-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-33830768-9
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-10-05 16:13:23','Actividad Generica 1','000001',NULL),(2,NULL,'2022-10-05 16:13:23','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'Fernandez2022',NULL,1,40722,'2023-03-02'),(2,NULL,'Fernandez2022',NULL,4,40722,'2023-03-02'),(3,'CIDI','Fernandez2021',NULL,41,40722,'2023-03-02'),(4,NULL,'Argjuncos2023',NULL,1,40721,'2023-03-22'),(5,NULL,'Argjuncos2023',NULL,1,40721,'2023-03-23'),(6,NULL,'Agcarnes2023',NULL,1,40723,'2023-03-23'),(7,NULL,'Canzio2022',NULL,1,40725,'2023-03-23'),(8,NULL,'notarial',NULL,39,40725,'2023-03-23'),(9,'AGEC','notarial08',NULL,40,40725,'2023-03-23'),(10,'FAECYS','notarial08',NULL,40,40725,'2023-03-23'),(11,'OSECAC','27335344923',NULL,40,40725,'2023-03-23'),(12,NULL,'Victoria2023',NULL,1,40719,'2023-04-03'),(13,NULL,'Canzio2022',NULL,1,40725,'2023-04-06'),(14,NULL,'notarial',NULL,39,40725,'2023-04-06'),(15,'AGEC','notarial08',NULL,40,40725,'2023-04-06'),(16,'FAECYS','notarial08',NULL,40,40725,'2023-04-06'),(17,'OSECAC','27335344923',NULL,40,40725,'2023-04-06'),(18,NULL,'Fernandez2022',NULL,1,40722,'2023-04-06'),(19,NULL,'Fernandez2022',NULL,4,40722,'2023-04-06'),(20,'CIDI','Fernandez2021',NULL,41,40722,'2023-04-06'),(21,NULL,'Fernandez2022',NULL,1,40722,'2023-04-06'),(22,NULL,'Fernandez2022',NULL,4,40722,'2023-04-06'),(23,'CIDI','Fernandez2021',NULL,41,40722,'2023-04-06'),(24,NULL,'Agcarnes2023',NULL,1,40723,'2023-07-13'),(25,NULL,'Agcarnes2023',NULL,1,40723,'2023-09-30'),(26,NULL,'Agcarnes2023',NULL,1,40723,'2025-07-22'),(27,NULL,'Jcscentral2023',NULL,1,40724,'2025-07-22'),(28,NULL,'Argjuncos2023',NULL,1,40721,'2025-07-22'),(29,NULL,'Victoria2023',NULL,1,40719,'2025-07-22'),(30,NULL,'Argjuncos2023',NULL,1,40721,'2025-10-07'),(31,NULL,'Marymar2022',NULL,1,40759,'2025-10-07'),(32,NULL,'Canzio2022',NULL,1,40725,'2025-11-10'),(33,NULL,'notarial',NULL,39,40725,'2025-11-10'),(34,'AGEC','notarial08',NULL,40,40725,'2025-11-10'),(35,'FAECYS','notarial08',NULL,40,40725,'2025-11-10'),(36,'OSECAC','27335344923',NULL,40,40725,'2025-11-10');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'vfernandez@guzmanyasociados.com.ar','3518015217',NULL,1,40719,'2023-03-01'),(2,'MVICTORIAF@OUTLOOK.COM','3518015217',NULL,1,40719,'2023-03-01'),(3,'sanchezjcs@hotmail.com','3516 19-8837','',1,40723,'2023-03-22'),(4,'sanchezjcs@hotmail.com','3516 19-8837','',1,40723,'2023-03-23'),(5,'MVICTORIAF@OUTLOOK.COM','3518015217',NULL,1,40719,'2023-04-03'),(6,'sanchezjcs@hotmail.com','3516 19-8837','',1,40723,'2023-07-13'),(7,'sanchezjcs@hotmail.com','3516 19-8837','',1,40723,'2023-09-30'),(8,'sanchezjcs@hotmail.com','3516 19-8837','',1,40723,'2025-07-22'),(9,'MVICTORIAF@OUTLOOK.COM','3518015217','',1,40719,'2025-07-22'),(10,'diegoramon44@hotmail.com','3516 812875','',1,42095,'2025-07-22'),(11,'diegoramon44@hotmail.com','3516 812875','',1,42095,'2025-09-23');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=26643 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7922,40723,6062,2,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',6211.05,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(2,7922,40723,6062,2,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',11969.99,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(3,7922,40723,6062,2,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',7151.03,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(4,7922,40723,6062,2,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',13574.98,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(5,7922,40723,6062,2,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',25000.05,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(6,7922,40723,6062,2,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',63688.73,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(7,7922,40723,6062,2,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',6269.98,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(8,7922,40723,6062,2,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',56054.97,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(9,7922,40723,6062,2,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',14830.05,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(10,7922,40723,6062,2,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',8720.03,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(11,7922,40723,6062,2,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',12240.03,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(12,7922,40723,6062,2,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',4471.04,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(13,7922,40723,6062,2,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',70857.02,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(14,7922,40723,6062,2,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',4023.99,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(15,7922,40723,6062,2,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',20700.02,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(16,7922,40723,6062,2,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',79229.03,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(17,7922,40723,6062,2,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',5769.99,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(18,7922,40723,6062,2,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',15079.99,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(19,7922,40723,6062,2,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',19999.97,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(20,7922,40723,6062,2,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',29349.96,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(21,7922,40723,6062,2,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',15677.00,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL);
INSERT INTO `balance_libro` VALUES (22,7922,40723,6062,2,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',12015.98,NULL,NULL,1,'2023-03-18 18:16:04','2023-03-18 18:16:04',NULL),(23,7922,40723,6062,2,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',0.00,NULL,NULL,1,'2023-03-18 18:16:12','2023-03-18 18:16:12',NULL),(24,7922,40723,6062,2,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',10500.03,NULL,NULL,1,'2023-03-18 18:16:12','2023-03-18 18:16:12',NULL),(25,7922,40723,6062,2,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1700.02,NULL,NULL,1,'2023-03-18 18:16:12','2023-03-18 18:16:12',NULL),(26,7922,40723,6062,2,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',10550.01,NULL,NULL,1,'2023-03-18 18:16:12','2023-03-18 18:16:12',NULL),(27,7922,40723,6062,2,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',4783.01,NULL,NULL,1,'2023-03-18 18:16:12','2023-03-18 18:16:12',NULL),(28,7922,40723,6062,2,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',10602.95,NULL,NULL,1,'2023-03-18 18:16:12','2023-03-18 18:16:12',NULL),(29,7922,40723,6062,2,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',10856.00,NULL,NULL,1,'2023-03-18 18:16:12','2023-03-18 18:16:12',NULL),(30,7922,40723,6062,2,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',3041.02,NULL,NULL,1,'2023-03-18 18:16:12','2023-03-18 18:16:12',NULL),(31,7922,40723,6062,2,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1839.98,NULL,NULL,1,'2023-03-18 18:16:12','2023-03-18 18:16:12',NULL),(32,7922,40723,6062,2,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',330143.69,NULL,NULL,1,'2023-03-18 18:21:54','2023-03-23 12:31:07','2023-03-23 12:31:07'),(33,7922,40723,6062,2,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',194179.97,NULL,NULL,1,'2023-03-18 18:21:54','2023-03-18 18:21:54',NULL),(34,7922,40723,6062,2,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',6211.05,NULL,NULL,1,'2023-03-18 18:21:54','2023-03-18 18:21:54',NULL),(35,7922,40723,6062,2,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',11969.99,NULL,NULL,1,'2023-03-18 18:21:54','2023-03-18 18:21:54',NULL),(36,7922,40723,6062,2,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',204517.82,NULL,NULL,1,'2023-03-18 18:21:54','2023-03-18 18:21:54',NULL),(37,7922,40723,6062,2,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',20726.01,NULL,NULL,1,'2023-03-18 18:21:54','2023-03-18 18:21:54',NULL),(38,7922,40723,6062,2,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',25000.05,NULL,NULL,1,'2023-03-18 18:21:54','2023-03-18 18:21:54',NULL),(39,7922,40723,6062,2,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',63688.73,NULL,NULL,1,'2023-03-18 18:21:54','2023-03-18 18:21:54',NULL),(40,7922,40723,6062,2,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',177260.11,NULL,NULL,1,'2023-03-18 18:21:55','2023-03-18 18:21:55',NULL),(41,7922,40723,6062,2,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',6269.98,NULL,NULL,1,'2023-03-18 18:21:55','2023-03-18 18:21:55',NULL),(42,7922,40723,6062,2,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',91845.07,NULL,NULL,1,'2023-03-18 18:21:55','2023-03-18 18:21:55',NULL);
INSERT INTO `balance_libro` VALUES (43,7922,40723,6062,2,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1330067.66,NULL,NULL,1,'2023-03-18 18:21:55','2023-03-18 18:21:55',NULL),(44,7922,40723,6062,2,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',74881.01,NULL,NULL,1,'2023-03-18 18:21:55','2023-03-18 18:21:55',NULL),(45,7922,40723,6062,2,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',105699.04,NULL,NULL,1,'2023-03-18 18:21:55','2023-03-18 18:21:55',NULL),(46,7922,40723,6062,2,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',227906.88,NULL,NULL,1,'2023-03-18 18:21:55','2023-03-18 18:21:55',NULL),(47,7922,40723,6062,2,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',64429.92,NULL,NULL,1,'2023-03-18 18:21:55','2023-03-18 18:21:55',NULL),(48,7922,40723,6062,2,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',27692.98,NULL,NULL,1,'2023-03-18 18:21:55','2023-03-18 18:21:55',NULL),(49,7922,40723,6062,2,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',366582.70,NULL,NULL,1,'2023-03-18 18:21:55','2023-03-18 18:21:55',NULL),(50,7922,40723,6062,2,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',0.02,NULL,NULL,1,'2023-03-18 18:48:40','2023-03-18 18:48:40',NULL),(51,7922,40723,6062,2,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',982907.11,NULL,NULL,1,'2023-03-18 18:48:40','2023-03-18 18:48:40',NULL),(52,7922,40723,6062,2,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',0.01,NULL,NULL,1,'2023-03-18 18:48:40','2023-03-18 18:48:40',NULL),(53,7922,40723,6062,2,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',893707.51,NULL,NULL,1,'2023-03-18 18:48:40','2023-03-18 18:48:40',NULL),(54,7922,40723,6062,2,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',278420.02,NULL,NULL,1,'2023-03-18 18:48:40','2023-03-18 18:48:40',NULL),(55,7922,40723,6062,2,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',606467.45,NULL,NULL,1,'2023-03-18 18:48:40','2023-03-18 18:48:40',NULL),(56,7922,40723,6062,2,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',153597.00,NULL,NULL,1,'2023-03-18 18:48:40','2023-03-18 18:48:40',NULL),(57,7922,40723,6062,2,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',10500.00,NULL,NULL,1,'2023-03-18 18:48:41','2023-03-18 18:48:41',NULL),(58,7922,40723,6062,2,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',679428.15,NULL,NULL,1,'2023-03-18 18:48:41','2023-03-18 18:48:41',NULL),(59,7922,40723,6062,2,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1700.00,NULL,NULL,1,'2023-03-18 18:48:41','2023-03-18 18:48:41',NULL),(60,7922,40723,6062,2,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',485633.57,NULL,NULL,1,'2023-03-18 18:48:41','2023-03-18 18:48:41',NULL),(61,7922,40723,6062,2,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1641027.17,NULL,NULL,1,'2023-03-18 18:48:41','2023-03-18 18:48:41',NULL),(62,7922,40723,6062,2,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',598907.09,NULL,NULL,1,'2023-03-18 18:48:41','2023-03-18 18:48:41',NULL),(63,7922,40723,6062,2,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',14917.94,NULL,NULL,1,'2023-03-18 18:48:41','2023-03-18 18:48:41',NULL);
INSERT INTO `balance_libro` VALUES (64,7922,40723,6062,2,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',56580.00,NULL,NULL,1,'2023-03-18 18:48:41','2023-03-18 18:48:41',NULL),(65,7922,40723,6062,2,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',23294.06,NULL,NULL,1,'2023-03-18 18:48:41','2023-03-18 18:48:41',NULL),(66,7922,40723,6062,2,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',589216.88,NULL,NULL,1,'2023-03-18 18:48:41','2023-03-18 18:48:41',NULL),(67,7922,40723,6062,2,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1840.00,NULL,NULL,1,'2023-03-18 18:48:41','2023-03-18 18:48:41',NULL),(68,7922,40723,6062,2,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',410873.03,NULL,NULL,1,'2023-03-18 18:48:41','2023-03-18 18:48:41',NULL),(1329,7922,40724,7577,1,1329,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-02-28',NULL,4803043.57,NULL,NULL,1,'2023-03-21 18:39:07','2023-03-21 18:39:07',NULL),(1732,7922,40721,3053,2,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3500.00,NULL,NULL,1,'2023-03-22 10:35:43','2023-03-22 10:35:43',NULL),(1733,7922,40721,3053,2,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2900.00,NULL,NULL,1,'2023-03-22 10:35:43','2023-03-22 10:35:43',NULL),(1734,7922,40721,3053,2,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1400.00,NULL,NULL,1,'2023-03-22 10:35:43','2023-03-22 10:35:43',NULL),(1735,7922,40721,3053,2,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',350.00,NULL,NULL,1,'2023-03-22 10:35:43','2023-03-22 10:35:43',NULL),(1736,7922,40721,3053,2,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',17000.00,NULL,NULL,1,'2023-03-22 10:35:43','2023-03-22 10:35:43',NULL),(1737,7922,40721,3053,2,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1750.00,NULL,NULL,1,'2023-03-22 10:35:43','2023-03-22 10:35:43',NULL),(1738,7922,40721,3053,2,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2900.00,NULL,NULL,1,'2023-03-22 10:35:43','2023-03-22 10:35:43',NULL),(1739,7922,40721,3053,2,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2520.00,NULL,NULL,1,'2023-03-22 10:35:43','2023-03-22 10:35:43',NULL),(1740,7922,40721,3053,2,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',50000.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1741,7922,40721,3053,2,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3600.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1742,7922,40721,3053,2,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3500.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1743,7922,40721,3053,2,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3700.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1744,7922,40721,3053,2,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1600.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1745,7922,40721,3053,2,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3900.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1746,7922,40721,3053,2,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',450.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL);
INSERT INTO `balance_libro` VALUES (1747,7922,40721,3053,2,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',500.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1748,7922,40721,3053,2,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',800.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1749,7922,40721,3053,2,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',300.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1750,7922,40721,3053,2,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1000.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1751,7922,40721,3053,2,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1750.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1752,7922,40721,3053,2,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',11500.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1753,7922,40721,3053,2,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1000.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1754,7922,40721,3053,2,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1500.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1755,7922,40721,3053,2,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',4500.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1756,7922,40721,3053,2,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',800.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1757,7922,40721,3053,2,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',600.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1758,7922,40721,3053,2,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',200.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1759,7922,40721,3053,2,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',4900.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1760,7922,40721,3053,2,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',45000.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1761,7922,40721,3053,2,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1200.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1762,7922,40721,3053,2,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1200.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1763,7922,40721,3053,2,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',9000.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1764,7922,40721,3053,2,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3500.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1765,7922,40721,3053,2,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',0.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1766,7922,40721,3053,2,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',0.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1767,7922,40721,3053,2,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',45500.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL);
INSERT INTO `balance_libro` VALUES (1768,7922,40721,3053,2,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',17450.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1769,7922,40721,3053,2,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',0.00,NULL,NULL,1,'2023-03-22 10:35:44','2023-03-22 10:35:44',NULL),(1770,7922,40721,3053,2,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1000.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1771,7922,40721,3053,2,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',2000.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1772,7922,40721,3053,2,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1100.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1773,7922,40721,3053,2,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3200.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1774,7922,40721,3053,2,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1000.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1775,7922,40721,3053,2,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3600.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1776,7922,40721,3053,2,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1500.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1777,7922,40721,3053,2,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3300.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1778,7922,40721,3053,2,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',24000.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1779,7922,40721,3053,2,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3900.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1780,7922,40721,3053,2,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1000.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1781,7922,40721,3053,2,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1100.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1782,7922,40721,3053,2,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',2400.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1783,7922,40721,3053,2,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',200.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1784,7922,40721,3053,2,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3920.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1785,7922,40721,3053,2,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1550.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1786,7922,40721,3053,2,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3000.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1787,7922,40721,3053,2,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3800.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1788,7922,40721,3053,2,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',600.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL);
INSERT INTO `balance_libro` VALUES (1789,7922,40721,3053,2,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',2860.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1790,7922,40721,3053,2,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',2300.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1791,7922,40721,3053,2,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',590.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1792,7922,40721,3053,2,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',15000.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1793,7922,40721,3053,2,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',270.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1794,7922,40721,3053,2,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',7300.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1795,7922,40721,3053,2,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',200.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1796,7922,40721,3053,2,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',16000.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1797,7922,40721,3053,2,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1000.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1798,7922,40721,3053,2,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1000.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1799,7922,40721,3053,2,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',17500.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1800,7922,40721,3053,2,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',4200.00,NULL,NULL,1,'2023-03-22 10:35:45','2023-03-22 10:35:45',NULL),(1801,7922,40721,3053,2,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1000.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1802,7922,40721,3053,2,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',2200.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1803,7922,40721,3053,2,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',300.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1804,7922,40721,3053,2,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1200.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1805,7922,40721,3053,2,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1360.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1806,7922,40721,3053,2,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',790.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1807,7922,40721,3053,2,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',2500.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1808,7922,40721,3053,2,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',14500.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1809,7922,40721,3053,2,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',2000.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL);
INSERT INTO `balance_libro` VALUES (1810,7922,40721,3053,2,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',690.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1811,7922,40721,3053,2,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',5500.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1812,7922,40721,3053,2,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',650.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1813,7922,40721,3053,2,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3700.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1814,7922,40721,3053,2,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',16900.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1815,7922,40721,3053,2,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1500.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1816,7922,40721,3053,2,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',3600.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1817,7922,40721,3053,2,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',10900.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1818,7922,40721,3053,2,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',300.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1819,7922,40721,3053,2,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',900.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1820,7922,40721,3053,2,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',550.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1821,7922,40721,3053,2,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',4900.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1822,7922,40721,3053,2,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',900.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1823,7922,40721,3053,2,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1000.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1824,7922,40721,3053,2,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1500.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1825,7922,40721,3053,2,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',2500.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1826,7922,40721,3053,2,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',4500.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1827,7922,40721,3053,2,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',4350.00,NULL,NULL,1,'2023-03-22 10:35:46','2023-03-22 10:35:46',NULL),(1828,7922,40721,3053,2,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1650.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1829,7922,40721,3053,2,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1500.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1830,7922,40721,3053,2,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',3500.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL);
INSERT INTO `balance_libro` VALUES (1831,7922,40721,3053,2,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',3400.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1832,7922,40721,3053,2,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1400.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1833,7922,40721,3053,2,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',250.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1834,7922,40721,3053,2,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',2400.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1835,7922,40721,3053,2,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',950.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1836,7922,40721,3053,2,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',900.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1837,7922,40721,3053,2,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',330.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1838,7922,40721,3053,2,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',300.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1839,7922,40721,3053,2,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1000.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1840,7922,40721,3053,2,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',2120.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1841,7922,40721,3053,2,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',500.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1842,7922,40721,3053,2,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',3000.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1843,7922,40721,3053,2,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',12800.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1844,7922,40721,3053,2,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1200.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1845,7922,40721,3053,2,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',2800.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1846,7922,40721,3053,2,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1650.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1847,7922,40721,3053,2,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1060.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1848,7922,40721,3053,2,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',300.00,NULL,NULL,1,'2023-03-22 10:35:47','2023-03-22 10:35:47',NULL),(1849,7922,40721,3053,2,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',11000.01,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1850,7922,40721,3053,2,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',0.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1851,7922,40721,3053,2,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1800.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL);
INSERT INTO `balance_libro` VALUES (1852,7922,40721,3053,2,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',3500.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1853,7922,40721,3053,2,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',29700.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1854,7922,40721,3053,2,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',970.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1855,7922,40721,3053,2,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',66325.50,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1856,7922,40721,3053,2,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1000.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1857,7922,40721,3053,2,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1000.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1858,7922,40721,3053,2,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',21500.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1859,7922,40721,3053,2,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1900.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1860,7922,40721,3053,2,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',920.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1861,7922,40721,3053,2,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',190.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1862,7922,40721,3053,2,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',22000.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1863,7922,40721,3053,2,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1200.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1864,7922,40721,3053,2,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1600.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1865,7922,40721,3053,2,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1440.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1866,7922,40721,3053,2,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',22543.50,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1867,7922,40721,3053,2,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',3075.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1868,7922,40721,3053,2,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',2400.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1869,7922,40721,3053,2,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',2420.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1870,7922,40721,3053,2,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',21700.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1871,7922,40721,3053,2,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1500.00,NULL,NULL,1,'2023-03-22 10:35:48','2023-03-22 10:35:48',NULL),(1872,7922,40721,3053,2,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',50000.00,NULL,NULL,1,'2023-03-22 10:35:49','2023-03-22 10:35:49',NULL);
INSERT INTO `balance_libro` VALUES (1873,7922,40721,3053,2,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',3700.00,NULL,NULL,1,'2023-03-22 10:35:49','2023-03-22 10:35:49',NULL),(1874,7922,40721,3053,2,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',3290.00,NULL,NULL,1,'2023-03-22 10:35:49','2023-03-22 10:35:49',NULL),(1875,7922,40721,3053,2,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',5600.00,NULL,NULL,1,'2023-03-22 10:35:49','2023-03-22 10:35:49',NULL),(1876,7922,40721,3053,2,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',2500.00,NULL,NULL,1,'2023-03-22 10:35:49','2023-03-22 10:35:49',NULL),(1877,7922,40721,3053,2,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',2990.00,NULL,NULL,1,'2023-03-22 10:35:49','2023-03-22 10:35:49',NULL),(1878,7922,40721,3053,2,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',500.00,NULL,NULL,1,'2023-03-22 10:35:49','2023-03-22 10:35:49',NULL),(1879,7922,40721,3053,2,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',17763.60,NULL,NULL,1,'2023-03-22 10:35:49','2023-03-22 10:35:49',NULL),(1880,7922,40721,3053,2,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',15000.00,NULL,NULL,1,'2023-03-22 10:35:49','2023-03-22 10:35:49',NULL),(1881,7922,40721,3053,2,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',520.00,NULL,NULL,1,'2023-03-22 10:35:49','2023-03-22 10:35:49',NULL),(1882,7922,40721,3053,2,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1420.00,NULL,NULL,1,'2023-03-22 10:35:49','2023-03-22 10:35:49',NULL),(1883,7922,40721,3053,2,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',520.00,NULL,NULL,1,'2023-03-22 10:35:49','2023-03-22 10:35:49',NULL),(1884,7922,40721,3053,2,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',400.00,NULL,NULL,1,'2023-03-22 10:35:49','2023-03-22 10:35:49',NULL),(1885,7922,40721,3053,2,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',2920.00,NULL,NULL,1,'2023-03-22 10:35:49','2023-03-22 10:35:49',NULL),(1886,7922,40721,3053,2,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',2100.00,NULL,NULL,1,'2023-03-22 10:35:49','2023-03-22 10:35:49',NULL),(1887,7922,40721,3053,2,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',200.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1888,7922,40721,3053,2,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1640.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1889,7922,40721,3053,2,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',50000.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1890,7922,40721,3053,2,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',65000.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1891,7922,40721,3053,2,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1800.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1892,7922,40721,3053,2,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',70000.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1893,7922,40721,3053,2,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',85000.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL);
INSERT INTO `balance_libro` VALUES (1894,7922,40721,3053,2,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',30000.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1895,7922,40721,3053,2,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',37400.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1896,7922,40721,3053,2,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',8250.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1897,7922,40721,3053,2,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',850.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1898,7922,40721,3053,2,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',5500.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1899,7922,40721,3053,2,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',4900.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1900,7922,40721,3053,2,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',300.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1901,7922,40721,3053,2,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',250.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1902,7922,40721,3053,2,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',2400.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1903,7922,40721,3053,2,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',8500.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1904,7922,40721,3053,2,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',23650.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1905,7922,40721,3053,2,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',18250.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1906,7922,40721,3053,2,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',17950.00,NULL,NULL,1,'2023-03-22 10:35:50','2023-03-22 10:35:50',NULL),(1907,7922,40721,3053,2,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1900.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1908,7922,40721,3053,2,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1500.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1909,7922,40721,3053,2,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',100.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1910,7922,40721,3053,2,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',600.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1911,7922,40721,3053,2,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',600.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1912,7922,40721,3053,2,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',18150.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1913,7922,40721,3053,2,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',19000.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1914,7922,40721,3053,2,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',2450.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL);
INSERT INTO `balance_libro` VALUES (1915,7922,40721,3053,2,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',3000.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1916,7922,40721,3053,2,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1650.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1917,7922,40721,3053,2,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',2050.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1918,7922,40721,3053,2,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1760.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1919,7922,40721,3053,2,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',14825.60,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1920,7922,40721,3053,2,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',500.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1921,7922,40721,3053,2,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',500.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1922,7922,40721,3053,2,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1000.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1923,7922,40721,3053,2,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',6550.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1924,7922,40721,3053,2,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',750.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1925,7922,40721,3053,2,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',2800.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1926,7922,40721,3053,2,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',4800.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1927,7922,40721,3053,2,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',5300.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1928,7922,40721,3053,2,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',5000.00,NULL,NULL,1,'2023-03-22 10:35:51','2023-03-22 10:35:51',NULL),(1929,7922,40721,3053,2,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',4500.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1930,7922,40721,3053,2,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',75000.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1931,7922,40721,3053,2,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',75000.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1932,7922,40721,3053,2,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',80000.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1933,7922,40721,3053,2,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',70000.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1934,7922,40721,3053,2,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',75000.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1935,7922,40721,3053,2,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',7000.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL);
INSERT INTO `balance_libro` VALUES (1936,7922,40721,3053,2,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',520.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1937,7922,40721,3053,2,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1000.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1938,7922,40721,3053,2,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',300.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1939,7922,40721,3053,2,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1200.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1940,7922,40721,3053,2,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',520.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1941,7922,40721,3053,2,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',7250.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1942,7922,40721,3053,2,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',300.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1943,7922,40721,3053,2,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',6200.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1944,7922,40721,3053,2,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1850.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1945,7922,40721,3053,2,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1580.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1946,7922,40721,3053,2,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',860.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1947,7922,40721,3053,2,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',5120.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1948,7922,40721,3053,2,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1580.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1949,7922,40721,3053,2,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',5520.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1950,7922,40721,3053,2,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',2280.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1951,7922,40721,3053,2,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',3000.00,NULL,NULL,1,'2023-03-22 10:35:52','2023-03-22 10:35:52',NULL),(1952,7922,40721,3053,2,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',5995.00,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL),(1953,7922,40721,3053,2,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',7400.00,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL),(1954,7922,40721,3053,2,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',600.00,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL),(1955,7922,40721,3053,2,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1100.00,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL),(1956,7922,40721,3053,2,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',2100.00,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL);
INSERT INTO `balance_libro` VALUES (1957,7922,40721,3053,2,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1900.00,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL),(1958,7922,40721,3053,2,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',200.00,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL),(1959,7922,40721,3053,2,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',160.00,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL),(1960,7922,40721,3053,2,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',100.00,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL),(1961,7922,40721,3053,2,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',2000.00,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL),(1962,7922,40721,3053,2,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',9187.50,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL),(1963,7922,40721,3053,2,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',11000.00,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL),(1964,7922,40721,3053,2,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',21500.00,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL),(1965,7922,40721,3053,2,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1500.00,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL),(1966,7922,40721,3053,2,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',500.00,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL),(1967,7922,40721,3053,2,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',600.00,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL),(1968,7922,40721,3053,2,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1610.00,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL),(1969,7922,40721,3053,2,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1800.00,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL),(1970,7922,40721,3053,2,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1000.00,NULL,NULL,1,'2023-03-22 10:35:53','2023-03-22 10:35:53',NULL),(1971,7922,40721,3053,2,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',100.00,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL),(1972,7922,40721,3053,2,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1000.00,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL),(1973,7922,40721,3053,2,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',2900.00,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL),(1974,7922,40721,3053,2,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',139000.00,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL),(1975,7922,40721,3053,2,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',116000.00,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL),(1976,7922,40721,3053,2,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',95000.00,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL),(1977,7922,40721,3053,2,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',70000.00,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL);
INSERT INTO `balance_libro` VALUES (1978,7922,40721,3053,2,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',69000.00,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL),(1979,7922,40721,3053,2,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',5150.00,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL),(1980,7922,40721,3053,2,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1500.00,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL),(1981,7922,40721,3053,2,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',18150.00,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL),(1982,7922,40721,3053,2,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',300.00,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL),(1983,7922,40721,3053,2,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',66877.30,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL),(1984,7922,40721,3053,2,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',2800.00,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL),(1985,7922,40721,3053,2,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',1200.00,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL),(1986,7922,40721,3053,2,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',5000.00,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL),(1987,7922,40721,3053,2,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',2400.00,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL),(1988,7922,40721,3053,2,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',120.00,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL),(1989,7922,40721,3053,2,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',38950.00,NULL,NULL,1,'2023-03-22 10:35:54','2023-03-22 10:35:54',NULL),(1990,7922,40721,3053,2,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',1500.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(1991,7922,40721,3053,2,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',3790.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(1992,7922,40721,3053,2,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',3500.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(1993,7922,40721,3053,2,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',550.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(1994,7922,40721,3053,2,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',1500.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(1995,7922,40721,3053,2,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',7000.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(1996,7922,40721,3053,2,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',2000.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(1997,7922,40721,3053,2,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',910.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(1998,7922,40721,3053,2,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',250.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL);
INSERT INTO `balance_libro` VALUES (1999,7922,40721,3053,2,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',7400.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(2000,7922,40721,3053,2,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',2820.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(2001,7922,40721,3053,2,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',600.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(2002,7922,40721,3053,2,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',3800.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(2003,7922,40721,3053,2,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1450.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(2004,7922,40721,3053,2,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',10170.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(2005,7922,40721,3053,2,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',2200.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(2006,7922,40721,3053,2,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',2700.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(2007,7922,40721,3053,2,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',14700.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(2008,7922,40721,3053,2,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',6000.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(2009,7922,40721,3053,2,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',10150.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(2010,7922,40721,3053,2,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1160.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(2011,7922,40721,3053,2,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',23650.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(2012,7922,40721,3053,2,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',0.00,NULL,NULL,1,'2023-03-22 10:35:55','2023-03-22 10:35:55',NULL),(2013,7922,40721,3053,2,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',5000.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2014,7922,40721,3053,2,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1500.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2015,7922,40721,3053,2,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1000.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2016,7922,40721,3053,2,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1450.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2017,7922,40721,3053,2,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',850.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2018,7922,40721,3053,2,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',10000.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2019,7922,40721,3053,2,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1750.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL);
INSERT INTO `balance_libro` VALUES (2020,7922,40721,3053,2,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',2700.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2021,7922,40721,3053,2,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',200.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2022,7922,40721,3053,2,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',8420.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2023,7922,40721,3053,2,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1500.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2024,7922,40721,3053,2,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',850.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2025,7922,40721,3053,2,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',64000.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2026,7922,40721,3053,2,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',70000.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2027,7922,40721,3053,2,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',65000.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2028,7922,40721,3053,2,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',85000.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2029,7922,40721,3053,2,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',90000.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2030,7922,40721,3053,2,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',26000.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2031,7922,40721,3053,2,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1500.40,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2032,7922,40721,3053,2,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',200.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2033,7922,40721,3053,2,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',1640.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2034,7922,40721,3053,2,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',550.00,NULL,NULL,1,'2023-03-22 10:35:56','2023-03-22 10:35:56',NULL),(2035,7922,40721,3053,2,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',6067.00,NULL,NULL,1,'2023-03-22 10:35:57','2023-03-22 10:35:57',NULL),(2036,7922,40721,3053,2,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',2500.00,NULL,NULL,1,'2023-03-22 10:35:57','2023-03-22 10:35:57',NULL),(2037,7922,40721,3053,2,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',4500.00,NULL,NULL,1,'2023-03-22 10:35:57','2023-03-22 10:35:57',NULL),(2038,7922,40721,3053,2,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',23562.50,NULL,NULL,1,'2023-03-22 10:35:57','2023-03-22 10:35:57',NULL),(2039,7922,40721,3053,2,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',2000.00,NULL,NULL,1,'2023-03-22 10:35:57','2023-03-22 10:35:57',NULL),(2040,7922,40721,3053,2,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',1000.00,NULL,NULL,1,'2023-03-22 10:35:57','2023-03-22 10:35:57',NULL);
INSERT INTO `balance_libro` VALUES (2041,7922,40721,3053,2,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',6030.00,NULL,NULL,1,'2023-03-22 10:35:57','2023-03-22 10:35:57',NULL),(2042,7922,40721,3053,2,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',4000.00,NULL,NULL,1,'2023-03-22 10:35:57','2023-03-22 10:35:57',NULL),(2043,7922,40721,3053,2,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',10637.00,NULL,NULL,1,'2023-03-22 10:35:57','2023-03-22 10:35:57',NULL),(2044,7922,40721,3053,2,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',5600.00,NULL,NULL,1,'2023-03-22 10:35:57','2023-03-22 10:35:57',NULL),(2045,7922,40721,3053,2,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',50000.00,NULL,NULL,1,'2023-03-22 10:35:57','2023-03-22 10:35:57',NULL),(2046,7922,40721,3053,2,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',69000.00,NULL,NULL,1,'2023-03-22 10:35:57','2023-03-22 10:35:57',NULL),(2047,7922,40721,3053,2,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',75000.00,NULL,NULL,1,'2023-03-22 10:35:57','2023-03-22 10:35:57',NULL),(2048,7922,40721,3053,2,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',79000.00,NULL,NULL,1,'2023-03-22 10:35:57','2023-03-22 10:35:57',NULL),(2049,7922,40721,3053,2,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',80500.00,NULL,NULL,1,'2023-03-22 10:35:57','2023-03-22 10:35:57',NULL),(2050,7922,40721,3053,2,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',99000.00,NULL,NULL,1,'2023-03-22 10:35:57','2023-03-22 10:35:57',NULL),(2051,7922,40721,3053,2,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',99000.00,NULL,NULL,1,'2023-03-22 10:35:57','2023-03-22 10:35:57',NULL),(2052,7922,40721,3053,2,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',0.00,NULL,NULL,1,'2023-03-22 10:35:57','2023-03-22 10:35:57',NULL),(2053,7922,40721,3053,2,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',0.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2054,7922,40721,3053,2,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',5600.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2055,7922,40721,3053,2,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1600.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2056,7922,40721,3053,2,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1800.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2057,7922,40721,3053,2,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1000.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2058,7922,40721,3053,2,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1950.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2059,7922,40721,3053,2,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',7700.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2060,7922,40721,3053,2,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',2500.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2061,7922,40721,3053,2,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',2500.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL);
INSERT INTO `balance_libro` VALUES (2062,7922,40721,3053,2,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',4700.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2063,7922,40721,3053,2,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1100.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2064,7922,40721,3053,2,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',2400.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2065,7922,40721,3053,2,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1000.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2066,7922,40721,3053,2,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',670.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2067,7922,40721,3053,2,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1000.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2068,7922,40721,3053,2,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',100.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2069,7922,40721,3053,2,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',600.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2070,7922,40721,3053,2,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',27830.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2071,7922,40721,3053,2,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',28250.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2072,7922,40721,3053,2,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1500.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2073,7922,40721,3053,2,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1000.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2074,7922,40721,3053,2,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',200.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2075,7922,40721,3053,2,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1400.00,NULL,NULL,1,'2023-03-22 10:35:58','2023-03-22 10:35:58',NULL),(2076,7922,40721,3053,2,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',600.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2077,7922,40721,3053,2,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1500.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2078,7922,40721,3053,2,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',2600.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2079,7922,40721,3053,2,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',2500.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2080,7922,40721,3053,2,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1500.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2081,7922,40721,3053,2,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',350.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2082,7922,40721,3053,2,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1250.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL);
INSERT INTO `balance_libro` VALUES (2083,7922,40721,3053,2,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',0.20,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2084,7922,40721,3053,2,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',0.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2085,7922,40721,3053,2,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',2500.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2086,7922,40721,3053,2,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',5000.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2087,7922,40721,3053,2,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1850.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2088,7922,40721,3053,2,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',3000.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2089,7922,40721,3053,2,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',5000.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2090,7922,40721,3053,2,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1000.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2091,7922,40721,3053,2,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',5600.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2092,7922,40721,3053,2,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',5500.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2093,7922,40721,3053,2,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',0.20,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2094,7922,40721,3053,2,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1420.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2095,7922,40721,3053,2,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2500.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2096,7922,40721,3053,2,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',11100.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2097,7922,40721,3053,2,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',300.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2098,7922,40721,3053,2,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3700.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2099,7922,40721,3053,2,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',15950.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2100,7922,40721,3053,2,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',0.20,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2101,7922,40721,3053,2,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',6700.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2102,7922,40721,3053,2,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',200.00,NULL,NULL,1,'2023-03-22 10:35:59','2023-03-22 10:35:59',NULL),(2103,7922,40721,3053,2,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',0.20,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL);
INSERT INTO `balance_libro` VALUES (2104,7922,40721,3053,2,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1250.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2105,7922,40721,3053,2,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',800.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2106,7922,40721,3053,2,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',350.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2107,7922,40721,3053,2,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1200.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2108,7922,40721,3053,2,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2500.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2109,7922,40721,3053,2,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',7600.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2110,7922,40721,3053,2,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2200.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2111,7922,40721,3053,2,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',550.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2112,7922,40721,3053,2,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2200.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2113,7922,40721,3053,2,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',590.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2114,7922,40721,3053,2,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',850.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2115,7922,40721,3053,2,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2950.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2116,7922,40721,3053,2,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4300.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2117,7922,40721,3053,2,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3080.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2118,7922,40721,3053,2,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1100.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2119,7922,40721,3053,2,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2500.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2120,7922,40721,3053,2,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1740.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2121,7922,40721,3053,2,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1800.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2122,7922,40721,3053,2,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',250.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2123,7922,40721,3053,2,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',103455.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL),(2124,7922,40721,3053,2,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1750.00,NULL,NULL,1,'2023-03-22 10:36:00','2023-03-22 10:36:00',NULL);
INSERT INTO `balance_libro` VALUES (2125,7922,40721,3053,2,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',10810.49,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2126,7922,40721,3053,2,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2530.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2127,7922,40721,3053,2,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1550.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2128,7922,40721,3053,2,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',19500.50,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2129,7922,40721,3053,2,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',300.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2130,7922,40721,3053,2,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',0.20,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2131,7922,40721,3053,2,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3930.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2132,7922,40721,3053,2,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',180.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2133,7922,40721,3053,2,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7500.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2134,7922,40721,3053,2,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1450.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2135,7922,40721,3053,2,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4540.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2136,7922,40721,3053,2,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5800.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2137,7922,40721,3053,2,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30000.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2138,7922,40721,3053,2,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30000.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2139,7922,40721,3053,2,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30000.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2140,7922,40721,3053,2,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30000.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2141,7922,40721,3053,2,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30000.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2142,7922,40721,3053,2,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30000.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2143,7922,40721,3053,2,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30000.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2144,7922,40721,3053,2,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30000.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2145,7922,40721,3053,2,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30000.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL);
INSERT INTO `balance_libro` VALUES (2146,7922,40721,3053,2,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30000.00,NULL,NULL,1,'2023-03-22 10:36:01','2023-03-22 10:36:01',NULL),(2147,7922,40721,3053,2,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30000.00,NULL,NULL,1,'2023-03-22 10:36:02','2023-03-22 10:36:02',NULL),(2148,7922,40721,3053,2,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30000.00,NULL,NULL,1,'2023-03-22 10:36:02','2023-03-22 10:36:02',NULL),(2149,7922,40721,3053,2,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30000.00,NULL,NULL,1,'2023-03-22 10:36:02','2023-03-22 10:36:02',NULL),(2150,7922,40721,3053,2,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30000.00,NULL,NULL,1,'2023-03-22 10:36:02','2023-03-22 10:36:02',NULL),(2151,7922,40721,3053,2,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30000.00,NULL,NULL,1,'2023-03-22 10:36:02','2023-03-22 10:36:02',NULL),(2152,7922,40721,3053,2,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',70800.97,NULL,NULL,1,'2023-03-22 10:36:02','2023-03-22 10:36:02',NULL),(2153,7922,40721,3053,2,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',576200.06,NULL,NULL,1,'2023-03-22 10:36:02','2023-03-22 10:36:02',NULL),(2154,7922,40721,3053,3,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',10499.00,NULL,NULL,1,'2023-03-22 10:36:57','2023-03-22 10:36:57',NULL),(2155,7922,40721,3053,3,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',11999.00,NULL,NULL,1,'2023-03-22 10:36:57','2023-03-22 10:36:57',NULL),(2156,7922,40721,3053,3,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',8400.00,NULL,NULL,1,'2023-03-22 10:36:57','2023-03-22 10:36:57',NULL),(2157,7922,40721,3053,3,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3407.47,NULL,NULL,1,'2023-03-22 10:36:57','2023-03-22 10:36:57',NULL),(2158,7922,40721,3053,3,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1816.19,NULL,NULL,1,'2023-03-22 10:36:57','2023-03-22 10:36:57',NULL),(2159,7922,40721,3053,3,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',3975.00,NULL,NULL,1,'2023-03-22 10:36:57','2023-03-22 10:36:57',NULL),(2160,7922,40721,3053,3,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',13886.49,NULL,NULL,1,'2023-03-22 10:36:57','2023-03-22 10:36:57',NULL),(2161,7922,40721,3053,3,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',6106.36,NULL,NULL,1,'2023-03-22 10:36:57','2023-03-22 10:36:57',NULL),(2162,7922,40721,3053,3,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1750.00,NULL,NULL,1,'2023-03-22 10:36:57','2023-03-22 10:36:57',NULL),(2163,7922,40721,3053,3,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1750.00,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2164,7922,40721,3053,3,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',39599.67,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2165,7922,40721,3053,3,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',69120.00,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2166,7922,40721,3053,3,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3244.00,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL);
INSERT INTO `balance_libro` VALUES (2167,7922,40721,3053,3,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',16150.00,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2168,7922,40721,3053,3,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1762142.72,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2169,7922,40721,3053,3,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',39760.60,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2170,7922,40721,3053,3,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',14900.00,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2171,7922,40721,3053,3,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',4209.80,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2172,7922,40721,3053,3,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',104569.92,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2173,7922,40721,3053,3,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',71050.00,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2174,7922,40721,3053,3,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',40609.62,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2175,7922,40721,3053,3,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',195000.00,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2176,7922,40721,3053,3,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',6450.00,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2177,7922,40721,3053,3,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',44613.03,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2178,7922,40721,3053,3,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',61438.84,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2179,7922,40721,3053,3,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',46964.08,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2180,7922,40721,3053,3,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8600.00,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2181,7922,40721,3053,3,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',86805.59,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2182,7922,40721,3053,3,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',59625.99,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2183,7922,40721,3053,3,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8600.00,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2184,7922,40721,3053,3,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',55683.62,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2185,7922,40721,3053,3,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',126138.97,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2186,7922,40721,3053,3,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',56773.21,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2187,7922,40721,3053,3,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',37534.20,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL);
INSERT INTO `balance_libro` VALUES (2188,7922,40721,3053,3,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',15432.34,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2189,7922,40721,3053,3,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',10522.38,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2190,7922,40721,3053,3,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',18225.00,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2191,7922,40721,3053,3,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1027.00,NULL,NULL,1,'2023-03-22 10:36:58','2023-03-22 10:36:58',NULL),(2192,7922,40721,3053,3,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',953.99,NULL,NULL,1,'2023-03-22 10:36:59','2023-03-22 10:36:59',NULL),(2193,7922,40721,3053,3,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1050.00,NULL,NULL,1,'2023-03-22 10:36:59','2023-03-22 10:36:59',NULL),(2194,7922,40721,3053,3,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',5200.00,NULL,NULL,1,'2023-03-22 10:36:59','2023-03-22 10:36:59',NULL),(2195,7922,40721,3053,3,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2775.00,NULL,NULL,1,'2023-03-22 10:36:59','2023-03-22 10:36:59',NULL),(2196,7922,40721,3053,3,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',60000.00,NULL,NULL,1,'2023-03-22 10:36:59','2023-03-22 10:36:59',NULL),(2197,7922,40721,3053,3,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',200.00,NULL,NULL,1,'2023-03-22 10:36:59','2023-03-22 10:36:59',NULL),(2198,7922,40721,3053,3,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1140.00,NULL,NULL,1,'2023-03-22 10:36:59','2023-03-22 10:36:59',NULL),(2199,7922,40721,3053,3,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',248965.19,NULL,NULL,1,'2023-03-22 10:36:59','2023-03-22 10:36:59',NULL),(2200,7922,40721,3053,3,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',758757.71,NULL,NULL,1,'2023-03-22 10:36:59','2023-03-22 10:36:59',NULL),(2201,7922,40721,3053,3,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',16200.00,NULL,NULL,1,'2023-03-22 10:36:59','2023-03-22 10:36:59',NULL),(2202,7922,40721,3053,3,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5200.00,NULL,NULL,1,'2023-03-22 10:36:59','2023-03-22 10:36:59',NULL),(2203,7922,40721,3053,3,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',0.00,NULL,NULL,1,'2023-03-22 10:36:59','2023-03-23 09:47:11','2023-03-23 09:47:11'),(2204,7922,40721,3053,3,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',11200.27,NULL,NULL,1,'2023-03-22 10:43:26','2023-03-23 09:50:57','2023-03-23 09:50:57'),(2205,7922,40721,3053,3,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',10500.52,NULL,NULL,1,'2023-03-22 10:44:26','2023-03-23 09:50:37','2023-03-23 09:50:37'),(2206,7922,40721,3053,3,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',11502.04,NULL,NULL,1,'2023-03-22 10:45:21','2023-03-23 09:50:20','2023-03-23 09:50:20'),(2207,7922,40721,3053,3,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',22200.03,NULL,NULL,1,'2023-03-22 10:47:58','2023-03-22 10:47:58',NULL),(2208,7922,40721,3053,3,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',18000.00,NULL,NULL,1,'2023-03-22 10:48:24','2023-03-22 10:48:24',NULL);
INSERT INTO `balance_libro` VALUES (2209,7922,40721,3053,3,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',8601.13,NULL,NULL,1,'2023-03-22 10:54:50','2023-03-23 09:51:20','2023-03-23 09:51:20'),(2210,7922,40721,3053,3,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',10496.60,NULL,NULL,1,'2023-03-22 10:59:17','2023-03-23 09:51:42','2023-03-23 09:51:42'),(2211,7922,40721,3053,3,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8200.01,NULL,NULL,1,'2023-03-22 11:01:46','2023-03-23 09:52:01','2023-03-23 09:52:01'),(2212,7922,40721,3053,3,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',2850.00,NULL,NULL,1,'2023-03-22 11:02:56','2023-03-22 11:02:56',NULL),(2213,7922,40721,3053,3,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',9000.81,NULL,NULL,1,'2023-03-22 11:04:50','2023-03-23 09:52:28','2023-03-23 09:52:28'),(2214,7922,40721,3053,3,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',11999.99,NULL,NULL,1,'2023-03-22 11:05:50','2023-03-23 09:48:22','2023-03-23 09:48:22'),(2215,7922,40721,3053,3,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',10499.99,NULL,NULL,1,'2023-03-22 11:07:48','2023-03-23 09:52:45','2023-03-23 09:52:45'),(2216,7922,40721,3053,3,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',8499.13,NULL,NULL,1,'2023-03-22 11:11:45','2023-03-23 09:48:03','2023-03-23 09:48:03'),(2217,7922,40721,3053,3,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',10802.98,NULL,NULL,1,'2023-03-22 11:13:47','2023-03-23 09:53:08','2023-03-23 09:53:08'),(2218,7922,40721,3053,3,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',10499.71,NULL,NULL,1,'2023-03-22 11:15:12','2023-03-23 09:56:08','2023-03-23 09:56:08'),(2219,7922,40721,3053,3,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',11101.19,NULL,NULL,1,'2023-03-22 11:16:37','2023-03-23 09:47:37','2023-03-23 09:47:37'),(2220,7922,40721,3054,3,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',78818.70,NULL,NULL,1,'2023-03-22 11:18:53','2023-03-22 11:18:53',NULL),(2221,7922,40723,6062,3,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',304178.89,NULL,NULL,1,'2023-03-22 16:28:18','2023-03-22 16:28:18',NULL),(2222,7922,40723,6062,3,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',293907.91,NULL,NULL,1,'2023-03-22 16:28:18','2023-03-22 16:28:18',NULL),(2223,7922,40723,6062,3,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',292327.75,NULL,NULL,1,'2023-03-22 16:28:18','2023-03-22 16:28:18',NULL),(2224,7922,40723,6062,3,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',319190.31,NULL,NULL,1,'2023-03-22 16:28:18','2023-03-22 16:28:18',NULL),(2225,7922,40723,6062,3,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',131812.46,NULL,NULL,1,'2023-03-22 16:28:18','2023-03-22 16:28:18',NULL),(2226,7922,40723,6062,3,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',108482.05,NULL,NULL,1,'2023-03-22 16:28:18','2023-03-22 16:28:18',NULL),(2227,7922,40723,6062,3,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',417159.60,NULL,NULL,1,'2023-03-22 16:28:18','2023-03-22 16:28:18',NULL),(2228,7922,40723,6062,3,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',406888.63,NULL,NULL,1,'2023-03-22 16:28:18','2023-03-22 16:28:18',NULL);
INSERT INTO `balance_libro` VALUES (2229,7922,40723,6062,3,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1557237.83,NULL,NULL,1,'2023-03-22 16:28:18','2023-03-22 16:28:18',NULL),(2230,7922,40723,6062,3,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1862996.85,NULL,NULL,1,'2023-03-22 16:28:18','2023-03-22 16:28:18',NULL),(2231,7922,40723,6062,3,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',157954.55,NULL,NULL,1,'2023-03-22 16:28:18','2023-03-22 16:28:18',NULL),(2232,7922,40723,6062,3,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',145444.19,NULL,NULL,1,'2023-03-22 16:28:18','2023-03-22 16:28:18',NULL),(2233,7922,40723,6062,3,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',598937.64,NULL,NULL,1,'2023-03-22 16:28:18','2023-03-22 16:28:18',NULL),(2234,7922,40723,6062,3,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',602486.90,NULL,NULL,1,'2023-03-22 16:28:18','2023-03-22 16:28:18',NULL),(2235,7922,40723,6062,3,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',586515.22,NULL,NULL,1,'2023-03-22 16:28:18','2023-03-22 16:28:18',NULL),(2236,7922,40723,6062,3,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',597163.00,NULL,NULL,1,'2023-03-22 16:28:18','2023-03-22 16:28:18',NULL),(2237,7922,40723,6062,3,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',440439.35,NULL,NULL,1,'2023-03-22 16:28:18','2023-03-22 16:28:18',NULL),(2238,7922,40723,6062,3,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',508199.25,NULL,NULL,1,'2023-03-22 16:28:18','2023-03-22 16:28:18',NULL),(2239,7922,40723,6062,3,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',172225.77,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2240,7922,40723,6062,3,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',0.00,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2241,7922,40723,6062,3,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',4209.80,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2242,7922,40723,6062,3,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',4209.80,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2243,7922,40723,6062,3,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',171225.48,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2244,7922,40723,6062,3,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1950318.37,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2245,7922,40723,6062,3,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',2134879.89,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2246,7922,40723,6062,3,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',89998.94,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2247,7922,40723,6062,3,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',488798.29,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2248,7922,40723,6062,3,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',67169.82,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2249,7922,40723,6062,3,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',238247.09,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL);
INSERT INTO `balance_libro` VALUES (2250,7922,40723,6062,3,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',89998.94,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2251,7922,40723,6062,3,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',122999.76,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2252,7922,40723,6062,3,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',477520.72,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2253,7922,40723,6062,3,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',514180.77,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2254,7922,40723,6062,3,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',459660.68,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2255,7922,40723,6062,3,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',487860.74,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2256,7922,40723,6062,3,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',14799.51,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2257,7922,40723,6062,3,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',427832.14,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2258,7922,40723,6062,3,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',50000.00,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2259,7922,40723,6062,3,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',541249.02,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2260,7922,40723,6062,3,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',101999.24,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2261,7922,40723,6062,3,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',129999.38,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2262,7922,40723,6062,3,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1953637.71,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2263,7922,40723,6062,3,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1950734.82,NULL,NULL,1,'2023-03-22 16:28:19','2023-03-22 16:28:19',NULL),(2264,7922,40723,6062,3,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',758003.92,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL),(2265,7922,40723,6062,3,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',670942.31,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL),(2266,7922,40723,6062,3,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',633089.43,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL),(2267,7922,40723,6062,3,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',756111.29,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL),(2268,7922,40723,6062,3,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',917122.97,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL),(2269,7922,40723,6062,3,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',4000000.00,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL),(2270,7922,40723,6062,3,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',301530.75,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL);
INSERT INTO `balance_libro` VALUES (2271,7922,40723,6062,3,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',68786.25,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL),(2272,7922,40723,6062,3,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',110001.65,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL),(2273,7922,40723,6062,3,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',947723.69,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL),(2274,7922,40723,6062,3,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',206358.75,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL),(2275,7922,40723,6062,3,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',361789.52,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL),(2276,7922,40723,6062,3,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',137502.06,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL),(2277,7922,40723,6062,3,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2491665.84,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL),(2278,7922,40723,6062,3,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2291045.56,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL),(2279,7922,40723,6062,3,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',307006.31,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL),(2280,7922,40723,6062,3,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',260361.54,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL),(2281,7922,40723,6062,3,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',0.00,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL),(2282,7922,40723,6062,3,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',0.00,NULL,NULL,1,'2023-03-22 16:28:20','2023-03-22 16:28:20',NULL),(2409,7922,40723,6061,2,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',28460.00,NULL,NULL,1,'2023-03-22 16:51:05','2023-03-22 16:51:05',NULL),(2410,7922,40723,6061,2,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',57562.00,NULL,NULL,1,'2023-03-22 16:51:05','2023-03-22 16:51:05',NULL),(2411,7922,40723,6061,2,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',50125.00,NULL,NULL,1,'2023-03-22 16:51:05','2023-03-22 16:51:05',NULL),(2412,7922,40723,6061,2,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',45509.02,NULL,NULL,1,'2023-03-22 16:51:05','2023-03-22 16:51:05',NULL),(2413,7922,40723,6061,2,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3500.00,NULL,NULL,1,'2023-03-22 16:51:05','2023-03-22 16:51:05',NULL),(2414,7922,40723,6061,2,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',9493.00,NULL,NULL,1,'2023-03-22 16:51:05','2023-03-22 16:51:05',NULL),(2415,7922,40723,6061,2,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',6463.00,NULL,NULL,1,'2023-03-22 16:51:05','2023-03-22 16:51:05',NULL),(2416,7922,40723,6061,2,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',27800.00,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2417,7922,40723,6061,2,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',22590.00,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL);
INSERT INTO `balance_libro` VALUES (2418,7922,40723,6061,2,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',23400.00,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2419,7922,40723,6061,2,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',19430.00,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2420,7922,40723,6061,2,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',18500.00,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2421,7922,40723,6061,2,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',33400.00,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2422,7922,40723,6061,2,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',21860.02,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2423,7922,40723,6061,2,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',27350.00,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2424,7922,40723,6061,2,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',19200.00,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2425,7922,40723,6061,2,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',32750.00,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2426,7922,40723,6061,2,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',34000.00,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2427,7922,40723,6061,2,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',32600.00,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2428,7922,40723,6061,2,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',28900.00,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2429,7922,40723,6061,2,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',24300.00,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2430,7922,40723,6061,2,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',17450.02,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2431,7922,40723,6061,2,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',24300.00,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2432,7922,40723,6061,2,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',8980.00,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2433,7922,40723,6061,2,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',30415.00,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2434,7922,40723,6061,2,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',6705.00,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2435,7922,40723,6061,2,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',25589003.86,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2436,7922,40723,6061,2,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4824589.06,NULL,NULL,1,'2023-03-22 16:51:06','2023-03-22 16:51:06',NULL),(2437,7922,40723,6061,3,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',290003.50,NULL,NULL,1,'2023-03-22 16:51:25','2023-09-30 09:39:18','2023-09-30 09:39:18');
INSERT INTO `balance_libro` VALUES (2438,7922,40723,6061,3,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',283904.00,NULL,NULL,1,'2023-03-22 16:51:25','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2439,7922,40723,6061,3,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',127974.80,NULL,NULL,1,'2023-03-22 16:51:25','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2440,7922,40723,6061,3,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',173822.23,NULL,NULL,1,'2023-03-22 16:51:25','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2441,7922,40723,6061,3,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',286554.52,NULL,NULL,1,'2023-03-22 16:51:26','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2442,7922,40723,6061,3,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',249774.53,NULL,NULL,1,'2023-03-22 16:51:26','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2443,7922,40723,6061,3,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',240991.26,NULL,NULL,1,'2023-03-22 16:51:26','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2444,7922,40723,6061,3,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',236599.62,NULL,NULL,1,'2023-03-22 16:51:26','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2445,7922,40723,6061,3,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',75614.54,NULL,NULL,1,'2023-03-22 16:51:26','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2446,7922,40723,6061,3,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',343790.00,NULL,NULL,1,'2023-03-22 16:51:26','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2447,7922,40723,6061,3,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',219184.93,NULL,NULL,1,'2023-03-22 16:51:26','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2448,7922,40723,6061,3,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',368742.50,NULL,NULL,1,'2023-03-22 16:51:26','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2449,7922,40723,6061,3,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',357652.50,NULL,NULL,1,'2023-03-22 16:51:26','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2450,7922,40723,6061,3,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',364861.00,NULL,NULL,1,'2023-03-22 16:51:26','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2451,7922,40723,6061,3,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',20034.68,NULL,NULL,1,'2023-03-22 16:51:26','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2452,7922,40723,6061,3,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',20034.68,NULL,NULL,1,'2023-03-22 16:51:26','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2453,7922,40723,6061,3,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',362709.54,NULL,NULL,1,'2023-03-22 16:51:26','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2454,7922,40723,6061,3,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',360081.21,NULL,NULL,1,'2023-03-22 16:51:26','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2455,7922,40723,6061,3,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',888309.00,NULL,NULL,1,'2023-03-22 16:51:26','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2456,7922,40723,6061,3,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',49303.03,NULL,NULL,1,'2023-03-22 16:51:26','2023-09-30 09:39:18','2023-09-30 09:39:18');
INSERT INTO `balance_libro` VALUES (2457,7922,40723,6061,3,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',55465.41,NULL,NULL,1,'2023-03-22 16:51:26','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2458,7922,40723,6061,3,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',36976.93,NULL,NULL,1,'2023-03-22 16:51:26','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2459,7922,40723,6061,3,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1063531.00,NULL,NULL,1,'2023-03-22 16:51:27','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2460,7922,40723,6061,3,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1053550.00,NULL,NULL,1,'2023-03-22 16:51:27','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2461,7922,40723,6061,3,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',997545.50,NULL,NULL,1,'2023-03-22 16:51:27','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2462,7922,40723,6061,3,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',132787.25,NULL,NULL,1,'2023-03-22 16:51:27','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2463,7922,40723,6061,3,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',0.00,NULL,NULL,1,'2023-03-22 16:51:27','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2464,7922,40723,6061,3,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4209.80,NULL,NULL,1,'2023-03-22 16:51:27','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2465,7922,40723,6061,3,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4209.80,NULL,NULL,1,'2023-03-22 16:51:27','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2466,7922,40723,6061,3,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',142800.18,NULL,NULL,1,'2023-03-22 16:51:27','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2467,7922,40723,6061,3,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',129392.73,NULL,NULL,1,'2023-03-22 16:51:27','2023-09-30 09:39:18','2023-09-30 09:39:18'),(2468,7922,40723,6061,3,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',127848.37,NULL,NULL,1,'2023-03-22 16:51:28','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2469,7922,40723,6061,3,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',202281.60,NULL,NULL,1,'2023-03-22 16:51:28','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2470,7922,40723,6061,3,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',215146.00,NULL,NULL,1,'2023-03-22 16:51:28','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2471,7922,40723,6061,3,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',404352.49,NULL,NULL,1,'2023-03-22 16:51:28','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2472,7922,40723,6061,3,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',437955.19,NULL,NULL,1,'2023-03-22 16:51:28','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2473,7922,40723,6061,3,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',390911.41,NULL,NULL,1,'2023-03-22 16:51:28','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2474,7922,40723,6061,3,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',435715.01,NULL,NULL,1,'2023-03-22 16:51:28','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2475,7922,40723,6061,3,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',148477.35,NULL,NULL,1,'2023-03-22 16:51:28','2023-09-30 09:39:19','2023-09-30 09:39:19');
INSERT INTO `balance_libro` VALUES (2476,7922,40723,6061,3,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',300893.88,NULL,NULL,1,'2023-03-22 16:51:28','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2477,7922,40723,6061,3,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',337091.64,NULL,NULL,1,'2023-03-22 16:51:28','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2478,7922,40723,6061,3,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',123257.60,NULL,NULL,1,'2023-03-22 16:51:28','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2479,7922,40723,6061,3,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',92442.35,NULL,NULL,1,'2023-03-22 16:51:28','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2480,7922,40723,6061,3,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',123257.60,NULL,NULL,1,'2023-03-22 16:51:28','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2481,7922,40723,6061,3,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',159506.85,NULL,NULL,1,'2023-03-22 16:51:28','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2482,7922,40723,6061,3,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',69331.76,NULL,NULL,1,'2023-03-22 16:51:29','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2483,7922,40723,6061,3,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',316730.40,NULL,NULL,1,'2023-03-22 16:51:29','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2484,7922,40723,6061,3,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',311640.09,NULL,NULL,1,'2023-03-22 16:51:29','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2485,7922,40723,6061,3,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',317295.99,NULL,NULL,1,'2023-03-22 16:51:29','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2486,7922,40723,6061,3,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',367633.50,NULL,NULL,1,'2023-03-22 16:51:29','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2487,7922,40723,6061,3,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4508.40,NULL,NULL,1,'2023-03-22 16:51:29','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2488,7922,40723,6061,3,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',189855.31,NULL,NULL,1,'2023-03-22 16:51:29','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2489,7922,40723,6061,3,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',162718.38,NULL,NULL,1,'2023-03-22 16:51:29','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2490,7922,40723,6061,3,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',123257.60,NULL,NULL,1,'2023-03-22 16:51:29','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2491,7922,40723,6061,3,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',69331.76,NULL,NULL,1,'2023-03-22 16:51:29','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2492,7922,40723,6061,3,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',597978.35,NULL,NULL,1,'2023-03-22 16:51:29','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2493,7922,40723,6061,3,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',514592.65,NULL,NULL,1,'2023-03-22 16:51:29','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2494,7922,40723,6061,3,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',615683.53,NULL,NULL,1,'2023-03-22 16:51:29','2023-09-30 09:39:19','2023-09-30 09:39:19');
INSERT INTO `balance_libro` VALUES (2495,7922,40723,6061,3,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',429493.52,NULL,NULL,1,'2023-03-22 16:51:29','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2496,7922,40723,6061,3,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',143363.93,NULL,NULL,1,'2023-03-22 16:51:29','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2497,7922,40723,6061,3,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',129564.34,NULL,NULL,1,'2023-03-22 16:51:30','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2498,7922,40723,6061,3,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',279822.89,NULL,NULL,1,'2023-03-22 16:51:30','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2499,7922,40723,6061,3,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',286266.17,NULL,NULL,1,'2023-03-22 16:51:30','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2500,7922,40723,6061,3,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',360064.59,NULL,NULL,1,'2023-03-22 16:51:30','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2501,7922,40723,6061,3,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',329289.84,NULL,NULL,1,'2023-03-22 16:51:30','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2502,7922,40723,6061,3,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',311440.48,NULL,NULL,1,'2023-03-22 16:51:30','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2503,7922,40723,6061,3,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',346523.69,NULL,NULL,1,'2023-03-22 16:51:30','2023-09-30 09:39:19','2023-09-30 09:39:19'),(2504,7922,40723,6061,3,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',327443.35,NULL,NULL,1,'2023-03-22 16:51:30','2023-09-30 09:39:20','2023-09-30 09:39:20'),(2505,7922,40723,6061,3,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',336675.77,NULL,NULL,1,'2023-03-22 16:51:30','2023-09-30 09:39:20','2023-09-30 09:39:20'),(2506,7922,40723,6061,3,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',150884.03,NULL,NULL,1,'2023-03-22 16:51:30','2023-09-30 09:39:20','2023-09-30 09:39:20'),(2507,7922,40723,6061,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',61628.80,NULL,NULL,1,'2023-03-22 16:51:30','2023-09-30 09:39:20','2023-09-30 09:39:20'),(2508,7922,40723,6061,3,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',46221.18,NULL,NULL,1,'2023-03-22 16:51:30','2023-09-30 09:39:20','2023-09-30 09:39:20'),(2509,7922,40723,6061,3,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',69331.76,NULL,NULL,1,'2023-03-22 16:51:30','2023-09-30 09:39:20','2023-09-30 09:39:20'),(2510,7922,40723,6061,3,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',92361.33,NULL,NULL,1,'2023-03-22 16:51:30','2023-09-30 09:39:20','2023-09-30 09:39:20'),(2511,7922,40723,6061,3,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',424225.78,NULL,NULL,1,'2023-03-22 16:51:30','2023-09-30 09:39:20','2023-09-30 09:39:20'),(2512,7922,40723,6061,3,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',385349.79,NULL,NULL,1,'2023-03-22 16:51:30','2023-09-30 09:39:20','2023-09-30 09:39:20'),(2513,7922,40723,6061,3,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',746168.47,NULL,NULL,1,'2023-03-22 16:51:31','2023-09-30 09:39:20','2023-09-30 09:39:20');
INSERT INTO `balance_libro` VALUES (2514,7922,40723,6061,3,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',725873.77,NULL,NULL,1,'2023-03-22 16:51:31','2023-09-30 09:39:20','2023-09-30 09:39:20'),(2515,7922,40723,6061,3,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',123208.26,NULL,NULL,1,'2023-03-22 16:51:31','2023-09-30 09:39:20','2023-09-30 09:39:20'),(2516,7922,40723,6061,3,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.00,NULL,NULL,1,'2023-03-22 16:51:31','2023-09-30 09:39:20','2023-09-30 09:39:20'),(2517,7922,40723,6061,3,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.00,NULL,NULL,1,'2023-03-22 16:51:31','2023-09-30 09:39:20','2023-09-30 09:39:20'),(2518,7922,40723,6061,3,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',127552.96,NULL,NULL,1,'2023-03-22 16:51:31','2023-09-30 09:39:20','2023-09-30 09:39:20'),(2519,7922,40721,3053,3,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',10310.75,NULL,NULL,1,'2023-03-23 09:47:37','2023-03-23 09:47:37',NULL),(2520,7922,40721,3053,3,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',7596.44,NULL,NULL,1,'2023-03-23 09:48:03','2023-03-23 09:48:03',NULL),(2521,7922,40721,3053,3,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',10923.72,NULL,NULL,1,'2023-03-23 09:48:22','2023-03-23 09:48:22',NULL),(2522,7922,40721,3053,3,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',10391.01,NULL,NULL,1,'2023-03-23 09:50:20','2023-03-23 09:50:20',NULL),(2523,7922,40721,3053,3,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',9412.86,NULL,NULL,1,'2023-03-23 09:50:37','2023-03-23 09:50:37',NULL),(2524,7922,40721,3053,3,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',10105.35,NULL,NULL,1,'2023-03-23 09:50:57','2023-03-23 09:50:57',NULL),(2525,7922,40721,3053,3,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',7742.72,NULL,NULL,1,'2023-03-23 09:51:20','2023-03-23 09:51:20',NULL),(2526,7922,40721,3053,3,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',9447.30,NULL,NULL,1,'2023-03-23 09:51:42','2023-03-23 09:51:42',NULL),(2527,7922,40721,3053,3,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',7339.28,NULL,NULL,1,'2023-03-23 09:52:01','2023-03-23 09:52:01',NULL),(2528,7922,40721,3053,3,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',8106.18,NULL,NULL,1,'2023-03-23 09:52:28','2023-03-23 09:52:28',NULL),(2529,7922,40721,3053,3,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',9295.51,NULL,NULL,1,'2023-03-23 09:52:45','2023-03-23 09:52:45',NULL),(2530,7922,40721,3053,3,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',9688.26,NULL,NULL,1,'2023-03-23 09:53:08','2023-03-23 09:53:08',NULL),(2531,7922,40721,3053,3,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',9424.52,NULL,NULL,1,'2023-03-23 09:56:08','2023-03-23 09:56:08',NULL),(2532,7922,40723,6062,2,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',330143.69,NULL,NULL,1,'2023-03-23 12:31:07','2023-03-23 15:15:31','2023-03-23 15:15:31'),(2533,7922,40723,6062,2,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',330143.69,NULL,NULL,1,'2023-03-23 15:15:31','2023-03-23 15:15:31',NULL);
INSERT INTO `balance_libro` VALUES (2534,7922,40759,10720,2,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',40795.00,NULL,NULL,1,'2023-03-24 09:37:12','2023-03-24 09:37:12',NULL),(2535,7922,40759,10720,2,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',5000.00,NULL,NULL,1,'2023-03-24 09:37:12','2023-03-24 09:37:12',NULL),(2536,7922,40759,10720,2,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15000.00,NULL,NULL,1,'2023-03-24 09:37:12','2023-03-24 09:37:12',NULL),(2537,7922,40759,10720,2,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15000.00,NULL,NULL,1,'2023-03-24 09:37:12','2023-03-24 09:37:12',NULL),(2538,7922,40759,10720,2,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',279110.00,NULL,NULL,1,'2023-03-24 09:37:12','2023-03-24 09:37:12',NULL),(2539,7922,40759,10720,2,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15000.00,NULL,NULL,1,'2023-03-24 09:37:12','2023-03-24 09:37:12',NULL),(2540,7922,40759,10721,2,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',124084.00,NULL,NULL,1,'2023-03-24 09:37:21','2023-03-24 09:37:21',NULL),(2541,7922,40759,10721,2,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',279110.00,NULL,NULL,1,'2023-03-24 09:37:21','2023-03-24 09:37:21',NULL),(2542,7922,40759,10721,3,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',867.36,NULL,NULL,1,'2023-03-24 09:37:44','2023-03-24 09:37:44',NULL),(2543,7922,40759,10721,3,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',4109.45,NULL,NULL,1,'2023-03-24 09:37:44','2023-03-24 09:37:44',NULL),(2544,7922,40759,10721,3,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1265.00,NULL,NULL,1,'2023-03-24 09:37:44','2023-03-24 09:37:44',NULL),(2545,7922,40759,10721,3,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',9300.01,NULL,NULL,1,'2023-03-24 09:37:44','2023-03-24 09:37:44',NULL),(2546,7922,40759,10721,3,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',857.00,NULL,NULL,1,'2023-03-24 09:37:44','2023-03-24 09:37:44',NULL),(2547,7922,40759,10721,3,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',440.00,NULL,NULL,1,'2023-03-24 09:37:44','2023-03-24 09:37:44',NULL),(2548,7922,40759,10721,3,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',2178.65,NULL,NULL,1,'2023-03-24 09:37:45','2023-03-24 09:37:45',NULL),(2549,7922,40759,10721,3,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1878.80,NULL,NULL,1,'2023-03-24 09:37:45','2023-03-24 09:37:45',NULL),(2550,7922,40759,10721,3,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1748.45,NULL,NULL,1,'2023-03-24 09:37:45','2023-03-24 09:37:45',NULL),(2551,7922,40759,10721,3,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',14000.00,NULL,NULL,1,'2023-03-24 09:37:45','2023-03-24 09:37:45',NULL),(2552,7922,40759,10721,3,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',4951.94,NULL,NULL,1,'2023-03-24 09:37:45','2023-03-24 09:37:45',NULL),(2553,7922,40759,10721,3,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',268.00,NULL,NULL,1,'2023-03-24 09:37:45','2023-03-24 09:37:45',NULL),(2554,7922,40759,10721,3,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',550.00,NULL,NULL,1,'2023-03-24 09:37:45','2023-03-24 09:37:45',NULL);
INSERT INTO `balance_libro` VALUES (2555,7922,40759,10721,3,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',6948.25,NULL,NULL,1,'2023-03-24 09:37:45','2023-03-24 09:37:45',NULL),(2556,7922,40759,10721,3,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1983.25,NULL,NULL,1,'2023-03-24 09:37:45','2023-03-24 09:37:45',NULL),(2557,7922,40759,10721,3,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',103455.00,NULL,NULL,1,'2023-03-24 09:37:45','2023-03-24 09:37:45',NULL),(2578,7922,40759,10720,3,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',872.95,NULL,NULL,1,'2023-03-24 09:42:21','2023-03-24 09:42:21',NULL),(2579,7922,40759,10720,3,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2323.86,NULL,NULL,1,'2023-03-24 09:42:21','2023-03-24 09:42:21',NULL),(2580,7922,40759,10720,3,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',8500.00,NULL,NULL,1,'2023-03-24 09:42:21','2023-03-24 09:42:21',NULL),(2581,7922,40759,10720,3,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',13100.08,NULL,NULL,1,'2023-03-24 09:42:21','2023-03-24 09:42:21',NULL),(2582,7922,40759,10720,3,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',263.00,NULL,NULL,1,'2023-03-24 09:42:21','2023-03-24 09:42:21',NULL),(2583,7922,40759,10720,3,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',894.94,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2584,7922,40759,10720,3,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',210.00,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2585,7922,40759,10720,3,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1388.50,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2586,7922,40759,10720,3,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',5400.00,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2587,7922,40759,10720,3,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1527.16,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2588,7922,40759,10720,3,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1852.04,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2589,7922,40759,10720,3,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2164.80,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2590,7922,40759,10720,3,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1365.00,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2591,7922,40759,10720,3,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1209.00,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2592,7922,40759,10720,3,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1600.00,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2593,7922,40759,10720,3,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',8400.00,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2594,7922,40759,10720,3,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1371.75,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2595,7922,40759,10720,3,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',6100.04,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL);
INSERT INTO `balance_libro` VALUES (2596,7922,40759,10720,3,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',3052.50,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2597,7922,40759,10720,3,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',145200.00,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2598,7922,40759,10720,3,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1773.99,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2599,7922,40759,10720,3,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1669.99,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2600,7922,40759,10720,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',904.00,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2601,7922,40759,10720,3,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',2481.76,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2602,7922,40759,10720,3,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2090.64,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2603,7922,40759,10720,3,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',990.00,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2604,7922,40759,10720,3,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',740.60,NULL,NULL,1,'2023-03-24 09:42:22','2023-03-24 09:42:22',NULL),(2605,7922,40759,10721,3,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',9799.98,NULL,NULL,1,'2023-03-24 10:00:45','2023-03-24 10:00:45',NULL),(2606,7922,40759,10721,3,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',6299.97,NULL,NULL,1,'2023-03-24 10:01:32','2023-03-24 10:01:32',NULL),(2607,7922,40759,10721,3,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',11500.00,NULL,NULL,1,'2023-03-24 10:01:57','2023-03-24 10:01:57',NULL),(2608,7922,40759,10721,3,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',14900.03,NULL,NULL,1,'2023-03-24 10:02:22','2023-03-24 10:02:22',NULL),(2609,7922,40723,6061,15,105,'App\\Models\\PeriodLiquidation',NULL,105,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3224439.93,NULL,NULL,1,'2023-03-24 12:14:17','2023-09-30 09:38:56','2023-09-30 09:38:56'),(2610,7922,40723,6061,16,56,'App\\Models\\PeriodLiquidation',NULL,56,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1962329.19,NULL,NULL,1,'2023-03-24 12:18:03','2023-09-30 09:39:02','2023-09-30 09:39:02'),(2611,7922,40723,6062,16,88,'App\\Models\\PeriodLiquidation',NULL,88,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',573303.70,NULL,NULL,1,'2023-03-24 12:19:56','2023-03-24 12:19:56',NULL),(2612,7922,40723,6062,15,87,'App\\Models\\PeriodLiquidation',NULL,87,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3290133.09,NULL,NULL,1,'2023-03-24 12:21:25','2023-03-24 12:21:25',NULL),(2613,7922,40721,3054,2,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',1970.00,NULL,NULL,1,'2023-03-27 12:28:12','2023-03-27 12:28:12',NULL),(2614,7922,40721,3054,2,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',20900.00,NULL,NULL,1,'2023-03-27 12:28:12','2023-03-27 12:28:12',NULL),(2615,7922,40721,3054,2,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',11812.50,NULL,NULL,1,'2023-03-27 12:28:12','2023-03-27 12:28:12',NULL);
INSERT INTO `balance_libro` VALUES (2616,7922,40721,3054,2,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',0.20,NULL,NULL,1,'2023-03-27 12:28:12','2023-03-27 12:28:12',NULL),(2617,7922,40721,3054,2,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',1600.00,NULL,NULL,1,'2023-03-27 12:28:12','2023-03-27 12:28:12',NULL),(2618,7922,40721,3054,2,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',300.00,NULL,NULL,1,'2023-03-27 12:28:12','2023-03-27 12:28:12',NULL),(2619,7922,40721,3054,2,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',1200.00,NULL,NULL,1,'2023-03-27 12:28:12','2023-03-27 12:28:12',NULL),(2620,7922,40721,3054,2,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',240.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2621,7922,40721,3054,2,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',1100.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2622,7922,40721,3054,2,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2500.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2623,7922,40721,3054,2,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',400.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2624,7922,40721,3054,2,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',1.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2625,7922,40721,3054,2,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2500.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2626,7922,40721,3054,2,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',360.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2627,7922,40721,3054,2,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',17100.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2628,7922,40721,3054,2,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',1100.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2629,7922,40721,3054,2,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',1000.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2630,7922,40721,3054,2,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',3000.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2631,7922,40721,3054,2,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2632,7922,40721,3054,2,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',4580.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2633,7922,40721,3054,2,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',3100.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2634,7922,40721,3054,2,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',2900.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2635,7922,40721,3054,2,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1000.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2636,7922,40721,3054,2,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',100.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL);
INSERT INTO `balance_libro` VALUES (2637,7922,40721,3054,2,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',300.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2638,7922,40721,3054,2,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',17100.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2639,7922,40721,3054,2,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',500.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2640,7922,40721,3054,2,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1100.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2641,7922,40721,3054,2,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',6000.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2642,7922,40721,3054,2,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2643,7922,40721,3054,2,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',3700.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2644,7922,40721,3054,2,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',900.00,NULL,NULL,1,'2023-03-27 12:28:13','2023-03-27 12:28:13',NULL),(2645,7922,40721,3054,2,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',320.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2646,7922,40721,3054,2,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1300.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2647,7922,40721,3054,2,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',3000.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2648,7922,40721,3054,2,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',5000.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2649,7922,40721,3054,2,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1200.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2650,7922,40721,3054,2,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1000.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2651,7922,40721,3054,2,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2652,7922,40721,3054,2,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',4615.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2653,7922,40721,3054,2,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',3650.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2654,7922,40721,3054,2,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1180.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2655,7922,40721,3054,2,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1900.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2656,7922,40721,3054,2,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1500.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2657,7922,40721,3054,2,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',3100.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL);
INSERT INTO `balance_libro` VALUES (2658,7922,40721,3054,2,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1170.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2659,7922,40721,3054,2,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',2500.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2660,7922,40721,3054,2,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1600.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2661,7922,40721,3054,2,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',850.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2662,7922,40721,3054,2,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1000.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2663,7922,40721,3054,2,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',2400.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2664,7922,40721,3054,2,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1800.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2665,7922,40721,3054,2,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',2000.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2666,7922,40721,3054,2,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',1100.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2667,7922,40721,3054,2,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',500.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2668,7922,40721,3054,2,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',6250.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2669,7922,40721,3054,2,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',100.00,NULL,NULL,1,'2023-03-27 12:28:14','2023-03-27 12:28:14',NULL),(2670,7922,40721,3054,2,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',1100.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2671,7922,40721,3054,2,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',1100.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2672,7922,40721,3054,2,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',2000.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2673,7922,40721,3054,2,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',3000.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2674,7922,40721,3054,2,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',1250.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2675,7922,40721,3054,2,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',550.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2676,7922,40721,3054,2,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',17250.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2677,7922,40721,3054,2,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',12082.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2678,7922,40721,3054,2,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1000.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL);
INSERT INTO `balance_libro` VALUES (2679,7922,40721,3054,2,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',4400.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2680,7922,40721,3054,2,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',750.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2681,7922,40721,3054,2,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',800.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2682,7922,40721,3054,2,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1250.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2683,7922,40721,3054,2,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',2500.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2684,7922,40721,3054,2,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',2000.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2685,7922,40721,3054,2,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',3300.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2686,7922,40721,3054,2,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',3100.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2687,7922,40721,3054,2,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',4650.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2688,7922,40721,3054,2,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',11500.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2689,7922,40721,3054,2,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',12700.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2690,7922,40721,3054,2,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1200.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2691,7922,40721,3054,2,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',3200.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2692,7922,40721,3054,2,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1480.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2693,7922,40721,3054,2,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',7500.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2694,7922,40721,3054,2,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',2500.00,NULL,NULL,1,'2023-03-27 12:28:15','2023-03-27 12:28:15',NULL),(2695,7922,40721,3054,2,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',4200.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2696,7922,40721,3054,2,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',2500.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2697,7922,40721,3054,2,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',18975.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2698,7922,40721,3054,2,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',3500.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2699,7922,40721,3054,2,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',380.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL);
INSERT INTO `balance_libro` VALUES (2700,7922,40721,3054,2,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',950.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2701,7922,40721,3054,2,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1300.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2702,7922,40721,3054,2,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',300.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2703,7922,40721,3054,2,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',50000.10,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2704,7922,40721,3054,2,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',104400.01,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2705,7922,40721,3054,2,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',2200.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2706,7922,40721,3054,2,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',6100.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2707,7922,40721,3054,2,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',950.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2708,7922,40721,3054,2,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',650.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2709,7922,40721,3054,2,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1300.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2710,7922,40721,3054,2,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1100.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2711,7922,40721,3054,2,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1000.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2712,7922,40721,3054,2,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1500.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2713,7922,40721,3054,2,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1300.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2714,7922,40721,3054,2,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',840.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2715,7922,40721,3054,2,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',2500.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2716,7922,40721,3054,2,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',71390.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2717,7922,40721,3054,2,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',15000.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2718,7922,40721,3054,2,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',1000.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2719,7922,40721,3054,2,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',600.00,NULL,NULL,1,'2023-03-27 12:28:16','2023-03-27 12:28:16',NULL),(2720,7922,40721,3054,2,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',18500.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL);
INSERT INTO `balance_libro` VALUES (2721,7922,40721,3054,2,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',2600.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2722,7922,40721,3054,2,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3500.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2723,7922,40721,3054,2,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3500.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2724,7922,40721,3054,2,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3300.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2725,7922,40721,3054,2,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',21000.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2726,7922,40721,3054,2,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',2000.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2727,7922,40721,3054,2,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',2000.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2728,7922,40721,3054,2,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',1370.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2729,7922,40721,3054,2,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',15200.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2730,7922,40721,3054,2,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',4500.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2731,7922,40721,3054,2,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',12000.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2732,7922,40721,3054,2,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',24000.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2733,7922,40721,3054,2,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',2800.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2734,7922,40721,3054,2,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',8650.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2735,7922,40721,3054,2,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1300.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2736,7922,40721,3054,2,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',7700.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2737,7922,40721,3054,2,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',3300.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2738,7922,40721,3054,2,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',800.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2739,7922,40721,3054,2,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',2750.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2740,7922,40721,3054,2,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1250.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2741,7922,40721,3054,2,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',4100.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL);
INSERT INTO `balance_libro` VALUES (2742,7922,40721,3054,2,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',3000.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2743,7922,40721,3054,2,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',900.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2744,7922,40721,3054,2,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1500.00,NULL,NULL,1,'2023-03-27 12:28:17','2023-03-27 12:28:17',NULL),(2745,7922,40721,3054,2,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1200.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2746,7922,40721,3054,2,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',2500.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2747,7922,40721,3054,2,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',9650.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2748,7922,40721,3054,2,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',12000.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2749,7922,40721,3054,2,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',3800.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2750,7922,40721,3054,2,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',300.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2751,7922,40721,3054,2,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',2500.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2752,7922,40721,3054,2,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',3170.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2753,7922,40721,3054,2,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',9000.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2754,7922,40721,3054,2,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',350.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2755,7922,40721,3054,2,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1800.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2756,7922,40721,3054,2,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',3300.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2757,7922,40721,3054,2,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',5000.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2758,7922,40721,3054,2,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',250.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2759,7922,40721,3054,2,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1000.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2760,7922,40721,3054,2,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1200.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2761,7922,40721,3054,2,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',126880.18,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2762,7922,40721,3054,2,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',9650.96,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL);
INSERT INTO `balance_libro` VALUES (2763,7922,40721,3054,2,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',0.10,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2764,7922,40721,3054,2,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',0.10,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2765,7922,40721,3054,2,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',3500.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2766,7922,40721,3054,2,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',4631.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2767,7922,40721,3054,2,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',250.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2768,7922,40721,3054,2,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',300.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2769,7922,40721,3054,2,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',7040.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2770,7922,40721,3054,2,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',200260.00,NULL,NULL,1,'2023-03-27 12:28:18','2023-03-27 12:28:18',NULL),(2771,7922,40721,3054,2,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',540.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2772,7922,40721,3054,2,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',1500.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2773,7922,40721,3054,2,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',3800.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2774,7922,40721,3054,2,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',15400.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2775,7922,40721,3054,2,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',1400.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2776,7922,40721,3054,2,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',1250.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2777,7922,40721,3054,2,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',620.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2778,7922,40721,3054,2,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',170.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2779,7922,40721,3054,2,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',26875.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2780,7922,40721,3054,2,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',2500.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2781,7922,40721,3054,2,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',3320.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2782,7922,40721,3054,2,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',100.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2783,7922,40721,3054,2,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',400.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL);
INSERT INTO `balance_libro` VALUES (2784,7922,40721,3054,2,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',34650.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2785,7922,40721,3054,2,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1000.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2786,7922,40721,3054,2,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',2500.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2787,7922,40721,3054,2,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',11500.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2788,7922,40721,3054,2,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1600.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2789,7922,40721,3054,2,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1700.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2790,7922,40721,3054,2,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',700.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2791,7922,40721,3054,2,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',700.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2792,7922,40721,3054,2,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',600.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2793,7922,40721,3054,2,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1250.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2794,7922,40721,3054,2,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',2900.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2795,7922,40721,3054,2,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',3150.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2796,7922,40721,3054,2,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',750.00,NULL,NULL,1,'2023-03-27 12:28:19','2023-03-27 12:28:19',NULL),(2797,7922,40721,3054,2,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',1550.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2798,7922,40721,3054,2,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',1900.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2799,7922,40721,3054,2,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',14520.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2800,7922,40721,3054,2,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',3335.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2801,7922,40721,3054,2,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',2800.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2802,7922,40721,3054,2,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',1000.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2803,7922,40721,3054,2,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',8797.50,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2804,7922,40721,3054,2,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1900.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL);
INSERT INTO `balance_libro` VALUES (2805,7922,40721,3054,2,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',150.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2806,7922,40721,3054,2,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1100.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2807,7922,40721,3054,2,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',2500.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2808,7922,40721,3054,2,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1200.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2809,7922,40721,3054,2,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',6000.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2810,7922,40721,3054,2,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',5000.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2811,7922,40721,3054,2,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1500.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2812,7922,40721,3054,2,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',2500.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2813,7922,40721,3054,2,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',9845.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2814,7922,40721,3054,2,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',300.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2815,7922,40721,3054,2,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',25357.20,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2816,7922,40721,3054,2,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',700.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2817,7922,40721,3054,2,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',2800.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2818,7922,40721,3054,2,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1500.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2819,7922,40721,3054,2,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',100000.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2820,7922,40721,3054,2,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',95000.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2821,7922,40721,3054,2,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',80000.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2822,7922,40721,3054,2,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',75000.00,NULL,NULL,1,'2023-03-27 12:28:20','2023-03-27 12:28:20',NULL),(2823,7922,40721,3054,2,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',50000.00,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL),(2824,7922,40721,3054,2,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',500.00,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL),(2825,7922,40721,3054,2,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',2500.00,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL);
INSERT INTO `balance_libro` VALUES (2826,7922,40721,3054,2,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',2500.00,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL),(2827,7922,40721,3054,2,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',300.00,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL),(2828,7922,40721,3054,2,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',4550.00,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL),(2829,7922,40721,3054,2,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',15850.00,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL),(2830,7922,40721,3054,2,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',300.00,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL),(2831,7922,40721,3054,2,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',300.00,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL),(2832,7922,40721,3054,2,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1300.00,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL),(2833,7922,40721,3054,2,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',720.00,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL),(2834,7922,40721,3054,2,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',900.00,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL),(2835,7922,40721,3054,2,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',2000.00,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL),(2836,7922,40721,3054,2,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',126880.18,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL),(2837,7922,40721,3054,2,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',14812.50,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL),(2838,7922,40721,3054,2,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',650.00,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL),(2839,7922,40721,3054,2,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1000.00,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL),(2840,7922,40721,3054,2,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',2300.00,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL),(2841,7922,40721,3054,2,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3630.00,NULL,NULL,1,'2023-03-27 12:28:21','2023-03-27 12:28:21',NULL),(2842,7922,40721,3054,2,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1300.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2843,7922,40721,3054,2,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3700.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2844,7922,40721,3054,2,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1300.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2845,7922,40721,3054,2,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',270.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2846,7922,40721,3054,2,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1200.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL);
INSERT INTO `balance_libro` VALUES (2847,7922,40721,3054,2,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',450.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2848,7922,40721,3054,2,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1100.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2849,7922,40721,3054,2,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1350.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2850,7922,40721,3054,2,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',130.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2851,7922,40721,3054,2,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',350.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2852,7922,40721,3054,2,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',126880.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2853,7922,40721,3054,2,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',9660.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2854,7922,40721,3054,2,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1100.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2855,7922,40721,3054,2,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',8650.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2856,7922,40721,3054,2,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',2900.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2857,7922,40721,3054,2,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',2500.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2858,7922,40721,3054,2,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1000.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2859,7922,40721,3054,2,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',3250.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2860,7922,40721,3054,2,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',2000.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2861,7922,40721,3054,2,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',3500.00,NULL,NULL,1,'2023-03-27 12:28:22','2023-03-27 12:28:22',NULL),(2862,7922,40721,3054,2,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',2700.00,NULL,NULL,1,'2023-03-27 12:28:23','2023-03-27 12:28:23',NULL),(2863,7922,40721,3054,2,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1000.00,NULL,NULL,1,'2023-03-27 12:28:23','2023-03-27 12:28:23',NULL),(2864,7922,40721,3054,2,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',900.00,NULL,NULL,1,'2023-03-27 12:28:23','2023-03-27 12:28:23',NULL),(2865,7922,40721,3054,2,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',600.00,NULL,NULL,1,'2023-03-27 12:28:23','2023-03-27 12:28:23',NULL),(2866,7922,40721,3054,2,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',300.00,NULL,NULL,1,'2023-03-27 12:28:23','2023-03-27 12:28:23',NULL),(2867,7922,40721,3054,2,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',2600.00,NULL,NULL,1,'2023-03-27 12:28:23','2023-03-27 12:28:23',NULL);
INSERT INTO `balance_libro` VALUES (2868,7922,40721,3054,2,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',700.00,NULL,NULL,1,'2023-03-27 12:28:23','2023-03-27 12:28:23',NULL),(2869,7922,40721,3054,2,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',500.00,NULL,NULL,1,'2023-03-27 12:28:23','2023-03-27 12:28:23',NULL),(2870,7922,40721,3054,2,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',9130.00,NULL,NULL,1,'2023-03-27 12:28:23','2023-03-27 12:28:23',NULL),(2871,7922,40721,3054,2,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',29150.00,NULL,NULL,1,'2023-03-27 12:28:23','2023-03-27 12:28:23',NULL),(2872,7922,40721,3054,2,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',600.00,NULL,NULL,1,'2023-03-27 12:28:23','2023-03-27 12:28:23',NULL),(2873,7922,40721,3054,2,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',4500.00,NULL,NULL,1,'2023-03-27 12:28:23','2023-03-27 12:28:23',NULL),(2874,7922,40721,3054,2,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',200.00,NULL,NULL,1,'2023-03-27 12:28:23','2023-03-27 12:28:23',NULL),(2875,7922,40721,3054,2,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1300.00,NULL,NULL,1,'2023-03-27 12:28:23','2023-03-27 12:28:23',NULL),(2876,7922,40721,3054,2,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',7400.00,NULL,NULL,1,'2023-03-27 12:28:23','2023-03-27 12:28:23',NULL),(2877,7922,40721,3054,2,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',13600.00,NULL,NULL,1,'2023-03-27 12:28:23','2023-03-27 12:28:23',NULL),(2878,7922,40721,3054,2,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',400.00,NULL,NULL,1,'2023-03-27 12:28:24','2023-03-27 12:28:24',NULL),(2879,7922,40721,3054,2,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1110.00,NULL,NULL,1,'2023-03-27 12:28:24','2023-03-27 12:28:24',NULL),(2880,7922,40721,3054,2,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1300.00,NULL,NULL,1,'2023-03-27 12:28:24','2023-03-27 12:28:24',NULL),(2881,7922,40721,3054,2,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',2500.00,NULL,NULL,1,'2023-03-27 12:28:24','2023-03-27 12:28:24',NULL),(2882,7922,40721,3054,2,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',25000.00,NULL,NULL,1,'2023-03-27 12:28:24','2023-03-27 12:28:24',NULL),(2883,7922,40721,3054,2,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',2020.00,NULL,NULL,1,'2023-03-27 12:28:24','2023-03-27 12:28:24',NULL),(2884,7922,40721,3054,2,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',11800.00,NULL,NULL,1,'2023-03-27 12:28:24','2023-03-27 12:28:24',NULL),(2885,7922,40721,3054,2,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',400.00,NULL,NULL,1,'2023-03-27 12:28:24','2023-03-27 12:28:24',NULL),(2886,7922,40721,3054,2,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',1500.00,NULL,NULL,1,'2023-03-27 12:28:24','2023-03-27 12:28:24',NULL),(2887,7922,40721,3054,2,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',850.00,NULL,NULL,1,'2023-03-27 12:28:24','2023-03-27 12:28:24',NULL),(2888,7922,40721,3054,2,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',600.00,NULL,NULL,1,'2023-03-27 12:28:24','2023-03-27 12:28:24',NULL);
INSERT INTO `balance_libro` VALUES (2889,7922,40721,3054,2,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',320.00,NULL,NULL,1,'2023-03-27 12:28:24','2023-03-27 12:28:24',NULL),(2890,7922,40721,3054,2,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',4300.00,NULL,NULL,1,'2023-03-27 12:28:24','2023-03-27 12:28:24',NULL),(2891,7922,40721,3054,2,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',150.00,NULL,NULL,1,'2023-03-27 12:28:24','2023-03-27 12:28:24',NULL),(2892,7922,40721,3054,2,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',4100.00,NULL,NULL,1,'2023-03-27 12:28:24','2023-03-27 12:28:24',NULL),(2893,7922,40721,3054,2,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',140.00,NULL,NULL,1,'2023-03-27 12:28:24','2023-03-27 12:28:24',NULL),(2894,7922,40721,3054,2,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',5900.00,NULL,NULL,1,'2023-03-27 12:28:24','2023-03-27 12:28:24',NULL),(2895,7922,40721,3054,2,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',178414.50,NULL,NULL,1,'2023-03-27 12:28:24','2023-03-27 12:28:24',NULL),(2896,7922,40721,3054,2,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',5450.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2897,7922,40721,3054,2,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',2550.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2898,7922,40721,3054,2,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',6000.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2899,7922,40721,3054,2,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',3500.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2900,7922,40721,3054,2,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',200.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2901,7922,40721,3054,2,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',1700.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2902,7922,40721,3054,2,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',800.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2903,7922,40721,3054,2,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',1900.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2904,7922,40721,3054,2,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',11250.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2905,7922,40721,3054,2,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',1420.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2906,7922,40721,3054,2,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',2550.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2907,7922,40721,3054,2,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',7500.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2908,7922,40721,3054,2,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',2900.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2909,7922,40721,3054,2,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',5900.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL);
INSERT INTO `balance_libro` VALUES (2910,7922,40721,3054,2,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',19747.20,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2911,7922,40721,3054,2,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',15872.78,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2912,7922,40721,3054,2,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',12580.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2913,7922,40721,3054,2,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',3800.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2914,7922,40721,3054,2,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',3950.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2915,7922,40721,3054,2,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',3100.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2916,7922,40721,3054,2,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',2950.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2917,7922,40721,3054,2,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',2000.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2918,7922,40721,3054,2,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',3900.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2919,7922,40721,3054,2,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',350.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2920,7922,40721,3054,2,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',300.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2921,7922,40721,3054,2,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',2550.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2922,7922,40721,3054,2,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',6440.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2923,7922,40721,3054,2,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',1630.00,NULL,NULL,1,'2023-03-27 12:28:25','2023-03-27 12:28:25',NULL),(2924,7922,40721,3054,2,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',1200.00,NULL,NULL,1,'2023-03-27 12:28:26','2023-03-27 12:28:26',NULL),(2925,7922,40721,3054,2,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',9000.00,NULL,NULL,1,'2023-03-27 12:28:26','2023-03-27 12:28:26',NULL),(2926,7922,40721,3054,2,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',2500.00,NULL,NULL,1,'2023-03-27 12:28:26','2023-03-27 12:28:26',NULL),(2927,7922,40721,3054,2,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',3650.00,NULL,NULL,1,'2023-03-27 12:28:26','2023-03-27 12:28:26',NULL),(2928,7922,40721,3054,2,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',6080.00,NULL,NULL,1,'2023-03-27 12:28:26','2023-03-27 12:28:26',NULL),(2929,7922,40721,3054,3,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',10499.00,NULL,NULL,1,'2023-03-27 12:28:59','2023-03-27 12:28:59',NULL),(2930,7922,40721,3054,3,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',12049.00,NULL,NULL,1,'2023-03-27 12:28:59','2023-03-27 12:28:59',NULL);
INSERT INTO `balance_libro` VALUES (2931,7922,40721,3054,3,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',8400.00,NULL,NULL,1,'2023-03-27 12:28:59','2023-03-27 12:28:59',NULL),(2932,7922,40721,3054,3,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',16200.00,NULL,NULL,1,'2023-03-27 12:28:59','2023-03-27 12:28:59',NULL),(2933,7922,40721,3054,3,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',400.00,NULL,NULL,1,'2023-03-27 12:28:59','2023-03-27 12:28:59',NULL),(2934,7922,40721,3054,3,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',0.01,NULL,NULL,1,'2023-03-27 12:28:59','2023-03-27 12:28:59',NULL),(2935,7922,40721,3054,3,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',100000.00,NULL,NULL,1,'2023-03-27 12:28:59','2023-03-27 12:28:59',NULL),(2936,7922,40721,3054,3,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',4000.00,NULL,NULL,1,'2023-03-27 12:28:59','2023-03-27 12:28:59',NULL),(2937,7922,40721,3054,3,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',12800.00,NULL,NULL,1,'2023-03-27 12:28:59','2023-03-27 12:28:59',NULL),(2938,7922,40721,3054,3,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',195000.00,NULL,NULL,1,'2023-03-27 12:28:59','2023-03-27 12:28:59',NULL),(2939,7922,40721,3054,3,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',146168.00,NULL,NULL,1,'2023-03-27 12:28:59','2023-03-27 12:28:59',NULL),(2940,7922,40721,3054,3,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',42580.78,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2941,7922,40721,3054,3,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',69120.00,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2942,7922,40721,3054,3,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',4860.00,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2943,7922,40721,3054,3,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',8215.90,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2944,7922,40721,3054,3,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',5820.00,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2945,7922,40721,3054,3,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',9400.01,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2946,7922,40721,3054,3,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3950.00,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2947,7922,40721,3054,3,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',14403.11,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2948,7922,40721,3054,3,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',8000.00,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2949,7922,40721,3054,3,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',100000.00,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2950,7922,40721,3054,3,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',42150.35,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2951,7922,40721,3054,3,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',4641.32,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL);
INSERT INTO `balance_libro` VALUES (2952,7922,40721,3054,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',40186.56,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2953,7922,40721,3054,3,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',294606.86,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2954,7922,40721,3054,3,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',11315.00,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2955,7922,40721,3054,3,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',348831.09,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2956,7922,40721,3054,3,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1049.00,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2957,7922,40721,3054,3,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',739434.80,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2958,7922,40721,3054,3,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',115200.00,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2959,7922,40721,3054,3,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',43650.00,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2960,7922,40721,3054,3,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',22836.58,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2961,7922,40721,3054,3,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',7500.00,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2962,7922,40721,3054,3,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',12200.98,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2963,7922,40721,3054,3,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',2029.00,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2964,7922,40721,3054,3,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',61599.72,NULL,NULL,1,'2023-03-27 12:29:00','2023-03-27 12:29:00',NULL),(2965,7922,40725,9149,1,2965,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-02-28',NULL,216303.72,NULL,NULL,1,'2023-03-27 16:17:34','2023-03-27 16:17:34',NULL),(2966,7922,40722,4550,1,2966,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-03-31',NULL,146218.71,NULL,NULL,1,'2023-04-01 14:09:43','2023-04-01 14:09:43',NULL),(2967,7922,40723,6062,1,2967,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-02-28',NULL,643088.09,NULL,NULL,1,'2023-04-01 16:39:18','2023-04-01 16:39:18',NULL),(2968,7922,40725,9148,2,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',69120.00,NULL,NULL,1,'2023-04-06 08:36:17','2023-04-06 08:36:17',NULL),(2969,7922,40725,9149,2,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',69120.00,NULL,NULL,1,'2023-04-06 08:37:17','2023-04-06 08:37:17',NULL),(2970,7922,40725,9150,2,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',69120.00,NULL,NULL,1,'2023-04-06 08:37:47','2023-04-06 08:37:47',NULL),(2971,7922,40725,9151,2,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',82950.00,NULL,NULL,1,'2023-04-06 08:38:15','2023-04-06 08:38:15',NULL),(2972,7922,40725,9148,3,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',2800.00,NULL,NULL,1,'2023-04-06 08:51:38','2023-04-06 08:51:38',NULL);
INSERT INTO `balance_libro` VALUES (2973,7922,40725,9148,3,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',82182.00,NULL,NULL,1,'2023-04-06 08:51:38','2023-04-06 08:51:38',NULL),(2974,7922,40725,9148,3,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',9800.00,NULL,NULL,1,'2023-04-06 08:51:38','2023-04-06 08:51:38',NULL),(2975,7922,40725,9148,3,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',6000.00,NULL,NULL,1,'2023-04-06 08:51:38','2023-04-06 08:51:38',NULL),(2976,7922,40725,9148,3,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',15540.00,NULL,NULL,1,'2023-04-06 08:51:38','2023-04-06 08:51:38',NULL),(2977,7922,40725,9148,3,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8039.99,NULL,NULL,1,'2023-04-06 08:51:38','2023-04-06 08:51:38',NULL),(2978,7922,40725,9148,3,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8039.99,NULL,NULL,1,'2023-04-06 08:51:38','2023-04-06 08:51:38',NULL),(2979,7922,40725,9148,3,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8039.99,NULL,NULL,1,'2023-04-06 08:51:38','2023-04-06 08:51:38',NULL),(2980,7922,40725,9148,3,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4107.95,NULL,NULL,1,'2023-04-06 08:51:38','2023-04-06 08:51:38',NULL),(2981,7922,40725,9148,3,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',27390.00,NULL,NULL,1,'2023-04-06 08:51:38','2023-04-06 08:51:38',NULL),(2982,7922,40725,9148,3,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8682.45,NULL,NULL,1,'2023-04-06 08:51:38','2023-04-06 08:51:38',NULL),(2983,7922,40725,9148,3,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',22942.50,NULL,NULL,1,'2023-04-06 08:51:38','2023-04-06 08:51:38',NULL),(2984,7922,40725,9148,3,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',11524.48,NULL,NULL,1,'2023-04-06 08:51:38','2023-04-06 08:51:38',NULL),(2985,7922,40725,9148,3,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',5552563.43,NULL,NULL,1,'2023-04-06 08:51:38','2023-04-06 08:51:38',NULL),(2986,7922,40725,9148,3,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',5980.40,NULL,NULL,1,'2023-04-06 08:51:38','2023-04-06 08:51:38',NULL),(2987,7922,40725,9148,3,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2100.00,NULL,NULL,1,'2023-04-06 08:51:38','2023-04-06 08:51:38',NULL),(2988,7922,40725,9148,3,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',363000.00,NULL,NULL,1,'2023-04-06 08:51:38','2023-04-06 08:51:38',NULL),(2989,7922,40725,9149,3,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3400.00,NULL,NULL,1,'2023-04-06 08:52:15','2023-04-06 08:52:15',NULL),(2990,7922,40725,9149,3,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',100590.00,NULL,NULL,1,'2023-04-06 08:52:15','2023-04-06 08:52:15',NULL),(2991,7922,40725,9149,3,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',9800.00,NULL,NULL,1,'2023-04-06 08:52:15','2023-04-06 08:52:15',NULL),(2992,7922,40725,9149,3,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',8040.00,NULL,NULL,1,'2023-04-06 08:52:15','2023-04-06 08:52:15',NULL),(2993,7922,40725,9149,3,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',75050.00,NULL,NULL,1,'2023-04-06 08:52:15','2023-04-06 08:52:15',NULL);
INSERT INTO `balance_libro` VALUES (2994,7922,40725,9149,3,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',82182.00,NULL,NULL,1,'2023-04-06 08:52:15','2023-04-06 08:52:15',NULL),(2995,7922,40725,9149,3,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',7500.00,NULL,NULL,1,'2023-04-06 08:52:15','2023-04-06 08:52:15',NULL),(2996,7922,40725,9149,3,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',350000.00,NULL,NULL,1,'2023-04-06 08:52:15','2023-04-06 08:52:15',NULL),(2997,7922,40725,9149,3,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',4107.95,NULL,NULL,1,'2023-04-06 08:52:15','2023-04-06 08:52:15',NULL),(2998,7922,40725,9149,3,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',36540.00,NULL,NULL,1,'2023-04-06 08:52:15','2023-04-06 08:52:15',NULL),(2999,7922,40725,9149,3,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',9070.16,NULL,NULL,1,'2023-04-06 08:52:15','2023-04-06 08:52:15',NULL),(3000,7922,40725,9149,3,1717,'App\\Models\\Receipt',1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',16062.99,NULL,NULL,1,'2023-04-06 08:52:15','2023-04-06 08:52:15',NULL),(3001,7922,40725,9149,3,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',6697.40,NULL,NULL,1,'2023-04-06 08:52:15','2023-04-06 08:52:15',NULL),(3002,7922,40725,9149,3,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',485737.00,NULL,NULL,1,'2023-04-06 08:52:15','2023-04-06 08:52:15',NULL),(3003,7922,40725,9149,3,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',513.00,NULL,NULL,1,'2023-04-06 08:52:15','2023-04-06 08:52:15',NULL),(3004,7922,40725,9149,3,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2100.00,NULL,NULL,1,'2023-04-06 08:52:15','2023-04-06 08:52:15',NULL),(3005,7922,40725,9149,3,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',49500.00,NULL,NULL,1,'2023-04-06 08:52:15','2023-04-06 08:52:15',NULL),(3006,7922,40725,9150,3,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3400.00,NULL,NULL,1,'2023-04-06 08:52:53','2023-04-06 08:52:53',NULL),(3007,7922,40725,9150,3,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',100000.00,NULL,NULL,1,'2023-04-06 08:52:53','2023-04-06 08:52:53',NULL),(3008,7922,40725,9150,3,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',7500.00,NULL,NULL,1,'2023-04-06 08:52:53','2023-04-06 08:52:53',NULL),(3009,7922,40725,9150,3,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',8040.00,NULL,NULL,1,'2023-04-06 08:52:53','2023-04-06 08:52:53',NULL),(3010,7922,40725,9150,3,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',48667.50,NULL,NULL,1,'2023-04-06 08:52:53','2023-04-06 08:52:53',NULL),(3011,7922,40725,9150,3,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',100000.00,NULL,NULL,1,'2023-04-06 08:52:53','2023-04-06 08:52:53',NULL),(3012,7922,40725,9150,3,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',82182.00,NULL,NULL,1,'2023-04-06 08:52:53','2023-04-06 08:52:53',NULL),(3013,7922,40725,9150,3,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',6560.00,NULL,NULL,1,'2023-04-06 08:52:53','2023-04-06 08:52:53',NULL),(3014,7922,40725,9150,3,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',85050.00,NULL,NULL,1,'2023-04-06 08:52:53','2023-04-06 08:52:53',NULL);
INSERT INTO `balance_libro` VALUES (3015,7922,40725,9150,3,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',4529.03,NULL,NULL,1,'2023-04-06 08:52:54','2023-04-06 08:52:54',NULL),(3016,7922,40725,9150,3,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',2050.00,NULL,NULL,1,'2023-04-06 08:52:54','2023-04-06 08:52:54',NULL),(3017,7922,40725,9150,3,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',3990.00,NULL,NULL,1,'2023-04-06 08:52:54','2023-04-06 08:52:54',NULL),(3018,7922,40725,9150,3,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',74500.00,NULL,NULL,1,'2023-04-06 08:52:54','2023-04-06 08:52:54',NULL),(3019,7922,40725,9150,3,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',3000.00,NULL,NULL,1,'2023-04-06 08:52:54','2023-04-06 08:52:54',NULL),(3020,7922,40725,9150,3,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',25500.00,NULL,NULL,1,'2023-04-06 08:52:54','2023-04-06 08:52:54',NULL),(3021,7922,40725,9150,3,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',102900.00,NULL,NULL,1,'2023-04-06 08:52:54','2023-04-06 08:52:54',NULL),(3022,7922,40725,9150,3,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2100.00,NULL,NULL,1,'2023-04-06 08:52:54','2023-04-06 08:52:54',NULL),(3023,7922,40725,9150,3,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',32916.33,NULL,NULL,1,'2023-04-06 08:52:54','2023-04-06 08:52:54',NULL),(3024,7922,40725,9136,2,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',57600.00,NULL,NULL,1,'2023-04-06 09:03:23','2023-04-06 09:03:23',NULL),(3025,7922,40725,9137,2,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',57600.00,NULL,NULL,1,'2023-04-06 09:04:12','2023-04-06 09:04:12',NULL),(3026,7922,40725,9138,2,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',57600.00,NULL,NULL,1,'2023-04-06 09:04:41','2023-04-06 09:04:41',NULL),(3027,7922,40725,9139,2,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',57600.00,NULL,NULL,1,'2023-04-06 09:05:11','2023-04-06 09:05:11',NULL),(3028,7922,40725,9140,2,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',57600.00,NULL,NULL,1,'2023-04-06 09:05:35','2023-04-06 09:05:35',NULL),(3029,7922,40725,9141,2,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',57600.00,NULL,NULL,1,'2023-04-06 09:06:01','2023-04-06 09:06:01',NULL),(3030,7922,40725,9142,2,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',69120.00,NULL,NULL,1,'2023-04-06 09:06:28','2023-04-06 09:06:28',NULL),(3031,7922,40725,9143,2,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',69120.00,NULL,NULL,1,'2023-04-06 09:06:59','2023-04-06 09:06:59',NULL),(3032,7922,40725,9144,2,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',69120.00,NULL,NULL,1,'2023-04-06 09:07:23','2023-04-06 09:07:23',NULL),(3033,7922,40722,12295,2,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',4800.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3034,7922,40722,12295,2,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',16250.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3035,7922,40722,12295,2,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',6350.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL);
INSERT INTO `balance_libro` VALUES (3036,7922,40722,12295,2,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',4800.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3037,7922,40722,12295,2,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',7000.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3038,7922,40722,12295,2,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',2640.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3039,7922,40722,12295,2,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',7890.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3040,7922,40722,12295,2,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',9870.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3041,7922,40722,12295,2,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',11150.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3042,7922,40722,12295,2,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',1200.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3043,7922,40722,12295,2,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',600.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3044,7922,40722,12295,2,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',2100.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3045,7922,40722,12295,2,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',3340.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3046,7922,40722,12295,2,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',600.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3047,7922,40722,12295,2,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',9000.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3048,7922,40722,12295,2,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',7500.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3049,7922,40722,12295,2,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',14500.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3050,7922,40722,12295,2,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',1800.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3051,7922,40722,12295,2,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',3730.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3052,7922,40722,12295,2,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',1200.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3053,7922,40722,12295,2,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',800.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3054,7922,40722,12295,2,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',660.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3055,7922,40722,12295,2,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',660.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3056,7922,40722,12295,2,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1100.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL);
INSERT INTO `balance_libro` VALUES (3057,7922,40722,12295,2,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',6000.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3058,7922,40722,12295,2,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',2400.00,NULL,NULL,1,'2023-04-06 09:56:39','2023-04-06 09:56:39',NULL),(3059,7922,40722,12296,2,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1200.00,NULL,NULL,1,'2023-04-07 08:20:57','2023-04-07 08:20:57',NULL),(3060,7922,40722,12296,2,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',600.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3061,7922,40722,12296,2,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',4200.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3062,7922,40722,12296,2,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',4950.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3063,7922,40722,12296,2,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',11150.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3064,7922,40722,12296,2,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',1200.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3065,7922,40722,12296,2,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',23000.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3066,7922,40722,12296,2,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',12500.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3067,7922,40722,12296,2,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',600.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3068,7922,40722,12296,2,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',2150.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3069,7922,40722,12296,2,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',550.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3070,7922,40722,12296,2,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',3850.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3071,7922,40722,12296,2,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',2000.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3072,7922,40722,12296,2,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',22100.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3073,7922,40722,12296,2,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',600.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3074,7922,40722,12296,2,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',1200.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3075,7922,40722,12296,2,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',800.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3076,7922,40722,12296,2,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',2100.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3077,7922,40722,12296,2,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',2460.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL);
INSERT INTO `balance_libro` VALUES (3078,7922,40722,12296,2,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',980.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3079,7922,40722,12296,2,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',600.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3080,7922,40722,12296,2,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',10500.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3081,7922,40722,12296,2,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',990.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3082,7922,40722,12296,2,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',890.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3083,7922,40722,12296,2,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',980.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3084,7922,40722,12296,2,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',10800.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3085,7922,40722,12296,2,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',7800.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3086,7922,40722,12296,2,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',8900.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3087,7922,40722,12296,2,1804,'App\\Models\\Receipt',1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',8960.00,NULL,NULL,1,'2023-04-07 08:20:58','2023-04-07 08:20:58',NULL),(3088,7922,40722,12296,2,1805,'App\\Models\\Receipt',1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',1600.00,NULL,NULL,1,'2023-04-07 08:21:48','2023-04-07 08:21:48',NULL),(3089,7922,40722,12296,2,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',2200.00,NULL,NULL,1,'2023-04-07 08:21:48','2023-04-07 08:21:48',NULL),(3090,7922,40722,12296,2,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',3210.00,NULL,NULL,1,'2023-04-07 08:21:48','2023-04-07 08:21:48',NULL),(3091,7922,40722,12296,2,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',3300.00,NULL,NULL,1,'2023-04-07 08:21:48','2023-04-07 08:21:48',NULL),(3092,7922,40722,12296,2,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',2600.00,NULL,NULL,1,'2023-04-07 08:21:48','2023-04-07 08:21:48',NULL),(3093,7922,40722,12296,2,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-18','2022-05-18',10000.00,NULL,NULL,1,'2023-04-07 08:21:48','2023-04-07 08:21:48',NULL),(3094,7922,40722,12296,2,1811,'App\\Models\\Receipt',1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',17500.00,NULL,NULL,1,'2023-04-07 08:21:48','2023-04-07 08:21:48',NULL),(3095,7922,40722,12296,2,1812,'App\\Models\\Receipt',1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',18200.00,NULL,NULL,1,'2023-04-07 08:21:49','2023-04-07 08:21:49',NULL),(3096,7922,40722,12296,2,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',700.00,NULL,NULL,1,'2023-04-07 08:21:49','2023-04-07 08:21:49',NULL),(3097,7922,40722,12297,2,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',5600.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3098,7922,40722,12297,2,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',1400.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL);
INSERT INTO `balance_libro` VALUES (3099,7922,40722,12297,2,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',1200.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3100,7922,40722,12297,2,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',5800.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3101,7922,40722,12297,2,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',9800.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3102,7922,40722,12297,2,1819,'App\\Models\\Receipt',1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',3520.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3103,7922,40722,12297,2,1820,'App\\Models\\Receipt',1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',10650.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3104,7922,40722,12297,2,1821,'App\\Models\\Receipt',1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',4500.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3105,7922,40722,12297,2,1822,'App\\Models\\Receipt',1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',3320.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3106,7922,40722,12297,2,1823,'App\\Models\\Receipt',1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',8500.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3107,7922,40722,12297,2,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',15200.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3108,7922,40722,12297,2,1825,'App\\Models\\Receipt',1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',1320.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3109,7922,40722,12297,2,1826,'App\\Models\\Receipt',1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',15200.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3110,7922,40722,12297,2,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',2850.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3111,7922,40722,12297,2,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',3200.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3112,7922,40722,12297,2,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',8470.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3113,7922,40722,12297,2,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',1600.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3114,7922,40722,12297,2,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',5580.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3115,7922,40722,12297,2,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',900.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3116,7922,40722,12297,2,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',1260.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3117,7922,40722,12297,2,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',660.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3118,7922,40722,12297,2,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',5280.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3119,7922,40722,12297,2,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',900.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL);
INSERT INTO `balance_libro` VALUES (3120,7922,40722,12297,2,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',1800.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3121,7922,40722,12297,2,1838,'App\\Models\\Receipt',1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',700.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3122,7922,40722,12297,2,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',2800.00,NULL,NULL,1,'2023-04-07 08:22:14','2023-04-07 08:22:14',NULL),(3123,7922,40722,12299,2,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',1200.00,NULL,NULL,1,'2023-04-07 08:22:54','2023-04-07 08:22:54',NULL),(3124,7922,40722,12299,2,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',3600.00,NULL,NULL,1,'2023-04-07 08:22:54','2023-04-07 08:22:54',NULL),(3125,7922,40722,12299,2,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',2700.00,NULL,NULL,1,'2023-04-07 08:22:54','2023-04-07 08:22:54',NULL),(3126,7922,40722,12299,2,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',1500.00,NULL,NULL,1,'2023-04-07 08:22:54','2023-04-07 08:22:54',NULL),(3127,7922,40722,12299,2,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',4570.00,NULL,NULL,1,'2023-04-07 08:22:54','2023-04-07 08:22:54',NULL),(3128,7922,40722,12299,2,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',700.00,NULL,NULL,1,'2023-04-07 08:22:54','2023-04-07 08:22:54',NULL),(3129,7922,40722,12299,2,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',800.00,NULL,NULL,1,'2023-04-07 08:22:54','2023-04-07 08:22:54',NULL),(3130,7922,40722,12299,2,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',800.00,NULL,NULL,1,'2023-04-07 08:22:54','2023-04-07 08:22:54',NULL),(3131,7922,40722,12299,2,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',1400.00,NULL,NULL,1,'2023-04-07 08:22:54','2023-04-07 08:22:54',NULL),(3132,7922,40722,12299,2,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',3730.00,NULL,NULL,1,'2023-04-07 08:22:54','2023-04-07 08:22:54',NULL),(3133,7922,40722,12299,2,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',3400.00,NULL,NULL,1,'2023-04-07 08:22:54','2023-04-07 08:22:54',NULL),(3134,7922,40722,12299,2,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',700.00,NULL,NULL,1,'2023-04-07 08:22:54','2023-04-07 08:22:54',NULL),(3135,7922,40722,12299,2,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',700.00,NULL,NULL,1,'2023-04-07 08:22:54','2023-04-07 08:22:54',NULL),(3136,7922,40722,12299,2,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',700.00,NULL,NULL,1,'2023-04-07 08:22:54','2023-04-07 08:22:54',NULL),(3137,7922,40722,12299,2,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',2900.00,NULL,NULL,1,'2023-04-07 08:22:54','2023-04-07 08:22:54',NULL),(3138,7922,40722,12299,2,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',3670.00,NULL,NULL,1,'2023-04-07 08:22:54','2023-04-07 08:22:54',NULL),(3139,7922,40722,12299,2,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',4480.00,NULL,NULL,1,'2023-04-07 08:22:55','2023-04-07 08:22:55',NULL),(3140,7922,40722,12299,2,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',1400.00,NULL,NULL,1,'2023-04-07 08:22:55','2023-04-07 08:22:55',NULL);
INSERT INTO `balance_libro` VALUES (3141,7922,40722,12299,2,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',42000.00,NULL,NULL,1,'2023-04-07 08:22:55','2023-04-07 08:22:55',NULL),(3142,7922,40722,12299,2,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',5400.00,NULL,NULL,1,'2023-04-07 08:22:55','2023-04-07 08:22:55',NULL),(3143,7922,40722,12299,2,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',38300.00,NULL,NULL,1,'2023-04-07 08:22:55','2023-04-07 08:22:55',NULL),(3144,7922,40722,12299,2,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',14400.00,NULL,NULL,1,'2023-04-07 08:22:55','2023-04-07 08:22:55',NULL),(3145,7922,40722,12299,2,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1150.00,NULL,NULL,1,'2023-04-07 08:22:55','2023-04-07 08:22:55',NULL),(3146,7922,40722,12299,2,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',700.00,NULL,NULL,1,'2023-04-07 08:22:55','2023-04-07 08:22:55',NULL),(3147,7922,40722,12300,2,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',900.00,NULL,NULL,1,'2023-04-07 08:23:16','2023-04-07 08:23:16',NULL),(3148,7922,40722,12300,2,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',4200.00,NULL,NULL,1,'2023-04-07 08:23:16','2023-04-07 08:23:16',NULL),(3149,7922,40722,12300,2,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',700.00,NULL,NULL,1,'2023-04-07 08:23:16','2023-04-07 08:23:16',NULL),(3150,7922,40722,12300,2,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',3600.00,NULL,NULL,1,'2023-04-07 08:23:16','2023-04-07 08:23:16',NULL),(3151,7922,40722,12300,2,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',10600.00,NULL,NULL,1,'2023-04-07 08:23:16','2023-04-07 08:23:16',NULL),(3152,7922,40722,12300,2,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',2100.00,NULL,NULL,1,'2023-04-07 08:23:16','2023-04-07 08:23:16',NULL),(3153,7922,40722,12300,2,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',700.00,NULL,NULL,1,'2023-04-07 08:23:16','2023-04-07 08:23:16',NULL),(3154,7922,40722,12300,2,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',700.00,NULL,NULL,1,'2023-04-07 08:23:16','2023-04-07 08:23:16',NULL),(3155,7922,40722,12300,2,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',6180.00,NULL,NULL,1,'2023-04-07 08:23:16','2023-04-07 08:23:16',NULL),(3156,7922,40722,12300,2,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',5300.00,NULL,NULL,1,'2023-04-07 08:23:16','2023-04-07 08:23:16',NULL),(3157,7922,40722,12300,2,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',6100.00,NULL,NULL,1,'2023-04-07 08:23:16','2023-04-07 08:23:16',NULL),(3158,7922,40722,12300,2,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',2250.00,NULL,NULL,1,'2023-04-07 08:23:16','2023-04-07 08:23:16',NULL),(3159,7922,40722,12300,2,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',700.00,NULL,NULL,1,'2023-04-07 08:23:16','2023-04-07 08:23:16',NULL),(3160,7922,40722,12300,2,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',800.00,NULL,NULL,1,'2023-04-07 08:23:16','2023-04-07 08:23:16',NULL),(3161,7922,40722,12300,2,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',800.00,NULL,NULL,1,'2023-04-07 08:23:16','2023-04-07 08:23:16',NULL);
INSERT INTO `balance_libro` VALUES (3162,7922,40722,12300,2,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',4000.00,NULL,NULL,1,'2023-04-07 08:23:16','2023-04-07 08:23:16',NULL),(3163,7922,40722,12300,2,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',600.00,NULL,NULL,1,'2023-04-07 08:23:16','2023-04-07 08:23:16',NULL),(3164,7922,40722,12301,2,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',23000.00,NULL,NULL,1,'2023-04-07 08:23:57','2023-04-07 08:23:57',NULL),(3165,7922,40722,12301,2,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',2100.00,NULL,NULL,1,'2023-04-07 08:23:57','2023-04-07 08:23:57',NULL),(3166,7922,40722,12301,2,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',600.00,NULL,NULL,1,'2023-04-07 08:23:57','2023-04-07 08:23:57',NULL),(3167,7922,40722,12301,2,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',4200.00,NULL,NULL,1,'2023-04-07 08:23:57','2023-04-07 08:23:57',NULL),(3168,7922,40722,12301,2,1885,'App\\Models\\Receipt',1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',12810.00,NULL,NULL,1,'2023-04-07 08:23:57','2023-04-07 08:23:57',NULL),(3169,7922,40722,12301,2,1886,'App\\Models\\Receipt',1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',9000.00,NULL,NULL,1,'2023-04-07 08:23:57','2023-04-07 08:23:57',NULL),(3170,7922,40722,12301,2,1887,'App\\Models\\Receipt',1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',800.00,NULL,NULL,1,'2023-04-07 08:23:57','2023-04-07 08:23:57',NULL),(3171,7922,40722,12301,2,1888,'App\\Models\\Receipt',1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',800.00,NULL,NULL,1,'2023-04-07 08:23:57','2023-04-07 08:23:57',NULL),(3172,7922,40722,12301,2,1889,'App\\Models\\Receipt',1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1400.00,NULL,NULL,1,'2023-04-07 08:23:57','2023-04-07 08:23:57',NULL),(3173,7922,40722,12301,2,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',800.00,NULL,NULL,1,'2023-04-07 08:23:57','2023-04-07 08:23:57',NULL),(3174,7922,40722,12301,2,1891,'App\\Models\\Receipt',1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',13500.00,NULL,NULL,1,'2023-04-07 08:23:57','2023-04-07 08:23:57',NULL),(3175,7922,40722,12301,2,1892,'App\\Models\\Receipt',1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',12500.00,NULL,NULL,1,'2023-04-07 08:23:57','2023-04-07 08:23:57',NULL),(3176,7922,40722,12301,2,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2400.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3177,7922,40722,12301,2,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',800.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3178,7922,40722,12301,2,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2300.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3179,7922,40722,12301,2,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1400.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3180,7922,40722,12301,2,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1500.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3181,7922,40722,12301,2,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',800.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3182,7922,40722,12301,2,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',5100.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL);
INSERT INTO `balance_libro` VALUES (3183,7922,40722,12301,2,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',800.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3184,7922,40722,12301,2,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',4580.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3185,7922,40722,12301,2,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',15350.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3186,7922,40722,12301,2,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',980.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3187,7922,40722,12301,2,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',400.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3188,7922,40722,12301,2,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',15500.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3189,7922,40722,12301,2,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',25500.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3190,7922,40722,12301,2,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1500.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3191,7922,40722,12301,2,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1500.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3192,7922,40722,12301,2,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',17500.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3193,7922,40722,12301,2,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',6300.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3194,7922,40722,12301,2,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',5650.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3195,7922,40722,12301,2,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',8200.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3196,7922,40722,12301,2,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',25000.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3197,7922,40722,12301,2,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2400.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3198,7922,40722,12301,2,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',6800.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3199,7922,40722,12301,2,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1500.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3200,7922,40722,12301,2,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2900.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3201,7922,40722,12301,2,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1500.00,NULL,NULL,1,'2023-04-07 08:23:58','2023-04-07 08:23:58',NULL),(3202,7922,40722,12302,2,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',5100.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3203,7922,40722,12302,2,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1200.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL);
INSERT INTO `balance_libro` VALUES (3204,7922,40722,12302,2,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',4000.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3205,7922,40722,12302,2,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',21800.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3206,7922,40722,12302,2,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',2800.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3207,7922,40722,12302,2,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',700.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3208,7922,40722,12302,2,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',900.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3209,7922,40722,12302,2,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',14400.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3210,7922,40722,12302,2,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',1600.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3211,7922,40722,12302,2,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',700.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3212,7922,40722,12302,2,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',6700.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3213,7922,40722,12302,2,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',800.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3214,7922,40722,12302,2,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',2100.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3215,7922,40722,12302,2,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',3930.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3216,7922,40722,12302,2,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',700.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3217,7922,40722,12302,2,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',900.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3218,7922,40722,12302,2,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',1500.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3219,7922,40722,12302,2,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',700.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3220,7922,40722,12302,2,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',700.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3221,7922,40722,12302,2,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',21000.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3222,7922,40722,12302,2,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',21500.00,NULL,NULL,1,'2023-04-07 08:24:26','2023-04-07 08:24:26',NULL),(3223,7922,40722,12302,2,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',21500.00,NULL,NULL,1,'2023-04-07 08:24:27','2023-04-07 08:24:27',NULL),(3224,7922,40722,12302,2,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',25500.00,NULL,NULL,1,'2023-04-07 08:24:27','2023-04-07 08:24:27',NULL);
INSERT INTO `balance_libro` VALUES (3225,7922,40722,12302,2,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',21500.00,NULL,NULL,1,'2023-04-07 08:24:27','2023-04-07 08:24:27',NULL),(3226,7922,40722,12302,2,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',21500.00,NULL,NULL,1,'2023-04-07 08:24:27','2023-04-07 08:24:27',NULL),(3227,7922,40722,12302,2,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',21500.00,NULL,NULL,1,'2023-04-07 08:24:27','2023-04-07 08:24:27',NULL),(3228,7922,40722,12302,2,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',21500.00,NULL,NULL,1,'2023-04-07 08:24:27','2023-04-07 08:24:27',NULL),(3229,7922,40722,12302,2,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',10200.00,NULL,NULL,1,'2023-04-07 08:24:27','2023-04-07 08:24:27',NULL),(3230,7922,40722,12302,2,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',5900.00,NULL,NULL,1,'2023-04-07 08:24:27','2023-04-07 08:24:27',NULL),(3231,7922,40722,12302,2,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',1200.00,NULL,NULL,1,'2023-04-07 08:24:27','2023-04-07 08:24:27',NULL),(3232,7922,40722,12302,2,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1500.00,NULL,NULL,1,'2023-04-07 08:24:27','2023-04-07 08:24:27',NULL),(3233,7922,40722,12302,2,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',35500.00,NULL,NULL,1,'2023-04-07 08:24:27','2023-04-07 08:24:27',NULL),(3234,7922,40722,12302,2,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',25500.00,NULL,NULL,1,'2023-04-07 08:24:27','2023-04-07 08:24:27',NULL),(3235,7922,40722,12302,2,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',17350.00,NULL,NULL,1,'2023-04-07 08:24:27','2023-04-07 08:24:27',NULL),(3236,7922,40722,12302,2,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',15400.00,NULL,NULL,1,'2023-04-07 08:24:27','2023-04-07 08:24:27',NULL),(3237,7922,40722,12302,2,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',21500.00,NULL,NULL,1,'2023-04-07 08:24:27','2023-04-07 08:24:27',NULL),(3238,7922,40722,12302,2,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',19500.00,NULL,NULL,1,'2023-04-07 08:24:27','2023-04-07 08:24:27',NULL),(3239,7922,40722,12302,2,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',20500.00,NULL,NULL,1,'2023-04-07 08:24:27','2023-04-07 08:24:27',NULL),(3240,7922,40722,12303,2,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',3500.00,NULL,NULL,1,'2023-04-07 08:24:47','2023-04-07 08:24:47',NULL),(3241,7922,40722,12303,2,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',800.00,NULL,NULL,1,'2023-04-07 08:24:47','2023-04-07 08:24:47',NULL),(3242,7922,40722,12303,2,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2800.00,NULL,NULL,1,'2023-04-07 08:24:47','2023-04-07 08:24:47',NULL),(3243,7922,40722,12303,2,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2500.00,NULL,NULL,1,'2023-04-07 08:24:47','2023-04-07 08:24:47',NULL),(3244,7922,40722,12303,2,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',6000.00,NULL,NULL,1,'2023-04-07 08:24:47','2023-04-07 08:24:47',NULL),(3245,7922,40722,12303,2,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',2900.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL);
INSERT INTO `balance_libro` VALUES (3246,7922,40722,12303,2,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',1500.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3247,7922,40722,12303,2,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',1700.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3248,7922,40722,12303,2,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',1400.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3249,7922,40722,12303,2,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',700.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3250,7922,40722,12303,2,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',4800.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3251,7922,40722,12303,2,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',6000.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3252,7922,40722,12303,2,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',700.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3253,7922,40722,12303,2,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',4000.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3254,7922,40722,12303,2,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1500.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3255,7922,40722,12303,2,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',700.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3256,7922,40722,12303,2,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1800.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3257,7922,40722,12303,2,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',4600.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3258,7922,40722,12303,2,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2000.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3259,7922,40722,12303,2,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',700.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3260,7922,40722,12303,2,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',14500.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3261,7922,40722,12303,2,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',7400.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3262,7922,40722,12303,2,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',19000.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3263,7922,40722,12303,2,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',4400.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3264,7922,40722,12303,2,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3400.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3265,7922,40722,12303,2,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',15300.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3266,7922,40722,12303,2,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',13600.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL);
INSERT INTO `balance_libro` VALUES (3267,7922,40722,12303,2,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',5600.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3268,7922,40722,12303,2,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',18200.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3269,7922,40722,12303,2,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',20500.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3270,7922,40722,12303,2,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',20800.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3271,7922,40722,12303,2,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',18800.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3272,7922,40722,12303,2,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',20180.00,NULL,NULL,1,'2023-04-07 08:24:48','2023-04-07 08:24:48',NULL),(3273,7922,40722,12303,2,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',10000.00,NULL,NULL,1,'2023-04-07 08:24:49','2023-04-07 08:24:49',NULL),(3274,7922,40722,12303,2,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',19000.00,NULL,NULL,1,'2023-04-07 08:24:49','2023-04-07 08:24:49',NULL),(3275,7922,40722,12303,2,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',13800.00,NULL,NULL,1,'2023-04-07 08:24:49','2023-04-07 08:24:49',NULL),(3276,7922,40722,12303,2,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',20950.00,NULL,NULL,1,'2023-04-07 08:24:49','2023-04-07 08:24:49',NULL),(3277,7922,40722,12303,2,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',17400.00,NULL,NULL,1,'2023-04-07 08:24:49','2023-04-07 08:24:49',NULL),(3278,7922,40722,12303,2,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',800.00,NULL,NULL,1,'2023-04-07 08:24:49','2023-04-07 08:24:49',NULL),(3279,7922,40722,12303,2,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1780.00,NULL,NULL,1,'2023-04-07 08:24:49','2023-04-07 08:24:49',NULL),(3280,7922,40722,12303,2,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',800.00,NULL,NULL,1,'2023-04-07 08:24:49','2023-04-07 08:24:49',NULL),(3281,7922,40722,12303,2,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',4180.00,NULL,NULL,1,'2023-04-07 08:24:49','2023-04-07 08:24:49',NULL),(3282,7922,40722,12303,2,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',7040.00,NULL,NULL,1,'2023-04-07 08:24:49','2023-04-07 08:24:49',NULL),(3283,7922,40722,12303,2,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',13700.00,NULL,NULL,1,'2023-04-07 08:24:49','2023-04-07 08:24:49',NULL),(3284,7922,40722,12303,2,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2000.00,NULL,NULL,1,'2023-04-07 08:24:49','2023-04-07 08:24:49',NULL),(3285,7922,40722,12303,2,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3200.00,NULL,NULL,1,'2023-04-07 08:24:49','2023-04-07 08:24:49',NULL),(3286,7922,40722,12303,2,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2800.00,NULL,NULL,1,'2023-04-07 08:24:49','2023-04-07 08:24:49',NULL),(3287,7922,40722,12303,2,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3000.00,NULL,NULL,1,'2023-04-07 08:24:49','2023-04-07 08:24:49',NULL);
INSERT INTO `balance_libro` VALUES (3288,7922,40722,12303,2,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',21000.00,NULL,NULL,1,'2023-04-07 08:24:49','2023-04-07 08:24:49',NULL),(3289,7922,40722,12303,2,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',21100.00,NULL,NULL,1,'2023-04-07 08:24:49','2023-04-07 08:24:49',NULL),(3290,7922,40722,12303,2,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',160000.00,NULL,NULL,1,'2023-04-07 08:24:49','2023-04-07 08:24:49',NULL),(3291,7922,40722,12307,2,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8100.00,NULL,NULL,1,'2023-04-07 08:25:11','2023-04-07 08:25:11',NULL),(3292,7922,40722,12307,2,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2400.00,NULL,NULL,1,'2023-04-07 08:25:11','2023-04-07 08:25:11',NULL),(3293,7922,40722,12307,2,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1800.00,NULL,NULL,1,'2023-04-07 08:25:12','2023-04-07 08:25:12',NULL),(3294,7922,40722,12307,2,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1800.00,NULL,NULL,1,'2023-04-07 08:25:12','2023-04-07 08:25:12',NULL),(3295,7922,40722,12307,2,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',800.00,NULL,NULL,1,'2023-04-07 08:25:12','2023-04-07 08:25:12',NULL),(3296,7922,40722,12307,2,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',7000.00,NULL,NULL,1,'2023-04-07 08:25:12','2023-04-07 08:25:12',NULL),(3297,7922,40722,12307,2,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1200.00,NULL,NULL,1,'2023-04-07 08:25:12','2023-04-07 08:25:12',NULL),(3298,7922,40722,12307,2,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',25500.00,NULL,NULL,1,'2023-04-07 08:25:12','2023-04-07 08:25:12',NULL),(3299,7922,40722,12307,2,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3200.00,NULL,NULL,1,'2023-04-07 08:25:12','2023-04-07 08:25:12',NULL),(3300,7922,40722,12307,2,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1000.00,NULL,NULL,1,'2023-04-07 08:25:12','2023-04-07 08:25:12',NULL),(3301,7922,40722,12307,2,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2000.00,NULL,NULL,1,'2023-04-07 08:25:12','2023-04-07 08:25:12',NULL),(3302,7922,40722,12307,2,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6200.00,NULL,NULL,1,'2023-04-07 08:25:12','2023-04-07 08:25:12',NULL),(3303,7922,40722,12307,2,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',23800.00,NULL,NULL,1,'2023-04-07 08:25:12','2023-04-07 08:25:12',NULL),(3304,7922,40722,12307,2,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',15000.00,NULL,NULL,1,'2023-04-07 08:25:12','2023-04-07 08:25:12',NULL),(3305,7922,40722,12307,2,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',53800.00,NULL,NULL,1,'2023-04-07 08:25:12','2023-04-07 08:25:12',NULL),(3306,7922,40722,12307,2,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3000.00,NULL,NULL,1,'2023-04-07 08:25:12','2023-04-07 08:25:12',NULL),(3307,7922,40722,4549,2,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',44900.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3308,7922,40722,4549,2,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1000.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL);
INSERT INTO `balance_libro` VALUES (3309,7922,40722,4549,2,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2000.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3310,7922,40722,4549,2,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',9700.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3311,7922,40722,4549,2,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',29000.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3312,7922,40722,4549,2,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',4000.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3313,7922,40722,4549,2,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1500.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3314,7922,40722,4549,2,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',6500.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3315,7922,40722,4549,2,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',3200.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3316,7922,40722,4549,2,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',5200.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3317,7922,40722,4549,2,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',3800.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3318,7922,40722,4549,2,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',2000.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3319,7922,40722,4549,2,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',2800.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3320,7922,40722,4549,2,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',22500.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3321,7922,40722,4549,2,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',18500.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3322,7922,40722,4549,2,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',17500.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3323,7922,40722,4549,2,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1000.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3324,7922,40722,4549,2,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',14200.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3325,7922,40722,4549,2,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',4000.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3326,7922,40722,4549,2,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',12200.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3327,7922,40722,4549,2,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1000.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3328,7922,40722,4549,2,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1000.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3329,7922,40722,4549,2,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1500.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL);
INSERT INTO `balance_libro` VALUES (3330,7922,40722,4549,2,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',14200.00,NULL,NULL,1,'2023-04-07 08:25:33','2023-04-07 08:25:33',NULL),(3331,7922,40722,4549,2,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',4000.00,NULL,NULL,1,'2023-04-07 08:25:34','2023-04-07 08:25:34',NULL),(3332,7922,40722,4549,2,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',18000.00,NULL,NULL,1,'2023-04-07 08:25:34','2023-04-07 08:25:34',NULL),(3333,7922,40722,4549,2,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1200.00,NULL,NULL,1,'2023-04-07 08:25:34','2023-04-07 08:25:34',NULL),(3334,7922,40722,4549,2,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',19500.00,NULL,NULL,1,'2023-04-07 08:25:34','2023-04-07 08:25:34',NULL),(3335,7922,40722,4549,2,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',20840.00,NULL,NULL,1,'2023-04-07 08:25:34','2023-04-07 08:25:34',NULL),(3336,7922,40722,4549,2,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',19850.00,NULL,NULL,1,'2023-04-07 08:25:34','2023-04-07 08:25:34',NULL),(3337,7922,40722,4549,2,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',28500.00,NULL,NULL,1,'2023-04-07 08:25:34','2023-04-07 08:25:34',NULL),(3338,7922,40722,4549,2,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',22560.00,NULL,NULL,1,'2023-04-07 08:25:34','2023-04-07 08:25:34',NULL),(3339,7922,40722,4549,2,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',21200.00,NULL,NULL,1,'2023-04-07 08:25:34','2023-04-07 08:25:34',NULL),(3340,7922,40722,4549,2,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',16800.00,NULL,NULL,1,'2023-04-07 08:25:34','2023-04-07 08:25:34',NULL),(3341,7922,40722,4549,2,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',19850.00,NULL,NULL,1,'2023-04-07 08:25:34','2023-04-07 08:25:34',NULL),(3342,7922,40722,4549,2,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',18300.00,NULL,NULL,1,'2023-04-07 08:25:34','2023-04-07 08:25:34',NULL),(3343,7922,40722,4549,2,2060,'App\\Models\\Receipt',2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',4400.00,NULL,NULL,1,'2023-04-07 08:25:34','2023-04-07 08:25:34',NULL),(3344,7922,40722,4549,2,2061,'App\\Models\\Receipt',2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1400.00,NULL,NULL,1,'2023-04-07 08:25:34','2023-04-07 08:25:34',NULL),(3345,7922,40722,4549,2,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1000.00,NULL,NULL,1,'2023-04-07 08:25:34','2023-04-07 08:25:34',NULL),(3346,7922,40722,4549,2,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',3500.00,NULL,NULL,1,'2023-04-07 08:25:34','2023-04-07 08:25:34',NULL),(3347,7922,40722,4549,2,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',15500.00,NULL,NULL,1,'2023-04-07 08:25:34','2023-04-07 08:25:34',NULL),(3348,7922,40722,4550,2,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',6000.00,NULL,NULL,1,'2023-04-07 08:25:56','2023-04-07 08:25:56',NULL),(3349,7922,40722,4550,2,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',1200.00,NULL,NULL,1,'2023-04-07 08:25:56','2023-04-07 08:25:56',NULL),(3350,7922,40722,4550,2,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2000.00,NULL,NULL,1,'2023-04-07 08:25:56','2023-04-07 08:25:56',NULL);
INSERT INTO `balance_libro` VALUES (3351,7922,40722,4550,2,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',6500.00,NULL,NULL,1,'2023-04-07 08:25:56','2023-04-07 08:25:56',NULL),(3352,7922,40722,4550,2,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',1500.00,NULL,NULL,1,'2023-04-07 08:25:56','2023-04-07 08:25:56',NULL),(3353,7922,40722,4550,2,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',98000.00,NULL,NULL,1,'2023-04-07 08:25:56','2023-04-07 08:25:56',NULL),(3354,7922,40722,4550,2,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',22400.00,NULL,NULL,1,'2023-04-07 08:25:56','2023-04-07 08:25:56',NULL),(3355,7922,40722,4550,2,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',1200.00,NULL,NULL,1,'2023-04-07 08:25:56','2023-04-07 08:25:56',NULL),(3356,7922,40722,4550,2,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',1000.00,NULL,NULL,1,'2023-04-07 08:25:56','2023-04-07 08:25:56',NULL),(3357,7922,40722,4550,2,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',2200.00,NULL,NULL,1,'2023-04-07 08:25:56','2023-04-07 08:25:56',NULL),(3358,7922,40722,4550,2,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',20000.00,NULL,NULL,1,'2023-04-07 08:25:56','2023-04-07 08:25:56',NULL),(3359,7922,40722,4550,2,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',2000.00,NULL,NULL,1,'2023-04-07 08:25:56','2023-04-07 08:25:56',NULL),(3360,7922,40722,4550,2,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4000.00,NULL,NULL,1,'2023-04-07 08:25:56','2023-04-07 08:25:56',NULL),(3361,7922,40722,4550,2,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',2000.00,NULL,NULL,1,'2023-04-07 08:25:56','2023-04-07 08:25:56',NULL),(3362,7922,40722,4550,2,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1400.00,NULL,NULL,1,'2023-04-07 08:25:57','2023-04-07 08:25:57',NULL),(3363,7922,40722,4550,2,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',1500.00,NULL,NULL,1,'2023-04-07 08:25:57','2023-04-07 08:25:57',NULL),(3364,7922,40722,4550,2,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',7600.00,NULL,NULL,1,'2023-04-07 08:25:57','2023-04-07 08:25:57',NULL),(3365,7922,40722,4550,2,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',800.00,NULL,NULL,1,'2023-04-07 08:25:57','2023-04-07 08:25:57',NULL),(3366,7922,40722,4550,2,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',4000.00,NULL,NULL,1,'2023-04-07 08:25:57','2023-04-07 08:25:57',NULL),(3367,7922,40722,4550,2,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',500.00,NULL,NULL,1,'2023-04-07 08:25:57','2023-04-07 08:25:57',NULL),(3368,7922,40722,4550,2,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',19000.00,NULL,NULL,1,'2023-04-07 08:25:57','2023-04-07 08:25:57',NULL),(3369,7922,40722,4550,2,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',2400.00,NULL,NULL,1,'2023-04-07 08:25:57','2023-04-07 08:25:57',NULL),(3370,7922,40722,4550,2,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',30500.00,NULL,NULL,1,'2023-04-07 08:25:57','2023-04-07 08:25:57',NULL),(3371,7922,40722,4550,2,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',30500.00,NULL,NULL,1,'2023-04-07 08:25:57','2023-04-07 08:25:57',NULL);
INSERT INTO `balance_libro` VALUES (3372,7922,40722,4550,2,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',25200.00,NULL,NULL,1,'2023-04-07 08:25:57','2023-04-07 08:25:57',NULL),(3373,7922,40722,4550,2,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',700.00,NULL,NULL,1,'2023-04-07 08:25:57','2023-04-07 08:25:57',NULL),(3374,7922,40722,4550,2,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',3600.00,NULL,NULL,1,'2023-04-07 08:25:57','2023-04-07 08:25:57',NULL),(3375,7922,40722,4550,2,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',2800.00,NULL,NULL,1,'2023-04-07 08:25:57','2023-04-07 08:25:57',NULL),(3376,7922,40722,4550,2,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',60000.00,NULL,NULL,1,'2023-04-07 08:25:57','2023-04-07 08:25:57',NULL),(3377,7922,40722,4550,2,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',9600.00,NULL,NULL,1,'2023-04-07 08:25:57','2023-04-07 08:25:57',NULL),(3378,7922,40722,12298,2,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2950.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3379,7922,40722,12298,2,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1580.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3380,7922,40722,12298,2,2097,'App\\Models\\Receipt',2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',700.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3381,7922,40722,12298,2,2098,'App\\Models\\Receipt',2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4000.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3382,7922,40722,12298,2,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2400.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3383,7922,40722,12298,2,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4680.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3384,7922,40722,12298,2,2101,'App\\Models\\Receipt',2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',4900.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3385,7922,40722,12298,2,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',660.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3386,7922,40722,12298,2,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',7500.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3387,7922,40722,12298,2,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1650.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3388,7922,40722,12298,2,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',15800.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3389,7922,40722,12298,2,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',10800.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3390,7922,40722,12298,2,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',1900.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3391,7922,40722,12298,2,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',700.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3392,7922,40722,12298,2,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',700.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL);
INSERT INTO `balance_libro` VALUES (3393,7922,40722,12298,2,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',1600.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3394,7922,40722,12298,2,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',9470.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3395,7922,40722,12298,2,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',800.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3396,7922,40722,12298,2,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1800.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3397,7922,40722,12298,2,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2400.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3398,7922,40722,12298,2,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',4900.00,NULL,NULL,1,'2023-04-07 08:27:24','2023-04-07 08:27:24',NULL),(3399,7922,40723,6063,2,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1140.04,NULL,NULL,1,'2023-04-07 08:33:00','2023-04-07 08:33:00',NULL),(3400,7922,40723,6063,2,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',2368.03,NULL,NULL,1,'2023-04-07 08:33:00','2023-04-07 08:33:00',NULL),(3401,7922,40723,6063,2,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',3350.04,NULL,NULL,1,'2023-04-07 08:33:00','2023-04-07 08:33:00',NULL),(3402,7922,40723,6063,2,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',3680.01,NULL,NULL,1,'2023-04-07 08:33:00','2023-04-07 08:33:00',NULL),(3403,7922,40723,6063,2,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',3680.01,NULL,NULL,1,'2023-04-07 08:33:00','2023-04-07 08:33:00',NULL),(3404,7922,40723,6063,2,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',4680.04,NULL,NULL,1,'2023-04-07 08:33:00','2023-04-07 08:33:00',NULL),(3405,7922,40723,6063,2,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',7010.96,NULL,NULL,1,'2023-04-07 08:33:00','2023-04-07 08:33:00',NULL),(3406,7922,40723,6063,2,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',2144.96,NULL,NULL,1,'2023-04-07 08:33:00','2023-04-07 08:33:00',NULL),(3407,7922,40723,6063,2,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',890.00,NULL,NULL,1,'2023-04-07 08:33:00','2023-04-07 08:33:00',NULL),(3408,7922,40723,6063,2,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',2200.00,NULL,NULL,1,'2023-04-07 08:33:00','2023-04-07 08:33:00',NULL),(3409,7922,40723,6063,2,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',6860.05,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3410,7922,40723,6063,2,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',19147.55,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3411,7922,40723,6063,2,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',60305.01,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3412,7922,40723,6063,2,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',6540.02,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3413,7922,40723,6063,2,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1959.95,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL);
INSERT INTO `balance_libro` VALUES (3414,7922,40723,6063,2,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',19254.99,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3415,7922,40723,6063,2,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',15969.99,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3416,7922,40723,6063,2,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',13196.02,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3417,7922,40723,6063,2,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',65398.95,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3418,7922,40723,6063,2,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',67188.00,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3419,7922,40723,6063,2,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',20519.96,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3420,7922,40723,6063,2,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',13319.99,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3421,7922,40723,6063,2,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',10719.97,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3422,7922,40723,6063,2,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',19687.00,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3423,7922,40723,6063,2,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',19541.03,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3424,7922,40723,6063,2,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',73676.03,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3425,7922,40723,6063,2,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',15866.01,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3426,7922,40723,6063,2,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',18390.04,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3427,7922,40723,6063,2,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',12069.02,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3428,7922,40723,6063,2,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',12029.66,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3429,7922,40723,6063,2,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',84093.97,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3430,7922,40723,6063,2,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',62103.00,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3431,7922,40723,6063,2,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',17173.01,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3432,7922,40723,6063,2,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',49999.99,NULL,NULL,1,'2023-04-07 08:33:08','2023-04-07 08:33:08',NULL),(3433,7922,40723,6063,2,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',390514.68,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3434,7922,40723,6063,2,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',911747.60,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL);
INSERT INTO `balance_libro` VALUES (3435,7922,40723,6063,2,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',480167.44,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3436,7922,40723,6063,2,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',3508.07,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3437,7922,40723,6063,2,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',369616.71,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3438,7922,40723,6063,2,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',504418.82,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3439,7922,40723,6063,2,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',3350.04,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3440,7922,40723,6063,2,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',401353.57,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3441,7922,40723,6063,2,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',747731.40,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3442,7922,40723,6063,2,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',355504.66,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3443,7922,40723,6063,2,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',7360.03,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3444,7922,40723,6063,2,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',4680.04,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3445,7922,40723,6063,2,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',541470.73,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3446,7922,40723,6063,2,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',646952.03,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3447,7922,40723,6063,2,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',687408.82,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3448,7922,40723,6063,2,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',175206.91,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3449,7922,40723,6063,2,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',165156.98,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3450,7922,40723,6063,2,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',7010.96,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3451,7922,40723,6063,2,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',2144.96,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3452,7922,40723,6063,2,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',890.00,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3453,7922,40723,6063,2,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',462751.79,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3454,7922,40723,6063,2,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',2200.00,NULL,NULL,1,'2023-04-07 08:38:43','2023-04-07 08:38:43',NULL),(3455,7922,40723,6063,2,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1286769.13,NULL,NULL,1,'2023-04-07 08:38:44','2023-04-07 08:38:44',NULL);
INSERT INTO `balance_libro` VALUES (3456,7922,40864,12309,2,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',16000.00,NULL,NULL,1,'2023-04-07 17:48:51','2023-04-07 17:48:51',NULL),(3457,7922,40864,12310,2,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',18000.00,NULL,NULL,1,'2023-04-07 17:49:38','2023-04-07 17:49:38',NULL),(3458,7922,40864,12311,2,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',11000.00,NULL,NULL,1,'2023-04-07 17:50:06','2023-04-07 17:50:06',NULL),(3459,7922,40864,12311,2,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',11000.00,NULL,NULL,1,'2023-04-07 17:50:06','2023-04-07 17:50:06',NULL),(3460,7922,40864,12312,2,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',12000.00,NULL,NULL,1,'2023-04-07 17:50:29','2023-04-07 17:50:29',NULL),(3461,7922,40864,12314,2,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',12000.00,NULL,NULL,1,'2023-04-07 17:51:10','2023-04-07 17:51:10',NULL),(3462,7922,40864,12314,2,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',39500.00,NULL,NULL,1,'2023-04-07 17:51:10','2023-04-07 17:51:10',NULL),(3463,7922,40864,12314,2,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',39500.00,NULL,NULL,1,'2023-04-07 17:51:10','2023-04-07 17:51:10',NULL),(3464,7922,40864,12314,2,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',12000.00,NULL,NULL,1,'2023-04-07 17:51:10','2023-04-07 17:51:10',NULL),(3465,7922,40864,12315,2,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',10000.00,NULL,NULL,1,'2023-04-07 17:59:53','2023-04-07 17:59:53',NULL),(3466,7922,40864,12315,2,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',18000.00,NULL,NULL,1,'2023-04-07 17:59:53','2023-04-07 17:59:53',NULL),(3467,7922,40864,12315,2,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',15000.00,NULL,NULL,1,'2023-04-07 17:59:53','2023-04-07 17:59:53',NULL),(3468,7922,40864,12316,2,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',15000.00,NULL,NULL,1,'2023-04-07 18:00:13','2023-04-07 18:00:13',NULL),(3469,7922,40864,12316,2,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',15000.00,NULL,NULL,1,'2023-04-07 18:00:13','2023-04-07 18:00:13',NULL),(3470,7922,40864,12316,2,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',231000.00,NULL,NULL,1,'2023-04-07 18:00:13','2023-04-07 18:00:13',NULL),(3471,7922,40864,12323,2,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',231000.00,NULL,NULL,1,'2023-04-07 18:00:35','2023-04-07 18:00:35',NULL),(3472,7922,40864,12324,2,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',20000.00,NULL,NULL,1,'2023-04-07 18:00:56','2023-04-07 18:00:56',NULL),(3473,7922,40864,12324,2,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',25000.00,NULL,NULL,1,'2023-04-07 18:00:56','2023-04-07 18:00:56',NULL),(3474,7922,40864,12324,2,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',485737.00,NULL,NULL,1,'2023-04-07 18:00:56','2023-04-07 18:00:56',NULL),(3475,7922,40864,12324,2,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',19550.00,NULL,NULL,1,'2023-04-07 18:00:56','2023-04-07 18:00:56',NULL),(3476,7922,40864,12324,2,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',18624.00,NULL,NULL,1,'2023-04-07 18:00:56','2023-04-07 18:00:56',NULL);
INSERT INTO `balance_libro` VALUES (3477,7922,40864,12324,2,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',24143.00,NULL,NULL,1,'2023-04-07 18:00:56','2023-04-07 18:00:56',NULL),(3478,7922,40864,12324,2,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',10560.00,NULL,NULL,1,'2023-04-07 18:00:56','2023-04-07 18:00:56',NULL),(3479,7922,40864,12325,2,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',25000.00,NULL,NULL,1,'2023-04-07 18:01:21','2023-04-07 18:01:21',NULL),(3480,7922,40864,12325,2,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',115200.00,NULL,NULL,1,'2023-04-07 18:01:21','2023-04-07 18:01:21',NULL),(3481,7922,40864,12325,2,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',25000.00,NULL,NULL,1,'2023-04-07 18:01:21','2023-04-07 18:01:21',NULL),(3482,7922,40864,12325,2,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',25000.00,NULL,NULL,1,'2023-04-07 18:01:21','2023-04-07 18:01:21',NULL),(3483,7922,40864,12325,2,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',25200.00,NULL,NULL,1,'2023-04-07 18:01:21','2023-04-07 18:01:21',NULL),(3484,7922,40864,12325,2,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',125000.00,NULL,NULL,1,'2023-04-07 18:01:21','2023-04-07 18:01:21',NULL),(3485,7922,40864,12325,2,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',420000.00,NULL,NULL,1,'2023-04-07 18:01:22','2023-04-07 18:01:22',NULL),(3486,7922,40864,12325,2,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',25500.00,NULL,NULL,1,'2023-04-07 18:01:22','2023-04-07 18:01:22',NULL),(3487,7922,40864,12325,2,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',25000.00,NULL,NULL,1,'2023-04-07 18:01:22','2023-04-07 18:01:22',NULL),(3488,7922,40864,12325,2,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',25500.00,NULL,NULL,1,'2023-04-07 18:01:22','2023-04-07 18:01:22',NULL),(3489,7922,40864,12325,2,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',9000.00,NULL,NULL,1,'2023-04-07 18:01:22','2023-04-07 18:01:22',NULL),(3490,7922,40864,12325,2,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',6000.00,NULL,NULL,1,'2023-04-07 18:01:22','2023-04-07 18:01:22',NULL),(3491,7922,40864,12325,2,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',25500.00,NULL,NULL,1,'2023-04-07 18:01:22','2023-04-07 18:01:22',NULL),(3492,7922,40864,12325,2,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',25500.00,NULL,NULL,1,'2023-04-07 18:01:22','2023-04-07 18:01:22',NULL),(3493,7922,40864,12325,2,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',230000.00,NULL,NULL,1,'2023-04-07 18:01:22','2023-04-07 18:01:22',NULL),(3494,7922,40723,6063,1,3494,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-03-31',NULL,649277.56,NULL,NULL,1,'2023-04-08 10:36:14','2023-04-08 10:36:14',NULL),(3495,7922,40725,9150,1,3495,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-03-31',NULL,234692.89,NULL,NULL,1,'2023-04-10 12:04:46','2023-04-10 12:04:46',NULL),(3496,7922,40721,3054,2,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',520300.00,NULL,NULL,1,'2023-04-11 12:25:29','2023-04-11 12:25:29',NULL),(3497,7922,40721,3054,2,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',302500.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL);
INSERT INTO `balance_libro` VALUES (3498,7922,40721,3054,2,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',162140.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3499,7922,40721,3054,2,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',388410.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3500,7922,40721,3054,2,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',344850.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3501,7922,40721,3054,2,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',471900.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3502,7922,40721,3054,2,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',12870.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3503,7922,40721,3054,2,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',600.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3504,7922,40721,3054,2,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',3500.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3505,7922,40721,3054,2,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',2500.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3506,7922,40721,3054,2,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',500.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3507,7922,40721,3054,2,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',3220.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3508,7922,40721,3054,2,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',3220.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3509,7922,40721,3054,2,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',600.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3510,7922,40721,3054,2,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',4500.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3511,7922,40721,3054,2,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',250.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3512,7922,40721,3054,2,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',400.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3513,7922,40721,3054,2,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',14355.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3514,7922,40721,3054,2,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',2000.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3515,7922,40721,3054,2,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',2500.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3516,7922,40721,3054,2,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',3500.00,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3517,7922,40721,3054,2,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',18204.50,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL),(3518,7922,40721,3054,2,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',5692.50,NULL,NULL,1,'2023-04-11 12:25:30','2023-04-11 12:25:30',NULL);
INSERT INTO `balance_libro` VALUES (3519,7922,40721,3054,2,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',270.00,NULL,NULL,1,'2023-04-11 12:25:31','2023-04-11 12:25:31',NULL),(3520,7922,40721,3054,2,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',2050.00,NULL,NULL,1,'2023-04-11 12:25:31','2023-04-11 12:25:31',NULL),(3521,7922,40721,3054,2,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',2050.00,NULL,NULL,1,'2023-04-11 12:25:31','2023-04-11 12:25:31',NULL),(3522,7922,40721,3054,2,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',1000.00,NULL,NULL,1,'2023-04-11 12:25:31','2023-04-11 12:25:31',NULL),(3523,7922,40721,3054,2,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',634403.00,NULL,NULL,1,'2023-04-11 12:25:31','2023-04-11 12:25:31',NULL),(3524,7922,40721,3054,2,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',242000.00,NULL,NULL,1,'2023-04-11 12:25:31','2023-04-11 12:25:31',NULL),(3525,7922,40721,3054,2,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',300080.00,NULL,NULL,1,'2023-04-11 12:25:31','2023-04-11 12:25:31',NULL),(3526,7922,40721,3054,2,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',377520.00,NULL,NULL,1,'2023-04-11 12:25:31','2023-04-11 12:25:31',NULL),(3527,7922,40721,3054,2,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',25875.00,NULL,NULL,1,'2023-04-11 12:25:31','2023-04-11 12:25:31',NULL),(3528,7922,40721,3054,2,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',19300.00,NULL,NULL,1,'2023-04-11 12:25:31','2023-04-11 12:25:31',NULL),(3529,7922,40721,3054,2,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',2500.00,NULL,NULL,1,'2023-04-11 12:25:31','2023-04-11 12:25:31',NULL),(3530,7922,40721,3054,2,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',5000.00,NULL,NULL,1,'2023-04-11 12:25:31','2023-04-11 12:25:31',NULL),(3531,7922,40721,3054,2,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1300.00,NULL,NULL,1,'2023-04-11 12:25:31','2023-04-11 12:25:31',NULL),(3532,7922,40721,3054,2,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1100.00,NULL,NULL,1,'2023-04-11 12:25:31','2023-04-11 12:25:31',NULL),(3533,7922,40721,3054,2,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',12000.00,NULL,NULL,1,'2023-04-11 12:25:31','2023-04-11 12:25:31',NULL),(3534,7922,40721,3054,2,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',3250.00,NULL,NULL,1,'2023-04-11 12:25:31','2023-04-11 12:25:31',NULL),(3535,7922,40721,3054,2,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1900.00,NULL,NULL,1,'2023-04-11 12:25:31','2023-04-11 12:25:31',NULL),(3536,7922,40721,3054,2,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',2600.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3537,7922,40721,3054,2,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',459800.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3538,7922,40721,3054,2,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',11300.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3539,7922,40721,3054,2,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',1950.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL);
INSERT INTO `balance_libro` VALUES (3540,7922,40721,3054,2,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',1900.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3541,7922,40721,3054,2,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',1900.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3542,7922,40721,3054,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',1400.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3543,7922,40721,3054,2,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',375100.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3544,7922,40721,3054,2,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',2700.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3545,7922,40721,3054,2,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',2600.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3546,7922,40721,3054,2,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',6500.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3547,7922,40721,3054,2,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',1300.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3548,7922,40721,3054,2,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',900.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3549,7922,40721,3054,2,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',4200.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3550,7922,40721,3054,2,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',400.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3551,7922,40721,3054,2,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',6200.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3552,7922,40721,3054,2,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',500.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3553,7922,40721,3054,2,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',44225.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3554,7922,40721,3054,2,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',500.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3555,7922,40721,3054,2,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',1600.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3556,7922,40721,3054,2,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',2550.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3557,7922,40721,3054,2,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',200.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3558,7922,40721,3054,2,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',387200.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3559,7922,40721,3054,2,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',80.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3560,7922,40721,3054,2,2275,'App\\Models\\Receipt',2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',800.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL);
INSERT INTO `balance_libro` VALUES (3561,7922,40721,3054,2,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1950.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3562,7922,40721,3054,2,2277,'App\\Models\\Receipt',2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2700.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3563,7922,40721,3054,2,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1100.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3564,7922,40721,3054,2,2279,'App\\Models\\Receipt',2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1000.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3565,7922,40721,3054,2,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3910.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3566,7922,40721,3054,2,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',950.00,NULL,NULL,1,'2023-04-11 12:25:32','2023-04-11 12:25:32',NULL),(3567,7922,40721,3054,2,2282,'App\\Models\\Receipt',2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2100.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3568,7922,40721,3054,2,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',4900.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3569,7922,40721,3054,2,2284,'App\\Models\\Receipt',2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',550.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3570,7922,40721,3054,2,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',850.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3571,7922,40721,3054,2,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1050.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3572,7922,40721,3054,2,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2300.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3573,7922,40721,3054,2,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',7000.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3574,7922,40721,3054,2,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2800.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3575,7922,40721,3054,2,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',200260.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3576,7922,40721,3054,2,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',100000.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3577,7922,40721,3054,2,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',80000.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3578,7922,40721,3054,2,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',50000.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3579,7922,40721,3054,2,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',20900.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3580,7922,40721,3054,2,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',21000.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3581,7922,40721,3054,2,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',24000.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL);
INSERT INTO `balance_libro` VALUES (3582,7922,40721,3054,2,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',24000.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3583,7922,40721,3054,2,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',26875.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3584,7922,40721,3054,2,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',34650.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3585,7922,40721,3054,2,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',95000.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3586,7922,40721,3054,2,2301,'App\\Models\\Receipt',2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',75000.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3587,7922,40721,3054,2,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',435600.00,NULL,NULL,1,'2023-04-11 12:25:33','2023-04-11 12:25:33',NULL),(3588,7922,40721,3054,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',146652.00,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3589,7922,40721,3054,3,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',420000.00,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3590,7922,40721,3054,3,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',38000.00,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3591,7922,40721,3054,3,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',11772.30,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3592,7922,40721,3054,3,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',254826.00,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3593,7922,40721,3054,3,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',14550.00,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3594,7922,40721,3054,3,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',29100.00,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3595,7922,40721,3054,3,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',42271.09,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3596,7922,40721,3054,3,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',296329.00,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3597,7922,40721,3054,3,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',298971.10,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3598,7922,40721,3054,3,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',141127.14,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3599,7922,40721,3054,3,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',45463.57,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3600,7922,40721,3054,3,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',1669.99,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3601,7922,40721,3054,3,2316,'App\\Models\\Receipt',2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',10768.19,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3602,7922,40721,3054,3,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1140.00,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL);
INSERT INTO `balance_libro` VALUES (3603,7922,40721,3054,3,2318,'App\\Models\\Receipt',2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',302500.00,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3604,7922,40721,3054,3,2319,'App\\Models\\Receipt',2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',0.95,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3605,7922,40721,3054,3,2320,'App\\Models\\Receipt',2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',0.00,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3606,7922,40721,3054,3,2321,'App\\Models\\Receipt',2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',146168.00,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3607,7922,40721,3054,3,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',22528.99,NULL,NULL,1,'2023-04-11 12:26:08','2023-04-11 12:26:08',NULL),(3608,7922,40723,6063,3,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',579196.80,NULL,NULL,1,'2023-04-13 11:22:31','2023-04-13 11:22:31',NULL),(3609,7922,40723,6063,3,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',526289.40,NULL,NULL,1,'2023-04-13 11:22:31','2023-04-13 11:22:31',NULL),(3610,7922,40723,6063,3,2325,'App\\Models\\Receipt',2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',542068.80,NULL,NULL,1,'2023-04-13 11:22:31','2023-04-13 11:22:31',NULL),(3611,7922,40723,6063,3,2326,'App\\Models\\Receipt',2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',557848.20,NULL,NULL,1,'2023-04-13 11:22:31','2023-04-13 11:22:31',NULL),(3612,7922,40723,6063,3,2327,'App\\Models\\Receipt',2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',400000.00,NULL,NULL,1,'2023-04-13 11:22:31','2023-04-13 11:22:31',NULL),(3613,7922,40723,6063,3,2328,'App\\Models\\Receipt',2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',357258.72,NULL,NULL,1,'2023-04-13 11:22:31','2023-04-13 11:22:31',NULL),(3614,7922,40723,6063,3,2329,'App\\Models\\Receipt',2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',339503.65,NULL,NULL,1,'2023-04-13 11:22:31','2023-04-13 11:22:31',NULL),(3615,7922,40723,6063,3,2330,'App\\Models\\Receipt',2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',5385.65,NULL,NULL,1,'2023-04-13 11:22:31','2023-04-13 11:22:31',NULL),(3616,7922,40723,6063,3,2331,'App\\Models\\Receipt',2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',8151.24,NULL,NULL,1,'2023-04-13 11:22:31','2023-04-13 11:22:31',NULL),(3617,7922,40723,6063,3,2332,'App\\Models\\Receipt',2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',458530.80,NULL,NULL,1,'2023-04-13 11:22:31','2023-04-13 11:22:31',NULL),(3618,7922,40723,6063,3,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',465028.20,NULL,NULL,1,'2023-04-13 11:22:31','2023-04-13 11:22:31',NULL),(3619,7922,40723,6063,3,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',572699.40,NULL,NULL,1,'2023-04-13 11:22:31','2023-04-13 11:22:31',NULL),(3620,7922,40723,6063,3,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',514222.80,NULL,NULL,1,'2023-04-13 11:22:31','2023-04-13 11:22:31',NULL),(3621,7922,40723,6063,3,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',85527.00,NULL,NULL,1,'2023-04-13 11:22:32','2023-04-13 11:22:32',NULL),(3622,7922,40723,6063,3,2337,'App\\Models\\Receipt',2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',33813.00,NULL,NULL,1,'2023-04-13 11:22:32','2023-04-13 11:22:32',NULL),(3623,7922,40723,6063,3,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',46297.33,NULL,NULL,1,'2023-04-13 11:22:32','2023-04-13 11:22:32',NULL);
INSERT INTO `balance_libro` VALUES (3624,7922,40723,6063,3,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',276582.27,NULL,NULL,1,'2023-04-13 11:22:32','2023-04-13 11:22:32',NULL),(3625,7922,40723,6063,3,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',261720.42,NULL,NULL,1,'2023-04-13 11:22:32','2023-04-13 11:22:32',NULL),(3626,7922,40723,6063,3,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',261720.42,NULL,NULL,1,'2023-04-13 11:22:32','2023-04-13 11:22:32',NULL),(3627,7922,40723,6063,3,2342,'App\\Models\\Receipt',2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',486629.78,NULL,NULL,1,'2023-04-13 11:22:32','2023-04-13 11:22:32',NULL),(3628,7922,40723,6063,3,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',5385.65,NULL,NULL,1,'2023-04-13 11:22:32','2023-04-13 11:22:32',NULL),(3629,7922,40723,6063,3,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',509228.20,NULL,NULL,1,'2023-04-13 11:22:32','2023-04-13 11:22:32',NULL),(3630,7922,40723,6063,3,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',502885.50,NULL,NULL,1,'2023-04-13 11:22:32','2023-04-13 11:22:32',NULL),(3631,7922,40723,6063,3,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',253708.00,NULL,NULL,1,'2023-04-13 11:22:32','2023-04-13 11:22:32',NULL),(3632,7922,40723,6063,3,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',241022.60,NULL,NULL,1,'2023-04-13 11:22:32','2023-04-13 11:22:32',NULL),(3633,7922,40723,6063,3,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',96483.00,NULL,NULL,1,'2023-04-13 11:22:32','2023-04-13 11:22:32',NULL),(3634,7922,40723,6063,3,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',104201.64,NULL,NULL,1,'2023-04-13 11:22:32','2023-04-13 11:22:32',NULL),(3635,7922,40723,6063,3,2350,'App\\Models\\Receipt',2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',192964.79,NULL,NULL,1,'2023-04-13 11:22:32','2023-04-13 11:22:32',NULL),(3636,7922,40723,6063,3,2351,'App\\Models\\Receipt',2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',190567.50,NULL,NULL,1,'2023-04-13 11:22:32','2023-04-13 11:22:32',NULL),(3637,7922,40723,6063,3,2352,'App\\Models\\Receipt',2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',202572.74,NULL,NULL,1,'2023-04-13 11:22:32','2023-04-13 11:22:32',NULL),(3638,7922,40723,6063,3,2353,'App\\Models\\Receipt',2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',190567.50,NULL,NULL,1,'2023-04-13 11:22:32','2023-04-13 11:22:32',NULL),(3639,7922,40723,6063,3,2354,'App\\Models\\Receipt',2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',192964.79,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3640,7922,40723,6063,3,2355,'App\\Models\\Receipt',2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',202572.74,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3641,7922,40723,6063,3,2356,'App\\Models\\Receipt',2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',4641.32,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3642,7922,40723,6063,3,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',4641.32,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3643,7922,40723,6063,3,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',0.00,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3644,7922,40723,6063,3,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',107671.20,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL);
INSERT INTO `balance_libro` VALUES (3645,7922,40723,6063,3,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',25000.00,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3646,7922,40723,6063,3,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',640308.82,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3647,7922,40723,6063,3,2362,'App\\Models\\Receipt',2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',634905.38,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3648,7922,40723,6063,3,2363,'App\\Models\\Receipt',2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',966808.70,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3649,7922,40723,6063,3,2364,'App\\Models\\Receipt',2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',1220516.70,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3650,7922,40723,6063,3,2365,'App\\Models\\Receipt',2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',948686.70,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3651,7922,40723,6063,3,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',965902.60,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3652,7922,40723,6063,3,2367,'App\\Models\\Receipt',2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',2718.30,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3653,7922,40723,6063,3,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',198224.34,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3654,7922,40723,6063,3,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',198224.34,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3655,7922,40723,6063,3,2370,'App\\Models\\Receipt',2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',119983.65,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3656,7922,40723,6063,3,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',119983.65,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3657,7922,40723,6063,3,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',576279.60,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3658,7922,40723,6063,3,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',660546.90,NULL,NULL,1,'2023-04-13 11:22:33','2023-04-13 11:22:33',NULL),(3659,7922,40723,6063,3,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',200000.01,NULL,NULL,1,'2023-04-13 11:22:34','2023-04-13 11:22:34',NULL),(3660,7922,40723,6063,3,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',212829.59,NULL,NULL,1,'2023-04-13 11:22:34','2023-04-13 11:22:34',NULL),(3661,7922,40723,6063,3,2376,'App\\Models\\Receipt',2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',157366.37,NULL,NULL,1,'2023-04-13 11:22:34','2023-04-13 11:22:34',NULL),(3662,7922,40723,6063,3,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',157366.37,NULL,NULL,1,'2023-04-13 11:22:34','2023-04-13 11:22:34',NULL),(3663,7922,40723,6063,3,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',212829.59,NULL,NULL,1,'2023-04-13 11:22:34','2023-04-13 11:22:34',NULL),(3664,7922,40723,6063,3,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',521913.60,NULL,NULL,1,'2023-04-13 11:22:34','2023-04-13 11:22:34',NULL),(3665,7922,40723,6063,3,2380,'App\\Models\\Receipt',2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',545472.20,NULL,NULL,1,'2023-04-13 11:22:34','2023-04-13 11:22:34',NULL);
INSERT INTO `balance_libro` VALUES (3666,7922,40723,6063,3,2381,'App\\Models\\Receipt',2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',951405.00,NULL,NULL,1,'2023-04-13 11:22:34','2023-04-13 11:22:34',NULL),(3667,7922,40723,6063,3,2382,'App\\Models\\Receipt',2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',980400.20,NULL,NULL,1,'2023-04-13 11:22:34','2023-04-13 11:22:34',NULL),(3668,7922,40723,6063,3,2383,'App\\Models\\Receipt',2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',980400.20,NULL,NULL,1,'2023-04-13 11:22:34','2023-04-13 11:22:34',NULL),(3669,7922,40723,6063,3,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',946874.50,NULL,NULL,1,'2023-04-13 11:22:34','2023-04-13 11:22:34',NULL),(3670,7922,40723,6063,3,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',142375.80,NULL,NULL,1,'2023-04-13 11:22:34','2023-04-13 11:22:34',NULL),(3671,7922,40723,6063,3,2386,'App\\Models\\Receipt',2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',135224.60,NULL,NULL,1,'2023-04-13 11:22:34','2023-04-13 11:22:34',NULL),(3672,7922,40723,6063,3,2387,'App\\Models\\Receipt',2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',135224.60,NULL,NULL,1,'2023-04-13 11:22:34','2023-04-13 11:22:34',NULL),(3673,7922,40723,6063,3,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',142375.80,NULL,NULL,1,'2023-04-13 11:22:34','2023-04-13 11:22:34',NULL),(3674,7922,40723,6063,3,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',45626.00,NULL,NULL,1,'2023-04-13 11:22:34','2023-04-13 11:22:34',NULL),(3675,7922,40723,6063,3,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',45626.00,NULL,NULL,1,'2023-04-13 11:22:34','2023-04-13 11:22:34',NULL),(3676,7922,40723,6063,3,2391,'App\\Models\\Receipt',2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',52469.00,NULL,NULL,1,'2023-04-13 11:22:34','2023-04-13 11:22:34',NULL),(3677,7922,40723,6063,3,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',52469.00,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3678,7922,40723,6063,3,2393,'App\\Models\\Receipt',2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',132739.08,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3679,7922,40723,6063,3,2394,'App\\Models\\Receipt',2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',185010.19,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3680,7922,40723,6063,3,2395,'App\\Models\\Receipt',2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',185010.19,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3681,7922,40723,6063,3,2396,'App\\Models\\Receipt',2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',132739.08,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3682,7922,40723,6063,3,2397,'App\\Models\\Receipt',2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',598147.55,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3683,7922,40723,6063,3,2398,'App\\Models\\Receipt',2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',501979.40,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3684,7922,40723,6063,3,2399,'App\\Models\\Receipt',2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',501073.30,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3685,7922,40723,6063,3,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',643242.60,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3686,7922,40723,6063,3,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',335643.75,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL);
INSERT INTO `balance_libro` VALUES (3687,7922,40723,6063,3,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',145860.00,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3688,7922,40723,6063,3,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',182325.00,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3689,7922,40723,6063,3,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',223762.50,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3690,7922,40723,6063,3,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',250000.00,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3691,7922,40723,6063,3,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',878917.00,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3692,7922,40723,6063,3,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',916973.20,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3693,7922,40723,6063,3,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',982212.40,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3694,7922,40723,6063,3,2409,'App\\Models\\Receipt',2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',989461.20,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3695,7922,40723,6063,3,2410,'App\\Models\\Receipt',2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',195403.03,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3696,7922,40723,6063,3,2411,'App\\Models\\Receipt',2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',151423.00,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3697,7922,40723,6063,3,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',151423.00,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3698,7922,40723,6063,3,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',195403.03,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3699,7922,40723,6063,3,2414,'App\\Models\\Receipt',2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',541008.00,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3700,7922,40723,6063,3,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',371280.00,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3701,7922,40723,6063,3,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',114023.16,NULL,NULL,1,'2023-04-13 11:22:35','2023-04-13 11:22:35',NULL),(3702,7922,40723,6063,3,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',133842.49,NULL,NULL,1,'2023-04-13 11:22:36','2023-04-13 11:22:36',NULL),(3703,7922,40723,6063,3,2418,'App\\Models\\Receipt',2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',133842.49,NULL,NULL,1,'2023-04-13 11:22:36','2023-04-13 11:22:36',NULL),(3704,7922,40723,6063,3,2419,'App\\Models\\Receipt',2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',114023.16,NULL,NULL,1,'2023-04-13 11:22:36','2023-04-13 11:22:36',NULL),(3705,7922,40723,6063,3,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',0.00,NULL,NULL,1,'2023-04-13 11:22:36','2023-04-13 11:22:36',NULL),(3706,7922,40723,6063,3,2421,'App\\Models\\Receipt',2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',0.00,NULL,NULL,1,'2023-04-13 11:22:36','2023-04-13 11:22:36',NULL),(3707,7922,40723,6063,3,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3551.43,NULL,NULL,1,'2023-04-13 11:22:36','2023-04-13 11:22:36',NULL);
INSERT INTO `balance_libro` VALUES (3708,7922,40723,6063,15,172,'App\\Models\\PeriodLiquidation',NULL,172,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5305536.59,NULL,NULL,1,'2023-04-14 11:09:25','2023-04-14 11:10:57','2023-04-14 11:10:57'),(3709,7922,40723,6063,16,173,'App\\Models\\PeriodLiquidation',NULL,173,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',61679.64,NULL,NULL,1,'2023-04-14 11:09:30','2023-04-14 11:11:04','2023-04-14 11:11:04'),(3751,7922,40723,6063,2,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',703531.06,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL),(3752,7922,40723,6063,2,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',1210116.82,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL),(3753,7922,40723,6063,2,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',690264.00,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL),(3754,7922,40723,6063,2,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',139271702.03,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL),(3755,7922,40723,6063,2,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',15970.00,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL),(3756,7922,40723,6063,2,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',2146647.00,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL),(3757,7922,40723,6063,2,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',461770.12,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL),(3758,7922,40723,6063,2,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',663746.04,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL),(3759,7922,40723,6063,2,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',736694.11,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL),(3760,7922,40723,6063,2,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',961041.97,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL),(3761,7922,40723,6063,2,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',818433.80,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL),(3762,7922,40723,6063,2,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',333347.98,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL),(3763,7922,40723,6063,2,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',1833406.98,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL),(3764,7922,40723,6063,2,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',641002.80,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL),(3765,7922,40723,6063,2,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',1283181.85,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL),(3766,7922,40723,6063,2,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',800642.19,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL),(3767,7922,40723,6063,2,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',588999.97,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL),(3768,7922,40723,6063,2,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',269771.99,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL);
INSERT INTO `balance_libro` VALUES (3769,7922,40723,6063,2,2482,'App\\Models\\Receipt',2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',69668.00,NULL,NULL,1,'2023-04-15 09:57:54','2023-04-15 09:57:54',NULL),(3770,7922,40723,6063,2,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',220583.66,NULL,NULL,1,'2023-04-15 09:57:55','2023-04-15 09:57:55',NULL),(3771,7922,40723,6063,2,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',762000.00,NULL,NULL,1,'2023-04-15 09:57:55','2023-04-15 09:57:55',NULL),(3772,7922,40723,6063,2,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',285556.77,NULL,NULL,1,'2023-04-15 09:57:55','2023-04-15 09:57:55',NULL),(3773,7922,40723,6063,2,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',361210.99,NULL,NULL,1,'2023-04-15 09:57:55','2023-04-15 09:57:55',NULL),(3774,7922,40723,6063,2,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',429758.49,NULL,NULL,1,'2023-04-15 09:57:55','2023-04-15 09:57:55',NULL),(3775,7922,40723,6063,2,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',252641.00,NULL,NULL,1,'2023-04-15 09:57:55','2023-04-15 09:57:55',NULL),(3776,7922,40723,6063,2,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',161672.94,NULL,NULL,1,'2023-04-15 09:57:55','2023-04-15 09:57:55',NULL),(3777,7922,40723,6063,2,2490,'App\\Models\\Receipt',2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',199681.01,NULL,NULL,1,'2023-04-15 09:57:55','2023-04-15 09:57:55',NULL),(3778,7922,40723,6063,2,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',273135.01,NULL,NULL,1,'2023-04-15 09:57:55','2023-04-15 09:57:55',NULL),(3779,7922,40723,6063,2,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',858518.11,NULL,NULL,1,'2023-04-15 09:57:55','2023-04-15 09:57:55',NULL),(3780,7922,40723,6063,2,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',367700.00,NULL,NULL,1,'2023-04-15 09:57:55','2023-04-15 09:57:55',NULL),(3781,7922,40723,6063,2,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',124882773.02,NULL,NULL,1,'2023-04-15 10:05:58','2023-04-15 10:10:49','2023-04-15 10:10:49'),(3782,7922,40723,6063,2,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',137995464.19,NULL,NULL,1,'2023-04-15 10:10:49','2023-04-15 10:10:49',NULL),(3783,7922,40723,6063,15,178,'App\\Models\\PeriodLiquidation',NULL,178,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',18418227.76,NULL,NULL,1,'2023-04-15 10:36:05','2023-04-19 16:54:12','2023-04-19 16:54:12'),(3784,7922,40723,6063,16,179,'App\\Models\\PeriodLiquidation',NULL,179,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',61679.64,NULL,NULL,1,'2023-04-15 10:36:09','2023-04-15 10:36:09',NULL),(3785,7922,40759,10722,2,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',37040.00,NULL,NULL,1,'2023-04-17 17:01:21','2023-04-17 17:01:21',NULL),(3786,7922,40759,10722,2,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',279110.00,NULL,NULL,1,'2023-04-17 17:01:21','2023-04-17 17:01:21',NULL),(3787,7922,40759,10722,3,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3219.00,NULL,NULL,1,'2023-04-17 17:01:41','2023-04-17 17:01:41',NULL),(3788,7922,40759,10722,3,2498,'App\\Models\\Receipt',2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',2975.00,NULL,NULL,1,'2023-04-17 17:01:41','2023-04-17 17:01:41',NULL);
INSERT INTO `balance_libro` VALUES (3789,7922,40759,10722,3,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1905.00,NULL,NULL,1,'2023-04-17 17:01:41','2023-04-17 17:01:41',NULL),(3790,7922,40759,10722,3,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',430.00,NULL,NULL,1,'2023-04-17 17:01:41','2023-04-17 17:01:41',NULL),(3791,7922,40759,10722,3,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',3719.34,NULL,NULL,1,'2023-04-17 17:01:41','2023-04-17 17:01:41',NULL),(3792,7922,40759,10722,3,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',4779.70,NULL,NULL,1,'2023-04-17 17:01:41','2023-04-17 17:01:41',NULL),(3793,7922,40759,10722,3,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',1050.00,NULL,NULL,1,'2023-04-17 17:01:41','2023-04-17 17:01:41',NULL),(3794,7922,40759,10722,3,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',670.00,NULL,NULL,1,'2023-04-17 17:01:41','2023-04-17 17:01:41',NULL),(3795,7922,40759,10722,3,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',3520.00,NULL,NULL,1,'2023-04-17 17:01:41','2023-04-17 17:01:41',NULL),(3796,7922,40759,10722,3,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',242000.00,NULL,NULL,1,'2023-04-17 17:01:41','2023-04-17 17:01:41',NULL),(3797,7922,40759,10722,3,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',1135.00,NULL,NULL,1,'2023-04-17 17:01:41','2023-04-17 17:01:41',NULL),(3798,7922,40759,10722,3,2508,'App\\Models\\Receipt',2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',980.00,NULL,NULL,1,'2023-04-17 17:01:41','2023-04-17 17:01:41',NULL),(3799,7922,40759,10722,16,183,'App\\Models\\PeriodLiquidation',NULL,183,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',7838.43,NULL,NULL,1,'2023-04-17 17:09:36','2023-04-17 17:09:36',NULL),(3800,7922,40759,10721,16,104,'App\\Models\\PeriodLiquidation',NULL,104,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',9996.31,NULL,NULL,1,'2023-04-17 17:10:30','2023-04-17 17:10:30',NULL),(3801,7922,40759,10720,16,96,'App\\Models\\PeriodLiquidation',NULL,96,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6548.19,NULL,NULL,1,'2023-04-17 17:12:01','2023-04-17 17:12:01',NULL),(3802,7922,40946,13835,2,2509,'App\\Models\\Receipt',2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',17340.00,NULL,NULL,1,'2023-04-19 10:17:16','2023-04-19 10:17:16',NULL),(3803,7922,40946,13836,2,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',55000.00,NULL,NULL,1,'2023-04-19 10:19:18','2023-04-19 10:19:18',NULL),(3804,7922,40946,13836,2,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',17340.00,NULL,NULL,1,'2023-04-19 10:19:18','2023-04-19 10:19:18',NULL),(3805,7922,40946,13836,2,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',9520.00,NULL,NULL,1,'2023-04-19 10:19:18','2023-04-19 10:19:18',NULL),(3806,7922,40946,13837,2,2513,'App\\Models\\Receipt',2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',46000.00,NULL,NULL,1,'2023-04-19 10:19:30','2023-04-19 10:19:30',NULL),(3807,7922,40946,13837,2,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',22100.00,NULL,NULL,1,'2023-04-19 10:19:30','2023-04-19 10:19:30',NULL),(3808,7922,40946,13838,2,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',80000.00,NULL,NULL,1,'2023-04-19 10:19:40','2023-04-19 10:19:40',NULL);
INSERT INTO `balance_libro` VALUES (3809,7922,40946,13838,2,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',22100.00,NULL,NULL,1,'2023-04-19 10:19:40','2023-04-19 10:19:40',NULL),(3810,7922,40946,13838,2,2517,'App\\Models\\Receipt',2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',46000.00,NULL,NULL,1,'2023-04-19 10:19:40','2023-04-19 10:19:40',NULL),(3811,7922,40946,13839,2,2518,'App\\Models\\Receipt',2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',68150.00,NULL,NULL,1,'2023-04-19 10:19:52','2023-04-19 10:19:52',NULL),(3812,7922,40946,13839,2,2519,'App\\Models\\Receipt',2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',46000.00,NULL,NULL,1,'2023-04-19 10:19:52','2023-04-19 10:19:52',NULL),(3813,7922,40946,13839,2,2520,'App\\Models\\Receipt',2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',22100.00,NULL,NULL,1,'2023-04-19 10:19:52','2023-04-19 10:19:52',NULL),(3814,7922,40946,13839,2,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',60000.00,NULL,NULL,1,'2023-04-19 10:19:53','2023-04-19 10:19:53',NULL),(3815,7922,40946,13840,2,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',75000.00,NULL,NULL,1,'2023-04-19 10:20:01','2023-04-19 10:20:01',NULL),(3816,7922,40946,13840,2,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',22100.00,NULL,NULL,1,'2023-04-19 10:20:01','2023-04-19 10:20:01',NULL),(3817,7922,40946,13841,2,2524,'App\\Models\\Receipt',2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',107800.00,NULL,NULL,1,'2023-04-19 10:20:09','2023-04-19 10:20:09',NULL),(3818,7922,40946,13842,2,2525,'App\\Models\\Receipt',2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',22100.00,NULL,NULL,1,'2023-04-19 10:20:17','2023-04-19 10:20:17',NULL),(3819,7922,40946,13842,2,2526,'App\\Models\\Receipt',2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',137280.00,NULL,NULL,1,'2023-04-19 10:20:17','2023-04-19 10:20:17',NULL),(3820,7922,40946,13843,2,2527,'App\\Models\\Receipt',2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',162533.00,NULL,NULL,1,'2023-04-19 10:20:25','2023-04-19 10:20:25',NULL),(3821,7922,40946,13843,2,2528,'App\\Models\\Receipt',2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',29900.00,NULL,NULL,1,'2023-04-19 10:20:25','2023-04-19 10:20:25',NULL),(3822,7922,40946,13843,2,2529,'App\\Models\\Receipt',2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',7800.00,NULL,NULL,1,'2023-04-19 10:20:25','2023-04-19 10:20:25',NULL),(3823,7922,40946,13850,2,2530,'App\\Models\\Receipt',2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',35070.00,NULL,NULL,1,'2023-04-19 10:21:31','2023-04-19 10:21:31',NULL),(3824,7922,40946,13851,2,2531,'App\\Models\\Receipt',2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',174300.00,NULL,NULL,1,'2023-04-19 10:21:39','2023-04-19 10:21:39',NULL),(3825,7922,40946,13851,2,2532,'App\\Models\\Receipt',2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',35070.00,NULL,NULL,1,'2023-04-19 10:21:39','2023-04-19 10:21:39',NULL),(3826,7922,40946,13852,2,2533,'App\\Models\\Receipt',2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',35070.00,NULL,NULL,1,'2023-04-19 10:21:46','2023-04-19 10:21:46',NULL),(3827,7922,40946,13852,2,2534,'App\\Models\\Receipt',2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',23500.00,NULL,NULL,1,'2023-04-19 10:21:46','2023-04-19 10:21:46',NULL),(3828,7922,40946,13852,2,2535,'App\\Models\\Receipt',2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',41650.00,NULL,NULL,1,'2023-04-19 10:21:46','2023-04-19 10:21:46',NULL),(3829,7922,40946,13852,2,2536,'App\\Models\\Receipt',2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',70000.00,NULL,NULL,1,'2023-04-19 10:21:46','2023-04-19 10:21:46',NULL);
INSERT INTO `balance_libro` VALUES (3830,7922,40946,13853,2,2537,'App\\Models\\Receipt',2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',42030.00,NULL,NULL,1,'2023-04-19 10:22:05','2023-04-19 10:22:05',NULL),(3831,7922,40956,15365,2,2538,'App\\Models\\Receipt',2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',47000.00,NULL,NULL,1,'2023-04-19 10:33:57','2023-04-19 10:33:57',NULL),(3832,7922,40956,15366,2,2539,'App\\Models\\Receipt',2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',46000.00,NULL,NULL,1,'2023-04-19 10:34:08','2023-04-19 10:34:08',NULL),(3833,7922,40956,15366,2,2540,'App\\Models\\Receipt',2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',47800.00,NULL,NULL,1,'2023-04-19 10:34:08','2023-04-19 10:34:08',NULL),(3834,7922,40956,15367,2,2541,'App\\Models\\Receipt',2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',48000.00,NULL,NULL,1,'2023-04-19 10:34:16','2023-04-19 10:34:16',NULL),(3835,7922,40956,15368,2,2542,'App\\Models\\Receipt',2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',56500.00,NULL,NULL,1,'2023-04-19 10:34:23','2023-04-19 10:34:23',NULL),(3836,7922,40956,15369,2,2543,'App\\Models\\Receipt',2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',120000.00,NULL,NULL,1,'2023-04-19 10:34:30','2023-04-19 10:34:30',NULL),(3837,7922,40956,15369,2,2544,'App\\Models\\Receipt',2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',60000.00,NULL,NULL,1,'2023-04-19 10:34:30','2023-04-19 10:34:30',NULL),(3838,7922,40956,15371,2,2545,'App\\Models\\Receipt',2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',35000.00,NULL,NULL,1,'2023-04-19 10:34:38','2023-04-19 10:34:38',NULL),(3839,7922,40956,15371,2,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',107800.00,NULL,NULL,1,'2023-04-19 10:34:38','2023-04-19 10:34:38',NULL),(3840,7922,40956,15372,2,2547,'App\\Models\\Receipt',2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',137280.00,NULL,NULL,1,'2023-04-19 10:34:45','2023-04-19 10:34:45',NULL),(3841,7922,40956,15373,2,2548,'App\\Models\\Receipt',2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',162533.00,NULL,NULL,1,'2023-04-19 10:34:51','2023-04-19 10:34:51',NULL),(3842,7922,40956,15373,2,2549,'App\\Models\\Receipt',2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',47600.00,NULL,NULL,1,'2023-04-19 10:34:51','2023-04-19 10:34:51',NULL),(3843,7922,40956,15382,2,2550,'App\\Models\\Receipt',2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',41650.00,NULL,NULL,1,'2023-04-19 10:36:04','2023-04-19 10:36:04',NULL),(3844,7922,40956,15382,2,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',70000.00,NULL,NULL,1,'2023-04-19 10:36:04','2023-04-19 10:36:04',NULL),(3845,7922,40956,15383,2,2552,'App\\Models\\Receipt',2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',51900.00,NULL,NULL,1,'2023-04-19 10:36:12','2023-04-19 10:36:12',NULL),(3846,7922,40956,15383,2,2553,'App\\Models\\Receipt',2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',65000.00,NULL,NULL,1,'2023-04-19 10:36:12','2023-04-19 10:36:12',NULL),(3847,7922,40956,15383,2,2554,'App\\Models\\Receipt',2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',51900.00,NULL,NULL,1,'2023-04-19 10:36:12','2023-04-19 10:36:12',NULL),(3848,7922,40962,16895,2,2555,'App\\Models\\Receipt',2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',46000.00,NULL,NULL,1,'2023-04-19 10:58:54','2023-04-19 10:58:54',NULL),(3849,7922,40962,16896,2,2556,'App\\Models\\Receipt',2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',53025.00,NULL,NULL,1,'2023-04-19 10:59:03','2023-04-19 10:59:03',NULL);
INSERT INTO `balance_libro` VALUES (3850,7922,40962,16897,2,2557,'App\\Models\\Receipt',2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',65945.00,NULL,NULL,1,'2023-04-19 10:59:12','2023-04-19 10:59:12',NULL),(3851,7922,40962,16898,2,2558,'App\\Models\\Receipt',2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',53025.00,NULL,NULL,1,'2023-04-19 11:00:14','2023-04-19 11:00:14',NULL),(3852,7922,40962,16898,2,2559,'App\\Models\\Receipt',2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',82850.00,NULL,NULL,1,'2023-04-19 11:00:14','2023-04-19 11:00:14',NULL),(3853,7922,40962,16899,2,2560,'App\\Models\\Receipt',2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',32000.00,NULL,NULL,1,'2023-04-19 11:00:22','2023-04-19 11:00:22',NULL),(3854,7922,40962,16899,2,2561,'App\\Models\\Receipt',2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',120000.00,NULL,NULL,1,'2023-04-19 11:00:22','2023-04-19 11:00:22',NULL),(3855,7922,40962,16901,2,2562,'App\\Models\\Receipt',2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',48000.00,NULL,NULL,1,'2023-04-19 11:00:40','2023-04-19 11:00:40',NULL),(3856,7922,40962,16901,2,2563,'App\\Models\\Receipt',2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',65945.00,NULL,NULL,1,'2023-04-19 11:00:40','2023-04-19 11:00:40',NULL),(3857,7922,40962,16902,2,2564,'App\\Models\\Receipt',2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',137280.00,NULL,NULL,1,'2023-04-19 11:00:46','2023-04-19 11:00:46',NULL),(3858,7922,40962,16902,2,2565,'App\\Models\\Receipt',2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',6420.00,NULL,NULL,1,'2023-04-19 11:00:47','2023-04-19 11:00:47',NULL),(3859,7922,40962,16903,2,2566,'App\\Models\\Receipt',2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',162533.00,NULL,NULL,1,'2023-04-19 11:00:53','2023-04-19 11:00:53',NULL),(3860,7922,40962,16903,2,2567,'App\\Models\\Receipt',2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',47600.00,NULL,NULL,1,'2023-04-19 11:00:53','2023-04-19 11:00:53',NULL),(3861,7922,40962,16910,2,2568,'App\\Models\\Receipt',2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',160400.00,NULL,NULL,1,'2023-04-19 11:01:02','2023-04-19 11:01:02',NULL),(3862,7922,40962,16911,2,2569,'App\\Models\\Receipt',2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',78000.00,NULL,NULL,1,'2023-04-19 11:01:09','2023-04-19 11:01:09',NULL),(3863,7922,40962,16912,2,2570,'App\\Models\\Receipt',2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',41700.00,NULL,NULL,1,'2023-04-19 11:01:16','2023-04-19 11:01:16',NULL),(3864,7922,40962,16912,2,2571,'App\\Models\\Receipt',2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',70000.00,NULL,NULL,1,'2023-04-19 11:01:16','2023-04-19 11:01:16',NULL),(3865,7922,40962,16913,2,2572,'App\\Models\\Receipt',2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',51900.00,NULL,NULL,1,'2023-04-19 11:01:23','2023-04-19 11:01:23',NULL),(3866,7922,40723,6063,15,178,'App\\Models\\PeriodLiquidation',NULL,178,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',18418227.76,NULL,NULL,1,'2023-04-19 17:31:49','2023-04-19 17:31:49',NULL),(3867,7922,40721,3054,3,2573,'App\\Models\\Receipt',2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',10213.13,NULL,NULL,1,'2023-04-20 16:03:41','2023-04-20 16:03:41',NULL),(3868,7922,40721,3054,3,2574,'App\\Models\\Receipt',2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',11316.91,NULL,NULL,1,'2023-04-20 16:03:41','2023-04-20 16:03:41',NULL),(3869,7922,40721,3054,3,2575,'App\\Models\\Receipt',2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',10394.83,NULL,NULL,1,'2023-04-20 16:03:41','2023-04-20 16:03:41',NULL);
INSERT INTO `balance_libro` VALUES (3870,7922,40721,3054,3,2576,'App\\Models\\Receipt',2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',10406.74,NULL,NULL,1,'2023-04-20 16:03:41','2023-04-20 16:03:41',NULL),(3871,7922,40721,3054,3,2577,'App\\Models\\Receipt',2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',10507.23,NULL,NULL,1,'2023-04-20 16:03:41','2023-04-20 16:03:41',NULL),(3872,7922,40721,3054,3,2578,'App\\Models\\Receipt',2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',10507.66,NULL,NULL,1,'2023-04-20 16:03:41','2023-04-20 16:03:41',NULL),(3873,7922,40721,3054,3,2579,'App\\Models\\Receipt',2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',10018.69,NULL,NULL,1,'2023-04-20 16:03:41','2023-04-20 16:03:41',NULL),(3874,7922,40721,3054,3,2580,'App\\Models\\Receipt',2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',9437.37,NULL,NULL,1,'2023-04-20 16:03:42','2023-04-20 16:03:42',NULL),(3875,7922,40721,3054,3,2581,'App\\Models\\Receipt',2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',1843.08,NULL,NULL,1,'2023-04-20 16:03:42','2023-04-20 16:03:42',NULL),(3876,7922,40721,3054,3,2582,'App\\Models\\Receipt',2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',10210.05,NULL,NULL,1,'2023-04-20 16:03:42','2023-04-20 16:03:42',NULL),(3877,7922,40721,3054,3,2583,'App\\Models\\Receipt',2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',10320.24,NULL,NULL,1,'2023-04-20 16:03:42','2023-04-20 16:03:42',NULL),(3878,7922,40721,3054,3,2584,'App\\Models\\Receipt',2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',6696.55,NULL,NULL,1,'2023-04-20 16:03:42','2023-04-20 16:03:42',NULL),(3879,7922,40721,3054,3,2585,'App\\Models\\Receipt',2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',6854.54,NULL,NULL,1,'2023-04-20 16:03:42','2023-04-20 16:03:42',NULL),(3880,7922,40721,3054,3,2586,'App\\Models\\Receipt',2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',8331.76,NULL,NULL,1,'2023-04-20 16:03:42','2023-04-20 16:03:42',NULL),(3881,7922,40723,6064,2,2587,'App\\Models\\Receipt',2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',308655.02,NULL,NULL,1,'2023-04-24 16:50:04','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3882,7922,40723,6064,2,2588,'App\\Models\\Receipt',2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',186092.73,NULL,NULL,1,'2023-04-24 16:50:04','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3883,7922,40723,6064,2,2589,'App\\Models\\Receipt',2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',404300.03,NULL,NULL,1,'2023-04-24 16:50:04','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3884,7922,40723,6064,2,2590,'App\\Models\\Receipt',2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',926676.15,NULL,NULL,1,'2023-04-24 16:50:04','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3885,7922,40723,6064,2,2591,'App\\Models\\Receipt',2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',617870.75,NULL,NULL,1,'2023-04-24 16:50:05','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3886,7922,40723,6064,2,2592,'App\\Models\\Receipt',2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',297184.59,NULL,NULL,1,'2023-04-24 16:50:05','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3887,7922,40723,6064,2,2593,'App\\Models\\Receipt',2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',146525.95,NULL,NULL,1,'2023-04-24 16:50:05','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3888,7922,40723,6064,2,2594,'App\\Models\\Receipt',2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',258348.68,NULL,NULL,1,'2023-04-24 16:50:05','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3889,7922,40723,6064,2,2595,'App\\Models\\Receipt',2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',314699.79,NULL,NULL,1,'2023-04-24 16:50:05','2023-05-16 16:17:18','2023-05-16 16:17:18');
INSERT INTO `balance_libro` VALUES (3890,7922,40723,6064,2,2596,'App\\Models\\Receipt',2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',156450.95,NULL,NULL,1,'2023-04-24 16:50:05','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3891,7922,40723,6064,2,2597,'App\\Models\\Receipt',2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',593767.22,NULL,NULL,1,'2023-04-24 16:50:05','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3892,7922,40723,6064,2,2598,'App\\Models\\Receipt',2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',562355.65,NULL,NULL,1,'2023-04-24 16:50:05','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3893,7922,40723,6064,2,2599,'App\\Models\\Receipt',2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',410284.92,NULL,NULL,1,'2023-04-24 16:50:05','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3894,7922,40723,6064,2,2600,'App\\Models\\Receipt',2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',3999.97,NULL,NULL,1,'2023-04-24 16:50:05','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3895,7922,40723,6064,2,2601,'App\\Models\\Receipt',2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',243020.86,NULL,NULL,1,'2023-04-24 16:50:05','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3896,7922,40723,6064,2,2602,'App\\Models\\Receipt',2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',354649.86,NULL,NULL,1,'2023-04-24 16:50:05','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3897,7922,40723,6064,2,2603,'App\\Models\\Receipt',2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',5160.03,NULL,NULL,1,'2023-04-24 16:50:05','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3898,7922,40723,6064,2,2604,'App\\Models\\Receipt',2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',19676.05,NULL,NULL,1,'2023-04-24 16:50:05','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3899,7922,40723,6064,2,2605,'App\\Models\\Receipt',2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',13200.01,NULL,NULL,1,'2023-04-24 16:50:05','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3900,7922,40723,6064,2,2606,'App\\Models\\Receipt',2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',8310.97,NULL,NULL,1,'2023-04-24 16:50:05','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3901,7922,40723,6064,2,2607,'App\\Models\\Receipt',2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',1340456.35,NULL,NULL,1,'2023-04-24 16:50:05','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3902,7922,40723,6064,2,2608,'App\\Models\\Receipt',2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',4929.98,NULL,NULL,1,'2023-04-24 16:50:05','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3903,7922,40723,6064,2,2609,'App\\Models\\Receipt',2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',27228.04,NULL,NULL,1,'2023-04-24 16:50:12','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3904,7922,40723,6064,2,2610,'App\\Models\\Receipt',2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',301435.05,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3905,7922,40723,6064,2,2611,'App\\Models\\Receipt',2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',123269.06,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3906,7922,40723,6064,2,2612,'App\\Models\\Receipt',2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',241157.09,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3907,7922,40723,6064,2,2613,'App\\Models\\Receipt',2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',400869.58,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3908,7922,40723,6064,2,2614,'App\\Models\\Receipt',2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',82005.00,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18');
INSERT INTO `balance_libro` VALUES (3909,7922,40723,6064,2,2615,'App\\Models\\Receipt',2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',68247.01,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3910,7922,40723,6064,2,2616,'App\\Models\\Receipt',2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',26484.96,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3911,7922,40723,6064,2,2617,'App\\Models\\Receipt',2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',16079.96,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3912,7922,40723,6064,2,2618,'App\\Models\\Receipt',2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',8063.97,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3913,7922,40723,6064,2,2619,'App\\Models\\Receipt',2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',3970.95,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3914,7922,40723,6064,2,2620,'App\\Models\\Receipt',2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',324000.10,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3915,7922,40723,6064,2,2621,'App\\Models\\Receipt',2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',414539.80,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3916,7922,40723,6064,2,2622,'App\\Models\\Receipt',2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',26574.93,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3917,7922,40723,6064,2,2623,'App\\Models\\Receipt',2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',595600.16,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3918,7922,40723,6064,2,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',26402.03,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3919,7922,40723,6064,2,2625,'App\\Models\\Receipt',2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',259876.64,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3920,7922,40723,6064,2,2626,'App\\Models\\Receipt',2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',9700.01,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3921,7922,40723,6064,2,2627,'App\\Models\\Receipt',2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',35184.99,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3922,7922,40723,6064,2,2628,'App\\Models\\Receipt',2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',1102499.86,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3923,7922,40723,6064,2,2629,'App\\Models\\Receipt',2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',577324.40,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3924,7922,40723,6064,2,2630,'App\\Models\\Receipt',2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',43855.03,NULL,NULL,1,'2023-04-24 16:50:13','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3925,7922,40723,6064,2,2631,'App\\Models\\Receipt',2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',3999.97,NULL,NULL,1,'2023-04-24 16:50:30','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3926,7922,40723,6064,2,2632,'App\\Models\\Receipt',2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',14900.03,NULL,NULL,1,'2023-04-24 16:50:30','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3927,7922,40723,6064,2,2633,'App\\Models\\Receipt',2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',5160.03,NULL,NULL,1,'2023-04-24 16:50:30','2023-05-16 16:17:18','2023-05-16 16:17:18');
INSERT INTO `balance_libro` VALUES (3928,7922,40723,6064,2,2634,'App\\Models\\Receipt',2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',14665.03,NULL,NULL,1,'2023-04-24 16:50:30','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3929,7922,40723,6064,2,2635,'App\\Models\\Receipt',2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',3157.98,NULL,NULL,1,'2023-04-24 16:50:30','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3930,7922,40723,6064,2,2636,'App\\Models\\Receipt',2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',1853.03,NULL,NULL,1,'2023-04-24 16:50:30','2023-05-16 16:17:18','2023-05-16 16:17:18'),(3931,7922,40723,6064,2,2637,'App\\Models\\Receipt',2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5100.05,NULL,NULL,1,'2023-04-24 16:50:30','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3932,7922,40723,6064,2,2638,'App\\Models\\Receipt',2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',8099.97,NULL,NULL,1,'2023-04-24 16:50:30','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3933,7922,40723,6064,2,2639,'App\\Models\\Receipt',2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',8310.97,NULL,NULL,1,'2023-04-24 16:50:30','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3934,7922,40723,6064,2,2640,'App\\Models\\Receipt',2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',4929.98,NULL,NULL,1,'2023-04-24 16:50:30','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3935,7922,40723,6064,2,2641,'App\\Models\\Receipt',2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',27228.04,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3936,7922,40723,6064,2,2642,'App\\Models\\Receipt',2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',45995.05,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3937,7922,40723,6064,2,2643,'App\\Models\\Receipt',2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',6166.95,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3938,7922,40723,6064,2,2644,'App\\Models\\Receipt',2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',10000.04,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3939,7922,40723,6064,2,2645,'App\\Models\\Receipt',2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',61107.03,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3940,7922,40723,6064,2,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',62385.04,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3941,7922,40723,6064,2,2647,'App\\Models\\Receipt',2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',19619.96,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3942,7922,40723,6064,2,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',64167.03,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3943,7922,40723,6064,2,2649,'App\\Models\\Receipt',2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',4079.98,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3944,7922,40723,6064,2,2650,'App\\Models\\Receipt',2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',26484.96,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3945,7922,40723,6064,2,2651,'App\\Models\\Receipt',2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',16079.96,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3946,7922,40723,6064,2,2652,'App\\Models\\Receipt',2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',8063.97,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19');
INSERT INTO `balance_libro` VALUES (3947,7922,40723,6064,2,2653,'App\\Models\\Receipt',2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',3970.95,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3948,7922,40723,6064,2,2654,'App\\Models\\Receipt',2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',56000.03,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3949,7922,40723,6064,2,2655,'App\\Models\\Receipt',2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',14623.99,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3950,7922,40723,6064,2,2656,'App\\Models\\Receipt',2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',5419.97,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3951,7922,40723,6064,2,2657,'App\\Models\\Receipt',2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',21154.96,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3952,7922,40723,6064,2,2658,'App\\Models\\Receipt',2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',30722.05,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3953,7922,40723,6064,2,2659,'App\\Models\\Receipt',2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',18181.04,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3954,7922,40723,6064,2,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8220.99,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3955,7922,40723,6064,2,2661,'App\\Models\\Receipt',2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',4850.00,NULL,NULL,1,'2023-04-24 16:50:36','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3956,7922,40723,6064,2,2662,'App\\Models\\Receipt',2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',4850.00,NULL,NULL,1,'2023-04-24 16:50:37','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3957,7922,40723,6064,2,2663,'App\\Models\\Receipt',2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',35184.99,NULL,NULL,1,'2023-04-24 16:50:37','2023-05-16 16:17:19','2023-05-16 16:17:19'),(3958,7922,40723,6064,2,2664,'App\\Models\\Receipt',2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',43855.03,NULL,NULL,1,'2023-04-24 16:50:37','2023-05-16 16:17:19','2023-05-16 16:17:19'),(4093,7922,40721,3055,2,2799,'App\\Models\\Receipt',2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',300.00,NULL,NULL,1,'2023-04-25 10:06:23','2023-04-25 10:06:23',NULL),(4094,7922,40721,3055,2,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',900.00,NULL,NULL,1,'2023-04-25 10:06:23','2023-04-25 10:06:23',NULL),(4095,7922,40721,3055,2,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1200.00,NULL,NULL,1,'2023-04-25 10:06:23','2023-04-25 10:06:23',NULL),(4096,7922,40721,3055,2,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',3050.00,NULL,NULL,1,'2023-04-25 10:06:24','2023-04-25 10:06:24',NULL),(4097,7922,40721,3055,2,2803,'App\\Models\\Receipt',2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1100.00,NULL,NULL,1,'2023-04-25 10:06:24','2023-04-25 10:06:24',NULL),(4098,7922,40721,3055,2,2804,'App\\Models\\Receipt',2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',3900.00,NULL,NULL,1,'2023-04-25 10:06:24','2023-04-25 10:06:24',NULL),(4099,7922,40721,3055,2,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',3100.00,NULL,NULL,1,'2023-04-25 10:06:24','2023-04-25 10:06:24',NULL),(4100,7922,40721,3055,2,2806,'App\\Models\\Receipt',2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',3200.00,NULL,NULL,1,'2023-04-25 10:06:24','2023-04-25 10:06:24',NULL);
INSERT INTO `balance_libro` VALUES (4101,7922,40721,3055,2,2807,'App\\Models\\Receipt',2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',5050.00,NULL,NULL,1,'2023-04-25 10:06:24','2023-04-25 10:06:24',NULL),(4102,7922,40721,3055,2,2808,'App\\Models\\Receipt',2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',76345.20,NULL,NULL,1,'2023-04-25 10:06:24','2023-04-25 10:06:24',NULL),(4103,7922,40721,3055,2,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',3250.00,NULL,NULL,1,'2023-04-25 10:06:24','2023-04-25 10:06:24',NULL),(4104,7922,40721,3055,2,2810,'App\\Models\\Receipt',2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',10500.00,NULL,NULL,1,'2023-04-25 10:06:24','2023-04-25 10:06:24',NULL),(4105,7922,40721,3055,2,2811,'App\\Models\\Receipt',2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',6000.00,NULL,NULL,1,'2023-04-25 10:06:24','2023-04-25 10:06:24',NULL),(4106,7922,40721,3055,2,2812,'App\\Models\\Receipt',2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',2700.00,NULL,NULL,1,'2023-04-25 10:06:24','2023-04-25 10:06:24',NULL),(4107,7922,40721,3055,2,2813,'App\\Models\\Receipt',2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1300.00,NULL,NULL,1,'2023-04-25 10:06:24','2023-04-25 10:06:24',NULL),(4108,7922,40721,3055,2,2814,'App\\Models\\Receipt',2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',500.00,NULL,NULL,1,'2023-04-25 10:06:25','2023-04-25 10:06:25',NULL),(4109,7922,40721,3055,2,2815,'App\\Models\\Receipt',2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',800.00,NULL,NULL,1,'2023-04-25 10:06:25','2023-04-25 10:06:25',NULL),(4110,7922,40721,3055,2,2816,'App\\Models\\Receipt',2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',300.00,NULL,NULL,1,'2023-04-25 10:06:25','2023-04-25 10:06:25',NULL),(4111,7922,40721,3055,2,2817,'App\\Models\\Receipt',2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1400.00,NULL,NULL,1,'2023-04-25 10:06:25','2023-04-25 10:06:25',NULL),(4112,7922,40721,3055,2,2818,'App\\Models\\Receipt',2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1350.00,NULL,NULL,1,'2023-04-25 10:06:25','2023-04-25 10:06:25',NULL),(4113,7922,40721,3055,2,2819,'App\\Models\\Receipt',2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',10.00,NULL,NULL,1,'2023-04-25 10:06:25','2023-04-25 10:06:25',NULL),(4114,7922,40721,3055,2,2820,'App\\Models\\Receipt',2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',17270.00,NULL,NULL,1,'2023-04-25 10:06:25','2023-04-25 10:06:25',NULL),(4115,7922,40721,3055,2,2821,'App\\Models\\Receipt',2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',2750.00,NULL,NULL,1,'2023-04-25 10:06:25','2023-04-25 10:06:25',NULL),(4116,7922,40721,3055,2,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',3500.00,NULL,NULL,1,'2023-04-25 10:06:25','2023-04-25 10:06:25',NULL),(4117,7922,40721,3055,2,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',33670.58,NULL,NULL,1,'2023-04-25 10:06:25','2023-04-25 10:06:25',NULL),(4118,7922,40721,3055,2,2824,'App\\Models\\Receipt',2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',14550.00,NULL,NULL,1,'2023-04-25 10:06:25','2023-04-25 10:06:25',NULL),(4119,7922,40721,3055,2,2825,'App\\Models\\Receipt',2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',800.00,NULL,NULL,1,'2023-04-25 10:06:25','2023-04-25 10:06:25',NULL),(4120,7922,40721,3055,2,2826,'App\\Models\\Receipt',2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',2600.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL),(4121,7922,40721,3055,2,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',500.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL);
INSERT INTO `balance_libro` VALUES (4122,7922,40721,3055,2,2828,'App\\Models\\Receipt',2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',50.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL),(4123,7922,40721,3055,2,2829,'App\\Models\\Receipt',2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',4100.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL),(4124,7922,40721,3055,2,2830,'App\\Models\\Receipt',2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',4950.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL),(4125,7922,40721,3055,2,2831,'App\\Models\\Receipt',2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1100.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL),(4126,7922,40721,3055,2,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',120.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL),(4127,7922,40721,3055,2,2833,'App\\Models\\Receipt',2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1100.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL),(4128,7922,40721,3055,2,2834,'App\\Models\\Receipt',2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',360.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL),(4129,7922,40721,3055,2,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',3200.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL),(4130,7922,40721,3055,2,2836,'App\\Models\\Receipt',2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',1100.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL),(4131,7922,40721,3055,2,2837,'App\\Models\\Receipt',2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',6500.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL),(4132,7922,40721,3055,2,2838,'App\\Models\\Receipt',2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',4500.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL),(4133,7922,40721,3055,2,2839,'App\\Models\\Receipt',2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',1400.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL),(4134,7922,40721,3055,2,2840,'App\\Models\\Receipt',2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',450.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL),(4135,7922,40721,3055,2,2841,'App\\Models\\Receipt',2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',700.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL),(4136,7922,40721,3055,2,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',2900.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL),(4137,7922,40721,3055,2,2843,'App\\Models\\Receipt',2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',150.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL),(4138,7922,40721,3055,2,2844,'App\\Models\\Receipt',2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',2350.00,NULL,NULL,1,'2023-04-25 10:06:26','2023-04-25 10:06:26',NULL),(4139,7922,40721,3055,2,2845,'App\\Models\\Receipt',2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',2600.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4140,7922,40721,3055,2,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',1000.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4141,7922,40721,3055,2,2847,'App\\Models\\Receipt',2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',1750.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4142,7922,40721,3055,2,2848,'App\\Models\\Receipt',2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',1700.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL);
INSERT INTO `balance_libro` VALUES (4143,7922,40721,3055,2,2849,'App\\Models\\Receipt',2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',300.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4144,7922,40721,3055,2,2850,'App\\Models\\Receipt',2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',500.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4145,7922,40721,3055,2,2851,'App\\Models\\Receipt',2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',2500.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4146,7922,40721,3055,2,2852,'App\\Models\\Receipt',2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',4500.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4147,7922,40721,3055,2,2853,'App\\Models\\Receipt',2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',1650.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4148,7922,40721,3055,2,2854,'App\\Models\\Receipt',2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',7400.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4149,7922,40721,3055,2,2855,'App\\Models\\Receipt',2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',2200.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4150,7922,40721,3055,2,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',3000.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4151,7922,40721,3055,2,2857,'App\\Models\\Receipt',2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',5000.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4152,7922,40721,3055,2,2858,'App\\Models\\Receipt',2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',600.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4153,7922,40721,3055,2,2859,'App\\Models\\Receipt',2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',6000.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4154,7922,40721,3055,2,2860,'App\\Models\\Receipt',2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',2700.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4155,7922,40721,3055,2,2861,'App\\Models\\Receipt',2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',4000.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4156,7922,40721,3055,2,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',8300.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4157,7922,40721,3055,2,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',1300.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4158,7922,40721,3055,2,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',3000.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4159,7922,40721,3055,2,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',3300.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4160,7922,40721,3055,2,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',4000.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4161,7922,40721,3055,2,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',5900.00,NULL,NULL,1,'2023-04-25 10:06:27','2023-04-25 10:06:27',NULL),(4162,7922,40721,3055,2,2868,'App\\Models\\Receipt',2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',16000.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4163,7922,40721,3055,2,2869,'App\\Models\\Receipt',2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1900.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL);
INSERT INTO `balance_libro` VALUES (4164,7922,40721,3055,2,2870,'App\\Models\\Receipt',2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',2600.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4165,7922,40721,3055,2,2871,'App\\Models\\Receipt',2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1000.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4166,7922,40721,3055,2,2872,'App\\Models\\Receipt',2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1500.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4167,7922,40721,3055,2,2873,'App\\Models\\Receipt',2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',2500.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4168,7922,40721,3055,2,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',750.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4169,7922,40721,3055,2,2875,'App\\Models\\Receipt',2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1500.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4170,7922,40721,3055,2,2876,'App\\Models\\Receipt',2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',500.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4171,7922,40721,3055,2,2877,'App\\Models\\Receipt',2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',9096.50,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4172,7922,40721,3055,2,2878,'App\\Models\\Receipt',2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1450.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4173,7922,40721,3055,2,2879,'App\\Models\\Receipt',2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',13000.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4174,7922,40721,3055,2,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',500.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4175,7922,40721,3055,2,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',9593.70,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4176,7922,40721,3055,2,2882,'App\\Models\\Receipt',2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',37800.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4177,7922,40721,3055,2,2883,'App\\Models\\Receipt',2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',375.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4178,7922,40721,3055,2,2884,'App\\Models\\Receipt',2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1100.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4179,7922,40721,3055,2,2885,'App\\Models\\Receipt',2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',600.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4180,7922,40721,3055,2,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',4150.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4181,7922,40721,3055,2,2887,'App\\Models\\Receipt',2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',18700.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4182,7922,40721,3055,2,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',30700.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4183,7922,40721,3055,2,2889,'App\\Models\\Receipt',2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1250.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4184,7922,40721,3055,2,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',2600.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL);
INSERT INTO `balance_libro` VALUES (4185,7922,40721,3055,2,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',50.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4186,7922,40721,3055,2,2892,'App\\Models\\Receipt',2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',700.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4187,7922,40721,3055,2,2893,'App\\Models\\Receipt',2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3600.00,NULL,NULL,1,'2023-04-25 10:06:28','2023-04-25 10:06:28',NULL),(4188,7922,40721,3055,2,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3900.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4189,7922,40721,3055,2,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',6300.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4190,7922,40721,3055,2,2896,'App\\Models\\Receipt',2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',16750.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4191,7922,40721,3055,2,2897,'App\\Models\\Receipt',2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',450.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4192,7922,40721,3055,2,2898,'App\\Models\\Receipt',2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',2500.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4193,7922,40721,3055,2,2899,'App\\Models\\Receipt',2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',1100.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4194,7922,40721,3055,2,2900,'App\\Models\\Receipt',2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',2200.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4195,7922,40721,3055,2,2901,'App\\Models\\Receipt',2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',2100.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4196,7922,40721,3055,2,2902,'App\\Models\\Receipt',2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',400.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4197,7922,40721,3055,2,2903,'App\\Models\\Receipt',2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',1100.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4198,7922,40721,3055,2,2904,'App\\Models\\Receipt',2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',1200.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4199,7922,40721,3055,2,2905,'App\\Models\\Receipt',2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',3600.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4200,7922,40721,3055,2,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',1300.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4201,7922,40721,3055,2,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',400.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4202,7922,40721,3055,2,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',1500.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4203,7922,40721,3055,2,2909,'App\\Models\\Receipt',2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',3500.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4204,7922,40721,3055,2,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',1700.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4205,7922,40721,3055,2,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',6400.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL);
INSERT INTO `balance_libro` VALUES (4206,7922,40721,3055,2,2912,'App\\Models\\Receipt',2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',3900.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4207,7922,40721,3055,2,2913,'App\\Models\\Receipt',2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',2000.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4208,7922,40721,3055,2,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',1200.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4209,7922,40721,3055,2,2915,'App\\Models\\Receipt',2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',1000.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4210,7922,40721,3055,2,2916,'App\\Models\\Receipt',2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',1200.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4211,7922,40721,3055,2,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',400.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4212,7922,40721,3055,2,2918,'App\\Models\\Receipt',2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',600.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4213,7922,40721,3055,2,2919,'App\\Models\\Receipt',2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',4900.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4214,7922,40721,3055,2,2920,'App\\Models\\Receipt',2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',2250.00,NULL,NULL,1,'2023-04-25 10:06:29','2023-04-25 10:06:29',NULL),(4215,7922,40721,3055,2,2921,'App\\Models\\Receipt',2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',6000.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4216,7922,40721,3055,2,2922,'App\\Models\\Receipt',2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',3900.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4217,7922,40721,3055,2,2923,'App\\Models\\Receipt',2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',1200.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4218,7922,40721,3055,2,2924,'App\\Models\\Receipt',2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',600.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4219,7922,40721,3055,2,2925,'App\\Models\\Receipt',2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',1000.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4220,7922,40721,3055,2,2926,'App\\Models\\Receipt',2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',400.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4221,7922,40721,3055,2,2927,'App\\Models\\Receipt',2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',750.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4222,7922,40721,3055,2,2928,'App\\Models\\Receipt',2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',600.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4223,7922,40721,3055,2,2929,'App\\Models\\Receipt',2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',1800.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4224,7922,40721,3055,2,2930,'App\\Models\\Receipt',2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',1010.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4225,7922,40721,3055,2,2931,'App\\Models\\Receipt',2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',1000.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4226,7922,40721,3055,2,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',1000.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL);
INSERT INTO `balance_libro` VALUES (4227,7922,40721,3055,2,2933,'App\\Models\\Receipt',2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',1850.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-05-15 17:13:26','2023-05-15 17:13:26'),(4228,7922,40721,3055,2,2934,'App\\Models\\Receipt',2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',5200.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4229,7922,40721,3055,2,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',1365.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4230,7922,40721,3055,2,2936,'App\\Models\\Receipt',2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',1500.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4231,7922,40721,3055,2,2937,'App\\Models\\Receipt',2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',7000.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4232,7922,40721,3055,2,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',5000.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4233,7922,40721,3055,2,2939,'App\\Models\\Receipt',2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',1000.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4234,7922,40721,3055,2,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',1390.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4235,7922,40721,3055,2,2941,'App\\Models\\Receipt',2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',31562.50,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4236,7922,40721,3055,2,2942,'App\\Models\\Receipt',2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',3500.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4237,7922,40721,3055,2,2943,'App\\Models\\Receipt',2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',3500.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4238,7922,40721,3055,2,2944,'App\\Models\\Receipt',2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',2500.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4239,7922,40721,3055,2,2945,'App\\Models\\Receipt',2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',7500.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4240,7922,40721,3055,2,2946,'App\\Models\\Receipt',2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',3650.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4241,7922,40721,3055,2,2947,'App\\Models\\Receipt',2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',1050.00,NULL,NULL,1,'2023-04-25 10:06:30','2023-04-25 10:06:30',NULL),(4242,7922,40721,3055,2,2948,'App\\Models\\Receipt',2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',750.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4243,7922,40721,3055,2,2949,'App\\Models\\Receipt',2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',73125.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4244,7922,40721,3055,2,2950,'App\\Models\\Receipt',2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',300.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4245,7922,40721,3055,2,2951,'App\\Models\\Receipt',2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',21000.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4246,7922,40721,3055,2,2952,'App\\Models\\Receipt',2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',22885.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4247,7922,40721,3055,2,2953,'App\\Models\\Receipt',2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',3500.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL);
INSERT INTO `balance_libro` VALUES (4248,7922,40721,3055,2,2954,'App\\Models\\Receipt',2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',7562.50,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4249,7922,40721,3055,2,2955,'App\\Models\\Receipt',2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',2500.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4250,7922,40721,3055,2,2956,'App\\Models\\Receipt',2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',4500.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4251,7922,40721,3055,2,2957,'App\\Models\\Receipt',2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',17000.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4252,7922,40721,3055,2,2958,'App\\Models\\Receipt',2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',600.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4253,7922,40721,3055,2,2959,'App\\Models\\Receipt',2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',20000.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4254,7922,40721,3055,2,2960,'App\\Models\\Receipt',2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',2700.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4255,7922,40721,3055,2,2961,'App\\Models\\Receipt',2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',800.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4256,7922,40721,3055,2,2962,'App\\Models\\Receipt',2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',1050.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4257,7922,40721,3055,2,2963,'App\\Models\\Receipt',2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',2500.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4258,7922,40721,3055,2,2964,'App\\Models\\Receipt',2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',700.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4259,7922,40721,3055,2,2965,'App\\Models\\Receipt',2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',950.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4260,7922,40721,3055,2,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',900.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4261,7922,40721,3055,2,2967,'App\\Models\\Receipt',2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',800.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4262,7922,40721,3055,2,2968,'App\\Models\\Receipt',2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',6500.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4263,7922,40721,3055,2,2969,'App\\Models\\Receipt',2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',2800.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4264,7922,40721,3055,2,2970,'App\\Models\\Receipt',2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',32500.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4265,7922,40721,3055,2,2971,'App\\Models\\Receipt',2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',1300.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4266,7922,40721,3055,2,2972,'App\\Models\\Receipt',2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',4000.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4267,7922,40721,3055,2,2973,'App\\Models\\Receipt',2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',3200.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4268,7922,40721,3055,2,2974,'App\\Models\\Receipt',2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8250.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL);
INSERT INTO `balance_libro` VALUES (4269,7922,40721,3055,2,2975,'App\\Models\\Receipt',2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8042.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4270,7922,40721,3055,2,2976,'App\\Models\\Receipt',2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',600.00,NULL,NULL,1,'2023-04-25 10:06:31','2023-04-25 10:06:31',NULL),(4271,7922,40721,3055,2,2977,'App\\Models\\Receipt',2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',30008.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4272,7922,40721,3055,2,2978,'App\\Models\\Receipt',2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',123309.89,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4273,7922,40721,3055,2,2979,'App\\Models\\Receipt',2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',8060.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4274,7922,40721,3055,2,2980,'App\\Models\\Receipt',2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',2100.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4275,7922,40721,3055,2,2981,'App\\Models\\Receipt',2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',2860.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4276,7922,40721,3055,2,2982,'App\\Models\\Receipt',2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',1100.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4277,7922,40721,3055,2,2983,'App\\Models\\Receipt',2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',600.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4278,7922,40721,3055,2,2984,'App\\Models\\Receipt',2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',1500.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4279,7922,40721,3055,2,2985,'App\\Models\\Receipt',2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',600.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4280,7922,40721,3055,2,2986,'App\\Models\\Receipt',2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',5100.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4281,7922,40721,3055,2,2987,'App\\Models\\Receipt',2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',5800.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4282,7922,40721,3055,2,2988,'App\\Models\\Receipt',2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',200.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4283,7922,40721,3055,2,2989,'App\\Models\\Receipt',2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',400.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4284,7922,40721,3055,2,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',1200.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4285,7922,40721,3055,2,2991,'App\\Models\\Receipt',2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',200.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4286,7922,40721,3055,2,2992,'App\\Models\\Receipt',2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',3100.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4287,7922,40721,3055,2,2993,'App\\Models\\Receipt',2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',5300.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4288,7922,40721,3055,2,2994,'App\\Models\\Receipt',2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',2100.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4289,7922,40721,3055,2,2995,'App\\Models\\Receipt',2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',650.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL);
INSERT INTO `balance_libro` VALUES (4290,7922,40721,3055,2,2996,'App\\Models\\Receipt',2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',700.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4291,7922,40721,3055,2,2997,'App\\Models\\Receipt',2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',450.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4292,7922,40721,3055,2,2998,'App\\Models\\Receipt',2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',540.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4293,7922,40721,3055,2,2999,'App\\Models\\Receipt',2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',1500.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4294,7922,40721,3055,2,3000,'App\\Models\\Receipt',3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',5100.00,NULL,NULL,1,'2023-04-25 10:06:32','2023-04-25 10:06:32',NULL),(4295,7922,40721,3055,2,3001,'App\\Models\\Receipt',3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',1500.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4296,7922,40721,3055,2,3002,'App\\Models\\Receipt',3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',13000.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4297,7922,40721,3055,2,3003,'App\\Models\\Receipt',3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',2860.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4298,7922,40721,3055,2,3004,'App\\Models\\Receipt',3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',1250.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4299,7922,40721,3055,2,3005,'App\\Models\\Receipt',3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',750.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4300,7922,40721,3055,2,3006,'App\\Models\\Receipt',3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',4500.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4301,7922,40721,3055,2,3007,'App\\Models\\Receipt',3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',1000.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4302,7922,40721,3055,2,3008,'App\\Models\\Receipt',3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',540.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4303,7922,40721,3055,2,3009,'App\\Models\\Receipt',3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',14750.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4304,7922,40721,3055,2,3010,'App\\Models\\Receipt',3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',740.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4305,7922,40721,3055,2,3011,'App\\Models\\Receipt',3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',21600.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4306,7922,40721,3055,2,3012,'App\\Models\\Receipt',3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',800.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4307,7922,40721,3055,2,3013,'App\\Models\\Receipt',3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',3600.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4308,7922,40721,3055,2,3014,'App\\Models\\Receipt',3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',3000.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4309,7922,40721,3055,2,3015,'App\\Models\\Receipt',3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',5970.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4310,7922,40721,3055,2,3016,'App\\Models\\Receipt',3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',1200.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL);
INSERT INTO `balance_libro` VALUES (4311,7922,40721,3055,2,3017,'App\\Models\\Receipt',3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',7450.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4312,7922,40721,3055,2,3018,'App\\Models\\Receipt',3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',4500.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4313,7922,40721,3055,2,3019,'App\\Models\\Receipt',3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',400.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4314,7922,40721,3055,2,3020,'App\\Models\\Receipt',3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',1575.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4315,7922,40721,3055,2,3021,'App\\Models\\Receipt',3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',35000.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4316,7922,40721,3055,2,3022,'App\\Models\\Receipt',3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',3500.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4317,7922,40721,3055,2,3023,'App\\Models\\Receipt',3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',3900.00,NULL,NULL,1,'2023-04-25 10:06:33','2023-04-25 10:06:33',NULL),(4318,7922,40721,3055,2,3024,'App\\Models\\Receipt',3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',8900.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL),(4319,7922,40721,3055,2,3025,'App\\Models\\Receipt',3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',1500.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL),(4320,7922,40721,3055,2,3026,'App\\Models\\Receipt',3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',2300.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL),(4321,7922,40721,3055,2,3027,'App\\Models\\Receipt',3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',1000.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL),(4322,7922,40721,3055,2,3028,'App\\Models\\Receipt',3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',4600.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL),(4323,7922,40721,3055,2,3029,'App\\Models\\Receipt',3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',8900.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL),(4324,7922,40721,3055,2,3030,'App\\Models\\Receipt',3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',1575.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL),(4325,7922,40721,3055,2,3031,'App\\Models\\Receipt',3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',3500.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL),(4326,7922,40721,3055,2,3032,'App\\Models\\Receipt',3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',2200.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL),(4327,7922,40721,3055,2,3033,'App\\Models\\Receipt',3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',250.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL),(4328,7922,40721,3055,2,3034,'App\\Models\\Receipt',3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',300.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL),(4329,7922,40721,3055,2,3035,'App\\Models\\Receipt',3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',4500.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL),(4330,7922,40721,3055,2,3036,'App\\Models\\Receipt',3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',450.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL),(4331,7922,40721,3055,2,3037,'App\\Models\\Receipt',3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',600.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL);
INSERT INTO `balance_libro` VALUES (4332,7922,40721,3055,2,3038,'App\\Models\\Receipt',3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',1500.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL),(4333,7922,40721,3055,2,3039,'App\\Models\\Receipt',3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',3500.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL),(4334,7922,40721,3055,2,3040,'App\\Models\\Receipt',3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',2900.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL),(4335,7922,40721,3055,2,3041,'App\\Models\\Receipt',3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',1000.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL),(4336,7922,40721,3055,2,3042,'App\\Models\\Receipt',3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',7000.00,NULL,NULL,1,'2023-04-25 10:06:34','2023-04-25 10:06:34',NULL),(4337,7922,40721,3055,2,3043,'App\\Models\\Receipt',3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',1200.00,NULL,NULL,1,'2023-04-25 10:06:35','2023-04-25 10:06:35',NULL),(4338,7922,40721,3055,2,3044,'App\\Models\\Receipt',3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',220.00,NULL,NULL,1,'2023-04-25 10:06:35','2023-04-25 10:06:35',NULL),(4339,7922,40721,3055,2,3045,'App\\Models\\Receipt',3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',800.00,NULL,NULL,1,'2023-04-25 10:06:35','2023-04-25 10:06:35',NULL),(4340,7922,40721,3055,2,3046,'App\\Models\\Receipt',3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',4100.00,NULL,NULL,1,'2023-04-25 10:06:35','2023-04-25 10:06:35',NULL),(4341,7922,40721,3055,2,3047,'App\\Models\\Receipt',3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',1200.00,NULL,NULL,1,'2023-04-25 10:06:35','2023-04-25 10:06:35',NULL),(4342,7922,40721,3055,2,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',200.00,NULL,NULL,1,'2023-04-25 10:06:35','2023-04-25 10:06:35',NULL),(4343,7922,40721,3055,2,3049,'App\\Models\\Receipt',3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',300.00,NULL,NULL,1,'2023-04-25 10:06:35','2023-04-25 10:06:35',NULL),(4344,7922,40721,3055,2,3050,'App\\Models\\Receipt',3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',300.00,NULL,NULL,1,'2023-04-25 10:06:35','2023-04-25 10:06:35',NULL),(4345,7922,40721,3055,2,3051,'App\\Models\\Receipt',3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',7700.00,NULL,NULL,1,'2023-04-25 10:06:35','2023-04-25 10:06:35',NULL),(4346,7922,40721,3055,2,3052,'App\\Models\\Receipt',3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',1800.00,NULL,NULL,1,'2023-04-25 10:06:35','2023-04-25 10:06:35',NULL),(4347,7922,40721,3055,2,3053,'App\\Models\\Receipt',3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',3700.00,NULL,NULL,1,'2023-04-25 10:06:35','2023-04-25 10:06:35',NULL),(4348,7922,40721,3055,3,3054,'App\\Models\\Receipt',3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',8400.00,NULL,NULL,1,'2023-04-25 10:26:53','2023-04-25 10:26:53',NULL),(4349,7922,40721,3055,3,3055,'App\\Models\\Receipt',3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',10499.00,NULL,NULL,1,'2023-04-25 10:26:53','2023-04-25 10:26:53',NULL),(4350,7922,40721,3055,3,3056,'App\\Models\\Receipt',3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',11999.00,NULL,NULL,1,'2023-04-25 10:26:53','2023-04-25 10:26:53',NULL),(4351,7922,40721,3055,3,3057,'App\\Models\\Receipt',3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',5742.31,NULL,NULL,1,'2023-04-25 10:26:53','2023-04-25 10:26:53',NULL),(4352,7922,40721,3055,3,3058,'App\\Models\\Receipt',3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',125165.31,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL);
INSERT INTO `balance_libro` VALUES (4353,7922,40721,3055,3,3059,'App\\Models\\Receipt',3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',39832.09,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4354,7922,40721,3055,3,3060,'App\\Models\\Receipt',3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',4842.37,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4355,7922,40721,3055,3,3061,'App\\Models\\Receipt',3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',82950.00,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4356,7922,40721,3055,3,3062,'App\\Models\\Receipt',3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',13076.30,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4357,7922,40721,3055,3,3063,'App\\Models\\Receipt',3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',27997.08,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4358,7922,40721,3055,3,3064,'App\\Models\\Receipt',3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',210472.24,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4359,7922,40721,3055,3,3065,'App\\Models\\Receipt',3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',4830.05,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4360,7922,40721,3055,3,3066,'App\\Models\\Receipt',3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',4573.44,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4361,7922,40721,3055,3,3067,'App\\Models\\Receipt',3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',4874.68,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4362,7922,40721,3055,3,3068,'App\\Models\\Receipt',3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',6951.24,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4363,7922,40721,3055,3,3069,'App\\Models\\Receipt',3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',1102.00,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4364,7922,40721,3055,3,3070,'App\\Models\\Receipt',3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',4947.65,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4365,7922,40721,3055,3,3071,'App\\Models\\Receipt',3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',60000.00,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4366,7922,40721,3055,3,3072,'App\\Models\\Receipt',3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',195000.00,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4367,7922,40721,3055,3,3073,'App\\Models\\Receipt',3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',18798.32,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4368,7922,40721,3055,3,3074,'App\\Models\\Receipt',3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',3272.00,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4369,7922,40721,3055,3,3075,'App\\Models\\Receipt',3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',13842.29,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4370,7922,40721,3055,3,3076,'App\\Models\\Receipt',3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',371421.60,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4371,7922,40721,3055,3,3077,'App\\Models\\Receipt',3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',9187.64,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4372,7922,40721,3055,3,3078,'App\\Models\\Receipt',3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',7713.00,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4373,7922,40721,3055,3,3079,'App\\Models\\Receipt',3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',37550.39,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL);
INSERT INTO `balance_libro` VALUES (4374,7922,40721,3055,3,3080,'App\\Models\\Receipt',3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',37250.04,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4375,7922,40721,3055,3,3081,'App\\Models\\Receipt',3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',1296904.95,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4376,7922,40721,3055,3,3082,'App\\Models\\Receipt',3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',3900.00,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4377,7922,40721,3055,3,3083,'App\\Models\\Receipt',3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',113391.00,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4378,7922,40721,3055,3,3084,'App\\Models\\Receipt',3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',84420.91,NULL,NULL,1,'2023-04-25 10:26:54','2023-04-25 10:26:54',NULL),(4379,7922,40721,3055,3,3085,'App\\Models\\Receipt',3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',88160.00,NULL,NULL,1,'2023-04-25 10:26:55','2023-04-25 10:26:55',NULL),(4380,7922,40721,3055,3,3086,'App\\Models\\Receipt',3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',14500.01,NULL,NULL,1,'2023-04-25 10:26:55','2023-04-25 10:26:55',NULL),(4381,7922,40721,3055,3,3087,'App\\Models\\Receipt',3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',88160.00,NULL,NULL,1,'2023-04-25 10:26:55','2023-04-25 10:26:55',NULL),(4382,7922,40721,3055,3,3088,'App\\Models\\Receipt',3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',4000.00,NULL,NULL,1,'2023-04-25 10:26:55','2023-04-25 10:26:55',NULL),(4383,7922,40721,3055,3,3089,'App\\Models\\Receipt',3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',13812.22,NULL,NULL,1,'2023-04-25 10:26:55','2023-04-25 10:26:55',NULL),(4384,7922,40721,3055,3,3090,'App\\Models\\Receipt',3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',3800.00,NULL,NULL,1,'2023-04-25 10:26:55','2023-04-25 10:26:55',NULL),(4385,7922,40721,3055,3,3091,'App\\Models\\Receipt',3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',5550.00,NULL,NULL,1,'2023-04-25 10:26:55','2023-04-25 10:26:55',NULL),(4386,7922,40721,3055,3,3092,'App\\Models\\Receipt',3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',3139.72,NULL,NULL,1,'2023-04-25 10:26:55','2023-04-25 10:26:55',NULL),(4387,7922,40724,7578,1,4387,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-03-31',NULL,5073619.41,'1',NULL,1,'2023-05-03 06:40:25','2023-05-03 06:40:25',NULL),(4388,7922,40723,6064,1,4388,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-04-30',NULL,670309.70,NULL,NULL,1,'2023-05-03 07:12:04','2023-05-03 07:13:11','2023-05-03 07:13:11'),(4389,7922,40962,16913,2,3093,'App\\Models\\Receipt',3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',37100.00,NULL,NULL,1,'2023-05-05 14:28:11','2023-05-05 14:28:11',NULL),(4390,7922,40962,16895,3,3094,'App\\Models\\Receipt',3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',25020.00,NULL,NULL,1,'2023-05-05 14:34:28','2023-05-05 14:34:28',NULL),(4391,7922,40962,16895,3,3095,'App\\Models\\Receipt',3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',36600.00,NULL,NULL,1,'2023-05-05 14:34:28','2023-05-05 14:34:28',NULL),(4392,7922,40962,16895,3,3096,'App\\Models\\Receipt',3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',6773.67,NULL,NULL,1,'2023-05-05 14:34:28','2023-05-05 14:34:28',NULL),(4393,7922,40962,16895,3,3097,'App\\Models\\Receipt',3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',800.54,NULL,NULL,1,'2023-05-05 14:34:28','2023-05-05 14:34:28',NULL),(4394,7922,40962,16895,3,3098,'App\\Models\\Receipt',3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2400.00,NULL,NULL,1,'2023-05-05 14:34:28','2023-05-05 14:34:28',NULL);
INSERT INTO `balance_libro` VALUES (4395,7922,40962,16896,3,3099,'App\\Models\\Receipt',3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',10972.00,NULL,NULL,1,'2023-05-05 14:34:38','2023-05-05 14:34:38',NULL),(4396,7922,40962,16897,3,3100,'App\\Models\\Receipt',3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',48999.00,NULL,NULL,1,'2023-05-05 14:34:47','2023-05-05 14:34:47',NULL),(4397,7922,40962,16897,3,3101,'App\\Models\\Receipt',3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',15527.90,NULL,NULL,1,'2023-05-05 14:34:47','2023-05-05 14:34:47',NULL),(4398,7922,40962,16897,3,3102,'App\\Models\\Receipt',3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',45139.00,NULL,NULL,1,'2023-05-05 14:34:47','2023-05-05 14:34:47',NULL),(4399,7922,40962,16897,3,3103,'App\\Models\\Receipt',3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',302.76,NULL,NULL,1,'2023-05-05 14:34:47','2023-05-05 14:34:47',NULL),(4400,7922,40962,16897,3,3104,'App\\Models\\Receipt',3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',12069.00,NULL,NULL,1,'2023-05-05 14:34:47','2023-05-05 14:34:47',NULL),(4401,7922,40962,16898,3,3105,'App\\Models\\Receipt',3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',350.00,NULL,NULL,1,'2023-05-05 14:34:54','2023-05-05 14:34:54',NULL),(4402,7922,40962,16898,3,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',45139.00,NULL,NULL,1,'2023-05-05 14:34:54','2023-05-05 14:34:54',NULL),(4403,7922,40962,16898,3,3107,'App\\Models\\Receipt',3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',12551.00,NULL,NULL,1,'2023-05-05 14:34:54','2023-05-05 14:34:54',NULL),(4404,7922,40962,16898,3,3108,'App\\Models\\Receipt',3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',207.83,NULL,NULL,1,'2023-05-05 14:34:54','2023-05-05 14:34:54',NULL),(4405,7922,40962,16898,3,3109,'App\\Models\\Receipt',3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',6273.00,NULL,NULL,1,'2023-05-05 14:34:54','2023-05-05 14:34:54',NULL),(4406,7922,40962,16898,3,3110,'App\\Models\\Receipt',3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3049.00,NULL,NULL,1,'2023-05-05 14:34:54','2023-05-05 14:34:54',NULL),(4407,7922,40962,16899,3,3111,'App\\Models\\Receipt',3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',199999.50,NULL,NULL,1,'2023-05-05 14:35:15','2023-05-05 14:35:15',NULL),(4408,7922,40962,16899,3,3112,'App\\Models\\Receipt',3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',6500.00,NULL,NULL,1,'2023-05-05 14:35:15','2023-05-05 14:35:15',NULL),(4409,7922,40962,16899,3,3113,'App\\Models\\Receipt',3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',985.00,NULL,NULL,1,'2023-05-05 14:35:15','2023-05-05 14:35:15',NULL),(4410,7922,40962,16899,3,3114,'App\\Models\\Receipt',3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',1170.00,NULL,NULL,1,'2023-05-05 14:35:15','2023-05-05 14:35:15',NULL),(4411,7922,40962,16899,3,3115,'App\\Models\\Receipt',3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',13974.00,NULL,NULL,1,'2023-05-05 14:35:15','2023-05-05 14:35:15',NULL),(4412,7922,40962,16899,3,3116,'App\\Models\\Receipt',3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',950.00,NULL,NULL,1,'2023-05-05 14:35:15','2023-05-05 14:35:15',NULL),(4413,7922,40962,16900,3,3117,'App\\Models\\Receipt',3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',677.00,NULL,NULL,1,'2023-05-05 14:35:23','2023-05-05 14:35:23',NULL),(4414,7922,40962,16900,3,3118,'App\\Models\\Receipt',3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',1309.00,NULL,NULL,1,'2023-05-05 14:35:23','2023-05-05 14:35:23',NULL),(4415,7922,40962,16900,3,3119,'App\\Models\\Receipt',3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',135.00,NULL,NULL,1,'2023-05-05 14:35:23','2023-05-05 14:35:23',NULL);
INSERT INTO `balance_libro` VALUES (4416,7922,40962,16900,3,3120,'App\\Models\\Receipt',3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',13974.00,NULL,NULL,1,'2023-05-05 14:35:23','2023-05-05 14:35:23',NULL),(4417,7922,40962,16901,3,3121,'App\\Models\\Receipt',3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',4975.48,NULL,NULL,1,'2023-05-05 14:35:30','2023-05-05 14:35:30',NULL),(4418,7922,40962,16901,3,3122,'App\\Models\\Receipt',3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',32302.08,NULL,NULL,1,'2023-05-05 14:35:30','2023-05-05 14:35:30',NULL),(4419,7922,40962,16901,3,3123,'App\\Models\\Receipt',3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',15585.00,NULL,NULL,1,'2023-05-05 14:35:30','2023-05-05 14:35:30',NULL),(4420,7922,40962,16901,3,3124,'App\\Models\\Receipt',3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',4580.00,NULL,NULL,1,'2023-05-05 14:35:30','2023-05-05 14:35:30',NULL),(4421,7922,40962,16902,3,3125,'App\\Models\\Receipt',3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',25999.00,NULL,NULL,1,'2023-05-05 14:35:37','2023-05-05 14:35:37',NULL),(4422,7922,40962,16902,3,3126,'App\\Models\\Receipt',3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',15585.00,NULL,NULL,1,'2023-05-05 14:35:37','2023-05-05 14:35:37',NULL),(4423,7922,40962,16903,3,3127,'App\\Models\\Receipt',3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',3268.75,NULL,NULL,1,'2023-05-05 14:35:45','2023-05-05 14:35:45',NULL),(4424,7922,40962,16903,3,3128,'App\\Models\\Receipt',3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',3262.49,NULL,NULL,1,'2023-05-05 14:35:45','2023-05-05 14:35:45',NULL),(4425,7922,40962,16903,3,3129,'App\\Models\\Receipt',3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',2790.00,NULL,NULL,1,'2023-05-05 14:35:45','2023-05-05 14:35:45',NULL),(4426,7922,40962,16903,3,3130,'App\\Models\\Receipt',3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',3420.00,NULL,NULL,1,'2023-05-05 14:35:45','2023-05-05 14:35:45',NULL),(4427,7922,40962,16903,3,3131,'App\\Models\\Receipt',3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',45980.00,NULL,NULL,1,'2023-05-05 14:35:45','2023-05-05 14:35:45',NULL),(4428,7922,40962,16903,3,3132,'App\\Models\\Receipt',3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',45980.00,NULL,NULL,1,'2023-05-05 14:35:45','2023-05-05 14:35:45',NULL),(4429,7922,40962,16903,3,3133,'App\\Models\\Receipt',3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',45980.00,NULL,NULL,1,'2023-05-05 14:35:45','2023-05-05 14:35:45',NULL),(4430,7922,40962,16903,3,3134,'App\\Models\\Receipt',3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',45980.00,NULL,NULL,1,'2023-05-05 14:35:45','2023-05-05 14:35:45',NULL),(4431,7922,40962,16903,3,3135,'App\\Models\\Receipt',3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',45980.00,NULL,NULL,1,'2023-05-05 14:35:45','2023-05-05 14:35:45',NULL),(4432,7922,40962,16903,3,3136,'App\\Models\\Receipt',3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',45980.00,NULL,NULL,1,'2023-05-05 14:35:45','2023-05-05 14:35:45',NULL),(4433,7922,40962,16903,3,3137,'App\\Models\\Receipt',3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',12960.00,NULL,NULL,1,'2023-05-05 14:35:45','2023-05-05 14:35:45',NULL),(4434,7922,40962,16903,3,3138,'App\\Models\\Receipt',3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',16660.00,NULL,NULL,1,'2023-05-05 14:35:45','2023-05-05 14:35:45',NULL),(4435,7922,40962,16903,3,3139,'App\\Models\\Receipt',3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',50000.00,NULL,NULL,1,'2023-05-05 14:35:46','2023-05-05 14:35:46',NULL),(4436,7922,40962,16903,3,3140,'App\\Models\\Receipt',3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',0.00,NULL,NULL,1,'2023-05-05 14:35:46','2023-05-05 14:35:46',NULL);
INSERT INTO `balance_libro` VALUES (4437,7922,40962,16903,3,3141,'App\\Models\\Receipt',3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',0.00,NULL,NULL,1,'2023-05-05 14:35:46','2023-05-05 14:35:46',NULL),(4438,7922,40962,16910,3,3142,'App\\Models\\Receipt',3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',100000.00,NULL,NULL,1,'2023-05-05 14:35:55','2023-05-05 14:35:55',NULL),(4439,7922,40962,16910,3,3143,'App\\Models\\Receipt',3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',291323.00,NULL,NULL,1,'2023-05-05 14:35:55','2023-05-05 14:35:55',NULL),(4440,7922,40962,16910,3,3144,'App\\Models\\Receipt',3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',17735.00,NULL,NULL,1,'2023-05-05 14:35:55','2023-05-05 14:35:55',NULL),(4441,7922,40962,16910,3,3145,'App\\Models\\Receipt',3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',53980.00,NULL,NULL,1,'2023-05-05 14:35:55','2023-05-05 14:35:55',NULL),(4442,7922,40962,16910,3,3146,'App\\Models\\Receipt',3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',53980.00,NULL,NULL,1,'2023-05-05 14:35:55','2023-05-05 14:35:55',NULL),(4443,7922,40962,16911,3,3147,'App\\Models\\Receipt',3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',15042.66,NULL,NULL,1,'2023-05-05 14:36:03','2023-05-05 14:36:03',NULL),(4444,7922,40962,16911,3,3148,'App\\Models\\Receipt',3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',2091.86,NULL,NULL,1,'2023-05-05 14:36:03','2023-05-05 14:36:03',NULL),(4445,7922,40962,16911,3,3149,'App\\Models\\Receipt',3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',0.00,NULL,NULL,1,'2023-05-05 14:36:03','2023-05-05 14:36:03',NULL),(4446,7922,40962,16911,3,3150,'App\\Models\\Receipt',3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',9764.01,NULL,NULL,1,'2023-05-05 14:36:03','2023-05-05 14:36:03',NULL),(4447,7922,40962,16911,3,3151,'App\\Models\\Receipt',3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',19191.00,NULL,NULL,1,'2023-05-05 14:36:03','2023-05-05 14:36:03',NULL),(4448,7922,40962,16912,3,3152,'App\\Models\\Receipt',3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',44101.36,NULL,NULL,1,'2023-05-05 14:36:12','2023-05-05 14:36:12',NULL),(4449,7922,40962,16912,3,3153,'App\\Models\\Receipt',3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',0.00,NULL,NULL,1,'2023-05-05 14:36:12','2023-05-05 14:36:12',NULL),(4450,7922,40962,16912,3,3154,'App\\Models\\Receipt',3154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',13386.00,NULL,NULL,1,'2023-05-05 14:36:12','2023-05-05 14:36:12',NULL),(4451,7922,40962,16912,3,3155,'App\\Models\\Receipt',3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',31890.41,NULL,NULL,1,'2023-05-05 14:36:12','2023-05-05 14:36:12',NULL),(4452,7922,40962,16912,3,3156,'App\\Models\\Receipt',3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',20660.99,NULL,NULL,1,'2023-05-05 14:36:12','2023-05-05 14:36:12',NULL),(4453,7922,40962,16912,3,3157,'App\\Models\\Receipt',3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',57484.43,NULL,NULL,1,'2023-05-05 14:36:12','2023-05-05 14:36:12',NULL),(4454,7922,40962,16912,3,3158,'App\\Models\\Receipt',3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',3000.00,NULL,NULL,1,'2023-05-05 14:36:12','2023-05-05 14:36:12',NULL),(4455,7922,40962,16912,3,3159,'App\\Models\\Receipt',3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',11496.88,NULL,NULL,1,'2023-05-05 14:36:12','2023-05-05 14:36:12',NULL),(4456,7922,40962,16913,3,3160,'App\\Models\\Receipt',3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',17305.19,NULL,NULL,1,'2023-05-05 14:36:20','2023-05-05 14:36:20',NULL),(4457,7922,40962,16913,3,3161,'App\\Models\\Receipt',3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',10461.28,NULL,NULL,1,'2023-05-05 14:36:20','2023-05-05 14:36:20',NULL);
INSERT INTO `balance_libro` VALUES (4458,7922,40962,16913,3,3162,'App\\Models\\Receipt',3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',12000.00,NULL,NULL,1,'2023-05-05 14:36:20','2023-05-05 14:36:20',NULL),(4459,7922,40962,16913,3,3163,'App\\Models\\Receipt',3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',0.00,NULL,NULL,1,'2023-05-05 14:36:20','2023-05-05 14:36:20',NULL),(4460,7922,40962,16913,3,3164,'App\\Models\\Receipt',3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',22000.00,NULL,NULL,1,'2023-05-05 14:36:20','2023-05-05 14:36:20',NULL),(4461,7922,40962,16913,3,3165,'App\\Models\\Receipt',3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',14000.00,NULL,NULL,1,'2023-05-05 14:36:20','2023-05-05 14:36:20',NULL),(4462,7922,40962,16913,3,3166,'App\\Models\\Receipt',3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',21148.00,NULL,NULL,1,'2023-05-05 14:36:20','2023-05-05 14:36:20',NULL),(4463,7922,40962,16913,3,3167,'App\\Models\\Receipt',3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',6190.00,NULL,NULL,1,'2023-05-05 14:36:20','2023-05-05 14:36:20',NULL),(4464,7922,40962,16913,3,3168,'App\\Models\\Receipt',3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',3488.50,NULL,NULL,1,'2023-05-05 14:36:20','2023-05-05 14:36:20',NULL),(4465,7922,40946,13836,3,3169,'App\\Models\\Receipt',3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-18','2022-05-18',11017.36,NULL,NULL,1,'2023-05-05 14:45:26','2023-05-05 14:45:26',NULL),(4466,7922,40946,13836,3,3170,'App\\Models\\Receipt',3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-29','2022-05-29',1890.00,NULL,NULL,1,'2023-05-05 14:45:26','2023-05-05 14:45:26',NULL),(4467,7922,40946,13837,3,3171,'App\\Models\\Receipt',3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',3392.55,NULL,NULL,1,'2023-05-05 14:45:35','2023-05-05 14:45:35',NULL),(4468,7922,40946,13837,3,3172,'App\\Models\\Receipt',3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',1077.90,NULL,NULL,1,'2023-05-05 14:45:35','2023-05-05 14:45:35',NULL),(4469,7922,40946,13837,3,3173,'App\\Models\\Receipt',3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',11487.07,NULL,NULL,1,'2023-05-05 14:45:35','2023-05-05 14:45:35',NULL),(4470,7922,40946,13837,3,3174,'App\\Models\\Receipt',3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-17','2022-06-17',3619.75,NULL,NULL,1,'2023-05-05 14:45:35','2023-05-05 14:45:35',NULL),(4471,7922,40946,13838,3,3175,'App\\Models\\Receipt',3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',12859.30,NULL,NULL,1,'2023-05-05 14:45:43','2023-05-05 14:45:43',NULL),(4472,7922,40946,13838,3,3176,'App\\Models\\Receipt',3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',3400.00,NULL,NULL,1,'2023-05-05 14:45:43','2023-05-05 14:45:43',NULL),(4473,7922,40946,13838,3,3177,'App\\Models\\Receipt',3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',270.00,NULL,NULL,1,'2023-05-05 14:45:43','2023-05-05 14:45:43',NULL),(4474,7922,40946,13839,3,3178,'App\\Models\\Receipt',3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',12871.10,NULL,NULL,1,'2023-05-05 14:45:50','2023-05-05 14:45:50',NULL),(4475,7922,40946,13839,3,3179,'App\\Models\\Receipt',3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',5351.03,NULL,NULL,1,'2023-05-05 14:45:50','2023-05-05 14:45:50',NULL),(4476,7922,40946,13839,3,3180,'App\\Models\\Receipt',3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',3465.85,NULL,NULL,1,'2023-05-05 14:45:50','2023-05-05 14:45:50',NULL),(4477,7922,40946,13839,3,3181,'App\\Models\\Receipt',3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',3465.85,NULL,NULL,1,'2023-05-05 14:45:50','2023-05-05 14:45:50',NULL),(4478,7922,40946,13839,3,3182,'App\\Models\\Receipt',3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-21','2022-08-21',5351.03,NULL,NULL,1,'2023-05-05 14:45:50','2023-05-05 14:45:50',NULL);
INSERT INTO `balance_libro` VALUES (4479,7922,40946,13839,3,3183,'App\\Models\\Receipt',3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',4750.00,NULL,NULL,1,'2023-05-05 14:45:50','2023-05-05 14:45:50',NULL),(4480,7922,40946,13839,3,3184,'App\\Models\\Receipt',3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',270.00,NULL,NULL,1,'2023-05-05 14:45:50','2023-05-05 14:45:50',NULL),(4481,7922,40946,13840,3,3185,'App\\Models\\Receipt',3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',580.00,NULL,NULL,1,'2023-05-05 14:45:58','2023-05-05 14:45:58',NULL),(4482,7922,40946,13840,3,3186,'App\\Models\\Receipt',3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',14437.88,NULL,NULL,1,'2023-05-05 14:45:58','2023-05-05 14:45:58',NULL),(4483,7922,40946,13840,3,3187,'App\\Models\\Receipt',3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',610.00,NULL,NULL,1,'2023-05-05 14:45:59','2023-05-05 14:45:59',NULL),(4484,7922,40946,13840,3,3188,'App\\Models\\Receipt',3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',7491.15,NULL,NULL,1,'2023-05-05 14:45:59','2023-05-05 14:45:59',NULL),(4485,7922,40946,13840,3,3189,'App\\Models\\Receipt',3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',252.00,NULL,NULL,1,'2023-05-05 14:45:59','2023-05-05 14:45:59',NULL),(4486,7922,40946,13842,3,3190,'App\\Models\\Receipt',3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',170.50,NULL,NULL,1,'2023-05-05 14:46:25','2023-05-05 14:46:25',NULL),(4487,7922,40946,13842,3,3191,'App\\Models\\Receipt',3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',1755.00,NULL,NULL,1,'2023-05-05 14:46:25','2023-05-05 14:46:25',NULL),(4488,7922,40946,13842,3,3192,'App\\Models\\Receipt',3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',15483.62,NULL,NULL,1,'2023-05-05 14:46:25','2023-05-05 14:46:25',NULL),(4489,7922,40946,13842,3,3193,'App\\Models\\Receipt',3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',270.00,NULL,NULL,1,'2023-05-05 14:46:25','2023-05-05 14:46:25',NULL),(4490,7922,40946,13843,3,3194,'App\\Models\\Receipt',3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',16528.60,NULL,NULL,1,'2023-05-05 14:46:31','2023-05-05 14:46:31',NULL),(4491,7922,40946,13843,3,3195,'App\\Models\\Receipt',3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',1490.00,NULL,NULL,1,'2023-05-05 14:46:31','2023-05-05 14:46:31',NULL),(4492,7922,40946,13843,3,3196,'App\\Models\\Receipt',3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',50000.00,NULL,NULL,1,'2023-05-05 14:46:31','2023-05-05 14:46:31',NULL),(4493,7922,40946,13850,3,3197,'App\\Models\\Receipt',3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',680.00,NULL,NULL,1,'2023-05-05 14:46:47','2023-05-05 14:46:47',NULL),(4494,7922,40946,13850,3,3198,'App\\Models\\Receipt',3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',570.00,NULL,NULL,1,'2023-05-05 14:46:47','2023-05-05 14:46:47',NULL),(4495,7922,40946,13850,3,3199,'App\\Models\\Receipt',3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',5700.00,NULL,NULL,1,'2023-05-05 14:46:47','2023-05-05 14:46:47',NULL),(4496,7922,40946,13850,3,3200,'App\\Models\\Receipt',3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',17944.53,NULL,NULL,1,'2023-05-05 14:46:47','2023-05-05 14:46:47',NULL),(4497,7922,40946,13851,3,3201,'App\\Models\\Receipt',3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1794.00,NULL,NULL,1,'2023-05-05 14:46:54','2023-05-05 14:46:54',NULL),(4498,7922,40946,13851,3,3202,'App\\Models\\Receipt',3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1189.00,NULL,NULL,1,'2023-05-05 14:46:54','2023-05-05 14:46:54',NULL),(4499,7922,40946,13851,3,3203,'App\\Models\\Receipt',3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',19374.06,NULL,NULL,1,'2023-05-05 14:46:54','2023-05-05 14:46:54',NULL);
INSERT INTO `balance_libro` VALUES (4500,7922,40946,13851,3,3204,'App\\Models\\Receipt',3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',342.00,NULL,NULL,1,'2023-05-05 14:46:54','2023-05-05 14:46:54',NULL),(4501,7922,40946,13852,3,3205,'App\\Models\\Receipt',3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',4289.99,NULL,NULL,1,'2023-05-05 14:47:08','2023-05-05 14:47:08',NULL),(4502,7922,40946,13852,3,3206,'App\\Models\\Receipt',3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1330.00,NULL,NULL,1,'2023-05-05 14:47:08','2023-05-05 14:47:08',NULL),(4503,7922,40946,13852,3,3207,'App\\Models\\Receipt',3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',19288.99,NULL,NULL,1,'2023-05-05 14:47:08','2023-05-05 14:47:08',NULL),(4504,7922,40946,13852,3,3208,'App\\Models\\Receipt',3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',4700.00,NULL,NULL,1,'2023-05-05 14:47:08','2023-05-05 14:47:08',NULL),(4505,7922,40946,13852,3,3209,'App\\Models\\Receipt',3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',873.00,NULL,NULL,1,'2023-05-05 14:47:08','2023-05-05 14:47:08',NULL),(4506,7922,40946,13853,3,3210,'App\\Models\\Receipt',3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',14187.32,NULL,NULL,1,'2023-05-05 14:47:15','2023-05-05 14:47:15',NULL),(4507,7922,40946,13853,3,3211,'App\\Models\\Receipt',3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',4385.60,NULL,NULL,1,'2023-05-05 14:47:15','2023-05-05 14:47:15',NULL),(4508,7922,40946,13853,3,3212,'App\\Models\\Receipt',3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',3000.00,NULL,NULL,1,'2023-05-05 14:47:15','2023-05-05 14:47:15',NULL),(4509,7922,40946,13853,3,3213,'App\\Models\\Receipt',3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',2100.00,NULL,NULL,1,'2023-05-05 14:47:15','2023-05-05 14:47:15',NULL),(4510,7922,40946,13853,3,3214,'App\\Models\\Receipt',3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',19842.25,NULL,NULL,1,'2023-05-05 14:47:15','2023-05-05 14:47:15',NULL),(4511,7922,40946,13841,3,3215,'App\\Models\\Receipt',3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1220.00,NULL,NULL,1,'2023-05-05 14:48:46','2023-05-05 14:48:46',NULL),(4512,7922,40946,13841,3,3216,'App\\Models\\Receipt',3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',283.50,NULL,NULL,1,'2023-05-05 14:48:46','2023-05-05 14:48:46',NULL),(4513,7922,40946,13841,3,3217,'App\\Models\\Receipt',3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',14437.88,NULL,NULL,1,'2023-05-05 14:48:46','2023-05-05 14:48:46',NULL),(4514,7922,40946,13841,3,3218,'App\\Models\\Receipt',3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',6480.00,NULL,NULL,1,'2023-05-05 14:48:46','2023-05-05 14:48:46',NULL),(4515,7922,40946,13841,3,3219,'App\\Models\\Receipt',3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',251.00,NULL,NULL,1,'2023-05-05 14:48:46','2023-05-05 14:48:46',NULL),(4516,7922,40946,13841,3,3220,'App\\Models\\Receipt',3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',270.00,NULL,NULL,1,'2023-05-05 14:48:46','2023-05-05 14:48:46',NULL),(4517,7922,40946,13853,2,3221,'App\\Models\\Receipt',3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',37100.00,NULL,NULL,1,'2023-05-05 14:50:55','2023-05-05 14:50:55',NULL),(4518,7922,40956,15383,2,3222,'App\\Models\\Receipt',3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',37100.00,NULL,NULL,1,'2023-05-05 14:54:24','2023-05-05 14:54:24',NULL),(4519,7922,40956,15383,2,3223,'App\\Models\\Receipt',3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',30000.00,NULL,NULL,1,'2023-05-05 14:54:25','2023-05-05 14:54:25',NULL),(4520,7922,40956,15366,3,3224,'App\\Models\\Receipt',3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-15','2022-05-15',25800.00,NULL,NULL,1,'2023-05-05 14:57:12','2023-05-05 14:57:12',NULL);
INSERT INTO `balance_libro` VALUES (4521,7922,40956,15367,3,3225,'App\\Models\\Receipt',3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',2350.00,NULL,NULL,1,'2023-05-05 14:57:19','2023-05-05 14:57:19',NULL),(4522,7922,40956,15367,3,3226,'App\\Models\\Receipt',3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',3042.17,NULL,NULL,1,'2023-05-05 14:57:19','2023-05-05 14:57:19',NULL),(4523,7922,40956,15367,3,3227,'App\\Models\\Receipt',3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',5112.00,NULL,NULL,1,'2023-05-05 14:57:19','2023-05-05 14:57:19',NULL),(4524,7922,40956,15368,3,3228,'App\\Models\\Receipt',3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',18898.98,NULL,NULL,1,'2023-05-05 14:57:28','2023-05-05 14:57:28',NULL),(4525,7922,40956,15368,3,3229,'App\\Models\\Receipt',3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',800.00,NULL,NULL,1,'2023-05-05 14:57:28','2023-05-05 14:57:28',NULL),(4526,7922,40956,15368,3,3230,'App\\Models\\Receipt',3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',12290.00,NULL,NULL,1,'2023-05-05 14:57:28','2023-05-05 14:57:28',NULL),(4527,7922,40956,15369,3,3231,'App\\Models\\Receipt',3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',6500.00,NULL,NULL,1,'2023-05-05 14:57:34','2023-05-05 14:57:34',NULL),(4528,7922,40956,15369,3,3232,'App\\Models\\Receipt',3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',24000.00,NULL,NULL,1,'2023-05-05 14:57:34','2023-05-05 14:57:34',NULL),(4529,7922,40956,15369,3,3233,'App\\Models\\Receipt',3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',5516.00,NULL,NULL,1,'2023-05-05 14:57:34','2023-05-05 14:57:34',NULL),(4530,7922,40956,15369,3,3234,'App\\Models\\Receipt',3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',5516.00,NULL,NULL,1,'2023-05-05 14:57:34','2023-05-05 14:57:34',NULL),(4531,7922,40956,15369,3,3235,'App\\Models\\Receipt',3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',5796.00,NULL,NULL,1,'2023-05-05 14:57:34','2023-05-05 14:57:34',NULL),(4532,7922,40956,15370,3,3236,'App\\Models\\Receipt',3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',10499.00,NULL,NULL,1,'2023-05-05 14:57:42','2023-05-05 14:57:42',NULL),(4533,7922,40956,15371,3,3237,'App\\Models\\Receipt',3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',2000.00,NULL,NULL,1,'2023-05-05 14:57:49','2023-05-05 14:57:49',NULL),(4534,7922,40956,15371,3,3238,'App\\Models\\Receipt',3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1200.00,NULL,NULL,1,'2023-05-05 14:57:49','2023-05-05 14:57:49',NULL),(4535,7922,40956,15372,3,3239,'App\\Models\\Receipt',3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',2111.55,NULL,NULL,1,'2023-05-05 14:57:58','2023-05-05 14:57:58',NULL),(4536,7922,40956,15373,3,3240,'App\\Models\\Receipt',3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',12880.00,NULL,NULL,1,'2023-05-05 14:58:17','2023-05-05 14:58:17',NULL),(4537,7922,40956,15380,3,3241,'App\\Models\\Receipt',3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2500.00,NULL,NULL,1,'2023-05-05 14:58:29','2023-05-05 14:58:29',NULL),(4538,7922,40956,15380,3,3242,'App\\Models\\Receipt',3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',11692.00,NULL,NULL,1,'2023-05-05 14:58:29','2023-05-05 14:58:29',NULL),(4539,7922,40956,15380,3,3243,'App\\Models\\Receipt',3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2700.00,NULL,NULL,1,'2023-05-05 14:58:29','2023-05-05 14:58:29',NULL),(4540,7922,40956,15381,3,3244,'App\\Models\\Receipt',3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',4000.00,NULL,NULL,1,'2023-05-05 14:58:37','2023-05-05 14:58:37',NULL),(4541,7922,40956,15382,3,3245,'App\\Models\\Receipt',3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',19435.70,NULL,NULL,1,'2023-05-05 14:58:44','2023-05-05 14:58:44',NULL);
INSERT INTO `balance_libro` VALUES (4542,7922,40956,15383,3,3246,'App\\Models\\Receipt',3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',34280.00,NULL,NULL,1,'2023-05-05 14:58:51','2023-05-05 14:58:51',NULL),(4543,7922,40956,15383,3,3247,'App\\Models\\Receipt',3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',47123.90,NULL,NULL,1,'2023-05-05 14:58:51','2023-05-05 14:58:51',NULL),(4544,7922,40956,15383,3,3248,'App\\Models\\Receipt',3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',47200.00,NULL,NULL,1,'2023-05-05 14:58:51','2023-05-05 14:58:51',NULL),(4545,7922,40956,15383,3,3249,'App\\Models\\Receipt',3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',4700.00,NULL,NULL,1,'2023-05-05 14:58:51','2023-05-05 14:58:51',NULL),(4546,7922,40864,12326,2,3250,'App\\Models\\Receipt',3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',674760.00,NULL,NULL,1,'2023-05-09 18:54:26','2023-05-09 18:54:26',NULL),(4547,7922,40864,12326,2,3251,'App\\Models\\Receipt',3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',258000.00,NULL,NULL,1,'2023-05-09 18:54:26','2023-05-09 18:54:26',NULL),(4548,7922,40864,12326,2,3252,'App\\Models\\Receipt',3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',220000.00,NULL,NULL,1,'2023-05-09 18:54:26','2023-05-09 18:54:26',NULL),(4549,7922,40864,12326,2,3253,'App\\Models\\Receipt',3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',30000.00,NULL,NULL,1,'2023-05-09 18:54:26','2023-05-09 18:54:26',NULL),(4550,7922,40864,12326,2,3254,'App\\Models\\Receipt',3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',28500.00,NULL,NULL,1,'2023-05-09 18:54:26','2023-05-09 18:54:26',NULL),(4551,7922,40864,12326,2,3255,'App\\Models\\Receipt',3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',29700.00,NULL,NULL,1,'2023-05-09 18:54:26','2023-05-09 18:54:26',NULL),(4552,7922,40864,12326,2,3256,'App\\Models\\Receipt',3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',30000.00,NULL,NULL,1,'2023-05-09 18:54:26','2023-05-09 18:54:26',NULL),(4553,7922,40864,12326,2,3257,'App\\Models\\Receipt',3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',30000.00,NULL,NULL,1,'2023-05-09 18:54:27','2023-05-09 18:54:27',NULL),(4554,7922,40864,12326,3,3258,'App\\Models\\Receipt',3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',7500.00,NULL,NULL,1,'2023-05-09 18:54:56','2023-05-09 18:54:56',NULL),(4555,7922,40864,12326,3,3259,'App\\Models\\Receipt',3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',19025.00,NULL,NULL,1,'2023-05-09 18:54:56','2023-05-09 18:54:56',NULL),(4556,7922,40864,12326,3,3260,'App\\Models\\Receipt',3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',14504.96,NULL,NULL,1,'2023-05-09 18:54:56','2023-05-09 18:54:56',NULL),(4557,7922,40864,12326,3,3261,'App\\Models\\Receipt',3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',94999.00,NULL,NULL,1,'2023-05-09 18:54:56','2023-05-09 18:54:56',NULL),(4558,7922,40864,12326,3,3262,'App\\Models\\Receipt',3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',498.90,NULL,NULL,1,'2023-05-09 18:54:56','2023-05-09 18:54:56',NULL),(4559,7922,40864,12326,3,3263,'App\\Models\\Receipt',3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',6720.00,NULL,NULL,1,'2023-05-09 18:54:56','2023-05-09 18:54:56',NULL),(4560,7922,41070,18422,2,3264,'App\\Models\\Receipt',3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',720163.00,NULL,NULL,1,'2023-05-10 17:22:28','2023-05-10 17:22:28',NULL),(4561,7922,41070,18422,2,3265,'App\\Models\\Receipt',3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',730263.00,NULL,NULL,1,'2023-05-10 17:22:28','2023-05-10 17:22:28',NULL),(4562,7922,41070,18422,2,3266,'App\\Models\\Receipt',3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',720163.00,NULL,NULL,1,'2023-05-10 17:22:28','2023-05-10 17:22:28',NULL);
INSERT INTO `balance_libro` VALUES (4563,7922,41070,18422,2,3267,'App\\Models\\Receipt',3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',18000.00,NULL,NULL,1,'2023-05-10 17:22:28','2023-05-10 17:22:28',NULL),(4564,7922,41070,18423,2,3268,'App\\Models\\Receipt',3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',12000.00,NULL,NULL,1,'2023-05-10 17:22:39','2023-05-10 17:22:39',NULL),(4565,7922,41070,18426,2,3269,'App\\Models\\Receipt',3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',290000.00,NULL,NULL,1,'2023-05-10 17:23:10','2023-05-10 17:23:10',NULL),(4566,7922,41070,18422,3,3270,'App\\Models\\Receipt',3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',33776.00,NULL,NULL,1,'2023-05-10 17:48:15','2023-05-10 17:48:15',NULL),(4567,7922,41070,18422,3,3271,'App\\Models\\Receipt',3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',25751.00,NULL,NULL,1,'2023-05-10 17:48:15','2023-05-10 17:48:15',NULL),(4568,7922,41070,18422,3,3272,'App\\Models\\Receipt',3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',92531.45,NULL,NULL,1,'2023-05-10 17:48:15','2023-05-10 17:48:15',NULL),(4569,7922,41070,18422,3,3273,'App\\Models\\Receipt',3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',4902.56,NULL,NULL,1,'2023-05-10 17:48:15','2023-05-10 17:48:15',NULL),(4570,7922,41070,18422,3,3274,'App\\Models\\Receipt',3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',90707.07,NULL,NULL,1,'2023-05-10 17:48:15','2023-05-10 17:48:15',NULL),(4571,7922,41070,18422,3,3275,'App\\Models\\Receipt',3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',668.00,NULL,NULL,1,'2023-05-10 17:48:15','2023-05-10 17:48:15',NULL),(4572,7922,41070,18422,3,3276,'App\\Models\\Receipt',3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',289.34,NULL,NULL,1,'2023-05-10 17:48:15','2023-05-10 17:48:15',NULL),(4573,7922,41070,18422,3,3277,'App\\Models\\Receipt',3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',2952.74,NULL,NULL,1,'2023-05-10 17:48:15','2023-05-10 17:48:15',NULL),(4574,7922,41070,18422,3,3278,'App\\Models\\Receipt',3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',600.01,NULL,NULL,1,'2023-05-10 17:48:15','2023-05-10 17:48:15',NULL),(4575,7922,41070,18422,3,3279,'App\\Models\\Receipt',3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',12493.88,NULL,NULL,1,'2023-05-10 17:48:15','2023-05-10 17:48:15',NULL),(4576,7922,41070,18422,3,3280,'App\\Models\\Receipt',3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',3490.00,NULL,NULL,1,'2023-05-10 17:48:15','2023-05-10 17:48:15',NULL),(4577,7922,41070,18422,3,3281,'App\\Models\\Receipt',3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',6486.82,NULL,NULL,1,'2023-05-10 17:48:15','2023-05-10 17:48:15',NULL),(4578,7922,41070,18422,3,3282,'App\\Models\\Receipt',3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',46748.91,NULL,NULL,1,'2023-05-10 17:48:15','2023-05-10 17:48:15',NULL),(4579,7922,41070,18422,3,3283,'App\\Models\\Receipt',3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',13929.40,NULL,NULL,1,'2023-05-10 17:48:15','2023-05-10 17:48:15',NULL),(4580,7922,41070,18422,3,3284,'App\\Models\\Receipt',3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1107.00,NULL,NULL,1,'2023-05-10 17:48:15','2023-05-10 17:48:15',NULL),(4581,7922,41070,18423,3,3285,'App\\Models\\Receipt',3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',29024.19,NULL,NULL,1,'2023-05-10 17:48:23','2023-05-10 17:48:23',NULL),(4582,7922,41070,18423,3,3286,'App\\Models\\Receipt',3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',968.13,NULL,NULL,1,'2023-05-10 17:48:23','2023-05-10 17:48:23',NULL),(4583,7922,41070,18423,3,3287,'App\\Models\\Receipt',3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',668.00,NULL,NULL,1,'2023-05-10 17:48:23','2023-05-10 17:48:23',NULL);
INSERT INTO `balance_libro` VALUES (4584,7922,41070,18423,3,3288,'App\\Models\\Receipt',3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',43806.60,NULL,NULL,1,'2023-05-10 17:48:23','2023-05-10 17:48:23',NULL),(4585,7922,41070,18423,3,3289,'App\\Models\\Receipt',3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',216304.37,NULL,NULL,1,'2023-05-10 17:48:23','2023-05-10 17:48:23',NULL),(4586,7922,41070,18423,3,3290,'App\\Models\\Receipt',3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',27870.97,NULL,NULL,1,'2023-05-10 17:48:23','2023-05-10 17:48:23',NULL),(4587,7922,41070,18423,3,3291,'App\\Models\\Receipt',3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',9100.32,NULL,NULL,1,'2023-05-10 17:48:24','2023-05-10 17:48:24',NULL),(4588,7922,41070,18423,3,3292,'App\\Models\\Receipt',3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',38025.62,NULL,NULL,1,'2023-05-10 17:48:24','2023-05-10 17:48:24',NULL),(4589,7922,41070,18423,3,3293,'App\\Models\\Receipt',3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',6800.00,NULL,NULL,1,'2023-05-10 17:48:24','2023-05-10 17:48:24',NULL),(4590,7922,41070,18423,3,3294,'App\\Models\\Receipt',3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',1170.27,NULL,NULL,1,'2023-05-10 17:48:24','2023-05-10 17:48:24',NULL),(4591,7922,41070,18423,3,3295,'App\\Models\\Receipt',3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2214.00,NULL,NULL,1,'2023-05-10 17:48:24','2023-05-10 17:48:24',NULL),(4592,7922,41070,18424,3,3296,'App\\Models\\Receipt',3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',5334.95,NULL,NULL,1,'2023-05-10 17:48:33','2023-05-10 17:48:33',NULL),(4593,7922,41070,18424,3,3297,'App\\Models\\Receipt',3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',358.46,NULL,NULL,1,'2023-05-10 17:48:33','2023-05-10 17:48:33',NULL),(4594,7922,41070,18424,3,3298,'App\\Models\\Receipt',3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',9702.29,NULL,NULL,1,'2023-05-10 17:48:33','2023-05-10 17:48:33',NULL),(4595,7922,41070,18424,3,3299,'App\\Models\\Receipt',3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',4200.00,NULL,NULL,1,'2023-05-10 17:48:33','2023-05-10 17:48:33',NULL),(4596,7922,41070,18424,3,3300,'App\\Models\\Receipt',3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',4596.05,NULL,NULL,1,'2023-05-10 17:48:33','2023-05-10 17:48:33',NULL),(4597,7922,41070,18424,3,3301,'App\\Models\\Receipt',3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',446.41,NULL,NULL,1,'2023-05-10 17:48:34','2023-05-10 17:48:34',NULL),(4598,7922,41070,18424,3,3302,'App\\Models\\Receipt',3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',668.00,NULL,NULL,1,'2023-05-10 17:48:34','2023-05-10 17:48:34',NULL),(4599,7922,41070,18424,3,3303,'App\\Models\\Receipt',3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',34900.03,NULL,NULL,1,'2023-05-10 17:48:34','2023-05-10 17:48:34',NULL),(4600,7922,41070,18424,3,3304,'App\\Models\\Receipt',3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',50343.13,NULL,NULL,1,'2023-05-10 17:48:34','2023-05-10 17:48:34',NULL),(4601,7922,41070,18424,3,3305,'App\\Models\\Receipt',3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',15486.40,NULL,NULL,1,'2023-05-10 17:48:34','2023-05-10 17:48:34',NULL),(4602,7922,41070,18424,3,3306,'App\\Models\\Receipt',3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',19791.00,NULL,NULL,1,'2023-05-10 17:48:34','2023-05-10 17:48:34',NULL),(4603,7922,41070,18424,3,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',38400.00,NULL,NULL,1,'2023-05-10 17:48:34','2023-05-10 17:48:34',NULL),(4604,7922,41070,18424,3,3308,'App\\Models\\Receipt',3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',268.56,NULL,NULL,1,'2023-05-10 17:48:34','2023-05-10 17:48:34',NULL);
INSERT INTO `balance_libro` VALUES (4605,7922,41070,18424,3,3309,'App\\Models\\Receipt',3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',2429.51,NULL,NULL,1,'2023-05-10 17:48:34','2023-05-10 17:48:34',NULL),(4606,7922,41070,18424,3,3310,'App\\Models\\Receipt',3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',12147.56,NULL,NULL,1,'2023-05-10 17:48:34','2023-05-10 17:48:34',NULL),(4607,7922,41070,18424,3,3311,'App\\Models\\Receipt',3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1818.00,NULL,NULL,1,'2023-05-10 17:48:34','2023-05-10 17:48:34',NULL),(4608,7922,41070,18424,3,3312,'App\\Models\\Receipt',3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',34900.03,NULL,NULL,1,'2023-05-10 17:48:34','2023-05-10 17:48:34',NULL),(4609,7922,41070,18425,3,3313,'App\\Models\\Receipt',3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',6368.33,NULL,NULL,1,'2023-05-10 17:48:41','2023-05-10 17:48:41',NULL),(4610,7922,41070,18425,3,3314,'App\\Models\\Receipt',3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',13184.25,NULL,NULL,1,'2023-05-10 17:48:41','2023-05-10 17:48:41',NULL),(4611,7922,41070,18425,3,3315,'App\\Models\\Receipt',3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',52192.00,NULL,NULL,1,'2023-05-10 17:48:41','2023-05-10 17:48:41',NULL),(4612,7922,41070,18425,3,3316,'App\\Models\\Receipt',3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',447.59,NULL,NULL,1,'2023-05-10 17:48:41','2023-05-10 17:48:41',NULL),(4613,7922,41070,18425,3,3317,'App\\Models\\Receipt',3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',35222.64,NULL,NULL,1,'2023-05-10 17:48:41','2023-05-10 17:48:41',NULL),(4614,7922,41070,18425,3,3318,'App\\Models\\Receipt',3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',2929.58,NULL,NULL,1,'2023-05-10 17:48:41','2023-05-10 17:48:41',NULL),(4615,7922,41070,18425,3,3319,'App\\Models\\Receipt',3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',668.00,NULL,NULL,1,'2023-05-10 17:48:41','2023-05-10 17:48:41',NULL),(4616,7922,41070,18425,3,3320,'App\\Models\\Receipt',3320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',35222.64,NULL,NULL,1,'2023-05-10 17:48:41','2023-05-10 17:48:41',NULL),(4617,7922,41070,18425,3,3321,'App\\Models\\Receipt',3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',11046.94,NULL,NULL,1,'2023-05-10 17:48:41','2023-05-10 17:48:41',NULL),(4618,7922,41070,18425,3,3322,'App\\Models\\Receipt',3322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',3964.12,NULL,NULL,1,'2023-05-10 17:48:41','2023-05-10 17:48:41',NULL),(4619,7922,41070,18425,3,3323,'App\\Models\\Receipt',3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',17691.50,NULL,NULL,1,'2023-05-10 17:48:41','2023-05-10 17:48:41',NULL),(4620,7922,41070,18425,3,3324,'App\\Models\\Receipt',3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',2408.87,NULL,NULL,1,'2023-05-10 17:48:42','2023-05-10 17:48:42',NULL),(4621,7922,41070,18425,3,3325,'App\\Models\\Receipt',3325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',8720.93,NULL,NULL,1,'2023-05-10 17:48:42','2023-05-10 17:48:42',NULL),(4622,7922,41070,18425,3,3326,'App\\Models\\Receipt',3326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',1178.08,NULL,NULL,1,'2023-05-10 17:48:42','2023-05-10 17:48:42',NULL),(4623,7922,41070,18425,3,3327,'App\\Models\\Receipt',3327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',195.00,NULL,NULL,1,'2023-05-10 17:48:42','2023-05-10 17:48:42',NULL),(4624,7922,41070,18425,3,3328,'App\\Models\\Receipt',3328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',1062.55,NULL,NULL,1,'2023-05-10 17:48:42','2023-05-10 17:48:42',NULL),(4625,7922,41070,18425,3,3329,'App\\Models\\Receipt',3329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',1425.81,NULL,NULL,1,'2023-05-10 17:48:42','2023-05-10 17:48:42',NULL);
INSERT INTO `balance_libro` VALUES (4626,7922,41070,18425,3,3330,'App\\Models\\Receipt',3330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',32573.46,NULL,NULL,1,'2023-05-10 17:48:42','2023-05-10 17:48:42',NULL),(4627,7922,41070,18425,3,3331,'App\\Models\\Receipt',3331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',408772.26,NULL,NULL,1,'2023-05-10 17:48:42','2023-05-10 17:48:42',NULL),(4628,7922,41070,18425,3,3332,'App\\Models\\Receipt',3332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',20840.00,NULL,NULL,1,'2023-05-10 17:48:42','2023-05-10 17:48:42',NULL),(4629,7922,41070,18425,3,3333,'App\\Models\\Receipt',3333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1044.00,NULL,NULL,1,'2023-05-10 17:48:42','2023-05-10 17:48:42',NULL),(4630,7922,41070,18426,3,3334,'App\\Models\\Receipt',3334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',8900.00,NULL,NULL,1,'2023-05-10 17:48:49','2023-05-10 17:48:49',NULL),(4631,7922,41070,18426,3,3335,'App\\Models\\Receipt',3335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',668.00,NULL,NULL,1,'2023-05-10 17:48:49','2023-05-10 17:48:49',NULL),(4632,7922,41070,18426,3,3336,'App\\Models\\Receipt',3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2416.75,NULL,NULL,1,'2023-05-10 17:48:49','2023-05-10 17:48:49',NULL),(4633,7922,41070,18426,3,3337,'App\\Models\\Receipt',3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',50755.71,NULL,NULL,1,'2023-05-10 17:48:49','2023-05-10 17:48:49',NULL),(4634,7922,41070,18426,3,3338,'App\\Models\\Receipt',3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1528.11,NULL,NULL,1,'2023-05-10 17:48:49','2023-05-10 17:48:49',NULL),(4635,7922,41070,18426,3,3339,'App\\Models\\Receipt',3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2937.63,NULL,NULL,1,'2023-05-10 17:48:49','2023-05-10 17:48:49',NULL),(4636,7922,41070,18426,3,3340,'App\\Models\\Receipt',3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',786.26,NULL,NULL,1,'2023-05-10 17:48:49','2023-05-10 17:48:49',NULL),(4637,7922,41070,18426,3,3341,'App\\Models\\Receipt',3341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',11385.00,NULL,NULL,1,'2023-05-10 17:48:49','2023-05-10 17:48:49',NULL),(4638,7922,41070,18426,3,3342,'App\\Models\\Receipt',3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',9400.70,NULL,NULL,1,'2023-05-10 17:48:49','2023-05-10 17:48:49',NULL),(4639,7922,41070,18426,3,3343,'App\\Models\\Receipt',3343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',18339.59,NULL,NULL,1,'2023-05-10 17:48:49','2023-05-10 17:48:49',NULL),(4640,7922,41070,18426,3,3344,'App\\Models\\Receipt',3344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3087.00,NULL,NULL,1,'2023-05-10 17:48:49','2023-05-10 17:48:49',NULL),(4641,7922,41070,18427,3,3345,'App\\Models\\Receipt',3345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',44425.40,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4642,7922,41070,18427,3,3346,'App\\Models\\Receipt',3346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',144680.80,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4643,7922,41070,18427,3,3347,'App\\Models\\Receipt',3347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',215937.86,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4644,7922,41070,18427,3,3348,'App\\Models\\Receipt',3348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',13821.00,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4645,7922,41070,18427,3,3349,'App\\Models\\Receipt',3349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',1786.97,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4646,7922,41070,18427,3,3350,'App\\Models\\Receipt',3350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',649.81,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL);
INSERT INTO `balance_libro` VALUES (4647,7922,41070,18427,3,3351,'App\\Models\\Receipt',3351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',43058.73,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4648,7922,41070,18427,3,3352,'App\\Models\\Receipt',3352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',5065.33,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4649,7922,41070,18427,3,3353,'App\\Models\\Receipt',3353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',668.00,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4650,7922,41070,18427,3,3354,'App\\Models\\Receipt',3354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',9876.44,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4651,7922,41070,18427,3,3355,'App\\Models\\Receipt',3355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',10207.27,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4652,7922,41070,18427,3,3356,'App\\Models\\Receipt',3356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',17746.72,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4653,7922,41070,18427,3,3357,'App\\Models\\Receipt',3357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',15769.44,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4654,7922,41070,18427,3,3358,'App\\Models\\Receipt',3358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',20546.54,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4655,7922,41070,18427,3,3359,'App\\Models\\Receipt',3359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',12842.80,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4656,7922,41070,18427,3,3360,'App\\Models\\Receipt',3360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',600.00,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4657,7922,41070,18427,3,3361,'App\\Models\\Receipt',3361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',32217.00,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4658,7922,41070,18427,3,3362,'App\\Models\\Receipt',3362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',505987.42,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4659,7922,41070,18427,3,3363,'App\\Models\\Receipt',3363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',21356.19,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4660,7922,41070,18427,3,3364,'App\\Models\\Receipt',3364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',10273.27,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4661,7922,41070,18427,3,3365,'App\\Models\\Receipt',3365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1422.00,NULL,NULL,1,'2023-05-10 17:48:57','2023-05-10 17:48:57',NULL),(4662,7922,41070,18428,3,3366,'App\\Models\\Receipt',3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1180.00,NULL,NULL,1,'2023-05-10 17:49:05','2023-05-10 17:49:05',NULL),(4663,7922,41070,18428,3,3367,'App\\Models\\Receipt',3367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',7369.93,NULL,NULL,1,'2023-05-10 17:49:05','2023-05-10 17:49:05',NULL),(4664,7922,41070,18428,3,3368,'App\\Models\\Receipt',3368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',4859.99,NULL,NULL,1,'2023-05-10 17:49:05','2023-05-10 17:49:05',NULL),(4665,7922,41070,18428,3,3369,'App\\Models\\Receipt',3369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',15831.60,NULL,NULL,1,'2023-05-10 17:49:05','2023-05-10 17:49:05',NULL),(4666,7922,41070,18428,3,3370,'App\\Models\\Receipt',3370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',800.00,NULL,NULL,1,'2023-05-10 17:49:05','2023-05-10 17:49:05',NULL),(4667,7922,41070,18428,3,3371,'App\\Models\\Receipt',3371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',47988.64,NULL,NULL,1,'2023-05-10 17:49:05','2023-05-10 17:49:05',NULL);
INSERT INTO `balance_libro` VALUES (4668,7922,41070,18428,3,3372,'App\\Models\\Receipt',3372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',111.86,NULL,NULL,1,'2023-05-10 17:49:05','2023-05-10 17:49:05',NULL),(4669,7922,41070,18428,3,3373,'App\\Models\\Receipt',3373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',17676.59,NULL,NULL,1,'2023-05-10 17:49:05','2023-05-10 17:49:05',NULL),(4670,7922,41070,18428,3,3374,'App\\Models\\Receipt',3374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',450.91,NULL,NULL,1,'2023-05-10 17:49:05','2023-05-10 17:49:05',NULL),(4671,7922,41070,18428,3,3375,'App\\Models\\Receipt',3375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',5255.99,NULL,NULL,1,'2023-05-10 17:49:05','2023-05-10 17:49:05',NULL),(4672,7922,41070,18428,3,3376,'App\\Models\\Receipt',3376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',3042.13,NULL,NULL,1,'2023-05-10 17:49:05','2023-05-10 17:49:05',NULL),(4673,7922,41070,18428,3,3377,'App\\Models\\Receipt',3377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',1843.73,NULL,NULL,1,'2023-05-10 17:49:05','2023-05-10 17:49:05',NULL),(4674,7922,41070,18428,3,3378,'App\\Models\\Receipt',3378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',19899.00,NULL,NULL,1,'2023-05-10 17:49:05','2023-05-10 17:49:05',NULL),(4675,7922,41070,18428,3,3379,'App\\Models\\Receipt',3379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2682.00,NULL,NULL,1,'2023-05-10 17:49:06','2023-05-10 17:49:06',NULL),(4676,7922,41070,18429,3,3380,'App\\Models\\Receipt',3380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',29477.61,NULL,NULL,1,'2023-05-10 17:49:16','2023-05-10 17:49:16',NULL),(4677,7922,41070,18429,3,3381,'App\\Models\\Receipt',3381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',85171.98,NULL,NULL,1,'2023-05-10 17:49:16','2023-05-10 17:49:16',NULL),(4678,7922,41070,18429,3,3382,'App\\Models\\Receipt',3382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1180.00,NULL,NULL,1,'2023-05-10 17:49:16','2023-05-10 17:49:16',NULL),(4679,7922,41070,18429,3,3383,'App\\Models\\Receipt',3383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',30116.84,NULL,NULL,1,'2023-05-10 17:49:16','2023-05-10 17:49:16',NULL),(4680,7922,41070,18429,3,3384,'App\\Models\\Receipt',3384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',8325.77,NULL,NULL,1,'2023-05-10 17:49:16','2023-05-10 17:49:16',NULL),(4681,7922,41070,18429,3,3385,'App\\Models\\Receipt',3385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',8325.77,NULL,NULL,1,'2023-05-10 17:49:16','2023-05-10 17:49:16',NULL),(4682,7922,41070,18429,3,3386,'App\\Models\\Receipt',3386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',97304.27,NULL,NULL,1,'2023-05-10 17:49:16','2023-05-10 17:49:16',NULL),(4683,7922,41070,18429,3,3387,'App\\Models\\Receipt',3387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',30584.95,NULL,NULL,1,'2023-05-10 17:49:16','2023-05-10 17:49:16',NULL),(4684,7922,41070,18429,3,3388,'App\\Models\\Receipt',3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4590.19,NULL,NULL,1,'2023-05-10 17:49:16','2023-05-10 17:49:16',NULL),(4685,7922,41070,18429,3,3389,'App\\Models\\Receipt',3389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3519.00,NULL,NULL,1,'2023-05-10 17:49:16','2023-05-10 17:49:16',NULL),(4686,7922,41070,18430,3,3390,'App\\Models\\Receipt',3390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',6370.99,NULL,NULL,1,'2023-05-10 17:49:23','2023-05-10 17:49:23',NULL),(4687,7922,41070,18430,3,3391,'App\\Models\\Receipt',3391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1180.00,NULL,NULL,1,'2023-05-10 17:49:23','2023-05-10 17:49:23',NULL),(4688,7922,41070,18430,3,3392,'App\\Models\\Receipt',3392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',2824.89,NULL,NULL,1,'2023-05-10 17:49:23','2023-05-10 17:49:23',NULL);
INSERT INTO `balance_libro` VALUES (4689,7922,41070,18430,3,3393,'App\\Models\\Receipt',3393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',7167.34,NULL,NULL,1,'2023-05-10 17:49:23','2023-05-10 17:49:23',NULL),(4690,7922,41070,18430,3,3394,'App\\Models\\Receipt',3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1415.48,NULL,NULL,1,'2023-05-10 17:49:23','2023-05-10 17:49:23',NULL),(4691,7922,41070,18430,3,3395,'App\\Models\\Receipt',3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',539.93,NULL,NULL,1,'2023-05-10 17:49:23','2023-05-10 17:49:23',NULL),(4692,7922,41070,18430,3,3396,'App\\Models\\Receipt',3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',239125.69,NULL,NULL,1,'2023-05-10 17:49:23','2023-05-10 17:49:23',NULL),(4693,7922,41070,18430,3,3397,'App\\Models\\Receipt',3397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',2967.59,NULL,NULL,1,'2023-05-10 17:49:23','2023-05-10 17:49:23',NULL),(4694,7922,41070,18430,3,3398,'App\\Models\\Receipt',3398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',3716.79,NULL,NULL,1,'2023-05-10 17:49:23','2023-05-10 17:49:23',NULL),(4695,7922,41070,18430,3,3399,'App\\Models\\Receipt',3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1700.77,NULL,NULL,1,'2023-05-10 17:49:23','2023-05-10 17:49:23',NULL),(4696,7922,41070,18430,3,3400,'App\\Models\\Receipt',3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',7264.07,NULL,NULL,1,'2023-05-10 17:49:23','2023-05-10 17:49:23',NULL),(4697,7922,41070,18430,3,3401,'App\\Models\\Receipt',3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',873.00,NULL,NULL,1,'2023-05-10 17:49:23','2023-05-10 17:49:23',NULL),(4698,7922,41070,18431,3,3402,'App\\Models\\Receipt',3402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',1371.99,NULL,NULL,1,'2023-05-10 17:49:29','2023-05-10 17:49:29',NULL),(4699,7922,41070,18431,3,3403,'App\\Models\\Receipt',3403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',19931.13,NULL,NULL,1,'2023-05-10 17:49:29','2023-05-10 17:49:29',NULL),(4700,7922,41070,18431,3,3404,'App\\Models\\Receipt',3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',68367.33,NULL,NULL,1,'2023-05-10 17:49:29','2023-05-10 17:49:29',NULL),(4701,7922,41070,18431,3,3405,'App\\Models\\Receipt',3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1180.00,NULL,NULL,1,'2023-05-10 17:49:29','2023-05-10 17:49:29',NULL),(4702,7922,41070,18431,3,3406,'App\\Models\\Receipt',3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',47343.65,NULL,NULL,1,'2023-05-10 17:49:29','2023-05-10 17:49:29',NULL),(4703,7922,41070,18431,3,3407,'App\\Models\\Receipt',3407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',52217.40,NULL,NULL,1,'2023-05-10 17:49:30','2023-05-10 17:49:30',NULL),(4704,7922,41070,18431,3,3408,'App\\Models\\Receipt',3408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',12975.33,NULL,NULL,1,'2023-05-10 17:49:30','2023-05-10 17:49:30',NULL),(4705,7922,41070,18431,3,3409,'App\\Models\\Receipt',3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',36800.00,NULL,NULL,1,'2023-05-10 17:49:30','2023-05-10 17:49:30',NULL),(4706,7922,41070,18431,3,3410,'App\\Models\\Receipt',3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',7068.70,NULL,NULL,1,'2023-05-10 17:49:30','2023-05-10 17:49:30',NULL),(4707,7922,41070,18431,3,3411,'App\\Models\\Receipt',3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',8694.62,NULL,NULL,1,'2023-05-10 17:49:30','2023-05-10 17:49:30',NULL),(4708,7922,41070,18431,3,3412,'App\\Models\\Receipt',3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',6359.83,NULL,NULL,1,'2023-05-10 17:49:30','2023-05-10 17:49:30',NULL),(4709,7922,41070,18431,3,3413,'App\\Models\\Receipt',3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',22121.48,NULL,NULL,1,'2023-05-10 17:49:30','2023-05-10 17:49:30',NULL);
INSERT INTO `balance_libro` VALUES (4710,7922,41070,18431,3,3414,'App\\Models\\Receipt',3414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1670.21,NULL,NULL,1,'2023-05-10 17:49:30','2023-05-10 17:49:30',NULL),(4711,7922,41070,18431,3,3415,'App\\Models\\Receipt',3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',161709.54,NULL,NULL,1,'2023-05-10 17:49:30','2023-05-10 17:49:30',NULL),(4712,7922,41070,18431,3,3416,'App\\Models\\Receipt',3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',996.10,NULL,NULL,1,'2023-05-10 17:49:30','2023-05-10 17:49:30',NULL),(4713,7922,41070,18431,3,3417,'App\\Models\\Receipt',3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',215556.37,NULL,NULL,1,'2023-05-10 17:49:30','2023-05-10 17:49:30',NULL),(4714,7922,41070,18431,3,3418,'App\\Models\\Receipt',3418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',5014.97,NULL,NULL,1,'2023-05-10 17:49:30','2023-05-10 17:49:30',NULL),(4715,7922,41070,18431,3,3419,'App\\Models\\Receipt',3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',6740.31,NULL,NULL,1,'2023-05-10 17:49:30','2023-05-10 17:49:30',NULL),(4716,7922,41070,18431,3,3420,'App\\Models\\Receipt',3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',30509.31,NULL,NULL,1,'2023-05-10 17:49:30','2023-05-10 17:49:30',NULL),(4717,7922,41070,18431,3,3421,'App\\Models\\Receipt',3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',3599.04,NULL,NULL,1,'2023-05-10 17:49:30','2023-05-10 17:49:30',NULL),(4718,7922,41070,18431,3,3422,'App\\Models\\Receipt',3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3573.00,NULL,NULL,1,'2023-05-10 17:49:30','2023-05-10 17:49:30',NULL),(4719,7922,41070,18432,3,3423,'App\\Models\\Receipt',3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',603.86,NULL,NULL,1,'2023-05-10 17:49:37','2023-05-10 17:49:37',NULL),(4720,7922,41070,18432,3,3424,'App\\Models\\Receipt',3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',4975.91,NULL,NULL,1,'2023-05-10 17:49:37','2023-05-10 17:49:37',NULL),(4721,7922,41070,18432,3,3425,'App\\Models\\Receipt',3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',13939.91,NULL,NULL,1,'2023-05-10 17:49:37','2023-05-10 17:49:37',NULL),(4722,7922,41070,18432,3,3426,'App\\Models\\Receipt',3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',9046.29,NULL,NULL,1,'2023-05-10 17:49:37','2023-05-10 17:49:37',NULL),(4723,7922,41070,18432,3,3427,'App\\Models\\Receipt',3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',603.86,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4724,7922,41070,18432,3,3428,'App\\Models\\Receipt',3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',400.00,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4725,7922,41070,18432,3,3429,'App\\Models\\Receipt',3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',408110.47,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4726,7922,41070,18432,3,3430,'App\\Models\\Receipt',3430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',1180.00,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4727,7922,41070,18432,3,3431,'App\\Models\\Receipt',3431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',30121.60,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4728,7922,41070,18432,3,3432,'App\\Models\\Receipt',3432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',25032.65,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4729,7922,41070,18432,3,3433,'App\\Models\\Receipt',3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',77293.54,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4730,7922,41070,18432,3,3434,'App\\Models\\Receipt',3434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',5759.99,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL);
INSERT INTO `balance_libro` VALUES (4731,7922,41070,18432,3,3435,'App\\Models\\Receipt',3435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',13305.61,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4732,7922,41070,18432,3,3436,'App\\Models\\Receipt',3436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',59670.05,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4733,7922,41070,18432,3,3437,'App\\Models\\Receipt',3437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',60599.00,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4734,7922,41070,18432,3,3438,'App\\Models\\Receipt',3438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',57000.00,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4735,7922,41070,18432,3,3439,'App\\Models\\Receipt',3439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',162144.72,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4736,7922,41070,18432,3,3440,'App\\Models\\Receipt',3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',18599.85,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4737,7922,41070,18432,3,3441,'App\\Models\\Receipt',3441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',40857.80,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4738,7922,41070,18432,3,3442,'App\\Models\\Receipt',3442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',25288.35,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4739,7922,41070,18432,3,3443,'App\\Models\\Receipt',3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',11050.06,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4740,7922,41070,18432,3,3444,'App\\Models\\Receipt',3444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',6219.12,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4741,7922,41070,18432,3,3445,'App\\Models\\Receipt',3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',9399.00,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4742,7922,41070,18432,3,3446,'App\\Models\\Receipt',3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',891.00,NULL,NULL,1,'2023-05-10 17:49:38','2023-05-10 17:49:38',NULL),(4743,7922,40723,6064,3,3447,'App\\Models\\Receipt',3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',737496.09,NULL,NULL,1,'2023-05-15 16:03:10','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4744,7922,40723,6064,3,3448,'App\\Models\\Receipt',3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',809958.15,NULL,NULL,1,'2023-05-15 16:03:10','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4745,7922,40723,6064,3,3449,'App\\Models\\Receipt',3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',669115.15,NULL,NULL,1,'2023-05-15 16:03:10','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4746,7922,40723,6064,3,3450,'App\\Models\\Receipt',3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',622514.97,NULL,NULL,1,'2023-05-15 16:03:10','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4747,7922,40723,6064,3,3451,'App\\Models\\Receipt',3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',85131.24,NULL,NULL,1,'2023-05-15 16:03:10','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4748,7922,40723,6064,3,3452,'App\\Models\\Receipt',3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',85131.24,NULL,NULL,1,'2023-05-15 16:03:10','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4749,7922,40723,6064,3,3453,'App\\Models\\Receipt',3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',175114.39,NULL,NULL,1,'2023-05-15 16:03:10','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4750,7922,40723,6064,3,3454,'App\\Models\\Receipt',3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',175114.39,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49');
INSERT INTO `balance_libro` VALUES (4751,7922,40723,6064,3,3455,'App\\Models\\Receipt',3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',554721.80,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4752,7922,40723,6064,3,3456,'App\\Models\\Receipt',3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',501068.38,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4753,7922,40723,6064,3,3457,'App\\Models\\Receipt',3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',672941.20,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4754,7922,40723,6064,3,3458,'App\\Models\\Receipt',3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',652025.46,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4755,7922,40723,6064,3,3459,'App\\Models\\Receipt',3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',173927.67,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4756,7922,40723,6064,3,3460,'App\\Models\\Receipt',3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',173927.67,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4757,7922,40723,6064,3,3461,'App\\Models\\Receipt',3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',145949.02,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4758,7922,40723,6064,3,3462,'App\\Models\\Receipt',3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',145949.02,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4759,7922,40723,6064,3,3463,'App\\Models\\Receipt',3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',31500.00,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4760,7922,40723,6064,3,3464,'App\\Models\\Receipt',3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',881189.22,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4761,7922,40723,6064,3,3465,'App\\Models\\Receipt',3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',1013958.70,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4762,7922,40723,6064,3,3466,'App\\Models\\Receipt',3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',949392.72,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4763,7922,40723,6064,3,3467,'App\\Models\\Receipt',3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',898467.44,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4764,7922,40723,6064,3,3468,'App\\Models\\Receipt',3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',4947.65,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4765,7922,40723,6064,3,3469,'App\\Models\\Receipt',3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',4947.65,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4766,7922,40723,6064,3,3470,'App\\Models\\Receipt',3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',99373.97,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4767,7922,40723,6064,3,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',124282.50,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4768,7922,40723,6064,3,3472,'App\\Models\\Receipt',3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',124282.50,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4769,7922,40723,6064,3,3473,'App\\Models\\Receipt',3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',74910.00,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49');
INSERT INTO `balance_libro` VALUES (4770,7922,40723,6064,3,3474,'App\\Models\\Receipt',3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',124282.50,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4771,7922,40723,6064,3,3475,'App\\Models\\Receipt',3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',149820.00,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4772,7922,40723,6064,3,3476,'App\\Models\\Receipt',3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',21367.07,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4773,7922,40723,6064,3,3477,'App\\Models\\Receipt',3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',248565.00,NULL,NULL,1,'2023-05-15 16:03:11','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4774,7922,40723,6064,3,3478,'App\\Models\\Receipt',3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',240466.87,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4775,7922,40723,6064,3,3479,'App\\Models\\Receipt',3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',126019.23,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4776,7922,40723,6064,3,3480,'App\\Models\\Receipt',3480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',240466.87,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4777,7922,40723,6064,3,3481,'App\\Models\\Receipt',3481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',126019.23,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4778,7922,40723,6064,3,3482,'App\\Models\\Receipt',3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',199154.22,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4779,7922,40723,6064,3,3483,'App\\Models\\Receipt',3483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',212107.34,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4780,7922,40723,6064,3,3484,'App\\Models\\Receipt',3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',400000.00,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4781,7922,40723,6064,3,3485,'App\\Models\\Receipt',3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',565107.60,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4782,7922,40723,6064,3,3486,'App\\Models\\Receipt',3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',538325.24,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4783,7922,40723,6064,3,3487,'App\\Models\\Receipt',3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',551716.42,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4784,7922,40723,6064,3,3488,'App\\Models\\Receipt',3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',537432.50,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4785,7922,40723,6064,3,3489,'App\\Models\\Receipt',3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',118830.45,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4786,7922,40723,6064,3,3490,'App\\Models\\Receipt',3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',131780.45,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4787,7922,40723,6064,3,3491,'App\\Models\\Receipt',3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',131780.45,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4788,7922,40723,6064,3,3492,'App\\Models\\Receipt',3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',118830.45,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49');
INSERT INTO `balance_libro` VALUES (4789,7922,40723,6064,3,3493,'App\\Models\\Receipt',3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',1122174.92,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4790,7922,40723,6064,3,3494,'App\\Models\\Receipt',3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',1184012.76,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4791,7922,40723,6064,3,3495,'App\\Models\\Receipt',3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',1163097.02,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4792,7922,40723,6064,3,3496,'App\\Models\\Receipt',3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',1171281.44,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4793,7922,40723,6064,3,3497,'App\\Models\\Receipt',3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',191532.86,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4794,7922,40723,6064,3,3498,'App\\Models\\Receipt',3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',191532.86,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4795,7922,40723,6064,3,3499,'App\\Models\\Receipt',3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',121958.89,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4796,7922,40723,6064,3,3500,'App\\Models\\Receipt',3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',121958.89,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4797,7922,40723,6064,3,3501,'App\\Models\\Receipt',3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',5432.89,NULL,NULL,1,'2023-05-15 16:03:12','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4798,7922,40723,6064,3,3502,'App\\Models\\Receipt',3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',544718.62,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4799,7922,40723,6064,3,3503,'App\\Models\\Receipt',3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',554721.80,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4800,7922,40723,6064,3,3504,'App\\Models\\Receipt',3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',157106.77,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4801,7922,40723,6064,3,3505,'App\\Models\\Receipt',3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',157106.77,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4802,7922,40723,6064,3,3506,'App\\Models\\Receipt',3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',117495.37,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4803,7922,40723,6064,3,3507,'App\\Models\\Receipt',3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',117495.37,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4804,7922,40723,6064,3,3508,'App\\Models\\Receipt',3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',550551.96,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4805,7922,40723,6064,3,3509,'App\\Models\\Receipt',3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',460190.64,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4806,7922,40723,6064,3,3510,'App\\Models\\Receipt',3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',461122.20,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4807,7922,40723,6064,3,3511,'App\\Models\\Receipt',3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',546825.72,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:49','2023-05-23 18:23:49');
INSERT INTO `balance_libro` VALUES (4808,7922,40723,6064,3,3512,'App\\Models\\Receipt',3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',74910.00,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4809,7922,40723,6064,3,3513,'App\\Models\\Receipt',3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',68951.25,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:49','2023-05-23 18:23:49'),(4810,7922,40723,6064,3,3514,'App\\Models\\Receipt',3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',114918.75,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4811,7922,40723,6064,3,3515,'App\\Models\\Receipt',3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',37455.00,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4812,7922,40723,6064,3,3516,'App\\Models\\Receipt',3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',170590.36,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4813,7922,40723,6064,3,3517,'App\\Models\\Receipt',3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',93037.09,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4814,7922,40723,6064,3,3518,'App\\Models\\Receipt',3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',170590.36,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4815,7922,40723,6064,3,3519,'App\\Models\\Receipt',3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',93037.09,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4816,7922,40723,6064,3,3520,'App\\Models\\Receipt',3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',521673.60,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4817,7922,40723,6064,3,3521,'App\\Models\\Receipt',3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',589677.48,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4818,7922,40723,6064,3,3522,'App\\Models\\Receipt',3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',698670.00,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4819,7922,40723,6064,3,3523,'App\\Models\\Receipt',3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',465780.00,NULL,NULL,1,'2023-05-15 16:03:13','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4820,7922,40723,6064,3,3524,'App\\Models\\Receipt',3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',577567.20,NULL,NULL,1,'2023-05-15 16:03:14','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4821,7922,40723,6064,3,3525,'App\\Models\\Receipt',3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',695875.32,NULL,NULL,1,'2023-05-15 16:03:14','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4822,7922,40723,6064,3,3526,'App\\Models\\Receipt',3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',664202.28,NULL,NULL,1,'2023-05-15 16:03:14','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4823,7922,40723,6064,3,3527,'App\\Models\\Receipt',3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',549620.40,NULL,NULL,1,'2023-05-15 16:03:14','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4824,7922,40723,6064,3,3528,'App\\Models\\Receipt',3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',252978.63,NULL,NULL,1,'2023-05-15 16:03:14','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4825,7922,40723,6064,3,3529,'App\\Models\\Receipt',3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',252978.63,NULL,NULL,1,'2023-05-15 16:03:14','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4826,7922,40723,6064,3,3530,'App\\Models\\Receipt',3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',186358.31,NULL,NULL,1,'2023-05-15 16:03:14','2023-05-23 18:23:50','2023-05-23 18:23:50');
INSERT INTO `balance_libro` VALUES (4827,7922,40723,6064,3,3531,'App\\Models\\Receipt',3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',186358.31,NULL,NULL,1,'2023-05-15 16:03:14','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4828,7922,40723,6064,3,3532,'App\\Models\\Receipt',3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',709848.72,NULL,NULL,1,'2023-05-15 16:03:14','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4829,7922,40723,6064,3,3533,'App\\Models\\Receipt',3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',694943.76,NULL,NULL,1,'2023-05-15 16:03:14','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4830,7922,40723,6064,3,3534,'App\\Models\\Receipt',3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',687491.28,NULL,NULL,1,'2023-05-15 16:03:14','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4831,7922,40723,6064,3,3535,'App\\Models\\Receipt',3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',653023.56,NULL,NULL,1,'2023-05-15 16:03:14','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4832,7922,40723,6064,3,3536,'App\\Models\\Receipt',3536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',0.00,NULL,NULL,1,'2023-05-15 16:03:14','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4833,7922,40723,6064,3,3537,'App\\Models\\Receipt',3537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',0.00,NULL,NULL,1,'2023-05-15 16:03:14','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4834,7922,40723,6064,3,3538,'App\\Models\\Receipt',3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',57000.00,NULL,NULL,1,'2023-05-15 16:03:14','2023-05-23 18:23:50','2023-05-23 18:23:50'),(4835,7922,40759,10723,2,3539,'App\\Models\\Receipt',3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',40281.00,NULL,NULL,1,'2023-05-15 16:32:54','2023-05-15 16:32:54',NULL),(4836,7922,40759,10723,2,3540,'App\\Models\\Receipt',3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',279110.00,NULL,NULL,1,'2023-05-15 16:32:54','2023-05-15 16:32:54',NULL),(4837,7922,40721,3055,2,3541,'App\\Models\\Receipt',3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',1850.00,NULL,NULL,1,'2023-05-15 17:00:41','2023-05-15 17:00:41',NULL),(4838,7922,40721,3055,2,3542,'App\\Models\\Receipt',3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',229900.00,NULL,NULL,1,'2023-05-15 17:00:42','2023-05-15 17:00:42',NULL),(4839,7922,40721,3055,2,3543,'App\\Models\\Receipt',3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',387200.00,NULL,NULL,1,'2023-05-15 17:00:42','2023-05-15 17:00:42',NULL),(4840,7922,40721,3055,2,3544,'App\\Models\\Receipt',3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',15150.00,NULL,NULL,1,'2023-05-15 17:00:42','2023-05-15 17:00:42',NULL),(4841,7922,40721,3055,2,3545,'App\\Models\\Receipt',3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',544500.00,NULL,NULL,1,'2023-05-15 17:00:42','2023-05-15 17:00:42',NULL),(4842,7922,40721,3055,2,3546,'App\\Models\\Receipt',3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',375100.00,NULL,NULL,1,'2023-05-15 17:00:42','2023-05-15 17:00:42',NULL),(4843,7922,40721,3055,2,3547,'App\\Models\\Receipt',3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',356950.00,NULL,NULL,1,'2023-05-15 17:00:42','2023-05-15 17:00:42',NULL),(4844,7922,40721,3055,2,3548,'App\\Models\\Receipt',3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',423500.00,NULL,NULL,1,'2023-05-15 17:00:43','2023-05-15 17:00:43',NULL),(4845,7922,40721,3055,2,3549,'App\\Models\\Receipt',3549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',1800.02,NULL,NULL,1,'2023-05-15 17:00:43','2023-05-15 17:00:43',NULL),(4846,7922,40721,3055,2,3550,'App\\Models\\Receipt',3550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',19662.50,NULL,NULL,1,'2023-05-15 17:00:43','2023-05-15 17:00:43',NULL);
INSERT INTO `balance_libro` VALUES (4847,7922,40721,3055,2,3551,'App\\Models\\Receipt',3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',423500.00,NULL,NULL,1,'2023-05-15 17:00:43','2023-05-15 17:00:43',NULL),(4848,7922,40721,3055,2,3552,'App\\Models\\Receipt',3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',3950.00,NULL,NULL,1,'2023-05-15 17:00:43','2023-05-15 17:00:43',NULL),(4849,7922,40721,3055,2,3553,'App\\Models\\Receipt',3553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',4500.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4850,7922,40721,3055,2,3554,'App\\Models\\Receipt',3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',700.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4851,7922,40721,3055,2,3555,'App\\Models\\Receipt',3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',4900.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4852,7922,40721,3055,2,3556,'App\\Models\\Receipt',3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',19500.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4853,7922,40721,3055,2,3557,'App\\Models\\Receipt',3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',1650.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4854,7922,40721,3055,2,3558,'App\\Models\\Receipt',3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',3900.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4855,7922,40721,3055,2,3559,'App\\Models\\Receipt',3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',2900.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4856,7922,40721,3055,2,3560,'App\\Models\\Receipt',3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',4485.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4857,7922,40721,3055,2,3561,'App\\Models\\Receipt',3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',12000.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4858,7922,40721,3055,2,3562,'App\\Models\\Receipt',3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',4100.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4859,7922,40721,3055,2,3563,'App\\Models\\Receipt',3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',1600.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4860,7922,40721,3055,2,3564,'App\\Models\\Receipt',3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',250.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4861,7922,40721,3055,2,3565,'App\\Models\\Receipt',3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',12000.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4862,7922,40721,3055,2,3566,'App\\Models\\Receipt',3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',4500.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4863,7922,40721,3055,2,3567,'App\\Models\\Receipt',3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',800.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4864,7922,40721,3055,2,3568,'App\\Models\\Receipt',3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',393250.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4865,7922,40721,3055,2,3569,'App\\Models\\Receipt',3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',15150.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4866,7922,40721,3055,2,3570,'App\\Models\\Receipt',3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',27140.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4867,7922,40721,3055,2,3571,'App\\Models\\Receipt',3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',1100.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL);
INSERT INTO `balance_libro` VALUES (4868,7922,40721,3055,2,3572,'App\\Models\\Receipt',3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',4800.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4869,7922,40721,3055,2,3573,'App\\Models\\Receipt',3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',3500.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4870,7922,40721,3055,2,3574,'App\\Models\\Receipt',3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',5200.00,NULL,NULL,1,'2023-05-15 17:00:44','2023-05-15 17:00:44',NULL),(4871,7922,40721,3055,2,3575,'App\\Models\\Receipt',3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',8878.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4872,7922,40721,3055,2,3576,'App\\Models\\Receipt',3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',500.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4873,7922,40721,3055,2,3577,'App\\Models\\Receipt',3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',2410.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4874,7922,40721,3055,2,3578,'App\\Models\\Receipt',3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',28025.50,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4875,7922,40721,3055,2,3579,'App\\Models\\Receipt',3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',2500.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4876,7922,40721,3055,2,3580,'App\\Models\\Receipt',3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',17300.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4877,7922,40721,3055,2,3581,'App\\Models\\Receipt',3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',358160.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4878,7922,40721,3055,2,3582,'App\\Models\\Receipt',3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',430760.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4879,7922,40721,3055,2,3583,'App\\Models\\Receipt',3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1210.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4880,7922,40721,3055,2,3584,'App\\Models\\Receipt',3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1320.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4881,7922,40721,3055,2,3585,'App\\Models\\Receipt',3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1200.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4882,7922,40721,3055,2,3586,'App\\Models\\Receipt',3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1300.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4883,7922,40721,3055,2,3587,'App\\Models\\Receipt',3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',2900.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4884,7922,40721,3055,2,3588,'App\\Models\\Receipt',3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1800.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4885,7922,40721,3055,2,3589,'App\\Models\\Receipt',3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1600.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4886,7922,40721,3055,2,3590,'App\\Models\\Receipt',3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',5000.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4887,7922,40721,3055,2,3591,'App\\Models\\Receipt',3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',200.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4888,7922,40721,3055,2,3592,'App\\Models\\Receipt',3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',400.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL);
INSERT INTO `balance_libro` VALUES (4889,7922,40721,3055,2,3593,'App\\Models\\Receipt',3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',9350.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4890,7922,40721,3055,2,3594,'App\\Models\\Receipt',3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1250.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4891,7922,40721,3055,2,3595,'App\\Models\\Receipt',3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',7850.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4892,7922,40721,3055,2,3596,'App\\Models\\Receipt',3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',3300.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4893,7922,40721,3055,2,3597,'App\\Models\\Receipt',3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',24860.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4894,7922,40721,3055,2,3598,'App\\Models\\Receipt',3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',450.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4895,7922,40721,3055,2,3599,'App\\Models\\Receipt',3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',900.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4896,7922,40721,3055,2,3600,'App\\Models\\Receipt',3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',12075.00,NULL,NULL,1,'2023-05-15 17:00:45','2023-05-15 17:00:45',NULL),(4897,7922,40721,3055,2,3601,'App\\Models\\Receipt',3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',7575.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4898,7922,40721,3055,2,3602,'App\\Models\\Receipt',3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',1400.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4899,7922,40721,3055,2,3603,'App\\Models\\Receipt',3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',5750.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4900,7922,40721,3055,2,3604,'App\\Models\\Receipt',3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',1200.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4901,7922,40721,3055,2,3605,'App\\Models\\Receipt',3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',2250.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4902,7922,40721,3055,2,3606,'App\\Models\\Receipt',3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',3190.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4903,7922,40721,3055,2,3607,'App\\Models\\Receipt',3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',500.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4904,7922,40721,3055,2,3608,'App\\Models\\Receipt',3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',600.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4905,7922,40721,3055,2,3609,'App\\Models\\Receipt',3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',4290.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4906,7922,40721,3055,2,3610,'App\\Models\\Receipt',3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',3510.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4907,7922,40721,3055,2,3611,'App\\Models\\Receipt',3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',243573.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4908,7922,40721,3055,2,3612,'App\\Models\\Receipt',3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',1100.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4909,7922,40721,3055,2,3613,'App\\Models\\Receipt',3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',7800.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL);
INSERT INTO `balance_libro` VALUES (4910,7922,40721,3055,2,3614,'App\\Models\\Receipt',3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',6270.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4911,7922,40721,3055,2,3615,'App\\Models\\Receipt',3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',3000.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4912,7922,40721,3055,2,3616,'App\\Models\\Receipt',3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',2750.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4913,7922,40721,3055,2,3617,'App\\Models\\Receipt',3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',1870.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4914,7922,40721,3055,2,3618,'App\\Models\\Receipt',3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',1600.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4915,7922,40721,3055,2,3619,'App\\Models\\Receipt',3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',1700.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4916,7922,40721,3055,2,3620,'App\\Models\\Receipt',3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',1700.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4917,7922,40721,3055,2,3621,'App\\Models\\Receipt',3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',3700.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4918,7922,40721,3055,2,3622,'App\\Models\\Receipt',3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',2890.50,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4919,7922,40721,3055,2,3623,'App\\Models\\Receipt',3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',1500.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4920,7922,40721,3055,2,3624,'App\\Models\\Receipt',3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',1980.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4921,7922,40721,3055,2,3625,'App\\Models\\Receipt',3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',2500.00,NULL,NULL,1,'2023-05-15 17:00:46','2023-05-15 17:00:46',NULL),(4922,7922,40721,3055,2,3626,'App\\Models\\Receipt',3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',500.00,NULL,NULL,1,'2023-05-15 17:00:47','2023-05-15 17:00:47',NULL),(4923,7922,40721,3055,2,3627,'App\\Models\\Receipt',3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',3850.00,NULL,NULL,1,'2023-05-15 17:00:47','2023-05-15 17:00:47',NULL),(4924,7922,40721,3055,3,3628,'App\\Models\\Receipt',3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',6934.49,NULL,NULL,1,'2023-05-15 17:03:05','2023-05-15 17:03:05',NULL),(4925,7922,40721,3055,3,3629,'App\\Models\\Receipt',3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',50000.00,NULL,NULL,1,'2023-05-15 17:03:05','2023-05-15 17:03:05',NULL),(4926,7922,40721,3055,3,3630,'App\\Models\\Receipt',3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',148830.00,NULL,NULL,1,'2023-05-15 17:03:05','2023-05-15 17:03:05',NULL),(4927,7922,40721,3055,3,3631,'App\\Models\\Receipt',3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',10000.00,NULL,NULL,1,'2023-05-15 17:03:05','2023-05-15 17:03:05',NULL),(4928,7922,40721,3055,3,3632,'App\\Models\\Receipt',3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',15000.03,NULL,NULL,1,'2023-05-15 17:03:05','2023-05-15 17:03:05',NULL),(4929,7922,40721,3055,3,3633,'App\\Models\\Receipt',3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',3000.00,NULL,NULL,1,'2023-05-15 17:03:05','2023-05-15 17:03:05',NULL),(4930,7922,40721,3055,3,3634,'App\\Models\\Receipt',3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',12499.99,NULL,NULL,1,'2023-05-15 17:03:05','2023-05-15 17:03:05',NULL);
INSERT INTO `balance_libro` VALUES (4931,7922,40721,3055,3,3635,'App\\Models\\Receipt',3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',40000.00,NULL,NULL,1,'2023-05-15 17:03:05','2023-05-15 17:03:05',NULL),(4932,7922,40721,3055,3,3636,'App\\Models\\Receipt',3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',33396.00,NULL,NULL,1,'2023-05-15 17:03:05','2023-05-15 17:03:05',NULL),(4933,7922,40721,3055,3,3637,'App\\Models\\Receipt',3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',2897.00,NULL,NULL,1,'2023-05-15 17:03:05','2023-05-15 17:03:05',NULL),(4934,7922,40721,3055,3,3638,'App\\Models\\Receipt',3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',8599.99,NULL,NULL,1,'2023-05-15 17:03:05','2023-05-15 17:03:05',NULL),(4935,7922,40721,3055,3,3639,'App\\Models\\Receipt',3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',12500.00,NULL,NULL,1,'2023-05-15 17:03:05','2023-05-15 17:03:05',NULL),(4936,7922,40721,3055,3,3640,'App\\Models\\Receipt',3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1596.00,NULL,NULL,1,'2023-05-15 17:03:05','2023-05-15 17:03:05',NULL),(4937,7922,40721,3055,3,3641,'App\\Models\\Receipt',3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',5395.80,NULL,NULL,1,'2023-05-15 17:03:05','2023-05-15 17:03:05',NULL),(4938,7922,40721,3055,3,3642,'App\\Models\\Receipt',3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',234400.00,NULL,NULL,1,'2023-05-15 17:03:06','2023-05-15 17:03:06',NULL),(4939,7922,40721,3055,3,3643,'App\\Models\\Receipt',3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',498128.93,NULL,NULL,1,'2023-05-15 17:03:06','2023-05-15 17:03:06',NULL),(4940,7922,40721,3055,3,3644,'App\\Models\\Receipt',3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',674760.00,NULL,NULL,1,'2023-05-15 17:03:06','2023-05-15 17:03:06',NULL),(4941,7922,40721,3055,3,3645,'App\\Models\\Receipt',3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',499784.21,NULL,NULL,1,'2023-05-15 17:03:06','2023-05-15 17:03:06',NULL),(4942,7922,40721,3055,3,3646,'App\\Models\\Receipt',3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',0.00,NULL,NULL,1,'2023-05-15 17:03:06','2023-05-15 17:03:06',NULL),(4943,7922,40721,3055,3,3647,'App\\Models\\Receipt',3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',10786.09,NULL,NULL,1,'2023-05-15 17:03:06','2023-05-15 17:03:06',NULL),(4944,7922,40723,6064,2,3648,'App\\Models\\Receipt',3648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',308655.02,NULL,NULL,1,'2023-05-16 16:18:06','2023-05-16 16:22:14','2023-05-16 16:22:14'),(4945,7922,40723,6064,2,3649,'App\\Models\\Receipt',3649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',186092.73,NULL,NULL,1,'2023-05-16 16:18:06','2023-05-16 16:22:14','2023-05-16 16:22:14'),(4946,7922,40723,6064,2,3650,'App\\Models\\Receipt',3650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',404300.03,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:14','2023-05-16 16:22:14'),(4947,7922,40723,6064,2,3651,'App\\Models\\Receipt',3651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',926676.15,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:14','2023-05-16 16:22:14'),(4948,7922,40723,6064,2,3652,'App\\Models\\Receipt',3652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',617870.75,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:14','2023-05-16 16:22:14'),(4949,7922,40723,6064,2,3653,'App\\Models\\Receipt',3653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',297184.59,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:14','2023-05-16 16:22:14'),(4950,7922,40723,6064,2,3654,'App\\Models\\Receipt',3654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',146525.95,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:14','2023-05-16 16:22:14');
INSERT INTO `balance_libro` VALUES (4951,7922,40723,6064,2,3655,'App\\Models\\Receipt',3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',258348.68,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:14','2023-05-16 16:22:14'),(4952,7922,40723,6064,2,3656,'App\\Models\\Receipt',3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',314699.79,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:14','2023-05-16 16:22:14'),(4953,7922,40723,6064,2,3657,'App\\Models\\Receipt',3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',156450.95,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:14','2023-05-16 16:22:14'),(4954,7922,40723,6064,2,3658,'App\\Models\\Receipt',3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',593767.22,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:14','2023-05-16 16:22:14'),(4955,7922,40723,6064,2,3659,'App\\Models\\Receipt',3659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',562355.65,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4956,7922,40723,6064,2,3660,'App\\Models\\Receipt',3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',410284.92,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4957,7922,40723,6064,2,3661,'App\\Models\\Receipt',3661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',3999.97,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4958,7922,40723,6064,2,3662,'App\\Models\\Receipt',3662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',243020.86,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4959,7922,40723,6064,2,3663,'App\\Models\\Receipt',3663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',354649.86,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4960,7922,40723,6064,2,3664,'App\\Models\\Receipt',3664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',5160.03,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4961,7922,40723,6064,2,3665,'App\\Models\\Receipt',3665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',19676.05,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4962,7922,40723,6064,2,3666,'App\\Models\\Receipt',3666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',13200.01,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4963,7922,40723,6064,2,3667,'App\\Models\\Receipt',3667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',8310.97,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4964,7922,40723,6064,2,3668,'App\\Models\\Receipt',3668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',1340456.35,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4965,7922,40723,6064,2,3669,'App\\Models\\Receipt',3669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',4929.98,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4966,7922,40723,6064,2,3670,'App\\Models\\Receipt',3670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',3540.00,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4967,7922,40723,6064,2,3671,'App\\Models\\Receipt',3671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',4549.97,NULL,NULL,1,'2023-05-16 16:18:07','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4968,7922,40723,6064,2,3672,'App\\Models\\Receipt',3672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',619620.75,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4969,7922,40723,6064,2,3673,'App\\Models\\Receipt',3673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',12999.96,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:22:15','2023-05-16 16:22:15');
INSERT INTO `balance_libro` VALUES (4970,7922,40723,6064,2,3674,'App\\Models\\Receipt',3674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',499471.79,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4971,7922,40723,6064,2,3675,'App\\Models\\Receipt',3675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',780224.71,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4972,7922,40723,6064,2,3676,'App\\Models\\Receipt',3676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',7985.05,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4973,7922,40723,6064,2,3677,'App\\Models\\Receipt',3677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',3315.00,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4974,7922,40723,6064,2,3678,'App\\Models\\Receipt',3678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',1074812.75,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4975,7922,40723,6064,2,3679,'App\\Models\\Receipt',3679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',555064.76,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4976,7922,40723,6064,2,3680,'App\\Models\\Receipt',3680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',569760.42,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4977,7922,40723,6064,2,3681,'App\\Models\\Receipt',3681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',4999.97,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4978,7922,40723,6064,2,3682,'App\\Models\\Receipt',3682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',10904.98,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4979,7922,40723,6064,2,3683,'App\\Models\\Receipt',3683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',712604.40,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4980,7922,40723,6064,2,3684,'App\\Models\\Receipt',3684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',10460.04,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4981,7922,40723,6064,2,3685,'App\\Models\\Receipt',3685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',3155.99,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4982,7922,40723,6064,2,3686,'App\\Models\\Receipt',3686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',443678.97,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:22:15','2023-05-16 16:22:15'),(4983,7922,40723,6064,2,3687,'App\\Models\\Receipt',3687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',8489.98,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:22:08','2023-05-16 16:22:08'),(4984,7922,40723,6064,2,3688,'App\\Models\\Receipt',3688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',853839.08,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:21:15','2023-05-16 16:21:15'),(4985,7922,40723,6064,2,3689,'App\\Models\\Receipt',3689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',628726.90,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:21:11','2023-05-16 16:21:11'),(4986,7922,40723,6064,2,3690,'App\\Models\\Receipt',3690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',3559.99,NULL,NULL,1,'2023-05-16 16:18:08','2023-05-16 16:21:03','2023-05-16 16:21:03'),(4987,7922,40723,6064,2,3691,'App\\Models\\Receipt',3691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',3999.97,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:31:21',NULL),(4988,7922,40723,6064,2,3692,'App\\Models\\Receipt',3692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',14900.03,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:31:21',NULL);
INSERT INTO `balance_libro` VALUES (4989,7922,40723,6064,2,3693,'App\\Models\\Receipt',3693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',5160.03,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:31:21',NULL),(4990,7922,40723,6064,2,3694,'App\\Models\\Receipt',3694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',14665.03,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:31:21',NULL),(4991,7922,40723,6064,2,3695,'App\\Models\\Receipt',3695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',3157.98,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:31:21',NULL),(4992,7922,40723,6064,2,3696,'App\\Models\\Receipt',3696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',1853.03,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:31:21',NULL),(4993,7922,40723,6064,2,3697,'App\\Models\\Receipt',3697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5100.05,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:31:21',NULL),(4994,7922,40723,6064,2,3698,'App\\Models\\Receipt',3698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',8099.97,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:31:21',NULL),(4995,7922,40723,6064,2,3699,'App\\Models\\Receipt',3699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',8310.97,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:31:21',NULL),(4996,7922,40723,6064,2,3700,'App\\Models\\Receipt',3700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',4929.98,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:31:21',NULL),(4997,7922,40723,6064,2,3701,'App\\Models\\Receipt',3701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',3540.00,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:31:21',NULL),(4998,7922,40723,6064,2,3702,'App\\Models\\Receipt',3702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',4549.97,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:31:21',NULL),(4999,7922,40723,6064,2,3703,'App\\Models\\Receipt',3703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',12999.96,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:31:21',NULL),(5000,7922,40723,6064,2,3704,'App\\Models\\Receipt',3704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',7985.05,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:31:21',NULL),(5001,7922,40723,6064,2,3705,'App\\Models\\Receipt',3705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',3315.00,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:34:11','2023-05-16 16:34:11'),(5002,7922,40723,6064,2,3706,'App\\Models\\Receipt',3706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',4999.97,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:34:39','2023-05-16 16:34:39'),(5003,7922,40723,6064,2,3707,'App\\Models\\Receipt',3707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',10904.98,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:45:00','2023-05-16 16:45:00'),(5004,7922,40723,6064,2,3708,'App\\Models\\Receipt',3708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',3159.98,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:44:53','2023-05-16 16:44:53'),(5005,7922,40723,6064,2,3709,'App\\Models\\Receipt',3709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',7300.05,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:44:44','2023-05-16 16:44:44'),(5006,7922,40723,6064,2,3710,'App\\Models\\Receipt',3710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',3155.99,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:44:35','2023-05-16 16:44:35'),(5007,7922,40723,6064,2,3711,'App\\Models\\Receipt',3711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',8489.98,NULL,NULL,1,'2023-05-16 16:31:21','2023-05-16 16:37:03','2023-05-16 16:37:03'),(5008,7922,40723,6064,2,3712,'App\\Models\\Receipt',3712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',3559.99,NULL,NULL,1,'2023-05-16 16:31:22','2023-05-16 16:33:52','2023-05-16 16:33:52');
INSERT INTO `balance_libro` VALUES (5009,7922,40723,6064,2,3713,'App\\Models\\Receipt',3713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',27228.04,NULL,NULL,1,'2023-05-16 16:31:32','2023-05-16 16:31:32',NULL),(5010,7922,40723,6064,2,3714,'App\\Models\\Receipt',3714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',45995.05,NULL,NULL,1,'2023-05-16 16:31:32','2023-05-16 16:31:32',NULL),(5011,7922,40723,6064,2,3715,'App\\Models\\Receipt',3715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',6166.95,NULL,NULL,1,'2023-05-16 16:31:32','2023-05-16 16:31:32',NULL),(5012,7922,40723,6064,2,3716,'App\\Models\\Receipt',3716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',10000.04,NULL,NULL,1,'2023-05-16 16:31:32','2023-05-16 16:31:32',NULL),(5013,7922,40723,6064,2,3717,'App\\Models\\Receipt',3717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',61107.03,NULL,NULL,1,'2023-05-16 16:31:32','2023-05-16 16:31:32',NULL),(5014,7922,40723,6064,2,3718,'App\\Models\\Receipt',3718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',62385.04,NULL,NULL,1,'2023-05-16 16:31:32','2023-05-16 16:31:32',NULL),(5015,7922,40723,6064,2,3719,'App\\Models\\Receipt',3719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',19619.96,NULL,NULL,1,'2023-05-16 16:31:32','2023-05-16 16:31:32',NULL),(5016,7922,40723,6064,2,3720,'App\\Models\\Receipt',3720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',64167.03,NULL,NULL,1,'2023-05-16 16:31:32','2023-05-16 16:31:32',NULL),(5017,7922,40723,6064,2,3721,'App\\Models\\Receipt',3721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',4079.98,NULL,NULL,1,'2023-05-16 16:31:32','2023-05-16 16:31:32',NULL),(5018,7922,40723,6064,2,3722,'App\\Models\\Receipt',3722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',26484.96,NULL,NULL,1,'2023-05-16 16:31:32','2023-05-16 16:31:32',NULL),(5019,7922,40723,6064,2,3723,'App\\Models\\Receipt',3723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',16079.96,NULL,NULL,1,'2023-05-16 16:31:32','2023-05-16 16:31:32',NULL),(5020,7922,40723,6064,2,3724,'App\\Models\\Receipt',3724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',8063.97,NULL,NULL,1,'2023-05-16 16:31:32','2023-05-16 16:31:32',NULL),(5021,7922,40723,6064,2,3725,'App\\Models\\Receipt',3725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',3970.95,NULL,NULL,1,'2023-05-16 16:31:32','2023-05-16 16:31:32',NULL),(5022,7922,40723,6064,2,3726,'App\\Models\\Receipt',3726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',56000.03,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5023,7922,40723,6064,2,3727,'App\\Models\\Receipt',3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',14623.99,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5024,7922,40723,6064,2,3728,'App\\Models\\Receipt',3728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',5419.97,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5025,7922,40723,6064,2,3729,'App\\Models\\Receipt',3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',21154.96,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5026,7922,40723,6064,2,3730,'App\\Models\\Receipt',3730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',30722.05,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5027,7922,40723,6064,2,3731,'App\\Models\\Receipt',3731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',18181.04,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5028,7922,40723,6064,2,3732,'App\\Models\\Receipt',3732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',8220.99,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5029,7922,40723,6064,2,3733,'App\\Models\\Receipt',3733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',4850.00,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL);
INSERT INTO `balance_libro` VALUES (5030,7922,40723,6064,2,3734,'App\\Models\\Receipt',3734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',4850.00,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5031,7922,40723,6064,2,3735,'App\\Models\\Receipt',3735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',35184.99,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5032,7922,40723,6064,2,3736,'App\\Models\\Receipt',3736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',43855.03,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5033,7922,40723,6064,2,3737,'App\\Models\\Receipt',3737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',17984.03,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5034,7922,40723,6064,2,3738,'App\\Models\\Receipt',3738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',17984.03,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5035,7922,40723,6064,2,3739,'App\\Models\\Receipt',3739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',2335.97,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5036,7922,40723,6064,2,3740,'App\\Models\\Receipt',3740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',2335.97,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5037,7922,40723,6064,2,3741,'App\\Models\\Receipt',3741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',2335.97,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5038,7922,40723,6064,2,3742,'App\\Models\\Receipt',3742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',73913.98,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5039,7922,40723,6064,2,3743,'App\\Models\\Receipt',3743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',73913.98,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5040,7922,40723,6064,2,3744,'App\\Models\\Receipt',3744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',12660.04,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5041,7922,40723,6064,2,3745,'App\\Models\\Receipt',3745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',12660.04,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5042,7922,40723,6064,2,3746,'App\\Models\\Receipt',3746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',6610.98,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5043,7922,40723,6064,2,3747,'App\\Models\\Receipt',3747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',17415.01,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5044,7922,40723,6064,2,3748,'App\\Models\\Receipt',3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',9614.03,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5045,7922,40723,6064,2,3749,'App\\Models\\Receipt',3749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',38917.05,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5046,7922,40723,6064,2,3750,'App\\Models\\Receipt',3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',137205.96,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5047,7922,40723,6064,2,3751,'App\\Models\\Receipt',3751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',11000.01,NULL,NULL,1,'2023-05-16 16:31:33','2023-05-16 16:31:33',NULL),(5048,7922,40723,6064,2,3752,'App\\Models\\Receipt',3752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',308655.02,NULL,NULL,1,'2023-05-16 16:31:53','2023-05-16 16:31:53',NULL),(5049,7922,40723,6064,2,3753,'App\\Models\\Receipt',3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',186092.73,NULL,NULL,1,'2023-05-16 16:31:53','2023-05-16 16:31:53',NULL),(5050,7922,40723,6064,2,3754,'App\\Models\\Receipt',3754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',404300.03,NULL,NULL,1,'2023-05-16 16:31:53','2023-05-16 16:31:53',NULL);
INSERT INTO `balance_libro` VALUES (5051,7922,40723,6064,2,3755,'App\\Models\\Receipt',3755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',926676.15,NULL,NULL,1,'2023-05-16 16:31:53','2023-05-16 16:31:53',NULL),(5052,7922,40723,6064,2,3756,'App\\Models\\Receipt',3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',617870.75,NULL,NULL,1,'2023-05-16 16:31:53','2023-05-16 16:31:53',NULL),(5053,7922,40723,6064,2,3757,'App\\Models\\Receipt',3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',297184.59,NULL,NULL,1,'2023-05-16 16:31:53','2023-05-16 16:31:53',NULL),(5054,7922,40723,6064,2,3758,'App\\Models\\Receipt',3758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',146525.95,NULL,NULL,1,'2023-05-16 16:31:53','2023-05-16 16:31:53',NULL),(5055,7922,40723,6064,2,3759,'App\\Models\\Receipt',3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',258348.68,NULL,NULL,1,'2023-05-16 16:31:53','2023-05-16 16:31:53',NULL),(5056,7922,40723,6064,2,3760,'App\\Models\\Receipt',3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',314699.79,NULL,NULL,1,'2023-05-16 16:31:53','2023-05-16 16:31:53',NULL),(5057,7922,40723,6064,2,3761,'App\\Models\\Receipt',3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',156450.95,NULL,NULL,1,'2023-05-16 16:31:53','2023-05-16 16:31:53',NULL),(5058,7922,40723,6064,2,3762,'App\\Models\\Receipt',3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',593767.22,NULL,NULL,1,'2023-05-16 16:31:53','2023-05-16 16:31:53',NULL),(5059,7922,40723,6064,2,3763,'App\\Models\\Receipt',3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',562355.65,NULL,NULL,1,'2023-05-16 16:31:53','2023-05-16 16:31:53',NULL),(5060,7922,40723,6064,2,3764,'App\\Models\\Receipt',3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',410284.92,NULL,NULL,1,'2023-05-16 16:31:53','2023-05-16 16:31:53',NULL),(5061,7922,40723,6064,2,3765,'App\\Models\\Receipt',3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',3999.97,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-23 17:05:24','2023-05-23 17:05:24'),(5062,7922,40723,6064,2,3766,'App\\Models\\Receipt',3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',243020.86,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:31:54',NULL),(5063,7922,40723,6064,2,3767,'App\\Models\\Receipt',3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',354649.86,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:31:54',NULL),(5064,7922,40723,6064,2,3768,'App\\Models\\Receipt',3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',5160.03,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-23 17:25:21','2023-05-23 17:25:21'),(5065,7922,40723,6064,2,3769,'App\\Models\\Receipt',3769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',19676.05,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-23 17:28:44','2023-05-23 17:28:44'),(5066,7922,40723,6064,2,3770,'App\\Models\\Receipt',3770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',13200.01,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-23 17:29:21','2023-05-23 17:29:21'),(5067,7922,40723,6064,2,3771,'App\\Models\\Receipt',3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',8310.97,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-23 17:30:04','2023-05-23 17:30:04'),(5068,7922,40723,6064,2,3772,'App\\Models\\Receipt',3772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',1340456.35,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:31:54',NULL),(5069,7922,40723,6064,2,3773,'App\\Models\\Receipt',3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',4929.98,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-23 17:31:37','2023-05-23 17:31:37'),(5070,7922,40723,6064,2,3774,'App\\Models\\Receipt',3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',3540.00,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-23 17:39:44','2023-05-23 17:39:44');
INSERT INTO `balance_libro` VALUES (5071,7922,40723,6064,2,3775,'App\\Models\\Receipt',3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',4549.97,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-23 17:41:08','2023-05-23 17:41:08'),(5072,7922,40723,6064,2,3776,'App\\Models\\Receipt',3776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',619620.75,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:31:54',NULL),(5073,7922,40723,6064,2,3777,'App\\Models\\Receipt',3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',12999.96,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-23 17:41:50','2023-05-23 17:41:50'),(5074,7922,40723,6064,2,3778,'App\\Models\\Receipt',3778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',499471.79,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:31:54',NULL),(5075,7922,40723,6064,2,3779,'App\\Models\\Receipt',3779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',780224.71,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:31:54',NULL),(5076,7922,40723,6064,2,3780,'App\\Models\\Receipt',3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',7985.05,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-23 17:43:33','2023-05-23 17:43:33'),(5077,7922,40723,6064,2,3781,'App\\Models\\Receipt',3781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',3315.00,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:36:56','2023-05-16 16:36:56'),(5078,7922,40723,6064,2,3782,'App\\Models\\Receipt',3782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',1074812.75,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:36:47','2023-05-16 16:36:47'),(5079,7922,40723,6064,2,3783,'App\\Models\\Receipt',3783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',555064.76,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:36:39','2023-05-16 16:36:39'),(5080,7922,40723,6064,2,3784,'App\\Models\\Receipt',3784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',569760.42,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:36:33','2023-05-16 16:36:33'),(5081,7922,40723,6064,2,3785,'App\\Models\\Receipt',3785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',4999.97,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:36:17','2023-05-16 16:36:17'),(5082,7922,40723,6064,2,3786,'App\\Models\\Receipt',3786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',10904.98,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:36:10','2023-05-16 16:36:10'),(5083,7922,40723,6064,2,3787,'App\\Models\\Receipt',3787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',712604.40,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:36:03','2023-05-16 16:36:03'),(5084,7922,40723,6064,2,3788,'App\\Models\\Receipt',3788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',10460.04,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:35:54','2023-05-16 16:35:54'),(5085,7922,40723,6064,2,3789,'App\\Models\\Receipt',3789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',3155.99,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:35:43','2023-05-16 16:35:43'),(5086,7922,40723,6064,2,3790,'App\\Models\\Receipt',3790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',443678.97,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:35:18','2023-05-16 16:35:18'),(5087,7922,40723,6064,2,3791,'App\\Models\\Receipt',3791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',8489.98,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:35:08','2023-05-16 16:35:08'),(5088,7922,40723,6064,2,3792,'App\\Models\\Receipt',3792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',853839.08,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:35:00','2023-05-16 16:35:00'),(5089,7922,40723,6064,2,3793,'App\\Models\\Receipt',3793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',628726.90,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:34:52','2023-05-16 16:34:52');
INSERT INTO `balance_libro` VALUES (5090,7922,40723,6064,2,3794,'App\\Models\\Receipt',3794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',3559.99,NULL,NULL,1,'2023-05-16 16:31:54','2023-05-16 16:33:01','2023-05-16 16:33:01'),(5091,7922,40723,6064,2,3795,'App\\Models\\Receipt',3795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',27228.04,NULL,NULL,1,'2023-05-16 16:32:08','2023-05-23 17:53:25','2023-05-23 17:53:25'),(5092,7922,40723,6064,2,3796,'App\\Models\\Receipt',3796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',301435.05,NULL,NULL,1,'2023-05-16 16:32:08','2023-05-16 16:32:08',NULL),(5093,7922,40723,6064,2,3797,'App\\Models\\Receipt',3797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',123269.06,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-16 16:32:09',NULL),(5094,7922,40723,6064,2,3798,'App\\Models\\Receipt',3798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',241157.09,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-16 16:32:09',NULL),(5095,7922,40723,6064,2,3799,'App\\Models\\Receipt',3799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',400869.58,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-16 16:32:09',NULL),(5096,7922,40723,6064,2,3800,'App\\Models\\Receipt',3800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',82005.00,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-23 17:54:12','2023-05-23 17:54:12'),(5097,7922,40723,6064,2,3801,'App\\Models\\Receipt',3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',68247.01,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-23 17:55:57','2023-05-23 17:55:57'),(5098,7922,40723,6064,2,3802,'App\\Models\\Receipt',3802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',26484.96,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-23 17:56:32','2023-05-23 17:56:32'),(5099,7922,40723,6064,2,3803,'App\\Models\\Receipt',3803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',16079.96,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-23 17:56:56','2023-05-23 17:56:56'),(5100,7922,40723,6064,2,3804,'App\\Models\\Receipt',3804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',8063.97,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-23 17:57:41','2023-05-23 17:57:41'),(5101,7922,40723,6064,2,3805,'App\\Models\\Receipt',3805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',3970.95,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-23 17:58:03','2023-05-23 17:58:03'),(5102,7922,40723,6064,2,3806,'App\\Models\\Receipt',3806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',324000.10,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-16 16:32:09',NULL),(5103,7922,40723,6064,2,3807,'App\\Models\\Receipt',3807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',414539.80,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-16 16:32:09',NULL),(5104,7922,40723,6064,2,3808,'App\\Models\\Receipt',3808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',26574.93,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-16 16:32:09',NULL),(5105,7922,40723,6064,2,3809,'App\\Models\\Receipt',3809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',595600.16,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-16 16:32:09',NULL),(5106,7922,40723,6064,2,3810,'App\\Models\\Receipt',3810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',26402.03,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-23 17:59:41','2023-05-23 17:59:41'),(5107,7922,40723,6064,2,3811,'App\\Models\\Receipt',3811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',259876.64,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-16 16:32:09',NULL),(5108,7922,40723,6064,2,3812,'App\\Models\\Receipt',3812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',9700.01,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-23 18:00:13','2023-05-23 18:00:13'),(5109,7922,40723,6064,2,3813,'App\\Models\\Receipt',3813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',35184.99,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-23 18:00:56','2023-05-23 18:00:56');
INSERT INTO `balance_libro` VALUES (5110,7922,40723,6064,2,3814,'App\\Models\\Receipt',3814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',1102499.86,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-16 16:32:09',NULL),(5111,7922,40723,6064,2,3815,'App\\Models\\Receipt',3815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',577324.40,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-16 16:32:09',NULL),(5112,7922,40723,6064,2,3816,'App\\Models\\Receipt',3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',43855.03,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-23 18:01:36','2023-05-23 18:01:36'),(5113,7922,40723,6064,2,3817,'App\\Models\\Receipt',3817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',35968.07,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-23 18:02:06','2023-05-23 18:02:06'),(5114,7922,40723,6064,2,3818,'App\\Models\\Receipt',3818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',880980.09,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-16 16:32:09',NULL),(5115,7922,40723,6064,2,3819,'App\\Models\\Receipt',3819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',743774.03,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-16 16:32:09',NULL),(5116,7922,40723,6064,2,3820,'App\\Models\\Receipt',3820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',606999.97,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-16 16:32:09',NULL),(5117,7922,40723,6064,2,3821,'App\\Models\\Receipt',3821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',179759.01,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-16 16:32:09',NULL),(5118,7922,40723,6064,2,3822,'App\\Models\\Receipt',3822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',65946.08,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-16 16:32:09',NULL),(5119,7922,40723,6064,2,3823,'App\\Models\\Receipt',3823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',148205.97,NULL,NULL,1,'2023-05-16 16:32:09','2023-05-23 18:04:38','2023-05-23 18:04:38'),(5120,7922,40759,10723,3,3824,'App\\Models\\Receipt',3824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',3302.88,NULL,NULL,1,'2023-05-22 15:56:57','2023-05-22 15:56:57',NULL),(5121,7922,40759,10723,3,3825,'App\\Models\\Receipt',3825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',9000.00,NULL,NULL,1,'2023-05-22 15:56:57','2023-05-22 15:56:57',NULL),(5122,7922,40759,10723,3,3826,'App\\Models\\Receipt',3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',2108.25,NULL,NULL,1,'2023-05-22 15:56:57','2023-05-22 15:56:57',NULL),(5123,7922,40759,10723,3,3827,'App\\Models\\Receipt',3827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',5535.88,NULL,NULL,1,'2023-05-22 15:56:57','2023-05-22 15:56:57',NULL),(5124,7922,40759,10723,3,3828,'App\\Models\\Receipt',3828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',3559.60,NULL,NULL,1,'2023-05-22 15:56:57','2023-05-22 15:56:57',NULL),(5125,7922,40759,10723,3,3829,'App\\Models\\Receipt',3829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',2195.00,NULL,NULL,1,'2023-05-22 15:56:57','2023-05-22 15:56:57',NULL),(5126,7922,40759,10723,3,3830,'App\\Models\\Receipt',3830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',7900.02,NULL,NULL,1,'2023-05-22 15:56:58','2023-05-22 15:56:58',NULL),(5127,7922,40759,10723,3,3831,'App\\Models\\Receipt',3831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',1790.00,NULL,NULL,1,'2023-05-22 15:56:58','2023-05-22 15:56:58',NULL),(5128,7922,40759,10723,3,3832,'App\\Models\\Receipt',3832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',4038.75,NULL,NULL,1,'2023-05-22 15:56:58','2023-05-22 15:56:58',NULL),(5129,7922,40759,10723,3,3833,'App\\Models\\Receipt',3833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',11500.00,NULL,NULL,1,'2023-05-22 15:56:58','2023-05-22 15:56:58',NULL);
INSERT INTO `balance_libro` VALUES (5130,7922,40759,10723,3,3834,'App\\Models\\Receipt',3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',12600.10,NULL,NULL,1,'2023-05-22 15:56:58','2023-05-22 15:56:58',NULL),(5131,7922,40759,10723,3,3835,'App\\Models\\Receipt',3835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',344.23,NULL,NULL,1,'2023-05-22 15:56:58','2023-05-22 15:56:58',NULL),(5132,7922,40759,10723,3,3836,'App\\Models\\Receipt',3836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',229900.00,NULL,NULL,1,'2023-05-22 15:56:58','2023-05-22 15:56:58',NULL),(5133,7922,40759,10723,3,3837,'App\\Models\\Receipt',3837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',11500.00,NULL,NULL,1,'2023-05-22 15:56:58','2023-05-22 15:56:58',NULL),(5134,7922,40759,10723,3,3838,'App\\Models\\Receipt',3838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',3565.40,NULL,NULL,1,'2023-05-22 15:56:58','2023-05-22 15:56:58',NULL),(5135,7922,40759,10723,3,3839,'App\\Models\\Receipt',3839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',5563.35,NULL,NULL,1,'2023-05-22 15:56:58','2023-05-22 15:56:58',NULL),(5136,7922,40759,10720,15,95,'App\\Models\\PeriodLiquidation',NULL,95,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',61595.08,NULL,NULL,1,'2023-05-22 15:57:37','2023-05-22 16:00:21','2023-05-22 16:00:21'),(5137,7922,40759,10723,15,365,'App\\Models\\PeriodLiquidation',NULL,365,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',55431.50,NULL,NULL,1,'2023-05-22 16:43:59','2023-05-22 16:43:59',NULL),(5138,7922,40721,3055,3,3840,'App\\Models\\Receipt',3840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',133878.16,NULL,NULL,1,'2023-05-23 12:25:57','2023-05-23 12:25:57',NULL),(5139,7922,40721,3055,3,3841,'App\\Models\\Receipt',3841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',5001.96,NULL,NULL,1,'2023-05-23 12:27:30','2023-05-23 12:27:30',NULL),(5140,7922,40721,3055,3,3842,'App\\Models\\Receipt',3842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',12300.51,NULL,NULL,1,'2023-05-23 12:28:51','2023-05-23 12:28:51',NULL),(5141,7922,40721,3055,3,3843,'App\\Models\\Receipt',3843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',11500.63,NULL,NULL,1,'2023-05-23 12:29:17','2023-05-23 12:29:17',NULL),(5142,7922,40721,3055,3,3844,'App\\Models\\Receipt',3844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',11656.62,NULL,NULL,1,'2023-05-23 12:29:47','2023-05-23 12:29:47',NULL),(5143,7922,40721,3055,3,3845,'App\\Models\\Receipt',3845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',9099.90,NULL,NULL,1,'2023-05-23 12:30:30','2023-05-23 12:30:30',NULL),(5144,7922,40721,3055,3,3846,'App\\Models\\Receipt',3846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',8112.40,NULL,NULL,1,'2023-05-23 12:32:06','2023-05-23 12:32:06',NULL),(5145,7922,40721,3055,3,3847,'App\\Models\\Receipt',3847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',9999.99,NULL,NULL,1,'2023-05-23 12:33:15','2023-05-23 12:33:15',NULL),(5146,7922,40721,3055,3,3848,'App\\Models\\Receipt',3848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',1257.00,NULL,NULL,1,'2023-05-23 12:35:14','2023-05-23 12:35:14',NULL),(5147,7922,40721,3055,3,3849,'App\\Models\\Receipt',3849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',794.99,NULL,NULL,1,'2023-05-23 12:35:50','2023-05-23 12:35:50',NULL),(5148,7922,40721,3055,3,3850,'App\\Models\\Receipt',3850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',11000.09,NULL,NULL,1,'2023-05-23 12:38:27','2023-05-23 12:38:27',NULL),(5149,7922,40723,6064,2,3765,'App\\Models\\Receipt',3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',2272828477273.20,NULL,NULL,1,'2023-05-23 17:05:24','2023-05-23 17:07:08','2023-05-23 17:07:08');
INSERT INTO `balance_libro` VALUES (5150,7922,40723,6064,2,3765,'App\\Models\\Receipt',3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',324249.65,NULL,NULL,1,'2023-05-23 17:07:08','2023-05-23 17:07:08',NULL),(5151,7922,40723,6064,2,3768,'App\\Models\\Receipt',3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',236570.00,NULL,NULL,1,'2023-05-23 17:25:21','2023-05-23 17:25:21',NULL),(5152,7922,40723,6064,2,3769,'App\\Models\\Receipt',3769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',611862.63,NULL,NULL,1,'2023-05-23 17:28:44','2023-05-23 17:28:44',NULL),(5153,7922,40723,6064,2,3770,'App\\Models\\Receipt',3770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',881595.85,NULL,NULL,1,'2023-05-23 17:29:21','2023-05-23 17:29:21',NULL),(5154,7922,40723,6064,2,3771,'App\\Models\\Receipt',3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',774811.15,NULL,NULL,1,'2023-05-23 17:30:04','2023-05-23 17:30:04',NULL),(5155,7922,40723,6064,2,3773,'App\\Models\\Receipt',3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',580442.43,NULL,NULL,1,'2023-05-23 17:31:37','2023-05-23 17:31:37',NULL),(5156,7922,40723,6064,2,3774,'App\\Models\\Receipt',3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',1180435.00,NULL,NULL,1,'2023-05-23 17:39:44','2023-05-23 17:39:44',NULL),(5157,7922,40723,6064,2,3775,'App\\Models\\Receipt',3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',1106942.00,NULL,NULL,1,'2023-05-23 17:41:08','2023-05-23 17:41:08',NULL),(5158,7922,40723,6064,2,3777,'App\\Models\\Receipt',3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',534543.00,NULL,NULL,1,'2023-05-23 17:41:50','2023-05-23 17:41:50',NULL),(5159,7922,40723,6064,2,3780,'App\\Models\\Receipt',3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',627693.75,NULL,NULL,1,'2023-05-23 17:43:33','2023-05-23 17:43:33',NULL),(5160,7922,40723,6064,2,3795,'App\\Models\\Receipt',3795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',363363.00,NULL,NULL,1,'2023-05-23 17:53:25','2023-05-23 17:53:25',NULL),(5161,7922,40723,6064,2,3800,'App\\Models\\Receipt',3800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',139401.00,NULL,NULL,1,'2023-05-23 17:54:12','2023-05-23 17:54:12',NULL),(5162,7922,40723,6064,2,3801,'App\\Models\\Receipt',3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',172197.00,NULL,NULL,1,'2023-05-23 17:55:57','2023-05-23 17:55:57',NULL),(5163,7922,40723,6064,2,3802,'App\\Models\\Receipt',3802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',232438.00,NULL,NULL,1,'2023-05-23 17:56:32','2023-05-23 17:56:32',NULL),(5164,7922,40723,6064,2,3803,'App\\Models\\Receipt',3803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',244615.00,NULL,NULL,1,'2023-05-23 17:56:56','2023-05-23 17:56:56',NULL),(5165,7922,40723,6064,2,3804,'App\\Models\\Receipt',3804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',249282.00,NULL,NULL,1,'2023-05-23 17:57:41','2023-05-23 17:57:41',NULL),(5166,7922,40723,6064,2,3805,'App\\Models\\Receipt',3805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',349109.00,NULL,NULL,1,'2023-05-23 17:58:03','2023-05-23 17:58:03',NULL),(5167,7922,40723,6064,2,3810,'App\\Models\\Receipt',3810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',414572.00,NULL,NULL,1,'2023-05-23 17:59:41','2023-05-23 17:59:41',NULL),(5168,7922,40723,6064,2,3812,'App\\Models\\Receipt',3812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',566986.00,NULL,NULL,1,'2023-05-23 18:00:13','2023-05-23 18:00:13',NULL),(5169,7922,40723,6064,2,3813,'App\\Models\\Receipt',3813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',674789.00,NULL,NULL,1,'2023-05-23 18:00:56','2023-05-23 18:00:56',NULL),(5170,7922,40723,6064,2,3816,'App\\Models\\Receipt',3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',431457.00,NULL,NULL,1,'2023-05-23 18:01:36','2023-05-23 18:01:36',NULL);
INSERT INTO `balance_libro` VALUES (5171,7922,40723,6064,2,3817,'App\\Models\\Receipt',3817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',612632.00,NULL,NULL,1,'2023-05-23 18:02:06','2023-05-23 18:02:06',NULL),(5172,7922,40723,6064,2,3823,'App\\Models\\Receipt',3823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',708499.00,NULL,NULL,1,'2023-05-23 18:04:38','2023-05-23 18:04:38',NULL),(5173,7922,40723,6064,3,3851,'App\\Models\\Receipt',3851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',737496.09,NULL,NULL,1,'2023-05-23 18:24:42','2023-05-23 18:24:42',NULL),(5174,7922,40723,6064,3,3852,'App\\Models\\Receipt',3852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',809958.15,NULL,NULL,1,'2023-05-23 18:24:42','2023-05-23 18:24:42',NULL),(5175,7922,40723,6064,3,3853,'App\\Models\\Receipt',3853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',669115.15,NULL,NULL,1,'2023-05-23 18:24:42','2023-05-23 18:24:42',NULL),(5176,7922,40723,6064,3,3854,'App\\Models\\Receipt',3854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',622514.97,NULL,NULL,1,'2023-05-23 18:24:42','2023-05-23 18:24:42',NULL),(5177,7922,40723,6064,3,3855,'App\\Models\\Receipt',3855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',85131.24,NULL,NULL,1,'2023-05-23 18:24:42','2023-05-23 18:24:42',NULL),(5178,7922,40723,6064,3,3856,'App\\Models\\Receipt',3856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',85131.24,NULL,NULL,1,'2023-05-23 18:24:42','2023-05-23 18:24:42',NULL),(5179,7922,40723,6064,3,3857,'App\\Models\\Receipt',3857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',175114.39,NULL,NULL,1,'2023-05-23 18:24:42','2023-05-23 18:24:42',NULL),(5180,7922,40723,6064,3,3858,'App\\Models\\Receipt',3858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',175114.39,NULL,NULL,1,'2023-05-23 18:24:42','2023-05-23 18:24:42',NULL),(5181,7922,40723,6064,3,3859,'App\\Models\\Receipt',3859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',554721.80,NULL,NULL,1,'2023-05-23 18:24:42','2023-05-23 18:24:42',NULL),(5182,7922,40723,6064,3,3860,'App\\Models\\Receipt',3860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',501068.38,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5183,7922,40723,6064,3,3861,'App\\Models\\Receipt',3861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',672941.20,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5184,7922,40723,6064,3,3862,'App\\Models\\Receipt',3862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',652025.46,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5185,7922,40723,6064,3,3863,'App\\Models\\Receipt',3863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',173927.67,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5186,7922,40723,6064,3,3864,'App\\Models\\Receipt',3864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',173927.67,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5187,7922,40723,6064,3,3865,'App\\Models\\Receipt',3865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',145949.02,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5188,7922,40723,6064,3,3866,'App\\Models\\Receipt',3866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',145949.02,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5189,7922,40723,6064,3,3867,'App\\Models\\Receipt',3867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-07','2023-04-07',31500.00,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5190,7922,40723,6064,3,3868,'App\\Models\\Receipt',3868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',881189.22,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5191,7922,40723,6064,3,3869,'App\\Models\\Receipt',3869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',1013958.70,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL);
INSERT INTO `balance_libro` VALUES (5192,7922,40723,6064,3,3870,'App\\Models\\Receipt',3870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',949392.72,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5193,7922,40723,6064,3,3871,'App\\Models\\Receipt',3871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',898467.44,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5194,7922,40723,6064,3,3872,'App\\Models\\Receipt',3872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',4947.65,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5195,7922,40723,6064,3,3873,'App\\Models\\Receipt',3873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',4947.65,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5196,7922,40723,6064,3,3874,'App\\Models\\Receipt',3874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',99373.97,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5197,7922,40723,6064,3,3875,'App\\Models\\Receipt',3875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',124282.50,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5198,7922,40723,6064,3,3876,'App\\Models\\Receipt',3876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',124282.50,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5199,7922,40723,6064,3,3877,'App\\Models\\Receipt',3877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',74910.00,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5200,7922,40723,6064,3,3878,'App\\Models\\Receipt',3878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',124282.50,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5201,7922,40723,6064,3,3879,'App\\Models\\Receipt',3879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',149820.00,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5202,7922,40723,6064,3,3880,'App\\Models\\Receipt',3880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',21367.07,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5203,7922,40723,6064,3,3881,'App\\Models\\Receipt',3881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',248565.00,NULL,NULL,1,'2023-05-23 18:24:43','2023-05-23 18:24:43',NULL),(5204,7922,40723,6064,3,3882,'App\\Models\\Receipt',3882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',240466.87,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5205,7922,40723,6064,3,3883,'App\\Models\\Receipt',3883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',126019.23,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5206,7922,40723,6064,3,3884,'App\\Models\\Receipt',3884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',240466.87,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5207,7922,40723,6064,3,3885,'App\\Models\\Receipt',3885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',126019.23,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5208,7922,40723,6064,3,3886,'App\\Models\\Receipt',3886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',199154.22,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5209,7922,40723,6064,3,3887,'App\\Models\\Receipt',3887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',212107.34,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5210,7922,40723,6064,3,3888,'App\\Models\\Receipt',3888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',400000.00,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5211,7922,40723,6064,3,3889,'App\\Models\\Receipt',3889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',565107.60,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5212,7922,40723,6064,3,3890,'App\\Models\\Receipt',3890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',538325.24,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL);
INSERT INTO `balance_libro` VALUES (5213,7922,40723,6064,3,3891,'App\\Models\\Receipt',3891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',551716.42,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5214,7922,40723,6064,3,3892,'App\\Models\\Receipt',3892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',537432.50,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5215,7922,40723,6064,3,3893,'App\\Models\\Receipt',3893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',118830.45,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5216,7922,40723,6064,3,3894,'App\\Models\\Receipt',3894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',131780.45,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5217,7922,40723,6064,3,3895,'App\\Models\\Receipt',3895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',131780.45,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5218,7922,40723,6064,3,3896,'App\\Models\\Receipt',3896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',118830.45,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5219,7922,40723,6064,3,3897,'App\\Models\\Receipt',3897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',1122174.92,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5220,7922,40723,6064,3,3898,'App\\Models\\Receipt',3898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',1184012.76,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5221,7922,40723,6064,3,3899,'App\\Models\\Receipt',3899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',1163097.02,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5222,7922,40723,6064,3,3900,'App\\Models\\Receipt',3900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',1171281.44,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5223,7922,40723,6064,3,3901,'App\\Models\\Receipt',3901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',191532.86,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5224,7922,40723,6064,3,3902,'App\\Models\\Receipt',3902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',191532.86,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5225,7922,40723,6064,3,3903,'App\\Models\\Receipt',3903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',121958.89,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5226,7922,40723,6064,3,3904,'App\\Models\\Receipt',3904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',121958.89,NULL,NULL,1,'2023-05-23 18:24:44','2023-05-23 18:24:44',NULL),(5227,7922,40723,6064,3,3905,'App\\Models\\Receipt',3905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',5432.89,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5228,7922,40723,6064,3,3906,'App\\Models\\Receipt',3906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',544718.62,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5229,7922,40723,6064,3,3907,'App\\Models\\Receipt',3907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',554721.80,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5230,7922,40723,6064,3,3908,'App\\Models\\Receipt',3908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',157106.77,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5231,7922,40723,6064,3,3909,'App\\Models\\Receipt',3909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',157106.77,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5232,7922,40723,6064,3,3910,'App\\Models\\Receipt',3910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',117495.37,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5233,7922,40723,6064,3,3911,'App\\Models\\Receipt',3911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',117495.37,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL);
INSERT INTO `balance_libro` VALUES (5234,7922,40723,6064,3,3912,'App\\Models\\Receipt',3912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',550551.96,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5235,7922,40723,6064,3,3913,'App\\Models\\Receipt',3913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',460190.64,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5236,7922,40723,6064,3,3914,'App\\Models\\Receipt',3914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',461122.20,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5237,7922,40723,6064,3,3915,'App\\Models\\Receipt',3915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',546825.72,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5238,7922,40723,6064,3,3916,'App\\Models\\Receipt',3916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',74910.00,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5239,7922,40723,6064,3,3917,'App\\Models\\Receipt',3917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',68951.25,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5240,7922,40723,6064,3,3918,'App\\Models\\Receipt',3918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',114918.75,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5241,7922,40723,6064,3,3919,'App\\Models\\Receipt',3919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',37455.00,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5242,7922,40723,6064,3,3920,'App\\Models\\Receipt',3920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',170590.36,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5243,7922,40723,6064,3,3921,'App\\Models\\Receipt',3921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',93037.09,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5244,7922,40723,6064,3,3922,'App\\Models\\Receipt',3922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',170590.36,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5245,7922,40723,6064,3,3923,'App\\Models\\Receipt',3923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',93037.09,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5246,7922,40723,6064,3,3924,'App\\Models\\Receipt',3924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',521673.60,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5247,7922,40723,6064,3,3925,'App\\Models\\Receipt',3925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',589677.48,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5248,7922,40723,6064,3,3926,'App\\Models\\Receipt',3926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',698670.00,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5249,7922,40723,6064,3,3927,'App\\Models\\Receipt',3927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',465780.00,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5250,7922,40723,6064,3,3928,'App\\Models\\Receipt',3928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',577567.20,NULL,NULL,1,'2023-05-23 18:24:45','2023-05-23 18:24:45',NULL),(5251,7922,40723,6064,3,3929,'App\\Models\\Receipt',3929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',695875.32,NULL,NULL,1,'2023-05-23 18:24:46','2023-05-23 18:24:46',NULL),(5252,7922,40723,6064,3,3930,'App\\Models\\Receipt',3930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',664202.28,NULL,NULL,1,'2023-05-23 18:24:46','2023-05-23 18:24:46',NULL),(5253,7922,40723,6064,3,3931,'App\\Models\\Receipt',3931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',549620.40,NULL,NULL,1,'2023-05-23 18:24:46','2023-05-23 18:24:46',NULL),(5254,7922,40723,6064,3,3932,'App\\Models\\Receipt',3932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',252978.63,NULL,NULL,1,'2023-05-23 18:24:46','2023-05-23 18:24:46',NULL);
INSERT INTO `balance_libro` VALUES (5255,7922,40723,6064,3,3933,'App\\Models\\Receipt',3933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',252978.63,NULL,NULL,1,'2023-05-23 18:24:46','2023-05-23 18:24:46',NULL),(5256,7922,40723,6064,3,3934,'App\\Models\\Receipt',3934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',186358.31,NULL,NULL,1,'2023-05-23 18:24:46','2023-05-23 18:24:46',NULL),(5257,7922,40723,6064,3,3935,'App\\Models\\Receipt',3935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',186358.31,NULL,NULL,1,'2023-05-23 18:24:46','2023-05-23 18:24:46',NULL),(5258,7922,40723,6064,3,3936,'App\\Models\\Receipt',3936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',709848.72,NULL,NULL,1,'2023-05-23 18:24:46','2023-05-23 18:24:46',NULL),(5259,7922,40723,6064,3,3937,'App\\Models\\Receipt',3937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',694943.76,NULL,NULL,1,'2023-05-23 18:24:46','2023-05-23 18:24:46',NULL),(5260,7922,40723,6064,3,3938,'App\\Models\\Receipt',3938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',687491.28,NULL,NULL,1,'2023-05-23 18:24:46','2023-05-23 18:24:46',NULL),(5261,7922,40723,6064,3,3939,'App\\Models\\Receipt',3939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',653023.56,NULL,NULL,1,'2023-05-23 18:24:46','2023-05-23 18:24:46',NULL),(5262,7922,40723,6064,3,3940,'App\\Models\\Receipt',3940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',0.00,NULL,NULL,1,'2023-05-23 18:24:46','2023-05-23 18:24:46',NULL),(5263,7922,40723,6064,3,3941,'App\\Models\\Receipt',3941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',0.00,NULL,NULL,1,'2023-05-23 18:24:46','2023-05-23 18:24:46',NULL),(5264,7922,40723,6064,3,3942,'App\\Models\\Receipt',3942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',57000.00,NULL,NULL,1,'2023-05-23 18:24:46','2023-05-23 18:24:46',NULL),(5265,7922,40720,1528,1,5265,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-04-30',NULL,832866.40,NULL,NULL,1,'2023-05-29 15:39:20','2023-05-29 15:39:20',NULL),(5266,7922,40722,4551,2,3943,'App\\Models\\Receipt',3943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1500.00,NULL,NULL,1,'2023-06-01 10:32:33','2023-06-01 10:32:33',NULL),(5267,7922,40722,4551,2,3944,'App\\Models\\Receipt',3944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1800.00,NULL,NULL,1,'2023-06-01 10:32:33','2023-06-01 10:32:33',NULL),(5268,7922,40722,4551,2,3945,'App\\Models\\Receipt',3945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',4600.00,NULL,NULL,1,'2023-06-01 10:32:33','2023-06-01 10:32:33',NULL),(5269,7922,40722,4551,2,3946,'App\\Models\\Receipt',3946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',13500.00,NULL,NULL,1,'2023-06-01 10:32:33','2023-06-01 10:32:33',NULL),(5270,7922,40722,4551,2,3947,'App\\Models\\Receipt',3947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',15300.00,NULL,NULL,1,'2023-06-01 10:32:33','2023-06-01 10:32:33',NULL),(5271,7922,40722,4551,2,3948,'App\\Models\\Receipt',3948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',1400.00,NULL,NULL,1,'2023-06-01 10:32:33','2023-06-01 10:32:33',NULL),(5272,7922,40722,4551,2,3949,'App\\Models\\Receipt',3949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',5400.00,NULL,NULL,1,'2023-06-01 10:32:34','2023-06-01 10:32:34',NULL),(5273,7922,40722,4551,2,3950,'App\\Models\\Receipt',3950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',4000.00,NULL,NULL,1,'2023-06-01 10:32:34','2023-06-01 10:32:34',NULL),(5274,7922,40722,4551,2,3951,'App\\Models\\Receipt',3951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',500.00,NULL,NULL,1,'2023-06-01 10:32:34','2023-06-01 10:32:34',NULL),(5275,7922,40722,4551,2,3952,'App\\Models\\Receipt',3952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',10200.00,NULL,NULL,1,'2023-06-01 10:32:34','2023-06-01 10:32:34',NULL);
INSERT INTO `balance_libro` VALUES (5276,7922,40722,4551,2,3953,'App\\Models\\Receipt',3953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',1400.00,NULL,NULL,1,'2023-06-01 10:32:34','2023-06-01 10:32:34',NULL),(5277,7922,40722,4551,2,3954,'App\\Models\\Receipt',3954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',7700.00,NULL,NULL,1,'2023-06-01 10:32:34','2023-06-01 10:32:34',NULL),(5278,7922,40722,4551,2,3955,'App\\Models\\Receipt',3955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',4800.00,NULL,NULL,1,'2023-06-01 10:32:34','2023-06-01 10:32:34',NULL),(5279,7922,40722,4551,2,3956,'App\\Models\\Receipt',3956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',1500.00,NULL,NULL,1,'2023-06-01 10:32:34','2023-06-01 10:32:34',NULL),(5280,7922,40722,4551,2,3957,'App\\Models\\Receipt',3957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',1300.00,NULL,NULL,1,'2023-06-01 10:32:34','2023-06-01 10:32:34',NULL),(5281,7922,40722,4551,2,3958,'App\\Models\\Receipt',3958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',9600.00,NULL,NULL,1,'2023-06-01 10:32:34','2023-06-01 10:32:34',NULL),(5282,7922,40722,4551,2,3959,'App\\Models\\Receipt',3959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',7200.00,NULL,NULL,1,'2023-06-01 10:32:34','2023-06-01 10:32:34',NULL),(5283,7922,40722,4551,2,3960,'App\\Models\\Receipt',3960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1800.00,NULL,NULL,1,'2023-06-01 10:32:35','2023-06-01 10:32:35',NULL),(5284,7922,40722,4551,2,3961,'App\\Models\\Receipt',3961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',2000.00,NULL,NULL,1,'2023-06-01 10:32:35','2023-06-01 10:32:35',NULL),(5285,7922,40722,4551,2,3962,'App\\Models\\Receipt',3962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',13500.00,NULL,NULL,1,'2023-06-01 10:32:35','2023-06-01 10:32:35',NULL),(5286,7922,40722,4551,2,3963,'App\\Models\\Receipt',3963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',8000.00,NULL,NULL,1,'2023-06-01 10:32:35','2023-06-01 10:32:35',NULL),(5287,7922,40722,4552,2,3964,'App\\Models\\Receipt',3964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',4500.00,NULL,NULL,1,'2023-06-01 10:32:58','2023-06-01 10:32:58',NULL),(5288,7922,40722,4552,2,3965,'App\\Models\\Receipt',3965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',1400.00,NULL,NULL,1,'2023-06-01 10:32:58','2023-06-01 10:32:58',NULL),(5289,7922,40722,4552,2,3966,'App\\Models\\Receipt',3966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',1400.00,NULL,NULL,1,'2023-06-01 10:32:58','2023-06-01 10:32:58',NULL),(5290,7922,40722,4552,2,3967,'App\\Models\\Receipt',3967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',26300.00,NULL,NULL,1,'2023-06-01 10:32:58','2023-06-01 10:32:58',NULL),(5291,7922,40722,4552,2,3968,'App\\Models\\Receipt',3968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',30000.00,NULL,NULL,1,'2023-06-01 10:32:58','2023-06-01 10:32:58',NULL),(5292,7922,40722,4552,2,3969,'App\\Models\\Receipt',3969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',25000.00,NULL,NULL,1,'2023-06-01 10:32:58','2023-06-01 10:32:58',NULL),(5293,7922,40722,4552,2,3970,'App\\Models\\Receipt',3970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',22500.00,NULL,NULL,1,'2023-06-01 10:32:59','2023-06-01 10:32:59',NULL),(5294,7922,40722,4552,2,3971,'App\\Models\\Receipt',3971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',18700.00,NULL,NULL,1,'2023-06-01 10:32:59','2023-06-01 10:32:59',NULL),(5295,7922,40722,4552,2,3972,'App\\Models\\Receipt',3972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',2000.00,NULL,NULL,1,'2023-06-01 10:32:59','2023-06-01 10:32:59',NULL),(5296,7922,40722,4552,2,3973,'App\\Models\\Receipt',3973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',2500.00,NULL,NULL,1,'2023-06-01 10:32:59','2023-06-01 10:32:59',NULL);
INSERT INTO `balance_libro` VALUES (5297,7922,40722,4552,2,3974,'App\\Models\\Receipt',3974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',25500.00,NULL,NULL,1,'2023-06-01 10:32:59','2023-06-01 10:32:59',NULL),(5298,7922,40722,4552,2,3975,'App\\Models\\Receipt',3975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',12500.00,NULL,NULL,1,'2023-06-01 10:32:59','2023-06-01 10:32:59',NULL),(5299,7922,40722,4552,2,3976,'App\\Models\\Receipt',3976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',13600.00,NULL,NULL,1,'2023-06-01 10:32:59','2023-06-01 10:32:59',NULL),(5300,7922,40722,4552,2,3977,'App\\Models\\Receipt',3977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',9850.00,NULL,NULL,1,'2023-06-01 10:32:59','2023-06-01 10:32:59',NULL),(5301,7922,40722,4552,2,3978,'App\\Models\\Receipt',3978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',12500.00,NULL,NULL,1,'2023-06-01 10:32:59','2023-06-01 10:32:59',NULL),(5302,7922,40722,4552,2,3979,'App\\Models\\Receipt',3979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',18500.00,NULL,NULL,1,'2023-06-01 10:32:59','2023-06-01 10:32:59',NULL),(5303,7922,40722,4552,2,3980,'App\\Models\\Receipt',3980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',1500.00,NULL,NULL,1,'2023-06-01 10:33:00','2023-06-01 10:33:00',NULL),(5304,7922,40722,4552,2,3981,'App\\Models\\Receipt',3981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',3600.00,NULL,NULL,1,'2023-06-01 10:33:00','2023-06-01 10:33:00',NULL),(5305,7922,40722,4552,2,3982,'App\\Models\\Receipt',3982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',1400.00,NULL,NULL,1,'2023-06-01 10:33:00','2023-06-01 10:33:00',NULL),(5306,7922,40722,4552,2,3983,'App\\Models\\Receipt',3983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',2800.00,NULL,NULL,1,'2023-06-01 10:33:00','2023-06-01 10:33:00',NULL),(5307,7922,40722,4552,2,3984,'App\\Models\\Receipt',3984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',2800.00,NULL,NULL,1,'2023-06-01 10:33:00','2023-06-01 10:33:00',NULL),(5308,7922,40722,4552,2,3985,'App\\Models\\Receipt',3985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',3800.00,NULL,NULL,1,'2023-06-01 10:33:00','2023-06-01 10:33:00',NULL),(5309,7922,40722,4552,2,3986,'App\\Models\\Receipt',3986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',1800.00,NULL,NULL,1,'2023-06-01 10:33:00','2023-06-01 10:33:00',NULL),(5310,7922,40722,4552,2,3987,'App\\Models\\Receipt',3987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',28200.00,NULL,NULL,1,'2023-06-01 10:33:00','2023-06-01 10:33:00',NULL),(5311,7922,40722,4552,2,3988,'App\\Models\\Receipt',3988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',6000.00,NULL,NULL,1,'2023-06-01 10:33:00','2023-06-01 10:33:00',NULL),(5312,7922,40722,4552,2,3989,'App\\Models\\Receipt',3989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',2800.00,NULL,NULL,1,'2023-06-01 10:33:00','2023-06-01 10:33:00',NULL),(5313,7922,40722,4552,2,3990,'App\\Models\\Receipt',3990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',7200.00,NULL,NULL,1,'2023-06-01 10:33:01','2023-06-01 10:33:01',NULL),(5314,7922,40722,4552,2,3991,'App\\Models\\Receipt',3991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',28800.00,NULL,NULL,1,'2023-06-01 10:33:01','2023-06-01 10:33:01',NULL),(5315,7922,40722,4552,2,3992,'App\\Models\\Receipt',3992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',4200.00,NULL,NULL,1,'2023-06-01 10:33:01','2023-06-01 10:33:01',NULL),(5316,7922,40722,4552,2,3993,'App\\Models\\Receipt',3993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',12000.00,NULL,NULL,1,'2023-06-01 10:33:01','2023-06-01 10:33:01',NULL),(5317,7922,40722,4552,2,3994,'App\\Models\\Receipt',3994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',1800.00,NULL,NULL,1,'2023-06-01 10:33:01','2023-06-01 10:33:01',NULL);
INSERT INTO `balance_libro` VALUES (5318,7922,40722,4552,2,3995,'App\\Models\\Receipt',3995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',7200.00,NULL,NULL,1,'2023-06-01 10:33:01','2023-06-01 10:33:01',NULL),(5319,7922,40722,4552,2,3996,'App\\Models\\Receipt',3996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',7200.00,NULL,NULL,1,'2023-06-01 10:33:01','2023-06-01 10:33:01',NULL),(5320,7922,40722,4552,2,3997,'App\\Models\\Receipt',3997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',2000.00,NULL,NULL,1,'2023-06-01 10:33:01','2023-06-01 10:33:01',NULL),(5321,7922,40722,4552,2,3998,'App\\Models\\Receipt',3998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',25000.00,NULL,NULL,1,'2023-06-01 10:33:01','2023-06-01 10:33:01',NULL),(5322,7922,40722,4552,2,3999,'App\\Models\\Receipt',3999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',14500.00,NULL,NULL,1,'2023-06-01 10:33:02','2023-06-01 10:33:02',NULL),(5323,7922,40722,4552,2,4000,'App\\Models\\Receipt',4000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',4200.00,NULL,NULL,1,'2023-06-01 10:33:02','2023-06-01 10:33:02',NULL),(5324,7922,40722,4552,2,4001,'App\\Models\\Receipt',4001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',12600.00,NULL,NULL,1,'2023-06-01 10:33:02','2023-06-01 10:33:02',NULL),(5325,7922,40722,4552,2,4002,'App\\Models\\Receipt',4002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1800.00,NULL,NULL,1,'2023-06-01 10:33:02','2023-06-01 10:33:02',NULL),(5326,7922,40722,4551,1,5326,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-04-30',NULL,167728.75,NULL,NULL,1,'2023-06-01 11:23:43','2023-06-01 11:23:43',NULL),(5327,7922,40962,16914,2,4003,'App\\Models\\Receipt',4003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',70280.00,NULL,NULL,1,'2023-06-01 18:28:59','2023-06-01 18:28:59',NULL),(5328,7922,40962,16914,2,4004,'App\\Models\\Receipt',4004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',60500.00,NULL,NULL,1,'2023-06-01 18:28:59','2023-06-01 18:28:59',NULL),(5329,7922,40962,16914,2,4005,'App\\Models\\Receipt',4005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',22400.00,NULL,NULL,1,'2023-06-01 18:28:59','2023-06-01 18:28:59',NULL),(5330,7922,40962,16914,2,4006,'App\\Models\\Receipt',4006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',133024.00,NULL,NULL,1,'2023-06-01 18:28:59','2023-06-01 18:28:59',NULL),(5331,7922,40962,16914,2,4007,'App\\Models\\Receipt',4007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',15000.00,NULL,NULL,1,'2023-06-01 18:28:59','2023-06-01 18:28:59',NULL),(5332,7922,40962,16914,3,4008,'App\\Models\\Receipt',4008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',45300.00,NULL,NULL,1,'2023-06-01 18:29:12','2023-06-01 18:29:12',NULL),(5333,7922,40962,16914,3,4009,'App\\Models\\Receipt',4009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',1979.43,NULL,NULL,1,'2023-06-01 18:29:12','2023-06-01 18:29:12',NULL),(5334,7922,40962,16914,3,4010,'App\\Models\\Receipt',4010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',0.00,NULL,NULL,1,'2023-06-01 18:29:12','2023-06-01 18:29:12',NULL),(5335,7922,40962,16914,3,4011,'App\\Models\\Receipt',4011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',4395.00,NULL,NULL,1,'2023-06-01 18:29:12','2023-06-01 18:29:12',NULL),(5336,7922,40962,16914,3,4012,'App\\Models\\Receipt',4012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',1375.50,NULL,NULL,1,'2023-06-01 18:29:12','2023-06-01 18:29:12',NULL),(5337,7922,40962,16914,3,4013,'App\\Models\\Receipt',4013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',22153.99,NULL,NULL,1,'2023-06-01 18:29:12','2023-06-01 18:29:12',NULL),(5338,7922,40946,13854,2,4014,'App\\Models\\Receipt',4014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',70280.00,NULL,NULL,1,'2023-06-01 18:31:48','2023-06-01 18:31:48',NULL);
INSERT INTO `balance_libro` VALUES (5339,7922,40946,13854,2,4015,'App\\Models\\Receipt',4015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',44010.00,NULL,NULL,1,'2023-06-01 18:31:48','2023-06-01 18:31:48',NULL),(5340,7922,40946,13854,2,4016,'App\\Models\\Receipt',4016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',133024.00,NULL,NULL,1,'2023-06-01 18:31:48','2023-06-01 18:31:48',NULL),(5341,7922,40946,13854,3,4017,'App\\Models\\Receipt',4017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',47200.00,NULL,NULL,1,'2023-06-01 18:31:55','2023-06-01 18:31:55',NULL),(5342,7922,40946,13854,3,4018,'App\\Models\\Receipt',4018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',7912.00,NULL,NULL,1,'2023-06-01 18:31:55','2023-06-01 18:31:55',NULL),(5343,7922,40946,13854,3,4019,'App\\Models\\Receipt',4019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',3784.52,NULL,NULL,1,'2023-06-01 18:31:55','2023-06-01 18:31:55',NULL),(5344,7922,40946,13854,3,4020,'App\\Models\\Receipt',4020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',18747.08,NULL,NULL,1,'2023-06-01 18:31:55','2023-06-01 18:31:55',NULL),(5345,7922,40946,13854,3,4021,'App\\Models\\Receipt',4021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',1890.00,NULL,NULL,1,'2023-06-01 18:31:55','2023-06-01 18:31:55',NULL),(5346,7922,40956,15384,2,4022,'App\\Models\\Receipt',4022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',70280.00,NULL,NULL,1,'2023-06-01 18:34:32','2023-06-01 18:34:32',NULL),(5347,7922,40956,15384,2,4023,'App\\Models\\Receipt',4023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',133024.00,NULL,NULL,1,'2023-06-01 18:34:32','2023-06-01 18:34:32',NULL),(5348,7922,40956,15384,3,4024,'App\\Models\\Receipt',4024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',10840.00,NULL,NULL,1,'2023-06-01 18:34:38','2023-06-01 18:34:38',NULL),(5349,7922,40956,15384,3,4025,'App\\Models\\Receipt',4025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',47123.90,NULL,NULL,1,'2023-06-01 18:34:38','2023-06-01 18:34:38',NULL),(5350,7922,40956,15384,3,4026,'App\\Models\\Receipt',4026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',17799.00,NULL,NULL,1,'2023-06-01 18:34:38','2023-06-01 18:34:38',NULL),(5351,7922,40956,15384,3,4027,'App\\Models\\Receipt',4027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',2470.00,NULL,NULL,1,'2023-06-01 18:34:38','2023-06-01 18:34:38',NULL),(5352,7922,40725,9151,1,5352,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-04-30',NULL,232908.39,NULL,NULL,1,'2023-06-01 18:42:55','2023-06-01 18:42:55',NULL),(5353,7922,40723,6064,1,5353,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-04-30',NULL,601581.20,NULL,NULL,1,'2023-06-05 10:48:22','2023-06-05 10:48:22',NULL),(5354,7922,40723,6064,15,441,'App\\Models\\PeriodLiquidation',NULL,441,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',5642649.21,NULL,NULL,1,'2023-06-07 11:21:58','2023-06-07 11:21:58',NULL),(5355,7922,40723,6064,16,442,'App\\Models\\PeriodLiquidation',NULL,442,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1312869.61,NULL,NULL,1,'2023-06-07 11:24:16','2023-06-07 11:24:16',NULL),(5356,7922,40723,6065,2,4028,'App\\Models\\Receipt',4028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',3315.00,NULL,NULL,1,'2023-06-07 11:29:31','2023-06-14 15:30:35','2023-06-14 15:30:35'),(5357,7922,40723,6065,2,4029,'App\\Models\\Receipt',4029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',1074812.75,NULL,NULL,1,'2023-06-07 11:29:31','2023-06-07 11:29:31',NULL),(5358,7922,40723,6065,2,4030,'App\\Models\\Receipt',4030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',555064.76,NULL,NULL,1,'2023-06-07 11:29:31','2023-06-07 11:29:31',NULL);
INSERT INTO `balance_libro` VALUES (5359,7922,40723,6065,2,4031,'App\\Models\\Receipt',4031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',569760.42,NULL,NULL,1,'2023-06-07 11:29:31','2023-06-07 11:29:31',NULL),(5360,7922,40723,6065,2,4032,'App\\Models\\Receipt',4032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',4999.97,NULL,NULL,1,'2023-06-07 11:29:31','2023-06-14 15:32:42','2023-06-14 15:32:42'),(5361,7922,40723,6065,2,4033,'App\\Models\\Receipt',4033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',10904.98,NULL,NULL,1,'2023-06-07 11:29:31','2023-06-14 15:33:40','2023-06-14 15:33:40'),(5362,7922,40723,6065,2,4034,'App\\Models\\Receipt',4034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',712604.40,NULL,NULL,1,'2023-06-07 11:29:31','2023-06-07 11:29:31',NULL),(5363,7922,40723,6065,2,4035,'App\\Models\\Receipt',4035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',10460.04,NULL,NULL,1,'2023-06-07 11:29:31','2023-06-15 15:48:13','2023-06-15 15:48:13'),(5364,7922,40723,6065,2,4036,'App\\Models\\Receipt',4036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',3155.99,NULL,NULL,1,'2023-06-07 11:29:31','2023-06-15 15:48:48','2023-06-15 15:48:48'),(5365,7922,40723,6065,2,4037,'App\\Models\\Receipt',4037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',443678.97,NULL,NULL,1,'2023-06-07 11:29:31','2023-06-07 11:29:31',NULL),(5366,7922,40723,6065,2,4038,'App\\Models\\Receipt',4038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',8489.98,NULL,NULL,1,'2023-06-07 11:29:31','2023-06-15 15:49:35','2023-06-15 15:49:35'),(5367,7922,40723,6065,2,4039,'App\\Models\\Receipt',4039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',853839.08,NULL,NULL,1,'2023-06-07 11:29:31','2023-06-07 11:29:31',NULL),(5368,7922,40723,6065,2,4040,'App\\Models\\Receipt',4040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',628726.90,NULL,NULL,1,'2023-06-07 11:29:31','2023-06-07 11:29:31',NULL),(5369,7922,40723,6065,2,4041,'App\\Models\\Receipt',4041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',3559.99,NULL,NULL,1,'2023-06-07 11:29:31','2023-06-15 15:50:35','2023-06-15 15:50:35'),(5370,7922,40723,6065,2,4042,'App\\Models\\Receipt',4042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',273300.07,NULL,NULL,1,'2023-06-07 11:29:31','2023-06-07 11:29:31',NULL),(5371,7922,40723,6065,2,4043,'App\\Models\\Receipt',4043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',392190.81,NULL,NULL,1,'2023-06-07 11:29:31','2023-06-07 11:29:31',NULL),(5372,7922,40723,6065,2,4044,'App\\Models\\Receipt',4044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',449212.49,NULL,NULL,1,'2023-06-07 11:29:31','2023-06-07 11:29:31',NULL),(5373,7922,40723,6065,2,4045,'App\\Models\\Receipt',4045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',54429.98,NULL,NULL,1,'2023-06-07 11:29:32','2023-06-07 11:29:32',NULL),(5374,7922,40723,6065,2,4046,'App\\Models\\Receipt',4046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',496189.83,NULL,NULL,1,'2023-06-07 11:29:32','2023-06-07 11:29:32',NULL),(5375,7922,40723,6065,2,4047,'App\\Models\\Receipt',4047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',3189.98,NULL,NULL,1,'2023-06-07 11:29:32','2023-06-15 15:51:10','2023-06-15 15:51:10'),(5376,7922,40723,6065,2,4048,'App\\Models\\Receipt',4048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',44313.97,NULL,NULL,1,'2023-06-07 11:29:32','2023-06-07 11:29:32',NULL),(5377,7922,40723,6065,2,4049,'App\\Models\\Receipt',4049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-21','2023-05-21',13337.03,NULL,NULL,1,'2023-06-07 11:29:32','2023-06-15 15:57:12','2023-06-15 15:57:12'),(5378,7922,40723,6065,2,4050,'App\\Models\\Receipt',4050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',10410.05,NULL,NULL,1,'2023-06-07 11:29:32','2023-06-15 15:57:35','2023-06-15 15:57:35');
INSERT INTO `balance_libro` VALUES (5379,7922,40723,6065,2,4051,'App\\Models\\Receipt',4051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',362517.88,NULL,NULL,1,'2023-06-07 11:29:32','2023-06-07 11:29:32',NULL),(5380,7922,40723,6065,2,4052,'App\\Models\\Receipt',4052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',213669.96,NULL,NULL,1,'2023-06-07 11:29:32','2023-06-07 11:29:32',NULL),(5381,7922,40723,6065,2,4053,'App\\Models\\Receipt',4053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',7199.97,NULL,NULL,1,'2023-06-07 11:29:32','2023-06-15 15:58:43','2023-06-15 15:58:43'),(5382,7922,40723,6065,2,4054,'App\\Models\\Receipt',4054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',150413.02,NULL,NULL,1,'2023-06-07 11:29:32','2023-06-07 11:29:32',NULL),(5383,7922,40723,6065,2,4055,'App\\Models\\Receipt',4055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',410074.76,NULL,NULL,1,'2023-06-07 11:29:32','2023-06-07 11:29:32',NULL),(5384,7922,40723,6065,2,4056,'App\\Models\\Receipt',4056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',1611229.65,NULL,NULL,1,'2023-06-07 11:29:32','2023-06-07 11:29:32',NULL),(5385,7922,40723,6065,2,4057,'App\\Models\\Receipt',4057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-28','2023-05-28',622584.36,NULL,NULL,1,'2023-06-07 11:29:32','2023-06-07 11:29:32',NULL),(5386,7922,40723,6065,2,4058,'App\\Models\\Receipt',4058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',462199.93,NULL,NULL,1,'2023-06-07 11:29:32','2023-06-07 11:29:32',NULL),(5387,7922,40723,6065,2,4059,'App\\Models\\Receipt',4059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',356694.00,NULL,NULL,1,'2023-06-07 11:29:32','2023-06-07 11:29:32',NULL),(5388,7922,40723,6065,2,4060,'App\\Models\\Receipt',4060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',18669.97,NULL,NULL,1,'2023-06-07 11:29:32','2023-06-07 11:29:32',NULL),(5389,7922,40723,6065,2,4061,'App\\Models\\Receipt',4061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',5566.04,NULL,NULL,1,'2023-06-07 11:30:16','2023-06-07 11:30:16',NULL),(5390,7922,40723,6065,2,4062,'App\\Models\\Receipt',4062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',15250.05,NULL,NULL,1,'2023-06-07 11:30:16','2023-06-07 11:30:16',NULL),(5391,7922,40723,6065,2,4063,'App\\Models\\Receipt',4063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',75154.00,NULL,NULL,1,'2023-06-07 11:30:16','2023-06-07 11:30:16',NULL),(5392,7922,40723,6065,2,4064,'App\\Models\\Receipt',4064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',12509.02,NULL,NULL,1,'2023-06-07 11:30:16','2023-06-07 11:30:16',NULL),(5393,7922,40723,6065,2,4065,'App\\Models\\Receipt',4065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',13029.95,NULL,NULL,1,'2023-06-07 11:30:16','2023-06-07 11:30:16',NULL),(5394,7922,40723,6065,2,4066,'App\\Models\\Receipt',4066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',20839.98,NULL,NULL,1,'2023-06-07 11:30:16','2023-06-07 11:30:16',NULL),(5395,7922,40723,6065,2,4067,'App\\Models\\Receipt',4067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',71709.97,NULL,NULL,1,'2023-06-07 11:30:16','2023-06-07 11:30:16',NULL),(5396,7922,40723,6065,2,4068,'App\\Models\\Receipt',4068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',15069.04,NULL,NULL,1,'2023-06-07 11:30:16','2023-06-07 11:30:16',NULL),(5397,7922,40723,6065,2,4069,'App\\Models\\Receipt',4069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',52693.98,NULL,NULL,1,'2023-06-07 11:30:16','2023-06-07 11:30:16',NULL),(5398,7922,40723,6065,2,4070,'App\\Models\\Receipt',4070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',14450.03,NULL,NULL,1,'2023-06-07 11:30:16','2023-06-07 11:30:16',NULL),(5399,7922,40723,6065,2,4071,'App\\Models\\Receipt',4071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',17492.04,NULL,NULL,1,'2023-06-07 11:30:16','2023-06-07 11:30:16',NULL);
INSERT INTO `balance_libro` VALUES (5400,7922,40723,6065,2,4072,'App\\Models\\Receipt',4072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',21620.01,NULL,NULL,1,'2023-06-07 11:30:16','2023-06-07 11:30:16',NULL),(5401,7922,40723,6065,2,4073,'App\\Models\\Receipt',4073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',52982.96,NULL,NULL,1,'2023-06-07 11:30:16','2023-06-07 11:30:16',NULL),(5402,7922,40723,6065,2,4074,'App\\Models\\Receipt',4074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',8666.04,NULL,NULL,1,'2023-06-07 11:30:16','2023-06-07 11:30:16',NULL),(5403,7922,40723,6065,2,4075,'App\\Models\\Receipt',4075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',3999.99,NULL,NULL,1,'2023-06-07 11:30:16','2023-06-07 11:30:16',NULL),(5404,7922,40723,6065,2,4076,'App\\Models\\Receipt',4076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',19913.99,NULL,NULL,1,'2023-06-07 11:30:17','2023-06-07 11:30:17',NULL),(5405,7922,40723,6065,2,4077,'App\\Models\\Receipt',4077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',12780.01,NULL,NULL,1,'2023-06-07 11:30:17','2023-06-07 11:30:17',NULL),(5406,7922,40723,6065,2,4078,'App\\Models\\Receipt',4078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',11830.02,NULL,NULL,1,'2023-06-07 11:30:17','2023-06-07 11:30:17',NULL),(5407,7922,40723,6065,2,4079,'App\\Models\\Receipt',4079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',4740.03,NULL,NULL,1,'2023-06-07 11:30:17','2023-06-07 11:30:17',NULL),(5408,7922,40723,6065,2,4080,'App\\Models\\Receipt',4080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',3086.00,NULL,NULL,1,'2023-06-07 11:30:17','2023-06-07 11:30:17',NULL),(5409,7922,40723,6065,2,4081,'App\\Models\\Receipt',4081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',40634.95,NULL,NULL,1,'2023-06-07 11:30:17','2023-06-07 11:30:17',NULL),(5410,7922,40723,6065,2,4082,'App\\Models\\Receipt',4082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',105383.96,NULL,NULL,1,'2023-06-07 11:30:17','2023-06-07 11:30:17',NULL),(5411,7922,40723,6065,2,4083,'App\\Models\\Receipt',4083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',10319.96,NULL,NULL,1,'2023-06-07 11:30:17','2023-06-07 11:30:17',NULL),(5412,7922,40723,6065,2,4084,'App\\Models\\Receipt',4084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',30673.96,NULL,NULL,1,'2023-06-07 11:30:17','2023-06-07 11:30:17',NULL),(5413,7922,40723,6065,2,4085,'App\\Models\\Receipt',4085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',81481.02,NULL,NULL,1,'2023-06-07 11:30:17','2023-06-07 11:30:17',NULL),(5414,7922,40723,6065,2,4086,'App\\Models\\Receipt',4086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',13915.00,NULL,NULL,1,'2023-06-07 11:30:17','2023-06-07 11:30:17',NULL),(5415,7922,40723,6065,2,4087,'App\\Models\\Receipt',4087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',6265.98,NULL,NULL,1,'2023-06-07 11:30:17','2023-06-07 11:30:17',NULL),(5416,7922,40723,6065,2,4088,'App\\Models\\Receipt',4088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',3315.00,NULL,NULL,1,'2023-06-07 11:30:23','2023-06-07 11:30:23',NULL),(5417,7922,40723,6065,2,4089,'App\\Models\\Receipt',4089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',4999.97,NULL,NULL,1,'2023-06-07 11:30:23','2023-06-07 11:30:23',NULL),(5418,7922,40723,6065,2,4090,'App\\Models\\Receipt',4090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',10904.98,NULL,NULL,1,'2023-06-07 11:30:23','2023-06-07 11:30:23',NULL),(5419,7922,40723,6065,2,4091,'App\\Models\\Receipt',4091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',3159.98,NULL,NULL,1,'2023-06-07 11:30:23','2023-06-07 11:30:23',NULL),(5420,7922,40723,6065,2,4092,'App\\Models\\Receipt',4092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',7300.05,NULL,NULL,1,'2023-06-07 11:30:24','2023-06-07 11:30:24',NULL);
INSERT INTO `balance_libro` VALUES (5421,7922,40723,6065,2,4093,'App\\Models\\Receipt',4093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',3155.99,NULL,NULL,1,'2023-06-07 11:30:24','2023-06-07 11:30:24',NULL),(5422,7922,40723,6065,2,4094,'App\\Models\\Receipt',4094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',8489.98,NULL,NULL,1,'2023-06-07 11:30:24','2023-06-07 11:30:24',NULL),(5423,7922,40723,6065,2,4095,'App\\Models\\Receipt',4095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',3559.99,NULL,NULL,1,'2023-06-07 11:30:24','2023-06-07 11:30:24',NULL),(5424,7922,40723,6065,2,4096,'App\\Models\\Receipt',4096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',3189.98,NULL,NULL,1,'2023-06-07 11:30:24','2023-06-07 11:30:24',NULL),(5425,7922,40723,6065,2,4097,'App\\Models\\Receipt',4097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-21','2023-05-21',13337.03,NULL,NULL,1,'2023-06-07 11:30:24','2023-06-07 11:30:24',NULL),(5426,7922,40723,6065,2,4098,'App\\Models\\Receipt',4098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',10410.05,NULL,NULL,1,'2023-06-07 11:30:24','2023-06-07 11:30:24',NULL),(5427,7922,40723,6065,2,4099,'App\\Models\\Receipt',4099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',3299.95,NULL,NULL,1,'2023-06-07 11:30:24','2023-06-07 11:30:24',NULL),(5428,7922,40723,6065,2,4100,'App\\Models\\Receipt',4100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',3900.02,NULL,NULL,1,'2023-06-07 11:30:24','2023-06-07 11:30:24',NULL),(5429,7922,40723,6065,2,4101,'App\\Models\\Receipt',4101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',13570.03,NULL,NULL,1,'2023-06-07 11:30:25','2023-06-07 11:30:25',NULL),(5430,7922,40723,6065,2,4102,'App\\Models\\Receipt',4102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',3999.99,NULL,NULL,1,'2023-06-07 11:30:25','2023-06-07 11:30:25',NULL),(5431,7922,40723,6065,2,4103,'App\\Models\\Receipt',4103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1099.95,NULL,NULL,1,'2023-06-07 11:30:25','2023-06-07 11:30:25',NULL),(5432,7922,40723,6065,3,4104,'App\\Models\\Receipt',4104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',196530.29,NULL,NULL,1,'2023-06-07 11:40:35','2023-06-07 11:40:35',NULL),(5433,7922,40723,6065,3,4105,'App\\Models\\Receipt',4105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',196530.29,NULL,NULL,1,'2023-06-07 11:40:35','2023-06-07 11:40:35',NULL),(5434,7922,40723,6065,3,4106,'App\\Models\\Receipt',4106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',24287.70,NULL,NULL,1,'2023-06-07 11:40:35','2023-06-07 11:40:35',NULL),(5435,7922,40723,6065,3,4107,'App\\Models\\Receipt',4107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',0.00,NULL,NULL,1,'2023-06-07 11:40:35','2023-06-07 11:40:35',NULL),(5436,7922,40723,6065,3,4108,'App\\Models\\Receipt',4108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',93071.88,NULL,NULL,1,'2023-06-07 11:40:35','2023-06-07 11:40:35',NULL),(5437,7922,40723,6065,3,4109,'App\\Models\\Receipt',4109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',93071.88,NULL,NULL,1,'2023-06-07 11:40:35','2023-06-07 11:40:35',NULL),(5438,7922,40723,6065,3,4110,'App\\Models\\Receipt',4110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',68100.00,NULL,NULL,1,'2023-06-07 11:40:35','2023-06-07 11:40:35',NULL),(5439,7922,40723,6065,3,4111,'App\\Models\\Receipt',4111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',68100.00,NULL,NULL,1,'2023-06-07 11:40:35','2023-06-07 11:40:35',NULL),(5440,7922,40723,6065,3,4112,'App\\Models\\Receipt',4112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',519810.48,NULL,NULL,1,'2023-06-07 11:40:35','2023-06-07 11:40:35',NULL),(5441,7922,40723,6065,3,4113,'App\\Models\\Receipt',4113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',435038.52,NULL,NULL,1,'2023-06-07 11:40:35','2023-06-07 11:40:35',NULL);
INSERT INTO `balance_libro` VALUES (5442,7922,40723,6065,3,4114,'App\\Models\\Receipt',4114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',447148.80,NULL,NULL,1,'2023-06-07 11:40:35','2023-06-07 11:40:35',NULL),(5443,7922,40723,6065,3,4115,'App\\Models\\Receipt',4115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',510494.88,NULL,NULL,1,'2023-06-07 11:40:35','2023-06-07 11:40:35',NULL),(5444,7922,40723,6065,3,4116,'App\\Models\\Receipt',4116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',90398.61,NULL,NULL,1,'2023-06-07 11:40:35','2023-06-07 11:40:35',NULL),(5445,7922,40723,6065,3,4117,'App\\Models\\Receipt',4117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',80718.50,NULL,NULL,1,'2023-06-07 11:40:35','2023-06-07 11:40:35',NULL),(5446,7922,40723,6065,3,4118,'App\\Models\\Receipt',4118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',458327.52,NULL,NULL,1,'2023-06-07 11:40:35','2023-06-07 11:40:35',NULL),(5447,7922,40723,6065,3,4119,'App\\Models\\Receipt',4119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',558936.00,NULL,NULL,1,'2023-06-07 11:40:36','2023-06-07 11:40:36',NULL),(5448,7922,40723,6065,3,4120,'App\\Models\\Receipt',4120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',524468.28,NULL,NULL,1,'2023-06-07 11:40:36','2023-06-07 11:40:36',NULL),(5449,7922,40723,6065,3,4121,'App\\Models\\Receipt',4121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',409886.40,NULL,NULL,1,'2023-06-07 11:40:36','2023-06-07 11:40:36',NULL),(5450,7922,40723,6065,3,4122,'App\\Models\\Receipt',4122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',121600.16,NULL,NULL,1,'2023-06-07 11:40:36','2023-06-07 11:40:36',NULL),(5451,7922,40723,6065,3,4123,'App\\Models\\Receipt',4123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',38403.19,NULL,NULL,1,'2023-06-07 11:40:36','2023-06-07 11:40:36',NULL),(5452,7922,40723,6065,3,4124,'App\\Models\\Receipt',4124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',66493.87,NULL,NULL,1,'2023-06-07 11:40:36','2023-06-07 11:40:36',NULL),(5453,7922,40723,6065,3,4125,'App\\Models\\Receipt',4125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',694012.20,NULL,NULL,1,'2023-06-07 11:40:36','2023-06-07 11:40:36',NULL),(5454,7922,40723,6065,3,4126,'App\\Models\\Receipt',4126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',671654.76,NULL,NULL,1,'2023-06-07 11:40:36','2023-06-07 11:40:36',NULL),(5455,7922,40723,6065,3,4127,'App\\Models\\Receipt',4127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',668860.08,NULL,NULL,1,'2023-06-07 11:40:36','2023-06-07 11:40:36',NULL),(5456,7922,40723,6065,3,4128,'App\\Models\\Receipt',4128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',786236.64,NULL,NULL,1,'2023-06-07 11:40:36','2023-06-07 11:40:36',NULL),(5457,7922,40723,6065,3,4129,'App\\Models\\Receipt',4129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',5328.62,NULL,NULL,1,'2023-06-07 11:40:36','2023-06-07 11:40:36',NULL),(5458,7922,40723,6065,3,4130,'App\\Models\\Receipt',4130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',5328.62,NULL,NULL,1,'2023-06-07 11:40:36','2023-06-07 11:40:36',NULL),(5459,7922,40723,6065,3,4131,'App\\Models\\Receipt',4131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',102332.09,NULL,NULL,1,'2023-06-07 11:40:36','2023-06-07 11:40:36',NULL),(5460,7922,40723,6065,3,4132,'App\\Models\\Receipt',4132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',111029.45,NULL,NULL,1,'2023-06-07 11:40:36','2023-06-07 11:40:36',NULL),(5461,7922,40723,6065,3,4133,'App\\Models\\Receipt',4133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',1147681.92,NULL,NULL,1,'2023-06-07 11:40:37','2023-06-07 11:40:37',NULL),(5462,7922,40723,6065,3,4134,'App\\Models\\Receipt',4134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',1094583.00,NULL,NULL,1,'2023-06-07 11:40:37','2023-06-07 11:40:37',NULL);
INSERT INTO `balance_libro` VALUES (5463,7922,40723,6065,3,4135,'App\\Models\\Receipt',4135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',1155134.40,NULL,NULL,1,'2023-06-07 11:40:37','2023-06-07 11:40:37',NULL),(5464,7922,40723,6065,3,4136,'App\\Models\\Receipt',4136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',1102967.04,NULL,NULL,1,'2023-06-07 11:40:37','2023-06-07 11:40:37',NULL),(5465,7922,40723,6065,3,4137,'App\\Models\\Receipt',4137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',300000.06,NULL,NULL,1,'2023-06-07 11:40:37','2023-06-07 11:40:37',NULL),(5466,7922,40723,6065,3,4138,'App\\Models\\Receipt',4138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',94664.92,NULL,NULL,1,'2023-06-07 11:40:37','2023-06-07 11:40:37',NULL),(5467,7922,40723,6065,3,4139,'App\\Models\\Receipt',4139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',92249.31,NULL,NULL,1,'2023-06-07 11:40:37','2023-06-07 11:40:37',NULL),(5468,7922,40723,6065,3,4140,'App\\Models\\Receipt',4140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',543099.48,NULL,NULL,1,'2023-06-07 11:40:37','2023-06-07 11:40:37',NULL),(5469,7922,40723,6065,3,4141,'App\\Models\\Receipt',4141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',561730.68,NULL,NULL,1,'2023-06-07 11:40:37','2023-06-07 11:40:37',NULL),(5470,7922,40723,6065,3,4142,'App\\Models\\Receipt',4142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',548688.84,NULL,NULL,1,'2023-06-07 11:40:38','2023-06-07 11:40:38',NULL),(5471,7922,40723,6065,3,4143,'App\\Models\\Receipt',4143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',580361.88,NULL,NULL,1,'2023-06-07 11:40:38','2023-06-07 11:40:38',NULL),(5472,7922,40723,6065,3,4144,'App\\Models\\Receipt',4144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',93719.20,NULL,NULL,1,'2023-06-07 11:40:38','2023-06-07 11:40:38',NULL),(5473,7922,40723,6065,3,4145,'App\\Models\\Receipt',4145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',101916.43,NULL,NULL,1,'2023-06-07 11:40:38','2023-06-07 11:40:38',NULL),(5474,7922,40723,6065,3,4146,'App\\Models\\Receipt',4146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',804867.84,NULL,NULL,1,'2023-06-07 11:40:38','2023-06-07 11:40:38',NULL),(5475,7922,40723,6065,3,4147,'App\\Models\\Receipt',4147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',923175.96,NULL,NULL,1,'2023-06-07 11:40:38','2023-06-07 11:40:38',NULL),(5476,7922,40723,6065,3,4148,'App\\Models\\Receipt',4148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',923175.96,NULL,NULL,1,'2023-06-07 11:40:38','2023-06-07 11:40:38',NULL),(5477,7922,40723,6065,3,4149,'App\\Models\\Receipt',4149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',832814.64,NULL,NULL,1,'2023-06-07 11:40:38','2023-06-07 11:40:38',NULL),(5478,7922,40723,6065,3,4150,'App\\Models\\Receipt',4150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',115628.75,NULL,NULL,1,'2023-06-07 11:40:38','2023-06-07 11:40:38',NULL),(5479,7922,40723,6065,3,4151,'App\\Models\\Receipt',4151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',759221.40,NULL,NULL,1,'2023-06-07 11:40:39','2023-06-07 11:40:39',NULL),(5480,7922,40723,6065,3,4152,'App\\Models\\Receipt',4152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',753632.04,NULL,NULL,1,'2023-06-07 11:40:39','2023-06-07 11:40:39',NULL),(5481,7922,40723,6065,3,4153,'App\\Models\\Receipt',4153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',765742.32,NULL,NULL,1,'2023-06-07 11:40:39','2023-06-07 11:40:39',NULL),(5482,7922,40723,6065,3,4154,'App\\Models\\Receipt',4154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',768537.00,NULL,NULL,1,'2023-06-07 11:40:39','2023-06-07 11:40:39',NULL),(5483,7922,40723,6065,3,4155,'App\\Models\\Receipt',4155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',82287.75,NULL,NULL,1,'2023-06-07 11:40:39','2023-06-07 11:40:39',NULL);
INSERT INTO `balance_libro` VALUES (5484,7922,40723,6065,3,4156,'App\\Models\\Receipt',4156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',200000.09,NULL,NULL,1,'2023-06-07 11:40:39','2023-06-07 11:40:39',NULL),(5485,7922,40723,6065,3,4157,'App\\Models\\Receipt',4157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',81312.06,NULL,NULL,1,'2023-06-07 11:40:39','2023-06-07 11:40:39',NULL),(5486,7922,40723,6065,3,4158,'App\\Models\\Receipt',4158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',81532.76,NULL,NULL,1,'2023-06-07 11:40:39','2023-06-07 11:40:39',NULL),(5487,7922,40723,6065,3,4159,'App\\Models\\Receipt',4159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',18000.00,NULL,NULL,1,'2023-06-07 11:40:39','2023-06-07 11:40:39',NULL),(5488,7922,40723,6065,3,4160,'App\\Models\\Receipt',4160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',442491.00,NULL,NULL,1,'2023-06-07 11:40:39','2023-06-07 11:40:39',NULL),(5489,7922,40723,6065,3,4161,'App\\Models\\Receipt',4161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',459259.08,NULL,NULL,1,'2023-06-07 11:40:39','2023-06-07 11:40:39',NULL),(5490,7922,40723,6065,3,4162,'App\\Models\\Receipt',4162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',459259.08,NULL,NULL,1,'2023-06-07 11:40:39','2023-06-07 11:40:39',NULL),(5491,7922,40723,6065,3,4163,'App\\Models\\Receipt',4163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',571046.28,NULL,NULL,1,'2023-06-07 11:40:39','2023-06-07 11:40:39',NULL),(5492,7922,40723,6065,3,4164,'App\\Models\\Receipt',4164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',52905.45,NULL,NULL,1,'2023-06-07 11:40:39','2023-06-07 11:40:39',NULL),(5493,7922,40723,6065,3,4165,'App\\Models\\Receipt',4165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',57377.01,NULL,NULL,1,'2023-06-07 11:40:40','2023-06-07 11:40:40',NULL),(5494,7922,40723,6065,3,4166,'App\\Models\\Receipt',4166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',0.00,NULL,NULL,1,'2023-06-07 11:40:40','2023-06-07 11:40:40',NULL),(5495,7922,40723,6065,3,4167,'App\\Models\\Receipt',4167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',200000.09,NULL,NULL,1,'2023-06-07 11:40:40','2023-06-07 11:40:40',NULL),(5496,7922,41070,18433,2,4168,'App\\Models\\Receipt',4168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',122000.00,NULL,NULL,1,'2023-06-07 17:44:47','2023-06-07 17:44:47',NULL),(5497,7922,41070,18433,2,4169,'App\\Models\\Receipt',4169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',840000.00,NULL,NULL,1,'2023-06-07 17:44:47','2023-06-07 17:44:47',NULL),(5498,7922,41070,18433,2,4170,'App\\Models\\Receipt',4170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',840000.06,NULL,NULL,1,'2023-06-07 17:44:47','2023-06-07 17:44:47',NULL),(5499,7922,41070,18433,2,4171,'App\\Models\\Receipt',4171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',840000.00,NULL,NULL,1,'2023-06-07 17:44:47','2023-06-07 17:44:47',NULL),(5500,7922,41070,18433,2,4172,'App\\Models\\Receipt',4172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',453000.00,NULL,NULL,1,'2023-06-07 17:44:47','2023-06-07 17:44:47',NULL),(5501,7922,41070,18433,2,4173,'App\\Models\\Receipt',4173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',104000.00,NULL,NULL,1,'2023-06-07 17:44:47','2023-06-07 17:44:47',NULL),(5502,7922,41070,18433,2,4174,'App\\Models\\Receipt',4174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',350000.00,NULL,NULL,1,'2023-06-07 17:44:48','2023-06-07 17:44:48',NULL),(5503,7922,41070,18433,3,4175,'App\\Models\\Receipt',4175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',2924.63,NULL,NULL,1,'2023-06-07 17:45:18','2023-06-07 17:45:18',NULL),(5504,7922,41070,18433,3,4176,'App\\Models\\Receipt',4176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',443.89,NULL,NULL,1,'2023-06-07 17:45:18','2023-06-07 17:45:18',NULL);
INSERT INTO `balance_libro` VALUES (5505,7922,41070,18433,3,4177,'App\\Models\\Receipt',4177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',2415.67,NULL,NULL,1,'2023-06-07 17:45:18','2023-06-07 17:45:18',NULL),(5506,7922,41070,18433,3,4178,'App\\Models\\Receipt',4178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',5002.01,NULL,NULL,1,'2023-06-07 17:45:18','2023-06-07 17:45:18',NULL),(5507,7922,41070,18433,3,4179,'App\\Models\\Receipt',4179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',1180.00,NULL,NULL,1,'2023-06-07 17:45:18','2023-06-07 17:45:18',NULL),(5508,7922,41070,18433,3,4180,'App\\Models\\Receipt',4180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',1180.00,NULL,NULL,1,'2023-06-07 17:45:18','2023-06-07 17:45:18',NULL),(5509,7922,41070,18433,3,4181,'App\\Models\\Receipt',4181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',358.05,NULL,NULL,1,'2023-06-07 17:45:18','2023-06-07 17:45:18',NULL),(5510,7922,41070,18433,3,4182,'App\\Models\\Receipt',4182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',14537.27,NULL,NULL,1,'2023-06-07 17:45:19','2023-06-07 17:45:19',NULL),(5511,7922,41070,18433,3,4183,'App\\Models\\Receipt',4183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',14537.27,NULL,NULL,1,'2023-06-07 17:45:19','2023-06-07 17:45:19',NULL),(5512,7922,41070,18433,3,4184,'App\\Models\\Receipt',4184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',14537.27,NULL,NULL,1,'2023-06-07 17:45:19','2023-06-07 17:45:19',NULL),(5513,7922,41070,18433,3,4185,'App\\Models\\Receipt',4185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',6900.00,NULL,NULL,1,'2023-06-07 17:45:19','2023-06-07 17:45:19',NULL),(5514,7922,41070,18433,3,4186,'App\\Models\\Receipt',4186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',400.00,NULL,NULL,1,'2023-06-07 17:45:19','2023-06-07 17:45:19',NULL),(5515,7922,41070,18433,3,4187,'App\\Models\\Receipt',4187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',5500.00,NULL,NULL,1,'2023-06-07 17:45:19','2023-06-07 17:45:19',NULL),(5516,7922,41070,18433,3,4188,'App\\Models\\Receipt',4188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',651556.64,NULL,NULL,1,'2023-06-07 17:45:19','2023-06-07 17:45:19',NULL),(5517,7922,41070,18433,3,4189,'App\\Models\\Receipt',4189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',40.00,NULL,NULL,1,'2023-06-07 17:45:19','2023-06-07 17:45:19',NULL),(5518,7922,41070,18433,3,4190,'App\\Models\\Receipt',4190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',175991.71,NULL,NULL,1,'2023-06-07 17:45:19','2023-06-07 17:45:19',NULL),(5519,7922,41070,18433,3,4191,'App\\Models\\Receipt',4191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',27500.00,NULL,NULL,1,'2023-06-07 17:45:19','2023-06-07 17:45:19',NULL),(5520,7922,41070,18433,3,4192,'App\\Models\\Receipt',4192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',856.00,NULL,NULL,1,'2023-06-07 17:45:19','2023-06-07 17:45:19',NULL),(5521,7922,41070,18433,3,4193,'App\\Models\\Receipt',4193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',28524.63,NULL,NULL,1,'2023-06-07 17:45:19','2023-06-07 17:45:19',NULL),(5522,7922,41070,18433,3,4194,'App\\Models\\Receipt',4194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',5156.84,NULL,NULL,1,'2023-06-07 17:45:19','2023-06-07 17:45:19',NULL),(5523,7922,41070,18433,3,4195,'App\\Models\\Receipt',4195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',1468.87,NULL,NULL,1,'2023-06-07 17:45:19','2023-06-07 17:45:19',NULL),(5524,7922,41070,18433,3,4196,'App\\Models\\Receipt',4196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',8999.99,NULL,NULL,1,'2023-06-07 17:45:19','2023-06-07 17:45:19',NULL),(5525,7922,41070,18433,3,4197,'App\\Models\\Receipt',4197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',4993.76,NULL,NULL,1,'2023-06-07 17:45:19','2023-06-07 17:45:19',NULL);
INSERT INTO `balance_libro` VALUES (5526,7922,41070,18433,3,4198,'App\\Models\\Receipt',4198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',800.03,NULL,NULL,1,'2023-06-07 17:45:19','2023-06-07 17:45:19',NULL),(5527,7922,40721,3055,1,5527,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-04-30',NULL,284784.85,NULL,NULL,1,'2023-06-08 10:02:30','2023-06-08 10:02:30',NULL),(5528,7922,40721,3056,2,4199,'App\\Models\\Receipt',4199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',940.00,NULL,NULL,1,'2023-06-08 11:02:22','2023-06-08 11:02:22',NULL),(5529,7922,40721,3056,2,4200,'App\\Models\\Receipt',4200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',530.00,NULL,NULL,1,'2023-06-08 11:02:22','2023-06-08 11:02:22',NULL),(5530,7922,40721,3056,2,4201,'App\\Models\\Receipt',4201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',3200.00,NULL,NULL,1,'2023-06-08 11:02:22','2023-06-08 11:02:22',NULL),(5531,7922,40721,3056,2,4202,'App\\Models\\Receipt',4202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',3500.00,NULL,NULL,1,'2023-06-08 11:02:22','2023-06-08 11:02:22',NULL),(5532,7922,40721,3056,2,4203,'App\\Models\\Receipt',4203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',1500.00,NULL,NULL,1,'2023-06-08 11:02:22','2023-06-08 11:02:22',NULL),(5533,7922,40721,3056,2,4204,'App\\Models\\Receipt',4204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',20458.50,NULL,NULL,1,'2023-06-08 11:02:22','2023-06-08 11:02:22',NULL),(5534,7922,40721,3056,2,4205,'App\\Models\\Receipt',4205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',8000.00,NULL,NULL,1,'2023-06-08 11:02:22','2023-06-08 11:02:22',NULL),(5535,7922,40721,3056,2,4206,'App\\Models\\Receipt',4206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',900.00,NULL,NULL,1,'2023-06-08 11:02:22','2023-06-08 11:02:22',NULL),(5536,7922,40721,3056,2,4207,'App\\Models\\Receipt',4207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',900.00,NULL,NULL,1,'2023-06-08 11:02:22','2023-06-08 11:02:22',NULL),(5537,7922,40721,3056,2,4208,'App\\Models\\Receipt',4208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',1500.00,NULL,NULL,1,'2023-06-08 11:02:22','2023-06-08 11:02:22',NULL),(5538,7922,40721,3056,2,4209,'App\\Models\\Receipt',4209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',850.00,NULL,NULL,1,'2023-06-08 11:02:22','2023-06-08 11:02:22',NULL),(5539,7922,40721,3056,2,4210,'App\\Models\\Receipt',4210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',7000.00,NULL,NULL,1,'2023-06-08 11:02:22','2023-06-08 11:02:22',NULL),(5540,7922,40721,3056,2,4211,'App\\Models\\Receipt',4211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',3800.00,NULL,NULL,1,'2023-06-08 11:02:22','2023-06-08 11:02:22',NULL),(5541,7922,40721,3056,2,4212,'App\\Models\\Receipt',4212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',1100.00,NULL,NULL,1,'2023-06-08 11:02:22','2023-06-08 11:02:22',NULL),(5542,7922,40721,3056,2,4213,'App\\Models\\Receipt',4213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',1500.00,NULL,NULL,1,'2023-06-08 11:02:22','2023-06-08 11:02:22',NULL),(5543,7922,40721,3056,2,4214,'App\\Models\\Receipt',4214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',600.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5544,7922,40721,3056,2,4215,'App\\Models\\Receipt',4215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',2500.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5545,7922,40721,3056,2,4216,'App\\Models\\Receipt',4216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',1400.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5546,7922,40721,3056,2,4217,'App\\Models\\Receipt',4217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',3080.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL);
INSERT INTO `balance_libro` VALUES (5547,7922,40721,3056,2,4218,'App\\Models\\Receipt',4218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',550.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5548,7922,40721,3056,2,4219,'App\\Models\\Receipt',4219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',1900.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5549,7922,40721,3056,2,4220,'App\\Models\\Receipt',4220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',3000.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5550,7922,40721,3056,2,4221,'App\\Models\\Receipt',4221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',15000.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5551,7922,40721,3056,2,4222,'App\\Models\\Receipt',4222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',2000.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5552,7922,40721,3056,2,4223,'App\\Models\\Receipt',4223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',6100.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5553,7922,40721,3056,2,4224,'App\\Models\\Receipt',4224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',3800.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5554,7922,40721,3056,2,4225,'App\\Models\\Receipt',4225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',5500.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5555,7922,40721,3056,2,4226,'App\\Models\\Receipt',4226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',100.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5556,7922,40721,3056,2,4227,'App\\Models\\Receipt',4227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',3000.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5557,7922,40721,3056,2,4228,'App\\Models\\Receipt',4228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',4730.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5558,7922,40721,3056,2,4229,'App\\Models\\Receipt',4229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',7000.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5559,7922,40721,3056,2,4230,'App\\Models\\Receipt',4230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',1200.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5560,7922,40721,3056,2,4231,'App\\Models\\Receipt',4231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',4000.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5561,7922,40721,3056,2,4232,'App\\Models\\Receipt',4232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',3850.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5562,7922,40721,3056,2,4233,'App\\Models\\Receipt',4233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',1500.00,NULL,NULL,1,'2023-06-08 11:02:23','2023-06-08 11:02:23',NULL),(5563,7922,40721,3056,2,4234,'App\\Models\\Receipt',4234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',3500.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL),(5564,7922,40721,3056,2,4235,'App\\Models\\Receipt',4235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',19952.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL),(5565,7922,40721,3056,2,4236,'App\\Models\\Receipt',4236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',3000.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL),(5566,7922,40721,3056,2,4237,'App\\Models\\Receipt',4237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',1800.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL),(5567,7922,40721,3056,2,4238,'App\\Models\\Receipt',4238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',550.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL);
INSERT INTO `balance_libro` VALUES (5568,7922,40721,3056,2,4239,'App\\Models\\Receipt',4239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',1000.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL),(5569,7922,40721,3056,2,4240,'App\\Models\\Receipt',4240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',17900.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL),(5570,7922,40721,3056,2,4241,'App\\Models\\Receipt',4241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',6611.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL),(5571,7922,40721,3056,2,4242,'App\\Models\\Receipt',4242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',300.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL),(5572,7922,40721,3056,2,4243,'App\\Models\\Receipt',4243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',700.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL),(5573,7922,40721,3056,2,4244,'App\\Models\\Receipt',4244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',800.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL),(5574,7922,40721,3056,2,4245,'App\\Models\\Receipt',4245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',2750.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL),(5575,7922,40721,3056,2,4246,'App\\Models\\Receipt',4246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',3000.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL),(5576,7922,40721,3056,2,4247,'App\\Models\\Receipt',4247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',5115.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL),(5577,7922,40721,3056,2,4248,'App\\Models\\Receipt',4248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',6050.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL),(5578,7922,40721,3056,2,4249,'App\\Models\\Receipt',4249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',7000.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL),(5579,7922,40721,3056,2,4250,'App\\Models\\Receipt',4250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',2000.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL),(5580,7922,40721,3056,2,4251,'App\\Models\\Receipt',4251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',2000.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL),(5581,7922,40721,3056,2,4252,'App\\Models\\Receipt',4252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',1200.00,NULL,NULL,1,'2023-06-08 11:02:24','2023-06-08 11:02:24',NULL),(5582,7922,40721,3056,2,4253,'App\\Models\\Receipt',4253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',1870.00,NULL,NULL,1,'2023-06-08 11:02:25','2023-06-08 11:02:25',NULL),(5583,7922,40721,3056,2,4254,'App\\Models\\Receipt',4254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',13900.00,NULL,NULL,1,'2023-06-08 11:02:25','2023-06-08 11:02:25',NULL),(5584,7922,40721,3056,2,4255,'App\\Models\\Receipt',4255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',1700.00,NULL,NULL,1,'2023-06-08 11:02:25','2023-06-08 11:02:25',NULL),(5585,7922,40721,3056,2,4256,'App\\Models\\Receipt',4256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',5267.00,NULL,NULL,1,'2023-06-08 11:02:25','2023-06-08 11:02:25',NULL),(5586,7922,40721,3056,2,4257,'App\\Models\\Receipt',4257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',1800.00,NULL,NULL,1,'2023-06-08 11:02:25','2023-06-08 11:02:25',NULL),(5587,7922,40721,3056,2,4258,'App\\Models\\Receipt',4258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',600.00,NULL,NULL,1,'2023-06-08 11:02:25','2023-06-08 11:02:25',NULL),(5588,7922,40721,3056,2,4259,'App\\Models\\Receipt',4259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',500.00,NULL,NULL,1,'2023-06-08 11:02:25','2023-06-08 11:02:25',NULL);
INSERT INTO `balance_libro` VALUES (5589,7922,40721,3056,2,4260,'App\\Models\\Receipt',4260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',1700.00,NULL,NULL,1,'2023-06-08 11:02:25','2023-06-08 11:02:25',NULL),(5590,7922,40721,3056,2,4261,'App\\Models\\Receipt',4261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',1900.00,NULL,NULL,1,'2023-06-08 11:02:25','2023-06-08 11:02:25',NULL),(5591,7922,40721,3056,2,4262,'App\\Models\\Receipt',4262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',2260.00,NULL,NULL,1,'2023-06-08 11:02:25','2023-06-08 11:02:25',NULL),(5592,7922,40721,3056,2,4263,'App\\Models\\Receipt',4263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',1500.00,NULL,NULL,1,'2023-06-08 11:02:25','2023-06-08 11:02:25',NULL),(5593,7922,40721,3056,2,4264,'App\\Models\\Receipt',4264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',5300.00,NULL,NULL,1,'2023-06-08 11:02:25','2023-06-08 11:02:25',NULL),(5594,7922,40721,3056,2,4265,'App\\Models\\Receipt',4265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',300.00,NULL,NULL,1,'2023-06-08 11:02:25','2023-06-08 11:02:25',NULL),(5595,7922,40721,3056,2,4266,'App\\Models\\Receipt',4266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',14000.00,NULL,NULL,1,'2023-06-08 11:02:25','2023-06-08 11:02:25',NULL),(5596,7922,40721,3056,2,4267,'App\\Models\\Receipt',4267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',14605.00,NULL,NULL,1,'2023-06-08 11:02:25','2023-06-08 11:02:25',NULL),(5597,7922,40721,3056,2,4268,'App\\Models\\Receipt',4268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',2000.00,NULL,NULL,1,'2023-06-08 11:02:26','2023-06-08 11:02:26',NULL),(5598,7922,40721,3056,2,4269,'App\\Models\\Receipt',4269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',1100.00,NULL,NULL,1,'2023-06-08 11:02:26','2023-06-08 11:02:26',NULL),(5599,7922,40721,3056,2,4270,'App\\Models\\Receipt',4270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',2750.00,NULL,NULL,1,'2023-06-08 11:02:26','2023-06-08 11:02:26',NULL),(5600,7922,40721,3056,2,4271,'App\\Models\\Receipt',4271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',3850.00,NULL,NULL,1,'2023-06-08 11:02:26','2023-06-08 11:02:26',NULL),(5601,7922,40721,3056,2,4272,'App\\Models\\Receipt',4272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',200.00,NULL,NULL,1,'2023-06-08 11:02:26','2023-06-08 11:02:26',NULL),(5602,7922,40721,3056,2,4273,'App\\Models\\Receipt',4273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',4500.00,NULL,NULL,1,'2023-06-08 11:02:26','2023-06-08 11:02:26',NULL),(5603,7922,40721,3056,2,4274,'App\\Models\\Receipt',4274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',13900.00,NULL,NULL,1,'2023-06-08 11:02:26','2023-06-08 11:02:26',NULL),(5604,7922,40721,3056,2,4275,'App\\Models\\Receipt',4275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',1800.00,NULL,NULL,1,'2023-06-08 11:02:26','2023-06-08 11:02:26',NULL),(5605,7922,40721,3056,2,4276,'App\\Models\\Receipt',4276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',100.00,NULL,NULL,1,'2023-06-08 11:02:26','2023-06-08 11:02:26',NULL),(5606,7922,40721,3056,2,4277,'App\\Models\\Receipt',4277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',850.00,NULL,NULL,1,'2023-06-08 11:02:26','2023-06-08 11:02:26',NULL),(5607,7922,40721,3056,2,4278,'App\\Models\\Receipt',4278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',900.00,NULL,NULL,1,'2023-06-08 11:02:26','2023-06-08 11:02:26',NULL),(5608,7922,40721,3056,2,4279,'App\\Models\\Receipt',4279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',1500.00,NULL,NULL,1,'2023-06-08 11:02:26','2023-06-08 11:02:26',NULL),(5609,7922,40721,3056,2,4280,'App\\Models\\Receipt',4280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',5150.00,NULL,NULL,1,'2023-06-08 11:02:26','2023-06-08 11:02:26',NULL);
INSERT INTO `balance_libro` VALUES (5610,7922,40721,3056,2,4281,'App\\Models\\Receipt',4281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',7160.00,NULL,NULL,1,'2023-06-08 11:02:26','2023-06-08 11:02:26',NULL),(5611,7922,40721,3056,2,4282,'App\\Models\\Receipt',4282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',2300.00,NULL,NULL,1,'2023-06-08 11:02:26','2023-06-08 11:02:26',NULL),(5612,7922,40721,3056,2,4283,'App\\Models\\Receipt',4283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',2950.00,NULL,NULL,1,'2023-06-08 11:02:27','2023-06-08 11:02:27',NULL),(5613,7922,40721,3056,2,4284,'App\\Models\\Receipt',4284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',3000.00,NULL,NULL,1,'2023-06-08 11:02:27','2023-06-08 11:02:27',NULL),(5614,7922,40721,3056,2,4285,'App\\Models\\Receipt',4285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',2920.00,NULL,NULL,1,'2023-06-08 11:02:27','2023-06-08 11:02:27',NULL),(5615,7922,40721,3056,2,4286,'App\\Models\\Receipt',4286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',2300.00,NULL,NULL,1,'2023-06-08 11:02:27','2023-06-08 11:02:27',NULL),(5616,7922,40721,3056,2,4287,'App\\Models\\Receipt',4287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',1900.00,NULL,NULL,1,'2023-06-08 11:02:27','2023-06-08 11:02:27',NULL),(5617,7922,40721,3056,2,4288,'App\\Models\\Receipt',4288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',3500.00,NULL,NULL,1,'2023-06-08 11:02:27','2023-06-08 11:02:27',NULL),(5618,7922,40721,3056,2,4289,'App\\Models\\Receipt',4289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',2750.00,NULL,NULL,1,'2023-06-08 11:02:27','2023-06-08 11:02:27',NULL),(5619,7922,40721,3056,2,4290,'App\\Models\\Receipt',4290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',4255.00,NULL,NULL,1,'2023-06-08 11:02:27','2023-06-08 11:02:27',NULL),(5620,7922,40721,3056,2,4291,'App\\Models\\Receipt',4291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',2100.00,NULL,NULL,1,'2023-06-08 11:02:27','2023-06-08 11:02:27',NULL),(5621,7922,40721,3056,2,4292,'App\\Models\\Receipt',4292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',1000.00,NULL,NULL,1,'2023-06-08 11:02:27','2023-06-08 11:02:27',NULL),(5622,7922,40721,3056,2,4293,'App\\Models\\Receipt',4293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',1200.00,NULL,NULL,1,'2023-06-08 11:02:28','2023-06-08 11:02:28',NULL),(5623,7922,40721,3056,2,4294,'App\\Models\\Receipt',4294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',12000.00,NULL,NULL,1,'2023-06-08 11:02:28','2023-06-08 11:02:28',NULL),(5624,7922,40721,3056,2,4295,'App\\Models\\Receipt',4295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',2850.00,NULL,NULL,1,'2023-06-08 11:02:28','2023-06-08 11:02:28',NULL),(5625,7922,40721,3056,2,4296,'App\\Models\\Receipt',4296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',3000.00,NULL,NULL,1,'2023-06-08 11:02:28','2023-06-08 11:02:28',NULL),(5626,7922,40721,3056,2,4297,'App\\Models\\Receipt',4297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',1000.00,NULL,NULL,1,'2023-06-08 11:02:28','2023-06-08 11:02:28',NULL),(5627,7922,40721,3056,2,4298,'App\\Models\\Receipt',4298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',3600.00,NULL,NULL,1,'2023-06-08 11:02:28','2023-06-08 11:02:28',NULL),(5628,7922,40721,3056,2,4299,'App\\Models\\Receipt',4299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',4500.00,NULL,NULL,1,'2023-06-08 11:02:28','2023-06-08 11:02:28',NULL),(5629,7922,40721,3056,2,4300,'App\\Models\\Receipt',4300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',1550.00,NULL,NULL,1,'2023-06-08 11:02:28','2023-06-08 11:02:28',NULL),(5630,7922,40721,3056,2,4301,'App\\Models\\Receipt',4301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',250.00,NULL,NULL,1,'2023-06-08 11:02:28','2023-06-08 11:02:28',NULL);
INSERT INTO `balance_libro` VALUES (5631,7922,40721,3056,2,4302,'App\\Models\\Receipt',4302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',1500.00,NULL,NULL,1,'2023-06-08 11:02:28','2023-06-08 11:02:28',NULL),(5632,7922,40721,3056,2,4303,'App\\Models\\Receipt',4303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',6200.00,NULL,NULL,1,'2023-06-08 11:02:28','2023-06-08 11:02:28',NULL),(5633,7922,40721,3056,2,4304,'App\\Models\\Receipt',4304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',900.00,NULL,NULL,1,'2023-06-08 11:02:28','2023-06-08 11:02:28',NULL),(5634,7922,40721,3056,2,4305,'App\\Models\\Receipt',4305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',8820.00,NULL,NULL,1,'2023-06-08 11:02:28','2023-06-08 11:02:28',NULL),(5635,7922,40721,3056,2,4306,'App\\Models\\Receipt',4306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',8100.00,NULL,NULL,1,'2023-06-08 11:02:28','2023-06-08 11:02:28',NULL),(5636,7922,40721,3056,2,4307,'App\\Models\\Receipt',4307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',2050.00,NULL,NULL,1,'2023-06-08 11:02:28','2023-06-08 11:02:28',NULL),(5637,7922,40721,3056,2,4308,'App\\Models\\Receipt',4308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',1200.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5638,7922,40721,3056,2,4309,'App\\Models\\Receipt',4309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',3500.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5639,7922,40721,3056,2,4310,'App\\Models\\Receipt',4310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',1200.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5640,7922,40721,3056,2,4311,'App\\Models\\Receipt',4311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',14000.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5641,7922,40721,3056,2,4312,'App\\Models\\Receipt',4312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',1300.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5642,7922,40721,3056,2,4313,'App\\Models\\Receipt',4313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',2000.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5643,7922,40721,3056,2,4314,'App\\Models\\Receipt',4314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',3850.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5644,7922,40721,3056,2,4315,'App\\Models\\Receipt',4315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',1500.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5645,7922,40721,3056,2,4316,'App\\Models\\Receipt',4316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',1500.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5646,7922,40721,3056,2,4317,'App\\Models\\Receipt',4317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',9387.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5647,7922,40721,3056,2,4318,'App\\Models\\Receipt',4318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',5100.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5648,7922,40721,3056,2,4319,'App\\Models\\Receipt',4319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1000.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5649,7922,40721,3056,2,4320,'App\\Models\\Receipt',4320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',700.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5650,7922,40721,3056,2,4321,'App\\Models\\Receipt',4321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',23931.50,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5651,7922,40721,3056,2,4322,'App\\Models\\Receipt',4322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1200.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL);
INSERT INTO `balance_libro` VALUES (5652,7922,40721,3056,2,4323,'App\\Models\\Receipt',4323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1100.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5653,7922,40721,3056,2,4324,'App\\Models\\Receipt',4324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1550.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5654,7922,40721,3056,2,4325,'App\\Models\\Receipt',4325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',2000.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5655,7922,40721,3056,2,4326,'App\\Models\\Receipt',4326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',400.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5656,7922,40721,3056,2,4327,'App\\Models\\Receipt',4327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1000.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5657,7922,40721,3056,2,4328,'App\\Models\\Receipt',4328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1300.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5658,7922,40721,3056,2,4329,'App\\Models\\Receipt',4329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',2000.00,NULL,NULL,1,'2023-06-08 11:02:29','2023-06-08 11:02:29',NULL),(5659,7922,40721,3056,2,4330,'App\\Models\\Receipt',4330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',8900.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL),(5660,7922,40721,3056,2,4331,'App\\Models\\Receipt',4331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',500.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL),(5661,7922,40721,3056,2,4332,'App\\Models\\Receipt',4332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',2500.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL),(5662,7922,40721,3056,2,4333,'App\\Models\\Receipt',4333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',2900.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL),(5663,7922,40721,3056,2,4334,'App\\Models\\Receipt',4334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1800.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL),(5664,7922,40721,3056,2,4335,'App\\Models\\Receipt',4335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',3850.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL),(5665,7922,40721,3056,2,4336,'App\\Models\\Receipt',4336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1800.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL),(5666,7922,40721,3056,2,4337,'App\\Models\\Receipt',4337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',500.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL),(5667,7922,40721,3056,2,4338,'App\\Models\\Receipt',4338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',550.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL),(5668,7922,40721,3056,2,4339,'App\\Models\\Receipt',4339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',1800.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL),(5669,7922,40721,3056,2,4340,'App\\Models\\Receipt',4340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',3060.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL),(5670,7922,40721,3056,2,4341,'App\\Models\\Receipt',4341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',2500.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL),(5671,7922,40721,3056,2,4342,'App\\Models\\Receipt',4342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',1840.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL),(5672,7922,40721,3056,2,4343,'App\\Models\\Receipt',4343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',1000.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL);
INSERT INTO `balance_libro` VALUES (5673,7922,40721,3056,2,4344,'App\\Models\\Receipt',4344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',3800.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL),(5674,7922,40721,3056,2,4345,'App\\Models\\Receipt',4345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',20700.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL),(5675,7922,40721,3056,2,4346,'App\\Models\\Receipt',4346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',6100.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL),(5676,7922,40721,3056,2,4347,'App\\Models\\Receipt',4347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',14800.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL),(5677,7922,40721,3056,2,4348,'App\\Models\\Receipt',4348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',1300.00,NULL,NULL,1,'2023-06-08 11:02:30','2023-06-08 11:02:30',NULL),(5678,7922,40721,3056,2,4349,'App\\Models\\Receipt',4349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',3400.00,NULL,NULL,1,'2023-06-08 11:02:31','2023-06-08 11:02:31',NULL),(5679,7922,40721,3056,2,4350,'App\\Models\\Receipt',4350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',3500.00,NULL,NULL,1,'2023-06-08 11:02:31','2023-06-08 11:02:31',NULL),(5680,7922,40721,3056,2,4351,'App\\Models\\Receipt',4351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',1800.00,NULL,NULL,1,'2023-06-08 11:02:31','2023-06-08 11:02:31',NULL),(5681,7922,40721,3056,2,4352,'App\\Models\\Receipt',4352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',1500.00,NULL,NULL,1,'2023-06-08 11:02:31','2023-06-08 11:02:31',NULL),(5682,7922,40721,3056,2,4353,'App\\Models\\Receipt',4353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',950.00,NULL,NULL,1,'2023-06-08 11:02:31','2023-06-08 11:02:31',NULL),(5683,7922,40721,3056,2,4354,'App\\Models\\Receipt',4354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',22425.00,NULL,NULL,1,'2023-06-08 11:02:31','2023-06-08 11:02:31',NULL),(5684,7922,40721,3056,2,4355,'App\\Models\\Receipt',4355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',1000.00,NULL,NULL,1,'2023-06-08 11:02:31','2023-06-08 11:02:31',NULL),(5685,7922,40721,3056,2,4356,'App\\Models\\Receipt',4356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',3900.00,NULL,NULL,1,'2023-06-08 11:02:31','2023-06-08 11:02:31',NULL),(5686,7922,40721,3056,2,4357,'App\\Models\\Receipt',4357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',3900.00,NULL,NULL,1,'2023-06-08 11:02:31','2023-06-08 11:02:31',NULL),(5687,7922,40721,3056,2,4358,'App\\Models\\Receipt',4358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',1700.00,NULL,NULL,1,'2023-06-08 11:02:31','2023-06-08 11:02:31',NULL),(5688,7922,40721,3056,2,4359,'App\\Models\\Receipt',4359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',1700.00,NULL,NULL,1,'2023-06-08 11:02:31','2023-06-08 11:02:31',NULL),(5689,7922,40721,3056,2,4360,'App\\Models\\Receipt',4360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',2100.00,NULL,NULL,1,'2023-06-08 11:02:31','2023-06-08 11:02:31',NULL),(5690,7922,40721,3056,2,4361,'App\\Models\\Receipt',4361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',1300.00,NULL,NULL,1,'2023-06-08 11:02:31','2023-06-08 11:02:31',NULL),(5691,7922,40721,3056,2,4362,'App\\Models\\Receipt',4362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',800.00,NULL,NULL,1,'2023-06-08 11:02:31','2023-06-08 11:02:31',NULL),(5692,7922,40721,3056,2,4363,'App\\Models\\Receipt',4363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',2500.00,NULL,NULL,1,'2023-06-08 11:02:31','2023-06-08 11:02:31',NULL),(5693,7922,40721,3056,2,4364,'App\\Models\\Receipt',4364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',760.00,NULL,NULL,1,'2023-06-08 11:02:31','2023-06-08 11:02:31',NULL);
INSERT INTO `balance_libro` VALUES (5694,7922,40721,3056,2,4365,'App\\Models\\Receipt',4365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',2900.00,NULL,NULL,1,'2023-06-08 11:02:31','2023-06-08 11:02:31',NULL),(5695,7922,40721,3056,2,4366,'App\\Models\\Receipt',4366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',544500.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5696,7922,40721,3056,2,4367,'App\\Models\\Receipt',4367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',5200.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5697,7922,40721,3056,2,4368,'App\\Models\\Receipt',4368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',1700.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5698,7922,40721,3056,2,4369,'App\\Models\\Receipt',4369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',1300.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5699,7922,40721,3056,2,4370,'App\\Models\\Receipt',4370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',500.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5700,7922,40721,3056,2,4371,'App\\Models\\Receipt',4371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',2600.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5701,7922,40721,3056,2,4372,'App\\Models\\Receipt',4372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',2100.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5702,7922,40721,3056,2,4373,'App\\Models\\Receipt',4373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',1200.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5703,7922,40721,3056,2,4374,'App\\Models\\Receipt',4374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',350.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5704,7922,40721,3056,2,4375,'App\\Models\\Receipt',4375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',94300.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5705,7922,40721,3056,2,4376,'App\\Models\\Receipt',4376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',8500.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5706,7922,40721,3056,2,4377,'App\\Models\\Receipt',4377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',1500.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5707,7922,40721,3056,2,4378,'App\\Models\\Receipt',4378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',18000.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5708,7922,40721,3056,2,4379,'App\\Models\\Receipt',4379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',120516.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5709,7922,40721,3056,2,4380,'App\\Models\\Receipt',4380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',1600.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5710,7922,40721,3056,2,4381,'App\\Models\\Receipt',4381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',2900.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5711,7922,40721,3056,2,4382,'App\\Models\\Receipt',4382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',786500.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5712,7922,40721,3056,2,4383,'App\\Models\\Receipt',4383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',300.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5713,7922,40721,3056,2,4384,'App\\Models\\Receipt',4384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',2750.00,NULL,NULL,1,'2023-06-08 11:02:32','2023-06-08 11:02:32',NULL),(5714,7922,40721,3056,2,4385,'App\\Models\\Receipt',4385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',700.00,NULL,NULL,1,'2023-06-08 11:02:33','2023-06-08 11:02:33',NULL);
INSERT INTO `balance_libro` VALUES (5715,7922,40721,3056,2,4386,'App\\Models\\Receipt',4386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',71390.00,NULL,NULL,1,'2023-06-08 11:02:33','2023-06-08 11:02:33',NULL),(5716,7922,40721,3056,2,4387,'App\\Models\\Receipt',4387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',2900.00,NULL,NULL,1,'2023-06-08 11:02:33','2023-06-08 11:02:33',NULL),(5717,7922,40721,3056,2,4388,'App\\Models\\Receipt',4388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',1900.00,NULL,NULL,1,'2023-06-08 11:02:33','2023-06-08 11:02:33',NULL),(5718,7922,40721,3056,2,4389,'App\\Models\\Receipt',4389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',1500.00,NULL,NULL,1,'2023-06-08 11:02:33','2023-06-08 11:02:33',NULL),(5719,7922,40721,3056,2,4390,'App\\Models\\Receipt',4390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',1000.00,NULL,NULL,1,'2023-06-08 11:02:33','2023-06-08 11:02:33',NULL),(5720,7922,40721,3056,2,4391,'App\\Models\\Receipt',4391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',500.00,NULL,NULL,1,'2023-06-08 11:02:33','2023-06-08 11:02:33',NULL),(5721,7922,40721,3056,2,4392,'App\\Models\\Receipt',4392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',30200.00,NULL,NULL,1,'2023-06-08 11:02:33','2023-06-08 11:02:33',NULL),(5722,7922,40721,3056,2,4393,'App\\Models\\Receipt',4393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',300.00,NULL,NULL,1,'2023-06-08 11:02:33','2023-06-08 11:02:33',NULL),(5723,7922,40721,3056,2,4394,'App\\Models\\Receipt',4394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',2500.00,NULL,NULL,1,'2023-06-08 11:02:33','2023-06-08 11:02:33',NULL),(5724,7922,40721,3056,2,4395,'App\\Models\\Receipt',4395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',8900.00,NULL,NULL,1,'2023-06-08 11:02:33','2023-06-08 11:02:33',NULL),(5725,7922,40721,3056,2,4396,'App\\Models\\Receipt',4396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',800.00,NULL,NULL,1,'2023-06-08 11:02:33','2023-06-08 11:02:33',NULL),(5726,7922,40721,3056,2,4397,'App\\Models\\Receipt',4397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',13800.00,NULL,NULL,1,'2023-06-08 11:02:33','2023-06-08 11:02:33',NULL),(5727,7922,40721,3056,2,4398,'App\\Models\\Receipt',4398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',600.00,NULL,NULL,1,'2023-06-08 11:02:33','2023-06-08 11:02:33',NULL),(5728,7922,40721,3056,2,4399,'App\\Models\\Receipt',4399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',1860.00,NULL,NULL,1,'2023-06-08 11:02:33','2023-06-08 11:02:33',NULL),(5729,7922,40721,3056,2,4400,'App\\Models\\Receipt',4400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',2800.00,NULL,NULL,1,'2023-06-08 11:02:33','2023-06-08 11:02:33',NULL),(5730,7922,40721,3056,2,4401,'App\\Models\\Receipt',4401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',2900.00,NULL,NULL,1,'2023-06-08 11:02:33','2023-06-08 11:02:33',NULL),(5731,7922,40721,3056,2,4402,'App\\Models\\Receipt',4402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',1960.00,NULL,NULL,1,'2023-06-08 11:02:34','2023-06-08 11:02:34',NULL),(5732,7922,40721,3056,2,4403,'App\\Models\\Receipt',4403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',1430.00,NULL,NULL,1,'2023-06-08 11:02:34','2023-06-08 11:02:34',NULL),(5733,7922,40721,3056,2,4404,'App\\Models\\Receipt',4404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',7900.00,NULL,NULL,1,'2023-06-08 11:02:34','2023-06-08 11:02:34',NULL),(5734,7922,40721,3056,2,4405,'App\\Models\\Receipt',4405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',2900.00,NULL,NULL,1,'2023-06-08 11:02:34','2023-06-08 11:02:34',NULL),(5735,7922,40721,3056,2,4406,'App\\Models\\Receipt',4406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',1300.00,NULL,NULL,1,'2023-06-08 11:02:34','2023-06-08 11:02:34',NULL);
INSERT INTO `balance_libro` VALUES (5736,7922,40721,3056,2,4407,'App\\Models\\Receipt',4407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',2000.00,NULL,NULL,1,'2023-06-08 11:02:34','2023-06-08 11:02:34',NULL),(5737,7922,40721,3056,2,4408,'App\\Models\\Receipt',4408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',423500.00,NULL,NULL,1,'2023-06-08 11:02:34','2023-06-08 11:02:34',NULL),(5738,7922,40721,3056,2,4409,'App\\Models\\Receipt',4409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',7000.00,NULL,NULL,1,'2023-06-08 11:02:34','2023-06-08 11:02:34',NULL),(5739,7922,40721,3056,2,4410,'App\\Models\\Receipt',4410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',1870.00,NULL,NULL,1,'2023-06-08 11:02:34','2023-06-08 11:02:34',NULL),(5740,7922,40721,3056,2,4411,'App\\Models\\Receipt',4411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',1800.00,NULL,NULL,1,'2023-06-08 11:02:34','2023-06-08 11:02:34',NULL),(5741,7922,40721,3056,2,4412,'App\\Models\\Receipt',4412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',200.00,NULL,NULL,1,'2023-06-08 11:02:34','2023-06-08 11:02:34',NULL),(5742,7922,40721,3056,2,4413,'App\\Models\\Receipt',4413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',8464.50,NULL,NULL,1,'2023-06-08 11:02:34','2023-06-08 11:02:34',NULL),(5743,7922,40721,3056,2,4414,'App\\Models\\Receipt',4414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',600.00,NULL,NULL,1,'2023-06-08 11:02:34','2023-06-08 11:02:34',NULL),(5744,7922,40721,3056,2,4415,'App\\Models\\Receipt',4415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',3500.00,NULL,NULL,1,'2023-06-08 11:02:34','2023-06-08 11:02:34',NULL),(5745,7922,40721,3056,2,4416,'App\\Models\\Receipt',4416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',5200.00,NULL,NULL,1,'2023-06-08 11:02:34','2023-06-08 11:02:34',NULL),(5746,7922,40721,3056,2,4417,'App\\Models\\Receipt',4417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',1000.00,NULL,NULL,1,'2023-06-08 11:02:34','2023-06-08 11:02:34',NULL),(5747,7922,40721,3056,2,4418,'App\\Models\\Receipt',4418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',5750.00,NULL,NULL,1,'2023-06-08 11:02:34','2023-06-08 11:02:34',NULL),(5748,7922,40721,3056,2,4419,'App\\Models\\Receipt',4419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',1700.00,NULL,NULL,1,'2023-06-08 11:02:35','2023-06-08 11:02:35',NULL),(5749,7922,40721,3056,2,4420,'App\\Models\\Receipt',4420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',300.00,NULL,NULL,1,'2023-06-08 11:02:35','2023-06-08 11:02:35',NULL),(5750,7922,40721,3056,2,4421,'App\\Models\\Receipt',4421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',1400.00,NULL,NULL,1,'2023-06-08 11:02:35','2023-06-08 11:02:35',NULL),(5751,7922,40721,3056,2,4422,'App\\Models\\Receipt',4422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',4500.00,NULL,NULL,1,'2023-06-08 11:02:35','2023-06-08 11:02:35',NULL),(5752,7922,40721,3056,2,4423,'App\\Models\\Receipt',4423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',2500.00,NULL,NULL,1,'2023-06-08 11:02:35','2023-06-08 11:02:35',NULL),(5753,7922,40721,3056,2,4424,'App\\Models\\Receipt',4424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',1200.00,NULL,NULL,1,'2023-06-08 11:02:35','2023-06-08 11:02:35',NULL),(5754,7922,40721,3056,2,4425,'App\\Models\\Receipt',4425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',1100.00,NULL,NULL,1,'2023-06-08 11:02:35','2023-06-08 11:02:35',NULL),(5755,7922,40721,3056,2,4426,'App\\Models\\Receipt',4426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',1000.00,NULL,NULL,1,'2023-06-08 11:02:35','2023-06-08 11:02:35',NULL),(5756,7922,40721,3056,2,4427,'App\\Models\\Receipt',4427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',6160.00,NULL,NULL,1,'2023-06-08 11:02:35','2023-06-08 11:02:35',NULL);
INSERT INTO `balance_libro` VALUES (5757,7922,40721,3056,2,4428,'App\\Models\\Receipt',4428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',7700.00,NULL,NULL,1,'2023-06-08 11:02:35','2023-06-08 11:02:35',NULL),(5758,7922,40721,3056,2,4429,'App\\Models\\Receipt',4429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',5500.00,NULL,NULL,1,'2023-06-08 11:02:35','2023-06-08 11:02:35',NULL),(5759,7922,40721,3056,2,4430,'App\\Models\\Receipt',4430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',700.00,NULL,NULL,1,'2023-06-08 11:02:35','2023-06-08 11:02:35',NULL),(5760,7922,40721,3056,2,4431,'App\\Models\\Receipt',4431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',2500.00,NULL,NULL,1,'2023-06-08 11:02:35','2023-06-08 11:02:35',NULL),(5761,7922,40721,3056,2,4432,'App\\Models\\Receipt',4432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',7600.00,NULL,NULL,1,'2023-06-08 11:02:35','2023-06-08 11:02:35',NULL),(5762,7922,40721,3056,2,4433,'App\\Models\\Receipt',4433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',8500.00,NULL,NULL,1,'2023-06-08 11:02:35','2023-06-08 11:02:35',NULL),(5763,7922,40721,3056,2,4434,'App\\Models\\Receipt',4434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',2500.00,NULL,NULL,1,'2023-06-08 11:02:35','2023-06-08 11:02:35',NULL),(5764,7922,40721,3056,2,4435,'App\\Models\\Receipt',4435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',1500.00,NULL,NULL,1,'2023-06-08 11:02:36','2023-06-08 11:02:36',NULL),(5765,7922,40721,3056,2,4436,'App\\Models\\Receipt',4436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',1500.00,NULL,NULL,1,'2023-06-08 11:02:36','2023-06-08 11:02:36',NULL),(5766,7922,40721,3056,2,4437,'App\\Models\\Receipt',4437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',1400.00,NULL,NULL,1,'2023-06-08 11:02:36','2023-06-08 11:02:36',NULL),(5767,7922,40721,3056,2,4438,'App\\Models\\Receipt',4438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',1100.00,NULL,NULL,1,'2023-06-08 11:02:36','2023-06-08 11:02:36',NULL),(5768,7922,40721,3056,2,4439,'App\\Models\\Receipt',4439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',1000.00,NULL,NULL,1,'2023-06-08 11:02:36','2023-06-08 11:02:36',NULL),(5769,7922,40721,3056,2,4440,'App\\Models\\Receipt',4440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',900.00,NULL,NULL,1,'2023-06-08 11:02:36','2023-06-08 11:02:36',NULL),(5770,7922,40721,3056,2,4441,'App\\Models\\Receipt',4441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',900.00,NULL,NULL,1,'2023-06-08 11:02:36','2023-06-08 11:02:36',NULL),(5771,7922,40721,3056,2,4442,'App\\Models\\Receipt',4442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',300.00,NULL,NULL,1,'2023-06-08 11:02:36','2023-06-08 11:02:36',NULL),(5772,7922,40721,3056,2,4443,'App\\Models\\Receipt',4443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',2200.00,NULL,NULL,1,'2023-06-08 11:02:36','2023-06-08 11:02:36',NULL),(5773,7922,40721,3056,2,4444,'App\\Models\\Receipt',4444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',1400.00,NULL,NULL,1,'2023-06-08 11:02:36','2023-06-08 11:02:36',NULL),(5774,7922,40721,3056,2,4445,'App\\Models\\Receipt',4445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',1400.00,NULL,NULL,1,'2023-06-08 11:02:36','2023-06-08 11:02:36',NULL),(5775,7922,40721,3056,2,4446,'App\\Models\\Receipt',4446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',1100.00,NULL,NULL,1,'2023-06-08 11:02:36','2023-06-08 11:02:36',NULL),(5776,7922,40721,3056,2,4447,'App\\Models\\Receipt',4447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',96800.00,NULL,NULL,1,'2023-06-08 11:02:36','2023-06-08 11:02:36',NULL),(5777,7922,40721,3056,2,4448,'App\\Models\\Receipt',4448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',459800.00,NULL,NULL,1,'2023-06-08 11:02:36','2023-06-08 11:02:36',NULL);
INSERT INTO `balance_libro` VALUES (5778,7922,40721,3056,2,4449,'App\\Models\\Receipt',4449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',556600.00,NULL,NULL,1,'2023-06-08 11:02:36','2023-06-08 11:02:36',NULL),(5779,7922,40721,3056,2,4450,'App\\Models\\Receipt',4450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',290400.00,NULL,NULL,1,'2023-06-08 11:02:36','2023-06-08 11:02:36',NULL),(5780,7922,40721,3056,2,4451,'App\\Models\\Receipt',4451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',175450.00,NULL,NULL,1,'2023-06-08 11:02:36','2023-06-08 11:02:36',NULL),(5781,7922,40721,3056,2,4452,'App\\Models\\Receipt',4452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',6900.00,NULL,NULL,1,'2023-06-08 11:02:37','2023-06-08 11:02:37',NULL),(5782,7922,40721,3056,2,4453,'App\\Models\\Receipt',4453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',3500.00,NULL,NULL,1,'2023-06-08 11:02:37','2023-06-08 11:02:37',NULL),(5783,7922,40721,3056,2,4454,'App\\Models\\Receipt',4454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',3000.00,NULL,NULL,1,'2023-06-08 11:02:37','2023-06-08 11:02:37',NULL),(5784,7922,40721,3056,2,4455,'App\\Models\\Receipt',4455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',2900.00,NULL,NULL,1,'2023-06-08 11:02:37','2023-06-08 11:02:37',NULL),(5785,7922,40721,3056,2,4456,'App\\Models\\Receipt',4456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',2000.00,NULL,NULL,1,'2023-06-08 11:02:37','2023-06-08 11:02:37',NULL),(5786,7922,40721,3056,2,4457,'App\\Models\\Receipt',4457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',1100.00,NULL,NULL,1,'2023-06-08 11:02:37','2023-06-08 11:02:37',NULL),(5787,7922,40721,3056,2,4458,'App\\Models\\Receipt',4458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',400.00,NULL,NULL,1,'2023-06-08 11:02:37','2023-06-08 11:02:37',NULL),(5788,7922,40721,3056,2,4459,'App\\Models\\Receipt',4459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',332508.00,NULL,NULL,1,'2023-06-08 11:02:37','2023-06-08 11:02:37',NULL),(5789,7922,40721,3056,2,4460,'App\\Models\\Receipt',4460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',900.00,NULL,NULL,1,'2023-06-08 11:02:37','2023-06-08 11:02:37',NULL),(5790,7922,40721,3056,2,4461,'App\\Models\\Receipt',4461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',1000.00,NULL,NULL,1,'2023-06-08 11:02:37','2023-06-08 11:02:37',NULL),(5791,7922,40721,3056,2,4462,'App\\Models\\Receipt',4462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',1320.00,NULL,NULL,1,'2023-06-08 11:02:37','2023-06-08 11:02:37',NULL),(5792,7922,40721,3056,2,4463,'App\\Models\\Receipt',4463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',2730.00,NULL,NULL,1,'2023-06-08 11:02:37','2023-06-08 11:02:37',NULL),(5793,7922,40721,3056,2,4464,'App\\Models\\Receipt',4464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',2900.00,NULL,NULL,1,'2023-06-08 11:02:37','2023-06-08 11:02:37',NULL),(5794,7922,40721,3056,2,4465,'App\\Models\\Receipt',4465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',1400.00,NULL,NULL,1,'2023-06-08 11:02:37','2023-06-08 11:02:37',NULL),(5795,7922,40721,3056,2,4466,'App\\Models\\Receipt',4466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',600.00,NULL,NULL,1,'2023-06-08 11:02:37','2023-06-08 11:02:37',NULL),(5796,7922,40721,3056,2,4467,'App\\Models\\Receipt',4467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',1500.00,NULL,NULL,1,'2023-06-08 11:02:37','2023-06-08 11:02:37',NULL),(5797,7922,40721,3056,2,4468,'App\\Models\\Receipt',4468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',400.00,NULL,NULL,1,'2023-06-08 11:02:37','2023-06-08 11:02:37',NULL),(5798,7922,40721,3056,2,4469,'App\\Models\\Receipt',4469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',3900.00,NULL,NULL,1,'2023-06-08 11:02:38','2023-06-08 11:02:38',NULL);
INSERT INTO `balance_libro` VALUES (5799,7922,40721,3056,2,4470,'App\\Models\\Receipt',4470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',33550.00,NULL,NULL,1,'2023-06-08 11:02:38','2023-06-08 11:02:38',NULL),(5800,7922,40721,3056,2,4471,'App\\Models\\Receipt',4471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',397122.00,NULL,NULL,1,'2023-06-08 11:02:38','2023-06-08 11:02:38',NULL),(5801,7922,40721,3056,2,4472,'App\\Models\\Receipt',4472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',219494.00,NULL,NULL,1,'2023-06-08 11:02:38','2023-06-08 11:02:38',NULL),(5802,7922,40721,3056,2,4473,'App\\Models\\Receipt',4473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',272250.00,NULL,NULL,1,'2023-06-08 11:02:38','2023-06-08 11:02:38',NULL),(5803,7922,40721,3056,2,4474,'App\\Models\\Receipt',4474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',411400.00,NULL,NULL,1,'2023-06-08 11:02:38','2023-06-08 11:02:38',NULL),(5804,7922,40721,3056,2,4475,'App\\Models\\Receipt',4475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',2000.00,NULL,NULL,1,'2023-06-08 11:02:38','2023-06-08 11:02:38',NULL),(5805,7922,40721,3056,2,4476,'App\\Models\\Receipt',4476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',300.00,NULL,NULL,1,'2023-06-08 11:02:38','2023-06-08 11:02:38',NULL),(5806,7922,40721,3056,2,4477,'App\\Models\\Receipt',4477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',800.00,NULL,NULL,1,'2023-06-08 11:02:38','2023-06-08 11:02:38',NULL),(5807,7922,40721,3056,2,4478,'App\\Models\\Receipt',4478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',2600.00,NULL,NULL,1,'2023-06-08 11:02:38','2023-06-08 11:02:38',NULL),(5808,7922,40721,3056,2,4479,'App\\Models\\Receipt',4479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',900.00,NULL,NULL,1,'2023-06-08 11:02:38','2023-06-08 11:02:38',NULL),(5809,7922,40721,3056,2,4480,'App\\Models\\Receipt',4480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',16905.00,NULL,NULL,1,'2023-06-08 11:02:38','2023-06-08 11:02:38',NULL),(5810,7922,40721,3056,2,4481,'App\\Models\\Receipt',4481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',1000.00,NULL,NULL,1,'2023-06-08 11:02:38','2023-06-08 11:02:38',NULL),(5811,7922,40721,3056,2,4482,'App\\Models\\Receipt',4482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',300.00,NULL,NULL,1,'2023-06-08 11:02:39','2023-06-08 11:02:39',NULL),(5812,7922,40721,3056,2,4483,'App\\Models\\Receipt',4483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',300.00,NULL,NULL,1,'2023-06-08 11:02:39','2023-06-08 11:02:39',NULL),(5813,7922,40721,3056,2,4484,'App\\Models\\Receipt',4484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',2400.00,NULL,NULL,1,'2023-06-08 11:02:39','2023-06-08 11:02:39',NULL),(5814,7922,40721,3056,2,4485,'App\\Models\\Receipt',4485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',268136.00,NULL,NULL,1,'2023-06-08 11:02:39','2023-06-08 11:02:39',NULL),(5815,7922,40721,3056,2,4486,'App\\Models\\Receipt',4486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1400.00,NULL,NULL,1,'2023-06-08 11:02:39','2023-06-08 11:02:39',NULL),(5816,7922,40721,3056,2,4487,'App\\Models\\Receipt',4487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',3300.00,NULL,NULL,1,'2023-06-08 11:02:39','2023-06-08 11:02:39',NULL),(5817,7922,40721,3056,2,4488,'App\\Models\\Receipt',4488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',14300.00,NULL,NULL,1,'2023-06-08 11:02:39','2023-06-08 11:02:39',NULL),(5818,7922,40721,3056,2,4489,'App\\Models\\Receipt',4489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',300.00,NULL,NULL,1,'2023-06-08 11:02:39','2023-06-08 11:02:39',NULL),(5819,7922,40721,3056,2,4490,'App\\Models\\Receipt',4490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',700.00,NULL,NULL,1,'2023-06-08 11:02:39','2023-06-08 11:02:39',NULL);
INSERT INTO `balance_libro` VALUES (5820,7922,40721,3056,2,4491,'App\\Models\\Receipt',4491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',800.00,NULL,NULL,1,'2023-06-08 11:02:39','2023-06-08 11:02:39',NULL),(5821,7922,40721,3056,2,4492,'App\\Models\\Receipt',4492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',900.00,NULL,NULL,1,'2023-06-08 11:02:39','2023-06-08 11:02:39',NULL),(5822,7922,40721,3056,2,4493,'App\\Models\\Receipt',4493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',6300.00,NULL,NULL,1,'2023-06-08 11:02:39','2023-06-08 11:02:39',NULL),(5823,7922,40721,3056,2,4494,'App\\Models\\Receipt',4494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',900.00,NULL,NULL,1,'2023-06-08 11:02:39','2023-06-08 11:02:39',NULL),(5824,7922,40721,3056,2,4495,'App\\Models\\Receipt',4495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',14000.00,NULL,NULL,1,'2023-06-08 11:02:40','2023-06-08 11:02:40',NULL),(5825,7922,40721,3056,2,4496,'App\\Models\\Receipt',4496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',26753.10,NULL,NULL,1,'2023-06-08 11:02:40','2023-06-08 11:02:40',NULL),(5826,7922,40721,3056,2,4497,'App\\Models\\Receipt',4497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',553212.00,NULL,NULL,1,'2023-06-08 11:02:40','2023-06-08 11:02:40',NULL),(5827,7922,40721,3056,2,4498,'App\\Models\\Receipt',4498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',423500.00,NULL,NULL,1,'2023-06-08 11:02:40','2023-06-08 11:02:40',NULL),(5828,7922,40721,3056,2,4499,'App\\Models\\Receipt',4499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',5500.00,NULL,NULL,1,'2023-06-08 11:02:40','2023-06-08 11:02:40',NULL),(5829,7922,40721,3056,2,4500,'App\\Models\\Receipt',4500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',4500.00,NULL,NULL,1,'2023-06-08 11:02:40','2023-06-08 11:02:40',NULL),(5830,7922,40721,3056,2,4501,'App\\Models\\Receipt',4501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1000.00,NULL,NULL,1,'2023-06-08 11:02:40','2023-06-08 11:02:40',NULL),(5831,7922,40721,3056,2,4502,'App\\Models\\Receipt',4502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',900.00,NULL,NULL,1,'2023-06-08 11:02:40','2023-06-08 11:02:40',NULL),(5832,7922,40721,3056,2,4503,'App\\Models\\Receipt',4503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',350.00,NULL,NULL,1,'2023-06-08 11:02:40','2023-06-08 11:02:40',NULL),(5833,7922,40721,3056,2,4504,'App\\Models\\Receipt',4504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',7000.00,NULL,NULL,1,'2023-06-08 11:02:40','2023-06-08 11:02:40',NULL),(5834,7922,40721,3056,2,4505,'App\\Models\\Receipt',4505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1000.00,NULL,NULL,1,'2023-06-08 11:02:40','2023-06-08 11:02:40',NULL),(5835,7922,40721,3056,3,4506,'App\\Models\\Receipt',4506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',12949.00,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5836,7922,40721,3056,3,4507,'App\\Models\\Receipt',4507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',11500.00,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5837,7922,40721,3056,3,4508,'App\\Models\\Receipt',4508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',3407.47,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5838,7922,40721,3056,3,4509,'App\\Models\\Receipt',4509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',3315.45,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5839,7922,40721,3056,3,4510,'App\\Models\\Receipt',4510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',37400.00,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5840,7922,40721,3056,3,4511,'App\\Models\\Receipt',4511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',276251.09,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL);
INSERT INTO `balance_libro` VALUES (5841,7922,40721,3056,3,4512,'App\\Models\\Receipt',4512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',42000.00,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5842,7922,40721,3056,3,4513,'App\\Models\\Receipt',4513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',5882.50,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5843,7922,40721,3056,3,4514,'App\\Models\\Receipt',4514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',82950.00,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5844,7922,40721,3056,3,4515,'App\\Models\\Receipt',4515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',151395.20,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5845,7922,40721,3056,3,4516,'App\\Models\\Receipt',4516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',21538.00,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5846,7922,40721,3056,3,4517,'App\\Models\\Receipt',4517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',6419.97,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5847,7922,40721,3056,3,4518,'App\\Models\\Receipt',4518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',45000.00,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5848,7922,40721,3056,3,4519,'App\\Models\\Receipt',4519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',14481.28,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5849,7922,40721,3056,3,4520,'App\\Models\\Receipt',4520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',44684.09,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5850,7922,40721,3056,3,4521,'App\\Models\\Receipt',4521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',47815.57,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5851,7922,40721,3056,3,4522,'App\\Models\\Receipt',4522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',363.00,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5852,7922,40721,3056,3,4523,'App\\Models\\Receipt',4523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',7032.50,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5853,7922,40721,3056,3,4524,'App\\Models\\Receipt',4524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',24000.00,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5854,7922,40721,3056,3,4525,'App\\Models\\Receipt',4525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',5328.62,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5855,7922,40721,3056,3,4526,'App\\Models\\Receipt',4526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',165000.00,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5856,7922,40721,3056,3,4527,'App\\Models\\Receipt',4527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',11797.50,NULL,NULL,1,'2023-06-08 11:02:56','2023-06-08 11:02:56',NULL),(5857,7922,40721,3056,3,4528,'App\\Models\\Receipt',4528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',11248.39,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5858,7922,40721,3056,3,4529,'App\\Models\\Receipt',4529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',17772.48,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5859,7922,40721,3056,3,4530,'App\\Models\\Receipt',4530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',75284.65,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5860,7922,40721,3056,3,4531,'App\\Models\\Receipt',4531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',592174.00,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5861,7922,40721,3056,3,4532,'App\\Models\\Receipt',4532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',14955.11,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL);
INSERT INTO `balance_libro` VALUES (5862,7922,40721,3056,3,4533,'App\\Models\\Receipt',4533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',2267.23,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5863,7922,40721,3056,3,4534,'App\\Models\\Receipt',4534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',102489.40,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5864,7922,40721,3056,3,4535,'App\\Models\\Receipt',4535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',581490.57,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5865,7922,40721,3056,3,4536,'App\\Models\\Receipt',4536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',8489.99,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5866,7922,40721,3056,3,4537,'App\\Models\\Receipt',4537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',1660.00,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5867,7922,40721,3056,3,4538,'App\\Models\\Receipt',4538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',5250.00,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5868,7922,40721,3056,3,4539,'App\\Models\\Receipt',4539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',12600.54,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5869,7922,40721,3056,3,4540,'App\\Models\\Receipt',4540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',8215.90,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5870,7922,40721,3056,3,4541,'App\\Models\\Receipt',4541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',220610.79,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5871,7922,40721,3056,3,4542,'App\\Models\\Receipt',4542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',160140.23,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5872,7922,40721,3056,3,4543,'App\\Models\\Receipt',4543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',6400.00,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5873,7922,40721,3056,3,4544,'App\\Models\\Receipt',4544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',55400.00,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5874,7922,40721,3056,3,4545,'App\\Models\\Receipt',4545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',5674.78,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5875,7922,40721,3056,3,4546,'App\\Models\\Receipt',4546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',10408.10,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5876,7922,40721,3056,3,4547,'App\\Models\\Receipt',4547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',45000.02,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5877,7922,40721,3056,3,4548,'App\\Models\\Receipt',4548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',5000.01,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5878,7922,40721,3056,3,4549,'App\\Models\\Receipt',4549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',29477.75,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5879,7922,40721,3056,3,4550,'App\\Models\\Receipt',4550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',1150409.92,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5880,7922,40721,3056,3,4551,'App\\Models\\Receipt',4551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',375947.00,NULL,NULL,1,'2023-06-08 11:02:57','2023-06-08 11:02:57',NULL),(5881,7922,40721,3056,3,4552,'App\\Models\\Receipt',4552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',347270.00,NULL,NULL,1,'2023-06-08 11:02:58','2023-06-08 11:02:58',NULL),(5882,7922,40721,3056,3,4553,'App\\Models\\Receipt',4553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',2259.00,NULL,NULL,1,'2023-06-08 11:02:58','2023-06-08 11:02:58',NULL);
INSERT INTO `balance_libro` VALUES (5883,7922,40721,3056,3,4554,'App\\Models\\Receipt',4554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',367840.00,NULL,NULL,1,'2023-06-08 11:02:58','2023-06-08 11:02:58',NULL),(5884,7922,40721,3056,3,4555,'App\\Models\\Receipt',4555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',336985.00,NULL,NULL,1,'2023-06-08 11:02:58','2023-06-08 11:02:58',NULL),(5885,7922,40721,3056,3,4556,'App\\Models\\Receipt',4556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',733018.00,NULL,NULL,1,'2023-06-08 11:02:58','2023-06-08 11:02:58',NULL),(5886,7922,40721,3056,3,4557,'App\\Models\\Receipt',4557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1596.00,NULL,NULL,1,'2023-06-08 11:02:58','2023-06-08 11:02:58',NULL),(5887,7922,40721,3056,3,4558,'App\\Models\\Receipt',4558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',545528.98,NULL,NULL,1,'2023-06-08 11:02:58','2023-06-08 11:02:58',NULL),(5888,7922,40721,3056,3,4559,'App\\Models\\Receipt',4559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',500335.00,NULL,NULL,1,'2023-06-08 11:02:58','2023-06-08 11:02:58',NULL),(5889,7922,40721,3056,3,4560,'App\\Models\\Receipt',4560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',18876.00,NULL,NULL,1,'2023-06-08 11:02:58','2023-06-08 11:02:58',NULL),(5890,7922,40721,3056,3,4561,'App\\Models\\Receipt',4561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',11613.40,NULL,NULL,1,'2023-06-08 11:02:58','2023-06-08 11:02:58',NULL),(5891,7922,40721,3056,3,4562,'App\\Models\\Receipt',4562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',64551.43,NULL,NULL,1,'2023-06-08 11:02:58','2023-06-08 11:02:58',NULL),(5892,7922,40721,3056,3,4563,'App\\Models\\Receipt',4563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',338195.00,NULL,NULL,1,'2023-06-08 11:02:58','2023-06-08 11:02:58',NULL),(5893,7922,40721,3056,3,4564,'App\\Models\\Receipt',4564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',0.00,NULL,NULL,1,'2023-06-08 11:02:58','2023-06-08 11:02:58',NULL),(5894,7922,40864,12327,2,4565,'App\\Models\\Receipt',4565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',87900.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL),(5895,7922,40864,12327,2,4566,'App\\Models\\Receipt',4566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',325000.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL),(5896,7922,40864,12327,2,4567,'App\\Models\\Receipt',4567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',175910.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL),(5897,7922,40864,12327,2,4568,'App\\Models\\Receipt',4568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',175910.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL),(5898,7922,40864,12327,2,4569,'App\\Models\\Receipt',4569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',240944.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL),(5899,7922,40864,12327,2,4570,'App\\Models\\Receipt',4570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',240944.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL),(5900,7922,40864,12327,2,4571,'App\\Models\\Receipt',4571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',72000.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL),(5901,7922,40864,12327,2,4572,'App\\Models\\Receipt',4572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',70000.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL),(5902,7922,40864,12327,2,4573,'App\\Models\\Receipt',4573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',40500.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL),(5903,7922,40864,12327,2,4574,'App\\Models\\Receipt',4574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',232200.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL);
INSERT INTO `balance_libro` VALUES (5904,7922,40864,12327,2,4575,'App\\Models\\Receipt',4575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',30000.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL),(5905,7922,40864,12327,2,4576,'App\\Models\\Receipt',4576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',30200.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL),(5906,7922,40864,12327,2,4577,'App\\Models\\Receipt',4577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',28900.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL),(5907,7922,40864,12327,2,4578,'App\\Models\\Receipt',4578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',29800.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL),(5908,7922,40864,12327,2,4579,'App\\Models\\Receipt',4579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',24500.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL),(5909,7922,40864,12327,2,4580,'App\\Models\\Receipt',4580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',30100.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL),(5910,7922,40864,12327,2,4581,'App\\Models\\Receipt',4581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',29800.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL),(5911,7922,40864,12327,2,4582,'App\\Models\\Receipt',4582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',28900.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL),(5912,7922,40864,12327,2,4583,'App\\Models\\Receipt',4583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',24500.00,NULL,NULL,1,'2023-06-10 09:38:18','2023-06-10 09:38:18',NULL),(5913,7922,40864,12327,2,4584,'App\\Models\\Receipt',4584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',30500.00,NULL,NULL,1,'2023-06-10 09:38:19','2023-06-10 09:38:19',NULL),(5914,7922,40864,12327,2,4585,'App\\Models\\Receipt',4585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',28700.00,NULL,NULL,1,'2023-06-10 09:38:19','2023-06-10 09:38:19',NULL),(5915,7922,40864,12327,2,4586,'App\\Models\\Receipt',4586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',29800.00,NULL,NULL,1,'2023-06-10 09:38:19','2023-06-10 09:38:19',NULL),(5916,7922,40864,12327,2,4587,'App\\Models\\Receipt',4587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',30200.00,NULL,NULL,1,'2023-06-10 09:38:19','2023-06-10 09:38:19',NULL),(5917,7922,40864,12327,2,4588,'App\\Models\\Receipt',4588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',29800.00,NULL,NULL,1,'2023-06-10 09:38:19','2023-06-10 09:38:19',NULL),(5918,7922,40864,12327,2,4589,'App\\Models\\Receipt',4589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',29800.00,NULL,NULL,1,'2023-06-10 09:38:19','2023-06-10 09:38:19',NULL),(5919,7922,40864,12327,2,4590,'App\\Models\\Receipt',4590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',29800.00,NULL,NULL,1,'2023-06-10 09:38:19','2023-06-10 09:38:19',NULL),(5920,7922,40864,12327,2,4591,'App\\Models\\Receipt',4591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',25800.00,NULL,NULL,1,'2023-06-10 09:38:19','2023-06-10 09:38:19',NULL),(5921,7922,40864,12327,2,4592,'App\\Models\\Receipt',4592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',29800.00,NULL,NULL,1,'2023-06-10 09:38:19','2023-06-10 09:38:19',NULL),(5922,7922,40864,12327,2,4593,'App\\Models\\Receipt',4593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',30200.00,NULL,NULL,1,'2023-06-10 09:38:19','2023-06-10 09:38:19',NULL),(5923,7922,40864,12327,3,4594,'App\\Models\\Receipt',4594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',209924.99,NULL,NULL,1,'2023-06-10 09:38:29','2023-06-10 09:38:29',NULL),(5924,7922,40864,12327,3,4595,'App\\Models\\Receipt',4595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',7000.00,NULL,NULL,1,'2023-06-10 09:38:29','2023-06-10 09:38:29',NULL);
INSERT INTO `balance_libro` VALUES (5925,7922,40864,12327,3,4596,'App\\Models\\Receipt',4596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',33816.00,NULL,NULL,1,'2023-06-10 09:38:29','2023-06-10 09:38:29',NULL),(5926,7922,40864,12327,3,4597,'App\\Models\\Receipt',4597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',38303.43,NULL,NULL,1,'2023-06-10 09:38:29','2023-06-10 09:38:29',NULL),(5927,7922,40864,12327,3,4598,'App\\Models\\Receipt',4598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',559.30,NULL,NULL,1,'2023-06-10 09:38:29','2023-06-10 09:38:29',NULL),(5928,7922,40864,12327,3,4599,'App\\Models\\Receipt',4599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',20069.00,NULL,NULL,1,'2023-06-10 09:38:29','2023-06-10 09:38:29',NULL),(5929,7922,40864,12327,3,4600,'App\\Models\\Receipt',4600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',498.90,NULL,NULL,1,'2023-06-10 09:38:29','2023-06-10 09:38:29',NULL),(5930,7922,40864,12327,3,4601,'App\\Models\\Receipt',4601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',4815.00,NULL,NULL,1,'2023-06-10 09:38:29','2023-06-10 09:38:29',NULL),(5931,7922,40864,12327,3,4602,'App\\Models\\Receipt',4602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',10100.00,NULL,NULL,1,'2023-06-10 09:38:29','2023-06-10 09:38:29',NULL),(5932,7922,40864,12309,3,4603,'App\\Models\\Receipt',4603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',4499.00,NULL,NULL,1,'2023-06-10 09:47:09','2023-06-10 09:47:09',NULL),(5933,7922,40864,12309,3,4604,'App\\Models\\Receipt',4604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',1743.96,NULL,NULL,1,'2023-06-10 09:47:09','2023-06-10 09:47:09',NULL),(5934,7922,40864,12309,3,4605,'App\\Models\\Receipt',4605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',2834.10,NULL,NULL,1,'2023-06-10 09:47:09','2023-06-10 09:47:09',NULL),(5935,7922,40864,12309,3,4606,'App\\Models\\Receipt',4606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',7500.00,NULL,NULL,1,'2023-06-10 09:47:09','2023-06-10 09:47:09',NULL),(5936,7922,40864,12309,3,4607,'App\\Models\\Receipt',4607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',11060.00,NULL,NULL,1,'2023-06-10 09:47:09','2023-06-10 09:47:09',NULL),(5937,7922,40864,12309,3,4608,'App\\Models\\Receipt',4608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',7500.00,NULL,NULL,1,'2023-06-10 09:47:09','2023-06-10 09:47:09',NULL),(5938,7922,40864,12309,3,4609,'App\\Models\\Receipt',4609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',17897.71,NULL,NULL,1,'2023-06-10 09:47:09','2023-06-10 09:47:09',NULL),(5939,7922,40864,12309,3,4610,'App\\Models\\Receipt',4610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',15000.00,NULL,NULL,1,'2023-06-10 09:47:09','2023-06-10 09:47:09',NULL),(5940,7922,40864,12309,3,4611,'App\\Models\\Receipt',4611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1404.00,NULL,NULL,1,'2023-06-10 09:47:09','2023-06-10 09:47:09',NULL),(5941,7922,40864,12309,3,4612,'App\\Models\\Receipt',4612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',8183.05,NULL,NULL,1,'2023-06-10 09:47:09','2023-06-10 09:47:09',NULL),(5942,7922,40864,12309,3,4613,'App\\Models\\Receipt',4613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',79999.00,NULL,NULL,1,'2023-06-10 09:47:09','2023-06-10 09:47:09',NULL),(5943,7922,40864,12309,3,4614,'App\\Models\\Receipt',4614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',658.90,NULL,NULL,1,'2023-06-10 09:47:09','2023-06-10 09:47:09',NULL),(5944,7922,40864,12310,3,4615,'App\\Models\\Receipt',4615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',5690.00,NULL,NULL,1,'2023-06-10 09:47:22','2023-06-10 09:47:22',NULL),(5945,7922,40864,12310,3,4616,'App\\Models\\Receipt',4616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',4505.50,NULL,NULL,1,'2023-06-10 09:47:22','2023-06-10 09:47:22',NULL);
INSERT INTO `balance_libro` VALUES (5946,7922,40864,12310,3,4617,'App\\Models\\Receipt',4617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',4139.99,NULL,NULL,1,'2023-06-10 09:47:22','2023-06-10 09:47:22',NULL),(5947,7922,40864,12310,3,4618,'App\\Models\\Receipt',4618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',12999.00,NULL,NULL,1,'2023-06-10 09:47:22','2023-06-10 09:47:22',NULL),(5948,7922,40864,12310,3,4619,'App\\Models\\Receipt',4619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',10777.00,NULL,NULL,1,'2023-06-10 09:47:22','2023-06-10 09:47:22',NULL),(5949,7922,40864,12310,3,4620,'App\\Models\\Receipt',4620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',342.00,NULL,NULL,1,'2023-06-10 09:47:22','2023-06-10 09:47:22',NULL),(5950,7922,40864,12310,3,4621,'App\\Models\\Receipt',4621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',658.90,NULL,NULL,1,'2023-06-10 09:47:22','2023-06-10 09:47:22',NULL),(5951,7922,40864,12311,3,4622,'App\\Models\\Receipt',4622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',15000.00,NULL,NULL,1,'2023-06-10 09:47:30','2023-06-10 09:47:30',NULL),(5952,7922,40864,12311,3,4623,'App\\Models\\Receipt',4623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',97637.68,NULL,NULL,1,'2023-06-10 09:47:30','2023-06-10 09:47:30',NULL),(5953,7922,40864,12311,3,4624,'App\\Models\\Receipt',4624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',11999.00,NULL,NULL,1,'2023-06-10 09:47:30','2023-06-10 09:47:30',NULL),(5954,7922,40864,12311,3,4625,'App\\Models\\Receipt',4625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',750.00,NULL,NULL,1,'2023-06-10 09:47:30','2023-06-10 09:47:30',NULL),(5955,7922,40864,12311,3,4626,'App\\Models\\Receipt',4626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',19915.00,NULL,NULL,1,'2023-06-10 09:47:30','2023-06-10 09:47:30',NULL),(5956,7922,40864,12311,3,4627,'App\\Models\\Receipt',4627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',16915.00,NULL,NULL,1,'2023-06-10 09:47:30','2023-06-10 09:47:30',NULL),(5957,7922,40864,12311,3,4628,'App\\Models\\Receipt',4628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',658.90,NULL,NULL,1,'2023-06-10 09:47:30','2023-06-10 09:47:30',NULL),(5958,7922,40864,12311,3,4629,'App\\Models\\Receipt',4629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',738.00,NULL,NULL,1,'2023-06-10 09:47:30','2023-06-10 09:47:30',NULL),(5959,7922,40864,12312,3,4630,'App\\Models\\Receipt',4630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-14','2022-08-14',9490.00,NULL,NULL,1,'2023-06-10 09:47:38','2023-06-10 09:47:38',NULL),(5960,7922,40864,12312,3,4631,'App\\Models\\Receipt',4631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',11999.00,NULL,NULL,1,'2023-06-10 09:47:38','2023-06-10 09:47:38',NULL),(5961,7922,40864,12312,3,4632,'App\\Models\\Receipt',4632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',1800.00,NULL,NULL,1,'2023-06-10 09:47:38','2023-06-10 09:47:38',NULL),(5962,7922,40864,12312,3,4633,'App\\Models\\Receipt',4633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',658.90,NULL,NULL,1,'2023-06-10 09:47:38','2023-06-10 09:47:38',NULL),(5963,7922,40864,12312,3,4634,'App\\Models\\Receipt',4634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',270.00,NULL,NULL,1,'2023-06-10 09:47:38','2023-06-10 09:47:38',NULL),(5964,7922,40864,12313,3,4635,'App\\Models\\Receipt',4635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',13382.50,NULL,NULL,1,'2023-06-10 09:47:45','2023-06-10 09:47:45',NULL),(5965,7922,40864,12313,3,4636,'App\\Models\\Receipt',4636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',195.00,NULL,NULL,1,'2023-06-10 09:47:45','2023-06-10 09:47:45',NULL),(5966,7922,40864,12313,3,4637,'App\\Models\\Receipt',4637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',658.90,NULL,NULL,1,'2023-06-10 09:47:45','2023-06-10 09:47:45',NULL);
INSERT INTO `balance_libro` VALUES (5967,7922,40864,12313,3,4638,'App\\Models\\Receipt',4638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',666.00,NULL,NULL,1,'2023-06-10 09:47:45','2023-06-10 09:47:45',NULL),(5968,7922,40864,12314,3,4639,'App\\Models\\Receipt',4639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',5903.00,NULL,NULL,1,'2023-06-10 09:47:53','2023-06-10 09:47:53',NULL),(5969,7922,40864,12314,3,4640,'App\\Models\\Receipt',4640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',13500.01,NULL,NULL,1,'2023-06-10 09:47:53','2023-06-10 09:47:53',NULL),(5970,7922,40864,12314,3,4641,'App\\Models\\Receipt',4641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',13382.50,NULL,NULL,1,'2023-06-10 09:47:53','2023-06-10 09:47:53',NULL),(5971,7922,40864,12314,3,4642,'App\\Models\\Receipt',4642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',498.90,NULL,NULL,1,'2023-06-10 09:47:53','2023-06-10 09:47:53',NULL),(5972,7922,40864,12314,3,4643,'App\\Models\\Receipt',4643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2166.95,NULL,NULL,1,'2023-06-10 09:47:53','2023-06-10 09:47:53',NULL),(5973,7922,40864,12315,3,4644,'App\\Models\\Receipt',4644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',10862.50,NULL,NULL,1,'2023-06-10 09:48:00','2023-06-10 09:48:00',NULL),(5974,7922,40864,12315,3,4645,'App\\Models\\Receipt',4645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',8572.32,NULL,NULL,1,'2023-06-10 09:48:00','2023-06-10 09:48:00',NULL),(5975,7922,40864,12315,3,4646,'App\\Models\\Receipt',4646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',525.00,NULL,NULL,1,'2023-06-10 09:48:00','2023-06-10 09:48:00',NULL),(5976,7922,40864,12315,3,4647,'App\\Models\\Receipt',4647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',10000.00,NULL,NULL,1,'2023-06-10 09:48:00','2023-06-10 09:48:00',NULL),(5977,7922,40864,12315,3,4648,'App\\Models\\Receipt',4648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',599.00,NULL,NULL,1,'2023-06-10 09:48:00','2023-06-10 09:48:00',NULL),(5978,7922,40864,12315,3,4649,'App\\Models\\Receipt',4649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',27566.02,NULL,NULL,1,'2023-06-10 09:48:00','2023-06-10 09:48:00',NULL),(5979,7922,40864,12315,3,4650,'App\\Models\\Receipt',4650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',14306.25,NULL,NULL,1,'2023-06-10 09:48:00','2023-06-10 09:48:00',NULL),(5980,7922,40864,12315,3,4651,'App\\Models\\Receipt',4651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',2703.22,NULL,NULL,1,'2023-06-10 09:48:00','2023-06-10 09:48:00',NULL),(5981,7922,40864,12315,3,4652,'App\\Models\\Receipt',4652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',498.90,NULL,NULL,1,'2023-06-10 09:48:00','2023-06-10 09:48:00',NULL),(5982,7922,40864,12315,3,4653,'App\\Models\\Receipt',4653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',13622.58,NULL,NULL,1,'2023-06-10 09:48:00','2023-06-10 09:48:00',NULL),(5983,7922,40864,12315,3,4654,'App\\Models\\Receipt',4654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',540.00,NULL,NULL,1,'2023-06-10 09:48:00','2023-06-10 09:48:00',NULL),(5984,7922,40864,12316,3,4655,'App\\Models\\Receipt',4655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',5000.00,NULL,NULL,1,'2023-06-10 09:48:09','2023-06-10 09:48:09',NULL),(5985,7922,40864,12316,3,4656,'App\\Models\\Receipt',4656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',14838.31,NULL,NULL,1,'2023-06-10 09:48:09','2023-06-10 09:48:09',NULL),(5986,7922,40864,12316,3,4657,'App\\Models\\Receipt',4657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',25283.66,NULL,NULL,1,'2023-06-10 09:48:09','2023-06-10 09:48:09',NULL),(5987,7922,40864,12316,3,4658,'App\\Models\\Receipt',4658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',15230.00,NULL,NULL,1,'2023-06-10 09:48:09','2023-06-10 09:48:09',NULL);
INSERT INTO `balance_libro` VALUES (5988,7922,40864,12316,3,4659,'App\\Models\\Receipt',4659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',7400.00,NULL,NULL,1,'2023-06-10 09:48:09','2023-06-10 09:48:09',NULL),(5989,7922,40864,12316,3,4660,'App\\Models\\Receipt',4660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',2387.03,NULL,NULL,1,'2023-06-10 09:48:09','2023-06-10 09:48:09',NULL),(5990,7922,40864,12316,3,4661,'App\\Models\\Receipt',4661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',1320.48,NULL,NULL,1,'2023-06-10 09:48:09','2023-06-10 09:48:09',NULL),(5991,7922,40864,12316,3,4662,'App\\Models\\Receipt',4662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',498.90,NULL,NULL,1,'2023-06-10 09:48:09','2023-06-10 09:48:09',NULL),(5992,7922,40864,12316,3,4663,'App\\Models\\Receipt',4663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',360.00,NULL,NULL,1,'2023-06-10 09:48:10','2023-06-10 09:48:10',NULL),(5993,7922,40864,12323,3,4664,'App\\Models\\Receipt',4664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',7800.00,NULL,NULL,1,'2023-06-10 09:48:22','2023-06-10 09:48:22',NULL),(5994,7922,40864,12323,3,4665,'App\\Models\\Receipt',4665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',8800.00,NULL,NULL,1,'2023-06-10 09:48:22','2023-06-10 09:48:22',NULL),(5995,7922,40864,12323,3,4666,'App\\Models\\Receipt',4666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',5951.36,NULL,NULL,1,'2023-06-10 09:48:22','2023-06-10 09:48:22',NULL),(5996,7922,40864,12323,3,4667,'App\\Models\\Receipt',4667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',16481.00,NULL,NULL,1,'2023-06-10 09:48:22','2023-06-10 09:48:22',NULL),(5997,7922,40864,12323,3,4668,'App\\Models\\Receipt',4668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',498.90,NULL,NULL,1,'2023-06-10 09:48:22','2023-06-10 09:48:22',NULL),(5998,7922,40864,12323,3,4669,'App\\Models\\Receipt',4669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3060.00,NULL,NULL,1,'2023-06-10 09:48:22','2023-06-10 09:48:22',NULL),(5999,7922,40864,12324,3,4670,'App\\Models\\Receipt',4670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',10000.00,NULL,NULL,1,'2023-06-10 09:48:30','2023-06-10 09:48:30',NULL),(6000,7922,40864,12324,3,4671,'App\\Models\\Receipt',4671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',180000.00,NULL,NULL,1,'2023-06-10 09:48:30','2023-06-10 09:48:30',NULL),(6001,7922,40864,12324,3,4672,'App\\Models\\Receipt',4672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',30000.00,NULL,NULL,1,'2023-06-10 09:48:30','2023-06-10 09:48:30',NULL),(6002,7922,40864,12324,3,4673,'App\\Models\\Receipt',4673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',20000.00,NULL,NULL,1,'2023-06-10 09:48:30','2023-06-10 09:48:30',NULL),(6003,7922,40864,12324,3,4674,'App\\Models\\Receipt',4674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',17742.75,NULL,NULL,1,'2023-06-10 09:48:30','2023-06-10 09:48:30',NULL),(6004,7922,40864,12324,3,4675,'App\\Models\\Receipt',4675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',498.90,NULL,NULL,1,'2023-06-10 09:48:30','2023-06-10 09:48:30',NULL),(6005,7922,40864,12324,3,4676,'App\\Models\\Receipt',4676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3240.00,NULL,NULL,1,'2023-06-10 09:48:30','2023-06-10 09:48:30',NULL),(6006,7922,40864,12324,3,4677,'App\\Models\\Receipt',4677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',50000.00,NULL,NULL,1,'2023-06-10 09:48:30','2023-06-10 09:48:30',NULL),(6007,7922,40864,12325,3,4678,'App\\Models\\Receipt',4678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',13500.01,NULL,NULL,1,'2023-06-10 09:48:39','2023-06-10 09:48:39',NULL),(6008,7922,40864,12325,3,4679,'App\\Models\\Receipt',4679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',18100.00,NULL,NULL,1,'2023-06-10 09:48:39','2023-06-10 09:48:39',NULL);
INSERT INTO `balance_libro` VALUES (6009,7922,40864,12325,3,4680,'App\\Models\\Receipt',4680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',18161.50,NULL,NULL,1,'2023-06-10 09:48:39','2023-06-10 09:48:39',NULL),(6010,7922,40864,12325,3,4681,'App\\Models\\Receipt',4681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',498.90,NULL,NULL,1,'2023-06-10 09:48:39','2023-06-10 09:48:39',NULL),(6011,7922,40864,12325,3,4682,'App\\Models\\Receipt',4682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',315879.02,NULL,NULL,1,'2023-06-10 09:48:39','2023-06-10 09:48:39',NULL),(6012,7922,40864,12325,3,4683,'App\\Models\\Receipt',4683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3771.00,NULL,NULL,1,'2023-06-10 09:48:39','2023-06-10 09:48:39',NULL),(6013,7922,40864,12327,2,4684,'App\\Models\\Receipt',4684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',674760.00,NULL,NULL,1,'2023-06-10 09:55:54','2023-06-10 09:55:54',NULL),(6014,7922,40723,6065,2,4028,'App\\Models\\Receipt',4028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',317850.00,NULL,NULL,1,'2023-06-14 15:30:35','2023-06-14 15:30:35',NULL),(6015,7922,40723,6065,2,4032,'App\\Models\\Receipt',4032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',427253.11,NULL,NULL,1,'2023-06-14 15:32:42','2023-06-14 15:32:42',NULL),(6016,7922,40723,6065,2,4033,'App\\Models\\Receipt',4033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',370397.30,NULL,NULL,1,'2023-06-14 15:33:40','2023-06-14 15:33:40',NULL),(6017,7922,40723,6065,2,4035,'App\\Models\\Receipt',4035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',418637.00,NULL,NULL,1,'2023-06-15 15:48:13','2023-06-15 15:48:13',NULL),(6018,7922,40723,6065,2,4036,'App\\Models\\Receipt',4036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',574900.00,NULL,NULL,1,'2023-06-15 15:48:48','2023-06-15 15:48:48',NULL),(6019,7922,40723,6065,2,4038,'App\\Models\\Receipt',4038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',568074.12,NULL,NULL,1,'2023-06-15 15:49:35','2023-06-15 15:49:35',NULL),(6020,7922,40723,6065,2,4041,'App\\Models\\Receipt',4041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',291002.27,NULL,NULL,1,'2023-06-15 15:50:35','2023-06-15 15:50:35',NULL),(6021,7922,40723,6065,2,4047,'App\\Models\\Receipt',4047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',456527.50,NULL,NULL,1,'2023-06-15 15:51:10','2023-06-15 15:51:10',NULL),(6022,7922,40723,6065,2,4685,'App\\Models\\Receipt',4685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',428561.17,NULL,NULL,1,'2023-06-15 15:55:03','2023-06-15 15:55:03',NULL),(6023,7922,40723,6065,2,4686,'App\\Models\\Receipt',4686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',44314.00,NULL,NULL,1,'2023-06-15 15:55:40','2023-06-15 15:56:21','2023-06-15 15:56:21'),(6024,7922,40723,6065,2,4049,'App\\Models\\Receipt',4049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-21','2023-05-21',472072.00,NULL,NULL,1,'2023-06-15 15:57:12','2023-06-15 15:57:12',NULL),(6025,7922,40723,6065,2,4050,'App\\Models\\Receipt',4050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',525329.99,NULL,NULL,1,'2023-06-15 15:57:35','2023-06-15 15:57:35',NULL),(6026,7922,40723,6065,2,4053,'App\\Models\\Receipt',4053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',864729.73,NULL,NULL,1,'2023-06-15 15:58:43','2023-06-15 15:58:43',NULL),(6027,7922,40723,6065,2,4687,'App\\Models\\Receipt',4687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',694749.00,NULL,NULL,1,'2023-06-15 16:14:54','2023-06-15 16:14:54',NULL),(6028,7922,40723,6065,2,4688,'App\\Models\\Receipt',4688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',402031.56,NULL,NULL,1,'2023-06-15 16:15:35','2023-06-15 16:15:35',NULL);
INSERT INTO `balance_libro` VALUES (6029,7922,40723,6065,2,4689,'App\\Models\\Receipt',4689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',552757.93,NULL,NULL,1,'2023-06-15 16:16:17','2023-06-15 16:16:17',NULL),(6030,7922,40723,6065,2,4690,'App\\Models\\Receipt',4690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',460982.91,NULL,NULL,1,'2023-06-15 16:16:53','2023-06-15 16:16:53',NULL),(6031,7922,40723,6065,2,4691,'App\\Models\\Receipt',4691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',510200.00,NULL,NULL,1,'2023-06-15 16:18:19','2023-06-15 16:18:19',NULL),(6032,7922,40723,6065,2,4692,'App\\Models\\Receipt',4692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',619333.41,NULL,NULL,1,'2023-06-15 16:19:07','2023-06-15 16:19:07',NULL),(6033,7922,40723,6065,2,4693,'App\\Models\\Receipt',4693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',388931.08,NULL,NULL,1,'2023-06-15 16:19:58','2023-06-15 16:19:58',NULL),(6034,7922,40723,6065,2,4694,'App\\Models\\Receipt',4694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',336912.35,NULL,NULL,1,'2023-06-15 16:20:40','2023-06-15 16:20:40',NULL),(6035,7922,40723,6065,2,4695,'App\\Models\\Receipt',4695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',826597.92,NULL,NULL,1,'2023-06-15 16:21:16','2023-06-15 16:21:16',NULL),(6036,7922,40723,6065,2,4696,'App\\Models\\Receipt',4696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',376417.56,NULL,NULL,1,'2023-06-15 16:21:48','2023-06-15 16:21:48',NULL),(6037,7922,40723,6065,2,4697,'App\\Models\\Receipt',4697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',376417.56,NULL,NULL,1,'2023-06-15 16:28:19','2023-06-15 16:28:19',NULL),(6038,7922,40723,6065,2,4698,'App\\Models\\Receipt',4698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',263349.01,NULL,NULL,1,'2023-06-15 16:29:54','2023-06-15 16:29:54',NULL),(6039,7922,40723,6065,2,4699,'App\\Models\\Receipt',4699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',450206.00,NULL,NULL,1,'2023-06-15 16:30:32','2023-06-15 16:30:32',NULL),(6040,7922,40723,6065,2,4700,'App\\Models\\Receipt',4700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',612757.44,NULL,NULL,1,'2023-06-15 16:31:31','2023-06-15 16:31:31',NULL),(6041,7922,40723,6065,2,4701,'App\\Models\\Receipt',4701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',253691.25,NULL,NULL,1,'2023-06-15 16:32:10','2023-06-15 16:32:10',NULL),(6042,7922,40723,6065,2,4702,'App\\Models\\Receipt',4702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',281620.00,NULL,NULL,1,'2023-06-15 16:32:52','2023-06-15 16:32:52',NULL),(6043,7922,40723,6065,2,4703,'App\\Models\\Receipt',4703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',551047.18,NULL,NULL,1,'2023-06-15 16:35:38','2023-06-15 16:35:38',NULL),(6044,7922,40723,6065,2,4704,'App\\Models\\Receipt',4704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',385672.00,NULL,NULL,1,'2023-06-15 16:36:10','2023-06-15 16:36:10',NULL),(6045,7922,40723,6065,2,4705,'App\\Models\\Receipt',4705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',510942.45,NULL,NULL,1,'2023-06-15 16:36:58','2023-06-15 16:36:58',NULL),(6046,7922,40723,6065,2,4706,'App\\Models\\Receipt',4706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',423500.00,NULL,NULL,1,'2023-06-15 16:37:29','2023-06-15 16:37:29',NULL),(6047,7922,40723,6065,2,4707,'App\\Models\\Receipt',4707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',648500.03,NULL,NULL,1,'2023-06-15 16:40:00','2023-06-15 16:40:00',NULL),(6048,7922,40723,6065,2,4708,'App\\Models\\Receipt',4708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-21','2023-05-21',268496.75,NULL,NULL,1,'2023-06-15 16:40:48','2023-06-15 16:40:48',NULL),(6049,7922,40723,6065,2,4709,'App\\Models\\Receipt',4709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',344150.00,NULL,NULL,1,'2023-06-15 16:41:48','2023-06-15 16:41:48',NULL);
INSERT INTO `balance_libro` VALUES (6050,7922,40723,6065,2,4710,'App\\Models\\Receipt',4710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',447254.95,NULL,NULL,1,'2023-06-15 16:42:26','2023-06-15 16:42:26',NULL),(6051,7922,40723,6065,2,4711,'App\\Models\\Receipt',4711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',90826.01,NULL,NULL,1,'2023-06-15 16:43:02','2023-06-15 16:43:02',NULL),(6052,7922,40723,6065,2,4712,'App\\Models\\Receipt',4712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',214063.71,NULL,NULL,1,'2023-06-15 16:43:33','2023-06-15 16:43:33',NULL),(6053,7922,40723,6065,2,4713,'App\\Models\\Receipt',4713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',647600.00,NULL,NULL,1,'2023-06-15 16:44:23','2023-06-15 16:44:23',NULL),(6054,7922,40723,6065,2,4714,'App\\Models\\Receipt',4714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',516310.26,NULL,NULL,1,'2023-06-15 16:45:13','2023-06-15 16:45:13',NULL),(6055,7922,40723,6065,2,4715,'App\\Models\\Receipt',4715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',616809.10,NULL,NULL,1,'2023-06-15 16:45:50','2023-06-15 16:45:50',NULL),(6056,7922,40723,6065,2,4716,'App\\Models\\Receipt',4716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',0.02,NULL,NULL,1,'2023-06-15 16:47:59','2023-06-15 16:47:59',NULL),(6057,7922,40723,6065,2,4717,'App\\Models\\Receipt',4717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',551390.01,NULL,NULL,1,'2023-06-15 16:48:29','2023-06-15 16:48:29',NULL),(6058,7922,40723,6065,2,4718,'App\\Models\\Receipt',4718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',176830.00,NULL,NULL,1,'2023-06-15 16:49:18','2023-06-15 16:49:18',NULL),(6059,7922,40759,10724,2,4719,'App\\Models\\Receipt',4719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',35651.00,NULL,NULL,1,'2023-06-20 09:45:09','2023-06-20 09:45:09',NULL),(6060,7922,40759,10724,2,4720,'App\\Models\\Receipt',4720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',279110.02,NULL,NULL,1,'2023-06-20 09:45:09','2023-06-20 09:45:09',NULL),(6061,7922,40759,10724,3,4721,'App\\Models\\Receipt',4721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',6300.00,NULL,NULL,1,'2023-06-20 09:45:18','2023-06-20 09:45:18',NULL),(6062,7922,40759,10724,3,4722,'App\\Models\\Receipt',4722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',2639.65,NULL,NULL,1,'2023-06-20 09:45:18','2023-06-20 09:45:18',NULL),(6063,7922,40759,10724,3,4723,'App\\Models\\Receipt',4723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',3192.00,NULL,NULL,1,'2023-06-20 09:45:18','2023-06-20 09:45:18',NULL),(6064,7922,40759,10724,3,4724,'App\\Models\\Receipt',4724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',380.00,NULL,NULL,1,'2023-06-20 09:45:18','2023-06-20 09:45:18',NULL),(6065,7922,40759,10724,3,4725,'App\\Models\\Receipt',4725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',1985.00,NULL,NULL,1,'2023-06-20 09:45:18','2023-06-20 09:45:18',NULL),(6066,7922,40759,10724,3,4726,'App\\Models\\Receipt',4726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',13500.10,NULL,NULL,1,'2023-06-20 09:45:18','2023-06-20 09:45:18',NULL),(6067,7922,40759,10724,3,4727,'App\\Models\\Receipt',4727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',9200.04,NULL,NULL,1,'2023-06-20 09:45:18','2023-06-20 09:45:18',NULL),(6068,7922,40759,10724,3,4728,'App\\Models\\Receipt',4728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',120516.00,NULL,NULL,1,'2023-06-20 09:45:18','2023-06-20 09:45:18',NULL),(6069,7922,40759,10724,3,4729,'App\\Models\\Receipt',4729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',3741.75,NULL,NULL,1,'2023-06-20 09:45:18','2023-06-20 09:45:18',NULL),(6070,7922,40759,10724,3,4730,'App\\Models\\Receipt',4730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',2077.90,NULL,NULL,1,'2023-06-20 09:45:18','2023-06-20 09:45:18',NULL);
INSERT INTO `balance_libro` VALUES (6071,7922,40759,10724,3,4731,'App\\Models\\Receipt',4731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',1017.60,NULL,NULL,1,'2023-06-20 09:45:19','2023-06-20 09:45:19',NULL),(6072,7922,40759,10724,3,4732,'App\\Models\\Receipt',4732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',2380.00,NULL,NULL,1,'2023-06-20 09:45:19','2023-06-20 09:45:19',NULL),(6073,7922,40759,10724,15,571,'App\\Models\\PeriodLiquidation',NULL,571,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',54627.94,NULL,NULL,1,'2023-06-20 09:59:25','2023-06-20 09:59:25',NULL),(6074,7922,40759,10724,16,572,'App\\Models\\PeriodLiquidation',NULL,572,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',7803.99,NULL,NULL,1,'2023-06-20 10:02:17','2023-06-20 10:02:17',NULL),(6075,7922,40759,10723,16,366,'App\\Models\\PeriodLiquidation',NULL,366,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',0.00,NULL,NULL,1,'2023-06-20 10:02:36','2023-06-20 10:02:36',NULL),(6076,7922,40721,3037,3,4733,'App\\Models\\Receipt',4733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',670.00,NULL,NULL,1,'2023-06-22 16:32:40','2023-06-22 16:32:40',NULL),(6077,7922,40721,3037,3,4734,'App\\Models\\Receipt',4734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',40000.00,NULL,NULL,1,'2023-06-22 16:32:40','2023-06-22 16:32:40',NULL),(6078,7922,40721,3037,3,4735,'App\\Models\\Receipt',4735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',2905.37,NULL,NULL,1,'2023-06-22 16:32:40','2023-06-22 16:32:40',NULL),(6079,7922,40721,3037,3,4736,'App\\Models\\Receipt',4736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',78999.99,NULL,NULL,1,'2023-06-22 16:32:40','2023-06-22 16:32:40',NULL),(6080,7922,40721,3037,3,4737,'App\\Models\\Receipt',4737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',25900.00,NULL,NULL,1,'2023-06-22 16:32:40','2023-06-22 16:32:40',NULL),(6081,7922,40721,3037,3,4738,'App\\Models\\Receipt',4738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',40000.00,NULL,NULL,1,'2023-06-22 16:32:40','2023-06-22 16:32:40',NULL),(6082,7922,40721,3037,3,4739,'App\\Models\\Receipt',4739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',48000.00,NULL,NULL,1,'2023-06-22 16:32:40','2023-06-22 16:32:40',NULL),(6083,7922,40721,3037,3,4740,'App\\Models\\Receipt',4740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',3706.99,NULL,NULL,1,'2023-06-22 16:32:40','2023-06-22 16:32:40',NULL),(6084,7922,40721,3037,3,4741,'App\\Models\\Receipt',4741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',9722.59,NULL,NULL,1,'2023-06-22 16:32:40','2023-06-22 16:32:40',NULL),(6085,7922,40721,3037,3,4742,'App\\Models\\Receipt',4742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',70874.71,NULL,NULL,1,'2023-06-22 16:32:40','2023-06-22 16:32:40',NULL),(6086,7922,40721,3037,3,4743,'App\\Models\\Receipt',4743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',232629.76,NULL,NULL,1,'2023-06-22 16:32:40','2023-06-22 16:32:40',NULL),(6087,7922,40721,3037,3,4744,'App\\Models\\Receipt',4744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',1242.01,NULL,NULL,1,'2023-06-22 16:32:40','2023-06-22 16:32:40',NULL),(6088,7922,40721,3037,3,4745,'App\\Models\\Receipt',4745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',0.00,NULL,NULL,1,'2023-06-22 16:32:40','2023-06-22 16:32:40',NULL),(6089,7922,40721,3037,3,4746,'App\\Models\\Receipt',4746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',0.00,NULL,NULL,1,'2023-06-22 16:32:40','2023-06-22 16:32:40',NULL),(6090,7922,40721,3037,3,4747,'App\\Models\\Receipt',4747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',0.00,NULL,NULL,1,'2023-06-22 16:32:40','2023-06-22 16:32:40',NULL),(6091,7922,40721,3037,3,4748,'App\\Models\\Receipt',4748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',3520.00,NULL,NULL,1,'2023-06-22 16:32:40','2023-06-22 16:32:40',NULL);
INSERT INTO `balance_libro` VALUES (6092,7922,40721,3037,3,4749,'App\\Models\\Receipt',4749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',20211.84,NULL,NULL,1,'2023-06-22 16:32:41','2023-06-22 16:32:41',NULL),(6093,7922,40721,3037,3,4750,'App\\Models\\Receipt',4750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',826.00,NULL,NULL,1,'2023-06-22 16:32:41','2023-06-22 16:32:41',NULL),(6094,7922,40721,3037,3,4751,'App\\Models\\Receipt',4751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',1242.01,NULL,NULL,1,'2023-06-22 16:32:41','2023-06-22 16:32:41',NULL),(6095,7922,40721,3037,3,4752,'App\\Models\\Receipt',4752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',804046.00,NULL,NULL,1,'2023-06-22 16:32:41','2023-06-22 16:32:41',NULL),(6096,7922,40721,3037,3,4753,'App\\Models\\Receipt',4753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',826.00,NULL,NULL,1,'2023-06-22 16:32:41','2023-06-22 16:32:41',NULL),(6097,7922,40721,3037,3,4754,'App\\Models\\Receipt',4754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',232629.76,NULL,NULL,1,'2023-06-22 16:32:41','2023-06-22 16:32:41',NULL),(6098,7922,40721,3037,3,4755,'App\\Models\\Receipt',4755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',188306.90,NULL,NULL,1,'2023-06-22 16:32:41','2023-06-22 16:32:41',NULL),(6099,7922,40721,3037,3,4756,'App\\Models\\Receipt',4756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',135850.80,NULL,NULL,1,'2023-06-22 16:32:41','2023-06-22 16:32:41',NULL),(6100,7922,40721,3037,3,4757,'App\\Models\\Receipt',4757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',107833.91,NULL,NULL,1,'2023-06-22 16:32:41','2023-06-22 16:32:41',NULL),(6101,7922,40721,3037,3,4758,'App\\Models\\Receipt',4758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',246832.77,NULL,NULL,1,'2023-06-22 16:32:41','2023-06-22 16:32:41',NULL),(6102,7922,40721,3037,3,4759,'App\\Models\\Receipt',4759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',33600.00,NULL,NULL,1,'2023-06-22 16:32:41','2023-06-22 16:32:41',NULL),(6103,7922,40721,3037,3,4760,'App\\Models\\Receipt',4760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',1689.97,NULL,NULL,1,'2023-06-22 16:32:41','2023-06-22 16:32:41',NULL),(6104,7922,40721,3037,3,4761,'App\\Models\\Receipt',4761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',849.99,NULL,NULL,1,'2023-06-22 16:32:41','2023-06-22 16:32:41',NULL),(6105,7922,40721,3037,3,4762,'App\\Models\\Receipt',4762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',50450.00,NULL,NULL,1,'2023-06-22 16:32:41','2023-06-22 16:32:41',NULL),(6106,7922,40721,3037,3,4763,'App\\Models\\Receipt',4763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',650.00,NULL,NULL,1,'2023-06-22 16:32:42','2023-06-22 16:32:42',NULL),(6107,7922,40721,3037,3,4764,'App\\Models\\Receipt',4764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',826.00,NULL,NULL,1,'2023-06-22 16:32:42','2023-06-22 16:32:42',NULL),(6108,7922,40721,3037,3,4765,'App\\Models\\Receipt',4765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',39697.80,NULL,NULL,1,'2023-06-22 16:32:42','2023-06-22 16:32:42',NULL),(6109,7922,40721,3037,3,4766,'App\\Models\\Receipt',4766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',9500.00,NULL,NULL,1,'2023-06-22 16:32:42','2023-06-22 16:32:42',NULL),(6110,7922,40721,3037,3,4767,'App\\Models\\Receipt',4767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',11305.00,NULL,NULL,1,'2023-06-22 16:32:42','2023-06-22 16:32:42',NULL),(6111,7922,40721,3037,3,4768,'App\\Models\\Receipt',4768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',9075.00,NULL,NULL,1,'2023-06-22 16:32:42','2023-06-22 16:32:42',NULL),(6112,7922,40721,3037,3,4769,'App\\Models\\Receipt',4769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',1726.01,NULL,NULL,1,'2023-06-22 16:32:42','2023-06-22 16:32:42',NULL);
INSERT INTO `balance_libro` VALUES (6113,7922,40721,3037,3,4770,'App\\Models\\Receipt',4770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',1173.00,NULL,NULL,1,'2023-06-22 16:32:42','2023-06-22 16:32:42',NULL),(6114,7922,40721,3037,3,4771,'App\\Models\\Receipt',4771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-30','2022-01-30',450.91,NULL,NULL,1,'2023-06-22 16:32:42','2023-06-22 16:32:42',NULL),(6115,7922,40721,3037,3,4772,'App\\Models\\Receipt',4772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',216.00,NULL,NULL,1,'2023-06-22 16:32:42','2023-06-22 16:32:42',NULL),(6116,7922,40721,3037,3,4773,'App\\Models\\Receipt',4773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',5292.00,NULL,NULL,1,'2023-06-22 16:32:42','2023-06-22 16:32:42',NULL),(6117,7922,40721,3037,3,4774,'App\\Models\\Receipt',4774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',804046.00,NULL,NULL,1,'2023-06-22 16:32:42','2023-06-22 16:32:42',NULL),(6118,7922,40721,3037,3,4775,'App\\Models\\Receipt',4775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1412.06,NULL,NULL,1,'2023-06-22 16:32:42','2023-06-22 16:32:42',NULL),(6119,7922,40721,3038,3,4776,'App\\Models\\Receipt',4776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',48000.00,NULL,NULL,1,'2023-06-22 16:33:13','2023-06-22 16:33:13',NULL),(6120,7922,40721,3038,3,4777,'App\\Models\\Receipt',4777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',670.00,NULL,NULL,1,'2023-06-22 16:33:13','2023-06-22 16:33:13',NULL),(6121,7922,40721,3038,3,4778,'App\\Models\\Receipt',4778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',12073.23,NULL,NULL,1,'2023-06-22 16:33:13','2023-06-22 16:33:13',NULL),(6122,7922,40721,3038,3,4779,'App\\Models\\Receipt',4779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',2640.00,NULL,NULL,1,'2023-06-22 16:33:13','2023-06-22 16:33:13',NULL),(6123,7922,40721,3038,3,4780,'App\\Models\\Receipt',4780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',14833.46,NULL,NULL,1,'2023-06-22 16:33:13','2023-06-22 16:33:13',NULL),(6124,7922,40721,3038,3,4781,'App\\Models\\Receipt',4781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',13623.39,NULL,NULL,1,'2023-06-22 16:33:13','2023-06-22 16:33:13',NULL),(6125,7922,40721,3038,3,4782,'App\\Models\\Receipt',4782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',5577.41,NULL,NULL,1,'2023-06-22 16:33:13','2023-06-22 16:33:13',NULL),(6126,7922,40721,3038,3,4783,'App\\Models\\Receipt',4783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',14833.46,NULL,NULL,1,'2023-06-22 16:33:13','2023-06-22 16:33:13',NULL),(6127,7922,40721,3038,3,4784,'App\\Models\\Receipt',4784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',1176.12,NULL,NULL,1,'2023-06-22 16:33:13','2023-06-22 16:33:13',NULL),(6128,7922,40721,3038,3,4785,'App\\Models\\Receipt',4785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',4897.82,NULL,NULL,1,'2023-06-22 16:33:13','2023-06-22 16:33:13',NULL),(6129,7922,40721,3038,3,4786,'App\\Models\\Receipt',4786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',5577.41,NULL,NULL,1,'2023-06-22 16:33:13','2023-06-22 16:33:13',NULL),(6130,7922,40721,3038,3,4787,'App\\Models\\Receipt',4787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',21749.99,NULL,NULL,1,'2023-06-22 16:33:13','2023-06-22 16:33:13',NULL),(6131,7922,40721,3038,3,4788,'App\\Models\\Receipt',4788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',9000.00,NULL,NULL,1,'2023-06-22 16:33:13','2023-06-22 16:33:13',NULL),(6132,7922,40721,3038,3,4789,'App\\Models\\Receipt',4789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',3388.82,NULL,NULL,1,'2023-06-22 16:33:13','2023-06-22 16:33:13',NULL),(6133,7922,40721,3038,3,4790,'App\\Models\\Receipt',4790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',20211.84,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL);
INSERT INTO `balance_libro` VALUES (6134,7922,40721,3038,3,4791,'App\\Models\\Receipt',4791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',36871.64,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL),(6135,7922,40721,3038,3,4792,'App\\Models\\Receipt',4792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',1173.00,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL),(6136,7922,40721,3038,3,4793,'App\\Models\\Receipt',4793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',4749.99,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL),(6137,7922,40721,3038,3,4794,'App\\Models\\Receipt',4794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',0.00,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL),(6138,7922,40721,3038,3,4795,'App\\Models\\Receipt',4795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',0.00,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL),(6139,7922,40721,3038,3,4796,'App\\Models\\Receipt',4796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',0.00,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL),(6140,7922,40721,3038,3,4797,'App\\Models\\Receipt',4797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',2870.00,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL),(6141,7922,40721,3038,3,4798,'App\\Models\\Receipt',4798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',14471.60,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL),(6142,7922,40721,3038,3,4799,'App\\Models\\Receipt',4799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',37972.85,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL),(6143,7922,40721,3038,3,4800,'App\\Models\\Receipt',4800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',32.43,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL),(6144,7922,40721,3038,3,4801,'App\\Models\\Receipt',4801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',188.95,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL),(6145,7922,40721,3038,3,4802,'App\\Models\\Receipt',4802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',777.01,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL),(6146,7922,40721,3038,3,4803,'App\\Models\\Receipt',4803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',519.25,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL),(6147,7922,40721,3038,3,4804,'App\\Models\\Receipt',4804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',601.44,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL),(6148,7922,40721,3038,3,4805,'App\\Models\\Receipt',4805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',1479.81,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL),(6149,7922,40721,3038,3,4806,'App\\Models\\Receipt',4806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',346.06,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL),(6150,7922,40721,3038,3,4807,'App\\Models\\Receipt',4807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',1345.36,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL),(6151,7922,40721,3038,3,4808,'App\\Models\\Receipt',4808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',1868.08,NULL,NULL,1,'2023-06-22 16:33:14','2023-06-22 16:33:14',NULL),(6152,7922,40721,3038,3,4809,'App\\Models\\Receipt',4809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',3146.99,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6153,7922,40721,3038,3,4810,'App\\Models\\Receipt',4810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',686.22,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6154,7922,40721,3038,3,4811,'App\\Models\\Receipt',4811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',10270.00,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL);
INSERT INTO `balance_libro` VALUES (6155,7922,40721,3038,3,4812,'App\\Models\\Receipt',4812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',500.00,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6156,7922,40721,3038,3,4813,'App\\Models\\Receipt',4813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',20600.00,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6157,7922,40721,3038,3,4814,'App\\Models\\Receipt',4814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',29949.77,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6158,7922,40721,3038,3,4815,'App\\Models\\Receipt',4815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',5600.00,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6159,7922,40721,3038,3,4816,'App\\Models\\Receipt',4816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',112211.61,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6160,7922,40721,3038,3,4817,'App\\Models\\Receipt',4817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',3959.97,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6161,7922,40721,3038,3,4818,'App\\Models\\Receipt',4818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',1598.98,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6162,7922,40721,3038,3,4819,'App\\Models\\Receipt',4819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',1172.01,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6163,7922,40721,3038,3,4820,'App\\Models\\Receipt',4820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',429.00,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6164,7922,40721,3038,3,4821,'App\\Models\\Receipt',4821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',179721.12,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6165,7922,40721,3038,3,4822,'App\\Models\\Receipt',4822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',112890.00,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6166,7922,40721,3038,3,4823,'App\\Models\\Receipt',4823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',377520.00,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6167,7922,40721,3038,3,4824,'App\\Models\\Receipt',4824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',3399.95,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6168,7922,40721,3038,3,4825,'App\\Models\\Receipt',4825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',1173.00,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6169,7922,40721,3038,3,4826,'App\\Models\\Receipt',4826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1197.00,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6170,7922,40721,3038,3,4827,'App\\Models\\Receipt',4827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',3944.00,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6171,7922,40721,3038,3,4828,'App\\Models\\Receipt',4828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',6881.93,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6172,7922,40721,3038,3,4829,'App\\Models\\Receipt',4829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',650.00,NULL,NULL,1,'2023-06-22 16:33:15','2023-06-22 16:33:15',NULL),(6173,7922,40721,3039,3,4830,'App\\Models\\Receipt',4830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',670.00,NULL,NULL,1,'2023-06-22 16:33:30','2023-06-22 16:33:30',NULL),(6174,7922,40721,3039,3,4831,'App\\Models\\Receipt',4831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',9800.00,NULL,NULL,1,'2023-06-22 16:33:30','2023-06-22 16:33:30',NULL),(6175,7922,40721,3039,3,4832,'App\\Models\\Receipt',4832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1014.01,NULL,NULL,1,'2023-06-22 16:33:30','2023-06-22 16:33:30',NULL);
INSERT INTO `balance_libro` VALUES (6176,7922,40721,3039,3,4833,'App\\Models\\Receipt',4833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',2319.00,NULL,NULL,1,'2023-06-22 16:33:30','2023-06-22 16:33:30',NULL),(6177,7922,40721,3039,3,4834,'App\\Models\\Receipt',4834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',146000.00,NULL,NULL,1,'2023-06-22 16:33:30','2023-06-22 16:33:30',NULL),(6178,7922,40721,3039,3,4835,'App\\Models\\Receipt',4835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1740.00,NULL,NULL,1,'2023-06-22 16:33:30','2023-06-22 16:33:30',NULL),(6179,7922,40721,3039,3,4836,'App\\Models\\Receipt',4836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1500.00,NULL,NULL,1,'2023-06-22 16:33:30','2023-06-22 16:33:30',NULL),(6180,7922,40721,3039,3,4837,'App\\Models\\Receipt',4837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',125840.00,NULL,NULL,1,'2023-06-22 16:33:30','2023-06-22 16:33:30',NULL),(6181,7922,40721,3039,3,4838,'App\\Models\\Receipt',4838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2450.00,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6182,7922,40721,3039,3,4839,'App\\Models\\Receipt',4839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2090.12,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6183,7922,40721,3039,3,4840,'App\\Models\\Receipt',4840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',36179.96,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6184,7922,40721,3039,3,4841,'App\\Models\\Receipt',4841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1181.00,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6185,7922,40721,3039,3,4842,'App\\Models\\Receipt',4842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',48000.00,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6186,7922,40721,3039,3,4843,'App\\Models\\Receipt',4843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',3620.32,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6187,7922,40721,3039,3,4844,'App\\Models\\Receipt',4844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',16680.00,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6188,7922,40721,3039,3,4845,'App\\Models\\Receipt',4845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',2520.00,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6189,7922,40721,3039,3,4846,'App\\Models\\Receipt',4846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',8780.77,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6190,7922,40721,3039,3,4847,'App\\Models\\Receipt',4847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1500.00,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6191,7922,40721,3039,3,4848,'App\\Models\\Receipt',4848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',4357.42,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6192,7922,40721,3039,3,4849,'App\\Models\\Receipt',4849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',13859.99,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6193,7922,40721,3039,3,4850,'App\\Models\\Receipt',4850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',315572.16,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6194,7922,40721,3039,3,4851,'App\\Models\\Receipt',4851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',60000.00,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6195,7922,40721,3039,3,4852,'App\\Models\\Receipt',4852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',169400.00,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6196,7922,40721,3039,3,4853,'App\\Models\\Receipt',4853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',0.00,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL);
INSERT INTO `balance_libro` VALUES (6197,7922,40721,3039,3,4854,'App\\Models\\Receipt',4854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',0.00,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6198,7922,40721,3039,3,4855,'App\\Models\\Receipt',4855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',0.00,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6199,7922,40721,3039,3,4856,'App\\Models\\Receipt',4856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',140309.15,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6200,7922,40721,3039,3,4857,'App\\Models\\Receipt',4857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',225506.81,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6201,7922,40721,3039,3,4858,'App\\Models\\Receipt',4858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',92925.27,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6202,7922,40721,3039,3,4859,'App\\Models\\Receipt',4859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1850.08,NULL,NULL,1,'2023-06-22 16:33:31','2023-06-22 16:33:31',NULL),(6203,7922,40721,3039,3,4860,'App\\Models\\Receipt',4860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',30852.64,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL),(6204,7922,40721,3039,3,4861,'App\\Models\\Receipt',4861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',13414.67,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL),(6205,7922,40721,3039,3,4862,'App\\Models\\Receipt',4862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1462.49,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL),(6206,7922,40721,3039,3,4863,'App\\Models\\Receipt',4863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',38868.70,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL),(6207,7922,40721,3039,3,4864,'App\\Models\\Receipt',4864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',2640.00,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL),(6208,7922,40721,3039,3,4865,'App\\Models\\Receipt',4865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',17453.34,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL),(6209,7922,40721,3039,3,4866,'App\\Models\\Receipt',4866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',1157.00,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL),(6210,7922,40721,3039,3,4867,'App\\Models\\Receipt',4867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',23728.68,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL),(6211,7922,40721,3039,3,4868,'App\\Models\\Receipt',4868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',33532.22,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL),(6212,7922,40721,3039,3,4869,'App\\Models\\Receipt',4869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',19460.00,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL),(6213,7922,40721,3039,3,4870,'App\\Models\\Receipt',4870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',826.00,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL),(6214,7922,40721,3039,3,4871,'App\\Models\\Receipt',4871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',47938.52,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL),(6215,7922,40721,3039,3,4872,'App\\Models\\Receipt',4872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',826.00,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL),(6216,7922,40721,3039,3,4873,'App\\Models\\Receipt',4873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',1417.00,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL),(6217,7922,40721,3039,3,4874,'App\\Models\\Receipt',4874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',9273.36,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL);
INSERT INTO `balance_libro` VALUES (6218,7922,40721,3039,3,4875,'App\\Models\\Receipt',4875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',22117.15,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL),(6219,7922,40721,3039,3,4876,'App\\Models\\Receipt',4876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',46541.26,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL),(6220,7922,40721,3039,3,4877,'App\\Models\\Receipt',4877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',103123.86,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL),(6221,7922,40721,3039,3,4878,'App\\Models\\Receipt',4878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',28682.26,NULL,NULL,1,'2023-06-22 16:33:32','2023-06-22 16:33:32',NULL),(6222,7922,40721,3039,3,4879,'App\\Models\\Receipt',4879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',62238.13,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL),(6223,7922,40721,3039,3,4880,'App\\Models\\Receipt',4880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',29539.40,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL),(6224,7922,40721,3039,3,4881,'App\\Models\\Receipt',4881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',42822.57,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL),(6225,7922,40721,3039,3,4882,'App\\Models\\Receipt',4882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',13940.41,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL),(6226,7922,40721,3039,3,4883,'App\\Models\\Receipt',4883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',5805.02,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL),(6227,7922,40721,3039,3,4884,'App\\Models\\Receipt',4884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',10242.94,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL),(6228,7922,40721,3039,3,4885,'App\\Models\\Receipt',4885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',61272.20,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL),(6229,7922,40721,3039,3,4886,'App\\Models\\Receipt',4886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',23590.69,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL),(6230,7922,40721,3039,3,4887,'App\\Models\\Receipt',4887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',232344.58,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL),(6231,7922,40721,3039,3,4888,'App\\Models\\Receipt',4888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',13970.66,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL),(6232,7922,40721,3039,3,4889,'App\\Models\\Receipt',4889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',2476.42,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL),(6233,7922,40721,3039,3,4890,'App\\Models\\Receipt',4890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1597.20,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL),(6234,7922,40721,3039,3,4891,'App\\Models\\Receipt',4891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1854.00,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL),(6235,7922,40721,3039,3,4892,'App\\Models\\Receipt',4892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2952.00,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL),(6236,7922,40721,3039,3,4893,'App\\Models\\Receipt',4893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',6902.61,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL),(6237,7922,40721,3039,3,4894,'App\\Models\\Receipt',4894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',10190.00,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL),(6238,7922,40721,3039,3,4895,'App\\Models\\Receipt',4895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',32164.50,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL);
INSERT INTO `balance_libro` VALUES (6239,7922,40721,3039,3,4896,'App\\Models\\Receipt',4896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',650.00,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL),(6240,7922,40721,3039,3,4897,'App\\Models\\Receipt',4897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1182.00,NULL,NULL,1,'2023-06-22 16:33:33','2023-06-22 16:33:33',NULL),(6241,7922,40721,3039,3,4898,'App\\Models\\Receipt',4898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',8425.80,NULL,NULL,1,'2023-06-22 16:33:34','2023-06-22 16:33:34',NULL),(6242,7922,40721,3040,3,4899,'App\\Models\\Receipt',4899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',800.00,NULL,NULL,1,'2023-06-22 16:33:45','2023-06-22 16:33:45',NULL),(6243,7922,40721,3040,3,4900,'App\\Models\\Receipt',4900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',24999.99,NULL,NULL,1,'2023-06-22 16:33:45','2023-06-22 16:33:45',NULL),(6244,7922,40721,3040,3,4901,'App\\Models\\Receipt',4901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',174871.56,NULL,NULL,1,'2023-06-22 16:33:45','2023-06-22 16:33:45',NULL),(6245,7922,40721,3040,3,4902,'App\\Models\\Receipt',4902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',561246.40,NULL,NULL,1,'2023-06-22 16:33:45','2023-06-22 16:33:45',NULL),(6246,7922,40721,3040,3,4903,'App\\Models\\Receipt',4903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',10306.57,NULL,NULL,1,'2023-06-22 16:33:45','2023-06-22 16:33:45',NULL),(6247,7922,40721,3040,3,4904,'App\\Models\\Receipt',4904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',18626.83,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6248,7922,40721,3040,3,4905,'App\\Models\\Receipt',4905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',15990.73,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6249,7922,40721,3040,3,4906,'App\\Models\\Receipt',4906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',1157.00,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6250,7922,40721,3040,3,4907,'App\\Models\\Receipt',4907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',56822.08,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6251,7922,40721,3040,3,4908,'App\\Models\\Receipt',4908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',1562.00,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6252,7922,40721,3040,3,4909,'App\\Models\\Receipt',4909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',1877.19,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6253,7922,40721,3040,3,4910,'App\\Models\\Receipt',4910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',21137.34,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6254,7922,40721,3040,3,4911,'App\\Models\\Receipt',4911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',57600.00,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6255,7922,40721,3040,3,4912,'App\\Models\\Receipt',4912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',75500.00,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6256,7922,40721,3040,3,4913,'App\\Models\\Receipt',4913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-10','2022-04-10',0.00,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6257,7922,40721,3040,3,4914,'App\\Models\\Receipt',4914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-10','2022-04-10',0.00,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6258,7922,40721,3040,3,4915,'App\\Models\\Receipt',4915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-10','2022-04-10',0.00,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6259,7922,40721,3040,3,4916,'App\\Models\\Receipt',4916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',21833.24,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL);
INSERT INTO `balance_libro` VALUES (6260,7922,40721,3040,3,4917,'App\\Models\\Receipt',4917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',145.20,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6261,7922,40721,3040,3,4918,'App\\Models\\Receipt',4918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',20211.84,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6262,7922,40721,3040,3,4919,'App\\Models\\Receipt',4919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',3423.82,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6263,7922,40721,3040,3,4920,'App\\Models\\Receipt',4920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',66407.95,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6264,7922,40721,3040,3,4921,'App\\Models\\Receipt',4921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',16335.00,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6265,7922,40721,3040,3,4922,'App\\Models\\Receipt',4922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',16335.00,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6266,7922,40721,3040,3,4923,'App\\Models\\Receipt',4923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',16335.00,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6267,7922,40721,3040,3,4924,'App\\Models\\Receipt',4924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',1056.86,NULL,NULL,1,'2023-06-22 16:33:46','2023-06-22 16:33:46',NULL),(6268,7922,40721,3040,3,4925,'App\\Models\\Receipt',4925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',2920.66,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6269,7922,40721,3040,3,4926,'App\\Models\\Receipt',4926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',1358.01,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6270,7922,40721,3040,3,4927,'App\\Models\\Receipt',4927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',826.01,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6271,7922,40721,3040,3,4928,'App\\Models\\Receipt',4928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',14597.00,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6272,7922,40721,3040,3,4929,'App\\Models\\Receipt',4929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',1849.00,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6273,7922,40721,3040,3,4930,'App\\Models\\Receipt',4930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',39641.65,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6274,7922,40721,3040,3,4931,'App\\Models\\Receipt',4931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',60332.11,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6275,7922,40721,3040,3,4932,'App\\Models\\Receipt',4932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',60332.11,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6276,7922,40721,3040,3,4933,'App\\Models\\Receipt',4933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',378367.00,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6277,7922,40721,3040,3,4934,'App\\Models\\Receipt',4934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',7400.00,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6278,7922,40721,3040,3,4935,'App\\Models\\Receipt',4935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',6000.00,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6279,7922,40721,3040,3,4936,'App\\Models\\Receipt',4936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',1911.00,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6280,7922,40721,3040,3,4937,'App\\Models\\Receipt',4937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',4928.00,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL);
INSERT INTO `balance_libro` VALUES (6281,7922,40721,3040,3,4938,'App\\Models\\Receipt',4938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',9500.00,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6282,7922,40721,3040,3,4939,'App\\Models\\Receipt',4939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',8017.59,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6283,7922,40721,3040,3,4940,'App\\Models\\Receipt',4940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',3781.04,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6284,7922,40721,3040,3,4941,'App\\Models\\Receipt',4941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',3734.96,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6285,7922,40721,3040,3,4942,'App\\Models\\Receipt',4942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',4347.53,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6286,7922,40721,3040,3,4943,'App\\Models\\Receipt',4943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',4928.00,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6287,7922,40721,3040,3,4944,'App\\Models\\Receipt',4944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',6000.00,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6288,7922,40721,3040,3,4945,'App\\Models\\Receipt',4945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',6000.00,NULL,NULL,1,'2023-06-22 16:33:47','2023-06-22 16:33:47',NULL),(6289,7922,40721,3040,3,4946,'App\\Models\\Receipt',4946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',6000.00,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6290,7922,40721,3040,3,4947,'App\\Models\\Receipt',4947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',6000.00,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6291,7922,40721,3040,3,4948,'App\\Models\\Receipt',4948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',6180.20,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6292,7922,40721,3040,3,4949,'App\\Models\\Receipt',4949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',10285.00,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6293,7922,40721,3040,3,4950,'App\\Models\\Receipt',4950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',7400.00,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6294,7922,40721,3040,3,4951,'App\\Models\\Receipt',4951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',43318.00,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6295,7922,40721,3040,3,4952,'App\\Models\\Receipt',4952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',53708.27,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6296,7922,40721,3040,3,4953,'App\\Models\\Receipt',4953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',8090.00,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6297,7922,40721,3040,3,4954,'App\\Models\\Receipt',4954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',1300.00,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6298,7922,40721,3040,3,4955,'App\\Models\\Receipt',4955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',14934.92,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6299,7922,40721,3040,3,4956,'App\\Models\\Receipt',4956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',400.00,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6300,7922,40721,3040,3,4957,'App\\Models\\Receipt',4957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',6450.63,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6301,7922,40721,3040,3,4958,'App\\Models\\Receipt',4958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',23129.97,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL);
INSERT INTO `balance_libro` VALUES (6302,7922,40721,3040,3,4959,'App\\Models\\Receipt',4959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',6419.99,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6303,7922,40721,3040,3,4960,'App\\Models\\Receipt',4960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',2800.00,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6304,7922,40721,3040,3,4961,'App\\Models\\Receipt',4961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',60066.24,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6305,7922,40721,3040,3,4962,'App\\Models\\Receipt',4962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',32877.76,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6306,7922,40721,3040,3,4963,'App\\Models\\Receipt',4963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',34848.13,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6307,7922,40721,3040,3,4964,'App\\Models\\Receipt',4964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',39909.79,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6308,7922,40721,3040,3,4965,'App\\Models\\Receipt',4965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',59976.88,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6309,7922,40721,3040,3,4966,'App\\Models\\Receipt',4966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23','2022-04-23',81816.26,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6310,7922,40721,3040,3,4967,'App\\Models\\Receipt',4967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',5380.98,NULL,NULL,1,'2023-06-22 16:33:48','2023-06-22 16:33:48',NULL),(6311,7922,40721,3040,3,4968,'App\\Models\\Receipt',4968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',15746.94,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL),(6312,7922,40721,3040,3,4969,'App\\Models\\Receipt',4969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',13431.00,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL),(6313,7922,40721,3040,3,4970,'App\\Models\\Receipt',4970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',74321.83,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL),(6314,7922,40721,3040,3,4971,'App\\Models\\Receipt',4971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',4821.84,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL),(6315,7922,40721,3040,3,4972,'App\\Models\\Receipt',4972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',4892.03,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL),(6316,7922,40721,3040,3,4973,'App\\Models\\Receipt',4973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',5006.19,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL),(6317,7922,40721,3040,3,4974,'App\\Models\\Receipt',4974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',4255.35,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL),(6318,7922,40721,3040,3,4975,'App\\Models\\Receipt',4975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',33076.39,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL),(6319,7922,40721,3040,3,4976,'App\\Models\\Receipt',4976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',22189.88,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL),(6320,7922,40721,3040,3,4977,'App\\Models\\Receipt',4977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',6872.63,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL),(6321,7922,40721,3040,3,4978,'App\\Models\\Receipt',4978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',650.00,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL),(6322,7922,40721,3040,3,4979,'App\\Models\\Receipt',4979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',9869.17,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL);
INSERT INTO `balance_libro` VALUES (6323,7922,40721,3040,3,4980,'App\\Models\\Receipt',4980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',3642.78,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL),(6324,7922,40721,3040,3,4981,'App\\Models\\Receipt',4981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',3919.31,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL),(6325,7922,40721,3040,3,4982,'App\\Models\\Receipt',4982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',4255.35,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL),(6326,7922,40721,3040,3,4983,'App\\Models\\Receipt',4983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',4965.95,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL),(6327,7922,40721,3040,3,4984,'App\\Models\\Receipt',4984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',90092.95,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL),(6328,7922,40721,3040,3,4985,'App\\Models\\Receipt',4985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',83512.09,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL),(6329,7922,40721,3040,3,4986,'App\\Models\\Receipt',4986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',83512.09,NULL,NULL,1,'2023-06-22 16:33:49','2023-06-22 16:33:49',NULL),(6330,7922,40721,3040,3,4987,'App\\Models\\Receipt',4987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1198.37,NULL,NULL,1,'2023-06-22 16:33:50','2023-06-22 16:33:50',NULL),(6331,7922,40721,3040,3,4988,'App\\Models\\Receipt',4988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',31968.97,NULL,NULL,1,'2023-06-22 16:33:50','2023-06-22 16:33:50',NULL),(6332,7922,40721,3040,3,4989,'App\\Models\\Receipt',4989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',6937.78,NULL,NULL,1,'2023-06-22 16:33:50','2023-06-22 16:33:50',NULL),(6333,7922,40721,3040,3,4990,'App\\Models\\Receipt',4990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1890.85,NULL,NULL,1,'2023-06-22 16:33:50','2023-06-22 16:33:50',NULL),(6334,7922,40721,3041,3,4991,'App\\Models\\Receipt',4991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',3800.00,NULL,NULL,1,'2023-06-22 16:34:02','2023-06-22 16:34:02',NULL),(6335,7922,40721,3041,3,4992,'App\\Models\\Receipt',4992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',800.00,NULL,NULL,1,'2023-06-22 16:34:02','2023-06-22 16:34:02',NULL),(6336,7922,40721,3041,3,4993,'App\\Models\\Receipt',4993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',861811.32,NULL,NULL,1,'2023-06-22 16:34:02','2023-06-22 16:34:02',NULL),(6337,7922,40721,3041,3,4994,'App\\Models\\Receipt',4994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',77077.00,NULL,NULL,1,'2023-06-22 16:34:02','2023-06-22 16:34:02',NULL),(6338,7922,40721,3041,3,4995,'App\\Models\\Receipt',4995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',1573.00,NULL,NULL,1,'2023-06-22 16:34:02','2023-06-22 16:34:02',NULL),(6339,7922,40721,3041,3,4996,'App\\Models\\Receipt',4996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',1649.00,NULL,NULL,1,'2023-06-22 16:34:02','2023-06-22 16:34:02',NULL),(6340,7922,40721,3041,3,4997,'App\\Models\\Receipt',4997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',17280.00,NULL,NULL,1,'2023-06-22 16:34:02','2023-06-22 16:34:02',NULL),(6341,7922,40721,3041,3,4998,'App\\Models\\Receipt',4998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',15000.01,NULL,NULL,1,'2023-06-22 16:34:02','2023-06-22 16:34:02',NULL),(6342,7922,40721,3041,3,4999,'App\\Models\\Receipt',4999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',4594.00,NULL,NULL,1,'2023-06-22 16:34:02','2023-06-22 16:34:02',NULL),(6343,7922,40721,3041,3,5000,'App\\Models\\Receipt',5000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',57600.00,NULL,NULL,1,'2023-06-22 16:34:02','2023-06-22 16:34:02',NULL);
INSERT INTO `balance_libro` VALUES (6344,7922,40721,3041,3,5001,'App\\Models\\Receipt',5001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',22399.99,NULL,NULL,1,'2023-06-22 16:34:02','2023-06-22 16:34:02',NULL),(6345,7922,40721,3041,3,5002,'App\\Models\\Receipt',5002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',40000.00,NULL,NULL,1,'2023-06-22 16:34:02','2023-06-22 16:34:02',NULL),(6346,7922,40721,3041,3,5003,'App\\Models\\Receipt',5003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',56000.00,NULL,NULL,1,'2023-06-22 16:34:02','2023-06-22 16:34:02',NULL),(6347,7922,40721,3041,3,5004,'App\\Models\\Receipt',5004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',40000.00,NULL,NULL,1,'2023-06-22 16:34:02','2023-06-22 16:34:02',NULL),(6348,7922,40721,3041,3,5005,'App\\Models\\Receipt',5005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',11187.06,NULL,NULL,1,'2023-06-22 16:34:02','2023-06-22 16:34:02',NULL),(6349,7922,40721,3041,3,5006,'App\\Models\\Receipt',5006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',3194.40,NULL,NULL,1,'2023-06-22 16:34:02','2023-06-22 16:34:02',NULL),(6350,7922,40721,3041,3,5007,'App\\Models\\Receipt',5007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',16000.00,NULL,NULL,1,'2023-06-22 16:34:02','2023-06-22 16:34:02',NULL),(6351,7922,40721,3041,3,5008,'App\\Models\\Receipt',5008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',9000.00,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6352,7922,40721,3041,3,5009,'App\\Models\\Receipt',5009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',20000.00,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6353,7922,40721,3041,3,5010,'App\\Models\\Receipt',5010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',2582.14,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6354,7922,40721,3041,3,5011,'App\\Models\\Receipt',5011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',999.00,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6355,7922,40721,3041,3,5012,'App\\Models\\Receipt',5012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',21833.24,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6356,7922,40721,3041,3,5013,'App\\Models\\Receipt',5013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',106886.86,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6357,7922,40721,3041,3,5014,'App\\Models\\Receipt',5014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',31777.24,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6358,7922,40721,3041,3,5015,'App\\Models\\Receipt',5015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',0.00,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6359,7922,40721,3041,3,5016,'App\\Models\\Receipt',5016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',0.00,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6360,7922,40721,3041,3,5017,'App\\Models\\Receipt',5017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',0.00,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6361,7922,40721,3041,3,5018,'App\\Models\\Receipt',5018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',175.50,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6362,7922,40721,3041,3,5019,'App\\Models\\Receipt',5019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',42896.96,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6363,7922,40721,3041,3,5020,'App\\Models\\Receipt',5020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',14510.93,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6364,7922,40721,3041,3,5021,'App\\Models\\Receipt',5021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-12','2022-05-12',22409.20,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL);
INSERT INTO `balance_libro` VALUES (6365,7922,40721,3041,3,5022,'App\\Models\\Receipt',5022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',1477.00,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6366,7922,40721,3041,3,5023,'App\\Models\\Receipt',5023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',2142.50,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6367,7922,40721,3041,3,5024,'App\\Models\\Receipt',5024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',154154.00,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6368,7922,40721,3041,3,5025,'App\\Models\\Receipt',5025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',30436.36,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6369,7922,40721,3041,3,5026,'App\\Models\\Receipt',5026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',70350.53,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6370,7922,40721,3041,3,5027,'App\\Models\\Receipt',5027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',179433.51,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6371,7922,40721,3041,3,5028,'App\\Models\\Receipt',5028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',16859.99,NULL,NULL,1,'2023-06-22 16:34:03','2023-06-22 16:34:03',NULL),(6372,7922,40721,3041,3,5029,'App\\Models\\Receipt',5029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',14800.01,NULL,NULL,1,'2023-06-22 16:34:04','2023-06-22 16:34:04',NULL),(6373,7922,40721,3041,3,5030,'App\\Models\\Receipt',5030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',6592.15,NULL,NULL,1,'2023-06-22 16:34:04','2023-06-22 16:34:04',NULL),(6374,7922,40721,3041,3,5031,'App\\Models\\Receipt',5031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',18755.00,NULL,NULL,1,'2023-06-22 16:34:04','2023-06-22 16:34:04',NULL),(6375,7922,40721,3041,3,5032,'App\\Models\\Receipt',5032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',2132.00,NULL,NULL,1,'2023-06-22 16:34:04','2023-06-22 16:34:04',NULL),(6376,7922,40721,3041,3,5033,'App\\Models\\Receipt',5033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',16930.93,NULL,NULL,1,'2023-06-22 16:34:04','2023-06-22 16:34:04',NULL),(6377,7922,40721,3041,3,5034,'App\\Models\\Receipt',5034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',119790.28,NULL,NULL,1,'2023-06-22 16:34:04','2023-06-22 16:34:04',NULL),(6378,7922,40721,3041,3,5035,'App\\Models\\Receipt',5035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',24075.13,NULL,NULL,1,'2023-06-22 16:34:04','2023-06-22 16:34:04',NULL),(6379,7922,40721,3041,3,5036,'App\\Models\\Receipt',5036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',69960.63,NULL,NULL,1,'2023-06-22 16:34:04','2023-06-22 16:34:04',NULL),(6380,7922,40721,3041,3,5037,'App\\Models\\Receipt',5037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',650.00,NULL,NULL,1,'2023-06-22 16:34:04','2023-06-22 16:34:04',NULL),(6381,7922,40721,3041,3,5038,'App\\Models\\Receipt',5038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',20769.38,NULL,NULL,1,'2023-06-22 16:34:04','2023-06-22 16:34:04',NULL),(6382,7922,40721,3041,3,5039,'App\\Models\\Receipt',5039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',43534.35,NULL,NULL,1,'2023-06-22 16:34:04','2023-06-22 16:34:04',NULL),(6383,7922,40721,3041,3,5040,'App\\Models\\Receipt',5040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',5631.00,NULL,NULL,1,'2023-06-22 16:34:04','2023-06-22 16:34:04',NULL),(6384,7922,40721,3041,3,5041,'App\\Models\\Receipt',5041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',9304.56,NULL,NULL,1,'2023-06-22 16:34:04','2023-06-22 16:34:04',NULL),(6385,7922,40721,3041,3,5042,'App\\Models\\Receipt',5042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',102500.29,NULL,NULL,1,'2023-06-22 16:34:04','2023-06-22 16:34:04',NULL);
INSERT INTO `balance_libro` VALUES (6386,7922,40721,3041,3,5043,'App\\Models\\Receipt',5043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',128382.88,NULL,NULL,1,'2023-06-22 16:34:04','2023-06-22 16:34:04',NULL),(6387,7922,40721,3041,3,5044,'App\\Models\\Receipt',5044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',102500.29,NULL,NULL,1,'2023-06-22 16:34:04','2023-06-22 16:34:04',NULL),(6388,7922,40721,3041,3,5045,'App\\Models\\Receipt',5045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',124668.29,NULL,NULL,1,'2023-06-22 16:34:04','2023-06-22 16:34:04',NULL),(6389,7922,40721,3041,3,5046,'App\\Models\\Receipt',5046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',847.00,NULL,NULL,1,'2023-06-22 16:34:04','2023-06-22 16:34:04',NULL),(6390,7922,40721,3041,3,5047,'App\\Models\\Receipt',5047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',239.46,NULL,NULL,1,'2023-06-22 16:34:05','2023-06-22 16:34:05',NULL),(6391,7922,40721,3041,3,5048,'App\\Models\\Receipt',5048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',7900.00,NULL,NULL,1,'2023-06-22 16:34:05','2023-06-22 16:34:05',NULL),(6392,7922,40721,3041,3,5049,'App\\Models\\Receipt',5049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1647.00,NULL,NULL,1,'2023-06-22 16:34:05','2023-06-22 16:34:05',NULL),(6393,7922,40721,3041,3,5050,'App\\Models\\Receipt',5050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',6942.96,NULL,NULL,1,'2023-06-22 16:34:05','2023-06-22 16:34:05',NULL),(6394,7922,40721,3041,3,5051,'App\\Models\\Receipt',5051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',104810.00,NULL,NULL,1,'2023-06-22 16:34:05','2023-06-22 16:34:05',NULL),(6395,7922,40721,3042,3,5052,'App\\Models\\Receipt',5052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',3800.00,NULL,NULL,1,'2023-06-22 16:35:34','2023-06-22 16:35:34',NULL),(6396,7922,40721,3042,3,5053,'App\\Models\\Receipt',5053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',800.00,NULL,NULL,1,'2023-06-22 16:35:34','2023-06-22 16:35:34',NULL),(6397,7922,40721,3042,3,5054,'App\\Models\\Receipt',5054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',57600.00,NULL,NULL,1,'2023-06-22 16:35:34','2023-06-22 16:35:34',NULL),(6398,7922,40721,3042,3,5055,'App\\Models\\Receipt',5055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',2668.00,NULL,NULL,1,'2023-06-22 16:35:34','2023-06-22 16:35:34',NULL),(6399,7922,40721,3042,3,5056,'App\\Models\\Receipt',5056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',34430.55,NULL,NULL,1,'2023-06-22 16:35:34','2023-06-22 16:35:34',NULL),(6400,7922,40721,3042,3,5057,'App\\Models\\Receipt',5057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',11858.00,NULL,NULL,1,'2023-06-22 16:35:34','2023-06-22 16:35:34',NULL),(6401,7922,40721,3042,3,5058,'App\\Models\\Receipt',5058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-07','2022-06-07',527.50,NULL,NULL,1,'2023-06-22 16:35:34','2023-06-22 16:35:34',NULL),(6402,7922,40721,3042,3,5059,'App\\Models\\Receipt',5059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06