-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-36423895-4
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-07-29 17:32:09','Actividad Generica 1','000001',NULL),(2,NULL,'2022-07-29 17:32:09','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'Rodriguez2021',NULL,1,40798,'2022-08-16');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'estudiocontableataf@gmail.com','2644442333',NULL,1,40719,'2022-08-02'),(2,'estudiocontableataf@gmail.com','2644442333','',1,40719,'2022-08-02'),(3,'estudiocontableataf@gmail.com','02644861579','',1,40746,'2022-08-08'),(4,'estudiocontableataf@gmail.com',NULL,'',1,40798,'2022-08-16'),(5,'estudiocontableataf@gmail.com','02644861579','',1,40746,'2022-08-16');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(5,3,5,410,NULL,0.00,'2022-08-12 22:13:37','2022-08-12 22:13:37',NULL),(6,3,5,14,NULL,0.00,'2022-08-12 22:13:37','2022-08-12 22:13:37',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,7478,5,2,'INGRESO TARJETAS',0.00,'2022-08-12 22:13:37','2022-08-12 22:13:37',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2722 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7478,40746,37695,2,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1747.86,NULL,NULL,1,'2022-08-08 11:37:40','2022-08-08 11:37:40',NULL),(2,7478,40746,37695,2,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',520.30,NULL,NULL,1,'2022-08-08 11:37:40','2022-08-08 11:37:40',NULL),(3,7478,40746,37695,2,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2542.53,NULL,NULL,1,'2022-08-08 11:37:40','2022-08-08 11:37:40',NULL),(4,7478,40746,37695,2,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',4210.80,NULL,NULL,1,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(5,7478,40746,37695,2,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',2736.94,NULL,NULL,1,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(6,7478,40746,37695,2,6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1272.21,NULL,NULL,1,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(7,7478,40746,37695,2,7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',4875.09,NULL,NULL,1,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(8,7478,40746,37695,2,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',4300.34,NULL,NULL,1,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(9,7478,40746,37695,2,9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1361.25,NULL,NULL,1,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(10,7478,40746,37695,2,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',4310.02,NULL,NULL,1,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(11,7478,40746,37695,2,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',2155.01,NULL,NULL,1,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(12,7478,40746,37695,2,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5185.29,NULL,NULL,1,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(13,7478,40746,37695,2,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1011.56,NULL,NULL,1,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(14,7478,40746,37695,2,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4797.41,NULL,NULL,1,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(15,7478,40746,37695,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',16637.50,NULL,NULL,1,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(16,7478,40746,37695,2,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',15609.00,NULL,NULL,1,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(17,7478,40746,37695,2,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',13552.00,NULL,NULL,1,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(18,7478,40746,37695,2,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',15246.00,NULL,NULL,1,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(19,7478,40746,37695,2,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',15197.60,NULL,NULL,1,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(20,7478,40746,37695,2,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',14483.70,NULL,NULL,1,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(21,7478,40746,37695,2,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',16879.50,NULL,NULL,1,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(22,7478,40746,37695,2,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',19602.00,NULL,NULL,1,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(23,7478,40746,37695,2,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',19057.50,NULL,NULL,1,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(24,7478,40746,37695,2,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',20709.15,NULL,NULL,1,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(25,7478,40746,37695,2,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',18150.00,NULL,NULL,1,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL);
INSERT INTO `balance_libro` VALUES (26,7478,40746,37695,2,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',20630.00,NULL,NULL,1,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(27,7478,40746,37695,2,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',14900.00,NULL,NULL,1,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(28,7478,40746,37695,2,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',19830.00,NULL,NULL,1,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(29,7478,40746,37695,2,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',19660.00,NULL,NULL,1,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(30,7478,40746,37695,2,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',15900.00,NULL,NULL,1,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(31,7478,40746,37695,2,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',19780.00,NULL,NULL,1,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(32,7478,40746,37695,2,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',19630.00,NULL,NULL,1,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(33,7478,40746,37695,2,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',20880.00,NULL,NULL,1,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(34,7478,40746,37695,2,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',19800.00,NULL,NULL,1,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(35,7478,40746,37695,2,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',17850.00,NULL,NULL,1,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(36,7478,40746,37695,2,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',21090.00,NULL,NULL,1,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(37,7478,40746,37695,2,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',15960.00,NULL,NULL,1,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(38,7478,40746,37695,2,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',18720.00,NULL,NULL,1,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(39,7478,40746,37695,2,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',19990.00,NULL,NULL,1,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(40,7478,40746,37695,2,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',20280.00,NULL,NULL,1,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(41,7478,40746,37695,2,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',19200.00,NULL,NULL,1,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(42,7478,40746,37695,2,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',18750.00,NULL,NULL,1,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(43,7478,40746,37695,2,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',17787.00,NULL,NULL,1,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(44,7478,40746,37695,2,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',18600.00,NULL,NULL,1,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(45,7478,40746,37695,2,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',18960.00,NULL,NULL,1,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(46,7478,40746,37695,2,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',14815.00,NULL,NULL,1,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(47,7478,40746,37695,2,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',17838.00,NULL,NULL,1,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(48,7478,40746,37695,2,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',19870.00,NULL,NULL,1,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(49,7478,40746,37695,2,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',19035.00,NULL,NULL,1,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(50,7478,40746,37695,2,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',20880.00,NULL,NULL,1,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL);
INSERT INTO `balance_libro` VALUES (51,7478,40746,37695,2,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15704.00,NULL,NULL,1,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(52,7478,40746,37695,2,52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',19800.00,NULL,NULL,1,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(53,7478,40746,37695,2,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15468.00,NULL,NULL,1,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(54,7478,40746,37695,2,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',18600.00,NULL,NULL,1,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(55,7478,40746,37695,2,55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',18600.00,NULL,NULL,1,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(56,7478,40746,37695,2,56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',18760.00,NULL,NULL,1,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(57,7478,40746,37695,2,57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',20220.00,NULL,NULL,1,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(58,7478,40746,37695,2,58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',18750.00,NULL,NULL,1,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(59,7478,40746,37695,2,59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',19000.00,NULL,NULL,1,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(60,7478,40746,37695,2,60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',21480.00,NULL,NULL,1,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(61,7478,40746,37695,2,61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',19920.00,NULL,NULL,1,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(62,7478,40746,37695,2,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',18720.00,NULL,NULL,1,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(63,7478,40746,37695,2,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',20230.00,NULL,NULL,1,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(64,7478,40746,37695,2,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',19040.00,NULL,NULL,1,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(65,7478,40746,37695,2,65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',17870.00,NULL,NULL,1,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(66,7478,40746,37695,2,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',18348.00,NULL,NULL,1,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(67,7478,40746,37695,2,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',18540.00,NULL,NULL,1,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(68,7478,40746,37695,2,68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',21150.00,NULL,NULL,1,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(69,7478,40746,37695,2,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',18540.00,NULL,NULL,1,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(70,7478,40746,37695,3,70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',12755.28,NULL,NULL,1,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(71,7478,40746,37695,3,71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',797.39,NULL,NULL,1,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(72,7478,40746,37695,3,72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',130758.55,NULL,NULL,1,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(73,7478,40746,37695,3,73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',636.02,NULL,NULL,1,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(74,7478,40746,37695,3,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',210828.98,NULL,NULL,1,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(75,7478,40746,37695,3,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',9717.89,NULL,NULL,1,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL);
INSERT INTO `balance_libro` VALUES (76,7478,40746,37695,3,76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',245334.52,NULL,NULL,1,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(77,7478,40746,37695,3,77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',16755.15,NULL,NULL,1,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(78,7478,40746,37695,3,78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',144092.85,NULL,NULL,1,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(79,7478,40746,37695,3,79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',136888.21,NULL,NULL,1,'2022-08-08 12:30:21','2022-08-08 12:30:21',NULL),(80,7478,40746,37695,3,80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',16755.15,NULL,NULL,1,'2022-08-08 12:30:21','2022-08-08 12:30:21',NULL),(81,7478,40746,37695,3,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',13510.63,NULL,NULL,1,'2022-08-08 12:30:21','2022-08-08 12:30:21',NULL),(82,7478,40746,37695,3,82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',9012.41,NULL,NULL,1,'2022-08-08 12:30:21','2022-08-08 12:30:21',NULL),(83,7478,40784,78386,2,83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',21000.00,NULL,NULL,1,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(84,7478,40784,78386,2,84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',56500.02,NULL,NULL,1,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(85,7478,40784,78386,2,85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',300000.10,NULL,NULL,1,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(86,7478,40784,78386,2,86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',300000.08,NULL,NULL,1,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(87,7478,40784,78386,2,87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',300000.10,NULL,NULL,1,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(88,7478,40784,78386,2,88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(89,7478,40784,78386,2,89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(90,7478,40784,78386,2,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(91,7478,40784,78386,2,91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(92,7478,40784,78386,2,92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(93,7478,40784,78386,2,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(94,7478,40784,78386,2,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(95,7478,40784,78386,2,95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(96,7478,40784,78386,2,96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(97,7478,40784,78386,2,97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(98,7478,40784,78386,2,98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(99,7478,40784,78386,2,99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(100,7478,40784,78386,2,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL);
INSERT INTO `balance_libro` VALUES (101,7478,40784,78386,2,101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(102,7478,40784,78386,2,102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(103,7478,40784,78386,2,103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(104,7478,40784,78386,2,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(105,7478,40784,78386,2,105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(106,7478,40784,78386,2,106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(107,7478,40784,78386,2,107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(108,7478,40784,78386,2,108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(109,7478,40784,78386,2,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(110,7478,40784,78386,2,110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(111,7478,40784,78386,2,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(112,7478,40784,78386,2,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(113,7478,40784,78386,2,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(114,7478,40784,78386,2,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(115,7478,40784,78386,2,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(116,7478,40784,78386,2,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(117,7478,40784,78386,2,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(118,7478,40784,78386,2,118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(119,7478,40784,78386,2,119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(120,7478,40784,78386,2,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(121,7478,40784,78386,2,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(122,7478,40784,78386,2,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(123,7478,40784,78386,2,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(124,7478,40784,78386,2,124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL);
INSERT INTO `balance_libro` VALUES (125,7478,40784,78386,2,125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(126,7478,40784,78386,2,126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(127,7478,40784,78386,2,127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(128,7478,40784,78386,2,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(129,7478,40784,78386,2,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(130,7478,40784,78386,2,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(131,7478,40784,78386,2,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(132,7478,40784,78386,2,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',15500.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(133,7478,40784,78386,2,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',12000.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(134,7478,40784,78386,2,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(135,7478,40784,78386,2,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(136,7478,40784,78386,2,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(137,7478,40784,78386,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(138,7478,40784,78386,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',29272.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(139,7478,40784,78386,2,139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(140,7478,40784,78386,2,140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(141,7478,40784,78386,2,141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(142,7478,40784,78386,2,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(143,7478,40784,78386,2,143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(144,7478,40784,78386,2,144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(145,7478,40784,78386,2,145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(146,7478,40784,78386,2,146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(147,7478,40784,78386,2,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(148,7478,40784,78386,2,148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL);
INSERT INTO `balance_libro` VALUES (149,7478,40784,78386,2,149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(150,7478,40784,78386,2,150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(151,7478,40784,78386,2,151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(152,7478,40784,78386,2,152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(153,7478,40784,78386,2,153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(154,7478,40784,78386,2,154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(155,7478,40784,78386,2,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(156,7478,40784,78386,2,156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(157,7478,40784,78386,2,157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(158,7478,40784,78386,2,158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(159,7478,40784,78386,2,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(160,7478,40784,78386,2,160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(161,7478,40784,78386,2,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(162,7478,40784,78386,2,162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(163,7478,40784,78386,2,163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(164,7478,40784,78386,2,164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(165,7478,40784,78386,2,165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(166,7478,40784,78386,2,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(167,7478,40784,78386,2,167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(168,7478,40784,78386,2,168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(169,7478,40784,78386,2,169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(170,7478,40784,78386,2,170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(171,7478,40784,78386,2,171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(172,7478,40784,78386,2,172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL);
INSERT INTO `balance_libro` VALUES (173,7478,40784,78386,2,173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(174,7478,40784,78386,2,174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(175,7478,40784,78386,2,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(176,7478,40784,78386,2,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(177,7478,40784,78386,2,177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(178,7478,40784,78386,2,178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(179,7478,40784,78386,2,179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(180,7478,40784,78386,2,180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(181,7478,40784,78386,2,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(182,7478,40784,78386,2,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(183,7478,40784,78386,2,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(184,7478,40784,78386,2,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(185,7478,40784,78386,2,185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',15500.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(186,7478,40784,78386,2,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',15500.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(187,7478,40784,78386,2,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',15500.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(188,7478,40784,78386,2,188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',15500.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(189,7478,40784,78386,2,189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',15500.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(190,7478,40784,78386,2,190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',15500.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(191,7478,40784,78386,2,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',15500.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(192,7478,40784,78386,2,192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',15500.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(193,7478,40784,78386,2,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',15500.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(194,7478,40784,78386,2,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',15500.00,NULL,NULL,1,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(195,7478,40784,78386,2,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',15500.00,NULL,NULL,1,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL),(196,7478,40784,78386,2,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',15500.00,NULL,NULL,1,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL);
INSERT INTO `balance_libro` VALUES (197,7478,40784,78386,2,197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',15500.00,NULL,NULL,1,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL),(198,7478,40784,78386,2,198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL),(199,7478,40784,78386,2,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',20000.00,NULL,NULL,1,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL),(200,7478,40784,78386,3,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',34440.00,NULL,NULL,1,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(201,7478,40784,78386,3,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',19441.98,NULL,NULL,1,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(202,7478,40784,78386,3,202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',9579.28,NULL,NULL,1,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(203,7478,40784,78386,3,203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-10','2022-07-10',2467.60,NULL,NULL,1,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(204,7478,40784,78386,3,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',12867.12,NULL,NULL,1,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(205,7478,40784,78386,3,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',6564.88,NULL,NULL,1,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(206,7478,40784,78386,3,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1048320.00,NULL,NULL,1,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(207,7478,40784,78386,3,207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',82480.39,NULL,NULL,1,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(208,7478,40784,78386,3,208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',136400.00,NULL,NULL,1,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(209,7478,40784,78386,3,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',6658.19,NULL,NULL,1,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(210,7478,40784,78386,3,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',12867.12,NULL,NULL,1,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(211,7478,40784,78386,3,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',82480.39,NULL,NULL,1,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(212,7478,40784,78386,3,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',6564.88,NULL,NULL,1,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(213,7478,40784,78386,3,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',13050.10,NULL,NULL,1,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(214,7478,40784,78386,3,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',83653.36,NULL,NULL,1,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(215,7478,40784,78386,3,215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',367000.00,NULL,NULL,1,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(216,7478,40784,78386,3,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',32916.33,NULL,NULL,1,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(217,7478,40784,78386,3,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',50437.86,NULL,NULL,1,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(218,7478,40784,78386,3,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',51475.99,NULL,NULL,1,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(219,7478,40784,78386,3,219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',52131.06,NULL,NULL,1,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(220,7478,40784,78386,3,220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',103748.93,NULL,NULL,1,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL);
INSERT INTO `balance_libro` VALUES (221,7478,40784,78386,3,221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',41182.21,NULL,NULL,1,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(222,7478,40784,78386,3,222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',50609.00,NULL,NULL,1,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(223,7478,40798,79893,2,223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',16000.00,NULL,NULL,1,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(224,7478,40798,79893,2,224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',22500.00,NULL,NULL,1,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(225,7478,40798,79893,2,225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',19600.00,NULL,NULL,1,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(226,7478,40798,79893,2,226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',22000.00,NULL,NULL,1,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(227,7478,40798,79893,2,227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',22000.00,NULL,NULL,1,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(228,7478,40798,79893,2,228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',15500.00,NULL,NULL,1,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(229,7478,40798,79893,2,229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',14000.00,NULL,NULL,1,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(230,7478,40798,79893,2,230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',13500.00,NULL,NULL,1,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(231,7478,40798,79893,3,231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',3930.00,NULL,NULL,1,'2022-08-12 15:40:09','2022-08-12 15:40:09',NULL),(232,7478,40798,79893,3,232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',200.00,NULL,NULL,1,'2022-08-12 15:40:09','2022-08-12 15:40:09',NULL),(648,7478,40809,81400,2,648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6000.00,NULL,NULL,1,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(649,7478,40809,81400,2,649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',987.40,NULL,NULL,1,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(650,7478,40809,81400,2,650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',13500.00,NULL,NULL,1,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(651,7478,40809,81400,2,651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',242.00,NULL,NULL,1,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(652,7478,40809,81400,2,652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',500.00,NULL,NULL,1,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(653,7478,40809,81400,2,653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',11003.00,NULL,NULL,1,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(654,7478,40809,81400,2,654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1200.00,NULL,NULL,1,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(655,7478,40809,81400,2,655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6500.00,NULL,NULL,1,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(656,7478,40809,81400,2,656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',200.00,NULL,NULL,1,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(657,7478,40809,81400,2,657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',10700.00,NULL,NULL,1,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(658,7478,40809,81400,2,658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',462.82,NULL,NULL,1,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(659,7478,40809,81400,2,659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',10925.00,NULL,NULL,1,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL);
INSERT INTO `balance_libro` VALUES (660,7478,40809,81400,2,660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',5700.00,NULL,NULL,1,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(661,7478,40809,81400,2,661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',490.00,NULL,NULL,1,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(662,7478,40809,81400,2,662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',300.00,NULL,NULL,1,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(663,7478,40809,81400,2,663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',10709.95,NULL,NULL,1,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(664,7478,40809,81400,2,664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',9300.00,NULL,NULL,1,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(665,7478,40809,81400,2,665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6300.00,NULL,NULL,1,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(666,7478,40809,81400,2,666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',40.00,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(667,7478,40809,81400,2,667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',9000.00,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(668,7478,40809,81400,2,668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',200.00,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(669,7478,40809,81400,2,669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',10000.00,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(670,7478,40809,81400,2,670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',99.82,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(671,7478,40809,81400,2,671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',618.48,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(672,7478,40809,81400,2,672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',150.00,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(673,7478,40809,81400,2,673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',13800.00,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(674,7478,40809,81400,2,674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',2247.27,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(675,7478,40809,81400,2,675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',13800.00,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(676,7478,40809,81400,2,676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',430.00,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(677,7478,40809,81400,2,677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',910.00,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(678,7478,40809,81400,2,678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',15400.00,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(679,7478,40809,81400,2,679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',200.00,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(680,7478,40809,81400,2,680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6300.00,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(681,7478,40809,81400,2,681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',600.00,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(682,7478,40809,81400,2,682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',99.82,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(683,7478,40809,81400,2,683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',5900.00,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(684,7478,40809,81400,2,684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',15500.00,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL);
INSERT INTO `balance_libro` VALUES (685,7478,40809,81400,2,685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',9085.00,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(686,7478,40809,81400,2,686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',10580.00,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(687,7478,40809,81400,2,687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',1719.80,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(688,7478,40809,81400,2,688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',271.20,NULL,NULL,1,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(689,7478,40809,81400,2,689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',540.00,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(690,7478,40809,81400,2,690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',3391.94,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(691,7478,40809,81400,2,691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',720.00,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(692,7478,40809,81400,2,692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',12420.00,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(693,7478,40809,81400,2,693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',5450.76,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(694,7478,40809,81400,2,694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',333.96,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(695,7478,40809,81400,2,695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',356.56,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(696,7478,40809,81400,2,696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',11669.05,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(697,7478,40809,81400,2,697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',270.00,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(698,7478,40809,81400,2,698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',7475.00,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(699,7478,40809,81400,2,699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',5500.00,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(700,7478,40809,81400,2,700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',270.00,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(701,7478,40809,81400,2,701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',3091.76,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(702,7478,40809,81400,2,702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',10800.00,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(703,7478,40809,81400,2,703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',10300.00,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(704,7478,40809,81400,2,704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',9000.00,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(705,7478,40809,81400,2,705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',1194.90,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(706,7478,40809,81400,2,706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',250.00,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(707,7478,40809,81400,2,707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',6000.00,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(708,7478,40809,81400,2,708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',111.66,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(709,7478,40809,81400,2,709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',250.00,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL);
INSERT INTO `balance_libro` VALUES (710,7478,40809,81400,2,710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',6000.00,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(711,7478,40809,81400,2,711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',6500.00,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(712,7478,40809,81400,2,712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',11880.00,NULL,NULL,1,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(713,7478,40809,81400,2,713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',9000.00,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(714,7478,40809,81400,2,714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',8625.00,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(715,7478,40809,81400,2,715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',790.00,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(716,7478,40809,81400,2,716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',191.86,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(717,7478,40809,81400,2,717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',19200.00,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(718,7478,40809,81400,2,718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',12000.00,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(719,7478,40809,81400,2,719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',375.00,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(720,7478,40809,81400,2,720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',2500.88,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(721,7478,40809,81400,2,721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',320.02,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(722,7478,40809,81400,2,722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-04','2021-04-04',300.00,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(723,7478,40809,81400,2,723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-04','2021-04-04',1592.67,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(724,7478,40809,81400,2,724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-04','2021-04-04',11615.00,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(725,7478,40809,81400,2,725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-04','2021-04-04',180.00,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(726,7478,40809,81400,2,726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1400.00,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(727,7478,40809,81400,2,727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',3928.09,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(728,7478,40809,81400,2,728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',9500.00,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(729,7478,40809,81400,2,729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',327.20,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(730,7478,40809,81400,2,730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',350.00,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(731,7478,40809,81400,2,731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',12000.00,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(732,7478,40809,81400,2,732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',9800.00,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(733,7478,40809,81400,2,733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',600.00,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(734,7478,40809,81400,2,734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',191.86,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL);
INSERT INTO `balance_libro` VALUES (735,7478,40809,81400,2,735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',5164.76,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(736,7478,40809,81400,2,736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',191.86,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(737,7478,40809,81400,2,737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',3620.92,NULL,NULL,1,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(738,7478,40809,81400,2,738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',250.16,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(739,7478,40809,81400,2,739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',14108.20,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(740,7478,40809,81400,2,740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',9500.00,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(741,7478,40809,81400,2,741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',262.50,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(742,7478,40809,81400,2,742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1195.82,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(743,7478,40809,81400,2,743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',600.00,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(744,7478,40809,81400,2,744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',160.02,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(745,7478,40809,81400,2,745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',7463.00,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(746,7478,40809,81400,2,746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2821.80,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(747,7478,40809,81400,2,747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1064.24,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(748,7478,40809,81400,2,748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',12995.00,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(749,7478,40809,81400,2,749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',14007.00,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(750,7478,40809,81400,2,750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',10925.00,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(751,7478,40809,81400,2,751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',283.14,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(752,7478,40809,81400,2,752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',283.14,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(753,7478,40809,81400,2,753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',9430.00,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(754,7478,40809,81400,2,754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',12486.70,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(755,7478,40809,81400,2,755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',14000.00,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(756,7478,40809,81400,2,756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',5405.00,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(757,7478,40809,81400,2,757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',9500.00,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(758,7478,40809,81400,2,758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',270.00,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(759,7478,40809,81400,2,759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',11730.00,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL);
INSERT INTO `balance_libro` VALUES (760,7478,40809,81400,2,760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',218.14,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(761,7478,40809,81400,2,761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',11200.00,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(762,7478,40809,81400,2,762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',3377.86,NULL,NULL,1,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(763,7478,40809,81400,2,763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',6900.00,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(764,7478,40809,81400,2,764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',14007.00,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(765,7478,40809,81400,2,765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2104.22,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(766,7478,40809,81400,2,766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',13915.00,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(767,7478,40809,81400,2,767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',11700.00,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(768,7478,40809,81400,2,768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',11000.00,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(769,7478,40809,81400,2,769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',7000.00,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(770,7478,40809,81400,2,770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',758.34,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(771,7478,40809,81400,2,771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',431.22,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(772,7478,40809,81400,2,772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',39600.00,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(773,7478,40809,81400,2,773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',7475.00,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(774,7478,40809,81400,2,774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',11615.00,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(775,7478,40809,81400,2,775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',2554.98,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(776,7478,40809,81400,2,776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',2700.59,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(777,7478,40809,81400,2,777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',4370.00,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(778,7478,40809,81400,2,778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',11000.00,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(779,7478,40809,81400,2,779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',62.92,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(780,7478,40809,81400,2,780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',500.00,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(781,7478,40809,81400,2,781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',287.20,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(782,7478,40809,81400,2,782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',9500.00,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(783,7478,40809,81400,2,783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',3700.00,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(784,7478,40809,81400,2,784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',628.41,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL);
INSERT INTO `balance_libro` VALUES (785,7478,40809,81400,2,785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',7100.00,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(786,7478,40809,81400,2,786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',368.00,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(787,7478,40809,81400,2,787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',14260.00,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(788,7478,40809,81400,2,788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1797.06,NULL,NULL,1,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(789,7478,40809,81400,2,789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',23661.79,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(790,7478,40809,81400,2,790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',78600.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(791,7478,40809,81400,2,791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',11477.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(792,7478,40809,81400,2,792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',464.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(793,7478,40809,81400,2,793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',990.04,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(794,7478,40809,81400,2,794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',40.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(795,7478,40809,81400,2,795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',10000.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(796,7478,40809,81400,2,796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',252.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(797,7478,40809,81400,2,797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',3329.53,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(798,7478,40809,81400,2,798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',500.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(799,7478,40809,81400,2,799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',11200.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(800,7478,40809,81400,2,800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',400.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(801,7478,40809,81400,2,801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',7200.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(802,7478,40809,81400,2,802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',6500.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(803,7478,40809,81400,2,803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',333.23,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(804,7478,40809,81400,2,804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',147.04,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(805,7478,40809,81400,2,805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',250.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(806,7478,40809,81400,2,806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1512.20,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(807,7478,40809,81400,2,807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',12765.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(808,7478,40809,81400,2,808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',11500.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(809,7478,40809,81400,2,809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',507.15,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL);
INSERT INTO `balance_libro` VALUES (810,7478,40809,81400,2,810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',7100.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(811,7478,40809,81400,2,811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',800.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(812,7478,40809,81400,2,812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',10100.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(813,7478,40809,81400,2,813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',8500.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(814,7478,40809,81400,2,814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',11500.00,NULL,NULL,1,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(815,7478,40809,81400,2,815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',9100.00,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(816,7478,40809,81400,2,816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',78600.00,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(817,7478,40809,81400,2,817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',13900.00,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(818,7478,40809,81400,2,818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',7470.00,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(819,7478,40809,81400,2,819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',3490.00,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(820,7478,40809,81400,2,820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',24600.00,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(821,7478,40809,81400,2,821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',23400.00,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(822,7478,40809,81400,2,822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',40100.00,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(823,7478,40809,81400,2,823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',10100.00,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(824,7478,40809,81400,2,824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',5000.00,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(825,7478,40809,81400,2,825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',286.71,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(826,7478,40809,81400,2,826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',160.02,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(827,7478,40809,81400,2,827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',10000.00,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(828,7478,40809,81400,2,828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',10000.00,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(829,7478,40809,81400,2,829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',9500.00,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(830,7478,40809,81400,2,830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',593.68,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(831,7478,40809,81400,2,831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',6524.55,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(832,7478,40809,81400,2,832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',240.00,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(833,7478,40809,81400,2,833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',12880.00,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(834,7478,40809,81400,2,834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',1305.00,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL);
INSERT INTO `balance_libro` VALUES (835,7478,40809,81400,2,835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',10.00,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(836,7478,40809,81400,2,836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',154.28,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(837,7478,40809,81400,2,837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',12500.00,NULL,NULL,1,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(838,7478,40809,81400,2,838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',13110.00,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(839,7478,40809,81400,2,839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',7400.00,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(840,7478,40809,81400,2,840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',18170.00,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(841,7478,40809,81400,2,841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',231.00,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(842,7478,40809,81400,2,842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',5800.00,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(843,7478,40809,81400,2,843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',9500.00,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(844,7478,40809,81400,2,844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',242.00,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(845,7478,40809,81400,2,845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',2600.00,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(846,7478,40809,81400,2,846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',8000.00,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(847,7478,40809,81400,2,847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',1602.72,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(848,7478,40809,81400,2,848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',15500.00,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(849,7478,40809,81400,2,849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',6325.00,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(850,7478,40809,81400,2,850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',312.92,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(851,7478,40809,81400,2,851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',662.77,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(852,7478,40809,81400,2,852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',13700.00,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(853,7478,40809,81400,2,853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',488.14,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(854,7478,40809,81400,2,854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',12420.00,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(855,7478,40809,81400,2,855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',11200.00,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(856,7478,40809,81400,2,856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',147.04,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(857,7478,40809,81400,2,857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',12880.00,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(858,7478,40809,81400,2,858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',199.64,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(859,7478,40809,81400,2,859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',6300.00,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL);
INSERT INTO `balance_libro` VALUES (860,7478,40809,81400,2,860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',966.14,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(861,7478,40809,81400,2,861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',199.65,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(862,7478,40809,81400,2,862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',11155.00,NULL,NULL,1,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(863,7478,40809,81400,2,863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',493.98,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(864,7478,40809,81400,2,864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',10800.00,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(865,7478,40809,81400,2,865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',131.59,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(866,7478,40809,81400,2,866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',99.82,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(867,7478,40809,81400,2,867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',13110.00,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(868,7478,40809,81400,2,868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',910.00,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(869,7478,40809,81400,2,869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',4710.64,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(870,7478,40809,81400,2,870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',6000.00,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(871,7478,40809,81400,2,871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',8800.00,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(872,7478,40809,81400,2,872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',1217.51,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(873,7478,40809,81400,2,873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',392.00,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(874,7478,40809,81400,2,874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',220.00,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(875,7478,40809,81400,2,875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',689.95,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(876,7478,40809,81400,2,876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',12880.00,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(877,7478,40809,81400,2,877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',3899.01,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(878,7478,40809,81400,2,878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',510.40,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(879,7478,40809,81400,2,879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',250.00,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(880,7478,40809,81400,2,880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',509.27,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(881,7478,40809,81400,2,881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',9775.00,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(882,7478,40809,81400,2,882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',6500.00,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(883,7478,40809,81400,2,883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',1.00,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(884,7478,40809,81400,2,884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',7852.20,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL);
INSERT INTO `balance_libro` VALUES (885,7478,40809,81400,2,885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',2494.42,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(886,7478,40809,81400,2,886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',294.08,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(887,7478,40809,81400,2,887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',12500.00,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(888,7478,40809,81400,2,888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',740.00,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(889,7478,40809,81400,2,889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',11.00,NULL,NULL,1,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(890,7478,40809,81400,2,890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',10.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(891,7478,40809,81400,2,891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',5624.95,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(892,7478,40809,81400,2,892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',147.04,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(893,7478,40809,81400,2,893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',300.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(894,7478,40809,81400,2,894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',10.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(895,7478,40809,81400,2,895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',12305.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(896,7478,40809,81400,2,896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',1500.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(897,7478,40809,81400,2,897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',10.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(898,7478,40809,81400,2,898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',10350.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(899,7478,40809,81400,2,899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',9100.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(900,7478,40809,81400,2,900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',9500.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(901,7478,40809,81400,2,901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-11','2021-04-11',3953.47,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(902,7478,40809,81400,2,902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-11','2021-04-11',17825.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(903,7478,40809,81400,2,903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-11','2021-04-11',4410.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(904,7478,40809,81400,2,904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',153433.87,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(905,7478,40809,81400,2,905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',11200.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(906,7478,40809,81400,2,906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',5500.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(907,7478,40809,81400,2,907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',10800.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(908,7478,40809,81400,2,908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',11100.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(909,7478,40809,81400,2,909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',14900.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL);
INSERT INTO `balance_libro` VALUES (910,7478,40809,81400,2,910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',6700.80,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(911,7478,40809,81400,2,911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',8395.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(912,7478,40809,81400,2,912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',1412.38,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(913,7478,40809,81400,2,913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',344.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(914,7478,40809,81400,2,914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',3600.92,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(915,7478,40809,81400,2,915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',19000.00,NULL,NULL,1,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(916,7478,40809,81400,2,916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',363.58,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(917,7478,40809,81400,2,917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',12650.00,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(918,7478,40809,81400,2,918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',10000.00,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(919,7478,40809,81400,2,919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',13200.40,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(920,7478,40809,81400,2,920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',1090.68,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(921,7478,40809,81400,2,921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',10000.00,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(922,7478,40809,81400,2,922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',147.04,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(923,7478,40809,81400,2,923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',31.46,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(924,7478,40809,81400,2,924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',10000.00,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(925,7478,40809,81400,2,925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',962.48,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(926,7478,40809,81400,2,926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',628.41,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(927,7478,40809,81400,2,927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',9000.00,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(928,7478,40809,81400,2,928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',160.00,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(929,7478,40809,81400,2,929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',40.00,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(930,7478,40809,81400,2,930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',566.28,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(931,7478,40809,81400,2,931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',830.83,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(932,7478,40809,81400,2,932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',2048.98,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(933,7478,40809,81400,2,933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',733.14,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(934,7478,40809,81400,2,934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',12880.00,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL);
INSERT INTO `balance_libro` VALUES (935,7478,40809,81400,2,935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',4029.85,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(936,7478,40809,81400,2,936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',5100.87,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(937,7478,40809,81400,2,937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',10695.00,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(938,7478,40809,81400,2,938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',4249.33,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(939,7478,40809,81400,2,939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',11400.00,NULL,NULL,1,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(940,7478,40809,81400,2,940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',12100.00,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(941,7478,40809,81400,2,941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',80.00,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(942,7478,40809,81400,2,942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',7100.00,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(943,7478,40809,81400,2,943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',3300.00,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(944,7478,40809,81400,2,944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',4800.00,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(945,7478,40809,81400,2,945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',300.00,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(946,7478,40809,81400,2,946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',231.41,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(947,7478,40809,81400,2,947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',7450.00,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(948,7478,40809,81400,2,948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',96.30,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(949,7478,40809,81400,2,949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',722.62,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(950,7478,40809,81400,2,950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',503.41,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(951,7478,40809,81400,2,951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',6500.00,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(952,7478,40809,81400,2,952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',405.00,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(953,7478,40809,81400,2,953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',10000.00,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(954,7478,40809,81400,2,954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',758.14,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(955,7478,40809,81400,2,955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',2574.88,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(956,7478,40809,81400,2,956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',287.20,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(957,7478,40809,81400,2,957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',706.19,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(958,7478,40809,81400,2,958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',13110.00,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(959,7478,40809,81400,2,959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',5622.94,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL);
INSERT INTO `balance_libro` VALUES (960,7478,40809,81400,2,960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',600.00,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(961,7478,40809,81400,2,961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',5152.05,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(962,7478,40809,81400,2,962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',13110.00,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(963,7478,40809,81400,2,963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',270.00,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(964,7478,40809,81400,2,964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',781.33,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(965,7478,40809,81400,2,965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',13950.00,NULL,NULL,1,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(966,7478,40809,81400,2,966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',783.60,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(967,7478,40809,81400,2,967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',15500.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(968,7478,40809,81400,2,968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1080.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(969,7478,40809,81400,2,969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',10000.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(970,7478,40809,81400,2,970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',9900.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(971,7478,40809,81400,2,971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',4050.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(972,7478,40809,81400,2,972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',8900.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(973,7478,40809,81400,2,973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',9500.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(974,7478,40809,81400,2,974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',5500.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(975,7478,40809,81400,2,975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',16330.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(976,7478,40809,81400,2,976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',503.41,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(977,7478,40809,81400,2,977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',250.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(978,7478,40809,81400,2,978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',542.40,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(979,7478,40809,81400,2,979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',11200.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(980,7478,40809,81400,2,980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1076.59,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(981,7478,40809,81400,2,981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',6240.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(982,7478,40809,81400,2,982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',300.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(983,7478,40809,81400,2,983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',10000.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(984,7478,40809,81400,2,984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',6000.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL);
INSERT INTO `balance_libro` VALUES (985,7478,40809,81400,2,985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',13600.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(986,7478,40809,81400,2,986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',603.90,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(987,7478,40809,81400,2,987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',9950.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(988,7478,40809,81400,2,988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',99.82,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(989,7478,40809,81400,2,989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',10235.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(990,7478,40809,81400,2,990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',325.61,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(991,7478,40809,81400,2,991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',10500.00,NULL,NULL,1,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(992,7478,40809,81400,2,992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',160.02,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(993,7478,40809,81400,2,993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',13900.00,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(994,7478,40809,81400,2,994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',294.08,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(995,7478,40809,81400,2,995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',10005.00,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(996,7478,40809,81400,2,996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',99.82,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(997,7478,40809,81400,2,997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',160.02,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(998,7478,40809,81400,2,998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',4357.76,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(999,7478,40809,81400,2,999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',1.00,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(1000,7478,40809,81400,2,1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',203.28,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(1001,7478,40809,81400,2,1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',11248.51,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(1002,7478,40809,81400,2,1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',99.82,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(1003,7478,40809,81400,2,1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',1006.19,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(1004,7478,40809,81400,2,1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',15900.00,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(1005,7478,40809,81400,2,1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',15900.00,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(1006,7478,40809,81400,2,1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',1410.02,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(1007,7478,40809,81400,2,1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',540.00,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(1008,7478,40809,81400,2,1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',485.94,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL);
INSERT INTO `balance_libro` VALUES (1009,7478,40809,81400,2,1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',5500.00,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(1010,7478,40809,81400,2,1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',333.23,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(1011,7478,40809,81400,2,1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',11615.00,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(1012,7478,40809,81400,2,1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',6100.00,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(1013,7478,40809,81400,2,1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',280.00,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(1014,7478,40809,81400,2,1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',812.20,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(1015,7478,40809,81400,2,1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',10.00,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(1016,7478,40809,81400,2,1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',0.00,NULL,NULL,1,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(1017,7478,40809,81400,2,1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',10.00,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1018,7478,40809,81400,2,1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',595.32,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1019,7478,40809,81400,2,1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',190.02,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1020,7478,40809,81400,2,1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',200.00,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1021,7478,40809,81400,2,1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',503.41,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1022,7478,40809,81400,2,1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',516.58,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1023,7478,40809,81400,2,1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',13500.00,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1024,7478,40809,81400,2,1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',3299.06,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1025,7478,40809,81400,2,1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',3790.39,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1026,7478,40809,81400,2,1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',867.02,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1027,7478,40809,81400,2,1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',10600.00,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1028,7478,40809,81400,2,1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',11270.00,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1029,7478,40809,81400,2,1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',900.00,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1030,7478,40809,81400,2,1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',12590.00,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1031,7478,40809,81400,2,1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',2449.52,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1032,7478,40809,81400,2,1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',31.46,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL);
INSERT INTO `balance_libro` VALUES (1033,7478,40809,81400,2,1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',12500.00,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1034,7478,40809,81400,2,1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',7360.00,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1035,7478,40809,81400,2,1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',8050.00,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1036,7478,40809,81400,2,1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',8000.00,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1037,7478,40809,81400,2,1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',3620.92,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1038,7478,40809,81400,2,1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',120.00,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1039,7478,40809,81400,2,1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',330.28,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1040,7478,40809,81400,2,1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',1438.12,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1041,7478,40809,81400,2,1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',2049.27,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1042,7478,40809,81400,2,1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',6300.00,NULL,NULL,1,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(1043,7478,40809,81400,2,1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',503.41,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1044,7478,40809,81400,2,1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',6500.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1045,7478,40809,81400,2,1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',4214.34,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1046,7478,40809,81400,2,1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',6325.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1047,7478,40809,81400,2,1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',280.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1048,7478,40809,81400,2,1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',150.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1049,7478,40809,81400,2,1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',13110.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1050,7478,40809,81400,2,1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',9300.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1051,7478,40809,81400,2,1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',1100.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1052,7478,40809,81400,2,1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',6325.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1053,7478,40809,81400,2,1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',8500.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1054,7478,40809,81400,2,1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',659.20,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1055,7478,40809,81400,2,1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',650.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1056,7478,40809,81400,2,1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',280.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL);
INSERT INTO `balance_libro` VALUES (1057,7478,40809,81400,2,1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',721.16,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1058,7478,40809,81400,2,1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',9500.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1059,7478,40809,81400,2,1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',150.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1060,7478,40809,81400,2,1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',4900.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1061,7478,40809,81400,2,1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',9000.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1062,7478,40809,81400,2,1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',7200.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1063,7478,40809,81400,2,1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',4592.45,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1064,7478,40809,81400,2,1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',6900.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1065,7478,40809,81400,2,1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',10500.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1066,7478,40809,81400,2,1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',600.04,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1067,7478,40809,81400,2,1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',23700.00,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1068,7478,40809,81400,2,1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',869.65,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1069,7478,40809,81400,2,1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',8419.97,NULL,NULL,1,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(1070,7478,40809,81400,2,1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',7850.00,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1071,7478,40809,81400,2,1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',293.06,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1072,7478,40809,81400,2,1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',423.50,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1073,7478,40809,81400,2,1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',17500.00,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1074,7478,40809,81400,2,1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',7000.00,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1075,7478,40809,81400,2,1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',1440.00,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1076,7478,40809,81400,2,1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',5700.00,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1077,7478,40809,81400,2,1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',6200.00,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1078,7478,40809,81400,2,1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',5713.92,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1079,7478,40809,81400,2,1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',420.00,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1080,7478,40809,81400,2,1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',10625.00,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL);
INSERT INTO `balance_libro` VALUES (1081,7478,40809,81400,2,1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',560.74,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1082,7478,40809,81400,2,1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',665.50,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1083,7478,40809,81400,2,1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',2500.00,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1084,7478,40809,81400,2,1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',394.00,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1085,7478,40809,81400,2,1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',15000.00,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1086,7478,40809,81400,2,1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',11155.00,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1087,7478,40809,81400,2,1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',6900.00,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1088,7478,40809,81400,2,1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',1320.00,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1089,7478,40809,81400,2,1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',344.00,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1090,7478,40809,81400,2,1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',4983.82,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1091,7478,40809,81400,2,1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',3942.78,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1092,7478,40809,81400,2,1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',1195.82,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1093,7478,40809,81400,2,1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',250.00,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1094,7478,40809,81400,2,1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',99.82,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1095,7478,40809,81400,2,1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',500.00,NULL,NULL,1,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(1096,7478,40809,81400,2,1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',9800.00,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1097,7478,40809,81400,2,1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',333.23,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1098,7478,40809,81400,2,1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',233.23,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1099,7478,40809,81400,2,1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',0.00,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1100,7478,40809,81400,2,1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',12880.00,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1101,7478,40809,81400,2,1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',31.46,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1102,7478,40809,81400,2,1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',10000.00,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1103,7478,40809,81400,2,1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',11500.00,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1104,7478,40809,81400,2,1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',763.21,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL);
INSERT INTO `balance_libro` VALUES (1105,7478,40809,81400,2,1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',2574.88,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1106,7478,40809,81400,2,1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',281.20,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1107,7478,40809,81400,2,1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',11799.00,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1108,7478,40809,81400,2,1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',10200.00,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1109,7478,40809,81400,2,1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',8800.00,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1110,7478,40809,81400,2,1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',9500.00,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1111,7478,40809,81400,2,1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',9600.00,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1112,7478,40809,81400,2,1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',356.56,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1113,7478,40809,81400,2,1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',280.00,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1114,7478,40809,81400,2,1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',840.00,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1115,7478,40809,81400,2,1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',120.84,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1116,7478,40809,81400,2,1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',6500.00,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1117,7478,40809,81400,2,1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',1017.92,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1118,7478,40809,81400,2,1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',1443.76,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1119,7478,40809,81400,2,1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',5900.00,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1120,7478,40809,81400,2,1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',94.38,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1121,7478,40809,81400,2,1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',6300.00,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1122,7478,40809,81400,2,1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',30.00,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1123,7478,40809,81400,2,1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',2498.43,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1124,7478,40809,81400,2,1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',6785.00,NULL,NULL,1,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(1125,7478,40809,81400,2,1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',10925.00,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1126,7478,40809,81400,2,1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',6500.00,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1127,7478,40809,81400,2,1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',280.00,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1128,7478,40809,81400,2,1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',346.63,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL);
INSERT INTO `balance_libro` VALUES (1129,7478,40809,81400,2,1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',910.07,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1130,7478,40809,81400,2,1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',5391.35,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1131,7478,40809,81400,2,1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',5631.83,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1132,7478,40809,81400,2,1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',398.62,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1133,7478,40809,81400,2,1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',144.00,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1134,7478,40809,81400,2,1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',600.04,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1135,7478,40809,81400,2,1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',7747.71,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1136,7478,40809,81400,2,1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',840.00,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1137,7478,40809,81400,2,1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',40.00,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1138,7478,40809,81400,2,1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',9953.25,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1139,7478,40809,81400,2,1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',6785.00,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1140,7478,40809,81400,2,1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',18009.00,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1141,7478,40809,81400,2,1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',972.58,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1142,7478,40809,81400,2,1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',7300.00,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1143,7478,40809,81400,2,1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',12880.00,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1144,7478,40809,81400,2,1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',17940.00,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1145,7478,40809,81400,2,1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',770.50,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1146,7478,40809,81400,2,1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',3995.97,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1147,7478,40809,81400,2,1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',220.35,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1148,7478,40809,81400,2,1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',332.75,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1149,7478,40809,81400,2,1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',700.00,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1150,7478,40809,81400,2,1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',503.41,NULL,NULL,1,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(1151,7478,40809,81400,2,1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',628.41,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1152,7478,40809,81400,2,1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',191.86,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL);
INSERT INTO `balance_libro` VALUES (1153,7478,40809,81400,2,1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1800.00,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1154,7478,40809,81400,2,1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',280.00,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1155,7478,40809,81400,2,1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',649.82,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1156,7478,40809,81400,2,1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',11300.00,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1157,7478,40809,81400,2,1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1017.92,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1158,7478,40809,81400,2,1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1906.01,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1159,7478,40809,81400,2,1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',12995.00,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1160,7478,40809,81400,2,1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',4494.54,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1161,7478,40809,81400,2,1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',9000.00,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1162,7478,40809,81400,2,1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',1526.42,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1163,7478,40809,81400,2,1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',10000.00,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1164,7478,40809,81400,2,1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',9700.00,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1165,7478,40809,81400,2,1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',9800.00,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1166,7478,40809,81400,2,1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',5000.00,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1167,7478,40809,81400,2,1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',191.86,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1168,7478,40809,81400,2,1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',700.00,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1169,7478,40809,81400,2,1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',7800.00,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1170,7478,40809,81400,2,1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',566.28,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1171,7478,40809,81400,2,1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',10350.00,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1172,7478,40809,81400,2,1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',198.22,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1173,7478,40809,81400,2,1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',16560.00,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1174,7478,40809,81400,2,1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',8000.00,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1175,7478,40809,81400,2,1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',80.54,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1176,7478,40809,81400,2,1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',3620.92,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL);
INSERT INTO `balance_libro` VALUES (1177,7478,40809,81400,2,1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',11500.00,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1178,7478,40809,81400,2,1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',7015.00,NULL,NULL,1,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(1179,7478,40809,81400,2,1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',1400.00,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1180,7478,40809,81400,2,1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',6300.00,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1181,7478,40809,81400,2,1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',13110.00,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1182,7478,40809,81400,2,1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',415.42,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1183,7478,40809,81400,2,1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',12420.00,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1184,7478,40809,81400,2,1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',260.00,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1185,7478,40809,81400,2,1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',11500.00,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1186,7478,40809,81400,2,1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',10950.00,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1187,7478,40809,81400,2,1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',18700.34,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1188,7478,40809,81400,2,1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',10800.00,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1189,7478,40809,81400,2,1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-25','2021-04-25',363.20,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1190,7478,40809,81400,2,1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-25','2021-04-25',7100.00,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1191,7478,40809,81400,2,1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-25','2021-04-25',280.00,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1192,7478,40809,81400,2,1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-25','2021-04-25',741.86,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1193,7478,40809,81400,2,1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-25','2021-04-25',3832.25,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1194,7478,40809,81400,2,1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-25','2021-04-25',2611.18,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1195,7478,40809,81400,2,1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-25','2021-04-25',1040.00,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1196,7478,40809,81400,2,1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-25','2021-04-25',340.00,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1197,7478,40809,81400,2,1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-25','2021-04-25',9000.00,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1198,7478,40809,81400,2,1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',8500.00,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1199,7478,40809,81400,2,1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',4501.37,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1200,7478,40809,81400,2,1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',8500.00,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL);
INSERT INTO `balance_libro` VALUES (1201,7478,40809,81400,2,1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',2200.00,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1202,7478,40809,81400,2,1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',9500.00,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1203,7478,40809,81400,2,1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',19342.68,NULL,NULL,1,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(1204,7478,40809,81400,2,1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',6000.00,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1205,7478,40809,81400,2,1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',470.71,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1206,7478,40809,81400,2,1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',7475.00,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1207,7478,40809,81400,2,1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',2500.00,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1208,7478,40809,81400,2,1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',4158.53,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1209,7478,40809,81400,2,1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',280.00,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1210,7478,40809,81400,2,1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',6500.00,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1211,7478,40809,81400,2,1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',290.23,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1212,7478,40809,81400,2,1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',15648.40,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1213,7478,40809,81400,2,1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',17800.00,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1214,7478,40809,81400,2,1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',11000.00,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1215,7478,40809,81400,2,1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',12700.00,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1216,7478,40809,81400,2,1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',778.89,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1217,7478,40809,81400,2,1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',787.31,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1218,7478,40809,81400,2,1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',11669.05,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1219,7478,40809,81400,2,1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',2735.81,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1220,7478,40809,81400,2,1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',162.30,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1221,7478,40809,81400,2,1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',455.36,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1222,7478,40809,81400,2,1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',13110.00,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1223,7478,40809,81400,2,1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',10175.00,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1224,7478,40809,81400,2,1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',9600.00,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL);
INSERT INTO `balance_libro` VALUES (1225,7478,40809,81400,2,1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',202.00,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1226,7478,40809,81400,2,1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',171.34,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1227,7478,40809,81400,2,1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',495.00,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1228,7478,40809,81400,2,1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1001.64,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1229,7478,40809,81400,2,1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',15300.00,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1230,7478,40809,81400,2,1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',4890.34,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1231,7478,40809,81400,2,1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1388.00,NULL,NULL,1,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(1232,7478,40809,81400,2,1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',100.00,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1233,7478,40809,81400,2,1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',928.00,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1234,7478,40809,81400,2,1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',8000.00,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1235,7478,40809,81400,2,1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1187.36,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1236,7478,40809,81400,2,1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',742.02,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1237,7478,40809,81400,2,1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',37800.00,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1238,7478,40809,81400,2,1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',693.26,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1239,7478,40809,81400,2,1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',3884.63,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1240,7478,40809,81400,2,1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',11000.00,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1241,7478,40809,81400,2,1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',4869.00,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1242,7478,40809,81400,2,1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',6532.00,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1243,7478,40809,81400,2,1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',447.63,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1244,7478,40809,81400,2,1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1107.08,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1245,7478,40809,81400,2,1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',3441.69,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1246,7478,40809,81400,2,1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',8600.27,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1247,7478,40809,81400,2,1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',75.00,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1248,7478,40809,81400,2,1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',11569.00,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL);
INSERT INTO `balance_libro` VALUES (1249,7478,40809,81400,2,1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',9159.20,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1250,7478,40809,81400,2,1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',600.00,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1251,7478,40809,81400,2,1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',8625.00,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1252,7478,40809,81400,2,1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',3641.28,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1253,7478,40809,81400,2,1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',10.00,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1254,7478,40809,81400,2,1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1.00,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1255,7478,40809,81400,2,1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',10.00,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1256,7478,40809,81400,2,1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',10.00,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1257,7478,40809,81400,2,1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',191.86,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1258,7478,40809,81400,2,1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',13110.00,NULL,NULL,1,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(1259,7478,40809,81400,2,1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',287.20,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1260,7478,40809,81400,2,1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',782.44,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1261,7478,40809,81400,2,1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',722.67,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1262,7478,40809,81400,2,1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',10000.00,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1263,7478,40809,81400,2,1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',160.02,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1264,7478,40809,81400,2,1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',11555.20,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1265,7478,40809,81400,2,1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',6600.00,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1266,7478,40809,81400,2,1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',9000.00,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1267,7478,40809,81400,2,1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',11900.00,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1268,7478,40809,81400,2,1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',9500.00,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1269,7478,40809,81400,2,1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',2974.33,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1270,7478,40809,81400,2,1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',6500.00,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1271,7478,40809,81400,2,1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',7475.00,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1272,7478,40809,81400,2,1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',9100.00,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL);
INSERT INTO `balance_libro` VALUES (1273,7478,40809,81400,2,1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',6500.00,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1274,7478,40809,81400,2,1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',7200.00,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1275,7478,40809,81400,2,1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',520.88,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1276,7478,40809,81400,2,1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',7100.00,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1277,7478,40809,81400,2,1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',182.00,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1278,7478,40809,81400,2,1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',7000.50,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1279,7478,40809,81400,2,1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',6000.00,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1280,7478,40809,81400,2,1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',503.41,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1281,7478,40809,81400,2,1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',394.00,NULL,NULL,1,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(1282,7478,40809,81400,2,1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',280.00,NULL,NULL,1,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(1283,7478,40809,81400,2,1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',280.00,NULL,NULL,1,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(1284,7478,40809,81400,2,1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',0.00,NULL,NULL,1,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(1285,7478,40809,81400,2,1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',613.10,NULL,NULL,1,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(1286,7478,40809,81400,2,1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',7300.15,NULL,NULL,1,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(1287,7478,40809,81400,2,1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',10465.00,NULL,NULL,1,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(1288,7478,40809,81400,2,1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',8000.00,NULL,NULL,1,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(1289,7478,40809,81400,2,1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',7200.00,NULL,NULL,1,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(1290,7478,40809,81400,2,1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',547.93,NULL,NULL,1,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(1291,7478,40809,81400,2,1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',1495.80,NULL,NULL,1,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(1292,7478,40809,81400,2,1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',12500.00,NULL,NULL,1,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(1293,7478,40809,81400,2,1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',7300.00,NULL,NULL,1,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(1294,7478,40809,81400,2,1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',64631.80,NULL,NULL,1,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(1295,7478,40809,81400,2,1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',9100.00,NULL,NULL,1,'2022-08-12 20:48:06','2022-08-12 20:48:06',NULL),(1296,7478,40809,81400,3,1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',908.90,NULL,NULL,1,'2022-08-12 21:04:47','2022-08-12 21:09:10','2022-08-12 21:09:10');
INSERT INTO `balance_libro` VALUES (1297,7478,40809,81400,3,1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1400.00,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1298,7478,40809,81400,3,1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1849.58,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1299,7478,40809,81400,3,1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1452.00,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1300,7478,40809,81400,3,1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',3870.79,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1301,7478,40809,81400,3,1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',3563.58,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1302,7478,40809,81400,3,1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',186860.35,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1303,7478,40809,81400,3,1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',173546.84,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1304,7478,40809,81400,3,1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',4400.85,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1305,7478,40809,81400,3,1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',8667.44,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1306,7478,40809,81400,3,1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',4592.50,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1307,7478,40809,81400,3,1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',8500.00,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1308,7478,40809,81400,3,1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',14194.53,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1309,7478,40809,81400,3,1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',23405.11,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1310,7478,40809,81400,3,1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',3368.64,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1311,7478,40809,81400,3,1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',2643.53,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1312,7478,40809,81400,3,1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',2178.00,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1313,7478,40809,81400,3,1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',8669.97,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1314,7478,40809,81400,3,1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',35634.50,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1315,7478,40809,81400,3,1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',12293.62,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1316,7478,40809,81400,3,1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1482.84,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1317,7478,40809,81400,3,1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',86002.05,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1318,7478,40809,81400,3,1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',17441.81,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10');
INSERT INTO `balance_libro` VALUES (1319,7478,40809,81400,3,1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',55874.01,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1320,7478,40809,81400,3,1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',28409.89,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1321,7478,40809,81400,3,1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',78920.49,NULL,NULL,1,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1322,7478,40809,81400,3,1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',50637.66,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1323,7478,40809,81400,3,1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',124057.74,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1324,7478,40809,81400,3,1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',14138.52,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1325,7478,40809,81400,3,1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',3871.52,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1326,7478,40809,81400,3,1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',35328.62,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1327,7478,40809,81400,3,1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',24063.79,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1328,7478,40809,81400,3,1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',13176.00,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1329,7478,40809,81400,3,1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',89577.97,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1330,7478,40809,81400,3,1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',7500.00,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1331,7478,40809,81400,3,1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',9116.00,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1332,7478,40809,81400,3,1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',106977.47,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1333,7478,40809,81400,3,1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',26200.49,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1334,7478,40809,81400,3,1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',3359.97,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(1335,7478,40809,81400,3,1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',9199.96,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1336,7478,40809,81400,3,1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',3175.00,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1337,7478,40809,81400,3,1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',75668.84,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1338,7478,40809,81400,3,1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',5632.55,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1339,7478,40809,81400,3,1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',2536.24,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1340,7478,40809,81400,3,1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',24000.00,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11');
INSERT INTO `balance_libro` VALUES (1341,7478,40809,81400,3,1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',20264.45,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1342,7478,40809,81400,3,1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',27951.14,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1343,7478,40809,81400,3,1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',49804.47,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1344,7478,40809,81400,3,1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',476080.38,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1345,7478,40809,81400,3,1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',5632.55,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1346,7478,40809,81400,3,1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',55952.31,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1347,7478,40809,81400,3,1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',54116.34,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1348,7478,40809,81400,3,1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',3388.00,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1349,7478,40809,81400,3,1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',39565.84,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1350,7478,40809,81400,3,1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',14384.96,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1351,7478,40809,81400,3,1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',17971.16,NULL,NULL,1,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1352,7478,40809,81400,3,1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',19779.33,NULL,NULL,1,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1353,7478,40809,81400,3,1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',17981.20,NULL,NULL,1,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1354,7478,40809,81400,3,1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',19779.33,NULL,NULL,1,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1355,7478,40809,81400,3,1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',5856.80,NULL,NULL,1,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1356,7478,40809,81400,3,1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',181851.90,NULL,NULL,1,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1357,7478,40809,81400,3,1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',172398.20,NULL,NULL,1,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1358,7478,40809,81400,3,1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',50556.93,NULL,NULL,1,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1359,7478,40809,81400,3,1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',11848.43,NULL,NULL,1,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1360,7478,40809,81400,3,1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',5366.52,NULL,NULL,1,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1361,7478,40809,81400,3,1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',709.65,NULL,NULL,1,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1362,7478,40809,81400,3,1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',9498.09,NULL,NULL,1,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11');
INSERT INTO `balance_libro` VALUES (1363,7478,40809,81400,3,1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',27434.16,NULL,NULL,1,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(1364,7478,40809,81400,3,1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',908.90,NULL,NULL,1,'2022-08-12 21:39:24','2022-08-12 21:39:24',NULL),(1365,7478,40809,81400,3,1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1400.00,NULL,NULL,1,'2022-08-12 21:39:24','2022-08-12 21:39:24',NULL),(1366,7478,40809,81400,3,1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1452.00,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1367,7478,40809,81400,3,1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',3870.79,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1368,7478,40809,81400,3,1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1849.58,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1369,7478,40809,81400,3,1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',186860.35,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1370,7478,40809,81400,3,1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',3563.58,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1371,7478,40809,81400,3,1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',4400.93,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1372,7478,40809,81400,3,1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',173546.84,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1373,7478,40809,81400,3,1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',8667.44,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1374,7478,40809,81400,3,1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',4592.56,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1375,7478,40809,81400,3,1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',8500.00,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1376,7478,40809,81400,3,1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',3368.64,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1377,7478,40809,81400,3,1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',14194.53,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1378,7478,40809,81400,3,1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',23405.11,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1379,7478,40809,81400,3,1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',2178.00,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1380,7478,40809,81400,3,1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',2643.53,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1381,7478,40809,81400,3,1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',8669.99,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1382,7478,40809,81400,3,1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',35634.50,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1383,7478,40809,81400,3,1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',12293.62,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1384,7478,40809,81400,3,1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1482.84,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1385,7478,40809,81400,3,1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',28409.89,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1386,7478,40809,81400,3,1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',17441.81,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL);
INSERT INTO `balance_libro` VALUES (1387,7478,40809,81400,3,1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',55874.01,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1388,7478,40809,81400,3,1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',86002.05,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1389,7478,40809,81400,3,1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',124057.74,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1390,7478,40809,81400,3,1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',78920.49,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1391,7478,40809,81400,3,1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',50637.66,NULL,NULL,1,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(1392,7478,40809,81400,3,1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',14138.52,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1393,7478,40809,81400,3,1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',35328.62,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1394,7478,40809,81400,3,1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',24063.79,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1395,7478,40809,81400,3,1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',3871.52,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1396,7478,40809,81400,3,1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',106977.47,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1397,7478,40809,81400,3,1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',89577.97,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1398,7478,40809,81400,3,1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',7500.00,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1399,7478,40809,81400,3,1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',13176.00,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1400,7478,40809,81400,3,1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',9116.00,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1401,7478,40809,81400,3,1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',26200.49,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1402,7478,40809,81400,3,1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',3359.97,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1403,7478,40809,81400,3,1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',9199.96,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1404,7478,40809,81400,3,1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',3175.00,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1405,7478,40809,81400,3,1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',75668.84,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1406,7478,40809,81400,3,1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',2536.24,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1407,7478,40809,81400,3,1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',5632.55,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1408,7478,40809,81400,3,1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',24000.00,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1409,7478,40809,81400,3,1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',20264.45,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1410,7478,40809,81400,3,1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',27951.14,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL);
INSERT INTO `balance_libro` VALUES (1411,7478,40809,81400,3,1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',476080.38,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1412,7478,40809,81400,3,1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',49804.47,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1413,7478,40809,81400,3,1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',3388.00,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1414,7478,40809,81400,3,1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',55952.31,NULL,NULL,1,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(1415,7478,40809,81400,3,1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',39565.84,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1416,7478,40809,81400,3,1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',5632.55,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1417,7478,40809,81400,3,1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',54116.36,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1418,7478,40809,81400,3,1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',17981.20,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1419,7478,40809,81400,3,1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',19779.37,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1420,7478,40809,81400,3,1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',17971.16,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1421,7478,40809,81400,3,1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',14384.96,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1422,7478,40809,81400,3,1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',19779.37,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1423,7478,40809,81400,3,1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',181851.90,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1424,7478,40809,81400,3,1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',5856.80,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1425,7478,40809,81400,3,1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',27434.16,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1426,7478,40809,81400,3,1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',172398.20,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1427,7478,40809,81400,3,1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',709.65,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1428,7478,40809,81400,3,1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',5366.52,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1429,7478,40809,81400,3,1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',50556.93,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1430,7478,40809,81400,3,1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',9498.09,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1431,7478,40809,81400,3,1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',11848.43,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1432,7478,40809,81400,3,1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',300.00,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1433,7478,40809,81400,3,1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',300.28,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1434,7478,40809,81400,3,1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',4000.56,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL);
INSERT INTO `balance_libro` VALUES (1435,7478,40809,81400,3,1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',300.00,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1436,7478,40809,81400,3,1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',1000.00,NULL,NULL,1,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(1437,7478,40809,81400,3,1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',300.00,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1438,7478,40809,81400,3,1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',250.00,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1439,7478,40809,81400,3,1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',130.00,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1440,7478,40809,81400,3,1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',311.00,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1441,7478,40809,81400,3,1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',58000.00,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1442,7478,40809,81400,3,1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',4436.17,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1443,7478,40809,81400,3,1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',340.00,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1444,7478,40809,81400,3,1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',350.00,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1445,7478,40809,81400,3,1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',130.72,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1446,7478,40809,81400,3,1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',353.40,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1447,7478,40809,81400,3,1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',1000.00,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1448,7478,40809,81400,3,1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',90.00,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1449,7478,40809,81400,3,1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',320.01,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1450,7478,40809,81400,3,1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',300.00,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1451,7478,40809,81400,3,1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',300.00,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1452,7478,40809,81400,3,1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',3000.00,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1453,7478,40809,81400,3,1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',349.92,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1454,7478,40809,81400,3,1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',300.00,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1455,7478,40809,81400,3,1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',210.26,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1456,7478,40809,81400,3,1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',3100.47,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1457,7478,40809,81400,3,1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',5059.00,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1458,7478,40809,81400,3,1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',2000.00,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL);
INSERT INTO `balance_libro` VALUES (1459,7478,40809,81400,3,1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',310.00,NULL,NULL,1,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(1460,7478,40809,81400,3,1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',310.00,NULL,NULL,1,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(1461,7478,40809,81400,3,1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',311091.41,NULL,NULL,1,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(1462,7478,40809,81400,3,1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1806127.06,NULL,NULL,1,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(1463,7478,40809,81400,3,1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',350.00,NULL,NULL,1,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(1464,7478,40809,81400,3,1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',290.00,NULL,NULL,1,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(1465,7478,40809,81400,3,1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',3216.21,NULL,NULL,1,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(1466,7478,40809,81400,3,1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',286.00,NULL,NULL,1,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(1467,7478,40809,81400,3,1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',12360.00,NULL,NULL,1,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(1468,7478,40809,81400,15,NULL,33,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',837958.37,NULL,NULL,1,'2022-08-12 21:49:08','2022-08-12 21:49:08',NULL),(1469,7478,40809,81400,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',2000000.00,'COBROS POR BANCO',NULL,1,'2022-08-12 21:57:43','2022-08-12 21:58:17','2022-08-12 21:58:17'),(1470,7478,40809,81400,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',2000000.00,'COBROS POR BANCO',NULL,1,'2022-08-12 21:58:17','2022-08-12 22:18:20','2022-08-12 22:18:20'),(1471,7478,40809,81400,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',2054092.98,'COBROS POR BANCO',NULL,1,'2022-08-12 22:18:20','2022-08-12 22:32:47','2022-08-12 22:32:47'),(1472,7478,40809,81400,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',2166280.25,'PAGOS POR BANCO TODOS',NULL,1,'2022-08-12 22:21:30','2022-08-12 22:32:30','2022-08-12 22:32:30'),(1473,7478,40809,82977,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',551228.14,'BANCO FINAL MARZO',NULL,1,'2022-08-12 22:24:08','2022-08-12 22:24:08',NULL),(1474,7478,40809,81400,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',2166610.25,'PAGOS POR BANCO TODOS',NULL,1,'2022-08-12 22:32:30','2022-08-12 22:32:30',NULL),(1475,7478,40809,81400,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',2084034.62,'COBROS POR BANCO',NULL,1,'2022-08-12 22:32:47','2022-08-12 22:32:47',NULL),(1580,7477,40809,81421,2,1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',16000.00,NULL,NULL,1,'2022-08-13 11:51:41','2022-08-13 11:51:41',NULL),(1581,7477,40809,81421,2,1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',16500.00,NULL,NULL,1,'2022-08-13 11:51:41','2022-08-13 11:51:41',NULL),(1582,7477,40809,81421,2,1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2180.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1583,7477,40809,81421,2,1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2337.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1584,7477,40809,81421,2,1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',8000.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1585,7477,40809,81421,2,1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',3700.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL);
INSERT INTO `balance_libro` VALUES (1586,7477,40809,81421,2,1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',551.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1587,7477,40809,81421,2,1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2200.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1588,7477,40809,81421,2,1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',12995.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1589,7477,40809,81421,2,1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2200.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1590,7477,40809,81421,2,1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',14500.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1591,7477,40809,81421,2,1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',650.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1592,7477,40809,81421,2,1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',9744.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1593,7477,40809,81421,2,1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',2840.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1594,7477,40809,81421,2,1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',21850.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1595,7477,40809,81421,2,1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4995.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1596,7477,40809,81421,2,1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',19000.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1597,7477,40809,81421,2,1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',13000.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1598,7477,40809,81421,2,1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',19000.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1599,7477,40809,81421,2,1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',6710.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1600,7477,40809,81421,2,1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',3479.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1601,7477,40809,81421,2,1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',9593.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1602,7477,40809,81421,2,1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',3006.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1603,7477,40809,81421,2,1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',17500.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1604,7477,40809,81421,2,1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',27000.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1605,7477,40809,81421,2,1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',2360.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1606,7477,40809,81421,2,1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',550.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1607,7477,40809,81421,2,1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',8778.00,NULL,NULL,1,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(1608,7477,40809,81421,2,1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',551.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1609,7477,40809,81421,2,1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',14500.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL);
INSERT INTO `balance_libro` VALUES (1610,7477,40809,81421,2,1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',12000.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1611,7477,40809,81421,2,1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',250000.52,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1612,7477,40809,81421,2,1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',27000.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1613,7477,40809,81421,2,1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',13794.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1614,7477,40809,81421,2,1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',250000.52,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1615,7477,40809,81421,2,1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',50800.10,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1616,7477,40809,81421,2,1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',31021.64,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1617,7477,40809,81421,2,1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',590.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1618,7477,40809,81421,2,1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',500.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1619,7477,40809,81421,2,1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',14900.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1620,7477,40809,81421,2,1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',11379.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1621,7477,40809,81421,2,1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',650.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1622,7477,40809,81421,2,1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',15400.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1623,7477,40809,81421,2,1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',15400.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1624,7477,40809,81421,2,1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',25000.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1625,7477,40809,81421,2,1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',14000.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1626,7477,40809,81421,2,1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2250.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1627,7477,40809,81421,2,1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',19500.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1628,7477,40809,81421,2,1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',800.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1629,7477,40809,81421,2,1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',6041.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1630,7477,40809,81421,2,1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',7921.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1631,7477,40809,81421,2,1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1050.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1632,7477,40809,81421,2,1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',19000.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1633,7477,40809,81421,2,1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',50800.10,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL);
INSERT INTO `balance_libro` VALUES (1634,7477,40809,81421,2,1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',13500.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1635,7477,40809,81421,2,1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1000.00,NULL,NULL,1,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(1636,7477,40809,81421,2,1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',14600.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1637,7477,40809,81421,2,1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',500.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1638,7477,40809,81421,2,1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',24000.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1639,7477,40809,81421,2,1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',11000.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1640,7477,40809,81421,2,1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6800.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1641,7477,40809,81421,2,1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1170.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1642,7477,40809,81421,2,1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',15620.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1643,7477,40809,81421,2,1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',30000.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1644,7477,40809,81421,2,1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',11500.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1645,7477,40809,81421,2,1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1644.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1646,7477,40809,81421,2,1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1530.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1647,7477,40809,81421,2,1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',11600.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1648,7477,40809,81421,2,1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',9000.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1649,7477,40809,81421,2,1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',25000.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1650,7477,40809,81421,2,1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',17650.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1651,7477,40809,81421,2,1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',24573.60,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1652,7477,40809,81421,2,1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',31021.64,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1653,7477,40809,81421,2,1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',700.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1654,7477,40809,81421,2,1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',14000.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1655,7477,40809,81421,2,1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',19887.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1656,7477,40809,81421,2,1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2299.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1657,7477,40809,81421,2,1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1070.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL);
INSERT INTO `balance_libro` VALUES (1658,7477,40809,81421,2,1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',24000.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1659,7477,40809,81421,2,1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',24000.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1660,7477,40809,81421,2,1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',10000.00,NULL,NULL,1,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(1661,7477,40809,81421,2,1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',26000.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1662,7477,40809,81421,2,1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2503.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1663,7477,40809,81421,2,1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1400.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1664,7477,40809,81421,2,1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',59000.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1665,7477,40809,81421,2,1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1900.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1666,7477,40809,81421,2,1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',9150.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1667,7477,40809,81421,2,1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',25000.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1668,7477,40809,81421,2,1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',38000.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1669,7477,40809,81421,2,1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',19000.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1670,7477,40809,81421,2,1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',201.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1671,7477,40809,81421,2,1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',606.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1672,7477,40809,81421,2,1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2339.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1673,7477,40809,81421,2,1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',28000.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1674,7477,40809,81421,2,1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',600.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1675,7477,40809,81421,2,1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5200.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1676,7477,40809,81421,2,1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',34900.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1677,7477,40809,81421,2,1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',23000.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1678,7477,40809,81421,2,1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',13300.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1679,7477,40809,81421,2,1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',29000.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1680,7477,40809,81421,2,1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',6849.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1681,7477,40809,81421,2,1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',13000.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL);
INSERT INTO `balance_libro` VALUES (1682,7477,40809,81421,2,1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',13202.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1683,7477,40809,81421,2,1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1150.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1684,7477,40809,81421,2,1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5300.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1685,7477,40809,81421,2,1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',21500.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1686,7477,40809,81421,2,1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',6590.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1687,7477,40809,81421,2,1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',6000.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1688,7477,40809,81421,2,1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',14218.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1689,7477,40809,81421,2,1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1820.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1690,7477,40809,81421,2,1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',11480.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1691,7477,40809,81421,2,1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',303.00,NULL,NULL,1,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(1692,7477,40809,81421,2,1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',4200.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1693,7477,40809,81421,2,1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',4298.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1694,7477,40809,81421,2,1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',14671.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1695,7477,40809,81421,2,1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',16500.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1696,7477,40809,81421,2,1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',18270.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1697,7477,40809,81421,2,1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',13724.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1698,7477,40809,81421,2,1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',19000.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1699,7477,40809,81421,2,1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',23625.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1700,7477,40809,81421,2,1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5954.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1701,7477,40809,81421,2,1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7355.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1702,7477,40809,81421,2,1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',55867.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1703,7477,40809,81421,2,1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2344.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1704,7477,40809,81421,2,1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',20000.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1705,7477,40809,81421,2,1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',9808.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL);
INSERT INTO `balance_libro` VALUES (1706,7477,40809,81421,2,1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5400.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1707,7477,40809,81421,2,1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',3568.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1708,7477,40809,81421,2,1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1442.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1709,7477,40809,81421,2,1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',700.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1710,7477,40809,81421,2,1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',422.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1711,7477,40809,81421,2,1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2062.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1712,7477,40809,81421,2,1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',4801.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1713,7477,40809,81421,2,1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',19900.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1714,7477,40809,81421,2,1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',3800.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1715,7477,40809,81421,2,1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',26000.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1716,7477,40809,81421,2,1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',400.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1717,7477,40809,81421,2,1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',600.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1718,7477,40809,81421,2,1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',7644.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1719,7477,40809,81421,2,1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',13313.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1720,7477,40809,81421,2,1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',18000.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1721,7477,40809,81421,2,1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3000.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1722,7477,40809,81421,2,1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',2000.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1723,7477,40809,81421,2,1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',10691.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1724,7477,40809,81421,2,1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',20800.00,NULL,NULL,1,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(1725,7477,40809,81421,2,1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',14900.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1726,7477,40809,81421,2,1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1500.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1727,7477,40809,81421,2,1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',2323.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1728,7477,40809,81421,2,1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',7600.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1729,7477,40809,81421,2,1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',26556.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL);
INSERT INTO `balance_libro` VALUES (1730,7477,40809,81421,2,1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',30500.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1731,7477,40809,81421,2,1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',14500.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1732,7477,40809,81421,2,1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1600.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1733,7477,40809,81421,2,1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1400.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1734,7477,40809,81421,2,1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',5204.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1735,7477,40809,81421,2,1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',4435.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1736,7477,40809,81421,2,1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',2000.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1737,7477,40809,81421,2,1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',44114.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1738,7477,40809,81421,2,1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',10030.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1739,7477,40809,81421,2,1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',10030.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1740,7477,40809,81421,2,1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',4000.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1741,7477,40809,81421,2,1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',52310.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1742,7477,40809,81421,2,1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',10030.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1743,7477,40809,81421,2,1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',1410.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1744,7477,40809,81421,2,1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',31299.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1745,7477,40809,81421,2,1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',34918.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1746,7477,40809,81421,2,1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',17519.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1747,7477,40809,81421,2,1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',5533.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1748,7477,40809,81421,2,1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',13490.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1749,7477,40809,81421,2,1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',1704.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1750,7477,40809,81421,2,1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',24999.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1751,7477,40809,81421,2,1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',27540.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1752,7477,40809,81421,2,1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',2470.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1753,7477,40809,81421,2,1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',7416.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL);
INSERT INTO `balance_libro` VALUES (1754,7477,40809,81421,2,1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',703.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1755,7477,40809,81421,2,1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',7644.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1756,7477,40809,81421,2,1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',8200.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1757,7477,40809,81421,2,1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',17800.00,NULL,NULL,1,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(1758,7477,40809,81421,2,1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',9300.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1759,7477,40809,81421,2,1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',16500.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1760,7477,40809,81421,2,1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',215250.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1761,7477,40809,81421,2,1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1500.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1762,7477,40809,81421,2,1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',150.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1763,7477,40809,81421,2,1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',7800.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1764,7477,40809,81421,2,1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',11000.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1765,7477,40809,81421,2,1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',20685.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1766,7477,40809,81421,2,1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',127487.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1767,7477,40809,81421,2,1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',215250.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1768,7477,40809,81421,2,1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2800.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1769,7477,40809,81421,2,1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',1882.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1770,7477,40809,81421,2,1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',11800.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1771,7477,40809,81421,2,1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',17250.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1772,7477,40809,81421,2,1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',2321.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1773,7477,40809,81421,2,1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',25000.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1774,7477,40809,81421,2,1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',600.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1775,7477,40809,81421,2,1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',8466.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1776,7477,40809,81421,2,1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',22400.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1777,7477,40809,81421,2,1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',2478.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL);
INSERT INTO `balance_libro` VALUES (1778,7477,40809,81421,2,1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',800.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1779,7477,40809,81421,2,1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',2160.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1780,7477,40809,81421,2,1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',14900.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1781,7477,40809,81421,2,1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',9900.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1782,7477,40809,81421,2,1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',13900.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1783,7477,40809,81421,2,1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',3000.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1784,7477,40809,81421,2,1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',2135.00,NULL,NULL,1,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(1785,7477,40809,81421,2,1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',4544.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1786,7477,40809,81421,2,1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2400.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1787,7477,40809,81421,2,1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2448.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1788,7477,40809,81421,2,1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2177.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1789,7477,40809,81421,2,1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',13500.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1790,7477,40809,81421,2,1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',75000.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1791,7477,40809,81421,2,1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',7969.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1792,7477,40809,81421,2,1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',19500.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1793,7477,40809,81421,2,1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1355.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1794,7477,40809,81421,2,1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',191140.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1795,7477,40809,81421,2,1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',159095.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1796,7477,40809,81421,2,1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',1243.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1797,7477,40809,81421,2,1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',25012.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1798,7477,40809,81421,2,1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',191140.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1799,7477,40809,81421,2,1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',22500.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1800,7477,40809,81421,2,1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',25800.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1801,7477,40809,81421,2,1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',21230.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL);
INSERT INTO `balance_libro` VALUES (1802,7477,40809,81421,2,1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',13499.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1803,7477,40809,81421,2,1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',1576.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1804,7477,40809,81421,2,1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',71120.14,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1805,7477,40809,81421,2,1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',0.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1806,7477,40809,81421,2,1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',14800.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1807,7477,40809,81421,2,1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',1450.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1808,7477,40809,81421,2,1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',338.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1809,7477,40809,81421,2,1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',10000.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1810,7477,40809,81421,2,1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',36027.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1811,7477,40809,81421,2,1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',200.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1812,7477,40809,81421,2,1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',20700.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1813,7477,40809,81421,2,1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',31706.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1814,7477,40809,81421,2,1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',5641.00,NULL,NULL,1,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(1815,7477,40809,81421,2,1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',23813.00,NULL,NULL,1,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(1816,7477,40809,81421,2,1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',25000.00,NULL,NULL,1,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(1817,7477,40809,81421,2,1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',251.00,NULL,NULL,1,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(1818,7477,40809,81421,2,1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',2893.00,NULL,NULL,1,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(1819,7477,40809,81421,2,1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',704.00,NULL,NULL,1,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(1820,7477,40809,81421,2,1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',34500.00,NULL,NULL,1,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(1821,7477,40809,81421,2,1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',27902.00,NULL,NULL,1,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(1822,7477,40809,81421,2,1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3893.00,NULL,NULL,1,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(1823,7477,40809,81421,2,1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2699.00,NULL,NULL,1,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(1824,7478,41722,82978,2,1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',63452.40,NULL,NULL,1,'2022-08-16 13:43:49','2022-08-16 13:43:49',NULL),(1825,7478,41722,82978,2,1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',63452.40,NULL,NULL,1,'2022-08-16 13:43:49','2022-08-16 13:43:49',NULL);
INSERT INTO `balance_libro` VALUES (1826,7478,41722,82978,2,1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',63452.40,NULL,NULL,1,'2022-08-16 13:43:49','2022-08-16 13:43:49',NULL),(1827,7478,41722,82978,2,1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',15350.57,NULL,NULL,1,'2022-08-16 13:43:49','2022-08-16 13:43:49',NULL),(1828,7478,41722,82978,2,1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',12686.38,NULL,NULL,1,'2022-08-16 13:43:50','2022-08-16 13:43:50',NULL),(1829,7478,41722,82978,2,1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',15350.57,NULL,NULL,1,'2022-08-16 13:43:50','2022-08-16 13:43:50',NULL),(1830,7478,41776,158328,2,1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',37000.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1831,7478,41776,158328,2,1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',24500.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1832,7478,41776,158328,2,1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',14820.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1833,7478,41776,158328,2,1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',5550.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1834,7478,41776,158328,2,1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',7650.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1835,7478,41776,158328,2,1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',24000.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1836,7478,41776,158328,2,1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',23400.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1837,7478,41776,158328,2,1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',17690.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1838,7478,41776,158328,2,1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1839,7478,41776,158328,2,1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1840,7478,41776,158328,2,1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',17690.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1841,7478,41776,158328,2,1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',17000.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1842,7478,41776,158328,2,1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',26775.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1843,7478,41776,158328,2,1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7200.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1844,7478,41776,158328,2,1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',4850.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1845,7478,41776,158328,2,1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',19500.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1846,7478,41776,158328,2,1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',21700.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1847,7478,41776,158328,2,1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',39600.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56');
INSERT INTO `balance_libro` VALUES (1848,7478,41776,158328,2,1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',9350.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1849,7478,41776,158328,2,1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5250.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1850,7478,41776,158328,2,1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',15500.00,NULL,NULL,1,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1851,7478,41776,158328,2,1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',66000.00,NULL,NULL,1,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1852,7478,41776,158328,2,1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',17686.00,NULL,NULL,1,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1853,7478,41776,158328,2,1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',22880.00,NULL,NULL,1,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1854,7478,41776,158328,2,1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',21190.00,NULL,NULL,1,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1855,7478,41776,158328,2,1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',4160.00,NULL,NULL,1,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1856,7478,41776,158328,2,1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',7160.00,NULL,NULL,1,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1857,7478,41776,158328,2,1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',44902.00,NULL,NULL,1,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1858,7478,41776,158328,2,1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',33528.00,NULL,NULL,1,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1859,7478,41776,158328,2,1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',12500.00,NULL,NULL,1,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(1860,7478,41776,158328,3,1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',50000.01,NULL,NULL,1,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(1861,7478,41776,158328,3,1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',222.43,NULL,NULL,1,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(1862,7478,41776,158328,3,1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-10','2022-07-10',0.00,NULL,NULL,1,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(1863,7478,41776,158328,3,1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',20066.00,NULL,NULL,1,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(1864,7478,41776,158328,3,1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',20066.00,NULL,NULL,1,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(1865,7478,41776,158328,3,1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',85465.71,NULL,NULL,1,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(1866,7478,41776,158328,3,1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',20066.00,NULL,NULL,1,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(1867,7478,41776,158328,3,1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',58336.45,NULL,NULL,1,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(1868,7478,41776,158328,3,1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',149890.00,NULL,NULL,1,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(1869,7478,41776,158328,3,1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',150000.07,NULL,NULL,1,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09');
INSERT INTO `balance_libro` VALUES (1870,7478,41776,158328,3,1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',7829.10,NULL,NULL,1,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(1871,7478,41776,158328,3,1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',9881.59,NULL,NULL,1,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(1872,7478,41776,158328,3,1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',45690.84,NULL,NULL,1,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(1873,7478,41776,158328,3,1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',0.00,NULL,NULL,1,'2022-08-16 19:58:52','2022-08-16 20:05:09','2022-08-16 20:05:09'),(1874,7478,41776,158328,2,1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',37000.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1875,7478,41776,158328,2,1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',24500.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1876,7478,41776,158328,2,1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',14820.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1877,7478,41776,158328,2,1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',5550.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1878,7478,41776,158328,2,1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',7650.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1879,7478,41776,158328,2,1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',24000.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1880,7478,41776,158328,2,1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',23400.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1881,7478,41776,158328,2,1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',17690.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1882,7478,41776,158328,2,1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1883,7478,41776,158328,2,1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1884,7478,41776,158328,2,1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',17690.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1885,7478,41776,158328,2,1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',17000.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1886,7478,41776,158328,2,1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',26775.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1887,7478,41776,158328,2,1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',7200.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1888,7478,41776,158328,2,1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',4850.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1889,7478,41776,158328,2,1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',19500.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1890,7478,41776,158328,2,1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',21700.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1891,7478,41776,158328,2,1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',39600.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1892,7478,41776,158328,2,1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',9350.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1893,7478,41776,158328,2,1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5250.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL);
INSERT INTO `balance_libro` VALUES (1894,7478,41776,158328,2,1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',15500.00,NULL,NULL,1,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(1895,7478,41776,158328,2,1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',66000.00,NULL,NULL,1,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(1896,7478,41776,158328,2,1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',17686.00,NULL,NULL,1,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(1897,7478,41776,158328,2,1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',22880.00,NULL,NULL,1,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(1898,7478,41776,158328,2,1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',21190.00,NULL,NULL,1,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(1899,7478,41776,158328,2,1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',4160.00,NULL,NULL,1,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(1900,7478,41776,158328,2,1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',7160.00,NULL,NULL,1,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(1901,7478,41776,158328,2,1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',44902.00,NULL,NULL,1,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(1902,7478,41776,158328,2,1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',33528.00,NULL,NULL,1,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(1903,7478,41776,158328,2,1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',12500.00,NULL,NULL,1,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(1904,7478,41776,158328,3,1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',50000.01,NULL,NULL,1,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(1905,7478,41776,158328,3,1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',222.43,NULL,NULL,1,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(1906,7478,41776,158328,3,1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-10','2022-07-10',0.00,NULL,NULL,1,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(1907,7478,41776,158328,3,1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',20066.00,NULL,NULL,1,'2022-08-16 20:06:35','2022-08-16 20:22:44','2022-08-16 20:22:44'),(1908,7478,41776,158328,3,1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',20066.00,NULL,NULL,1,'2022-08-16 20:06:35','2022-08-16 20:30:23','2022-08-16 20:30:23'),(1909,7478,41776,158328,3,1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',85465.71,NULL,NULL,1,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(1910,7478,41776,158328,3,1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',20066.00,NULL,NULL,1,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(1911,7478,41776,158328,3,1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',58336.45,NULL,NULL,1,'2022-08-16 20:06:35','2022-08-16 20:24:02','2022-08-16 20:24:02'),(1912,7478,41776,158328,3,1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',149890.00,NULL,NULL,1,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(1913,7478,41776,158328,3,1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',150000.07,NULL,NULL,1,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(1914,7478,41776,158328,3,1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',7829.10,NULL,NULL,1,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(1915,7478,41776,158328,3,1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',9881.59,NULL,NULL,1,'2022-08-16 20:06:35','2022-08-16 20:23:12','2022-08-16 20:23:12'),(1916,7478,41776,158328,3,1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',45690.84,NULL,NULL,1,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(1917,7478,41776,158328,3,1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',0.00,NULL,NULL,1,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL);
INSERT INTO `balance_libro` VALUES (1918,7478,41776,158328,3,1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',20066.00,NULL,NULL,1,'2022-08-16 20:22:44','2022-08-16 20:29:59','2022-08-16 20:29:59'),(1919,7478,41776,158328,3,1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',9881.59,NULL,NULL,1,'2022-08-16 20:23:12','2022-08-16 20:23:48','2022-08-16 20:23:48'),(1920,7478,41776,158328,3,1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',9881.59,NULL,NULL,1,'2022-08-16 20:23:48','2022-08-16 20:28:37','2022-08-16 20:28:37'),(1921,7478,41776,158328,3,1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',58336.45,NULL,NULL,1,'2022-08-16 20:24:02','2022-08-16 20:29:00','2022-08-16 20:29:00'),(1922,7478,41776,158328,3,1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',9881.59,NULL,NULL,1,'2022-08-16 20:28:37','2022-08-16 20:28:37',NULL),(1923,7478,41776,158328,3,1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',58336.45,NULL,NULL,1,'2022-08-16 20:29:00','2022-08-16 20:29:00',NULL),(1924,7478,41776,158328,3,1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',20066.00,NULL,NULL,1,'2022-08-16 20:29:59','2022-08-16 20:29:59',NULL),(1925,7478,41776,158328,3,1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',20066.00,NULL,NULL,1,'2022-08-16 20:30:23','2022-08-16 20:30:23',NULL),(1926,7478,41795,159835,3,1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',4897.05,NULL,NULL,1,'2022-08-17 11:10:43','2022-08-17 11:15:36','2022-08-17 11:15:36'),(1927,7478,41795,159835,3,1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4951.01,NULL,NULL,1,'2022-08-17 11:10:43','2022-08-17 11:10:43',NULL),(1928,7478,41795,159835,3,1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',170000.00,NULL,NULL,1,'2022-08-17 11:10:43','2022-08-17 11:10:43',NULL),(1929,7478,41795,159835,3,1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',68474.00,NULL,NULL,1,'2022-08-17 11:10:44','2022-08-17 11:19:10','2022-08-17 11:19:10'),(1930,7478,41795,159835,3,1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',139963.00,NULL,NULL,1,'2022-08-17 11:10:44','2022-08-17 11:18:36','2022-08-17 11:18:36'),(1931,7478,41795,159835,3,1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',4651.00,NULL,NULL,1,'2022-08-17 11:10:44','2022-08-17 11:10:44',NULL),(1932,7478,41795,159835,3,1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',139963.00,NULL,NULL,1,'2022-08-17 11:18:36','2022-08-17 11:18:36',NULL),(1933,7478,41795,159835,3,1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',68474.01,NULL,NULL,1,'2022-08-17 11:19:10','2022-08-17 11:19:10',NULL),(1934,7478,41798,161342,2,1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',20000.00,NULL,NULL,1,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(1935,7478,41798,161342,2,1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',21500.00,NULL,NULL,1,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(1936,7478,41798,161342,2,1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',20000.00,NULL,NULL,1,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(1937,7478,41798,161342,2,1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',18500.00,NULL,NULL,1,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(1938,7478,41798,161342,2,1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',19000.00,NULL,NULL,1,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(1939,7478,41798,161342,2,1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',17000.00,NULL,NULL,1,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(1940,7478,41798,161342,2,1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',21500.00,NULL,NULL,1,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL);
INSERT INTO `balance_libro` VALUES (1941,7478,41798,161342,2,1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',18500.00,NULL,NULL,1,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(1942,7478,41798,161342,2,1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',15800.00,NULL,NULL,1,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(1943,7478,41798,161342,2,1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',19500.00,NULL,NULL,1,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(1944,7478,41798,161342,2,1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',18700.00,NULL,NULL,1,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(1945,7478,41798,161342,2,1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',17600.00,NULL,NULL,1,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(1946,7478,41798,161342,2,1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',21500.00,NULL,NULL,1,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(1947,7478,41798,161342,2,1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',13355.48,NULL,NULL,1,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(1948,7478,41798,161342,3,1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',875.59,NULL,NULL,1,'2022-08-17 13:23:25','2022-08-17 13:23:25',NULL),(1949,7478,41798,161342,3,1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2100.00,NULL,NULL,1,'2022-08-17 13:23:26','2022-08-17 13:23:26',NULL),(1950,7478,41798,161342,15,NULL,86,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',45550.13,NULL,NULL,1,'2022-08-17 13:26:10','2022-08-17 13:26:10',NULL),(1951,7478,41798,161342,16,NULL,88,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5422.63,NULL,NULL,1,'2022-08-18 10:58:14','2022-08-18 10:58:14',NULL),(1952,7478,41611,162849,2,1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',50000.01,NULL,NULL,1,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(1953,7478,41611,162849,2,1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',16001.04,NULL,NULL,1,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(1954,7478,41611,162849,2,1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',150000.07,NULL,NULL,1,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(1955,7478,41611,162849,2,1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',70000.00,NULL,NULL,1,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(1956,7478,41611,162849,2,1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',250000.52,NULL,NULL,1,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(1957,7478,41611,162849,3,1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',50000.01,NULL,NULL,1,'2022-08-18 11:10:42','2022-08-18 11:13:20','2022-08-18 11:13:20'),(1958,7478,41611,162849,3,1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',16001.04,NULL,NULL,1,'2022-08-18 11:10:42','2022-08-18 11:13:15','2022-08-18 11:13:15'),(1959,7478,41611,162849,3,1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',150000.07,NULL,NULL,1,'2022-08-18 11:10:42','2022-08-18 11:13:10','2022-08-18 11:13:10'),(1960,7478,41611,162849,3,1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',70000.00,NULL,NULL,1,'2022-08-18 11:10:42','2022-08-18 11:13:06','2022-08-18 11:13:06'),(1961,7478,41611,162849,3,1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',250000.52,NULL,NULL,1,'2022-08-18 11:10:42','2022-08-18 11:12:57','2022-08-18 11:12:57'),(1962,7478,41611,162849,3,1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',250000.52,NULL,NULL,1,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(1963,7478,41611,162849,3,1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',250000.52,NULL,NULL,1,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL);
INSERT INTO `balance_libro` VALUES (1964,7478,41611,162849,3,1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',2843.50,NULL,NULL,1,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(1965,7478,41611,162849,3,1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',58640.58,NULL,NULL,1,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(1966,7478,41611,162849,3,1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',299.00,NULL,NULL,1,'2022-08-18 11:13:59','2022-08-18 11:32:56','2022-08-18 11:32:56'),(1967,7478,41611,162849,3,1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',2647.48,NULL,NULL,1,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(1968,7478,41611,162849,3,1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',63004.80,NULL,NULL,1,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(1969,7478,41611,162849,3,1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',24900.00,NULL,NULL,1,'2022-08-18 11:13:59','2022-08-18 11:32:48','2022-08-18 11:32:48'),(1970,7478,41611,162849,3,1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',31208.00,NULL,NULL,1,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(1971,7478,41611,162849,3,1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',0.93,NULL,NULL,1,'2022-08-18 11:13:59','2022-08-18 11:32:40','2022-08-18 11:32:40'),(1972,7478,41611,162849,3,1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',715.00,NULL,NULL,1,'2022-08-18 11:13:59','2022-08-18 11:32:24','2022-08-18 11:32:24'),(1973,7478,41611,162849,3,1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',13407.77,NULL,NULL,1,'2022-08-18 11:24:37','2022-08-18 11:24:37',NULL),(1974,7478,41611,162849,3,1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',8500.00,NULL,NULL,1,'2022-08-18 11:26:38','2022-08-18 11:26:38',NULL),(1975,7478,40746,37696,3,1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',1790.16,NULL,NULL,1,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1976,7478,40746,37696,3,1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',6499.00,NULL,NULL,1,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1977,7478,40746,37696,3,1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',2464.82,NULL,NULL,1,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1978,7478,40746,37696,3,1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',3986.10,NULL,NULL,1,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1979,7478,40746,37696,3,1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',3165.72,NULL,NULL,1,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1980,7478,40746,37696,3,1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',4912.60,NULL,NULL,1,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1981,7478,40746,37696,3,1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',483.52,NULL,NULL,1,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1982,7478,40746,37696,3,1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',1084.88,NULL,NULL,1,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1983,7478,40746,37696,3,1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',1656.97,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1984,7478,40746,37696,3,1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',532.93,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1985,7478,40746,37696,3,1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',1524.60,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1986,7478,40746,37696,3,1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',3663.70,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16');
INSERT INTO `balance_libro` VALUES (1987,7478,40746,37696,3,1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',7320.50,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1988,7478,40746,37696,3,1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',172364.50,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1989,7478,40746,37696,3,1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',1999.54,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1990,7478,40746,37696,3,1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',4719.00,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1991,7478,40746,37696,3,1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',6308.44,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1992,7478,40746,37696,3,1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',4731.33,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1993,7478,40746,37696,3,1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',3044.36,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1994,7478,40746,37696,3,1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',12668.70,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1995,7478,40746,37696,3,1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10164.00,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1996,7478,40746,37696,3,1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13310.00,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1997,7478,40746,37696,3,1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11434.50,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1998,7478,40746,37696,3,1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',16879.50,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(1999,7478,40746,37696,3,1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11253.00,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2000,7478,40746,37696,3,1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',9801.00,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2001,7478,40746,37696,3,1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',12069.75,NULL,NULL,1,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2002,7478,40746,37696,3,1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10650.42,NULL,NULL,1,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2003,7478,40746,37696,3,1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14822.50,NULL,NULL,1,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2004,7478,40746,37696,3,1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10587.50,NULL,NULL,1,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2005,7478,40746,37696,3,1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14278.00,NULL,NULL,1,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2006,7478,40746,37696,3,1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11544.00,NULL,NULL,1,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2007,7478,40746,37696,3,1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',9890.00,NULL,NULL,1,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2008,7478,40746,37696,3,1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10440.00,NULL,NULL,1,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16');
INSERT INTO `balance_libro` VALUES (2009,7478,40746,37696,3,1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10752.00,NULL,NULL,1,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2010,7478,40746,37696,3,1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10788.00,NULL,NULL,1,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2011,7478,40746,37696,3,1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',15312.00,NULL,NULL,1,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2012,7478,40746,37696,3,1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',8930.00,NULL,NULL,1,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2013,7478,40746,37696,3,1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14382.00,NULL,NULL,1,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2014,7478,40746,37696,3,1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',8990.00,NULL,NULL,1,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2015,7478,40746,37696,3,1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14048.10,NULL,NULL,1,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2016,7478,40746,37696,3,1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11168.00,NULL,NULL,1,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2017,7478,40746,37696,3,1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11858.00,NULL,NULL,1,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2018,7478,40746,37696,3,1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14964.00,NULL,NULL,1,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2019,7478,40746,37696,3,1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14268.00,NULL,NULL,1,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2020,7478,40746,37696,3,2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14550.00,NULL,NULL,1,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2021,7478,40746,37696,3,2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',15592.00,NULL,NULL,1,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2022,7478,40746,37696,3,2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13972.00,NULL,NULL,1,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2023,7478,40746,37696,3,2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11153.00,NULL,NULL,1,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2024,7478,40746,37696,3,2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13080.00,NULL,NULL,1,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2025,7478,40746,37696,3,2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14940.00,NULL,NULL,1,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2026,7478,40746,37696,3,2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14385.00,NULL,NULL,1,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2027,7478,40746,37696,3,2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11580.00,NULL,NULL,1,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2028,7478,40746,37696,3,2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',16710.00,NULL,NULL,1,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2029,7478,40746,37696,3,2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',15574.00,NULL,NULL,1,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(2030,7478,40746,37696,3,2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13950.00,NULL,NULL,1,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16');
INSERT INTO `balance_libro` VALUES (2031,7478,40746,37696,3,2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10485.00,NULL,NULL,1,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2032,7478,40746,37696,3,2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',16296.00,NULL,NULL,1,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2033,7478,40746,37696,3,2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',9990.00,NULL,NULL,1,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2034,7478,40746,37696,3,2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14955.00,NULL,NULL,1,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2035,7478,40746,37696,3,2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10660.00,NULL,NULL,1,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2036,7478,40746,37696,3,2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13494.00,NULL,NULL,1,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2037,7478,40746,37696,3,2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14955.00,NULL,NULL,1,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2038,7478,40746,37696,3,2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14220.00,NULL,NULL,1,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2039,7478,40746,37696,3,2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',12954.00,NULL,NULL,1,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2040,7478,40746,37696,3,2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',17280.00,NULL,NULL,1,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2041,7478,40746,37696,3,2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14955.00,NULL,NULL,1,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2042,7478,40746,37696,3,2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14958.00,NULL,NULL,1,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2043,7478,40746,37696,3,2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14097.00,NULL,NULL,1,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2044,7478,40746,37696,3,2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',16800.00,NULL,NULL,1,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2045,7478,40746,37696,3,2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',16650.00,NULL,NULL,1,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2046,7478,40746,37696,3,2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10990.00,NULL,NULL,1,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2047,7478,40746,37696,3,2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14745.00,NULL,NULL,1,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2048,7478,40746,37696,3,2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13536.00,NULL,NULL,1,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2049,7478,40746,37696,3,2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13960.00,NULL,NULL,1,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2050,7478,40746,37696,3,2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',15804.00,NULL,NULL,1,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2051,7478,40746,37696,3,2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14304.00,NULL,NULL,1,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2052,7478,40746,37696,3,2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',12894.00,NULL,NULL,1,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17');
INSERT INTO `balance_libro` VALUES (2053,7478,40746,37696,3,2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14358.00,NULL,NULL,1,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2054,7478,40746,37696,3,2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',8010.00,NULL,NULL,1,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2055,7478,40746,37696,3,2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',7236.41,NULL,NULL,1,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2056,7478,40746,37696,3,2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',7816.23,NULL,NULL,1,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2057,7478,40746,37696,3,2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',588.06,NULL,NULL,1,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(2058,7478,41798,161343,3,2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',1699.92,NULL,NULL,1,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(2059,7478,41798,161343,3,2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',11000.00,NULL,NULL,1,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(2060,7478,41798,161343,3,2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',6300.00,NULL,NULL,1,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(2061,7478,41798,161343,3,2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',498.90,NULL,NULL,1,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(2062,7478,41798,161343,3,2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',7700.00,NULL,NULL,1,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(2063,7478,41798,161343,3,2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',63250.00,NULL,NULL,1,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(2064,7478,41798,161343,3,2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',1790.00,NULL,NULL,1,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(2065,7478,41798,161343,3,2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',4000.01,NULL,NULL,1,'2022-08-30 13:06:43','2022-08-30 13:06:43',NULL),(2066,7478,41798,161343,3,2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',2400.00,NULL,NULL,1,'2022-08-30 13:06:43','2022-08-30 13:06:43',NULL),(2067,7478,41798,161343,3,2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',3970.00,NULL,NULL,1,'2022-08-30 13:06:43','2022-08-30 13:06:43',NULL),(2068,7478,41798,161343,3,2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',15282.30,NULL,NULL,1,'2022-08-30 13:06:43','2022-08-30 13:06:43',NULL),(2069,7478,40784,78387,3,2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',6232.64,NULL,NULL,1,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2070,7478,40784,78387,3,2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',75212.17,NULL,NULL,1,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2071,7478,40784,78387,3,2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',55454.15,NULL,NULL,1,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2072,7478,40784,78387,3,2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',57915.59,NULL,NULL,1,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2073,7478,40784,78387,3,2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',43120.19,NULL,NULL,1,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2074,7478,40784,78387,3,2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',36178.26,NULL,NULL,1,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2075,7478,40784,78387,3,2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',20945.18,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39');
INSERT INTO `balance_libro` VALUES (2076,7478,40784,78387,3,2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',12012.77,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2077,7478,40784,78387,3,2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',90497.69,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2078,7478,40784,78387,3,2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',106865.15,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2079,7478,40784,78387,3,2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',54454.09,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2080,7478,40784,78387,3,2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',104242.63,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2081,7478,40784,78387,3,2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',6757.56,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2082,7478,40784,78387,3,2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',1135680.00,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2083,7478,40784,78387,3,2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',218400.00,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2084,7478,40784,78387,3,2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',136400.00,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2085,7478,40784,78387,3,2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',31708.96,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2086,7478,40784,78387,3,2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',31708.96,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2087,7478,40784,78387,3,2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',81910.01,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2088,7478,40784,78387,3,2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',18461.78,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2089,7478,40784,78387,3,2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',3538.12,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2090,7478,40784,78387,3,2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',53912.06,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(2091,7478,40784,78387,3,2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',62392.17,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2092,7478,40784,78387,3,2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',89717.06,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2093,7478,40784,78387,3,2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',74547.25,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2094,7478,40784,78387,3,2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',11740.90,NULL,NULL,1,'2022-08-30 13:10:48','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2095,7478,40784,78387,3,2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',75465.02,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2096,7478,40784,78387,3,2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',133731.67,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2097,7478,40784,78387,3,2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',2093.71,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40');
INSERT INTO `balance_libro` VALUES (2098,7478,40784,78387,3,2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',127060.42,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2099,7478,40784,78387,3,2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',101059.94,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2100,7478,40784,78387,3,2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',141230.96,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2101,7478,40784,78387,3,2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',72979.44,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2102,7478,40784,78387,3,2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',15185.23,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2103,7478,40784,78387,3,2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',24153.41,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2104,7478,40784,78387,3,2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',3100.00,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2105,7478,40784,78387,3,2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',72070.70,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2106,7478,40784,78387,3,2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',29619.42,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2107,7478,40784,78387,3,2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',44749.95,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2108,7478,40784,78387,3,2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',55618.78,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2109,7478,40784,78387,3,2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',19249.00,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2110,7478,40784,78387,3,2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',34833.79,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2111,7478,40784,78387,3,2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',39950.10,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2112,7478,40784,78387,3,2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',33980.36,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2113,7478,40784,78387,3,2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',8772.81,NULL,NULL,1,'2022-08-30 13:10:49','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2114,7478,40784,78387,3,2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',72711.82,NULL,NULL,1,'2022-08-30 13:10:50','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2115,7478,40784,78387,3,2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',57525.79,NULL,NULL,1,'2022-08-30 13:10:50','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2116,7478,40784,78387,3,2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',42642.33,NULL,NULL,1,'2022-08-30 13:10:50','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2117,7478,40784,78387,3,2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',62805.17,NULL,NULL,1,'2022-08-30 13:10:50','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2118,7478,40784,78387,3,2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',29366.76,NULL,NULL,1,'2022-08-30 13:10:50','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2119,7478,40784,78387,3,2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',84794.77,NULL,NULL,1,'2022-08-30 13:10:50','2022-09-01 09:31:40','2022-09-01 09:31:40');
INSERT INTO `balance_libro` VALUES (2120,7478,40784,78387,3,2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',71045.35,NULL,NULL,1,'2022-08-30 13:10:50','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2121,7478,40784,78387,3,2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',31229.77,NULL,NULL,1,'2022-08-30 13:10:50','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2122,7478,40784,78387,3,2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14868.53,NULL,NULL,1,'2022-08-30 13:10:50','2022-09-01 09:31:40','2022-09-01 09:31:40'),(2123,7478,40784,78387,2,2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',20000.00,NULL,NULL,1,'2022-08-30 13:12:04','2022-09-01 09:31:27','2022-09-01 09:31:27'),(2124,7478,40784,78387,2,2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',20000.00,NULL,NULL,1,'2022-08-30 13:12:04','2022-09-01 09:31:27','2022-09-01 09:31:27'),(2125,7478,40784,78387,2,2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',226312.89,NULL,NULL,1,'2022-08-30 13:12:04','2022-09-01 09:31:27','2022-09-01 09:31:27'),(2126,7478,40746,37696,2,2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',1790.16,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:51','2022-09-08 11:39:51'),(2127,7478,40746,37696,2,2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',6499.00,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:51','2022-09-08 11:39:51'),(2128,7478,40746,37696,2,2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',2464.82,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:51','2022-09-08 11:39:51'),(2129,7478,40746,37696,2,2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',3986.10,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:51','2022-09-08 11:39:51'),(2130,7478,40746,37696,2,2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',3165.72,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:51','2022-09-08 11:39:51'),(2131,7478,40746,37696,2,2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',4912.60,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:51','2022-09-08 11:39:51'),(2132,7478,40746,37696,2,2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',483.52,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:51','2022-09-08 11:39:51'),(2133,7478,40746,37696,2,2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',1084.88,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:51','2022-09-08 11:39:51'),(2134,7478,40746,37696,2,2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',1656.97,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:51','2022-09-08 11:39:51'),(2135,7478,40746,37696,2,2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',532.93,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:51','2022-09-08 11:39:51'),(2136,7478,40746,37696,2,2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',1524.60,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:51','2022-09-08 11:39:51'),(2137,7478,40746,37696,2,2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',3663.70,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:51','2022-09-08 11:39:51'),(2138,7478,40746,37696,2,2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',7320.50,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:51','2022-09-08 11:39:51'),(2139,7478,40746,37696,2,2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',172364.50,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:51','2022-09-08 11:39:51'),(2140,7478,40746,37696,2,2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',1999.54,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:51','2022-09-08 11:39:51'),(2141,7478,40746,37696,2,2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',4719.00,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:51','2022-09-08 11:39:51');
INSERT INTO `balance_libro` VALUES (2142,7478,40746,37696,2,2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',6308.44,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:51','2022-09-08 11:39:51'),(2143,7478,40746,37696,2,2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',4731.33,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2144,7478,40746,37696,2,2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',3044.36,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2145,7478,40746,37696,2,2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',12668.70,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2146,7478,40746,37696,2,2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10164.00,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2147,7478,40746,37696,2,2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13310.00,NULL,NULL,1,'2022-08-31 09:39:37','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2148,7478,40746,37696,2,2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11434.50,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2149,7478,40746,37696,2,2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',16879.50,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2150,7478,40746,37696,2,2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11253.00,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2151,7478,40746,37696,2,2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',9801.00,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2152,7478,40746,37696,2,2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',12069.75,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2153,7478,40746,37696,2,2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10650.42,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2154,7478,40746,37696,2,2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14822.50,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2155,7478,40746,37696,2,2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10587.50,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2156,7478,40746,37696,2,2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14278.00,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2157,7478,40746,37696,2,2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11544.00,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2158,7478,40746,37696,2,2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',9890.00,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2159,7478,40746,37696,2,2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10440.00,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2160,7478,40746,37696,2,2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10752.00,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2161,7478,40746,37696,2,2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10788.00,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2162,7478,40746,37696,2,2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',15312.00,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2163,7478,40746,37696,2,2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',8930.00,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52');
INSERT INTO `balance_libro` VALUES (2164,7478,40746,37696,2,2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14382.00,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2165,7478,40746,37696,2,2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',8990.00,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2166,7478,40746,37696,2,2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14048.10,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2167,7478,40746,37696,2,2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11168.00,NULL,NULL,1,'2022-08-31 09:39:38','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2168,7478,40746,37696,2,2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11858.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2169,7478,40746,37696,2,2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14964.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2170,7478,40746,37696,2,2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14268.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2171,7478,40746,37696,2,2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14550.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2172,7478,40746,37696,2,2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',15592.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2173,7478,40746,37696,2,2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13972.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2174,7478,40746,37696,2,2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11153.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2175,7478,40746,37696,2,2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13080.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2176,7478,40746,37696,2,2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14940.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2177,7478,40746,37696,2,2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14385.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2178,7478,40746,37696,2,2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11580.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2179,7478,40746,37696,2,2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',16710.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2180,7478,40746,37696,2,2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',15574.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2181,7478,40746,37696,2,2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13950.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2182,7478,40746,37696,2,2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10485.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2183,7478,40746,37696,2,2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',16296.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2184,7478,40746,37696,2,2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',9990.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2185,7478,40746,37696,2,2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14955.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52');
INSERT INTO `balance_libro` VALUES (2186,7478,40746,37696,2,2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10660.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2187,7478,40746,37696,2,2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13494.00,NULL,NULL,1,'2022-08-31 09:39:39','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2188,7478,40746,37696,2,2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14955.00,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2189,7478,40746,37696,2,2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14220.00,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2190,7478,40746,37696,2,2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',12954.00,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2191,7478,40746,37696,2,2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',17280.00,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2192,7478,40746,37696,2,2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14955.00,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2193,7478,40746,37696,2,2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14958.00,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2194,7478,40746,37696,2,2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14097.00,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2195,7478,40746,37696,2,2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',16800.00,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2196,7478,40746,37696,2,2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',16650.00,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2197,7478,40746,37696,2,2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10990.00,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2198,7478,40746,37696,2,2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14745.00,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2199,7478,40746,37696,2,2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13536.00,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2200,7478,40746,37696,2,2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13960.00,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2201,7478,40746,37696,2,2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',15804.00,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2202,7478,40746,37696,2,2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14304.00,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2203,7478,40746,37696,2,2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',12894.00,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2204,7478,40746,37696,2,2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14358.00,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2205,7478,40746,37696,2,2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',8010.00,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:52','2022-09-08 11:39:52'),(2206,7478,40746,37696,2,2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',7236.41,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:53','2022-09-08 11:39:53'),(2207,7478,40746,37696,2,2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',7816.23,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:53','2022-09-08 11:39:53');
INSERT INTO `balance_libro` VALUES (2208,7478,40746,37696,2,2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',588.06,NULL,NULL,1,'2022-08-31 09:39:40','2022-09-08 11:39:53','2022-09-08 11:39:53'),(2209,7478,40746,37696,3,2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',401490.52,NULL,NULL,1,'2022-08-31 09:40:39','2022-09-08 11:37:33','2022-09-08 11:37:33'),(2210,7478,40746,37696,3,2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',1013.84,NULL,NULL,1,'2022-08-31 09:40:39','2022-09-08 11:37:33','2022-09-08 11:37:33'),(2211,7478,40746,37696,3,2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',8763.04,NULL,NULL,1,'2022-08-31 09:40:39','2022-09-08 11:37:33','2022-09-08 11:37:33'),(2212,7478,40746,37696,3,2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',59656.03,NULL,NULL,1,'2022-08-31 09:40:39','2022-09-08 11:37:33','2022-09-08 11:37:33'),(2213,7478,40746,37696,3,2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',625385.25,NULL,NULL,1,'2022-08-31 09:40:39','2022-09-08 11:37:33','2022-09-08 11:37:33'),(2214,7478,40746,37696,3,2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',353745.54,NULL,NULL,1,'2022-08-31 09:40:39','2022-09-08 11:37:33','2022-09-08 11:37:33'),(2215,7478,40784,78387,2,2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',20000.00,NULL,NULL,1,'2022-09-01 09:32:08','2022-09-01 09:32:08',NULL),(2216,7478,40784,78387,2,2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',20000.00,NULL,NULL,1,'2022-09-01 09:32:08','2022-09-01 09:32:08',NULL),(2217,7478,40784,78387,2,2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',226312.89,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2218,7478,40784,78387,2,2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',24000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2219,7478,40784,78387,2,2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2220,7478,40784,78387,2,2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2221,7478,40784,78387,2,2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2222,7478,40784,78387,2,2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2223,7478,40784,78387,2,2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2224,7478,40784,78387,2,2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2225,7478,40784,78387,2,2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2226,7478,40784,78387,2,2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2227,7478,40784,78387,2,2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2228,7478,40784,78387,2,2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2229,7478,40784,78387,2,2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2230,7478,40784,78387,2,2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL);
INSERT INTO `balance_libro` VALUES (2231,7478,40784,78387,2,2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2232,7478,40784,78387,2,2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2233,7478,40784,78387,2,2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2234,7478,40784,78387,2,2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2235,7478,40784,78387,2,2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2236,7478,40784,78387,2,2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2237,7478,40784,78387,2,2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2238,7478,40784,78387,2,2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:09','2022-09-01 09:32:09',NULL),(2239,7478,40784,78387,2,2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:10','2022-09-01 09:32:10',NULL),(2240,7478,40784,78387,2,2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:10','2022-09-01 09:32:10',NULL),(2241,7478,40784,78387,2,2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:10','2022-09-01 09:32:10',NULL),(2242,7478,40784,78387,2,2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:10','2022-09-01 09:32:10',NULL),(2243,7478,40784,78387,2,2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',20001.30,NULL,NULL,1,'2022-09-01 09:32:10','2022-09-01 09:32:10',NULL),(2244,7478,40784,78387,2,2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',24200.00,NULL,NULL,1,'2022-09-01 09:32:10','2022-09-01 09:32:10',NULL),(2245,7478,40784,78387,2,2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',24200.00,NULL,NULL,1,'2022-09-01 09:32:10','2022-09-01 09:32:10',NULL),(2246,7478,40784,78387,2,2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:10','2022-09-01 09:32:10',NULL),(2247,7478,40784,78387,2,2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:10','2022-09-01 09:32:10',NULL),(2248,7478,40784,78387,2,2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:10','2022-09-01 09:32:10',NULL),(2249,7478,40784,78387,2,2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:10','2022-09-01 09:32:10',NULL),(2250,7478,40784,78387,2,2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:10','2022-09-01 09:32:10',NULL),(2251,7478,40784,78387,2,2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:10','2022-09-01 09:32:10',NULL),(2252,7478,40784,78387,2,2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:10','2022-09-01 09:32:10',NULL),(2253,7478,40784,78387,2,2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:10','2022-09-01 09:32:10',NULL),(2254,7478,40784,78387,2,2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:10','2022-09-01 09:32:10',NULL);
INSERT INTO `balance_libro` VALUES (2255,7478,40784,78387,2,2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:10','2022-09-01 09:32:10',NULL),(2256,7478,40784,78387,2,2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:10','2022-09-01 09:32:10',NULL),(2257,7478,40784,78387,2,2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2258,7478,40784,78387,2,2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2259,7478,40784,78387,2,2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2260,7478,40784,78387,2,2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2261,7478,40784,78387,2,2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2262,7478,40784,78387,2,2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2263,7478,40784,78387,2,2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2264,7478,40784,78387,2,2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2265,7478,40784,78387,2,2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2266,7478,40784,78387,2,2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25001.02,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2267,7478,40784,78387,2,2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',26620.00,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2268,7478,40784,78387,2,2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',29040.00,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2269,7478,40784,78387,2,2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',29040.00,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2270,7478,40784,78387,2,2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',29040.00,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2271,7478,40784,78387,2,2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',29040.00,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2272,7478,40784,78387,2,2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',30008.00,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2273,7478,40784,78387,2,2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',30008.00,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2274,7478,40784,78387,2,2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',30008.00,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2275,7478,40784,78387,2,2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',30008.00,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2276,7478,40784,78387,2,2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',36300.00,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2277,7478,40784,78387,2,2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',36300.00,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL),(2278,7478,40784,78387,2,2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',36300.00,NULL,NULL,1,'2022-09-01 09:32:11','2022-09-01 09:32:11',NULL);
INSERT INTO `balance_libro` VALUES (2279,7478,40784,78387,2,2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',36300.00,NULL,NULL,1,'2022-09-01 09:32:12','2022-09-01 09:32:12',NULL),(2280,7478,40784,78387,2,2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',36300.00,NULL,NULL,1,'2022-09-01 09:32:12','2022-09-01 09:32:12',NULL),(2281,7478,40784,78387,2,2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',36300.00,NULL,NULL,1,'2022-09-01 09:32:12','2022-09-01 09:32:12',NULL),(2282,7478,40784,78387,2,2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',36300.00,NULL,NULL,1,'2022-09-01 09:32:12','2022-09-01 09:32:12',NULL),(2283,7478,40784,78387,2,2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:12','2022-09-01 09:32:12',NULL),(2284,7478,40784,78387,2,2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:12','2022-09-01 09:32:12',NULL),(2285,7478,40784,78387,2,2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:12','2022-09-01 09:32:12',NULL),(2286,7478,40784,78387,2,2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:12','2022-09-01 09:32:12',NULL),(2287,7478,40784,78387,2,2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:12','2022-09-01 09:32:12',NULL),(2288,7478,40784,78387,2,2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:12','2022-09-01 09:32:12',NULL),(2289,7478,40784,78387,2,2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:12','2022-09-01 09:32:12',NULL),(2290,7478,40784,78387,2,2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:12','2022-09-01 09:32:12',NULL),(2291,7478,40784,78387,2,2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:12','2022-09-01 09:32:12',NULL),(2292,7478,40784,78387,2,2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:12','2022-09-01 09:32:12',NULL),(2293,7478,40784,78387,2,2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:12','2022-09-01 09:32:12',NULL),(2294,7478,40784,78387,2,2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:12','2022-09-01 09:32:12',NULL),(2295,7478,40784,78387,2,2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',21000.00,NULL,NULL,1,'2022-09-01 09:32:12','2022-09-01 09:32:12',NULL),(2296,7478,40784,78387,3,2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',6232.64,NULL,NULL,1,'2022-09-01 09:32:25','2022-09-01 09:32:25',NULL),(2297,7478,40784,78387,3,2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',75212.17,NULL,NULL,1,'2022-09-01 09:32:25','2022-09-01 09:32:25',NULL),(2298,7478,40784,78387,3,2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',55454.15,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL),(2299,7478,40784,78387,3,2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',57915.59,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL),(2300,7478,40784,78387,3,2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',43120.19,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL),(2301,7478,40784,78387,3,2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',36178.26,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL),(2302,7478,40784,78387,3,2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',20945.18,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL);
INSERT INTO `balance_libro` VALUES (2303,7478,40784,78387,3,2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',12012.77,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL),(2304,7478,40784,78387,3,2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',90497.69,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL),(2305,7478,40784,78387,3,2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',106865.15,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL),(2306,7478,40784,78387,3,2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',54454.09,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL),(2307,7478,40784,78387,3,2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',104242.63,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL),(2308,7478,40784,78387,3,2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',6757.56,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL),(2309,7478,40784,78387,3,2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',1135680.00,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL),(2310,7478,40784,78387,3,2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',218400.00,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL),(2311,7478,40784,78387,3,2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',136400.00,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL),(2312,7478,40784,78387,3,2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',31708.96,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL),(2313,7478,40784,78387,3,2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',31708.96,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL),(2314,7478,40784,78387,3,2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',81910.01,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL),(2315,7478,40784,78387,3,2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',18461.78,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL),(2316,7478,40784,78387,3,2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',3538.12,NULL,NULL,1,'2022-09-01 09:32:26','2022-09-01 09:32:26',NULL),(2317,7478,40784,78387,3,2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',53912.06,NULL,NULL,1,'2022-09-01 09:32:27','2022-09-01 09:32:27',NULL),(2318,7478,40784,78387,3,2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',62392.17,NULL,NULL,1,'2022-09-01 09:32:27','2022-09-01 09:32:27',NULL),(2319,7478,40784,78387,3,2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',89717.06,NULL,NULL,1,'2022-09-01 09:32:27','2022-09-01 09:32:27',NULL),(2320,7478,40784,78387,3,2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',74547.25,NULL,NULL,1,'2022-09-01 09:32:27','2022-09-01 09:32:27',NULL),(2321,7478,40784,78387,3,2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',11740.90,NULL,NULL,1,'2022-09-01 09:32:27','2022-09-01 09:32:27',NULL),(2322,7478,40784,78387,3,2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',75465.02,NULL,NULL,1,'2022-09-01 09:32:27','2022-09-01 09:32:27',NULL),(2323,7478,40784,78387,3,2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',133731.67,NULL,NULL,1,'2022-09-01 09:32:27','2022-09-01 09:32:27',NULL),(2324,7478,40784,78387,3,2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',2093.71,NULL,NULL,1,'2022-09-01 09:32:27','2022-09-01 09:32:27',NULL),(2325,7478,40784,78387,3,2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',127060.42,NULL,NULL,1,'2022-09-01 09:32:27','2022-09-01 09:32:27',NULL),(2326,7478,40784,78387,3,2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',101059.94,NULL,NULL,1,'2022-09-01 09:32:27','2022-09-01 09:32:27',NULL);
INSERT INTO `balance_libro` VALUES (2327,7478,40784,78387,3,2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',141230.96,NULL,NULL,1,'2022-09-01 09:32:27','2022-09-01 09:32:27',NULL),(2328,7478,40784,78387,3,2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',72979.44,NULL,NULL,1,'2022-09-01 09:32:27','2022-09-01 09:32:27',NULL),(2329,7478,40784,78387,3,2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',15185.23,NULL,NULL,1,'2022-09-01 09:32:27','2022-09-01 09:32:27',NULL),(2330,7478,40784,78387,3,2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',24153.41,NULL,NULL,1,'2022-09-01 09:32:27','2022-09-01 09:32:27',NULL),(2331,7478,40784,78387,3,2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',3100.00,NULL,NULL,1,'2022-09-01 09:32:28','2022-09-01 09:32:28',NULL),(2332,7478,40784,78387,3,2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',72070.70,NULL,NULL,1,'2022-09-01 09:32:28','2022-09-01 09:32:28',NULL),(2333,7478,40784,78387,3,2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',29619.42,NULL,NULL,1,'2022-09-01 09:32:28','2022-09-01 09:32:28',NULL),(2334,7478,40784,78387,3,2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',44749.95,NULL,NULL,1,'2022-09-01 09:32:28','2022-09-01 09:32:28',NULL),(2335,7478,40784,78387,3,2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',55618.78,NULL,NULL,1,'2022-09-01 09:32:28','2022-09-01 09:32:28',NULL),(2336,7478,40784,78387,3,2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',19249.00,NULL,NULL,1,'2022-09-01 09:32:28','2022-09-19 12:31:24','2022-09-19 12:31:24'),(2337,7478,40784,78387,3,2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',34833.79,NULL,NULL,1,'2022-09-01 09:32:28','2022-09-01 09:32:28',NULL),(2338,7478,40784,78387,3,2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',39950.10,NULL,NULL,1,'2022-09-01 09:32:28','2022-09-01 09:32:28',NULL),(2339,7478,40784,78387,3,2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',33980.36,NULL,NULL,1,'2022-09-01 09:32:28','2022-09-01 09:32:28',NULL),(2340,7478,40784,78387,3,2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',8772.81,NULL,NULL,1,'2022-09-01 09:32:28','2022-09-01 09:32:28',NULL),(2341,7478,40784,78387,3,2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',72711.82,NULL,NULL,1,'2022-09-01 09:32:28','2022-09-01 09:32:28',NULL),(2342,7478,40784,78387,3,2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',57525.79,NULL,NULL,1,'2022-09-01 09:32:28','2022-09-01 09:32:28',NULL),(2343,7478,40784,78387,3,2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',42642.33,NULL,NULL,1,'2022-09-01 09:32:28','2022-09-01 09:32:28',NULL),(2344,7478,40784,78387,3,2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',62805.17,NULL,NULL,1,'2022-09-01 09:32:29','2022-09-01 09:32:29',NULL),(2345,7478,40784,78387,3,2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',29366.76,NULL,NULL,1,'2022-09-01 09:32:29','2022-09-01 09:32:29',NULL),(2346,7478,40784,78387,3,2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',84794.77,NULL,NULL,1,'2022-09-01 09:32:29','2022-09-01 09:32:29',NULL),(2347,7478,40784,78387,3,2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',71045.35,NULL,NULL,1,'2022-09-01 09:32:29','2022-09-01 09:32:29',NULL),(2348,7478,40784,78387,3,2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',31229.77,NULL,NULL,1,'2022-09-01 09:32:29','2022-09-01 09:32:29',NULL),(2349,7478,40784,78387,3,2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14868.53,NULL,NULL,1,'2022-09-01 09:32:29','2022-09-01 09:32:29',NULL),(2350,7478,41722,82979,2,2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',68972.42,NULL,NULL,1,'2022-09-08 10:46:41','2022-09-08 10:46:41',NULL);
INSERT INTO `balance_libro` VALUES (2351,7478,41722,82979,2,2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',68972.42,NULL,NULL,1,'2022-09-08 10:46:41','2022-09-08 10:46:41',NULL),(2352,7478,41722,82979,2,2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',68972.42,NULL,NULL,1,'2022-09-08 10:46:41','2022-09-08 10:46:41',NULL),(2353,7478,41722,82979,2,2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',68972.42,NULL,NULL,1,'2022-09-08 10:46:41','2022-09-08 10:46:41',NULL),(2354,7478,41722,82979,2,2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',61710.00,NULL,NULL,1,'2022-09-08 10:46:41','2022-09-08 10:46:41',NULL),(2355,7478,41722,82979,2,2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',61710.00,NULL,NULL,1,'2022-09-08 10:46:41','2022-09-08 10:46:41',NULL),(2365,7478,41722,82979,3,2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',690.00,NULL,NULL,1,'2022-09-08 10:54:57','2022-09-08 10:54:57',NULL),(2366,7478,41722,82979,3,2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',903.88,NULL,NULL,1,'2022-09-08 10:54:57','2022-09-08 10:54:57',NULL),(2367,7478,41722,82979,3,2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',10217.56,NULL,NULL,1,'2022-09-08 10:54:58','2022-09-08 10:54:58',NULL),(2368,7478,41722,82979,3,2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',5800.00,NULL,NULL,1,'2022-09-08 10:54:58','2022-09-08 10:54:58',NULL),(2369,7478,41722,82979,3,2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',2400.00,NULL,NULL,1,'2022-09-08 10:54:58','2022-09-08 10:54:58',NULL),(2370,7478,41722,82979,3,2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',2600.00,NULL,NULL,1,'2022-09-08 10:54:58','2022-09-08 10:54:58',NULL),(2371,7478,41722,82979,3,2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',1400.56,NULL,NULL,1,'2022-09-08 10:54:58','2022-09-08 10:54:58',NULL),(2372,7478,41722,82979,3,2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',2993.55,NULL,NULL,1,'2022-09-08 10:54:58','2022-09-08 10:54:58',NULL),(2373,7478,41722,82979,3,2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',8490.80,NULL,NULL,1,'2022-09-08 10:54:58','2022-09-08 10:54:58',NULL),(2374,7478,41722,82979,3,2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',5399.95,NULL,NULL,1,'2022-09-08 10:54:58','2022-09-08 10:54:58',NULL),(2375,7478,41722,82979,3,2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',600.03,NULL,NULL,1,'2022-09-08 10:54:58','2022-09-08 10:54:58',NULL),(2376,7478,41722,82979,3,2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',79545.77,NULL,NULL,1,'2022-09-08 10:54:58','2022-09-08 10:54:58',NULL),(2377,7478,41722,82979,3,2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',2000.00,NULL,NULL,1,'2022-09-08 10:54:58','2022-09-08 10:54:58',NULL),(2378,7478,41722,82979,3,2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',801338.51,NULL,NULL,1,'2022-09-08 10:54:58','2022-09-08 10:54:58',NULL),(2379,7478,41722,82979,3,2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1680.00,NULL,NULL,1,'2022-09-08 10:54:58','2022-09-08 10:54:58',NULL),(2380,7478,41722,82979,3,2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2500.01,NULL,NULL,1,'2022-09-08 11:04:07','2022-09-08 11:04:07',NULL),(2381,7478,41722,82979,3,2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',7850.00,NULL,NULL,1,'2022-09-08 11:07:29','2022-09-08 11:07:29',NULL),(2382,7478,41722,82979,3,2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',5000.05,NULL,NULL,1,'2022-09-08 11:11:51','2022-09-08 11:11:51',NULL),(2383,7478,41722,82979,3,2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',5313.77,NULL,NULL,1,'2022-09-08 11:15:47','2022-09-08 11:15:47',NULL);
INSERT INTO `balance_libro` VALUES (2384,7478,41722,82979,3,2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',3420.08,NULL,NULL,1,'2022-09-08 11:16:56','2022-09-08 11:16:56',NULL),(2385,7478,41722,82979,3,2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',3199.40,NULL,NULL,1,'2022-09-08 11:17:51','2022-09-08 11:17:51',NULL),(2386,7478,40746,37696,3,2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',401490.52,NULL,NULL,1,'2022-09-08 11:38:30','2022-09-08 11:38:30',NULL),(2387,7478,40746,37696,3,2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',1013.84,NULL,NULL,1,'2022-09-08 11:38:30','2022-09-08 11:38:30',NULL),(2388,7478,40746,37696,3,2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',8763.04,NULL,NULL,1,'2022-09-08 11:38:30','2022-09-08 11:38:30',NULL),(2389,7478,40746,37696,3,2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',59656.03,NULL,NULL,1,'2022-09-08 11:38:30','2022-09-08 11:38:30',NULL),(2390,7478,40746,37696,3,2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',625385.25,NULL,NULL,1,'2022-09-08 11:38:30','2022-09-08 11:38:30',NULL),(2391,7478,40746,37696,3,2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',353745.54,NULL,NULL,1,'2022-09-08 11:38:30','2022-09-08 11:38:30',NULL),(2392,7478,40746,37696,3,2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',243.83,NULL,NULL,1,'2022-09-08 11:38:30','2022-09-08 11:38:30',NULL),(2393,7478,40746,37696,2,2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',1790.16,NULL,NULL,1,'2022-09-08 11:40:23','2022-09-08 11:40:23',NULL),(2394,7478,40746,37696,2,2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',6499.00,NULL,NULL,1,'2022-09-08 11:40:23','2022-09-08 11:40:23',NULL),(2395,7478,40746,37696,2,2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',2464.82,NULL,NULL,1,'2022-09-08 11:40:23','2022-09-08 11:40:23',NULL),(2396,7478,40746,37696,2,2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',3986.10,NULL,NULL,1,'2022-09-08 11:40:23','2022-09-08 11:40:23',NULL),(2397,7478,40746,37696,2,2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',3165.72,NULL,NULL,1,'2022-09-08 11:40:23','2022-09-08 11:40:23',NULL),(2398,7478,40746,37696,2,2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',4912.60,NULL,NULL,1,'2022-09-08 11:40:23','2022-09-08 11:40:23',NULL),(2399,7478,40746,37696,2,2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',483.52,NULL,NULL,1,'2022-09-08 11:40:23','2022-09-08 11:40:23',NULL),(2400,7478,40746,37696,2,2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',1084.88,NULL,NULL,1,'2022-09-08 11:40:23','2022-09-08 11:40:23',NULL),(2401,7478,40746,37696,2,2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',1656.97,NULL,NULL,1,'2022-09-08 11:40:23','2022-09-08 11:40:23',NULL),(2402,7478,40746,37696,2,2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',532.93,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2403,7478,40746,37696,2,2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',1524.60,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2404,7478,40746,37696,2,2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',3663.70,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2405,7478,40746,37696,2,2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',7320.50,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2406,7478,40746,37696,2,2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',172364.50,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2407,7478,40746,37696,2,2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',1999.54,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL);
INSERT INTO `balance_libro` VALUES (2408,7478,40746,37696,2,2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',4719.00,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2409,7478,40746,37696,2,2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',6308.44,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2410,7478,40746,37696,2,2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',4731.33,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2411,7478,40746,37696,2,2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',3044.36,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2412,7478,40746,37696,2,2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',12668.70,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2413,7478,40746,37696,2,2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10164.00,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2414,7478,40746,37696,2,2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13310.00,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2415,7478,40746,37696,2,2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11434.50,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2416,7478,40746,37696,2,2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',16879.50,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2417,7478,40746,37696,2,2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11253.00,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2418,7478,40746,37696,2,2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',9801.00,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2419,7478,40746,37696,2,2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',12069.75,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2420,7478,40746,37696,2,2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10650.42,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2421,7478,40746,37696,2,2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14822.50,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2422,7478,40746,37696,2,2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10587.50,NULL,NULL,1,'2022-09-08 11:40:24','2022-09-08 11:40:24',NULL),(2423,7478,40746,37696,2,2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14278.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2424,7478,40746,37696,2,2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11544.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2425,7478,40746,37696,2,2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',9890.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2426,7478,40746,37696,2,2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10440.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2427,7478,40746,37696,2,2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10752.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2428,7478,40746,37696,2,2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10788.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2429,7478,40746,37696,2,2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',15312.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2430,7478,40746,37696,2,2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',8930.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2431,7478,40746,37696,2,2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14382.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL);
INSERT INTO `balance_libro` VALUES (2432,7478,40746,37696,2,2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',8990.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2433,7478,40746,37696,2,2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14048.10,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2434,7478,40746,37696,2,2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11168.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2435,7478,40746,37696,2,2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11858.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2436,7478,40746,37696,2,2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14964.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2437,7478,40746,37696,2,2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14268.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2438,7478,40746,37696,2,2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14550.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2439,7478,40746,37696,2,2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',15592.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2440,7478,40746,37696,2,2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13972.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2441,7478,40746,37696,2,2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11153.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2442,7478,40746,37696,2,2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13080.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2443,7478,40746,37696,2,2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14940.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2444,7478,40746,37696,2,2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14385.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2445,7478,40746,37696,2,2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11580.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2446,7478,40746,37696,2,2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',16710.00,NULL,NULL,1,'2022-09-08 11:40:25','2022-09-08 11:40:25',NULL),(2447,7478,40746,37696,2,2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',15574.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2448,7478,40746,37696,2,2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13950.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2449,7478,40746,37696,2,2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10485.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2450,7478,40746,37696,2,2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',16296.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2451,7478,40746,37696,2,2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',9990.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2452,7478,40746,37696,2,2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14955.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2453,7478,40746,37696,2,2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10660.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2454,7478,40746,37696,2,2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13494.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2455,7478,40746,37696,2,2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14955.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL);
INSERT INTO `balance_libro` VALUES (2456,7478,40746,37696,2,2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14220.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2457,7478,40746,37696,2,2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',12954.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2458,7478,40746,37696,2,2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',17280.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2459,7478,40746,37696,2,2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14955.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2460,7478,40746,37696,2,2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14958.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2461,7478,40746,37696,2,2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14097.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2462,7478,40746,37696,2,2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',16800.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2463,7478,40746,37696,2,2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',16650.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2464,7478,40746,37696,2,2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10990.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2465,7478,40746,37696,2,2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14745.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2466,7478,40746,37696,2,2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13536.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2467,7478,40746,37696,2,2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',13960.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2468,7478,40746,37696,2,2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',15804.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2469,7478,40746,37696,2,2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14304.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2470,7478,40746,37696,2,2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',12894.00,NULL,NULL,1,'2022-09-08 11:40:26','2022-09-08 11:40:26',NULL),(2471,7478,40746,37696,2,2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14358.00,NULL,NULL,1,'2022-09-08 11:40:27','2022-09-08 11:40:27',NULL),(2472,7478,40746,37696,2,2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',8010.00,NULL,NULL,1,'2022-09-08 11:40:27','2022-09-08 11:40:27',NULL),(2473,7478,40746,37696,2,2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',7236.41,NULL,NULL,1,'2022-09-08 11:40:27','2022-09-08 11:40:27',NULL),(2474,7478,40746,37696,2,2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',7816.23,NULL,NULL,1,'2022-09-08 11:40:27','2022-09-08 11:40:27',NULL),(2475,7478,40746,37696,2,2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',588.06,NULL,NULL,1,'2022-09-08 11:40:27','2022-09-08 11:40:27',NULL),(2476,7478,40746,37696,2,2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',11311.08,NULL,NULL,1,'2022-09-08 11:40:27','2022-09-08 11:40:27',NULL),(2477,7478,40798,79894,3,2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',10345.50,NULL,NULL,1,'2022-09-08 11:43:48','2022-09-08 11:43:48',NULL),(2478,7478,40798,79894,3,2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',3590.00,NULL,NULL,1,'2022-09-08 11:43:48','2022-09-08 11:43:48',NULL),(2479,7478,40798,79894,3,2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',8670.00,NULL,NULL,1,'2022-09-08 11:43:48','2022-09-08 11:43:48',NULL);
INSERT INTO `balance_libro` VALUES (2480,7478,40798,79894,3,2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',7100.00,NULL,NULL,1,'2022-09-08 11:43:48','2022-09-08 11:43:48',NULL),(2481,7478,40798,79894,2,2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',19360.00,NULL,NULL,1,'2022-09-08 11:45:01','2022-09-08 11:45:01',NULL),(2482,7478,40798,79894,2,2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',16335.00,NULL,NULL,1,'2022-09-08 11:45:02','2022-09-08 11:45:02',NULL),(2483,7478,40798,79894,2,2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',22500.00,NULL,NULL,1,'2022-09-08 11:45:02','2022-09-08 11:45:02',NULL),(2484,7478,40798,79894,2,2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',19600.00,NULL,NULL,1,'2022-09-08 11:45:02','2022-09-08 11:45:02',NULL),(2485,7478,40798,79894,2,2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',22000.00,NULL,NULL,1,'2022-09-08 11:45:02','2022-09-08 11:45:02',NULL),(2486,7478,40798,79894,2,2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',22000.00,NULL,NULL,1,'2022-09-08 11:45:02','2022-09-08 11:45:02',NULL),(2487,7478,40798,79894,2,2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',15500.00,NULL,NULL,1,'2022-09-08 11:45:02','2022-09-08 11:45:02',NULL),(2488,7478,40798,79894,2,2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',14000.00,NULL,NULL,1,'2022-09-08 11:45:02','2022-09-08 11:45:02',NULL),(2489,7478,41795,159836,3,2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',6959.04,NULL,NULL,1,'2022-09-08 11:46:49','2022-09-08 11:46:49',NULL),(2490,7478,41795,159836,3,2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',4600.70,NULL,NULL,1,'2022-09-08 11:46:49','2022-09-08 11:46:49',NULL),(2491,7478,41795,159836,3,2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',16361.00,NULL,NULL,1,'2022-09-08 11:46:49','2022-09-08 11:46:49',NULL),(2492,7478,41795,159836,3,2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',4626.80,NULL,NULL,1,'2022-09-08 11:46:49','2022-09-08 11:46:49',NULL),(2493,7478,41795,159836,3,2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',400000.00,NULL,NULL,1,'2022-09-08 11:46:49','2022-09-08 11:46:49',NULL),(2494,7478,41795,159836,3,2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',276190.00,NULL,NULL,1,'2022-09-08 11:46:49','2022-09-08 11:46:49',NULL),(2495,7478,41795,159836,3,2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',5573.60,NULL,NULL,1,'2022-09-08 11:46:49','2022-09-08 11:46:49',NULL),(2496,7478,40784,78387,3,2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',40380.00,NULL,NULL,1,'2022-09-13 11:32:41','2022-09-13 11:32:41',NULL),(2497,7478,41798,161343,3,2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',2579.55,NULL,NULL,1,'2022-09-13 12:58:33','2022-09-13 12:59:03','2022-09-13 12:59:03'),(2498,7478,41798,161343,3,2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',2579.55,NULL,NULL,1,'2022-09-13 12:59:03','2022-09-13 12:59:03',NULL),(2499,7478,41798,161343,3,2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',1000.00,NULL,NULL,1,'2022-09-13 13:01:49','2022-09-13 13:01:49',NULL),(2500,7478,41798,161343,3,2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2000.05,NULL,NULL,1,'2022-09-13 13:03:42','2022-09-13 13:03:42',NULL),(2501,7478,41798,161343,3,2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',1400.03,NULL,NULL,1,'2022-09-13 13:05:10','2022-09-13 13:05:10',NULL),(2502,7478,41798,161343,3,2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',999.95,NULL,NULL,1,'2022-09-13 13:06:44','2022-09-13 13:06:44',NULL),(2503,7478,41798,161343,3,2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1000.00,NULL,NULL,1,'2022-09-13 13:13:52','2022-09-13 13:13:52',NULL);
INSERT INTO `balance_libro` VALUES (2504,7478,41798,161343,3,2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2000.00,NULL,NULL,1,'2022-09-13 13:19:03','2022-09-13 13:19:03',NULL),(2505,7478,41722,82979,3,2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',2300.00,NULL,NULL,1,'2022-09-19 11:08:08','2022-09-19 13:28:35','2022-09-19 13:28:35'),(2506,7478,41722,82979,3,2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1595.58,NULL,NULL,1,'2022-09-19 11:14:14','2022-09-19 13:59:19','2022-09-19 13:59:19'),(2507,7478,41722,82979,3,2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',1150.35,NULL,NULL,1,'2022-09-19 11:15:23','2022-09-19 14:02:23','2022-09-19 14:02:23'),(2508,7478,41722,82979,3,2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',2367.07,NULL,NULL,1,'2022-09-19 11:22:35','2022-09-19 14:03:05','2022-09-19 14:03:05'),(2509,7478,41722,82979,3,2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1388.70,NULL,NULL,1,'2022-09-19 11:25:00','2022-09-19 14:02:53','2022-09-19 14:02:53'),(2510,7478,41722,82979,3,2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1744.05,NULL,NULL,1,'2022-09-19 11:25:40','2022-09-19 14:01:48','2022-09-19 14:01:48'),(2511,7478,41722,82979,3,2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',421.98,NULL,NULL,1,'2022-09-19 11:26:14','2022-09-19 14:03:17','2022-09-19 14:03:17'),(2512,7478,41722,82979,3,2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',13730.40,NULL,NULL,1,'2022-09-19 11:27:40','2022-09-19 14:02:41','2022-09-19 14:02:41'),(2513,7478,41722,82979,3,2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',800.11,NULL,NULL,1,'2022-09-19 11:28:34','2022-09-19 14:03:30','2022-09-19 14:03:30'),(2514,7478,41722,82979,3,2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',270.03,NULL,NULL,1,'2022-09-19 11:29:25','2022-09-19 11:29:25',NULL),(2515,7478,41722,82979,3,2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',800.48,NULL,NULL,1,'2022-09-19 11:30:15','2022-09-19 11:30:15',NULL),(2516,7478,41722,82979,3,2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',919.94,NULL,NULL,1,'2022-09-19 11:32:07','2022-09-19 11:32:07',NULL),(2517,7478,41722,82979,3,2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',5000.00,NULL,NULL,1,'2022-09-19 11:38:44','2022-09-19 13:49:04','2022-09-19 13:49:04'),(2518,7478,41722,82979,3,2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',1999.96,NULL,NULL,1,'2022-09-19 11:41:20','2022-09-19 14:10:41','2022-09-19 14:10:41'),(2519,7478,41722,82979,3,2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',4000.06,NULL,NULL,1,'2022-09-19 11:42:24','2022-09-19 14:11:03','2022-09-19 14:11:03'),(2520,7478,41722,82979,3,2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',4000.02,NULL,NULL,1,'2022-09-19 11:44:03','2022-09-19 14:10:50','2022-09-19 14:10:50'),(2521,7478,41722,82979,3,2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',5000.05,NULL,NULL,1,'2022-09-19 11:45:55','2022-09-19 11:48:40','2022-09-19 11:48:40'),(2522,7478,41722,82979,3,2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',5000.05,NULL,NULL,1,'2022-09-19 11:48:40','2022-09-19 11:50:24','2022-09-19 11:50:24'),(2523,7478,41722,82979,3,2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',5000.00,NULL,NULL,1,'2022-09-19 11:50:09','2022-09-19 14:10:10','2022-09-19 14:10:10'),(2524,7478,41722,82979,3,2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',5000.05,NULL,NULL,1,'2022-09-19 11:50:24','2022-09-19 14:10:19','2022-09-19 14:10:19'),(2525,7478,41722,82979,3,2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',3000.00,NULL,NULL,1,'2022-09-19 11:51:59','2022-09-19 14:09:59','2022-09-19 14:09:59');
INSERT INTO `balance_libro` VALUES (2526,7478,41722,82979,3,2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',5999.99,NULL,NULL,1,'2022-09-19 11:53:27','2022-09-19 11:53:27',NULL),(2527,7478,41722,82979,3,2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',5000.00,NULL,NULL,1,'2022-09-19 11:54:47','2022-09-19 14:09:48','2022-09-19 14:09:48'),(2528,7478,41722,82979,3,2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',4000.00,NULL,NULL,1,'2022-09-19 11:55:51','2022-09-19 14:09:35','2022-09-19 14:09:35'),(2529,7478,41722,82979,3,2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',7499.98,NULL,NULL,1,'2022-09-19 11:58:56','2022-09-19 14:09:25','2022-09-19 14:09:25'),(2530,7478,41722,82979,3,2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',4500.48,NULL,NULL,1,'2022-09-19 12:11:43','2022-09-19 12:11:43',NULL),(2531,7478,41722,82979,3,2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',1800.41,NULL,NULL,1,'2022-09-19 12:18:37','2022-09-19 12:18:37',NULL),(2532,7478,41722,82979,3,2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',600792.01,NULL,NULL,1,'2022-09-19 12:25:37','2022-09-19 13:51:03','2022-09-19 13:51:03'),(2533,7478,41722,82979,3,2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',7500.21,NULL,NULL,1,'2022-09-19 12:29:01','2022-09-19 12:29:01',NULL),(2534,7478,41722,82979,3,2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',3000.51,NULL,NULL,1,'2022-09-19 12:31:16','2022-09-19 14:10:31','2022-09-19 14:10:31'),(2535,7478,41722,82979,3,2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3231.23,NULL,NULL,1,'2022-09-19 12:32:38','2022-09-19 13:41:06','2022-09-19 13:41:06'),(2536,7478,41722,82979,3,2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-25','2022-06-25',490.97,NULL,NULL,1,'2022-09-19 12:34:32','2022-09-19 13:45:46','2022-09-19 13:45:46'),(2537,7478,41722,82979,3,2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',1446.43,NULL,NULL,1,'2022-09-19 12:37:38','2022-09-19 13:37:44','2022-09-19 13:37:44'),(2538,7478,41722,82979,3,2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',1999.96,NULL,NULL,1,'2022-09-19 12:40:06','2022-09-19 14:09:04','2022-09-19 14:09:04'),(2539,7478,41722,82979,3,2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',2000.05,NULL,NULL,1,'2022-09-19 12:43:10','2022-09-19 14:08:57','2022-09-19 14:08:57'),(2540,7478,41722,82979,3,2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',10500.00,NULL,NULL,1,'2022-09-19 12:46:07','2022-09-19 14:09:14','2022-09-19 14:09:14'),(2541,7478,41722,82979,3,2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',3000.06,NULL,NULL,1,'2022-09-19 12:49:08','2022-09-19 12:49:08',NULL),(2542,7478,41722,82979,3,2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',4000.00,NULL,NULL,1,'2022-09-19 12:50:45','2022-09-19 12:50:45',NULL),(2543,7478,41722,82979,3,2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',520.06,NULL,NULL,1,'2022-09-19 12:54:07','2022-09-19 12:54:26','2022-09-19 12:54:26'),(2544,7478,41722,82979,3,2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-11','2022-06-11',520.06,NULL,NULL,1,'2022-09-19 12:54:26','2022-09-19 14:08:26','2022-09-19 14:08:26'),(2545,7478,41722,82979,3,2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2511.79,NULL,NULL,1,'2022-09-19 12:58:15','2022-09-19 13:34:47','2022-09-19 13:34:47'),(2546,7478,41722,82979,3,2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',4530.24,NULL,NULL,1,'2022-09-19 12:59:44','2022-09-19 13:01:35','2022-09-19 13:01:35'),(2547,7478,41722,82979,3,2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',4530.24,NULL,NULL,1,'2022-09-19 13:01:35','2022-09-19 13:37:15','2022-09-19 13:37:15');
INSERT INTO `balance_libro` VALUES (2548,7478,41722,82979,3,2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',79414.72,NULL,NULL,1,'2022-09-19 13:02:31','2022-09-19 13:37:05','2022-09-19 13:37:05'),(2549,7478,41722,82979,3,2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1235.61,NULL,NULL,1,'2022-09-19 13:05:38','2022-09-19 13:36:15','2022-09-19 13:36:15'),(2550,7478,41722,82979,3,2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',500.05,NULL,NULL,1,'2022-09-19 13:08:39','2022-09-19 13:46:37','2022-09-19 13:46:37'),(2551,7478,41722,82979,3,2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1490.06,NULL,NULL,1,'2022-09-19 13:10:39','2022-09-19 13:40:27','2022-09-19 13:40:27'),(2552,7478,41722,82979,3,2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1300.00,NULL,NULL,1,'2022-09-19 13:12:35','2022-09-19 13:36:50','2022-09-19 13:36:50'),(2553,7478,41722,82979,3,2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2187.14,NULL,NULL,1,'2022-09-19 13:15:13','2022-09-19 13:35:54','2022-09-19 13:35:54'),(2554,7478,41722,82979,3,2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',1039.98,NULL,NULL,1,'2022-09-19 13:16:31','2022-09-19 13:47:27','2022-09-19 13:47:27'),(2555,7478,41722,82979,3,2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',130.00,NULL,NULL,1,'2022-09-19 13:17:20','2022-09-19 13:35:40','2022-09-19 13:35:40'),(2556,7478,41776,158329,3,2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',14264.93,NULL,NULL,1,'2022-09-20 10:17:10','2022-09-20 10:17:10',NULL),(2557,7478,41776,158329,3,2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',179765.60,NULL,NULL,1,'2022-09-20 10:17:10','2022-09-20 10:17:10',NULL),(2558,7478,41776,158329,3,2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',4337.05,NULL,NULL,1,'2022-09-20 10:17:10','2022-09-20 10:17:10',NULL),(2559,7478,41776,158329,3,2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',19042.93,NULL,NULL,1,'2022-09-20 10:17:10','2022-09-20 10:17:10',NULL),(2560,7478,41776,158329,3,2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',991.94,NULL,NULL,1,'2022-09-20 10:17:10','2022-09-20 10:17:10',NULL),(2561,7478,41776,158329,3,2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',9401.40,NULL,NULL,1,'2022-09-20 10:17:11','2022-09-20 10:17:11',NULL),(2562,7478,41776,158329,3,2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',0.00,NULL,NULL,1,'2022-09-20 10:17:11','2022-09-20 10:17:11',NULL),(2563,7478,41776,158329,3,2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',127544.04,NULL,NULL,1,'2022-09-20 10:17:11','2022-09-20 10:17:11',NULL),(2564,7478,41776,158329,3,2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',33894.45,NULL,NULL,1,'2022-09-20 10:17:11','2022-09-20 10:17:11',NULL),(2565,7478,41776,158329,3,2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',18894.08,NULL,NULL,1,'2022-09-20 10:17:11','2022-09-20 10:17:11',NULL),(2566,7478,41776,158329,3,2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',241581.65,NULL,NULL,1,'2022-09-20 10:17:11','2022-09-20 10:17:11',NULL),(2567,7478,41776,158329,3,2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',58440.00,NULL,NULL,1,'2022-09-20 10:17:11','2022-09-20 10:17:11',NULL),(2568,7478,41776,158329,3,2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',530367.05,NULL,NULL,1,'2022-09-20 10:17:11','2022-09-20 10:17:11',NULL),(2569,7478,41776,158329,3,2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',293597.96,NULL,NULL,1,'2022-09-20 10:17:11','2022-09-20 10:17:11',NULL),(2570,7478,41776,158329,3,2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',310868.47,NULL,NULL,1,'2022-09-20 10:17:11','2022-09-20 10:17:11',NULL);
INSERT INTO `balance_libro` VALUES (2571,7478,41776,158329,3,2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',9912.87,NULL,NULL,1,'2022-09-20 10:17:11','2022-09-20 10:17:11',NULL),(2572,7478,41776,158329,3,2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',0.00,NULL,NULL,1,'2022-09-20 10:17:11','2022-09-20 10:17:11',NULL),(2573,7478,41776,158329,3,2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',5500.22,NULL,NULL,1,'2022-09-20 10:20:42','2022-09-20 10:20:42',NULL),(2574,7478,41776,158329,3,2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',1280.00,NULL,NULL,1,'2022-09-20 10:23:52','2022-09-20 10:23:52',NULL),(2575,7478,41776,158329,3,2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',1250.00,NULL,NULL,1,'2022-09-20 10:26:00','2022-09-20 10:26:00',NULL),(2576,7478,41776,158329,3,2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',8450.59,NULL,NULL,1,'2022-09-20 10:28:56','2022-09-20 10:28:56',NULL),(2577,7478,41776,158329,3,2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',5300.51,NULL,NULL,1,'2022-09-20 10:32:15','2022-09-20 10:32:15',NULL),(2578,7478,40746,37696,15,NULL,163,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',251620.87,NULL,NULL,1,'2022-09-20 10:32:44','2022-09-20 10:32:44',NULL),(2579,7478,40746,37696,16,NULL,383,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',0.00,NULL,NULL,1,'2022-09-20 10:32:59','2022-09-20 10:32:59',NULL),(2580,7478,41776,158329,3,2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',8200.00,NULL,NULL,1,'2022-09-20 10:34:59','2022-09-20 10:34:59',NULL),(2581,7478,41776,158329,3,2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',1840.00,NULL,NULL,1,'2022-09-20 10:39:56','2022-09-20 10:39:56',NULL),(2582,7478,41776,158329,3,2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',5900.01,NULL,NULL,1,'2022-09-20 10:41:21','2022-09-20 10:41:21',NULL),(2583,7478,41776,158329,3,2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',5530.00,NULL,NULL,1,'2022-09-20 10:42:39','2022-09-20 10:42:39',NULL),(2584,7478,41776,158329,3,2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',4600.00,NULL,NULL,1,'2022-09-20 10:43:53','2022-09-20 10:43:53',NULL),(2585,7478,41776,158329,3,2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',2384.00,NULL,NULL,1,'2022-09-20 10:45:09','2022-09-20 10:45:09',NULL),(2586,7478,41776,158329,3,2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',7730.00,NULL,NULL,1,'2022-09-20 10:46:47','2022-09-20 10:46:47',NULL),(2587,7478,41776,158329,3,2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',1860.00,NULL,NULL,1,'2022-09-20 10:47:52','2022-09-20 10:47:52',NULL),(2588,7478,41776,158329,3,2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',8999.99,NULL,NULL,1,'2022-09-20 10:48:59','2022-09-20 10:48:59',NULL),(2589,7478,41776,158329,3,2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',5049.99,NULL,NULL,1,'2022-09-20 10:51:03','2022-09-20 10:51:03',NULL),(2590,7478,41776,158329,3,2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',3800.00,NULL,NULL,1,'2022-09-20 10:52:06','2022-09-20 10:52:06',NULL),(2591,7478,41776,158329,3,2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',5800.01,NULL,NULL,1,'2022-09-20 10:53:46','2022-09-20 10:53:46',NULL),(2592,7478,41776,158329,3,2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',3200.00,NULL,NULL,1,'2022-09-20 10:54:53','2022-09-20 10:54:53',NULL),(2593,7478,41776,158329,3,2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',5344.96,NULL,NULL,1,'2022-09-20 10:56:26','2022-09-20 10:56:26',NULL),(2594,7478,41776,158329,3,2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',4850.01,NULL,NULL,1,'2022-09-20 10:57:35','2022-09-20 10:57:35',NULL);
INSERT INTO `balance_libro` VALUES (2595,7478,41776,158329,3,2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',3900.01,NULL,NULL,1,'2022-09-20 10:58:14','2022-09-20 10:58:14',NULL),(2596,7478,41776,158329,3,2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',6960.00,NULL,NULL,1,'2022-09-20 11:00:22','2022-09-20 11:00:22',NULL),(2597,7478,41776,158329,3,2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',3469.99,NULL,NULL,1,'2022-09-20 11:01:29','2022-09-20 11:01:29',NULL),(2598,7478,41776,158329,3,2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',5269.99,NULL,NULL,1,'2022-09-20 11:02:32','2022-09-20 11:02:32',NULL),(2599,7478,41776,158329,3,2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',7800.00,NULL,NULL,1,'2022-09-20 11:03:36','2022-09-20 11:03:36',NULL),(2600,7478,41776,158329,3,2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',4899.99,NULL,NULL,1,'2022-09-20 11:04:33','2022-09-20 11:04:33',NULL),(2601,7478,41776,158329,3,2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',4999.99,NULL,NULL,1,'2022-09-20 11:05:35','2022-09-20 11:05:35',NULL),(2602,7478,41776,158329,3,2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',5700.01,NULL,NULL,1,'2022-09-20 11:06:22','2022-09-20 11:06:22',NULL),(2603,7478,41776,158329,2,2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',7650.00,NULL,NULL,1,'2022-09-20 11:50:00','2022-09-20 11:50:00',NULL),(2604,7478,41776,158329,2,2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',5800.00,NULL,NULL,1,'2022-09-20 11:50:00','2022-09-20 11:50:00',NULL),(2605,7478,41776,158329,2,2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',25000.00,NULL,NULL,1,'2022-09-20 11:50:00','2022-09-20 11:50:00',NULL),(2606,7478,41776,158329,2,2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',27738.00,NULL,NULL,1,'2022-09-20 11:50:00','2022-09-20 11:50:00',NULL),(2607,7478,41776,158329,2,2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',42450.01,NULL,NULL,1,'2022-09-20 11:50:00','2022-09-20 11:50:00',NULL),(2608,7478,41776,158329,2,2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',24765.00,NULL,NULL,1,'2022-09-20 11:50:00','2022-09-20 11:50:00',NULL),(2609,7478,41776,158329,2,2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',1000.00,NULL,NULL,1,'2022-09-20 11:50:01','2022-09-20 11:50:01',NULL),(2610,7478,41776,158329,2,2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',15000.00,NULL,NULL,1,'2022-09-20 11:50:01','2022-09-20 11:50:01',NULL),(2611,7478,41776,158329,2,2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',14000.00,NULL,NULL,1,'2022-09-20 11:50:01','2022-09-20 11:50:01',NULL),(2612,7478,41776,158329,2,2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',15000.00,NULL,NULL,1,'2022-09-20 11:50:01','2022-09-20 11:50:01',NULL),(2613,7478,41776,158329,2,2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',13000.00,NULL,NULL,1,'2022-09-20 11:50:01','2022-09-20 11:50:01',NULL),(2614,7478,41776,158329,2,2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',14500.00,NULL,NULL,1,'2022-09-20 11:50:01','2022-09-20 11:50:01',NULL),(2615,7478,41776,158329,2,2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',13500.00,NULL,NULL,1,'2022-09-20 11:50:01','2022-09-20 11:50:01',NULL),(2616,7478,41776,158329,2,2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',12500.00,NULL,NULL,1,'2022-09-20 11:50:01','2022-09-20 11:50:01',NULL),(2617,7478,41776,158329,2,2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',14900.00,NULL,NULL,1,'2022-09-20 11:50:01','2022-09-20 11:50:01',NULL),(2618,7478,41776,158329,2,2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',14900.00,NULL,NULL,1,'2022-09-20 11:50:01','2022-09-20 11:50:01',NULL);
INSERT INTO `balance_libro` VALUES (2619,7478,41776,158329,2,2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',14900.00,NULL,NULL,1,'2022-09-20 11:50:01','2022-09-20 11:50:01',NULL),(2620,7478,41776,158329,2,2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',14000.00,NULL,NULL,1,'2022-09-20 11:50:01','2022-09-20 11:50:01',NULL),(2621,7478,41776,158329,2,2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',13000.00,NULL,NULL,1,'2022-09-20 11:50:01','2022-09-20 11:50:01',NULL),(2622,7478,41776,158329,2,2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',15000.00,NULL,NULL,1,'2022-09-20 11:50:01','2022-09-20 11:50:01',NULL),(2623,7478,41776,158329,2,2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',19748.25,NULL,NULL,1,'2022-09-20 11:50:02','2022-09-20 11:50:02',NULL),(2624,7478,41776,158329,2,2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',6000.00,NULL,NULL,1,'2022-09-20 11:50:02','2022-09-20 11:50:02',NULL),(2625,7478,41776,158329,2,2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',6550.00,NULL,NULL,1,'2022-09-20 11:50:02','2022-09-20 11:50:02',NULL),(2626,7478,41776,158329,2,2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',54600.00,NULL,NULL,1,'2022-09-20 11:50:02','2022-09-20 11:50:02',NULL),(2627,7478,41776,158329,2,2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',20671.88,NULL,NULL,1,'2022-09-20 11:50:02','2022-09-20 11:50:02',NULL),(2628,7478,41776,158329,2,2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',17193.75,NULL,NULL,1,'2022-09-20 11:50:02','2022-09-20 11:50:02',NULL),(2629,7478,41776,158329,2,2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',5900.00,NULL,NULL,1,'2022-09-20 11:50:02','2022-09-20 11:50:02',NULL),(2630,7478,41776,158329,2,2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',7700.00,NULL,NULL,1,'2022-09-20 11:50:03','2022-09-20 11:50:03',NULL),(2631,7478,41776,158329,2,2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',30531.60,NULL,NULL,1,'2022-09-20 11:50:03','2022-09-20 11:50:03',NULL),(2632,7478,41776,158329,2,2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',9378.60,NULL,NULL,1,'2022-09-20 11:50:03','2022-09-20 11:50:03',NULL),(2633,7478,41776,158329,2,2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',1.00,NULL,NULL,1,'2022-09-20 11:50:03','2022-09-20 11:50:03',NULL),(2634,7478,41776,158329,2,2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',22837.50,NULL,NULL,1,'2022-09-20 11:50:03','2022-09-20 11:50:03',NULL),(2635,7478,41776,158329,2,2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',34438.00,NULL,NULL,1,'2022-09-20 11:50:03','2022-09-20 11:50:03',NULL),(2636,7478,41776,158329,2,2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',23375.00,NULL,NULL,1,'2022-09-20 11:50:03','2022-09-20 11:50:03',NULL),(2637,7478,41776,158329,2,2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',23375.00,NULL,NULL,1,'2022-09-20 11:50:03','2022-09-20 11:50:03',NULL),(2638,7478,41776,158329,2,2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',488.98,NULL,NULL,1,'2022-09-20 11:50:03','2022-09-20 11:50:03',NULL),(2639,7478,41776,158329,2,2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',5350.00,NULL,NULL,1,'2022-09-20 11:50:03','2022-09-20 11:50:03',NULL),(2640,7478,41776,158329,2,2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',3500.00,NULL,NULL,1,'2022-09-20 11:50:03','2022-09-20 11:50:03',NULL),(2641,7478,41776,158329,2,2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',1122.84,NULL,NULL,1,'2022-09-20 11:50:03','2022-09-20 11:50:03',NULL),(2642,7478,41776,158329,2,2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',48700.00,NULL,NULL,1,'2022-09-20 11:50:03','2022-09-20 11:50:03',NULL);
INSERT INTO `balance_libro` VALUES (2643,7478,41776,158329,2,2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',678.74,NULL,NULL,1,'2022-09-20 11:50:03','2022-09-20 11:50:03',NULL),(2644,7478,41776,158329,2,2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',30712.44,NULL,NULL,1,'2022-09-20 11:50:03','2022-09-20 11:50:03',NULL),(2645,7478,41776,158329,2,2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',40530.00,NULL,NULL,1,'2022-09-20 11:50:04','2022-09-20 11:50:04',NULL),(2646,7478,41776,158329,2,2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',425.59,NULL,NULL,1,'2022-09-20 11:50:04','2022-09-20 11:50:04',NULL),(2647,7478,41776,158329,2,2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',5300.00,NULL,NULL,1,'2022-09-20 11:50:04','2022-09-20 11:50:04',NULL),(2648,7478,41776,158329,2,2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',8250.00,NULL,NULL,1,'2022-09-20 11:50:04','2022-09-20 11:50:04',NULL),(2649,7478,41776,158329,2,2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',23130.00,NULL,NULL,1,'2022-09-20 11:50:04','2022-09-20 11:50:04',NULL),(2650,7478,41776,158329,2,2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',244.49,NULL,NULL,1,'2022-09-20 11:50:04','2022-09-20 11:50:04',NULL),(2651,7478,41776,158329,2,2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',23130.00,NULL,NULL,1,'2022-09-20 11:50:04','2022-09-20 11:50:04',NULL),(2652,7478,41776,158329,2,2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',28060.56,NULL,NULL,1,'2022-09-20 11:50:04','2022-09-20 11:50:04',NULL),(2653,7478,41722,82980,2,2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',1482600.00,NULL,NULL,1,'2022-10-20 10:19:39','2022-10-20 10:19:39',NULL),(2654,7478,41722,82980,2,2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',48400.00,NULL,NULL,1,'2022-10-20 10:19:39','2022-10-20 10:19:39',NULL),(2655,7478,41722,82980,2,2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',79860.00,NULL,NULL,1,'2022-10-20 10:19:39','2022-10-20 10:19:39',NULL),(2656,7478,41722,82980,2,2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',43560.00,NULL,NULL,1,'2022-10-20 10:19:39','2022-10-20 10:19:39',NULL),(2657,7478,41722,82980,2,2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',70180.00,NULL,NULL,1,'2022-10-20 10:19:39','2022-10-20 10:19:39',NULL),(2658,7478,41722,82980,2,2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',61710.00,NULL,NULL,1,'2022-10-20 10:19:39','2022-10-20 10:19:39',NULL),(2659,7478,41722,82980,2,2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',35005.30,NULL,NULL,1,'2022-10-20 10:19:39','2022-10-20 10:19:39',NULL),(2660,7478,41722,82980,2,2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',75625.00,NULL,NULL,1,'2022-10-20 10:19:39','2022-10-20 10:19:39',NULL),(2661,7478,41722,82980,2,2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',48400.00,NULL,NULL,1,'2022-10-20 10:19:39','2022-10-20 10:19:39',NULL),(2662,7478,41722,82980,2,2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',75625.00,NULL,NULL,1,'2022-10-20 10:19:39','2022-10-20 10:19:39',NULL),(2663,7478,40784,78389,2,2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',400350.00,NULL,NULL,1,'2022-11-04 14:20:36','2022-11-04 14:20:36',NULL),(2664,7478,40784,78389,2,2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',400000.00,NULL,NULL,1,'2022-11-04 14:20:36','2022-11-04 14:20:36',NULL),(2665,7478,40784,78389,2,2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',281000.00,NULL,NULL,1,'2022-11-04 14:20:36','2022-11-04 14:20:36',NULL),(2666,7478,40784,78389,2,2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',36300.00,NULL,NULL,1,'2022-11-04 14:20:36','2022-11-04 14:20:36',NULL);
INSERT INTO `balance_libro` VALUES (2667,7478,40784,78389,2,2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:36','2022-11-04 14:20:36',NULL),(2668,7478,40784,78389,2,2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:36','2022-11-04 14:20:36',NULL),(2669,7478,40784,78389,2,2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:36','2022-11-04 14:20:36',NULL),(2670,7478,40784,78389,2,2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:36','2022-11-04 14:20:36',NULL),(2671,7478,40784,78389,2,2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:36','2022-11-04 14:20:36',NULL),(2672,7478,40784,78389,2,2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:36','2022-11-04 14:20:36',NULL),(2673,7478,40784,78389,2,2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:36','2022-11-04 14:20:36',NULL),(2674,7478,40784,78389,2,2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:36','2022-11-04 14:20:36',NULL),(2675,7478,40784,78389,2,2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2676,7478,40784,78389,2,2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2677,7478,40784,78389,2,2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2678,7478,40784,78389,2,2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2679,7478,40784,78389,2,2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2680,7478,40784,78389,2,2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2681,7478,40784,78389,2,2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2682,7478,40784,78389,2,2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2683,7478,40784,78389,2,2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2684,7478,40784,78389,2,2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2685,7478,40784,78389,2,2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2686,7478,40784,78389,2,2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2687,7478,40784,78389,2,2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2688,7478,40784,78389,2,2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2689,7478,40784,78389,2,2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2690,7478,40784,78389,2,2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL);
INSERT INTO `balance_libro` VALUES (2691,7478,40784,78389,2,2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2692,7478,40784,78389,2,2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2693,7478,40784,78389,2,2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2694,7478,40784,78389,2,2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2695,7478,40784,78389,2,2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2696,7478,40784,78389,2,2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2697,7478,40784,78389,2,2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2698,7478,40784,78389,2,2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2699,7478,40784,78389,2,2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2700,7478,40784,78389,2,2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:37','2022-11-04 14:20:37',NULL),(2701,7478,40784,78389,2,2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2702,7478,40784,78389,2,2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2703,7478,40784,78389,2,2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2704,7478,40784,78389,2,2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2705,7478,40784,78389,2,2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2706,7478,40784,78389,2,2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2707,7478,40784,78389,2,2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2708,7478,40784,78389,2,2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2709,7478,40784,78389,2,2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2710,7478,40784,78389,2,2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2711,7478,40784,78389,2,2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2712,7478,40784,78389,2,2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2713,7478,40784,78389,2,2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2714,7478,40784,78389,2,2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL);
INSERT INTO `balance_libro` VALUES (2715,7478,40784,78389,2,2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2716,7478,40784,78389,2,2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2717,7478,40784,78389,2,2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2718,7478,40784,78389,2,2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2719,7478,40784,78389,2,2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2720,7478,40784,78389,2,2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL),(2721,7478,40784,78389,2,2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',42350.00,NULL,NULL,1,'2022-11-04 14:20:38','2022-11-04 14:20:38',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8443 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7478,1,40746,37695,2,96,2,1444.51,NULL,'2022-08-08 11:37:40','2022-08-08 11:37:40',NULL),(2,7478,1,40746,37695,2,67,2,303.35,NULL,'2022-08-08 11:37:40','2022-08-08 11:37:40',NULL),(3,7478,1,40746,37695,2,13,1,1747.86,NULL,'2022-08-08 11:37:40','2022-08-08 11:37:40',NULL),(4,7478,2,40746,37695,2,96,2,430.00,NULL,'2022-08-08 11:37:40','2022-08-08 11:37:40',NULL),(5,7478,2,40746,37695,2,67,2,90.30,NULL,'2022-08-08 11:37:40','2022-08-08 11:37:40',NULL),(6,7478,2,40746,37695,2,13,1,520.30,NULL,'2022-08-08 11:37:40','2022-08-08 11:37:40',NULL),(7,7478,3,40746,37695,2,96,2,2101.27,NULL,'2022-08-08 11:37:40','2022-08-08 11:37:40',NULL),(8,7478,3,40746,37695,2,67,2,441.26,NULL,'2022-08-08 11:37:40','2022-08-08 11:37:40',NULL),(9,7478,3,40746,37695,2,13,1,2542.53,NULL,'2022-08-08 11:37:40','2022-08-08 11:37:40',NULL),(10,7478,4,40746,37695,2,96,2,3480.00,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(11,7478,4,40746,37695,2,67,2,730.80,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(12,7478,4,40746,37695,2,13,1,4210.80,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(13,7478,5,40746,37695,2,96,2,2261.94,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(14,7478,5,40746,37695,2,67,2,475.00,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(15,7478,5,40746,37695,2,13,1,2736.94,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(16,7478,6,40746,37695,2,96,2,1051.41,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(17,7478,6,40746,37695,2,67,2,220.80,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(18,7478,6,40746,37695,2,13,1,1272.21,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(19,7478,7,40746,37695,2,96,2,4029.00,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(20,7478,7,40746,37695,2,67,2,846.09,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(21,7478,7,40746,37695,2,13,1,4875.09,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(22,7478,8,40746,37695,2,96,2,3554.00,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(23,7478,8,40746,37695,2,67,2,746.34,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(24,7478,8,40746,37695,2,13,1,4300.34,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(25,7478,9,40746,37695,2,96,2,1125.00,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(26,7478,9,40746,37695,2,67,2,236.25,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(27,7478,9,40746,37695,2,13,1,1361.25,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(28,7478,10,40746,37695,2,96,2,3562.00,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(29,7478,10,40746,37695,2,67,2,748.02,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(30,7478,10,40746,37695,2,13,1,4310.02,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(31,7478,11,40746,37695,2,96,2,1781.00,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(32,7478,11,40746,37695,2,67,2,374.01,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(33,7478,11,40746,37695,2,13,1,2155.01,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(34,7478,12,40746,37695,2,96,2,4285.36,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(35,7478,12,40746,37695,2,67,2,899.93,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(36,7478,12,40746,37695,2,13,1,5185.29,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(37,7478,13,40746,37695,2,96,2,836.00,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(38,7478,13,40746,37695,2,67,2,175.56,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(39,7478,13,40746,37695,2,13,1,1011.56,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(40,7478,14,40746,37695,2,96,2,3964.80,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(41,7478,14,40746,37695,2,67,2,832.61,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(42,7478,14,40746,37695,2,13,1,4797.41,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(43,7478,15,40746,37695,2,96,2,13750.00,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL);
INSERT INTO `balance_libro_details` VALUES (44,7478,15,40746,37695,2,67,2,2887.50,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(45,7478,15,40746,37695,2,13,1,16637.50,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(46,7478,16,40746,37695,2,96,2,12900.00,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(47,7478,16,40746,37695,2,67,2,2709.00,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(48,7478,16,40746,37695,2,13,1,15609.00,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(49,7478,17,40746,37695,2,96,2,11200.00,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(50,7478,17,40746,37695,2,67,2,2352.00,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(51,7478,17,40746,37695,2,13,1,13552.00,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(52,7478,18,40746,37695,2,96,2,12600.00,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(53,7478,18,40746,37695,2,67,2,2646.00,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(54,7478,18,40746,37695,2,13,1,15246.00,NULL,'2022-08-08 11:37:41','2022-08-08 11:37:41',NULL),(55,7478,19,40746,37695,2,96,2,12560.00,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(56,7478,19,40746,37695,2,67,2,2637.60,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(57,7478,19,40746,37695,2,13,1,15197.60,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(58,7478,20,40746,37695,2,96,2,11970.00,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(59,7478,20,40746,37695,2,67,2,2513.70,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(60,7478,20,40746,37695,2,13,1,14483.70,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(61,7478,21,40746,37695,2,96,2,13950.00,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(62,7478,21,40746,37695,2,67,2,2929.50,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(63,7478,21,40746,37695,2,13,1,16879.50,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(64,7478,22,40746,37695,2,96,2,16200.00,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(65,7478,22,40746,37695,2,67,2,3402.00,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(66,7478,22,40746,37695,2,13,1,19602.00,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(67,7478,23,40746,37695,2,96,2,15750.00,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(68,7478,23,40746,37695,2,67,2,3307.50,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(69,7478,23,40746,37695,2,13,1,19057.50,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(70,7478,24,40746,37695,2,96,2,17115.00,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(71,7478,24,40746,37695,2,67,2,3594.15,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(72,7478,24,40746,37695,2,13,1,20709.15,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(73,7478,25,40746,37695,2,96,2,15000.00,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(74,7478,25,40746,37695,2,67,2,3150.00,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(75,7478,25,40746,37695,2,13,1,18150.00,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(76,7478,26,40746,37695,2,96,2,17049.59,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(77,7478,26,40746,37695,2,67,2,3580.41,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(78,7478,26,40746,37695,2,13,1,20630.00,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(79,7478,27,40746,37695,2,96,2,12314.05,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(80,7478,27,40746,37695,2,67,2,2585.95,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(81,7478,27,40746,37695,2,13,1,14900.00,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(82,7478,28,40746,37695,2,96,2,16388.43,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(83,7478,28,40746,37695,2,67,2,3441.57,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(84,7478,28,40746,37695,2,13,1,19830.00,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(85,7478,29,40746,37695,2,96,2,16247.93,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL);
INSERT INTO `balance_libro_details` VALUES (86,7478,29,40746,37695,2,67,2,3412.07,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(87,7478,29,40746,37695,2,13,1,19660.00,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(88,7478,30,40746,37695,2,96,2,13140.50,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(89,7478,30,40746,37695,2,67,2,2759.50,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(90,7478,30,40746,37695,2,13,1,15900.00,NULL,'2022-08-08 11:37:42','2022-08-08 11:37:42',NULL),(91,7478,31,40746,37695,2,96,2,16347.11,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(92,7478,31,40746,37695,2,67,2,3432.89,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(93,7478,31,40746,37695,2,13,1,19780.00,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(94,7478,32,40746,37695,2,96,2,16223.14,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(95,7478,32,40746,37695,2,67,2,3406.86,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(96,7478,32,40746,37695,2,13,1,19630.00,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(97,7478,33,40746,37695,2,96,2,17256.20,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(98,7478,33,40746,37695,2,67,2,3623.80,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(99,7478,33,40746,37695,2,13,1,20880.00,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(100,7478,34,40746,37695,2,96,2,16363.64,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(101,7478,34,40746,37695,2,67,2,3436.36,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(102,7478,34,40746,37695,2,13,1,19800.00,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(103,7478,35,40746,37695,2,96,2,14752.07,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(104,7478,35,40746,37695,2,67,2,3097.93,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(105,7478,35,40746,37695,2,13,1,17850.00,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(106,7478,36,40746,37695,2,96,2,17429.75,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(107,7478,36,40746,37695,2,67,2,3660.25,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(108,7478,36,40746,37695,2,13,1,21090.00,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(109,7478,37,40746,37695,2,96,2,13190.08,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(110,7478,37,40746,37695,2,67,2,2769.92,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(111,7478,37,40746,37695,2,13,1,15960.00,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(112,7478,38,40746,37695,2,96,2,15471.07,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(113,7478,38,40746,37695,2,67,2,3248.93,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(114,7478,38,40746,37695,2,13,1,18720.00,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(115,7478,39,40746,37695,2,96,2,16520.66,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(116,7478,39,40746,37695,2,67,2,3469.34,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(117,7478,39,40746,37695,2,13,1,19990.00,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(118,7478,40,40746,37695,2,96,2,16760.33,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(119,7478,40,40746,37695,2,67,2,3519.67,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(120,7478,40,40746,37695,2,13,1,20280.00,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(121,7478,41,40746,37695,2,96,2,15867.77,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(122,7478,41,40746,37695,2,67,2,3332.23,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(123,7478,41,40746,37695,2,13,1,19200.00,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(124,7478,42,40746,37695,2,96,2,15495.87,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(125,7478,42,40746,37695,2,67,2,3254.13,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(126,7478,42,40746,37695,2,13,1,18750.00,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(127,7478,43,40746,37695,2,96,2,14700.00,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL);
INSERT INTO `balance_libro_details` VALUES (128,7478,43,40746,37695,2,67,2,3087.00,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(129,7478,43,40746,37695,2,13,1,17787.00,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(130,7478,44,40746,37695,2,96,2,15371.90,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(131,7478,44,40746,37695,2,67,2,3228.10,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(132,7478,44,40746,37695,2,13,1,18600.00,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(133,7478,45,40746,37695,2,96,2,15669.42,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(134,7478,45,40746,37695,2,67,2,3290.58,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(135,7478,45,40746,37695,2,13,1,18960.00,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(136,7478,46,40746,37695,2,96,2,12243.80,NULL,'2022-08-08 11:37:43','2022-08-08 11:37:43',NULL),(137,7478,46,40746,37695,2,67,2,2571.20,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(138,7478,46,40746,37695,2,13,1,14815.00,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(139,7478,47,40746,37695,2,96,2,14742.15,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(140,7478,47,40746,37695,2,67,2,3095.85,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(141,7478,47,40746,37695,2,13,1,17838.00,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(142,7478,48,40746,37695,2,96,2,16421.49,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(143,7478,48,40746,37695,2,67,2,3448.51,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(144,7478,48,40746,37695,2,13,1,19870.00,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(145,7478,49,40746,37695,2,96,2,15731.40,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(146,7478,49,40746,37695,2,67,2,3303.60,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(147,7478,49,40746,37695,2,13,1,19035.00,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(148,7478,50,40746,37695,2,96,2,17256.20,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(149,7478,50,40746,37695,2,67,2,3623.80,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(150,7478,50,40746,37695,2,13,1,20880.00,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(151,7478,51,40746,37695,2,96,2,12978.51,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(152,7478,51,40746,37695,2,67,2,2725.49,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(153,7478,51,40746,37695,2,13,1,15704.00,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(154,7478,52,40746,37695,2,96,2,16363.64,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(155,7478,52,40746,37695,2,67,2,3436.36,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(156,7478,52,40746,37695,2,13,1,19800.00,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(157,7478,53,40746,37695,2,96,2,12783.47,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(158,7478,53,40746,37695,2,67,2,2684.53,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(159,7478,53,40746,37695,2,13,1,15468.00,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(160,7478,54,40746,37695,2,96,2,15371.90,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(161,7478,54,40746,37695,2,67,2,3228.10,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(162,7478,54,40746,37695,2,13,1,18600.00,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(163,7478,55,40746,37695,2,96,2,15371.90,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(164,7478,55,40746,37695,2,67,2,3228.10,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(165,7478,55,40746,37695,2,13,1,18600.00,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(166,7478,56,40746,37695,2,96,2,15504.13,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(167,7478,56,40746,37695,2,67,2,3255.87,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(168,7478,56,40746,37695,2,13,1,18760.00,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL);
INSERT INTO `balance_libro_details` VALUES (169,7478,57,40746,37695,2,96,2,16710.74,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(170,7478,57,40746,37695,2,67,2,3509.26,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(171,7478,57,40746,37695,2,13,1,20220.00,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(172,7478,58,40746,37695,2,96,2,15495.87,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(173,7478,58,40746,37695,2,67,2,3254.13,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(174,7478,58,40746,37695,2,13,1,18750.00,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(175,7478,59,40746,37695,2,96,2,15702.48,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(176,7478,59,40746,37695,2,67,2,3297.52,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(177,7478,59,40746,37695,2,13,1,19000.00,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(178,7478,60,40746,37695,2,96,2,17752.07,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(179,7478,60,40746,37695,2,67,2,3727.93,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(180,7478,60,40746,37695,2,13,1,21480.00,NULL,'2022-08-08 11:37:44','2022-08-08 11:37:44',NULL),(181,7478,61,40746,37695,2,96,2,16462.81,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(182,7478,61,40746,37695,2,67,2,3457.19,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(183,7478,61,40746,37695,2,13,1,19920.00,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(184,7478,62,40746,37695,2,96,2,15471.07,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(185,7478,62,40746,37695,2,67,2,3248.93,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(186,7478,62,40746,37695,2,13,1,18720.00,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(187,7478,63,40746,37695,2,96,2,16719.01,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(188,7478,63,40746,37695,2,67,2,3510.99,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(189,7478,63,40746,37695,2,13,1,20230.00,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(190,7478,64,40746,37695,2,96,2,15735.54,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(191,7478,64,40746,37695,2,67,2,3304.46,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(192,7478,64,40746,37695,2,13,1,19040.00,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(193,7478,65,40746,37695,2,96,2,14768.60,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(194,7478,65,40746,37695,2,67,2,3101.40,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(195,7478,65,40746,37695,2,13,1,17870.00,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(196,7478,66,40746,37695,2,96,2,15163.64,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(197,7478,66,40746,37695,2,67,2,3184.36,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(198,7478,66,40746,37695,2,13,1,18348.00,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(199,7478,67,40746,37695,2,96,2,15322.31,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(200,7478,67,40746,37695,2,67,2,3217.69,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(201,7478,67,40746,37695,2,13,1,18540.00,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(202,7478,68,40746,37695,2,96,2,17479.34,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(203,7478,68,40746,37695,2,67,2,3670.66,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(204,7478,68,40746,37695,2,13,1,21150.00,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(205,7478,69,40746,37695,2,96,2,15322.31,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(206,7478,69,40746,37695,2,67,2,3217.69,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(207,7478,69,40746,37695,2,13,1,18540.00,NULL,'2022-08-08 11:37:45','2022-08-08 11:37:45',NULL),(208,7478,70,40746,37695,3,217,1,10541.55,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(209,7478,70,40746,37695,3,68,1,2213.73,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL);
INSERT INTO `balance_libro_details` VALUES (210,7478,70,40746,37695,3,57,2,12755.28,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(211,7478,71,40746,37695,3,217,1,639.96,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(212,7478,71,40746,37695,3,68,1,134.39,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(213,7478,71,40746,37695,3,217,1,23.04,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(214,7478,71,40746,37695,3,57,2,797.39,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(215,7478,72,40746,37695,3,217,1,108064.92,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(216,7478,72,40746,37695,3,68,1,22693.63,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(217,7478,72,40746,37695,3,57,2,130758.55,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(218,7478,73,40746,37695,3,217,1,525.64,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(219,7478,73,40746,37695,3,68,1,110.38,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(220,7478,73,40746,37695,3,57,2,636.02,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(221,7478,74,40746,37695,3,217,1,174238.83,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(222,7478,74,40746,37695,3,68,1,36590.15,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(223,7478,74,40746,37695,3,57,2,210828.98,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(224,7478,75,40746,37695,3,217,1,7615.90,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(225,7478,75,40746,37695,3,68,1,1599.34,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(226,7478,75,40746,37695,3,217,1,502.65,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(227,7478,75,40746,37695,3,57,2,9717.89,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(228,7478,76,40746,37695,3,217,1,202755.80,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(229,7478,76,40746,37695,3,68,1,42578.72,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(230,7478,76,40746,37695,3,57,2,245334.52,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(231,7478,77,40746,37695,3,217,1,13847.23,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(232,7478,77,40746,37695,3,68,1,2907.92,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(233,7478,77,40746,37695,3,57,2,16755.15,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(234,7478,78,40746,37695,3,217,2,119085.00,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(235,7478,78,40746,37695,3,67,2,25007.85,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(236,7478,78,40746,37695,3,57,1,144092.85,NULL,'2022-08-08 12:30:20','2022-08-08 12:30:20',NULL),(237,7478,79,40746,37695,3,217,1,113130.75,NULL,'2022-08-08 12:30:21','2022-08-08 12:30:21',NULL),(238,7478,79,40746,37695,3,68,1,23757.46,NULL,'2022-08-08 12:30:21','2022-08-08 12:30:21',NULL),(239,7478,79,40746,37695,3,57,2,136888.21,NULL,'2022-08-08 12:30:21','2022-08-08 12:30:21',NULL),(240,7478,80,40746,37695,3,217,1,13847.23,NULL,'2022-08-08 12:30:21','2022-08-08 12:30:21',NULL),(241,7478,80,40746,37695,3,68,1,2907.92,NULL,'2022-08-08 12:30:21','2022-08-08 12:30:21',NULL),(242,7478,80,40746,37695,3,57,2,16755.15,NULL,'2022-08-08 12:30:21','2022-08-08 12:30:21',NULL),(243,7478,81,40746,37695,3,217,1,11165.81,NULL,'2022-08-08 12:30:21','2022-08-08 12:30:21',NULL),(244,7478,81,40746,37695,3,68,1,2344.82,NULL,'2022-08-08 12:30:21','2022-08-08 12:30:21',NULL),(245,7478,81,40746,37695,3,57,2,13510.63,NULL,'2022-08-08 12:30:21','2022-08-08 12:30:21',NULL),(246,7478,82,40746,37695,3,217,1,6941.47,NULL,'2022-08-08 12:30:21','2022-08-08 12:30:21',NULL),(247,7478,82,40746,37695,3,68,1,1457.71,NULL,'2022-08-08 12:30:21','2022-08-08 12:30:21',NULL),(248,7478,82,40746,37695,3,217,1,613.23,NULL,'2022-08-08 12:30:21','2022-08-08 12:30:21',NULL),(249,7478,82,40746,37695,3,57,2,9012.41,NULL,'2022-08-08 12:30:21','2022-08-08 12:30:21',NULL),(250,7478,83,40784,78386,2,96,2,17355.37,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL);
INSERT INTO `balance_libro_details` VALUES (251,7478,83,40784,78386,2,67,2,3644.63,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(252,7478,83,40784,78386,2,13,1,21000.00,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(253,7478,84,40784,78386,2,96,2,46694.23,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(254,7478,84,40784,78386,2,67,2,9805.79,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(255,7478,84,40784,78386,2,13,1,56500.02,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(256,7478,85,40784,78386,2,96,2,247933.97,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(257,7478,85,40784,78386,2,67,2,52066.13,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(258,7478,85,40784,78386,2,13,1,300000.10,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(259,7478,86,40784,78386,2,96,2,247933.95,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(260,7478,86,40784,78386,2,67,2,52066.13,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(261,7478,86,40784,78386,2,13,1,300000.08,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(262,7478,87,40784,78386,2,96,1,247933.97,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(263,7478,87,40784,78386,2,68,1,52066.13,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(264,7478,87,40784,78386,2,13,2,300000.10,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(265,7478,88,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(266,7478,88,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(267,7478,88,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(268,7478,89,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(269,7478,89,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(270,7478,89,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(271,7478,90,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(272,7478,90,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(273,7478,90,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(274,7478,91,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(275,7478,91,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(276,7478,91,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(277,7478,92,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(278,7478,92,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(279,7478,92,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(280,7478,93,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(281,7478,93,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(282,7478,93,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(283,7478,94,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(284,7478,94,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(285,7478,94,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(286,7478,95,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(287,7478,95,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(288,7478,95,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(289,7478,96,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(290,7478,96,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(291,7478,96,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL);
INSERT INTO `balance_libro_details` VALUES (292,7478,97,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(293,7478,97,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(294,7478,97,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:28','2022-08-11 14:30:28',NULL),(295,7478,98,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(296,7478,98,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(297,7478,98,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(298,7478,99,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(299,7478,99,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(300,7478,99,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(301,7478,100,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(302,7478,100,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(303,7478,100,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(304,7478,101,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(305,7478,101,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(306,7478,101,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(307,7478,102,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(308,7478,102,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(309,7478,102,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(310,7478,103,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(311,7478,103,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(312,7478,103,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(313,7478,104,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(314,7478,104,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(315,7478,104,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(316,7478,105,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(317,7478,105,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(318,7478,105,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(319,7478,106,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(320,7478,106,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(321,7478,106,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(322,7478,107,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(323,7478,107,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(324,7478,107,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(325,7478,108,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(326,7478,108,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(327,7478,108,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(328,7478,109,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(329,7478,109,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(330,7478,109,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(331,7478,110,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(332,7478,110,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL);
INSERT INTO `balance_libro_details` VALUES (333,7478,110,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(334,7478,111,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(335,7478,111,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(336,7478,111,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(337,7478,112,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(338,7478,112,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(339,7478,112,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(340,7478,113,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(341,7478,113,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(342,7478,113,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(343,7478,114,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(344,7478,114,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(345,7478,114,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(346,7478,115,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(347,7478,115,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(348,7478,115,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(349,7478,116,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(350,7478,116,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(351,7478,116,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(352,7478,117,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(353,7478,117,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(354,7478,117,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(355,7478,118,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(356,7478,118,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(357,7478,118,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(358,7478,119,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(359,7478,119,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(360,7478,119,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(361,7478,120,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(362,7478,120,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(363,7478,120,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(364,7478,121,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(365,7478,121,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(366,7478,121,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:29','2022-08-11 14:30:29',NULL),(367,7478,122,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(368,7478,122,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(369,7478,122,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(370,7478,123,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(371,7478,123,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(372,7478,123,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(373,7478,124,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL);
INSERT INTO `balance_libro_details` VALUES (374,7478,124,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(375,7478,124,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(376,7478,125,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(377,7478,125,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(378,7478,125,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(379,7478,126,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(380,7478,126,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(381,7478,126,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(382,7478,127,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(383,7478,127,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(384,7478,127,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(385,7478,128,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(386,7478,128,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(387,7478,128,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(388,7478,129,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(389,7478,129,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(390,7478,129,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(391,7478,130,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(392,7478,130,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(393,7478,130,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(394,7478,131,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(395,7478,131,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(396,7478,131,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(397,7478,132,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(398,7478,132,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(399,7478,132,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(400,7478,133,40784,78386,2,218,2,12000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(401,7478,133,40784,78386,2,13,1,12000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(402,7478,134,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(403,7478,134,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(404,7478,134,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(405,7478,135,40784,78386,2,218,2,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(406,7478,135,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(407,7478,136,40784,78386,2,218,2,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(408,7478,136,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(409,7478,137,40784,78386,2,218,2,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(410,7478,137,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(411,7478,138,40784,78386,2,218,2,29272.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(412,7478,138,40784,78386,2,13,1,29272.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(413,7478,139,40784,78386,2,218,2,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(414,7478,139,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL);
INSERT INTO `balance_libro_details` VALUES (415,7478,140,40784,78386,2,218,2,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(416,7478,140,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(417,7478,141,40784,78386,2,218,2,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(418,7478,141,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(419,7478,142,40784,78386,2,218,2,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(420,7478,142,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(421,7478,143,40784,78386,2,218,2,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(422,7478,143,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(423,7478,144,40784,78386,2,218,2,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(424,7478,144,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(425,7478,145,40784,78386,2,218,2,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(426,7478,145,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:30','2022-08-11 14:30:30',NULL),(427,7478,146,40784,78386,2,218,2,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(428,7478,146,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(429,7478,147,40784,78386,2,218,2,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(430,7478,147,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(431,7478,148,40784,78386,2,218,2,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(432,7478,148,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(433,7478,149,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(434,7478,149,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(435,7478,149,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(436,7478,150,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(437,7478,150,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(438,7478,150,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(439,7478,151,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(440,7478,151,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(441,7478,151,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(442,7478,152,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(443,7478,152,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(444,7478,152,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(445,7478,153,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(446,7478,153,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(447,7478,153,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(448,7478,154,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(449,7478,154,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(450,7478,154,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(451,7478,155,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(452,7478,155,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(453,7478,155,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(454,7478,156,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(455,7478,156,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL);
INSERT INTO `balance_libro_details` VALUES (456,7478,156,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(457,7478,157,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(458,7478,157,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(459,7478,157,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(460,7478,158,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(461,7478,158,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(462,7478,158,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(463,7478,159,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(464,7478,159,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(465,7478,159,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(466,7478,160,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(467,7478,160,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(468,7478,160,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(469,7478,161,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(470,7478,161,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(471,7478,161,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(472,7478,162,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(473,7478,162,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(474,7478,162,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(475,7478,163,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(476,7478,163,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(477,7478,163,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(478,7478,164,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(479,7478,164,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(480,7478,164,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(481,7478,165,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(482,7478,165,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(483,7478,165,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(484,7478,166,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(485,7478,166,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(486,7478,166,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(487,7478,167,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(488,7478,167,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(489,7478,167,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(490,7478,168,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(491,7478,168,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(492,7478,168,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(493,7478,169,40784,78386,2,96,2,18099.55,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(494,7478,169,40784,78386,2,67,2,1900.45,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(495,7478,169,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(496,7478,170,40784,78386,2,96,2,18099.55,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL);
INSERT INTO `balance_libro_details` VALUES (497,7478,170,40784,78386,2,67,2,1900.45,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(498,7478,170,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:31','2022-08-11 14:30:31',NULL),(499,7478,171,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(500,7478,171,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(501,7478,171,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(502,7478,172,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(503,7478,172,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(504,7478,172,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(505,7478,173,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(506,7478,173,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(507,7478,173,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(508,7478,174,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(509,7478,174,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(510,7478,174,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(511,7478,175,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(512,7478,175,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(513,7478,175,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(514,7478,176,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(515,7478,176,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(516,7478,176,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(517,7478,177,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(518,7478,177,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(519,7478,177,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(520,7478,178,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(521,7478,178,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(522,7478,178,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(523,7478,179,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(524,7478,179,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(525,7478,179,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(526,7478,180,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(527,7478,180,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(528,7478,180,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(529,7478,181,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(530,7478,181,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(531,7478,181,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(532,7478,182,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(533,7478,182,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(534,7478,182,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(535,7478,183,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(536,7478,183,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(537,7478,183,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL);
INSERT INTO `balance_libro_details` VALUES (538,7478,184,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(539,7478,184,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(540,7478,184,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(541,7478,185,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(542,7478,185,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(543,7478,185,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(544,7478,186,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(545,7478,186,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(546,7478,186,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(547,7478,187,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(548,7478,187,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(549,7478,187,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(550,7478,188,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(551,7478,188,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(552,7478,188,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(553,7478,189,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(554,7478,189,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(555,7478,189,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(556,7478,190,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(557,7478,190,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(558,7478,190,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(559,7478,191,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(560,7478,191,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(561,7478,191,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(562,7478,192,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(563,7478,192,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(564,7478,192,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(565,7478,193,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(566,7478,193,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(567,7478,193,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(568,7478,194,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(569,7478,194,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(570,7478,194,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:32','2022-08-11 14:30:32',NULL),(571,7478,195,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL),(572,7478,195,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL),(573,7478,195,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL),(574,7478,196,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL),(575,7478,196,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL),(576,7478,196,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL),(577,7478,197,40784,78386,2,96,2,12809.92,NULL,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL),(578,7478,197,40784,78386,2,67,2,2690.08,NULL,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL);
INSERT INTO `balance_libro_details` VALUES (579,7478,197,40784,78386,2,13,1,15500.00,NULL,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL),(580,7478,198,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL),(581,7478,198,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL),(582,7478,198,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL),(583,7478,199,40784,78386,2,96,2,16528.93,NULL,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL),(584,7478,199,40784,78386,2,67,2,3471.07,NULL,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL),(585,7478,199,40784,78386,2,13,1,20000.00,NULL,'2022-08-11 14:30:33','2022-08-11 14:30:33',NULL),(586,7478,200,40784,78386,3,250,1,34440.00,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(587,7478,200,40784,78386,3,57,2,34440.00,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(588,7478,201,40784,78386,3,217,1,16067.75,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(589,7478,201,40784,78386,3,68,1,3374.23,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(590,7478,201,40784,78386,3,57,2,19441.98,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(591,7478,202,40784,78386,3,217,1,7725.22,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(592,7478,202,40784,78386,3,68,1,1622.30,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(593,7478,202,40784,78386,3,217,1,231.76,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(594,7478,202,40784,78386,3,57,2,9579.28,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(595,7478,203,40784,78386,3,217,1,1990.00,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(596,7478,203,40784,78386,3,68,1,417.90,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(597,7478,203,40784,78386,3,217,1,59.70,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(598,7478,203,40784,78386,3,57,2,2467.60,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(599,7478,204,40784,78386,3,217,1,11488.50,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(600,7478,204,40784,78386,3,68,1,1206.29,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(601,7478,204,40784,78386,3,217,1,172.33,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(602,7478,204,40784,78386,3,57,2,12867.12,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(603,7478,205,40784,78386,3,217,1,5861.50,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(604,7478,205,40784,78386,3,68,1,615.46,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(605,7478,205,40784,78386,3,217,1,87.92,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(606,7478,205,40784,78386,3,57,2,6564.88,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(607,7478,206,40784,78386,3,217,1,936000.00,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(608,7478,206,40784,78386,3,68,1,98280.00,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(609,7478,206,40784,78386,3,217,1,14040.00,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(610,7478,206,40784,78386,3,57,2,1048320.00,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(611,7478,207,40784,78386,3,217,1,73643.20,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(612,7478,207,40784,78386,3,68,1,7732.54,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(613,7478,207,40784,78386,3,217,1,1104.65,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(614,7478,207,40784,78386,3,57,2,82480.39,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(615,7478,208,40784,78386,3,217,1,110000.00,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(616,7478,208,40784,78386,3,68,1,23100.00,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(617,7478,208,40784,78386,3,217,1,3300.00,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(618,7478,208,40784,78386,3,57,2,136400.00,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(619,7478,209,40784,78386,3,217,1,5944.81,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL);
INSERT INTO `balance_libro_details` VALUES (620,7478,209,40784,78386,3,68,1,624.21,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(621,7478,209,40784,78386,3,217,1,89.17,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(622,7478,209,40784,78386,3,57,2,6658.19,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(623,7478,210,40784,78386,3,217,2,11488.50,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(624,7478,210,40784,78386,3,67,2,1206.29,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(625,7478,210,40784,78386,3,217,2,172.33,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(626,7478,210,40784,78386,3,57,1,12867.12,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(627,7478,211,40784,78386,3,217,2,73643.20,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(628,7478,211,40784,78386,3,67,2,7732.54,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(629,7478,211,40784,78386,3,217,2,1104.65,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(630,7478,211,40784,78386,3,57,1,82480.39,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(631,7478,212,40784,78386,3,217,2,5861.50,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(632,7478,212,40784,78386,3,67,2,615.46,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(633,7478,212,40784,78386,3,217,2,87.92,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(634,7478,212,40784,78386,3,57,1,6564.88,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(635,7478,213,40784,78386,3,217,1,11651.87,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(636,7478,213,40784,78386,3,68,1,1223.45,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(637,7478,213,40784,78386,3,217,1,174.78,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(638,7478,213,40784,78386,3,57,2,13050.10,NULL,'2022-08-11 14:34:21','2022-08-11 14:34:21',NULL),(639,7478,214,40784,78386,3,217,1,74690.50,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(640,7478,214,40784,78386,3,68,1,7842.50,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(641,7478,214,40784,78386,3,217,1,1120.36,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(642,7478,214,40784,78386,3,57,2,83653.36,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(643,7478,215,40784,78386,3,217,1,303305.79,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(644,7478,215,40784,78386,3,68,1,63694.21,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(645,7478,215,40784,78386,3,57,2,367000.00,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(646,7478,216,40784,78386,3,217,1,26936.44,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(647,7478,216,40784,78386,3,68,1,5656.66,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(648,7478,216,40784,78386,3,217,1,323.23,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(649,7478,216,40784,78386,3,57,2,32916.33,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(650,7478,217,40784,78386,3,217,1,41274.84,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(651,7478,217,40784,78386,3,68,1,8667.72,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(652,7478,217,40784,78386,3,217,1,495.30,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(653,7478,217,40784,78386,3,57,2,50437.86,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(654,7478,218,40784,78386,3,217,1,42124.38,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(655,7478,218,40784,78386,3,68,1,8846.12,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(656,7478,218,40784,78386,3,217,1,505.49,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(657,7478,218,40784,78386,3,57,2,51475.99,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(658,7478,219,40784,78386,3,217,1,42660.45,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(659,7478,219,40784,78386,3,68,1,8958.69,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(660,7478,219,40784,78386,3,217,1,511.92,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL);
INSERT INTO `balance_libro_details` VALUES (661,7478,219,40784,78386,3,57,2,52131.06,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(662,7478,220,40784,78386,3,217,1,84892.26,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(663,7478,220,40784,78386,3,68,1,17827.38,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(664,7478,220,40784,78386,3,217,1,1029.29,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(665,7478,220,40784,78386,3,57,2,103748.93,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(666,7478,221,40784,78386,3,217,1,33345.91,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(667,7478,221,40784,78386,3,68,1,7002.64,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(668,7478,221,40784,78386,3,217,1,833.66,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(669,7478,221,40784,78386,3,57,2,41182.21,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(670,7478,222,40784,78386,3,217,2,41825.62,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(671,7478,222,40784,78386,3,67,2,8783.38,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(672,7478,222,40784,78386,3,57,1,50609.00,NULL,'2022-08-11 14:34:22','2022-08-11 14:34:22',NULL),(673,7478,223,40798,79893,2,96,2,13223.14,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(674,7478,223,40798,79893,2,67,2,2776.86,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(675,7478,223,40798,79893,2,13,1,16000.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(676,7478,224,40798,79893,2,218,2,0.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(677,7478,224,40798,79893,2,218,2,22500.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(678,7478,224,40798,79893,2,13,1,22500.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(679,7478,225,40798,79893,2,218,2,0.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(680,7478,225,40798,79893,2,218,2,19600.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(681,7478,225,40798,79893,2,13,1,19600.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(682,7478,226,40798,79893,2,218,2,0.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(683,7478,226,40798,79893,2,218,2,22000.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(684,7478,226,40798,79893,2,13,1,22000.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(685,7478,227,40798,79893,2,218,2,0.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(686,7478,227,40798,79893,2,218,2,22000.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(687,7478,227,40798,79893,2,13,1,22000.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(688,7478,228,40798,79893,2,218,2,0.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(689,7478,228,40798,79893,2,218,2,15500.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(690,7478,228,40798,79893,2,13,1,15500.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(691,7478,229,40798,79893,2,218,2,0.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(692,7478,229,40798,79893,2,218,2,14000.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(693,7478,229,40798,79893,2,13,1,14000.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(694,7478,230,40798,79893,2,96,2,11157.02,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(695,7478,230,40798,79893,2,67,2,2342.98,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(696,7478,230,40798,79893,2,13,1,13500.00,NULL,'2022-08-12 15:38:23','2022-08-12 15:38:23',NULL),(697,7478,231,40798,79893,3,217,1,3514.94,NULL,'2022-08-12 15:40:09','2022-08-12 15:40:09',NULL),(698,7478,231,40798,79893,3,68,1,415.06,NULL,'2022-08-12 15:40:09','2022-08-12 15:40:09',NULL),(699,7478,231,40798,79893,3,57,2,3930.00,NULL,'2022-08-12 15:40:09','2022-08-12 15:40:09',NULL),(700,7478,232,40798,79893,3,217,1,180.99,NULL,'2022-08-12 15:40:09','2022-08-12 15:40:09',NULL),(701,7478,232,40798,79893,3,68,1,19.01,NULL,'2022-08-12 15:40:09','2022-08-12 15:40:09',NULL);
INSERT INTO `balance_libro_details` VALUES (702,7478,232,40798,79893,3,57,2,200.00,NULL,'2022-08-12 15:40:09','2022-08-12 15:40:09',NULL),(1955,7478,648,40809,81400,2,96,2,4958.68,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1956,7478,648,40809,81400,2,67,2,1041.32,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1957,7478,648,40809,81400,2,13,1,6000.00,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1958,7478,649,40809,81400,2,96,2,816.03,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1959,7478,649,40809,81400,2,67,2,171.37,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1960,7478,649,40809,81400,2,13,1,987.40,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1961,7478,650,40809,81400,2,96,2,11157.02,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1962,7478,650,40809,81400,2,67,2,2342.98,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1963,7478,650,40809,81400,2,13,1,13500.00,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1964,7478,651,40809,81400,2,96,2,200.00,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1965,7478,651,40809,81400,2,67,2,42.00,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1966,7478,651,40809,81400,2,13,1,242.00,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1967,7478,652,40809,81400,2,96,2,413.22,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1968,7478,652,40809,81400,2,67,2,86.78,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1969,7478,652,40809,81400,2,13,1,500.00,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1970,7478,653,40809,81400,2,96,2,9093.39,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1971,7478,653,40809,81400,2,67,2,1909.61,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1972,7478,653,40809,81400,2,13,1,11003.00,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1973,7478,654,40809,81400,2,96,2,991.74,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1974,7478,654,40809,81400,2,67,2,208.26,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1975,7478,654,40809,81400,2,13,1,1200.00,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1976,7478,655,40809,81400,2,96,2,5371.90,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1977,7478,655,40809,81400,2,67,2,1128.10,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1978,7478,655,40809,81400,2,13,1,6500.00,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1979,7478,656,40809,81400,2,96,2,165.29,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1980,7478,656,40809,81400,2,67,2,34.71,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1981,7478,656,40809,81400,2,13,1,200.00,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1982,7478,657,40809,81400,2,96,2,8842.98,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1983,7478,657,40809,81400,2,67,2,1857.02,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1984,7478,657,40809,81400,2,13,1,10700.00,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1985,7478,658,40809,81400,2,96,2,382.50,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1986,7478,658,40809,81400,2,67,2,80.32,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1987,7478,658,40809,81400,2,13,1,462.82,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1988,7478,659,40809,81400,2,96,2,9028.93,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1989,7478,659,40809,81400,2,67,2,1896.07,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1990,7478,659,40809,81400,2,13,1,10925.00,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1991,7478,660,40809,81400,2,96,2,4710.74,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1992,7478,660,40809,81400,2,67,2,989.26,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1993,7478,660,40809,81400,2,13,1,5700.00,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1994,7478,661,40809,81400,2,96,2,404.96,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL);
INSERT INTO `balance_libro_details` VALUES (1995,7478,661,40809,81400,2,67,2,85.04,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1996,7478,661,40809,81400,2,13,1,490.00,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1997,7478,662,40809,81400,2,96,2,247.93,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1998,7478,662,40809,81400,2,67,2,52.07,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(1999,7478,662,40809,81400,2,13,1,300.00,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(2000,7478,663,40809,81400,2,96,2,8851.20,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(2001,7478,663,40809,81400,2,67,2,1858.75,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(2002,7478,663,40809,81400,2,13,1,10709.95,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(2003,7478,664,40809,81400,2,96,2,7685.95,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(2004,7478,664,40809,81400,2,67,2,1614.05,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(2005,7478,664,40809,81400,2,13,1,9300.00,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(2006,7478,665,40809,81400,2,96,2,5206.61,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(2007,7478,665,40809,81400,2,67,2,1093.39,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(2008,7478,665,40809,81400,2,13,1,6300.00,NULL,'2022-08-12 20:39:29','2022-08-12 20:39:29',NULL),(2009,7478,666,40809,81400,2,96,2,33.06,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2010,7478,666,40809,81400,2,67,2,6.94,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2011,7478,666,40809,81400,2,13,1,40.00,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2012,7478,667,40809,81400,2,96,2,7438.02,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2013,7478,667,40809,81400,2,67,2,1561.98,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2014,7478,667,40809,81400,2,13,1,9000.00,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2015,7478,668,40809,81400,2,96,2,165.29,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2016,7478,668,40809,81400,2,67,2,34.71,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2017,7478,668,40809,81400,2,13,1,200.00,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2018,7478,669,40809,81400,2,96,2,8264.46,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2019,7478,669,40809,81400,2,67,2,1735.54,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2020,7478,669,40809,81400,2,13,1,10000.00,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2021,7478,670,40809,81400,2,96,2,82.50,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2022,7478,670,40809,81400,2,67,2,17.32,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2023,7478,670,40809,81400,2,13,1,99.82,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2024,7478,671,40809,81400,2,96,2,511.14,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2025,7478,671,40809,81400,2,67,2,107.34,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2026,7478,671,40809,81400,2,13,1,618.48,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2027,7478,672,40809,81400,2,96,2,123.97,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2028,7478,672,40809,81400,2,67,2,26.03,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2029,7478,672,40809,81400,2,13,1,150.00,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2030,7478,673,40809,81400,2,96,2,11404.96,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2031,7478,673,40809,81400,2,67,2,2395.04,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2032,7478,673,40809,81400,2,13,1,13800.00,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2033,7478,674,40809,81400,2,96,2,1857.25,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2034,7478,674,40809,81400,2,67,2,390.02,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2035,7478,674,40809,81400,2,13,1,2247.27,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL);
INSERT INTO `balance_libro_details` VALUES (2036,7478,675,40809,81400,2,96,2,11404.96,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2037,7478,675,40809,81400,2,67,2,2395.04,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2038,7478,675,40809,81400,2,13,1,13800.00,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2039,7478,676,40809,81400,2,96,2,355.37,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2040,7478,676,40809,81400,2,67,2,74.63,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2041,7478,676,40809,81400,2,13,1,430.00,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2042,7478,677,40809,81400,2,96,2,752.07,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2043,7478,677,40809,81400,2,67,2,157.93,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2044,7478,677,40809,81400,2,13,1,910.00,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2045,7478,678,40809,81400,2,96,2,12727.27,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2046,7478,678,40809,81400,2,67,2,2672.73,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2047,7478,678,40809,81400,2,13,1,15400.00,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2048,7478,679,40809,81400,2,96,2,165.29,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2049,7478,679,40809,81400,2,67,2,34.71,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2050,7478,679,40809,81400,2,13,1,200.00,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2051,7478,680,40809,81400,2,96,2,5206.61,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2052,7478,680,40809,81400,2,67,2,1093.39,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2053,7478,680,40809,81400,2,13,1,6300.00,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2054,7478,681,40809,81400,2,96,2,495.87,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2055,7478,681,40809,81400,2,67,2,104.13,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2056,7478,681,40809,81400,2,13,1,600.00,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2057,7478,682,40809,81400,2,96,2,82.50,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2058,7478,682,40809,81400,2,67,2,17.32,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2059,7478,682,40809,81400,2,13,1,99.82,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2060,7478,683,40809,81400,2,96,2,4876.03,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2061,7478,683,40809,81400,2,67,2,1023.97,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2062,7478,683,40809,81400,2,13,1,5900.00,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2063,7478,684,40809,81400,2,96,2,12809.92,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2064,7478,684,40809,81400,2,67,2,2690.08,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2065,7478,684,40809,81400,2,13,1,15500.00,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2066,7478,685,40809,81400,2,96,2,7508.26,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2067,7478,685,40809,81400,2,67,2,1576.74,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2068,7478,685,40809,81400,2,13,1,9085.00,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2069,7478,686,40809,81400,2,96,2,8743.80,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2070,7478,686,40809,81400,2,67,2,1836.20,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2071,7478,686,40809,81400,2,13,1,10580.00,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2072,7478,687,40809,81400,2,96,2,1421.32,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2073,7478,687,40809,81400,2,67,2,298.48,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2074,7478,687,40809,81400,2,13,1,1719.80,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2075,7478,688,40809,81400,2,96,2,224.13,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2076,7478,688,40809,81400,2,67,2,47.07,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL);
INSERT INTO `balance_libro_details` VALUES (2077,7478,688,40809,81400,2,13,1,271.20,NULL,'2022-08-12 20:39:30','2022-08-12 20:39:30',NULL),(2078,7478,689,40809,81400,2,96,2,446.28,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2079,7478,689,40809,81400,2,67,2,93.72,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2080,7478,689,40809,81400,2,13,1,540.00,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2081,7478,690,40809,81400,2,96,2,2803.26,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2082,7478,690,40809,81400,2,67,2,588.68,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2083,7478,690,40809,81400,2,13,1,3391.94,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2084,7478,691,40809,81400,2,96,2,595.04,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2085,7478,691,40809,81400,2,67,2,124.96,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2086,7478,691,40809,81400,2,13,1,720.00,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2087,7478,692,40809,81400,2,96,2,10264.46,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2088,7478,692,40809,81400,2,67,2,2155.54,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2089,7478,692,40809,81400,2,13,1,12420.00,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2090,7478,693,40809,81400,2,96,2,4504.76,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2091,7478,693,40809,81400,2,67,2,946.00,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2092,7478,693,40809,81400,2,13,1,5450.76,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2093,7478,694,40809,81400,2,96,2,276.00,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2094,7478,694,40809,81400,2,67,2,57.96,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2095,7478,694,40809,81400,2,13,1,333.96,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2096,7478,695,40809,81400,2,96,2,294.68,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2097,7478,695,40809,81400,2,67,2,61.88,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2098,7478,695,40809,81400,2,13,1,356.56,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2099,7478,696,40809,81400,2,96,2,9643.84,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2100,7478,696,40809,81400,2,67,2,2025.21,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2101,7478,696,40809,81400,2,13,1,11669.05,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2102,7478,697,40809,81400,2,96,2,223.14,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2103,7478,697,40809,81400,2,67,2,46.86,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2104,7478,697,40809,81400,2,13,1,270.00,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2105,7478,698,40809,81400,2,96,2,6177.69,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2106,7478,698,40809,81400,2,67,2,1297.31,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2107,7478,698,40809,81400,2,13,1,7475.00,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2108,7478,699,40809,81400,2,96,2,4545.45,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2109,7478,699,40809,81400,2,67,2,954.55,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2110,7478,699,40809,81400,2,13,1,5500.00,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2111,7478,700,40809,81400,2,96,2,223.14,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2112,7478,700,40809,81400,2,67,2,46.86,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2113,7478,700,40809,81400,2,13,1,270.00,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2114,7478,701,40809,81400,2,96,2,2555.17,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2115,7478,701,40809,81400,2,67,2,536.59,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2116,7478,701,40809,81400,2,13,1,3091.76,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2117,7478,702,40809,81400,2,96,2,8925.62,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL);
INSERT INTO `balance_libro_details` VALUES (2118,7478,702,40809,81400,2,67,2,1874.38,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2119,7478,702,40809,81400,2,13,1,10800.00,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2120,7478,703,40809,81400,2,96,2,8512.40,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2121,7478,703,40809,81400,2,67,2,1787.60,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2122,7478,703,40809,81400,2,13,1,10300.00,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2123,7478,704,40809,81400,2,96,2,7438.02,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2124,7478,704,40809,81400,2,67,2,1561.98,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2125,7478,704,40809,81400,2,13,1,9000.00,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2126,7478,705,40809,81400,2,96,2,987.52,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2127,7478,705,40809,81400,2,67,2,207.38,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2128,7478,705,40809,81400,2,13,1,1194.90,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2129,7478,706,40809,81400,2,96,2,206.61,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2130,7478,706,40809,81400,2,67,2,43.39,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2131,7478,706,40809,81400,2,13,1,250.00,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2132,7478,707,40809,81400,2,96,2,4958.68,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2133,7478,707,40809,81400,2,67,2,1041.32,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2134,7478,707,40809,81400,2,13,1,6000.00,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2135,7478,708,40809,81400,2,96,2,92.28,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2136,7478,708,40809,81400,2,67,2,19.38,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2137,7478,708,40809,81400,2,13,1,111.66,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2138,7478,709,40809,81400,2,96,2,206.61,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2139,7478,709,40809,81400,2,67,2,43.39,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2140,7478,709,40809,81400,2,13,1,250.00,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2141,7478,710,40809,81400,2,96,2,4958.68,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2142,7478,710,40809,81400,2,67,2,1041.32,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2143,7478,710,40809,81400,2,13,1,6000.00,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2144,7478,711,40809,81400,2,96,2,5371.90,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2145,7478,711,40809,81400,2,67,2,1128.10,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2146,7478,711,40809,81400,2,13,1,6500.00,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2147,7478,712,40809,81400,2,96,2,9818.18,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2148,7478,712,40809,81400,2,67,2,2061.82,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2149,7478,712,40809,81400,2,13,1,11880.00,NULL,'2022-08-12 20:39:31','2022-08-12 20:39:31',NULL),(2150,7478,713,40809,81400,2,96,2,7438.02,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2151,7478,713,40809,81400,2,67,2,1561.98,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2152,7478,713,40809,81400,2,13,1,9000.00,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2153,7478,714,40809,81400,2,96,2,7128.10,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2154,7478,714,40809,81400,2,67,2,1496.90,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2155,7478,714,40809,81400,2,13,1,8625.00,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2156,7478,715,40809,81400,2,96,2,652.89,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2157,7478,715,40809,81400,2,67,2,137.11,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2158,7478,715,40809,81400,2,13,1,790.00,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL);
INSERT INTO `balance_libro_details` VALUES (2159,7478,716,40809,81400,2,96,2,158.56,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2160,7478,716,40809,81400,2,67,2,33.30,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2161,7478,716,40809,81400,2,13,1,191.86,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2162,7478,717,40809,81400,2,96,2,15867.77,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2163,7478,717,40809,81400,2,67,2,3332.23,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2164,7478,717,40809,81400,2,13,1,19200.00,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2165,7478,718,40809,81400,2,96,2,9917.36,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2166,7478,718,40809,81400,2,67,2,2082.64,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2167,7478,718,40809,81400,2,13,1,12000.00,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2168,7478,719,40809,81400,2,96,2,309.92,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2169,7478,719,40809,81400,2,67,2,65.08,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2170,7478,719,40809,81400,2,13,1,375.00,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2171,7478,720,40809,81400,2,96,2,2066.84,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2172,7478,720,40809,81400,2,67,2,434.04,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2173,7478,720,40809,81400,2,13,1,2500.88,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2174,7478,721,40809,81400,2,96,2,264.48,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2175,7478,721,40809,81400,2,67,2,55.54,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2176,7478,721,40809,81400,2,13,1,320.02,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2177,7478,722,40809,81400,2,96,2,247.93,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2178,7478,722,40809,81400,2,67,2,52.07,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2179,7478,722,40809,81400,2,13,1,300.00,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2180,7478,723,40809,81400,2,96,2,1316.26,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2181,7478,723,40809,81400,2,67,2,276.41,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2182,7478,723,40809,81400,2,13,1,1592.67,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2183,7478,724,40809,81400,2,96,2,9599.17,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2184,7478,724,40809,81400,2,67,2,2015.83,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2185,7478,724,40809,81400,2,13,1,11615.00,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2186,7478,725,40809,81400,2,96,2,148.76,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2187,7478,725,40809,81400,2,67,2,31.24,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2188,7478,725,40809,81400,2,13,1,180.00,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2189,7478,726,40809,81400,2,96,2,1157.02,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2190,7478,726,40809,81400,2,67,2,242.98,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2191,7478,726,40809,81400,2,13,1,1400.00,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2192,7478,727,40809,81400,2,96,2,3246.36,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2193,7478,727,40809,81400,2,67,2,681.73,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2194,7478,727,40809,81400,2,13,1,3928.09,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2195,7478,728,40809,81400,2,96,2,7851.24,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2196,7478,728,40809,81400,2,67,2,1648.76,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2197,7478,728,40809,81400,2,13,1,9500.00,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2198,7478,729,40809,81400,2,96,2,270.41,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2199,7478,729,40809,81400,2,67,2,56.79,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL);
INSERT INTO `balance_libro_details` VALUES (2200,7478,729,40809,81400,2,13,1,327.20,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2201,7478,730,40809,81400,2,96,2,289.26,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2202,7478,730,40809,81400,2,67,2,60.74,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2203,7478,730,40809,81400,2,13,1,350.00,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2204,7478,731,40809,81400,2,96,2,9917.36,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2205,7478,731,40809,81400,2,67,2,2082.64,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2206,7478,731,40809,81400,2,13,1,12000.00,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2207,7478,732,40809,81400,2,96,2,8099.17,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2208,7478,732,40809,81400,2,67,2,1700.83,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2209,7478,732,40809,81400,2,13,1,9800.00,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2210,7478,733,40809,81400,2,96,2,495.87,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2211,7478,733,40809,81400,2,67,2,104.13,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2212,7478,733,40809,81400,2,13,1,600.00,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2213,7478,734,40809,81400,2,96,2,158.56,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2214,7478,734,40809,81400,2,67,2,33.30,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2215,7478,734,40809,81400,2,13,1,191.86,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2216,7478,735,40809,81400,2,96,2,4268.40,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2217,7478,735,40809,81400,2,67,2,896.36,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2218,7478,735,40809,81400,2,13,1,5164.76,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2219,7478,736,40809,81400,2,96,2,158.56,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2220,7478,736,40809,81400,2,67,2,33.30,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2221,7478,736,40809,81400,2,13,1,191.86,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2222,7478,737,40809,81400,2,96,2,2992.50,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2223,7478,737,40809,81400,2,67,2,628.42,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2224,7478,737,40809,81400,2,13,1,3620.92,NULL,'2022-08-12 20:39:32','2022-08-12 20:39:32',NULL),(2225,7478,738,40809,81400,2,96,2,206.74,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2226,7478,738,40809,81400,2,67,2,43.42,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2227,7478,738,40809,81400,2,13,1,250.16,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2228,7478,739,40809,81400,2,96,2,11659.67,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2229,7478,739,40809,81400,2,67,2,2448.53,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2230,7478,739,40809,81400,2,13,1,14108.20,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2231,7478,740,40809,81400,2,96,2,7851.24,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2232,7478,740,40809,81400,2,67,2,1648.76,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2233,7478,740,40809,81400,2,13,1,9500.00,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2234,7478,741,40809,81400,2,96,2,216.94,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2235,7478,741,40809,81400,2,67,2,45.56,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2236,7478,741,40809,81400,2,13,1,262.50,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2237,7478,742,40809,81400,2,96,2,988.28,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2238,7478,742,40809,81400,2,67,2,207.54,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2239,7478,742,40809,81400,2,13,1,1195.82,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2240,7478,743,40809,81400,2,96,2,495.87,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL);
INSERT INTO `balance_libro_details` VALUES (2241,7478,743,40809,81400,2,67,2,104.13,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2242,7478,743,40809,81400,2,13,1,600.00,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2243,7478,744,40809,81400,2,96,2,132.25,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2244,7478,744,40809,81400,2,67,2,27.77,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2245,7478,744,40809,81400,2,13,1,160.02,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2246,7478,745,40809,81400,2,96,2,6167.77,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2247,7478,745,40809,81400,2,67,2,1295.23,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2248,7478,745,40809,81400,2,13,1,7463.00,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2249,7478,746,40809,81400,2,96,2,2332.07,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2250,7478,746,40809,81400,2,67,2,489.73,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2251,7478,746,40809,81400,2,13,1,2821.80,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2252,7478,747,40809,81400,2,96,2,879.54,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2253,7478,747,40809,81400,2,67,2,184.70,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2254,7478,747,40809,81400,2,13,1,1064.24,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2255,7478,748,40809,81400,2,96,2,10739.67,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2256,7478,748,40809,81400,2,67,2,2255.33,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2257,7478,748,40809,81400,2,13,1,12995.00,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2258,7478,749,40809,81400,2,96,2,11576.03,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2259,7478,749,40809,81400,2,67,2,2430.97,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2260,7478,749,40809,81400,2,13,1,14007.00,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2261,7478,750,40809,81400,2,96,2,9028.93,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2262,7478,750,40809,81400,2,67,2,1896.07,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2263,7478,750,40809,81400,2,13,1,10925.00,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2264,7478,751,40809,81400,2,96,2,234.00,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2265,7478,751,40809,81400,2,67,2,49.14,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2266,7478,751,40809,81400,2,13,1,283.14,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2267,7478,752,40809,81400,2,96,2,234.00,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2268,7478,752,40809,81400,2,67,2,49.14,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2269,7478,752,40809,81400,2,13,1,283.14,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2270,7478,753,40809,81400,2,96,2,7793.39,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2271,7478,753,40809,81400,2,67,2,1636.61,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2272,7478,753,40809,81400,2,13,1,9430.00,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2273,7478,754,40809,81400,2,96,2,10319.59,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2274,7478,754,40809,81400,2,67,2,2167.11,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2275,7478,754,40809,81400,2,13,1,12486.70,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2276,7478,755,40809,81400,2,96,2,11570.25,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2277,7478,755,40809,81400,2,67,2,2429.75,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2278,7478,755,40809,81400,2,13,1,14000.00,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2279,7478,756,40809,81400,2,96,2,4466.94,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2280,7478,756,40809,81400,2,67,2,938.06,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2281,7478,756,40809,81400,2,13,1,5405.00,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL);
INSERT INTO `balance_libro_details` VALUES (2282,7478,757,40809,81400,2,96,2,7851.24,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2283,7478,757,40809,81400,2,67,2,1648.76,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2284,7478,757,40809,81400,2,13,1,9500.00,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2285,7478,758,40809,81400,2,96,2,223.14,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2286,7478,758,40809,81400,2,67,2,46.86,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2287,7478,758,40809,81400,2,13,1,270.00,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2288,7478,759,40809,81400,2,96,2,9694.21,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2289,7478,759,40809,81400,2,67,2,2035.79,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2290,7478,759,40809,81400,2,13,1,11730.00,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2291,7478,760,40809,81400,2,96,2,180.28,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2292,7478,760,40809,81400,2,67,2,37.86,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2293,7478,760,40809,81400,2,13,1,218.14,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2294,7478,761,40809,81400,2,96,2,9256.20,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2295,7478,761,40809,81400,2,67,2,1943.80,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2296,7478,761,40809,81400,2,13,1,11200.00,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2297,7478,762,40809,81400,2,96,2,2791.62,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2298,7478,762,40809,81400,2,67,2,586.24,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2299,7478,762,40809,81400,2,13,1,3377.86,NULL,'2022-08-12 20:39:33','2022-08-12 20:39:33',NULL),(2300,7478,763,40809,81400,2,96,2,5702.48,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2301,7478,763,40809,81400,2,67,2,1197.52,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2302,7478,763,40809,81400,2,13,1,6900.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2303,7478,764,40809,81400,2,96,2,11576.03,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2304,7478,764,40809,81400,2,67,2,2430.97,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2305,7478,764,40809,81400,2,13,1,14007.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2306,7478,765,40809,81400,2,96,2,1739.02,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2307,7478,765,40809,81400,2,67,2,365.19,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2308,7478,765,40809,81400,2,218,2,0.01,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2309,7478,765,40809,81400,2,13,1,2104.22,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2310,7478,766,40809,81400,2,96,2,11500.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2311,7478,766,40809,81400,2,67,2,2415.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2312,7478,766,40809,81400,2,13,1,13915.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2313,7478,767,40809,81400,2,96,2,9669.42,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2314,7478,767,40809,81400,2,67,2,2030.58,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2315,7478,767,40809,81400,2,13,1,11700.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2316,7478,768,40809,81400,2,96,2,9090.91,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2317,7478,768,40809,81400,2,67,2,1909.09,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2318,7478,768,40809,81400,2,13,1,11000.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2319,7478,769,40809,81400,2,96,2,5785.12,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2320,7478,769,40809,81400,2,67,2,1214.88,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2321,7478,769,40809,81400,2,13,1,7000.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2322,7478,770,40809,81400,2,96,2,626.73,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL);
INSERT INTO `balance_libro_details` VALUES (2323,7478,770,40809,81400,2,67,2,131.61,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2324,7478,770,40809,81400,2,13,1,758.34,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2325,7478,771,40809,81400,2,96,2,356.38,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2326,7478,771,40809,81400,2,67,2,74.84,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2327,7478,771,40809,81400,2,13,1,431.22,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2328,7478,772,40809,81400,2,96,2,32727.27,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2329,7478,772,40809,81400,2,67,2,6872.73,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2330,7478,772,40809,81400,2,13,1,39600.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2331,7478,773,40809,81400,2,96,2,6177.69,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2332,7478,773,40809,81400,2,67,2,1297.31,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2333,7478,773,40809,81400,2,13,1,7475.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2334,7478,774,40809,81400,2,96,2,9599.17,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2335,7478,774,40809,81400,2,67,2,2015.83,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2336,7478,774,40809,81400,2,13,1,11615.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2337,7478,775,40809,81400,2,96,2,2111.55,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2338,7478,775,40809,81400,2,67,2,443.43,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2339,7478,775,40809,81400,2,13,1,2554.98,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2340,7478,776,40809,81400,2,96,2,2231.89,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2341,7478,776,40809,81400,2,67,2,468.70,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2342,7478,776,40809,81400,2,13,1,2700.59,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2343,7478,777,40809,81400,2,96,2,3611.59,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2344,7478,777,40809,81400,2,67,2,758.43,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2345,7478,777,40809,81400,2,13,1,4370.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2346,7478,777,40809,81400,2,136,1,0.02,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2347,7478,778,40809,81400,2,96,2,9090.91,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2348,7478,778,40809,81400,2,67,2,1909.09,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2349,7478,778,40809,81400,2,13,1,11000.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2350,7478,779,40809,81400,2,96,2,52.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2351,7478,779,40809,81400,2,67,2,10.92,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2352,7478,779,40809,81400,2,13,1,62.92,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2353,7478,780,40809,81400,2,96,2,413.22,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2354,7478,780,40809,81400,2,67,2,86.78,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2355,7478,780,40809,81400,2,13,1,500.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2356,7478,781,40809,81400,2,96,2,237.36,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2357,7478,781,40809,81400,2,67,2,49.84,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2358,7478,781,40809,81400,2,13,1,287.20,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2359,7478,782,40809,81400,2,96,2,7851.24,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2360,7478,782,40809,81400,2,67,2,1648.76,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2361,7478,782,40809,81400,2,13,1,9500.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2362,7478,783,40809,81400,2,96,2,3057.85,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2363,7478,783,40809,81400,2,67,2,642.15,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL);
INSERT INTO `balance_libro_details` VALUES (2364,7478,783,40809,81400,2,13,1,3700.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2365,7478,784,40809,81400,2,96,2,519.35,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2366,7478,784,40809,81400,2,67,2,109.06,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2367,7478,784,40809,81400,2,13,1,628.41,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2368,7478,785,40809,81400,2,96,2,5867.77,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2369,7478,785,40809,81400,2,67,2,1232.23,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2370,7478,785,40809,81400,2,13,1,7100.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2371,7478,786,40809,81400,2,96,2,304.13,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2372,7478,786,40809,81400,2,67,2,63.87,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2373,7478,786,40809,81400,2,13,1,368.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2374,7478,787,40809,81400,2,96,2,11785.12,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2375,7478,787,40809,81400,2,67,2,2474.88,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2376,7478,787,40809,81400,2,13,1,14260.00,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2377,7478,788,40809,81400,2,96,2,1485.17,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2378,7478,788,40809,81400,2,67,2,311.89,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2379,7478,788,40809,81400,2,13,1,1797.06,NULL,'2022-08-12 20:39:34','2022-08-12 20:39:34',NULL),(2380,7478,789,40809,81400,2,96,2,19555.20,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2381,7478,789,40809,81400,2,67,2,4106.59,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2382,7478,789,40809,81400,2,13,1,23661.79,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2383,7478,790,40809,81400,2,96,2,64958.68,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2384,7478,790,40809,81400,2,67,2,13641.32,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2385,7478,790,40809,81400,2,13,1,78600.00,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2386,7478,791,40809,81400,2,96,2,9485.12,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2387,7478,791,40809,81400,2,67,2,1991.88,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2388,7478,791,40809,81400,2,13,1,11477.00,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2389,7478,792,40809,81400,2,96,2,383.47,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2390,7478,792,40809,81400,2,67,2,80.53,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2391,7478,792,40809,81400,2,13,1,464.00,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2392,7478,793,40809,81400,2,96,2,818.21,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2393,7478,793,40809,81400,2,67,2,171.83,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2394,7478,793,40809,81400,2,13,1,990.04,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2395,7478,794,40809,81400,2,96,2,33.06,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2396,7478,794,40809,81400,2,67,2,6.94,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2397,7478,794,40809,81400,2,13,1,40.00,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2398,7478,795,40809,81400,2,96,2,8264.46,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2399,7478,795,40809,81400,2,67,2,1735.54,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2400,7478,795,40809,81400,2,13,1,10000.00,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2401,7478,796,40809,81400,2,96,2,208.26,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2402,7478,796,40809,81400,2,67,2,43.74,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2403,7478,796,40809,81400,2,13,1,252.00,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2404,7478,797,40809,81400,2,96,2,2751.66,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL);
INSERT INTO `balance_libro_details` VALUES (2405,7478,797,40809,81400,2,67,2,577.85,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2406,7478,797,40809,81400,2,218,2,0.02,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2407,7478,797,40809,81400,2,13,1,3329.53,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2408,7478,798,40809,81400,2,96,2,413.22,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2409,7478,798,40809,81400,2,67,2,86.78,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2410,7478,798,40809,81400,2,13,1,500.00,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2411,7478,799,40809,81400,2,96,2,9256.20,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2412,7478,799,40809,81400,2,67,2,1943.80,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2413,7478,799,40809,81400,2,13,1,11200.00,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2414,7478,800,40809,81400,2,96,2,330.58,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2415,7478,800,40809,81400,2,67,2,69.42,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2416,7478,800,40809,81400,2,13,1,400.00,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2417,7478,801,40809,81400,2,96,2,5950.41,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2418,7478,801,40809,81400,2,67,2,1249.59,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2419,7478,801,40809,81400,2,13,1,7200.00,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2420,7478,802,40809,81400,2,96,2,5371.90,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2421,7478,802,40809,81400,2,67,2,1128.10,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2422,7478,802,40809,81400,2,13,1,6500.00,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2423,7478,803,40809,81400,2,96,2,275.40,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2424,7478,803,40809,81400,2,67,2,57.83,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2425,7478,803,40809,81400,2,13,1,333.23,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2426,7478,804,40809,81400,2,96,2,121.52,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2427,7478,804,40809,81400,2,67,2,25.52,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2428,7478,804,40809,81400,2,13,1,147.04,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2429,7478,805,40809,81400,2,96,2,206.61,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2430,7478,805,40809,81400,2,67,2,43.39,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2431,7478,805,40809,81400,2,13,1,250.00,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2432,7478,806,40809,81400,2,96,2,1249.75,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2433,7478,806,40809,81400,2,67,2,262.45,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2434,7478,806,40809,81400,2,13,1,1512.20,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2435,7478,807,40809,81400,2,96,2,10549.59,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2436,7478,807,40809,81400,2,67,2,2215.41,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2437,7478,807,40809,81400,2,13,1,12765.00,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2438,7478,808,40809,81400,2,96,2,9504.13,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2439,7478,808,40809,81400,2,67,2,1995.87,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2440,7478,808,40809,81400,2,13,1,11500.00,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2441,7478,809,40809,81400,2,96,2,419.13,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2442,7478,809,40809,81400,2,67,2,88.02,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2443,7478,809,40809,81400,2,13,1,507.15,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2444,7478,810,40809,81400,2,96,2,5867.77,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2445,7478,810,40809,81400,2,67,2,1232.23,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL);
INSERT INTO `balance_libro_details` VALUES (2446,7478,810,40809,81400,2,13,1,7100.00,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2447,7478,811,40809,81400,2,96,2,661.16,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2448,7478,811,40809,81400,2,67,2,138.84,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2449,7478,811,40809,81400,2,13,1,800.00,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2450,7478,812,40809,81400,2,96,2,8347.11,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2451,7478,812,40809,81400,2,67,2,1752.89,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2452,7478,812,40809,81400,2,13,1,10100.00,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2453,7478,813,40809,81400,2,96,2,7024.79,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2454,7478,813,40809,81400,2,67,2,1475.21,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2455,7478,813,40809,81400,2,13,1,8500.00,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2456,7478,814,40809,81400,2,96,2,9504.13,NULL,'2022-08-12 20:39:35','2022-08-12 20:39:35',NULL),(2457,7478,814,40809,81400,2,67,2,1995.87,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2458,7478,814,40809,81400,2,13,1,11500.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2459,7478,815,40809,81400,2,96,2,7520.66,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2460,7478,815,40809,81400,2,67,2,1579.34,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2461,7478,815,40809,81400,2,13,1,9100.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2462,7478,816,40809,81400,2,96,1,64958.68,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2463,7478,816,40809,81400,2,68,1,13641.32,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2464,7478,816,40809,81400,2,13,2,78600.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2465,7478,817,40809,81400,2,96,2,11487.60,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2466,7478,817,40809,81400,2,67,2,2412.40,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2467,7478,817,40809,81400,2,13,1,13900.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2468,7478,818,40809,81400,2,96,2,6173.55,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2469,7478,818,40809,81400,2,67,2,1296.45,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2470,7478,818,40809,81400,2,13,1,7470.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2471,7478,819,40809,81400,2,96,2,2884.30,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2472,7478,819,40809,81400,2,67,2,605.70,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2473,7478,819,40809,81400,2,13,1,3490.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2474,7478,820,40809,81400,2,96,2,20330.58,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2475,7478,820,40809,81400,2,67,2,4269.42,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2476,7478,820,40809,81400,2,13,1,24600.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2477,7478,821,40809,81400,2,96,2,19338.84,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2478,7478,821,40809,81400,2,67,2,4061.16,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2479,7478,821,40809,81400,2,13,1,23400.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2480,7478,822,40809,81400,2,96,2,33140.50,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2481,7478,822,40809,81400,2,67,2,6959.50,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2482,7478,822,40809,81400,2,13,1,40100.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2483,7478,823,40809,81400,2,96,2,8347.11,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2484,7478,823,40809,81400,2,67,2,1752.89,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2485,7478,823,40809,81400,2,13,1,10100.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2486,7478,824,40809,81400,2,96,2,4132.23,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL);
INSERT INTO `balance_libro_details` VALUES (2487,7478,824,40809,81400,2,67,2,867.77,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2488,7478,824,40809,81400,2,13,1,5000.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2489,7478,825,40809,81400,2,96,2,236.95,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2490,7478,825,40809,81400,2,67,2,49.76,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2491,7478,825,40809,81400,2,13,1,286.71,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2492,7478,826,40809,81400,2,96,2,132.25,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2493,7478,826,40809,81400,2,67,2,27.77,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2494,7478,826,40809,81400,2,13,1,160.02,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2495,7478,827,40809,81400,2,96,2,8264.46,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2496,7478,827,40809,81400,2,67,2,1735.54,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2497,7478,827,40809,81400,2,13,1,10000.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2498,7478,828,40809,81400,2,96,2,8264.46,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2499,7478,828,40809,81400,2,67,2,1735.54,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2500,7478,828,40809,81400,2,13,1,10000.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2501,7478,829,40809,81400,2,96,2,7851.24,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2502,7478,829,40809,81400,2,67,2,1648.76,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2503,7478,829,40809,81400,2,13,1,9500.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2504,7478,830,40809,81400,2,96,2,490.64,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2505,7478,830,40809,81400,2,67,2,103.04,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2506,7478,830,40809,81400,2,13,1,593.68,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2507,7478,831,40809,81400,2,96,2,5392.19,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2508,7478,831,40809,81400,2,67,2,1132.36,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2509,7478,831,40809,81400,2,13,1,6524.55,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2510,7478,832,40809,81400,2,96,2,198.35,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2511,7478,832,40809,81400,2,67,2,41.65,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2512,7478,832,40809,81400,2,13,1,240.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2513,7478,833,40809,81400,2,96,2,10644.63,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2514,7478,833,40809,81400,2,67,2,2235.37,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2515,7478,833,40809,81400,2,13,1,12880.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2516,7478,834,40809,81400,2,96,2,1078.51,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2517,7478,834,40809,81400,2,67,2,226.49,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2518,7478,834,40809,81400,2,13,1,1305.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2519,7478,835,40809,81400,2,96,2,8.26,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2520,7478,835,40809,81400,2,67,2,1.74,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2521,7478,835,40809,81400,2,13,1,10.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2522,7478,836,40809,81400,2,96,2,127.50,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2523,7478,836,40809,81400,2,67,2,26.78,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2524,7478,836,40809,81400,2,13,1,154.28,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2525,7478,837,40809,81400,2,96,2,10330.58,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2526,7478,837,40809,81400,2,67,2,2169.42,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL),(2527,7478,837,40809,81400,2,13,1,12500.00,NULL,'2022-08-12 20:39:36','2022-08-12 20:39:36',NULL);
INSERT INTO `balance_libro_details` VALUES (2528,7478,838,40809,81400,2,96,2,10834.71,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2529,7478,838,40809,81400,2,67,2,2275.29,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2530,7478,838,40809,81400,2,13,1,13110.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2531,7478,839,40809,81400,2,96,2,6115.70,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2532,7478,839,40809,81400,2,67,2,1284.30,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2533,7478,839,40809,81400,2,13,1,7400.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2534,7478,840,40809,81400,2,96,2,15016.53,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2535,7478,840,40809,81400,2,67,2,3153.47,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2536,7478,840,40809,81400,2,13,1,18170.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2537,7478,841,40809,81400,2,96,2,190.91,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2538,7478,841,40809,81400,2,67,2,40.09,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2539,7478,841,40809,81400,2,13,1,231.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2540,7478,842,40809,81400,2,96,2,4793.39,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2541,7478,842,40809,81400,2,67,2,1006.61,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2542,7478,842,40809,81400,2,13,1,5800.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2543,7478,843,40809,81400,2,96,2,7851.24,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2544,7478,843,40809,81400,2,67,2,1648.76,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2545,7478,843,40809,81400,2,13,1,9500.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2546,7478,844,40809,81400,2,96,2,200.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2547,7478,844,40809,81400,2,67,2,42.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2548,7478,844,40809,81400,2,13,1,242.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2549,7478,845,40809,81400,2,96,2,2148.76,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2550,7478,845,40809,81400,2,67,2,451.24,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2551,7478,845,40809,81400,2,13,1,2600.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2552,7478,846,40809,81400,2,96,2,6611.57,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2553,7478,846,40809,81400,2,67,2,1388.43,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2554,7478,846,40809,81400,2,13,1,8000.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2555,7478,847,40809,81400,2,96,2,1324.56,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2556,7478,847,40809,81400,2,67,2,278.16,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2557,7478,847,40809,81400,2,13,1,1602.72,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2558,7478,848,40809,81400,2,96,2,12809.92,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2559,7478,848,40809,81400,2,67,2,2690.08,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2560,7478,848,40809,81400,2,13,1,15500.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2561,7478,849,40809,81400,2,96,2,5227.27,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2562,7478,849,40809,81400,2,67,2,1097.73,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2563,7478,849,40809,81400,2,13,1,6325.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2564,7478,850,40809,81400,2,96,2,258.61,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2565,7478,850,40809,81400,2,67,2,54.31,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2566,7478,850,40809,81400,2,13,1,312.92,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2567,7478,851,40809,81400,2,96,2,547.74,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2568,7478,851,40809,81400,2,67,2,115.03,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL);
INSERT INTO `balance_libro_details` VALUES (2569,7478,851,40809,81400,2,13,1,662.77,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2570,7478,852,40809,81400,2,96,2,11322.31,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2571,7478,852,40809,81400,2,67,2,2377.69,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2572,7478,852,40809,81400,2,13,1,13700.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2573,7478,853,40809,81400,2,96,2,403.42,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2574,7478,853,40809,81400,2,67,2,84.72,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2575,7478,853,40809,81400,2,13,1,488.14,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2576,7478,854,40809,81400,2,96,2,10264.46,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2577,7478,854,40809,81400,2,67,2,2155.54,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2578,7478,854,40809,81400,2,13,1,12420.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2579,7478,855,40809,81400,2,96,2,9256.20,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2580,7478,855,40809,81400,2,67,2,1943.80,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2581,7478,855,40809,81400,2,13,1,11200.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2582,7478,856,40809,81400,2,96,2,121.52,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2583,7478,856,40809,81400,2,67,2,25.52,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2584,7478,856,40809,81400,2,13,1,147.04,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2585,7478,857,40809,81400,2,96,2,10644.63,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2586,7478,857,40809,81400,2,67,2,2235.37,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2587,7478,857,40809,81400,2,13,1,12880.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2588,7478,858,40809,81400,2,96,2,164.99,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2589,7478,858,40809,81400,2,67,2,34.65,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2590,7478,858,40809,81400,2,13,1,199.64,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2591,7478,859,40809,81400,2,96,2,5206.61,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2592,7478,859,40809,81400,2,67,2,1093.39,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2593,7478,859,40809,81400,2,13,1,6300.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2594,7478,860,40809,81400,2,96,2,798.46,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2595,7478,860,40809,81400,2,67,2,167.68,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2596,7478,860,40809,81400,2,13,1,966.14,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2597,7478,861,40809,81400,2,96,2,165.00,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2598,7478,861,40809,81400,2,67,2,34.65,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2599,7478,861,40809,81400,2,13,1,199.65,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2600,7478,862,40809,81400,2,96,2,9219.01,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2601,7478,862,40809,81400,2,67,2,1935.99,NULL,'2022-08-12 20:39:37','2022-08-12 20:39:37',NULL),(2602,7478,862,40809,81400,2,13,1,11155.00,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2603,7478,863,40809,81400,2,96,2,408.25,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2604,7478,863,40809,81400,2,67,2,85.73,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2605,7478,863,40809,81400,2,13,1,493.98,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2606,7478,864,40809,81400,2,96,2,8925.62,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2607,7478,864,40809,81400,2,67,2,1874.38,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2608,7478,864,40809,81400,2,13,1,10800.00,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2609,7478,865,40809,81400,2,96,2,108.75,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL);
INSERT INTO `balance_libro_details` VALUES (2610,7478,865,40809,81400,2,67,2,22.84,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2611,7478,865,40809,81400,2,13,1,131.59,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2612,7478,866,40809,81400,2,96,2,82.50,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2613,7478,866,40809,81400,2,67,2,17.32,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2614,7478,866,40809,81400,2,13,1,99.82,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2615,7478,867,40809,81400,2,96,2,10834.71,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2616,7478,867,40809,81400,2,67,2,2275.29,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2617,7478,867,40809,81400,2,13,1,13110.00,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2618,7478,868,40809,81400,2,96,2,752.07,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2619,7478,868,40809,81400,2,67,2,157.93,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2620,7478,868,40809,81400,2,13,1,910.00,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2621,7478,869,40809,81400,2,96,2,3893.09,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2622,7478,869,40809,81400,2,67,2,817.55,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2623,7478,869,40809,81400,2,13,1,4710.64,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2624,7478,870,40809,81400,2,96,2,4958.68,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2625,7478,870,40809,81400,2,67,2,1041.32,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2626,7478,870,40809,81400,2,13,1,6000.00,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2627,7478,871,40809,81400,2,96,2,7272.73,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2628,7478,871,40809,81400,2,67,2,1527.27,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2629,7478,871,40809,81400,2,13,1,8800.00,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2630,7478,872,40809,81400,2,96,2,1006.21,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2631,7478,872,40809,81400,2,67,2,211.30,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2632,7478,872,40809,81400,2,13,1,1217.51,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2633,7478,873,40809,81400,2,96,2,323.97,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2634,7478,873,40809,81400,2,67,2,68.03,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2635,7478,873,40809,81400,2,13,1,392.00,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2636,7478,874,40809,81400,2,96,2,181.82,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2637,7478,874,40809,81400,2,67,2,38.18,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2638,7478,874,40809,81400,2,13,1,220.00,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2639,7478,875,40809,81400,2,96,2,570.21,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2640,7478,875,40809,81400,2,67,2,119.74,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2641,7478,875,40809,81400,2,13,1,689.95,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2642,7478,876,40809,81400,2,96,2,10644.63,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2643,7478,876,40809,81400,2,67,2,2235.37,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2644,7478,876,40809,81400,2,13,1,12880.00,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2645,7478,877,40809,81400,2,96,2,3222.32,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2646,7478,877,40809,81400,2,67,2,676.69,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2647,7478,877,40809,81400,2,13,1,3899.01,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2648,7478,878,40809,81400,2,96,2,421.82,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2649,7478,878,40809,81400,2,67,2,88.58,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2650,7478,878,40809,81400,2,13,1,510.40,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL);
INSERT INTO `balance_libro_details` VALUES (2651,7478,879,40809,81400,2,96,2,206.61,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2652,7478,879,40809,81400,2,67,2,43.39,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2653,7478,879,40809,81400,2,13,1,250.00,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2654,7478,880,40809,81400,2,96,2,420.88,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2655,7478,880,40809,81400,2,67,2,88.39,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2656,7478,880,40809,81400,2,13,1,509.27,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2657,7478,881,40809,81400,2,96,2,8078.51,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2658,7478,881,40809,81400,2,67,2,1696.49,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2659,7478,881,40809,81400,2,13,1,9775.00,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2660,7478,882,40809,81400,2,96,2,5371.90,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2661,7478,882,40809,81400,2,67,2,1128.10,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2662,7478,882,40809,81400,2,13,1,6500.00,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2663,7478,883,40809,81400,2,96,2,0.83,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2664,7478,883,40809,81400,2,67,2,0.17,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2665,7478,883,40809,81400,2,13,1,1.00,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2666,7478,884,40809,81400,2,96,2,6489.42,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2667,7478,884,40809,81400,2,67,2,1362.78,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2668,7478,884,40809,81400,2,13,1,7852.20,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2669,7478,885,40809,81400,2,96,2,2061.50,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2670,7478,885,40809,81400,2,67,2,432.92,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2671,7478,885,40809,81400,2,13,1,2494.42,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2672,7478,886,40809,81400,2,96,2,243.04,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2673,7478,886,40809,81400,2,67,2,51.04,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2674,7478,886,40809,81400,2,13,1,294.08,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2675,7478,887,40809,81400,2,96,2,10330.58,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2676,7478,887,40809,81400,2,67,2,2169.42,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2677,7478,887,40809,81400,2,13,1,12500.00,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2678,7478,888,40809,81400,2,96,2,611.57,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2679,7478,888,40809,81400,2,67,2,128.43,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2680,7478,888,40809,81400,2,13,1,740.00,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2681,7478,889,40809,81400,2,96,2,9.09,NULL,'2022-08-12 20:39:38','2022-08-12 20:39:38',NULL),(2682,7478,889,40809,81400,2,67,2,1.91,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2683,7478,889,40809,81400,2,13,1,11.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2684,7478,890,40809,81400,2,96,2,8.26,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2685,7478,890,40809,81400,2,67,2,1.74,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2686,7478,890,40809,81400,2,13,1,10.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2687,7478,891,40809,81400,2,96,2,4648.72,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2688,7478,891,40809,81400,2,67,2,976.23,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2689,7478,891,40809,81400,2,13,1,5624.95,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2690,7478,892,40809,81400,2,96,2,121.52,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2691,7478,892,40809,81400,2,67,2,25.52,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL);
INSERT INTO `balance_libro_details` VALUES (2692,7478,892,40809,81400,2,13,1,147.04,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2693,7478,893,40809,81400,2,96,2,247.93,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2694,7478,893,40809,81400,2,67,2,52.07,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2695,7478,893,40809,81400,2,13,1,300.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2696,7478,894,40809,81400,2,96,2,8.26,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2697,7478,894,40809,81400,2,67,2,1.74,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2698,7478,894,40809,81400,2,13,1,10.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2699,7478,895,40809,81400,2,96,2,10169.42,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2700,7478,895,40809,81400,2,67,2,2135.58,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2701,7478,895,40809,81400,2,13,1,12305.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2702,7478,896,40809,81400,2,96,2,1239.67,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2703,7478,896,40809,81400,2,67,2,260.33,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2704,7478,896,40809,81400,2,13,1,1500.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2705,7478,897,40809,81400,2,96,2,8.26,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2706,7478,897,40809,81400,2,67,2,1.74,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2707,7478,897,40809,81400,2,13,1,10.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2708,7478,898,40809,81400,2,96,2,8553.72,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2709,7478,898,40809,81400,2,67,2,1796.28,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2710,7478,898,40809,81400,2,13,1,10350.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2711,7478,899,40809,81400,2,96,2,7520.66,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2712,7478,899,40809,81400,2,67,2,1579.34,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2713,7478,899,40809,81400,2,13,1,9100.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2714,7478,900,40809,81400,2,96,2,7851.24,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2715,7478,900,40809,81400,2,67,2,1648.76,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2716,7478,900,40809,81400,2,13,1,9500.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2717,7478,901,40809,81400,2,96,2,3267.33,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2718,7478,901,40809,81400,2,67,2,686.14,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2719,7478,901,40809,81400,2,13,1,3953.47,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2720,7478,902,40809,81400,2,96,2,14731.40,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2721,7478,902,40809,81400,2,67,2,3093.60,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2722,7478,902,40809,81400,2,13,1,17825.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2723,7478,903,40809,81400,2,96,2,3644.63,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2724,7478,903,40809,81400,2,67,2,765.37,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2725,7478,903,40809,81400,2,13,1,4410.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2726,7478,904,40809,81400,2,96,2,126804.85,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2727,7478,904,40809,81400,2,67,2,26629.02,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2728,7478,904,40809,81400,2,13,1,153433.87,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2729,7478,905,40809,81400,2,96,2,9256.20,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2730,7478,905,40809,81400,2,67,2,1943.80,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2731,7478,905,40809,81400,2,13,1,11200.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2732,7478,906,40809,81400,2,96,2,4545.45,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL);
INSERT INTO `balance_libro_details` VALUES (2733,7478,906,40809,81400,2,67,2,954.55,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2734,7478,906,40809,81400,2,13,1,5500.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2735,7478,907,40809,81400,2,96,2,8925.62,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2736,7478,907,40809,81400,2,67,2,1874.38,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2737,7478,907,40809,81400,2,13,1,10800.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2738,7478,908,40809,81400,2,96,2,9173.55,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2739,7478,908,40809,81400,2,67,2,1926.45,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2740,7478,908,40809,81400,2,13,1,11100.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2741,7478,909,40809,81400,2,96,2,12314.05,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2742,7478,909,40809,81400,2,67,2,2585.95,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2743,7478,909,40809,81400,2,13,1,14900.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2744,7478,910,40809,81400,2,96,2,5537.85,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2745,7478,910,40809,81400,2,67,2,1162.95,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2746,7478,910,40809,81400,2,13,1,6700.80,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2747,7478,911,40809,81400,2,96,2,6938.02,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2748,7478,911,40809,81400,2,67,2,1456.98,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2749,7478,911,40809,81400,2,13,1,8395.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2750,7478,912,40809,81400,2,96,2,1167.26,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2751,7478,912,40809,81400,2,67,2,245.12,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2752,7478,912,40809,81400,2,13,1,1412.38,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2753,7478,913,40809,81400,2,96,2,284.30,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2754,7478,913,40809,81400,2,67,2,59.70,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2755,7478,913,40809,81400,2,13,1,344.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2756,7478,914,40809,81400,2,96,2,2975.97,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2757,7478,914,40809,81400,2,67,2,624.95,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2758,7478,914,40809,81400,2,13,1,3600.92,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2759,7478,915,40809,81400,2,96,2,15702.48,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2760,7478,915,40809,81400,2,67,2,3297.52,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2761,7478,915,40809,81400,2,13,1,19000.00,NULL,'2022-08-12 20:39:39','2022-08-12 20:39:39',NULL),(2762,7478,916,40809,81400,2,96,2,300.48,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2763,7478,916,40809,81400,2,67,2,63.10,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2764,7478,916,40809,81400,2,13,1,363.58,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2765,7478,917,40809,81400,2,96,2,10454.55,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2766,7478,917,40809,81400,2,67,2,2195.45,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2767,7478,917,40809,81400,2,13,1,12650.00,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2768,7478,918,40809,81400,2,96,2,8264.46,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2769,7478,918,40809,81400,2,67,2,1735.54,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2770,7478,918,40809,81400,2,13,1,10000.00,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2771,7478,919,40809,81400,2,96,2,10909.42,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2772,7478,919,40809,81400,2,67,2,2290.98,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2773,7478,919,40809,81400,2,13,1,13200.40,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL);
INSERT INTO `balance_libro_details` VALUES (2774,7478,920,40809,81400,2,96,2,901.39,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2775,7478,920,40809,81400,2,67,2,189.29,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2776,7478,920,40809,81400,2,13,1,1090.68,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2777,7478,921,40809,81400,2,96,2,8264.46,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2778,7478,921,40809,81400,2,67,2,1735.54,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2779,7478,921,40809,81400,2,13,1,10000.00,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2780,7478,922,40809,81400,2,96,2,121.52,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2781,7478,922,40809,81400,2,67,2,25.52,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2782,7478,922,40809,81400,2,13,1,147.04,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2783,7478,923,40809,81400,2,96,2,26.00,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2784,7478,923,40809,81400,2,67,2,5.46,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2785,7478,923,40809,81400,2,13,1,31.46,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2786,7478,924,40809,81400,2,96,2,8264.46,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2787,7478,924,40809,81400,2,67,2,1735.54,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2788,7478,924,40809,81400,2,13,1,10000.00,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2789,7478,925,40809,81400,2,96,2,795.44,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2790,7478,925,40809,81400,2,67,2,167.04,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2791,7478,925,40809,81400,2,13,1,962.48,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2792,7478,926,40809,81400,2,96,2,519.35,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2793,7478,926,40809,81400,2,67,2,109.06,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2794,7478,926,40809,81400,2,13,1,628.41,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2795,7478,927,40809,81400,2,96,2,7438.02,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2796,7478,927,40809,81400,2,67,2,1561.98,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2797,7478,927,40809,81400,2,13,1,9000.00,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2798,7478,928,40809,81400,2,96,2,132.23,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2799,7478,928,40809,81400,2,67,2,27.77,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2800,7478,928,40809,81400,2,13,1,160.00,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2801,7478,929,40809,81400,2,96,2,33.06,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2802,7478,929,40809,81400,2,67,2,6.94,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2803,7478,929,40809,81400,2,13,1,40.00,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2804,7478,930,40809,81400,2,96,2,468.00,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2805,7478,930,40809,81400,2,67,2,98.28,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2806,7478,930,40809,81400,2,13,1,566.28,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2807,7478,931,40809,81400,2,96,2,686.64,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2808,7478,931,40809,81400,2,67,2,144.19,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2809,7478,931,40809,81400,2,13,1,830.83,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2810,7478,932,40809,81400,2,96,2,1693.37,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2811,7478,932,40809,81400,2,67,2,355.61,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2812,7478,932,40809,81400,2,13,1,2048.98,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2813,7478,933,40809,81400,2,96,2,605.90,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2814,7478,933,40809,81400,2,67,2,127.24,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL);
INSERT INTO `balance_libro_details` VALUES (2815,7478,933,40809,81400,2,13,1,733.14,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2816,7478,934,40809,81400,2,96,2,10644.63,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2817,7478,934,40809,81400,2,67,2,2235.37,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2818,7478,934,40809,81400,2,13,1,12880.00,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2819,7478,935,40809,81400,2,96,2,3330.45,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2820,7478,935,40809,81400,2,67,2,699.40,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2821,7478,935,40809,81400,2,13,1,4029.85,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2822,7478,936,40809,81400,2,96,2,4215.60,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2823,7478,936,40809,81400,2,67,2,885.27,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2824,7478,936,40809,81400,2,13,1,5100.87,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2825,7478,937,40809,81400,2,96,2,8838.84,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2826,7478,937,40809,81400,2,67,2,1856.16,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2827,7478,937,40809,81400,2,13,1,10695.00,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2828,7478,938,40809,81400,2,96,2,3511.84,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2829,7478,938,40809,81400,2,67,2,737.49,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2830,7478,938,40809,81400,2,13,1,4249.33,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2831,7478,939,40809,81400,2,96,2,9421.49,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2832,7478,939,40809,81400,2,67,2,1978.51,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2833,7478,939,40809,81400,2,13,1,11400.00,NULL,'2022-08-12 20:39:40','2022-08-12 20:39:40',NULL),(2834,7478,940,40809,81400,2,96,2,10000.00,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2835,7478,940,40809,81400,2,67,2,2100.00,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2836,7478,940,40809,81400,2,13,1,12100.00,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2837,7478,941,40809,81400,2,96,2,66.12,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2838,7478,941,40809,81400,2,67,2,13.88,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2839,7478,941,40809,81400,2,13,1,80.00,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2840,7478,942,40809,81400,2,96,2,5867.77,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2841,7478,942,40809,81400,2,67,2,1232.23,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2842,7478,942,40809,81400,2,13,1,7100.00,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2843,7478,943,40809,81400,2,96,2,2727.27,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2844,7478,943,40809,81400,2,67,2,572.73,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2845,7478,943,40809,81400,2,13,1,3300.00,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2846,7478,944,40809,81400,2,96,2,3966.94,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2847,7478,944,40809,81400,2,67,2,833.06,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2848,7478,944,40809,81400,2,13,1,4800.00,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2849,7478,945,40809,81400,2,96,2,247.93,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2850,7478,945,40809,81400,2,67,2,52.07,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2851,7478,945,40809,81400,2,13,1,300.00,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2852,7478,946,40809,81400,2,96,2,191.25,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2853,7478,946,40809,81400,2,67,2,40.16,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2854,7478,946,40809,81400,2,13,1,231.41,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2855,7478,947,40809,81400,2,96,2,6157.02,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL);
INSERT INTO `balance_libro_details` VALUES (2856,7478,947,40809,81400,2,67,2,1292.98,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2857,7478,947,40809,81400,2,13,1,7450.00,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2858,7478,948,40809,81400,2,96,2,79.59,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2859,7478,948,40809,81400,2,67,2,16.71,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2860,7478,948,40809,81400,2,13,1,96.30,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2861,7478,949,40809,81400,2,96,2,597.21,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2862,7478,949,40809,81400,2,67,2,125.41,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2863,7478,949,40809,81400,2,13,1,722.62,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2864,7478,950,40809,81400,2,96,2,416.04,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2865,7478,950,40809,81400,2,67,2,87.37,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2866,7478,950,40809,81400,2,13,1,503.41,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2867,7478,951,40809,81400,2,96,2,5371.90,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2868,7478,951,40809,81400,2,67,2,1128.10,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2869,7478,951,40809,81400,2,13,1,6500.00,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2870,7478,952,40809,81400,2,96,2,334.71,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2871,7478,952,40809,81400,2,67,2,70.29,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2872,7478,952,40809,81400,2,13,1,405.00,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2873,7478,953,40809,81400,2,96,2,8264.46,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2874,7478,953,40809,81400,2,67,2,1735.54,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2875,7478,953,40809,81400,2,13,1,10000.00,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2876,7478,954,40809,81400,2,96,2,626.56,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2877,7478,954,40809,81400,2,67,2,131.58,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2878,7478,954,40809,81400,2,13,1,758.14,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2879,7478,955,40809,81400,2,96,2,2128.00,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2880,7478,955,40809,81400,2,67,2,446.88,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2881,7478,955,40809,81400,2,13,1,2574.88,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2882,7478,956,40809,81400,2,96,2,237.36,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2883,7478,956,40809,81400,2,67,2,49.84,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2884,7478,956,40809,81400,2,13,1,287.20,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2885,7478,957,40809,81400,2,96,2,583.63,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2886,7478,957,40809,81400,2,67,2,122.56,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2887,7478,957,40809,81400,2,13,1,706.19,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2888,7478,958,40809,81400,2,96,2,10834.71,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2889,7478,958,40809,81400,2,67,2,2275.29,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2890,7478,958,40809,81400,2,13,1,13110.00,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2891,7478,959,40809,81400,2,96,2,4647.07,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2892,7478,959,40809,81400,2,67,2,975.88,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2893,7478,959,40809,81400,2,13,1,5622.94,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2894,7478,959,40809,81400,2,136,1,0.01,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2895,7478,960,40809,81400,2,96,2,495.87,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2896,7478,960,40809,81400,2,67,2,104.13,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL);
INSERT INTO `balance_libro_details` VALUES (2897,7478,960,40809,81400,2,13,1,600.00,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2898,7478,961,40809,81400,2,96,2,4257.89,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2899,7478,961,40809,81400,2,67,2,894.16,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2900,7478,961,40809,81400,2,13,1,5152.05,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2901,7478,962,40809,81400,2,96,2,10834.71,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2902,7478,962,40809,81400,2,67,2,2275.29,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2903,7478,962,40809,81400,2,13,1,13110.00,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2904,7478,963,40809,81400,2,96,2,223.14,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2905,7478,963,40809,81400,2,67,2,46.86,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2906,7478,963,40809,81400,2,13,1,270.00,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2907,7478,964,40809,81400,2,96,2,645.73,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2908,7478,964,40809,81400,2,67,2,135.60,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2909,7478,964,40809,81400,2,13,1,781.33,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2910,7478,965,40809,81400,2,96,2,11528.93,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2911,7478,965,40809,81400,2,67,2,2421.07,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2912,7478,965,40809,81400,2,13,1,13950.00,NULL,'2022-08-12 20:39:41','2022-08-12 20:39:41',NULL),(2913,7478,966,40809,81400,2,96,2,647.60,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2914,7478,966,40809,81400,2,67,2,136.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2915,7478,966,40809,81400,2,13,1,783.60,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2916,7478,967,40809,81400,2,96,2,12809.92,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2917,7478,967,40809,81400,2,67,2,2690.08,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2918,7478,967,40809,81400,2,13,1,15500.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2919,7478,968,40809,81400,2,96,2,892.56,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2920,7478,968,40809,81400,2,67,2,187.44,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2921,7478,968,40809,81400,2,13,1,1080.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2922,7478,969,40809,81400,2,96,2,8264.46,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2923,7478,969,40809,81400,2,67,2,1735.54,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2924,7478,969,40809,81400,2,13,1,10000.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2925,7478,970,40809,81400,2,96,2,8181.82,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2926,7478,970,40809,81400,2,67,2,1718.18,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2927,7478,970,40809,81400,2,13,1,9900.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2928,7478,971,40809,81400,2,96,2,3347.11,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2929,7478,971,40809,81400,2,67,2,702.89,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2930,7478,971,40809,81400,2,13,1,4050.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2931,7478,972,40809,81400,2,96,2,7355.37,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2932,7478,972,40809,81400,2,67,2,1544.63,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2933,7478,972,40809,81400,2,13,1,8900.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2934,7478,973,40809,81400,2,96,2,7851.24,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2935,7478,973,40809,81400,2,67,2,1648.76,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2936,7478,973,40809,81400,2,13,1,9500.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2937,7478,974,40809,81400,2,96,2,4545.45,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL);
INSERT INTO `balance_libro_details` VALUES (2938,7478,974,40809,81400,2,67,2,954.55,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2939,7478,974,40809,81400,2,13,1,5500.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2940,7478,975,40809,81400,2,96,2,13495.87,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2941,7478,975,40809,81400,2,67,2,2834.13,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2942,7478,975,40809,81400,2,13,1,16330.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2943,7478,976,40809,81400,2,96,2,416.04,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2944,7478,976,40809,81400,2,67,2,87.37,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2945,7478,976,40809,81400,2,13,1,503.41,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2946,7478,977,40809,81400,2,96,2,206.61,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2947,7478,977,40809,81400,2,67,2,43.39,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2948,7478,977,40809,81400,2,13,1,250.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2949,7478,978,40809,81400,2,96,2,448.26,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2950,7478,978,40809,81400,2,67,2,94.14,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2951,7478,978,40809,81400,2,13,1,542.40,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2952,7478,979,40809,81400,2,96,2,9256.20,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2953,7478,979,40809,81400,2,67,2,1943.80,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2954,7478,979,40809,81400,2,13,1,11200.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2955,7478,980,40809,81400,2,96,2,889.74,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2956,7478,980,40809,81400,2,67,2,186.85,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2957,7478,980,40809,81400,2,13,1,1076.59,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2958,7478,981,40809,81400,2,96,2,5157.02,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2959,7478,981,40809,81400,2,67,2,1082.98,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2960,7478,981,40809,81400,2,13,1,6240.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2961,7478,982,40809,81400,2,96,2,247.93,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2962,7478,982,40809,81400,2,67,2,52.07,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2963,7478,982,40809,81400,2,13,1,300.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2964,7478,983,40809,81400,2,96,2,8264.46,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2965,7478,983,40809,81400,2,67,2,1735.54,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2966,7478,983,40809,81400,2,13,1,10000.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2967,7478,984,40809,81400,2,96,2,4958.68,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2968,7478,984,40809,81400,2,67,2,1041.32,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2969,7478,984,40809,81400,2,13,1,6000.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2970,7478,985,40809,81400,2,96,2,11239.67,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2971,7478,985,40809,81400,2,67,2,2360.33,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2972,7478,985,40809,81400,2,13,1,13600.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2973,7478,986,40809,81400,2,96,2,499.09,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2974,7478,986,40809,81400,2,67,2,104.81,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2975,7478,986,40809,81400,2,13,1,603.90,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2976,7478,987,40809,81400,2,96,2,8223.14,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2977,7478,987,40809,81400,2,67,2,1726.86,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2978,7478,987,40809,81400,2,13,1,9950.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL);
INSERT INTO `balance_libro_details` VALUES (2979,7478,988,40809,81400,2,96,2,82.50,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2980,7478,988,40809,81400,2,67,2,17.32,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2981,7478,988,40809,81400,2,13,1,99.82,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2982,7478,989,40809,81400,2,96,2,8458.68,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2983,7478,989,40809,81400,2,67,2,1776.32,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2984,7478,989,40809,81400,2,13,1,10235.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2985,7478,990,40809,81400,2,96,2,269.10,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2986,7478,990,40809,81400,2,67,2,56.51,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2987,7478,990,40809,81400,2,13,1,325.61,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2988,7478,991,40809,81400,2,96,2,8677.69,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2989,7478,991,40809,81400,2,67,2,1822.31,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2990,7478,991,40809,81400,2,13,1,10500.00,NULL,'2022-08-12 20:39:42','2022-08-12 20:39:42',NULL),(2991,7478,992,40809,81400,2,96,2,132.25,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(2992,7478,992,40809,81400,2,67,2,27.77,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(2993,7478,992,40809,81400,2,13,1,160.02,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(2994,7478,993,40809,81400,2,96,2,11487.60,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(2995,7478,993,40809,81400,2,67,2,2412.40,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(2996,7478,993,40809,81400,2,13,1,13900.00,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(2997,7478,994,40809,81400,2,96,2,243.04,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(2998,7478,994,40809,81400,2,67,2,51.04,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(2999,7478,994,40809,81400,2,13,1,294.08,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3000,7478,995,40809,81400,2,96,2,8268.60,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3001,7478,995,40809,81400,2,67,2,1736.40,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3002,7478,995,40809,81400,2,13,1,10005.00,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3003,7478,996,40809,81400,2,96,2,82.50,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3004,7478,996,40809,81400,2,67,2,17.32,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3005,7478,996,40809,81400,2,13,1,99.82,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3006,7478,997,40809,81400,2,96,2,132.25,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3007,7478,997,40809,81400,2,67,2,27.77,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3008,7478,997,40809,81400,2,13,1,160.02,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3009,7478,998,40809,81400,2,96,2,3601.45,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3010,7478,998,40809,81400,2,67,2,756.31,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3011,7478,998,40809,81400,2,13,1,4357.76,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3012,7478,999,40809,81400,2,96,2,0.83,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3013,7478,999,40809,81400,2,67,2,0.17,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3014,7478,999,40809,81400,2,13,1,1.00,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3015,7478,1000,40809,81400,2,96,2,168.00,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3016,7478,1000,40809,81400,2,67,2,35.28,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3017,7478,1000,40809,81400,2,13,1,203.28,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3018,7478,1001,40809,81400,2,96,2,9296.30,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3019,7478,1001,40809,81400,2,67,2,1952.22,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL);
INSERT INTO `balance_libro_details` VALUES (3020,7478,1001,40809,81400,2,13,1,11248.51,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3021,7478,1001,40809,81400,2,136,1,0.01,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3022,7478,1002,40809,81400,2,96,2,82.50,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3023,7478,1002,40809,81400,2,67,2,17.32,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3024,7478,1002,40809,81400,2,13,1,99.82,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3025,7478,1003,40809,81400,2,96,2,831.56,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3026,7478,1003,40809,81400,2,67,2,174.63,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3027,7478,1003,40809,81400,2,13,1,1006.19,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3028,7478,1004,40809,81400,2,96,2,13140.50,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3029,7478,1004,40809,81400,2,67,2,2759.50,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3030,7478,1004,40809,81400,2,13,1,15900.00,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3031,7478,1005,40809,81400,2,96,2,13140.50,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3032,7478,1005,40809,81400,2,67,2,2759.50,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3033,7478,1005,40809,81400,2,13,1,15900.00,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3034,7478,1006,40809,81400,2,96,2,1165.31,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3035,7478,1006,40809,81400,2,67,2,244.72,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3036,7478,1006,40809,81400,2,13,1,1410.02,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3037,7478,1006,40809,81400,2,136,1,0.01,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3038,7478,1007,40809,81400,2,96,2,446.28,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3039,7478,1007,40809,81400,2,67,2,93.72,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3040,7478,1007,40809,81400,2,13,1,540.00,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3041,7478,1008,40809,81400,2,96,2,401.60,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3042,7478,1008,40809,81400,2,67,2,84.34,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3043,7478,1008,40809,81400,2,13,1,485.94,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3044,7478,1009,40809,81400,2,96,2,4545.45,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3045,7478,1009,40809,81400,2,67,2,954.55,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3046,7478,1009,40809,81400,2,13,1,5500.00,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3047,7478,1010,40809,81400,2,96,2,275.40,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3048,7478,1010,40809,81400,2,67,2,57.83,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3049,7478,1010,40809,81400,2,13,1,333.23,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3050,7478,1011,40809,81400,2,96,2,9599.17,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3051,7478,1011,40809,81400,2,67,2,2015.83,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3052,7478,1011,40809,81400,2,13,1,11615.00,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3053,7478,1012,40809,81400,2,96,2,5041.32,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3054,7478,1012,40809,81400,2,67,2,1058.68,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3055,7478,1012,40809,81400,2,13,1,6100.00,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3056,7478,1013,40809,81400,2,96,2,231.40,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3057,7478,1013,40809,81400,2,67,2,48.60,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3058,7478,1013,40809,81400,2,13,1,280.00,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3059,7478,1014,40809,81400,2,96,2,671.24,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3060,7478,1014,40809,81400,2,67,2,140.96,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL);
INSERT INTO `balance_libro_details` VALUES (3061,7478,1014,40809,81400,2,13,1,812.20,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3062,7478,1015,40809,81400,2,96,2,8.26,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3063,7478,1015,40809,81400,2,67,2,1.74,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3064,7478,1015,40809,81400,2,13,1,10.00,NULL,'2022-08-12 20:39:43','2022-08-12 20:39:43',NULL),(3065,7478,1016,40809,81400,2,218,2,0.00,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3066,7478,1016,40809,81400,2,13,1,0.00,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3067,7478,1017,40809,81400,2,96,2,8.26,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3068,7478,1017,40809,81400,2,67,2,1.74,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3069,7478,1017,40809,81400,2,13,1,10.00,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3070,7478,1018,40809,81400,2,96,2,492.00,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3071,7478,1018,40809,81400,2,67,2,103.32,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3072,7478,1018,40809,81400,2,13,1,595.32,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3073,7478,1019,40809,81400,2,96,2,157.04,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3074,7478,1019,40809,81400,2,67,2,32.98,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3075,7478,1019,40809,81400,2,13,1,190.02,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3076,7478,1020,40809,81400,2,96,2,165.29,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3077,7478,1020,40809,81400,2,67,2,34.71,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3078,7478,1020,40809,81400,2,13,1,200.00,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3079,7478,1021,40809,81400,2,96,2,416.04,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3080,7478,1021,40809,81400,2,67,2,87.37,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3081,7478,1021,40809,81400,2,13,1,503.41,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3082,7478,1022,40809,81400,2,96,2,426.93,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3083,7478,1022,40809,81400,2,67,2,89.65,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3084,7478,1022,40809,81400,2,13,1,516.58,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3085,7478,1023,40809,81400,2,96,2,11157.02,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3086,7478,1023,40809,81400,2,67,2,2342.98,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3087,7478,1023,40809,81400,2,13,1,13500.00,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3088,7478,1024,40809,81400,2,96,2,2726.50,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3089,7478,1024,40809,81400,2,67,2,572.56,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3090,7478,1024,40809,81400,2,13,1,3299.06,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3091,7478,1025,40809,81400,2,96,2,3132.55,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3092,7478,1025,40809,81400,2,67,2,657.84,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3093,7478,1025,40809,81400,2,13,1,3790.39,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3094,7478,1026,40809,81400,2,96,2,716.55,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3095,7478,1026,40809,81400,2,67,2,150.48,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3096,7478,1026,40809,81400,2,13,1,867.02,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3097,7478,1026,40809,81400,2,136,1,0.01,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3098,7478,1027,40809,81400,2,96,2,8760.33,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3099,7478,1027,40809,81400,2,67,2,1839.67,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3100,7478,1027,40809,81400,2,13,1,10600.00,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3101,7478,1028,40809,81400,2,96,2,9314.05,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL);
INSERT INTO `balance_libro_details` VALUES (3102,7478,1028,40809,81400,2,67,2,1955.95,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3103,7478,1028,40809,81400,2,13,1,11270.00,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3104,7478,1029,40809,81400,2,96,2,743.80,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3105,7478,1029,40809,81400,2,67,2,156.20,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3106,7478,1029,40809,81400,2,13,1,900.00,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3107,7478,1030,40809,81400,2,96,2,10404.96,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3108,7478,1030,40809,81400,2,67,2,2185.04,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3109,7478,1030,40809,81400,2,13,1,12590.00,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3110,7478,1031,40809,81400,2,96,2,2024.40,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3111,7478,1031,40809,81400,2,67,2,425.12,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3112,7478,1031,40809,81400,2,13,1,2449.52,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3113,7478,1032,40809,81400,2,96,2,26.00,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3114,7478,1032,40809,81400,2,67,2,5.46,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3115,7478,1032,40809,81400,2,13,1,31.46,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3116,7478,1033,40809,81400,2,96,2,10330.58,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3117,7478,1033,40809,81400,2,67,2,2169.42,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3118,7478,1033,40809,81400,2,13,1,12500.00,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3119,7478,1034,40809,81400,2,96,2,6082.64,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3120,7478,1034,40809,81400,2,67,2,1277.36,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3121,7478,1034,40809,81400,2,13,1,7360.00,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3122,7478,1035,40809,81400,2,96,2,6652.89,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3123,7478,1035,40809,81400,2,67,2,1397.11,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3124,7478,1035,40809,81400,2,13,1,8050.00,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3125,7478,1036,40809,81400,2,96,2,6611.57,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3126,7478,1036,40809,81400,2,67,2,1388.43,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3127,7478,1036,40809,81400,2,13,1,8000.00,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3128,7478,1037,40809,81400,2,96,2,2992.50,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3129,7478,1037,40809,81400,2,67,2,628.42,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3130,7478,1037,40809,81400,2,13,1,3620.92,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3131,7478,1038,40809,81400,2,96,2,99.17,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3132,7478,1038,40809,81400,2,67,2,20.83,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3133,7478,1038,40809,81400,2,13,1,120.00,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3134,7478,1039,40809,81400,2,96,2,272.96,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3135,7478,1039,40809,81400,2,67,2,57.32,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3136,7478,1039,40809,81400,2,13,1,330.28,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3137,7478,1040,40809,81400,2,96,2,1188.53,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3138,7478,1040,40809,81400,2,67,2,249.59,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3139,7478,1040,40809,81400,2,13,1,1438.12,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3140,7478,1041,40809,81400,2,96,2,1693.61,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3141,7478,1041,40809,81400,2,67,2,355.66,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3142,7478,1041,40809,81400,2,13,1,2049.27,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL);
INSERT INTO `balance_libro_details` VALUES (3143,7478,1042,40809,81400,2,96,2,5206.61,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3144,7478,1042,40809,81400,2,67,2,1093.39,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3145,7478,1042,40809,81400,2,13,1,6300.00,NULL,'2022-08-12 20:39:44','2022-08-12 20:39:44',NULL),(3146,7478,1043,40809,81400,2,96,2,416.04,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3147,7478,1043,40809,81400,2,67,2,87.37,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3148,7478,1043,40809,81400,2,13,1,503.41,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3149,7478,1044,40809,81400,2,96,2,5371.90,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3150,7478,1044,40809,81400,2,67,2,1128.10,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3151,7478,1044,40809,81400,2,13,1,6500.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3152,7478,1045,40809,81400,2,96,2,3482.93,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3153,7478,1045,40809,81400,2,67,2,731.41,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3154,7478,1045,40809,81400,2,13,1,4214.34,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3155,7478,1046,40809,81400,2,96,2,5227.27,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3156,7478,1046,40809,81400,2,67,2,1097.73,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3157,7478,1046,40809,81400,2,13,1,6325.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3158,7478,1047,40809,81400,2,96,2,231.40,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3159,7478,1047,40809,81400,2,67,2,48.60,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3160,7478,1047,40809,81400,2,13,1,280.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3161,7478,1048,40809,81400,2,96,2,123.97,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3162,7478,1048,40809,81400,2,67,2,26.03,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3163,7478,1048,40809,81400,2,13,1,150.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3164,7478,1049,40809,81400,2,96,2,10834.71,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3165,7478,1049,40809,81400,2,67,2,2275.29,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3166,7478,1049,40809,81400,2,13,1,13110.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3167,7478,1050,40809,81400,2,96,2,7685.95,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3168,7478,1050,40809,81400,2,67,2,1614.05,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3169,7478,1050,40809,81400,2,13,1,9300.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3170,7478,1051,40809,81400,2,96,2,909.09,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3171,7478,1051,40809,81400,2,67,2,190.91,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3172,7478,1051,40809,81400,2,13,1,1100.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3173,7478,1052,40809,81400,2,96,2,5227.27,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3174,7478,1052,40809,81400,2,67,2,1097.73,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3175,7478,1052,40809,81400,2,13,1,6325.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3176,7478,1053,40809,81400,2,96,2,7024.79,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3177,7478,1053,40809,81400,2,67,2,1475.21,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3178,7478,1053,40809,81400,2,13,1,8500.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3179,7478,1054,40809,81400,2,96,2,544.79,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3180,7478,1054,40809,81400,2,67,2,114.41,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3181,7478,1054,40809,81400,2,13,1,659.20,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3182,7478,1055,40809,81400,2,96,2,537.19,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3183,7478,1055,40809,81400,2,67,2,112.81,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL);
INSERT INTO `balance_libro_details` VALUES (3184,7478,1055,40809,81400,2,13,1,650.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3185,7478,1056,40809,81400,2,96,2,231.40,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3186,7478,1056,40809,81400,2,67,2,48.60,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3187,7478,1056,40809,81400,2,13,1,280.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3188,7478,1057,40809,81400,2,96,2,596.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3189,7478,1057,40809,81400,2,67,2,125.15,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3190,7478,1057,40809,81400,2,218,2,0.01,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3191,7478,1057,40809,81400,2,13,1,721.16,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3192,7478,1058,40809,81400,2,96,2,7851.24,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3193,7478,1058,40809,81400,2,67,2,1648.76,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3194,7478,1058,40809,81400,2,13,1,9500.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3195,7478,1059,40809,81400,2,96,2,123.97,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3196,7478,1059,40809,81400,2,67,2,26.03,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3197,7478,1059,40809,81400,2,13,1,150.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3198,7478,1060,40809,81400,2,96,2,4049.59,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3199,7478,1060,40809,81400,2,67,2,850.41,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3200,7478,1060,40809,81400,2,13,1,4900.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3201,7478,1061,40809,81400,2,96,2,7438.02,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3202,7478,1061,40809,81400,2,67,2,1561.98,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3203,7478,1061,40809,81400,2,13,1,9000.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3204,7478,1062,40809,81400,2,96,2,5950.41,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3205,7478,1062,40809,81400,2,67,2,1249.59,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3206,7478,1062,40809,81400,2,13,1,7200.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3207,7478,1063,40809,81400,2,96,2,3795.41,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3208,7478,1063,40809,81400,2,67,2,797.04,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3209,7478,1063,40809,81400,2,13,1,4592.45,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3210,7478,1064,40809,81400,2,96,2,5702.48,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3211,7478,1064,40809,81400,2,67,2,1197.52,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3212,7478,1064,40809,81400,2,13,1,6900.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3213,7478,1065,40809,81400,2,96,2,8677.69,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3214,7478,1065,40809,81400,2,67,2,1822.31,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3215,7478,1065,40809,81400,2,13,1,10500.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3216,7478,1066,40809,81400,2,96,2,495.90,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3217,7478,1066,40809,81400,2,67,2,104.14,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3218,7478,1066,40809,81400,2,13,1,600.04,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3219,7478,1067,40809,81400,2,96,2,19586.78,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3220,7478,1067,40809,81400,2,67,2,4113.22,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3221,7478,1067,40809,81400,2,13,1,23700.00,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3222,7478,1068,40809,81400,2,96,2,718.72,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3223,7478,1068,40809,81400,2,67,2,150.93,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3224,7478,1068,40809,81400,2,13,1,869.65,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL);
INSERT INTO `balance_libro_details` VALUES (3225,7478,1069,40809,81400,2,96,2,6958.65,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3226,7478,1069,40809,81400,2,67,2,1461.32,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3227,7478,1069,40809,81400,2,13,1,8419.97,NULL,'2022-08-12 20:39:45','2022-08-12 20:39:45',NULL),(3228,7478,1070,40809,81400,2,96,2,6487.60,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3229,7478,1070,40809,81400,2,67,2,1362.40,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3230,7478,1070,40809,81400,2,13,1,7850.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3231,7478,1071,40809,81400,2,96,2,242.20,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3232,7478,1071,40809,81400,2,67,2,50.86,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3233,7478,1071,40809,81400,2,13,1,293.06,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3234,7478,1072,40809,81400,2,96,2,350.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3235,7478,1072,40809,81400,2,67,2,73.50,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3236,7478,1072,40809,81400,2,13,1,423.50,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3237,7478,1073,40809,81400,2,96,2,14462.81,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3238,7478,1073,40809,81400,2,67,2,3037.19,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3239,7478,1073,40809,81400,2,13,1,17500.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3240,7478,1074,40809,81400,2,96,2,5785.12,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3241,7478,1074,40809,81400,2,67,2,1214.88,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3242,7478,1074,40809,81400,2,13,1,7000.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3243,7478,1075,40809,81400,2,96,2,1190.09,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3244,7478,1075,40809,81400,2,67,2,249.92,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3245,7478,1075,40809,81400,2,13,1,1440.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3246,7478,1075,40809,81400,2,136,1,0.01,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3247,7478,1076,40809,81400,2,96,2,4710.74,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3248,7478,1076,40809,81400,2,67,2,989.26,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3249,7478,1076,40809,81400,2,13,1,5700.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3250,7478,1077,40809,81400,2,96,2,5123.97,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3251,7478,1077,40809,81400,2,67,2,1076.03,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3252,7478,1077,40809,81400,2,13,1,6200.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3253,7478,1078,40809,81400,2,96,2,4722.25,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3254,7478,1078,40809,81400,2,67,2,991.67,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3255,7478,1078,40809,81400,2,13,1,5713.92,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3256,7478,1079,40809,81400,2,96,2,347.11,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3257,7478,1079,40809,81400,2,67,2,72.89,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3258,7478,1079,40809,81400,2,13,1,420.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3259,7478,1080,40809,81400,2,96,2,8780.99,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3260,7478,1080,40809,81400,2,67,2,1844.01,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3261,7478,1080,40809,81400,2,13,1,10625.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3262,7478,1081,40809,81400,2,96,2,463.42,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3263,7478,1081,40809,81400,2,67,2,97.32,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3264,7478,1081,40809,81400,2,13,1,560.74,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3265,7478,1082,40809,81400,2,96,2,550.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL);
INSERT INTO `balance_libro_details` VALUES (3266,7478,1082,40809,81400,2,67,2,115.50,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3267,7478,1082,40809,81400,2,13,1,665.50,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3268,7478,1083,40809,81400,2,96,2,2066.12,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3269,7478,1083,40809,81400,2,67,2,433.88,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3270,7478,1083,40809,81400,2,13,1,2500.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3271,7478,1084,40809,81400,2,96,2,325.62,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3272,7478,1084,40809,81400,2,67,2,68.38,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3273,7478,1084,40809,81400,2,13,1,394.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3274,7478,1085,40809,81400,2,96,2,12396.69,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3275,7478,1085,40809,81400,2,67,2,2603.31,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3276,7478,1085,40809,81400,2,13,1,15000.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3277,7478,1086,40809,81400,2,96,2,9219.01,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3278,7478,1086,40809,81400,2,67,2,1935.99,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3279,7478,1086,40809,81400,2,13,1,11155.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3280,7478,1087,40809,81400,2,96,2,5702.48,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3281,7478,1087,40809,81400,2,67,2,1197.52,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3282,7478,1087,40809,81400,2,13,1,6900.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3283,7478,1088,40809,81400,2,96,2,1090.91,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3284,7478,1088,40809,81400,2,67,2,229.09,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3285,7478,1088,40809,81400,2,13,1,1320.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3286,7478,1089,40809,81400,2,96,2,284.30,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3287,7478,1089,40809,81400,2,67,2,59.70,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3288,7478,1089,40809,81400,2,13,1,344.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3289,7478,1090,40809,81400,2,96,2,4118.86,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3290,7478,1090,40809,81400,2,67,2,864.96,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3291,7478,1090,40809,81400,2,13,1,4983.82,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3292,7478,1091,40809,81400,2,96,2,3258.50,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3293,7478,1091,40809,81400,2,67,2,684.28,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3294,7478,1091,40809,81400,2,13,1,3942.78,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3295,7478,1092,40809,81400,2,96,2,988.28,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3296,7478,1092,40809,81400,2,67,2,207.54,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3297,7478,1092,40809,81400,2,13,1,1195.82,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3298,7478,1093,40809,81400,2,96,2,206.61,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3299,7478,1093,40809,81400,2,67,2,43.39,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3300,7478,1093,40809,81400,2,13,1,250.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3301,7478,1094,40809,81400,2,96,2,82.50,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3302,7478,1094,40809,81400,2,67,2,17.32,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3303,7478,1094,40809,81400,2,13,1,99.82,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3304,7478,1095,40809,81400,2,96,2,413.22,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3305,7478,1095,40809,81400,2,67,2,86.78,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL),(3306,7478,1095,40809,81400,2,13,1,500.00,NULL,'2022-08-12 20:39:46','2022-08-12 20:39:46',NULL);
INSERT INTO `balance_libro_details` VALUES (3307,7478,1096,40809,81400,2,96,2,8099.17,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3308,7478,1096,40809,81400,2,67,2,1700.83,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3309,7478,1096,40809,81400,2,13,1,9800.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3310,7478,1097,40809,81400,2,96,2,275.40,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3311,7478,1097,40809,81400,2,67,2,57.83,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3312,7478,1097,40809,81400,2,13,1,333.23,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3313,7478,1098,40809,81400,2,96,2,192.75,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3314,7478,1098,40809,81400,2,67,2,40.48,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3315,7478,1098,40809,81400,2,13,1,233.23,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3316,7478,1099,40809,81400,2,218,2,0.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3317,7478,1099,40809,81400,2,13,1,0.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3318,7478,1100,40809,81400,2,96,2,10644.63,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3319,7478,1100,40809,81400,2,67,2,2235.37,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3320,7478,1100,40809,81400,2,13,1,12880.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3321,7478,1101,40809,81400,2,96,2,26.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3322,7478,1101,40809,81400,2,67,2,5.46,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3323,7478,1101,40809,81400,2,13,1,31.46,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3324,7478,1102,40809,81400,2,96,2,8264.46,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3325,7478,1102,40809,81400,2,67,2,1735.54,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3326,7478,1102,40809,81400,2,13,1,10000.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3327,7478,1103,40809,81400,2,96,2,9504.13,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3328,7478,1103,40809,81400,2,67,2,1995.87,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3329,7478,1103,40809,81400,2,13,1,11500.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3330,7478,1104,40809,81400,2,96,2,630.75,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3331,7478,1104,40809,81400,2,67,2,132.46,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3332,7478,1104,40809,81400,2,13,1,763.21,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3333,7478,1105,40809,81400,2,96,2,2128.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3334,7478,1105,40809,81400,2,67,2,446.88,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3335,7478,1105,40809,81400,2,13,1,2574.88,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3336,7478,1106,40809,81400,2,96,2,232.40,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3337,7478,1106,40809,81400,2,67,2,48.80,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3338,7478,1106,40809,81400,2,13,1,281.20,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3339,7478,1107,40809,81400,2,96,2,9751.24,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3340,7478,1107,40809,81400,2,67,2,2047.76,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3341,7478,1107,40809,81400,2,13,1,11799.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3342,7478,1108,40809,81400,2,96,2,8429.75,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3343,7478,1108,40809,81400,2,67,2,1770.25,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3344,7478,1108,40809,81400,2,13,1,10200.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3345,7478,1109,40809,81400,2,96,2,7272.73,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3346,7478,1109,40809,81400,2,67,2,1527.27,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3347,7478,1109,40809,81400,2,13,1,8800.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL);
INSERT INTO `balance_libro_details` VALUES (3348,7478,1110,40809,81400,2,96,2,7851.24,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3349,7478,1110,40809,81400,2,67,2,1648.76,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3350,7478,1110,40809,81400,2,13,1,9500.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3351,7478,1111,40809,81400,2,96,2,7933.88,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3352,7478,1111,40809,81400,2,67,2,1666.12,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3353,7478,1111,40809,81400,2,13,1,9600.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3354,7478,1112,40809,81400,2,96,2,294.68,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3355,7478,1112,40809,81400,2,67,2,61.88,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3356,7478,1112,40809,81400,2,13,1,356.56,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3357,7478,1113,40809,81400,2,96,2,231.40,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3358,7478,1113,40809,81400,2,67,2,48.60,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3359,7478,1113,40809,81400,2,13,1,280.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3360,7478,1114,40809,81400,2,96,2,694.21,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3361,7478,1114,40809,81400,2,67,2,145.79,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3362,7478,1114,40809,81400,2,13,1,840.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3363,7478,1115,40809,81400,2,96,2,99.87,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3364,7478,1115,40809,81400,2,67,2,20.97,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3365,7478,1115,40809,81400,2,13,1,120.84,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3366,7478,1116,40809,81400,2,96,2,5371.90,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3367,7478,1116,40809,81400,2,67,2,1128.10,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3368,7478,1116,40809,81400,2,13,1,6500.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3369,7478,1117,40809,81400,2,96,2,841.26,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3370,7478,1117,40809,81400,2,67,2,176.66,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3371,7478,1117,40809,81400,2,13,1,1017.92,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3372,7478,1118,40809,81400,2,96,2,1193.19,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3373,7478,1118,40809,81400,2,67,2,250.57,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3374,7478,1118,40809,81400,2,13,1,1443.76,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3375,7478,1119,40809,81400,2,96,2,4876.03,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3376,7478,1119,40809,81400,2,67,2,1023.97,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3377,7478,1119,40809,81400,2,13,1,5900.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3378,7478,1120,40809,81400,2,96,2,78.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3379,7478,1120,40809,81400,2,67,2,16.38,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3380,7478,1120,40809,81400,2,13,1,94.38,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3381,7478,1121,40809,81400,2,96,2,5206.61,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3382,7478,1121,40809,81400,2,67,2,1093.39,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3383,7478,1121,40809,81400,2,13,1,6300.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3384,7478,1122,40809,81400,2,96,2,24.79,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3385,7478,1122,40809,81400,2,67,2,5.21,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3386,7478,1122,40809,81400,2,13,1,30.00,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3387,7478,1123,40809,81400,2,96,2,2064.82,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3388,7478,1123,40809,81400,2,67,2,433.61,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL);
INSERT INTO `balance_libro_details` VALUES (3389,7478,1123,40809,81400,2,13,1,2498.43,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3390,7478,1124,40809,81400,2,96,2,5607.44,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3391,7478,1124,40809,81400,2,67,2,1177.56,NULL,'2022-08-12 20:39:47','2022-08-12 20:39:47',NULL),(3392,7478,1124,40809,81400,2,13,1,6785.00,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3393,7478,1125,40809,81400,2,96,2,9028.93,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3394,7478,1125,40809,81400,2,67,2,1896.07,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3395,7478,1125,40809,81400,2,13,1,10925.00,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3396,7478,1126,40809,81400,2,96,2,5371.90,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3397,7478,1126,40809,81400,2,67,2,1128.10,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3398,7478,1126,40809,81400,2,13,1,6500.00,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3399,7478,1127,40809,81400,2,96,2,231.40,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3400,7478,1127,40809,81400,2,67,2,48.60,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3401,7478,1127,40809,81400,2,13,1,280.00,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3402,7478,1128,40809,81400,2,96,2,286.47,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3403,7478,1128,40809,81400,2,67,2,60.16,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3404,7478,1128,40809,81400,2,13,1,346.63,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3405,7478,1129,40809,81400,2,96,2,752.12,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3406,7478,1129,40809,81400,2,67,2,157.95,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3407,7478,1129,40809,81400,2,13,1,910.07,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3408,7478,1130,40809,81400,2,96,2,4455.66,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3409,7478,1130,40809,81400,2,67,2,935.69,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3410,7478,1130,40809,81400,2,13,1,5391.35,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3411,7478,1131,40809,81400,2,96,2,4654.40,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3412,7478,1131,40809,81400,2,67,2,977.43,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3413,7478,1131,40809,81400,2,13,1,5631.83,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3414,7478,1132,40809,81400,2,96,2,329.44,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3415,7478,1132,40809,81400,2,67,2,69.18,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3416,7478,1132,40809,81400,2,13,1,398.62,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3417,7478,1133,40809,81400,2,96,2,119.01,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3418,7478,1133,40809,81400,2,67,2,24.99,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3419,7478,1133,40809,81400,2,13,1,144.00,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3420,7478,1134,40809,81400,2,96,2,495.90,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3421,7478,1134,40809,81400,2,67,2,104.14,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3422,7478,1134,40809,81400,2,13,1,600.04,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3423,7478,1135,40809,81400,2,96,2,6403.07,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3424,7478,1135,40809,81400,2,67,2,1344.64,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3425,7478,1135,40809,81400,2,13,1,7747.71,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3426,7478,1136,40809,81400,2,96,2,694.21,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3427,7478,1136,40809,81400,2,67,2,145.79,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3428,7478,1136,40809,81400,2,13,1,840.00,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3429,7478,1137,40809,81400,2,96,2,33.06,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL);
INSERT INTO `balance_libro_details` VALUES (3430,7478,1137,40809,81400,2,67,2,6.94,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3431,7478,1137,40809,81400,2,13,1,40.00,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3432,7478,1138,40809,81400,2,96,2,8225.83,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3433,7478,1138,40809,81400,2,67,2,1727.42,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3434,7478,1138,40809,81400,2,13,1,9953.25,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3435,7478,1139,40809,81400,2,96,2,5607.44,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3436,7478,1139,40809,81400,2,67,2,1177.56,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3437,7478,1139,40809,81400,2,13,1,6785.00,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3438,7478,1140,40809,81400,2,96,2,14883.47,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3439,7478,1140,40809,81400,2,67,2,3125.53,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3440,7478,1140,40809,81400,2,13,1,18009.00,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3441,7478,1141,40809,81400,2,96,2,803.79,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3442,7478,1141,40809,81400,2,67,2,168.79,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3443,7478,1141,40809,81400,2,13,1,972.58,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3444,7478,1142,40809,81400,2,96,2,6033.06,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3445,7478,1142,40809,81400,2,67,2,1266.94,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3446,7478,1142,40809,81400,2,13,1,7300.00,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3447,7478,1143,40809,81400,2,96,2,10644.63,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3448,7478,1143,40809,81400,2,67,2,2235.37,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3449,7478,1143,40809,81400,2,13,1,12880.00,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3450,7478,1144,40809,81400,2,96,2,14826.45,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3451,7478,1144,40809,81400,2,67,2,3113.55,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3452,7478,1144,40809,81400,2,13,1,17940.00,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3453,7478,1145,40809,81400,2,96,2,636.78,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3454,7478,1145,40809,81400,2,67,2,133.72,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3455,7478,1145,40809,81400,2,13,1,770.50,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3456,7478,1146,40809,81400,2,96,2,3302.45,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3457,7478,1146,40809,81400,2,67,2,693.52,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3458,7478,1146,40809,81400,2,13,1,3995.97,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3459,7478,1147,40809,81400,2,96,2,182.11,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3460,7478,1147,40809,81400,2,67,2,38.24,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3461,7478,1147,40809,81400,2,13,1,220.35,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3462,7478,1148,40809,81400,2,96,2,275.00,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3463,7478,1148,40809,81400,2,67,2,57.75,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3464,7478,1148,40809,81400,2,13,1,332.75,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3465,7478,1149,40809,81400,2,96,2,578.51,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3466,7478,1149,40809,81400,2,67,2,121.49,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3467,7478,1149,40809,81400,2,13,1,700.00,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3468,7478,1150,40809,81400,2,96,2,416.04,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3469,7478,1150,40809,81400,2,67,2,87.37,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL),(3470,7478,1150,40809,81400,2,13,1,503.41,NULL,'2022-08-12 20:39:48','2022-08-12 20:39:48',NULL);
INSERT INTO `balance_libro_details` VALUES (3471,7478,1151,40809,81400,2,96,2,519.35,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3472,7478,1151,40809,81400,2,67,2,109.06,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3473,7478,1151,40809,81400,2,13,1,628.41,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3474,7478,1152,40809,81400,2,96,2,158.56,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3475,7478,1152,40809,81400,2,67,2,33.30,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3476,7478,1152,40809,81400,2,13,1,191.86,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3477,7478,1153,40809,81400,2,96,2,1487.60,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3478,7478,1153,40809,81400,2,67,2,312.40,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3479,7478,1153,40809,81400,2,13,1,1800.00,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3480,7478,1154,40809,81400,2,96,2,231.40,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3481,7478,1154,40809,81400,2,67,2,48.60,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3482,7478,1154,40809,81400,2,13,1,280.00,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3483,7478,1155,40809,81400,2,96,2,537.04,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3484,7478,1155,40809,81400,2,67,2,112.78,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3485,7478,1155,40809,81400,2,13,1,649.82,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3486,7478,1156,40809,81400,2,96,2,9338.84,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3487,7478,1156,40809,81400,2,67,2,1961.16,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3488,7478,1156,40809,81400,2,13,1,11300.00,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3489,7478,1157,40809,81400,2,96,2,841.26,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3490,7478,1157,40809,81400,2,67,2,176.66,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3491,7478,1157,40809,81400,2,13,1,1017.92,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3492,7478,1158,40809,81400,2,96,2,1575.21,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3493,7478,1158,40809,81400,2,67,2,330.80,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3494,7478,1158,40809,81400,2,13,1,1906.01,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3495,7478,1159,40809,81400,2,96,2,10739.67,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3496,7478,1159,40809,81400,2,67,2,2255.33,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3497,7478,1159,40809,81400,2,13,1,12995.00,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3498,7478,1160,40809,81400,2,96,2,3714.50,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3499,7478,1160,40809,81400,2,67,2,780.04,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3500,7478,1160,40809,81400,2,13,1,4494.54,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3501,7478,1161,40809,81400,2,96,2,7438.02,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3502,7478,1161,40809,81400,2,67,2,1561.98,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3503,7478,1161,40809,81400,2,13,1,9000.00,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3504,7478,1162,40809,81400,2,96,2,1261.50,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3505,7478,1162,40809,81400,2,67,2,264.92,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3506,7478,1162,40809,81400,2,13,1,1526.42,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3507,7478,1163,40809,81400,2,96,2,8264.46,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3508,7478,1163,40809,81400,2,67,2,1735.54,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3509,7478,1163,40809,81400,2,13,1,10000.00,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3510,7478,1164,40809,81400,2,96,2,8016.53,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3511,7478,1164,40809,81400,2,67,2,1683.47,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL);
INSERT INTO `balance_libro_details` VALUES (3512,7478,1164,40809,81400,2,13,1,9700.00,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3513,7478,1165,40809,81400,2,96,2,8099.17,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3514,7478,1165,40809,81400,2,67,2,1700.83,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3515,7478,1165,40809,81400,2,13,1,9800.00,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3516,7478,1166,40809,81400,2,96,2,4132.23,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3517,7478,1166,40809,81400,2,67,2,867.77,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3518,7478,1166,40809,81400,2,13,1,5000.00,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3519,7478,1167,40809,81400,2,96,2,158.56,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3520,7478,1167,40809,81400,2,67,2,33.30,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3521,7478,1167,40809,81400,2,13,1,191.86,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3522,7478,1168,40809,81400,2,96,2,578.51,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3523,7478,1168,40809,81400,2,67,2,121.49,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3524,7478,1168,40809,81400,2,13,1,700.00,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3525,7478,1169,40809,81400,2,96,2,6446.28,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3526,7478,1169,40809,81400,2,67,2,1353.72,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3527,7478,1169,40809,81400,2,13,1,7800.00,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3528,7478,1170,40809,81400,2,96,2,468.00,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3529,7478,1170,40809,81400,2,67,2,98.28,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3530,7478,1170,40809,81400,2,13,1,566.28,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3531,7478,1171,40809,81400,2,96,2,8553.72,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3532,7478,1171,40809,81400,2,67,2,1796.28,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3533,7478,1171,40809,81400,2,13,1,10350.00,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3534,7478,1172,40809,81400,2,96,2,163.82,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3535,7478,1172,40809,81400,2,67,2,34.40,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3536,7478,1172,40809,81400,2,13,1,198.22,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3537,7478,1173,40809,81400,2,96,2,13685.95,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3538,7478,1173,40809,81400,2,67,2,2874.05,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3539,7478,1173,40809,81400,2,13,1,16560.00,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3540,7478,1174,40809,81400,2,96,2,6611.57,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3541,7478,1174,40809,81400,2,67,2,1388.43,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3542,7478,1174,40809,81400,2,13,1,8000.00,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3543,7478,1175,40809,81400,2,96,2,66.56,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3544,7478,1175,40809,81400,2,67,2,13.98,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3545,7478,1175,40809,81400,2,13,1,80.54,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3546,7478,1176,40809,81400,2,96,2,2992.50,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3547,7478,1176,40809,81400,2,67,2,628.42,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3548,7478,1176,40809,81400,2,13,1,3620.92,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3549,7478,1177,40809,81400,2,96,2,9504.13,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3550,7478,1177,40809,81400,2,67,2,1995.87,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3551,7478,1177,40809,81400,2,13,1,11500.00,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3552,7478,1178,40809,81400,2,96,2,5797.52,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL);
INSERT INTO `balance_libro_details` VALUES (3553,7478,1178,40809,81400,2,67,2,1217.48,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3554,7478,1178,40809,81400,2,13,1,7015.00,NULL,'2022-08-12 20:39:49','2022-08-12 20:39:49',NULL),(3555,7478,1179,40809,81400,2,96,2,1157.02,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3556,7478,1179,40809,81400,2,67,2,242.98,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3557,7478,1179,40809,81400,2,13,1,1400.00,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3558,7478,1180,40809,81400,2,96,2,5206.61,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3559,7478,1180,40809,81400,2,67,2,1093.39,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3560,7478,1180,40809,81400,2,13,1,6300.00,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3561,7478,1181,40809,81400,2,96,2,10834.71,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3562,7478,1181,40809,81400,2,67,2,2275.29,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3563,7478,1181,40809,81400,2,13,1,13110.00,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3564,7478,1182,40809,81400,2,96,2,343.32,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3565,7478,1182,40809,81400,2,67,2,72.10,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3566,7478,1182,40809,81400,2,13,1,415.42,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3567,7478,1183,40809,81400,2,96,2,10264.46,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3568,7478,1183,40809,81400,2,67,2,2155.54,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3569,7478,1183,40809,81400,2,13,1,12420.00,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3570,7478,1184,40809,81400,2,96,2,214.88,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3571,7478,1184,40809,81400,2,67,2,45.12,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3572,7478,1184,40809,81400,2,13,1,260.00,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3573,7478,1185,40809,81400,2,96,2,9504.13,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3574,7478,1185,40809,81400,2,67,2,1995.87,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3575,7478,1185,40809,81400,2,13,1,11500.00,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3576,7478,1186,40809,81400,2,96,2,9049.59,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3577,7478,1186,40809,81400,2,67,2,1900.41,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3578,7478,1186,40809,81400,2,13,1,10950.00,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3579,7478,1187,40809,81400,2,96,2,15454.83,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3580,7478,1187,40809,81400,2,67,2,3245.51,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3581,7478,1187,40809,81400,2,13,1,18700.34,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3582,7478,1188,40809,81400,2,96,2,8925.62,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3583,7478,1188,40809,81400,2,67,2,1874.38,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3584,7478,1188,40809,81400,2,13,1,10800.00,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3585,7478,1189,40809,81400,2,96,2,300.17,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3586,7478,1189,40809,81400,2,67,2,63.03,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3587,7478,1189,40809,81400,2,13,1,363.20,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3588,7478,1190,40809,81400,2,96,2,5867.77,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3589,7478,1190,40809,81400,2,67,2,1232.23,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3590,7478,1190,40809,81400,2,13,1,7100.00,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3591,7478,1191,40809,81400,2,96,2,231.40,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3592,7478,1191,40809,81400,2,67,2,48.60,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL);
INSERT INTO `balance_libro_details` VALUES (3593,7478,1191,40809,81400,2,13,1,280.00,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3594,7478,1192,40809,81400,2,96,2,613.11,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3595,7478,1192,40809,81400,2,67,2,128.75,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3596,7478,1192,40809,81400,2,13,1,741.86,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3597,7478,1193,40809,81400,2,96,2,3167.15,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3598,7478,1193,40809,81400,2,67,2,665.10,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3599,7478,1193,40809,81400,2,13,1,3832.25,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3600,7478,1194,40809,81400,2,96,2,2158.00,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3601,7478,1194,40809,81400,2,67,2,453.18,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3602,7478,1194,40809,81400,2,13,1,2611.18,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3603,7478,1195,40809,81400,2,96,2,859.50,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3604,7478,1195,40809,81400,2,67,2,180.50,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3605,7478,1195,40809,81400,2,13,1,1040.00,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3606,7478,1196,40809,81400,2,96,2,280.99,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3607,7478,1196,40809,81400,2,67,2,59.01,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3608,7478,1196,40809,81400,2,13,1,340.00,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3609,7478,1197,40809,81400,2,96,2,7438.02,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3610,7478,1197,40809,81400,2,67,2,1561.98,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3611,7478,1197,40809,81400,2,13,1,9000.00,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3612,7478,1198,40809,81400,2,96,2,7024.79,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3613,7478,1198,40809,81400,2,67,2,1475.21,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3614,7478,1198,40809,81400,2,13,1,8500.00,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3615,7478,1199,40809,81400,2,96,2,3720.14,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3616,7478,1199,40809,81400,2,67,2,781.23,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3617,7478,1199,40809,81400,2,13,1,4501.37,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3618,7478,1200,40809,81400,2,96,2,7024.79,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3619,7478,1200,40809,81400,2,67,2,1475.21,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3620,7478,1200,40809,81400,2,13,1,8500.00,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3621,7478,1201,40809,81400,2,96,2,1818.18,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3622,7478,1201,40809,81400,2,67,2,381.82,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3623,7478,1201,40809,81400,2,13,1,2200.00,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3624,7478,1202,40809,81400,2,96,2,7851.24,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3625,7478,1202,40809,81400,2,67,2,1648.76,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3626,7478,1202,40809,81400,2,13,1,9500.00,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3627,7478,1203,40809,81400,2,96,2,15985.69,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3628,7478,1203,40809,81400,2,67,2,3356.99,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3629,7478,1203,40809,81400,2,13,1,19342.68,NULL,'2022-08-12 20:39:50','2022-08-12 20:39:50',NULL),(3630,7478,1204,40809,81400,2,96,2,4958.68,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3631,7478,1204,40809,81400,2,67,2,1041.32,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3632,7478,1204,40809,81400,2,13,1,6000.00,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3633,7478,1205,40809,81400,2,96,2,389.02,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL);
INSERT INTO `balance_libro_details` VALUES (3634,7478,1205,40809,81400,2,67,2,81.69,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3635,7478,1205,40809,81400,2,13,1,470.71,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3636,7478,1206,40809,81400,2,96,2,6177.69,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3637,7478,1206,40809,81400,2,67,2,1297.31,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3638,7478,1206,40809,81400,2,13,1,7475.00,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3639,7478,1207,40809,81400,2,96,2,2066.12,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3640,7478,1207,40809,81400,2,67,2,433.88,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3641,7478,1207,40809,81400,2,13,1,2500.00,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3642,7478,1208,40809,81400,2,96,2,3436.80,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3643,7478,1208,40809,81400,2,67,2,721.73,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3644,7478,1208,40809,81400,2,13,1,4158.53,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3645,7478,1209,40809,81400,2,96,2,231.40,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3646,7478,1209,40809,81400,2,67,2,48.60,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3647,7478,1209,40809,81400,2,13,1,280.00,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3648,7478,1210,40809,81400,2,96,2,5371.90,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3649,7478,1210,40809,81400,2,67,2,1128.10,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3650,7478,1210,40809,81400,2,13,1,6500.00,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3651,7478,1211,40809,81400,2,96,2,239.86,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3652,7478,1211,40809,81400,2,67,2,50.37,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3653,7478,1211,40809,81400,2,13,1,290.23,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3654,7478,1212,40809,81400,2,96,2,12932.56,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3655,7478,1212,40809,81400,2,67,2,2715.84,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3656,7478,1212,40809,81400,2,13,1,15648.40,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3657,7478,1213,40809,81400,2,96,2,14710.74,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3658,7478,1213,40809,81400,2,67,2,3089.26,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3659,7478,1213,40809,81400,2,13,1,17800.00,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3660,7478,1214,40809,81400,2,96,2,9090.91,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3661,7478,1214,40809,81400,2,67,2,1909.09,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3662,7478,1214,40809,81400,2,13,1,11000.00,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3663,7478,1215,40809,81400,2,96,2,10495.87,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3664,7478,1215,40809,81400,2,67,2,2204.13,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3665,7478,1215,40809,81400,2,13,1,12700.00,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3666,7478,1216,40809,81400,2,96,2,643.71,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3667,7478,1216,40809,81400,2,67,2,135.18,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3668,7478,1216,40809,81400,2,13,1,778.89,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3669,7478,1217,40809,81400,2,96,2,650.67,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3670,7478,1217,40809,81400,2,67,2,136.64,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3671,7478,1217,40809,81400,2,13,1,787.31,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3672,7478,1218,40809,81400,2,96,2,9643.84,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3673,7478,1218,40809,81400,2,67,2,2025.21,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3674,7478,1218,40809,81400,2,13,1,11669.05,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL);
INSERT INTO `balance_libro_details` VALUES (3675,7478,1219,40809,81400,2,96,2,2261.00,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3676,7478,1219,40809,81400,2,67,2,474.81,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3677,7478,1219,40809,81400,2,13,1,2735.81,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3678,7478,1220,40809,81400,2,96,2,134.13,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3679,7478,1220,40809,81400,2,67,2,28.17,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3680,7478,1220,40809,81400,2,13,1,162.30,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3681,7478,1221,40809,81400,2,96,2,376.33,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3682,7478,1221,40809,81400,2,67,2,79.03,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3683,7478,1221,40809,81400,2,13,1,455.36,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3684,7478,1222,40809,81400,2,96,2,10834.71,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3685,7478,1222,40809,81400,2,67,2,2275.29,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3686,7478,1222,40809,81400,2,13,1,13110.00,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3687,7478,1223,40809,81400,2,96,2,8409.09,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3688,7478,1223,40809,81400,2,67,2,1765.91,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3689,7478,1223,40809,81400,2,13,1,10175.00,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3690,7478,1224,40809,81400,2,96,2,7933.88,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3691,7478,1224,40809,81400,2,67,2,1666.12,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3692,7478,1224,40809,81400,2,13,1,9600.00,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3693,7478,1225,40809,81400,2,96,2,166.94,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3694,7478,1225,40809,81400,2,67,2,35.06,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3695,7478,1225,40809,81400,2,13,1,202.00,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3696,7478,1226,40809,81400,2,96,2,141.60,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3697,7478,1226,40809,81400,2,67,2,29.74,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3698,7478,1226,40809,81400,2,13,1,171.34,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3699,7478,1227,40809,81400,2,96,2,409.09,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3700,7478,1227,40809,81400,2,67,2,85.91,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3701,7478,1227,40809,81400,2,13,1,495.00,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3702,7478,1228,40809,81400,2,96,2,827.80,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3703,7478,1228,40809,81400,2,67,2,173.84,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3704,7478,1228,40809,81400,2,13,1,1001.64,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3705,7478,1229,40809,81400,2,96,2,12644.63,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3706,7478,1229,40809,81400,2,67,2,2655.37,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3707,7478,1229,40809,81400,2,13,1,15300.00,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3708,7478,1230,40809,81400,2,96,2,4041.60,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3709,7478,1230,40809,81400,2,67,2,848.74,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3710,7478,1230,40809,81400,2,13,1,4890.34,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3711,7478,1231,40809,81400,2,96,2,1147.11,NULL,'2022-08-12 20:39:51','2022-08-12 20:39:51',NULL),(3712,7478,1231,40809,81400,2,67,2,240.89,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3713,7478,1231,40809,81400,2,13,1,1388.00,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3714,7478,1232,40809,81400,2,96,2,82.64,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3715,7478,1232,40809,81400,2,67,2,17.36,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL);
INSERT INTO `balance_libro_details` VALUES (3716,7478,1232,40809,81400,2,13,1,100.00,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3717,7478,1233,40809,81400,2,96,2,766.94,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3718,7478,1233,40809,81400,2,67,2,161.06,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3719,7478,1233,40809,81400,2,13,1,928.00,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3720,7478,1234,40809,81400,2,96,2,6611.57,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3721,7478,1234,40809,81400,2,67,2,1388.43,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3722,7478,1234,40809,81400,2,13,1,8000.00,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3723,7478,1235,40809,81400,2,96,2,981.29,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3724,7478,1235,40809,81400,2,67,2,206.07,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3725,7478,1235,40809,81400,2,13,1,1187.36,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3726,7478,1236,40809,81400,2,96,2,613.24,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3727,7478,1236,40809,81400,2,67,2,128.78,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3728,7478,1236,40809,81400,2,13,1,742.02,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3729,7478,1237,40809,81400,2,96,2,31239.67,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3730,7478,1237,40809,81400,2,67,2,6560.33,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3731,7478,1237,40809,81400,2,13,1,37800.00,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3732,7478,1238,40809,81400,2,96,2,572.94,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3733,7478,1238,40809,81400,2,67,2,120.32,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3734,7478,1238,40809,81400,2,13,1,693.26,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3735,7478,1239,40809,81400,2,96,2,3210.44,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3736,7478,1239,40809,81400,2,67,2,674.19,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3737,7478,1239,40809,81400,2,13,1,3884.63,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3738,7478,1240,40809,81400,2,96,2,9090.91,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3739,7478,1240,40809,81400,2,67,2,1909.09,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3740,7478,1240,40809,81400,2,13,1,11000.00,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3741,7478,1241,40809,81400,2,96,2,4023.97,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3742,7478,1241,40809,81400,2,67,2,845.03,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3743,7478,1241,40809,81400,2,13,1,4869.00,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3744,7478,1242,40809,81400,2,96,2,5398.35,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3745,7478,1242,40809,81400,2,67,2,1133.65,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3746,7478,1242,40809,81400,2,13,1,6532.00,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3747,7478,1243,40809,81400,2,96,2,369.94,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3748,7478,1243,40809,81400,2,67,2,77.69,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3749,7478,1243,40809,81400,2,13,1,447.63,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3750,7478,1244,40809,81400,2,96,2,914.94,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3751,7478,1244,40809,81400,2,67,2,192.14,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3752,7478,1244,40809,81400,2,13,1,1107.08,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3753,7478,1245,40809,81400,2,96,2,2844.37,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3754,7478,1245,40809,81400,2,67,2,597.32,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3755,7478,1245,40809,81400,2,13,1,3441.69,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3756,7478,1246,40809,81400,2,96,2,7107.66,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL);
INSERT INTO `balance_libro_details` VALUES (3757,7478,1246,40809,81400,2,67,2,1492.61,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3758,7478,1246,40809,81400,2,13,1,8600.27,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3759,7478,1247,40809,81400,2,96,2,61.98,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3760,7478,1247,40809,81400,2,67,2,13.02,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3761,7478,1247,40809,81400,2,13,1,75.00,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3762,7478,1248,40809,81400,2,96,2,9561.16,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3763,7478,1248,40809,81400,2,67,2,2007.84,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3764,7478,1248,40809,81400,2,13,1,11569.00,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3765,7478,1249,40809,81400,2,96,2,7569.59,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3766,7478,1249,40809,81400,2,67,2,1589.61,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3767,7478,1249,40809,81400,2,13,1,9159.20,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3768,7478,1250,40809,81400,2,96,2,495.87,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3769,7478,1250,40809,81400,2,67,2,104.13,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3770,7478,1250,40809,81400,2,13,1,600.00,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3771,7478,1251,40809,81400,2,96,2,7128.10,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3772,7478,1251,40809,81400,2,67,2,1496.90,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3773,7478,1251,40809,81400,2,13,1,8625.00,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3774,7478,1252,40809,81400,2,96,2,3009.32,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3775,7478,1252,40809,81400,2,67,2,631.96,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3776,7478,1252,40809,81400,2,13,1,3641.28,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3777,7478,1253,40809,81400,2,96,2,8.26,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3778,7478,1253,40809,81400,2,67,2,1.74,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3779,7478,1253,40809,81400,2,13,1,10.00,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3780,7478,1254,40809,81400,2,96,2,0.83,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3781,7478,1254,40809,81400,2,67,2,0.17,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3782,7478,1254,40809,81400,2,13,1,1.00,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3783,7478,1255,40809,81400,2,96,2,8.26,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3784,7478,1255,40809,81400,2,67,2,1.74,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3785,7478,1255,40809,81400,2,13,1,10.00,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3786,7478,1256,40809,81400,2,96,2,8.26,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3787,7478,1256,40809,81400,2,67,2,1.74,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3788,7478,1256,40809,81400,2,13,1,10.00,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3789,7478,1257,40809,81400,2,96,2,158.56,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3790,7478,1257,40809,81400,2,67,2,33.30,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3791,7478,1257,40809,81400,2,13,1,191.86,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3792,7478,1258,40809,81400,2,96,2,10834.71,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3793,7478,1258,40809,81400,2,67,2,2275.29,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3794,7478,1258,40809,81400,2,13,1,13110.00,NULL,'2022-08-12 20:39:52','2022-08-12 20:39:52',NULL),(3795,7478,1259,40809,81400,2,96,2,237.36,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3796,7478,1259,40809,81400,2,67,2,49.84,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3797,7478,1259,40809,81400,2,13,1,287.20,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL);
INSERT INTO `balance_libro_details` VALUES (3798,7478,1260,40809,81400,2,96,2,646.64,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3799,7478,1260,40809,81400,2,67,2,135.80,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3800,7478,1260,40809,81400,2,13,1,782.44,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3801,7478,1261,40809,81400,2,96,2,597.25,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3802,7478,1261,40809,81400,2,67,2,125.42,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3803,7478,1261,40809,81400,2,13,1,722.67,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3804,7478,1262,40809,81400,2,96,2,8264.46,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3805,7478,1262,40809,81400,2,67,2,1735.54,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3806,7478,1262,40809,81400,2,13,1,10000.00,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3807,7478,1263,40809,81400,2,96,2,132.25,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3808,7478,1263,40809,81400,2,67,2,27.77,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3809,7478,1263,40809,81400,2,13,1,160.02,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3810,7478,1264,40809,81400,2,96,2,9549.75,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3811,7478,1264,40809,81400,2,67,2,2005.45,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3812,7478,1264,40809,81400,2,13,1,11555.20,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3813,7478,1265,40809,81400,2,96,2,5454.55,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3814,7478,1265,40809,81400,2,67,2,1145.45,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3815,7478,1265,40809,81400,2,13,1,6600.00,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3816,7478,1266,40809,81400,2,96,2,7438.02,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3817,7478,1266,40809,81400,2,67,2,1561.98,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3818,7478,1266,40809,81400,2,13,1,9000.00,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3819,7478,1267,40809,81400,2,96,2,9834.71,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3820,7478,1267,40809,81400,2,67,2,2065.29,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3821,7478,1267,40809,81400,2,13,1,11900.00,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3822,7478,1268,40809,81400,2,96,2,7851.24,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3823,7478,1268,40809,81400,2,67,2,1648.76,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3824,7478,1268,40809,81400,2,13,1,9500.00,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3825,7478,1269,40809,81400,2,96,2,2458.12,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3826,7478,1269,40809,81400,2,67,2,516.21,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3827,7478,1269,40809,81400,2,13,1,2974.33,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3828,7478,1270,40809,81400,2,96,2,5371.90,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3829,7478,1270,40809,81400,2,67,2,1128.10,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3830,7478,1270,40809,81400,2,13,1,6500.00,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3831,7478,1271,40809,81400,2,96,2,6177.69,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3832,7478,1271,40809,81400,2,67,2,1297.31,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3833,7478,1271,40809,81400,2,13,1,7475.00,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3834,7478,1272,40809,81400,2,96,2,7520.66,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3835,7478,1272,40809,81400,2,67,2,1579.34,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3836,7478,1272,40809,81400,2,13,1,9100.00,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3837,7478,1273,40809,81400,2,96,2,5371.90,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL);
INSERT INTO `balance_libro_details` VALUES (3838,7478,1273,40809,81400,2,67,2,1128.10,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3839,7478,1273,40809,81400,2,13,1,6500.00,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3840,7478,1274,40809,81400,2,96,2,5950.41,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3841,7478,1274,40809,81400,2,67,2,1249.59,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3842,7478,1274,40809,81400,2,13,1,7200.00,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3843,7478,1275,40809,81400,2,96,2,430.48,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3844,7478,1275,40809,81400,2,67,2,90.40,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3845,7478,1275,40809,81400,2,13,1,520.88,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3846,7478,1276,40809,81400,2,96,2,5867.77,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3847,7478,1276,40809,81400,2,67,2,1232.23,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3848,7478,1276,40809,81400,2,13,1,7100.00,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3849,7478,1277,40809,81400,2,96,2,150.41,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3850,7478,1277,40809,81400,2,67,2,31.59,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3851,7478,1277,40809,81400,2,13,1,182.00,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3852,7478,1278,40809,81400,2,96,2,5785.54,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3853,7478,1278,40809,81400,2,67,2,1214.96,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3854,7478,1278,40809,81400,2,13,1,7000.50,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3855,7478,1279,40809,81400,2,96,2,4958.68,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3856,7478,1279,40809,81400,2,67,2,1041.32,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3857,7478,1279,40809,81400,2,13,1,6000.00,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3858,7478,1280,40809,81400,2,96,2,416.04,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3859,7478,1280,40809,81400,2,67,2,87.37,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3860,7478,1280,40809,81400,2,13,1,503.41,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3861,7478,1281,40809,81400,2,96,2,325.62,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3862,7478,1281,40809,81400,2,67,2,68.38,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3863,7478,1281,40809,81400,2,13,1,394.00,NULL,'2022-08-12 20:39:53','2022-08-12 20:39:53',NULL),(3864,7478,1282,40809,81400,2,96,2,231.40,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3865,7478,1282,40809,81400,2,67,2,48.60,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3866,7478,1282,40809,81400,2,13,1,280.00,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3867,7478,1283,40809,81400,2,96,2,231.40,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3868,7478,1283,40809,81400,2,67,2,48.60,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3869,7478,1283,40809,81400,2,13,1,280.00,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3870,7478,1284,40809,81400,2,218,2,0.00,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3871,7478,1284,40809,81400,2,13,1,0.00,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3872,7478,1285,40809,81400,2,96,2,506.69,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3873,7478,1285,40809,81400,2,67,2,106.41,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3874,7478,1285,40809,81400,2,13,1,613.10,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3875,7478,1286,40809,81400,2,96,2,6033.18,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3876,7478,1286,40809,81400,2,67,2,1266.97,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3877,7478,1286,40809,81400,2,13,1,7300.15,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3878,7478,1287,40809,81400,2,96,2,8648.76,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL);
INSERT INTO `balance_libro_details` VALUES (3879,7478,1287,40809,81400,2,67,2,1816.24,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3880,7478,1287,40809,81400,2,13,1,10465.00,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3881,7478,1288,40809,81400,2,96,2,6611.57,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3882,7478,1288,40809,81400,2,67,2,1388.43,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3883,7478,1288,40809,81400,2,13,1,8000.00,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3884,7478,1289,40809,81400,2,96,2,5950.41,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3885,7478,1289,40809,81400,2,67,2,1249.59,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3886,7478,1289,40809,81400,2,13,1,7200.00,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3887,7478,1290,40809,81400,2,96,2,452.83,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3888,7478,1290,40809,81400,2,67,2,95.10,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3889,7478,1290,40809,81400,2,13,1,547.93,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3890,7478,1291,40809,81400,2,96,2,1236.20,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3891,7478,1291,40809,81400,2,67,2,259.60,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3892,7478,1291,40809,81400,2,13,1,1495.80,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3893,7478,1292,40809,81400,2,96,2,10330.58,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3894,7478,1292,40809,81400,2,67,2,2169.42,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3895,7478,1292,40809,81400,2,13,1,12500.00,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3896,7478,1293,40809,81400,2,96,2,6033.06,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3897,7478,1293,40809,81400,2,67,2,1266.94,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3898,7478,1293,40809,81400,2,13,1,7300.00,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3899,7478,1294,40809,81400,2,96,2,53414.71,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3900,7478,1294,40809,81400,2,67,2,11217.09,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3901,7478,1294,40809,81400,2,13,1,64631.80,NULL,'2022-08-12 20:39:54','2022-08-12 20:39:54',NULL),(3902,7478,1295,40809,81400,2,96,2,7520.66,NULL,'2022-08-12 20:48:06','2022-08-12 20:48:06',NULL),(3903,7478,1295,40809,81400,2,67,2,1579.34,NULL,'2022-08-12 20:48:06','2022-08-12 20:48:06',NULL),(3904,7478,1295,40809,81400,2,13,1,9100.00,NULL,'2022-08-12 20:48:06','2022-08-12 20:48:06',NULL),(3905,7478,1296,40809,81400,3,217,1,732.98,NULL,'2022-08-12 21:04:47','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3906,7478,1296,40809,81400,3,68,1,153.93,NULL,'2022-08-12 21:04:47','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3907,7478,1296,40809,81400,3,217,1,21.99,NULL,'2022-08-12 21:04:47','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3908,7478,1296,40809,81400,3,57,2,908.90,NULL,'2022-08-12 21:04:47','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3909,7478,1297,40809,81400,3,217,1,1157.02,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3910,7478,1297,40809,81400,3,68,1,242.98,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3911,7478,1297,40809,81400,3,57,2,1400.00,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3912,7478,1298,40809,81400,3,217,2,1528.58,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3913,7478,1298,40809,81400,3,67,2,321.00,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3914,7478,1298,40809,81400,3,57,1,1849.58,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3915,7478,1299,40809,81400,3,217,1,1200.00,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3916,7478,1299,40809,81400,3,68,1,252.00,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10');
INSERT INTO `balance_libro_details` VALUES (3917,7478,1299,40809,81400,3,57,2,1452.00,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3918,7478,1300,40809,81400,3,217,1,3199.00,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3919,7478,1300,40809,81400,3,68,1,671.79,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3920,7478,1300,40809,81400,3,57,2,3870.79,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3921,7478,1301,40809,81400,3,217,2,2667.40,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3922,7478,1301,40809,81400,3,67,2,560.15,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3923,7478,1301,40809,81400,3,217,2,336.03,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3924,7478,1301,40809,81400,3,57,1,3563.58,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3925,7478,1302,40809,81400,3,217,1,154430.04,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3926,7478,1302,40809,81400,3,68,1,32430.31,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3927,7478,1302,40809,81400,3,57,2,186860.35,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3928,7478,1303,40809,81400,3,217,1,143427.14,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3929,7478,1303,40809,81400,3,68,1,30119.70,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3930,7478,1303,40809,81400,3,57,2,173546.84,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3931,7478,1304,40809,81400,3,217,1,3637.06,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3932,7478,1304,40809,81400,3,68,1,763.79,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3933,7478,1304,40809,81400,3,57,2,4400.85,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3934,7478,1305,40809,81400,3,217,1,7163.17,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3935,7478,1305,40809,81400,3,68,1,1504.27,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3936,7478,1305,40809,81400,3,57,2,8667.44,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3937,7478,1306,40809,81400,3,217,1,3795.45,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3938,7478,1306,40809,81400,3,68,1,797.05,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3939,7478,1306,40809,81400,3,57,2,4592.50,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3940,7478,1307,40809,81400,3,217,1,7692.31,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3941,7478,1307,40809,81400,3,68,1,807.69,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3942,7478,1307,40809,81400,3,57,2,8500.00,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3943,7478,1308,40809,81400,3,217,1,11731.02,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3944,7478,1308,40809,81400,3,68,1,2463.51,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3945,7478,1308,40809,81400,3,57,2,14194.53,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3946,7478,1309,40809,81400,3,217,2,19343.07,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3947,7478,1309,40809,81400,3,67,2,4062.04,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3948,7478,1309,40809,81400,3,57,1,23405.11,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3949,7478,1310,40809,81400,3,217,1,2640.00,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3950,7478,1310,40809,81400,3,68,1,554.40,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10');
INSERT INTO `balance_libro_details` VALUES (3951,7478,1310,40809,81400,3,217,1,174.24,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3952,7478,1310,40809,81400,3,57,2,3368.64,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3953,7478,1311,40809,81400,3,217,1,2184.73,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3954,7478,1311,40809,81400,3,68,1,458.80,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3955,7478,1311,40809,81400,3,57,2,2643.53,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3956,7478,1312,40809,81400,3,217,1,1800.00,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3957,7478,1312,40809,81400,3,68,1,378.00,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3958,7478,1312,40809,81400,3,57,2,2178.00,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3959,7478,1313,40809,81400,3,217,1,7165.27,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3960,7478,1313,40809,81400,3,68,1,1504.71,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3961,7478,1313,40809,81400,3,217,1,-0.01,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3962,7478,1313,40809,81400,3,57,2,8669.97,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3963,7478,1314,40809,81400,3,217,1,29450.00,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3964,7478,1314,40809,81400,3,68,1,6184.50,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3965,7478,1314,40809,81400,3,57,2,35634.50,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3966,7478,1315,40809,81400,3,217,1,10160.01,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3967,7478,1315,40809,81400,3,68,1,2133.60,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3968,7478,1315,40809,81400,3,217,1,0.01,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3969,7478,1315,40809,81400,3,57,2,12293.62,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3970,7478,1316,40809,81400,3,217,2,1225.49,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3971,7478,1316,40809,81400,3,67,2,257.35,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3972,7478,1316,40809,81400,3,57,1,1482.84,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3973,7478,1317,40809,81400,3,217,1,71076.07,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3974,7478,1317,40809,81400,3,68,1,14925.98,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3975,7478,1317,40809,81400,3,57,2,86002.05,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3976,7478,1318,40809,81400,3,217,1,14414.72,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3977,7478,1318,40809,81400,3,68,1,3027.09,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3978,7478,1318,40809,81400,3,57,2,17441.81,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3979,7478,1319,40809,81400,3,217,1,46176.87,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3980,7478,1319,40809,81400,3,68,1,9697.14,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3981,7478,1319,40809,81400,3,57,2,55874.01,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3982,7478,1320,40809,81400,3,217,1,23479.25,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3983,7478,1320,40809,81400,3,68,1,4930.64,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3984,7478,1320,40809,81400,3,57,2,28409.89,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10');
INSERT INTO `balance_libro_details` VALUES (3985,7478,1321,40809,81400,3,217,1,65223.54,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3986,7478,1321,40809,81400,3,68,1,13696.94,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3987,7478,1321,40809,81400,3,217,1,0.01,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3988,7478,1321,40809,81400,3,57,2,78920.49,NULL,'2022-08-12 21:04:48','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3989,7478,1322,40809,81400,3,217,1,40640.17,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3990,7478,1322,40809,81400,3,68,1,8534.44,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3991,7478,1322,40809,81400,3,217,1,1463.05,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3992,7478,1322,40809,81400,3,57,2,50637.66,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3993,7478,1323,40809,81400,3,217,1,102527.06,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3994,7478,1323,40809,81400,3,68,1,21530.68,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3995,7478,1323,40809,81400,3,57,2,124057.74,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3996,7478,1324,40809,81400,3,217,2,11684.73,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3997,7478,1324,40809,81400,3,67,2,2453.79,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3998,7478,1324,40809,81400,3,57,1,14138.52,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(3999,7478,1325,40809,81400,3,217,2,3199.60,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4000,7478,1325,40809,81400,3,67,2,671.92,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4001,7478,1325,40809,81400,3,57,1,3871.52,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4002,7478,1326,40809,81400,3,217,1,29197.21,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4003,7478,1326,40809,81400,3,68,1,6131.41,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4004,7478,1326,40809,81400,3,57,2,35328.62,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4005,7478,1327,40809,81400,3,217,1,19887.43,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4006,7478,1327,40809,81400,3,68,1,4176.36,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4007,7478,1327,40809,81400,3,57,2,24063.79,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4008,7478,1328,40809,81400,3,217,1,10889.26,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4009,7478,1328,40809,81400,3,68,1,2286.74,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4010,7478,1328,40809,81400,3,57,2,13176.00,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4011,7478,1329,40809,81400,3,217,1,71892.43,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4012,7478,1329,40809,81400,3,68,1,15097.41,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4013,7478,1329,40809,81400,3,217,1,2588.13,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4014,7478,1329,40809,81400,3,57,2,89577.97,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4015,7478,1330,40809,81400,3,217,1,6198.35,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4016,7478,1330,40809,81400,3,68,1,1301.65,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4017,7478,1330,40809,81400,3,57,2,7500.00,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4018,7478,1331,40809,81400,3,217,1,7533.89,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10');
INSERT INTO `balance_libro_details` VALUES (4019,7478,1331,40809,81400,3,68,1,1582.12,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4020,7478,1331,40809,81400,3,217,1,-0.01,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4021,7478,1331,40809,81400,3,57,2,9116.00,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4022,7478,1332,40809,81400,3,217,1,88411.13,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4023,7478,1332,40809,81400,3,68,1,18566.34,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4024,7478,1332,40809,81400,3,57,2,106977.47,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4025,7478,1333,40809,81400,3,217,1,21653.30,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4026,7478,1333,40809,81400,3,68,1,4547.19,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4027,7478,1333,40809,81400,3,57,2,26200.49,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4028,7478,1334,40809,81400,3,217,1,2776.83,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4029,7478,1334,40809,81400,3,68,1,583.14,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4030,7478,1334,40809,81400,3,57,2,3359.97,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:10','2022-08-12 21:09:10'),(4031,7478,1335,40809,81400,3,217,1,7603.27,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4032,7478,1335,40809,81400,3,68,1,1596.69,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4033,7478,1335,40809,81400,3,57,2,9199.96,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4034,7478,1336,40809,81400,3,217,1,2500.00,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4035,7478,1336,40809,81400,3,68,1,525.00,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4036,7478,1336,40809,81400,3,217,1,150.00,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4037,7478,1336,40809,81400,3,57,2,3175.00,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4038,7478,1337,40809,81400,3,217,1,62536.23,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4039,7478,1337,40809,81400,3,68,1,13132.61,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4040,7478,1337,40809,81400,3,57,2,75668.84,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4041,7478,1338,40809,81400,3,217,1,4655.00,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4042,7478,1338,40809,81400,3,68,1,977.55,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4043,7478,1338,40809,81400,3,57,2,5632.55,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4044,7478,1339,40809,81400,3,217,1,2035.50,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4045,7478,1339,40809,81400,3,68,1,427.46,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4046,7478,1339,40809,81400,3,217,1,73.28,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4047,7478,1339,40809,81400,3,57,2,2536.24,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4048,7478,1340,40809,81400,3,250,1,24000.00,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4049,7478,1340,40809,81400,3,57,2,24000.00,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4050,7478,1341,40809,81400,3,217,1,16263.60,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4051,7478,1341,40809,81400,3,68,1,3415.36,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4052,7478,1341,40809,81400,3,217,1,585.49,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11');
INSERT INTO `balance_libro_details` VALUES (4053,7478,1341,40809,81400,3,57,2,20264.45,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4054,7478,1342,40809,81400,3,217,1,23100.11,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4055,7478,1342,40809,81400,3,68,1,4851.02,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4056,7478,1342,40809,81400,3,217,1,0.01,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4057,7478,1342,40809,81400,3,57,2,27951.14,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4058,7478,1343,40809,81400,3,217,1,41160.72,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4059,7478,1343,40809,81400,3,68,1,8643.75,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4060,7478,1343,40809,81400,3,57,2,49804.47,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4061,7478,1344,40809,81400,3,217,1,393454.86,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4062,7478,1344,40809,81400,3,68,1,82625.52,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4063,7478,1344,40809,81400,3,57,2,476080.38,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4064,7478,1345,40809,81400,3,217,2,4655.00,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4065,7478,1345,40809,81400,3,67,2,977.55,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4066,7478,1345,40809,81400,3,57,1,5632.55,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4067,7478,1346,40809,81400,3,217,1,46241.58,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4068,7478,1346,40809,81400,3,68,1,9710.73,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4069,7478,1346,40809,81400,3,57,2,55952.31,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4070,7478,1347,40809,81400,3,217,2,45927.74,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4071,7478,1347,40809,81400,3,67,2,8188.61,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4072,7478,1347,40809,81400,3,217,2,-0.01,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4073,7478,1347,40809,81400,3,57,1,54116.34,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4074,7478,1348,40809,81400,3,217,1,2800.00,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4075,7478,1348,40809,81400,3,68,1,588.00,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4076,7478,1348,40809,81400,3,57,2,3388.00,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4077,7478,1349,40809,81400,3,217,1,32699.04,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4078,7478,1349,40809,81400,3,68,1,6866.80,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4079,7478,1349,40809,81400,3,57,2,39565.84,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4080,7478,1350,40809,81400,3,217,1,11888.40,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4081,7478,1350,40809,81400,3,68,1,2496.56,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4082,7478,1350,40809,81400,3,57,2,14384.96,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4083,7478,1351,40809,81400,3,217,1,14852.20,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4084,7478,1351,40809,81400,3,68,1,3118.96,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4085,7478,1351,40809,81400,3,57,2,17971.16,NULL,'2022-08-12 21:04:49','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4086,7478,1352,40809,81400,3,217,1,16346.55,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11');
INSERT INTO `balance_libro_details` VALUES (4087,7478,1352,40809,81400,3,68,1,3432.78,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4088,7478,1352,40809,81400,3,57,2,19779.33,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4089,7478,1353,40809,81400,3,217,1,14860.50,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4090,7478,1353,40809,81400,3,68,1,3120.70,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4091,7478,1353,40809,81400,3,57,2,17981.20,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4092,7478,1354,40809,81400,3,217,1,16346.55,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4093,7478,1354,40809,81400,3,68,1,3432.78,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4094,7478,1354,40809,81400,3,57,2,19779.33,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4095,7478,1355,40809,81400,3,217,1,4700.48,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4096,7478,1355,40809,81400,3,68,1,987.10,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4097,7478,1355,40809,81400,3,217,1,169.22,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4098,7478,1355,40809,81400,3,57,2,5856.80,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4099,7478,1356,40809,81400,3,217,1,150290.83,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4100,7478,1356,40809,81400,3,68,1,31561.07,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4101,7478,1356,40809,81400,3,57,2,181851.90,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4102,7478,1357,40809,81400,3,217,1,142477.85,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4103,7478,1357,40809,81400,3,68,1,29920.35,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4104,7478,1357,40809,81400,3,57,2,172398.20,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4105,7478,1358,40809,81400,3,217,1,41782.59,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4106,7478,1358,40809,81400,3,68,1,8774.34,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4107,7478,1358,40809,81400,3,57,2,50556.93,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4108,7478,1359,40809,81400,3,217,2,9792.09,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4109,7478,1359,40809,81400,3,67,2,2056.34,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4110,7478,1359,40809,81400,3,57,1,11848.43,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4111,7478,1360,40809,81400,3,217,1,4307.00,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4112,7478,1360,40809,81400,3,68,1,904.47,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4113,7478,1360,40809,81400,3,217,1,155.05,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4114,7478,1360,40809,81400,3,57,2,5366.52,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4115,7478,1361,40809,81400,3,217,1,572.30,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4116,7478,1361,40809,81400,3,68,1,120.18,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4117,7478,1361,40809,81400,3,217,1,17.17,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4118,7478,1361,40809,81400,3,57,2,709.65,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4119,7478,1362,40809,81400,3,217,1,7849.66,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4120,7478,1362,40809,81400,3,68,1,1648.43,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11');
INSERT INTO `balance_libro_details` VALUES (4121,7478,1362,40809,81400,3,57,2,9498.09,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4122,7478,1363,40809,81400,3,217,1,22672.86,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4123,7478,1363,40809,81400,3,68,1,4761.30,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4124,7478,1363,40809,81400,3,57,2,27434.16,NULL,'2022-08-12 21:04:50','2022-08-12 21:09:11','2022-08-12 21:09:11'),(4125,7478,1364,40809,81400,3,221,1,21.99,NULL,'2022-08-12 21:39:24','2022-08-12 21:39:24',NULL),(4126,7478,1364,40809,81400,3,250,1,732.98,NULL,'2022-08-12 21:39:24','2022-08-12 21:39:24',NULL),(4127,7478,1364,40809,81400,3,68,1,153.93,NULL,'2022-08-12 21:39:24','2022-08-12 21:39:24',NULL),(4128,7478,1364,40809,81400,3,57,2,908.90,NULL,'2022-08-12 21:39:24','2022-08-12 21:39:24',NULL),(4129,7478,1365,40809,81400,3,250,1,1157.02,NULL,'2022-08-12 21:39:24','2022-08-12 21:39:24',NULL),(4130,7478,1365,40809,81400,3,68,1,242.98,NULL,'2022-08-12 21:39:24','2022-08-12 21:39:24',NULL),(4131,7478,1365,40809,81400,3,57,2,1400.00,NULL,'2022-08-12 21:39:24','2022-08-12 21:39:24',NULL),(4132,7478,1366,40809,81400,3,250,1,1200.00,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4133,7478,1366,40809,81400,3,68,1,252.00,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4134,7478,1366,40809,81400,3,57,2,1452.00,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4135,7478,1367,40809,81400,3,250,1,3199.00,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4136,7478,1367,40809,81400,3,68,1,671.79,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4137,7478,1367,40809,81400,3,57,2,3870.79,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4138,7478,1368,40809,81400,3,250,2,1528.58,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4139,7478,1368,40809,81400,3,67,2,321.00,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4140,7478,1368,40809,81400,3,57,1,1849.58,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4141,7478,1369,40809,81400,3,250,1,154430.04,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4142,7478,1369,40809,81400,3,68,1,32430.31,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4143,7478,1369,40809,81400,3,57,2,186860.35,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4144,7478,1370,40809,81400,3,250,2,2667.40,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4145,7478,1370,40809,81400,3,67,2,560.15,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4146,7478,1370,40809,81400,3,250,2,336.03,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4147,7478,1370,40809,81400,3,57,1,3563.58,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4148,7478,1371,40809,81400,3,250,1,3637.10,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4149,7478,1371,40809,81400,3,68,1,763.79,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4150,7478,1371,40809,81400,3,250,1,0.04,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4151,7478,1371,40809,81400,3,57,2,4400.93,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4152,7478,1372,40809,81400,3,250,1,143427.14,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4153,7478,1372,40809,81400,3,68,1,30119.70,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4154,7478,1372,40809,81400,3,57,2,173546.84,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4155,7478,1373,40809,81400,3,250,1,7163.17,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4156,7478,1373,40809,81400,3,68,1,1504.27,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4157,7478,1373,40809,81400,3,57,2,8667.44,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4158,7478,1374,40809,81400,3,250,1,3795.48,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4159,7478,1374,40809,81400,3,68,1,797.05,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4160,7478,1374,40809,81400,3,250,1,0.03,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL);
INSERT INTO `balance_libro_details` VALUES (4161,7478,1374,40809,81400,3,57,2,4592.56,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4162,7478,1375,40809,81400,3,250,1,7692.31,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4163,7478,1375,40809,81400,3,68,1,807.69,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4164,7478,1375,40809,81400,3,57,2,8500.00,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4165,7478,1376,40809,81400,3,243,1,174.24,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4166,7478,1376,40809,81400,3,250,1,2640.00,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4167,7478,1376,40809,81400,3,68,1,554.40,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4168,7478,1376,40809,81400,3,57,2,3368.64,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4169,7478,1377,40809,81400,3,250,1,11731.02,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4170,7478,1377,40809,81400,3,68,1,2463.51,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4171,7478,1377,40809,81400,3,57,2,14194.53,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4172,7478,1378,40809,81400,3,250,2,19343.06,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4173,7478,1378,40809,81400,3,67,2,4062.04,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4174,7478,1378,40809,81400,3,250,2,0.01,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4175,7478,1378,40809,81400,3,57,1,23405.11,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4176,7478,1379,40809,81400,3,250,1,1800.00,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4177,7478,1379,40809,81400,3,68,1,378.00,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4178,7478,1379,40809,81400,3,57,2,2178.00,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4179,7478,1380,40809,81400,3,250,1,2184.73,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4180,7478,1380,40809,81400,3,68,1,458.80,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4181,7478,1380,40809,81400,3,57,2,2643.53,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4182,7478,1381,40809,81400,3,250,1,7165.27,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4183,7478,1381,40809,81400,3,68,1,1504.71,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4184,7478,1381,40809,81400,3,250,1,0.01,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4185,7478,1381,40809,81400,3,57,2,8669.99,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4186,7478,1382,40809,81400,3,250,1,29450.00,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4187,7478,1382,40809,81400,3,68,1,6184.50,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4188,7478,1382,40809,81400,3,57,2,35634.50,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4189,7478,1383,40809,81400,3,217,1,10160.01,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4190,7478,1383,40809,81400,3,68,1,2133.60,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4191,7478,1383,40809,81400,3,217,1,0.01,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4192,7478,1383,40809,81400,3,57,2,12293.62,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4193,7478,1384,40809,81400,3,250,2,1225.49,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4194,7478,1384,40809,81400,3,67,2,257.35,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4195,7478,1384,40809,81400,3,57,1,1482.84,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4196,7478,1385,40809,81400,3,250,1,23479.25,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4197,7478,1385,40809,81400,3,68,1,4930.64,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4198,7478,1385,40809,81400,3,57,2,28409.89,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4199,7478,1386,40809,81400,3,250,1,14414.72,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4200,7478,1386,40809,81400,3,68,1,3027.09,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL);
INSERT INTO `balance_libro_details` VALUES (4201,7478,1386,40809,81400,3,57,2,17441.81,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4202,7478,1387,40809,81400,3,250,1,46176.87,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4203,7478,1387,40809,81400,3,68,1,9697.14,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4204,7478,1387,40809,81400,3,57,2,55874.01,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4205,7478,1388,40809,81400,3,250,1,71076.07,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4206,7478,1388,40809,81400,3,68,1,14925.98,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4207,7478,1388,40809,81400,3,57,2,86002.05,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4208,7478,1389,40809,81400,3,250,1,102527.06,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4209,7478,1389,40809,81400,3,68,1,21530.68,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4210,7478,1389,40809,81400,3,57,2,124057.74,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4211,7478,1390,40809,81400,3,217,1,65223.54,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4212,7478,1390,40809,81400,3,68,1,13696.94,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4213,7478,1390,40809,81400,3,217,1,0.01,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4214,7478,1390,40809,81400,3,57,2,78920.49,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4215,7478,1391,40809,81400,3,250,1,40640.17,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4216,7478,1391,40809,81400,3,68,1,8534.44,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4217,7478,1391,40809,81400,3,250,1,1463.05,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4218,7478,1391,40809,81400,3,57,2,50637.66,NULL,'2022-08-12 21:39:25','2022-08-12 21:39:25',NULL),(4219,7478,1392,40809,81400,3,250,2,11684.72,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4220,7478,1392,40809,81400,3,67,2,2453.79,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4221,7478,1392,40809,81400,3,250,2,0.01,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4222,7478,1392,40809,81400,3,57,1,14138.52,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4223,7478,1393,40809,81400,3,250,1,29197.21,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4224,7478,1393,40809,81400,3,68,1,6131.41,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4225,7478,1393,40809,81400,3,57,2,35328.62,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4226,7478,1394,40809,81400,3,250,1,19887.43,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4227,7478,1394,40809,81400,3,68,1,4176.36,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4228,7478,1394,40809,81400,3,57,2,24063.79,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4229,7478,1395,40809,81400,3,250,2,3199.60,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4230,7478,1395,40809,81400,3,67,2,671.92,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4231,7478,1395,40809,81400,3,57,1,3871.52,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4232,7478,1396,40809,81400,3,250,1,88411.13,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4233,7478,1396,40809,81400,3,68,1,18566.34,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4234,7478,1396,40809,81400,3,57,2,106977.47,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4235,7478,1397,40809,81400,3,243,1,2588.13,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4236,7478,1397,40809,81400,3,250,1,71892.43,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4237,7478,1397,40809,81400,3,68,1,15097.41,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4238,7478,1397,40809,81400,3,57,2,89577.97,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4239,7478,1398,40809,81400,3,250,1,6198.35,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4240,7478,1398,40809,81400,3,68,1,1301.65,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL);
INSERT INTO `balance_libro_details` VALUES (4241,7478,1398,40809,81400,3,57,2,7500.00,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4242,7478,1399,40809,81400,3,250,1,10889.26,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4243,7478,1399,40809,81400,3,68,1,2286.74,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4244,7478,1399,40809,81400,3,57,2,13176.00,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4245,7478,1400,40809,81400,3,250,1,7533.88,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4246,7478,1400,40809,81400,3,68,1,1582.12,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4247,7478,1400,40809,81400,3,57,2,9116.00,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4248,7478,1401,40809,81400,3,250,1,21653.30,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4249,7478,1401,40809,81400,3,68,1,4547.19,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4250,7478,1401,40809,81400,3,57,2,26200.49,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4251,7478,1402,40809,81400,3,250,1,2776.83,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4252,7478,1402,40809,81400,3,68,1,583.14,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4253,7478,1402,40809,81400,3,57,2,3359.97,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4254,7478,1403,40809,81400,3,250,1,7603.27,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4255,7478,1403,40809,81400,3,68,1,1596.69,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4256,7478,1403,40809,81400,3,57,2,9199.96,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4257,7478,1404,40809,81400,3,221,1,2.50,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4258,7478,1404,40809,81400,3,217,1,2500.00,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4259,7478,1404,40809,81400,3,68,1,525.00,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4260,7478,1404,40809,81400,3,217,1,147.50,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4261,7478,1404,40809,81400,3,57,2,3175.00,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4262,7478,1405,40809,81400,3,250,1,62536.23,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4263,7478,1405,40809,81400,3,68,1,13132.61,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4264,7478,1405,40809,81400,3,57,2,75668.84,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4265,7478,1406,40809,81400,3,250,1,2035.50,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4266,7478,1406,40809,81400,3,68,1,427.46,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4267,7478,1406,40809,81400,3,250,1,73.28,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4268,7478,1406,40809,81400,3,57,2,2536.24,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4269,7478,1407,40809,81400,3,250,1,4655.00,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4270,7478,1407,40809,81400,3,68,1,977.55,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4271,7478,1407,40809,81400,3,57,2,5632.55,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4272,7478,1408,40809,81400,3,217,1,24000.00,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4273,7478,1408,40809,81400,3,217,1,24000.00,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4274,7478,1408,40809,81400,3,57,2,24000.00,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4275,7478,1408,40809,81400,3,136,2,24000.00,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4276,7478,1409,40809,81400,3,243,1,585.49,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4277,7478,1409,40809,81400,3,250,1,16263.60,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4278,7478,1409,40809,81400,3,68,1,3415.36,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4279,7478,1409,40809,81400,3,57,2,20264.45,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4280,7478,1410,40809,81400,3,217,1,23100.11,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL);
INSERT INTO `balance_libro_details` VALUES (4281,7478,1410,40809,81400,3,68,1,4851.02,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4282,7478,1410,40809,81400,3,217,1,0.01,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4283,7478,1410,40809,81400,3,57,2,27951.14,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4284,7478,1411,40809,81400,3,250,1,393454.86,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4285,7478,1411,40809,81400,3,68,1,82625.52,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4286,7478,1411,40809,81400,3,57,2,476080.38,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4287,7478,1412,40809,81400,3,250,1,41160.72,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4288,7478,1412,40809,81400,3,68,1,8643.75,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4289,7478,1412,40809,81400,3,57,2,49804.47,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4290,7478,1413,40809,81400,3,250,1,2800.00,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4291,7478,1413,40809,81400,3,68,1,588.00,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4292,7478,1413,40809,81400,3,57,2,3388.00,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4293,7478,1414,40809,81400,3,250,1,46241.58,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4294,7478,1414,40809,81400,3,68,1,9710.73,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4295,7478,1414,40809,81400,3,57,2,55952.31,NULL,'2022-08-12 21:39:26','2022-08-12 21:39:26',NULL),(4296,7478,1415,40809,81400,3,250,1,32699.04,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4297,7478,1415,40809,81400,3,68,1,6866.80,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4298,7478,1415,40809,81400,3,57,2,39565.84,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4299,7478,1416,40809,81400,3,250,2,4655.00,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4300,7478,1416,40809,81400,3,67,2,977.55,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4301,7478,1416,40809,81400,3,57,1,5632.55,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4302,7478,1417,40809,81400,3,217,2,13868.75,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4303,7478,1417,40809,81400,3,67,2,1456.22,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4304,7478,1417,40809,81400,3,217,2,32058.99,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4305,7478,1417,40809,81400,3,67,2,6732.39,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4306,7478,1417,40809,81400,3,217,2,0.01,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4307,7478,1417,40809,81400,3,57,1,54116.36,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4308,7478,1418,40809,81400,3,217,1,14860.48,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4309,7478,1418,40809,81400,3,68,1,3120.70,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4310,7478,1418,40809,81400,3,217,1,0.02,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4311,7478,1418,40809,81400,3,57,2,17981.20,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4312,7478,1419,40809,81400,3,250,1,16346.57,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4313,7478,1419,40809,81400,3,68,1,3432.78,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4314,7478,1419,40809,81400,3,250,1,0.02,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4315,7478,1419,40809,81400,3,57,2,19779.37,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4316,7478,1420,40809,81400,3,217,1,14852.19,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4317,7478,1420,40809,81400,3,68,1,3118.96,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4318,7478,1420,40809,81400,3,217,1,0.01,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4319,7478,1420,40809,81400,3,57,2,17971.16,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4320,7478,1421,40809,81400,3,217,1,11888.38,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL);
INSERT INTO `balance_libro_details` VALUES (4321,7478,1421,40809,81400,3,68,1,2496.56,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4322,7478,1421,40809,81400,3,217,1,0.02,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4323,7478,1421,40809,81400,3,57,2,14384.96,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4324,7478,1422,40809,81400,3,250,1,16346.57,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4325,7478,1422,40809,81400,3,68,1,3432.78,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4326,7478,1422,40809,81400,3,250,1,0.02,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4327,7478,1422,40809,81400,3,57,2,19779.37,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4328,7478,1423,40809,81400,3,250,1,150290.83,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4329,7478,1423,40809,81400,3,68,1,31561.07,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4330,7478,1423,40809,81400,3,57,2,181851.90,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4331,7478,1424,40809,81400,3,250,1,4700.48,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4332,7478,1424,40809,81400,3,68,1,987.10,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4333,7478,1424,40809,81400,3,250,1,169.22,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4334,7478,1424,40809,81400,3,57,2,5856.80,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4335,7478,1425,40809,81400,3,250,1,22672.86,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4336,7478,1425,40809,81400,3,68,1,4761.30,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4337,7478,1425,40809,81400,3,57,2,27434.16,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4338,7478,1426,40809,81400,3,250,1,142477.85,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4339,7478,1426,40809,81400,3,68,1,29920.35,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4340,7478,1426,40809,81400,3,57,2,172398.20,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4341,7478,1427,40809,81400,3,221,1,17.17,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4342,7478,1427,40809,81400,3,250,1,572.30,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4343,7478,1427,40809,81400,3,68,1,120.18,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4344,7478,1427,40809,81400,3,57,2,709.65,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4345,7478,1428,40809,81400,3,250,1,4307.00,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4346,7478,1428,40809,81400,3,68,1,904.47,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4347,7478,1428,40809,81400,3,250,1,155.05,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4348,7478,1428,40809,81400,3,57,2,5366.52,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4349,7478,1429,40809,81400,3,250,1,41782.59,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4350,7478,1429,40809,81400,3,68,1,8774.34,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4351,7478,1429,40809,81400,3,57,2,50556.93,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4352,7478,1430,40809,81400,3,250,1,7849.66,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4353,7478,1430,40809,81400,3,68,1,1648.43,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4354,7478,1430,40809,81400,3,57,2,9498.09,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4355,7478,1431,40809,81400,3,250,2,9792.09,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4356,7478,1431,40809,81400,3,67,2,2056.34,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4357,7478,1431,40809,81400,3,57,1,11848.43,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4358,7478,1432,40809,81400,3,217,1,240.99,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4359,7478,1432,40809,81400,3,68,1,50.61,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4360,7478,1432,40809,81400,3,217,1,8.40,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL);
INSERT INTO `balance_libro_details` VALUES (4361,7478,1432,40809,81400,3,57,2,300.00,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4362,7478,1433,40809,81400,3,250,1,248.05,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4363,7478,1433,40809,81400,3,68,1,52.09,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4364,7478,1433,40809,81400,3,250,1,0.14,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4365,7478,1433,40809,81400,3,57,2,300.28,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4366,7478,1434,40809,81400,3,217,1,2883.67,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4367,7478,1434,40809,81400,3,68,1,605.57,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4368,7478,1434,40809,81400,3,217,1,510.76,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4369,7478,1434,40809,81400,3,57,2,4000.56,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4370,7478,1434,40809,81400,3,136,1,0.56,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4371,7478,1435,40809,81400,3,217,1,240.99,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4372,7478,1435,40809,81400,3,68,1,50.61,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4373,7478,1435,40809,81400,3,217,1,8.40,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4374,7478,1435,40809,81400,3,57,2,300.00,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4375,7478,1436,40809,81400,3,217,1,659.45,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4376,7478,1436,40809,81400,3,68,1,138.48,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4377,7478,1436,40809,81400,3,217,1,202.07,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4378,7478,1436,40809,81400,3,57,2,1000.00,NULL,'2022-08-12 21:39:27','2022-08-12 21:39:27',NULL),(4379,7478,1437,40809,81400,3,217,1,247.08,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4380,7478,1437,40809,81400,3,68,1,51.89,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4381,7478,1437,40809,81400,3,217,1,1.03,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4382,7478,1437,40809,81400,3,57,2,300.00,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4383,7478,1438,40809,81400,3,217,1,201.39,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4384,7478,1438,40809,81400,3,68,1,42.29,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4385,7478,1438,40809,81400,3,217,1,6.32,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4386,7478,1438,40809,81400,3,57,2,250.00,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4387,7478,1439,40809,81400,3,217,1,104.43,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4388,7478,1439,40809,81400,3,68,1,21.93,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4389,7478,1439,40809,81400,3,217,1,3.64,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4390,7478,1439,40809,81400,3,57,2,130.00,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4391,7478,1440,40809,81400,3,217,1,257.02,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4392,7478,1440,40809,81400,3,68,1,53.97,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4393,7478,1440,40809,81400,3,217,1,0.01,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4394,7478,1440,40809,81400,3,57,2,311.00,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4395,7478,1441,40809,81400,3,243,1,1675.76,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4396,7478,1441,40809,81400,3,250,1,46548.96,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4397,7478,1441,40809,81400,3,68,1,9775.28,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4398,7478,1441,40809,81400,3,57,2,58000.00,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4399,7478,1442,40809,81400,3,250,1,1098.11,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4400,7478,1442,40809,81400,3,68,1,115.30,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4401,7478,1442,40809,81400,3,250,1,2663.44,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL);
INSERT INTO `balance_libro_details` VALUES (4402,7478,1442,40809,81400,3,68,1,559.32,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4403,7478,1442,40809,81400,3,57,2,4436.17,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4404,7478,1443,40809,81400,3,217,1,260.23,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4405,7478,1443,40809,81400,3,68,1,54.65,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4406,7478,1443,40809,81400,3,217,1,25.12,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4407,7478,1443,40809,81400,3,57,2,340.00,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4408,7478,1444,40809,81400,3,217,1,281.95,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4409,7478,1444,40809,81400,3,68,1,59.21,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4410,7478,1444,40809,81400,3,217,1,8.84,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4411,7478,1444,40809,81400,3,57,2,350.00,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4412,7478,1445,40809,81400,3,217,1,107.17,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4413,7478,1445,40809,81400,3,68,1,22.51,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4414,7478,1445,40809,81400,3,217,1,1.04,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4415,7478,1445,40809,81400,3,57,2,130.72,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4416,7478,1446,40809,81400,3,217,1,289.74,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4417,7478,1446,40809,81400,3,68,1,60.85,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4418,7478,1446,40809,81400,3,217,1,2.81,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4419,7478,1446,40809,81400,3,57,2,353.40,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4420,7478,1447,40809,81400,3,217,1,653.38,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4421,7478,1447,40809,81400,3,68,1,137.21,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4422,7478,1447,40809,81400,3,217,1,209.41,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4423,7478,1447,40809,81400,3,57,2,1000.00,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4424,7478,1448,40809,81400,3,217,1,72.30,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4425,7478,1448,40809,81400,3,68,1,15.18,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4426,7478,1448,40809,81400,3,217,1,2.52,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4427,7478,1448,40809,81400,3,57,2,90.00,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4428,7478,1449,40809,81400,3,217,1,244.93,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4429,7478,1449,40809,81400,3,68,1,51.44,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4430,7478,1449,40809,81400,3,217,1,23.64,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4431,7478,1449,40809,81400,3,57,2,320.01,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4432,7478,1450,40809,81400,3,250,1,247.93,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4433,7478,1450,40809,81400,3,68,1,52.07,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4434,7478,1450,40809,81400,3,57,2,300.00,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4435,7478,1451,40809,81400,3,217,1,229.62,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4436,7478,1451,40809,81400,3,68,1,48.22,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4437,7478,1451,40809,81400,3,217,1,22.16,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4438,7478,1451,40809,81400,3,57,2,300.00,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4439,7478,1452,40809,81400,3,217,1,2296.19,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4440,7478,1452,40809,81400,3,68,1,482.20,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4441,7478,1452,40809,81400,3,217,1,221.61,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4442,7478,1452,40809,81400,3,57,2,3000.00,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL);
INSERT INTO `balance_libro_details` VALUES (4443,7478,1453,40809,81400,3,217,1,286.99,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4444,7478,1453,40809,81400,3,68,1,60.27,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4445,7478,1453,40809,81400,3,217,1,2.66,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4446,7478,1453,40809,81400,3,57,2,349.92,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4447,7478,1454,40809,81400,3,217,1,240.99,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4448,7478,1454,40809,81400,3,68,1,50.61,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4449,7478,1454,40809,81400,3,217,1,8.40,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4450,7478,1454,40809,81400,3,57,2,300.00,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4451,7478,1455,40809,81400,3,217,1,172.45,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4452,7478,1455,40809,81400,3,68,1,36.21,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4453,7478,1455,40809,81400,3,217,1,1.60,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4454,7478,1455,40809,81400,3,57,2,210.26,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4455,7478,1456,40809,81400,3,217,1,2069.24,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4456,7478,1456,40809,81400,3,68,1,434.54,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4457,7478,1456,40809,81400,3,217,1,596.69,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4458,7478,1456,40809,81400,3,57,2,3100.47,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4459,7478,1457,40809,81400,3,250,1,4180.99,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4460,7478,1457,40809,81400,3,68,1,878.01,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4461,7478,1457,40809,81400,3,57,2,5059.00,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4462,7478,1458,40809,81400,3,217,1,1449.18,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4463,7478,1458,40809,81400,3,68,1,304.33,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4464,7478,1458,40809,81400,3,217,1,246.49,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4465,7478,1458,40809,81400,3,57,2,2000.00,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4466,7478,1459,40809,81400,3,217,1,237.27,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4467,7478,1459,40809,81400,3,68,1,49.83,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4468,7478,1459,40809,81400,3,217,1,22.90,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4469,7478,1459,40809,81400,3,57,2,310.00,NULL,'2022-08-12 21:39:28','2022-08-12 21:39:28',NULL),(4470,7478,1460,40809,81400,3,217,1,237.27,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4471,7478,1460,40809,81400,3,68,1,49.83,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4472,7478,1460,40809,81400,3,217,1,22.90,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4473,7478,1460,40809,81400,3,57,2,310.00,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4474,7478,1461,40809,81400,3,250,1,257100.34,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4475,7478,1461,40809,81400,3,68,1,53991.07,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4476,7478,1461,40809,81400,3,57,2,311091.41,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4477,7478,1462,40809,81400,3,250,1,1492666.99,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4478,7478,1462,40809,81400,3,68,1,313460.07,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4479,7478,1462,40809,81400,3,57,2,1806127.06,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4480,7478,1463,40809,81400,3,217,1,282.13,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4481,7478,1463,40809,81400,3,68,1,59.25,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4482,7478,1463,40809,81400,3,217,1,8.62,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4483,7478,1463,40809,81400,3,57,2,350.00,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL);
INSERT INTO `balance_libro_details` VALUES (4484,7478,1464,40809,81400,3,217,1,233.61,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4485,7478,1464,40809,81400,3,68,1,49.06,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4486,7478,1464,40809,81400,3,217,1,7.33,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4487,7478,1464,40809,81400,3,57,2,290.00,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4488,7478,1465,40809,81400,3,217,1,2505.79,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4489,7478,1465,40809,81400,3,68,1,526.22,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4490,7478,1465,40809,81400,3,217,1,184.20,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4491,7478,1465,40809,81400,3,57,2,3216.21,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4492,7478,1466,40809,81400,3,217,1,218.90,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4493,7478,1466,40809,81400,3,68,1,45.97,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4494,7478,1466,40809,81400,3,217,1,21.13,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4495,7478,1466,40809,81400,3,57,2,286.00,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4496,7478,1467,40809,81400,3,250,1,10214.88,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4497,7478,1467,40809,81400,3,68,1,2145.12,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4498,7478,1467,40809,81400,3,57,2,12360.00,NULL,'2022-08-12 21:39:29','2022-08-12 21:39:29',NULL),(4499,7478,1468,40809,81400,15,67,1,671468.21,NULL,'2022-08-12 21:49:08','2022-08-12 21:49:08',NULL),(4500,7478,1468,40809,81400,15,68,2,837958.37,NULL,'2022-08-12 21:49:08','2022-08-12 21:49:08',NULL),(4501,7478,1468,40809,81400,15,353,1,166490.16,NULL,'2022-08-12 21:49:08','2022-08-12 21:49:08',NULL),(4502,7478,1469,40809,81400,2,410,1,2000000.00,NULL,'2022-08-12 21:57:43','2022-08-12 21:58:17','2022-08-12 21:58:17'),(4503,7478,1470,40809,81400,2,410,1,2000000.00,NULL,'2022-08-12 21:58:17','2022-08-12 22:18:20','2022-08-12 22:18:20'),(4504,7478,1470,40809,81400,2,14,2,2000000.00,NULL,'2022-08-12 21:58:17','2022-08-12 22:18:20','2022-08-12 22:18:20'),(4505,7478,1471,40809,81400,2,410,1,2054092.98,NULL,'2022-08-12 22:18:20','2022-08-12 22:32:47','2022-08-12 22:32:47'),(4506,7478,1471,40809,81400,2,14,2,2054092.98,NULL,'2022-08-12 22:18:20','2022-08-12 22:32:47','2022-08-12 22:32:47'),(4507,7478,1472,40809,81400,3,63,1,2166280.25,NULL,'2022-08-12 22:21:30','2022-08-12 22:32:30','2022-08-12 22:32:30'),(4508,7478,1472,40809,81400,3,410,2,2166280.25,NULL,'2022-08-12 22:21:30','2022-08-12 22:32:30','2022-08-12 22:32:30'),(4509,7478,1473,40809,82977,2,410,1,551228.14,NULL,'2022-08-12 22:24:08','2022-08-12 22:24:08',NULL),(4510,7478,1473,40809,82977,2,359,2,551228.14,NULL,'2022-08-12 22:24:08','2022-08-12 22:24:08',NULL),(4511,7478,1474,40809,81400,3,63,1,2166610.25,NULL,'2022-08-12 22:32:30','2022-08-12 22:32:30',NULL),(4512,7478,1474,40809,81400,3,410,2,2166610.25,NULL,'2022-08-12 22:32:30','2022-08-12 22:32:30',NULL),(4513,7478,1475,40809,81400,2,410,1,2084034.62,NULL,'2022-08-12 22:32:47','2022-08-12 22:32:47',NULL),(4514,7478,1475,40809,81400,2,14,2,2084034.62,NULL,'2022-08-12 22:32:47','2022-08-12 22:32:47',NULL),(4827,7477,1580,40809,81421,2,96,2,13223.14,NULL,'2022-08-13 11:51:41','2022-08-13 11:51:41',NULL),(4828,7477,1580,40809,81421,2,67,2,2776.86,NULL,'2022-08-13 11:51:41','2022-08-13 11:51:41',NULL),(4829,7477,1580,40809,81421,2,13,1,16000.00,NULL,'2022-08-13 11:51:41','2022-08-13 11:51:41',NULL),(4830,7477,1581,40809,81421,2,96,2,13636.36,NULL,'2022-08-13 11:51:41','2022-08-13 11:51:41',NULL),(4831,7477,1581,40809,81421,2,67,2,2863.64,NULL,'2022-08-13 11:51:41','2022-08-13 11:51:41',NULL),(4832,7477,1581,40809,81421,2,13,1,16500.00,NULL,'2022-08-13 11:51:41','2022-08-13 11:51:41',NULL),(4833,7477,1582,40809,81421,2,96,2,1801.65,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4834,7477,1582,40809,81421,2,67,2,378.35,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL);
INSERT INTO `balance_libro_details` VALUES (4835,7477,1582,40809,81421,2,13,1,2180.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4836,7477,1583,40809,81421,2,96,2,1931.40,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4837,7477,1583,40809,81421,2,67,2,405.60,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4838,7477,1583,40809,81421,2,13,1,2337.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4839,7477,1584,40809,81421,2,96,2,6611.57,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4840,7477,1584,40809,81421,2,67,2,1388.43,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4841,7477,1584,40809,81421,2,13,1,8000.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4842,7477,1585,40809,81421,2,96,2,3057.85,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4843,7477,1585,40809,81421,2,67,2,642.15,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4844,7477,1585,40809,81421,2,13,1,3700.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4845,7477,1586,40809,81421,2,96,2,455.37,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4846,7477,1586,40809,81421,2,67,2,95.63,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4847,7477,1586,40809,81421,2,13,1,551.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4848,7477,1587,40809,81421,2,96,2,1818.18,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4849,7477,1587,40809,81421,2,67,2,381.82,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4850,7477,1587,40809,81421,2,13,1,2200.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4851,7477,1588,40809,81421,2,96,2,10739.67,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4852,7477,1588,40809,81421,2,67,2,2255.33,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4853,7477,1588,40809,81421,2,13,1,12995.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4854,7477,1589,40809,81421,2,96,2,1818.18,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4855,7477,1589,40809,81421,2,67,2,381.82,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4856,7477,1589,40809,81421,2,13,1,2200.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4857,7477,1590,40809,81421,2,96,2,11983.47,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4858,7477,1590,40809,81421,2,67,2,2516.53,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4859,7477,1590,40809,81421,2,13,1,14500.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4860,7477,1591,40809,81421,2,96,2,537.19,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4861,7477,1591,40809,81421,2,67,2,112.81,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4862,7477,1591,40809,81421,2,13,1,650.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4863,7477,1592,40809,81421,2,96,2,8052.89,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4864,7477,1592,40809,81421,2,67,2,1691.11,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4865,7477,1592,40809,81421,2,13,1,9744.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4866,7477,1593,40809,81421,2,96,2,2347.11,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4867,7477,1593,40809,81421,2,67,2,492.89,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4868,7477,1593,40809,81421,2,13,1,2840.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4869,7477,1594,40809,81421,2,96,2,18057.85,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4870,7477,1594,40809,81421,2,67,2,3792.15,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4871,7477,1594,40809,81421,2,13,1,21850.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4872,7477,1595,40809,81421,2,96,2,4128.10,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4873,7477,1595,40809,81421,2,67,2,866.90,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4874,7477,1595,40809,81421,2,13,1,4995.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL);
INSERT INTO `balance_libro_details` VALUES (4875,7477,1596,40809,81421,2,96,2,15702.48,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4876,7477,1596,40809,81421,2,67,2,3297.52,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4877,7477,1596,40809,81421,2,13,1,19000.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4878,7477,1597,40809,81421,2,96,2,10743.80,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4879,7477,1597,40809,81421,2,67,2,2256.20,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4880,7477,1597,40809,81421,2,13,1,13000.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4881,7477,1598,40809,81421,2,96,2,15702.48,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4882,7477,1598,40809,81421,2,67,2,3297.52,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4883,7477,1598,40809,81421,2,13,1,19000.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4884,7477,1599,40809,81421,2,96,2,5545.45,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4885,7477,1599,40809,81421,2,67,2,1164.55,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4886,7477,1599,40809,81421,2,13,1,6710.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4887,7477,1600,40809,81421,2,96,2,2875.21,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4888,7477,1600,40809,81421,2,67,2,603.79,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4889,7477,1600,40809,81421,2,13,1,3479.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4890,7477,1601,40809,81421,2,96,2,7928.10,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4891,7477,1601,40809,81421,2,67,2,1664.90,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4892,7477,1601,40809,81421,2,13,1,9593.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4893,7477,1602,40809,81421,2,96,2,2484.30,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4894,7477,1602,40809,81421,2,67,2,521.70,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4895,7477,1602,40809,81421,2,13,1,3006.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4896,7477,1603,40809,81421,2,96,2,14462.81,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4897,7477,1603,40809,81421,2,67,2,3037.19,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4898,7477,1603,40809,81421,2,13,1,17500.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4899,7477,1604,40809,81421,2,96,2,22314.05,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4900,7477,1604,40809,81421,2,67,2,4685.95,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4901,7477,1604,40809,81421,2,13,1,27000.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4902,7477,1605,40809,81421,2,96,2,1950.41,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4903,7477,1605,40809,81421,2,67,2,409.59,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4904,7477,1605,40809,81421,2,13,1,2360.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4905,7477,1606,40809,81421,2,96,2,454.55,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4906,7477,1606,40809,81421,2,67,2,95.45,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4907,7477,1606,40809,81421,2,13,1,550.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4908,7477,1607,40809,81421,2,96,2,7254.55,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4909,7477,1607,40809,81421,2,67,2,1523.45,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4910,7477,1607,40809,81421,2,13,1,8778.00,NULL,'2022-08-13 11:51:42','2022-08-13 11:51:42',NULL),(4911,7477,1608,40809,81421,2,96,2,455.37,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4912,7477,1608,40809,81421,2,67,2,95.63,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4913,7477,1608,40809,81421,2,13,1,551.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4914,7477,1609,40809,81421,2,96,2,11983.47,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL);
INSERT INTO `balance_libro_details` VALUES (4915,7477,1609,40809,81421,2,67,2,2516.53,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4916,7477,1609,40809,81421,2,13,1,14500.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4917,7477,1610,40809,81421,2,96,2,9917.36,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4918,7477,1610,40809,81421,2,67,2,2082.64,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4919,7477,1610,40809,81421,2,13,1,12000.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4920,7477,1611,40809,81421,2,96,2,206612.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4921,7477,1611,40809,81421,2,67,2,43388.52,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4922,7477,1611,40809,81421,2,13,1,250000.52,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4923,7477,1612,40809,81421,2,96,2,22314.05,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4924,7477,1612,40809,81421,2,67,2,4685.95,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4925,7477,1612,40809,81421,2,13,1,27000.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4926,7477,1613,40809,81421,2,96,2,11400.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4927,7477,1613,40809,81421,2,67,2,2394.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4928,7477,1613,40809,81421,2,13,1,13794.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4929,7477,1614,40809,81421,2,96,1,206612.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4930,7477,1614,40809,81421,2,68,1,43388.52,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4931,7477,1614,40809,81421,2,13,2,250000.52,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4932,7477,1615,40809,81421,2,96,2,41983.55,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4933,7477,1615,40809,81421,2,67,2,8816.55,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4934,7477,1615,40809,81421,2,13,1,50800.10,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4935,7477,1616,40809,81421,2,96,2,25637.71,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4936,7477,1616,40809,81421,2,67,2,5383.93,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4937,7477,1616,40809,81421,2,13,1,31021.64,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4938,7477,1617,40809,81421,2,96,2,487.60,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4939,7477,1617,40809,81421,2,67,2,102.40,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4940,7477,1617,40809,81421,2,13,1,590.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4941,7477,1618,40809,81421,2,96,2,413.22,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4942,7477,1618,40809,81421,2,67,2,86.78,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4943,7477,1618,40809,81421,2,13,1,500.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4944,7477,1619,40809,81421,2,96,2,12314.05,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4945,7477,1619,40809,81421,2,67,2,2585.95,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4946,7477,1619,40809,81421,2,13,1,14900.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4947,7477,1620,40809,81421,2,96,2,9404.13,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4948,7477,1620,40809,81421,2,67,2,1974.87,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4949,7477,1620,40809,81421,2,13,1,11379.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4950,7477,1621,40809,81421,2,96,2,537.19,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4951,7477,1621,40809,81421,2,67,2,112.81,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4952,7477,1621,40809,81421,2,13,1,650.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4953,7477,1622,40809,81421,2,96,2,12727.27,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4954,7477,1622,40809,81421,2,67,2,2672.73,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL);
INSERT INTO `balance_libro_details` VALUES (4955,7477,1622,40809,81421,2,13,1,15400.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4956,7477,1623,40809,81421,2,96,2,12727.27,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4957,7477,1623,40809,81421,2,67,2,2672.73,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4958,7477,1623,40809,81421,2,13,1,15400.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4959,7477,1624,40809,81421,2,96,2,20661.16,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4960,7477,1624,40809,81421,2,67,2,4338.84,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4961,7477,1624,40809,81421,2,13,1,25000.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4962,7477,1625,40809,81421,2,96,2,11570.25,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4963,7477,1625,40809,81421,2,67,2,2429.75,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4964,7477,1625,40809,81421,2,13,1,14000.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4965,7477,1626,40809,81421,2,96,2,1859.50,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4966,7477,1626,40809,81421,2,67,2,390.50,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4967,7477,1626,40809,81421,2,13,1,2250.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4968,7477,1627,40809,81421,2,96,2,16115.70,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4969,7477,1627,40809,81421,2,67,2,3384.30,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4970,7477,1627,40809,81421,2,13,1,19500.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4971,7477,1628,40809,81421,2,96,2,661.16,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4972,7477,1628,40809,81421,2,67,2,138.84,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4973,7477,1628,40809,81421,2,13,1,800.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4974,7477,1629,40809,81421,2,96,2,4992.56,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4975,7477,1629,40809,81421,2,67,2,1048.44,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4976,7477,1629,40809,81421,2,13,1,6041.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4977,7477,1630,40809,81421,2,96,2,6546.28,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4978,7477,1630,40809,81421,2,67,2,1374.72,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4979,7477,1630,40809,81421,2,13,1,7921.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4980,7477,1631,40809,81421,2,96,2,867.77,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4981,7477,1631,40809,81421,2,67,2,182.23,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4982,7477,1631,40809,81421,2,13,1,1050.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4983,7477,1632,40809,81421,2,96,2,15702.48,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4984,7477,1632,40809,81421,2,67,2,3297.52,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4985,7477,1632,40809,81421,2,13,1,19000.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4986,7477,1633,40809,81421,2,96,1,41983.55,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4987,7477,1633,40809,81421,2,68,1,8816.55,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4988,7477,1633,40809,81421,2,13,2,50800.10,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4989,7477,1634,40809,81421,2,96,2,11157.02,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4990,7477,1634,40809,81421,2,67,2,2342.98,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4991,7477,1634,40809,81421,2,13,1,13500.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4992,7477,1635,40809,81421,2,96,2,826.45,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4993,7477,1635,40809,81421,2,67,2,173.55,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL),(4994,7477,1635,40809,81421,2,13,1,1000.00,NULL,'2022-08-13 11:51:43','2022-08-13 11:51:43',NULL);
INSERT INTO `balance_libro_details` VALUES (4995,7477,1636,40809,81421,2,96,2,12066.12,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(4996,7477,1636,40809,81421,2,67,2,2533.88,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(4997,7477,1636,40809,81421,2,13,1,14600.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(4998,7477,1637,40809,81421,2,96,2,413.22,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(4999,7477,1637,40809,81421,2,67,2,86.78,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5000,7477,1637,40809,81421,2,13,1,500.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5001,7477,1638,40809,81421,2,96,2,19834.71,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5002,7477,1638,40809,81421,2,67,2,4165.29,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5003,7477,1638,40809,81421,2,13,1,24000.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5004,7477,1639,40809,81421,2,96,2,9090.91,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5005,7477,1639,40809,81421,2,67,2,1909.09,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5006,7477,1639,40809,81421,2,13,1,11000.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5007,7477,1640,40809,81421,2,96,2,5619.83,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5008,7477,1640,40809,81421,2,67,2,1180.17,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5009,7477,1640,40809,81421,2,13,1,6800.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5010,7477,1641,40809,81421,2,96,2,966.94,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5011,7477,1641,40809,81421,2,67,2,203.06,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5012,7477,1641,40809,81421,2,13,1,1170.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5013,7477,1642,40809,81421,2,96,2,12909.09,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5014,7477,1642,40809,81421,2,67,2,2710.91,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5015,7477,1642,40809,81421,2,13,1,15620.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5016,7477,1643,40809,81421,2,96,2,24793.39,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5017,7477,1643,40809,81421,2,67,2,5206.61,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5018,7477,1643,40809,81421,2,13,1,30000.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5019,7477,1644,40809,81421,2,96,2,9504.13,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5020,7477,1644,40809,81421,2,67,2,1995.87,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5021,7477,1644,40809,81421,2,13,1,11500.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5022,7477,1645,40809,81421,2,96,2,1358.68,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5023,7477,1645,40809,81421,2,67,2,285.32,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5024,7477,1645,40809,81421,2,13,1,1644.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5025,7477,1646,40809,81421,2,96,2,1264.46,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5026,7477,1646,40809,81421,2,67,2,265.54,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5027,7477,1646,40809,81421,2,13,1,1530.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5028,7477,1647,40809,81421,2,96,2,9586.78,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5029,7477,1647,40809,81421,2,67,2,2013.22,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5030,7477,1647,40809,81421,2,13,1,11600.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5031,7477,1648,40809,81421,2,96,2,7438.02,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5032,7477,1648,40809,81421,2,67,2,1561.98,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5033,7477,1648,40809,81421,2,13,1,9000.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5034,7477,1649,40809,81421,2,96,2,20661.16,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL);
INSERT INTO `balance_libro_details` VALUES (5035,7477,1649,40809,81421,2,67,2,4338.84,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5036,7477,1649,40809,81421,2,13,1,25000.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5037,7477,1650,40809,81421,2,96,2,14586.78,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5038,7477,1650,40809,81421,2,67,2,3063.22,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5039,7477,1650,40809,81421,2,13,1,17650.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5040,7477,1651,40809,81421,2,96,2,20308.76,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5041,7477,1651,40809,81421,2,67,2,4264.84,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5042,7477,1651,40809,81421,2,13,1,24573.60,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5043,7477,1652,40809,81421,2,96,2,25637.71,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5044,7477,1652,40809,81421,2,67,2,5383.93,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5045,7477,1652,40809,81421,2,13,1,31021.64,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5046,7477,1653,40809,81421,2,96,2,578.51,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5047,7477,1653,40809,81421,2,67,2,121.49,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5048,7477,1653,40809,81421,2,13,1,700.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5049,7477,1654,40809,81421,2,96,2,11570.25,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5050,7477,1654,40809,81421,2,67,2,2429.75,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5051,7477,1654,40809,81421,2,13,1,14000.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5052,7477,1655,40809,81421,2,96,2,16435.54,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5053,7477,1655,40809,81421,2,67,2,3451.46,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5054,7477,1655,40809,81421,2,13,1,19887.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5055,7477,1656,40809,81421,2,96,2,1900.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5056,7477,1656,40809,81421,2,67,2,399.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5057,7477,1656,40809,81421,2,13,1,2299.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5058,7477,1657,40809,81421,2,96,2,884.30,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5059,7477,1657,40809,81421,2,67,2,185.70,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5060,7477,1657,40809,81421,2,13,1,1070.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5061,7477,1658,40809,81421,2,96,2,19834.71,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5062,7477,1658,40809,81421,2,67,2,4165.29,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5063,7477,1658,40809,81421,2,13,1,24000.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5064,7477,1659,40809,81421,2,96,2,19834.71,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5065,7477,1659,40809,81421,2,67,2,4165.29,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5066,7477,1659,40809,81421,2,13,1,24000.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5067,7477,1660,40809,81421,2,96,2,8264.46,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5068,7477,1660,40809,81421,2,67,2,1735.54,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5069,7477,1660,40809,81421,2,13,1,10000.00,NULL,'2022-08-13 11:51:44','2022-08-13 11:51:44',NULL),(5070,7477,1661,40809,81421,2,96,2,21487.60,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5071,7477,1661,40809,81421,2,67,2,4512.40,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5072,7477,1661,40809,81421,2,13,1,26000.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5073,7477,1662,40809,81421,2,96,2,2068.60,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5074,7477,1662,40809,81421,2,67,2,434.40,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL);
INSERT INTO `balance_libro_details` VALUES (5075,7477,1662,40809,81421,2,13,1,2503.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5076,7477,1663,40809,81421,2,96,2,1157.02,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5077,7477,1663,40809,81421,2,67,2,242.98,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5078,7477,1663,40809,81421,2,13,1,1400.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5079,7477,1664,40809,81421,2,96,2,48760.33,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5080,7477,1664,40809,81421,2,67,2,10239.67,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5081,7477,1664,40809,81421,2,13,1,59000.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5082,7477,1665,40809,81421,2,96,2,1570.25,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5083,7477,1665,40809,81421,2,67,2,329.75,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5084,7477,1665,40809,81421,2,13,1,1900.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5085,7477,1666,40809,81421,2,96,2,7561.98,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5086,7477,1666,40809,81421,2,67,2,1588.02,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5087,7477,1666,40809,81421,2,13,1,9150.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5088,7477,1667,40809,81421,2,96,2,20661.16,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5089,7477,1667,40809,81421,2,67,2,4338.84,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5090,7477,1667,40809,81421,2,13,1,25000.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5091,7477,1668,40809,81421,2,96,2,31404.96,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5092,7477,1668,40809,81421,2,67,2,6595.04,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5093,7477,1668,40809,81421,2,13,1,38000.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5094,7477,1669,40809,81421,2,96,2,15702.48,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5095,7477,1669,40809,81421,2,67,2,3297.52,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5096,7477,1669,40809,81421,2,13,1,19000.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5097,7477,1670,40809,81421,2,96,2,166.12,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5098,7477,1670,40809,81421,2,67,2,34.88,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5099,7477,1670,40809,81421,2,13,1,201.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5100,7477,1671,40809,81421,2,96,2,500.83,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5101,7477,1671,40809,81421,2,67,2,105.17,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5102,7477,1671,40809,81421,2,13,1,606.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5103,7477,1672,40809,81421,2,96,2,1933.06,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5104,7477,1672,40809,81421,2,67,2,405.94,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5105,7477,1672,40809,81421,2,13,1,2339.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5106,7477,1673,40809,81421,2,96,2,23140.50,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5107,7477,1673,40809,81421,2,67,2,4859.50,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5108,7477,1673,40809,81421,2,13,1,28000.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5109,7477,1674,40809,81421,2,96,2,495.87,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5110,7477,1674,40809,81421,2,67,2,104.13,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5111,7477,1674,40809,81421,2,13,1,600.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5112,7477,1675,40809,81421,2,96,2,4297.52,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5113,7477,1675,40809,81421,2,67,2,902.48,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5114,7477,1675,40809,81421,2,13,1,5200.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL);
INSERT INTO `balance_libro_details` VALUES (5115,7477,1676,40809,81421,2,96,2,28842.98,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5116,7477,1676,40809,81421,2,67,2,6057.02,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5117,7477,1676,40809,81421,2,13,1,34900.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5118,7477,1677,40809,81421,2,96,2,19008.26,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5119,7477,1677,40809,81421,2,67,2,3991.74,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5120,7477,1677,40809,81421,2,13,1,23000.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5121,7477,1678,40809,81421,2,96,2,10991.74,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5122,7477,1678,40809,81421,2,67,2,2308.26,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5123,7477,1678,40809,81421,2,13,1,13300.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5124,7477,1679,40809,81421,2,96,2,23966.94,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5125,7477,1679,40809,81421,2,67,2,5033.06,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5126,7477,1679,40809,81421,2,13,1,29000.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5127,7477,1680,40809,81421,2,96,2,5660.33,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5128,7477,1680,40809,81421,2,67,2,1188.67,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5129,7477,1680,40809,81421,2,13,1,6849.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5130,7477,1681,40809,81421,2,96,2,10743.80,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5131,7477,1681,40809,81421,2,67,2,2256.20,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5132,7477,1681,40809,81421,2,13,1,13000.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5133,7477,1682,40809,81421,2,96,2,10910.74,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5134,7477,1682,40809,81421,2,67,2,2291.26,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5135,7477,1682,40809,81421,2,13,1,13202.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5136,7477,1683,40809,81421,2,96,2,950.41,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5137,7477,1683,40809,81421,2,67,2,199.59,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5138,7477,1683,40809,81421,2,13,1,1150.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5139,7477,1684,40809,81421,2,96,2,4380.17,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5140,7477,1684,40809,81421,2,67,2,919.83,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5141,7477,1684,40809,81421,2,13,1,5300.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5142,7477,1685,40809,81421,2,96,2,17768.60,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5143,7477,1685,40809,81421,2,67,2,3731.40,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5144,7477,1685,40809,81421,2,13,1,21500.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5145,7477,1686,40809,81421,2,96,2,5446.28,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5146,7477,1686,40809,81421,2,67,2,1143.72,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5147,7477,1686,40809,81421,2,13,1,6590.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5148,7477,1687,40809,81421,2,96,2,4958.68,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5149,7477,1687,40809,81421,2,67,2,1041.32,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5150,7477,1687,40809,81421,2,13,1,6000.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5151,7477,1688,40809,81421,2,96,2,11750.41,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5152,7477,1688,40809,81421,2,67,2,2467.59,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5153,7477,1688,40809,81421,2,13,1,14218.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5154,7477,1689,40809,81421,2,96,2,1504.13,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL);
INSERT INTO `balance_libro_details` VALUES (5155,7477,1689,40809,81421,2,67,2,315.87,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5156,7477,1689,40809,81421,2,13,1,1820.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5157,7477,1690,40809,81421,2,96,2,9487.60,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5158,7477,1690,40809,81421,2,67,2,1992.40,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5159,7477,1690,40809,81421,2,13,1,11480.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5160,7477,1691,40809,81421,2,96,2,250.41,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5161,7477,1691,40809,81421,2,67,2,52.59,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5162,7477,1691,40809,81421,2,13,1,303.00,NULL,'2022-08-13 11:51:45','2022-08-13 11:51:45',NULL),(5163,7477,1692,40809,81421,2,96,2,3471.07,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5164,7477,1692,40809,81421,2,67,2,728.93,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5165,7477,1692,40809,81421,2,13,1,4200.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5166,7477,1693,40809,81421,2,96,2,3552.07,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5167,7477,1693,40809,81421,2,67,2,745.93,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5168,7477,1693,40809,81421,2,13,1,4298.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5169,7477,1694,40809,81421,2,96,2,12124.79,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5170,7477,1694,40809,81421,2,67,2,2546.21,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5171,7477,1694,40809,81421,2,13,1,14671.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5172,7477,1695,40809,81421,2,96,2,13636.36,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5173,7477,1695,40809,81421,2,67,2,2863.64,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5174,7477,1695,40809,81421,2,13,1,16500.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5175,7477,1696,40809,81421,2,96,2,15099.17,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5176,7477,1696,40809,81421,2,67,2,3170.83,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5177,7477,1696,40809,81421,2,13,1,18270.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5178,7477,1697,40809,81421,2,96,2,11342.15,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5179,7477,1697,40809,81421,2,67,2,2381.85,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5180,7477,1697,40809,81421,2,13,1,13724.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5181,7477,1698,40809,81421,2,96,2,15702.48,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5182,7477,1698,40809,81421,2,67,2,3297.52,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5183,7477,1698,40809,81421,2,13,1,19000.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5184,7477,1699,40809,81421,2,96,2,19524.79,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5185,7477,1699,40809,81421,2,67,2,4100.21,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5186,7477,1699,40809,81421,2,13,1,23625.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5187,7477,1700,40809,81421,2,96,2,4920.67,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5188,7477,1700,40809,81421,2,67,2,1033.33,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5189,7477,1700,40809,81421,2,13,1,5954.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5190,7477,1701,40809,81421,2,96,2,6078.51,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5191,7477,1701,40809,81421,2,67,2,1276.49,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5192,7477,1701,40809,81421,2,13,1,7355.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5193,7477,1702,40809,81421,2,96,2,46171.07,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5194,7477,1702,40809,81421,2,67,2,9695.93,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL);
INSERT INTO `balance_libro_details` VALUES (5195,7477,1702,40809,81421,2,13,1,55867.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5196,7477,1703,40809,81421,2,96,2,1937.19,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5197,7477,1703,40809,81421,2,67,2,406.81,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5198,7477,1703,40809,81421,2,13,1,2344.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5199,7477,1704,40809,81421,2,96,2,16528.93,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5200,7477,1704,40809,81421,2,67,2,3471.07,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5201,7477,1704,40809,81421,2,13,1,20000.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5202,7477,1705,40809,81421,2,96,2,8105.79,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5203,7477,1705,40809,81421,2,67,2,1702.21,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5204,7477,1705,40809,81421,2,13,1,9808.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5205,7477,1706,40809,81421,2,96,2,4462.81,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5206,7477,1706,40809,81421,2,67,2,937.19,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5207,7477,1706,40809,81421,2,13,1,5400.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5208,7477,1707,40809,81421,2,96,2,2948.76,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5209,7477,1707,40809,81421,2,67,2,619.24,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5210,7477,1707,40809,81421,2,13,1,3568.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5211,7477,1708,40809,81421,2,96,2,1191.74,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5212,7477,1708,40809,81421,2,67,2,250.26,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5213,7477,1708,40809,81421,2,13,1,1442.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5214,7477,1709,40809,81421,2,96,2,578.51,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5215,7477,1709,40809,81421,2,67,2,121.49,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5216,7477,1709,40809,81421,2,13,1,700.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5217,7477,1710,40809,81421,2,96,2,348.76,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5218,7477,1710,40809,81421,2,67,2,73.24,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5219,7477,1710,40809,81421,2,13,1,422.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5220,7477,1711,40809,81421,2,96,2,1704.13,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5221,7477,1711,40809,81421,2,67,2,357.87,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5222,7477,1711,40809,81421,2,13,1,2062.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5223,7477,1712,40809,81421,2,96,2,3967.77,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5224,7477,1712,40809,81421,2,67,2,833.23,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5225,7477,1712,40809,81421,2,13,1,4801.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5226,7477,1713,40809,81421,2,96,2,16446.28,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5227,7477,1713,40809,81421,2,67,2,3453.72,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5228,7477,1713,40809,81421,2,13,1,19900.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5229,7477,1714,40809,81421,2,96,2,3140.50,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5230,7477,1714,40809,81421,2,67,2,659.50,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5231,7477,1714,40809,81421,2,13,1,3800.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5232,7477,1715,40809,81421,2,96,2,21487.60,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5233,7477,1715,40809,81421,2,67,2,4512.40,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5234,7477,1715,40809,81421,2,13,1,26000.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL);
INSERT INTO `balance_libro_details` VALUES (5235,7477,1716,40809,81421,2,96,2,330.58,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5236,7477,1716,40809,81421,2,67,2,69.42,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5237,7477,1716,40809,81421,2,13,1,400.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5238,7477,1717,40809,81421,2,96,2,495.87,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5239,7477,1717,40809,81421,2,67,2,104.13,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5240,7477,1717,40809,81421,2,13,1,600.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5241,7477,1718,40809,81421,2,96,2,6317.36,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5242,7477,1718,40809,81421,2,67,2,1326.64,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5243,7477,1718,40809,81421,2,13,1,7644.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5244,7477,1719,40809,81421,2,96,2,11002.48,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5245,7477,1719,40809,81421,2,67,2,2310.52,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5246,7477,1719,40809,81421,2,13,1,13313.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5247,7477,1720,40809,81421,2,96,2,14876.03,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5248,7477,1720,40809,81421,2,67,2,3123.97,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5249,7477,1720,40809,81421,2,13,1,18000.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5250,7477,1721,40809,81421,2,96,2,2479.34,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5251,7477,1721,40809,81421,2,67,2,520.66,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5252,7477,1721,40809,81421,2,13,1,3000.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5253,7477,1722,40809,81421,2,96,2,1652.89,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5254,7477,1722,40809,81421,2,67,2,347.11,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5255,7477,1722,40809,81421,2,13,1,2000.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5256,7477,1723,40809,81421,2,96,2,8835.54,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5257,7477,1723,40809,81421,2,67,2,1855.46,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5258,7477,1723,40809,81421,2,13,1,10691.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5259,7477,1724,40809,81421,2,96,2,17190.08,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5260,7477,1724,40809,81421,2,67,2,3609.92,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5261,7477,1724,40809,81421,2,13,1,20800.00,NULL,'2022-08-13 11:51:46','2022-08-13 11:51:46',NULL),(5262,7477,1725,40809,81421,2,96,2,12314.05,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5263,7477,1725,40809,81421,2,67,2,2585.95,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5264,7477,1725,40809,81421,2,13,1,14900.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5265,7477,1726,40809,81421,2,96,2,1239.67,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5266,7477,1726,40809,81421,2,67,2,260.33,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5267,7477,1726,40809,81421,2,13,1,1500.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5268,7477,1727,40809,81421,2,96,2,1919.83,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5269,7477,1727,40809,81421,2,67,2,403.17,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5270,7477,1727,40809,81421,2,13,1,2323.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5271,7477,1728,40809,81421,2,96,2,6280.99,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5272,7477,1728,40809,81421,2,67,2,1319.01,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5273,7477,1728,40809,81421,2,13,1,7600.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5274,7477,1729,40809,81421,2,96,2,21947.11,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL);
INSERT INTO `balance_libro_details` VALUES (5275,7477,1729,40809,81421,2,67,2,4608.89,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5276,7477,1729,40809,81421,2,13,1,26556.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5277,7477,1730,40809,81421,2,96,2,25206.61,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5278,7477,1730,40809,81421,2,67,2,5293.39,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5279,7477,1730,40809,81421,2,13,1,30500.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5280,7477,1731,40809,81421,2,96,2,11983.47,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5281,7477,1731,40809,81421,2,67,2,2516.53,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5282,7477,1731,40809,81421,2,13,1,14500.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5283,7477,1732,40809,81421,2,96,2,1322.31,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5284,7477,1732,40809,81421,2,67,2,277.69,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5285,7477,1732,40809,81421,2,13,1,1600.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5286,7477,1733,40809,81421,2,96,2,1157.02,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5287,7477,1733,40809,81421,2,67,2,242.98,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5288,7477,1733,40809,81421,2,13,1,1400.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5289,7477,1734,40809,81421,2,96,2,4300.83,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5290,7477,1734,40809,81421,2,67,2,903.17,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5291,7477,1734,40809,81421,2,13,1,5204.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5292,7477,1735,40809,81421,2,96,2,3665.29,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5293,7477,1735,40809,81421,2,67,2,769.71,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5294,7477,1735,40809,81421,2,13,1,4435.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5295,7477,1736,40809,81421,2,96,2,1652.89,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5296,7477,1736,40809,81421,2,67,2,347.11,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5297,7477,1736,40809,81421,2,13,1,2000.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5298,7477,1737,40809,81421,2,96,2,36457.85,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5299,7477,1737,40809,81421,2,67,2,7656.15,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5300,7477,1737,40809,81421,2,13,1,44114.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5301,7477,1738,40809,81421,2,96,2,8289.26,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5302,7477,1738,40809,81421,2,67,2,1740.74,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5303,7477,1738,40809,81421,2,13,1,10030.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5304,7477,1739,40809,81421,2,96,2,8289.26,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5305,7477,1739,40809,81421,2,67,2,1740.74,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5306,7477,1739,40809,81421,2,13,1,10030.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5307,7477,1740,40809,81421,2,96,2,3305.79,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5308,7477,1740,40809,81421,2,67,2,694.21,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5309,7477,1740,40809,81421,2,13,1,4000.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5310,7477,1741,40809,81421,2,96,2,43231.40,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5311,7477,1741,40809,81421,2,67,2,9078.60,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5312,7477,1741,40809,81421,2,13,1,52310.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5313,7477,1742,40809,81421,2,96,1,8289.26,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5314,7477,1742,40809,81421,2,68,1,1740.74,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL);
INSERT INTO `balance_libro_details` VALUES (5315,7477,1742,40809,81421,2,13,2,10030.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5316,7477,1743,40809,81421,2,96,2,1165.29,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5317,7477,1743,40809,81421,2,67,2,244.71,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5318,7477,1743,40809,81421,2,13,1,1410.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5319,7477,1744,40809,81421,2,96,2,25866.94,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5320,7477,1744,40809,81421,2,67,2,5432.06,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5321,7477,1744,40809,81421,2,13,1,31299.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5322,7477,1745,40809,81421,2,96,2,28857.85,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5323,7477,1745,40809,81421,2,67,2,6060.15,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5324,7477,1745,40809,81421,2,13,1,34918.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5325,7477,1746,40809,81421,2,96,2,14478.51,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5326,7477,1746,40809,81421,2,67,2,3040.49,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5327,7477,1746,40809,81421,2,13,1,17519.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5328,7477,1747,40809,81421,2,96,2,4572.73,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5329,7477,1747,40809,81421,2,67,2,960.27,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5330,7477,1747,40809,81421,2,13,1,5533.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5331,7477,1748,40809,81421,2,96,2,11148.76,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5332,7477,1748,40809,81421,2,67,2,2341.24,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5333,7477,1748,40809,81421,2,13,1,13490.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5334,7477,1749,40809,81421,2,96,2,1408.26,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5335,7477,1749,40809,81421,2,67,2,295.74,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5336,7477,1749,40809,81421,2,13,1,1704.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5337,7477,1750,40809,81421,2,96,2,20660.33,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5338,7477,1750,40809,81421,2,67,2,4338.67,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5339,7477,1750,40809,81421,2,13,1,24999.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5340,7477,1751,40809,81421,2,96,2,22760.33,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5341,7477,1751,40809,81421,2,67,2,4779.67,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5342,7477,1751,40809,81421,2,13,1,27540.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5343,7477,1752,40809,81421,2,96,2,2041.32,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5344,7477,1752,40809,81421,2,67,2,428.68,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5345,7477,1752,40809,81421,2,13,1,2470.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5346,7477,1753,40809,81421,2,96,2,6128.93,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5347,7477,1753,40809,81421,2,67,2,1287.07,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5348,7477,1753,40809,81421,2,13,1,7416.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5349,7477,1754,40809,81421,2,96,2,580.96,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5350,7477,1754,40809,81421,2,67,2,122.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5351,7477,1754,40809,81421,2,218,2,0.04,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5352,7477,1754,40809,81421,2,13,1,703.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5353,7477,1755,40809,81421,2,96,2,6317.36,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5354,7477,1755,40809,81421,2,67,2,1326.64,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL);
INSERT INTO `balance_libro_details` VALUES (5355,7477,1755,40809,81421,2,13,1,7644.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5356,7477,1756,40809,81421,2,96,2,6776.86,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5357,7477,1756,40809,81421,2,67,2,1423.14,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5358,7477,1756,40809,81421,2,13,1,8200.00,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5359,7477,1757,40809,81421,2,96,2,14710.74,NULL,'2022-08-13 11:51:47','2022-08-13 11:51:47',NULL),(5360,7477,1757,40809,81421,2,67,2,3089.26,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5361,7477,1757,40809,81421,2,13,1,17800.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5362,7477,1758,40809,81421,2,96,2,7685.95,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5363,7477,1758,40809,81421,2,67,2,1614.05,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5364,7477,1758,40809,81421,2,13,1,9300.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5365,7477,1759,40809,81421,2,96,2,13636.36,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5366,7477,1759,40809,81421,2,67,2,2863.64,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5367,7477,1759,40809,81421,2,13,1,16500.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5368,7477,1760,40809,81421,2,96,2,177892.56,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5369,7477,1760,40809,81421,2,67,2,37357.44,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5370,7477,1760,40809,81421,2,13,1,215250.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5371,7477,1761,40809,81421,2,96,2,1239.67,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5372,7477,1761,40809,81421,2,67,2,260.33,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5373,7477,1761,40809,81421,2,13,1,1500.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5374,7477,1762,40809,81421,2,96,2,123.97,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5375,7477,1762,40809,81421,2,67,2,26.03,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5376,7477,1762,40809,81421,2,13,1,150.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5377,7477,1763,40809,81421,2,96,2,6446.28,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5378,7477,1763,40809,81421,2,67,2,1353.72,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5379,7477,1763,40809,81421,2,13,1,7800.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5380,7477,1764,40809,81421,2,96,2,9090.91,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5381,7477,1764,40809,81421,2,67,2,1909.09,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5382,7477,1764,40809,81421,2,13,1,11000.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5383,7477,1765,40809,81421,2,96,2,17095.04,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5384,7477,1765,40809,81421,2,67,2,3589.96,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5385,7477,1765,40809,81421,2,13,1,20685.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5386,7477,1766,40809,81421,2,96,2,105361.16,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5387,7477,1766,40809,81421,2,67,2,22125.84,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5388,7477,1766,40809,81421,2,13,1,127487.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5389,7477,1767,40809,81421,2,96,1,177892.56,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5390,7477,1767,40809,81421,2,68,1,37357.44,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5391,7477,1767,40809,81421,2,13,2,215250.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5392,7477,1768,40809,81421,2,96,2,2314.05,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5393,7477,1768,40809,81421,2,67,2,485.95,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5394,7477,1768,40809,81421,2,13,1,2800.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL);
INSERT INTO `balance_libro_details` VALUES (5395,7477,1769,40809,81421,2,96,2,1555.37,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5396,7477,1769,40809,81421,2,67,2,326.63,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5397,7477,1769,40809,81421,2,13,1,1882.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5398,7477,1770,40809,81421,2,96,2,9752.07,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5399,7477,1770,40809,81421,2,67,2,2047.93,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5400,7477,1770,40809,81421,2,13,1,11800.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5401,7477,1771,40809,81421,2,96,2,14256.20,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5402,7477,1771,40809,81421,2,67,2,2993.80,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5403,7477,1771,40809,81421,2,13,1,17250.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5404,7477,1772,40809,81421,2,96,2,1918.18,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5405,7477,1772,40809,81421,2,67,2,402.82,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5406,7477,1772,40809,81421,2,13,1,2321.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5407,7477,1773,40809,81421,2,96,2,20661.16,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5408,7477,1773,40809,81421,2,67,2,4338.84,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5409,7477,1773,40809,81421,2,13,1,25000.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5410,7477,1774,40809,81421,2,96,2,495.87,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5411,7477,1774,40809,81421,2,67,2,104.13,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5412,7477,1774,40809,81421,2,13,1,600.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5413,7477,1775,40809,81421,2,96,2,6996.69,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5414,7477,1775,40809,81421,2,67,2,1469.31,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5415,7477,1775,40809,81421,2,13,1,8466.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5416,7477,1776,40809,81421,2,96,2,18512.40,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5417,7477,1776,40809,81421,2,67,2,3887.60,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5418,7477,1776,40809,81421,2,13,1,22400.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5419,7477,1777,40809,81421,2,96,2,2047.93,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5420,7477,1777,40809,81421,2,67,2,430.07,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5421,7477,1777,40809,81421,2,13,1,2478.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5422,7477,1778,40809,81421,2,96,2,661.16,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5423,7477,1778,40809,81421,2,67,2,138.84,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5424,7477,1778,40809,81421,2,13,1,800.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5425,7477,1779,40809,81421,2,96,1,1785.12,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5426,7477,1779,40809,81421,2,68,1,374.88,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5427,7477,1779,40809,81421,2,13,2,2160.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5428,7477,1780,40809,81421,2,96,1,12314.05,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5429,7477,1780,40809,81421,2,68,1,2585.95,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5430,7477,1780,40809,81421,2,13,2,14900.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5431,7477,1781,40809,81421,2,96,1,8181.82,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5432,7477,1781,40809,81421,2,68,1,1718.18,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5433,7477,1781,40809,81421,2,13,2,9900.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5434,7477,1782,40809,81421,2,96,1,11487.60,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL);
INSERT INTO `balance_libro_details` VALUES (5435,7477,1782,40809,81421,2,68,1,2412.40,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5436,7477,1782,40809,81421,2,13,2,13900.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5437,7477,1783,40809,81421,2,96,1,2479.34,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5438,7477,1783,40809,81421,2,68,1,520.66,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5439,7477,1783,40809,81421,2,13,2,3000.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5440,7477,1784,40809,81421,2,96,1,1764.46,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5441,7477,1784,40809,81421,2,68,1,370.54,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5442,7477,1784,40809,81421,2,13,2,2135.00,NULL,'2022-08-13 11:51:48','2022-08-13 11:51:48',NULL),(5443,7477,1785,40809,81421,2,96,1,3755.37,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5444,7477,1785,40809,81421,2,68,1,788.63,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5445,7477,1785,40809,81421,2,13,2,4544.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5446,7477,1786,40809,81421,2,96,2,1983.47,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5447,7477,1786,40809,81421,2,67,2,416.53,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5448,7477,1786,40809,81421,2,13,1,2400.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5449,7477,1787,40809,81421,2,96,2,2023.14,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5450,7477,1787,40809,81421,2,67,2,424.86,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5451,7477,1787,40809,81421,2,13,1,2448.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5452,7477,1788,40809,81421,2,96,2,1799.17,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5453,7477,1788,40809,81421,2,67,2,377.83,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5454,7477,1788,40809,81421,2,13,1,2177.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5455,7477,1789,40809,81421,2,96,2,11157.02,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5456,7477,1789,40809,81421,2,67,2,2342.98,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5457,7477,1789,40809,81421,2,13,1,13500.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5458,7477,1790,40809,81421,2,96,2,61983.47,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5459,7477,1790,40809,81421,2,67,2,13016.53,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5460,7477,1790,40809,81421,2,13,1,75000.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5461,7477,1791,40809,81421,2,96,2,6585.95,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5462,7477,1791,40809,81421,2,67,2,1383.05,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5463,7477,1791,40809,81421,2,13,1,7969.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5464,7477,1792,40809,81421,2,96,2,16115.70,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5465,7477,1792,40809,81421,2,67,2,3384.30,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5466,7477,1792,40809,81421,2,13,1,19500.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5467,7477,1793,40809,81421,2,96,2,1119.83,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5468,7477,1793,40809,81421,2,67,2,235.17,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5469,7477,1793,40809,81421,2,13,1,1355.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5470,7477,1794,40809,81421,2,96,2,157966.94,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5471,7477,1794,40809,81421,2,67,2,33173.06,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5472,7477,1794,40809,81421,2,13,1,191140.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5473,7477,1795,40809,81421,2,96,2,131483.47,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5474,7477,1795,40809,81421,2,67,2,27611.53,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL);
INSERT INTO `balance_libro_details` VALUES (5475,7477,1795,40809,81421,2,13,1,159095.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5476,7477,1796,40809,81421,2,96,2,1027.27,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5477,7477,1796,40809,81421,2,67,2,215.73,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5478,7477,1796,40809,81421,2,13,1,1243.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5479,7477,1797,40809,81421,2,96,2,20671.07,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5480,7477,1797,40809,81421,2,67,2,4340.93,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5481,7477,1797,40809,81421,2,13,1,25012.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5482,7477,1798,40809,81421,2,96,1,157966.94,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5483,7477,1798,40809,81421,2,68,1,33173.06,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5484,7477,1798,40809,81421,2,13,2,191140.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5485,7477,1799,40809,81421,2,96,2,18595.04,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5486,7477,1799,40809,81421,2,67,2,3904.96,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5487,7477,1799,40809,81421,2,13,1,22500.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5488,7477,1800,40809,81421,2,96,2,21322.31,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5489,7477,1800,40809,81421,2,67,2,4477.69,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5490,7477,1800,40809,81421,2,13,1,25800.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5491,7477,1801,40809,81421,2,96,2,17545.45,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5492,7477,1801,40809,81421,2,67,2,3684.55,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5493,7477,1801,40809,81421,2,13,1,21230.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5494,7477,1802,40809,81421,2,96,2,11156.20,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5495,7477,1802,40809,81421,2,67,2,2342.80,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5496,7477,1802,40809,81421,2,13,1,13499.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5497,7477,1803,40809,81421,2,96,2,1302.48,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5498,7477,1803,40809,81421,2,67,2,273.52,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5499,7477,1803,40809,81421,2,13,1,1576.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5500,7477,1804,40809,81421,2,96,2,58776.98,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5501,7477,1804,40809,81421,2,67,2,12343.16,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5502,7477,1804,40809,81421,2,13,1,71120.14,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5503,7477,1805,40809,81421,2,218,2,0.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5504,7477,1805,40809,81421,2,13,1,0.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5505,7477,1806,40809,81421,2,96,2,12231.40,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5506,7477,1806,40809,81421,2,67,2,2568.60,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5507,7477,1806,40809,81421,2,13,1,14800.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5508,7477,1807,40809,81421,2,96,2,1198.35,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5509,7477,1807,40809,81421,2,67,2,251.65,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5510,7477,1807,40809,81421,2,13,1,1450.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5511,7477,1808,40809,81421,2,96,2,279.34,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5512,7477,1808,40809,81421,2,67,2,58.66,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5513,7477,1808,40809,81421,2,13,1,338.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5514,7477,1809,40809,81421,2,96,2,8264.46,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL);
INSERT INTO `balance_libro_details` VALUES (5515,7477,1809,40809,81421,2,67,2,1735.54,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5516,7477,1809,40809,81421,2,13,1,10000.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5517,7477,1810,40809,81421,2,96,2,29774.38,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5518,7477,1810,40809,81421,2,67,2,6252.62,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5519,7477,1810,40809,81421,2,13,1,36027.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5520,7477,1811,40809,81421,2,96,2,165.29,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5521,7477,1811,40809,81421,2,67,2,34.71,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5522,7477,1811,40809,81421,2,13,1,200.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5523,7477,1812,40809,81421,2,96,2,17107.44,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5524,7477,1812,40809,81421,2,67,2,3592.56,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5525,7477,1812,40809,81421,2,13,1,20700.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5526,7477,1813,40809,81421,2,96,2,26203.31,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5527,7477,1813,40809,81421,2,67,2,5502.69,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5528,7477,1813,40809,81421,2,13,1,31706.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5529,7477,1814,40809,81421,2,96,2,4661.98,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5530,7477,1814,40809,81421,2,67,2,979.02,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5531,7477,1814,40809,81421,2,13,1,5641.00,NULL,'2022-08-13 11:51:49','2022-08-13 11:51:49',NULL),(5532,7477,1815,40809,81421,2,96,2,19680.17,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5533,7477,1815,40809,81421,2,67,2,4132.83,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5534,7477,1815,40809,81421,2,13,1,23813.00,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5535,7477,1816,40809,81421,2,96,2,20661.16,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5536,7477,1816,40809,81421,2,67,2,4338.84,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5537,7477,1816,40809,81421,2,13,1,25000.00,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5538,7477,1817,40809,81421,2,96,2,207.44,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5539,7477,1817,40809,81421,2,67,2,43.56,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5540,7477,1817,40809,81421,2,13,1,251.00,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5541,7477,1818,40809,81421,2,96,2,2390.91,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5542,7477,1818,40809,81421,2,67,2,502.09,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5543,7477,1818,40809,81421,2,13,1,2893.00,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5544,7477,1819,40809,81421,2,96,2,581.82,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5545,7477,1819,40809,81421,2,67,2,122.18,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5546,7477,1819,40809,81421,2,13,1,704.00,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5547,7477,1820,40809,81421,2,96,2,28512.40,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5548,7477,1820,40809,81421,2,67,2,5987.60,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5549,7477,1820,40809,81421,2,13,1,34500.00,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5550,7477,1821,40809,81421,2,96,2,23059.50,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5551,7477,1821,40809,81421,2,67,2,4842.50,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5552,7477,1821,40809,81421,2,13,1,27902.00,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5553,7477,1822,40809,81421,2,96,2,3217.36,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5554,7477,1822,40809,81421,2,67,2,675.64,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL);
INSERT INTO `balance_libro_details` VALUES (5555,7477,1822,40809,81421,2,13,1,3893.00,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5556,7477,1823,40809,81421,2,96,2,2230.58,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5557,7477,1823,40809,81421,2,67,2,468.42,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5558,7477,1823,40809,81421,2,13,1,2699.00,NULL,'2022-08-13 11:51:50','2022-08-13 11:51:50',NULL),(5559,7478,1824,41722,82978,2,96,2,52440.00,NULL,'2022-08-16 13:43:49','2022-08-16 13:43:49',NULL),(5560,7478,1824,41722,82978,2,67,2,11012.40,NULL,'2022-08-16 13:43:49','2022-08-16 13:43:49',NULL),(5561,7478,1824,41722,82978,2,13,1,63452.40,NULL,'2022-08-16 13:43:49','2022-08-16 13:43:49',NULL),(5562,7478,1825,41722,82978,2,96,2,52440.00,NULL,'2022-08-16 13:43:49','2022-08-16 13:43:49',NULL),(5563,7478,1825,41722,82978,2,67,2,11012.40,NULL,'2022-08-16 13:43:49','2022-08-16 13:43:49',NULL),(5564,7478,1825,41722,82978,2,13,1,63452.40,NULL,'2022-08-16 13:43:49','2022-08-16 13:43:49',NULL),(5565,7478,1826,41722,82978,2,96,2,52440.00,NULL,'2022-08-16 13:43:49','2022-08-16 13:43:49',NULL),(5566,7478,1826,41722,82978,2,67,2,11012.40,NULL,'2022-08-16 13:43:49','2022-08-16 13:43:49',NULL),(5567,7478,1826,41722,82978,2,13,1,63452.40,NULL,'2022-08-16 13:43:49','2022-08-16 13:43:49',NULL),(5568,7478,1827,41722,82978,2,96,2,12686.42,NULL,'2022-08-16 13:43:49','2022-08-16 13:43:49',NULL),(5569,7478,1827,41722,82978,2,67,2,2664.15,NULL,'2022-08-16 13:43:49','2022-08-16 13:43:49',NULL),(5570,7478,1827,41722,82978,2,13,1,15350.57,NULL,'2022-08-16 13:43:49','2022-08-16 13:43:49',NULL),(5571,7478,1828,41722,82978,2,96,2,10484.61,NULL,'2022-08-16 13:43:50','2022-08-16 13:43:50',NULL),(5572,7478,1828,41722,82978,2,67,2,2201.77,NULL,'2022-08-16 13:43:50','2022-08-16 13:43:50',NULL),(5573,7478,1828,41722,82978,2,13,1,12686.38,NULL,'2022-08-16 13:43:50','2022-08-16 13:43:50',NULL),(5574,7478,1829,41722,82978,2,96,1,12686.42,NULL,'2022-08-16 13:43:50','2022-08-16 13:43:50',NULL),(5575,7478,1829,41722,82978,2,68,1,2664.15,NULL,'2022-08-16 13:43:50','2022-08-16 13:43:50',NULL),(5576,7478,1829,41722,82978,2,13,2,15350.57,NULL,'2022-08-16 13:43:50','2022-08-16 13:43:50',NULL),(5577,7478,1830,41776,158328,2,96,2,30578.51,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5578,7478,1830,41776,158328,2,67,2,6421.49,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5579,7478,1830,41776,158328,2,13,1,37000.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5580,7478,1831,41776,158328,2,96,2,20247.93,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5581,7478,1831,41776,158328,2,67,2,4252.07,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5582,7478,1831,41776,158328,2,13,1,24500.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5583,7478,1832,41776,158328,2,96,2,12247.93,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5584,7478,1832,41776,158328,2,67,2,2572.07,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5585,7478,1832,41776,158328,2,13,1,14820.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5586,7478,1833,41776,158328,2,96,2,4586.78,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5587,7478,1833,41776,158328,2,67,2,963.22,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5588,7478,1833,41776,158328,2,13,1,5550.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5589,7478,1834,41776,158328,2,96,2,6322.32,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5590,7478,1834,41776,158328,2,67,2,1327.68,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5591,7478,1834,41776,158328,2,13,1,7650.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56');
INSERT INTO `balance_libro_details` VALUES (5592,7478,1835,41776,158328,2,96,2,19834.71,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5593,7478,1835,41776,158328,2,67,2,4165.29,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5594,7478,1835,41776,158328,2,13,1,24000.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5595,7478,1836,41776,158328,2,96,2,19338.84,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5596,7478,1836,41776,158328,2,67,2,4061.16,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5597,7478,1836,41776,158328,2,13,1,23400.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5598,7478,1837,41776,158328,2,96,2,14619.83,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5599,7478,1837,41776,158328,2,67,2,3070.17,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5600,7478,1837,41776,158328,2,13,1,17690.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5601,7478,1838,41776,158328,2,96,2,0.83,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5602,7478,1838,41776,158328,2,67,2,0.17,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5603,7478,1838,41776,158328,2,13,1,1.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5604,7478,1839,41776,158328,2,96,2,0.83,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5605,7478,1839,41776,158328,2,67,2,0.17,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5606,7478,1839,41776,158328,2,13,1,1.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5607,7478,1840,41776,158328,2,96,1,15173.47,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5608,7478,1840,41776,158328,2,68,1,2516.53,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5609,7478,1840,41776,158328,2,13,2,17690.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5610,7478,1841,41776,158328,2,96,2,14049.59,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5611,7478,1841,41776,158328,2,67,2,2950.41,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5612,7478,1841,41776,158328,2,13,1,17000.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5613,7478,1842,41776,158328,2,96,2,22128.10,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5614,7478,1842,41776,158328,2,67,2,4646.90,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5615,7478,1842,41776,158328,2,13,1,26775.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5616,7478,1843,41776,158328,2,96,2,5950.41,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5617,7478,1843,41776,158328,2,67,2,1249.59,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5618,7478,1843,41776,158328,2,13,1,7200.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5619,7478,1844,41776,158328,2,96,2,4008.28,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5620,7478,1844,41776,158328,2,67,2,841.72,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5621,7478,1844,41776,158328,2,13,1,4850.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5622,7478,1845,41776,158328,2,96,2,16115.70,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5623,7478,1845,41776,158328,2,67,2,3384.30,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5624,7478,1845,41776,158328,2,13,1,19500.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5625,7478,1846,41776,158328,2,96,2,17933.88,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56');
INSERT INTO `balance_libro_details` VALUES (5626,7478,1846,41776,158328,2,67,2,3766.12,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5627,7478,1846,41776,158328,2,13,1,21700.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5628,7478,1847,41776,158328,2,96,2,32727.27,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5629,7478,1847,41776,158328,2,67,2,6872.73,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5630,7478,1847,41776,158328,2,13,1,39600.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5631,7478,1848,41776,158328,2,96,2,7727.27,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5632,7478,1848,41776,158328,2,67,2,1622.73,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5633,7478,1848,41776,158328,2,13,1,9350.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5634,7478,1849,41776,158328,2,96,2,4338.85,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5635,7478,1849,41776,158328,2,67,2,911.15,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5636,7478,1849,41776,158328,2,13,1,5250.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5637,7478,1850,41776,158328,2,96,2,12809.92,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5638,7478,1850,41776,158328,2,67,2,2690.08,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5639,7478,1850,41776,158328,2,13,1,15500.00,NULL,'2022-08-16 19:58:03','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5640,7478,1851,41776,158328,2,96,2,54545.45,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5641,7478,1851,41776,158328,2,67,2,11454.55,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5642,7478,1851,41776,158328,2,13,1,66000.00,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5643,7478,1852,41776,158328,2,96,2,14616.53,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5644,7478,1852,41776,158328,2,67,2,3069.47,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5645,7478,1852,41776,158328,2,13,1,17686.00,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5646,7478,1853,41776,158328,2,96,2,18909.09,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5647,7478,1853,41776,158328,2,67,2,3970.91,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5648,7478,1853,41776,158328,2,13,1,22880.00,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5649,7478,1854,41776,158328,2,96,2,17512.40,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5650,7478,1854,41776,158328,2,67,2,3677.60,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5651,7478,1854,41776,158328,2,13,1,21190.00,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5652,7478,1855,41776,158328,2,96,2,3438.02,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5653,7478,1855,41776,158328,2,67,2,721.98,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5654,7478,1855,41776,158328,2,13,1,4160.00,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5655,7478,1856,41776,158328,2,96,2,5917.35,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5656,7478,1856,41776,158328,2,67,2,1242.65,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5657,7478,1856,41776,158328,2,13,1,7160.00,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5658,7478,1857,41776,158328,2,96,2,37109.09,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5659,7478,1857,41776,158328,2,67,2,7792.91,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56');
INSERT INTO `balance_libro_details` VALUES (5660,7478,1857,41776,158328,2,13,1,44902.00,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5661,7478,1858,41776,158328,2,96,2,27709.09,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5662,7478,1858,41776,158328,2,67,2,5818.91,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5663,7478,1858,41776,158328,2,13,1,33528.00,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5664,7478,1859,41776,158328,2,96,2,10330.58,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5665,7478,1859,41776,158328,2,67,2,2169.42,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5666,7478,1859,41776,158328,2,13,1,12500.00,NULL,'2022-08-16 19:58:04','2022-08-16 20:04:56','2022-08-16 20:04:56'),(5667,7478,1860,41776,158328,3,217,1,41322.32,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5668,7478,1860,41776,158328,3,68,1,8677.69,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5669,7478,1860,41776,158328,3,57,2,50000.01,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5670,7478,1861,41776,158328,3,217,1,178.51,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5671,7478,1861,41776,158328,3,68,1,37.49,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5672,7478,1861,41776,158328,3,217,1,6.43,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5673,7478,1861,41776,158328,3,57,2,222.43,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5674,7478,1862,41776,158328,3,250,1,0.00,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5675,7478,1862,41776,158328,3,57,2,0.00,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5676,7478,1863,41776,158328,3,217,1,16583.47,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5677,7478,1863,41776,158328,3,68,1,3482.53,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5678,7478,1863,41776,158328,3,57,2,20066.00,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5679,7478,1864,41776,158328,3,217,2,16583.47,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5680,7478,1864,41776,158328,3,67,2,3482.53,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5681,7478,1864,41776,158328,3,57,1,20066.00,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5682,7478,1865,41776,158328,3,217,1,70632.81,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5683,7478,1865,41776,158328,3,68,1,14832.89,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5684,7478,1865,41776,158328,3,217,1,0.01,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5685,7478,1865,41776,158328,3,57,2,85465.71,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5686,7478,1866,41776,158328,3,217,1,16583.47,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5687,7478,1866,41776,158328,3,68,1,3482.53,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5688,7478,1866,41776,158328,3,57,2,20066.00,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5689,7478,1867,41776,158328,3,217,1,48211.94,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5690,7478,1867,41776,158328,3,68,1,10124.51,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5691,7478,1867,41776,158328,3,57,2,58336.45,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5692,7478,1868,41776,158328,3,217,1,123876.03,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5693,7478,1868,41776,158328,3,68,1,26013.97,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09');
INSERT INTO `balance_libro_details` VALUES (5694,7478,1868,41776,158328,3,57,2,149890.00,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5695,7478,1869,41776,158328,3,217,1,123967.00,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5696,7478,1869,41776,158328,3,68,1,26033.07,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5697,7478,1869,41776,158328,3,57,2,150000.07,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5698,7478,1870,41776,158328,3,217,1,6470.33,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5699,7478,1870,41776,158328,3,68,1,1358.77,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5700,7478,1870,41776,158328,3,57,2,7829.10,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5701,7478,1871,41776,158328,3,217,1,8166.60,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5702,7478,1871,41776,158328,3,68,1,1714.99,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5703,7478,1871,41776,158328,3,57,2,9881.59,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5704,7478,1872,41776,158328,3,217,1,37761.03,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5705,7478,1872,41776,158328,3,68,1,7929.82,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5706,7478,1872,41776,158328,3,217,1,-0.01,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5707,7478,1872,41776,158328,3,57,2,45690.84,NULL,'2022-08-16 19:58:51','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5708,7478,1873,41776,158328,3,250,1,0.00,NULL,'2022-08-16 19:58:52','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5709,7478,1873,41776,158328,3,57,2,0.00,NULL,'2022-08-16 19:58:52','2022-08-16 20:05:09','2022-08-16 20:05:09'),(5710,7478,1874,41776,158328,2,96,2,30578.51,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5711,7478,1874,41776,158328,2,67,2,6421.49,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5712,7478,1874,41776,158328,2,13,1,37000.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5713,7478,1875,41776,158328,2,96,2,20247.93,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5714,7478,1875,41776,158328,2,67,2,4252.07,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5715,7478,1875,41776,158328,2,13,1,24500.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5716,7478,1876,41776,158328,2,96,2,12247.93,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5717,7478,1876,41776,158328,2,67,2,2572.07,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5718,7478,1876,41776,158328,2,13,1,14820.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5719,7478,1877,41776,158328,2,96,2,4586.78,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5720,7478,1877,41776,158328,2,67,2,963.22,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5721,7478,1877,41776,158328,2,13,1,5550.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5722,7478,1878,41776,158328,2,96,2,6322.32,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5723,7478,1878,41776,158328,2,67,2,1327.68,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5724,7478,1878,41776,158328,2,13,1,7650.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5725,7478,1879,41776,158328,2,96,2,19834.71,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5726,7478,1879,41776,158328,2,67,2,4165.29,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5727,7478,1879,41776,158328,2,13,1,24000.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5728,7478,1880,41776,158328,2,96,2,19338.84,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5729,7478,1880,41776,158328,2,67,2,4061.16,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5730,7478,1880,41776,158328,2,13,1,23400.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL);
INSERT INTO `balance_libro_details` VALUES (5731,7478,1881,41776,158328,2,96,2,14619.83,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5732,7478,1881,41776,158328,2,67,2,3070.17,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5733,7478,1881,41776,158328,2,13,1,17690.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5734,7478,1882,41776,158328,2,96,2,0.83,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5735,7478,1882,41776,158328,2,67,2,0.17,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5736,7478,1882,41776,158328,2,13,1,1.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5737,7478,1883,41776,158328,2,96,2,0.83,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5738,7478,1883,41776,158328,2,67,2,0.17,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5739,7478,1883,41776,158328,2,13,1,1.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5740,7478,1884,41776,158328,2,96,1,15173.47,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5741,7478,1884,41776,158328,2,68,1,2516.53,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5742,7478,1884,41776,158328,2,13,2,17690.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5743,7478,1885,41776,158328,2,96,2,14049.59,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5744,7478,1885,41776,158328,2,67,2,2950.41,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5745,7478,1885,41776,158328,2,13,1,17000.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5746,7478,1886,41776,158328,2,96,2,22128.10,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5747,7478,1886,41776,158328,2,67,2,4646.90,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5748,7478,1886,41776,158328,2,13,1,26775.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5749,7478,1887,41776,158328,2,96,2,5950.41,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5750,7478,1887,41776,158328,2,67,2,1249.59,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5751,7478,1887,41776,158328,2,13,1,7200.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5752,7478,1888,41776,158328,2,96,2,4008.28,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5753,7478,1888,41776,158328,2,67,2,841.72,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5754,7478,1888,41776,158328,2,13,1,4850.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5755,7478,1889,41776,158328,2,96,2,16115.70,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5756,7478,1889,41776,158328,2,67,2,3384.30,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5757,7478,1889,41776,158328,2,13,1,19500.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5758,7478,1890,41776,158328,2,96,2,17933.88,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5759,7478,1890,41776,158328,2,67,2,3766.12,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5760,7478,1890,41776,158328,2,13,1,21700.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5761,7478,1891,41776,158328,2,96,2,32727.27,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5762,7478,1891,41776,158328,2,67,2,6872.73,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5763,7478,1891,41776,158328,2,13,1,39600.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5764,7478,1892,41776,158328,2,96,2,7727.27,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5765,7478,1892,41776,158328,2,67,2,1622.73,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5766,7478,1892,41776,158328,2,13,1,9350.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5767,7478,1893,41776,158328,2,96,2,4338.85,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5768,7478,1893,41776,158328,2,67,2,911.15,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5769,7478,1893,41776,158328,2,13,1,5250.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5770,7478,1894,41776,158328,2,96,2,12809.92,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL);
INSERT INTO `balance_libro_details` VALUES (5771,7478,1894,41776,158328,2,67,2,2690.08,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5772,7478,1894,41776,158328,2,13,1,15500.00,NULL,'2022-08-16 20:06:24','2022-08-16 20:06:24',NULL),(5773,7478,1895,41776,158328,2,96,2,54545.45,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5774,7478,1895,41776,158328,2,67,2,11454.55,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5775,7478,1895,41776,158328,2,13,1,66000.00,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5776,7478,1896,41776,158328,2,96,2,14616.53,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5777,7478,1896,41776,158328,2,67,2,3069.47,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5778,7478,1896,41776,158328,2,13,1,17686.00,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5779,7478,1897,41776,158328,2,96,2,18909.09,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5780,7478,1897,41776,158328,2,67,2,3970.91,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5781,7478,1897,41776,158328,2,13,1,22880.00,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5782,7478,1898,41776,158328,2,96,2,17512.40,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5783,7478,1898,41776,158328,2,67,2,3677.60,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5784,7478,1898,41776,158328,2,13,1,21190.00,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5785,7478,1899,41776,158328,2,96,2,3438.02,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5786,7478,1899,41776,158328,2,67,2,721.98,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5787,7478,1899,41776,158328,2,13,1,4160.00,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5788,7478,1900,41776,158328,2,96,2,5917.35,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5789,7478,1900,41776,158328,2,67,2,1242.65,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5790,7478,1900,41776,158328,2,13,1,7160.00,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5791,7478,1901,41776,158328,2,96,2,37109.09,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5792,7478,1901,41776,158328,2,67,2,7792.91,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5793,7478,1901,41776,158328,2,13,1,44902.00,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5794,7478,1902,41776,158328,2,96,2,27709.09,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5795,7478,1902,41776,158328,2,67,2,5818.91,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5796,7478,1902,41776,158328,2,13,1,33528.00,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5797,7478,1903,41776,158328,2,96,2,10330.58,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5798,7478,1903,41776,158328,2,67,2,2169.42,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5799,7478,1903,41776,158328,2,13,1,12500.00,NULL,'2022-08-16 20:06:25','2022-08-16 20:06:25',NULL),(5800,7478,1904,41776,158328,3,217,1,41322.32,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5801,7478,1904,41776,158328,3,68,1,8677.69,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5802,7478,1904,41776,158328,3,57,2,50000.01,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5803,7478,1905,41776,158328,3,217,1,178.51,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5804,7478,1905,41776,158328,3,68,1,37.49,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5805,7478,1905,41776,158328,3,217,1,6.43,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5806,7478,1905,41776,158328,3,57,2,222.43,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5807,7478,1906,41776,158328,3,250,1,0.00,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5808,7478,1906,41776,158328,3,57,2,0.00,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5809,7478,1907,41776,158328,3,217,1,16583.47,NULL,'2022-08-16 20:06:35','2022-08-16 20:22:44','2022-08-16 20:22:44'),(5810,7478,1907,41776,158328,3,68,1,3482.53,NULL,'2022-08-16 20:06:35','2022-08-16 20:22:44','2022-08-16 20:22:44');
INSERT INTO `balance_libro_details` VALUES (5811,7478,1907,41776,158328,3,57,2,20066.00,NULL,'2022-08-16 20:06:35','2022-08-16 20:22:44','2022-08-16 20:22:44'),(5812,7478,1908,41776,158328,3,217,2,16583.47,NULL,'2022-08-16 20:06:35','2022-08-16 20:30:23','2022-08-16 20:30:23'),(5813,7478,1908,41776,158328,3,67,2,3482.53,NULL,'2022-08-16 20:06:35','2022-08-16 20:30:23','2022-08-16 20:30:23'),(5814,7478,1908,41776,158328,3,57,1,20066.00,NULL,'2022-08-16 20:06:35','2022-08-16 20:30:23','2022-08-16 20:30:23'),(5815,7478,1909,41776,158328,3,217,1,70632.81,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5816,7478,1909,41776,158328,3,68,1,14832.89,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5817,7478,1909,41776,158328,3,217,1,0.01,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5818,7478,1909,41776,158328,3,57,2,85465.71,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5819,7478,1910,41776,158328,3,217,1,16583.47,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5820,7478,1910,41776,158328,3,68,1,3482.53,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5821,7478,1910,41776,158328,3,57,2,20066.00,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5822,7478,1911,41776,158328,3,217,1,48211.94,NULL,'2022-08-16 20:06:35','2022-08-16 20:24:02','2022-08-16 20:24:02'),(5823,7478,1911,41776,158328,3,68,1,10124.51,NULL,'2022-08-16 20:06:35','2022-08-16 20:24:02','2022-08-16 20:24:02'),(5824,7478,1911,41776,158328,3,57,2,58336.45,NULL,'2022-08-16 20:06:35','2022-08-16 20:24:02','2022-08-16 20:24:02'),(5825,7478,1912,41776,158328,3,217,1,123876.03,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5826,7478,1912,41776,158328,3,68,1,26013.97,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5827,7478,1912,41776,158328,3,57,2,149890.00,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5828,7478,1913,41776,158328,3,217,1,123967.00,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5829,7478,1913,41776,158328,3,68,1,26033.07,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5830,7478,1913,41776,158328,3,57,2,150000.07,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5831,7478,1914,41776,158328,3,217,1,6470.33,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5832,7478,1914,41776,158328,3,68,1,1358.77,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5833,7478,1914,41776,158328,3,57,2,7829.10,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5834,7478,1915,41776,158328,3,217,1,8166.60,NULL,'2022-08-16 20:06:35','2022-08-16 20:23:12','2022-08-16 20:23:12'),(5835,7478,1915,41776,158328,3,68,1,1714.99,NULL,'2022-08-16 20:06:35','2022-08-16 20:23:12','2022-08-16 20:23:12'),(5836,7478,1915,41776,158328,3,57,2,9881.59,NULL,'2022-08-16 20:06:35','2022-08-16 20:23:12','2022-08-16 20:23:12'),(5837,7478,1916,41776,158328,3,217,1,37761.03,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5838,7478,1916,41776,158328,3,68,1,7929.82,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5839,7478,1916,41776,158328,3,217,1,-0.01,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5840,7478,1916,41776,158328,3,57,2,45690.84,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5841,7478,1917,41776,158328,3,250,1,0.00,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5842,7478,1917,41776,158328,3,57,2,0.00,NULL,'2022-08-16 20:06:35','2022-08-16 20:06:35',NULL),(5843,7478,1918,41776,158328,3,217,1,16583.47,NULL,'2022-08-16 20:22:44','2022-08-16 20:29:59','2022-08-16 20:29:59'),(5844,7478,1918,41776,158328,3,68,1,3482.53,NULL,'2022-08-16 20:22:44','2022-08-16 20:29:59','2022-08-16 20:29:59'),(5845,7478,1918,41776,158328,3,57,2,20066.00,NULL,'2022-08-16 20:22:44','2022-08-16 20:29:59','2022-08-16 20:29:59'),(5846,7478,1919,41776,158328,3,217,1,8166.60,NULL,'2022-08-16 20:23:12','2022-08-16 20:23:48','2022-08-16 20:23:48'),(5847,7478,1919,41776,158328,3,68,1,1714.99,NULL,'2022-08-16 20:23:12','2022-08-16 20:23:48','2022-08-16 20:23:48');
INSERT INTO `balance_libro_details` VALUES (5848,7478,1919,41776,158328,3,57,2,9881.59,NULL,'2022-08-16 20:23:12','2022-08-16 20:23:48','2022-08-16 20:23:48'),(5849,7478,1920,41776,158328,3,217,1,8166.60,NULL,'2022-08-16 20:23:48','2022-08-16 20:28:37','2022-08-16 20:28:37'),(5850,7478,1920,41776,158328,3,68,1,1714.99,NULL,'2022-08-16 20:23:48','2022-08-16 20:28:37','2022-08-16 20:28:37'),(5851,7478,1920,41776,158328,3,57,2,9881.59,NULL,'2022-08-16 20:23:48','2022-08-16 20:28:37','2022-08-16 20:28:37'),(5852,7478,1921,41776,158328,3,217,1,48211.94,NULL,'2022-08-16 20:24:02','2022-08-16 20:29:00','2022-08-16 20:29:00'),(5853,7478,1921,41776,158328,3,68,1,10124.51,NULL,'2022-08-16 20:24:02','2022-08-16 20:29:00','2022-08-16 20:29:00'),(5854,7478,1921,41776,158328,3,57,2,58336.45,NULL,'2022-08-16 20:24:02','2022-08-16 20:29:00','2022-08-16 20:29:00'),(5855,7478,1922,41776,158328,3,217,1,9881.59,NULL,'2022-08-16 20:28:37','2022-08-16 20:28:37',NULL),(5856,7478,1922,41776,158328,3,57,2,9881.59,NULL,'2022-08-16 20:28:37','2022-08-16 20:28:37',NULL),(5857,7478,1923,41776,158328,3,217,1,58336.45,NULL,'2022-08-16 20:29:00','2022-08-16 20:29:00',NULL),(5858,7478,1923,41776,158328,3,57,2,58336.45,NULL,'2022-08-16 20:29:00','2022-08-16 20:29:00',NULL),(5859,7478,1924,41776,158328,3,217,1,20066.00,NULL,'2022-08-16 20:29:59','2022-08-16 20:29:59',NULL),(5860,7478,1924,41776,158328,3,57,2,20066.00,NULL,'2022-08-16 20:29:59','2022-08-16 20:29:59',NULL),(5861,7478,1925,41776,158328,3,217,2,20066.00,NULL,'2022-08-16 20:30:23','2022-08-16 20:30:23',NULL),(5862,7478,1925,41776,158328,3,57,1,20066.00,NULL,'2022-08-16 20:30:23','2022-08-16 20:30:23',NULL),(5863,7478,1926,41795,159835,3,250,1,4897.05,NULL,'2022-08-17 11:10:43','2022-08-17 11:15:36','2022-08-17 11:15:36'),(5864,7478,1926,41795,159835,3,57,2,4897.05,NULL,'2022-08-17 11:10:43','2022-08-17 11:15:36','2022-08-17 11:15:36'),(5865,7478,1927,41795,159835,3,217,1,3597.19,NULL,'2022-08-17 11:10:43','2022-08-17 11:10:43',NULL),(5866,7478,1927,41795,159835,3,68,1,755.41,NULL,'2022-08-17 11:10:43','2022-08-17 11:10:43',NULL),(5867,7478,1927,41795,159835,3,217,1,598.41,NULL,'2022-08-17 11:10:43','2022-08-17 11:10:43',NULL),(5868,7478,1927,41795,159835,3,57,2,4951.01,NULL,'2022-08-17 11:10:43','2022-08-17 11:10:43',NULL),(5869,7478,1928,41795,159835,3,217,1,140495.87,NULL,'2022-08-17 11:10:43','2022-08-17 11:10:43',NULL),(5870,7478,1928,41795,159835,3,68,1,29504.13,NULL,'2022-08-17 11:10:43','2022-08-17 11:10:43',NULL),(5871,7478,1928,41795,159835,3,57,2,170000.00,NULL,'2022-08-17 11:10:43','2022-08-17 11:10:43',NULL),(5872,7478,1929,41795,159835,3,217,1,61883.08,NULL,'2022-08-17 11:10:44','2022-08-17 11:19:09','2022-08-17 11:19:09'),(5873,7478,1929,41795,159835,3,68,1,6590.92,NULL,'2022-08-17 11:10:44','2022-08-17 11:19:09','2022-08-17 11:19:09'),(5874,7478,1929,41795,159835,3,57,2,68474.00,NULL,'2022-08-17 11:10:44','2022-08-17 11:19:09','2022-08-17 11:19:09'),(5875,7478,1930,41795,159835,3,217,1,125338.22,NULL,'2022-08-17 11:10:44','2022-08-17 11:18:36','2022-08-17 11:18:36'),(5876,7478,1930,41795,159835,3,68,1,14624.78,NULL,'2022-08-17 11:10:44','2022-08-17 11:18:36','2022-08-17 11:18:36'),(5877,7478,1930,41795,159835,3,57,2,139963.00,NULL,'2022-08-17 11:10:44','2022-08-17 11:18:36','2022-08-17 11:18:36'),(5878,7478,1931,41795,159835,3,217,1,3344.25,NULL,'2022-08-17 11:10:44','2022-08-17 11:10:44',NULL),(5879,7478,1931,41795,159835,3,68,1,702.29,NULL,'2022-08-17 11:10:44','2022-08-17 11:10:44',NULL),(5880,7478,1931,41795,159835,3,217,1,604.46,NULL,'2022-08-17 11:10:44','2022-08-17 11:10:44',NULL),(5881,7478,1931,41795,159835,3,57,2,4651.00,NULL,'2022-08-17 11:10:44','2022-08-17 11:10:44',NULL),(5882,7478,1932,41795,159835,3,217,1,13945.36,NULL,'2022-08-17 11:18:36','2022-08-17 11:18:36',NULL),(5883,7478,1932,41795,159835,3,68,1,2928.53,NULL,'2022-08-17 11:18:36','2022-08-17 11:18:36',NULL),(5884,7478,1932,41795,159835,3,217,1,111392.86,NULL,'2022-08-17 11:18:36','2022-08-17 11:18:36',NULL);
INSERT INTO `balance_libro_details` VALUES (5885,7478,1932,41795,159835,3,68,1,11696.25,NULL,'2022-08-17 11:18:36','2022-08-17 11:18:36',NULL),(5886,7478,1932,41795,159835,3,57,2,139963.00,NULL,'2022-08-17 11:18:36','2022-08-17 11:18:36',NULL),(5887,7478,1933,41795,159835,3,217,1,887.60,NULL,'2022-08-17 11:19:10','2022-08-17 11:19:10',NULL),(5888,7478,1933,41795,159835,3,68,1,186.40,NULL,'2022-08-17 11:19:10','2022-08-17 11:19:10',NULL),(5889,7478,1933,41795,159835,3,217,1,60995.48,NULL,'2022-08-17 11:19:10','2022-08-17 11:19:10',NULL),(5890,7478,1933,41795,159835,3,68,1,6404.53,NULL,'2022-08-17 11:19:10','2022-08-17 11:19:10',NULL),(5891,7478,1933,41795,159835,3,57,2,68474.01,NULL,'2022-08-17 11:19:10','2022-08-17 11:19:10',NULL),(5892,7478,1934,41798,161342,2,96,2,16528.93,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5893,7478,1934,41798,161342,2,67,2,3471.07,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5894,7478,1934,41798,161342,2,13,1,20000.00,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5895,7478,1935,41798,161342,2,96,2,17768.60,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5896,7478,1935,41798,161342,2,67,2,3731.40,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5897,7478,1935,41798,161342,2,13,1,21500.00,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5898,7478,1936,41798,161342,2,96,2,16528.93,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5899,7478,1936,41798,161342,2,67,2,3471.07,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5900,7478,1936,41798,161342,2,13,1,20000.00,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5901,7478,1937,41798,161342,2,96,2,15289.26,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5902,7478,1937,41798,161342,2,67,2,3210.74,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5903,7478,1937,41798,161342,2,13,1,18500.00,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5904,7478,1938,41798,161342,2,96,2,15702.48,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5905,7478,1938,41798,161342,2,67,2,3297.52,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5906,7478,1938,41798,161342,2,13,1,19000.00,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5907,7478,1939,41798,161342,2,96,2,14049.59,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5908,7478,1939,41798,161342,2,67,2,2950.41,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5909,7478,1939,41798,161342,2,13,1,17000.00,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5910,7478,1940,41798,161342,2,96,2,17768.60,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5911,7478,1940,41798,161342,2,67,2,3731.40,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5912,7478,1940,41798,161342,2,13,1,21500.00,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5913,7478,1941,41798,161342,2,96,2,15289.26,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5914,7478,1941,41798,161342,2,67,2,3210.74,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5915,7478,1941,41798,161342,2,13,1,18500.00,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5916,7478,1942,41798,161342,2,96,2,13057.85,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5917,7478,1942,41798,161342,2,67,2,2742.15,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5918,7478,1942,41798,161342,2,13,1,15800.00,NULL,'2022-08-17 13:10:40','2022-08-17 13:10:40',NULL),(5919,7478,1943,41798,161342,2,96,2,16115.70,NULL,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(5920,7478,1943,41798,161342,2,67,2,3384.30,NULL,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(5921,7478,1943,41798,161342,2,13,1,19500.00,NULL,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(5922,7478,1944,41798,161342,2,96,2,15454.55,NULL,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(5923,7478,1944,41798,161342,2,67,2,3245.45,NULL,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(5924,7478,1944,41798,161342,2,13,1,18700.00,NULL,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL);
INSERT INTO `balance_libro_details` VALUES (5925,7478,1945,41798,161342,2,96,2,14545.45,NULL,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(5926,7478,1945,41798,161342,2,67,2,3054.55,NULL,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(5927,7478,1945,41798,161342,2,13,1,17600.00,NULL,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(5928,7478,1946,41798,161342,2,96,2,17768.60,NULL,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(5929,7478,1946,41798,161342,2,67,2,3731.40,NULL,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(5930,7478,1946,41798,161342,2,13,1,21500.00,NULL,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(5931,7478,1947,41798,161342,2,96,2,11037.59,NULL,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(5932,7478,1947,41798,161342,2,67,2,2317.89,NULL,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(5933,7478,1947,41798,161342,2,13,1,13355.48,NULL,'2022-08-17 13:10:41','2022-08-17 13:10:41',NULL),(5934,7478,1948,41798,161342,3,217,1,723.63,NULL,'2022-08-17 13:23:25','2022-08-17 13:23:25',NULL),(5935,7478,1948,41798,161342,3,68,1,151.96,NULL,'2022-08-17 13:23:25','2022-08-17 13:23:25',NULL),(5936,7478,1948,41798,161342,3,57,2,875.59,NULL,'2022-08-17 13:23:25','2022-08-17 13:23:25',NULL),(5937,7478,1949,41798,161342,3,217,1,1735.54,NULL,'2022-08-17 13:23:26','2022-08-17 13:23:26',NULL),(5938,7478,1949,41798,161342,3,68,1,364.46,NULL,'2022-08-17 13:23:26','2022-08-17 13:23:26',NULL),(5939,7478,1949,41798,161342,3,57,2,2100.00,NULL,'2022-08-17 13:23:26','2022-08-17 13:23:26',NULL),(5940,7478,1950,41798,161342,15,67,1,45550.13,NULL,'2022-08-17 13:26:10','2022-08-17 13:26:10',NULL),(5941,7478,1950,41798,161342,15,68,2,516.43,NULL,'2022-08-17 13:26:10','2022-08-17 13:26:10',NULL),(5942,7478,1950,41798,161342,15,74,2,45033.71,NULL,'2022-08-17 13:26:10','2022-08-17 13:26:10',NULL),(5943,7478,1950,41798,161342,15,136,1,0.01,NULL,'2022-08-17 13:26:10','2022-08-17 13:26:10',NULL),(5944,7478,1951,41798,161342,16,156,1,5422.63,NULL,'2022-08-18 10:58:14','2022-08-18 10:58:14',NULL),(5945,7478,1951,41798,161342,16,344,2,5422.63,NULL,'2022-08-18 10:58:14','2022-08-18 10:58:14',NULL),(5946,7478,1952,41611,162849,2,96,2,41322.32,NULL,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(5947,7478,1952,41611,162849,2,67,2,8677.69,NULL,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(5948,7478,1952,41611,162849,2,13,1,50000.01,NULL,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(5949,7478,1953,41611,162849,2,96,2,13224.00,NULL,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(5950,7478,1953,41611,162849,2,67,2,2777.04,NULL,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(5951,7478,1953,41611,162849,2,13,1,16001.04,NULL,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(5952,7478,1954,41611,162849,2,96,2,123967.00,NULL,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(5953,7478,1954,41611,162849,2,67,2,26033.07,NULL,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(5954,7478,1954,41611,162849,2,13,1,150000.07,NULL,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(5955,7478,1955,41611,162849,2,96,2,57851.24,NULL,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(5956,7478,1955,41611,162849,2,67,2,12148.76,NULL,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(5957,7478,1955,41611,162849,2,13,1,70000.00,NULL,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(5958,7478,1956,41611,162849,2,96,2,206612.00,NULL,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(5959,7478,1956,41611,162849,2,67,2,43388.52,NULL,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(5960,7478,1956,41611,162849,2,13,1,250000.52,NULL,'2022-08-18 11:07:16','2022-08-18 11:07:16',NULL),(5961,7478,1957,41611,162849,3,217,1,41322.32,NULL,'2022-08-18 11:10:42','2022-08-18 11:13:20','2022-08-18 11:13:20'),(5962,7478,1957,41611,162849,3,68,1,8677.69,NULL,'2022-08-18 11:10:42','2022-08-18 11:13:20','2022-08-18 11:13:20'),(5963,7478,1957,41611,162849,3,57,2,50000.01,NULL,'2022-08-18 11:10:42','2022-08-18 11:13:20','2022-08-18 11:13:20');
INSERT INTO `balance_libro_details` VALUES (5964,7478,1958,41611,162849,3,217,1,13224.00,NULL,'2022-08-18 11:10:42','2022-08-18 11:13:15','2022-08-18 11:13:15'),(5965,7478,1958,41611,162849,3,68,1,2777.04,NULL,'2022-08-18 11:10:42','2022-08-18 11:13:15','2022-08-18 11:13:15'),(5966,7478,1958,41611,162849,3,57,2,16001.04,NULL,'2022-08-18 11:10:42','2022-08-18 11:13:15','2022-08-18 11:13:15'),(5967,7478,1959,41611,162849,3,217,1,123967.00,NULL,'2022-08-18 11:10:42','2022-08-18 11:13:10','2022-08-18 11:13:10'),(5968,7478,1959,41611,162849,3,68,1,26033.07,NULL,'2022-08-18 11:10:42','2022-08-18 11:13:10','2022-08-18 11:13:10'),(5969,7478,1959,41611,162849,3,57,2,150000.07,NULL,'2022-08-18 11:10:42','2022-08-18 11:13:10','2022-08-18 11:13:10'),(5970,7478,1960,41611,162849,3,217,1,57851.24,NULL,'2022-08-18 11:10:42','2022-08-18 11:13:06','2022-08-18 11:13:06'),(5971,7478,1960,41611,162849,3,68,1,12148.76,NULL,'2022-08-18 11:10:42','2022-08-18 11:13:06','2022-08-18 11:13:06'),(5972,7478,1960,41611,162849,3,57,2,70000.00,NULL,'2022-08-18 11:10:42','2022-08-18 11:13:06','2022-08-18 11:13:06'),(5973,7478,1961,41611,162849,3,217,1,206612.00,NULL,'2022-08-18 11:10:42','2022-08-18 11:12:57','2022-08-18 11:12:57'),(5974,7478,1961,41611,162849,3,68,1,43388.52,NULL,'2022-08-18 11:10:42','2022-08-18 11:12:57','2022-08-18 11:12:57'),(5975,7478,1961,41611,162849,3,57,2,250000.52,NULL,'2022-08-18 11:10:42','2022-08-18 11:12:57','2022-08-18 11:12:57'),(5976,7478,1962,41611,162849,3,217,2,206612.00,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(5977,7478,1962,41611,162849,3,67,2,43388.52,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(5978,7478,1962,41611,162849,3,57,1,250000.52,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(5979,7478,1963,41611,162849,3,217,1,206612.00,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(5980,7478,1963,41611,162849,3,68,1,43388.52,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(5981,7478,1963,41611,162849,3,57,2,250000.52,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(5982,7478,1964,41611,162849,3,217,1,2350.00,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(5983,7478,1964,41611,162849,3,68,1,493.50,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(5984,7478,1964,41611,162849,3,57,2,2843.50,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(5985,7478,1965,41611,162849,3,217,1,48463.29,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(5986,7478,1965,41611,162849,3,68,1,10177.29,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(5987,7478,1965,41611,162849,3,57,2,58640.58,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(5988,7478,1966,41611,162849,3,217,1,270.59,NULL,'2022-08-18 11:13:59','2022-08-18 11:32:56','2022-08-18 11:32:56'),(5989,7478,1966,41611,162849,3,68,1,28.41,NULL,'2022-08-18 11:13:59','2022-08-18 11:32:56','2022-08-18 11:32:56'),(5990,7478,1966,41611,162849,3,57,2,299.00,NULL,'2022-08-18 11:13:59','2022-08-18 11:32:56','2022-08-18 11:32:56'),(5991,7478,1967,41611,162849,3,217,1,2188.00,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(5992,7478,1967,41611,162849,3,68,1,459.48,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(5993,7478,1967,41611,162849,3,57,2,2647.48,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(5994,7478,1968,41611,162849,3,217,1,52070.08,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(5995,7478,1968,41611,162849,3,68,1,10934.72,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(5996,7478,1968,41611,162849,3,57,2,63004.80,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(5997,7478,1969,41611,162849,3,250,1,24900.00,NULL,'2022-08-18 11:13:59','2022-08-18 11:32:48','2022-08-18 11:32:48'),(5998,7478,1969,41611,162849,3,57,2,24900.00,NULL,'2022-08-18 11:13:59','2022-08-18 11:32:48','2022-08-18 11:32:48'),(5999,7478,1970,41611,162849,3,217,1,25791.73,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(6000,7478,1970,41611,162849,3,68,1,5416.27,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL);
INSERT INTO `balance_libro_details` VALUES (6001,7478,1970,41611,162849,3,57,2,31208.00,NULL,'2022-08-18 11:13:59','2022-08-18 11:13:59',NULL),(6002,7478,1971,41611,162849,3,217,1,0.77,NULL,'2022-08-18 11:13:59','2022-08-18 11:32:40','2022-08-18 11:32:40'),(6003,7478,1971,41611,162849,3,68,1,0.16,NULL,'2022-08-18 11:13:59','2022-08-18 11:32:40','2022-08-18 11:32:40'),(6004,7478,1971,41611,162849,3,57,2,0.93,NULL,'2022-08-18 11:13:59','2022-08-18 11:32:40','2022-08-18 11:32:40'),(6005,7478,1972,41611,162849,3,217,1,590.91,NULL,'2022-08-18 11:13:59','2022-08-18 11:32:24','2022-08-18 11:32:24'),(6006,7478,1972,41611,162849,3,68,1,124.09,NULL,'2022-08-18 11:13:59','2022-08-18 11:32:24','2022-08-18 11:32:24'),(6007,7478,1972,41611,162849,3,57,2,715.00,NULL,'2022-08-18 11:13:59','2022-08-18 11:32:24','2022-08-18 11:32:24'),(6008,7478,1973,41611,162849,3,217,1,7836.60,NULL,'2022-08-18 11:24:37','2022-08-18 11:24:37',NULL),(6009,7478,1973,41611,162849,3,68,1,1645.69,NULL,'2022-08-18 11:24:37','2022-08-18 11:24:37',NULL),(6010,7478,1973,41611,162849,3,217,1,3552.47,NULL,'2022-08-18 11:24:37','2022-08-18 11:24:37',NULL),(6011,7478,1973,41611,162849,3,68,1,373.01,NULL,'2022-08-18 11:24:37','2022-08-18 11:24:37',NULL),(6012,7478,1973,41611,162849,3,57,2,13407.77,NULL,'2022-08-18 11:24:37','2022-08-18 11:24:37',NULL),(6013,7478,1974,41611,162849,3,217,1,6200.81,NULL,'2022-08-18 11:26:38','2022-08-18 11:26:38',NULL),(6014,7478,1974,41611,162849,3,68,1,1302.17,NULL,'2022-08-18 11:26:38','2022-08-18 11:26:38',NULL),(6015,7478,1974,41611,162849,3,221,1,997.02,NULL,'2022-08-18 11:26:38','2022-08-18 11:26:38',NULL),(6016,7478,1974,41611,162849,3,57,2,8500.00,NULL,'2022-08-18 11:26:38','2022-08-18 11:26:38',NULL),(6017,7478,1975,40746,37696,3,217,1,1479.47,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6018,7478,1975,40746,37696,3,68,1,310.69,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6019,7478,1975,40746,37696,3,57,2,1790.16,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6020,7478,1976,40746,37696,3,217,1,5371.07,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6021,7478,1976,40746,37696,3,68,1,1127.93,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6022,7478,1976,40746,37696,3,57,2,6499.00,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6023,7478,1977,40746,37696,3,217,1,2037.04,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6024,7478,1977,40746,37696,3,68,1,427.78,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6025,7478,1977,40746,37696,3,57,2,2464.82,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6026,7478,1978,40746,37696,3,217,1,3294.30,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6027,7478,1978,40746,37696,3,68,1,691.80,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6028,7478,1978,40746,37696,3,57,2,3986.10,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6029,7478,1979,40746,37696,3,217,1,2616.30,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6030,7478,1979,40746,37696,3,68,1,549.42,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6031,7478,1979,40746,37696,3,57,2,3165.72,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6032,7478,1980,40746,37696,3,217,1,4060.00,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6033,7478,1980,40746,37696,3,68,1,852.60,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6034,7478,1980,40746,37696,3,57,2,4912.60,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6035,7478,1981,40746,37696,3,217,1,399.60,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6036,7478,1981,40746,37696,3,68,1,83.92,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16');
INSERT INTO `balance_libro_details` VALUES (6037,7478,1981,40746,37696,3,57,2,483.52,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6038,7478,1982,40746,37696,3,217,1,896.60,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6039,7478,1982,40746,37696,3,68,1,188.28,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6040,7478,1982,40746,37696,3,57,2,1084.88,NULL,'2022-08-30 12:57:52','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6041,7478,1983,40746,37696,3,217,1,1369.40,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6042,7478,1983,40746,37696,3,68,1,287.57,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6043,7478,1983,40746,37696,3,57,2,1656.97,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6044,7478,1984,40746,37696,3,217,1,440.44,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6045,7478,1984,40746,37696,3,68,1,92.49,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6046,7478,1984,40746,37696,3,57,2,532.93,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6047,7478,1985,40746,37696,3,217,1,1260.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6048,7478,1985,40746,37696,3,68,1,264.60,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6049,7478,1985,40746,37696,3,57,2,1524.60,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6050,7478,1986,40746,37696,3,217,1,3027.85,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6051,7478,1986,40746,37696,3,68,1,635.85,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6052,7478,1986,40746,37696,3,57,2,3663.70,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6053,7478,1987,40746,37696,3,217,1,6050.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6054,7478,1987,40746,37696,3,68,1,1270.50,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6055,7478,1987,40746,37696,3,57,2,7320.50,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6056,7478,1988,40746,37696,3,217,1,142450.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6057,7478,1988,40746,37696,3,68,1,29914.50,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6058,7478,1988,40746,37696,3,57,2,172364.50,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6059,7478,1989,40746,37696,3,217,1,1652.52,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6060,7478,1989,40746,37696,3,68,1,347.02,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6061,7478,1989,40746,37696,3,57,2,1999.54,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6062,7478,1990,40746,37696,3,217,1,3900.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6063,7478,1990,40746,37696,3,68,1,819.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6064,7478,1990,40746,37696,3,57,2,4719.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6065,7478,1991,40746,37696,3,217,1,5213.59,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6066,7478,1991,40746,37696,3,68,1,1094.85,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6067,7478,1991,40746,37696,3,57,2,6308.44,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6068,7478,1992,40746,37696,3,217,1,3910.19,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6069,7478,1992,40746,37696,3,68,1,821.14,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6070,7478,1992,40746,37696,3,57,2,4731.33,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16');
INSERT INTO `balance_libro_details` VALUES (6071,7478,1993,40746,37696,3,217,1,2516.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6072,7478,1993,40746,37696,3,68,1,528.36,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6073,7478,1993,40746,37696,3,57,2,3044.36,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6074,7478,1994,40746,37696,3,217,1,10470.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6075,7478,1994,40746,37696,3,68,1,2198.70,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6076,7478,1994,40746,37696,3,57,2,12668.70,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6077,7478,1995,40746,37696,3,217,1,8400.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6078,7478,1995,40746,37696,3,68,1,1764.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6079,7478,1995,40746,37696,3,57,2,10164.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6080,7478,1996,40746,37696,3,217,1,11000.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6081,7478,1996,40746,37696,3,68,1,2310.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6082,7478,1996,40746,37696,3,57,2,13310.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6083,7478,1997,40746,37696,3,217,1,9450.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6084,7478,1997,40746,37696,3,68,1,1984.50,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6085,7478,1997,40746,37696,3,57,2,11434.50,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6086,7478,1998,40746,37696,3,217,1,13950.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6087,7478,1998,40746,37696,3,68,1,2929.50,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6088,7478,1998,40746,37696,3,57,2,16879.50,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6089,7478,1999,40746,37696,3,217,1,9300.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6090,7478,1999,40746,37696,3,68,1,1953.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6091,7478,1999,40746,37696,3,57,2,11253.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6092,7478,2000,40746,37696,3,217,1,8100.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6093,7478,2000,40746,37696,3,68,1,1701.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6094,7478,2000,40746,37696,3,57,2,9801.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6095,7478,2001,40746,37696,3,217,1,9975.00,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6096,7478,2001,40746,37696,3,68,1,2094.75,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6097,7478,2001,40746,37696,3,57,2,12069.75,NULL,'2022-08-30 12:57:53','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6098,7478,2002,40746,37696,3,217,1,8802.00,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6099,7478,2002,40746,37696,3,68,1,1848.42,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6100,7478,2002,40746,37696,3,57,2,10650.42,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6101,7478,2003,40746,37696,3,217,1,12250.00,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6102,7478,2003,40746,37696,3,68,1,2572.50,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6103,7478,2003,40746,37696,3,57,2,14822.50,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6104,7478,2004,40746,37696,3,217,1,8750.00,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16');
INSERT INTO `balance_libro_details` VALUES (6105,7478,2004,40746,37696,3,68,1,1837.50,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6106,7478,2004,40746,37696,3,57,2,10587.50,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6107,7478,2005,40746,37696,3,217,1,11800.00,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6108,7478,2005,40746,37696,3,68,1,2478.00,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6109,7478,2005,40746,37696,3,57,2,14278.00,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6110,7478,2006,40746,37696,3,217,1,9540.50,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6111,7478,2006,40746,37696,3,68,1,2003.50,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6112,7478,2006,40746,37696,3,57,2,11544.00,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6113,7478,2007,40746,37696,3,217,1,8173.55,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6114,7478,2007,40746,37696,3,68,1,1716.45,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6115,7478,2007,40746,37696,3,57,2,9890.00,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6116,7478,2008,40746,37696,3,217,1,8628.10,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6117,7478,2008,40746,37696,3,68,1,1811.90,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6118,7478,2008,40746,37696,3,57,2,10440.00,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6119,7478,2009,40746,37696,3,217,1,8885.95,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6120,7478,2009,40746,37696,3,68,1,1866.05,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6121,7478,2009,40746,37696,3,57,2,10752.00,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6122,7478,2010,40746,37696,3,217,1,8915.70,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6123,7478,2010,40746,37696,3,68,1,1872.30,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6124,7478,2010,40746,37696,3,57,2,10788.00,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6125,7478,2011,40746,37696,3,217,1,12654.55,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6126,7478,2011,40746,37696,3,68,1,2657.45,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6127,7478,2011,40746,37696,3,57,2,15312.00,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6128,7478,2012,40746,37696,3,217,1,7380.17,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6129,7478,2012,40746,37696,3,68,1,1549.83,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6130,7478,2012,40746,37696,3,57,2,8930.00,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6131,7478,2013,40746,37696,3,217,1,11885.95,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6132,7478,2013,40746,37696,3,68,1,2496.05,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6133,7478,2013,40746,37696,3,57,2,14382.00,NULL,'2022-08-30 12:57:54','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6134,7478,2014,40746,37696,3,217,1,7429.75,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6135,7478,2014,40746,37696,3,68,1,1560.25,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6136,7478,2014,40746,37696,3,57,2,8990.00,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6137,7478,2015,40746,37696,3,217,1,11610.00,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6138,7478,2015,40746,37696,3,68,1,2438.10,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16');
INSERT INTO `balance_libro_details` VALUES (6139,7478,2015,40746,37696,3,57,2,14048.10,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6140,7478,2016,40746,37696,3,217,1,9229.75,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6141,7478,2016,40746,37696,3,68,1,1938.25,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6142,7478,2016,40746,37696,3,57,2,11168.00,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6143,7478,2017,40746,37696,3,217,1,9800.00,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6144,7478,2017,40746,37696,3,68,1,2058.00,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6145,7478,2017,40746,37696,3,57,2,11858.00,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6146,7478,2018,40746,37696,3,217,1,12366.94,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6147,7478,2018,40746,37696,3,68,1,2597.06,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6148,7478,2018,40746,37696,3,57,2,14964.00,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6149,7478,2019,40746,37696,3,217,1,11791.74,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6150,7478,2019,40746,37696,3,68,1,2476.26,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6151,7478,2019,40746,37696,3,57,2,14268.00,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6152,7478,2020,40746,37696,3,217,1,12024.79,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6153,7478,2020,40746,37696,3,68,1,2525.21,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6154,7478,2020,40746,37696,3,57,2,14550.00,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6155,7478,2021,40746,37696,3,217,1,12885.95,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6156,7478,2021,40746,37696,3,68,1,2706.05,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6157,7478,2021,40746,37696,3,57,2,15592.00,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6158,7478,2022,40746,37696,3,217,1,11547.11,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6159,7478,2022,40746,37696,3,68,1,2424.89,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6160,7478,2022,40746,37696,3,57,2,13972.00,NULL,'2022-08-30 12:57:55','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6161,7478,2023,40746,37696,3,217,1,9217.36,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6162,7478,2023,40746,37696,3,68,1,1935.64,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6163,7478,2023,40746,37696,3,57,2,11153.00,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6164,7478,2024,40746,37696,3,217,1,10809.92,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6165,7478,2024,40746,37696,3,68,1,2270.08,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6166,7478,2024,40746,37696,3,57,2,13080.00,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6167,7478,2025,40746,37696,3,217,1,12347.11,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6168,7478,2025,40746,37696,3,68,1,2592.89,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6169,7478,2025,40746,37696,3,57,2,14940.00,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6170,7478,2026,40746,37696,3,217,1,11888.43,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6171,7478,2026,40746,37696,3,68,1,2496.57,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6172,7478,2026,40746,37696,3,57,2,14385.00,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16');
INSERT INTO `balance_libro_details` VALUES (6173,7478,2027,40746,37696,3,217,1,9570.25,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6174,7478,2027,40746,37696,3,68,1,2009.75,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6175,7478,2027,40746,37696,3,57,2,11580.00,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6176,7478,2028,40746,37696,3,217,1,13809.92,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6177,7478,2028,40746,37696,3,68,1,2900.08,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6178,7478,2028,40746,37696,3,57,2,16710.00,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6179,7478,2029,40746,37696,3,217,1,12871.07,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6180,7478,2029,40746,37696,3,68,1,2702.93,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6181,7478,2029,40746,37696,3,57,2,15574.00,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6182,7478,2030,40746,37696,3,217,1,11528.93,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6183,7478,2030,40746,37696,3,68,1,2421.07,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6184,7478,2030,40746,37696,3,57,2,13950.00,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:16','2022-08-30 13:57:16'),(6185,7478,2031,40746,37696,3,217,1,8665.29,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6186,7478,2031,40746,37696,3,68,1,1819.71,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6187,7478,2031,40746,37696,3,57,2,10485.00,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6188,7478,2032,40746,37696,3,217,1,13467.77,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6189,7478,2032,40746,37696,3,68,1,2828.23,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6190,7478,2032,40746,37696,3,57,2,16296.00,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6191,7478,2033,40746,37696,3,217,1,8256.20,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6192,7478,2033,40746,37696,3,68,1,1733.80,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6193,7478,2033,40746,37696,3,57,2,9990.00,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6194,7478,2034,40746,37696,3,217,1,12359.50,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6195,7478,2034,40746,37696,3,68,1,2595.50,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6196,7478,2034,40746,37696,3,57,2,14955.00,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6197,7478,2035,40746,37696,3,217,1,8809.92,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6198,7478,2035,40746,37696,3,68,1,1850.08,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6199,7478,2035,40746,37696,3,57,2,10660.00,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6200,7478,2036,40746,37696,3,217,1,11152.07,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6201,7478,2036,40746,37696,3,68,1,2341.93,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6202,7478,2036,40746,37696,3,57,2,13494.00,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6203,7478,2037,40746,37696,3,217,1,12359.50,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6204,7478,2037,40746,37696,3,68,1,2595.50,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6205,7478,2037,40746,37696,3,57,2,14955.00,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6206,7478,2038,40746,37696,3,217,1,11752.07,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17');
INSERT INTO `balance_libro_details` VALUES (6207,7478,2038,40746,37696,3,68,1,2467.93,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6208,7478,2038,40746,37696,3,57,2,14220.00,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6209,7478,2039,40746,37696,3,217,1,10705.79,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6210,7478,2039,40746,37696,3,68,1,2248.21,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6211,7478,2039,40746,37696,3,57,2,12954.00,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6212,7478,2040,40746,37696,3,217,1,14280.99,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6213,7478,2040,40746,37696,3,68,1,2999.01,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6214,7478,2040,40746,37696,3,57,2,17280.00,NULL,'2022-08-30 12:57:56','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6215,7478,2041,40746,37696,3,217,1,12359.50,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6216,7478,2041,40746,37696,3,68,1,2595.50,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6217,7478,2041,40746,37696,3,57,2,14955.00,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6218,7478,2042,40746,37696,3,217,1,12361.98,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6219,7478,2042,40746,37696,3,68,1,2596.02,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6220,7478,2042,40746,37696,3,57,2,14958.00,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6221,7478,2043,40746,37696,3,217,1,11650.41,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6222,7478,2043,40746,37696,3,68,1,2446.59,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6223,7478,2043,40746,37696,3,57,2,14097.00,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6224,7478,2044,40746,37696,3,217,1,13884.30,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6225,7478,2044,40746,37696,3,68,1,2915.70,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6226,7478,2044,40746,37696,3,57,2,16800.00,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6227,7478,2045,40746,37696,3,217,1,13760.33,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6228,7478,2045,40746,37696,3,68,1,2889.67,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6229,7478,2045,40746,37696,3,57,2,16650.00,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6230,7478,2046,40746,37696,3,217,1,9082.64,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6231,7478,2046,40746,37696,3,68,1,1907.36,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6232,7478,2046,40746,37696,3,57,2,10990.00,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6233,7478,2047,40746,37696,3,217,1,12185.95,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6234,7478,2047,40746,37696,3,68,1,2559.05,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6235,7478,2047,40746,37696,3,57,2,14745.00,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6236,7478,2048,40746,37696,3,217,1,11186.78,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6237,7478,2048,40746,37696,3,68,1,2349.22,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6238,7478,2048,40746,37696,3,57,2,13536.00,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6239,7478,2049,40746,37696,3,217,1,11537.19,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6240,7478,2049,40746,37696,3,68,1,2422.81,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17');
INSERT INTO `balance_libro_details` VALUES (6241,7478,2049,40746,37696,3,57,2,13960.00,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6242,7478,2050,40746,37696,3,217,1,13061.16,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6243,7478,2050,40746,37696,3,68,1,2742.84,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6244,7478,2050,40746,37696,3,57,2,15804.00,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6245,7478,2051,40746,37696,3,217,1,11821.49,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6246,7478,2051,40746,37696,3,68,1,2482.51,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6247,7478,2051,40746,37696,3,57,2,14304.00,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6248,7478,2052,40746,37696,3,217,1,10656.20,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6249,7478,2052,40746,37696,3,68,1,2237.80,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6250,7478,2052,40746,37696,3,57,2,12894.00,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6251,7478,2053,40746,37696,3,217,1,11866.12,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6252,7478,2053,40746,37696,3,68,1,2491.88,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6253,7478,2053,40746,37696,3,57,2,14358.00,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6254,7478,2054,40746,37696,3,217,1,6619.83,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6255,7478,2054,40746,37696,3,68,1,1390.17,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6256,7478,2054,40746,37696,3,57,2,8010.00,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6257,7478,2055,40746,37696,3,217,1,5980.50,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6258,7478,2055,40746,37696,3,68,1,1255.91,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6259,7478,2055,40746,37696,3,57,2,7236.41,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6260,7478,2056,40746,37696,3,217,1,6459.70,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6261,7478,2056,40746,37696,3,68,1,1356.53,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6262,7478,2056,40746,37696,3,57,2,7816.23,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6263,7478,2057,40746,37696,3,217,1,486.00,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6264,7478,2057,40746,37696,3,68,1,102.06,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6265,7478,2057,40746,37696,3,57,2,588.06,NULL,'2022-08-30 12:57:57','2022-08-30 13:57:17','2022-08-30 13:57:17'),(6266,7478,2058,41798,161343,3,217,1,1404.89,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6267,7478,2058,41798,161343,3,68,1,295.03,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6268,7478,2058,41798,161343,3,57,2,1699.92,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6269,7478,2059,41798,161343,3,250,1,11000.00,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6270,7478,2059,41798,161343,3,57,2,11000.00,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6271,7478,2060,41798,161343,3,217,1,5206.61,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6272,7478,2060,41798,161343,3,68,1,1093.39,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6273,7478,2060,41798,161343,3,57,2,6300.00,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6274,7478,2061,41798,161343,3,217,1,412.31,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6275,7478,2061,41798,161343,3,68,1,86.59,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6276,7478,2061,41798,161343,3,57,2,498.90,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL);
INSERT INTO `balance_libro_details` VALUES (6277,7478,2062,41798,161343,3,217,1,6363.64,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6278,7478,2062,41798,161343,3,68,1,1336.36,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6279,7478,2062,41798,161343,3,57,2,7700.00,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6280,7478,2063,41798,161343,3,217,1,52272.73,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6281,7478,2063,41798,161343,3,68,1,10977.27,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6282,7478,2063,41798,161343,3,57,2,63250.00,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6283,7478,2064,41798,161343,3,217,1,1479.34,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6284,7478,2064,41798,161343,3,68,1,310.66,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6285,7478,2064,41798,161343,3,57,2,1790.00,NULL,'2022-08-30 13:06:42','2022-08-30 13:06:42',NULL),(6286,7478,2065,41798,161343,3,217,1,3305.79,NULL,'2022-08-30 13:06:43','2022-08-30 13:06:43',NULL),(6287,7478,2065,41798,161343,3,68,1,694.22,NULL,'2022-08-30 13:06:43','2022-08-30 13:06:43',NULL),(6288,7478,2065,41798,161343,3,57,2,4000.01,NULL,'2022-08-30 13:06:43','2022-08-30 13:06:43',NULL),(6289,7478,2066,41798,161343,3,217,1,1983.47,NULL,'2022-08-30 13:06:43','2022-08-30 13:06:43',NULL),(6290,7478,2066,41798,161343,3,68,1,416.53,NULL,'2022-08-30 13:06:43','2022-08-30 13:06:43',NULL),(6291,7478,2066,41798,161343,3,57,2,2400.00,NULL,'2022-08-30 13:06:43','2022-08-30 13:06:43',NULL),(6292,7478,2067,41798,161343,3,217,1,3280.99,NULL,'2022-08-30 13:06:43','2022-08-30 13:06:43',NULL),(6293,7478,2067,41798,161343,3,68,1,689.01,NULL,'2022-08-30 13:06:43','2022-08-30 13:06:43',NULL),(6294,7478,2067,41798,161343,3,57,2,3970.00,NULL,'2022-08-30 13:06:43','2022-08-30 13:06:43',NULL),(6295,7478,2068,41798,161343,3,217,1,12630.00,NULL,'2022-08-30 13:06:43','2022-08-30 13:06:43',NULL),(6296,7478,2068,41798,161343,3,68,1,2652.30,NULL,'2022-08-30 13:06:43','2022-08-30 13:06:43',NULL),(6297,7478,2068,41798,161343,3,57,2,15282.30,NULL,'2022-08-30 13:06:43','2022-08-30 13:06:43',NULL),(6298,7478,2069,40784,78387,3,217,1,5026.32,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6299,7478,2069,40784,78387,3,68,1,1055.53,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6300,7478,2069,40784,78387,3,217,1,150.79,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6301,7478,2069,40784,78387,3,57,2,6232.64,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6302,7478,2070,40784,78387,3,217,1,61548.42,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6303,7478,2070,40784,78387,3,68,1,12925.17,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6304,7478,2070,40784,78387,3,217,1,738.58,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6305,7478,2070,40784,78387,3,57,2,75212.17,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6306,7478,2071,40784,78387,3,217,1,45379.82,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6307,7478,2071,40784,78387,3,68,1,9529.77,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6308,7478,2071,40784,78387,3,217,1,544.56,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6309,7478,2071,40784,78387,3,57,2,55454.15,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6310,7478,2072,40784,78387,3,217,1,47394.10,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6311,7478,2072,40784,78387,3,68,1,9952.76,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6312,7478,2072,40784,78387,3,217,1,568.73,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6313,7478,2072,40784,78387,3,57,2,57915.59,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39');
INSERT INTO `balance_libro_details` VALUES (6314,7478,2073,40784,78387,3,217,1,35286.57,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6315,7478,2073,40784,78387,3,68,1,7410.18,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6316,7478,2073,40784,78387,3,217,1,423.44,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6317,7478,2073,40784,78387,3,57,2,43120.19,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6318,7478,2074,40784,78387,3,217,1,29294.12,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6319,7478,2074,40784,78387,3,68,1,6151.77,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6320,7478,2074,40784,78387,3,217,1,732.37,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6321,7478,2074,40784,78387,3,57,2,36178.26,NULL,'2022-08-30 13:10:47','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6322,7478,2075,40784,78387,3,217,1,16959.66,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6323,7478,2075,40784,78387,3,68,1,3561.53,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6324,7478,2075,40784,78387,3,217,1,423.99,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6325,7478,2075,40784,78387,3,57,2,20945.18,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6326,7478,2076,40784,78387,3,217,1,9687.72,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6327,7478,2076,40784,78387,3,68,1,2034.42,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6328,7478,2076,40784,78387,3,217,1,290.63,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6329,7478,2076,40784,78387,3,57,2,12012.77,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6330,7478,2077,40784,78387,3,217,1,74057.03,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6331,7478,2077,40784,78387,3,68,1,15551.98,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6332,7478,2077,40784,78387,3,217,1,888.68,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6333,7478,2077,40784,78387,3,57,2,90497.69,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6334,7478,2078,40784,78387,3,217,1,87451.02,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6335,7478,2078,40784,78387,3,68,1,18364.72,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6336,7478,2078,40784,78387,3,217,1,1049.41,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6337,7478,2078,40784,78387,3,57,2,106865.15,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6338,7478,2079,40784,78387,3,217,1,44561.45,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6339,7478,2079,40784,78387,3,68,1,9357.91,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6340,7478,2079,40784,78387,3,217,1,534.73,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6341,7478,2079,40784,78387,3,57,2,54454.09,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6342,7478,2080,40784,78387,3,217,1,85294.98,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6343,7478,2080,40784,78387,3,68,1,17911.94,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6344,7478,2080,40784,78387,3,217,1,1035.71,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6345,7478,2080,40784,78387,3,57,2,104242.63,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6346,7478,2081,40784,78387,3,217,2,5529.92,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6347,7478,2081,40784,78387,3,67,2,1161.28,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39');
INSERT INTO `balance_libro_details` VALUES (6348,7478,2081,40784,78387,3,217,2,66.36,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6349,7478,2081,40784,78387,3,57,1,6757.56,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6350,7478,2082,40784,78387,3,217,1,1014000.00,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6351,7478,2082,40784,78387,3,68,1,106470.00,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6352,7478,2082,40784,78387,3,217,1,15210.00,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6353,7478,2082,40784,78387,3,57,2,1135680.00,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6354,7478,2083,40784,78387,3,217,1,195000.00,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6355,7478,2083,40784,78387,3,68,1,20475.00,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6356,7478,2083,40784,78387,3,217,1,2925.00,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6357,7478,2083,40784,78387,3,57,2,218400.00,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6358,7478,2084,40784,78387,3,217,1,110000.00,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6359,7478,2084,40784,78387,3,68,1,23100.00,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6360,7478,2084,40784,78387,3,217,1,3300.00,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6361,7478,2084,40784,78387,3,57,2,136400.00,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6362,7478,2085,40784,78387,3,217,2,26205.75,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6363,7478,2085,40784,78387,3,67,2,5503.21,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6364,7478,2085,40784,78387,3,57,1,31708.96,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6365,7478,2086,40784,78387,3,217,1,26205.75,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6366,7478,2086,40784,78387,3,68,1,5503.21,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6367,7478,2086,40784,78387,3,57,2,31708.96,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6368,7478,2087,40784,78387,3,217,1,74126.70,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6369,7478,2087,40784,78387,3,68,1,7783.31,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6370,7478,2087,40784,78387,3,57,2,81910.01,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6371,7478,2088,40784,78387,3,217,1,14888.53,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6372,7478,2088,40784,78387,3,68,1,3126.59,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6373,7478,2088,40784,78387,3,217,1,446.66,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6374,7478,2088,40784,78387,3,57,2,18461.78,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6375,7478,2089,40784,78387,3,217,1,2853.32,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6376,7478,2089,40784,78387,3,68,1,599.20,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6377,7478,2089,40784,78387,3,217,1,85.60,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6378,7478,2089,40784,78387,3,57,2,3538.12,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6379,7478,2090,40784,78387,3,217,1,44117.89,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6380,7478,2090,40784,78387,3,68,1,9264.75,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6381,7478,2090,40784,78387,3,217,1,529.42,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39');
INSERT INTO `balance_libro_details` VALUES (6382,7478,2090,40784,78387,3,57,2,53912.06,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:39','2022-09-01 09:31:39'),(6383,7478,2091,40784,78387,3,217,1,51057.42,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:40','2022-09-01 09:31:40'),(6384,7478,2091,40784,78387,3,68,1,10722.07,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:40','2022-09-01 09:31:40'),(6385,7478,2091,40784,78387,3,217,1,612.68,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:40','2022-09-01 09:31:40'),(6386,7478,2091,40784,78387,3,57,2,62392.17,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:40','2022-09-01 09:31:40'),(6387,7478,2092,40784,78387,3,217,1,73418.21,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:40','2022-09-01 09:31:40'),(6388,7478,2092,40784,78387,3,68,1,15417.83,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:40','2022-09-01 09:31:40'),(6389,7478,2092,40784,78387,3,217,1,881.02,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:40','2022-09-01 09:31:40'),(6390,7478,2092,40784,78387,3,57,2,89717.06,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:40','2022-09-01 09:31:40'),(6391,7478,2093,40784,78387,3,217,1,61004.30,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:40','2022-09-01 09:31:40'),(6392,7478,2093,40784,78387,3,68,1,12810.90,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:40','2022-09-01 09:31:40'),(6393,7478,2093,40784,78387,3,217,1,732.05,NULL,'2022-08-30 13:10:48','2022-09-01 09:31:40','2022-09-01 09:31:40'),(6394,7478,2093,40784,78387,3,57,2,74547.25,NULL,'