-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-38517755-6
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-10-11 09:37:11','Actividad Generica 1','000001',NULL),(2,NULL,'2022-10-11 09:37:11','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,'2022-12-07 16:47:16','2022-12-07 16:47:16',NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,'2022-12-07 16:47:57','2022-12-07 16:47:57',NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,'2022-12-07 16:48:17','2022-12-07 16:48:17',NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,'2022-12-07 16:48:29','2022-12-07 16:48:29',NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,'2022-12-07 16:48:41','2022-12-07 16:48:41',NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=194 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(5,3,2,425,NULL,0.00,'2022-11-12 11:20:17','2022-11-12 11:20:17',NULL),(6,3,2,486,NULL,0.00,'2022-11-12 11:20:17','2022-11-12 11:20:17',NULL),(7,3,2,25,NULL,0.00,'2022-11-12 11:20:17','2022-11-12 11:20:17',NULL),(8,3,2,23,NULL,0.00,'2022-11-12 11:20:17','2022-11-12 11:20:17',NULL),(9,3,2,97,NULL,0.00,'2022-11-12 11:20:17','2022-11-12 11:20:17',NULL),(10,3,2,67,NULL,0.00,'2022-11-12 11:20:17','2022-11-12 11:20:17',NULL),(11,4,2,23,1,7656.60,'2022-11-12 11:33:08','2022-11-12 11:33:08',NULL),(12,4,2,425,1,447743.40,'2022-11-12 11:33:08','2022-11-12 11:33:08',NULL),(13,4,2,21,1,13500.00,'2022-11-12 11:33:08','2022-11-12 11:33:08',NULL),(14,4,2,25,1,75600.00,'2022-11-12 11:33:08','2022-11-12 11:33:08',NULL),(15,4,2,97,2,450000.00,'2022-11-12 11:33:08','2022-11-12 11:33:08',NULL),(16,4,2,67,2,94500.00,'2022-11-12 11:33:08','2022-11-12 11:33:08',NULL),(17,5,2,488,NULL,0.00,'2022-11-12 12:00:47','2022-11-12 12:00:47',NULL),(18,5,2,67,NULL,0.00,'2022-11-12 12:00:47','2022-11-12 12:00:47',NULL),(19,5,2,487,NULL,0.00,'2022-11-12 12:00:47','2022-11-12 12:00:47',NULL),(20,6,2,425,NULL,0.00,'2022-11-12 12:53:20','2022-11-12 12:53:20',NULL),(21,6,2,25,NULL,0.00,'2022-11-12 12:53:20','2022-11-12 12:53:20',NULL),(22,6,2,23,NULL,0.00,'2022-11-12 12:53:20','2022-11-12 12:53:20',NULL),(23,6,2,21,NULL,0.00,'2022-11-12 12:53:20','2022-11-12 12:53:20',NULL),(24,6,2,67,NULL,0.00,'2022-11-12 12:53:20','2022-11-12 12:53:20',NULL),(25,6,2,490,NULL,0.00,'2022-11-12 12:53:20','2022-11-12 12:53:20',NULL),(34,8,3,425,NULL,0.00,'2022-11-21 13:58:34','2022-11-21 13:58:34',NULL),(35,8,3,491,NULL,0.00,'2022-11-21 13:58:34','2022-11-21 13:58:34',NULL),(36,8,3,492,NULL,0.00,'2022-11-21 13:58:34','2022-11-21 13:58:34',NULL),(37,8,3,135,NULL,0.00,'2022-11-21 13:58:34','2022-11-21 13:58:34',NULL),(38,8,3,493,NULL,0.00,'2022-11-21 13:58:34','2022-11-21 13:58:34',NULL),(39,8,3,494,NULL,0.00,'2022-11-21 13:58:34','2022-11-21 13:58:34',NULL),(40,8,3,495,NULL,0.00,'2022-11-21 13:58:34','2022-11-21 13:58:34',NULL),(41,8,3,496,NULL,0.00,'2022-11-21 13:58:34','2022-11-21 13:58:34',NULL),(42,8,3,188,NULL,0.00,'2022-11-21 13:58:34','2022-11-21 13:58:34',NULL),(43,8,3,216,NULL,0.00,'2022-11-21 13:58:34','2022-11-21 13:58:34',NULL),(44,8,3,396,NULL,0.00,'2022-11-21 13:58:34','2022-11-21 13:58:34',NULL),(45,8,3,155,NULL,0.00,'2022-11-21 13:58:34','2022-11-21 13:58:34',NULL),(46,8,3,157,NULL,0.00,'2022-11-21 13:58:34','2022-11-21 13:58:34',NULL),(47,8,3,220,NULL,0.00,'2022-11-21 13:58:34','2022-11-21 13:58:34',NULL),(48,8,3,75,NULL,0.00,'2022-11-21 13:58:34','2022-11-21 13:58:34',NULL),(49,8,3,68,NULL,0.00,'2022-11-21 13:58:34','2022-11-21 13:58:34',NULL),(58,10,15,67,NULL,0.00,'2022-11-21 16:42:20','2022-11-21 16:42:20',NULL),(59,10,15,353,NULL,0.00,'2022-11-21 16:42:20','2022-11-21 16:42:20',NULL),(60,10,15,354,NULL,0.00,'2022-11-21 16:42:20','2022-11-21 16:42:20',NULL),(61,10,15,20,NULL,0.00,'2022-11-21 16:42:20','2022-11-21 16:42:20',NULL),(62,10,15,68,NULL,0.00,'2022-11-21 16:42:20','2022-11-21 16:42:20',NULL),(63,10,15,25,NULL,0.00,'2022-11-21 16:42:20','2022-11-21 16:42:20',NULL),(64,10,15,353,NULL,0.00,'2022-11-21 16:42:20','2022-11-21 16:42:20',NULL),(65,10,15,354,NULL,0.00,'2022-11-21 16:42:20','2022-11-21 16:42:20',NULL),(66,11,16,302,1,7551.49,'2022-11-22 16:55:56','2022-11-22 16:55:56',NULL),(67,11,16,252,1,29795.77,'2022-11-22 16:55:56','2022-11-22 16:55:56',NULL),(68,11,16,21,2,7500.00,'2022-11-22 16:55:56','2022-11-22 16:55:56',NULL),(69,11,16,209,NULL,0.00,'2022-11-22 16:55:56','2022-11-22 16:55:56',NULL),(70,11,16,302,2,29847.26,'2022-11-22 16:55:56','2022-11-22 16:55:56',NULL),(71,12,16,156,NULL,0.00,'2022-11-22 17:15:09','2022-11-22 17:15:09',NULL);
INSERT INTO `balance_asiento_modelo_detail` VALUES (72,12,16,301,NULL,0.00,'2022-11-22 17:15:09','2022-11-22 17:15:09',NULL),(73,12,16,21,NULL,0.00,'2022-11-22 17:15:09','2022-11-22 17:15:09',NULL),(74,12,16,209,NULL,0.00,'2022-11-22 17:15:09','2022-11-22 17:15:09',NULL),(75,12,16,301,NULL,0.00,'2022-11-22 17:15:09','2022-11-22 17:15:09',NULL),(76,13,2,386,NULL,0.00,'2022-12-07 05:14:43','2022-12-07 05:14:43',NULL),(77,13,2,23,NULL,0.00,'2022-12-07 05:14:43','2022-12-07 05:14:43',NULL),(78,13,2,425,NULL,0.00,'2022-12-07 05:14:43','2022-12-07 05:14:43',NULL),(79,13,2,386,NULL,0.00,'2022-12-07 05:14:43','2022-12-07 05:14:43',NULL),(80,13,2,102,NULL,0.00,'2022-12-07 05:14:43','2022-12-07 05:14:43',NULL),(81,14,2,386,1,1900000.00,'2022-12-07 05:23:23','2022-12-07 05:23:23',NULL),(82,14,2,425,1,2104603.29,'2022-12-07 05:23:23','2022-12-07 05:23:23',NULL),(83,14,2,386,2,2104603.29,'2022-12-07 05:23:23','2022-12-07 05:23:23',NULL),(84,14,2,425,2,1900000.00,'2022-12-07 05:23:23','2022-12-07 05:23:23',NULL),(85,15,3,155,NULL,0.00,'2022-12-07 07:23:11','2022-12-07 07:23:11',NULL),(86,15,3,79,NULL,0.00,'2022-12-07 07:23:11','2022-12-07 07:23:11',NULL),(87,15,3,141,NULL,0.00,'2022-12-07 07:23:11','2022-12-07 07:23:11',NULL),(88,15,3,425,NULL,0.00,'2022-12-07 07:23:11','2022-12-07 07:23:11',NULL),(89,15,3,157,NULL,0.00,'2022-12-07 07:23:11','2022-12-07 07:23:11',NULL),(90,15,3,354,NULL,0.00,'2022-12-07 07:23:11','2022-12-07 07:23:11',NULL),(91,15,3,79,NULL,0.00,'2022-12-07 07:23:11','2022-12-07 07:23:11',NULL),(92,16,3,67,NULL,0.00,'2022-12-10 09:59:03','2022-12-10 09:59:03',NULL),(93,16,3,353,NULL,0.00,'2022-12-10 09:59:03','2022-12-10 09:59:03',NULL),(94,16,3,354,NULL,0.00,'2022-12-10 09:59:03','2022-12-10 09:59:03',NULL),(95,16,3,68,NULL,0.00,'2022-12-10 09:59:03','2022-12-10 09:59:03',NULL),(96,16,3,25,NULL,0.00,'2022-12-10 09:59:03','2022-12-10 09:59:03',NULL),(97,16,3,353,NULL,0.00,'2022-12-10 09:59:03','2022-12-10 09:59:03',NULL),(98,16,3,354,NULL,0.00,'2022-12-10 09:59:03','2022-12-10 09:59:03',NULL),(99,16,3,74,NULL,0.00,'2022-12-10 09:59:03','2022-12-10 09:59:03',NULL),(100,17,16,156,NULL,0.00,'2022-12-26 12:11:22','2022-12-26 12:11:22',NULL),(101,17,16,485,NULL,0.00,'2022-12-26 12:11:22','2022-12-26 12:11:22',NULL),(102,17,16,21,NULL,0.00,'2022-12-26 12:11:22','2022-12-26 12:11:22',NULL),(103,17,16,209,NULL,0.00,'2022-12-26 12:11:22','2022-12-26 12:11:22',NULL),(104,17,16,485,NULL,0.00,'2022-12-26 12:11:22','2022-12-26 12:11:22',NULL),(105,17,16,78,NULL,0.00,'2022-12-26 12:11:22','2022-12-26 12:11:22',NULL),(106,18,3,20,NULL,0.00,'2022-12-26 12:50:09','2022-12-26 12:50:09',NULL),(107,18,3,354,NULL,0.00,'2022-12-26 12:50:09','2022-12-26 12:50:09',NULL),(108,18,3,157,NULL,0.00,'2022-12-26 12:50:09','2022-12-26 12:50:09',NULL),(109,19,3,68,NULL,0.00,'2022-12-26 13:17:00','2022-12-26 13:17:00',NULL),(110,19,3,62,NULL,0.00,'2022-12-26 13:17:00','2022-12-26 13:17:00',NULL),(111,19,3,499,NULL,0.00,'2022-12-26 13:17:00','2022-12-26 13:17:00',NULL),(112,19,3,500,NULL,0.00,'2022-12-26 13:17:00','2022-12-26 13:17:00',NULL),(113,19,3,64,NULL,0.00,'2022-12-26 13:17:00','2022-12-26 13:17:00',NULL),(114,19,3,396,NULL,0.00,'2022-12-26 13:17:00','2022-12-26 13:17:00',NULL),(115,19,3,502,NULL,0.00,'2022-12-26 13:17:00','2022-12-26 13:17:00',NULL),(116,19,3,74,NULL,0.00,'2022-12-26 13:17:00','2022-12-26 13:17:00',NULL),(117,19,3,78,NULL,0.00,'2022-12-26 13:17:00','2022-12-26 13:17:00',NULL),(118,19,3,503,NULL,0.00,'2022-12-26 13:17:00','2022-12-26 13:17:00',NULL),(119,19,3,135,NULL,0.00,'2022-12-26 13:17:00','2022-12-26 13:17:00',NULL),(120,19,3,25,NULL,0.00,'2022-12-26 13:17:00','2022-12-26 13:17:00',NULL),(121,19,3,504,NULL,0.00,'2022-12-26 13:17:00','2022-12-26 13:17:00',NULL),(122,19,3,486,NULL,0.00,'2022-12-26 13:17:00','2022-12-26 13:17:00',NULL),(123,19,3,157,NULL,0.00,'2022-12-26 13:17:00','2022-12-26 13:17:00',NULL),(124,19,3,505,NULL,0.00,'2022-12-26 13:17:00','2022-12-26 13:17:00',NULL),(125,19,3,425,NULL,0.00,'2022-12-26 13:17:00','2022-12-26 13:17:00',NULL);
INSERT INTO `balance_asiento_modelo_detail` VALUES (126,20,3,68,NULL,0.00,'2022-12-26 13:17:36','2022-12-26 13:17:36',NULL),(127,20,3,62,NULL,0.00,'2022-12-26 13:17:36','2022-12-26 13:17:36',NULL),(128,20,3,499,NULL,0.00,'2022-12-26 13:17:36','2022-12-26 13:17:36',NULL),(129,20,3,500,NULL,0.00,'2022-12-26 13:17:36','2022-12-26 13:17:36',NULL),(130,20,3,64,NULL,0.00,'2022-12-26 13:17:36','2022-12-26 13:17:36',NULL),(131,20,3,396,NULL,0.00,'2022-12-26 13:17:36','2022-12-26 13:17:36',NULL),(132,20,3,502,NULL,0.00,'2022-12-26 13:17:36','2022-12-26 13:17:36',NULL),(133,20,3,74,NULL,0.00,'2022-12-26 13:17:36','2022-12-26 13:17:36',NULL),(134,20,3,78,NULL,0.00,'2022-12-26 13:17:36','2022-12-26 13:17:36',NULL),(135,20,3,503,NULL,0.00,'2022-12-26 13:17:36','2022-12-26 13:17:36',NULL),(136,20,3,135,NULL,0.00,'2022-12-26 13:17:36','2022-12-26 13:17:36',NULL),(137,20,3,25,NULL,0.00,'2022-12-26 13:17:36','2022-12-26 13:17:36',NULL),(138,20,3,504,NULL,0.00,'2022-12-26 13:17:36','2022-12-26 13:17:36',NULL),(139,20,3,486,NULL,0.00,'2022-12-26 13:17:36','2022-12-26 13:17:36',NULL),(140,20,3,157,NULL,0.00,'2022-12-26 13:17:36','2022-12-26 13:17:36',NULL),(141,20,3,505,NULL,0.00,'2022-12-26 13:17:36','2022-12-26 13:17:36',NULL),(142,20,3,425,NULL,0.00,'2022-12-26 13:17:36','2022-12-26 13:17:36',NULL),(143,21,3,425,NULL,0.00,'2023-01-02 21:18:55','2023-01-02 21:18:55',NULL),(144,21,3,506,NULL,0.00,'2023-01-02 21:18:55','2023-01-02 21:18:55',NULL),(145,21,3,23,NULL,0.00,'2023-01-02 21:18:55','2023-01-02 21:18:55',NULL),(146,21,3,484,NULL,0.00,'2023-01-02 21:18:55','2023-01-02 21:18:55',NULL),(147,21,3,25,NULL,0.00,'2023-01-02 21:18:55','2023-01-02 21:18:55',NULL),(148,21,3,486,NULL,0.00,'2023-01-02 21:18:55','2023-01-02 21:18:55',NULL),(149,21,3,157,NULL,0.00,'2023-01-02 21:18:55','2023-01-02 21:18:55',NULL),(150,21,3,67,NULL,0.00,'2023-01-02 21:18:55','2023-01-02 21:18:55',NULL),(151,22,2,425,NULL,0.00,'2023-01-02 21:32:45','2023-01-02 21:32:45',NULL),(152,22,2,506,NULL,0.00,'2023-01-02 21:32:45','2023-01-02 21:32:45',NULL),(153,23,2,425,NULL,0.00,'2023-01-02 21:39:03','2023-01-02 21:39:03',NULL),(154,23,2,508,NULL,0.00,'2023-01-02 21:39:03','2023-01-02 21:39:03',NULL),(155,23,2,67,NULL,0.00,'2023-01-02 21:39:03','2023-01-02 21:39:03',NULL),(156,24,2,425,NULL,0.00,'2023-01-02 21:49:20','2023-01-02 21:49:20',NULL),(157,24,2,23,NULL,0.00,'2023-01-02 21:49:20','2023-01-02 21:49:20',NULL),(158,24,2,162,NULL,0.00,'2023-01-02 21:49:20','2023-01-02 21:49:20',NULL),(159,24,2,25,NULL,0.00,'2023-01-02 21:49:20','2023-01-02 21:49:20',NULL),(160,24,2,486,NULL,0.00,'2023-01-02 21:49:20','2023-01-02 21:49:20',NULL),(161,24,2,157,NULL,0.00,'2023-01-02 21:49:20','2023-01-02 21:49:20',NULL),(162,24,2,509,NULL,0.00,'2023-01-02 21:49:20','2023-01-02 21:49:20',NULL),(163,24,2,67,NULL,0.00,'2023-01-02 21:49:20','2023-01-02 21:49:20',NULL),(164,25,2,425,NULL,0.00,'2023-01-02 22:12:22','2023-01-02 22:12:22',NULL),(165,25,2,23,NULL,0.00,'2023-01-02 22:12:22','2023-01-02 22:12:22',NULL),(166,25,2,486,NULL,0.00,'2023-01-02 22:12:22','2023-01-02 22:12:22',NULL),(167,25,2,157,NULL,0.00,'2023-01-02 22:12:22','2023-01-02 22:12:22',NULL),(168,25,2,510,NULL,0.00,'2023-01-02 22:12:22','2023-01-02 22:12:22',NULL),(169,25,2,67,NULL,0.00,'2023-01-02 22:12:22','2023-01-02 22:12:22',NULL),(170,26,1,110,NULL,0.00,'2023-01-08 01:12:49','2023-01-08 01:12:49',NULL),(171,26,1,514,NULL,0.00,'2023-01-08 01:12:49','2023-01-08 01:12:49',NULL),(172,26,1,515,NULL,0.00,'2023-01-08 01:12:49','2023-01-08 01:12:49',NULL),(173,26,1,516,NULL,0.00,'2023-01-08 01:12:49','2023-01-08 01:12:49',NULL),(174,26,1,517,NULL,0.00,'2023-01-08 01:12:49','2023-01-08 01:12:49',NULL),(175,26,1,518,NULL,0.00,'2023-01-08 01:12:49','2023-01-08 01:12:49',NULL),(176,26,1,519,NULL,0.00,'2023-01-08 01:12:49','2023-01-08 01:12:49',NULL),(177,26,1,62,NULL,0.00,'2023-01-08 01:12:49','2023-01-08 01:12:49',NULL),(178,26,1,500,NULL,0.00,'2023-01-08 01:12:49','2023-01-08 01:12:49',NULL),(179,26,1,484,NULL,0.00,'2023-01-08 01:12:49','2023-01-08 01:12:49',NULL);
INSERT INTO `balance_asiento_modelo_detail` VALUES (180,26,1,520,NULL,0.00,'2023-01-08 01:12:49','2023-01-08 01:12:49',NULL),(181,26,1,64,NULL,0.00,'2023-01-08 01:12:49','2023-01-08 01:12:49',NULL),(182,27,1,110,NULL,0.00,'2023-01-08 01:13:21','2023-01-08 01:13:21',NULL),(183,27,1,514,NULL,0.00,'2023-01-08 01:13:21','2023-01-08 01:13:21',NULL),(184,27,1,515,NULL,0.00,'2023-01-08 01:13:21','2023-01-08 01:13:21',NULL),(185,27,1,516,NULL,0.00,'2023-01-08 01:13:21','2023-01-08 01:13:21',NULL),(186,27,1,517,NULL,0.00,'2023-01-08 01:13:21','2023-01-08 01:13:21',NULL),(187,27,1,518,NULL,0.00,'2023-01-08 01:13:21','2023-01-08 01:13:21',NULL),(188,27,1,519,NULL,0.00,'2023-01-08 01:13:21','2023-01-08 01:13:21',NULL),(189,27,1,62,NULL,0.00,'2023-01-08 01:13:21','2023-01-08 01:13:21',NULL),(190,27,1,500,NULL,0.00,'2023-01-08 01:13:21','2023-01-08 01:13:21',NULL),(191,27,1,484,NULL,0.00,'2023-01-08 01:13:21','2023-01-08 01:13:21',NULL),(192,27,1,520,NULL,0.00,'2023-01-08 01:13:21','2023-01-08 01:13:21',NULL),(193,27,1,64,NULL,0.00,'2023-01-08 01:13:21','2023-01-08 01:13:21',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,7938,2,2,'SANCOR',0.00,'2022-11-12 11:20:17','2022-11-12 11:20:17',NULL),(4,7938,2,2,'SANCOR',0.00,'2022-11-12 11:33:08','2022-11-12 11:33:08',NULL),(5,7938,2,2,'PREVENCION SALUD',0.00,'2022-11-12 12:00:47','2022-11-12 12:00:47',NULL),(6,7938,2,2,'HONORARIOS EXTRA',0.00,'2022-11-12 12:53:20','2022-11-12 12:53:20',NULL),(7,7938,3,2,'Egresos mensuales',0.00,'2022-11-21 13:22:10','2022-11-21 13:31:49','2022-11-21 13:31:49'),(8,7938,3,2,'Egresos mensuales',0.00,'2022-11-21 13:58:34','2022-11-21 13:58:34',NULL),(9,7938,15,2,'IVA MENSUAL',0.00,'2022-11-21 16:42:00','2022-11-21 16:42:30','2022-11-21 16:42:30'),(10,7938,15,2,'IVA MENSUAL',0.00,'2022-11-21 16:42:20','2022-11-21 16:42:20',NULL),(11,7938,16,2,'IIBB MENSUAL',0.00,'2022-11-22 16:55:56','2022-11-22 16:55:56',NULL),(12,7938,16,2,'IIBB MENSUAL BSAS',0.00,'2022-11-22 17:15:09','2022-11-22 17:15:09',NULL),(13,7938,2,2,'Plazo fijo',0.00,'2022-12-07 05:14:43','2022-12-07 05:14:43',NULL),(14,7938,2,2,'Aumento plazo fijo',0.00,'2022-12-07 05:23:23','2022-12-07 05:23:23',NULL),(15,7938,3,2,'Anticipo impuesto a las ganancias',0.00,'2022-12-07 07:23:11','2022-12-07 07:23:11',NULL),(16,7938,3,2,'IVA MENSUAL',0.00,'2022-12-10 09:59:03','2022-12-10 09:59:03',NULL),(17,7938,16,2,'IIBB MENSUAL BROKER',0.00,'2022-12-26 12:11:22','2022-12-26 12:11:22',NULL),(18,7938,3,2,'anticipos ganancias broker',0.00,'2022-12-26 12:50:09','2022-12-26 12:50:09',NULL),(19,7938,3,2,'Egresos mensuales Broker',0.00,'2022-12-26 13:17:00','2022-12-26 13:17:00',NULL),(20,7938,3,2,'Egresos mensuales Broker',0.00,'2022-12-26 13:17:36','2022-12-26 13:17:36',NULL),(21,7938,3,2,'Ingreso prev retiro',0.00,'2023-01-02 21:18:55','2023-01-02 21:18:55',NULL),(22,7938,2,2,'ingreso retiro banco',0.00,'2023-01-02 21:32:45','2023-01-02 21:32:45',NULL),(23,7938,2,2,'Comision banco sol',0.00,'2023-01-02 21:39:03','2023-01-02 21:39:03',NULL),(24,7938,2,2,'Ingresos sancor',0.00,'2023-01-02 21:49:20','2023-01-02 21:49:20',NULL),(25,7938,2,2,'Ingreso ART',0.00,'2023-01-02 22:12:22','2023-01-02 22:12:22',NULL),(26,7938,1,2,'SUELDOS',0.00,'2023-01-08 01:12:49','2023-01-08 01:12:49',NULL),(27,7938,1,2,'SUELDOS',0.00,'2023-01-08 01:13:21','2023-01-08 01:13:21',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=500 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7938,40719,3,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',3052368.60,NULL,NULL,1,'2022-10-11 12:28:31','2022-10-11 12:30:56','2022-10-11 12:30:56'),(2,7938,40719,3,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',3052368.60,NULL,NULL,1,'2022-10-11 12:30:56','2022-10-11 12:34:11','2022-10-11 12:34:11'),(3,7938,40719,3,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',3052368.60,NULL,NULL,1,'2022-10-11 12:34:11','2022-10-11 12:38:49','2022-10-11 12:38:49'),(4,7938,40719,3,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',3052368.60,NULL,NULL,1,'2022-10-11 12:38:49','2022-11-12 10:49:30','2022-11-12 10:49:30'),(5,7938,40719,3,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',3052368.60,NULL,NULL,1,'2022-11-12 10:49:30','2022-11-12 10:49:44','2022-11-12 10:49:44'),(6,7938,40719,3,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',3052368.60,NULL,NULL,1,'2022-11-12 10:49:44','2022-11-12 10:49:44',NULL),(7,7938,40720,1518,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',3052368.60,'Asinto inicial',NULL,1,'2022-11-12 11:14:33','2022-12-07 13:12:43','2022-12-07 13:12:43'),(8,7938,40720,1518,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',302500.00,'SANCOR',NULL,1,'2022-11-12 11:23:07','2022-12-07 11:50:16','2022-12-07 11:50:16'),(9,7938,40720,1519,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',544500.00,'SANCOR',NULL,1,'2022-11-12 11:25:28','2022-12-07 11:52:28','2022-12-07 11:52:28'),(10,7938,40720,1520,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',544500.00,'SANCOR',NULL,1,'2022-11-12 11:28:41','2022-12-07 11:49:45','2022-12-07 11:49:45'),(11,7938,40720,1521,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',544500.00,'SANCOR',NULL,1,'2022-11-12 11:36:40','2022-11-12 11:36:40',NULL),(12,7938,40720,1525,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',544500.00,'SANCOR',NULL,1,'2022-11-12 11:37:04','2022-11-12 11:37:04',NULL),(13,7938,40720,1526,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',544500.00,'SANCOR',NULL,1,'2022-11-12 11:37:23','2022-11-12 11:37:23',NULL),(14,7938,40720,1527,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',544500.00,'SANCOR',NULL,1,'2022-11-12 11:37:40','2022-11-12 11:37:40',NULL),(15,7938,40720,1528,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',544500.00,'SANCOR',NULL,1,'2022-11-12 11:38:02','2022-11-12 11:38:02',NULL),(16,7938,40720,1529,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-01','2022-05-01',544500.00,'SANCOR',NULL,1,'2022-11-12 11:38:23','2022-11-12 11:38:23',NULL),(17,7938,40720,1531,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',544500.00,'SANCOR',NULL,1,'2022-11-12 11:38:59','2022-11-12 11:38:59',NULL),(18,7938,40720,1532,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',544500.00,'SANCOR',NULL,1,'2022-11-12 11:39:22','2022-11-12 11:39:22',NULL),(19,7938,40720,1530,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',544500.00,'SANCOR',NULL,1,'2022-11-12 11:40:49','2022-11-12 11:40:49',NULL),(20,7938,40720,1518,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',5339.79,'PREVENCION SALUD',NULL,1,'2022-11-12 12:01:49','2022-11-12 12:01:49',NULL),(21,7938,40720,1519,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',5657.37,'PREVENCION SALUD',NULL,1,'2022-11-12 12:40:25','2022-11-12 12:40:25',NULL),(22,7938,40720,1520,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',5572.45,'PREVENCION SALUD',NULL,1,'2022-11-12 12:41:43','2022-11-12 12:41:43',NULL),(23,7938,40720,1521,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',5629.50,'PREVENCION SALUD',NULL,1,'2022-11-12 12:42:39','2022-11-12 12:48:10','2022-11-12 12:48:10');
INSERT INTO `balance_libro` VALUES (24,7938,40720,1525,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',5981.39,'PREVENCION SALUD',NULL,1,'2022-11-12 12:43:41','2022-11-12 12:43:41',NULL),(25,7938,40720,1527,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',6876.22,'PREVENCION SALUD',NULL,1,'2022-11-12 12:44:43','2022-11-12 12:44:43',NULL),(26,7938,40720,1528,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',6206.21,'PREVENCION SALUD',NULL,1,'2022-11-12 12:45:27','2022-11-12 12:45:27',NULL),(27,7938,40720,1530,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',7140.85,'PREVENCION SALUD',NULL,1,'2022-11-12 12:46:19','2022-11-12 12:46:19',NULL),(28,7938,40720,1521,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',5629.53,'PREVENCION SALUD',NULL,1,'2022-11-12 12:48:10','2022-11-12 12:48:10',NULL),(29,7938,40720,1532,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',16732.65,'PREVENCION SALUD',NULL,1,'2022-11-12 12:49:56','2022-11-12 12:49:56',NULL),(30,7938,40720,1526,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',735492.45,'HONORARIOS EXTRA',NULL,1,'2022-11-12 12:58:24','2022-11-12 12:58:24',NULL),(31,7938,40720,1528,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',951128.85,'HONORARIOS EXTRA',NULL,1,'2022-11-12 13:01:06','2022-11-12 13:01:06',NULL),(32,7938,40720,1531,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1009618.90,'HONORARIOS EXTRA',NULL,1,'2022-11-12 13:10:28','2022-11-12 13:10:28',NULL),(33,7938,40720,3168,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',335194.45,'Egresos mensuales',NULL,1,'2022-11-21 14:04:26','2022-12-07 05:48:35','2022-12-07 05:48:35'),(34,7938,40720,3169,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',508421.06,'Egresos mensuales',NULL,1,'2022-11-21 14:11:33','2022-12-07 05:50:26','2022-12-07 05:50:26'),(35,7938,40720,3170,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',261274.14,'Egresos mensuales',NULL,1,'2022-11-21 14:16:36','2022-12-07 05:51:27','2022-12-07 05:51:27'),(36,7938,40720,3171,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',325002.80,'Egresos mensuales',NULL,1,'2022-11-21 14:25:34','2022-12-07 05:57:49','2022-12-07 05:57:49'),(37,7938,40720,3175,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',263136.59,'Egresos mensuales',NULL,1,'2022-11-21 14:29:32','2022-12-07 05:58:19','2022-12-07 05:58:19'),(38,7938,40720,3176,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',329493.33,'Egresos mensuales',NULL,1,'2022-11-21 15:54:40','2022-12-07 05:59:17','2022-12-07 05:59:17'),(39,7938,40720,3177,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',253741.69,'Egresos mensuales',NULL,1,'2022-11-21 15:57:45','2022-12-07 06:03:57','2022-12-07 06:03:57'),(40,7938,40720,3178,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',688270.99,'Egresos mensuales',NULL,1,'2022-11-21 16:04:17','2022-12-07 06:10:30','2022-12-07 06:10:30'),(41,7938,40720,3179,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',363099.36,'Egresos mensuales',NULL,1,'2022-11-21 16:08:20','2022-12-07 06:17:31','2022-12-07 06:17:31'),(42,7938,40720,3180,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',313101.07,'Egresos mensuales',NULL,1,'2022-11-21 16:17:33','2022-12-07 06:23:42','2022-12-07 06:23:42'),(43,7938,40720,3181,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',645546.65,'Egresos mensuales',NULL,1,'2022-11-21 16:22:41','2022-12-07 06:21:03','2022-12-07 06:21:03'),(44,7938,40720,3182,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',423150.70,'Egresos mensuales',NULL,1,'2022-11-21 16:26:23','2022-12-07 06:18:58','2022-12-07 06:18:58');
INSERT INTO `balance_libro` VALUES (45,7938,40720,3168,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',122942.49,'IVA MENSUAL',NULL,1,'2022-11-21 16:44:33','2022-12-07 06:27:53','2022-12-07 06:27:53'),(46,7938,40720,3169,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',171391.12,'IVA MENSUAL',NULL,1,'2022-11-21 16:45:58','2022-12-07 06:28:31','2022-12-07 06:28:31'),(47,7938,40720,3170,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',171384.95,'IVA MENSUAL',NULL,1,'2022-11-21 16:47:16','2022-12-07 06:29:08','2022-12-07 06:29:08'),(48,7938,40720,3171,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',228683.19,'IVA MENSUAL',NULL,1,'2022-11-21 16:49:38','2022-12-07 06:29:29','2022-12-07 06:29:29'),(49,7938,40720,3175,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',195585.02,'IVA MENSUAL',NULL,1,'2022-11-21 16:51:09','2022-12-07 06:29:53','2022-12-07 06:29:53'),(50,7938,40720,3176,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',299087.24,'IVA MENSUAL',NULL,1,'2022-11-21 16:52:42','2022-12-07 06:30:15','2022-12-07 06:30:15'),(51,7938,40720,3177,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',149376.09,'IVA MENSUAL',NULL,1,'2022-11-21 16:53:47','2022-12-07 06:30:35','2022-12-07 06:30:35'),(52,7938,40720,3178,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',363357.90,'IVA MENSUAL',NULL,1,'2022-11-21 16:54:50','2022-12-07 06:31:07','2022-12-07 06:31:07'),(53,7938,40720,3179,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',191130.00,'IVA MENSUAL',NULL,1,'2022-11-21 16:56:06','2022-12-07 06:31:29','2022-12-07 06:31:29'),(54,7938,40720,3180,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',195811.58,'IVA MENSUAL',NULL,1,'2022-11-21 16:57:28','2022-12-07 06:32:00','2022-12-07 06:32:00'),(55,7938,40720,3181,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',417680.15,'IVA MENSUAL',NULL,1,'2022-11-21 16:58:55','2022-12-07 06:32:30','2022-12-07 06:32:30'),(56,7938,40720,3182,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',195278.10,'IVA MENSUAL',NULL,1,'2022-11-21 17:00:02','2022-12-07 06:32:56','2022-12-07 06:32:56'),(57,7938,40720,3168,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',37347.26,'IIBB MENSUAL',NULL,1,'2022-11-22 16:56:31','2022-11-22 17:16:39','2022-11-22 17:16:39'),(58,7938,40720,3169,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',43295.77,'IIBB MENSUAL',NULL,1,'2022-11-22 16:57:29','2022-11-22 17:17:28','2022-11-22 17:17:28'),(59,7938,40720,3170,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',43300.09,'IIBB MENSUAL',NULL,1,'2022-11-22 16:58:30','2022-11-22 17:18:04','2022-11-22 17:18:04'),(60,7938,40720,3171,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',43530.36,'IIBB MENSUAL',NULL,1,'2022-11-22 16:59:38','2022-11-22 17:19:35','2022-11-22 17:19:35'),(61,7938,40720,3175,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',43759.23,'IIBB MENSUAL',NULL,1,'2022-11-22 17:00:37','2022-11-22 17:20:55','2022-11-22 17:20:55'),(62,7938,40720,3176,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',62516.31,'IIBB MENSUAL',NULL,1,'2022-11-22 17:01:34','2022-11-22 17:21:33','2022-11-22 17:21:33'),(63,7938,40720,3177,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',44841.22,'IIBB MENSUAL',NULL,1,'2022-11-22 17:02:29','2022-11-22 17:22:10','2022-11-22 17:22:10'),(64,7938,40720,3178,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',70852.38,'IIBB MENSUAL',NULL,1,'2022-11-22 17:05:03','2022-11-22 17:22:48','2022-11-22 17:22:48'),(65,7938,40720,3179,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',47810.37,'IIBB MENSUAL',NULL,1,'2022-11-22 17:06:45','2022-11-22 17:23:48','2022-11-22 17:23:48');
INSERT INTO `balance_libro` VALUES (66,7938,40720,3180,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',34284.00,'IIBB MENSUAL',NULL,1,'2022-11-22 17:07:26','2022-11-22 17:24:48','2022-11-22 17:24:48'),(67,7938,40720,3181,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',59921.53,'IIBB MENSUAL',NULL,1,'2022-11-22 17:08:15','2022-11-22 17:25:22','2022-11-22 17:25:22'),(68,7938,40720,3182,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',35745.83,'IIBB MENSUAL',NULL,1,'2022-11-22 17:09:17','2022-11-22 17:25:56','2022-11-22 17:25:56'),(69,7938,40720,3168,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',37347.26,'IIBB MENSUAL',NULL,1,'2022-11-22 17:16:39','2022-12-07 06:47:33','2022-12-07 06:47:33'),(70,7938,40720,3169,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',43295.77,'IIBB MENSUAL',NULL,1,'2022-11-22 17:17:28','2022-12-07 06:47:11','2022-12-07 06:47:11'),(71,7938,40720,3170,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',43300.09,'IIBB MENSUAL',NULL,1,'2022-11-22 17:18:04','2022-12-07 06:46:50','2022-12-07 06:46:50'),(72,7938,40720,3171,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',43530.36,'IIBB MENSUAL',NULL,1,'2022-11-22 17:19:35','2022-12-07 06:42:59','2022-12-07 06:42:59'),(73,7938,40720,3175,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',43759.23,'IIBB MENSUAL',NULL,1,'2022-11-22 17:20:55','2022-12-07 06:46:26','2022-12-07 06:46:26'),(74,7938,40720,3176,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',62516.31,'IIBB MENSUAL',NULL,1,'2022-11-22 17:21:33','2022-12-07 06:46:02','2022-12-07 06:46:02'),(75,7938,40720,3177,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',44841.22,'IIBB MENSUAL',NULL,1,'2022-11-22 17:22:10','2022-12-07 06:45:39','2022-12-07 06:45:39'),(76,7938,40720,3178,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',70852.38,'IIBB MENSUAL',NULL,1,'2022-11-22 17:22:48','2022-12-07 06:45:18','2022-12-07 06:45:18'),(77,7938,40720,3179,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',47810.37,'IIBB MENSUAL',NULL,1,'2022-11-22 17:23:48','2022-12-07 06:44:50','2022-12-07 06:44:50'),(78,7938,40720,3180,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',34284.00,'IIBB MENSUAL',NULL,1,'2022-11-22 17:24:48','2022-12-07 06:44:25','2022-12-07 06:44:25'),(79,7938,40720,3181,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',59921.53,'IIBB MENSUAL',NULL,1,'2022-11-22 17:25:22','2022-12-07 06:44:03','2022-12-07 06:44:03'),(80,7938,40720,3182,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',35745.83,'IIBB MENSUAL',NULL,1,'2022-11-22 17:25:56','2022-12-07 06:43:37','2022-12-07 06:43:37'),(81,7938,40720,3168,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',3033.48,'IIBB MENSUAL BSAS',NULL,1,'2022-11-22 17:30:15','2022-12-07 06:49:21','2022-12-07 06:49:21'),(82,7938,40720,3169,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',2925.61,'IIBB MENSUAL BSAS',NULL,1,'2022-11-22 17:31:08','2022-12-07 06:49:48','2022-12-07 06:49:48'),(83,7938,40720,3170,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2732.83,'IIBB MENSUAL BSAS',NULL,1,'2022-11-22 17:31:55','2022-12-07 06:42:31','2022-12-07 06:42:31'),(84,7938,40720,3170,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2540.05,'IIBB MENSUAL BSAS',NULL,1,'2022-11-22 17:32:46','2022-11-22 17:33:26','2022-11-22 17:33:26'),(85,7938,40720,3171,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2540.05,'IIBB MENSUAL BSAS',NULL,1,'2022-11-22 17:33:51','2022-12-07 06:41:49','2022-12-07 06:41:49'),(86,7938,40720,3175,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',2347.28,'IIBB MENSUAL BSAS',NULL,1,'2022-11-22 17:34:33','2022-12-07 06:48:55','2022-12-07 06:48:55');
INSERT INTO `balance_libro` VALUES (87,7938,40720,3176,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',2178.50,'IIBB MENSUAL BSAS',NULL,1,'2022-11-22 17:37:22','2022-12-07 06:41:27','2022-12-07 06:41:27'),(88,7938,40720,3177,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1786.04,'IIBB MENSUAL BSAS',NULL,1,'2022-11-22 17:38:34','2022-12-07 06:41:08','2022-12-07 06:41:08'),(89,7938,40720,3178,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1616.98,'IIBB MENSUAL BSAS',NULL,1,'2022-11-22 17:39:27','2022-12-07 06:40:47','2022-12-07 06:40:47'),(90,7938,40720,3179,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1156.50,'IIBB MENSUAL BSAS',NULL,1,'2022-11-22 17:40:22','2022-12-07 06:40:27','2022-12-07 06:40:27'),(91,7938,40720,3180,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',987.43,'IIBB MENSUAL BSAS',NULL,1,'2022-11-22 17:41:10','2022-12-07 06:40:06','2022-12-07 06:40:06'),(92,7938,40720,3181,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',818.29,'IIBB MENSUAL BSAS',NULL,1,'2022-11-22 17:42:01','2022-12-07 06:39:46','2022-12-07 06:39:46'),(93,7938,40720,3182,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',341.78,'IIBB MENSUAL BSAS',NULL,1,'2022-11-22 17:43:07','2022-12-07 06:39:21','2022-12-07 06:39:21'),(94,7938,40720,1518,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',51481.11,'Plazo fijo',NULL,1,'2022-12-07 05:17:43','2022-12-07 05:17:43',NULL),(95,7938,40720,1519,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',52799.91,'Plazo fijo',NULL,1,'2022-12-07 05:18:40','2022-12-07 05:18:40',NULL),(96,7938,40720,1520,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',54231.15,'Plazo fijo',NULL,1,'2022-12-07 05:19:38','2022-12-07 05:19:38',NULL),(97,7938,40720,1521,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',57557.89,'Plazo fijo',NULL,1,'2022-12-07 05:20:44','2022-12-07 05:20:44',NULL),(98,7938,40720,1525,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',4004603.29,'Variaciones plazo fijo',NULL,1,'2022-12-07 05:24:15','2022-12-07 05:24:15',NULL),(99,7938,40720,1525,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',57261.39,'Plazo fijo',NULL,1,'2022-12-07 05:26:23','2022-12-07 05:26:23',NULL),(100,7938,40720,1526,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',61269.68,'Plazo fijo',NULL,1,'2022-12-07 05:28:12','2022-12-07 05:28:12',NULL),(101,7938,40720,1527,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',83442.93,'Plazo fijo',NULL,1,'2022-12-07 05:29:10','2022-12-07 05:29:10',NULL),(102,7938,40720,1527,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1000000.00,'Aumento plazo fijo',NULL,1,'2022-12-07 05:29:55','2022-12-07 05:29:55',NULL),(103,7938,40720,1528,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',70794.95,'Plazo fijo',NULL,1,'2022-12-07 05:30:57','2022-12-07 05:30:57',NULL),(104,7938,40720,1529,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',111162.65,'Plazo fijo',NULL,1,'2022-12-07 05:32:47','2022-12-07 05:32:47',NULL),(105,7938,40720,1529,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',2702860.28,'Aumento plazo fijo',NULL,1,'2022-12-07 05:34:25','2022-12-07 10:38:15','2022-12-07 10:38:15'),(106,7938,40720,1530,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',153212.54,'Plazo fijo',NULL,1,'2022-12-07 05:35:20','2022-12-07 05:35:20',NULL),(107,7938,40720,1530,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2348210.95,'Aumento plazo fijo',NULL,1,'2022-12-07 05:36:10','2022-12-07 05:36:10',NULL),(108,7938,40720,1531,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',160162.22,'Plazo fijo',NULL,1,'2022-12-07 05:37:10','2022-12-07 05:37:10',NULL);
INSERT INTO `balance_libro` VALUES (109,7938,40720,1531,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',858276.48,'Aumento plazo fijo',NULL,1,'2022-12-07 05:42:53','2022-12-07 11:13:19','2022-12-07 11:13:19'),(110,7938,40720,1532,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',212498.62,'Plazo fijo',NULL,1,'2022-12-07 05:44:30','2022-12-07 11:40:30','2022-12-07 11:40:30'),(111,7938,40720,1518,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',320446.43,'Egresos mensuales',NULL,1,'2022-12-07 05:48:35','2022-12-07 07:13:49','2022-12-07 07:13:49'),(112,7938,40720,1519,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',488720.02,'Egresos mensuales',NULL,1,'2022-12-07 05:50:26','2022-12-07 12:24:37','2022-12-07 12:24:37'),(113,7938,40720,1520,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',247436.29,'Egresos mensuales',NULL,1,'2022-12-07 05:51:27','2022-12-07 08:32:46','2022-12-07 08:32:46'),(114,7938,40720,1521,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',325002.80,'Egresos mensuales',NULL,1,'2022-12-07 05:57:49','2022-12-07 08:37:31','2022-12-07 08:37:31'),(115,7938,40720,1525,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',263136.59,'Egresos mensuales',NULL,1,'2022-12-07 05:58:19','2022-12-07 12:32:10','2022-12-07 12:32:10'),(116,7938,40720,1526,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',329493.33,'Egresos mensuales',NULL,1,'2022-12-07 05:59:17','2022-12-07 12:28:06','2022-12-07 12:28:06'),(117,7938,40720,1527,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',253741.69,'Egresos mensuales',NULL,1,'2022-12-07 06:03:57','2022-12-07 12:29:34','2022-12-07 12:29:34'),(118,7938,40720,1528,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',631541.65,'Egresos mensuales',NULL,1,'2022-12-07 06:10:30','2022-12-07 06:15:32','2022-12-07 06:15:32'),(119,7938,40720,1528,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',652361.12,'Egresos mensuales',NULL,1,'2022-12-07 06:15:32','2022-12-07 12:27:05','2022-12-07 12:27:05'),(120,7938,40720,1529,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',351027.30,'Egresos mensuales',NULL,1,'2022-12-07 06:17:31','2022-12-07 12:27:39','2022-12-07 12:27:39'),(121,7938,40720,1532,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',415562.19,'Egresos mensuales',NULL,1,'2022-12-07 06:18:58','2022-12-07 12:25:11','2022-12-07 12:25:11'),(122,7938,40720,1531,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',645546.65,'Egresos mensuales',NULL,1,'2022-12-07 06:21:03','2022-12-07 06:38:45','2022-12-07 06:38:45'),(123,7938,40720,1530,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',313101.07,'Egresos mensuales',NULL,1,'2022-12-07 06:23:42','2022-12-07 12:28:37','2022-12-07 12:28:37'),(124,7938,40720,1518,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',122942.49,'IVA MENSUAL',NULL,1,'2022-12-07 06:27:53','2022-12-07 06:27:53',NULL),(125,7938,40720,1519,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',171391.12,'IVA MENSUAL',NULL,1,'2022-12-07 06:28:31','2022-12-07 06:28:31',NULL),(126,7938,40720,1520,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',171384.95,'IVA MENSUAL',NULL,1,'2022-12-07 06:29:08','2022-12-07 06:29:08',NULL),(127,7938,40720,1521,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',228683.19,'IVA MENSUAL',NULL,1,'2022-12-07 06:29:29','2022-12-07 12:00:07','2022-12-07 12:00:07'),(128,7938,40720,1525,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',195585.02,'IVA MENSUAL',NULL,1,'2022-12-07 06:29:53','2022-12-07 12:03:18','2022-12-07 12:03:18'),(129,7938,40720,1526,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',299087.24,'IVA MENSUAL',NULL,1,'2022-12-07 06:30:15','2022-12-07 12:02:56','2022-12-07 12:02:56');
INSERT INTO `balance_libro` VALUES (130,7938,40720,1527,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',149376.09,'IVA MENSUAL',NULL,1,'2022-12-07 06:30:35','2022-12-07 06:30:35',NULL),(131,7938,40720,1528,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',363357.90,'IVA MENSUAL',NULL,1,'2022-12-07 06:31:07','2022-12-07 06:31:07',NULL),(132,7938,40720,1529,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',191130.00,'IVA MENSUAL',NULL,1,'2022-12-07 06:31:29','2022-12-07 12:01:55','2022-12-07 12:01:55'),(133,7938,40720,1530,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',195811.58,'IVA MENSUAL',NULL,1,'2022-12-07 06:32:00','2022-12-07 12:01:37','2022-12-07 12:01:37'),(134,7938,40720,1531,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',417680.15,'IVA MENSUAL',NULL,1,'2022-12-07 06:32:30','2022-12-07 06:32:30',NULL),(135,7938,40720,1532,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',195278.10,'IVA MENSUAL',NULL,1,'2022-12-07 06:32:56','2022-12-07 12:00:51','2022-12-07 12:00:51'),(136,7938,40720,1531,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',661435.12,'Egresos mensuales',NULL,1,'2022-12-07 06:38:45','2022-12-07 12:30:05','2022-12-07 12:30:05'),(137,7938,40720,1532,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',341.78,'IIBB MENSUAL BSAS',NULL,1,'2022-12-07 06:39:21','2022-12-07 06:39:21',NULL),(138,7938,40720,1531,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',818.29,'IIBB MENSUAL BSAS',NULL,1,'2022-12-07 06:39:46','2022-12-07 06:39:46',NULL),(139,7938,40720,1530,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',987.43,'IIBB MENSUAL BSAS',NULL,1,'2022-12-07 06:40:06','2022-12-07 06:40:06',NULL),(140,7938,40720,1529,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1156.50,'IIBB MENSUAL BSAS',NULL,1,'2022-12-07 06:40:27','2022-12-07 06:40:27',NULL),(141,7938,40720,1528,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1616.98,'IIBB MENSUAL BSAS',NULL,1,'2022-12-07 06:40:47','2022-12-07 06:40:47',NULL),(142,7938,40720,1527,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1786.04,'IIBB MENSUAL BSAS',NULL,1,'2022-12-07 06:41:08','2022-12-07 06:41:08',NULL),(143,7938,40720,1526,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',2178.50,'IIBB MENSUAL BSAS',NULL,1,'2022-12-07 06:41:27','2022-12-07 06:41:27',NULL),(144,7938,40720,1521,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2540.05,'IIBB MENSUAL BSAS',NULL,1,'2022-12-07 06:41:49','2022-12-07 06:41:49',NULL),(145,7938,40720,1520,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',2732.83,'IIBB MENSUAL BSAS',NULL,1,'2022-12-07 06:42:31','2022-12-07 06:42:31',NULL),(146,7938,40720,1521,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',43530.36,'IIBB MENSUAL',NULL,1,'2022-12-07 06:42:59','2022-12-07 06:42:59',NULL),(147,7938,40720,1532,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',35745.83,'IIBB MENSUAL',NULL,1,'2022-12-07 06:43:37','2022-12-07 06:43:37',NULL),(148,7938,40720,1531,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',59921.53,'IIBB MENSUAL',NULL,1,'2022-12-07 06:44:03','2022-12-07 06:44:03',NULL),(149,7938,40720,1530,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',34284.00,'IIBB MENSUAL',NULL,1,'2022-12-07 06:44:25','2022-12-07 06:44:25',NULL),(150,7938,40720,1529,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',47810.37,'IIBB MENSUAL',NULL,1,'2022-12-07 06:44:50','2022-12-07 06:44:50',NULL),(151,7938,40720,1528,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',70852.38,'IIBB MENSUAL',NULL,1,'2022-12-07 06:45:18','2022-12-07 06:45:18',NULL);
INSERT INTO `balance_libro` VALUES (152,7938,40720,1527,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',44841.22,'IIBB MENSUAL',NULL,1,'2022-12-07 06:45:39','2022-12-07 06:45:39',NULL),(153,7938,40720,1526,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',62516.31,'IIBB MENSUAL',NULL,1,'2022-12-07 06:46:02','2022-12-07 06:46:02',NULL),(154,7938,40720,1525,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',43759.23,'IIBB MENSUAL',NULL,1,'2022-12-07 06:46:26','2022-12-07 06:46:26',NULL),(155,7938,40720,1520,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',43300.09,'IIBB MENSUAL',NULL,1,'2022-12-07 06:46:50','2022-12-07 06:46:50',NULL),(156,7938,40720,1519,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',43295.77,'IIBB MENSUAL',NULL,1,'2022-12-07 06:47:11','2022-12-07 06:47:11',NULL),(157,7938,40720,1518,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',37347.26,'IIBB MENSUAL',NULL,1,'2022-12-07 06:47:33','2022-12-07 06:47:33',NULL),(158,7938,40720,1525,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',2347.28,'IIBB MENSUAL BSAS',NULL,1,'2022-12-07 06:48:55','2022-12-07 06:48:55',NULL),(159,7938,40720,1518,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',3033.48,'IIBB MENSUAL BSAS',NULL,1,'2022-12-07 06:49:21','2022-12-07 06:49:21',NULL),(160,7938,40720,1519,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',2925.61,'IIBB MENSUAL BSAS',NULL,1,'2022-12-07 06:49:48','2022-12-07 06:49:48',NULL),(161,7938,40720,1518,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',32880.74,'Correccion monto saldo a favor IIBB',NULL,1,'2022-12-07 07:11:03','2022-12-07 07:12:47','2022-12-07 07:12:47'),(162,7938,40720,1518,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',32880.74,'Correccion monto saldo a favor IIBB',NULL,1,'2022-12-07 07:12:47','2022-12-07 07:12:47',NULL),(163,7938,40720,1518,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',320445.93,'Egresos mensuales',NULL,1,'2022-12-07 07:13:49','2022-12-07 12:29:06','2022-12-07 12:29:06'),(164,7938,40720,1518,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',19701.04,'Anticipo impuesto a las ganancias 8',NULL,1,'2022-12-07 07:27:49','2022-12-07 12:08:43','2022-12-07 12:08:43'),(165,7938,40720,1519,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',19701.04,'Anticipo impuesto a las ganancias 9',NULL,1,'2022-12-07 07:28:32','2022-12-07 12:09:03','2022-12-07 12:09:03'),(166,7938,40720,1520,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',19701.04,'Anticipo impuesto a las ganancias 10',NULL,1,'2022-12-07 07:29:24','2022-12-07 12:09:23','2022-12-07 12:09:23'),(167,7938,40720,1526,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',73446.16,'Anticipo impuesto a las ganancias 1',NULL,1,'2022-12-07 07:31:18','2022-12-07 12:08:03','2022-12-07 12:08:03'),(168,7938,40720,1527,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',24472.26,'Anticipo impuesto a las ganancias 2',NULL,1,'2022-12-07 07:32:13','2022-12-07 11:25:38','2022-12-07 11:25:38'),(169,7938,40720,1528,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',60118.97,'Anticipo impuesto a las ganancias 3',NULL,1,'2022-12-07 07:33:25','2022-12-07 12:08:24','2022-12-07 12:08:24'),(170,7938,40720,1529,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',24517.00,'Anticipo impuesto a las ganancias 4',NULL,1,'2022-12-07 07:34:30','2022-12-07 12:07:42','2022-12-07 12:07:42'),(171,7938,40720,1530,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',25159.04,'Anticipo impuesto a las ganancias 5',NULL,1,'2022-12-07 07:35:32','2022-12-07 12:09:43','2022-12-07 12:09:43');
INSERT INTO `balance_libro` VALUES (172,7938,40720,1531,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',24472.26,'Anticipo impuesto a las ganancias 6',NULL,1,'2022-12-07 07:36:16','2022-12-07 07:39:12','2022-12-07 07:39:12'),(173,7938,40720,1532,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',24472.26,'Anticipo impuesto a las ganancias 7',NULL,1,'2022-12-07 07:37:14','2022-12-07 12:06:37','2022-12-07 12:06:37'),(174,7938,40720,1531,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',24472.26,'Anticipo impuesto a las ganancias 6',NULL,1,'2022-12-07 07:39:12','2022-12-07 12:07:22','2022-12-07 12:07:22'),(175,7938,40720,1525,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',356632.47,'Impuesto  a las ganancias 13-01',NULL,1,'2022-12-07 07:48:52','2022-12-07 07:48:52',NULL),(176,7938,40720,1526,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',830335.12,'Distribución de utilidades',NULL,1,'2022-12-07 08:02:24','2022-12-07 08:04:55','2022-12-07 08:04:55'),(177,7938,40720,1526,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1130125.41,'Distribución de utilidades',NULL,1,'2022-12-07 08:04:55','2022-12-07 13:34:01','2022-12-07 13:34:01'),(178,7938,40720,1518,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',160000.00,'Devolución prestamo broker',NULL,1,'2022-12-07 08:17:52','2022-12-07 08:17:52',NULL),(179,7938,40720,1528,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',150000.00,'Prestamo broker',NULL,1,'2022-12-07 08:23:39','2022-12-07 08:23:39',NULL),(180,7938,40720,1520,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',244182.43,'Egresos mensuales',NULL,1,'2022-12-07 08:32:46','2022-12-07 12:23:05','2022-12-07 12:23:05'),(181,7938,40720,1521,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',324999.80,'Egresos mensuales',NULL,1,'2022-12-07 08:37:31','2022-12-07 08:41:48','2022-12-07 08:41:48'),(182,7938,40720,1521,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',324984.81,'Egresos mensuales',NULL,1,'2022-12-07 08:41:48','2022-12-07 08:45:19','2022-12-07 08:45:19'),(183,7938,40720,1521,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',325005.80,'Egresos mensuales',NULL,1,'2022-12-07 08:45:19','2022-12-07 12:22:28','2022-12-07 12:22:28'),(184,7938,40720,1529,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',2771531.38,'Aumento plazo fijo',NULL,1,'2022-12-07 10:38:15','2022-12-07 10:39:27','2022-12-07 10:39:27'),(185,7938,40720,1529,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',2771531.38,'Aumento plazo fijo',NULL,1,'2022-12-07 10:39:27','2022-12-07 10:43:48','2022-12-07 10:43:48'),(186,7938,40720,1529,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',2702860.28,'Aumento plazo fijo',NULL,1,'2022-12-07 10:43:48','2022-12-07 11:01:50','2022-12-07 11:01:50'),(187,7938,40720,1529,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',497139.75,'Aumento plazo fijo',NULL,1,'2022-12-07 11:01:50','2022-12-07 11:01:50',NULL),(188,7938,40720,1531,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',864352.72,'Aumento plazo fijo',NULL,1,'2022-12-07 11:13:19','2022-12-07 11:38:45','2022-12-07 11:38:45'),(189,7938,40720,1532,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',250619.67,'Ajuste banco',NULL,1,'2022-12-07 11:18:10','2022-12-07 11:19:44','2022-12-07 11:19:44'),(190,7938,40720,1532,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',250619.67,'Ajuste banco',NULL,1,'2022-12-07 11:19:44','2022-12-07 11:19:44',NULL),(191,7938,40720,1527,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',24472.26,'Anticipo impuesto a las ganancias 2',NULL,1,'2022-12-07 11:25:38','2022-12-07 12:07:01','2022-12-07 12:07:01');
INSERT INTO `balance_libro` VALUES (192,7938,40720,1531,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',858276.45,'Aumento plazo fijo',NULL,1,'2022-12-07 11:38:45','2022-12-07 11:38:45',NULL),(193,7938,40720,1532,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',212498.65,'Plazo fijo',NULL,1,'2022-12-07 11:40:30','2022-12-07 11:40:30',NULL),(194,7938,40720,1520,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',544500.00,'SANCOR',NULL,1,'2022-12-07 11:49:45','2022-12-07 11:51:49','2022-12-07 11:51:49'),(195,7938,40720,1518,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',302500.00,'SANCOR',NULL,1,'2022-12-07 11:50:16','2022-12-07 12:33:45','2022-12-07 12:33:45'),(196,7938,40720,1520,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',544500.00,'SANCOR',NULL,1,'2022-12-07 11:51:49','2022-12-07 11:51:49',NULL),(197,7938,40720,1519,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',544500.00,'SANCOR',NULL,1,'2022-12-07 11:52:28','2022-12-07 11:52:28',NULL),(198,7938,40720,1521,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',228683.19,'IVA MENSUAL',NULL,1,'2022-12-07 12:00:07','2022-12-07 13:03:14','2022-12-07 13:03:14'),(199,7938,40720,1532,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',195278.10,'IVA MENSUAL',NULL,1,'2022-12-07 12:00:51','2022-12-07 12:00:51',NULL),(200,7938,40720,1530,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',195811.58,'IVA MENSUAL',NULL,1,'2022-12-07 12:01:37','2022-12-07 13:06:37','2022-12-07 13:06:37'),(201,7938,40720,1529,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',191130.00,'IVA MENSUAL',NULL,1,'2022-12-07 12:01:55','2022-12-07 12:01:55',NULL),(202,7938,40720,1526,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',299087.24,'IVA MENSUAL',NULL,1,'2022-12-07 12:02:56','2022-12-07 13:05:20','2022-12-07 13:05:20'),(203,7938,40720,1525,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',195585.02,'IVA MENSUAL',NULL,1,'2022-12-07 12:03:18','2022-12-07 12:03:18',NULL),(204,7938,40720,1532,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',24472.26,'Anticipo impuesto a las ganancias 7',NULL,1,'2022-12-07 12:06:37','2022-12-07 12:06:37',NULL),(205,7938,40720,1527,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',24472.26,'Anticipo impuesto a las ganancias 2',NULL,1,'2022-12-07 12:07:01','2022-12-07 12:07:01',NULL),(206,7938,40720,1531,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',24472.26,'Anticipo impuesto a las ganancias 6',NULL,1,'2022-12-07 12:07:22','2022-12-07 12:40:09','2022-12-07 12:40:09'),(207,7938,40720,1529,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',24517.00,'Anticipo impuesto a las ganancias 4',NULL,1,'2022-12-07 12:07:42','2022-12-07 12:07:42',NULL),(208,7938,40720,1526,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',73446.16,'Anticipo impuesto a las ganancias 1',NULL,1,'2022-12-07 12:08:03','2022-12-07 12:08:03',NULL),(209,7938,40720,1528,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',60118.97,'Anticipo impuesto a las ganancias 3',NULL,1,'2022-12-07 12:08:24','2022-12-07 12:08:24',NULL),(210,7938,40720,1518,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',19701.04,'Anticipo impuesto a las ganancias 8',NULL,1,'2022-12-07 12:08:43','2022-12-07 12:08:43',NULL),(211,7938,40720,1519,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',19701.04,'Anticipo impuesto a las ganancias 9',NULL,1,'2022-12-07 12:09:03','2022-12-07 12:09:03',NULL),(212,7938,40720,1520,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',19701.04,'Anticipo impuesto a las ganancias 10',NULL,1,'2022-12-07 12:09:23','2022-12-07 12:09:23',NULL);
INSERT INTO `balance_libro` VALUES (213,7938,40720,1530,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',25159.04,'Anticipo impuesto a las ganancias 5',NULL,1,'2022-12-07 12:09:43','2022-12-07 12:09:43',NULL),(214,7938,40720,1521,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',325005.80,'Egresos mensuales',NULL,1,'2022-12-07 12:22:28','2022-12-07 13:25:47','2022-12-07 13:25:47'),(215,7938,40720,1520,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',244182.43,'Egresos mensuales',NULL,1,'2022-12-07 12:23:05','2022-12-07 12:23:05',NULL),(216,7938,40720,1519,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',488720.02,'Egresos mensuales',NULL,1,'2022-12-07 12:24:37','2022-12-07 12:24:37',NULL),(217,7938,40720,1532,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',415562.19,'Egresos mensuales',NULL,1,'2022-12-07 12:25:11','2022-12-07 13:24:39','2022-12-07 13:24:39'),(218,7938,40720,1528,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',652361.12,'Egresos mensuales',NULL,1,'2022-12-07 12:27:05','2022-12-07 13:19:43','2022-12-07 13:19:43'),(219,7938,40720,1529,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',351027.30,'Egresos mensuales',NULL,1,'2022-12-07 12:27:39','2022-12-07 13:24:06','2022-12-07 13:24:06'),(220,7938,40720,1526,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',329493.33,'Egresos mensuales',NULL,1,'2022-12-07 12:28:06','2022-12-07 13:20:16','2022-12-07 13:20:16'),(221,7938,40720,1530,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',313101.07,'Egresos mensuales',NULL,1,'2022-12-07 12:28:37','2022-12-07 13:23:35','2022-12-07 13:23:35'),(222,7938,40720,1518,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',320445.93,'Egresos mensuales',NULL,1,'2022-12-07 12:29:06','2022-12-07 13:23:06','2022-12-07 13:23:06'),(223,7938,40720,1527,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',253741.69,'Egresos mensuales',NULL,1,'2022-12-07 12:29:34','2022-12-07 13:20:52','2022-12-07 13:20:52'),(224,7938,40720,1531,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',661435.12,'Egresos mensuales',NULL,1,'2022-12-07 12:30:05','2022-12-07 13:18:44','2022-12-07 13:18:44'),(225,7938,40720,1525,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',263136.59,'Egresos mensuales',NULL,1,'2022-12-07 12:32:10','2022-12-07 13:18:12','2022-12-07 13:18:12'),(226,7938,40720,1518,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',302500.00,'SANCOR',NULL,1,'2022-12-07 12:33:45','2022-12-07 12:33:45',NULL),(227,7938,40720,1531,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',24472.26,'Anticipo impuesto a las ganancias 6',NULL,1,'2022-12-07 12:40:09','2022-12-07 12:40:09',NULL),(228,7938,40720,1532,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',22148.17,NULL,NULL,1,'2022-12-07 12:43:19','2022-12-07 12:43:19',NULL),(229,7938,40720,1529,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',6908.64,'PREVENCION SALUD',NULL,1,'2022-12-07 13:00:14','2022-12-07 13:00:14',NULL),(230,7938,40720,1521,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',228683.19,'IVA MENSUAL',NULL,1,'2022-12-07 13:03:14','2022-12-07 13:03:14',NULL),(231,7938,40720,1526,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',299087.24,'IVA MENSUAL',NULL,1,'2022-12-07 13:05:20','2022-12-07 13:05:20',NULL),(232,7938,40720,1530,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',195811.58,'IVA MENSUAL',NULL,1,'2022-12-07 13:06:37','2022-12-07 13:08:36','2022-12-07 13:08:36'),(233,7938,40720,1530,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',195811.58,'IVA MENSUAL',NULL,1,'2022-12-07 13:08:36','2022-12-07 13:10:03','2022-12-07 13:10:03');
INSERT INTO `balance_libro` VALUES (234,7938,40720,1530,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',195811.58,'IVA MENSUAL',NULL,1,'2022-12-07 13:10:03','2022-12-07 13:10:03',NULL),(235,7938,40720,1518,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',3052368.60,'Asinto inicial',NULL,1,'2022-12-07 13:12:43','2022-12-07 13:12:43',NULL),(236,7938,40720,1525,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',263136.59,'Egresos mensuales',NULL,1,'2022-12-07 13:18:12','2022-12-07 13:18:12',NULL),(237,7938,40720,1531,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',661435.12,'Egresos mensuales',NULL,1,'2022-12-07 13:18:44','2022-12-07 13:18:44',NULL),(238,7938,40720,1528,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',652361.12,'Egresos mensuales',NULL,1,'2022-12-07 13:19:43','2022-12-07 13:19:43',NULL),(239,7938,40720,1526,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',329493.33,'Egresos mensuales',NULL,1,'2022-12-07 13:20:16','2022-12-07 13:20:16',NULL),(240,7938,40720,1527,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',253741.69,'Egresos mensuales',NULL,1,'2022-12-07 13:20:52','2022-12-07 13:20:52',NULL),(241,7938,40720,1518,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',320445.93,'Egresos mensuales',NULL,1,'2022-12-07 13:23:06','2022-12-07 13:23:06',NULL),(242,7938,40720,1530,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',313101.07,'Egresos mensuales',NULL,1,'2022-12-07 13:23:35','2022-12-07 13:23:35',NULL),(243,7938,40720,1529,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',351027.30,'Egresos mensuales',NULL,1,'2022-12-07 13:24:06','2022-12-07 13:24:06',NULL),(244,7938,40720,1532,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',415562.19,'Egresos mensuales',NULL,1,'2022-12-07 13:24:39','2022-12-07 13:24:39',NULL),(245,7938,40720,1521,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',325005.80,'Egresos mensuales',NULL,1,'2022-12-07 13:25:47','2022-12-07 13:25:47',NULL),(246,7938,40720,1526,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1130125.41,'Distribución de utilidades',NULL,1,'2022-12-07 13:34:01','2022-12-09 10:47:23','2022-12-09 10:47:23'),(247,7938,40720,1532,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',0.00,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-07 13:49:54','2022-12-07 13:50:26','2022-12-07 13:50:26'),(248,7938,40720,1532,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',391815.91,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-07 13:50:06','2022-12-07 13:50:57','2022-12-07 13:50:57'),(249,7938,40720,1526,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',49998.32,NULL,NULL,1,'2022-12-09 10:41:25','2022-12-09 10:41:25',NULL),(250,7938,40720,1533,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',477123.00,'Aajuste caja dolares',NULL,1,'2022-12-09 10:42:38','2022-12-09 10:47:46','2022-12-09 10:47:46'),(251,7938,40720,1526,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1325875.41,'Distribución de utilidades',NULL,1,'2022-12-09 10:47:23','2022-12-09 13:44:00','2022-12-09 13:44:00'),(252,7938,40720,1533,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',477123.00,'Ajuste caja dolares',NULL,1,'2022-12-09 10:47:46','2022-12-09 10:51:56','2022-12-09 10:51:56'),(253,7938,40720,1533,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',477123.29,'Ajuste caja dolares',NULL,1,'2022-12-09 10:51:56','2022-12-09 11:05:44','2022-12-09 11:05:44'),(254,7938,40720,1532,14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',74956.35,'ajuste interes plazo fijo',NULL,1,'2022-12-09 11:05:18','2022-12-09 11:11:39','2022-12-09 11:11:39');
INSERT INTO `balance_libro` VALUES (255,7938,40720,1533,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',477123.29,'Ajuste caja dolares',NULL,1,'2022-12-09 11:05:44','2022-12-13 05:24:51','2022-12-13 05:24:51'),(256,7938,40720,1532,14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',74956.35,'ajuste interes plazo fijo',NULL,1,'2022-12-09 11:11:39','2022-12-09 11:14:38','2022-12-09 11:14:38'),(257,7938,40720,1532,14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',74956.35,'ajuste interes plazo fijo',NULL,1,'2022-12-09 11:14:38','2022-12-09 11:14:38',NULL),(258,7938,40720,1532,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',74956.35,NULL,NULL,1,'2022-12-09 11:15:12','2022-12-09 11:15:12',NULL),(259,7938,40720,1532,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2806303.97,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-09 12:33:00','2022-12-09 13:04:36','2022-12-09 13:04:36'),(260,7938,40720,1532,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1599708.88,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-09 13:17:24','2022-12-09 13:48:27','2022-12-09 13:48:27'),(261,7938,40720,1532,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1599708.88,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-09 13:17:44','2022-12-09 13:50:20','2022-12-09 13:50:20'),(262,7938,40720,1526,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1325875.41,'Distribución de utilidades',NULL,1,'2022-12-09 13:44:00','2022-12-09 13:44:00',NULL),(263,7938,40720,1532,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1014880.89,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-09 14:03:43','2022-12-09 14:31:25','2022-12-09 14:31:25'),(264,7938,40720,1532,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1014880.89,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-09 14:31:25','2022-12-09 14:31:30','2022-12-09 14:31:30'),(265,7938,40720,1532,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1014880.89,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-09 14:32:23','2022-12-09 14:33:49','2022-12-09 14:33:49'),(266,7938,40720,1532,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1159682.07,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-09 14:33:26','2022-12-09 14:36:41','2022-12-09 14:36:41'),(267,7938,40720,1532,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1599708.88,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-09 14:38:20','2022-12-13 05:12:51','2022-12-13 05:12:51'),(268,7938,40721,3183,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',578825.33,'asiento inicial',NULL,1,'2022-12-10 09:55:23','2022-12-10 09:55:23',NULL),(269,7938,40720,1532,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',4368503.75,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-13 05:14:45','2022-12-13 05:24:57','2022-12-13 05:24:57'),(270,7938,40720,1532,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',477123.29,'Ajuste caja dolares',NULL,1,'2022-12-13 05:24:51','2022-12-13 05:24:51',NULL),(271,7938,40720,1532,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',4368503.75,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-13 05:26:35','2022-12-13 05:35:51','2022-12-13 05:35:51'),(272,7938,40720,1532,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',4368503.75,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-12-13 05:38:23','2022-12-13 05:38:25',NULL),(273,7938,40721,3183,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',227113.73,'IVA MENSUAL',NULL,1,'2022-12-26 11:46:01','2022-12-26 11:46:01',NULL),(274,7938,40721,3184,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',198411.19,'IVA MENSUAL',NULL,1,'2022-12-26 11:48:34','2022-12-26 11:48:34',NULL);
INSERT INTO `balance_libro` VALUES (275,7938,40721,3185,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',191040.94,'IVA MENSUAL',NULL,1,'2022-12-26 11:49:53','2022-12-26 11:49:53',NULL),(276,7938,40721,3186,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',192671.42,'IVA MENSUAL',NULL,1,'2022-12-26 11:53:26','2022-12-26 11:53:26',NULL),(277,7938,40721,3190,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',213470.76,'IVA MENSUAL',NULL,1,'2022-12-26 11:54:45','2022-12-26 11:54:45',NULL),(278,7938,40721,3191,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',219928.66,'IVA MENSUAL',NULL,1,'2022-12-26 11:56:10','2022-12-26 11:56:10',NULL),(279,7938,40721,3191,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',219928.66,'IVA MENSUAL',NULL,1,'2022-12-26 11:56:19','2022-12-26 12:12:29','2022-12-26 12:12:29'),(280,7938,40721,3192,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',253504.80,'IVA MENSUAL',NULL,1,'2022-12-26 11:57:45','2022-12-26 11:57:45',NULL),(281,7938,40721,3193,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',278369.09,'IVA MENSUAL',NULL,1,'2022-12-26 11:58:51','2022-12-26 11:58:51',NULL),(282,7938,40721,3194,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',297020.00,'IVA MENSUAL',NULL,1,'2022-12-26 12:00:02','2022-12-26 12:00:02',NULL),(283,7938,40721,3195,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',340842.24,'IVA MENSUAL',NULL,1,'2022-12-26 12:02:00','2022-12-26 12:02:00',NULL),(284,7938,40721,3196,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',598397.50,'IVA MENSUAL',NULL,1,'2022-12-26 12:03:19','2023-01-03 21:43:22','2023-01-03 21:43:22'),(285,7938,40721,3197,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',835177.17,'IVA MENSUAL',NULL,1,'2022-12-26 12:04:39','2022-12-26 12:04:39',NULL),(286,7938,40721,3183,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',112123.35,'IIBB MENSUAL BROKER',NULL,1,'2022-12-26 12:14:38','2023-01-03 14:02:11','2023-01-03 14:02:11'),(287,7938,40721,3184,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',83849.09,'IIBB MENSUAL BROKER',NULL,1,'2022-12-26 12:15:50','2023-01-03 14:02:38','2023-01-03 14:02:38'),(288,7938,40721,3185,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',72973.94,'IIBB MENSUAL BROKER',NULL,1,'2022-12-26 12:16:54','2023-01-03 14:01:00','2023-01-03 14:01:00'),(289,7938,40721,3186,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',73931.81,'IIBB MENSUAL BROKER',NULL,1,'2022-12-26 12:17:57','2023-01-03 14:00:34','2023-01-03 14:00:34'),(290,7938,40721,3190,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',79859.16,'IIBB MENSUAL BROKER',NULL,1,'2022-12-26 12:19:29','2023-01-03 14:01:40','2023-01-03 14:01:40'),(291,7938,40721,3191,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',82414.01,'IIBB MENSUAL BROKER',NULL,1,'2022-12-26 12:20:44','2023-01-03 14:00:09','2023-01-03 14:00:09'),(292,7938,40721,3192,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',92138.51,'IIBB MENSUAL BROKER',NULL,1,'2022-12-26 12:30:00','2023-01-03 13:59:17','2023-01-03 13:59:17'),(293,7938,40721,3193,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',98753.51,'IIBB MENSUAL BROKER',NULL,1,'2022-12-26 12:31:59','2023-01-03 13:59:45','2023-01-03 13:59:45'),(294,7938,40721,3194,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',99574.43,'IIBB MENSUAL BROKER',NULL,1,'2022-12-26 12:33:31','2023-01-03 13:58:50','2023-01-03 13:58:50'),(295,7938,40721,3195,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',106915.93,'IIBB MENSUAL BROKER',NULL,1,'2022-12-26 12:35:14','2023-01-03 13:58:23','2023-01-03 13:58:23');
INSERT INTO `balance_libro` VALUES (296,7938,40721,3196,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',179639.10,'IIBB MENSUAL BROKER',NULL,1,'2022-12-26 12:36:42','2023-01-03 13:57:56','2023-01-03 13:57:56'),(297,7938,40721,3197,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',243062.19,'IIBB MENSUAL BROKER',NULL,1,'2022-12-26 12:38:00','2023-01-03 13:57:28','2023-01-03 13:57:28'),(298,7938,40721,3190,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',257037.67,'Impuesto a las ganancias anual',NULL,1,'2022-12-26 12:43:25','2023-01-03 21:45:13','2023-01-03 21:45:13'),(299,7938,40721,3191,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',16801.88,'Anticipo impuesto a las ganancias',NULL,1,'2022-12-26 12:45:34','2023-01-03 21:39:06','2023-01-03 21:39:06'),(300,7938,40721,3192,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',5598.39,'Anticipo impuesto a las ganancias',NULL,1,'2022-12-26 12:46:22','2023-01-03 21:40:21','2023-01-03 21:40:21'),(301,7938,40721,3193,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',5598.39,'Anticipo impuesto a las ganancias',NULL,1,'2022-12-26 12:47:50','2023-01-03 21:38:32','2023-01-03 21:38:32'),(302,7938,40721,3194,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',5598.39,'anticipos ganancias broker',NULL,1,'2022-12-26 12:51:08','2023-01-03 21:38:07','2023-01-03 21:38:07'),(303,7938,40721,3195,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',5598.39,'anticipos ganancias broker',NULL,1,'2022-12-26 12:51:50','2023-01-03 21:37:24','2023-01-03 21:37:24'),(304,7938,40721,3196,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',5598.39,'anticipos ganancias broker',NULL,1,'2022-12-26 12:52:21','2022-12-26 12:52:21',NULL),(305,7938,40721,3197,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',5598.39,'anticipos ganancias broker',NULL,1,'2022-12-26 12:53:11','2022-12-26 12:53:11',NULL),(306,7938,40721,3183,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',776419.82,'Egresos mensuales Broker',NULL,1,'2022-12-26 14:09:21','2023-01-03 21:54:53','2023-01-03 21:54:53'),(307,7938,40721,3184,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',773313.69,'Egresos mensuales Broker',NULL,1,'2022-12-26 14:12:35','2023-01-03 22:00:04','2023-01-03 22:00:04'),(308,7938,40721,3185,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',807073.25,'Egresos mensuales Broker',NULL,1,'2022-12-26 14:15:12','2023-01-03 22:53:38','2023-01-03 22:53:38'),(309,7938,40721,3186,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1002343.85,'Egresos mensuales Broker',NULL,1,'2022-12-26 14:17:57','2023-01-03 22:29:28','2023-01-03 22:29:28'),(310,7938,40721,3190,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',931409.43,'Egresos mensuales Broker',NULL,1,'2022-12-26 14:21:17','2023-01-03 22:53:06','2023-01-03 22:53:06'),(311,7938,40721,3191,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',992778.29,'Egresos mensuales Broker',NULL,1,'2022-12-26 14:25:18','2023-01-03 22:05:10','2023-01-03 22:05:10'),(312,7938,40721,3192,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1054613.70,'Egresos mensuales Broker',NULL,1,'2022-12-26 14:28:01','2023-01-03 22:52:33','2023-01-03 22:52:33'),(313,7938,40721,3193,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1236753.25,'Egresos mensuales Broker',NULL,1,'2022-12-26 14:31:12','2023-01-03 22:51:57','2023-01-03 22:51:57'),(314,7938,40721,3194,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1320610.77,'Egresos mensuales Broker',NULL,1,'2022-12-26 14:34:03','2023-01-03 22:50:52','2023-01-03 22:50:52'),(315,7938,40721,3195,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1455445.84,'Egresos mensuales Broker',NULL,1,'2022-12-26 14:38:14','2023-01-03 22:50:26','2023-01-03 22:50:26');
INSERT INTO `balance_libro` VALUES (316,7938,40721,3197,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3640145.14,'Egresos mensuales Broker',NULL,1,'2022-12-26 14:42:00','2023-01-03 22:49:42','2023-01-03 22:49:42'),(317,7938,40721,3196,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2308690.97,'Egresos mensuales Broker',NULL,1,'2022-12-26 14:45:56','2023-01-03 22:49:02','2023-01-03 22:49:02'),(318,7938,40721,3193,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',600000.00,'Plazo fijo',NULL,1,'2022-12-26 14:48:27','2022-12-26 14:48:27',NULL),(319,7938,40721,3194,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',21802.01,'Plazo fijo',NULL,1,'2022-12-26 14:49:36','2023-01-03 21:12:59','2023-01-03 21:12:59'),(320,7938,40721,3195,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',26789.94,'Plazo fijo',NULL,1,'2022-12-26 14:51:00','2023-01-03 21:12:41','2023-01-03 21:12:41'),(321,7938,40721,3196,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',26789.94,'Plazo fijo',NULL,1,'2022-12-26 14:52:14','2023-01-03 21:12:22','2023-01-03 21:12:22'),(322,7938,40721,3197,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',29347.19,'Plazo fijo',NULL,1,'2022-12-26 14:53:14','2023-01-03 21:12:05','2023-01-03 21:12:05'),(323,7938,40721,3183,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',6488.26,'Ingreso prev retiro',NULL,1,'2023-01-02 21:24:30','2023-01-03 22:59:36','2023-01-03 22:59:36'),(324,7938,40721,3185,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',173.20,'Ingreso prev retiro',NULL,1,'2023-01-02 21:25:43','2023-01-02 21:25:43',NULL),(325,7938,40721,3190,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',2597.99,'Ingreso prev retiro',NULL,1,'2023-01-02 21:26:52','2023-01-02 21:26:52',NULL),(326,7938,40721,3192,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',7103.93,'Ingreso prev retiro',NULL,1,'2023-01-02 21:27:56','2023-01-02 21:27:56',NULL),(327,7938,40721,3195,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',714.45,'Ingreso prev retiro',NULL,1,'2023-01-02 21:29:03','2023-01-02 21:29:03',NULL),(328,7938,40721,3196,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2247.08,'Ingreso prev retiro',NULL,1,'2023-01-02 21:30:18','2023-01-03 14:06:24','2023-01-03 14:06:24'),(329,7938,40721,3197,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',24382.46,'Ingreso prev retiro',NULL,1,'2023-01-02 21:31:52','2023-01-03 16:54:36','2023-01-03 16:54:36'),(330,7938,40721,3184,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',6488.26,'ingreso retiro banco',NULL,1,'2023-01-02 21:33:24','2023-01-02 21:33:24',NULL),(331,7938,40721,3186,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',173.20,'ingreso retiro banco',NULL,1,'2023-01-02 21:34:08','2023-01-02 21:34:08',NULL),(332,7938,40721,3191,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',2597.99,'ingreso retiro banco',NULL,1,'2023-01-02 21:34:56','2023-01-02 21:34:56',NULL),(333,7938,40721,3197,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1924.05,'ingreso retiro banco',NULL,1,'2023-01-02 21:36:36','2023-01-03 16:50:04','2023-01-03 16:50:04'),(334,7938,40721,3183,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1089.00,'Comision banco sol',NULL,1,'2023-01-02 21:39:50','2023-01-02 21:39:50',NULL),(335,7938,40721,3185,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',544.50,'Comision banco sol 03-04-05',NULL,1,'2023-01-02 21:42:46','2023-01-03 14:15:13','2023-01-03 14:15:13'),(336,7938,40721,3183,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',985864.38,'Ingresos sancor',NULL,1,'2023-01-02 21:51:25','2023-01-03 12:42:59','2023-01-03 12:42:59');
INSERT INTO `balance_libro` VALUES (337,7938,40721,3184,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1045180.00,'Ingresos sancor',NULL,1,'2023-01-02 21:53:14','2023-01-03 12:42:28','2023-01-03 12:42:28'),(338,7938,40721,3185,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',996469.70,'Ingresos sancor',NULL,1,'2023-01-02 21:54:45','2023-01-03 12:41:33','2023-01-03 12:41:33'),(339,7938,40721,3186,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',990611.00,'Ingresos sancor',NULL,1,'2023-01-02 21:56:11','2023-01-03 12:41:02','2023-01-03 12:41:02'),(340,7938,40721,3191,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1162671.20,'Ingresos sancor',NULL,1,'2023-01-02 21:57:58','2023-01-03 12:40:37','2023-01-03 12:40:37'),(341,7938,40721,3192,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1333000.04,'Ingresos sancor',NULL,1,'2023-01-02 22:03:36','2023-01-03 12:40:11','2023-01-03 12:40:11'),(342,7938,40721,3195,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1633828.38,'Ingresos sancor',NULL,1,'2023-01-02 22:06:20','2023-01-03 12:39:37','2023-01-03 12:39:37'),(343,7938,40721,3197,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1910002.89,'Ingresos sancor',NULL,1,'2023-01-02 22:08:25','2023-01-03 12:39:11','2023-01-03 12:39:11'),(344,7938,40721,3184,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',98046.53,'Ingreso ART',NULL,1,'2023-01-02 22:13:37','2023-01-02 22:13:37',NULL),(345,7938,40721,3193,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',96864.06,'Ingreso ART',NULL,1,'2023-01-02 22:15:54','2023-01-02 22:15:54',NULL),(346,7938,40721,3195,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',92729.81,'Ingreso ART',NULL,1,'2023-01-02 22:16:57','2023-01-02 22:16:57',NULL),(347,7938,40721,3196,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1710452.23,'Ingreso ART',NULL,1,'2023-01-02 22:20:11','2023-01-02 22:20:11',NULL),(348,7938,40721,3183,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',97601.59,'Ingreso ART',NULL,1,'2023-01-02 22:37:37','2023-01-03 21:07:46','2023-01-03 21:07:46'),(349,7938,40721,3185,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',104116.83,'Ingreso ART',NULL,1,'2023-01-02 22:39:16','2023-01-02 22:39:16',NULL),(350,7938,40721,3186,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',171463.25,'Ingreso ART',NULL,1,'2023-01-02 22:40:58','2023-01-02 22:40:58',NULL),(351,7938,40721,3190,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',85027.27,'Ingreso ART',NULL,1,'2023-01-02 22:42:32','2023-01-02 22:42:32',NULL),(352,7938,40721,3191,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',133576.94,'Ingreso ART',NULL,1,'2023-01-02 22:44:22','2023-01-03 16:04:16','2023-01-03 16:04:16'),(353,7938,40721,3192,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',139059.16,'Ingreso ART',NULL,1,'2023-01-02 22:46:29','2023-01-02 22:46:29',NULL),(354,7938,40721,3194,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',96589.67,'Ingreso ART',NULL,1,'2023-01-02 22:48:06','2023-01-03 14:41:04','2023-01-03 14:41:04'),(355,7938,40721,3197,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2877815.94,'Ingreso ART',NULL,1,'2023-01-02 22:49:50','2023-01-03 21:11:09','2023-01-03 21:11:09'),(356,7938,40721,3190,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1142372.90,'Ingresos sancor',NULL,1,'2023-01-02 22:56:12','2023-01-03 12:38:03','2023-01-03 12:38:03'),(357,7938,40721,3193,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1480953.00,'Ingresos sancor',NULL,1,'2023-01-02 22:57:52','2023-01-03 12:37:40','2023-01-03 12:37:40');
INSERT INTO `balance_libro` VALUES (358,7938,40721,3194,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1490447.37,'Ingresos sancor',NULL,1,'2023-01-02 23:00:05','2023-01-03 12:37:08','2023-01-03 12:37:08'),(359,7938,40721,3196,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1445746.82,'Ingresos sancor',NULL,1,'2023-01-02 23:01:58','2023-01-03 13:04:35','2023-01-03 13:04:35'),(360,7938,40721,3194,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1490447.37,'Ingresos sancor',NULL,1,'2023-01-03 12:37:08','2023-01-03 13:50:47','2023-01-03 13:50:47'),(361,7938,40721,3193,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1480953.00,'Ingresos sancor',NULL,1,'2023-01-03 12:37:40','2023-01-03 13:45:34','2023-01-03 13:45:34'),(362,7938,40721,3190,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1142372.90,'Ingresos sancor',NULL,1,'2023-01-03 12:38:03','2023-01-03 13:11:24','2023-01-03 13:11:24'),(363,7938,40721,3197,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1910002.89,'Ingresos sancor',NULL,1,'2023-01-03 12:39:11','2023-01-03 12:39:11',NULL),(364,7938,40721,3195,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1633828.38,'Ingresos sancor',NULL,1,'2023-01-03 12:39:37','2023-01-03 12:39:37',NULL),(365,7938,40721,3192,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1333000.04,'Ingresos sancor',NULL,1,'2023-01-03 12:40:11','2023-01-03 12:40:11',NULL),(366,7938,40721,3191,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1162671.20,'Ingresos sancor',NULL,1,'2023-01-03 12:40:37','2023-01-03 12:40:37',NULL),(367,7938,40721,3186,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',990611.00,'Ingresos sancor',NULL,1,'2023-01-03 12:41:02','2023-01-03 12:41:02',NULL),(368,7938,40721,3185,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',996469.70,'Ingresos sancor',NULL,1,'2023-01-03 12:41:33','2023-01-03 20:41:39','2023-01-03 20:41:39'),(369,7938,40721,3184,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1045180.00,'Ingresos sancor',NULL,1,'2023-01-03 12:42:28','2023-01-03 12:42:28',NULL),(370,7938,40721,3183,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',985864.38,'Ingresos sancor',NULL,1,'2023-01-03 12:42:59','2023-01-03 12:42:59',NULL),(371,7938,40721,3196,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1746432.82,'Ingresos sancor',NULL,1,'2023-01-03 13:04:35','2023-01-03 13:04:35',NULL),(372,7938,40721,3190,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1142372.94,'Ingresos sancor',NULL,1,'2023-01-03 13:11:24','2023-01-03 13:11:24',NULL),(373,7938,40721,3193,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1450219.00,'Ingresos sancor',NULL,1,'2023-01-03 13:45:34','2023-01-03 13:45:34',NULL),(374,7938,40721,3194,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1495984.57,'Ingresos sancor',NULL,1,'2023-01-03 13:50:47','2023-01-03 13:50:47',NULL),(375,7938,40721,3197,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',243062.19,'IIBB MENSUAL BROKER',NULL,1,'2023-01-03 13:57:28','2023-01-03 13:57:28',NULL),(376,7938,40721,3196,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',179639.10,'IIBB MENSUAL BROKER',NULL,1,'2023-01-03 13:57:56','2023-01-03 13:57:56',NULL),(377,7938,40721,3195,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',106915.93,'IIBB MENSUAL BROKER',NULL,1,'2023-01-03 13:58:23','2023-01-03 22:26:35','2023-01-03 22:26:35'),(378,7938,40721,3194,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',99574.43,'IIBB MENSUAL BROKER',NULL,1,'2023-01-03 13:58:50','2023-01-03 13:58:50',NULL),(379,7938,40721,3192,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',92138.51,'IIBB MENSUAL BROKER',NULL,1,'2023-01-03 13:59:17','2023-01-03 13:59:17',NULL);
INSERT INTO `balance_libro` VALUES (380,7938,40721,3193,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',98753.51,'IIBB MENSUAL BROKER',NULL,1,'2023-01-03 13:59:45','2023-01-03 13:59:45',NULL),(381,7938,40721,3191,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',82414.01,'IIBB MENSUAL BROKER',NULL,1,'2023-01-03 14:00:09','2023-01-03 14:00:09',NULL),(382,7938,40721,3186,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',73931.81,'IIBB MENSUAL BROKER',NULL,1,'2023-01-03 14:00:34','2023-01-03 14:00:34',NULL),(383,7938,40721,3185,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',72973.94,'IIBB MENSUAL BROKER',NULL,1,'2023-01-03 14:01:00','2023-01-03 22:23:19','2023-01-03 22:23:19'),(384,7938,40721,3190,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',79859.16,'IIBB MENSUAL BROKER',NULL,1,'2023-01-03 14:01:40','2023-01-03 14:01:40',NULL),(385,7938,40721,3183,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',112123.35,'IIBB MENSUAL BROKER',NULL,1,'2023-01-03 14:02:11','2023-01-03 14:02:11',NULL),(386,7938,40721,3184,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',83849.09,'IIBB MENSUAL BROKER',NULL,1,'2023-01-03 14:02:38','2023-01-03 14:02:38',NULL),(387,7938,40721,3196,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2247.08,'Ingreso prev retiro',NULL,1,'2023-01-03 14:06:24','2023-01-03 16:58:39','2023-01-03 16:58:39'),(388,7938,40721,3192,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',544.50,'Comision banco sol 03-04-05',NULL,1,'2023-01-03 14:15:13','2023-01-03 14:15:13',NULL),(389,7938,40721,3194,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',76019.66,'Ingreso ART',NULL,1,'2023-01-03 14:41:04','2023-01-03 14:41:04',NULL),(390,7938,40721,3191,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',104536.94,'Ingreso ART',NULL,1,'2023-01-03 16:04:16','2023-01-03 16:04:16',NULL),(391,7938,40721,3184,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',160000.00,'PRESTAMOS SOCIOS',NULL,1,'2023-01-03 16:09:05','2023-01-03 16:09:05',NULL),(392,7938,40721,3185,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',45678.15,'IVA LOYOUDICE',NULL,1,'2023-01-03 16:15:09','2023-01-03 16:15:09',NULL),(393,7938,40721,3193,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',150000.00,'PRESTAMO GROUP',NULL,1,'2023-01-03 16:23:14','2023-01-03 16:23:14',NULL),(394,7938,40721,3194,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',14004.05,'RESULTADO MES- PERDIDA',NULL,1,'2023-01-03 16:33:34','2023-01-03 18:22:03','2023-01-03 18:22:03'),(395,7938,40721,3197,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',26629.54,'Ingreso prev retiro',NULL,1,'2023-01-03 16:54:36','2023-01-03 16:54:36',NULL),(396,7938,40721,3196,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2247.08,'Ingreso prev retiro',NULL,1,'2023-01-03 16:58:39','2023-01-03 16:59:18','2023-01-03 16:59:18'),(397,7938,40721,3196,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2247.08,'Ingreso prev retiro',NULL,1,'2023-01-03 16:59:18','2023-01-03 16:59:18',NULL),(398,7938,40721,3194,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',150000.00,NULL,NULL,1,'2023-01-03 18:24:06','2023-01-03 18:24:06',NULL),(399,7938,40721,3185,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',996469.29,'Ingresos sancor',NULL,1,'2023-01-03 20:41:39','2023-01-03 20:41:39',NULL),(400,7938,40721,3183,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',97601.59,'Ingreso ART',NULL,1,'2023-01-03 21:07:46','2023-01-03 21:09:06','2023-01-03 21:09:06'),(401,7938,40721,3183,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',97601.59,'Ingreso ART',NULL,1,'2023-01-03 21:09:06','2023-01-03 22:14:11','2023-01-03 22:14:11');
INSERT INTO `balance_libro` VALUES (402,7938,40721,3197,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2886168.44,'Ingreso ART',NULL,1,'2023-01-03 21:11:09','2023-01-03 21:11:09',NULL),(403,7938,40721,3197,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',29347.19,'Plazo fijo',NULL,1,'2023-01-03 21:12:05','2023-01-03 21:15:25','2023-01-03 21:15:25'),(404,7938,40721,3196,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',26789.94,'Plazo fijo',NULL,1,'2023-01-03 21:12:22','2023-01-03 21:12:22',NULL),(405,7938,40721,3195,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',26789.94,'Plazo fijo',NULL,1,'2023-01-03 21:12:41','2023-01-03 21:12:41',NULL),(406,7938,40721,3194,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',21802.01,'Plazo fijo',NULL,1,'2023-01-03 21:12:59','2023-01-03 21:12:59',NULL),(407,7938,40721,3197,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',23431.29,'Plazo fijo',NULL,1,'2023-01-03 21:15:25','2023-01-03 21:15:25',NULL),(408,7938,40721,3195,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',5598.39,'anticipos ganancias broker',NULL,1,'2023-01-03 21:37:24','2023-01-03 21:37:24',NULL),(409,7938,40721,3194,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',5598.39,'anticipos ganancias broker',NULL,1,'2023-01-03 21:38:07','2023-01-03 21:38:07',NULL),(410,7938,40721,3193,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',5598.39,'Anticipo impuesto a las ganancias',NULL,1,'2023-01-03 21:38:32','2023-01-03 21:38:32',NULL),(411,7938,40721,3191,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',16801.88,'Anticipo impuesto a las ganancias',NULL,1,'2023-01-03 21:39:06','2023-01-03 21:39:06',NULL),(412,7938,40721,3192,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',5598.39,'Anticipo impuesto a las ganancias',NULL,1,'2023-01-03 21:40:21','2023-01-03 21:40:21',NULL),(413,7938,40721,3196,15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',598397.50,'IVA MENSUAL',NULL,1,'2023-01-03 21:43:22','2023-01-03 21:43:22',NULL),(414,7938,40721,3190,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',257037.67,'Impuesto a las ganancias anual',NULL,1,'2023-01-03 21:45:13','2023-01-03 21:45:13',NULL),(415,7938,40721,3183,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',776419.82,'Egresos mensuales Broker',NULL,1,'2023-01-03 21:54:53','2023-01-03 21:56:17','2023-01-03 21:56:17'),(416,7938,40721,3183,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',776419.82,'Egresos mensuales Broker',NULL,1,'2023-01-03 21:56:17','2023-01-03 22:30:50','2023-01-03 22:30:50'),(417,7938,40721,3184,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',773313.69,'Egresos mensuales Broker',NULL,1,'2023-01-03 22:00:04','2023-01-03 22:01:40','2023-01-03 22:01:40'),(418,7938,40721,3184,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',773313.69,'Egresos mensuales Broker',NULL,1,'2023-01-03 22:01:40','2023-01-03 22:48:18','2023-01-03 22:48:18'),(419,7938,40721,3191,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',992778.29,'Egresos mensuales Broker',NULL,1,'2023-01-03 22:05:10','2023-01-03 22:06:34','2023-01-03 22:06:34'),(420,7938,40721,3191,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',992778.29,'Egresos mensuales Broker',NULL,1,'2023-01-03 22:06:34','2023-01-03 22:47:48','2023-01-03 22:47:48'),(421,7938,40721,3183,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',100666.05,'Ingreso ART',NULL,1,'2023-01-03 22:14:11','2023-01-03 22:14:11',NULL),(422,7938,40721,3185,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',72973.94,'IIBB MENSUAL BROKER',NULL,1,'2023-01-03 22:23:19','2023-01-03 22:23:19',NULL);
INSERT INTO `balance_libro` VALUES (423,7938,40721,3195,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',106915.93,'IIBB MENSUAL BROKER',NULL,1,'2023-01-03 22:26:35','2023-01-10 21:24:44','2023-01-10 21:24:44'),(424,7938,40721,3186,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1002343.85,'Egresos mensuales Broker',NULL,1,'2023-01-03 22:29:28','2023-01-03 22:47:18','2023-01-03 22:47:18'),(425,7938,40721,3183,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',776419.82,'Egresos mensuales Broker',NULL,1,'2023-01-03 22:30:50','2023-01-03 22:46:52','2023-01-03 22:46:52'),(426,7938,40721,3183,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',776419.82,'Egresos mensuales Broker',NULL,1,'2023-01-03 22:46:52','2023-01-10 21:16:42','2023-01-10 21:16:42'),(427,7938,40721,3186,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1002343.85,'Egresos mensuales Broker',NULL,1,'2023-01-03 22:47:18','2023-01-10 21:16:10','2023-01-10 21:16:10'),(428,7938,40721,3191,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',992778.29,'Egresos mensuales Broker',NULL,1,'2023-01-03 22:47:48','2023-01-10 21:15:27','2023-01-10 21:15:27'),(429,7938,40721,3184,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',773313.69,'Egresos mensuales Broker',NULL,1,'2023-01-03 22:48:18','2023-01-09 19:29:01','2023-01-09 19:29:01'),(430,7938,40721,3196,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2308690.97,'Egresos mensuales Broker',NULL,1,'2023-01-03 22:49:02','2023-01-08 02:05:09','2023-01-08 02:05:09'),(431,7938,40721,3197,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3640145.14,'Egresos mensuales Broker',NULL,1,'2023-01-03 22:49:42','2023-01-08 01:51:18','2023-01-08 01:51:18'),(432,7938,40721,3195,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1455445.84,'Egresos mensuales Broker',NULL,1,'2023-01-03 22:50:26','2023-01-10 21:14:35','2023-01-10 21:14:35'),(433,7938,40721,3194,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1320610.77,'Egresos mensuales Broker',NULL,1,'2023-01-03 22:50:52','2023-01-10 21:13:33','2023-01-10 21:13:33'),(434,7938,40721,3193,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1236753.25,'Egresos mensuales Broker',NULL,1,'2023-01-03 22:51:57','2023-01-10 21:12:30','2023-01-10 21:12:30'),(435,7938,40721,3192,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1054613.70,'Egresos mensuales Broker',NULL,1,'2023-01-03 22:52:33','2023-01-10 21:11:14','2023-01-10 21:11:14'),(436,7938,40721,3190,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',931409.43,'Egresos mensuales Broker',NULL,1,'2023-01-03 22:53:06','2023-01-10 21:10:17','2023-01-10 21:10:17'),(437,7938,40721,3185,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',807073.25,'Egresos mensuales Broker',NULL,1,'2023-01-03 22:53:38','2023-01-10 21:09:02','2023-01-10 21:09:02'),(438,7938,40721,3197,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',22088.90,NULL,NULL,1,'2023-01-03 22:55:24','2023-01-10 21:21:19','2023-01-10 21:21:19'),(439,7938,40721,3183,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',6688.32,'Ingreso prev retiro',NULL,1,'2023-01-03 22:59:36','2023-01-03 23:00:11','2023-01-03 23:00:11'),(440,7938,40721,3183,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',6668.32,'Ingreso prev retiro',NULL,1,'2023-01-03 23:00:11','2023-01-03 23:00:38','2023-01-03 23:00:38'),(441,7938,40721,3183,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',6708.32,'Ingreso prev retiro',NULL,1,'2023-01-03 23:00:38','2023-01-03 23:12:59','2023-01-03 23:12:59'),(442,7938,40721,3183,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',6488.26,'Ingreso prev retiro',NULL,1,'2023-01-03 23:12:59','2023-01-03 23:12:59',NULL);
INSERT INTO `balance_libro` VALUES (443,7938,40721,3183,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',321624.53,'SUELDOS',NULL,1,'2023-01-08 01:15:31','2023-01-10 17:57:10','2023-01-10 17:57:10'),(444,7938,40721,3184,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',314444.74,'SUELDOS',NULL,1,'2023-01-08 01:20:20','2023-01-08 01:20:20',NULL),(445,7938,40721,3185,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',332565.85,'SUELDOS',NULL,1,'2023-01-08 01:22:38','2023-01-09 19:34:53','2023-01-09 19:34:53'),(446,7938,40721,3186,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',601991.15,'SUELDOS',NULL,1,'2023-01-08 01:25:53','2023-01-09 19:36:52','2023-01-09 19:36:52'),(447,7938,40721,3190,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',377761.18,'SUELDOS',NULL,1,'2023-01-08 01:27:58','2023-01-09 19:40:09','2023-01-09 19:40:09'),(448,7938,40721,3191,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',402423.01,'SUELDOS',NULL,1,'2023-01-08 01:30:02','2023-01-09 19:42:11','2023-01-09 19:42:11'),(449,7938,40721,3192,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',424880.04,'SUELDOS',NULL,1,'2023-01-08 01:32:29','2023-01-10 17:58:08','2023-01-10 17:58:08'),(450,7938,40721,3193,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',474405.14,'SUELDOS',NULL,1,'2023-01-08 01:35:27','2023-01-09 19:46:10','2023-01-09 19:46:10'),(451,7938,40721,3194,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',593983.33,'SUELDOS',NULL,1,'2023-01-08 01:37:45','2023-01-09 19:48:16','2023-01-09 19:48:16'),(452,7938,40721,3195,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',796418.50,'SUELDOS',NULL,1,'2023-01-08 01:40:03','2023-01-09 19:52:02','2023-01-09 19:52:02'),(453,7938,40721,3196,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',613243.98,'SUELDOS',NULL,1,'2023-01-08 01:42:17','2023-01-09 19:55:34','2023-01-09 19:55:34'),(454,7938,40721,3197,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',538788.48,'SUELDOS',NULL,1,'2023-01-08 01:44:38','2023-01-09 19:59:41','2023-01-09 19:59:41'),(455,7938,40721,3197,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3625226.58,'Egresos mensuales Broker',NULL,1,'2023-01-08 01:51:18','2023-01-08 01:55:43','2023-01-08 01:55:43'),(456,7938,40721,3197,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3595389.46,'Egresos mensuales Broker',NULL,1,'2023-01-08 01:55:43','2023-01-08 01:59:39','2023-01-08 01:59:39'),(457,7938,40721,3197,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3655063.70,'Egresos mensuales Broker',NULL,1,'2023-01-08 01:59:39','2023-01-08 02:04:11','2023-01-08 02:04:11'),(458,7938,40721,3197,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3655063.70,'Egresos mensuales Broker',NULL,1,'2023-01-08 02:04:11','2023-01-09 20:01:00','2023-01-09 20:01:00'),(459,7938,40721,3196,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2308690.97,'Egresos mensuales Broker',NULL,1,'2023-01-08 02:05:09','2023-01-08 02:06:49','2023-01-08 02:06:49'),(460,7938,40721,3196,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2308690.97,'Egresos mensuales Broker',NULL,1,'2023-01-08 02:06:49','2023-01-09 19:57:37','2023-01-09 19:57:37'),(461,7938,40721,3184,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',773313.69,'Egresos mensuales Broker',NULL,1,'2023-01-09 19:29:01','2023-01-10 21:04:37','2023-01-10 21:04:37'),(462,7938,40721,3185,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',332595.90,'SUELDOS',NULL,1,'2023-01-09 19:34:53','2023-01-09 19:34:53',NULL),(463,7938,40721,3186,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',483348.85,'SUELDOS',NULL,1,'2023-01-09 19:36:52','2023-01-09 19:36:52',NULL);
INSERT INTO `balance_libro` VALUES (464,7938,40721,3190,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',377790.19,'SUELDOS',NULL,1,'2023-01-09 19:40:09','2023-01-09 19:40:09',NULL),(465,7938,40721,3191,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',402459.15,'SUELDOS',NULL,1,'2023-01-09 19:42:11','2023-01-09 19:42:11',NULL),(466,7938,40721,3193,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',474447.24,'SUELDOS',NULL,1,'2023-01-09 19:46:10','2023-01-09 19:46:10',NULL),(467,7938,40721,3194,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',594030.21,'SUELDOS',NULL,1,'2023-01-09 19:48:16','2023-01-09 19:48:16',NULL),(468,7938,40721,3195,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',485721.35,'SUELDOS',NULL,1,'2023-01-09 19:52:02','2023-01-09 19:52:02',NULL),(469,7938,40721,3196,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',473673.03,'SUELDOS',NULL,1,'2023-01-09 19:55:34','2023-01-09 19:55:34',NULL),(470,7938,40721,3196,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2308690.97,'Egresos mensuales Broker',NULL,1,'2023-01-09 19:57:37','2023-01-10 21:03:50','2023-01-10 21:03:50'),(471,7938,40721,3197,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',538880.67,'SUELDOS',NULL,1,'2023-01-09 19:59:41','2023-01-09 19:59:41',NULL),(472,7938,40721,3197,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3655063.70,'Egresos mensuales Broker',NULL,1,'2023-01-09 20:01:00','2023-01-10 21:02:10','2023-01-10 21:02:10'),(473,7938,40721,3197,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',72231.16,'dolares',NULL,1,'2023-01-10 17:53:06','2023-01-10 17:53:06',NULL),(474,7938,40721,3197,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',160000.00,'prestamos a socios',NULL,1,'2023-01-10 17:53:56','2023-01-10 17:53:56',NULL),(475,7938,40721,3197,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',232000.00,'gastos pintureria',NULL,1,'2023-01-10 17:54:57','2023-01-10 17:54:57',NULL),(476,7938,40721,3197,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',45000.00,NULL,NULL,1,'2023-01-10 17:56:05','2023-01-10 18:55:04','2023-01-10 18:55:04'),(477,7938,40721,3183,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',325257.41,'SUELDOS',NULL,1,'2023-01-10 17:57:10','2023-01-10 17:57:10',NULL),(478,7938,40721,3192,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',418610.01,'SUELDOS',NULL,1,'2023-01-10 17:58:08','2023-01-10 17:58:08',NULL),(479,7938,40721,3197,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',5132565.73,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-01-10 18:16:32','2023-01-10 21:21:44','2023-01-10 21:21:44'),(480,7938,40721,3197,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',70392.98,NULL,NULL,1,'2023-01-10 18:55:04','2023-01-10 21:28:11','2023-01-10 21:28:11'),(481,7938,40721,3197,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3655063.70,'Egresos mensuales Broker',NULL,1,'2023-01-10 21:02:10','2023-01-10 21:02:10',NULL),(482,7938,40721,3196,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2308690.97,'Egresos mensuales Broker',NULL,1,'2023-01-10 21:03:50','2023-01-10 21:03:50',NULL),(483,7938,40721,3184,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',773313.69,'Egresos mensuales Broker',NULL,1,'2023-01-10 21:04:37','2023-01-10 21:08:19','2023-01-10 21:08:19'),(484,7938,40721,3184,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',773313.69,'Egresos mensuales Broker',NULL,1,'2023-01-10 21:08:19','2023-01-10 21:08:19',NULL),(485,7938,40721,3185,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',807073.25,'Egresos mensuales Broker',NULL,1,'2023-01-10 21:09:02','2023-01-10 21:09:02',NULL);
INSERT INTO `balance_libro` VALUES (486,7938,40721,3190,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',931409.43,'Egresos mensuales Broker',NULL,1,'2023-01-10 21:10:17','2023-01-10 21:22:32','2023-01-10 21:22:32'),(487,7938,40721,3192,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1054613.70,'Egresos mensuales Broker',NULL,1,'2023-01-10 21:11:14','2023-01-10 21:11:14',NULL),(488,7938,40721,3193,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1236753.25,'Egresos mensuales Broker',NULL,1,'2023-01-10 21:12:30','2023-01-10 21:12:30',NULL),(489,7938,40721,3194,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1320610.77,'Egresos mensuales Broker',NULL,1,'2023-01-10 21:13:33','2023-01-10 21:13:33',NULL),(490,7938,40721,3195,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1455445.84,'Egresos mensuales Broker',NULL,1,'2023-01-10 21:14:35','2023-01-10 21:14:35',NULL),(491,7938,40721,3191,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',992778.29,'Egresos mensuales Broker',NULL,1,'2023-01-10 21:15:27','2023-01-10 21:15:27',NULL),(492,7938,40721,3186,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1002343.85,'Egresos mensuales Broker',NULL,1,'2023-01-10 21:16:10','2023-01-10 22:04:12','2023-01-10 22:04:12'),(493,7938,40721,3183,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',776419.82,'Egresos mensuales Broker',NULL,1,'2023-01-10 21:16:42','2023-01-10 21:16:42',NULL),(494,7938,40721,3190,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',931409.43,'Egresos mensuales Broker',NULL,1,'2023-01-10 21:22:32','2023-01-10 21:22:32',NULL),(495,7938,40721,3195,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',106915.93,'IIBB MENSUAL BROKER',NULL,1,'2023-01-10 21:24:44','2023-01-10 21:24:44',NULL),(496,7938,40721,3197,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',45000.00,NULL,NULL,1,'2023-01-10 21:28:11','2023-01-10 22:03:30','2023-01-10 22:03:30'),(497,7938,40721,3197,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',5132565.73,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-01-10 21:49:01','2023-01-10 22:03:14','2023-01-10 22:03:14'),(498,7938,40721,3186,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1002343.85,'Egresos mensuales Broker',NULL,1,'2023-01-10 22:04:12','2023-01-10 22:04:12',NULL),(499,7938,40721,3197,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',5132565.73,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-01-10 22:05:32','2023-01-10 22:05:36',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3523 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7938,1,40719,3,12,359,1,64054.49,NULL,'2022-10-11 12:28:31','2022-10-11 12:30:56','2022-10-11 12:30:56'),(2,7938,1,40719,3,12,384,1,477123.29,NULL,'2022-10-11 12:28:31','2022-10-11 12:30:56','2022-10-11 12:30:56'),(3,7938,1,40719,3,12,425,1,160932.75,NULL,'2022-10-11 12:28:31','2022-10-11 12:30:56','2022-10-11 12:30:56'),(4,7938,1,40719,3,12,302,1,29847.24,NULL,'2022-10-11 12:28:31','2022-10-11 12:30:56','2022-10-11 12:30:56'),(5,7938,1,40719,3,12,301,1,3033.00,NULL,'2022-10-11 12:28:31','2022-10-11 12:30:56','2022-10-11 12:30:56'),(6,7938,1,40719,3,12,354,1,35745.24,NULL,'2022-10-11 12:28:31','2022-10-11 12:30:56','2022-10-11 12:30:56'),(7,7938,1,40719,3,12,482,1,205750.00,NULL,'2022-10-11 12:28:31','2022-10-11 12:30:56','2022-10-11 12:30:56'),(8,7938,1,40719,3,12,20,1,177333.00,NULL,'2022-10-11 12:28:31','2022-10-11 12:30:56','2022-10-11 12:30:56'),(9,7938,1,40719,3,12,23,1,60622.24,NULL,'2022-10-11 12:28:31','2022-10-11 12:30:56','2022-10-11 12:30:56'),(10,7938,1,40719,3,12,386,1,1837927.35,NULL,'2022-10-11 12:28:31','2022-10-11 12:30:56','2022-10-11 12:30:56'),(11,7938,1,40719,3,12,369,2,200000.00,NULL,'2022-10-11 12:28:31','2022-10-11 12:30:56','2022-10-11 12:30:56'),(12,7938,1,40719,3,12,88,2,1401757.76,NULL,'2022-10-11 12:28:31','2022-10-11 12:30:56','2022-10-11 12:30:56'),(13,7938,1,40719,3,12,383,2,1410610.84,NULL,'2022-10-11 12:28:31','2022-10-11 12:30:56','2022-10-11 12:30:56'),(14,7938,1,40719,3,12,483,2,40000.00,NULL,'2022-10-11 12:28:31','2022-10-11 12:30:56','2022-10-11 12:30:56'),(15,7938,2,40719,3,12,359,1,64054.49,NULL,'2022-10-11 12:30:56','2022-10-11 12:34:11','2022-10-11 12:34:11'),(16,7938,2,40719,3,12,384,1,477123.29,NULL,'2022-10-11 12:30:56','2022-10-11 12:34:11','2022-10-11 12:34:11'),(17,7938,2,40719,3,12,425,1,160932.75,NULL,'2022-10-11 12:30:56','2022-10-11 12:34:11','2022-10-11 12:34:11'),(18,7938,2,40719,3,12,354,1,35745.24,NULL,'2022-10-11 12:30:56','2022-10-11 12:34:11','2022-10-11 12:34:11'),(19,7938,2,40719,3,12,482,1,205750.00,NULL,'2022-10-11 12:30:56','2022-10-11 12:34:11','2022-10-11 12:34:11'),(20,7938,2,40719,3,12,20,1,177333.00,NULL,'2022-10-11 12:30:56','2022-10-11 12:34:11','2022-10-11 12:34:11'),(21,7938,2,40719,3,12,23,1,60622.24,NULL,'2022-10-11 12:30:56','2022-10-11 12:34:11','2022-10-11 12:34:11'),(22,7938,2,40719,3,12,386,1,1837927.35,NULL,'2022-10-11 12:30:56','2022-10-11 12:34:11','2022-10-11 12:34:11'),(23,7938,2,40719,3,12,369,2,200000.00,NULL,'2022-10-11 12:30:56','2022-10-11 12:34:11','2022-10-11 12:34:11'),(24,7938,2,40719,3,12,88,2,1401757.76,NULL,'2022-10-11 12:30:56','2022-10-11 12:34:11','2022-10-11 12:34:11'),(25,7938,2,40719,3,12,383,2,1410610.84,NULL,'2022-10-11 12:30:56','2022-10-11 12:34:11','2022-10-11 12:34:11'),(26,7938,2,40719,3,12,483,2,40000.00,NULL,'2022-10-11 12:30:56','2022-10-11 12:34:11','2022-10-11 12:34:11'),(27,7938,2,40719,3,12,485,1,32880.24,NULL,'2022-10-11 12:30:56','2022-10-11 12:34:11','2022-10-11 12:34:11'),(28,7938,3,40719,3,12,359,1,64054.49,NULL,'2022-10-11 12:34:11','2022-10-11 12:38:49','2022-10-11 12:38:49'),(29,7938,3,40719,3,12,384,1,477123.29,NULL,'2022-10-11 12:34:11','2022-10-11 12:38:49','2022-10-11 12:38:49'),(30,7938,3,40719,3,12,425,1,160932.75,NULL,'2022-10-11 12:34:11','2022-10-11 12:38:49','2022-10-11 12:38:49'),(31,7938,3,40719,3,12,354,1,35745.24,NULL,'2022-10-11 12:34:11','2022-10-11 12:38:49','2022-10-11 12:38:49'),(32,7938,3,40719,3,12,482,1,205750.00,NULL,'2022-10-11 12:34:11','2022-10-11 12:38:49','2022-10-11 12:38:49'),(33,7938,3,40719,3,12,20,1,177333.00,NULL,'2022-10-11 12:34:11','2022-10-11 12:38:49','2022-10-11 12:38:49'),(34,7938,3,40719,3,12,23,1,60622.24,NULL,'2022-10-11 12:34:11','2022-10-11 12:38:49','2022-10-11 12:38:49'),(35,7938,3,40719,3,12,386,1,1837927.35,NULL,'2022-10-11 12:34:11','2022-10-11 12:38:49','2022-10-11 12:38:49'),(36,7938,3,40719,3,12,369,2,200000.00,NULL,'2022-10-11 12:34:11','2022-10-11 12:38:49','2022-10-11 12:38:49');
INSERT INTO `balance_libro_details` VALUES (37,7938,3,40719,3,12,88,2,1401757.76,NULL,'2022-10-11 12:34:11','2022-10-11 12:38:49','2022-10-11 12:38:49'),(38,7938,3,40719,3,12,383,2,1410610.84,NULL,'2022-10-11 12:34:11','2022-10-11 12:38:49','2022-10-11 12:38:49'),(39,7938,3,40719,3,12,483,2,40000.00,NULL,'2022-10-11 12:34:11','2022-10-11 12:38:49','2022-10-11 12:38:49'),(40,7938,3,40719,3,12,485,1,32880.24,NULL,'2022-10-11 12:34:11','2022-10-11 12:38:49','2022-10-11 12:38:49'),(41,7938,4,40719,3,12,359,1,64054.49,NULL,'2022-10-11 12:38:49','2022-11-12 10:49:30','2022-11-12 10:49:30'),(42,7938,4,40719,3,12,384,1,477123.29,NULL,'2022-10-11 12:38:49','2022-11-12 10:49:30','2022-11-12 10:49:30'),(43,7938,4,40719,3,12,425,1,160932.75,NULL,'2022-10-11 12:38:49','2022-11-12 10:49:30','2022-11-12 10:49:30'),(44,7938,4,40719,3,12,354,1,35745.24,NULL,'2022-10-11 12:38:49','2022-11-12 10:49:30','2022-11-12 10:49:30'),(45,7938,4,40719,3,12,482,1,205750.00,NULL,'2022-10-11 12:38:49','2022-11-12 10:49:30','2022-11-12 10:49:30'),(46,7938,4,40719,3,12,20,1,177333.00,NULL,'2022-10-11 12:38:49','2022-11-12 10:49:30','2022-11-12 10:49:30'),(47,7938,4,40719,3,12,23,1,60622.24,NULL,'2022-10-11 12:38:49','2022-11-12 10:49:30','2022-11-12 10:49:30'),(48,7938,4,40719,3,12,386,1,1837927.35,NULL,'2022-10-11 12:38:49','2022-11-12 10:49:30','2022-11-12 10:49:30'),(49,7938,4,40719,3,12,369,2,200000.00,NULL,'2022-10-11 12:38:49','2022-11-12 10:49:30','2022-11-12 10:49:30'),(50,7938,4,40719,3,12,88,2,1401757.76,NULL,'2022-10-11 12:38:49','2022-11-12 10:49:30','2022-11-12 10:49:30'),(51,7938,4,40719,3,12,383,2,1410610.84,NULL,'2022-10-11 12:38:49','2022-11-12 10:49:30','2022-11-12 10:49:30'),(52,7938,4,40719,3,12,483,2,40000.00,NULL,'2022-10-11 12:38:49','2022-11-12 10:49:30','2022-11-12 10:49:30'),(53,7938,4,40719,3,12,485,1,32880.24,NULL,'2022-10-11 12:38:49','2022-11-12 10:49:30','2022-11-12 10:49:30'),(54,7938,5,40719,3,12,359,1,64054.49,NULL,'2022-11-12 10:49:30','2022-11-12 10:49:44','2022-11-12 10:49:44'),(55,7938,5,40719,3,12,384,1,477123.29,NULL,'2022-11-12 10:49:30','2022-11-12 10:49:44','2022-11-12 10:49:44'),(56,7938,5,40719,3,12,425,1,160932.75,NULL,'2022-11-12 10:49:30','2022-11-12 10:49:44','2022-11-12 10:49:44'),(57,7938,5,40719,3,12,354,1,35745.24,NULL,'2022-11-12 10:49:30','2022-11-12 10:49:44','2022-11-12 10:49:44'),(58,7938,5,40719,3,12,482,1,205750.00,NULL,'2022-11-12 10:49:30','2022-11-12 10:49:44','2022-11-12 10:49:44'),(59,7938,5,40719,3,12,20,1,177333.00,NULL,'2022-11-12 10:49:30','2022-11-12 10:49:44','2022-11-12 10:49:44'),(60,7938,5,40719,3,12,23,1,60622.24,NULL,'2022-11-12 10:49:30','2022-11-12 10:49:44','2022-11-12 10:49:44'),(61,7938,5,40719,3,12,386,1,1837927.35,NULL,'2022-11-12 10:49:30','2022-11-12 10:49:44','2022-11-12 10:49:44'),(62,7938,5,40719,3,12,369,2,200000.00,NULL,'2022-11-12 10:49:30','2022-11-12 10:49:44','2022-11-12 10:49:44'),(63,7938,5,40719,3,12,88,2,1401757.76,NULL,'2022-11-12 10:49:30','2022-11-12 10:49:44','2022-11-12 10:49:44'),(64,7938,5,40719,3,12,383,2,1410610.84,NULL,'2022-11-12 10:49:30','2022-11-12 10:49:44','2022-11-12 10:49:44'),(65,7938,5,40719,3,12,483,2,40000.00,NULL,'2022-11-12 10:49:30','2022-11-12 10:49:44','2022-11-12 10:49:44'),(66,7938,5,40719,3,12,485,1,32880.24,NULL,'2022-11-12 10:49:30','2022-11-12 10:49:44','2022-11-12 10:49:44'),(67,7938,6,40719,3,12,359,1,64054.49,NULL,'2022-11-12 10:49:44','2022-11-12 10:49:44',NULL),(68,7938,6,40719,3,12,384,1,477123.29,NULL,'2022-11-12 10:49:44','2022-11-12 10:49:44',NULL),(69,7938,6,40719,3,12,425,1,160932.75,NULL,'2022-11-12 10:49:44','2022-11-12 10:49:44',NULL),(70,7938,6,40719,3,12,354,1,35745.24,NULL,'2022-11-12 10:49:44','2022-11-12 10:49:44',NULL),(71,7938,6,40719,3,12,482,1,205750.00,NULL,'2022-11-12 10:49:44','2022-11-12 10:49:44',NULL),(72,7938,6,40719,3,12,20,1,177333.00,NULL,'2022-11-12 10:49:44','2022-11-12 10:49:44',NULL),(73,7938,6,40719,3,12,23,1,60622.24,NULL,'2022-11-12 10:49:44','2022-11-12 10:49:44',NULL);
INSERT INTO `balance_libro_details` VALUES (74,7938,6,40719,3,12,386,1,1837927.35,NULL,'2022-11-12 10:49:44','2022-11-12 10:49:44',NULL),(75,7938,6,40719,3,12,369,2,200000.00,NULL,'2022-11-12 10:49:44','2022-11-12 10:49:44',NULL),(76,7938,6,40719,3,12,88,2,1401757.76,NULL,'2022-11-12 10:49:44','2022-11-12 10:49:44',NULL),(77,7938,6,40719,3,12,383,2,1410610.84,NULL,'2022-11-12 10:49:44','2022-11-12 10:49:44',NULL),(78,7938,6,40719,3,12,483,2,40000.00,NULL,'2022-11-12 10:49:44','2022-11-12 10:49:44',NULL),(79,7938,6,40719,3,12,485,1,32880.24,NULL,'2022-11-12 10:49:44','2022-11-12 10:49:44',NULL),(80,7938,7,40720,1518,12,359,1,64054.49,NULL,'2022-11-12 11:14:33','2022-12-07 13:12:43','2022-12-07 13:12:43'),(81,7938,7,40720,1518,12,425,1,160932.75,NULL,'2022-11-12 11:14:33','2022-12-07 13:12:43','2022-12-07 13:12:43'),(82,7938,7,40720,1518,12,20,1,177333.00,NULL,'2022-11-12 11:14:33','2022-12-07 13:12:43','2022-12-07 13:12:43'),(83,7938,7,40720,1518,12,384,1,477123.29,NULL,'2022-11-12 11:14:33','2022-12-07 13:12:43','2022-12-07 13:12:43'),(84,7938,7,40720,1518,12,386,1,1837927.35,NULL,'2022-11-12 11:14:33','2022-12-07 13:12:43','2022-12-07 13:12:43'),(85,7938,7,40720,1518,12,485,1,32880.24,NULL,'2022-11-12 11:14:33','2022-12-07 13:12:43','2022-12-07 13:12:43'),(86,7938,7,40720,1518,12,73,1,35745.24,NULL,'2022-11-12 11:14:33','2022-12-07 13:12:43','2022-12-07 13:12:43'),(87,7938,7,40720,1518,12,369,2,200000.00,NULL,'2022-11-12 11:14:33','2022-12-07 13:12:43','2022-12-07 13:12:43'),(88,7938,7,40720,1518,12,483,2,40000.00,NULL,'2022-11-12 11:14:33','2022-12-07 13:12:43','2022-12-07 13:12:43'),(89,7938,7,40720,1518,12,88,2,1401757.76,NULL,'2022-11-12 11:14:33','2022-12-07 13:12:43','2022-12-07 13:12:43'),(90,7938,7,40720,1518,12,383,2,1410610.84,NULL,'2022-11-12 11:14:33','2022-12-07 13:12:43','2022-12-07 13:12:43'),(91,7938,7,40720,1518,12,482,1,205750.00,NULL,'2022-11-12 11:14:33','2022-12-07 13:12:43','2022-12-07 13:12:43'),(92,7938,7,40720,1518,12,23,1,60622.24,NULL,'2022-11-12 11:14:33','2022-12-07 13:12:43','2022-12-07 13:12:43'),(93,7938,8,40720,1518,2,425,1,249343.40,NULL,'2022-11-12 11:23:07','2022-12-07 11:50:16','2022-12-07 11:50:16'),(94,7938,8,40720,1518,2,486,1,7500.00,NULL,'2022-11-12 11:23:07','2022-12-07 11:50:16','2022-12-07 11:50:16'),(95,7938,8,40720,1518,2,25,1,42000.00,NULL,'2022-11-12 11:23:07','2022-12-07 11:50:16','2022-12-07 11:50:16'),(96,7938,8,40720,1518,2,23,1,3656.60,NULL,'2022-11-12 11:23:07','2022-12-07 11:50:16','2022-12-07 11:50:16'),(97,7938,8,40720,1518,2,97,2,250000.00,NULL,'2022-11-12 11:23:07','2022-12-07 11:50:16','2022-12-07 11:50:16'),(98,7938,8,40720,1518,2,67,2,52500.00,NULL,'2022-11-12 11:23:07','2022-12-07 11:50:16','2022-12-07 11:50:16'),(99,7938,9,40720,1519,2,425,1,447743.40,NULL,'2022-11-12 11:25:28','2022-12-07 11:52:28','2022-12-07 11:52:28'),(100,7938,9,40720,1519,2,486,1,13500.00,NULL,'2022-11-12 11:25:28','2022-12-07 11:52:28','2022-12-07 11:52:28'),(101,7938,9,40720,1519,2,25,1,75600.00,NULL,'2022-11-12 11:25:28','2022-12-07 11:52:28','2022-12-07 11:52:28'),(102,7938,9,40720,1519,2,23,1,7656.60,NULL,'2022-11-12 11:25:28','2022-12-07 11:52:28','2022-12-07 11:52:28'),(103,7938,9,40720,1519,2,97,2,450000.00,NULL,'2022-11-12 11:25:28','2022-12-07 11:52:28','2022-12-07 11:52:28'),(104,7938,9,40720,1519,2,67,2,94500.00,NULL,'2022-11-12 11:25:28','2022-12-07 11:52:28','2022-12-07 11:52:28'),(105,7938,10,40720,1520,2,425,1,447743.40,NULL,'2022-11-12 11:28:41','2022-12-07 11:49:45','2022-12-07 11:49:45'),(106,7938,10,40720,1520,2,486,1,13500.00,NULL,'2022-11-12 11:28:41','2022-12-07 11:49:45','2022-12-07 11:49:45'),(107,7938,10,40720,1520,2,25,1,75600.00,NULL,'2022-11-12 11:28:41','2022-12-07 11:49:45','2022-12-07 11:49:45'),(108,7938,10,40720,1520,2,23,1,7656.60,NULL,'2022-11-12 11:28:41','2022-12-07 11:49:45','2022-12-07 11:49:45'),(109,7938,10,40720,1520,2,97,2,450000.00,NULL,'2022-11-12 11:28:41','2022-12-07 11:49:45','2022-12-07 11:49:45');
INSERT INTO `balance_libro_details` VALUES (110,7938,10,40720,1520,2,67,2,94500.00,NULL,'2022-11-12 11:28:41','2022-12-07 11:49:45','2022-12-07 11:49:45'),(111,7938,11,40720,1521,2,23,1,7656.60,NULL,'2022-11-12 11:36:40','2022-11-12 11:36:40',NULL),(112,7938,11,40720,1521,2,425,1,447743.40,NULL,'2022-11-12 11:36:40','2022-11-12 11:36:40',NULL),(113,7938,11,40720,1521,2,21,1,13500.00,NULL,'2022-11-12 11:36:40','2022-11-12 11:36:40',NULL),(114,7938,11,40720,1521,2,25,1,75600.00,NULL,'2022-11-12 11:36:40','2022-11-12 11:36:40',NULL),(115,7938,11,40720,1521,2,97,2,450000.00,NULL,'2022-11-12 11:36:40','2022-11-12 11:36:40',NULL),(116,7938,11,40720,1521,2,67,2,94500.00,NULL,'2022-11-12 11:36:40','2022-11-12 11:36:40',NULL),(117,7938,12,40720,1525,2,23,1,7656.60,NULL,'2022-11-12 11:37:04','2022-11-12 11:37:04',NULL),(118,7938,12,40720,1525,2,425,1,447743.40,NULL,'2022-11-12 11:37:04','2022-11-12 11:37:04',NULL),(119,7938,12,40720,1525,2,21,1,13500.00,NULL,'2022-11-12 11:37:04','2022-11-12 11:37:04',NULL),(120,7938,12,40720,1525,2,25,1,75600.00,NULL,'2022-11-12 11:37:04','2022-11-12 11:37:04',NULL),(121,7938,12,40720,1525,2,97,2,450000.00,NULL,'2022-11-12 11:37:04','2022-11-12 11:37:04',NULL),(122,7938,12,40720,1525,2,67,2,94500.00,NULL,'2022-11-12 11:37:04','2022-11-12 11:37:04',NULL),(123,7938,13,40720,1526,2,23,1,7656.60,NULL,'2022-11-12 11:37:23','2022-11-12 11:37:23',NULL),(124,7938,13,40720,1526,2,425,1,447743.40,NULL,'2022-11-12 11:37:23','2022-11-12 11:37:23',NULL),(125,7938,13,40720,1526,2,21,1,13500.00,NULL,'2022-11-12 11:37:23','2022-11-12 11:37:23',NULL),(126,7938,13,40720,1526,2,25,1,75600.00,NULL,'2022-11-12 11:37:23','2022-11-12 11:37:23',NULL),(127,7938,13,40720,1526,2,97,2,450000.00,NULL,'2022-11-12 11:37:23','2022-11-12 11:37:23',NULL),(128,7938,13,40720,1526,2,67,2,94500.00,NULL,'2022-11-12 11:37:23','2022-11-12 11:37:23',NULL),(129,7938,14,40720,1527,2,23,1,7656.60,NULL,'2022-11-12 11:37:40','2022-11-12 11:37:40',NULL),(130,7938,14,40720,1527,2,425,1,447743.40,NULL,'2022-11-12 11:37:40','2022-11-12 11:37:40',NULL),(131,7938,14,40720,1527,2,21,1,13500.00,NULL,'2022-11-12 11:37:40','2022-11-12 11:37:40',NULL),(132,7938,14,40720,1527,2,25,1,75600.00,NULL,'2022-11-12 11:37:40','2022-11-12 11:37:40',NULL),(133,7938,14,40720,1527,2,97,2,450000.00,NULL,'2022-11-12 11:37:40','2022-11-12 11:37:40',NULL),(134,7938,14,40720,1527,2,67,2,94500.00,NULL,'2022-11-12 11:37:40','2022-11-12 11:37:40',NULL),(135,7938,15,40720,1528,2,23,1,7656.60,NULL,'2022-11-12 11:38:02','2022-11-12 11:38:02',NULL),(136,7938,15,40720,1528,2,425,1,447743.40,NULL,'2022-11-12 11:38:02','2022-11-12 11:38:02',NULL),(137,7938,15,40720,1528,2,21,1,13500.00,NULL,'2022-11-12 11:38:02','2022-11-12 11:38:02',NULL),(138,7938,15,40720,1528,2,25,1,75600.00,NULL,'2022-11-12 11:38:02','2022-11-12 11:38:02',NULL),(139,7938,15,40720,1528,2,97,2,450000.00,NULL,'2022-11-12 11:38:02','2022-11-12 11:38:02',NULL),(140,7938,15,40720,1528,2,67,2,94500.00,NULL,'2022-11-12 11:38:02','2022-11-12 11:38:02',NULL),(141,7938,16,40720,1529,2,23,1,7656.60,NULL,'2022-11-12 11:38:23','2022-11-12 11:38:23',NULL),(142,7938,16,40720,1529,2,425,1,447743.40,NULL,'2022-11-12 11:38:23','2022-11-12 11:38:23',NULL),(143,7938,16,40720,1529,2,21,1,13500.00,NULL,'2022-11-12 11:38:23','2022-11-12 11:38:23',NULL),(144,7938,16,40720,1529,2,25,1,75600.00,NULL,'2022-11-12 11:38:23','2022-11-12 11:38:23',NULL),(145,7938,16,40720,1529,2,97,2,450000.00,NULL,'2022-11-12 11:38:23','2022-11-12 11:38:23',NULL),(146,7938,16,40720,1529,2,67,2,94500.00,NULL,'2022-11-12 11:38:23','2022-11-12 11:38:23',NULL),(147,7938,17,40720,1531,2,23,1,7656.60,NULL,'2022-11-12 11:38:59','2022-11-12 11:38:59',NULL),(148,7938,17,40720,1531,2,425,1,447743.40,NULL,'2022-11-12 11:38:59','2022-11-12 11:38:59',NULL),(149,7938,17,40720,1531,2,21,1,13500.00,NULL,'2022-11-12 11:38:59','2022-11-12 11:38:59',NULL),(150,7938,17,40720,1531,2,25,1,75600.00,NULL,'2022-11-12 11:38:59','2022-11-12 11:38:59',NULL);
INSERT INTO `balance_libro_details` VALUES (151,7938,17,40720,1531,2,97,2,450000.00,NULL,'2022-11-12 11:38:59','2022-11-12 11:38:59',NULL),(152,7938,17,40720,1531,2,67,2,94500.00,NULL,'2022-11-12 11:38:59','2022-11-12 11:38:59',NULL),(153,7938,18,40720,1532,2,23,1,7656.60,NULL,'2022-11-12 11:39:22','2022-11-12 11:39:22',NULL),(154,7938,18,40720,1532,2,425,1,447743.40,NULL,'2022-11-12 11:39:22','2022-11-12 11:39:22',NULL),(155,7938,18,40720,1532,2,21,1,13500.00,NULL,'2022-11-12 11:39:22','2022-11-12 11:39:22',NULL),(156,7938,18,40720,1532,2,25,1,75600.00,NULL,'2022-11-12 11:39:22','2022-11-12 11:39:22',NULL),(157,7938,18,40720,1532,2,97,2,450000.00,NULL,'2022-11-12 11:39:22','2022-11-12 11:39:22',NULL),(158,7938,18,40720,1532,2,67,2,94500.00,NULL,'2022-11-12 11:39:22','2022-11-12 11:39:22',NULL),(159,7938,19,40720,1530,2,23,1,7656.60,NULL,'2022-11-12 11:40:49','2022-11-12 11:40:49',NULL),(160,7938,19,40720,1530,2,425,1,447743.40,NULL,'2022-11-12 11:40:49','2022-11-12 11:40:49',NULL),(161,7938,19,40720,1530,2,21,1,13500.00,NULL,'2022-11-12 11:40:49','2022-11-12 11:40:49',NULL),(162,7938,19,40720,1530,2,25,1,75600.00,NULL,'2022-11-12 11:40:49','2022-11-12 11:40:49',NULL),(163,7938,19,40720,1530,2,97,2,450000.00,NULL,'2022-11-12 11:40:49','2022-11-12 11:40:49',NULL),(164,7938,19,40720,1530,2,67,2,94500.00,NULL,'2022-11-12 11:40:49','2022-11-12 11:40:49',NULL),(165,7938,20,40720,1518,2,488,1,5339.79,NULL,'2022-11-12 12:01:49','2022-11-12 12:01:49',NULL),(166,7938,20,40720,1518,2,67,2,926.74,NULL,'2022-11-12 12:01:49','2022-11-12 12:01:49',NULL),(167,7938,20,40720,1518,2,487,2,4413.05,NULL,'2022-11-12 12:01:49','2022-11-12 12:01:49',NULL),(168,7938,21,40720,1519,2,488,1,5657.37,NULL,'2022-11-12 12:40:25','2022-11-12 12:40:25',NULL),(169,7938,21,40720,1519,2,67,2,981.86,NULL,'2022-11-12 12:40:25','2022-11-12 12:40:25',NULL),(170,7938,21,40720,1519,2,487,2,4675.51,NULL,'2022-11-12 12:40:25','2022-11-12 12:40:25',NULL),(171,7938,22,40720,1520,2,488,1,5572.45,NULL,'2022-11-12 12:41:43','2022-11-12 12:41:43',NULL),(172,7938,22,40720,1520,2,67,2,967.12,NULL,'2022-11-12 12:41:43','2022-11-12 12:41:43',NULL),(173,7938,22,40720,1520,2,487,2,4605.33,NULL,'2022-11-12 12:41:43','2022-11-12 12:41:43',NULL),(174,7938,23,40720,1521,2,488,1,5629.50,NULL,'2022-11-12 12:42:39','2022-11-12 12:48:10','2022-11-12 12:48:10'),(175,7938,23,40720,1521,2,67,2,977.00,NULL,'2022-11-12 12:42:39','2022-11-12 12:48:10','2022-11-12 12:48:10'),(176,7938,23,40720,1521,2,487,2,4652.50,NULL,'2022-11-12 12:42:39','2022-11-12 12:48:10','2022-11-12 12:48:10'),(177,7938,24,40720,1525,2,488,1,5981.39,NULL,'2022-11-12 12:43:41','2022-11-12 12:43:41',NULL),(178,7938,24,40720,1525,2,67,2,1038.09,NULL,'2022-11-12 12:43:41','2022-11-12 12:43:41',NULL),(179,7938,24,40720,1525,2,487,2,4943.30,NULL,'2022-11-12 12:43:41','2022-11-12 12:43:41',NULL),(180,7938,25,40720,1527,2,488,1,6876.22,NULL,'2022-11-12 12:44:43','2022-11-12 12:44:43',NULL),(181,7938,25,40720,1527,2,67,2,1193.39,NULL,'2022-11-12 12:44:43','2022-11-12 12:44:43',NULL),(182,7938,25,40720,1527,2,487,2,5682.83,NULL,'2022-11-12 12:44:43','2022-11-12 12:44:43',NULL),(183,7938,26,40720,1528,2,488,1,6206.21,NULL,'2022-11-12 12:45:27','2022-11-12 12:45:27',NULL),(184,7938,26,40720,1528,2,67,2,1077.11,NULL,'2022-11-12 12:45:27','2022-11-12 12:45:27',NULL),(185,7938,26,40720,1528,2,487,2,5129.10,NULL,'2022-11-12 12:45:27','2022-11-12 12:45:27',NULL),(186,7938,27,40720,1530,2,488,1,7140.85,NULL,'2022-11-12 12:46:19','2022-11-12 12:46:19',NULL),(187,7938,27,40720,1530,2,67,2,1239.32,NULL,'2022-11-12 12:46:19','2022-11-12 12:46:19',NULL),(188,7938,27,40720,1530,2,487,2,5901.53,NULL,'2022-11-12 12:46:19','2022-11-12 12:46:19',NULL),(189,7938,28,40720,1521,2,488,1,5629.53,NULL,'2022-11-12 12:48:10','2022-11-12 12:48:10',NULL),(190,7938,28,40720,1521,2,67,2,977.03,NULL,'2022-11-12 12:48:10','2022-11-12 12:48:10',NULL),(191,7938,28,40720,1521,2,487,2,4652.50,NULL,'2022-11-12 12:48:10','2022-11-12 12:48:10',NULL);
INSERT INTO `balance_libro_details` VALUES (192,7938,29,40720,1532,2,488,1,16732.65,NULL,'2022-11-12 12:49:56','2022-11-12 12:49:56',NULL),(193,7938,29,40720,1532,2,67,2,2904.01,NULL,'2022-11-12 12:49:56','2022-11-12 12:49:56',NULL),(194,7938,29,40720,1532,2,487,2,13828.64,NULL,'2022-11-12 12:49:56','2022-11-12 12:49:56',NULL),(195,7938,30,40720,1526,2,425,1,602982.24,NULL,'2022-11-12 12:58:24','2022-11-12 12:58:24',NULL),(196,7938,30,40720,1526,2,25,1,102117.96,NULL,'2022-11-12 12:58:24','2022-11-12 12:58:24',NULL),(197,7938,30,40720,1526,2,23,1,12156.90,NULL,'2022-11-12 12:58:24','2022-11-12 12:58:24',NULL),(198,7938,30,40720,1526,2,21,1,18235.35,NULL,'2022-11-12 12:58:24','2022-11-12 12:58:24',NULL),(199,7938,30,40720,1526,2,67,2,127647.45,NULL,'2022-11-12 12:58:24','2022-11-12 12:58:24',NULL),(200,7938,30,40720,1526,2,490,2,607845.00,NULL,'2022-11-12 12:58:24','2022-11-12 12:58:24',NULL),(201,7938,31,40720,1528,2,425,1,779768.45,NULL,'2022-11-12 13:01:06','2022-11-12 13:01:06',NULL),(202,7938,31,40720,1528,2,25,1,132057.56,NULL,'2022-11-12 13:01:06','2022-11-12 13:01:06',NULL),(203,7938,31,40720,1528,2,23,1,15721.13,NULL,'2022-11-12 13:01:06','2022-11-12 13:01:06',NULL),(204,7938,31,40720,1528,2,21,1,23581.71,NULL,'2022-11-12 13:01:06','2022-11-12 13:01:06',NULL),(205,7938,31,40720,1528,2,67,2,165071.95,NULL,'2022-11-12 13:01:06','2022-11-12 13:01:06',NULL),(206,7938,31,40720,1528,2,490,2,786056.90,NULL,'2022-11-12 13:01:06','2022-11-12 13:01:06',NULL),(207,7938,32,40720,1531,2,425,1,827720.60,NULL,'2022-11-12 13:10:28','2022-11-12 13:10:28',NULL),(208,7938,32,40720,1531,2,25,1,140178.50,NULL,'2022-11-12 13:10:28','2022-11-12 13:10:28',NULL),(209,7938,32,40720,1531,2,23,1,16687.90,NULL,'2022-11-12 13:10:28','2022-11-12 13:10:28',NULL),(210,7938,32,40720,1531,2,21,1,25031.90,NULL,'2022-11-12 13:10:28','2022-11-12 13:10:28',NULL),(211,7938,32,40720,1531,2,67,2,175223.10,NULL,'2022-11-12 13:10:28','2022-11-12 13:10:28',NULL),(212,7938,32,40720,1531,2,490,2,834395.80,NULL,'2022-11-12 13:10:28','2022-11-12 13:10:28',NULL),(213,7938,33,40720,3168,3,425,2,335194.45,NULL,'2022-11-21 14:04:26','2022-12-07 05:48:35','2022-12-07 05:48:35'),(214,7938,33,40720,3168,3,491,1,110000.00,NULL,'2022-11-21 14:04:26','2022-12-07 05:48:35','2022-12-07 05:48:35'),(215,7938,33,40720,3168,3,492,1,45540.00,NULL,'2022-11-21 14:04:26','2022-12-07 05:48:35','2022-12-07 05:48:35'),(216,7938,33,40720,3168,3,135,1,33093.44,NULL,'2022-11-21 14:04:26','2022-12-07 05:48:35','2022-12-07 05:48:35'),(217,7938,33,40720,3168,3,494,1,18398.00,NULL,'2022-11-21 14:04:26','2022-12-07 05:48:35','2022-12-07 05:48:35'),(218,7938,33,40720,3168,3,496,1,25481.95,NULL,'2022-11-21 14:04:26','2022-12-07 05:48:35','2022-12-07 05:48:35'),(219,7938,33,40720,3168,3,396,1,2826.00,NULL,'2022-11-21 14:04:26','2022-12-07 05:48:35','2022-12-07 05:48:35'),(220,7938,33,40720,3168,3,155,1,14748.02,NULL,'2022-11-21 14:04:26','2022-12-07 05:48:35','2022-12-07 05:48:35'),(221,7938,33,40720,3168,3,157,1,3486.31,NULL,'2022-11-21 14:04:26','2022-12-07 05:48:35','2022-12-07 05:48:35'),(222,7938,33,40720,3168,3,220,1,678.24,NULL,'2022-11-21 14:04:26','2022-12-07 05:48:35','2022-12-07 05:48:35'),(223,7938,33,40720,3168,3,68,1,80942.49,NULL,'2022-11-21 14:04:26','2022-12-07 05:48:35','2022-12-07 05:48:35'),(224,7938,34,40720,3169,3,425,2,508421.06,NULL,'2022-11-21 14:11:33','2022-12-07 05:50:26','2022-12-07 05:50:26'),(225,7938,34,40720,3169,3,491,1,110000.00,NULL,'2022-11-21 14:11:33','2022-12-07 05:50:26','2022-12-07 05:50:26'),(226,7938,34,40720,3169,3,492,1,45510.00,NULL,'2022-11-21 14:11:33','2022-12-07 05:50:26','2022-12-07 05:50:26'),(227,7938,34,40720,3169,3,135,1,254817.57,NULL,'2022-11-21 14:11:33','2022-12-07 05:50:26','2022-12-07 05:50:26'),(228,7938,34,40720,3169,3,494,1,3157.00,NULL,'2022-11-21 14:11:33','2022-12-07 05:50:26','2022-12-07 05:50:26'),(229,7938,34,40720,3169,3,496,1,18656.16,NULL,'2022-11-21 14:11:33','2022-12-07 05:50:26','2022-12-07 05:50:26');
INSERT INTO `balance_libro_details` VALUES (230,7938,34,40720,3169,3,188,1,7200.00,NULL,'2022-11-21 14:11:33','2022-12-07 05:50:26','2022-12-07 05:50:26'),(231,7938,34,40720,3169,3,396,1,2826.00,NULL,'2022-11-21 14:11:33','2022-12-07 05:50:26','2022-12-07 05:50:26'),(232,7938,34,40720,3169,3,155,1,19701.04,NULL,'2022-11-21 14:11:33','2022-12-07 05:50:26','2022-12-07 05:50:26'),(233,7938,34,40720,3169,3,157,1,5866.19,NULL,'2022-11-21 14:11:33','2022-12-07 05:50:26','2022-12-07 05:50:26'),(234,7938,34,40720,3169,3,220,1,678.24,NULL,'2022-11-21 14:11:33','2022-12-07 05:50:26','2022-12-07 05:50:26'),(235,7938,34,40720,3169,3,68,1,30968.86,NULL,'2022-11-21 14:11:33','2022-12-07 05:50:26','2022-12-07 05:50:26'),(236,7938,34,40720,3169,3,498,1,9040.00,NULL,'2022-11-21 14:11:33','2022-12-07 05:50:26','2022-12-07 05:50:26'),(237,7938,35,40720,3170,3,425,2,261274.14,NULL,'2022-11-21 14:16:36','2022-12-07 05:51:27','2022-12-07 05:51:27'),(238,7938,35,40720,3170,3,491,1,110000.00,NULL,'2022-11-21 14:16:36','2022-12-07 05:51:27','2022-12-07 05:51:27'),(239,7938,35,40720,3170,3,492,1,45600.00,NULL,'2022-11-21 14:16:36','2022-12-07 05:51:27','2022-12-07 05:51:27'),(240,7938,35,40720,3170,3,135,1,6595.55,NULL,'2022-11-21 14:16:36','2022-12-07 05:51:27','2022-12-07 05:51:27'),(241,7938,35,40720,3170,3,493,1,2766.92,NULL,'2022-11-21 14:16:36','2022-12-07 05:51:27','2022-12-07 05:51:27'),(242,7938,35,40720,3170,3,494,1,5656.96,NULL,'2022-11-21 14:16:36','2022-12-07 05:51:27','2022-12-07 05:51:27'),(243,7938,35,40720,3170,3,496,1,25999.55,NULL,'2022-11-21 14:16:36','2022-12-07 05:51:27','2022-12-07 05:51:27'),(244,7938,35,40720,3170,3,188,1,7200.00,NULL,'2022-11-21 14:16:36','2022-12-07 05:51:27','2022-12-07 05:51:27'),(245,7938,35,40720,3170,3,396,1,2826.00,NULL,'2022-11-21 14:16:36','2022-12-07 05:51:27','2022-12-07 05:51:27'),(246,7938,35,40720,3170,3,155,1,13837.85,NULL,'2022-11-21 14:16:36','2022-12-07 05:51:27','2022-12-07 05:51:27'),(247,7938,35,40720,3170,3,157,1,5000.20,NULL,'2022-11-21 14:16:36','2022-12-07 05:51:27','2022-12-07 05:51:27'),(248,7938,35,40720,3170,3,220,1,678.24,NULL,'2022-11-21 14:16:36','2022-12-07 05:51:27','2022-12-07 05:51:27'),(249,7938,35,40720,3170,3,68,1,35112.87,NULL,'2022-11-21 14:16:36','2022-12-07 05:51:27','2022-12-07 05:51:27'),(250,7938,36,40720,3171,3,425,2,325002.80,NULL,'2022-11-21 14:25:34','2022-12-07 05:57:49','2022-12-07 05:57:49'),(251,7938,36,40720,3171,3,491,1,110000.00,NULL,'2022-11-21 14:25:34','2022-12-07 05:57:49','2022-12-07 05:57:49'),(252,7938,36,40720,3171,3,492,1,45640.00,NULL,'2022-11-21 14:25:34','2022-12-07 05:57:49','2022-12-07 05:57:49'),(253,7938,36,40720,3171,3,135,1,20460.43,NULL,'2022-11-21 14:25:34','2022-12-07 05:57:49','2022-12-07 05:57:49'),(254,7938,36,40720,3171,3,494,1,46937.12,NULL,'2022-11-21 14:25:34','2022-12-07 05:57:49','2022-12-07 05:57:49'),(255,7938,36,40720,3171,3,496,1,32134.00,NULL,'2022-11-21 14:25:34','2022-12-07 05:57:49','2022-12-07 05:57:49'),(256,7938,36,40720,3171,3,188,1,2000.00,NULL,'2022-11-21 14:25:34','2022-12-07 05:57:49','2022-12-07 05:57:49'),(257,7938,36,40720,3171,3,396,1,2826.00,NULL,'2022-11-21 14:25:34','2022-12-07 05:57:49','2022-12-07 05:57:49'),(258,7938,36,40720,3171,3,157,1,4605.85,NULL,'2022-11-21 14:25:34','2022-12-07 05:57:49','2022-12-07 05:57:49'),(259,7938,36,40720,3171,3,220,1,678.24,NULL,'2022-11-21 14:25:34','2022-12-07 05:57:49','2022-12-07 05:57:49'),(260,7938,36,40720,3171,3,75,1,223.87,NULL,'2022-11-21 14:25:34','2022-12-07 05:57:49','2022-12-07 05:57:49'),(261,7938,36,40720,3171,3,68,1,42997.29,NULL,'2022-11-21 14:25:34','2022-12-07 05:57:49','2022-12-07 05:57:49'),(262,7938,36,40720,3171,3,498,1,16500.00,NULL,'2022-11-21 14:25:34','2022-12-07 05:57:49','2022-12-07 05:57:49'),(263,7938,37,40720,3175,3,425,2,263136.59,NULL,'2022-11-21 14:29:32','2022-12-07 05:58:19','2022-12-07 05:58:19'),(264,7938,37,40720,3175,3,491,1,110000.00,NULL,'2022-11-21 14:29:32','2022-12-07 05:58:19','2022-12-07 05:58:19');
INSERT INTO `balance_libro_details` VALUES (265,7938,37,40720,3175,3,492,1,55070.00,NULL,'2022-11-21 14:29:32','2022-12-07 05:58:19','2022-12-07 05:58:19'),(266,7938,37,40720,3175,3,135,1,7137.07,NULL,'2022-11-21 14:29:32','2022-12-07 05:58:19','2022-12-07 05:58:19'),(267,7938,37,40720,3175,3,494,1,22646.98,NULL,'2022-11-21 14:29:32','2022-12-07 05:58:19','2022-12-07 05:58:19'),(268,7938,37,40720,3175,3,496,1,27181.68,NULL,'2022-11-21 14:29:32','2022-12-07 05:58:19','2022-12-07 05:58:19'),(269,7938,37,40720,3175,3,396,1,2826.00,NULL,'2022-11-21 14:29:32','2022-12-07 05:58:19','2022-12-07 05:58:19'),(270,7938,37,40720,3175,3,157,1,3446.02,NULL,'2022-11-21 14:29:32','2022-12-07 05:58:19','2022-12-07 05:58:19'),(271,7938,37,40720,3175,3,220,1,678.24,NULL,'2022-11-21 14:29:32','2022-12-07 05:58:19','2022-12-07 05:58:19'),(272,7938,37,40720,3175,3,75,1,223.77,NULL,'2022-11-21 14:29:32','2022-12-07 05:58:19','2022-12-07 05:58:19'),(273,7938,37,40720,3175,3,68,1,33926.83,NULL,'2022-11-21 14:29:32','2022-12-07 05:58:19','2022-12-07 05:58:19'),(274,7938,38,40720,3176,3,425,2,329493.33,NULL,'2022-11-21 15:54:40','2022-12-07 05:59:17','2022-12-07 05:59:17'),(275,7938,38,40720,3176,3,491,1,110000.00,NULL,'2022-11-21 15:54:40','2022-12-07 05:59:17','2022-12-07 05:59:17'),(276,7938,38,40720,3176,3,492,1,111950.00,NULL,'2022-11-21 15:54:40','2022-12-07 05:59:17','2022-12-07 05:59:17'),(277,7938,38,40720,3176,3,135,1,21865.38,NULL,'2022-11-21 15:54:40','2022-12-07 05:59:17','2022-12-07 05:59:17'),(278,7938,38,40720,3176,3,494,1,5200.00,NULL,'2022-11-21 15:54:40','2022-12-07 05:59:17','2022-12-07 05:59:17'),(279,7938,38,40720,3176,3,496,1,30111.64,NULL,'2022-11-21 15:54:40','2022-12-07 05:59:17','2022-12-07 05:59:17'),(280,7938,38,40720,3176,3,396,1,3000.00,NULL,'2022-11-21 15:54:40','2022-12-07 05:59:17','2022-12-07 05:59:17'),(281,7938,38,40720,3176,3,157,1,12920.41,NULL,'2022-11-21 15:54:40','2022-12-07 05:59:17','2022-12-07 05:59:17'),(282,7938,38,40720,3176,3,220,1,720.00,NULL,'2022-11-21 15:54:40','2022-12-07 05:59:17','2022-12-07 05:59:17'),(283,7938,38,40720,3176,3,75,1,525.36,NULL,'2022-11-21 15:54:40','2022-12-07 05:59:17','2022-12-07 05:59:17'),(284,7938,38,40720,3176,3,68,1,33200.54,NULL,'2022-11-21 15:54:40','2022-12-07 05:59:17','2022-12-07 05:59:17'),(285,7938,39,40720,3177,3,425,2,253741.69,NULL,'2022-11-21 15:57:45','2022-12-07 06:03:57','2022-12-07 06:03:57'),(286,7938,39,40720,3177,3,491,1,110000.00,NULL,'2022-11-21 15:57:45','2022-12-07 06:03:57','2022-12-07 06:03:57'),(287,7938,39,40720,3177,3,492,1,48500.00,NULL,'2022-11-21 15:57:45','2022-12-07 06:03:57','2022-12-07 06:03:57'),(288,7938,39,40720,3177,3,135,1,34756.49,NULL,'2022-11-21 15:57:45','2022-12-07 06:03:57','2022-12-07 06:03:57'),(289,7938,39,40720,3177,3,496,1,32105.79,NULL,'2022-11-21 15:57:45','2022-12-07 06:03:57','2022-12-07 06:03:57'),(290,7938,39,40720,3177,3,396,1,3000.00,NULL,'2022-11-21 15:57:45','2022-12-07 06:03:57','2022-12-07 06:03:57'),(291,7938,39,40720,3177,3,157,1,3389.97,NULL,'2022-11-21 15:57:45','2022-12-07 06:03:57','2022-12-07 06:03:57'),(292,7938,39,40720,3177,3,220,1,720.00,NULL,'2022-11-21 15:57:45','2022-12-07 06:03:57','2022-12-07 06:03:57'),(293,7938,39,40720,3177,3,75,1,223.87,NULL,'2022-11-21 15:57:45','2022-12-07 06:03:57','2022-12-07 06:03:57'),(294,7938,39,40720,3177,3,68,1,10445.57,NULL,'2022-11-21 15:57:45','2022-12-07 06:03:57','2022-12-07 06:03:57'),(295,7938,39,40720,3177,3,498,1,10600.00,NULL,'2022-11-21 15:57:45','2022-12-07 06:03:57','2022-12-07 06:03:57'),(296,7938,40,40720,3178,3,425,2,688270.99,NULL,'2022-11-21 16:04:17','2022-12-07 06:10:30','2022-12-07 06:10:30'),(297,7938,40,40720,3178,3,492,1,48750.00,NULL,'2022-11-21 16:04:17','2022-12-07 06:10:30','2022-12-07 06:10:30'),(298,7938,40,40720,3178,3,135,1,17301.58,NULL,'2022-11-21 16:04:17','2022-12-07 06:10:30','2022-12-07 06:10:30'),(299,7938,40,40720,3178,3,493,1,385000.00,NULL,'2022-11-21 16:04:17','2022-12-07 06:10:30','2022-12-07 06:10:30');
INSERT INTO `balance_libro_details` VALUES (300,7938,40,40720,3178,3,494,1,24536.29,NULL,'2022-11-21 16:04:17','2022-12-07 06:10:30','2022-12-07 06:10:30'),(301,7938,40,40720,3178,3,496,1,35804.19,NULL,'2022-11-21 16:04:17','2022-12-07 06:10:30','2022-12-07 06:10:30'),(302,7938,40,40720,3178,3,396,1,3000.00,NULL,'2022-11-21 16:04:17','2022-12-07 06:10:30','2022-12-07 06:10:30'),(303,7938,40,40720,3178,3,155,1,56729.34,NULL,'2022-11-21 16:04:17','2022-12-07 06:10:30','2022-12-07 06:10:30'),(304,7938,40,40720,3178,3,157,1,12444.94,NULL,'2022-11-21 16:04:17','2022-12-07 06:10:30','2022-12-07 06:10:30'),(305,7938,40,40720,3178,3,220,1,720.00,NULL,'2022-11-21 16:04:17','2022-12-07 06:10:30','2022-12-07 06:10:30'),(306,7938,40,40720,3178,3,75,1,2455.03,NULL,'2022-11-21 16:04:17','2022-12-07 06:10:30','2022-12-07 06:10:30'),(307,7938,40,40720,3178,3,68,1,101529.62,NULL,'2022-11-21 16:04:17','2022-12-07 06:10:30','2022-12-07 06:10:30'),(308,7938,41,40720,3179,3,425,2,363099.36,NULL,'2022-11-21 16:08:20','2022-12-07 06:17:31','2022-12-07 06:17:31'),(309,7938,41,40720,3179,3,491,1,110000.00,NULL,'2022-11-21 16:08:20','2022-12-07 06:17:31','2022-12-07 06:17:31'),(310,7938,41,40720,3179,3,492,1,53700.00,NULL,'2022-11-21 16:08:20','2022-12-07 06:17:31','2022-12-07 06:17:31'),(311,7938,41,40720,3179,3,135,1,38328.95,NULL,'2022-11-21 16:08:20','2022-12-07 06:17:31','2022-12-07 06:17:31'),(312,7938,41,40720,3179,3,494,1,40016.96,NULL,'2022-11-21 16:08:20','2022-12-07 06:17:31','2022-12-07 06:17:31'),(313,7938,41,40720,3179,3,495,1,4752.21,NULL,'2022-11-21 16:08:20','2022-12-07 06:17:31','2022-12-07 06:17:31'),(314,7938,41,40720,3179,3,496,1,34346.72,NULL,'2022-11-21 16:08:20','2022-12-07 06:17:31','2022-12-07 06:17:31'),(315,7938,41,40720,3179,3,396,1,3000.00,NULL,'2022-11-21 16:08:20','2022-12-07 06:17:31','2022-12-07 06:17:31'),(316,7938,41,40720,3179,3,155,1,12072.06,NULL,'2022-11-21 16:08:20','2022-12-07 06:17:31','2022-12-07 06:17:31'),(317,7938,41,40720,3179,3,157,1,5730.68,NULL,'2022-11-21 16:08:20','2022-12-07 06:17:31','2022-12-07 06:17:31'),(318,7938,41,40720,3179,3,220,1,720.00,NULL,'2022-11-21 16:08:20','2022-12-07 06:17:31','2022-12-07 06:17:31'),(319,7938,41,40720,3179,3,75,1,298.87,NULL,'2022-11-21 16:08:20','2022-12-07 06:17:31','2022-12-07 06:17:31'),(320,7938,41,40720,3179,3,68,1,35558.91,NULL,'2022-11-21 16:08:20','2022-12-07 06:17:31','2022-12-07 06:17:31'),(321,7938,41,40720,3179,3,498,1,24574.00,NULL,'2022-11-21 16:08:20','2022-12-07 06:17:31','2022-12-07 06:17:31'),(322,7938,42,40720,3180,3,425,2,313101.07,NULL,'2022-11-21 16:17:33','2022-12-07 06:23:42','2022-12-07 06:23:42'),(323,7938,42,40720,3180,3,491,1,110000.00,NULL,'2022-11-21 16:17:33','2022-12-07 06:23:42','2022-12-07 06:23:42'),(324,7938,42,40720,3180,3,492,1,53850.00,NULL,'2022-11-21 16:17:33','2022-12-07 06:23:42','2022-12-07 06:23:42'),(325,7938,42,40720,3180,3,135,1,9197.15,NULL,'2022-11-21 16:17:33','2022-12-07 06:23:42','2022-12-07 06:23:42'),(326,7938,42,40720,3180,3,494,1,15557.42,NULL,'2022-11-21 16:17:33','2022-12-07 06:23:42','2022-12-07 06:23:42'),(327,7938,42,40720,3180,3,496,1,55850.35,NULL,'2022-11-21 16:17:33','2022-12-07 06:23:42','2022-12-07 06:23:42'),(328,7938,42,40720,3180,3,396,1,3000.00,NULL,'2022-11-21 16:17:33','2022-12-07 06:23:42','2022-12-07 06:23:42'),(329,7938,42,40720,3180,3,157,1,4537.84,NULL,'2022-11-21 16:17:33','2022-12-07 06:23:42','2022-12-07 06:23:42'),(330,7938,42,40720,3180,3,220,1,720.00,NULL,'2022-11-21 16:17:33','2022-12-07 06:23:42','2022-12-07 06:23:42'),(331,7938,42,40720,3180,3,75,1,895.49,NULL,'2022-11-21 16:17:33','2022-12-07 06:23:42','2022-12-07 06:23:42'),(332,7938,42,40720,3180,3,68,1,59492.82,NULL,'2022-11-21 16:17:33','2022-12-07 06:23:42','2022-12-07 06:23:42'),(333,7938,43,40720,3181,3,425,2,645546.65,NULL,'2022-11-21 16:22:41','2022-12-07 06:21:03','2022-12-07 06:21:03'),(334,7938,43,40720,3181,3,491,1,323047.00,NULL,'2022-11-21 16:22:41','2022-12-07 06:21:03','2022-12-07 06:21:03');
INSERT INTO `balance_libro_details` VALUES (335,7938,43,40720,3181,3,492,1,54000.00,NULL,'2022-11-21 16:22:41','2022-12-07 06:21:03','2022-12-07 06:21:03'),(336,7938,43,40720,3181,3,135,1,78079.81,NULL,'2022-11-21 16:22:41','2022-12-07 06:21:03','2022-12-07 06:21:03'),(337,7938,43,40720,3181,3,494,1,4797.00,NULL,'2022-11-21 16:22:41','2022-12-07 06:21:03','2022-12-07 06:21:03'),(338,7938,43,40720,3181,3,496,1,60667.88,NULL,'2022-11-21 16:22:41','2022-12-07 06:21:03','2022-12-07 06:21:03'),(339,7938,43,40720,3181,3,396,1,3000.00,NULL,'2022-11-21 16:22:41','2022-12-07 06:21:03','2022-12-07 06:21:03'),(340,7938,43,40720,3181,3,157,1,12345.91,NULL,'2022-11-21 16:22:41','2022-12-07 06:21:03','2022-12-07 06:21:03'),(341,7938,43,40720,3181,3,220,1,90.00,NULL,'2022-11-21 16:22:41','2022-12-07 06:21:03','2022-12-07 06:21:03'),(342,7938,43,40720,3181,3,75,1,637.73,NULL,'2022-11-21 16:22:41','2022-12-07 06:21:03','2022-12-07 06:21:03'),(343,7938,43,40720,3181,3,68,1,87671.32,NULL,'2022-11-21 16:22:41','2022-12-07 06:21:03','2022-12-07 06:21:03'),(344,7938,43,40720,3181,3,498,1,21210.00,NULL,'2022-11-21 16:22:41','2022-12-07 06:21:03','2022-12-07 06:21:03'),(345,7938,44,40720,3182,3,425,2,423150.70,NULL,'2022-11-21 16:26:23','2022-12-07 06:18:58','2022-12-07 06:18:58'),(346,7938,44,40720,3182,3,491,1,110000.00,NULL,'2022-11-21 16:26:23','2022-12-07 06:18:58','2022-12-07 06:18:58'),(347,7938,44,40720,3182,3,492,1,59660.00,NULL,'2022-11-21 16:26:23','2022-12-07 06:18:58','2022-12-07 06:18:58'),(348,7938,44,40720,3182,3,135,1,166475.11,NULL,'2022-11-21 16:26:23','2022-12-07 06:18:58','2022-12-07 06:18:58'),(349,7938,44,40720,3182,3,496,1,21833.17,NULL,'2022-11-21 16:26:23','2022-12-07 06:18:58','2022-12-07 06:18:58'),(350,7938,44,40720,3182,3,396,1,4500.00,NULL,'2022-11-21 16:26:23','2022-12-07 06:18:58','2022-12-07 06:18:58'),(351,7938,44,40720,3182,3,155,1,7588.51,NULL,'2022-11-21 16:26:23','2022-12-07 06:18:58','2022-12-07 06:18:58'),(352,7938,44,40720,3182,3,157,1,2523.82,NULL,'2022-11-21 16:26:23','2022-12-07 06:18:58','2022-12-07 06:18:58'),(353,7938,44,40720,3182,3,220,1,1080.00,NULL,'2022-11-21 16:26:23','2022-12-07 06:18:58','2022-12-07 06:18:58'),(354,7938,44,40720,3182,3,75,1,447.74,NULL,'2022-11-21 16:26:23','2022-12-07 06:18:58','2022-12-07 06:18:58'),(355,7938,44,40720,3182,3,68,1,34902.35,NULL,'2022-11-21 16:26:23','2022-12-07 06:18:58','2022-12-07 06:18:58'),(356,7938,44,40720,3182,3,498,1,14140.00,NULL,'2022-11-21 16:26:23','2022-12-07 06:18:58','2022-12-07 06:18:58'),(357,7938,45,40720,3168,15,67,1,53426.74,NULL,'2022-11-21 16:44:33','2022-12-07 06:27:53','2022-12-07 06:27:53'),(358,7938,45,40720,3168,15,353,1,27515.75,NULL,'2022-11-21 16:44:33','2022-12-07 06:27:53','2022-12-07 06:27:53'),(359,7938,45,40720,3168,15,354,1,42000.00,NULL,'2022-11-21 16:44:33','2022-12-07 06:27:53','2022-12-07 06:27:53'),(360,7938,45,40720,3168,15,68,2,80942.49,NULL,'2022-11-21 16:44:33','2022-12-07 06:27:53','2022-12-07 06:27:53'),(361,7938,45,40720,3168,15,25,2,42000.00,NULL,'2022-11-21 16:44:33','2022-12-07 06:27:53','2022-12-07 06:27:53'),(362,7938,46,40720,3169,15,67,1,95481.86,NULL,'2022-11-21 16:45:58','2022-12-07 06:28:31','2022-12-07 06:28:31'),(363,7938,46,40720,3169,15,354,1,75909.26,NULL,'2022-11-21 16:45:58','2022-12-07 06:28:31','2022-12-07 06:28:31'),(364,7938,46,40720,3169,15,68,2,30968.86,NULL,'2022-11-21 16:45:58','2022-12-07 06:28:31','2022-12-07 06:28:31'),(365,7938,46,40720,3169,15,25,2,75909.26,NULL,'2022-11-21 16:45:58','2022-12-07 06:28:31','2022-12-07 06:28:31'),(366,7938,46,40720,3169,15,353,2,27515.75,NULL,'2022-11-21 16:45:58','2022-12-07 06:28:31','2022-12-07 06:28:31'),(367,7938,46,40720,3169,15,354,2,36997.25,NULL,'2022-11-21 16:45:58','2022-12-07 06:28:31','2022-12-07 06:28:31'),(368,7938,47,40720,3170,15,67,1,95467.12,NULL,'2022-11-21 16:47:16','2022-12-07 06:29:08','2022-12-07 06:29:08'),(369,7938,47,40720,3170,15,354,1,75917.83,NULL,'2022-11-21 16:47:16','2022-12-07 06:29:08','2022-12-07 06:29:08');
INSERT INTO `balance_libro_details` VALUES (370,7938,47,40720,3170,15,68,2,35112.87,NULL,'2022-11-21 16:47:16','2022-12-07 06:29:08','2022-12-07 06:29:08'),(371,7938,47,40720,3170,15,25,2,75917.83,NULL,'2022-11-21 16:47:16','2022-12-07 06:29:08','2022-12-07 06:29:08'),(372,7938,47,40720,3170,15,354,2,60354.25,NULL,'2022-11-21 16:47:16','2022-12-07 06:29:08','2022-12-07 06:29:08'),(373,7938,48,40720,3171,15,67,1,95477.02,NULL,'2022-11-21 16:49:38','2022-12-07 06:29:29','2022-12-07 06:29:29'),(374,7938,48,40720,3171,15,354,1,75857.31,NULL,'2022-11-21 16:49:38','2022-12-07 06:29:29','2022-12-07 06:29:29'),(375,7938,48,40720,3171,15,20,1,57348.86,NULL,'2022-11-21 16:49:38','2022-12-07 06:29:29','2022-12-07 06:29:29'),(376,7938,48,40720,3171,15,68,2,42997.29,NULL,'2022-11-21 16:49:38','2022-12-07 06:29:29','2022-12-07 06:29:29'),(377,7938,48,40720,3171,15,25,2,75857.65,NULL,'2022-11-21 16:49:38','2022-12-07 06:29:29','2022-12-07 06:29:29'),(378,7938,48,40720,3171,15,354,2,109828.25,NULL,'2022-11-21 16:49:38','2022-12-07 06:29:29','2022-12-07 06:29:29'),(379,7938,49,40720,3175,15,67,1,95538.09,NULL,'2022-11-21 16:51:09','2022-12-07 06:29:53','2022-12-07 06:29:53'),(380,7938,49,40720,3175,15,354,1,75600.00,NULL,'2022-11-21 16:51:09','2022-12-07 06:29:53','2022-12-07 06:29:53'),(381,7938,49,40720,3175,15,20,1,24446.93,NULL,'2022-11-21 16:51:09','2022-12-07 06:29:53','2022-12-07 06:29:53'),(382,7938,49,40720,3175,15,68,2,33926.83,NULL,'2022-11-21 16:51:09','2022-12-07 06:29:53','2022-12-07 06:29:53'),(383,7938,49,40720,3175,15,25,2,75600.00,NULL,'2022-11-21 16:51:09','2022-12-07 06:29:53','2022-12-07 06:29:53'),(384,7938,49,40720,3175,15,354,2,86058.19,NULL,'2022-11-21 16:51:09','2022-12-07 06:29:53','2022-12-07 06:29:53'),(385,7938,50,40720,3176,15,67,1,222147.50,NULL,'2022-11-21 16:52:42','2022-12-07 06:30:15','2022-12-07 06:30:15'),(386,7938,50,40720,3176,15,354,1,62951.00,NULL,'2022-11-21 16:52:42','2022-12-07 06:30:15','2022-12-07 06:30:15'),(387,7938,50,40720,3176,15,20,1,13988.74,NULL,'2022-11-21 16:52:42','2022-12-07 06:30:15','2022-12-07 06:30:15'),(388,7938,50,40720,3176,15,68,2,33200.54,NULL,'2022-11-21 16:52:42','2022-12-07 06:30:15','2022-12-07 06:30:15'),(389,7938,50,40720,3176,15,25,2,178095.00,NULL,'2022-11-21 16:52:42','2022-12-07 06:30:15','2022-12-07 06:30:15'),(390,7938,50,40720,3176,15,354,2,87791.70,NULL,'2022-11-21 16:52:42','2022-12-07 06:30:15','2022-12-07 06:30:15'),(391,7938,51,40720,3177,15,67,1,95693.39,NULL,'2022-11-21 16:53:47','2022-12-07 06:30:35','2022-12-07 06:30:35'),(392,7938,51,40720,3177,15,354,1,53682.70,NULL,'2022-11-21 16:53:47','2022-12-07 06:30:35','2022-12-07 06:30:35'),(393,7938,51,40720,3177,15,68,2,10445.57,NULL,'2022-11-21 16:53:47','2022-12-07 06:30:35','2022-12-07 06:30:35'),(394,7938,51,40720,3177,15,25,2,75979.52,NULL,'2022-11-21 16:53:47','2022-12-07 06:30:35','2022-12-07 06:30:35'),(395,7938,51,40720,3177,15,354,2,62951.00,NULL,'2022-11-21 16:53:47','2022-12-07 06:30:35','2022-12-07 06:30:35'),(396,7938,52,40720,3178,15,67,1,260649.06,NULL,'2022-11-21 16:54:50','2022-12-07 06:31:07','2022-12-07 06:31:07'),(397,7938,52,40720,3178,15,354,1,102708.84,NULL,'2022-11-21 16:54:50','2022-12-07 06:31:07','2022-12-07 06:31:07'),(398,7938,52,40720,3178,15,68,2,101529.62,NULL,'2022-11-21 16:54:50','2022-12-07 06:31:07','2022-12-07 06:31:07'),(399,7938,52,40720,3178,15,25,2,208145.58,NULL,'2022-11-21 16:54:50','2022-12-07 06:31:07','2022-12-07 06:31:07'),(400,7938,52,40720,3178,15,354,2,53682.70,NULL,'2022-11-21 16:54:50','2022-12-07 06:31:07','2022-12-07 06:31:07'),(401,7938,53,40720,3179,15,67,1,95699.02,NULL,'2022-11-21 16:56:06','2022-12-07 06:31:29','2022-12-07 06:31:29'),(402,7938,53,40720,3179,15,354,1,76002.62,NULL,'2022-11-21 16:56:06','2022-12-07 06:31:29','2022-12-07 06:31:29'),(403,7938,53,40720,3179,15,20,1,19428.36,NULL,'2022-11-21 16:56:06','2022-12-07 06:31:29','2022-12-07 06:31:29'),(404,7938,53,40720,3179,15,68,2,35558.91,NULL,'2022-11-21 16:56:06','2022-12-07 06:31:29','2022-12-07 06:31:29');
INSERT INTO `balance_libro_details` VALUES (405,7938,53,40720,3179,15,25,2,76002.62,NULL,'2022-11-21 16:56:06','2022-12-07 06:31:29','2022-12-07 06:31:29'),(406,7938,53,40720,3179,15,354,2,79568.47,NULL,'2022-11-21 16:56:06','2022-12-07 06:31:29','2022-12-07 06:31:29'),(407,7938,54,40720,3180,15,67,1,95739.32,NULL,'2022-11-21 16:57:28','2022-12-07 06:32:00','2022-12-07 06:32:00'),(408,7938,54,40720,3180,15,354,1,75600.00,NULL,'2022-11-21 16:57:28','2022-12-07 06:32:00','2022-12-07 06:32:00'),(409,7938,54,40720,3180,15,20,1,24472.26,NULL,'2022-11-21 16:57:28','2022-12-07 06:32:00','2022-12-07 06:32:00'),(410,7938,54,40720,3180,15,68,2,59492.82,NULL,'2022-11-21 16:57:28','2022-12-07 06:32:00','2022-12-07 06:32:00'),(411,7938,54,40720,3180,15,25,2,75600.00,NULL,'2022-11-21 16:57:28','2022-12-07 06:32:00','2022-12-07 06:32:00'),(412,7938,54,40720,3180,15,354,2,60718.76,NULL,'2022-11-21 16:57:28','2022-12-07 06:32:00','2022-12-07 06:32:00'),(413,7938,55,40720,3181,15,67,1,269723.12,NULL,'2022-11-21 16:58:55','2022-12-07 06:32:30','2022-12-07 06:32:30'),(414,7938,55,40720,3181,15,354,1,147957.03,NULL,'2022-11-21 16:58:55','2022-12-07 06:32:30','2022-12-07 06:32:30'),(415,7938,55,40720,3181,15,68,2,87671.32,NULL,'2022-11-21 16:58:55','2022-12-07 06:32:30','2022-12-07 06:32:30'),(416,7938,55,40720,3181,15,25,2,215984.60,NULL,'2022-11-21 16:58:55','2022-12-07 06:32:30','2022-12-07 06:32:30'),(417,7938,55,40720,3181,15,354,2,114024.23,NULL,'2022-11-21 16:58:55','2022-12-07 06:32:30','2022-12-07 06:32:30'),(418,7938,56,40720,3182,15,67,1,97404.01,NULL,'2022-11-21 17:00:02','2022-12-07 06:32:56','2022-12-07 06:32:56'),(419,7938,56,40720,3182,15,354,1,75921.04,NULL,'2022-11-21 17:00:02','2022-12-07 06:32:56','2022-12-07 06:32:56'),(420,7938,56,40720,3182,15,20,1,21953.05,NULL,'2022-11-21 17:00:02','2022-12-07 06:32:56','2022-12-07 06:32:56'),(421,7938,56,40720,3182,15,68,2,34902.35,NULL,'2022-11-21 17:00:02','2022-12-07 06:32:56','2022-12-07 06:32:56'),(422,7938,56,40720,3182,15,25,2,75921.04,NULL,'2022-11-21 17:00:02','2022-12-07 06:32:56','2022-12-07 06:32:56'),(423,7938,56,40720,3182,15,354,2,84454.71,NULL,'2022-11-21 17:00:02','2022-12-07 06:32:56','2022-12-07 06:32:56'),(424,7938,57,40720,3168,16,302,1,7551.49,NULL,'2022-11-22 16:56:31','2022-11-22 17:16:39','2022-11-22 17:16:39'),(425,7938,57,40720,3168,16,252,1,29795.77,NULL,'2022-11-22 16:56:31','2022-11-22 17:16:39','2022-11-22 17:16:39'),(426,7938,57,40720,3168,16,21,2,7500.00,NULL,'2022-11-22 16:56:31','2022-11-22 17:16:39','2022-11-22 17:16:39'),(427,7938,57,40720,3168,16,302,2,29847.26,NULL,'2022-11-22 16:56:31','2022-11-22 17:16:39','2022-11-22 17:16:39'),(428,7938,58,40720,3169,16,302,1,13495.68,NULL,'2022-11-22 16:57:29','2022-11-22 17:17:28','2022-11-22 17:17:28'),(429,7938,58,40720,3169,16,252,1,29800.09,NULL,'2022-11-22 16:57:29','2022-11-22 17:17:28','2022-11-22 17:17:28'),(430,7938,58,40720,3169,16,21,2,13500.00,NULL,'2022-11-22 16:57:29','2022-11-22 17:17:28','2022-11-22 17:17:28'),(431,7938,58,40720,3169,16,302,2,29795.77,NULL,'2022-11-22 16:57:29','2022-11-22 17:17:28','2022-11-22 17:17:28'),(432,7938,59,40720,3170,16,302,1,13493.60,NULL,'2022-11-22 16:58:30','2022-11-22 17:18:04','2022-11-22 17:18:04'),(433,7938,59,40720,3170,16,252,1,29806.49,NULL,'2022-11-22 16:58:30','2022-11-22 17:18:04','2022-11-22 17:18:04'),(434,7938,59,40720,3170,16,21,2,13500.00,NULL,'2022-11-22 16:58:30','2022-11-22 17:18:04','2022-11-22 17:18:04'),(435,7938,59,40720,3170,16,302,2,29800.09,NULL,'2022-11-22 16:58:30','2022-11-22 17:18:04','2022-11-22 17:18:04'),(436,7938,60,40720,3171,16,302,1,13495.00,NULL,'2022-11-22 16:59:38','2022-11-22 17:19:35','2022-11-22 17:19:35'),(437,7938,60,40720,3171,16,252,1,30035.36,NULL,'2022-11-22 16:59:38','2022-11-22 17:19:35','2022-11-22 17:19:35'),(438,7938,60,40720,3171,16,21,2,13500.00,NULL,'2022-11-22 16:59:38','2022-11-22 17:19:35','2022-11-22 17:19:35'),(439,7938,60,40720,3171,16,209,2,223.87,NULL,'2022-11-22 16:59:38','2022-11-22 17:19:35','2022-11-22 17:19:35');
INSERT INTO `balance_libro_details` VALUES (440,7938,60,40720,3171,16,302,2,29806.49,NULL,'2022-11-22 16:59:38','2022-11-22 17:19:35','2022-11-22 17:19:35'),(441,7938,61,40720,3175,16,302,1,13503.63,NULL,'2022-11-22 17:00:37','2022-11-22 17:20:55','2022-11-22 17:20:55'),(442,7938,61,40720,3175,16,252,1,30255.60,NULL,'2022-11-22 17:00:37','2022-11-22 17:20:55','2022-11-22 17:20:55'),(443,7938,61,40720,3175,16,21,2,13500.00,NULL,'2022-11-22 17:00:37','2022-11-22 17:20:55','2022-11-22 17:20:55'),(444,7938,61,40720,3175,16,209,2,223.87,NULL,'2022-11-22 17:00:37','2022-11-22 17:20:55','2022-11-22 17:20:55'),(445,7938,61,40720,3175,16,302,2,30035.36,NULL,'2022-11-22 17:00:37','2022-11-22 17:20:55','2022-11-22 17:20:55'),(446,7938,62,40720,3176,16,302,1,31398.96,NULL,'2022-11-22 17:01:34','2022-11-22 17:21:33','2022-11-22 17:21:33'),(447,7938,62,40720,3176,16,252,1,31117.35,NULL,'2022-11-22 17:01:34','2022-11-22 17:21:33','2022-11-22 17:21:33'),(448,7938,62,40720,3176,16,21,2,31735.35,NULL,'2022-11-22 17:01:34','2022-11-22 17:21:33','2022-11-22 17:21:33'),(449,7938,62,40720,3176,16,209,2,525.36,NULL,'2022-11-22 17:01:34','2022-11-22 17:21:33','2022-11-22 17:21:33'),(450,7938,62,40720,3176,16,302,2,30255.60,NULL,'2022-11-22 17:01:34','2022-11-22 17:21:33','2022-11-22 17:21:33'),(451,7938,63,40720,3177,16,302,1,13525.58,NULL,'2022-11-22 17:02:29','2022-11-22 17:22:10','2022-11-22 17:22:10'),(452,7938,63,40720,3177,16,252,1,31315.64,NULL,'2022-11-22 17:02:29','2022-11-22 17:22:10','2022-11-22 17:22:10'),(453,7938,63,40720,3177,16,21,2,13500.00,NULL,'2022-11-22 17:02:29','2022-11-22 17:22:10','2022-11-22 17:22:10'),(454,7938,63,40720,3177,16,209,2,223.87,NULL,'2022-11-22 17:02:29','2022-11-22 17:22:10','2022-11-22 17:22:10'),(455,7938,63,40720,3177,16,302,2,31117.35,NULL,'2022-11-22 17:02:29','2022-11-22 17:22:10','2022-11-22 17:22:10'),(456,7938,64,40720,3178,16,302,1,36840.88,NULL,'2022-11-22 17:05:03','2022-11-22 17:22:48','2022-11-22 17:22:48'),(457,7938,64,40720,3178,16,252,1,34011.50,NULL,'2022-11-22 17:05:03','2022-11-22 17:22:48','2022-11-22 17:22:48'),(458,7938,64,40720,3178,16,21,2,37081.71,NULL,'2022-11-22 17:05:03','2022-11-22 17:22:48','2022-11-22 17:22:48'),(459,7938,64,40720,3178,16,209,2,2455.03,NULL,'2022-11-22 17:05:03','2022-11-22 17:22:48','2022-11-22 17:22:48'),(460,7938,64,40720,3178,16,302,2,31315.64,NULL,'2022-11-22 17:05:03','2022-11-22 17:22:48','2022-11-22 17:22:48'),(461,7938,65,40720,3179,16,302,1,13526.37,NULL,'2022-11-22 17:06:45','2022-11-22 17:23:48','2022-11-22 17:23:48'),(462,7938,65,40720,3179,16,252,1,34284.00,NULL,'2022-11-22 17:06:45','2022-11-22 17:23:48','2022-11-22 17:23:48'),(463,7938,65,40720,3179,16,21,2,13500.00,NULL,'2022-11-22 17:06:45','2022-11-22 17:23:48','2022-11-22 17:23:48'),(464,7938,65,40720,3179,16,209,2,298.87,NULL,'2022-11-22 17:06:45','2022-11-22 17:23:48','2022-11-22 17:23:48'),(465,7938,65,40720,3179,16,302,2,34011.50,NULL,'2022-11-22 17:06:45','2022-11-22 17:23:48','2022-11-22 17:23:48'),(466,7938,66,40720,3180,16,302,1,13532.07,NULL,'2022-11-22 17:07:26','2022-11-22 17:24:48','2022-11-22 17:24:48'),(467,7938,66,40720,3180,16,252,1,20751.93,NULL,'2022-11-22 17:07:26','2022-11-22 17:24:48','2022-11-22 17:24:48'),(468,7938,66,40720,3180,16,302,2,34284.00,NULL,'2022-11-22 17:07:26','2022-11-22 17:24:48','2022-11-22 17:24:48'),(469,7938,67,40720,3181,16,302,1,38123.44,NULL,'2022-11-22 17:08:15','2022-11-22 17:25:22','2022-11-22 17:25:22'),(470,7938,67,40720,3181,16,252,1,21798.09,NULL,'2022-11-22 17:08:15','2022-11-22 17:25:22','2022-11-22 17:25:22'),(471,7938,67,40720,3181,16,21,2,38531.87,NULL,'2022-11-22 17:08:15','2022-11-22 17:25:22','2022-11-22 17:25:22'),(472,7938,67,40720,3181,16,209,2,637.73,NULL,'2022-11-22 17:08:15','2022-11-22 17:25:22','2022-11-22 17:25:22'),(473,7938,67,40720,3181,16,302,2,20751.93,NULL,'2022-11-22 17:08:15','2022-11-22 17:25:22','2022-11-22 17:25:22'),(474,7938,68,40720,3182,16,302,1,13767.36,NULL,'2022-11-22 17:09:17','2022-11-22 17:25:56','2022-11-22 17:25:56');
INSERT INTO `balance_libro_details` VALUES (475,7938,68,40720,3182,16,252,1,21978.47,NULL,'2022-11-22 17:09:17','2022-11-22 17:25:56','2022-11-22 17:25:56'),(476,7938,68,40720,3182,16,21,2,13500.00,NULL,'2022-11-22 17:09:17','2022-11-22 17:25:56','2022-11-22 17:25:56'),(477,7938,68,40720,3182,16,209,2,447.74,NULL,'2022-11-22 17:09:17','2022-11-22 17:25:56','2022-11-22 17:25:56'),(478,7938,68,40720,3182,16,302,2,21798.09,NULL,'2022-11-22 17:09:17','2022-11-22 17:25:56','2022-11-22 17:25:56'),(479,7938,69,40720,3168,16,21,2,7500.00,NULL,'2022-11-22 17:16:39','2022-12-07 06:47:33','2022-12-07 06:47:33'),(480,7938,69,40720,3168,16,302,2,29847.26,NULL,'2022-11-22 17:16:39','2022-12-07 06:47:33','2022-12-07 06:47:33'),(481,7938,69,40720,3168,16,156,1,7551.49,NULL,'2022-11-22 17:16:39','2022-12-07 06:47:33','2022-12-07 06:47:33'),(482,7938,69,40720,3168,16,302,1,29795.77,NULL,'2022-11-22 17:16:39','2022-12-07 06:47:33','2022-12-07 06:47:33'),(483,7938,70,40720,3169,16,302,1,29800.09,NULL,'2022-11-22 17:17:28','2022-12-07 06:47:11','2022-12-07 06:47:11'),(484,7938,70,40720,3169,16,21,2,13500.00,NULL,'2022-11-22 17:17:28','2022-12-07 06:47:11','2022-12-07 06:47:11'),(485,7938,70,40720,3169,16,302,2,29795.77,NULL,'2022-11-22 17:17:28','2022-12-07 06:47:11','2022-12-07 06:47:11'),(486,7938,70,40720,3169,16,156,1,13495.68,NULL,'2022-11-22 17:17:28','2022-12-07 06:47:11','2022-12-07 06:47:11'),(487,7938,71,40720,3170,16,302,1,29806.49,NULL,'2022-11-22 17:18:04','2022-12-07 06:46:50','2022-12-07 06:46:50'),(488,7938,71,40720,3170,16,21,2,13500.00,NULL,'2022-11-22 17:18:04','2022-12-07 06:46:50','2022-12-07 06:46:50'),(489,7938,71,40720,3170,16,302,2,29800.09,NULL,'2022-11-22 17:18:04','2022-12-07 06:46:50','2022-12-07 06:46:50'),(490,7938,71,40720,3170,16,156,1,13493.60,NULL,'2022-11-22 17:18:04','2022-12-07 06:46:50','2022-12-07 06:46:50'),(491,7938,72,40720,3171,16,302,1,30035.36,NULL,'2022-11-22 17:19:35','2022-12-07 06:42:59','2022-12-07 06:42:59'),(492,7938,72,40720,3171,16,21,2,13500.00,NULL,'2022-11-22 17:19:35','2022-12-07 06:42:59','2022-12-07 06:42:59'),(493,7938,72,40720,3171,16,209,2,223.87,NULL,'2022-11-22 17:19:35','2022-12-07 06:42:59','2022-12-07 06:42:59'),(494,7938,72,40720,3171,16,302,2,29806.49,NULL,'2022-11-22 17:19:35','2022-12-07 06:42:59','2022-12-07 06:42:59'),(495,7938,72,40720,3171,16,156,1,13495.00,NULL,'2022-11-22 17:19:35','2022-12-07 06:42:59','2022-12-07 06:42:59'),(496,7938,73,40720,3175,16,302,1,30255.60,NULL,'2022-11-22 17:20:55','2022-12-07 06:46:26','2022-12-07 06:46:26'),(497,7938,73,40720,3175,16,21,2,13500.00,NULL,'2022-11-22 17:20:55','2022-12-07 06:46:26','2022-12-07 06:46:26'),(498,7938,73,40720,3175,16,209,2,223.87,NULL,'2022-11-22 17:20:55','2022-12-07 06:46:26','2022-12-07 06:46:26'),(499,7938,73,40720,3175,16,302,2,30035.36,NULL,'2022-11-22 17:20:55','2022-12-07 06:46:26','2022-12-07 06:46:26'),(500,7938,73,40720,3175,16,156,1,13503.63,NULL,'2022-11-22 17:20:55','2022-12-07 06:46:26','2022-12-07 06:46:26'),(501,7938,74,40720,3176,16,302,1,31117.35,NULL,'2022-11-22 17:21:33','2022-12-07 06:46:02','2022-12-07 06:46:02'),(502,7938,74,40720,3176,16,21,2,31735.35,NULL,'2022-11-22 17:21:33','2022-12-07 06:46:02','2022-12-07 06:46:02'),(503,7938,74,40720,3176,16,209,2,525.36,NULL,'2022-11-22 17:21:33','2022-12-07 06:46:02','2022-12-07 06:46:02'),(504,7938,74,40720,3176,16,302,2,30255.60,NULL,'2022-11-22 17:21:33','2022-12-07 06:46:02','2022-12-07 06:46:02'),(505,7938,74,40720,3176,16,156,1,31398.96,NULL,'2022-11-22 17:21:33','2022-12-07 06:46:02','2022-12-07 06:46:02'),(506,7938,75,40720,3177,16,302,1,31315.64,NULL,'2022-11-22 17:22:10','2022-12-07 06:45:39','2022-12-07 06:45:39'),(507,7938,75,40720,3177,16,21,2,13500.00,NULL,'2022-11-22 17:22:10','2022-12-07 06:45:39','2022-12-07 06:45:39'),(508,7938,75,40720,3177,16,209,2,223.87,NULL,'2022-11-22 17:22:10','2022-12-07 06:45:39','2022-12-07 06:45:39'),(509,7938,75,40720,3177,16,302,2,31117.35,NULL,'2022-11-22 17:22:10','2022-12-07 06:45:39','2022-12-07 06:45:39');
INSERT INTO `balance_libro_details` VALUES (510,7938,75,40720,3177,16,156,1,13525.58,NULL,'2022-11-22 17:22:10','2022-12-07 06:45:39','2022-12-07 06:45:39'),(511,7938,76,40720,3178,16,302,1,34011.50,NULL,'2022-11-22 17:22:48','2022-12-07 06:45:18','2022-12-07 06:45:18'),(512,7938,76,40720,3178,16,21,2,37081.71,NULL,'2022-11-22 17:22:48','2022-12-07 06:45:18','2022-12-07 06:45:18'),(513,7938,76,40720,3178,16,209,2,2455.03,NULL,'2022-11-22 17:22:48','2022-12-07 06:45:18','2022-12-07 06:45:18'),(514,7938,76,40720,3178,16,302,2,31315.64,NULL,'2022-11-22 17:22:48','2022-12-07 06:45:18','2022-12-07 06:45:18'),(515,7938,76,40720,3178,16,156,1,36840.88,NULL,'2022-11-22 17:22:48','2022-12-07 06:45:18','2022-12-07 06:45:18'),(516,7938,77,40720,3179,16,302,1,34284.00,NULL,'2022-11-22 17:23:48','2022-12-07 06:44:50','2022-12-07 06:44:50'),(517,7938,77,40720,3179,16,21,2,13500.00,NULL,'2022-11-22 17:23:48','2022-12-07 06:44:50','2022-12-07 06:44:50'),(518,7938,77,40720,3179,16,209,2,298.87,NULL,'2022-11-22 17:23:48','2022-12-07 06:44:50','2022-12-07 06:44:50'),(519,7938,77,40720,3179,16,302,2,34011.50,NULL,'2022-11-22 17:23:48','2022-12-07 06:44:50','2022-12-07 06:44:50'),(520,7938,77,40720,3179,16,156,1,13526.37,NULL,'2022-11-22 17:23:48','2022-12-07 06:44:50','2022-12-07 06:44:50'),(521,7938,78,40720,3180,16,302,1,20751.93,NULL,'2022-11-22 17:24:48','2022-12-07 06:44:25','2022-12-07 06:44:25'),(522,7938,78,40720,3180,16,302,2,34284.00,NULL,'2022-11-22 17:24:48','2022-12-07 06:44:25','2022-12-07 06:44:25'),(523,7938,78,40720,3180,16,156,1,13532.07,NULL,'2022-11-22 17:24:48','2022-12-07 06:44:25','2022-12-07 06:44:25'),(524,7938,79,40720,3181,16,302,1,21798.09,NULL,'2022-11-22 17:25:22','2022-12-07 06:44:03','2022-12-07 06:44:03'),(525,7938,79,40720,3181,16,21,2,38531.87,NULL,'2022-11-22 17:25:22','2022-12-07 06:44:03','2022-12-07 06:44:03'),(526,7938,79,40720,3181,16,209,2,637.73,NULL,'2022-11-22 17:25:22','2022-12-07 06:44:03','2022-12-07 06:44:03'),(527,7938,79,40720,3181,16,302,2,20751.93,NULL,'2022-11-22 17:25:22','2022-12-07 06:44:03','2022-12-07 06:44:03'),(528,7938,79,40720,3181,16,156,1,38123.44,NULL,'2022-11-22 17:25:22','2022-12-07 06:44:03','2022-12-07 06:44:03'),(529,7938,80,40720,3182,16,302,1,21978.47,NULL,'2022-11-22 17:25:56','2022-12-07 06:43:37','2022-12-07 06:43:37'),(530,7938,80,40720,3182,16,21,2,13500.00,NULL,'2022-11-22 17:25:56','2022-12-07 06:43:37','2022-12-07 06:43:37'),(531,7938,80,40720,3182,16,209,2,447.74,NULL,'2022-11-22 17:25:56','2022-12-07 06:43:37','2022-12-07 06:43:37'),(532,7938,80,40720,3182,16,302,2,21798.09,NULL,'2022-11-22 17:25:56','2022-12-07 06:43:37','2022-12-07 06:43:37'),(533,7938,80,40720,3182,16,156,1,13767.36,NULL,'2022-11-22 17:25:56','2022-12-07 06:43:37','2022-12-07 06:43:37'),(534,7938,81,40720,3168,16,156,1,107.87,NULL,'2022-11-22 17:30:15','2022-12-07 06:49:21','2022-12-07 06:49:21'),(535,7938,81,40720,3168,16,301,1,2925.61,NULL,'2022-11-22 17:30:15','2022-12-07 06:49:21','2022-12-07 06:49:21'),(536,7938,81,40720,3168,16,301,2,3033.48,NULL,'2022-11-22 17:30:15','2022-12-07 06:49:21','2022-12-07 06:49:21'),(537,7938,82,40720,3169,16,156,1,192.78,NULL,'2022-11-22 17:31:08','2022-12-07 06:49:48','2022-12-07 06:49:48'),(538,7938,82,40720,3169,16,301,1,2732.83,NULL,'2022-11-22 17:31:08','2022-12-07 06:49:48','2022-12-07 06:49:48'),(539,7938,82,40720,3169,16,301,2,2925.61,NULL,'2022-11-22 17:31:08','2022-12-07 06:49:48','2022-12-07 06:49:48'),(540,7938,83,40720,3170,16,156,1,192.78,NULL,'2022-11-22 17:31:55','2022-12-07 06:42:31','2022-12-07 06:42:31'),(541,7938,83,40720,3170,16,301,1,2540.05,NULL,'2022-11-22 17:31:55','2022-12-07 06:42:31','2022-12-07 06:42:31'),(542,7938,83,40720,3170,16,301,2,2732.83,NULL,'2022-11-22 17:31:55','2022-12-07 06:42:31','2022-12-07 06:42:31'),(543,7938,84,40720,3170,16,156,1,192.77,NULL,'2022-11-22 17:32:46','2022-11-22 17:33:26','2022-11-22 17:33:26'),(544,7938,84,40720,3170,16,301,1,2347.28,NULL,'2022-11-22 17:32:46','2022-11-22 17:33:26','2022-11-22 17:33:26');
INSERT INTO `balance_libro_details` VALUES (545,7938,84,40720,3170,16,301,2,2540.05,NULL,'2022-11-22 17:32:46','2022-11-22 17:33:26','2022-11-22 17:33:26'),(546,7938,85,40720,3171,16,156,1,192.77,NULL,'2022-11-22 17:33:51','2022-12-07 06:41:49','2022-12-07 06:41:49'),(547,7938,85,40720,3171,16,301,1,2347.28,NULL,'2022-11-22 17:33:51','2022-12-07 06:41:49','2022-12-07 06:41:49'),(548,7938,85,40720,3171,16,301,2,2540.05,NULL,'2022-11-22 17:33:51','2022-12-07 06:41:49','2022-12-07 06:41:49'),(549,7938,86,40720,3175,16,156,1,168.78,NULL,'2022-11-22 17:34:33','2022-12-07 06:48:55','2022-12-07 06:48:55'),(550,7938,86,40720,3175,16,301,1,2178.50,NULL,'2022-11-22 17:34:33','2022-12-07 06:48:55','2022-12-07 06:48:55'),(551,7938,86,40720,3175,16,301,2,2347.28,NULL,'2022-11-22 17:34:33','2022-12-07 06:48:55','2022-12-07 06:48:55'),(552,7938,87,40720,3176,16,156,1,392.46,NULL,'2022-11-22 17:37:22','2022-12-07 06:41:27','2022-12-07 06:41:27'),(553,7938,87,40720,3176,16,301,1,1786.04,NULL,'2022-11-22 17:37:22','2022-12-07 06:41:27','2022-12-07 06:41:27'),(554,7938,87,40720,3176,16,301,2,2178.50,NULL,'2022-11-22 17:37:22','2022-12-07 06:41:27','2022-12-07 06:41:27'),(555,7938,88,40720,3177,16,156,1,169.06,NULL,'2022-11-22 17:38:34','2022-12-07 06:41:08','2022-12-07 06:41:08'),(556,7938,88,40720,3177,16,301,1,1616.98,NULL,'2022-11-22 17:38:34','2022-12-07 06:41:08','2022-12-07 06:41:08'),(557,7938,88,40720,3177,16,301,2,1786.04,NULL,'2022-11-22 17:38:34','2022-12-07 06:41:08','2022-12-07 06:41:08'),(558,7938,89,40720,3178,16,156,1,460.48,NULL,'2022-11-22 17:39:27','2022-12-07 06:40:47','2022-12-07 06:40:47'),(559,7938,89,40720,3178,16,301,1,1156.50,NULL,'2022-11-22 17:39:27','2022-12-07 06:40:47','2022-12-07 06:40:47'),(560,7938,89,40720,3178,16,301,2,1616.98,NULL,'2022-11-22 17:39:27','2022-12-07 06:40:47','2022-12-07 06:40:47'),(561,7938,90,40720,3179,16,156,1,169.07,NULL,'2022-11-22 17:40:22','2022-12-07 06:40:27','2022-12-07 06:40:27'),(562,7938,90,40720,3179,16,301,1,987.43,NULL,'2022-11-22 17:40:22','2022-12-07 06:40:27','2022-12-07 06:40:27'),(563,7938,90,40720,3179,16,301,2,1156.50,NULL,'2022-11-22 17:40:22','2022-12-07 06:40:27','2022-12-07 06:40:27'),(564,7938,91,40720,3180,16,156,1,169.14,NULL,'2022-11-22 17:41:10','2022-12-07 06:40:06','2022-12-07 06:40:06'),(565,7938,91,40720,3180,16,301,1,818.29,NULL,'2022-11-22 17:41:10','2022-12-07 06:40:06','2022-12-07 06:40:06'),(566,7938,91,40720,3180,16,301,2,987.43,NULL,'2022-11-22 17:41:10','2022-12-07 06:40:06','2022-12-07 06:40:06'),(567,7938,92,40720,3181,16,156,1,476.51,NULL,'2022-11-22 17:42:01','2022-12-07 06:39:46','2022-12-07 06:39:46'),(568,7938,92,40720,3181,16,301,1,341.78,NULL,'2022-11-22 17:42:01','2022-12-07 06:39:46','2022-12-07 06:39:46'),(569,7938,92,40720,3181,16,301,2,818.29,NULL,'2022-11-22 17:42:01','2022-12-07 06:39:46','2022-12-07 06:39:46'),(570,7938,93,40720,3182,16,156,1,172.08,NULL,'2022-11-22 17:43:07','2022-12-07 06:39:21','2022-12-07 06:39:21'),(571,7938,93,40720,3182,16,301,1,169.70,NULL,'2022-11-22 17:43:07','2022-12-07 06:39:21','2022-12-07 06:39:21'),(572,7938,93,40720,3182,16,301,2,341.78,NULL,'2022-11-22 17:43:07','2022-12-07 06:39:21','2022-12-07 06:39:21'),(573,7938,94,40720,1518,2,386,1,51481.11,NULL,'2022-12-07 05:17:43','2022-12-07 05:17:43',NULL),(574,7938,94,40720,1518,2,102,2,51481.11,NULL,'2022-12-07 05:17:43','2022-12-07 05:17:43',NULL),(575,7938,95,40720,1519,2,386,1,51215.91,NULL,'2022-12-07 05:18:40','2022-12-07 05:18:40',NULL),(576,7938,95,40720,1519,2,23,1,1584.00,NULL,'2022-12-07 05:18:40','2022-12-07 05:18:40',NULL),(577,7938,95,40720,1519,2,102,2,52799.91,NULL,'2022-12-07 05:18:40','2022-12-07 05:18:40',NULL),(578,7938,96,40720,1520,2,386,1,52604.22,NULL,'2022-12-07 05:19:38','2022-12-07 05:19:38',NULL),(579,7938,96,40720,1520,2,23,1,1626.93,NULL,'2022-12-07 05:19:38','2022-12-07 05:19:38',NULL),(580,7938,96,40720,1520,2,102,2,54231.15,NULL,'2022-12-07 05:19:38','2022-12-07 05:19:38',NULL),(581,7938,97,40720,1521,2,386,1,55831.15,NULL,'2022-12-07 05:20:44','2022-12-07 05:20:44',NULL);
INSERT INTO `balance_libro_details` VALUES (582,7938,97,40720,1521,2,23,1,1726.74,NULL,'2022-12-07 05:20:44','2022-12-07 05:20:44',NULL),(583,7938,97,40720,1521,2,102,2,57557.89,NULL,'2022-12-07 05:20:44','2022-12-07 05:20:44',NULL),(584,7938,98,40720,1525,2,386,1,1900000.00,NULL,'2022-12-07 05:24:15','2022-12-07 05:24:15',NULL),(585,7938,98,40720,1525,2,425,1,2104603.29,NULL,'2022-12-07 05:24:15','2022-12-07 05:24:15',NULL),(586,7938,98,40720,1525,2,386,2,2104603.29,NULL,'2022-12-07 05:24:15','2022-12-07 05:24:15',NULL),(587,7938,98,40720,1525,2,425,2,1900000.00,NULL,'2022-12-07 05:24:15','2022-12-07 05:24:15',NULL),(588,7938,99,40720,1525,2,386,1,55543.55,NULL,'2022-12-07 05:26:23','2022-12-07 05:26:23',NULL),(589,7938,99,40720,1525,2,23,1,1717.84,NULL,'2022-12-07 05:26:23','2022-12-07 05:26:23',NULL),(590,7938,99,40720,1525,2,102,2,57261.39,NULL,'2022-12-07 05:26:23','2022-12-07 05:26:23',NULL),(591,7938,100,40720,1526,2,386,1,61269.68,NULL,'2022-12-07 05:28:12','2022-12-07 05:28:12',NULL),(592,7938,100,40720,1526,2,102,2,61269.68,NULL,'2022-12-07 05:28:12','2022-12-07 05:28:12',NULL),(593,7938,101,40720,1527,2,386,1,81319.08,NULL,'2022-12-07 05:29:10','2022-12-07 05:29:10',NULL),(594,7938,101,40720,1527,2,23,1,2123.85,NULL,'2022-12-07 05:29:10','2022-12-07 05:29:10',NULL),(595,7938,101,40720,1527,2,102,2,83442.93,NULL,'2022-12-07 05:29:10','2022-12-07 05:29:10',NULL),(596,7938,102,40720,1527,2,386,1,1000000.00,NULL,'2022-12-07 05:29:55','2022-12-07 05:29:55',NULL),(597,7938,102,40720,1527,2,425,2,1000000.00,NULL,'2022-12-07 05:29:55','2022-12-07 05:29:55',NULL),(598,7938,103,40720,1528,2,386,1,68671.10,NULL,'2022-12-07 05:30:57','2022-12-07 05:30:57',NULL),(599,7938,103,40720,1528,2,23,1,2123.85,NULL,'2022-12-07 05:30:57','2022-12-07 05:30:57',NULL),(600,7938,103,40720,1528,2,102,2,70794.95,NULL,'2022-12-07 05:30:57','2022-12-07 05:30:57',NULL),(601,7938,104,40720,1529,2,386,1,108853.45,NULL,'2022-12-07 05:32:47','2022-12-07 05:32:47',NULL),(602,7938,104,40720,1529,2,23,1,2309.20,NULL,'2022-12-07 05:32:47','2022-12-07 05:32:47',NULL),(603,7938,104,40720,1529,2,102,2,111162.65,NULL,'2022-12-07 05:32:47','2022-12-07 05:32:47',NULL),(604,7938,105,40720,1529,2,386,1,1600000.00,NULL,'2022-12-07 05:34:25','2022-12-07 10:38:15','2022-12-07 10:38:15'),(605,7938,105,40720,1529,2,425,1,1102860.28,NULL,'2022-12-07 05:34:25','2022-12-07 10:38:15','2022-12-07 10:38:15'),(606,7938,105,40720,1529,2,386,2,1102860.28,NULL,'2022-12-07 05:34:25','2022-12-07 10:38:15','2022-12-07 10:38:15'),(607,7938,105,40720,1529,2,425,2,1600000.00,NULL,'2022-12-07 05:34:25','2022-12-07 10:38:15','2022-12-07 10:38:15'),(608,7938,106,40720,1530,2,386,1,148210.95,NULL,'2022-12-07 05:35:20','2022-12-07 05:35:20',NULL),(609,7938,106,40720,1530,2,23,1,5001.59,NULL,'2022-12-07 05:35:20','2022-12-07 05:35:20',NULL),(610,7938,106,40720,1530,2,102,2,153212.54,NULL,'2022-12-07 05:35:20','2022-12-07 05:35:20',NULL),(611,7938,107,40720,1530,2,386,1,1100000.00,NULL,'2022-12-07 05:36:10','2022-12-07 05:36:10',NULL),(612,7938,107,40720,1530,2,425,1,1248210.95,NULL,'2022-12-07 05:36:10','2022-12-07 05:36:10',NULL),(613,7938,107,40720,1530,2,386,2,1248210.95,NULL,'2022-12-07 05:36:10','2022-12-07 05:36:10',NULL),(614,7938,107,40720,1530,2,425,2,1100000.00,NULL,'2022-12-07 05:36:10','2022-12-07 05:36:10',NULL),(615,7938,108,40720,1531,2,386,1,154287.19,NULL,'2022-12-07 05:37:10','2022-12-07 05:37:10',NULL),(616,7938,108,40720,1531,2,23,1,5875.03,NULL,'2022-12-07 05:37:10','2022-12-07 05:37:10',NULL),(617,7938,108,40720,1531,2,102,2,160162.22,NULL,'2022-12-07 05:37:10','2022-12-07 05:37:10',NULL),(618,7938,109,40720,1531,2,386,1,858276.48,NULL,'2022-12-07 05:42:53','2022-12-07 11:13:19','2022-12-07 11:13:19'),(619,7938,109,40720,1531,2,425,2,858276.48,NULL,'2022-12-07 05:42:53','2022-12-07 11:13:19','2022-12-07 11:13:19'),(620,7938,110,40720,1532,2,386,1,206139.13,NULL,'2022-12-07 05:44:30','2022-12-07 11:40:30','2022-12-07 11:40:30');
INSERT INTO `balance_libro_details` VALUES (621,7938,110,40720,1532,2,23,1,6359.49,NULL,'2022-12-07 05:44:30','2022-12-07 11:40:30','2022-12-07 11:40:30'),(622,7938,110,40720,1532,2,102,2,212498.62,NULL,'2022-12-07 05:44:30','2022-12-07 11:40:30','2022-12-07 11:40:30'),(623,7938,111,40720,1518,3,425,2,320446.43,NULL,'2022-12-07 05:48:35','2022-12-07 07:13:49','2022-12-07 07:13:49'),(624,7938,111,40720,1518,3,491,1,110000.00,NULL,'2022-12-07 05:48:35','2022-12-07 07:13:49','2022-12-07 07:13:49'),(625,7938,111,40720,1518,3,492,1,45540.00,NULL,'2022-12-07 05:48:35','2022-12-07 07:13:49','2022-12-07 07:13:49'),(626,7938,111,40720,1518,3,135,1,33093.44,NULL,'2022-12-07 05:48:35','2022-12-07 07:13:49','2022-12-07 07:13:49'),(627,7938,111,40720,1518,3,494,1,18398.00,NULL,'2022-12-07 05:48:35','2022-12-07 07:13:49','2022-12-07 07:13:49'),(628,7938,111,40720,1518,3,496,1,25481.95,NULL,'2022-12-07 05:48:35','2022-12-07 07:13:49','2022-12-07 07:13:49'),(629,7938,111,40720,1518,3,396,1,2826.00,NULL,'2022-12-07 05:48:35','2022-12-07 07:13:49','2022-12-07 07:13:49'),(630,7938,111,40720,1518,3,157,1,3486.31,NULL,'2022-12-07 05:48:35','2022-12-07 07:13:49','2022-12-07 07:13:49'),(631,7938,111,40720,1518,3,220,1,678.24,NULL,'2022-12-07 05:48:35','2022-12-07 07:13:49','2022-12-07 07:13:49'),(632,7938,111,40720,1518,3,68,1,80942.49,NULL,'2022-12-07 05:48:35','2022-12-07 07:13:49','2022-12-07 07:13:49'),(633,7938,112,40720,1519,3,425,2,488720.02,NULL,'2022-12-07 05:50:26','2022-12-07 12:24:37','2022-12-07 12:24:37'),(634,7938,112,40720,1519,3,491,1,110000.00,NULL,'2022-12-07 05:50:26','2022-12-07 12:24:37','2022-12-07 12:24:37'),(635,7938,112,40720,1519,3,492,1,45510.00,NULL,'2022-12-07 05:50:26','2022-12-07 12:24:37','2022-12-07 12:24:37'),(636,7938,112,40720,1519,3,135,1,254817.57,NULL,'2022-12-07 05:50:26','2022-12-07 12:24:37','2022-12-07 12:24:37'),(637,7938,112,40720,1519,3,494,1,3157.00,NULL,'2022-12-07 05:50:26','2022-12-07 12:24:37','2022-12-07 12:24:37'),(638,7938,112,40720,1519,3,496,1,18656.16,NULL,'2022-12-07 05:50:26','2022-12-07 12:24:37','2022-12-07 12:24:37'),(639,7938,112,40720,1519,3,188,1,7200.00,NULL,'2022-12-07 05:50:26','2022-12-07 12:24:37','2022-12-07 12:24:37'),(640,7938,112,40720,1519,3,396,1,2826.00,NULL,'2022-12-07 05:50:26','2022-12-07 12:24:37','2022-12-07 12:24:37'),(641,7938,112,40720,1519,3,157,1,5866.19,NULL,'2022-12-07 05:50:26','2022-12-07 12:24:37','2022-12-07 12:24:37'),(642,7938,112,40720,1519,3,220,1,678.24,NULL,'2022-12-07 05:50:26','2022-12-07 12:24:37','2022-12-07 12:24:37'),(643,7938,112,40720,1519,3,68,1,30968.86,NULL,'2022-12-07 05:50:26','2022-12-07 12:24:37','2022-12-07 12:24:37'),(644,7938,112,40720,1519,3,498,1,9040.00,NULL,'2022-12-07 05:50:26','2022-12-07 12:24:37','2022-12-07 12:24:37'),(645,7938,113,40720,1520,3,425,2,247436.29,NULL,'2022-12-07 05:51:27','2022-12-07 08:32:46','2022-12-07 08:32:46'),(646,7938,113,40720,1520,3,491,1,110000.00,NULL,'2022-12-07 05:51:27','2022-12-07 08:32:46','2022-12-07 08:32:46'),(647,7938,113,40720,1520,3,492,1,45600.00,NULL,'2022-12-07 05:51:27','2022-12-07 08:32:46','2022-12-07 08:32:46'),(648,7938,113,40720,1520,3,135,1,6595.55,NULL,'2022-12-07 05:51:27','2022-12-07 08:32:46','2022-12-07 08:32:46'),(649,7938,113,40720,1520,3,493,1,2766.92,NULL,'2022-12-07 05:51:27','2022-12-07 08:32:46','2022-12-07 08:32:46'),(650,7938,113,40720,1520,3,494,1,5656.96,NULL,'2022-12-07 05:51:27','2022-12-07 08:32:46','2022-12-07 08:32:46'),(651,7938,113,40720,1520,3,496,1,25999.55,NULL,'2022-12-07 05:51:27','2022-12-07 08:32:46','2022-12-07 08:32:46'),(652,7938,113,40720,1520,3,188,1,7200.00,NULL,'2022-12-07 05:51:27','2022-12-07 08:32:46','2022-12-07 08:32:46'),(653,7938,113,40720,1520,3,396,1,2826.00,NULL,'2022-12-07 05:51:27','2022-12-07 08:32:46','2022-12-07 08:32:46'),(654,7938,113,40720,1520,3,157,1,5000.20,NULL,'2022-12-07 05:51:27','2022-12-07 08:32:46','2022-12-07 08:32:46'),(655,7938,113,40720,1520,3,220,1,678.24,NULL,'2022-12-07 05:51:27','2022-12-07 08:32:46','2022-12-07 08:32:46');
INSERT INTO `balance_libro_details` VALUES (656,7938,113,40720,1520,3,68,1,35112.87,NULL,'2022-12-07 05:51:27','2022-12-07 08:32:46','2022-12-07 08:32:46'),(657,7938,114,40720,1521,3,425,2,325002.80,NULL,'2022-12-07 05:57:49','2022-12-07 08:37:31','2022-12-07 08:37:31'),(658,7938,114,40720,1521,3,491,1,110000.00,NULL,'2022-12-07 05:57:49','2022-12-07 08:37:31','2022-12-07 08:37:31'),(659,7938,114,40720,1521,3,492,1,45640.00,NULL,'2022-12-07 05:57:49','2022-12-07 08:37:31','2022-12-07 08:37:31'),(660,7938,114,40720,1521,3,135,1,20460.43,NULL,'2022-12-07 05:57:49','2022-12-07 08:37:31','2022-12-07 08:37:31'),(661,7938,114,40720,1521,3,494,1,46937.12,NULL,'2022-12-07 05:57:49','2022-12-07 08:37:31','2022-12-07 08:37:31'),(662,7938,114,40720,1521,3,496,1,32134.00,NULL,'2022-12-07 05:57:49','2022-12-07 08:37:31','2022-12-07 08:37:31'),(663,7938,114,40720,1521,3,188,1,2000.00,NULL,'2022-12-07 05:57:49','2022-12-07 08:37:31','2022-12-07 08:37:31'),(664,7938,114,40720,1521,3,396,1,2826.00,NULL,'2022-12-07 05:57:49','2022-12-07 08:37:31','2022-12-07 08:37:31'),(665,7938,114,40720,1521,3,157,1,4605.85,NULL,'2022-12-07 05:57:49','2022-12-07 08:37:31','2022-12-07 08:37:31'),(666,7938,114,40720,1521,3,220,1,678.24,NULL,'2022-12-07 05:57:49','2022-12-07 08:37:31','2022-12-07 08:37:31'),(667,7938,114,40720,1521,3,75,1,223.87,NULL,'2022-12-07 05:57:49','2022-12-07 08:37:31','2022-12-07 08:37:31'),(668,7938,114,40720,1521,3,68,1,42997.29,NULL,'2022-12-07 05:57:49','2022-12-07 08:37:31','2022-12-07 08:37:31'),(669,7938,114,40720,1521,3,498,1,16500.00,NULL,'2022-12-07 05:57:49','2022-12-07 08:37:31','2022-12-07 08:37:31'),(670,7938,115,40720,1525,3,425,2,263136.59,NULL,'2022-12-07 05:58:19','2022-12-07 12:32:10','2022-12-07 12:32:10'),(671,7938,115,40720,1525,3,491,1,110000.00,NULL,'2022-12-07 05:58:19','2022-12-07 12:32:10','2022-12-07 12:32:10'),(672,7938,115,40720,1525,3,492,1,55070.00,NULL,'2022-12-07 05:58:19','2022-12-07 12:32:10','2022-12-07 12:32:10'),(673,7938,115,40720,1525,3,135,1,7137.07,NULL,'2022-12-07 05:58:19','2022-12-07 12:32:10','2022-12-07 12:32:10'),(674,7938,115,40720,1525,3,494,1,22646.98,NULL,'2022-12-07 05:58:19','2022-12-07 12:32:10','2022-12-07 12:32:10'),(675,7938,115,40720,1525,3,496,1,27181.68,NULL,'2022-12-07 05:58:19','2022-12-07 12:32:10','2022-12-07 12:32:10'),(676,7938,115,40720,1525,3,396,1,2826.00,NULL,'2022-12-07 05:58:19','2022-12-07 12:32:10','2022-12-07 12:32:10'),(677,7938,115,40720,1525,3,157,1,3446.02,NULL,'2022-12-07 05:58:19','2022-12-07 12:32:10','2022-12-07 12:32:10'),(678,7938,115,40720,1525,3,220,1,678.24,NULL,'2022-12-07 05:58:19','2022-12-07 12:32:10','2022-12-07 12:32:10'),(679,7938,115,40720,1525,3,75,1,223.77,NULL,'2022-12-07 05:58:19','2022-12-07 12:32:10','2022-12-07 12:32:10'),(680,7938,115,40720,1525,3,68,1,33926.83,NULL,'2022-12-07 05:58:19','2022-12-07 12:32:10','2022-12-07 12:32:10'),(681,7938,116,40720,1526,3,425,2,329493.33,NULL,'2022-12-07 05:59:17','2022-12-07 12:28:06','2022-12-07 12:28:06'),(682,7938,116,40720,1526,3,491,1,110000.00,NULL,'2022-12-07 05:59:17','2022-12-07 12:28:06','2022-12-07 12:28:06'),(683,7938,116,40720,1526,3,492,1,111950.00,NULL,'2022-12-07 05:59:17','2022-12-07 12:28:06','2022-12-07 12:28:06'),(684,7938,116,40720,1526,3,135,1,21865.38,NULL,'2022-12-07 05:59:17','2022-12-07 12:28:06','2022-12-07 12:28:06'),(685,7938,116,40720,1526,3,494,1,5200.00,NULL,'2022-12-07 05:59:17','2022-12-07 12:28:06','2022-12-07 12:28:06'),(686,7938,116,40720,1526,3,496,1,30111.64,NULL,'2022-12-07 05:59:17','2022-12-07 12:28:06','2022-12-07 12:28:06'),(687,7938,116,40720,1526,3,396,1,3000.00,NULL,'2022-12-07 05:59:17','2022-12-07 12:28:06','2022-12-07 12:28:06'),(688,7938,116,40720,1526,3,157,1,12920.41,NULL,'2022-12-07 05:59:17','2022-12-07 12:28:06','2022-12-07 12:28:06'),(689,7938,116,40720,1526,3,220,1,720.00,NULL,'2022-12-07 05:59:17','2022-12-07 12:28:06','2022-12-07 12:28:06'),(690,7938,116,40720,1526,3,75,1,525.36,NULL,'2022-12-07 05:59:17','2022-12-07 12:28:06','2022-12-07 12:28:06');
INSERT INTO `balance_libro_details` VALUES (691,7938,116,40720,1526,3,68,1,33200.54,NULL,'2022-12-07 05:59:17','2022-12-07 12:28:06','2022-12-07 12:28:06'),(692,7938,117,40720,1527,3,425,2,253741.69,NULL,'2022-12-07 06:03:57','2022-12-07 12:29:34','2022-12-07 12:29:34'),(693,7938,117,40720,1527,3,491,1,110000.00,NULL,'2022-12-07 06:03:57','2022-12-07 12:29:34','2022-12-07 12:29:34'),(694,7938,117,40720,1527,3,492,1,48500.00,NULL,'2022-12-07 06:03:57','2022-12-07 12:29:34','2022-12-07 12:29:34'),(695,7938,117,40720,1527,3,135,1,34756.49,NULL,'2022-12-07 06:03:57','2022-12-07 12:29:34','2022-12-07 12:29:34'),(696,7938,117,40720,1527,3,496,1,32105.79,NULL,'2022-12-07 06:03:57','2022-12-07 12:29:34','2022-12-07 12:29:34'),(697,7938,117,40720,1527,3,396,1,3000.00,NULL,'2022-12-07 06:03:57','2022-12-07 12:29:34','2022-12-07 12:29:34'),(698,7938,117,40720,1527,3,157,1,3389.97,NULL,'2022-12-07 06:03:57','2022-12-07 12:29:34','2022-12-07 12:29:34'),(699,7938,117,40720,1527,3,220,1,720.00,NULL,'2022-12-07 06:03:57','2022-12-07 12:29:34','2022-12-07 12:29:34'),(700,7938,117,40720,1527,3,75,1,223.87,NULL,'2022-12-07 06:03:57','2022-12-07 12:29:34','2022-12-07 12:29:34'),(701,7938,117,40720,1527,3,68,1,10445.57,NULL,'2022-12-07 06:03:57','2022-12-07 12:29:34','2022-12-07 12:29:34'),(702,7938,117,40720,1527,3,498,1,10600.00,NULL,'2022-12-07 06:03:57','2022-12-07 12:29:34','2022-12-07 12:29:34'),(703,7938,118,40720,1528,3,425,2,631541.65,NULL,'2022-12-07 06:10:30','2022-12-07 06:15:32','2022-12-07 06:15:32'),(704,7938,118,40720,1528,3,492,1,48750.00,NULL,'2022-12-07 06:10:30','2022-12-07 06:15:32','2022-12-07 06:15:32'),(705,7938,118,40720,1528,3,135,1,17301.58,NULL,'2022-12-07 06:10:30','2022-12-07 06:15:32','2022-12-07 06:15:32'),(706,7938,118,40720,1528,3,493,1,385000.00,NULL,'2022-12-07 06:10:30','2022-12-07 06:15:32','2022-12-07 06:15:32'),(707,7938,118,40720,1528,3,494,1,24536.29,NULL,'2022-12-07 06:10:30','2022-12-07 06:15:32','2022-12-07 06:15:32'),(708,7938,118,40720,1528,3,496,1,35804.19,NULL,'2022-12-07 06:10:30','2022-12-07 06:15:32','2022-12-07 06:15:32'),(709,7938,118,40720,1528,3,396,1,3000.00,NULL,'2022-12-07 06:10:31','2022-12-07 06:15:32','2022-12-07 06:15:32'),(710,7938,118,40720,1528,3,157,1,12444.94,NULL,'2022-12-07 06:10:31','2022-12-07 06:15:32','2022-12-07 06:15:32'),(711,7938,118,40720,1528,3,220,1,720.00,NULL,'2022-12-07 06:10:31','2022-12-07 06:15:32','2022-12-07 06:15:32'),(712,7938,118,40720,1528,3,75,1,2455.03,NULL,'2022-12-07 06:10:31','2022-12-07 06:15:32','2022-12-07 06:15:32'),(713,7938,118,40720,1528,3,68,1,101529.62,NULL,'2022-12-07 06:10:31','2022-12-07 06:15:32','2022-12-07 06:15:32'),(714,7938,119,40720,1528,3,425,2,652361.12,NULL,'2022-12-07 06:15:32','2022-12-07 12:27:05','2022-12-07 12:27:05'),(715,7938,119,40720,1528,3,492,1,48750.00,NULL,'2022-12-07 06:15:32','2022-12-07 12:27:05','2022-12-07 12:27:05'),(716,7938,119,40720,1528,3,135,1,38121.05,NULL,'2022-12-07 06:15:32','2022-12-07 12:27:05','2022-12-07 12:27:05'),(717,7938,119,40720,1528,3,493,1,385000.00,NULL,'2022-12-07 06:15:32','2022-12-07 12:27:05','2022-12-07 12:27:05'),(718,7938,119,40720,1528,3,494,1,24536.29,NULL,'2022-12-07 06:15:32','2022-12-07 12:27:05','2022-12-07 12:27:05'),(719,7938,119,40720,1528,3,496,1,35804.19,NULL,'2022-12-07 06:15:32','2022-12-07 12:27:05','2022-12-07 12:27:05'),(720,7938,119,40720,1528,3,396,1,3000.00,NULL,'2022-12-07 06:15:32','2022-12-07 12:27:05','2022-12-07 12:27:05'),(721,7938,119,40720,1528,3,157,1,12444.94,NULL,'2022-12-07 06:15:32','2022-12-07 12:27:05','2022-12-07 12:27:05'),(722,7938,119,40720,1528,3,220,1,720.00,NULL,'2022-12-07 06:15:32','2022-12-07 12:27:05','2022-12-07 12:27:05'),(723,7938,119,40720,1528,3,75,1,2455.03,NULL,'2022-12-07 06:15:32','2022-12-07 12:27:05','2022-12-07 12:27:05'),(724,7938,119,40720,1528,3,68,1,101529.62,NULL,'2022-12-07 06:15:32','2022-12-07 12:27:05','2022-12-07 12:27:05'),(725,7938,120,40720,1529,3,425,2,351027.30,NULL,'2022-12-07 06:17:31','2022-12-07 12:27:39','2022-12-07 12:27:39');
INSERT INTO `balance_libro_details` VALUES (726,7938,120,40720,1529,3,491,1,110000.00,NULL,'2022-12-07 06:17:31','2022-12-07 12:27:39','2022-12-07 12:27:39'),(727,7938,120,40720,1529,3,492,1,53700.00,NULL,'2022-12-07 06:17:31','2022-12-07 12:27:39','2022-12-07 12:27:39'),(728,7938,120,40720,1529,3,135,1,38328.95,NULL,'2022-12-07 06:17:31','2022-12-07 12:27:39','2022-12-07 12:27:39'),(729,7938,120,40720,1529,3,494,1,40016.96,NULL,'2022-12-07 06:17:31','2022-12-07 12:27:39','2022-12-07 12:27:39'),(730,7938,120,40720,1529,3,495,1,4752.21,NULL,'2022-12-07 06:17:31','2022-12-07 12:27:39','2022-12-07 12:27:39'),(731,7938,120,40720,1529,3,496,1,34346.72,NULL,'2022-12-07 06:17:31','2022-12-07 12:27:39','2022-12-07 12:27:39'),(732,7938,120,40720,1529,3,396,1,3000.00,NULL,'2022-12-07 06:17:31','2022-12-07 12:27:39','2022-12-07 12:27:39'),(733,7938,120,40720,1529,3,157,1,5730.68,NULL,'2022-12-07 06:17:31','2022-12-07 12:27:39','2022-12-07 12:27:39'),(734,7938,120,40720,1529,3,220,1,720.00,NULL,'2022-12-07 06:17:31','2022-12-07 12:27:39','2022-12-07 12:27:39'),(735,7938,120,40720,1529,3,75,1,298.87,NULL,'2022-12-07 06:17:31','2022-12-07 12:27:39','2022-12-07 12:27:39'),(736,7938,120,40720,1529,3,68,1,35558.91,NULL,'2022-12-07 06:17:31','2022-12-07 12:27:39','2022-12-07 12:27:39'),(737,7938,120,40720,1529,3,498,1,24574.00,NULL,'2022-12-07 06:17:31','2022-12-07 12:27:39','2022-12-07 12:27:39'),(738,7938,121,40720,1532,3,425,2,415562.19,NULL,'2022-12-07 06:18:58','2022-12-07 12:25:11','2022-12-07 12:25:11'),(739,7938,121,40720,1532,3,491,1,110000.00,NULL,'2022-12-07 06:18:58','2022-12-07 12:25:11','2022-12-07 12:25:11'),(740,7938,121,40720,1532,3,492,1,59660.00,NULL,'2022-12-07 06:18:58','2022-12-07 12:25:11','2022-12-07 12:25:11'),(741,7938,121,40720,1532,3,135,1,166475.11,NULL,'2022-12-07 06:18:58','2022-12-07 12:25:11','2022-12-07 12:25:11'),(742,7938,121,40720,1532,3,496,1,21833.17,NULL,'2022-12-07 06:18:58','2022-12-07 12:25:11','2022-12-07 12:25:11'),(743,7938,121,40720,1532,3,396,1,4500.00,NULL,'2022-12-07 06:18:58','2022-12-07 12:25:11','2022-12-07 12:25:11'),(744,7938,121,40720,1532,3,157,1,2523.82,NULL,'2022-12-07 06:18:58','2022-12-07 12:25:11','2022-12-07 12:25:11'),(745,7938,121,40720,1532,3,220,1,1080.00,NULL,'2022-12-07 06:18:58','2022-12-07 12:25:11','2022-12-07 12:25:11'),(746,7938,121,40720,1532,3,75,1,447.74,NULL,'2022-12-07 06:18:58','2022-12-07 12:25:11','2022-12-07 12:25:11'),(747,7938,121,40720,1532,3,68,1,34902.35,NULL,'2022-12-07 06:18:58','2022-12-07 12:25:11','2022-12-07 12:25:11'),(748,7938,121,40720,1532,3,498,1,14140.00,NULL,'2022-12-07 06:18:58','2022-12-07 12:25:11','2022-12-07 12:25:11'),(749,7938,122,40720,1531,3,425,2,645546.65,NULL,'2022-12-07 06:21:03','2022-12-07 06:38:45','2022-12-07 06:38:45'),(750,7938,122,40720,1531,3,491,1,323047.00,NULL,'2022-12-07 06:21:03','2022-12-07 06:38:45','2022-12-07 06:38:45'),(751,7938,122,40720,1531,3,492,1,54000.00,NULL,'2022-12-07 06:21:03','2022-12-07 06:38:45','2022-12-07 06:38:45'),(752,7938,122,40720,1531,3,135,1,78079.81,NULL,'2022-12-07 06:21:03','2022-12-07 06:38:45','2022-12-07 06:38:45'),(753,7938,122,40720,1531,3,494,1,4797.00,NULL,'2022-12-07 06:21:03','2022-12-07 06:38:45','2022-12-07 06:38:45'),(754,7938,122,40720,1531,3,496,1,60667.88,NULL,'2022-12-07 06:21:03','2022-12-07 06:38:45','2022-12-07 06:38:45'),(755,7938,122,40720,1531,3,396,1,3000.00,NULL,'2022-12-07 06:21:03','2022-12-07 06:38:45','2022-12-07 06:38:45'),(756,7938,122,40720,1531,3,157,1,12345.91,NULL,'2022-12-07 06:21:03','2022-12-07 06:38:45','2022-12-07 06:38:45'),(757,7938,122,40720,1531,3,220,1,90.00,NULL,'2022-12-07 06:21:03','2022-12-07 06:38:45','2022-12-07 06:38:45'),(758,7938,122,40720,1531,3,75,1,637.73,NULL,'2022-12-07 06:21:03','2022-12-07 06:38:45','2022-12-07 06:38:45'),(759,7938,122,40720,1531,3,68,1,87671.32,NULL,'2022-12-07 06:21:03','2022-12-07 06:38:45','2022-12-07 06:38:45'),(760,7938,122,40720,1531,3,498,1,21210.00,NULL,'2022-12-07 06:21:03','2022-12-07 06:38:45','2022-12-07 06:38:45');
INSERT INTO `balance_libro_details` VALUES (761,7938,123,40720,1530,3,425,2,313101.07,NULL,'2022-12-07 06:23:42','2022-12-07 12:28:37','2022-12-07 12:28:37'),(762,7938,123,40720,1530,3,491,1,110000.00,NULL,'2022-12-07 06:23:42','2022-12-07 12:28:37','2022-12-07 12:28:37'),(763,7938,123,40720,1530,3,492,1,53850.00,NULL,'2022-12-07 06:23:42','2022-12-07 12:28:37','2022-12-07 12:28:37'),(764,7938,123,40720,1530,3,135,1,9197.15,NULL,'2022-12-07 06:23:42','2022-12-07 12:28:37','2022-12-07 12:28:37'),(765,7938,123,40720,1530,3,494,1,15557.42,NULL,'2022-12-07 06:23:42','2022-12-07 12:28:37','2022-12-07 12:28:37'),(766,7938,123,40720,1530,3,496,1,55850.35,NULL,'2022-12-07 06:23:42','2022-12-07 12:28:37','2022-12-07 12:28:37'),(767,7938,123,40720,1530,3,396,1,3000.00,NULL,'2022-12-07 06:23:42','2022-12-07 12:28:37','2022-12-07 12:28:37'),(768,7938,123,40720,1530,3,157,1,4537.84,NULL,'2022-12-07 06:23:42','2022-12-07 12:28:37','2022-12-07 12:28:37'),(769,7938,123,40720,1530,3,220,1,720.00,NULL,'2022-12-07 06:23:42','2022-12-07 12:28:37','2022-12-07 12:28:37'),(770,7938,123,40720,1530,3,75,1,895.49,NULL,'2022-12-07 06:23:42','2022-12-07 12:28:37','2022-12-07 12:28:37'),(771,7938,123,40720,1530,3,68,1,59492.82,NULL,'2022-12-07 06:23:42','2022-12-07 12:28:37','2022-12-07 12:28:37'),(772,7938,124,40720,1518,15,67,1,53426.74,NULL,'2022-12-07 06:27:53','2022-12-07 06:27:53',NULL),(773,7938,124,40720,1518,15,353,1,27515.75,NULL,'2022-12-07 06:27:53','2022-12-07 06:27:53',NULL),(774,7938,124,40720,1518,15,354,1,42000.00,NULL,'2022-12-07 06:27:53','2022-12-07 06:27:53',NULL),(775,7938,124,40720,1518,15,68,2,80942.49,NULL,'2022-12-07 06:27:53','2022-12-07 06:27:53',NULL),(776,7938,124,40720,1518,15,25,2,42000.00,NULL,'2022-12-07 06:27:53','2022-12-07 06:27:53',NULL),(777,7938,125,40720,1519,15,67,1,95481.86,NULL,'2022-12-07 06:28:31','2022-12-07 06:28:31',NULL),(778,7938,125,40720,1519,15,354,1,75909.26,NULL,'2022-12-07 06:28:31','2022-12-07 06:28:31',NULL),(779,7938,125,40720,1519,15,68,2,30968.86,NULL,'2022-12-07 06:28:31','2022-12-07 06:28:31',NULL),(780,7938,125,40720,1519,15,25,2,75909.26,NULL,'2022-12-07 06:28:31','2022-12-07 06:28:31',NULL),(781,7938,125,40720,1519,15,353,2,27515.75,NULL,'2022-12-07 06:28:31','2022-12-07 06:28:31',NULL),(782,7938,125,40720,1519,15,354,2,36997.25,NULL,'2022-12-07 06:28:31','2022-12-07 06:28:31',NULL),(783,7938,126,40720,1520,15,67,1,95467.12,NULL,'2022-12-07 06:29:08','2022-12-07 06:29:08',NULL),(784,7938,126,40720,1520,15,354,1,75917.83,NULL,'2022-12-07 06:29:08','2022-12-07 06:29:08',NULL),(785,7938,126,40720,1520,15,68,2,35112.87,NULL,'2022-12-07 06:29:08','2022-12-07 06:29:08',NULL),(786,7938,126,40720,1520,15,25,2,75917.83,NULL,'2022-12-07 06:29:08','2022-12-07 06:29:08',NULL),(787,7938,126,40720,1520,15,354,2,60354.25,NULL,'2022-12-07 06:29:08','2022-12-07 06:29:08',NULL),(788,7938,127,40720,1521,15,67,1,95477.02,NULL,'2022-12-07 06:29:29','2022-12-07 12:00:07','2022-12-07 12:00:07'),(789,7938,127,40720,1521,15,354,1,75857.31,NULL,'2022-12-07 06:29:29','2022-12-07 12:00:07','2022-12-07 12:00:07'),(790,7938,127,40720,1521,15,20,1,57348.86,NULL,'2022-12-07 06:29:29','2022-12-07 12:00:07','2022-12-07 12:00:07'),(791,7938,127,40720,1521,15,68,2,42997.29,NULL,'2022-12-07 06:29:29','2022-12-07 12:00:07','2022-12-07 12:00:07'),(792,7938,127,40720,1521,15,25,2,75857.65,NULL,'2022-12-07 06:29:29','2022-12-07 12:00:07','2022-12-07 12:00:07'),(793,7938,127,40720,1521,15,354,2,109828.25,NULL,'2022-12-07 06:29:29','2022-12-07 12:00:07','2022-12-07 12:00:07'),(794,7938,128,40720,1525,15,67,1,95538.09,NULL,'2022-12-07 06:29:53','2022-12-07 12:03:18','2022-12-07 12:03:18'),(795,7938,128,40720,1525,15,354,1,75600.00,NULL,'2022-12-07 06:29:53','2022-12-07 12:03:18','2022-12-07 12:03:18'),(796,7938,128,40720,1525,15,20,1,24446.93,NULL,'2022-12-07 06:29:53','2022-12-07 12:03:18','2022-12-07 12:03:18'),(797,7938,128,40720,1525,15,68,2,33926.83,NULL,'2022-12-07 06:29:53','2022-12-07 12:03:18','2022-12-07 12:03:18');
INSERT INTO `balance_libro_details` VALUES (798,7938,128,40720,1525,15,25,2,75600.00,NULL,'2022-12-07 06:29:53','2022-12-07 12:03:18','2022-12-07 12:03:18'),(799,7938,128,40720,1525,15,354,2,86058.19,NULL,'2022-12-07 06:29:53','2022-12-07 12:03:18','2022-12-07 12:03:18'),(800,7938,129,40720,1526,15,67,1,222147.50,NULL,'2022-12-07 06:30:15','2022-12-07 12:02:56','2022-12-07 12:02:56'),(801,7938,129,40720,1526,15,354,1,62951.00,NULL,'2022-12-07 06:30:15','2022-12-07 12:02:56','2022-12-07 12:02:56'),(802,7938,129,40720,1526,15,20,1,13988.74,NULL,'2022-12-07 06:30:15','2022-12-07 12:02:56','2022-12-07 12:02:56'),(803,7938,129,40720,1526,15,68,2,33200.54,NULL,'2022-12-07 06:30:15','2022-12-07 12:02:56','2022-12-07 12:02:56'),(804,7938,129,40720,1526,15,25,2,178095.00,NULL,'2022-12-07 06:30:15','2022-12-07 12:02:56','2022-12-07 12:02:56'),(805,7938,129,40720,1526,15,354,2,87791.70,NULL,'2022-12-07 06:30:15','2022-12-07 12:02:56','2022-12-07 12:02:56'),(806,7938,130,40720,1527,15,67,1,95693.39,NULL,'2022-12-07 06:30:35','2022-12-07 06:30:35',NULL),(807,7938,130,40720,1527,15,354,1,53682.70,NULL,'2022-12-07 06:30:35','2022-12-07 06:30:35',NULL),(808,7938,130,40720,1527,15,68,2,10445.57,NULL,'2022-12-07 06:30:35','2022-12-07 06:30:35',NULL),(809,7938,130,40720,1527,15,25,2,75979.52,NULL,'2022-12-07 06:30:35','2022-12-07 06:30:35',NULL),(810,7938,130,40720,1527,15,354,2,62951.00,NULL,'2022-12-07 06:30:35','2022-12-07 06:30:35',NULL),(811,7938,131,40720,1528,15,67,1,260649.06,NULL,'2022-12-07 06:31:07','2022-12-07 06:31:07',NULL),(812,7938,131,40720,1528,15,354,1,102708.84,NULL,'2022-12-07 06:31:07','2022-12-07 06:31:07',NULL),(813,7938,131,40720,1528,15,68,2,101529.62,NULL,'2022-12-07 06:31:07','2022-12-07 06:31:07',NULL),(814,7938,131,40720,1528,15,25,2,208145.58,NULL,'2022-12-07 06:31:07','2022-12-07 06:31:07',NULL),(815,7938,131,40720,1528,15,354,2,53682.70,NULL,'2022-12-07 06:31:07','2022-12-07 06:31:07',NULL),(816,7938,132,40720,1529,15,67,1,95699.02,NULL,'2022-12-07 06:31:29','2022-12-07 12:01:55','2022-12-07 12:01:55'),(817,7938,132,40720,1529,15,354,1,76002.62,NULL,'2022-12-07 06:31:29','2022-12-07 12:01:55','2022-12-07 12:01:55'),(818,7938,132,40720,1529,15,20,1,19428.36,NULL,'2022-12-07 06:31:29','2022-12-07 12:01:55','2022-12-07 12:01:55'),(819,7938,132,40720,1529,15,68,2,35558.91,NULL,'2022-12-07 06:31:29','2022-12-07 12:01:55','2022-12-07 12:01:55'),(820,7938,132,40720,1529,15,25,2,76002.62,NULL,'2022-12-07 06:31:29','2022-12-07 12:01:55','2022-12-07 12:01:55'),(821,7938,132,40720,1529,15,354,2,79568.47,NULL,'2022-12-07 06:31:29','2022-12-07 12:01:55','2022-12-07 12:01:55'),(822,7938,133,40720,1530,15,67,1,95739.32,NULL,'2022-12-07 06:32:00','2022-12-07 12:01:37','2022-12-07 12:01:37'),(823,7938,133,40720,1530,15,354,1,75600.00,NULL,'2022-12-07 06:32:00','2022-12-07 12:01:37','2022-12-07 12:01:37'),(824,7938,133,40720,1530,15,20,1,24472.26,NULL,'2022-12-07 06:32:00','2022-12-07 12:01:37','2022-12-07 12:01:37'),(825,7938,133,40720,1530,15,68,2,59492.82,NULL,'2022-12-07 06:32:00','2022-12-07 12:01:37','2022-12-07 12:01:37'),(826,7938,133,40720,1530,15,25,2,75600.00,NULL,'2022-12-07 06:32:00','2022-12-07 12:01:37','2022-12-07 12:01:37'),(827,7938,133,40720,1530,15,354,2,60718.76,NULL,'2022-12-07 06:32:00','2022-12-07 12:01:37','2022-12-07 12:01:37'),(828,7938,134,40720,1531,15,67,1,269723.12,NULL,'2022-12-07 06:32:30','2022-12-07 06:32:30',NULL),(829,7938,134,40720,1531,15,354,1,147957.03,NULL,'2022-12-07 06:32:30','2022-12-07 06:32:30',NULL),(830,7938,134,40720,1531,15,68,2,87671.32,NULL,'2022-12-07 06:32:30','2022-12-07 06:32:30',NULL),(831,7938,134,40720,1531,15,25,2,215984.60,NULL,'2022-12-07 06:32:30','2022-12-07 06:32:30',NULL),(832,7938,134,40720,1531,15,354,2,114024.23,NULL,'2022-12-07 06:32:30','2022-12-07 06:32:30',NULL),(833,7938,135,40720,1532,15,67,1,97404.01,NULL,'2022-12-07 06:32:56','2022-12-07 12:00:51','2022-12-07 12:00:51'),(834,7938,135,40720,1532,15,354,1,75921.04,NULL,'2022-12-07 06:32:56','2022-12-07 12:00:51','2022-12-07 12:00:51');
INSERT INTO `balance_libro_details` VALUES (835,7938,135,40720,1532,15,20,1,21953.05,NULL,'2022-12-07 06:32:56','2022-12-07 12:00:51','2022-12-07 12:00:51'),(836,7938,135,40720,1532,15,68,2,34902.35,NULL,'2022-12-07 06:32:56','2022-12-07 12:00:51','2022-12-07 12:00:51'),(837,7938,135,40720,1532,15,25,2,75921.04,NULL,'2022-12-07 06:32:56','2022-12-07 12:00:51','2022-12-07 12:00:51'),(838,7938,135,40720,1532,15,354,2,84454.71,NULL,'2022-12-07 06:32:56','2022-12-07 12:00:51','2022-12-07 12:00:51'),(839,7938,136,40720,1531,3,425,2,661435.12,NULL,'2022-12-07 06:38:45','2022-12-07 12:30:05','2022-12-07 12:30:05'),(840,7938,136,40720,1531,3,491,1,323047.00,NULL,'2022-12-07 06:38:45','2022-12-07 12:30:05','2022-12-07 12:30:05'),(841,7938,136,40720,1531,3,492,1,54000.00,NULL,'2022-12-07 06:38:45','2022-12-07 12:30:05','2022-12-07 12:30:05'),(842,7938,136,40720,1531,3,135,1,93968.28,NULL,'2022-12-07 06:38:45','2022-12-07 12:30:05','2022-12-07 12:30:05'),(843,7938,136,40720,1531,3,494,1,4797.00,NULL,'2022-12-07 06:38:45','2022-12-07 12:30:05','2022-12-07 12:30:05'),(844,7938,136,40720,1531,3,496,1,60667.88,NULL,'2022-12-07 06:38:45','2022-12-07 12:30:05','2022-12-07 12:30:05'),(845,7938,136,40720,1531,3,396,1,3000.00,NULL,'2022-12-07 06:38:45','2022-12-07 12:30:05','2022-12-07 12:30:05'),(846,7938,136,40720,1531,3,157,1,12345.91,NULL,'2022-12-07 06:38:45','2022-12-07 12:30:05','2022-12-07 12:30:05'),(847,7938,136,40720,1531,3,220,1,90.00,NULL,'2022-12-07 06:38:45','2022-12-07 12:30:05','2022-12-07 12:30:05'),(848,7938,136,40720,1531,3,75,1,637.73,NULL,'2022-12-07 06:38:45','2022-12-07 12:30:05','2022-12-07 12:30:05'),(849,7938,136,40720,1531,3,68,1,87671.32,NULL,'2022-12-07 06:38:45','2022-12-07 12:30:05','2022-12-07 12:30:05'),(850,7938,136,40720,1531,3,498,1,21210.00,NULL,'2022-12-07 06:38:45','2022-12-07 12:30:05','2022-12-07 12:30:05'),(851,7938,137,40720,1532,16,156,1,172.08,NULL,'2022-12-07 06:39:21','2022-12-07 06:39:21',NULL),(852,7938,137,40720,1532,16,301,1,169.70,NULL,'2022-12-07 06:39:21','2022-12-07 06:39:21',NULL),(853,7938,137,40720,1532,16,301,2,341.78,NULL,'2022-12-07 06:39:21','2022-12-07 06:39:21',NULL),(854,7938,138,40720,1531,16,156,1,476.51,NULL,'2022-12-07 06:39:46','2022-12-07 06:39:46',NULL),(855,7938,138,40720,1531,16,301,1,341.78,NULL,'2022-12-07 06:39:46','2022-12-07 06:39:46',NULL),(856,7938,138,40720,1531,16,301,2,818.29,NULL,'2022-12-07 06:39:46','2022-12-07 06:39:46',NULL),(857,7938,139,40720,1530,16,156,1,169.14,NULL,'2022-12-07 06:40:06','2022-12-07 06:40:06',NULL),(858,7938,139,40720,1530,16,301,1,818.29,NULL,'2022-12-07 06:40:06','2022-12-07 06:40:06',NULL),(859,7938,139,40720,1530,16,301,2,987.43,NULL,'2022-12-07 06:40:06','2022-12-07 06:40:06',NULL),(860,7938,140,40720,1529,16,156,1,169.07,NULL,'2022-12-07 06:40:27','2022-12-07 06:40:27',NULL),(861,7938,140,40720,1529,16,301,1,987.43,NULL,'2022-12-07 06:40:27','2022-12-07 06:40:27',NULL),(862,7938,140,40720,1529,16,301,2,1156.50,NULL,'2022-12-07 06:40:27','2022-12-07 06:40:27',NULL),(863,7938,141,40720,1528,16,156,1,460.48,NULL,'2022-12-07 06:40:47','2022-12-07 06:40:47',NULL),(864,7938,141,40720,1528,16,301,1,1156.50,NULL,'2022-12-07 06:40:47','2022-12-07 06:40:47',NULL),(865,7938,141,40720,1528,16,301,2,1616.98,NULL,'2022-12-07 06:40:47','2022-12-07 06:40:47',NULL),(866,7938,142,40720,1527,16,156,1,169.06,NULL,'2022-12-07 06:41:08','2022-12-07 06:41:08',NULL),(867,7938,142,40720,1527,16,301,1,1616.98,NULL,'2022-12-07 06:41:08','2022-12-07 06:41:08',NULL),(868,7938,142,40720,1527,16,301,2,1786.04,NULL,'2022-12-07 06:41:08','2022-12-07 06:41:08',NULL),(869,7938,143,40720,1526,16,156,1,392.46,NULL,'2022-12-07 06:41:27','2022-12-07 06:41:27',NULL),(870,7938,143,40720,1526,16,301,1,1786.04,NULL,'2022-12-07 06:41:27','2022-12-07 06:41:27',NULL),(871,7938,143,40720,1526,16,301,2,2178.50,NULL,'2022-12-07 06:41:27','2022-12-07 06:41:27',NULL),(872,7938,144,40720,1521,16,156,1,192.77,NULL,'2022-12-07 06:41:49','2022-12-07 06:41:49',NULL);
INSERT INTO `balance_libro_details` VALUES (873,7938,144,40720,1521,16,301,1,2347.28,NULL,'2022-12-07 06:41:49','2022-12-07 06:41:49',NULL),(874,7938,144,40720,1521,16,301,2,2540.05,NULL,'2022-12-07 06:41:49','2022-12-07 06:41:49',NULL),(875,7938,145,40720,1520,16,156,1,192.78,NULL,'2022-12-07 06:42:31','2022-12-07 06:42:31',NULL),(876,7938,145,40720,1520,16,301,1,2540.05,NULL,'2022-12-07 06:42:31','2022-12-07 06:42:31',NULL),(877,7938,145,40720,1520,16,301,2,2732.83,NULL,'2022-12-07 06:42:31','2022-12-07 06:42:31',NULL),(878,7938,146,40720,1521,16,302,1,30035.36,NULL,'2022-12-07 06:42:59','2022-12-07 06:42:59',NULL),(879,7938,146,40720,1521,16,21,2,13500.00,NULL,'2022-12-07 06:42:59','2022-12-07 06:42:59',NULL),(880,7938,146,40720,1521,16,209,2,223.87,NULL,'2022-12-07 06:42:59','2022-12-07 06:42:59',NULL),(881,7938,146,40720,1521,16,302,2,29806.49,NULL,'2022-12-07 06:42:59','2022-12-07 06:42:59',NULL),(882,7938,146,40720,1521,16,156,1,13495.00,NULL,'2022-12-07 06:42:59','2022-12-07 06:42:59',NULL),(883,7938,147,40720,1532,16,302,1,21978.47,NULL,'2022-12-07 06:43:37','2022-12-07 06:43:37',NULL),(884,7938,147,40720,1532,16,21,2,13500.00,NULL,'2022-12-07 06:43:37','2022-12-07 06:43:37',NULL),(885,7938,147,40720,1532,16,209,2,447.74,NULL,'2022-12-07 06:43:37','2022-12-07 06:43:37',NULL),(886,7938,147,40720,1532,16,302,2,21798.09,NULL,'2022-12-07 06:43:37','2022-12-07 06:43:37',NULL),(887,7938,147,40720,1532,16,156,1,13767.36,NULL,'2022-12-07 06:43:37','2022-12-07 06:43:37',NULL),(888,7938,148,40720,1531,16,302,1,21798.09,NULL,'2022-12-07 06:44:03','2022-12-07 06:44:03',NULL),(889,7938,148,40720,1531,16,21,2,38531.87,NULL,'2022-12-07 06:44:03','2022-12-07 06:44:03',NULL),(890,7938,148,40720,1531,16,209,2,637.73,NULL,'2022-12-07 06:44:03','2022-12-07 06:44:03',NULL),(891,7938,148,40720,1531,16,302,2,20751.93,NULL,'2022-12-07 06:44:03','2022-12-07 06:44:03',NULL),(892,7938,148,40720,1531,16,156,1,38123.44,NULL,'2022-12-07 06:44:03','2022-12-07 06:44:03',NULL),(893,7938,149,40720,1530,16,302,1,20751.93,NULL,'2022-12-07 06:44:25','2022-12-07 06:44:25',NULL),(894,7938,149,40720,1530,16,302,2,34284.00,NULL,'2022-12-07 06:44:25','2022-12-07 06:44:25',NULL),(895,7938,149,40720,1530,16,156,1,13532.07,NULL,'2022-12-07 06:44:25','2022-12-07 06:44:25',NULL),(896,7938,150,40720,1529,16,302,1,34284.00,NULL,'2022-12-07 06:44:50','2022-12-07 06:44:50',NULL),(897,7938,150,40720,1529,16,21,2,13500.00,NULL,'2022-12-07 06:44:50','2022-12-07 06:44:50',NULL),(898,7938,150,40720,1529,16,209,2,298.87,NULL,'2022-12-07 06:44:50','2022-12-07 06:44:50',NULL),(899,7938,150,40720,1529,16,302,2,34011.50,NULL,'2022-12-07 06:44:50','2022-12-07 06:44:50',NULL),(900,7938,150,40720,1529,16,156,1,13526.37,NULL,'2022-12-07 06:44:50','2022-12-07 06:44:50',NULL),(901,7938,151,40720,1528,16,302,1,34011.50,NULL,'2022-12-07 06:45:18','2022-12-07 06:45:18',NULL),(902,7938,151,40720,1528,16,21,2,37081.71,NULL,'2022-12-07 06:45:18','2022-12-07 06:45:18',NULL),(903,7938,151,40720,1528,16,209,2,2455.03,NULL,'2022-12-07 06:45:18','2022-12-07 06:45:18',NULL),(904,7938,151,40720,1528,16,302,2,31315.64,NULL,'2022-12-07 06:45:18','2022-12-07 06:45:18',NULL),(905,7938,151,40720,1528,16,156,1,36840.88,NULL,'2022-12-07 06:45:18','2022-12-07 06:45:18',NULL),(906,7938,152,40720,1527,16,302,1,31315.64,NULL,'2022-12-07 06:45:39','2022-12-07 06:45:39',NULL),(907,7938,152,40720,1527,16,21,2,13500.00,NULL,'2022-12-07 06:45:39','2022-12-07 06:45:39',NULL),(908,7938,152,40720,1527,16,209,2,223.87,NULL,'2022-12-07 06:45:39','2022-12-07 06:45:39',NULL),(909,7938,152,40720,1527,16,302,2,31117.35,NULL,'2022-12-07 06:45:39','2022-12-07 06:45:39',NULL),(910,7938,152,40720,1527,16,156,1,13525.58,NULL,'2022-12-07 06:45:39','2022-12-07 06:45:39',NULL),(911,7938,153,40720,1526,16,302,1,31117.35,NULL,'2022-12-07 06:46:02','2022-12-07 06:46:02',NULL),(912,7938,153,40720,1526,16,21,2,31735.35,NULL,'2022-12-07 06:46:02','2022-12-07 06:46:02',NULL),(913,7938,153,40720,1526,16,209,2,525.36,NULL,'2022-12-07 06:46:02','2022-12-07 06:46:02',NULL);
INSERT INTO `balance_libro_details` VALUES (914,7938,153,40720,1526,16,302,2,30255.60,NULL,'2022-12-07 06:46:02','2022-12-07 06:46:02',NULL),(915,7938,153,40720,1526,16,156,1,31398.96,NULL,'2022-12-07 06:46:02','2022-12-07 06:46:02',NULL),(916,7938,154,40720,1525,16,302,1,30255.60,NULL,'2022-12-07 06:46:26','2022-12-07 06:46:26',NULL),(917,7938,154,40720,1525,16,21,2,13500.00,NULL,'2022-12-07 06:46:26','2022-12-07 06:46:26',NULL),(918,7938,154,40720,1525,16,209,2,223.87,NULL,'2022-12-07 06:46:26','2022-12-07 06:46:26',NULL),(919,7938,154,40720,1525,16,302,2,30035.36,NULL,'2022-12-07 06:46:26','2022-12-07 06:46:26',NULL),(920,7938,154,40720,1525,16,156,1,13503.63,NULL,'2022-12-07 06:46:26','2022-12-07 06:46:26',NULL),(921,7938,155,40720,1520,16,302,1,29806.49,NULL,'2022-12-07 06:46:50','2022-12-07 06:46:50',NULL),(922,7938,155,40720,1520,16,21,2,13500.00,NULL,'2022-12-07 06:46:50','2022-12-07 06:46:50',NULL),(923,7938,155,40720,1520,16,302,2,29800.09,NULL,'2022-12-07 06:46:50','2022-12-07 06:46:50',NULL),(924,7938,155,40720,1520,16,156,1,13493.60,NULL,'2022-12-07 06:46:50','2022-12-07 06:46:50',NULL),(925,7938,156,40720,1519,16,302,1,29800.09,NULL,'2022-12-07 06:47:11','2022-12-07 06:47:11',NULL),(926,7938,156,40720,1519,16,21,2,13500.00,NULL,'2022-12-07 06:47:11','2022-12-07 06:47:11',NULL),(927,7938,156,40720,1519,16,302,2,29795.77,NULL,'2022-12-07 06:47:11','2022-12-07 06:47:11',NULL),(928,7938,156,40720,1519,16,156,1,13495.68,NULL,'2022-12-07 06:47:11','2022-12-07 06:47:11',NULL),(929,7938,157,40720,1518,16,21,2,7500.00,NULL,'2022-12-07 06:47:33','2022-12-07 06:47:33',NULL),(930,7938,157,40720,1518,16,302,2,29847.26,NULL,'2022-12-07 06:47:33','2022-12-07 06:47:33',NULL),(931,7938,157,40720,1518,16,156,1,7551.49,NULL,'2022-12-07 06:47:33','2022-12-07 06:47:33',NULL),(932,7938,157,40720,1518,16,302,1,29795.77,NULL,'2022-12-07 06:47:33','2022-12-07 06:47:33',NULL),(933,7938,158,40720,1525,16,156,1,168.78,NULL,'2022-12-07 06:48:55','2022-12-07 06:48:55',NULL),(934,7938,158,40720,1525,16,301,1,2178.50,NULL,'2022-12-07 06:48:55','2022-12-07 06:48:55',NULL),(935,7938,158,40720,1525,16,301,2,2347.28,NULL,'2022-12-07 06:48:55','2022-12-07 06:48:55',NULL),(936,7938,159,40720,1518,16,156,1,107.87,NULL,'2022-12-07 06:49:21','2022-12-07 06:49:21',NULL),(937,7938,159,40720,1518,16,301,1,2925.61,NULL,'2022-12-07 06:49:21','2022-12-07 06:49:21',NULL),(938,7938,159,40720,1518,16,301,2,3033.48,NULL,'2022-12-07 06:49:21','2022-12-07 06:49:21',NULL),(939,7938,160,40720,1519,16,156,1,192.78,NULL,'2022-12-07 06:49:48','2022-12-07 06:49:48',NULL),(940,7938,160,40720,1519,16,301,1,2732.83,NULL,'2022-12-07 06:49:48','2022-12-07 06:49:48',NULL),(941,7938,160,40720,1519,16,301,2,2925.61,NULL,'2022-12-07 06:49:48','2022-12-07 06:49:48',NULL),(942,7938,161,40720,1518,18,302,1,29847.26,NULL,'2022-12-07 07:11:03','2022-12-07 07:12:47','2022-12-07 07:12:47'),(943,7938,161,40720,1518,18,301,1,3033.48,NULL,'2022-12-07 07:11:03','2022-12-07 07:12:47','2022-12-07 07:12:47'),(944,7938,161,40720,1518,18,485,2,32880.24,NULL,'2022-12-07 07:11:03','2022-12-07 07:12:47','2022-12-07 07:12:47'),(945,7938,161,40720,1518,18,136,2,0.50,NULL,'2022-12-07 07:11:03','2022-12-07 07:12:47','2022-12-07 07:12:47'),(946,7938,162,40720,1518,18,302,1,29847.26,NULL,'2022-12-07 07:12:47','2022-12-07 07:12:47',NULL),(947,7938,162,40720,1518,18,301,1,3033.48,NULL,'2022-12-07 07:12:47','2022-12-07 07:12:47',NULL),(948,7938,162,40720,1518,18,485,2,32880.24,NULL,'2022-12-07 07:12:47','2022-12-07 07:12:47',NULL),(949,7938,162,40720,1518,18,425,2,0.50,NULL,'2022-12-07 07:12:47','2022-12-07 07:12:47',NULL),(950,7938,163,40720,1518,3,425,2,320445.93,NULL,'2022-12-07 07:13:49','2022-12-07 12:29:06','2022-12-07 12:29:06'),(951,7938,163,40720,1518,3,491,1,110000.00,NULL,'2022-12-07 07:13:49','2022-12-07 12:29:06','2022-12-07 12:29:06'),(952,7938,163,40720,1518,3,492,1,45540.00,NULL,'2022-12-07 07:13:49','2022-12-07 12:29:06','2022-12-07 12:29:06');
INSERT INTO `balance_libro_details` VALUES (953,7938,163,40720,1518,3,135,1,33092.94,NULL,'2022-12-07 07:13:49','2022-12-07 12:29:06','2022-12-07 12:29:06'),(954,7938,163,40720,1518,3,494,1,18398.00,NULL,'2022-12-07 07:13:49','2022-12-07 12:29:06','2022-12-07 12:29:06'),(955,7938,163,40720,1518,3,496,1,25481.95,NULL,'2022-12-07 07:13:49','2022-12-07 12:29:06','2022-12-07 12:29:06'),(956,7938,163,40720,1518,3,396,1,2826.00,NULL,'2022-12-07 07:13:49','2022-12-07 12:29:06','2022-12-07 12:29:06'),(957,7938,163,40720,1518,3,157,1,3486.31,NULL,'2022-12-07 07:13:49','2022-12-07 12:29:06','2022-12-07 12:29:06'),(958,7938,163,40720,1518,3,220,1,678.24,NULL,'2022-12-07 07:13:49','2022-12-07 12:29:06','2022-12-07 12:29:06'),(959,7938,163,40720,1518,3,68,1,80942.49,NULL,'2022-12-07 07:13:49','2022-12-07 12:29:06','2022-12-07 12:29:06'),(960,7938,164,40720,1518,3,155,1,19701.04,NULL,'2022-12-07 07:27:49','2022-12-07 12:08:43','2022-12-07 12:08:43'),(961,7938,164,40720,1518,3,425,2,14748.02,NULL,'2022-12-07 07:27:49','2022-12-07 12:08:43','2022-12-07 12:08:43'),(962,7938,164,40720,1518,3,157,2,4953.02,NULL,'2022-12-07 07:27:49','2022-12-07 12:08:43','2022-12-07 12:08:43'),(963,7938,165,40720,1519,3,155,1,19701.04,NULL,'2022-12-07 07:28:32','2022-12-07 12:09:03','2022-12-07 12:09:03'),(964,7938,165,40720,1519,3,425,2,19701.04,NULL,'2022-12-07 07:28:32','2022-12-07 12:09:03','2022-12-07 12:09:03'),(965,7938,166,40720,1520,3,155,1,19701.04,NULL,'2022-12-07 07:29:24','2022-12-07 12:09:23','2022-12-07 12:09:23'),(966,7938,166,40720,1520,3,425,2,13837.85,NULL,'2022-12-07 07:29:24','2022-12-07 12:09:23','2022-12-07 12:09:23'),(967,7938,166,40720,1520,3,157,2,5863.19,NULL,'2022-12-07 07:29:24','2022-12-07 12:09:23','2022-12-07 12:09:23'),(968,7938,167,40720,1526,3,155,1,73446.16,NULL,'2022-12-07 07:31:18','2022-12-07 12:08:03','2022-12-07 12:08:03'),(969,7938,167,40720,1526,3,157,2,13052.07,NULL,'2022-12-07 07:31:18','2022-12-07 12:08:03','2022-12-07 12:08:03'),(970,7938,167,40720,1526,3,354,2,38435.67,NULL,'2022-12-07 07:31:18','2022-12-07 12:08:03','2022-12-07 12:08:03'),(971,7938,167,40720,1526,3,79,2,21958.42,NULL,'2022-12-07 07:31:18','2022-12-07 12:08:03','2022-12-07 12:08:03'),(972,7938,168,40720,1527,3,155,1,24472.26,NULL,'2022-12-07 07:32:13','2022-12-07 11:25:38','2022-12-07 11:25:38'),(973,7938,168,40720,1527,3,157,2,12920.41,NULL,'2022-12-07 07:32:13','2022-12-07 11:25:38','2022-12-07 11:25:38'),(974,7938,168,40720,1527,3,354,2,11551.85,NULL,'2022-12-07 07:32:13','2022-12-07 11:25:38','2022-12-07 11:25:38'),(975,7938,169,40720,1528,3,155,1,24472.26,NULL,'2022-12-07 07:33:25','2022-12-07 12:08:24','2022-12-07 12:08:24'),(976,7938,169,40720,1528,3,79,1,33510.27,NULL,'2022-12-07 07:33:25','2022-12-07 12:08:24','2022-12-07 12:08:24'),(977,7938,169,40720,1528,3,141,1,2136.44,NULL,'2022-12-07 07:33:25','2022-12-07 12:08:24','2022-12-07 12:08:24'),(978,7938,169,40720,1528,3,425,2,56729.00,NULL,'2022-12-07 07:33:25','2022-12-07 12:08:24','2022-12-07 12:08:24'),(979,7938,169,40720,1528,3,157,2,3389.97,NULL,'2022-12-07 07:33:25','2022-12-07 12:08:24','2022-12-07 12:08:24'),(980,7938,170,40720,1529,3,155,1,24472.26,NULL,'2022-12-07 07:34:30','2022-12-07 12:07:42','2022-12-07 12:07:42'),(981,7938,170,40720,1529,3,141,1,44.74,NULL,'2022-12-07 07:34:30','2022-12-07 12:07:42','2022-12-07 12:07:42'),(982,7938,170,40720,1529,3,425,2,12072.06,NULL,'2022-12-07 07:34:30','2022-12-07 12:07:42','2022-12-07 12:07:42'),(983,7938,170,40720,1529,3,157,2,12444.94,NULL,'2022-12-07 07:34:30','2022-12-07 12:07:42','2022-12-07 12:07:42'),(984,7938,171,40720,1530,3,155,1,24472.26,NULL,'2022-12-07 07:35:32','2022-12-07 12:09:43','2022-12-07 12:09:43'),(985,7938,171,40720,1530,3,141,1,686.78,NULL,'2022-12-07 07:35:32','2022-12-07 12:09:43','2022-12-07 12:09:43'),(986,7938,171,40720,1530,3,157,2,5730.68,NULL,'2022-12-07 07:35:32','2022-12-07 12:09:43','2022-12-07 12:09:43'),(987,7938,171,40720,1530,3,354,2,19428.36,NULL,'2022-12-07 07:35:32','2022-12-07 12:09:43','2022-12-07 12:09:43');
INSERT INTO `balance_libro_details` VALUES (988,7938,172,40720,1531,3,155,1,24472.26,NULL,'2022-12-07 07:36:16','2022-12-07 07:39:12','2022-12-07 07:39:12'),(989,7938,172,40720,1531,3,79,2,24472.26,NULL,'2022-12-07 07:36:16','2022-12-07 07:39:12','2022-12-07 07:39:12'),(990,7938,173,40720,1532,3,155,1,24472.26,NULL,'2022-12-07 07:37:14','2022-12-07 12:06:37','2022-12-07 12:06:37'),(991,7938,173,40720,1532,3,425,2,7588.51,NULL,'2022-12-07 07:37:14','2022-12-07 12:06:37','2022-12-07 12:06:37'),(992,7938,173,40720,1532,3,157,2,16883.75,NULL,'2022-12-07 07:37:14','2022-12-07 12:06:37','2022-12-07 12:06:37'),(993,7938,174,40720,1531,3,155,1,24472.26,NULL,'2022-12-07 07:39:12','2022-12-07 12:07:22','2022-12-07 12:07:22'),(994,7938,174,40720,1531,3,353,2,24472.26,NULL,'2022-12-07 07:39:12','2022-12-07 12:07:22','2022-12-07 12:07:22'),(995,7938,175,40720,1525,10,155,1,356632.47,NULL,'2022-12-07 07:48:52','2022-12-07 07:48:52',NULL),(996,7938,175,40720,1525,10,20,2,187901.51,NULL,'2022-12-07 07:48:52','2022-12-07 07:48:52',NULL),(997,7938,175,40720,1525,10,23,2,62847.83,NULL,'2022-12-07 07:48:52','2022-12-07 07:48:52',NULL),(998,7938,175,40720,1525,10,354,2,57348.52,NULL,'2022-12-07 07:48:52','2022-12-07 07:48:52',NULL),(999,7938,175,40720,1525,10,157,2,48534.61,NULL,'2022-12-07 07:48:52','2022-12-07 07:48:52',NULL),(1000,7938,176,40720,1526,19,383,1,830335.12,NULL,'2022-12-07 08:02:24','2022-12-07 08:04:54','2022-12-07 08:04:54'),(1001,7938,176,40720,1526,19,425,2,653002.12,NULL,'2022-12-07 08:02:24','2022-12-07 08:04:54','2022-12-07 08:04:54'),(1002,7938,176,40720,1526,19,384,2,177333.00,NULL,'2022-12-07 08:02:24','2022-12-07 08:04:54','2022-12-07 08:04:54'),(1003,7938,177,40720,1526,19,383,1,1130125.41,NULL,'2022-12-07 08:04:55','2022-12-07 13:34:01','2022-12-07 13:34:01'),(1004,7938,177,40720,1526,19,425,2,653002.12,NULL,'2022-12-07 08:04:55','2022-12-07 13:34:01','2022-12-07 13:34:01'),(1005,7938,177,40720,1526,19,384,2,477123.29,NULL,'2022-12-07 08:04:55','2022-12-07 13:34:01','2022-12-07 13:34:01'),(1006,7938,178,40720,1518,2,482,2,160000.00,NULL,'2022-12-07 08:17:52','2022-12-07 08:17:52',NULL),(1007,7938,178,40720,1518,2,425,1,160000.00,NULL,'2022-12-07 08:17:52','2022-12-07 08:17:52',NULL),(1008,7938,179,40720,1528,3,482,1,150000.00,NULL,'2022-12-07 08:23:39','2022-12-07 08:23:39',NULL),(1009,7938,179,40720,1528,3,425,2,150000.00,NULL,'2022-12-07 08:23:39','2022-12-07 08:23:39',NULL),(1010,7938,180,40720,1520,3,425,2,244182.43,NULL,'2022-12-07 08:32:46','2022-12-07 12:23:05','2022-12-07 12:23:05'),(1011,7938,180,40720,1520,3,491,1,110000.00,NULL,'2022-12-07 08:32:46','2022-12-07 12:23:05','2022-12-07 12:23:05'),(1012,7938,180,40720,1520,3,492,1,45600.00,NULL,'2022-12-07 08:32:46','2022-12-07 12:23:05','2022-12-07 12:23:05'),(1013,7938,180,40720,1520,3,135,1,3341.69,NULL,'2022-12-07 08:32:46','2022-12-07 12:23:05','2022-12-07 12:23:05'),(1014,7938,180,40720,1520,3,493,1,2766.92,NULL,'2022-12-07 08:32:46','2022-12-07 12:23:05','2022-12-07 12:23:05'),(1015,7938,180,40720,1520,3,494,1,5656.96,NULL,'2022-12-07 08:32:46','2022-12-07 12:23:05','2022-12-07 12:23:05'),(1016,7938,180,40720,1520,3,496,1,25999.55,NULL,'2022-12-07 08:32:46','2022-12-07 12:23:05','2022-12-07 12:23:05'),(1017,7938,180,40720,1520,3,188,1,7200.00,NULL,'2022-12-07 08:32:46','2022-12-07 12:23:05','2022-12-07 12:23:05'),(1018,7938,180,40720,1520,3,396,1,2826.00,NULL,'2022-12-07 08:32:46','2022-12-07 12:23:05','2022-12-07 12:23:05'),(1019,7938,180,40720,1520,3,157,1,5000.20,NULL,'2022-12-07 08:32:46','2022-12-07 12:23:05','2022-12-07 12:23:05'),(1020,7938,180,40720,1520,3,220,1,678.24,NULL,'2022-12-07 08:32:46','2022-12-07 12:23:05','2022-12-07 12:23:05'),(1021,7938,180,40720,1520,3,68,1,35112.87,NULL,'2022-12-07 08:32:46','2022-12-07 12:23:05','2022-12-07 12:23:05'),(1022,7938,181,40720,1521,3,425,2,324999.80,NULL,'2022-12-07 08:37:31','2022-12-07 08:41:48','2022-12-07 08:41:48'),(1023,7938,181,40720,1521,3,491,1,110000.00,NULL,'2022-12-07 08:37:31','2022-12-07 08:41:48','2022-12-07 08:41:48');
INSERT INTO `balance_libro_details` VALUES (1024,7938,181,40720,1521,3,492,1,45640.00,NULL,'2022-12-07 08:37:31','2022-12-07 08:41:48','2022-12-07 08:41:48'),(1025,7938,181,40720,1521,3,135,1,20457.43,NULL,'2022-12-07 08:37:31','2022-12-07 08:41:48','2022-12-07 08:41:48'),(1026,7938,181,40720,1521,3,494,1,46937.12,NULL,'2022-12-07 08:37:31','2022-12-07 08:41:48','2022-12-07 08:41:48'),(1027,7938,181,40720,1521,3,496,1,32134.00,NULL,'2022-12-07 08:37:31','2022-12-07 08:41:48','2022-12-07 08:41:48'),(1028,7938,181,40720,1521,3,188,1,2000.00,NULL,'2022-12-07 08:37:31','2022-12-07 08:41:48','2022-12-07 08:41:48'),(1029,7938,181,40720,1521,3,396,1,2826.00,NULL,'2022-12-07 08:37:31','2022-12-07 08:41:48','2022-12-07 08:41:48'),(1030,7938,181,40720,1521,3,157,1,4605.85,NULL,'2022-12-07 08:37:31','2022-12-07 08:41:48','2022-12-07 08:41:48'),(1031,7938,181,40720,1521,3,220,1,678.24,NULL,'2022-12-07 08:37:31','2022-12-07 08:41:48','2022-12-07 08:41:48'),(1032,7938,181,40720,1521,3,75,1,223.87,NULL,'2022-12-07 08:37:31','2022-12-07 08:41:48','2022-12-07 08:41:48'),(1033,7938,181,40720,1521,3,68,1,42997.29,NULL,'2022-12-07 08:37:31','2022-12-07 08:41:48','2022-12-07 08:41:48'),(1034,7938,181,40720,1521,3,498,1,16500.00,NULL,'2022-12-07 08:37:31','2022-12-07 08:41:48','2022-12-07 08:41:48'),(1035,7938,182,40720,1521,3,425,2,324984.81,NULL,'2022-12-07 08:41:48','2022-12-07 08:45:19','2022-12-07 08:45:19'),(1036,7938,182,40720,1521,3,491,1,110000.00,NULL,'2022-12-07 08:41:48','2022-12-07 08:45:19','2022-12-07 08:45:19'),(1037,7938,182,40720,1521,3,492,1,45640.00,NULL,'2022-12-07 08:41:48','2022-12-07 08:45:19','2022-12-07 08:45:19'),(1038,7938,182,40720,1521,3,135,1,20442.44,NULL,'2022-12-07 08:41:48','2022-12-07 08:45:19','2022-12-07 08:45:19'),(1039,7938,182,40720,1521,3,494,1,46937.12,NULL,'2022-12-07 08:41:48','2022-12-07 08:45:19','2022-12-07 08:45:19'),(1040,7938,182,40720,1521,3,496,1,32134.00,NULL,'2022-12-07 08:41:48','2022-12-07 08:45:19','2022-12-07 08:45:19'),(1041,7938,182,40720,1521,3,188,1,2000.00,NULL,'2022-12-07 08:41:48','2022-12-07 08:45:19','2022-12-07 08:45:19'),(1042,7938,182,40720,1521,3,396,1,2826.00,NULL,'2022-12-07 08:41:48','2022-12-07 08:45:19','2022-12-07 08:45:19'),(1043,7938,182,40720,1521,3,157,1,4605.85,NULL,'2022-12-07 08:41:48','2022-12-07 08:45:19','2022-12-07 08:45:19'),(1044,7938,182,40720,1521,3,220,1,678.24,NULL,'2022-12-07 08:41:48','2022-12-07 08:45:19','2022-12-07 08:45:19'),(1045,7938,182,40720,1521,3,75,1,223.87,NULL,'2022-12-07 08:41:48','2022-12-07 08:45:19','2022-12-07 08:45:19'),(1046,7938,182,40720,1521,3,68,1,42997.29,NULL,'2022-12-07 08:41:48','2022-12-07 08:45:19','2022-12-07 08:45:19'),(1047,7938,182,40720,1521,3,498,1,16500.00,NULL,'2022-12-07 08:41:48','2022-12-07 08:45:19','2022-12-07 08:45:19'),(1048,7938,183,40720,1521,3,425,2,325005.80,NULL,'2022-12-07 08:45:19','2022-12-07 12:22:28','2022-12-07 12:22:28'),(1049,7938,183,40720,1521,3,491,1,110000.00,NULL,'2022-12-07 08:45:19','2022-12-07 12:22:28','2022-12-07 12:22:28'),(1050,7938,183,40720,1521,3,492,1,45640.00,NULL,'2022-12-07 08:45:19','2022-12-07 12:22:28','2022-12-07 12:22:28'),(1051,7938,183,40720,1521,3,135,1,20463.43,NULL,'2022-12-07 08:45:19','2022-12-07 12:22:28','2022-12-07 12:22:28'),(1052,7938,183,40720,1521,3,494,1,46937.12,NULL,'2022-12-07 08:45:19','2022-12-07 12:22:28','2022-12-07 12:22:28'),(1053,7938,183,40720,1521,3,496,1,32134.00,NULL,'2022-12-07 08:45:19','2022-12-07 12:22:28','2022-12-07 12:22:28'),(1054,7938,183,40720,1521,3,188,1,2000.00,NULL,'2022-12-07 08:45:19','2022-12-07 12:22:28','2022-12-07 12:22:28'),(1055,7938,183,40720,1521,3,396,1,2826.00,NULL,'2022-12-07 08:45:19','2022-12-07 12:22:28','2022-12-07 12:22:28'),(1056,7938,183,40720,1521,3,157,1,4605.85,NULL,'2022-12-07 08:45:19','2022-12-07 12:22:28','2022-12-07 12:22:28'),(1057,7938,183,40720,1521,3,220,1,678.24,NULL,'2022-12-07 08:45:19','2022-12-07 12:22:28','2022-12-07 12:22:28'),(1058,7938,183,40720,1521,3,75,1,223.87,NULL,'2022-12-07 08:45:19','2022-12-07 12:22:28','2022-12-07 12:22:28');
INSERT INTO `balance_libro_details` VALUES (1059,7938,183,40720,1521,3,68,1,42997.29,NULL,'2022-12-07 08:45:19','2022-12-07 12:22:28','2022-12-07 12:22:28'),(1060,7938,183,40720,1521,3,498,1,16500.00,NULL,'2022-12-07 08:45:19','2022-12-07 12:22:28','2022-12-07 12:22:28'),(1061,7938,184,40720,1529,2,386,1,1600000.00,NULL,'2022-12-07 10:38:15','2022-12-07 10:39:27','2022-12-07 10:39:27'),(1062,7938,184,40720,1529,2,425,1,1102860.28,NULL,'2022-12-07 10:38:15','2022-12-07 10:39:27','2022-12-07 10:39:27'),(1063,7938,184,40720,1529,2,386,2,1102860.28,NULL,'2022-12-07 10:38:15','2022-12-07 10:39:27','2022-12-07 10:39:27'),(1064,7938,184,40720,1529,2,425,2,1600000.00,NULL,'2022-12-07 10:38:15','2022-12-07 10:39:27','2022-12-07 10:39:27'),(1065,7938,184,40720,1529,2,386,1,68671.10,NULL,'2022-12-07 10:38:15','2022-12-07 10:39:27','2022-12-07 10:39:27'),(1066,7938,184,40720,1529,2,135,2,68671.10,NULL,'2022-12-07 10:38:15','2022-12-07 10:39:27','2022-12-07 10:39:27'),(1067,7938,185,40720,1529,2,386,1,1600000.00,NULL,'2022-12-07 10:39:27','2022-12-07 10:43:48','2022-12-07 10:43:48'),(1068,7938,185,40720,1529,2,425,1,1102860.28,NULL,'2022-12-07 10:39:27','2022-12-07 10:43:48','2022-12-07 10:43:48'),(1069,7938,185,40720,1529,2,386,2,1102860.28,NULL,'2022-12-07 10:39:27','2022-12-07 10:43:48','2022-12-07 10:43:48'),(1070,7938,185,40720,1529,2,425,2,1600000.00,NULL,'2022-12-07 10:39:27','2022-12-07 10:43:48','2022-12-07 10:43:48'),(1071,7938,185,40720,1529,2,425,2,68671.10,NULL,'2022-12-07 10:39:27','2022-12-07 10:43:48','2022-12-07 10:43:48'),(1072,7938,185,40720,1529,2,135,1,68671.10,NULL,'2022-12-07 10:39:27','2022-12-07 10:43:48','2022-12-07 10:43:48'),(1073,7938,186,40720,1529,2,386,1,1600000.00,NULL,'2022-12-07 10:43:48','2022-12-07 11:01:50','2022-12-07 11:01:50'),(1074,7938,186,40720,1529,2,425,1,1034189.18,NULL,'2022-12-07 10:43:48','2022-12-07 11:01:50','2022-12-07 11:01:50'),(1075,7938,186,40720,1529,2,386,2,1034189.18,NULL,'2022-12-07 10:43:48','2022-12-07 11:01:50','2022-12-07 11:01:50'),(1076,7938,186,40720,1529,2,425,2,1600000.00,NULL,'2022-12-07 10:43:48','2022-12-07 11:01:50','2022-12-07 11:01:50'),(1077,7938,186,40720,1529,2,386,1,68671.10,NULL,'2022-12-07 10:43:48','2022-12-07 11:01:50','2022-12-07 11:01:50'),(1078,7938,186,40720,1529,2,477,2,68671.10,NULL,'2022-12-07 10:43:48','2022-12-07 11:01:50','2022-12-07 11:01:50'),(1079,7938,187,40720,1529,2,386,1,497139.75,NULL,'2022-12-07 11:01:50','2022-12-07 11:01:50',NULL),(1080,7938,187,40720,1529,2,425,2,415811.30,NULL,'2022-12-07 11:01:50','2022-12-07 11:01:50',NULL),(1081,7938,187,40720,1529,2,477,2,81328.45,NULL,'2022-12-07 11:01:50','2022-12-07 11:01:50',NULL),(1082,7938,188,40720,1531,2,386,1,864352.72,NULL,'2022-12-07 11:13:19','2022-12-07 11:38:45','2022-12-07 11:38:45'),(1083,7938,188,40720,1531,2,425,2,614028.88,NULL,'2022-12-07 11:13:19','2022-12-07 11:38:45','2022-12-07 11:38:45'),(1084,7938,188,40720,1531,2,477,2,250323.84,NULL,'2022-12-07 11:13:19','2022-12-07 11:38:45','2022-12-07 11:38:45'),(1085,7938,189,40720,1532,11,425,1,250619.67,NULL,'2022-12-07 11:18:10','2022-12-07 11:19:44','2022-12-07 11:19:44'),(1086,7938,189,40720,1532,11,477,2,250619.67,NULL,'2022-12-07 11:18:10','2022-12-07 11:19:44','2022-12-07 11:19:44'),(1087,7938,190,40720,1532,11,425,2,250619.67,NULL,'2022-12-07 11:19:44','2022-12-07 11:19:44',NULL),(1088,7938,190,40720,1532,11,477,1,250619.67,NULL,'2022-12-07 11:19:44','2022-12-07 11:19:44',NULL),(1089,7938,191,40720,1527,3,155,1,24472.26,NULL,'2022-12-07 11:25:38','2022-12-07 12:07:01','2022-12-07 12:07:01'),(1090,7938,191,40720,1527,3,157,2,12920.41,NULL,'2022-12-07 11:25:38','2022-12-07 12:07:01','2022-12-07 12:07:01'),(1091,7938,191,40720,1527,3,79,2,11551.85,NULL,'2022-12-07 11:25:38','2022-12-07 12:07:01','2022-12-07 12:07:01'),(1092,7938,192,40720,1531,2,386,1,858276.45,NULL,'2022-12-07 11:38:45','2022-12-07 11:38:45',NULL),(1093,7938,192,40720,1531,2,425,2,614028.88,NULL,'2022-12-07 11:38:45','2022-12-07 11:38:45',NULL);
INSERT INTO `balance_libro_details` VALUES (1094,7938,192,40720,1531,2,477,2,244247.57,NULL,'2022-12-07 11:38:45','2022-12-07 11:38:45',NULL),(1095,7938,193,40720,1532,2,386,1,206139.16,NULL,'2022-12-07 11:40:30','2022-12-07 11:40:30',NULL),(1096,7938,193,40720,1532,2,23,1,6359.49,NULL,'2022-12-07 11:40:30','2022-12-07 11:40:30',NULL),(1097,7938,193,40720,1532,2,102,2,212498.65,NULL,'2022-12-07 11:40:30','2022-12-07 11:40:30',NULL),(1098,7938,194,40720,1520,2,425,1,447743.40,NULL,'2022-12-07 11:49:45','2022-12-07 11:51:49','2022-12-07 11:51:49'),(1099,7938,194,40720,1520,2,25,1,75600.00,NULL,'2022-12-07 11:49:45','2022-12-07 11:51:49','2022-12-07 11:51:49'),(1100,7938,194,40720,1520,2,23,1,7656.60,NULL,'2022-12-07 11:49:45','2022-12-07 11:51:49','2022-12-07 11:51:49'),(1101,7938,194,40720,1520,2,97,2,450000.00,NULL,'2022-12-07 11:49:45','2022-12-07 11:51:49','2022-12-07 11:51:49'),(1102,7938,194,40720,1520,2,67,2,94500.00,NULL,'2022-12-07 11:49:45','2022-12-07 11:51:49','2022-12-07 11:51:49'),(1103,7938,194,40720,1520,2,21,1,13500.00,NULL,'2022-12-07 11:49:45','2022-12-07 11:51:49','2022-12-07 11:51:49'),(1104,7938,195,40720,1518,2,425,1,249343.40,NULL,'2022-12-07 11:50:16','2022-12-07 12:33:45','2022-12-07 12:33:45'),(1105,7938,195,40720,1518,2,25,1,42000.00,NULL,'2022-12-07 11:50:16','2022-12-07 12:33:45','2022-12-07 12:33:45'),(1106,7938,195,40720,1518,2,23,1,3656.60,NULL,'2022-12-07 11:50:16','2022-12-07 12:33:45','2022-12-07 12:33:45'),(1107,7938,195,40720,1518,2,97,2,250000.00,NULL,'2022-12-07 11:50:16','2022-12-07 12:33:45','2022-12-07 12:33:45'),(1108,7938,195,40720,1518,2,67,2,52500.00,NULL,'2022-12-07 11:50:16','2022-12-07 12:33:45','2022-12-07 12:33:45'),(1109,7938,195,40720,1518,2,21,1,7500.00,NULL,'2022-12-07 11:50:16','2022-12-07 12:33:45','2022-12-07 12:33:45'),(1110,7938,196,40720,1520,2,425,1,447743.40,NULL,'2022-12-07 11:51:49','2022-12-07 11:51:49',NULL),(1111,7938,196,40720,1520,2,25,1,75600.00,NULL,'2022-12-07 11:51:49','2022-12-07 11:51:49',NULL),(1112,7938,196,40720,1520,2,23,1,7656.60,NULL,'2022-12-07 11:51:49','2022-12-07 11:51:49',NULL),(1113,7938,196,40720,1520,2,97,2,450000.00,NULL,'2022-12-07 11:51:49','2022-12-07 11:51:49',NULL),(1114,7938,196,40720,1520,2,67,2,94500.00,NULL,'2022-12-07 11:51:49','2022-12-07 11:51:49',NULL),(1115,7938,196,40720,1520,2,21,1,13500.00,NULL,'2022-12-07 11:51:49','2022-12-07 11:51:49',NULL),(1116,7938,197,40720,1519,2,425,1,447743.40,NULL,'2022-12-07 11:52:28','2022-12-07 11:52:28',NULL),(1117,7938,197,40720,1519,2,25,1,75600.00,NULL,'2022-12-07 11:52:28','2022-12-07 11:52:28',NULL),(1118,7938,197,40720,1519,2,23,1,7656.60,NULL,'2022-12-07 11:52:28','2022-12-07 11:52:28',NULL),(1119,7938,197,40720,1519,2,97,2,450000.00,NULL,'2022-12-07 11:52:28','2022-12-07 11:52:28',NULL),(1120,7938,197,40720,1519,2,67,2,94500.00,NULL,'2022-12-07 11:52:28','2022-12-07 11:52:28',NULL),(1121,7938,197,40720,1519,2,21,1,13500.00,NULL,'2022-12-07 11:52:28','2022-12-07 11:52:28',NULL),(1122,7938,198,40720,1521,15,67,1,95477.02,NULL,'2022-12-07 12:00:07','2022-12-07 13:03:14','2022-12-07 13:03:14'),(1123,7938,198,40720,1521,15,354,1,133206.17,NULL,'2022-12-07 12:00:07','2022-12-07 13:03:14','2022-12-07 13:03:14'),(1124,7938,198,40720,1521,15,68,2,42997.29,NULL,'2022-12-07 12:00:07','2022-12-07 13:03:14','2022-12-07 13:03:14'),(1125,7938,198,40720,1521,15,25,2,75857.65,NULL,'2022-12-07 12:00:07','2022-12-07 13:03:14','2022-12-07 13:03:14'),(1126,7938,198,40720,1521,15,354,2,109828.25,NULL,'2022-12-07 12:00:07','2022-12-07 13:03:14','2022-12-07 13:03:14'),(1127,7938,199,40720,1532,15,67,1,97404.01,NULL,'2022-12-07 12:00:51','2022-12-07 12:00:51',NULL),(1128,7938,199,40720,1532,15,354,1,97874.09,NULL,'2022-12-07 12:00:51','2022-12-07 12:00:51',NULL),(1129,7938,199,40720,1532,15,68,2,34902.35,NULL,'2022-12-07 12:00:51','2022-12-07 12:00:51',NULL),(1130,7938,199,40720,1532,15,25,2,75921.04,NULL,'2022-12-07 12:00:51','2022-12-07 12:00:51',NULL),(1131,7938,199,40720,1532,15,354,2,84454.71,NULL,'2022-12-07 12:00:51','2022-12-07 12:00:51',NULL);
INSERT INTO `balance_libro_details` VALUES (1132,7938,200,40720,1530,15,67,1,95739.32,NULL,'2022-12-07 12:01:37','2022-12-07 13:06:37','2022-12-07 13:06:37'),(1133,7938,200,40720,1530,15,354,1,100072.26,NULL,'2022-12-07 12:01:37','2022-12-07 13:06:37','2022-12-07 13:06:37'),(1134,7938,200,40720,1530,15,68,2,59492.82,NULL,'2022-12-07 12:01:37','2022-12-07 13:06:37','2022-12-07 13:06:37'),(1135,7938,200,40720,1530,15,25,2,75600.00,NULL,'2022-12-07 12:01:37','2022-12-07 13:06:37','2022-12-07 13:06:37'),(1136,7938,200,40720,1530,15,354,2,60718.76,NULL,'2022-12-07 12:01:37','2022-12-07 13:06:37','2022-12-07 13:06:37'),(1137,7938,201,40720,1529,15,67,1,95699.02,NULL,'2022-12-07 12:01:55','2022-12-07 12:01:55',NULL),(1138,7938,201,40720,1529,15,354,1,95430.98,NULL,'2022-12-07 12:01:55','2022-12-07 12:01:55',NULL),(1139,7938,201,40720,1529,15,68,2,35558.91,NULL,'2022-12-07 12:01:55','2022-12-07 12:01:55',NULL),(1140,7938,201,40720,1529,15,25,2,76002.62,NULL,'2022-12-07 12:01:55','2022-12-07 12:01:55',NULL),(1141,7938,201,40720,1529,15,354,2,79568.47,NULL,'2022-12-07 12:01:55','2022-12-07 12:01:55',NULL),(1142,7938,202,40720,1526,15,67,1,222147.50,NULL,'2022-12-07 12:02:56','2022-12-07 13:05:20','2022-12-07 13:05:20'),(1143,7938,202,40720,1526,15,354,1,76939.74,NULL,'2022-12-07 12:02:56','2022-12-07 13:05:20','2022-12-07 13:05:20'),(1144,7938,202,40720,1526,15,68,2,33200.54,NULL,'2022-12-07 12:02:56','2022-12-07 13:05:20','2022-12-07 13:05:20'),(1145,7938,202,40720,1526,15,25,2,178095.00,NULL,'2022-12-07 12:02:56','2022-12-07 13:05:20','2022-12-07 13:05:20'),(1146,7938,202,40720,1526,15,354,2,87791.70,NULL,'2022-12-07 12:02:56','2022-12-07 13:05:20','2022-12-07 13:05:20'),(1147,7938,203,40720,1525,15,67,1,95538.09,NULL,'2022-12-07 12:03:18','2022-12-07 12:03:18',NULL),(1148,7938,203,40720,1525,15,354,1,100046.93,NULL,'2022-12-07 12:03:18','2022-12-07 12:03:18',NULL),(1149,7938,203,40720,1525,15,68,2,33926.83,NULL,'2022-12-07 12:03:18','2022-12-07 12:03:18',NULL),(1150,7938,203,40720,1525,15,25,2,75600.00,NULL,'2022-12-07 12:03:18','2022-12-07 12:03:18',NULL),(1151,7938,203,40720,1525,15,354,2,86058.19,NULL,'2022-12-07 12:03:18','2022-12-07 12:03:18',NULL),(1152,7938,204,40720,1532,3,425,2,7588.51,NULL,'2022-12-07 12:06:37','2022-12-07 12:06:37',NULL),(1153,7938,204,40720,1532,3,157,2,16883.75,NULL,'2022-12-07 12:06:37','2022-12-07 12:06:37',NULL),(1154,7938,204,40720,1532,3,20,1,24472.26,NULL,'2022-12-07 12:06:37','2022-12-07 12:06:37',NULL),(1155,7938,205,40720,1527,3,157,2,12920.41,NULL,'2022-12-07 12:07:01','2022-12-07 12:07:01',NULL),(1156,7938,205,40720,1527,3,79,2,11551.85,NULL,'2022-12-07 12:07:01','2022-12-07 12:07:01',NULL),(1157,7938,205,40720,1527,3,20,1,24472.26,NULL,'2022-12-07 12:07:01','2022-12-07 12:07:01',NULL),(1158,7938,206,40720,1531,3,353,2,24472.26,NULL,'2022-12-07 12:07:22','2022-12-07 12:40:09','2022-12-07 12:40:09'),(1159,7938,206,40720,1531,3,20,1,24472.26,NULL,'2022-12-07 12:07:22','2022-12-07 12:40:09','2022-12-07 12:40:09'),(1160,7938,207,40720,1529,3,141,1,44.74,NULL,'2022-12-07 12:07:42','2022-12-07 12:07:42',NULL),(1161,7938,207,40720,1529,3,425,2,12072.06,NULL,'2022-12-07 12:07:42','2022-12-07 12:07:42',NULL),(1162,7938,207,40720,1529,3,157,2,12444.94,NULL,'2022-12-07 12:07:42','2022-12-07 12:07:42',NULL),(1163,7938,207,40720,1529,3,20,1,24472.26,NULL,'2022-12-07 12:07:42','2022-12-07 12:07:42',NULL),(1164,7938,208,40720,1526,3,157,2,13052.07,NULL,'2022-12-07 12:08:03','2022-12-07 12:08:03',NULL),(1165,7938,208,40720,1526,3,354,2,38435.67,NULL,'2022-12-07 12:08:03','2022-12-07 12:08:03',NULL),(1166,7938,208,40720,1526,3,79,2,21958.42,NULL,'2022-12-07 12:08:03','2022-12-07 12:08:03',NULL),(1167,7938,208,40720,1526,3,20,1,73446.16,NULL,'2022-12-07 12:08:03','2022-12-07 12:08:03',NULL),(1168,7938,209,40720,1528,3,79,1,33510.27,NULL,'2022-12-07 12:08:24','2022-12-07 12:08:24',NULL),(1169,7938,209,40720,1528,3,141,1,2136.44,NULL,'2022-12-07 12:08:24','2022-12-07 12:08:24',NULL);
INSERT INTO `balance_libro_details` VALUES (1170,7938,209,40720,1528,3,425,2,56729.00,NULL,'2022-12-07 12:08:24','2022-12-07 12:08:24',NULL),(1171,7938,209,40720,1528,3,157,2,3389.97,NULL,'2022-12-07 12:08:24','2022-12-07 12:08:24',NULL),(1172,7938,209,40720,1528,3,20,1,24472.26,NULL,'2022-12-07 12:08:24','2022-12-07 12:08:24',NULL),(1173,7938,210,40720,1518,3,425,2,14748.02,NULL,'2022-12-07 12:08:43','2022-12-07 12:08:43',NULL),(1174,7938,210,40720,1518,3,157,2,4953.02,NULL,'2022-12-07 12:08:43','2022-12-07 12:08:43',NULL),(1175,7938,210,40720,1518,3,20,1,19701.04,NULL,'2022-12-07 12:08:43','2022-12-07 12:08:43',NULL),(1176,7938,211,40720,1519,3,425,2,19701.04,NULL,'2022-12-07 12:09:03','2022-12-07 12:09:03',NULL),(1177,7938,211,40720,1519,3,20,1,19701.04,NULL,'2022-12-07 12:09:03','2022-12-07 12:09:03',NULL),(1178,7938,212,40720,1520,3,425,2,13837.85,NULL,'2022-12-07 12:09:23','2022-12-07 12:09:23',NULL),(1179,7938,212,40720,1520,3,157,2,5863.19,NULL,'2022-12-07 12:09:23','2022-12-07 12:09:23',NULL),(1180,7938,212,40720,1520,3,20,1,19701.04,NULL,'2022-12-07 12:09:23','2022-12-07 12:09:23',NULL),(1181,7938,213,40720,1530,3,141,1,686.78,NULL,'2022-12-07 12:09:43','2022-12-07 12:09:43',NULL),(1182,7938,213,40720,1530,3,157,2,5730.68,NULL,'2022-12-07 12:09:43','2022-12-07 12:09:43',NULL),(1183,7938,213,40720,1530,3,354,2,19428.36,NULL,'2022-12-07 12:09:43','2022-12-07 12:09:43',NULL),(1184,7938,213,40720,1530,3,20,1,24472.26,NULL,'2022-12-07 12:09:43','2022-12-07 12:09:43',NULL),(1185,7938,214,40720,1521,3,425,2,325005.80,NULL,'2022-12-07 12:22:28','2022-12-07 13:25:47','2022-12-07 13:25:47'),(1186,7938,214,40720,1521,3,491,1,110000.00,NULL,'2022-12-07 12:22:28','2022-12-07 13:25:47','2022-12-07 13:25:47'),(1187,7938,214,40720,1521,3,492,1,45640.00,NULL,'2022-12-07 12:22:28','2022-12-07 13:25:47','2022-12-07 13:25:47'),(1188,7938,214,40720,1521,3,135,1,20463.43,NULL,'2022-12-07 12:22:28','2022-12-07 13:25:47','2022-12-07 13:25:47'),(1189,7938,214,40720,1521,3,494,1,46937.12,NULL,'2022-12-07 12:22:28','2022-12-07 13:25:47','2022-12-07 13:25:47'),(1190,7938,214,40720,1521,3,496,1,32134.00,NULL,'2022-12-07 12:22:28','2022-12-07 13:25:47','2022-12-07 13:25:47'),(1191,7938,214,40720,1521,3,188,1,2000.00,NULL,'2022-12-07 12:22:28','2022-12-07 13:25:47','2022-12-07 13:25:47'),(1192,7938,214,40720,1521,3,396,1,2826.00,NULL,'2022-12-07 12:22:28','2022-12-07 13:25:47','2022-12-07 13:25:47'),(1193,7938,214,40720,1521,3,157,1,4605.85,NULL,'2022-12-07 12:22:28','2022-12-07 13:25:47','2022-12-07 13:25:47'),(1194,7938,214,40720,1521,3,75,1,223.87,NULL,'2022-12-07 12:22:28','2022-12-07 13:25:47','2022-12-07 13:25:47'),(1195,7938,214,40720,1521,3,68,1,42997.29,NULL,'2022-12-07 12:22:28','2022-12-07 13:25:47','2022-12-07 13:25:47'),(1196,7938,214,40720,1521,3,498,1,16500.00,NULL,'2022-12-07 12:22:28','2022-12-07 13:25:47','2022-12-07 13:25:47'),(1197,7938,214,40720,1521,3,25,1,678.24,NULL,'2022-12-07 12:22:28','2022-12-07 13:25:47','2022-12-07 13:25:47'),(1198,7938,215,40720,1520,3,425,2,244182.43,NULL,'2022-12-07 12:23:05','2022-12-07 12:23:05',NULL),(1199,7938,215,40720,1520,3,491,1,110000.00,NULL,'2022-12-07 12:23:05','2022-12-07 12:23:05',NULL),(1200,7938,215,40720,1520,3,492,1,45600.00,NULL,'2022-12-07 12:23:05','2022-12-07 12:23:05',NULL),(1201,7938,215,40720,1520,3,135,1,3341.69,NULL,'2022-12-07 12:23:05','2022-12-07 12:23:05',NULL),(1202,7938,215,40720,1520,3,493,1,2766.92,NULL,'2022-12-07 12:23:05','2022-12-07 12:23:05',NULL),(1203,7938,215,40720,1520,3,494,1,5656.96,NULL,'2022-12-07 12:23:05','2022-12-07 12:23:05',NULL),(1204,7938,215,40720,1520,3,496,1,25999.55,NULL,'2022-12-07 12:23:05','2022-12-07 12:23:05',NULL),(1205,7938,215,40720,1520,3,188,1,7200.00,NULL,'2022-12-07 12:23:05','2022-12-07 12:23:05',NULL),(1206,7938,215,40720,1520,3,396,1,2826.00,NULL,'2022-12-07 12:23:05','2022-12-07 12:23:05',NULL),(1207,7938,215,40720,1520,3,157,1,5000.20,NULL,'2022-12-07 12:23:05','2022-12-07 12:23:05',NULL);
INSERT INTO `balance_libro_details` VALUES (1208,7938,215,40720,1520,3,68,1,35112.87,NULL,'2022-12-07 12:23:05','2022-12-07 12:23:05',NULL),(1209,7938,215,40720,1520,3,25,1,678.24,NULL,'2022-12-07 12:23:05','2022-12-07 12:23:05',NULL),(1210,7938,216,40720,1519,3,425,2,488720.02,NULL,'2022-12-07 12:24:37','2022-12-07 12:24:37',NULL),(1211,7938,216,40720,1519,3,491,1,110000.00,NULL,'2022-12-07 12:24:37','2022-12-07 12:24:37',NULL),(1212,7938,216,40720,1519,3,492,1,45510.00,NULL,'2022-12-07 12:24:37','2022-12-07 12:24:37',NULL),(1213,7938,216,40720,1519,3,135,1,254817.57,NULL,'2022-12-07 12:24:37','2022-12-07 12:24:37',NULL),(1214,7938,216,40720,1519,3,494,1,3157.00,NULL,'2022-12-07 12:24:37','2022-12-07 12:24:37',NULL),(1215,7938,216,40720,1519,3,496,1,18656.16,NULL,'2022-12-07 12:24:37','2022-12-07 12:24:37',NULL),(1216,7938,216,40720,1519,3,188,1,7200.00,NULL,'2022-12-07 12:24:37','2022-12-07 12:24:37',NULL),(1217,7938,216,40720,1519,3,396,1,2826.00,NULL,'2022-12-07 12:24:37','2022-12-07 12:24:37',NULL),(1218,7938,216,40720,1519,3,157,1,5866.19,NULL,'2022-12-07 12:24:37','2022-12-07 12:24:37',NULL),(1219,7938,216,40720,1519,3,68,1,30968.86,NULL,'2022-12-07 12:24:37','2022-12-07 12:24:37',NULL),(1220,7938,216,40720,1519,3,498,1,9040.00,NULL,'2022-12-07 12:24:37','2022-12-07 12:24:37',NULL),(1221,7938,216,40720,1519,3,25,1,678.24,NULL,'2022-12-07 12:24:37','2022-12-07 12:24:37',NULL),(1222,7938,217,40720,1532,3,425,2,415562.19,NULL,'2022-12-07 12:25:11','2022-12-07 13:24:39','2022-12-07 13:24:39'),(1223,7938,217,40720,1532,3,491,1,110000.00,NULL,'2022-12-07 12:25:11','2022-12-07 13:24:39','2022-12-07 13:24:39'),(1224,7938,217,40720,1532,3,492,1,59660.00,NULL,'2022-12-07 12:25:11','2022-12-07 13:24:39','2022-12-07 13:24:39'),(1225,7938,217,40720,1532,3,135,1,166475.11,NULL,'2022-12-07 12:25:11','2022-12-07 13:24:39','2022-12-07 13:24:39'),(1226,7938,217,40720,1532,3,496,1,21833.17,NULL,'2022-12-07 12:25:11','2022-12-07 13:24:39','2022-12-07 13:24:39'),(1227,7938,217,40720,1532,3,396,1,4500.00,NULL,'2022-12-07 12:25:11','2022-12-07 13:24:39','2022-12-07 13:24:39'),(1228,7938,217,40720,1532,3,157,1,2523.82,NULL,'2022-12-07 12:25:11','2022-12-07 13:24:39','2022-12-07 13:24:39'),(1229,7938,217,40720,1532,3,75,1,447.74,NULL,'2022-12-07 12:25:11','2022-12-07 13:24:39','2022-12-07 13:24:39'),(1230,7938,217,40720,1532,3,68,1,34902.35,NULL,'2022-12-07 12:25:11','2022-12-07 13:24:39','2022-12-07 13:24:39'),(1231,7938,217,40720,1532,3,498,1,14140.00,NULL,'2022-12-07 12:25:11','2022-12-07 13:24:39','2022-12-07 13:24:39'),(1232,7938,217,40720,1532,3,25,1,1080.00,NULL,'2022-12-07 12:25:11','2022-12-07 13:24:39','2022-12-07 13:24:39'),(1233,7938,218,40720,1528,3,425,2,652361.12,NULL,'2022-12-07 12:27:05','2022-12-07 13:19:43','2022-12-07 13:19:43'),(1234,7938,218,40720,1528,3,492,1,48750.00,NULL,'2022-12-07 12:27:05','2022-12-07 13:19:43','2022-12-07 13:19:43'),(1235,7938,218,40720,1528,3,135,1,38121.05,NULL,'2022-12-07 12:27:05','2022-12-07 13:19:43','2022-12-07 13:19:43'),(1236,7938,218,40720,1528,3,493,1,385000.00,NULL,'2022-12-07 12:27:05','2022-12-07 13:19:43','2022-12-07 13:19:43'),(1237,7938,218,40720,1528,3,494,1,24536.29,NULL,'2022-12-07 12:27:05','2022-12-07 13:19:43','2022-12-07 13:19:43'),(1238,7938,218,40720,1528,3,496,1,35804.19,NULL,'2022-12-07 12:27:05','2022-12-07 13:19:43','2022-12-07 13:19:43'),(1239,7938,218,40720,1528,3,396,1,3000.00,NULL,'2022-12-07 12:27:05','2022-12-07 13:19:43','2022-12-07 13:19:43'),(1240,7938,218,40720,1528,3,157,1,12444.94,NULL,'2022-12-07 12:27:05','2022-12-07 13:19:43','2022-12-07 13:19:43'),(1241,7938,218,40720,1528,3,75,1,2455.03,NULL,'2022-12-07 12:27:05','2022-12-07 13:19:43','2022-12-07 13:19:43'),(1242,7938,218,40720,1528,3,68,1,101529.62,NULL,'2022-12-07 12:27:05','2022-12-07 13:19:43','2022-12-07 13:19:43'),(1243,7938,218,40720,1528,3,25,1,720.00,NULL,'2022-12-07 12:27:05','2022-12-07 13:19:43','2022-12-07 13:19:43'),(1244,7938,219,40720,1529,3,425,2,351027.30,NULL,'2022-12-07 12:27:39','2022-12-07 13:24:06','2022-12-07 13:24:06');
INSERT INTO `balance_libro_details` VALUES (1245,7938,219,40720,1529,3,491,1,110000.00,NULL,'2022-12-07 12:27:39','2022-12-07 13:24:06','2022-12-07 13:24:06'),(1246,7938,219,40720,1529,3,492,1,53700.00,NULL,'2022-12-07 12:27:39','2022-12-07 13:24:06','2022-12-07 13:24:06'),(1247,7938,219,40720,1529,3,135,1,38328.95,NULL,'2022-12-07 12:27:39','2022-12-07 13:24:06','2022-12-07 13:24:06'),(1248,7938,219,40720,1529,3,494,1,40016.96,NULL,'2022-12-07 12:27:39','2022-12-07 13:24:06','2022-12-07 13:24:06'),(1249,7938,219,40720,1529,3,495,1,4752.21,NULL,'2022-12-07 12:27:39','2022-12-07 13:24:06','2022-12-07 13:24:06'),(1250,7938,219,40720,1529,3,496,1,34346.72,NULL,'2022-12-07 12:27:39','2022-12-07 13:24:06','2022-12-07 13:24:06'),(1251,7938,219,40720,1529,3,396,1,3000.00,NULL,'2022-12-07 12:27:39','2022-12-07 13:24:06','2022-12-07 13:24:06'),(1252,7938,219,40720,1529,3,157,1,5730.68,NULL,'2022-12-07 12:27:39','2022-12-07 13:24:06','2022-12-07 13:24:06'),(1253,7938,219,40720,1529,3,75,1,298.87,NULL,'2022-12-07 12:27:39','2022-12-07 13:24:06','2022-12-07 13:24:06'),(1254,7938,219,40720,1529,3,68,1,35558.91,NULL,'2022-12-07 12:27:39','2022-12-07 13:24:06','2022-12-07 13:24:06'),(1255,7938,219,40720,1529,3,498,1,24574.00,NULL,'2022-12-07 12:27:39','2022-12-07 13:24:06','2022-12-07 13:24:06'),(1256,7938,219,40720,1529,3,25,1,720.00,NULL,'2022-12-07 12:27:39','2022-12-07 13:24:06','2022-12-07 13:24:06'),(1257,7938,220,40720,1526,3,425,2,329493.33,NULL,'2022-12-07 12:28:06','2022-12-07 13:20:16','2022-12-07 13:20:16'),(1258,7938,220,40720,1526,3,491,1,110000.00,NULL,'2022-12-07 12:28:06','2022-12-07 13:20:16','2022-12-07 13:20:16'),(1259,7938,220,40720,1526,3,492,1,111950.00,NULL,'2022-12-07 12:28:06','2022-12-07 13:20:16','2022-12-07 13:20:16'),(1260,7938,220,40720,1526,3,135,1,21865.38,NULL,'2022-12-07 12:28:06','2022-12-07 13:20:16','2022-12-07 13:20:16'),(1261,7938,220,40720,1526,3,494,1,5200.00,NULL,'2022-12-07 12:28:06','2022-12-07 13:20:16','2022-12-07 13:20:16'),(1262,7938,220,40720,1526,3,496,1,30111.64,NULL,'2022-12-07 12:28:06','2022-12-07 13:20:16','2022-12-07 13:20:16'),(1263,7938,220,40720,1526,3,396,1,3000.00,NULL,'2022-12-07 12:28:06','2022-12-07 13:20:16','2022-12-07 13:20:16'),(1264,7938,220,40720,1526,3,157,1,12920.41,NULL,'2022-12-07 12:28:06','2022-12-07 13:20:16','2022-12-07 13:20:16'),(1265,7938,220,40720,1526,3,75,1,525.36,NULL,'2022-12-07 12:28:06','2022-12-07 13:20:16','2022-12-07 13:20:16'),(1266,7938,220,40720,1526,3,68,1,33200.54,NULL,'2022-12-07 12:28:06','2022-12-07 13:20:16','2022-12-07 13:20:16'),(1267,7938,220,40720,1526,3,25,1,720.00,NULL,'2022-12-07 12:28:06','2022-12-07 13:20:16','2022-12-07 13:20:16'),(1268,7938,221,40720,1530,3,425,2,313101.07,NULL,'2022-12-07 12:28:37','2022-12-07 13:23:35','2022-12-07 13:23:35'),(1269,7938,221,40720,1530,3,491,1,110000.00,NULL,'2022-12-07 12:28:37','2022-12-07 13:23:35','2022-12-07 13:23:35'),(1270,7938,221,40720,1530,3,492,1,53850.00,NULL,'2022-12-07 12:28:37','2022-12-07 13:23:35','2022-12-07 13:23:35'),(1271,7938,221,40720,1530,3,135,1,9197.15,NULL,'2022-12-07 12:28:37','2022-12-07 13:23:35','2022-12-07 13:23:35'),(1272,7938,221,40720,1530,3,494,1,15557.42,NULL,'2022-12-07 12:28:37','2022-12-07 13:23:35','2022-12-07 13:23:35'),(1273,7938,221,40720,1530,3,496,1,55850.35,NULL,'2022-12-07 12:28:37','2022-12-07 13:23:35','2022-12-07 13:23:35'),(1274,7938,221,40720,1530,3,396,1,3000.00,NULL,'2022-12-07 12:28:37','2022-12-07 13:23:35','2022-12-07 13:23:35'),(1275,7938,221,40720,1530,3,157,1,4537.84,NULL,'2022-12-07 12:28:37','2022-12-07 13:23:35','2022-12-07 13:23:35'),(1276,7938,221,40720,1530,3,75,1,895.49,NULL,'2022-12-07 12:28:37','2022-12-07 13:23:35','2022-12-07 13:23:35'),(1277,7938,221,40720,1530,3,68,1,59492.82,NULL,'2022-12-07 12:28:37','2022-12-07 13:23:35','2022-12-07 13:23:35'),(1278,7938,221,40720,1530,3,25,1,720.00,NULL,'2022-12-07 12:28:37','2022-12-07 13:23:35','2022-12-07 13:23:35'),(1279,7938,222,40720,1518,3,425,2,320445.93,NULL,'2022-12-07 12:29:06','2022-12-07 13:23:06','2022-12-07 13:23:06');
INSERT INTO `balance_libro_details` VALUES (1280,7938,222,40720,1518,3,491,1,110000.00,NULL,'2022-12-07 12:29:06','2022-12-07 13:23:06','2022-12-07 13:23:06'),(1281,7938,222,40720,1518,3,492,1,45540.00,NULL,'2022-12-07 12:29:06','2022-12-07 13:23:06','2022-12-07 13:23:06'),(1282,7938,222,40720,1518,3,135,1,33092.94,NULL,'2022-12-07 12:29:06','2022-12-07 13:23:06','2022-12-07 13:23:06'),(1283,7938,222,40720,1518,3,494,1,18398.00,NULL,'2022-12-07 12:29:06','2022-12-07 13:23:06','2022-12-07 13:23:06'),(1284,7938,222,40720,1518,3,496,1,25481.95,NULL,'2022-12-07 12:29:06','2022-12-07 13:23:06','2022-12-07 13:23:06'),(1285,7938,222,40720,1518,3,396,1,2826.00,NULL,'2022-12-07 12:29:06','2022-12-07 13:23:06','2022-12-07 13:23:06'),(1286,7938,222,40720,1518,3,157,1,3486.31,NULL,'2022-12-07 12:29:06','2022-12-07 13:23:06','2022-12-07 13:23:06'),(1287,7938,222,40720,1518,3,68,1,80942.49,NULL,'2022-12-07 12:29:06','2022-12-07 13:23:06','2022-12-07 13:23:06'),(1288,7938,222,40720,1518,3,25,1,678.24,NULL,'2022-12-07 12:29:06','2022-12-07 13:23:06','2022-12-07 13:23:06'),(1289,7938,223,40720,1527,3,425,2,253741.69,NULL,'2022-12-07 12:29:34','2022-12-07 13:20:52','2022-12-07 13:20:52'),(1290,7938,223,40720,1527,3,491,1,110000.00,NULL,'2022-12-07 12:29:34','2022-12-07 13:20:52','2022-12-07 13:20:52'),(1291,7938,223,40720,1527,3,492,1,48500.00,NULL,'2022-12-07 12:29:34','2022-12-07 13:20:52','2022-12-07 13:20:52'),(1292,7938,223,40720,1527,3,135,1,34756.49,NULL,'2022-12-07 12:29:34','2022-12-07 13:20:52','2022-12-07 13:20:52'),(1293,7938,223,40720,1527,3,496,1,32105.79,NULL,'2022-12-07 12:29:34','2022-12-07 13:20:52','2022-12-07 13:20:52'),(1294,7938,223,40720,1527,3,396,1,3000.00,NULL,'2022-12-07 12:29:34','2022-12-07 13:20:52','2022-12-07 13:20:52'),(1295,7938,223,40720,1527,3,157,1,3389.97,NULL,'2022-12-07 12:29:34','2022-12-07 13:20:52','2022-12-07 13:20:52'),(1296,7938,223,40720,1527,3,75,1,223.87,NULL,'2022-12-07 12:29:34','2022-12-07 13:20:52','2022-12-07 13:20:52'),(1297,7938,223,40720,1527,3,68,1,10445.57,NULL,'2022-12-07 12:29:34','2022-12-07 13:20:52','2022-12-07 13:20:52'),(1298,7938,223,40720,1527,3,498,1,10600.00,NULL,'2022-12-07 12:29:34','2022-12-07 13:20:52','2022-12-07 13:20:52'),(1299,7938,223,40720,1527,3,25,1,720.00,NULL,'2022-12-07 12:29:34','2022-12-07 13:20:52','2022-12-07 13:20:52'),(1300,7938,224,40720,1531,3,425,2,661435.12,NULL,'2022-12-07 12:30:05','2022-12-07 13:18:44','2022-12-07 13:18:44'),(1301,7938,224,40720,1531,3,491,1,323047.00,NULL,'2022-12-07 12:30:05','2022-12-07 13:18:44','2022-12-07 13:18:44'),(1302,7938,224,40720,1531,3,492,1,54000.00,NULL,'2022-12-07 12:30:05','2022-12-07 13:18:44','2022-12-07 13:18:44'),(1303,7938,224,40720,1531,3,135,1,93968.28,NULL,'2022-12-07 12:30:05','2022-12-07 13:18:44','2022-12-07 13:18:44'),(1304,7938,224,40720,1531,3,494,1,4797.00,NULL,'2022-12-07 12:30:05','2022-12-07 13:18:44','2022-12-07 13:18:44'),(1305,7938,224,40720,1531,3,496,1,60667.88,NULL,'2022-12-07 12:30:05','2022-12-07 13:18:44','2022-12-07 13:18:44'),(1306,7938,224,40720,1531,3,396,1,3000.00,NULL,'2022-12-07 12:30:05','2022-12-07 13:18:44','2022-12-07 13:18:44'),(1307,7938,224,40720,1531,3,157,1,12345.91,NULL,'2022-12-07 12:30:05','2022-12-07 13:18:44','2022-12-07 13:18:44'),(1308,7938,224,40720,1531,3,75,1,637.73,NULL,'2022-12-07 12:30:05','2022-12-07 13:18:44','2022-12-07 13:18:44'),(1309,7938,224,40720,1531,3,68,1,87671.32,NULL,'2022-12-07 12:30:05','2022-12-07 13:18:44','2022-12-07 13:18:44'),(1310,7938,224,40720,1531,3,498,1,21210.00,NULL,'2022-12-07 12:30:05','2022-12-07 13:18:44','2022-12-07 13:18:44'),(1311,7938,224,40720,1531,3,25,1,90.00,NULL,'2022-12-07 12:30:05','2022-12-07 13:18:44','2022-12-07 13:18:44'),(1312,7938,225,40720,1525,3,425,2,263136.59,NULL,'2022-12-07 12:32:10','2022-12-07 13:18:12','2022-12-07 13:18:12'),(1313,7938,225,40720,1525,3,491,1,110000.00,NULL,'2022-12-07 12:32:10','2022-12-07 13:18:12','2022-12-07 13:18:12'),(1314,7938,225,40720,1525,3,492,1,55070.00,NULL,'2022-12-07 12:32:10','2022-12-07 13:18:12','2022-12-07 13:18:12');
INSERT INTO `balance_libro_details` VALUES (1315,7938,225,40720,1525,3,135,1,7137.07,NULL,'2022-12-07 12:32:10','2022-12-07 13:18:12','2022-12-07 13:18:12'),(1316,7938,225,40720,1525,3,494,1,22646.98,NULL,'2022-12-07 12:32:10','2022-12-07 13:18:12','2022-12-07 13:18:12'),(1317,7938,225,40720,1525,3,496,1,27181.68,NULL,'2022-12-07 12:32:10','2022-12-07 13:18:12','2022-12-07 13:18:12'),(1318,7938,225,40720,1525,3,396,1,2826.00,NULL,'2022-12-07 12:32:10','2022-12-07 13:18:12','2022-12-07 13:18:12'),(1319,7938,225,40720,1525,3,157,1,3446.02,NULL,'2022-12-07 12:32:10','2022-12-07 13:18:12','2022-12-07 13:18:12'),(1320,7938,225,40720,1525,3,75,1,223.77,NULL,'2022-12-07 12:32:10','2022-12-07 13:18:12','2022-12-07 13:18:12'),(1321,7938,225,40720,1525,3,68,1,33926.83,NULL,'2022-12-07 12:32:10','2022-12-07 13:18:12','2022-12-07 13:18:12'),(1322,7938,225,40720,1525,3,25,1,678.24,NULL,'2022-12-07 12:32:10','2022-12-07 13:18:12','2022-12-07 13:18:12'),(1323,7938,226,40720,1518,2,425,1,249343.40,NULL,'2022-12-07 12:33:45','2022-12-07 12:33:45',NULL),(1324,7938,226,40720,1518,2,25,1,42000.00,NULL,'2022-12-07 12:33:45','2022-12-07 12:33:45',NULL),(1325,7938,226,40720,1518,2,23,1,3656.60,NULL,'2022-12-07 12:33:45','2022-12-07 12:33:45',NULL),(1326,7938,226,40720,1518,2,97,2,250000.00,NULL,'2022-12-07 12:33:45','2022-12-07 12:33:45',NULL),(1327,7938,226,40720,1518,2,67,2,52500.00,NULL,'2022-12-07 12:33:45','2022-12-07 12:33:45',NULL),(1328,7938,226,40720,1518,2,21,1,7500.00,NULL,'2022-12-07 12:33:45','2022-12-07 12:33:45',NULL),(1329,7938,227,40720,1531,3,20,1,24472.26,NULL,'2022-12-07 12:40:09','2022-12-07 12:40:09',NULL),(1330,7938,227,40720,1531,3,354,2,24472.26,NULL,'2022-12-07 12:40:09','2022-12-07 12:40:09',NULL),(1331,7938,228,40720,1532,18,485,1,22148.17,NULL,'2022-12-07 12:43:19','2022-12-07 12:43:19',NULL),(1332,7938,228,40720,1532,18,302,2,21978.47,NULL,'2022-12-07 12:43:19','2022-12-07 12:43:19',NULL),(1333,7938,228,40720,1532,18,301,2,169.70,NULL,'2022-12-07 12:43:19','2022-12-07 12:43:19',NULL),(1334,7938,229,40720,1529,2,488,1,6908.64,NULL,'2022-12-07 13:00:14','2022-12-07 13:00:14',NULL),(1335,7938,229,40720,1529,2,67,2,1199.02,NULL,'2022-12-07 13:00:14','2022-12-07 13:00:14',NULL),(1336,7938,229,40720,1529,2,487,2,5709.62,NULL,'2022-12-07 13:00:14','2022-12-07 13:00:14',NULL),(1337,7938,230,40720,1521,15,67,1,95477.03,NULL,'2022-12-07 13:03:14','2022-12-07 13:03:14',NULL),(1338,7938,230,40720,1521,15,354,1,133206.16,NULL,'2022-12-07 13:03:14','2022-12-07 13:03:14',NULL),(1339,7938,230,40720,1521,15,68,2,42997.29,NULL,'2022-12-07 13:03:14','2022-12-07 13:03:14',NULL),(1340,7938,230,40720,1521,15,25,2,75857.65,NULL,'2022-12-07 13:03:14','2022-12-07 13:03:14',NULL),(1341,7938,230,40720,1521,15,354,2,109828.25,NULL,'2022-12-07 13:03:14','2022-12-07 13:03:14',NULL),(1342,7938,231,40720,1526,15,67,1,222147.45,NULL,'2022-12-07 13:05:20','2022-12-07 13:05:20',NULL),(1343,7938,231,40720,1526,15,354,1,76939.79,NULL,'2022-12-07 13:05:20','2022-12-07 13:05:20',NULL),(1344,7938,231,40720,1526,15,68,2,33200.54,NULL,'2022-12-07 13:05:20','2022-12-07 13:05:20',NULL),(1345,7938,231,40720,1526,15,25,2,178095.00,NULL,'2022-12-07 13:05:20','2022-12-07 13:05:20',NULL),(1346,7938,231,40720,1526,15,354,2,87791.70,NULL,'2022-12-07 13:05:20','2022-12-07 13:05:20',NULL),(1347,7938,232,40720,1530,15,67,1,95739.34,NULL,'2022-12-07 13:06:37','2022-12-07 13:08:36','2022-12-07 13:08:36'),(1348,7938,232,40720,1530,15,354,1,100072.24,NULL,'2022-12-07 13:06:37','2022-12-07 13:08:36','2022-12-07 13:08:36'),(1349,7938,232,40720,1530,15,68,2,59492.82,NULL,'2022-12-07 13:06:37','2022-12-07 13:08:36','2022-12-07 13:08:36'),(1350,7938,232,40720,1530,15,25,2,75600.00,NULL,'2022-12-07 13:06:37','2022-12-07 13:08:36','2022-12-07 13:08:36'),(1351,7938,232,40720,1530,15,354,2,60718.76,NULL,'2022-12-07 13:06:37','2022-12-07 13:08:36','2022-12-07 13:08:36'),(1352,7938,233,40720,1530,15,67,1,95739.36,NULL,'2022-12-07 13:08:36','2022-12-07 13:10:03','2022-12-07 13:10:03');
INSERT INTO `balance_libro_details` VALUES (1353,7938,233,40720,1530,15,354,1,100072.22,NULL,'2022-12-07 13:08:36','2022-12-07 13:10:03','2022-12-07 13:10:03'),(1354,7938,233,40720,1530,15,68,2,59492.82,NULL,'2022-12-07 13:08:36','2022-12-07 13:10:03','2022-12-07 13:10:03'),(1355,7938,233,40720,1530,15,25,2,75600.00,NULL,'2022-12-07 13:08:36','2022-12-07 13:10:03','2022-12-07 13:10:03'),(1356,7938,233,40720,1530,15,354,2,60718.76,NULL,'2022-12-07 13:08:36','2022-12-07 13:10:03','2022-12-07 13:10:03'),(1357,7938,234,40720,1530,15,67,1,95739.30,NULL,'2022-12-07 13:10:03','2022-12-07 13:10:03',NULL),(1358,7938,234,40720,1530,15,354,1,100072.28,NULL,'2022-12-07 13:10:03','2022-12-07 13:10:03',NULL),(1359,7938,234,40720,1530,15,68,2,59492.82,NULL,'2022-12-07 13:10:03','2022-12-07 13:10:03',NULL),(1360,7938,234,40720,1530,15,25,2,75600.00,NULL,'2022-12-07 13:10:03','2022-12-07 13:10:03',NULL),(1361,7938,234,40720,1530,15,354,2,60718.76,NULL,'2022-12-07 13:10:03','2022-12-07 13:10:03',NULL),(1362,7938,235,40720,1518,12,359,1,64054.49,NULL,'2022-12-07 13:12:43','2022-12-07 13:12:43',NULL),(1363,7938,235,40720,1518,12,425,1,160932.75,NULL,'2022-12-07 13:12:43','2022-12-07 13:12:43',NULL),(1364,7938,235,40720,1518,12,20,1,177333.00,NULL,'2022-12-07 13:12:43','2022-12-07 13:12:43',NULL),(1365,7938,235,40720,1518,12,384,1,477123.29,NULL,'2022-12-07 13:12:43','2022-12-07 13:12:43',NULL),(1366,7938,235,40720,1518,12,386,1,1837927.35,NULL,'2022-12-07 13:12:43','2022-12-07 13:12:43',NULL),(1367,7938,235,40720,1518,12,485,1,32880.24,NULL,'2022-12-07 13:12:43','2022-12-07 13:12:43',NULL),(1368,7938,235,40720,1518,12,369,2,200000.00,NULL,'2022-12-07 13:12:43','2022-12-07 13:12:43',NULL),(1369,7938,235,40720,1518,12,483,2,40000.00,NULL,'2022-12-07 13:12:43','2022-12-07 13:12:43',NULL),(1370,7938,235,40720,1518,12,88,2,1401757.76,NULL,'2022-12-07 13:12:43','2022-12-07 13:12:43',NULL),(1371,7938,235,40720,1518,12,383,2,1410610.84,NULL,'2022-12-07 13:12:43','2022-12-07 13:12:43',NULL),(1372,7938,235,40720,1518,12,482,1,205750.00,NULL,'2022-12-07 13:12:43','2022-12-07 13:12:43',NULL),(1373,7938,235,40720,1518,12,23,1,60622.24,NULL,'2022-12-07 13:12:43','2022-12-07 13:12:43',NULL),(1374,7938,235,40720,1518,12,354,1,35745.24,NULL,'2022-12-07 13:12:43','2022-12-07 13:12:43',NULL),(1375,7938,236,40720,1525,3,425,2,263136.59,NULL,'2022-12-07 13:18:12','2022-12-07 13:18:12',NULL),(1376,7938,236,40720,1525,3,491,1,110000.00,NULL,'2022-12-07 13:18:12','2022-12-07 13:18:12',NULL),(1377,7938,236,40720,1525,3,492,1,55070.00,NULL,'2022-12-07 13:18:12','2022-12-07 13:18:12',NULL),(1378,7938,236,40720,1525,3,135,1,7137.07,NULL,'2022-12-07 13:18:12','2022-12-07 13:18:12',NULL),(1379,7938,236,40720,1525,3,494,1,22646.98,NULL,'2022-12-07 13:18:12','2022-12-07 13:18:12',NULL),(1380,7938,236,40720,1525,3,496,1,27181.68,NULL,'2022-12-07 13:18:12','2022-12-07 13:18:12',NULL),(1381,7938,236,40720,1525,3,396,1,2826.00,NULL,'2022-12-07 13:18:12','2022-12-07 13:18:12',NULL),(1382,7938,236,40720,1525,3,157,1,3446.02,NULL,'2022-12-07 13:18:12','2022-12-07 13:18:12',NULL),(1383,7938,236,40720,1525,3,68,1,33926.83,NULL,'2022-12-07 13:18:12','2022-12-07 13:18:12',NULL),(1384,7938,236,40720,1525,3,25,1,678.24,NULL,'2022-12-07 13:18:12','2022-12-07 13:18:12',NULL),(1385,7938,236,40720,1525,3,209,1,223.77,NULL,'2022-12-07 13:18:12','2022-12-07 13:18:12',NULL),(1386,7938,237,40720,1531,3,425,2,661435.12,NULL,'2022-12-07 13:18:44','2022-12-07 13:18:44',NULL),(1387,7938,237,40720,1531,3,491,1,323047.00,NULL,'2022-12-07 13:18:44','2022-12-07 13:18:44',NULL),(1388,7938,237,40720,1531,3,492,1,54000.00,NULL,'2022-12-07 13:18:44','2022-12-07 13:18:44',NULL),(1389,7938,237,40720,1531,3,135,1,93968.28,NULL,'2022-12-07 13:18:44','2022-12-07 13:18:44',NULL),(1390,7938,237,40720,1531,3,494,1,4797.00,NULL,'2022-12-07 13:18:44','2022-12-07 13:18:44',NULL),(1391,7938,237,40720,1531,3,496,1,60667.88,NULL,'2022-12-07 13:18:44','2022-12-07 13:18:44',NULL),(1392,7938,237,40720,1531,3,396,1,3000.00,NULL,'2022-12-07 13:18:44','2022-12-07 13:18:44',NULL);
INSERT INTO `balance_libro_details` VALUES (1393,7938,237,40720,1531,3,157,1,12345.91,NULL,'2022-12-07 13:18:44','2022-12-07 13:18:44',NULL),(1394,7938,237,40720,1531,3,68,1,87671.32,NULL,'2022-12-07 13:18:44','2022-12-07 13:18:44',NULL),(1395,7938,237,40720,1531,3,498,1,21210.00,NULL,'2022-12-07 13:18:44','2022-12-07 13:18:44',NULL),(1396,7938,237,40720,1531,3,25,1,90.00,NULL,'2022-12-07 13:18:44','2022-12-07 13:18:44',NULL),(1397,7938,237,40720,1531,3,209,1,637.73,NULL,'2022-12-07 13:18:44','2022-12-07 13:18:44',NULL),(1398,7938,238,40720,1528,3,425,2,652361.12,NULL,'2022-12-07 13:19:43','2022-12-07 13:19:43',NULL),(1399,7938,238,40720,1528,3,492,1,48750.00,NULL,'2022-12-07 13:19:43','2022-12-07 13:19:43',NULL),(1400,7938,238,40720,1528,3,135,1,38121.05,NULL,'2022-12-07 13:19:43','2022-12-07 13:19:43',NULL),(1401,7938,238,40720,1528,3,493,1,385000.00,NULL,'2022-12-07 13:19:43','2022-12-07 13:19:43',NULL),(1402,7938,238,40720,1528,3,494,1,24536.29,NULL,'2022-12-07 13:19:43','2022-12-07 13:19:43',NULL),(1403,7938,238,40720,1528,3,496,1,35804.19,NULL,'2022-12-07 13:19:43','2022-12-07 13:19:43',NULL),(1404,7938,238,40720,1528,3,396,1,3000.00,NULL,'2022-12-07 13:19:43','2022-12-07 13:19:43',NULL),(1405,7938,238,40720,1528,3,157,1,12444.94,NULL,'2022-12-07 13:19:43','2022-12-07 13:19:43',NULL),(1406,7938,238,40720,1528,3,68,1,101529.62,NULL,'2022-12-07 13:19:43','2022-12-07 13:19:43',NULL),(1407,7938,238,40720,1528,3,25,1,720.00,NULL,'2022-12-07 13:19:43','2022-12-07 13:19:43',NULL),(1408,7938,238,40720,1528,3,209,1,2455.03,NULL,'2022-12-07 13:19:43','2022-12-07 13:19:43',NULL),(1409,7938,239,40720,1526,3,425,2,329493.33,NULL,'2022-12-07 13:20:16','2022-12-07 13:20:16',NULL),(1410,7938,239,40720,1526,3,491,1,110000.00,NULL,'2022-12-07 13:20:16','2022-12-07 13:20:16',NULL),(1411,7938,239,40720,1526,3,492,1,111950.00,NULL,'2022-12-07 13:20:16','2022-12-07 13:20:16',NULL),(1412,7938,239,40720,1526,3,135,1,21865.38,NULL,'2022-12-07 13:20:16','2022-12-07 13:20:16',NULL),(1413,7938,239,40720,1526,3,494,1,5200.00,NULL,'2022-12-07 13:20:16','2022-12-07 13:20:16',NULL),(1414,7938,239,40720,1526,3,496,1,30111.64,NULL,'2022-12-07 13:20:16','2022-12-07 13:20:16',NULL),(1415,7938,239,40720,1526,3,396,1,3000.00,NULL,'2022-12-07 13:20:16','2022-12-07 13:20:16',NULL),(1416,7938,239,40720,1526,3,157,1,12920.41,NULL,'2022-12-07 13:20:16','2022-12-07 13:20:16',NULL),(1417,7938,239,40720,1526,3,68,1,33200.54,NULL,'2022-12-07 13:20:16','2022-12-07 13:20:16',NULL),(1418,7938,239,40720,1526,3,25,1,720.00,NULL,'2022-12-07 13:20:16','2022-12-07 13:20:16',NULL),(1419,7938,239,40720,1526,3,209,1,525.36,NULL,'2022-12-07 13:20:16','2022-12-07 13:20:16',NULL),(1420,7938,240,40720,1527,3,425,2,253741.69,NULL,'2022-12-07 13:20:52','2022-12-07 13:20:52',NULL),(1421,7938,240,40720,1527,3,491,1,110000.00,NULL,'2022-12-07 13:20:52','2022-12-07 13:20:52',NULL),(1422,7938,240,40720,1527,3,492,1,48500.00,NULL,'2022-12-07 13:20:52','2022-12-07 13:20:52',NULL),(1423,7938,240,40720,1527,3,135,1,34756.49,NULL,'2022-12-07 13:20:52','2022-12-07 13:20:52',NULL),(1424,7938,240,40720,1527,3,496,1,32105.79,NULL,'2022-12-07 13:20:52','2022-12-07 13:20:52',NULL),(1425,7938,240,40720,1527,3,396,1,3000.00,NULL,'2022-12-07 13:20:52','2022-12-07 13:20:52',NULL),(1426,7938,240,40720,1527,3,157,1,3389.97,NULL,'2022-12-07 13:20:52','2022-12-07 13:20:52',NULL),(1427,7938,240,40720,1527,3,68,1,10445.57,NULL,'2022-12-07 13:20:52','2022-12-07 13:20:52',NULL),(1428,7938,240,40720,1527,3,498,1,10600.00,NULL,'2022-12-07 13:20:52','2022-12-07 13:20:52',NULL),(1429,7938,240,40720,1527,3,25,1,720.00,NULL,'2022-12-07 13:20:52','2022-12-07 13:20:52',NULL),(1430,7938,240,40720,1527,3,209,1,223.87,NULL,'2022-12-07 13:20:52','2022-12-07 13:20:52',NULL),(1431,7938,241,40720,1518,3,425,2,320445.93,NULL,'2022-12-07 13:23:06','2022-12-07 13:23:06',NULL),(1432,7938,241,40720,1518,3,491,1,110000.00,NULL,'2022-12-07 13:23:06','2022-12-07 13:23:06',NULL),(1433,7938,241,40720,1518,3,492,1,45540.00,NULL,'2022-12-07 13:23:06','2022-12-07 13:23:06',NULL);
INSERT INTO `balance_libro_details` VALUES (1434,7938,241,40720,1518,3,135,1,33092.94,NULL,'2022-12-07 13:23:06','2022-12-07 13:23:06',NULL),(1435,7938,241,40720,1518,3,494,1,18398.00,NULL,'2022-12-07 13:23:06','2022-12-07 13:23:06',NULL),(1436,7938,241,40720,1518,3,496,1,25481.95,NULL,'2022-12-07 13:23:06','2022-12-07 13:23:06',NULL),(1437,7938,241,40720,1518,3,396,1,2826.00,NULL,'2022-12-07 13:23:06','2022-12-07 13:23:06',NULL),(1438,7938,241,40720,1518,3,157,1,3486.31,NULL,'2022-12-07 13:23:06','2022-12-07 13:23:06',NULL),(1439,7938,241,40720,1518,3,68,1,80942.49,NULL,'2022-12-07 13:23:06','2022-12-07 13:23:06',NULL),(1440,7938,241,40720,1518,3,25,1,678.24,NULL,'2022-12-07 13:23:06','2022-12-07 13:23:06',NULL),(1441,7938,242,40720,1530,3,425,2,313101.07,NULL,'2022-12-07 13:23:35','2022-12-07 13:23:35',NULL),(1442,7938,242,40720,1530,3,491,1,110000.00,NULL,'2022-12-07 13:23:35','2022-12-07 13:23:35',NULL),(1443,7938,242,40720,1530,3,492,1,53850.00,NULL,'2022-12-07 13:23:35','2022-12-07 13:23:35',NULL),(1444,7938,242,40720,1530,3,135,1,9197.15,NULL,'2022-12-07 13:23:35','2022-12-07 13:23:35',NULL),(1445,7938,242,40720,1530,3,494,1,15557.42,NULL,'2022-12-07 13:23:35','2022-12-07 13:23:35',NULL),(1446,7938,242,40720,1530,3,496,1,55850.35,NULL,'2022-12-07 13:23:35','2022-12-07 13:23:35',NULL),(1447,7938,242,40720,1530,3,396,1,3000.00,NULL,'2022-12-07 13:23:35','2022-12-07 13:23:35',NULL),(1448,7938,242,40720,1530,3,157,1,4537.84,NULL,'2022-12-07 13:23:35','2022-12-07 13:23:35',NULL),(1449,7938,242,40720,1530,3,68,1,59492.82,NULL,'2022-12-07 13:23:35','2022-12-07 13:23:35',NULL),(1450,7938,242,40720,1530,3,25,1,720.00,NULL,'2022-12-07 13:23:35','2022-12-07 13:23:35',NULL),(1451,7938,242,40720,1530,3,209,1,895.49,NULL,'2022-12-07 13:23:35','2022-12-07 13:23:35',NULL),(1452,7938,243,40720,1529,3,425,2,351027.30,NULL,'2022-12-07 13:24:06','2022-12-07 13:24:06',NULL),(1453,7938,243,40720,1529,3,491,1,110000.00,NULL,'2022-12-07 13:24:06','2022-12-07 13:24:06',NULL),(1454,7938,243,40720,1529,3,492,1,53700.00,NULL,'2022-12-07 13:24:06','2022-12-07 13:24:06',NULL),(1455,7938,243,40720,1529,3,135,1,38328.95,NULL,'2022-12-07 13:24:06','2022-12-07 13:24:06',NULL),(1456,7938,243,40720,1529,3,494,1,40016.96,NULL,'2022-12-07 13:24:06','2022-12-07 13:24:06',NULL),(1457,7938,243,40720,1529,3,495,1,4752.21,NULL,'2022-12-07 13:24:06','2022-12-07 13:24:06',NULL),(1458,7938,243,40720,1529,3,496,1,34346.72,NULL,'2022-12-07 13:24:06','2022-12-07 13:24:06',NULL),(1459,7938,243,40720,1529,3,396,1,3000.00,NULL,'2022-12-07 13:24:06','2022-12-07 13:24:06',NULL),(1460,7938,243,40720,1529,3,157,1,5730.68,NULL,'2022-12-07 13:24:06','2022-12-07 13:24:06',NULL),(1461,7938,243,40720,1529,3,68,1,35558.91,NULL,'2022-12-07 13:24:06','2022-12-07 13:24:06',NULL),(1462,7938,243,40720,1529,3,498,1,24574.00,NULL,'2022-12-07 13:24:06','2022-12-07 13:24:06',NULL),(1463,7938,243,40720,1529,3,25,1,720.00,NULL,'2022-12-07 13:24:06','2022-12-07 13:24:06',NULL),(1464,7938,243,40720,1529,3,209,1,298.87,NULL,'2022-12-07 13:24:06','2022-12-07 13:24:06',NULL),(1465,7938,244,40720,1532,3,425,2,415562.19,NULL,'2022-12-07 13:24:39','2022-12-07 13:24:39',NULL),(1466,7938,244,40720,1532,3,491,1,110000.00,NULL,'2022-12-07 13:24:39','2022-12-07 13:24:39',NULL),(1467,7938,244,40720,1532,3,492,1,59660.00,NULL,'2022-12-07 13:24:39','2022-12-07 13:24:39',NULL),(1468,7938,244,40720,1532,3,135,1,166475.11,NULL,'2022-12-07 13:24:39','2022-12-07 13:24:39',NULL),(1469,7938,244,40720,1532,3,496,1,21833.17,NULL,'2022-12-07 13:24:39','2022-12-07 13:24:39',NULL),(1470,7938,244,40720,1532,3,396,1,4500.00,NULL,'2022-12-07 13:24:39','2022-12-07 13:24:39',NULL),(1471,7938,244,40720,1532,3,157,1,2523.82,NULL,'2022-12-07 13:24:39','2022-12-07 13:24:39',NULL),(1472,7938,244,40720,1532,3,68,1,34902.35,NULL,'2022-12-07 13:24:39','2022-12-07 13:24:39',NULL),(1473,7938,244,40720,1532,3,498,1,14140.00,NULL,'2022-12-07 13:24:39','2022-12-07 13:24:39',NULL),(1474,7938,244,40720,1532,3,25,1,1080.00,NULL,'2022-12-07 13:24:39','2022-12-07 13:24:39',NULL);
INSERT INTO `balance_libro_details` VALUES (1475,7938,244,40720,1532,3,209,1,447.74,NULL,'2022-12-07 13:24:39','2022-12-07 13:24:39',NULL),(1476,7938,245,40720,1521,3,425,2,325005.80,NULL,'2022-12-07 13:25:47','2022-12-07 13:25:47',NULL),(1477,7938,245,40720,1521,3,491,1,110000.00,NULL,'2022-12-07 13:25:47','2022-12-07 13:25:47',NULL),(1478,7938,245,40720,1521,3,492,1,45640.00,NULL,'2022-12-07 13:25:47','2022-12-07 13:25:47',NULL),(1479,7938,245,40720,1521,3,135,1,20463.43,NULL,'2022-12-07 13:25:47','2022-12-07 13:25:47',NULL),(1480,7938,245,40720,1521,3,494,1,46937.12,NULL,'2022-12-07 13:25:47','2022-12-07 13:25:47',NULL),(1481,7938,245,40720,1521,3,496,1,32134.00,NULL,'2022-12-07 13:25:47','2022-12-07 13:25:47',NULL),(1482,7938,245,40720,1521,3,188,1,2000.00,NULL,'2022-12-07 13:25:47','2022-12-07 13:25:47',NULL),(1483,7938,245,40720,1521,3,396,1,2826.00,NULL,'2022-12-07 13:25:47','2022-12-07 13:25:47',NULL),(1484,7938,245,40720,1521,3,157,1,4605.85,NULL,'2022-12-07 13:25:47','2022-12-07 13:25:47',NULL),(1485,7938,245,40720,1521,3,68,1,42997.29,NULL,'2022-12-07 13:25:47','2022-12-07 13:25:47',NULL),(1486,7938,245,40720,1521,3,498,1,16500.00,NULL,'2022-12-07 13:25:47','2022-12-07 13:25:47',NULL),(1487,7938,245,40720,1521,3,25,1,678.24,NULL,'2022-12-07 13:25:47','2022-12-07 13:25:47',NULL),(1488,7938,245,40720,1521,3,209,1,223.87,NULL,'2022-12-07 13:25:47','2022-12-07 13:25:47',NULL),(1489,7938,246,40720,1526,19,383,1,1130125.41,NULL,'2022-12-07 13:34:01','2022-12-09 10:47:23','2022-12-09 10:47:23'),(1490,7938,246,40720,1526,19,425,2,653002.12,NULL,'2022-12-07 13:34:01','2022-12-09 10:47:23','2022-12-09 10:47:23'),(1491,7938,246,40720,1526,19,477,2,477123.29,NULL,'2022-12-07 13:34:01','2022-12-09 10:47:23','2022-12-09 10:47:23'),(1492,7938,247,40720,1532,23,476,2,0.00,NULL,'2022-12-07 13:49:54','2022-12-07 13:50:26','2022-12-07 13:50:26'),(1493,7938,248,40720,1532,23,359,1,46375.83,NULL,'2022-12-07 13:50:06','2022-12-07 13:50:57','2022-12-07 13:50:57'),(1494,7938,248,40720,1532,23,384,1,345440.08,NULL,'2022-12-07 13:50:06','2022-12-07 13:50:57','2022-12-07 13:50:57'),(1495,7938,248,40720,1532,23,477,2,243255.66,NULL,'2022-12-07 13:50:06','2022-12-07 13:50:57','2022-12-07 13:50:57'),(1496,7938,248,40720,1532,23,476,2,148560.25,NULL,'2022-12-07 13:50:06','2022-12-07 13:50:57','2022-12-07 13:50:57'),(1497,7938,249,40720,1526,11,157,1,49998.32,NULL,'2022-12-09 10:41:25','2022-12-09 10:41:25',NULL),(1498,7938,249,40720,1526,11,359,2,49998.32,NULL,'2022-12-09 10:41:25','2022-12-09 10:41:25',NULL),(1499,7938,250,40720,1533,11,482,1,477123.00,NULL,'2022-12-09 10:42:38','2022-12-09 10:47:46','2022-12-09 10:47:46'),(1500,7938,250,40720,1533,11,384,2,477123.00,NULL,'2022-12-09 10:42:38','2022-12-09 10:47:46','2022-12-09 10:47:46'),(1501,7938,251,40720,1526,19,383,1,1325875.41,NULL,'2022-12-09 10:47:23','2022-12-09 13:44:00','2022-12-09 13:44:00'),(1502,7938,251,40720,1526,19,425,2,653002.12,NULL,'2022-12-09 10:47:23','2022-12-09 13:44:00','2022-12-09 13:44:00'),(1503,7938,251,40720,1526,19,482,2,672873.29,NULL,'2022-12-09 10:47:23','2022-12-09 13:44:00','2022-12-09 13:44:00'),(1504,7938,252,40720,1533,11,482,1,477123.00,NULL,'2022-12-09 10:47:46','2022-12-09 10:51:56','2022-12-09 10:51:56'),(1505,7938,252,40720,1533,11,384,2,477123.00,NULL,'2022-12-09 10:47:46','2022-12-09 10:51:56','2022-12-09 10:51:56'),(1506,7938,253,40720,1533,11,482,1,477123.29,NULL,'2022-12-09 10:51:56','2022-12-09 11:05:44','2022-12-09 11:05:44'),(1507,7938,253,40720,1533,11,384,2,477123.29,NULL,'2022-12-09 10:51:56','2022-12-09 11:05:44','2022-12-09 11:05:44'),(1508,7938,254,40720,1532,14,477,2,74956.35,NULL,'2022-12-09 11:05:18','2022-12-09 11:11:39','2022-12-09 11:11:39'),(1509,7938,254,40720,1532,14,102,1,74956.35,NULL,'2022-12-09 11:05:18','2022-12-09 11:11:39','2022-12-09 11:11:39'),(1510,7938,255,40720,1533,11,482,1,477123.29,NULL,'2022-12-09 11:05:44','2022-12-13 05:24:51','2022-12-13 05:24:51');
INSERT INTO `balance_libro_details` VALUES (1511,7938,255,40720,1533,11,384,2,477123.29,NULL,'2022-12-09 11:05:44','2022-12-13 05:24:51','2022-12-13 05:24:51'),(1512,7938,256,40720,1532,14,477,1,74956.35,NULL,'2022-12-09 11:11:39','2022-12-09 11:14:38','2022-12-09 11:14:38'),(1513,7938,256,40720,1532,14,102,2,74956.35,NULL,'2022-12-09 11:11:39','2022-12-09 11:14:38','2022-12-09 11:14:38'),(1514,7938,257,40720,1532,14,477,1,74956.35,NULL,'2022-12-09 11:14:38','2022-12-09 11:14:38',NULL),(1515,7938,257,40720,1532,14,386,2,74956.35,NULL,'2022-12-09 11:14:38','2022-12-09 11:14:38',NULL),(1516,7938,258,40720,1532,2,386,1,74956.35,NULL,'2022-12-09 11:15:12','2022-12-09 11:15:12',NULL),(1517,7938,258,40720,1532,2,102,2,74956.35,NULL,'2022-12-09 11:15:12','2022-12-09 11:15:12',NULL),(1518,7938,259,40720,1532,23,482,2,221235.09,NULL,'2022-12-09 12:33:00','2022-12-09 13:04:36','2022-12-09 13:04:36'),(1519,7938,259,40720,1532,23,384,1,345440.08,NULL,'2022-12-09 12:33:00','2022-12-09 13:04:36','2022-12-09 13:04:36'),(1520,7938,259,40720,1532,23,488,1,23897.37,NULL,'2022-12-09 12:33:00','2022-12-09 13:04:36','2022-12-09 13:04:36'),(1521,7938,259,40720,1532,23,386,1,2010107.69,NULL,'2022-12-09 12:33:00','2022-12-09 13:04:36','2022-12-09 13:04:36'),(1522,7938,259,40720,1532,23,359,1,24456.57,NULL,'2022-12-09 12:33:00','2022-12-09 13:04:36','2022-12-09 13:04:36'),(1523,7938,259,40720,1532,23,425,1,336550.82,NULL,'2022-12-09 12:33:00','2022-12-09 13:04:36','2022-12-09 13:04:36'),(1524,7938,259,40720,1532,23,25,1,2039.37,NULL,'2022-12-09 12:33:00','2022-12-09 13:04:36','2022-12-09 13:04:36'),(1525,7938,259,40720,1532,23,21,1,2010.52,NULL,'2022-12-09 12:33:00','2022-12-09 13:04:36','2022-12-09 13:04:36'),(1526,7938,259,40720,1532,23,23,1,61801.55,NULL,'2022-12-09 12:33:00','2022-12-09 13:04:36','2022-12-09 13:04:36'),(1527,7938,259,40720,1532,23,477,2,34084.82,NULL,'2022-12-09 12:33:00','2022-12-09 13:04:36','2022-12-09 13:04:36'),(1528,7938,259,40720,1532,23,476,2,2550984.06,NULL,'2022-12-09 12:33:00','2022-12-09 13:04:36','2022-12-09 13:04:36'),(1529,7938,260,40720,1532,23,88,2,144801.18,NULL,'2022-12-09 13:17:24','2022-12-09 13:48:27','2022-12-09 13:48:27'),(1530,7938,260,40720,1532,23,383,2,440026.81,NULL,'2022-12-09 13:17:24','2022-12-09 13:48:27','2022-12-09 13:48:27'),(1531,7938,260,40720,1532,23,88,2,1014880.89,NULL,'2022-12-09 13:17:24','2022-12-09 13:48:27','2022-12-09 13:48:27'),(1532,7938,260,40720,1532,23,476,1,1599708.88,NULL,'2022-12-09 13:17:24','2022-12-09 13:48:27','2022-12-09 13:48:27'),(1533,7938,261,40720,1532,23,88,2,144801.18,NULL,'2022-12-09 13:17:44','2022-12-09 13:50:20','2022-12-09 13:50:20'),(1534,7938,261,40720,1532,23,383,2,440026.81,NULL,'2022-12-09 13:17:44','2022-12-09 13:50:20','2022-12-09 13:50:20'),(1535,7938,261,40720,1532,23,88,2,1014880.89,NULL,'2022-12-09 13:17:44','2022-12-09 13:50:20','2022-12-09 13:50:20'),(1536,7938,261,40720,1532,23,476,1,1599708.88,NULL,'2022-12-09 13:17:44','2022-12-09 13:50:20','2022-12-09 13:50:20'),(1537,7938,262,40720,1526,19,383,1,1325875.41,NULL,'2022-12-09 13:44:00','2022-12-09 13:44:00',NULL),(1538,7938,262,40720,1526,19,425,2,653002.12,NULL,'2022-12-09 13:44:00','2022-12-09 13:44:00',NULL),(1539,7938,262,40720,1526,19,482,2,672873.29,NULL,'2022-12-09 13:44:00','2022-12-09 13:44:00',NULL),(1540,7938,263,40720,1532,23,88,2,1014880.89,NULL,'2022-12-09 14:03:43','2022-12-09 14:31:25','2022-12-09 14:31:25'),(1541,7938,263,40720,1532,23,476,1,1014880.89,NULL,'2022-12-09 14:03:43','2022-12-09 14:31:25','2022-12-09 14:31:25'),(1542,7938,264,40720,1532,23,88,2,1014880.89,NULL,'2022-12-09 14:31:25','2022-12-09 14:31:30','2022-12-09 14:31:30'),(1543,7938,264,40720,1532,23,476,1,1014880.89,NULL,'2022-12-09 14:31:25','2022-12-09 14:31:30','2022-12-09 14:31:30'),(1544,7938,265,40720,1532,23,88,2,1014880.89,NULL,'2022-12-09 14:32:23','2022-12-09 14:33:49','2022-12-09 14:33:49'),(1545,7938,265,40720,1532,23,476,1,1014880.89,NULL,'2022-12-09 14:32:23','2022-12-09 14:33:49','2022-12-09 14:33:49');
INSERT INTO `balance_libro_details` VALUES (1546,7938,266,40720,1532,23,88,2,144801.18,NULL,'2022-12-09 14:33:26','2022-12-09 14:36:41','2022-12-09 14:36:41'),(1547,7938,266,40720,1532,23,88,2,1014880.89,NULL,'2022-12-09 14:33:26','2022-12-09 14:36:41','2022-12-09 14:36:41'),(1548,7938,266,40720,1532,23,476,1,1159682.07,NULL,'2022-12-09 14:33:26','2022-12-09 14:36:41','2022-12-09 14:36:41'),(1549,7938,267,40720,1532,23,88,2,144801.18,NULL,'2022-12-09 14:38:20','2022-12-13 05:12:51','2022-12-13 05:12:51'),(1550,7938,267,40720,1532,23,383,2,440026.81,NULL,'2022-12-09 14:38:20','2022-12-13 05:12:51','2022-12-13 05:12:51'),(1551,7938,267,40720,1532,23,88,2,1014880.89,NULL,'2022-12-09 14:38:20','2022-12-13 05:12:51','2022-12-13 05:12:51'),(1552,7938,267,40720,1532,23,476,1,1599708.88,NULL,'2022-12-09 14:38:20','2022-12-13 05:12:51','2022-12-13 05:12:51'),(1553,7938,268,40721,3183,12,425,1,77990.60,NULL,'2022-12-10 09:55:23','2022-12-10 09:55:23',NULL),(1554,7938,268,40721,3183,12,485,1,91059.70,NULL,'2022-12-10 09:55:23','2022-12-10 09:55:23',NULL),(1555,7938,268,40721,3183,12,157,1,216359.65,NULL,'2022-12-10 09:55:23','2022-12-10 09:55:23',NULL),(1556,7938,268,40721,3183,12,24,1,22234.28,NULL,'2022-12-10 09:55:23','2022-12-10 09:55:23',NULL),(1557,7938,268,40721,3183,12,23,1,98949.94,NULL,'2022-12-10 09:55:23','2022-12-10 09:55:23',NULL),(1558,7938,268,40721,3183,12,384,1,72231.16,NULL,'2022-12-10 09:55:23','2022-12-10 09:55:23',NULL),(1559,7938,268,40721,3183,12,64,2,4531.70,NULL,'2022-12-10 09:55:23','2022-12-10 09:55:23',NULL),(1560,7938,268,40721,3183,12,78,2,52.39,NULL,'2022-12-10 09:55:23','2022-12-10 09:55:23',NULL),(1561,7938,268,40721,3183,12,74,2,25060.57,NULL,'2022-12-10 09:55:23','2022-12-10 09:55:23',NULL),(1562,7938,268,40721,3183,12,76,2,87341.81,NULL,'2022-12-10 09:55:23','2022-12-10 09:55:23',NULL),(1563,7938,268,40721,3183,12,369,2,60000.00,NULL,'2022-12-10 09:55:23','2022-12-10 09:55:23',NULL),(1564,7938,268,40721,3183,12,88,2,246243.87,NULL,'2022-12-10 09:55:23','2022-12-10 09:55:23',NULL),(1565,7938,268,40721,3183,12,383,2,155594.99,NULL,'2022-12-10 09:55:23','2022-12-10 09:55:23',NULL),(1566,7938,269,40720,1532,23,102,2,300066.99,NULL,'2022-12-13 05:14:45','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1567,7938,269,40720,1532,23,88,2,1014880.89,NULL,'2022-12-13 05:14:45','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1568,7938,269,40720,1532,23,487,2,19749.88,NULL,'2022-12-13 05:14:45','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1569,7938,269,40720,1532,23,383,2,440026.81,NULL,'2022-12-13 05:14:45','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1570,7938,269,40720,1532,23,88,2,144801.18,NULL,'2022-12-13 05:14:45','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1571,7938,269,40720,1532,23,498,1,25645.36,NULL,'2022-12-13 05:14:45','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1572,7938,269,40720,1532,23,396,1,13171.56,NULL,'2022-12-13 05:14:45','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1573,7938,269,40720,1532,23,496,1,132795.20,NULL,'2022-12-13 05:14:45','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1574,7938,269,40720,1532,23,493,1,106009.38,NULL,'2022-12-13 05:14:45','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1575,7938,269,40720,1532,23,491,1,487688.53,NULL,'2022-12-13 05:14:45','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1576,7938,269,40720,1532,23,188,1,10415.15,NULL,'2022-12-13 05:14:45','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1577,7938,269,40720,1532,23,494,1,76867.88,NULL,'2022-12-13 05:14:45','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1578,7938,269,40720,1532,23,492,1,247537.37,NULL,'2022-12-13 05:14:46','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1579,7938,269,40720,1532,23,97,2,1911425.71,NULL,'2022-12-13 05:14:46','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1580,7938,269,40720,1532,23,209,1,133.31,NULL,'2022-12-13 05:14:46','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1581,7938,269,40720,1532,23,157,1,2365.33,NULL,'2022-12-13 05:14:46','2022-12-13 05:24:57','2022-12-13 05:24:57');
INSERT INTO `balance_libro_details` VALUES (1582,7938,269,40720,1532,23,155,1,180428.83,NULL,'2022-12-13 05:14:46','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1583,7938,269,40720,1532,23,490,2,537552.29,NULL,'2022-12-13 05:14:46','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1584,7938,269,40720,1532,23,495,1,996.85,NULL,'2022-12-13 05:14:46','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1585,7938,269,40720,1532,23,141,1,690.34,NULL,'2022-12-13 05:14:46','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1586,7938,269,40720,1532,23,156,1,74247.15,NULL,'2022-12-13 05:14:46','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1587,7938,269,40720,1532,23,476,1,3009511.51,NULL,'2022-12-13 05:14:46','2022-12-13 05:24:57','2022-12-13 05:24:57'),(1588,7938,270,40720,1532,11,482,1,477123.29,NULL,'2022-12-13 05:24:51','2022-12-13 05:24:51',NULL),(1589,7938,270,40720,1532,11,384,2,477123.29,NULL,'2022-12-13 05:24:51','2022-12-13 05:24:51',NULL),(1590,7938,271,40720,1532,23,383,2,440026.81,NULL,'2022-12-13 05:26:35','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1591,7938,271,40720,1532,23,102,2,300066.99,NULL,'2022-12-13 05:26:35','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1592,7938,271,40720,1532,23,88,2,144801.18,NULL,'2022-12-13 05:26:35','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1593,7938,271,40720,1532,23,487,2,19749.88,NULL,'2022-12-13 05:26:35','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1594,7938,271,40720,1532,23,88,2,1014880.89,NULL,'2022-12-13 05:26:35','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1595,7938,271,40720,1532,23,498,1,25645.36,NULL,'2022-12-13 05:26:35','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1596,7938,271,40720,1532,23,491,1,487688.53,NULL,'2022-12-13 05:26:35','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1597,7938,271,40720,1532,23,396,1,13171.56,NULL,'2022-12-13 05:26:35','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1598,7938,271,40720,1532,23,496,1,132795.20,NULL,'2022-12-13 05:26:35','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1599,7938,271,40720,1532,23,493,1,106009.38,NULL,'2022-12-13 05:26:35','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1600,7938,271,40720,1532,23,492,1,247537.37,NULL,'2022-12-13 05:26:36','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1601,7938,271,40720,1532,23,188,1,10415.15,NULL,'2022-12-13 05:26:36','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1602,7938,271,40720,1532,23,494,1,76867.88,NULL,'2022-12-13 05:26:36','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1603,7938,271,40720,1532,23,135,1,258727.27,NULL,'2022-12-13 05:26:36','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1604,7938,271,40720,1532,23,209,1,133.31,NULL,'2022-12-13 05:26:36','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1605,7938,271,40720,1532,23,97,2,1911425.71,NULL,'2022-12-13 05:26:36','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1606,7938,271,40720,1532,23,157,1,2365.33,NULL,'2022-12-13 05:26:36','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1607,7938,271,40720,1532,23,155,1,180428.83,NULL,'2022-12-13 05:26:36','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1608,7938,271,40720,1532,23,490,2,537552.29,NULL,'2022-12-13 05:26:36','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1609,7938,271,40720,1532,23,141,1,690.34,NULL,'2022-12-13 05:26:36','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1610,7938,271,40720,1532,23,495,1,996.85,NULL,'2022-12-13 05:26:37','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1611,7938,271,40720,1532,23,156,1,74247.15,NULL,'2022-12-13 05:26:37','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1612,7938,271,40720,1532,23,476,1,2750784.24,NULL,'2022-12-13 05:26:37','2022-12-13 05:35:51','2022-12-13 05:35:51'),(1613,7938,272,40720,1532,23,102,2,300066.99,NULL,'2022-12-13 05:38:24','2022-12-13 05:38:24',NULL),(1614,7938,272,40720,1532,23,88,2,1014880.89,NULL,'2022-12-13 05:38:24','2022-12-13 05:38:24',NULL),(1615,7938,272,40720,1532,23,487,2,19749.88,NULL,'2022-12-13 05:38:24','2022-12-13 05:38:24',NULL),(1616,7938,272,40720,1532,23,383,2,440026.81,NULL,'2022-12-13 05:38:24','2022-12-13 05:38:24',NULL);
INSERT INTO `balance_libro_details` VALUES (1617,7938,272,40720,1532,23,88,2,144801.18,NULL,'2022-12-13 05:38:24','2022-12-13 05:38:24',NULL),(1618,7938,272,40720,1532,23,498,1,25645.36,NULL,'2022-12-13 05:38:24','2022-12-13 05:38:24',NULL),(1619,7938,272,40720,1532,23,188,1,10415.15,NULL,'2022-12-13 05:38:24','2022-12-13 05:38:24',NULL),(1620,7938,272,40720,1532,23,494,1,76867.88,NULL,'2022-12-13 05:38:24','2022-12-13 05:38:24',NULL),(1621,7938,272,40720,1532,23,135,1,258727.27,NULL,'2022-12-13 05:38:24','2022-12-13 05:38:24',NULL),(1622,7938,272,40720,1532,23,491,1,487688.53,NULL,'2022-12-13 05:38:24','2022-12-13 05:38:24',NULL),(1623,7938,272,40720,1532,23,396,1,13171.56,NULL,'2022-12-13 05:38:24','2022-12-13 05:38:24',NULL),(1624,7938,272,40720,1532,23,496,1,132795.20,NULL,'2022-12-13 05:38:24','2022-12-13 05:38:24',NULL),(1625,7938,272,40720,1532,23,493,1,106009.38,NULL,'2022-12-13 05:38:25','2022-12-13 05:38:25',NULL),(1626,7938,272,40720,1532,23,492,1,247537.37,NULL,'2022-12-13 05:38:25','2022-12-13 05:38:25',NULL),(1627,7938,272,40720,1532,23,209,1,133.31,NULL,'2022-12-13 05:38:25','2022-12-13 05:38:25',NULL),(1628,7938,272,40720,1532,23,97,2,1911425.71,NULL,'2022-12-13 05:38:25','2022-12-13 05:38:25',NULL),(1629,7938,272,40720,1532,23,155,1,180428.83,NULL,'2022-12-13 05:38:25','2022-12-13 05:38:25',NULL),(1630,7938,272,40720,1532,23,490,2,537552.29,NULL,'2022-12-13 05:38:25','2022-12-13 05:38:25',NULL),(1631,7938,272,40720,1532,23,141,1,690.34,NULL,'2022-12-13 05:38:25','2022-12-13 05:38:25',NULL),(1632,7938,272,40720,1532,23,495,1,996.85,NULL,'2022-12-13 05:38:25','2022-12-13 05:38:25',NULL),(1633,7938,272,40720,1532,23,156,1,74247.15,NULL,'2022-12-13 05:38:25','2022-12-13 05:38:25',NULL),(1634,7938,272,40720,1532,23,476,1,2753149.57,NULL,'2022-12-13 05:38:25','2022-12-13 05:38:25',NULL),(1635,7938,273,40721,3183,15,67,1,187412.32,NULL,'2022-12-26 11:46:01','2022-12-26 11:46:01',NULL),(1636,7938,273,40721,3183,15,353,1,39701.41,NULL,'2022-12-26 11:46:01','2022-12-26 11:46:01',NULL),(1637,7938,273,40721,3183,15,68,2,89646.50,NULL,'2022-12-26 11:46:01','2022-12-26 11:46:01',NULL),(1638,7938,273,40721,3183,15,25,2,137467.23,NULL,'2022-12-26 11:46:01','2022-12-26 11:46:01',NULL),(1639,7938,274,40721,3184,15,67,1,198411.19,NULL,'2022-12-26 11:48:34','2022-12-26 11:48:34',NULL),(1640,7938,274,40721,3184,15,68,2,12748.33,NULL,'2022-12-26 11:48:34','2022-12-26 11:48:34',NULL),(1641,7938,274,40721,3184,15,25,2,145789.37,NULL,'2022-12-26 11:48:34','2022-12-26 11:48:34',NULL),(1642,7938,274,40721,3184,15,353,2,39701.41,NULL,'2022-12-26 11:48:34','2022-12-26 11:48:34',NULL),(1643,7938,274,40721,3184,15,74,2,172.08,NULL,'2022-12-26 11:48:34','2022-12-26 11:48:34',NULL),(1644,7938,275,40721,3185,15,67,1,191040.94,NULL,'2022-12-26 11:49:53','2022-12-26 11:49:53',NULL),(1645,7938,275,40721,3185,15,68,2,11013.64,NULL,'2022-12-26 11:49:53','2022-12-26 11:49:53',NULL),(1646,7938,275,40721,3185,15,25,2,138899.57,NULL,'2022-12-26 11:49:53','2022-12-26 11:49:53',NULL),(1647,7938,275,40721,3185,15,74,2,41127.73,NULL,'2022-12-26 11:49:53','2022-12-26 11:49:53',NULL),(1648,7938,276,40721,3186,15,67,1,192671.42,NULL,'2022-12-26 11:53:26','2022-12-26 11:53:26',NULL),(1649,7938,276,40721,3186,15,68,2,13965.90,NULL,'2022-12-26 11:53:26','2022-12-26 11:53:26',NULL),(1650,7938,276,40721,3186,15,25,2,137978.16,NULL,'2022-12-26 11:53:26','2022-12-26 11:53:26',NULL),(1651,7938,276,40721,3186,15,74,2,40727.36,NULL,'2022-12-26 11:53:26','2022-12-26 11:53:26',NULL),(1652,7938,277,40721,3190,15,67,1,213470.76,NULL,'2022-12-26 11:54:45','2022-12-26 11:54:45',NULL),(1653,7938,277,40721,3190,15,68,2,10763.04,NULL,'2022-12-26 11:54:45','2022-12-26 11:54:45',NULL),(1654,7938,277,40721,3190,15,25,2,159180.33,NULL,'2022-12-26 11:54:45','2022-12-26 11:54:45',NULL),(1655,7938,277,40721,3190,15,74,2,43527.39,NULL,'2022-12-26 11:54:45','2022-12-26 11:54:45',NULL),(1656,7938,278,40721,3191,15,67,1,219928.66,NULL,'2022-12-26 11:56:10','2022-12-26 11:56:10',NULL);
INSERT INTO `balance_libro_details` VALUES (1657,7938,278,40721,3191,15,68,2,7338.66,NULL,'2022-12-26 11:56:10','2022-12-26 11:56:10',NULL),(1658,7938,278,40721,3191,15,25,2,162027.18,NULL,'2022-12-26 11:56:10','2022-12-26 11:56:10',NULL),(1659,7938,278,40721,3191,15,74,2,50562.82,NULL,'2022-12-26 11:56:10','2022-12-26 11:56:10',NULL),(1660,7938,279,40721,3191,15,67,1,219928.66,NULL,'2022-12-26 11:56:19','2022-12-26 12:12:29','2022-12-26 12:12:29'),(1661,7938,279,40721,3191,15,68,2,7338.66,NULL,'2022-12-26 11:56:19','2022-12-26 12:12:29','2022-12-26 12:12:29'),(1662,7938,279,40721,3191,15,25,2,162027.18,NULL,'2022-12-26 11:56:19','2022-12-26 12:12:29','2022-12-26 12:12:29'),(1663,7938,279,40721,3191,15,74,2,50562.82,NULL,'2022-12-26 11:56:19','2022-12-26 12:12:29','2022-12-26 12:12:29'),(1664,7938,280,40721,3192,15,67,1,253504.80,NULL,'2022-12-26 11:57:45','2022-12-26 11:57:45',NULL),(1665,7938,280,40721,3192,15,68,2,16359.97,NULL,'2022-12-26 11:57:45','2022-12-26 11:57:45',NULL),(1666,7938,280,40721,3192,15,25,2,185671.07,NULL,'2022-12-26 11:57:45','2022-12-26 11:57:45',NULL),(1667,7938,280,40721,3192,15,74,2,51473.76,NULL,'2022-12-26 11:57:45','2022-12-26 11:57:45',NULL),(1668,7938,281,40721,3193,15,67,1,273867.53,NULL,'2022-12-26 11:58:51','2022-12-26 11:58:51',NULL),(1669,7938,281,40721,3193,15,353,1,4501.56,NULL,'2022-12-26 11:58:51','2022-12-26 11:58:51',NULL),(1670,7938,281,40721,3193,15,68,2,76398.84,NULL,'2022-12-26 11:58:51','2022-12-26 11:58:51',NULL),(1671,7938,281,40721,3193,15,25,2,201970.25,NULL,'2022-12-26 11:58:51','2022-12-26 11:58:51',NULL),(1672,7938,282,40721,3194,15,67,1,271094.62,NULL,'2022-12-26 12:00:02','2022-12-26 12:00:02',NULL),(1673,7938,282,40721,3194,15,353,1,25925.38,NULL,'2022-12-26 12:00:03','2022-12-26 12:00:03',NULL),(1674,7938,282,40721,3194,15,68,2,84219.91,NULL,'2022-12-26 12:00:03','2022-12-26 12:00:03',NULL),(1675,7938,282,40721,3194,15,25,2,208298.53,NULL,'2022-12-26 12:00:03','2022-12-26 12:00:03',NULL),(1676,7938,282,40721,3194,15,353,2,4501.56,NULL,'2022-12-26 12:00:03','2022-12-26 12:00:03',NULL),(1677,7938,283,40721,3195,15,67,1,298094.59,NULL,'2022-12-26 12:02:00','2022-12-26 12:02:00',NULL),(1678,7938,283,40721,3195,15,353,1,42747.65,NULL,'2022-12-26 12:02:00','2022-12-26 12:02:00',NULL),(1679,7938,283,40721,3195,15,68,2,91871.68,NULL,'2022-12-26 12:02:00','2022-12-26 12:02:00',NULL),(1680,7938,283,40721,3195,15,25,2,227546.74,NULL,'2022-12-26 12:02:00','2022-12-26 12:02:00',NULL),(1681,7938,283,40721,3195,15,353,2,21423.82,NULL,'2022-12-26 12:02:00','2022-12-26 12:02:00',NULL),(1682,7938,284,40721,3196,15,67,1,598397.50,NULL,'2022-12-26 12:03:19','2023-01-03 21:43:22','2023-01-03 21:43:22'),(1683,7938,284,40721,3196,15,68,2,203982.54,NULL,'2022-12-26 12:03:19','2023-01-03 21:43:22','2023-01-03 21:43:22'),(1684,7938,284,40721,3196,15,25,2,243088.53,NULL,'2022-12-26 12:03:19','2023-01-03 21:43:22','2023-01-03 21:43:22'),(1685,7938,284,40721,3196,15,74,2,151326.43,NULL,'2022-12-26 12:03:19','2023-01-03 21:43:22','2023-01-03 21:43:22'),(1686,7938,285,40721,3197,15,67,1,835177.17,NULL,'2022-12-26 12:04:39','2022-12-26 12:04:39',NULL),(1687,7938,285,40721,3197,15,68,2,204684.60,NULL,'2022-12-26 12:04:39','2022-12-26 12:04:39',NULL),(1688,7938,285,40721,3197,15,25,2,265782.04,NULL,'2022-12-26 12:04:39','2022-12-26 12:04:39',NULL),(1689,7938,285,40721,3197,15,74,2,364710.53,NULL,'2022-12-26 12:04:39','2022-12-26 12:04:39',NULL),(1690,7938,286,40721,3183,16,156,1,48418.60,NULL,'2022-12-26 12:14:38','2023-01-03 14:02:11','2023-01-03 14:02:11'),(1691,7938,286,40721,3183,16,485,1,63704.75,NULL,'2022-12-26 12:14:38','2023-01-03 14:02:11','2023-01-03 14:02:11'),(1692,7938,286,40721,3183,16,21,2,20947.33,NULL,'2022-12-26 12:14:38','2023-01-03 14:02:11','2023-01-03 14:02:11'),(1693,7938,286,40721,3183,16,485,2,91059.70,NULL,'2022-12-26 12:14:38','2023-01-03 14:02:11','2023-01-03 14:02:11'),(1694,7938,286,40721,3183,16,78,2,116.32,NULL,'2022-12-26 12:14:38','2023-01-03 14:02:11','2023-01-03 14:02:11');
INSERT INTO `balance_libro_details` VALUES (1695,7938,287,40721,3184,16,156,1,51447.19,NULL,'2022-12-26 12:15:50','2023-01-03 14:02:38','2023-01-03 14:02:38'),(1696,7938,287,40721,3184,16,485,1,32401.90,NULL,'2022-12-26 12:15:50','2023-01-03 14:02:38','2023-01-03 14:02:38'),(1697,7938,287,40721,3184,16,21,2,20102.42,NULL,'2022-12-26 12:15:50','2023-01-03 14:02:38','2023-01-03 14:02:38'),(1698,7938,287,40721,3184,16,485,2,63704.75,NULL,'2022-12-26 12:15:50','2023-01-03 14:02:38','2023-01-03 14:02:38'),(1699,7938,287,40721,3184,16,78,2,41.92,NULL,'2022-12-26 12:15:50','2023-01-03 14:02:38','2023-01-03 14:02:38'),(1700,7938,288,40721,3185,16,156,1,49567.80,NULL,'2022-12-26 12:16:54','2023-01-03 14:01:00','2023-01-03 14:01:00'),(1701,7938,288,40721,3185,16,485,1,23406.14,NULL,'2022-12-26 12:16:54','2023-01-03 14:01:00','2023-01-03 14:01:00'),(1702,7938,288,40721,3185,16,21,2,18428.56,NULL,'2022-12-26 12:16:54','2023-01-03 14:01:00','2023-01-03 14:01:00'),(1703,7938,288,40721,3185,16,485,2,32409.56,NULL,'2022-12-26 12:16:54','2023-01-03 14:01:00','2023-01-03 14:01:00'),(1704,7938,288,40721,3185,16,78,2,22135.82,NULL,'2022-12-26 12:16:54','2023-01-03 14:01:00','2023-01-03 14:01:00'),(1705,7938,289,40721,3186,16,156,1,49948.28,NULL,'2022-12-26 12:17:57','2023-01-03 14:00:34','2023-01-03 14:00:34'),(1706,7938,289,40721,3186,16,485,1,23983.53,NULL,'2022-12-26 12:17:57','2023-01-03 14:00:34','2023-01-03 14:00:34'),(1707,7938,289,40721,3186,16,21,2,20435.89,NULL,'2022-12-26 12:17:57','2023-01-03 14:00:34','2023-01-03 14:00:34'),(1708,7938,289,40721,3186,16,485,2,23406.14,NULL,'2022-12-26 12:17:57','2023-01-03 14:00:34','2023-01-03 14:00:34'),(1709,7938,289,40721,3186,16,78,2,30089.78,NULL,'2022-12-26 12:17:57','2023-01-03 14:00:34','2023-01-03 14:00:34'),(1710,7938,290,40721,3190,16,156,1,55038.20,NULL,'2022-12-26 12:19:29','2023-01-03 14:01:40','2023-01-03 14:01:40'),(1711,7938,290,40721,3190,16,485,1,24820.96,NULL,'2022-12-26 12:19:29','2023-01-03 14:01:40','2023-01-03 14:01:40'),(1712,7938,290,40721,3190,16,21,2,20941.87,NULL,'2022-12-26 12:19:29','2023-01-03 14:01:40','2023-01-03 14:01:40'),(1713,7938,290,40721,3190,16,209,2,6211.01,NULL,'2022-12-26 12:19:29','2023-01-03 14:01:40','2023-01-03 14:01:40'),(1714,7938,290,40721,3190,16,485,2,23983.53,NULL,'2022-12-26 12:19:29','2023-01-03 14:01:40','2023-01-03 14:01:40'),(1715,7938,290,40721,3190,16,78,2,28722.75,NULL,'2022-12-26 12:19:29','2023-01-03 14:01:40','2023-01-03 14:01:40'),(1716,7938,291,40721,3191,16,156,1,56804.14,NULL,'2022-12-26 12:20:44','2023-01-03 14:00:09','2023-01-03 14:00:09'),(1717,7938,291,40721,3191,16,485,1,25609.87,NULL,'2022-12-26 12:20:44','2023-01-03 14:00:09','2023-01-03 14:00:09'),(1718,7938,291,40721,3191,16,21,2,21385.86,NULL,'2022-12-26 12:20:44','2023-01-03 14:00:09','2023-01-03 14:00:09'),(1719,7938,291,40721,3191,16,209,2,6137.13,NULL,'2022-12-26 12:20:44','2023-01-03 14:00:09','2023-01-03 14:00:09'),(1720,7938,291,40721,3191,16,485,2,24820.96,NULL,'2022-12-26 12:20:44','2023-01-03 14:00:09','2023-01-03 14:00:09'),(1721,7938,291,40721,3191,16,78,2,30070.06,NULL,'2022-12-26 12:20:44','2023-01-03 14:00:09','2023-01-03 14:00:09'),(1722,7938,292,40721,3192,16,156,1,65115.71,NULL,'2022-12-26 12:30:00','2023-01-03 13:59:17','2023-01-03 13:59:17'),(1723,7938,292,40721,3192,16,485,1,27022.80,NULL,'2022-12-26 12:30:00','2023-01-03 13:59:17','2023-01-03 13:59:17'),(1724,7938,292,40721,3192,16,21,2,24667.92,NULL,'2022-12-26 12:30:00','2023-01-03 13:59:17','2023-01-03 13:59:17'),(1725,7938,292,40721,3192,16,209,2,7355.18,NULL,'2022-12-26 12:30:00','2023-01-03 13:59:17','2023-01-03 13:59:17'),(1726,7938,292,40721,3192,16,485,2,25609.87,NULL,'2022-12-26 12:30:00','2023-01-03 13:59:17','2023-01-03 13:59:17'),(1727,7938,292,40721,3192,16,78,2,34505.54,NULL,'2022-12-26 12:30:00','2023-01-03 13:59:17','2023-01-03 13:59:17'),(1728,7938,293,40721,3193,16,156,1,70615.46,NULL,'2022-12-26 12:31:59','2023-01-03 13:59:45','2023-01-03 13:59:45');
INSERT INTO `balance_libro_details` VALUES (1729,7938,293,40721,3193,16,485,1,28138.05,NULL,'2022-12-26 12:31:59','2023-01-03 13:59:45','2023-01-03 13:59:45'),(1730,7938,293,40721,3193,16,21,2,26021.40,NULL,'2022-12-26 12:31:59','2023-01-03 13:59:45','2023-01-03 13:59:45'),(1731,7938,293,40721,3193,16,209,2,8513.64,NULL,'2022-12-26 12:31:59','2023-01-03 13:59:45','2023-01-03 13:59:45'),(1732,7938,293,40721,3193,16,485,2,27022.51,NULL,'2022-12-26 12:31:59','2023-01-03 13:59:45','2023-01-03 13:59:45'),(1733,7938,293,40721,3193,16,78,2,37195.96,NULL,'2022-12-26 12:31:59','2023-01-03 13:59:45','2023-01-03 13:59:45'),(1734,7938,294,40721,3194,16,156,1,69901.92,NULL,'2022-12-26 12:33:31','2023-01-03 13:58:50','2023-01-03 13:58:50'),(1735,7938,294,40721,3194,16,485,1,29672.51,NULL,'2022-12-26 12:33:31','2023-01-03 13:58:50','2023-01-03 13:58:50'),(1736,7938,294,40721,3194,16,21,2,30589.88,NULL,'2022-12-26 12:33:31','2023-01-03 13:58:50','2023-01-03 13:58:50'),(1737,7938,294,40721,3194,16,209,2,7712.75,NULL,'2022-12-26 12:33:31','2023-01-03 13:58:50','2023-01-03 13:58:50'),(1738,7938,294,40721,3194,16,485,2,28138.05,NULL,'2022-12-26 12:33:31','2023-01-03 13:58:50','2023-01-03 13:58:50'),(1739,7938,294,40721,3194,16,78,2,33133.75,NULL,'2022-12-26 12:33:31','2023-01-03 13:58:50','2023-01-03 13:58:50'),(1740,7938,295,40721,3195,16,156,1,76586.49,NULL,'2022-12-26 12:35:14','2023-01-03 13:58:23','2023-01-03 13:58:23'),(1741,7938,295,40721,3195,16,485,1,30329.44,NULL,'2022-12-26 12:35:14','2023-01-03 13:58:23','2023-01-03 13:58:23'),(1742,7938,295,40721,3195,16,21,2,30328.26,NULL,'2022-12-26 12:35:14','2023-01-03 13:58:23','2023-01-03 13:58:23'),(1743,7938,295,40721,3195,16,209,2,8478.39,NULL,'2022-12-26 12:35:14','2023-01-03 13:58:23','2023-01-03 13:58:23'),(1744,7938,295,40721,3195,16,485,2,28707.92,NULL,'2022-12-26 12:35:14','2023-01-03 13:58:23','2023-01-03 13:58:23'),(1745,7938,295,40721,3195,16,78,2,39401.36,NULL,'2022-12-26 12:35:14','2023-01-03 13:58:23','2023-01-03 13:58:23'),(1746,7938,296,40721,3196,16,156,1,155230.88,NULL,'2022-12-26 12:36:42','2023-01-03 13:57:56','2023-01-03 13:57:56'),(1747,7938,296,40721,3196,16,485,1,24408.22,NULL,'2022-12-26 12:36:42','2023-01-03 13:57:56','2023-01-03 13:57:56'),(1748,7938,296,40721,3196,16,21,2,42833.08,NULL,'2022-12-26 12:36:42','2023-01-03 13:57:56','2023-01-03 13:57:56'),(1749,7938,296,40721,3196,16,209,2,18297.34,NULL,'2022-12-26 12:36:42','2023-01-03 13:57:56','2023-01-03 13:57:56'),(1750,7938,296,40721,3196,16,485,2,30329.44,NULL,'2022-12-26 12:36:42','2023-01-03 13:57:56','2023-01-03 13:57:56'),(1751,7938,296,40721,3196,16,78,2,88179.24,NULL,'2022-12-26 12:36:42','2023-01-03 13:57:56','2023-01-03 13:57:56'),(1752,7938,297,40721,3197,16,156,1,217020.61,NULL,'2022-12-26 12:38:00','2023-01-03 13:57:28','2023-01-03 13:57:28'),(1753,7938,297,40721,3197,16,485,1,26041.58,NULL,'2022-12-26 12:38:00','2023-01-03 13:57:28','2023-01-03 13:57:28'),(1754,7938,297,40721,3197,16,21,2,75627.79,NULL,'2022-12-26 12:38:00','2023-01-03 13:57:28','2023-01-03 13:57:28'),(1755,7938,297,40721,3197,16,209,2,25494.06,NULL,'2022-12-26 12:38:00','2023-01-03 13:57:28','2023-01-03 13:57:28'),(1756,7938,297,40721,3197,16,485,2,24408.22,NULL,'2022-12-26 12:38:00','2023-01-03 13:57:28','2023-01-03 13:57:28'),(1757,7938,297,40721,3197,16,78,2,117532.12,NULL,'2022-12-26 12:38:00','2023-01-03 13:57:28','2023-01-03 13:57:28'),(1758,7938,298,40721,3190,3,155,1,244158.24,NULL,'2022-12-26 12:43:25','2023-01-03 21:45:13','2023-01-03 21:45:13'),(1759,7938,298,40721,3190,3,24,1,12879.43,NULL,'2022-12-26 12:43:25','2023-01-03 21:45:13','2023-01-03 21:45:13'),(1760,7938,298,40721,3190,3,157,2,80086.94,NULL,'2022-12-26 12:43:25','2023-01-03 21:45:13','2023-01-03 21:45:13'),(1761,7938,298,40721,3190,3,23,2,176950.73,NULL,'2022-12-26 12:43:25','2023-01-03 21:45:13','2023-01-03 21:45:13'),(1762,7938,299,40721,3191,3,354,2,16801.88,NULL,'2022-12-26 12:45:34','2023-01-03 21:39:06','2023-01-03 21:39:06');
INSERT INTO `balance_libro_details` VALUES (1763,7938,299,40721,3191,3,20,1,16801.88,NULL,'2022-12-26 12:45:34','2023-01-03 21:39:06','2023-01-03 21:39:06'),(1764,7938,300,40721,3192,3,354,2,5598.39,NULL,'2022-12-26 12:46:22','2023-01-03 21:40:21','2023-01-03 21:40:21'),(1765,7938,300,40721,3192,3,20,1,5598.39,NULL,'2022-12-26 12:46:22','2023-01-03 21:40:21','2023-01-03 21:40:21'),(1766,7938,301,40721,3193,3,354,2,5598.39,NULL,'2022-12-26 12:47:50','2023-01-03 21:38:32','2023-01-03 21:38:32'),(1767,7938,301,40721,3193,3,20,1,5598.39,NULL,'2022-12-26 12:47:50','2023-01-03 21:38:32','2023-01-03 21:38:32'),(1768,7938,302,40721,3194,3,20,1,5598.39,NULL,'2022-12-26 12:51:08','2023-01-03 21:38:07','2023-01-03 21:38:07'),(1769,7938,302,40721,3194,3,354,2,5598.39,NULL,'2022-12-26 12:51:08','2023-01-03 21:38:07','2023-01-03 21:38:07'),(1770,7938,303,40721,3195,3,20,1,5598.39,NULL,'2022-12-26 12:51:50','2023-01-03 21:37:24','2023-01-03 21:37:24'),(1771,7938,303,40721,3195,3,354,2,1516.66,NULL,'2022-12-26 12:51:50','2023-01-03 21:37:24','2023-01-03 21:37:24'),(1772,7938,303,40721,3195,3,157,2,4081.73,NULL,'2022-12-26 12:51:50','2023-01-03 21:37:24','2023-01-03 21:37:24'),(1773,7938,304,40721,3196,3,20,1,5598.39,NULL,'2022-12-26 12:52:21','2022-12-26 12:52:21',NULL),(1774,7938,304,40721,3196,3,157,2,5598.39,NULL,'2022-12-26 12:52:21','2022-12-26 12:52:21',NULL),(1775,7938,305,40721,3197,3,20,1,5598.39,NULL,'2022-12-26 12:53:11','2022-12-26 12:53:11',NULL),(1776,7938,305,40721,3197,3,157,2,5598.39,NULL,'2022-12-26 12:53:11','2022-12-26 12:53:11',NULL),(1777,7938,306,40721,3183,3,68,1,89646.50,NULL,'2022-12-26 14:09:21','2023-01-03 21:54:53','2023-01-03 21:54:53'),(1778,7938,306,40721,3183,3,62,1,218898.00,NULL,'2022-12-26 14:09:21','2023-01-03 21:54:53','2023-01-03 21:54:53'),(1779,7938,306,40721,3183,3,500,1,87341.81,NULL,'2022-12-26 14:09:21','2023-01-03 21:54:53','2023-01-03 21:54:53'),(1780,7938,306,40721,3183,3,64,1,4531.70,NULL,'2022-12-26 14:09:21','2023-01-03 21:54:53','2023-01-03 21:54:53'),(1781,7938,306,40721,3183,3,396,1,2826.00,NULL,'2022-12-26 14:09:21','2023-01-03 21:54:53','2023-01-03 21:54:53'),(1782,7938,306,40721,3183,3,502,1,293948.56,NULL,'2022-12-26 14:09:21','2023-01-03 21:54:53','2023-01-03 21:54:53'),(1783,7938,306,40721,3183,3,74,1,25060.57,NULL,'2022-12-26 14:09:21','2023-01-03 21:54:53','2023-01-03 21:54:53'),(1784,7938,306,40721,3183,3,78,1,52.39,NULL,'2022-12-26 14:09:21','2023-01-03 21:54:53','2023-01-03 21:54:53'),(1785,7938,306,40721,3183,3,503,1,22826.54,NULL,'2022-12-26 14:09:21','2023-01-03 21:54:53','2023-01-03 21:54:53'),(1786,7938,306,40721,3183,3,135,1,16993.53,NULL,'2022-12-26 14:09:21','2023-01-03 21:54:53','2023-01-03 21:54:53'),(1787,7938,306,40721,3183,3,25,1,678.24,NULL,'2022-12-26 14:09:21','2023-01-03 21:54:53','2023-01-03 21:54:53'),(1788,7938,306,40721,3183,3,504,1,2546.66,NULL,'2022-12-26 14:09:21','2023-01-03 21:54:53','2023-01-03 21:54:53'),(1789,7938,306,40721,3183,3,486,1,1085.52,NULL,'2022-12-26 14:09:21','2023-01-03 21:54:53','2023-01-03 21:54:53'),(1790,7938,306,40721,3183,3,157,1,9983.80,NULL,'2022-12-26 14:09:21','2023-01-03 21:54:53','2023-01-03 21:54:53'),(1791,7938,306,40721,3183,3,425,2,776419.82,NULL,'2022-12-26 14:09:21','2023-01-03 21:54:53','2023-01-03 21:54:53'),(1792,7938,307,40721,3184,3,68,1,12748.33,NULL,'2022-12-26 14:12:35','2023-01-03 22:00:04','2023-01-03 22:00:04'),(1793,7938,307,40721,3184,3,62,1,210646.00,NULL,'2022-12-26 14:12:35','2023-01-03 22:00:04','2023-01-03 22:00:04'),(1794,7938,307,40721,3184,3,500,1,90350.12,NULL,'2022-12-26 14:12:35','2023-01-03 22:00:04','2023-01-03 22:00:04'),(1795,7938,307,40721,3184,3,64,1,7865.00,NULL,'2022-12-26 14:12:35','2023-01-03 22:00:04','2023-01-03 22:00:04'),(1796,7938,307,40721,3184,3,396,1,2826.00,NULL,'2022-12-26 14:12:35','2023-01-03 22:00:04','2023-01-03 22:00:04'),(1797,7938,307,40721,3184,3,502,1,336098.26,NULL,'2022-12-26 14:12:35','2023-01-03 22:00:04','2023-01-03 22:00:04');
INSERT INTO `balance_libro_details` VALUES (1798,7938,307,40721,3184,3,78,1,116.32,NULL,'2022-12-26 14:12:35','2023-01-03 22:00:04','2023-01-03 22:00:04'),(1799,7938,307,40721,3184,3,503,1,22494.74,NULL,'2022-12-26 14:12:35','2023-01-03 22:00:04','2023-01-03 22:00:04'),(1800,7938,307,40721,3184,3,135,1,76411.80,NULL,'2022-12-26 14:12:35','2023-01-03 22:00:04','2023-01-03 22:00:04'),(1801,7938,307,40721,3184,3,25,1,794.56,NULL,'2022-12-26 14:12:35','2023-01-03 22:00:04','2023-01-03 22:00:04'),(1802,7938,307,40721,3184,3,504,1,2284.85,NULL,'2022-12-26 14:12:35','2023-01-03 22:00:04','2023-01-03 22:00:04'),(1803,7938,307,40721,3184,3,486,1,1029.28,NULL,'2022-12-26 14:12:35','2023-01-03 22:00:04','2023-01-03 22:00:04'),(1804,7938,307,40721,3184,3,157,1,9648.43,NULL,'2022-12-26 14:12:35','2023-01-03 22:00:04','2023-01-03 22:00:04'),(1805,7938,307,40721,3184,3,425,2,773313.69,NULL,'2022-12-26 14:12:35','2023-01-03 22:00:04','2023-01-03 22:00:04'),(1806,7938,308,40721,3185,3,68,1,11013.64,NULL,'2022-12-26 14:15:12','2023-01-03 22:53:38','2023-01-03 22:53:38'),(1807,7938,308,40721,3185,3,62,1,226220.00,NULL,'2022-12-26 14:15:12','2023-01-03 22:53:38','2023-01-03 22:53:38'),(1808,7938,308,40721,3185,3,500,1,87450.80,NULL,'2022-12-26 14:15:12','2023-01-03 22:53:38','2023-01-03 22:53:38'),(1809,7938,308,40721,3185,3,64,1,7710.00,NULL,'2022-12-26 14:15:12','2023-01-03 22:53:38','2023-01-03 22:53:38'),(1810,7938,308,40721,3185,3,396,1,2826.00,NULL,'2022-12-26 14:15:12','2023-01-03 22:53:38','2023-01-03 22:53:38'),(1811,7938,308,40721,3185,3,502,1,374344.93,NULL,'2022-12-26 14:15:12','2023-01-03 22:53:38','2023-01-03 22:53:38'),(1812,7938,308,40721,3185,3,74,1,172.08,NULL,'2022-12-26 14:15:12','2023-01-03 22:53:38','2023-01-03 22:53:38'),(1813,7938,308,40721,3185,3,78,1,41.92,NULL,'2022-12-26 14:15:12','2023-01-03 22:53:38','2023-01-03 22:53:38'),(1814,7938,308,40721,3185,3,503,1,21001.80,NULL,'2022-12-26 14:15:12','2023-01-03 22:53:38','2023-01-03 22:53:38'),(1815,7938,308,40721,3185,3,135,1,61576.06,NULL,'2022-12-26 14:15:12','2023-01-03 22:53:38','2023-01-03 22:53:38'),(1816,7938,308,40721,3185,3,25,1,506.16,NULL,'2022-12-26 14:15:12','2023-01-03 22:53:38','2023-01-03 22:53:38'),(1817,7938,308,40721,3185,3,504,1,1944.93,NULL,'2022-12-26 14:15:12','2023-01-03 22:53:38','2023-01-03 22:53:38'),(1818,7938,308,40721,3185,3,486,1,1002.96,NULL,'2022-12-26 14:15:12','2023-01-03 22:53:38','2023-01-03 22:53:38'),(1819,7938,308,40721,3185,3,157,1,11261.97,NULL,'2022-12-26 14:15:12','2023-01-03 22:53:38','2023-01-03 22:53:38'),(1820,7938,308,40721,3185,3,425,2,807073.25,NULL,'2022-12-26 14:15:12','2023-01-03 22:53:38','2023-01-03 22:53:38'),(1821,7938,309,40721,3186,3,68,1,13965.90,NULL,'2022-12-26 14:17:57','2023-01-03 22:29:28','2023-01-03 22:29:28'),(1822,7938,309,40721,3186,3,62,1,324400.00,NULL,'2022-12-26 14:17:57','2023-01-03 22:29:28','2023-01-03 22:29:28'),(1823,7938,309,40721,3186,3,499,1,45000.00,NULL,'2022-12-26 14:17:57','2023-01-03 22:29:28','2023-01-03 22:29:28'),(1824,7938,309,40721,3186,3,500,1,89955.84,NULL,'2022-12-26 14:17:57','2023-01-03 22:29:28','2023-01-03 22:29:28'),(1825,7938,309,40721,3186,3,64,1,6833.52,NULL,'2022-12-26 14:17:57','2023-01-03 22:29:28','2023-01-03 22:29:28'),(1826,7938,309,40721,3186,3,396,1,2826.00,NULL,'2022-12-26 14:17:57','2023-01-03 22:29:28','2023-01-03 22:29:28'),(1827,7938,309,40721,3186,3,502,1,376927.78,NULL,'2022-12-26 14:17:57','2023-01-03 22:29:28','2023-01-03 22:29:28'),(1828,7938,309,40721,3186,3,74,1,41127.73,NULL,'2022-12-26 14:17:57','2023-01-03 22:29:28','2023-01-03 22:29:28'),(1829,7938,309,40721,3186,3,78,1,22135.82,NULL,'2022-12-26 14:17:57','2023-01-03 22:29:28','2023-01-03 22:29:28'),(1830,7938,309,40721,3186,3,503,1,19946.76,NULL,'2022-12-26 14:17:57','2023-01-03 22:29:28','2023-01-03 22:29:28'),(1831,7938,309,40721,3186,3,135,1,42457.73,NULL,'2022-12-26 14:17:57','2023-01-03 22:29:28','2023-01-03 22:29:28'),(1832,7938,309,40721,3186,3,25,1,678.24,NULL,'2022-12-26 14:17:57','2023-01-03 22:29:28','2023-01-03 22:29:28');
INSERT INTO `balance_libro_details` VALUES (1833,7938,309,40721,3186,3,504,1,2887.58,NULL,'2022-12-26 14:17:57','2023-01-03 22:29:28','2023-01-03 22:29:28'),(1834,7938,309,40721,3186,3,486,1,1406.37,NULL,'2022-12-26 14:17:57','2023-01-03 22:29:28','2023-01-03 22:29:28'),(1835,7938,309,40721,3186,3,157,1,11794.58,NULL,'2022-12-26 14:17:57','2023-01-03 22:29:28','2023-01-03 22:29:28'),(1836,7938,309,40721,3186,3,425,2,1002343.85,NULL,'2022-12-26 14:17:57','2023-01-03 22:29:28','2023-01-03 22:29:28'),(1837,7938,310,40721,3190,3,68,1,10763.04,NULL,'2022-12-26 14:21:17','2023-01-03 22:53:06','2023-01-03 22:53:06'),(1838,7938,310,40721,3190,3,62,1,247649.00,NULL,'2022-12-26 14:21:17','2023-01-03 22:53:06','2023-01-03 22:53:06'),(1839,7938,310,40721,3190,3,500,1,139496.40,NULL,'2022-12-26 14:21:17','2023-01-03 22:53:06','2023-01-03 22:53:06'),(1840,7938,310,40721,3190,3,64,1,11264.00,NULL,'2022-12-26 14:21:17','2023-01-03 22:53:06','2023-01-03 22:53:06'),(1841,7938,310,40721,3190,3,396,1,2826.00,NULL,'2022-12-26 14:21:17','2023-01-03 22:53:06','2023-01-03 22:53:06'),(1842,7938,310,40721,3190,3,502,1,369432.36,NULL,'2022-12-26 14:21:17','2023-01-03 22:53:06','2023-01-03 22:53:06'),(1843,7938,310,40721,3190,3,74,1,40727.36,NULL,'2022-12-26 14:21:17','2023-01-03 22:53:06','2023-01-03 22:53:06'),(1844,7938,310,40721,3190,3,78,1,30089.78,NULL,'2022-12-26 14:21:17','2023-01-03 22:53:06','2023-01-03 22:53:06'),(1845,7938,310,40721,3190,3,503,1,22052.89,NULL,'2022-12-26 14:21:17','2023-01-03 22:53:06','2023-01-03 22:53:06'),(1846,7938,310,40721,3190,3,135,1,35210.31,NULL,'2022-12-26 14:21:17','2023-01-03 22:53:06','2023-01-03 22:53:06'),(1847,7938,310,40721,3190,3,25,1,678.24,NULL,'2022-12-26 14:21:17','2023-01-03 22:53:06','2023-01-03 22:53:06'),(1848,7938,310,40721,3190,3,504,1,3371.60,NULL,'2022-12-26 14:21:17','2023-01-03 22:53:06','2023-01-03 22:53:06'),(1849,7938,310,40721,3190,3,486,1,7461.69,NULL,'2022-12-26 14:21:17','2023-01-03 22:53:06','2023-01-03 22:53:06'),(1850,7938,310,40721,3190,3,157,1,10386.76,NULL,'2022-12-26 14:21:17','2023-01-03 22:53:06','2023-01-03 22:53:06'),(1851,7938,310,40721,3190,3,425,2,931409.43,NULL,'2022-12-26 14:21:17','2023-01-03 22:53:06','2023-01-03 22:53:06'),(1852,7938,311,40721,3191,3,68,1,7338.66,NULL,'2022-12-26 14:25:18','2023-01-03 22:05:10','2023-01-03 22:05:10'),(1853,7938,311,40721,3191,3,62,1,268301.00,NULL,'2022-12-26 14:25:18','2023-01-03 22:05:10','2023-01-03 22:05:10'),(1854,7938,311,40721,3191,3,500,1,111607.52,NULL,'2022-12-26 14:25:18','2023-01-03 22:05:10','2023-01-03 22:05:10'),(1855,7938,311,40721,3191,3,64,1,7536.47,NULL,'2022-12-26 14:25:18','2023-01-03 22:05:10','2023-01-03 22:05:10'),(1856,7938,311,40721,3191,3,396,1,3000.00,NULL,'2022-12-26 14:25:18','2023-01-03 22:05:10','2023-01-03 22:05:10'),(1857,7938,311,40721,3191,3,502,1,438026.11,NULL,'2022-12-26 14:25:18','2023-01-03 22:05:10','2023-01-03 22:05:10'),(1858,7938,311,40721,3191,3,74,1,43527.39,NULL,'2022-12-26 14:25:18','2023-01-03 22:05:10','2023-01-03 22:05:10'),(1859,7938,311,40721,3191,3,78,1,28722.75,NULL,'2022-12-26 14:25:18','2023-01-03 22:05:10','2023-01-03 22:05:10'),(1860,7938,311,40721,3191,3,503,1,23115.62,NULL,'2022-12-26 14:25:18','2023-01-03 22:05:10','2023-01-03 22:05:10'),(1861,7938,311,40721,3191,3,135,1,9222.14,NULL,'2022-12-26 14:25:18','2023-01-03 22:05:10','2023-01-03 22:05:10'),(1862,7938,311,40721,3191,3,25,1,720.00,NULL,'2022-12-26 14:25:18','2023-01-03 22:05:10','2023-01-03 22:05:10'),(1863,7938,311,40721,3191,3,504,1,2372.86,NULL,'2022-12-26 14:25:18','2023-01-03 22:05:10','2023-01-03 22:05:10'),(1864,7938,311,40721,3191,3,486,1,7373.56,NULL,'2022-12-26 14:25:18','2023-01-03 22:05:10','2023-01-03 22:05:10'),(1865,7938,311,40721,3191,3,157,1,11914.21,NULL,'2022-12-26 14:25:18','2023-01-03 22:05:10','2023-01-03 22:05:10'),(1866,7938,311,40721,3191,3,505,1,30000.00,NULL,'2022-12-26 14:25:18','2023-01-03 22:05:10','2023-01-03 22:05:10'),(1867,7938,311,40721,3191,3,425,2,992778.29,NULL,'2022-12-26 14:25:18','2023-01-03 22:05:10','2023-01-03 22:05:10');
INSERT INTO `balance_libro_details` VALUES (1868,7938,312,40721,3192,3,68,1,16359.97,NULL,'2022-12-26 14:28:01','2023-01-03 22:52:33','2023-01-03 22:52:33'),(1869,7938,312,40721,3192,3,62,1,287074.00,NULL,'2022-12-26 14:28:01','2023-01-03 22:52:33','2023-01-03 22:52:33'),(1870,7938,312,40721,3192,3,500,1,114857.37,NULL,'2022-12-26 14:28:01','2023-01-03 22:52:33','2023-01-03 22:52:33'),(1871,7938,312,40721,3192,3,64,1,1222.89,NULL,'2022-12-26 14:28:01','2023-01-03 22:52:33','2023-01-03 22:52:33'),(1872,7938,312,40721,3192,3,396,1,3000.00,NULL,'2022-12-26 14:28:01','2023-01-03 22:52:33','2023-01-03 22:52:33'),(1873,7938,312,40721,3192,3,502,1,469345.46,NULL,'2022-12-26 14:28:01','2023-01-03 22:52:33','2023-01-03 22:52:33'),(1874,7938,312,40721,3192,3,74,1,50562.82,NULL,'2022-12-26 14:28:01','2023-01-03 22:52:33','2023-01-03 22:52:33'),(1875,7938,312,40721,3192,3,78,1,30070.06,NULL,'2022-12-26 14:28:01','2023-01-03 22:52:33','2023-01-03 22:52:33'),(1876,7938,312,40721,3192,3,503,1,22886.98,NULL,'2022-12-26 14:28:01','2023-01-03 22:52:33','2023-01-03 22:52:33'),(1877,7938,312,40721,3192,3,135,1,32269.24,NULL,'2022-12-26 14:28:01','2023-01-03 22:52:33','2023-01-03 22:52:33'),(1878,7938,312,40721,3192,3,25,1,720.00,NULL,'2022-12-26 14:28:01','2023-01-03 22:52:33','2023-01-03 22:52:33'),(1879,7938,312,40721,3192,3,504,1,3912.48,NULL,'2022-12-26 14:28:01','2023-01-03 22:52:33','2023-01-03 22:52:33'),(1880,7938,312,40721,3192,3,486,1,8835.21,NULL,'2022-12-26 14:28:01','2023-01-03 22:52:33','2023-01-03 22:52:33'),(1881,7938,312,40721,3192,3,157,1,13497.22,NULL,'2022-12-26 14:28:01','2023-01-03 22:52:33','2023-01-03 22:52:33'),(1882,7938,312,40721,3192,3,425,2,1054613.70,NULL,'2022-12-26 14:28:01','2023-01-03 22:52:33','2023-01-03 22:52:33'),(1883,7938,313,40721,3193,3,68,1,76398.84,NULL,'2022-12-26 14:31:12','2023-01-03 22:51:57','2023-01-03 22:51:57'),(1884,7938,313,40721,3193,3,62,1,309933.00,NULL,'2022-12-26 14:31:12','2023-01-03 22:51:57','2023-01-03 22:51:57'),(1885,7938,313,40721,3193,3,500,1,114680.63,NULL,'2022-12-26 14:31:12','2023-01-03 22:51:57','2023-01-03 22:51:57'),(1886,7938,313,40721,3193,3,396,1,3000.00,NULL,'2022-12-26 14:31:12','2023-01-03 22:51:57','2023-01-03 22:51:57'),(1887,7938,313,40721,3193,3,502,1,528524.53,NULL,'2022-12-26 14:31:12','2023-01-03 22:51:57','2023-01-03 22:51:57'),(1888,7938,313,40721,3193,3,74,1,51473.76,NULL,'2022-12-26 14:31:12','2023-01-03 22:51:57','2023-01-03 22:51:57'),(1889,7938,313,40721,3193,3,78,1,34505.54,NULL,'2022-12-26 14:31:12','2023-01-03 22:51:57','2023-01-03 22:51:57'),(1890,7938,313,40721,3193,3,503,1,23981.40,NULL,'2022-12-26 14:31:12','2023-01-03 22:51:57','2023-01-03 22:51:57'),(1891,7938,313,40721,3193,3,135,1,62838.97,NULL,'2022-12-26 14:31:12','2023-01-03 22:51:57','2023-01-03 22:51:57'),(1892,7938,313,40721,3193,3,25,1,720.00,NULL,'2022-12-26 14:31:12','2023-01-03 22:51:57','2023-01-03 22:51:57'),(1893,7938,313,40721,3193,3,504,1,2927.83,NULL,'2022-12-26 14:31:12','2023-01-03 22:51:57','2023-01-03 22:51:57'),(1894,7938,313,40721,3193,3,486,1,10225.37,NULL,'2022-12-26 14:31:12','2023-01-03 22:51:57','2023-01-03 22:51:57'),(1895,7938,313,40721,3193,3,157,1,17543.38,NULL,'2022-12-26 14:31:12','2023-01-03 22:51:57','2023-01-03 22:51:57'),(1896,7938,313,40721,3193,3,425,2,1236753.25,NULL,'2022-12-26 14:31:12','2023-01-03 22:51:57','2023-01-03 22:51:57'),(1897,7938,314,40721,3194,3,68,1,84219.91,NULL,'2022-12-26 14:34:03','2023-01-03 22:50:52','2023-01-03 22:50:52'),(1898,7938,314,40721,3194,3,62,1,406166.00,NULL,'2022-12-26 14:34:03','2023-01-03 22:50:52','2023-01-03 22:50:52'),(1899,7938,314,40721,3194,3,500,1,139141.52,NULL,'2022-12-26 14:34:03','2023-01-03 22:50:52','2023-01-03 22:50:52'),(1900,7938,314,40721,3194,3,64,1,24797.39,NULL,'2022-12-26 14:34:03','2023-01-03 22:50:52','2023-01-03 22:50:52'),(1901,7938,314,40721,3194,3,396,1,3000.00,NULL,'2022-12-26 14:34:03','2023-01-03 22:50:52','2023-01-03 22:50:52'),(1902,7938,314,40721,3194,3,502,1,523829.98,NULL,'2022-12-26 14:34:03','2023-01-03 22:50:52','2023-01-03 22:50:52');
INSERT INTO `balance_libro_details` VALUES (1903,7938,314,40721,3194,3,78,1,37195.96,NULL,'2022-12-26 14:34:03','2023-01-03 22:50:52','2023-01-03 22:50:52'),(1904,7938,314,40721,3194,3,503,1,22804.79,NULL,'2022-12-26 14:34:03','2023-01-03 22:50:52','2023-01-03 22:50:52'),(1905,7938,314,40721,3194,3,135,1,51276.00,NULL,'2022-12-26 14:34:03','2023-01-03 22:50:52','2023-01-03 22:50:52'),(1906,7938,314,40721,3194,3,25,1,90.00,NULL,'2022-12-26 14:34:03','2023-01-03 22:50:52','2023-01-03 22:50:52'),(1907,7938,314,40721,3194,3,504,1,4255.83,NULL,'2022-12-26 14:34:03','2023-01-03 22:50:52','2023-01-03 22:50:52'),(1908,7938,314,40721,3194,3,486,1,9255.30,NULL,'2022-12-26 14:34:03','2023-01-03 22:50:52','2023-01-03 22:50:52'),(1909,7938,314,40721,3194,3,157,1,14578.09,NULL,'2022-12-26 14:34:03','2023-01-03 22:50:52','2023-01-03 22:50:52'),(1910,7938,314,40721,3194,3,425,2,1320610.77,NULL,'2022-12-26 14:34:03','2023-01-03 22:50:52','2023-01-03 22:50:52'),(1911,7938,315,40721,3195,3,68,1,91871.68,NULL,'2022-12-26 14:38:14','2023-01-03 22:50:26','2023-01-03 22:50:26'),(1912,7938,315,40721,3195,3,62,1,321251.00,NULL,'2022-12-26 14:38:14','2023-01-03 22:50:26','2023-01-03 22:50:26'),(1913,7938,315,40721,3195,3,500,1,160696.54,NULL,'2022-12-26 14:38:14','2023-01-03 22:50:26','2023-01-03 22:50:26'),(1914,7938,315,40721,3195,3,64,1,9517.00,NULL,'2022-12-26 14:38:14','2023-01-03 22:50:26','2023-01-03 22:50:26'),(1915,7938,315,40721,3195,3,396,1,3000.00,NULL,'2022-12-26 14:38:14','2023-01-03 22:50:26','2023-01-03 22:50:26'),(1916,7938,315,40721,3195,3,502,1,542949.36,NULL,'2022-12-26 14:38:14','2023-01-03 22:50:26','2023-01-03 22:50:26'),(1917,7938,315,40721,3195,3,78,1,33133.75,NULL,'2022-12-26 14:38:14','2023-01-03 22:50:26','2023-01-03 22:50:26'),(1918,7938,315,40721,3195,3,503,1,29678.17,NULL,'2022-12-26 14:38:14','2023-01-03 22:50:26','2023-01-03 22:50:26'),(1919,7938,315,40721,3195,3,135,1,63318.41,NULL,'2022-12-26 14:38:14','2023-01-03 22:50:26','2023-01-03 22:50:26'),(1920,7938,315,40721,3195,3,25,1,90.00,NULL,'2022-12-26 14:38:14','2023-01-03 22:50:26','2023-01-03 22:50:26'),(1921,7938,315,40721,3195,3,504,1,3800.07,NULL,'2022-12-26 14:38:14','2023-01-03 22:50:26','2023-01-03 22:50:26'),(1922,7938,315,40721,3195,3,486,1,10174.07,NULL,'2022-12-26 14:38:14','2023-01-03 22:50:26','2023-01-03 22:50:26'),(1923,7938,315,40721,3195,3,157,1,16618.60,NULL,'2022-12-26 14:38:14','2023-01-03 22:50:26','2023-01-03 22:50:26'),(1924,7938,315,40721,3195,3,505,1,2309.19,NULL,'2022-12-26 14:38:14','2023-01-03 22:50:26','2023-01-03 22:50:26'),(1925,7938,315,40721,3195,3,425,2,1455445.84,NULL,'2022-12-26 14:38:14','2023-01-03 22:50:26','2023-01-03 22:50:26'),(1926,7938,315,40721,3195,3,492,1,167038.00,NULL,'2022-12-26 14:38:14','2023-01-03 22:50:26','2023-01-03 22:50:26'),(1927,7938,316,40721,3197,3,68,1,204684.60,NULL,'2022-12-26 14:42:00','2023-01-03 22:49:42','2023-01-03 22:49:42'),(1928,7938,316,40721,3197,3,62,1,373093.95,NULL,'2022-12-26 14:42:00','2023-01-03 22:49:42','2023-01-03 22:49:42'),(1929,7938,316,40721,3197,3,500,1,128154.37,NULL,'2022-12-26 14:42:00','2023-01-03 22:49:42','2023-01-03 22:49:42'),(1930,7938,316,40721,3197,3,64,1,11257.20,NULL,'2022-12-26 14:42:00','2023-01-03 22:49:42','2023-01-03 22:49:42'),(1931,7938,316,40721,3197,3,396,1,4750.00,NULL,'2022-12-26 14:42:00','2023-01-03 22:49:42','2023-01-03 22:49:42'),(1932,7938,316,40721,3197,3,502,1,2192666.37,NULL,'2022-12-26 14:42:00','2023-01-03 22:49:42','2023-01-03 22:49:42'),(1933,7938,316,40721,3197,3,74,1,104182.20,NULL,'2022-12-26 14:42:00','2023-01-03 22:49:42','2023-01-03 22:49:42'),(1934,7938,316,40721,3197,3,78,1,88179.24,NULL,'2022-12-26 14:42:00','2023-01-03 22:49:42','2023-01-03 22:49:42'),(1935,7938,316,40721,3197,3,503,1,29877.91,NULL,'2022-12-26 14:42:00','2023-01-03 22:49:42','2023-01-03 22:49:42'),(1936,7938,316,40721,3197,3,135,1,163903.02,NULL,'2022-12-26 14:42:00','2023-01-03 22:49:42','2023-01-03 22:49:42'),(1937,7938,316,40721,3197,3,25,1,135.00,NULL,'2022-12-26 14:42:00','2023-01-03 22:49:42','2023-01-03 22:49:42');
INSERT INTO `balance_libro_details` VALUES (1938,7938,316,40721,3197,3,504,1,2825.30,NULL,'2022-12-26 14:42:00','2023-01-03 22:49:42','2023-01-03 22:49:42'),(1939,7938,316,40721,3197,3,486,1,30592.86,NULL,'2022-12-26 14:42:00','2023-01-03 22:49:42','2023-01-03 22:49:42'),(1940,7938,316,40721,3197,3,157,1,48953.12,NULL,'2022-12-26 14:42:00','2023-01-03 22:49:42','2023-01-03 22:49:42'),(1941,7938,316,40721,3197,3,425,2,3640145.14,NULL,'2022-12-26 14:42:00','2023-01-03 22:49:42','2023-01-03 22:49:42'),(1942,7938,316,40721,3197,3,492,1,256890.00,NULL,'2022-12-26 14:42:00','2023-01-03 22:49:42','2023-01-03 22:49:42'),(1943,7938,317,40721,3196,3,68,1,203982.54,NULL,'2022-12-26 14:45:56','2023-01-03 22:49:02','2023-01-03 22:49:02'),(1944,7938,317,40721,3196,3,62,1,317543.08,NULL,'2022-12-26 14:45:56','2023-01-03 22:49:02','2023-01-03 22:49:02'),(1945,7938,317,40721,3196,3,500,1,138245.67,NULL,'2022-12-26 14:45:56','2023-01-03 22:49:02','2023-01-03 22:49:02'),(1946,7938,317,40721,3196,3,64,1,9368.47,NULL,'2022-12-26 14:45:56','2023-01-03 22:49:02','2023-01-03 22:49:02'),(1947,7938,317,40721,3196,3,396,1,3500.00,NULL,'2022-12-26 14:45:56','2023-01-03 22:49:02','2023-01-03 22:49:02'),(1948,7938,317,40721,3196,3,502,1,1466969.57,NULL,'2022-12-26 14:45:56','2023-01-03 22:49:02','2023-01-03 22:49:02'),(1949,7938,317,40721,3196,3,78,1,39401.36,NULL,'2022-12-26 14:45:56','2023-01-03 22:49:02','2023-01-03 22:49:02'),(1950,7938,317,40721,3196,3,503,1,33422.24,NULL,'2022-12-26 14:45:56','2023-01-03 22:49:02','2023-01-03 22:49:02'),(1951,7938,317,40721,3196,3,135,1,52655.75,NULL,'2022-12-26 14:45:56','2023-01-03 22:49:02','2023-01-03 22:49:02'),(1952,7938,317,40721,3196,3,25,1,90.00,NULL,'2022-12-26 14:45:56','2023-01-03 22:49:02','2023-01-03 22:49:02'),(1953,7938,317,40721,3196,3,504,1,1861.09,NULL,'2022-12-26 14:45:56','2023-01-03 22:49:02','2023-01-03 22:49:02'),(1954,7938,317,40721,3196,3,486,1,21967.28,NULL,'2022-12-26 14:45:56','2023-01-03 22:49:02','2023-01-03 22:49:02'),(1955,7938,317,40721,3196,3,157,1,19683.92,NULL,'2022-12-26 14:45:56','2023-01-03 22:49:02','2023-01-03 22:49:02'),(1956,7938,317,40721,3196,3,425,2,2308690.97,NULL,'2022-12-26 14:45:56','2023-01-03 22:49:02','2023-01-03 22:49:02'),(1957,7938,318,40721,3193,2,386,1,600000.00,NULL,'2022-12-26 14:48:27','2022-12-26 14:48:27',NULL),(1958,7938,318,40721,3193,2,425,2,600000.00,NULL,'2022-12-26 14:48:27','2022-12-26 14:48:27',NULL),(1959,7938,319,40721,3194,2,386,1,21147.95,NULL,'2022-12-26 14:49:36','2023-01-03 21:12:59','2023-01-03 21:12:59'),(1960,7938,319,40721,3194,2,23,1,654.06,NULL,'2022-12-26 14:49:36','2023-01-03 21:12:59','2023-01-03 21:12:59'),(1961,7938,319,40721,3194,2,102,2,21802.01,NULL,'2022-12-26 14:49:36','2023-01-03 21:12:59','2023-01-03 21:12:59'),(1962,7938,320,40721,3195,2,386,1,25986.25,NULL,'2022-12-26 14:51:00','2023-01-03 21:12:41','2023-01-03 21:12:41'),(1963,7938,320,40721,3195,2,23,1,803.69,NULL,'2022-12-26 14:51:00','2023-01-03 21:12:41','2023-01-03 21:12:41'),(1964,7938,320,40721,3195,2,102,2,26789.94,NULL,'2022-12-26 14:51:00','2023-01-03 21:12:41','2023-01-03 21:12:41'),(1965,7938,321,40721,3196,2,386,1,25986.25,NULL,'2022-12-26 14:52:14','2023-01-03 21:12:22','2023-01-03 21:12:22'),(1966,7938,321,40721,3196,2,23,1,803.69,NULL,'2022-12-26 14:52:14','2023-01-03 21:12:22','2023-01-03 21:12:22'),(1967,7938,321,40721,3196,2,102,2,26789.94,NULL,'2022-12-26 14:52:14','2023-01-03 21:12:22','2023-01-03 21:12:22'),(1968,7938,322,40721,3197,2,386,1,28466.77,NULL,'2022-12-26 14:53:14','2023-01-03 21:12:05','2023-01-03 21:12:05'),(1969,7938,322,40721,3197,2,23,1,880.42,NULL,'2022-12-26 14:53:14','2023-01-03 21:12:05','2023-01-03 21:12:05'),(1970,7938,322,40721,3197,2,102,2,29347.19,NULL,'2022-12-26 14:53:14','2023-01-03 21:12:05','2023-01-03 21:12:05'),(1971,7938,323,40721,3183,3,506,1,6488.26,NULL,'2023-01-02 21:24:30','2023-01-03 22:59:36','2023-01-03 22:59:36'),(1972,7938,323,40721,3183,3,67,2,1126.06,NULL,'2023-01-02 21:24:30','2023-01-03 22:59:36','2023-01-03 22:59:36');
INSERT INTO `balance_libro_details` VALUES (1973,7938,323,40721,3183,3,507,2,5362.20,NULL,'2023-01-02 21:24:30','2023-01-03 22:59:36','2023-01-03 22:59:36'),(1974,7938,324,40721,3185,3,506,1,173.20,NULL,'2023-01-02 21:25:43','2023-01-02 21:25:43',NULL),(1975,7938,324,40721,3185,3,67,2,30.06,NULL,'2023-01-02 21:25:43','2023-01-02 21:25:43',NULL),(1976,7938,324,40721,3185,3,507,2,143.14,NULL,'2023-01-02 21:25:43','2023-01-02 21:25:43',NULL),(1977,7938,325,40721,3190,3,506,1,2597.99,NULL,'2023-01-02 21:26:52','2023-01-02 21:26:52',NULL),(1978,7938,325,40721,3190,3,67,2,450.89,NULL,'2023-01-02 21:26:52','2023-01-02 21:26:52',NULL),(1979,7938,325,40721,3190,3,507,2,2147.10,NULL,'2023-01-02 21:26:52','2023-01-02 21:26:52',NULL),(1980,7938,326,40721,3192,3,425,1,7103.93,NULL,'2023-01-02 21:27:56','2023-01-02 21:27:56',NULL),(1981,7938,326,40721,3192,3,67,2,1232.91,NULL,'2023-01-02 21:27:56','2023-01-02 21:27:56',NULL),(1982,7938,326,40721,3192,3,507,2,5871.02,NULL,'2023-01-02 21:27:56','2023-01-02 21:27:56',NULL),(1983,7938,327,40721,3195,3,425,1,714.45,NULL,'2023-01-02 21:29:03','2023-01-02 21:29:03',NULL),(1984,7938,327,40721,3195,3,67,2,124.00,NULL,'2023-01-02 21:29:03','2023-01-02 21:29:03',NULL),(1985,7938,327,40721,3195,3,507,2,590.45,NULL,'2023-01-02 21:29:03','2023-01-02 21:29:03',NULL),(1986,7938,328,40721,3196,3,506,1,2247.08,NULL,'2023-01-02 21:30:18','2023-01-03 14:06:24','2023-01-03 14:06:24'),(1987,7938,328,40721,3196,3,67,2,333.09,NULL,'2023-01-02 21:30:18','2023-01-03 14:06:24','2023-01-03 14:06:24'),(1988,7938,328,40721,3196,3,489,2,1913.99,NULL,'2023-01-02 21:30:18','2023-01-03 14:06:24','2023-01-03 14:06:24'),(1989,7938,329,40721,3197,3,425,1,24382.46,NULL,'2023-01-02 21:31:52','2023-01-03 16:54:36','2023-01-03 16:54:36'),(1990,7938,329,40721,3197,3,67,2,4223.40,NULL,'2023-01-02 21:31:52','2023-01-03 16:54:36','2023-01-03 16:54:36'),(1991,7938,329,40721,3197,3,507,2,20159.06,NULL,'2023-01-02 21:31:52','2023-01-03 16:54:36','2023-01-03 16:54:36'),(1992,7938,330,40721,3184,2,425,1,6488.26,NULL,'2023-01-02 21:33:24','2023-01-02 21:33:24',NULL),(1993,7938,330,40721,3184,2,506,2,6488.26,NULL,'2023-01-02 21:33:24','2023-01-02 21:33:24',NULL),(1994,7938,331,40721,3186,2,425,1,173.20,NULL,'2023-01-02 21:34:08','2023-01-02 21:34:08',NULL),(1995,7938,331,40721,3186,2,506,2,173.20,NULL,'2023-01-02 21:34:08','2023-01-02 21:34:08',NULL),(1996,7938,332,40721,3191,2,425,1,2597.99,NULL,'2023-01-02 21:34:56','2023-01-02 21:34:56',NULL),(1997,7938,332,40721,3191,2,506,2,2597.99,NULL,'2023-01-02 21:34:56','2023-01-02 21:34:56',NULL),(1998,7938,333,40721,3197,2,425,1,1924.05,NULL,'2023-01-02 21:36:36','2023-01-03 16:50:04','2023-01-03 16:50:04'),(1999,7938,333,40721,3197,2,506,2,1924.05,NULL,'2023-01-02 21:36:36','2023-01-03 16:50:04','2023-01-03 16:50:04'),(2000,7938,334,40721,3183,2,425,1,1089.00,NULL,'2023-01-02 21:39:50','2023-01-02 21:39:50',NULL),(2001,7938,334,40721,3183,2,508,2,900.00,NULL,'2023-01-02 21:39:50','2023-01-02 21:39:50',NULL),(2002,7938,334,40721,3183,2,67,2,189.00,NULL,'2023-01-02 21:39:50','2023-01-02 21:39:50',NULL),(2003,7938,335,40721,3185,2,425,1,544.50,NULL,'2023-01-02 21:42:46','2023-01-03 14:15:13','2023-01-03 14:15:13'),(2004,7938,335,40721,3185,2,508,2,450.00,NULL,'2023-01-02 21:42:46','2023-01-03 14:15:13','2023-01-03 14:15:13'),(2005,7938,335,40721,3185,2,67,2,94.50,NULL,'2023-01-02 21:42:46','2023-01-03 14:15:13','2023-01-03 14:15:13'),(2006,7938,336,40721,3183,2,425,1,798839.50,NULL,'2023-01-02 21:51:25','2023-01-03 12:42:59','2023-01-03 12:42:59'),(2007,7938,336,40721,3183,2,23,1,14951.88,NULL,'2023-01-02 21:51:25','2023-01-03 12:42:59','2023-01-03 12:42:59'),(2008,7938,336,40721,3183,2,162,1,8147.64,NULL,'2023-01-02 21:51:25','2023-01-03 12:42:59','2023-01-03 12:42:59'),(2009,7938,336,40721,3183,2,25,1,136880.34,NULL,'2023-01-02 21:51:25','2023-01-03 12:42:59','2023-01-03 12:42:59'),(2010,7938,336,40721,3183,2,486,1,16797.35,NULL,'2023-01-02 21:51:25','2023-01-03 12:42:59','2023-01-03 12:42:59');
INSERT INTO `balance_libro_details` VALUES (2011,7938,336,40721,3183,2,157,1,10247.67,NULL,'2023-01-02 21:51:25','2023-01-03 12:42:59','2023-01-03 12:42:59'),(2012,7938,336,40721,3183,2,509,2,814764.38,NULL,'2023-01-02 21:51:25','2023-01-03 12:42:59','2023-01-03 12:42:59'),(2013,7938,336,40721,3183,2,67,2,171100.00,NULL,'2023-01-02 21:51:25','2023-01-03 12:42:59','2023-01-03 12:42:59'),(2014,7938,337,40721,3184,2,425,1,847275.47,NULL,'2023-01-02 21:53:14','2023-01-03 12:42:28','2023-01-03 12:42:28'),(2015,7938,337,40721,3184,2,23,1,15932.30,NULL,'2023-01-02 21:53:14','2023-01-03 12:42:28','2023-01-03 12:42:28'),(2016,7938,337,40721,3184,2,162,1,8637.85,NULL,'2023-01-02 21:53:14','2023-01-03 12:42:28','2023-01-03 12:42:28'),(2017,7938,337,40721,3184,2,25,1,145115.88,NULL,'2023-01-02 21:53:14','2023-01-03 12:42:28','2023-01-03 12:42:28'),(2018,7938,337,40721,3184,2,486,1,16818.64,NULL,'2023-01-02 21:53:14','2023-01-03 12:42:28','2023-01-03 12:42:28'),(2019,7938,337,40721,3184,2,157,1,11399.86,NULL,'2023-01-02 21:53:14','2023-01-03 12:42:28','2023-01-03 12:42:28'),(2020,7938,337,40721,3184,2,509,2,863785.00,NULL,'2023-01-02 21:53:14','2023-01-03 12:42:28','2023-01-03 12:42:28'),(2021,7938,337,40721,3184,2,67,2,181395.00,NULL,'2023-01-02 21:53:14','2023-01-03 12:42:28','2023-01-03 12:42:28'),(2022,7938,338,40721,3185,2,425,1,815442.81,NULL,'2023-01-02 21:54:45','2023-01-03 12:41:33','2023-01-03 12:41:33'),(2023,7938,338,40721,3185,2,23,1,15031.17,NULL,'2023-01-02 21:54:45','2023-01-03 12:41:33','2023-01-03 12:41:33'),(2024,7938,338,40721,3185,2,162,1,8187.29,NULL,'2023-01-02 21:54:45','2023-01-03 12:41:33','2023-01-03 12:41:33'),(2025,7938,338,40721,3185,2,25,1,138352.42,NULL,'2023-01-02 21:54:45','2023-01-03 12:41:33','2023-01-03 12:41:33'),(2026,7938,338,40721,3185,2,486,1,16196.18,NULL,'2023-01-02 21:54:45','2023-01-03 12:41:33','2023-01-03 12:41:33'),(2027,7938,338,40721,3185,2,157,1,3259.83,NULL,'2023-01-02 21:54:45','2023-01-03 12:41:33','2023-01-03 12:41:33'),(2028,7938,338,40721,3185,2,509,2,823528.70,NULL,'2023-01-02 21:54:45','2023-01-03 12:41:33','2023-01-03 12:41:33'),(2029,7938,338,40721,3185,2,67,2,172941.00,NULL,'2023-01-02 21:54:45','2023-01-03 12:41:33','2023-01-03 12:41:33'),(2030,7938,339,40721,3186,2,425,1,794022.53,NULL,'2023-01-02 21:56:11','2023-01-03 12:41:02','2023-01-03 12:41:02'),(2031,7938,339,40721,3186,2,23,1,15030.34,NULL,'2023-01-02 21:56:11','2023-01-03 12:41:02','2023-01-03 12:41:02'),(2032,7938,339,40721,3186,2,162,1,8186.87,NULL,'2023-01-02 21:56:11','2023-01-03 12:41:02','2023-01-03 12:41:02'),(2033,7938,339,40721,3186,2,25,1,137539.39,NULL,'2023-01-02 21:56:11','2023-01-03 12:41:02','2023-01-03 12:41:02'),(2034,7938,339,40721,3186,2,486,1,16198.71,NULL,'2023-01-02 21:56:11','2023-01-03 12:41:02','2023-01-03 12:41:02'),(2035,7938,339,40721,3186,2,157,1,19633.16,NULL,'2023-01-02 21:56:11','2023-01-03 12:41:02','2023-01-03 12:41:02'),(2036,7938,339,40721,3186,2,509,2,818686.90,NULL,'2023-01-02 21:56:11','2023-01-03 12:41:02','2023-01-03 12:41:02'),(2037,7938,339,40721,3186,2,67,2,171924.10,NULL,'2023-01-02 21:56:11','2023-01-03 12:41:02','2023-01-03 12:41:02'),(2038,7938,340,40721,3191,2,425,1,943452.93,NULL,'2023-01-02 21:57:58','2023-01-03 12:40:37','2023-01-03 12:40:37'),(2039,7938,340,40721,3191,2,23,1,17754.30,NULL,'2023-01-02 21:57:58','2023-01-03 12:40:37','2023-01-03 12:40:37'),(2040,7938,340,40721,3191,2,162,1,9548.85,NULL,'2023-01-02 21:57:58','2023-01-03 12:40:37','2023-01-03 12:40:37'),(2041,7938,340,40721,3191,2,25,1,161428.71,NULL,'2023-01-02 21:57:58','2023-01-03 12:40:37','2023-01-03 12:40:37'),(2042,7938,340,40721,3191,2,486,1,17605.85,NULL,'2023-01-02 21:57:58','2023-01-03 12:40:37','2023-01-03 12:40:37'),(2043,7938,340,40721,3191,2,157,1,12880.56,NULL,'2023-01-02 21:57:58','2023-01-03 12:40:37','2023-01-03 12:40:37'),(2044,7938,340,40721,3191,2,509,2,960885.20,NULL,'2023-01-02 21:57:58','2023-01-03 12:40:37','2023-01-03 12:40:37');
INSERT INTO `balance_libro_details` VALUES (2045,7938,340,40721,3191,2,67,2,201786.00,NULL,'2023-01-02 21:57:58','2023-01-03 12:40:37','2023-01-03 12:40:37'),(2046,7938,341,40721,3192,2,425,1,1082252.40,NULL,'2023-01-02 22:03:36','2023-01-03 12:40:11','2023-01-03 12:40:11'),(2047,7938,341,40721,3192,2,23,1,20689.65,NULL,'2023-01-02 22:03:36','2023-01-03 12:40:11','2023-01-03 12:40:11'),(2048,7938,341,40721,3192,2,162,1,11016.53,NULL,'2023-01-02 22:03:36','2023-01-03 12:40:11','2023-01-03 12:40:11'),(2049,7938,341,40721,3192,2,25,1,185077.60,NULL,'2023-01-02 22:03:36','2023-01-03 12:40:11','2023-01-03 12:40:11'),(2050,7938,341,40721,3192,2,486,1,19688.35,NULL,'2023-01-02 22:03:36','2023-01-03 12:40:11','2023-01-03 12:40:11'),(2051,7938,341,40721,3192,2,157,1,14275.51,NULL,'2023-01-02 22:03:36','2023-01-03 12:40:11','2023-01-03 12:40:11'),(2052,7938,341,40721,3192,2,509,2,1101653.04,NULL,'2023-01-02 22:03:36','2023-01-03 12:40:11','2023-01-03 12:40:11'),(2053,7938,341,40721,3192,2,67,2,231347.00,NULL,'2023-01-02 22:03:36','2023-01-03 12:40:11','2023-01-03 12:40:11'),(2054,7938,342,40721,3195,2,425,1,1324598.31,NULL,'2023-01-02 22:06:20','2023-01-03 12:39:37','2023-01-03 12:39:37'),(2055,7938,342,40721,3195,2,23,1,25662.03,NULL,'2023-01-02 22:06:20','2023-01-03 12:39:37','2023-01-03 12:39:37'),(2056,7938,342,40721,3195,2,162,1,13502.71,NULL,'2023-01-02 22:06:20','2023-01-03 12:39:37','2023-01-03 12:39:37'),(2057,7938,342,40721,3195,2,25,1,226845.60,NULL,'2023-01-02 22:06:20','2023-01-03 12:39:37','2023-01-03 12:39:37'),(2058,7938,342,40721,3195,2,486,1,26458.01,NULL,'2023-01-02 22:06:20','2023-01-03 12:39:37','2023-01-03 12:39:37'),(2059,7938,342,40721,3195,2,157,1,16761.72,NULL,'2023-01-02 22:06:20','2023-01-03 12:39:37','2023-01-03 12:39:37'),(2060,7938,342,40721,3195,2,509,2,1350271.38,NULL,'2023-01-02 22:06:20','2023-01-03 12:39:37','2023-01-03 12:39:37'),(2061,7938,342,40721,3195,2,67,2,283557.00,NULL,'2023-01-02 22:06:20','2023-01-03 12:39:37','2023-01-03 12:39:37'),(2062,7938,343,40721,3197,2,425,1,1550461.75,NULL,'2023-01-02 22:08:25','2023-01-03 12:39:11','2023-01-03 12:39:11'),(2063,7938,343,40721,3197,2,23,1,30185.40,NULL,'2023-01-02 22:08:25','2023-01-03 12:39:11','2023-01-03 12:39:11'),(2064,7938,343,40721,3197,2,162,1,15764.40,NULL,'2023-01-02 22:08:25','2023-01-03 12:39:11','2023-01-03 12:39:11'),(2065,7938,343,40721,3197,2,25,1,264841.90,NULL,'2023-01-02 22:08:25','2023-01-03 12:39:11','2023-01-03 12:39:11'),(2066,7938,343,40721,3197,2,486,1,30385.04,NULL,'2023-01-02 22:08:25','2023-01-03 12:39:11','2023-01-03 12:39:11'),(2067,7938,343,40721,3197,2,157,1,18364.40,NULL,'2023-01-02 22:08:25','2023-01-03 12:39:11','2023-01-03 12:39:11'),(2068,7938,343,40721,3197,2,509,2,1578514.78,NULL,'2023-01-02 22:08:25','2023-01-03 12:39:11','2023-01-03 12:39:11'),(2069,7938,343,40721,3197,2,67,2,331488.11,NULL,'2023-01-02 22:08:25','2023-01-03 12:39:11','2023-01-03 12:39:11'),(2070,7938,344,40721,3184,2,425,1,93834.79,NULL,'2023-01-02 22:13:37','2023-01-02 22:13:37',NULL),(2071,7938,344,40721,3184,2,23,1,617.53,NULL,'2023-01-02 22:13:37','2023-01-02 22:13:37',NULL),(2072,7938,344,40721,3184,2,486,1,3283.91,NULL,'2023-01-02 22:13:37','2023-01-02 22:13:37',NULL),(2073,7938,344,40721,3184,2,157,1,310.30,NULL,'2023-01-02 22:13:37','2023-01-02 22:13:37',NULL),(2074,7938,344,40721,3184,2,510,2,81030.19,NULL,'2023-01-02 22:13:37','2023-01-02 22:13:37',NULL),(2075,7938,344,40721,3184,2,67,2,17016.34,NULL,'2023-01-02 22:13:37','2023-01-02 22:13:37',NULL),(2076,7938,345,40721,3193,2,425,1,92065.41,NULL,'2023-01-02 22:15:54','2023-01-02 22:15:54',NULL),(2077,7938,345,40721,3193,2,23,1,593.88,NULL,'2023-01-02 22:15:54','2023-01-02 22:15:54',NULL),(2078,7938,345,40721,3193,2,486,1,3704.24,NULL,'2023-01-02 22:15:54','2023-01-02 22:15:54',NULL),(2079,7938,345,40721,3193,2,157,1,500.53,NULL,'2023-01-02 22:15:54','2023-01-02 22:15:54',NULL),(2080,7938,345,40721,3193,2,510,2,80052.96,NULL,'2023-01-02 22:15:54','2023-01-02 22:15:54',NULL);
INSERT INTO `balance_libro_details` VALUES (2081,7938,345,40721,3193,2,67,2,16811.10,NULL,'2023-01-02 22:15:54','2023-01-02 22:15:54',NULL),(2082,7938,346,40721,3195,2,425,1,87752.04,NULL,'2023-01-02 22:16:57','2023-01-02 22:16:57',NULL),(2083,7938,346,40721,3195,2,23,1,511.20,NULL,'2023-01-02 22:16:57','2023-01-02 22:16:57',NULL),(2084,7938,346,40721,3195,2,486,1,3870.25,NULL,'2023-01-02 22:16:57','2023-01-02 22:16:57',NULL),(2085,7938,346,40721,3195,2,157,1,596.32,NULL,'2023-01-02 22:16:57','2023-01-02 22:16:57',NULL),(2086,7938,346,40721,3195,2,510,2,76636.21,NULL,'2023-01-02 22:16:57','2023-01-02 22:16:57',NULL),(2087,7938,346,40721,3195,2,67,2,16093.60,NULL,'2023-01-02 22:16:57','2023-01-02 22:16:57',NULL),(2088,7938,347,40721,3196,2,425,1,1632403.00,NULL,'2023-01-02 22:20:11','2023-01-02 22:20:11',NULL),(2089,7938,347,40721,3196,2,23,1,32865.64,NULL,'2023-01-02 22:20:11','2023-01-02 22:20:11',NULL),(2090,7938,347,40721,3196,2,486,1,44437.63,NULL,'2023-01-02 22:20:11','2023-01-02 22:20:11',NULL),(2091,7938,347,40721,3196,2,157,1,745.96,NULL,'2023-01-02 22:20:11','2023-01-02 22:20:11',NULL),(2092,7938,347,40721,3196,2,510,2,1413596.93,NULL,'2023-01-02 22:20:11','2023-01-02 22:20:11',NULL),(2093,7938,347,40721,3196,2,67,2,296855.30,NULL,'2023-01-02 22:20:11','2023-01-02 22:20:11',NULL),(2094,7938,348,40721,3183,2,425,1,97601.59,NULL,'2023-01-02 22:37:37','2023-01-03 21:07:46','2023-01-03 21:07:46'),(2095,7938,348,40721,3183,2,510,2,70413.45,NULL,'2023-01-02 22:37:37','2023-01-03 21:07:46','2023-01-03 21:07:46'),(2096,7938,348,40721,3183,2,67,2,14786.83,NULL,'2023-01-02 22:37:37','2023-01-03 21:07:46','2023-01-03 21:07:46'),(2097,7938,348,40721,3183,2,511,2,12401.31,NULL,'2023-01-02 22:37:37','2023-01-03 21:07:46','2023-01-03 21:07:46'),(2098,7938,349,40721,3185,2,425,1,48225.45,NULL,'2023-01-02 22:39:16','2023-01-02 22:39:16',NULL),(2099,7938,349,40721,3185,2,23,1,2210.49,NULL,'2023-01-02 22:39:16','2023-01-02 22:39:16',NULL),(2100,7938,349,40721,3185,2,486,1,3550.91,NULL,'2023-01-02 22:39:16','2023-01-02 22:39:16',NULL),(2101,7938,349,40721,3185,2,157,1,420.47,NULL,'2023-01-02 22:39:16','2023-01-02 22:39:16',NULL),(2102,7938,349,40721,3185,2,510,2,86046.97,NULL,'2023-01-02 22:39:16','2023-01-02 22:39:16',NULL),(2103,7938,349,40721,3185,2,67,2,18069.86,NULL,'2023-01-02 22:39:16','2023-01-02 22:39:16',NULL),(2104,7938,349,40721,3185,2,511,1,49709.51,NULL,'2023-01-02 22:39:16','2023-01-02 22:39:16',NULL),(2105,7938,350,40721,3186,2,425,1,164505.94,NULL,'2023-01-02 22:40:58','2023-01-02 22:40:58',NULL),(2106,7938,350,40721,3186,2,23,1,2112.27,NULL,'2023-01-02 22:40:58','2023-01-02 22:40:58',NULL),(2107,7938,350,40721,3186,2,486,1,4327.09,NULL,'2023-01-02 22:40:58','2023-01-02 22:40:58',NULL),(2108,7938,350,40721,3186,2,157,1,517.95,NULL,'2023-01-02 22:40:58','2023-01-02 22:40:58',NULL),(2109,7938,350,40721,3186,2,510,2,98796.07,NULL,'2023-01-02 22:40:58','2023-01-02 22:40:58',NULL),(2110,7938,350,40721,3186,2,67,2,20747.20,NULL,'2023-01-02 22:40:58','2023-01-02 22:40:58',NULL),(2111,7938,350,40721,3186,2,511,2,51919.98,NULL,'2023-01-02 22:40:58','2023-01-02 22:40:58',NULL),(2112,7938,351,40721,3190,2,425,1,81005.30,NULL,'2023-01-02 22:42:32','2023-01-02 22:42:32',NULL),(2113,7938,351,40721,3190,2,486,1,2482.30,NULL,'2023-01-02 22:42:32','2023-01-02 22:42:32',NULL),(2114,7938,351,40721,3190,2,157,1,462.52,NULL,'2023-01-02 22:42:32','2023-01-02 22:42:32',NULL),(2115,7938,351,40721,3190,2,510,2,70270.47,NULL,'2023-01-02 22:42:32','2023-01-02 22:42:32',NULL),(2116,7938,351,40721,3190,2,67,2,14756.80,NULL,'2023-01-02 22:42:32','2023-01-02 22:42:32',NULL),(2117,7938,351,40721,3190,2,511,1,1077.15,NULL,'2023-01-02 22:42:32','2023-01-02 22:42:32',NULL),(2118,7938,352,40721,3191,2,425,1,76835.42,NULL,'2023-01-02 22:44:22','2023-01-03 16:04:16','2023-01-03 16:04:16'),(2119,7938,352,40721,3191,2,23,1,4079.80,NULL,'2023-01-02 22:44:22','2023-01-03 16:04:16','2023-01-03 16:04:16');
INSERT INTO `balance_libro_details` VALUES (2120,7938,352,40721,3191,2,486,1,5040.01,NULL,'2023-01-02 22:44:22','2023-01-03 16:04:16','2023-01-03 16:04:16'),(2121,7938,352,40721,3191,2,157,1,673.94,NULL,'2023-01-02 22:44:22','2023-01-03 16:04:16','2023-01-03 16:04:16'),(2122,7938,352,40721,3191,2,510,2,110394.14,NULL,'2023-01-02 22:44:22','2023-01-03 16:04:16','2023-01-03 16:04:16'),(2123,7938,352,40721,3191,2,67,2,23182.80,NULL,'2023-01-02 22:44:22','2023-01-03 16:04:16','2023-01-03 16:04:16'),(2124,7938,352,40721,3191,2,511,1,46947.77,NULL,'2023-01-02 22:44:22','2023-01-03 16:04:16','2023-01-03 16:04:16'),(2125,7938,353,40721,3192,2,425,1,136326.43,NULL,'2023-01-02 22:46:29','2023-01-02 22:46:29',NULL),(2126,7938,353,40721,3192,2,23,1,1089.00,NULL,'2023-01-02 22:46:29','2023-01-02 22:46:29',NULL),(2127,7938,353,40721,3192,2,486,1,1643.73,NULL,'2023-01-02 22:46:29','2023-01-02 22:46:29',NULL),(2128,7938,353,40721,3192,2,510,2,99492.12,NULL,'2023-01-02 22:46:29','2023-01-02 22:46:29',NULL),(2129,7938,353,40721,3192,2,67,2,20892.40,NULL,'2023-01-02 22:46:29','2023-01-02 22:46:29',NULL),(2130,7938,353,40721,3192,2,511,2,18674.64,NULL,'2023-01-02 22:46:29','2023-01-02 22:46:29',NULL),(2131,7938,354,40721,3194,2,425,1,72002.31,NULL,'2023-01-02 22:48:06','2023-01-03 14:41:04','2023-01-03 14:41:04'),(2132,7938,354,40721,3194,2,486,1,3389.09,NULL,'2023-01-02 22:48:06','2023-01-03 14:41:04','2023-01-03 14:41:04'),(2133,7938,354,40721,3194,2,157,1,628.26,NULL,'2023-01-02 22:48:06','2023-01-03 14:41:04','2023-01-03 14:41:04'),(2134,7938,354,40721,3194,2,510,2,79826.17,NULL,'2023-01-02 22:48:06','2023-01-03 14:41:04','2023-01-03 14:41:04'),(2135,7938,354,40721,3194,2,67,2,16763.50,NULL,'2023-01-02 22:48:06','2023-01-03 14:41:04','2023-01-03 14:41:04'),(2136,7938,354,40721,3194,2,511,1,20570.01,NULL,'2023-01-02 22:48:06','2023-01-03 14:41:04','2023-01-03 14:41:04'),(2137,7938,355,40721,3197,2,425,1,2672242.24,NULL,'2023-01-02 22:49:50','2023-01-03 21:11:09','2023-01-03 21:11:09'),(2138,7938,355,40721,3197,2,23,1,54014.40,NULL,'2023-01-02 22:49:50','2023-01-03 21:11:09','2023-01-03 21:11:09'),(2139,7938,355,40721,3197,2,486,1,66960.00,NULL,'2023-01-02 22:49:50','2023-01-03 21:11:09','2023-01-03 21:11:09'),(2140,7938,355,40721,3197,2,510,2,2378360.28,NULL,'2023-01-02 22:49:50','2023-01-03 21:11:09','2023-01-03 21:11:09'),(2141,7938,355,40721,3197,2,67,2,499455.66,NULL,'2023-01-02 22:49:50','2023-01-03 21:11:09','2023-01-03 21:11:09'),(2142,7938,355,40721,3197,2,511,1,84599.30,NULL,'2023-01-02 22:49:50','2023-01-03 21:11:09','2023-01-03 21:11:09'),(2143,7938,356,40721,3190,2,425,1,928942.91,NULL,'2023-01-02 22:56:12','2023-01-03 12:38:03','2023-01-03 12:38:03'),(2144,7938,356,40721,3190,2,23,1,17538.80,NULL,'2023-01-02 22:56:12','2023-01-03 12:38:03','2023-01-03 12:38:03'),(2145,7938,356,40721,3190,2,162,1,9441.10,NULL,'2023-01-02 22:56:12','2023-01-03 12:38:03','2023-01-03 12:38:03'),(2146,7938,356,40721,3190,2,25,1,158610.46,NULL,'2023-01-02 22:56:12','2023-01-03 12:38:03','2023-01-03 12:38:03'),(2147,7938,356,40721,3190,2,486,1,5739.57,NULL,'2023-01-02 22:56:12','2023-01-03 12:38:03','2023-01-03 12:38:03'),(2148,7938,356,40721,3190,2,157,1,10100.10,NULL,'2023-01-02 22:56:12','2023-01-03 12:38:03','2023-01-03 12:38:03'),(2149,7938,356,40721,3190,2,509,2,944109.90,NULL,'2023-01-02 22:56:12','2023-01-03 12:38:03','2023-01-03 12:38:03'),(2150,7938,356,40721,3190,2,67,2,198263.00,NULL,'2023-01-02 22:56:12','2023-01-03 12:38:03','2023-01-03 12:38:03'),(2151,7938,356,40721,3190,2,512,1,11999.96,NULL,'2023-01-02 22:56:12','2023-01-03 12:38:03','2023-01-03 12:38:03'),(2152,7938,357,40721,3193,2,425,1,1176690.44,NULL,'2023-01-02 22:57:52','2023-01-03 12:37:40','2023-01-03 12:37:40'),(2153,7938,357,40721,3193,2,23,1,23135.16,NULL,'2023-01-02 22:57:52','2023-01-03 12:37:40','2023-01-03 12:37:40'),(2154,7938,357,40721,3193,2,162,1,11985.28,NULL,'2023-01-02 22:57:52','2023-01-03 12:37:40','2023-01-03 12:37:40');
INSERT INTO `balance_libro_details` VALUES (2155,7938,357,40721,3193,2,25,1,201352.73,NULL,'2023-01-02 22:57:52','2023-01-03 12:37:40','2023-01-03 12:37:40'),(2156,7938,357,40721,3193,2,486,1,23081.16,NULL,'2023-01-02 22:57:52','2023-01-03 12:37:40','2023-01-03 12:37:40'),(2157,7938,357,40721,3193,2,157,1,15244.30,NULL,'2023-01-02 22:57:52','2023-01-03 12:37:40','2023-01-03 12:37:40'),(2158,7938,357,40721,3193,2,509,2,1223928.00,NULL,'2023-01-02 22:57:52','2023-01-03 12:37:40','2023-01-03 12:37:40'),(2159,7938,357,40721,3193,2,67,2,257025.00,NULL,'2023-01-02 22:57:52','2023-01-03 12:37:40','2023-01-03 12:37:40'),(2160,7938,357,40721,3193,2,512,1,29463.93,NULL,'2023-01-02 22:57:52','2023-01-03 12:37:40','2023-01-03 12:37:40'),(2161,7938,358,40721,3194,2,425,1,1213274.96,NULL,'2023-01-02 23:00:05','2023-01-03 12:37:08','2023-01-03 12:37:08'),(2162,7938,358,40721,3194,2,23,1,22875.61,NULL,'2023-01-02 23:00:05','2023-01-03 12:37:08','2023-01-03 12:37:08'),(2163,7938,358,40721,3194,2,162,1,12109.51,NULL,'2023-01-02 23:00:05','2023-01-03 12:37:08','2023-01-03 12:37:08'),(2164,7938,358,40721,3194,2,25,1,203440.00,NULL,'2023-01-02 23:00:05','2023-01-03 12:37:08','2023-01-03 12:37:08'),(2165,7938,358,40721,3194,2,486,1,23378.78,NULL,'2023-01-02 23:00:05','2023-01-03 12:37:08','2023-01-03 12:37:08'),(2166,7938,358,40721,3194,2,157,1,15368.51,NULL,'2023-01-02 23:00:05','2023-01-03 12:37:08','2023-01-03 12:37:08'),(2167,7938,358,40721,3194,2,509,2,1210951.00,NULL,'2023-01-02 23:00:05','2023-01-03 12:37:08','2023-01-03 12:37:08'),(2168,7938,358,40721,3194,2,67,2,254300.00,NULL,'2023-01-02 23:00:05','2023-01-03 12:37:08','2023-01-03 12:37:08'),(2169,7938,358,40721,3194,2,512,2,25196.37,NULL,'2023-01-02 23:00:05','2023-01-03 12:37:08','2023-01-03 12:37:08'),(2170,7938,359,40721,3196,2,425,1,1417154.92,NULL,'2023-01-02 23:01:58','2023-01-03 13:04:35','2023-01-03 13:04:35'),(2171,7938,359,40721,3196,2,25,1,1713.60,NULL,'2023-01-02 23:01:58','2023-01-03 13:04:35','2023-01-03 13:04:35'),(2172,7938,359,40721,3196,2,486,1,306.00,NULL,'2023-01-02 23:01:58','2023-01-03 13:04:35','2023-01-03 13:04:35'),(2173,7938,359,40721,3196,2,509,2,1443332.89,NULL,'2023-01-02 23:01:58','2023-01-03 13:04:35','2023-01-03 13:04:35'),(2174,7938,359,40721,3196,2,67,2,2413.93,NULL,'2023-01-02 23:01:58','2023-01-03 13:04:35','2023-01-03 13:04:35'),(2175,7938,359,40721,3196,2,512,1,26572.30,NULL,'2023-01-02 23:01:58','2023-01-03 13:04:35','2023-01-03 13:04:35'),(2176,7938,360,40721,3194,2,425,1,1213274.96,NULL,'2023-01-03 12:37:08','2023-01-03 13:50:47','2023-01-03 13:50:47'),(2177,7938,360,40721,3194,2,23,1,22875.61,NULL,'2023-01-03 12:37:08','2023-01-03 13:50:47','2023-01-03 13:50:47'),(2178,7938,360,40721,3194,2,25,1,203440.00,NULL,'2023-01-03 12:37:08','2023-01-03 13:50:47','2023-01-03 13:50:47'),(2179,7938,360,40721,3194,2,486,1,23378.78,NULL,'2023-01-03 12:37:08','2023-01-03 13:50:47','2023-01-03 13:50:47'),(2180,7938,360,40721,3194,2,157,1,15368.51,NULL,'2023-01-03 12:37:08','2023-01-03 13:50:47','2023-01-03 13:50:47'),(2181,7938,360,40721,3194,2,509,2,1210951.00,NULL,'2023-01-03 12:37:08','2023-01-03 13:50:47','2023-01-03 13:50:47'),(2182,7938,360,40721,3194,2,67,2,254300.00,NULL,'2023-01-03 12:37:08','2023-01-03 13:50:47','2023-01-03 13:50:47'),(2183,7938,360,40721,3194,2,512,2,25196.37,NULL,'2023-01-03 12:37:08','2023-01-03 13:50:47','2023-01-03 13:50:47'),(2184,7938,360,40721,3194,2,484,1,12109.51,NULL,'2023-01-03 12:37:08','2023-01-03 13:50:47','2023-01-03 13:50:47'),(2185,7938,361,40721,3193,2,425,1,1176690.44,NULL,'2023-01-03 12:37:40','2023-01-03 13:45:34','2023-01-03 13:45:34'),(2186,7938,361,40721,3193,2,23,1,23135.16,NULL,'2023-01-03 12:37:40','2023-01-03 13:45:34','2023-01-03 13:45:34'),(2187,7938,361,40721,3193,2,25,1,201352.73,NULL,'2023-01-03 12:37:40','2023-01-03 13:45:34','2023-01-03 13:45:34'),(2188,7938,361,40721,3193,2,486,1,23081.16,NULL,'2023-01-03 12:37:40','2023-01-03 13:45:34','2023-01-03 13:45:34');
INSERT INTO `balance_libro_details` VALUES (2189,7938,361,40721,3193,2,157,1,15244.30,NULL,'2023-01-03 12:37:40','2023-01-03 13:45:34','2023-01-03 13:45:34'),(2190,7938,361,40721,3193,2,509,2,1223928.00,NULL,'2023-01-03 12:37:40','2023-01-03 13:45:34','2023-01-03 13:45:34'),(2191,7938,361,40721,3193,2,67,2,257025.00,NULL,'2023-01-03 12:37:40','2023-01-03 13:45:34','2023-01-03 13:45:34'),(2192,7938,361,40721,3193,2,512,1,29463.93,NULL,'2023-01-03 12:37:40','2023-01-03 13:45:34','2023-01-03 13:45:34'),(2193,7938,361,40721,3193,2,484,1,11985.28,NULL,'2023-01-03 12:37:40','2023-01-03 13:45:34','2023-01-03 13:45:34'),(2194,7938,362,40721,3190,2,425,1,928942.91,NULL,'2023-01-03 12:38:03','2023-01-03 13:11:24','2023-01-03 13:11:24'),(2195,7938,362,40721,3190,2,23,1,17538.80,NULL,'2023-01-03 12:38:03','2023-01-03 13:11:24','2023-01-03 13:11:24'),(2196,7938,362,40721,3190,2,25,1,158610.46,NULL,'2023-01-03 12:38:03','2023-01-03 13:11:24','2023-01-03 13:11:24'),(2197,7938,362,40721,3190,2,486,1,5739.57,NULL,'2023-01-03 12:38:03','2023-01-03 13:11:24','2023-01-03 13:11:24'),(2198,7938,362,40721,3190,2,157,1,10100.10,NULL,'2023-01-03 12:38:03','2023-01-03 13:11:24','2023-01-03 13:11:24'),(2199,7938,362,40721,3190,2,509,2,944109.90,NULL,'2023-01-03 12:38:03','2023-01-03 13:11:24','2023-01-03 13:11:24'),(2200,7938,362,40721,3190,2,67,2,198263.00,NULL,'2023-01-03 12:38:03','2023-01-03 13:11:24','2023-01-03 13:11:24'),(2201,7938,362,40721,3190,2,512,1,11999.96,NULL,'2023-01-03 12:38:03','2023-01-03 13:11:24','2023-01-03 13:11:24'),(2202,7938,362,40721,3190,2,484,1,9441.10,NULL,'2023-01-03 12:38:03','2023-01-03 13:11:24','2023-01-03 13:11:24'),(2203,7938,363,40721,3197,2,425,1,1550461.75,NULL,'2023-01-03 12:39:11','2023-01-03 12:39:11',NULL),(2204,7938,363,40721,3197,2,23,1,30185.40,NULL,'2023-01-03 12:39:11','2023-01-03 12:39:11',NULL),(2205,7938,363,40721,3197,2,25,1,264841.90,NULL,'2023-01-03 12:39:11','2023-01-03 12:39:11',NULL),(2206,7938,363,40721,3197,2,486,1,30385.04,NULL,'2023-01-03 12:39:11','2023-01-03 12:39:11',NULL),(2207,7938,363,40721,3197,2,157,1,18364.40,NULL,'2023-01-03 12:39:11','2023-01-03 12:39:11',NULL),(2208,7938,363,40721,3197,2,509,2,1578514.78,NULL,'2023-01-03 12:39:11','2023-01-03 12:39:11',NULL),(2209,7938,363,40721,3197,2,67,2,331488.11,NULL,'2023-01-03 12:39:11','2023-01-03 12:39:11',NULL),(2210,7938,363,40721,3197,2,484,1,15764.40,NULL,'2023-01-03 12:39:11','2023-01-03 12:39:11',NULL),(2211,7938,364,40721,3195,2,425,1,1324598.31,NULL,'2023-01-03 12:39:37','2023-01-03 12:39:37',NULL),(2212,7938,364,40721,3195,2,23,1,25662.03,NULL,'2023-01-03 12:39:37','2023-01-03 12:39:37',NULL),(2213,7938,364,40721,3195,2,25,1,226845.60,NULL,'2023-01-03 12:39:37','2023-01-03 12:39:37',NULL),(2214,7938,364,40721,3195,2,486,1,26458.01,NULL,'2023-01-03 12:39:37','2023-01-03 12:39:37',NULL),(2215,7938,364,40721,3195,2,157,1,16761.72,NULL,'2023-01-03 12:39:37','2023-01-03 12:39:37',NULL),(2216,7938,364,40721,3195,2,509,2,1350271.38,NULL,'2023-01-03 12:39:37','2023-01-03 12:39:37',NULL),(2217,7938,364,40721,3195,2,67,2,283557.00,NULL,'2023-01-03 12:39:37','2023-01-03 12:39:37',NULL),(2218,7938,364,40721,3195,2,484,1,13502.71,NULL,'2023-01-03 12:39:37','2023-01-03 12:39:37',NULL),(2219,7938,365,40721,3192,2,425,1,1082252.40,NULL,'2023-01-03 12:40:11','2023-01-03 12:40:11',NULL),(2220,7938,365,40721,3192,2,23,1,20689.65,NULL,'2023-01-03 12:40:11','2023-01-03 12:40:11',NULL),(2221,7938,365,40721,3192,2,25,1,185077.60,NULL,'2023-01-03 12:40:11','2023-01-03 12:40:11',NULL),(2222,7938,365,40721,3192,2,486,1,19688.35,NULL,'2023-01-03 12:40:11','2023-01-03 12:40:11',NULL),(2223,7938,365,40721,3192,2,157,1,14275.51,NULL,'2023-01-03 12:40:11','2023-01-03 12:40:11',NULL),(2224,7938,365,40721,3192,2,509,2,1101653.04,NULL,'2023-01-03 12:40:11','2023-01-03 12:40:11',NULL),(2225,7938,365,40721,3192,2,67,2,231347.00,NULL,'2023-01-03 12:40:11','2023-01-03 12:40:11',NULL),(2226,7938,365,40721,3192,2,484,1,11016.53,NULL,'2023-01-03 12:40:11','2023-01-03 12:40:11',NULL);
INSERT INTO `balance_libro_details` VALUES (2227,7938,366,40721,3191,2,425,1,943452.93,NULL,'2023-01-03 12:40:37','2023-01-03 12:40:37',NULL),(2228,7938,366,40721,3191,2,23,1,17754.30,NULL,'2023-01-03 12:40:37','2023-01-03 12:40:37',NULL),(2229,7938,366,40721,3191,2,25,1,161428.71,NULL,'2023-01-03 12:40:37','2023-01-03 12:40:37',NULL),(2230,7938,366,40721,3191,2,486,1,17605.85,NULL,'2023-01-03 12:40:37','2023-01-03 12:40:37',NULL),(2231,7938,366,40721,3191,2,157,1,12880.56,NULL,'2023-01-03 12:40:37','2023-01-03 12:40:37',NULL),(2232,7938,366,40721,3191,2,509,2,960885.20,NULL,'2023-01-03 12:40:37','2023-01-03 12:40:37',NULL),(2233,7938,366,40721,3191,2,67,2,201786.00,NULL,'2023-01-03 12:40:37','2023-01-03 12:40:37',NULL),(2234,7938,366,40721,3191,2,484,1,9548.85,NULL,'2023-01-03 12:40:37','2023-01-03 12:40:37',NULL),(2235,7938,367,40721,3186,2,425,1,794022.53,NULL,'2023-01-03 12:41:02','2023-01-03 12:41:02',NULL),(2236,7938,367,40721,3186,2,23,1,15030.34,NULL,'2023-01-03 12:41:02','2023-01-03 12:41:02',NULL),(2237,7938,367,40721,3186,2,25,1,137539.39,NULL,'2023-01-03 12:41:02','2023-01-03 12:41:02',NULL),(2238,7938,367,40721,3186,2,486,1,16198.71,NULL,'2023-01-03 12:41:02','2023-01-03 12:41:02',NULL),(2239,7938,367,40721,3186,2,157,1,19633.16,NULL,'2023-01-03 12:41:02','2023-01-03 12:41:02',NULL),(2240,7938,367,40721,3186,2,509,2,818686.90,NULL,'2023-01-03 12:41:02','2023-01-03 12:41:02',NULL),(2241,7938,367,40721,3186,2,67,2,171924.10,NULL,'2023-01-03 12:41:02','2023-01-03 12:41:02',NULL),(2242,7938,367,40721,3186,2,484,1,8186.87,NULL,'2023-01-03 12:41:02','2023-01-03 12:41:02',NULL),(2243,7938,368,40721,3185,2,425,1,815442.81,NULL,'2023-01-03 12:41:33','2023-01-03 20:41:39','2023-01-03 20:41:39'),(2244,7938,368,40721,3185,2,23,1,15031.17,NULL,'2023-01-03 12:41:33','2023-01-03 20:41:39','2023-01-03 20:41:39'),(2245,7938,368,40721,3185,2,25,1,138352.42,NULL,'2023-01-03 12:41:33','2023-01-03 20:41:39','2023-01-03 20:41:39'),(2246,7938,368,40721,3185,2,486,1,16196.18,NULL,'2023-01-03 12:41:33','2023-01-03 20:41:39','2023-01-03 20:41:39'),(2247,7938,368,40721,3185,2,157,1,3259.83,NULL,'2023-01-03 12:41:33','2023-01-03 20:41:39','2023-01-03 20:41:39'),(2248,7938,368,40721,3185,2,509,2,823528.70,NULL,'2023-01-03 12:41:33','2023-01-03 20:41:39','2023-01-03 20:41:39'),(2249,7938,368,40721,3185,2,67,2,172941.00,NULL,'2023-01-03 12:41:33','2023-01-03 20:41:39','2023-01-03 20:41:39'),(2250,7938,368,40721,3185,2,484,1,8187.29,NULL,'2023-01-03 12:41:33','2023-01-03 20:41:39','2023-01-03 20:41:39'),(2251,7938,369,40721,3184,2,425,1,847275.47,NULL,'2023-01-03 12:42:28','2023-01-03 12:42:28',NULL),(2252,7938,369,40721,3184,2,23,1,15932.30,NULL,'2023-01-03 12:42:28','2023-01-03 12:42:28',NULL),(2253,7938,369,40721,3184,2,25,1,145115.88,NULL,'2023-01-03 12:42:28','2023-01-03 12:42:28',NULL),(2254,7938,369,40721,3184,2,486,1,16818.64,NULL,'2023-01-03 12:42:28','2023-01-03 12:42:28',NULL),(2255,7938,369,40721,3184,2,157,1,11399.86,NULL,'2023-01-03 12:42:28','2023-01-03 12:42:28',NULL),(2256,7938,369,40721,3184,2,509,2,863785.00,NULL,'2023-01-03 12:42:28','2023-01-03 12:42:28',NULL),(2257,7938,369,40721,3184,2,67,2,181395.00,NULL,'2023-01-03 12:42:28','2023-01-03 12:42:28',NULL),(2258,7938,369,40721,3184,2,484,1,8637.85,NULL,'2023-01-03 12:42:28','2023-01-03 12:42:28',NULL),(2259,7938,370,40721,3183,2,425,1,798839.50,NULL,'2023-01-03 12:42:59','2023-01-03 12:42:59',NULL),(2260,7938,370,40721,3183,2,23,1,14951.88,NULL,'2023-01-03 12:42:59','2023-01-03 12:42:59',NULL),(2261,7938,370,40721,3183,2,25,1,136880.34,NULL,'2023-01-03 12:42:59','2023-01-03 12:42:59',NULL),(2262,7938,370,40721,3183,2,486,1,16797.35,NULL,'2023-01-03 12:42:59','2023-01-03 12:42:59',NULL),(2263,7938,370,40721,3183,2,157,1,10247.67,NULL,'2023-01-03 12:42:59','2023-01-03 12:42:59',NULL),(2264,7938,370,40721,3183,2,509,2,814764.38,NULL,'2023-01-03 12:42:59','2023-01-03 12:42:59',NULL),(2265,7938,370,40721,3183,2,67,2,171100.00,NULL,'2023-01-03 12:42:59','2023-01-03 12:42:59',NULL);
INSERT INTO `balance_libro_details` VALUES (2266,7938,370,40721,3183,2,484,1,8147.64,NULL,'2023-01-03 12:42:59','2023-01-03 12:42:59',NULL),(2267,7938,371,40721,3196,2,425,1,1417154.92,NULL,'2023-01-03 13:04:35','2023-01-03 13:04:35',NULL),(2268,7938,371,40721,3196,2,25,1,242479.94,NULL,'2023-01-03 13:04:35','2023-01-03 13:04:35',NULL),(2269,7938,371,40721,3196,2,486,1,24945.99,NULL,'2023-01-03 13:04:35','2023-01-03 13:04:35',NULL),(2270,7938,371,40721,3196,2,509,2,1443332.89,NULL,'2023-01-03 13:04:35','2023-01-03 13:04:35',NULL),(2271,7938,371,40721,3196,2,67,2,303099.93,NULL,'2023-01-03 13:04:35','2023-01-03 13:04:35',NULL),(2272,7938,371,40721,3196,2,23,1,28636.76,NULL,'2023-01-03 13:04:35','2023-01-03 13:04:35',NULL),(2273,7938,371,40721,3196,2,484,1,14318.38,NULL,'2023-01-03 13:04:35','2023-01-03 13:04:35',NULL),(2274,7938,371,40721,3196,2,157,1,18896.83,NULL,'2023-01-03 13:04:35','2023-01-03 13:04:35',NULL),(2275,7938,372,40721,3190,2,425,1,928942.91,NULL,'2023-01-03 13:11:24','2023-01-03 13:11:24',NULL),(2276,7938,372,40721,3190,2,23,1,17538.80,NULL,'2023-01-03 13:11:24','2023-01-03 13:11:24',NULL),(2277,7938,372,40721,3190,2,25,1,158610.46,NULL,'2023-01-03 13:11:24','2023-01-03 13:11:24',NULL),(2278,7938,372,40721,3190,2,486,1,17739.57,NULL,'2023-01-03 13:11:24','2023-01-03 13:11:24',NULL),(2279,7938,372,40721,3190,2,157,1,10100.10,NULL,'2023-01-03 13:11:24','2023-01-03 13:11:24',NULL),(2280,7938,372,40721,3190,2,509,2,944109.94,NULL,'2023-01-03 13:11:24','2023-01-03 13:11:24',NULL),(2281,7938,372,40721,3190,2,67,2,198263.00,NULL,'2023-01-03 13:11:24','2023-01-03 13:11:24',NULL),(2282,7938,372,40721,3190,2,484,1,9441.10,NULL,'2023-01-03 13:11:24','2023-01-03 13:11:24',NULL),(2283,7938,373,40721,3193,2,425,1,1176690.30,NULL,'2023-01-03 13:45:34','2023-01-03 13:45:34',NULL),(2284,7938,373,40721,3193,2,23,1,22627.16,NULL,'2023-01-03 13:45:34','2023-01-03 13:45:34',NULL),(2285,7938,373,40721,3193,2,25,1,201352.80,NULL,'2023-01-03 13:45:34','2023-01-03 13:45:34',NULL),(2286,7938,373,40721,3193,2,486,1,22319.16,NULL,'2023-01-03 13:45:34','2023-01-03 13:45:34',NULL),(2287,7938,373,40721,3193,2,157,1,15244.30,NULL,'2023-01-03 13:45:34','2023-01-03 13:45:34',NULL),(2288,7938,373,40721,3193,2,509,2,1198528.00,NULL,'2023-01-03 13:45:34','2023-01-03 13:45:34',NULL),(2289,7938,373,40721,3193,2,67,2,251691.00,NULL,'2023-01-03 13:45:34','2023-01-03 13:45:34',NULL),(2290,7938,373,40721,3193,2,484,1,11985.28,NULL,'2023-01-03 13:45:34','2023-01-03 13:45:34',NULL),(2291,7938,374,40721,3194,2,425,1,1213274.96,NULL,'2023-01-03 13:50:47','2023-01-03 13:50:47',NULL),(2292,7938,374,40721,3194,2,23,1,23383.61,NULL,'2023-01-03 13:50:47','2023-01-03 13:50:47',NULL),(2293,7938,374,40721,3194,2,25,1,207707.20,NULL,'2023-01-03 13:50:47','2023-01-03 13:50:47',NULL),(2294,7938,374,40721,3194,2,486,1,24140.78,NULL,'2023-01-03 13:50:47','2023-01-03 13:50:47',NULL),(2295,7938,374,40721,3194,2,157,1,15368.51,NULL,'2023-01-03 13:50:47','2023-01-03 13:50:47',NULL),(2296,7938,374,40721,3194,2,509,2,1236350.57,NULL,'2023-01-03 13:50:47','2023-01-03 13:50:47',NULL),(2297,7938,374,40721,3194,2,67,2,259634.00,NULL,'2023-01-03 13:50:47','2023-01-03 13:50:47',NULL),(2298,7938,374,40721,3194,2,484,1,12109.51,NULL,'2023-01-03 13:50:47','2023-01-03 13:50:47',NULL),(2299,7938,375,40721,3197,16,156,1,217020.61,NULL,'2023-01-03 13:57:28','2023-01-03 13:57:28',NULL),(2300,7938,375,40721,3197,16,485,1,26041.58,NULL,'2023-01-03 13:57:28','2023-01-03 13:57:28',NULL),(2301,7938,375,40721,3197,16,209,2,25494.06,NULL,'2023-01-03 13:57:28','2023-01-03 13:57:28',NULL),(2302,7938,375,40721,3197,16,485,2,24408.22,NULL,'2023-01-03 13:57:28','2023-01-03 13:57:28',NULL),(2303,7938,375,40721,3197,16,78,2,117532.12,NULL,'2023-01-03 13:57:28','2023-01-03 13:57:28',NULL),(2304,7938,375,40721,3197,16,486,2,75627.79,NULL,'2023-01-03 13:57:28','2023-01-03 13:57:28',NULL),(2305,7938,376,40721,3196,16,156,1,155230.88,NULL,'2023-01-03 13:57:56','2023-01-03 13:57:56',NULL);
INSERT INTO `balance_libro_details` VALUES (2306,7938,376,40721,3196,16,485,1,24408.22,NULL,'2023-01-03 13:57:56','2023-01-03 13:57:56',NULL),(2307,7938,376,40721,3196,16,209,2,18297.34,NULL,'2023-01-03 13:57:56','2023-01-03 13:57:56',NULL),(2308,7938,376,40721,3196,16,485,2,30329.44,NULL,'2023-01-03 13:57:56','2023-01-03 13:57:56',NULL),(2309,7938,376,40721,3196,16,78,2,88179.24,NULL,'2023-01-03 13:57:56','2023-01-03 13:57:56',NULL),(2310,7938,376,40721,3196,16,486,2,42833.08,NULL,'2023-01-03 13:57:56','2023-01-03 13:57:56',NULL),(2311,7938,377,40721,3195,16,156,1,76586.49,NULL,'2023-01-03 13:58:23','2023-01-03 22:26:35','2023-01-03 22:26:35'),(2312,7938,377,40721,3195,16,485,1,30329.44,NULL,'2023-01-03 13:58:23','2023-01-03 22:26:35','2023-01-03 22:26:35'),(2313,7938,377,40721,3195,16,209,2,8478.39,NULL,'2023-01-03 13:58:23','2023-01-03 22:26:35','2023-01-03 22:26:35'),(2314,7938,377,40721,3195,16,485,2,28707.92,NULL,'2023-01-03 13:58:23','2023-01-03 22:26:35','2023-01-03 22:26:35'),(2315,7938,377,40721,3195,16,78,2,39401.36,NULL,'2023-01-03 13:58:23','2023-01-03 22:26:35','2023-01-03 22:26:35'),(2316,7938,377,40721,3195,16,486,2,30328.26,NULL,'2023-01-03 13:58:23','2023-01-03 22:26:35','2023-01-03 22:26:35'),(2317,7938,378,40721,3194,16,156,1,69901.92,NULL,'2023-01-03 13:58:50','2023-01-03 13:58:50',NULL),(2318,7938,378,40721,3194,16,485,1,29672.51,NULL,'2023-01-03 13:58:50','2023-01-03 13:58:50',NULL),(2319,7938,378,40721,3194,16,209,2,7712.75,NULL,'2023-01-03 13:58:50','2023-01-03 13:58:50',NULL),(2320,7938,378,40721,3194,16,485,2,28138.05,NULL,'2023-01-03 13:58:50','2023-01-03 13:58:50',NULL),(2321,7938,378,40721,3194,16,78,2,33133.75,NULL,'2023-01-03 13:58:50','2023-01-03 13:58:50',NULL),(2322,7938,378,40721,3194,16,486,2,30589.88,NULL,'2023-01-03 13:58:50','2023-01-03 13:58:50',NULL),(2323,7938,379,40721,3192,16,156,1,65115.71,NULL,'2023-01-03 13:59:17','2023-01-03 13:59:17',NULL),(2324,7938,379,40721,3192,16,485,1,27022.80,NULL,'2023-01-03 13:59:17','2023-01-03 13:59:17',NULL),(2325,7938,379,40721,3192,16,209,2,7355.18,NULL,'2023-01-03 13:59:17','2023-01-03 13:59:17',NULL),(2326,7938,379,40721,3192,16,485,2,25609.87,NULL,'2023-01-03 13:59:17','2023-01-03 13:59:17',NULL),(2327,7938,379,40721,3192,16,78,2,34505.54,NULL,'2023-01-03 13:59:17','2023-01-03 13:59:17',NULL),(2328,7938,379,40721,3192,16,486,2,24667.92,NULL,'2023-01-03 13:59:17','2023-01-03 13:59:17',NULL),(2329,7938,380,40721,3193,16,156,1,70615.46,NULL,'2023-01-03 13:59:45','2023-01-03 13:59:45',NULL),(2330,7938,380,40721,3193,16,485,1,28138.05,NULL,'2023-01-03 13:59:45','2023-01-03 13:59:45',NULL),(2331,7938,380,40721,3193,16,209,2,8513.64,NULL,'2023-01-03 13:59:45','2023-01-03 13:59:45',NULL),(2332,7938,380,40721,3193,16,485,2,27022.51,NULL,'2023-01-03 13:59:45','2023-01-03 13:59:45',NULL),(2333,7938,380,40721,3193,16,78,2,37195.96,NULL,'2023-01-03 13:59:45','2023-01-03 13:59:45',NULL),(2334,7938,380,40721,3193,16,486,2,26021.40,NULL,'2023-01-03 13:59:45','2023-01-03 13:59:45',NULL),(2335,7938,381,40721,3191,16,156,1,56804.14,NULL,'2023-01-03 14:00:09','2023-01-03 14:00:09',NULL),(2336,7938,381,40721,3191,16,485,1,25609.87,NULL,'2023-01-03 14:00:09','2023-01-03 14:00:09',NULL),(2337,7938,381,40721,3191,16,209,2,6137.13,NULL,'2023-01-03 14:00:09','2023-01-03 14:00:09',NULL),(2338,7938,381,40721,3191,16,485,2,24820.96,NULL,'2023-01-03 14:00:09','2023-01-03 14:00:09',NULL),(2339,7938,381,40721,3191,16,78,2,30070.06,NULL,'2023-01-03 14:00:09','2023-01-03 14:00:09',NULL),(2340,7938,381,40721,3191,16,486,2,21385.86,NULL,'2023-01-03 14:00:09','2023-01-03 14:00:09',NULL),(2341,7938,382,40721,3186,16,156,1,49948.28,NULL,'2023-01-03 14:00:34','2023-01-03 14:00:34',NULL),(2342,7938,382,40721,3186,16,485,1,23983.53,NULL,'2023-01-03 14:00:34','2023-01-03 14:00:34',NULL),(2343,7938,382,40721,3186,16,485,2,23406.14,NULL,'2023-01-03 14:00:34','2023-01-03 14:00:34',NULL),(2344,7938,382,40721,3186,16,78,2,30089.78,NULL,'2023-01-03 14:00:34','2023-01-03 14:00:34',NULL);
INSERT INTO `balance_libro_details` VALUES (2345,7938,382,40721,3186,16,486,2,20435.89,NULL,'2023-01-03 14:00:34','2023-01-03 14:00:34',NULL),(2346,7938,383,40721,3185,16,156,1,49567.80,NULL,'2023-01-03 14:01:00','2023-01-03 22:23:19','2023-01-03 22:23:19'),(2347,7938,383,40721,3185,16,485,1,23406.14,NULL,'2023-01-03 14:01:00','2023-01-03 22:23:19','2023-01-03 22:23:19'),(2348,7938,383,40721,3185,16,485,2,32409.56,NULL,'2023-01-03 14:01:00','2023-01-03 22:23:19','2023-01-03 22:23:19'),(2349,7938,383,40721,3185,16,78,2,22135.82,NULL,'2023-01-03 14:01:00','2023-01-03 22:23:19','2023-01-03 22:23:19'),(2350,7938,383,40721,3185,16,486,2,18428.56,NULL,'2023-01-03 14:01:00','2023-01-03 22:23:19','2023-01-03 22:23:19'),(2351,7938,384,40721,3190,16,156,1,55038.20,NULL,'2023-01-03 14:01:40','2023-01-03 14:01:40',NULL),(2352,7938,384,40721,3190,16,485,1,24820.96,NULL,'2023-01-03 14:01:40','2023-01-03 14:01:40',NULL),(2353,7938,384,40721,3190,16,209,2,6211.01,NULL,'2023-01-03 14:01:40','2023-01-03 14:01:40',NULL),(2354,7938,384,40721,3190,16,485,2,23983.53,NULL,'2023-01-03 14:01:40','2023-01-03 14:01:40',NULL),(2355,7938,384,40721,3190,16,78,2,28722.75,NULL,'2023-01-03 14:01:40','2023-01-03 14:01:40',NULL),(2356,7938,384,40721,3190,16,486,2,20941.87,NULL,'2023-01-03 14:01:40','2023-01-03 14:01:40',NULL),(2357,7938,385,40721,3183,16,156,1,48418.60,NULL,'2023-01-03 14:02:11','2023-01-03 14:02:11',NULL),(2358,7938,385,40721,3183,16,485,1,63704.75,NULL,'2023-01-03 14:02:11','2023-01-03 14:02:11',NULL),(2359,7938,385,40721,3183,16,485,2,91059.70,NULL,'2023-01-03 14:02:11','2023-01-03 14:02:11',NULL),(2360,7938,385,40721,3183,16,78,2,116.32,NULL,'2023-01-03 14:02:11','2023-01-03 14:02:11',NULL),(2361,7938,385,40721,3183,16,486,2,20947.33,NULL,'2023-01-03 14:02:11','2023-01-03 14:02:11',NULL),(2362,7938,386,40721,3184,16,156,1,51447.19,NULL,'2023-01-03 14:02:38','2023-01-03 14:02:38',NULL),(2363,7938,386,40721,3184,16,485,1,32401.90,NULL,'2023-01-03 14:02:38','2023-01-03 14:02:38',NULL),(2364,7938,386,40721,3184,16,485,2,63704.75,NULL,'2023-01-03 14:02:38','2023-01-03 14:02:38',NULL),(2365,7938,386,40721,3184,16,78,2,41.92,NULL,'2023-01-03 14:02:38','2023-01-03 14:02:38',NULL),(2366,7938,386,40721,3184,16,486,2,20102.42,NULL,'2023-01-03 14:02:38','2023-01-03 14:02:38',NULL),(2367,7938,387,40721,3196,3,506,1,2247.08,NULL,'2023-01-03 14:06:24','2023-01-03 16:58:39','2023-01-03 16:58:39'),(2368,7938,387,40721,3196,3,67,2,333.09,NULL,'2023-01-03 14:06:24','2023-01-03 16:58:39','2023-01-03 16:58:39'),(2369,7938,387,40721,3196,3,506,2,1913.99,NULL,'2023-01-03 14:06:24','2023-01-03 16:58:39','2023-01-03 16:58:39'),(2370,7938,388,40721,3192,2,425,1,544.50,NULL,'2023-01-03 14:15:13','2023-01-03 14:15:13',NULL),(2371,7938,388,40721,3192,2,508,2,450.00,NULL,'2023-01-03 14:15:13','2023-01-03 14:15:13',NULL),(2372,7938,388,40721,3192,2,67,2,94.50,NULL,'2023-01-03 14:15:13','2023-01-03 14:15:13',NULL),(2373,7938,389,40721,3194,2,425,1,72002.31,NULL,'2023-01-03 14:41:04','2023-01-03 14:41:04',NULL),(2374,7938,389,40721,3194,2,486,1,3389.09,NULL,'2023-01-03 14:41:04','2023-01-03 14:41:04',NULL),(2375,7938,389,40721,3194,2,157,1,628.26,NULL,'2023-01-03 14:41:04','2023-01-03 14:41:04',NULL),(2376,7938,389,40721,3194,2,510,2,62826.16,NULL,'2023-01-03 14:41:04','2023-01-03 14:41:04',NULL),(2377,7938,389,40721,3194,2,67,2,13193.50,NULL,'2023-01-03 14:41:04','2023-01-03 14:41:04',NULL),(2378,7938,390,40721,3191,2,425,1,76835.42,NULL,'2023-01-03 16:04:16','2023-01-03 16:04:16',NULL),(2379,7938,390,40721,3191,2,23,1,4079.80,NULL,'2023-01-03 16:04:16','2023-01-03 16:04:16',NULL),(2380,7938,390,40721,3191,2,486,1,5040.01,NULL,'2023-01-03 16:04:16','2023-01-03 16:04:16',NULL),(2381,7938,390,40721,3191,2,157,1,673.94,NULL,'2023-01-03 16:04:16','2023-01-03 16:04:16',NULL),(2382,7938,390,40721,3191,2,510,2,86394.14,NULL,'2023-01-03 16:04:16','2023-01-03 16:04:16',NULL),(2383,7938,390,40721,3191,2,67,2,18142.80,NULL,'2023-01-03 16:04:16','2023-01-03 16:04:16',NULL);
INSERT INTO `balance_libro_details` VALUES (2384,7938,390,40721,3191,2,511,1,17907.77,NULL,'2023-01-03 16:04:16','2023-01-03 16:04:16',NULL),(2385,7938,391,40721,3184,3,482,1,160000.00,NULL,'2023-01-03 16:09:05','2023-01-03 16:09:05',NULL),(2386,7938,391,40721,3184,3,425,2,160000.00,NULL,'2023-01-03 16:09:05','2023-01-03 16:09:05',NULL),(2387,7938,392,40721,3185,2,425,1,45678.15,NULL,'2023-01-03 16:15:09','2023-01-03 16:15:09',NULL),(2388,7938,392,40721,3185,2,502,2,45678.15,NULL,'2023-01-03 16:15:09','2023-01-03 16:15:09',NULL),(2389,7938,393,40721,3193,2,425,1,150000.00,NULL,'2023-01-03 16:23:14','2023-01-03 16:23:14',NULL),(2390,7938,393,40721,3193,2,482,2,150000.00,NULL,'2023-01-03 16:23:14','2023-01-03 16:23:14',NULL),(2391,7938,394,40721,3194,3,135,1,14004.05,NULL,'2023-01-03 16:33:34','2023-01-03 18:22:03','2023-01-03 18:22:03'),(2392,7938,394,40721,3194,3,425,2,14004.05,NULL,'2023-01-03 16:33:34','2023-01-03 18:22:03','2023-01-03 18:22:03'),(2393,7938,395,40721,3197,3,425,1,26629.54,NULL,'2023-01-03 16:54:36','2023-01-03 16:54:36',NULL),(2394,7938,395,40721,3197,3,67,2,4223.40,NULL,'2023-01-03 16:54:36','2023-01-03 16:54:36',NULL),(2395,7938,395,40721,3197,3,507,2,20159.06,NULL,'2023-01-03 16:54:36','2023-01-03 16:54:36',NULL),(2396,7938,395,40721,3197,3,506,2,2247.08,NULL,'2023-01-03 16:54:36','2023-01-03 16:54:36',NULL),(2397,7938,396,40721,3196,3,506,1,2247.08,NULL,'2023-01-03 16:58:39','2023-01-03 16:59:18','2023-01-03 16:59:18'),(2398,7938,396,40721,3196,3,67,2,333.09,NULL,'2023-01-03 16:58:39','2023-01-03 16:59:18','2023-01-03 16:59:18'),(2399,7938,396,40721,3196,3,506,2,1913.99,NULL,'2023-01-03 16:58:39','2023-01-03 16:59:18','2023-01-03 16:59:18'),(2400,7938,397,40721,3196,3,506,1,2247.08,NULL,'2023-01-03 16:59:18','2023-01-03 16:59:18',NULL),(2401,7938,397,40721,3196,3,67,2,333.09,NULL,'2023-01-03 16:59:18','2023-01-03 16:59:18',NULL),(2402,7938,397,40721,3196,3,507,2,1913.99,NULL,'2023-01-03 16:59:18','2023-01-03 16:59:18',NULL),(2403,7938,398,40721,3194,3,425,2,150000.00,NULL,'2023-01-03 18:24:06','2023-01-03 18:24:06',NULL),(2404,7938,398,40721,3194,3,482,1,150000.00,NULL,'2023-01-03 18:24:06','2023-01-03 18:24:06',NULL),(2405,7938,399,40721,3185,2,425,1,815442.40,NULL,'2023-01-03 20:41:39','2023-01-03 20:41:39',NULL),(2406,7938,399,40721,3185,2,23,1,15031.17,NULL,'2023-01-03 20:41:39','2023-01-03 20:41:39',NULL),(2407,7938,399,40721,3185,2,25,1,138352.42,NULL,'2023-01-03 20:41:39','2023-01-03 20:41:39',NULL),(2408,7938,399,40721,3185,2,486,1,16196.18,NULL,'2023-01-03 20:41:39','2023-01-03 20:41:39',NULL),(2409,7938,399,40721,3185,2,157,1,3259.83,NULL,'2023-01-03 20:41:39','2023-01-03 20:41:39',NULL),(2410,7938,399,40721,3185,2,509,2,823528.29,NULL,'2023-01-03 20:41:39','2023-01-03 20:41:39',NULL),(2411,7938,399,40721,3185,2,67,2,172941.00,NULL,'2023-01-03 20:41:39','2023-01-03 20:41:39',NULL),(2412,7938,399,40721,3185,2,484,1,8187.29,NULL,'2023-01-03 20:41:39','2023-01-03 20:41:39',NULL),(2413,7938,400,40721,3183,2,425,1,97601.59,NULL,'2023-01-03 21:07:46','2023-01-03 21:09:06','2023-01-03 21:09:06'),(2414,7938,400,40721,3183,2,510,2,82814.76,NULL,'2023-01-03 21:07:46','2023-01-03 21:09:06','2023-01-03 21:09:06'),(2415,7938,400,40721,3183,2,67,2,14786.83,NULL,'2023-01-03 21:07:46','2023-01-03 21:09:06','2023-01-03 21:09:06'),(2416,7938,401,40721,3183,2,425,1,97601.59,NULL,'2023-01-03 21:09:06','2023-01-03 22:14:11','2023-01-03 22:14:11'),(2417,7938,401,40721,3183,2,510,2,70413.45,NULL,'2023-01-03 21:09:06','2023-01-03 22:14:11','2023-01-03 22:14:11'),(2418,7938,401,40721,3183,2,67,2,14786.83,NULL,'2023-01-03 21:09:06','2023-01-03 22:14:11','2023-01-03 22:14:11'),(2419,7938,401,40721,3183,2,511,2,12401.31,NULL,'2023-01-03 21:09:06','2023-01-03 22:14:11','2023-01-03 22:14:11'),(2420,7938,402,40721,3197,2,425,1,2672242.24,NULL,'2023-01-03 21:11:09','2023-01-03 21:11:09',NULL),(2421,7938,402,40721,3197,2,23,1,54014.40,NULL,'2023-01-03 21:11:09','2023-01-03 21:11:09',NULL);
INSERT INTO `balance_libro_details` VALUES (2422,7938,402,40721,3197,2,486,1,66960.00,NULL,'2023-01-03 21:11:09','2023-01-03 21:11:09',NULL),(2423,7938,402,40721,3197,2,510,2,2386712.78,NULL,'2023-01-03 21:11:09','2023-01-03 21:11:09',NULL),(2424,7938,402,40721,3197,2,67,2,499455.66,NULL,'2023-01-03 21:11:09','2023-01-03 21:11:09',NULL),(2425,7938,402,40721,3197,2,511,1,92951.80,NULL,'2023-01-03 21:11:09','2023-01-03 21:11:09',NULL),(2426,7938,403,40721,3197,2,386,1,29347.19,NULL,'2023-01-03 21:12:05','2023-01-03 21:15:25','2023-01-03 21:15:25'),(2427,7938,403,40721,3197,2,102,2,29347.19,NULL,'2023-01-03 21:12:05','2023-01-03 21:15:25','2023-01-03 21:15:25'),(2428,7938,404,40721,3196,2,386,1,26789.94,NULL,'2023-01-03 21:12:22','2023-01-03 21:12:22',NULL),(2429,7938,404,40721,3196,2,102,2,26789.94,NULL,'2023-01-03 21:12:22','2023-01-03 21:12:22',NULL),(2430,7938,405,40721,3195,2,386,1,26789.94,NULL,'2023-01-03 21:12:41','2023-01-03 21:12:41',NULL),(2431,7938,405,40721,3195,2,102,2,26789.94,NULL,'2023-01-03 21:12:41','2023-01-03 21:12:41',NULL),(2432,7938,406,40721,3194,2,386,1,21802.01,NULL,'2023-01-03 21:12:59','2023-01-03 21:12:59',NULL),(2433,7938,406,40721,3194,2,102,2,21802.01,NULL,'2023-01-03 21:12:59','2023-01-03 21:12:59',NULL),(2434,7938,407,40721,3197,2,386,1,23431.29,NULL,'2023-01-03 21:15:25','2023-01-03 21:15:25',NULL),(2435,7938,407,40721,3197,2,102,2,23431.29,NULL,'2023-01-03 21:15:25','2023-01-03 21:15:25',NULL),(2436,7938,408,40721,3195,3,20,1,5598.39,NULL,'2023-01-03 21:37:24','2023-01-03 21:37:24',NULL),(2437,7938,408,40721,3195,3,157,2,4081.73,NULL,'2023-01-03 21:37:24','2023-01-03 21:37:24',NULL),(2438,7938,408,40721,3195,3,24,2,1516.66,NULL,'2023-01-03 21:37:24','2023-01-03 21:37:24',NULL),(2439,7938,409,40721,3194,3,20,1,5598.39,NULL,'2023-01-03 21:38:07','2023-01-03 21:38:07',NULL),(2440,7938,409,40721,3194,3,24,2,5598.39,NULL,'2023-01-03 21:38:07','2023-01-03 21:38:07',NULL),(2441,7938,410,40721,3193,3,20,1,5598.39,NULL,'2023-01-03 21:38:32','2023-01-03 21:38:32',NULL),(2442,7938,410,40721,3193,3,24,2,5598.39,NULL,'2023-01-03 21:38:32','2023-01-03 21:38:32',NULL),(2443,7938,411,40721,3191,3,20,1,16801.88,NULL,'2023-01-03 21:39:06','2023-01-03 21:39:06',NULL),(2444,7938,411,40721,3191,3,24,2,16801.88,NULL,'2023-01-03 21:39:06','2023-01-03 21:39:06',NULL),(2445,7938,412,40721,3192,3,20,1,5598.39,NULL,'2023-01-03 21:40:21','2023-01-03 21:40:21',NULL),(2446,7938,412,40721,3192,3,24,2,5598.39,NULL,'2023-01-03 21:40:21','2023-01-03 21:40:21',NULL),(2447,7938,413,40721,3196,15,67,1,598397.50,NULL,'2023-01-03 21:43:22','2023-01-03 21:43:22',NULL),(2448,7938,413,40721,3196,15,68,2,203982.54,NULL,'2023-01-03 21:43:22','2023-01-03 21:43:22',NULL),(2449,7938,413,40721,3196,15,25,2,243088.53,NULL,'2023-01-03 21:43:22','2023-01-03 21:43:22',NULL),(2450,7938,413,40721,3196,15,74,2,104077.22,NULL,'2023-01-03 21:43:22','2023-01-03 21:43:22',NULL),(2451,7938,413,40721,3196,15,353,2,47249.21,NULL,'2023-01-03 21:43:22','2023-01-03 21:43:22',NULL),(2452,7938,414,40721,3190,3,155,1,244158.24,NULL,'2023-01-03 21:45:13','2023-01-03 21:45:13',NULL),(2453,7938,414,40721,3190,3,24,1,12879.43,NULL,'2023-01-03 21:45:13','2023-01-03 21:45:13',NULL),(2454,7938,414,40721,3190,3,157,2,80086.94,NULL,'2023-01-03 21:45:13','2023-01-03 21:45:13',NULL),(2455,7938,414,40721,3190,3,23,2,176950.73,NULL,'2023-01-03 21:45:13','2023-01-03 21:45:13',NULL),(2456,7938,415,40721,3183,3,68,1,89646.50,NULL,'2023-01-03 21:54:53','2023-01-03 21:56:17','2023-01-03 21:56:17'),(2457,7938,415,40721,3183,3,62,1,218898.00,NULL,'2023-01-03 21:54:53','2023-01-03 21:56:17','2023-01-03 21:56:17'),(2458,7938,415,40721,3183,3,500,1,87341.81,NULL,'2023-01-03 21:54:53','2023-01-03 21:56:17','2023-01-03 21:56:17'),(2459,7938,415,40721,3183,3,64,1,4531.70,NULL,'2023-01-03 21:54:53','2023-01-03 21:56:17','2023-01-03 21:56:17'),(2460,7938,415,40721,3183,3,396,1,2826.00,NULL,'2023-01-03 21:54:53','2023-01-03 21:56:17','2023-01-03 21:56:17');
INSERT INTO `balance_libro_details` VALUES (2461,7938,415,40721,3183,3,502,1,293948.56,NULL,'2023-01-03 21:54:53','2023-01-03 21:56:17','2023-01-03 21:56:17'),(2462,7938,415,40721,3183,3,74,1,25060.57,NULL,'2023-01-03 21:54:53','2023-01-03 21:56:17','2023-01-03 21:56:17'),(2463,7938,415,40721,3183,3,78,1,52.39,NULL,'2023-01-03 21:54:53','2023-01-03 21:56:17','2023-01-03 21:56:17'),(2464,7938,415,40721,3183,3,503,1,22826.54,NULL,'2023-01-03 21:54:53','2023-01-03 21:56:17','2023-01-03 21:56:17'),(2465,7938,415,40721,3183,3,135,1,16902.18,NULL,'2023-01-03 21:54:53','2023-01-03 21:56:17','2023-01-03 21:56:17'),(2466,7938,415,40721,3183,3,25,1,769.59,NULL,'2023-01-03 21:54:53','2023-01-03 21:56:17','2023-01-03 21:56:17'),(2467,7938,415,40721,3183,3,504,1,2546.66,NULL,'2023-01-03 21:54:53','2023-01-03 21:56:17','2023-01-03 21:56:17'),(2468,7938,415,40721,3183,3,486,1,1085.52,NULL,'2023-01-03 21:54:53','2023-01-03 21:56:17','2023-01-03 21:56:17'),(2469,7938,415,40721,3183,3,157,1,9983.80,NULL,'2023-01-03 21:54:53','2023-01-03 21:56:17','2023-01-03 21:56:17'),(2470,7938,415,40721,3183,3,425,2,776419.82,NULL,'2023-01-03 21:54:53','2023-01-03 21:56:17','2023-01-03 21:56:17'),(2471,7938,416,40721,3183,3,68,1,89646.50,NULL,'2023-01-03 21:56:17','2023-01-03 22:30:50','2023-01-03 22:30:50'),(2472,7938,416,40721,3183,3,62,1,218898.00,NULL,'2023-01-03 21:56:17','2023-01-03 22:30:50','2023-01-03 22:30:50'),(2473,7938,416,40721,3183,3,500,1,87341.81,NULL,'2023-01-03 21:56:17','2023-01-03 22:30:50','2023-01-03 22:30:50'),(2474,7938,416,40721,3183,3,64,1,4531.70,NULL,'2023-01-03 21:56:17','2023-01-03 22:30:50','2023-01-03 22:30:50'),(2475,7938,416,40721,3183,3,396,1,2826.00,NULL,'2023-01-03 21:56:17','2023-01-03 22:30:50','2023-01-03 22:30:50'),(2476,7938,416,40721,3183,3,502,1,293948.56,NULL,'2023-01-03 21:56:17','2023-01-03 22:30:50','2023-01-03 22:30:50'),(2477,7938,416,40721,3183,3,74,1,25060.57,NULL,'2023-01-03 21:56:17','2023-01-03 22:30:50','2023-01-03 22:30:50'),(2478,7938,416,40721,3183,3,78,1,52.39,NULL,'2023-01-03 21:56:17','2023-01-03 22:30:50','2023-01-03 22:30:50'),(2479,7938,416,40721,3183,3,503,1,22826.54,NULL,'2023-01-03 21:56:17','2023-01-03 22:30:50','2023-01-03 22:30:50'),(2480,7938,416,40721,3183,3,135,1,17084.88,NULL,'2023-01-03 21:56:17','2023-01-03 22:30:50','2023-01-03 22:30:50'),(2481,7938,416,40721,3183,3,25,1,586.89,NULL,'2023-01-03 21:56:17','2023-01-03 22:30:50','2023-01-03 22:30:50'),(2482,7938,416,40721,3183,3,504,1,2546.66,NULL,'2023-01-03 21:56:17','2023-01-03 22:30:50','2023-01-03 22:30:50'),(2483,7938,416,40721,3183,3,486,1,1085.52,NULL,'2023-01-03 21:56:17','2023-01-03 22:30:50','2023-01-03 22:30:50'),(2484,7938,416,40721,3183,3,157,1,9983.80,NULL,'2023-01-03 21:56:17','2023-01-03 22:30:50','2023-01-03 22:30:50'),(2485,7938,416,40721,3183,3,425,2,776419.82,NULL,'2023-01-03 21:56:17','2023-01-03 22:30:50','2023-01-03 22:30:50'),(2486,7938,417,40721,3184,3,68,1,12748.33,NULL,'2023-01-03 22:00:04','2023-01-03 22:01:40','2023-01-03 22:01:40'),(2487,7938,417,40721,3184,3,62,1,210646.00,NULL,'2023-01-03 22:00:04','2023-01-03 22:01:40','2023-01-03 22:01:40'),(2488,7938,417,40721,3184,3,500,1,90350.12,NULL,'2023-01-03 22:00:04','2023-01-03 22:01:40','2023-01-03 22:01:40'),(2489,7938,417,40721,3184,3,64,1,7865.00,NULL,'2023-01-03 22:00:04','2023-01-03 22:01:40','2023-01-03 22:01:40'),(2490,7938,417,40721,3184,3,396,1,2826.00,NULL,'2023-01-03 22:00:04','2023-01-03 22:01:40','2023-01-03 22:01:40'),(2491,7938,417,40721,3184,3,502,1,336098.26,NULL,'2023-01-03 22:00:04','2023-01-03 22:01:40','2023-01-03 22:01:40'),(2492,7938,417,40721,3184,3,78,1,116.32,NULL,'2023-01-03 22:00:04','2023-01-03 22:01:40','2023-01-03 22:01:40'),(2493,7938,417,40721,3184,3,503,1,22494.74,NULL,'2023-01-03 22:00:04','2023-01-03 22:01:40','2023-01-03 22:01:40'),(2494,7938,417,40721,3184,3,135,1,76532.87,NULL,'2023-01-03 22:00:04','2023-01-03 22:01:40','2023-01-03 22:01:40'),(2495,7938,417,40721,3184,3,25,1,794.56,NULL,'2023-01-03 22:00:04','2023-01-03 22:01:40','2023-01-03 22:01:40');
INSERT INTO `balance_libro_details` VALUES (2496,7938,417,40721,3184,3,504,1,2284.85,NULL,'2023-01-03 22:00:04','2023-01-03 22:01:40','2023-01-03 22:01:40'),(2497,7938,417,40721,3184,3,486,1,908.21,NULL,'2023-01-03 22:00:04','2023-01-03 22:01:40','2023-01-03 22:01:40'),(2498,7938,417,40721,3184,3,157,1,9648.43,NULL,'2023-01-03 22:00:04','2023-01-03 22:01:40','2023-01-03 22:01:40'),(2499,7938,417,40721,3184,3,425,2,773313.69,NULL,'2023-01-03 22:00:04','2023-01-03 22:01:40','2023-01-03 22:01:40'),(2500,7938,418,40721,3184,3,68,1,12748.33,NULL,'2023-01-03 22:01:40','2023-01-03 22:48:18','2023-01-03 22:48:18'),(2501,7938,418,40721,3184,3,62,1,210646.00,NULL,'2023-01-03 22:01:40','2023-01-03 22:48:18','2023-01-03 22:48:18'),(2502,7938,418,40721,3184,3,500,1,90350.12,NULL,'2023-01-03 22:01:40','2023-01-03 22:48:18','2023-01-03 22:48:18'),(2503,7938,418,40721,3184,3,64,1,7865.00,NULL,'2023-01-03 22:01:40','2023-01-03 22:48:18','2023-01-03 22:48:18'),(2504,7938,418,40721,3184,3,396,1,2826.00,NULL,'2023-01-03 22:01:40','2023-01-03 22:48:18','2023-01-03 22:48:18'),(2505,7938,418,40721,3184,3,502,1,336098.26,NULL,'2023-01-03 22:01:40','2023-01-03 22:48:18','2023-01-03 22:48:18'),(2506,7938,418,40721,3184,3,78,1,116.32,NULL,'2023-01-03 22:01:40','2023-01-03 22:48:18','2023-01-03 22:48:18'),(2507,7938,418,40721,3184,3,503,1,22494.74,NULL,'2023-01-03 22:01:40','2023-01-03 22:48:18','2023-01-03 22:48:18'),(2508,7938,418,40721,3184,3,135,1,76653.87,NULL,'2023-01-03 22:01:40','2023-01-03 22:48:18','2023-01-03 22:48:18'),(2509,7938,418,40721,3184,3,25,1,673.56,NULL,'2023-01-03 22:01:40','2023-01-03 22:48:18','2023-01-03 22:48:18'),(2510,7938,418,40721,3184,3,504,1,2284.85,NULL,'2023-01-03 22:01:40','2023-01-03 22:48:18','2023-01-03 22:48:18'),(2511,7938,418,40721,3184,3,486,1,908.21,NULL,'2023-01-03 22:01:40','2023-01-03 22:48:18','2023-01-03 22:48:18'),(2512,7938,418,40721,3184,3,157,1,9648.43,NULL,'2023-01-03 22:01:40','2023-01-03 22:48:18','2023-01-03 22:48:18'),(2513,7938,418,40721,3184,3,425,2,773313.69,NULL,'2023-01-03 22:01:40','2023-01-03 22:48:18','2023-01-03 22:48:18'),(2514,7938,419,40721,3191,3,68,1,7338.66,NULL,'2023-01-03 22:05:10','2023-01-03 22:06:34','2023-01-03 22:06:34'),(2515,7938,419,40721,3191,3,62,1,268301.00,NULL,'2023-01-03 22:05:10','2023-01-03 22:06:34','2023-01-03 22:06:34'),(2516,7938,419,40721,3191,3,500,1,111607.52,NULL,'2023-01-03 22:05:10','2023-01-03 22:06:34','2023-01-03 22:06:34'),(2517,7938,419,40721,3191,3,64,1,7536.47,NULL,'2023-01-03 22:05:10','2023-01-03 22:06:34','2023-01-03 22:06:34'),(2518,7938,419,40721,3191,3,396,1,3000.00,NULL,'2023-01-03 22:05:10','2023-01-03 22:06:34','2023-01-03 22:06:34'),(2519,7938,419,40721,3191,3,502,1,438026.11,NULL,'2023-01-03 22:05:10','2023-01-03 22:06:34','2023-01-03 22:06:34'),(2520,7938,419,40721,3191,3,74,1,43527.39,NULL,'2023-01-03 22:05:10','2023-01-03 22:06:34','2023-01-03 22:06:34'),(2521,7938,419,40721,3191,3,78,1,28722.75,NULL,'2023-01-03 22:05:10','2023-01-03 22:06:34','2023-01-03 22:06:34'),(2522,7938,419,40721,3191,3,503,1,23115.62,NULL,'2023-01-03 22:05:10','2023-01-03 22:06:34','2023-01-03 22:06:34'),(2523,7938,419,40721,3191,3,135,1,9942.14,NULL,'2023-01-03 22:05:10','2023-01-03 22:06:34','2023-01-03 22:06:34'),(2524,7938,419,40721,3191,3,504,1,2372.86,NULL,'2023-01-03 22:05:10','2023-01-03 22:06:34','2023-01-03 22:06:34'),(2525,7938,419,40721,3191,3,486,1,7373.56,NULL,'2023-01-03 22:05:10','2023-01-03 22:06:34','2023-01-03 22:06:34'),(2526,7938,419,40721,3191,3,157,1,11914.21,NULL,'2023-01-03 22:05:10','2023-01-03 22:06:34','2023-01-03 22:06:34'),(2527,7938,419,40721,3191,3,505,1,30000.00,NULL,'2023-01-03 22:05:10','2023-01-03 22:06:34','2023-01-03 22:06:34'),(2528,7938,419,40721,3191,3,425,2,992778.29,NULL,'2023-01-03 22:05:10','2023-01-03 22:06:34','2023-01-03 22:06:34'),(2529,7938,420,40721,3191,3,68,1,7338.66,NULL,'2023-01-03 22:06:34','2023-01-03 22:47:48','2023-01-03 22:47:48'),(2530,7938,420,40721,3191,3,62,1,268301.00,NULL,'2023-01-03 22:06:34','2023-01-03 22:47:48','2023-01-03 22:47:48');
INSERT INTO `balance_libro_details` VALUES (2531,7938,420,40721,3191,3,500,1,111607.52,NULL,'2023-01-03 22:06:34','2023-01-03 22:47:48','2023-01-03 22:47:48'),(2532,7938,420,40721,3191,3,64,1,7536.47,NULL,'2023-01-03 22:06:34','2023-01-03 22:47:48','2023-01-03 22:47:48'),(2533,7938,420,40721,3191,3,396,1,3000.00,NULL,'2023-01-03 22:06:34','2023-01-03 22:47:48','2023-01-03 22:47:48'),(2534,7938,420,40721,3191,3,502,1,438026.11,NULL,'2023-01-03 22:06:34','2023-01-03 22:47:48','2023-01-03 22:47:48'),(2535,7938,420,40721,3191,3,74,1,43527.39,NULL,'2023-01-03 22:06:34','2023-01-03 22:47:48','2023-01-03 22:47:48'),(2536,7938,420,40721,3191,3,78,1,28722.75,NULL,'2023-01-03 22:06:34','2023-01-03 22:47:48','2023-01-03 22:47:48'),(2537,7938,420,40721,3191,3,503,1,23115.62,NULL,'2023-01-03 22:06:34','2023-01-03 22:47:48','2023-01-03 22:47:48'),(2538,7938,420,40721,3191,3,135,1,7443.47,NULL,'2023-01-03 22:06:34','2023-01-03 22:47:48','2023-01-03 22:47:48'),(2539,7938,420,40721,3191,3,504,1,2372.86,NULL,'2023-01-03 22:06:34','2023-01-03 22:47:48','2023-01-03 22:47:48'),(2540,7938,420,40721,3191,3,486,1,7373.56,NULL,'2023-01-03 22:06:34','2023-01-03 22:47:48','2023-01-03 22:47:48'),(2541,7938,420,40721,3191,3,157,1,11914.21,NULL,'2023-01-03 22:06:34','2023-01-03 22:47:48','2023-01-03 22:47:48'),(2542,7938,420,40721,3191,3,505,1,30000.00,NULL,'2023-01-03 22:06:34','2023-01-03 22:47:48','2023-01-03 22:47:48'),(2543,7938,420,40721,3191,3,425,2,992778.29,NULL,'2023-01-03 22:06:34','2023-01-03 22:47:48','2023-01-03 22:47:48'),(2544,7938,420,40721,3191,3,25,1,2498.67,NULL,'2023-01-03 22:06:34','2023-01-03 22:47:48','2023-01-03 22:47:48'),(2545,7938,421,40721,3183,2,425,1,97601.59,NULL,'2023-01-03 22:14:11','2023-01-03 22:14:11',NULL),(2546,7938,421,40721,3183,2,510,2,73477.91,NULL,'2023-01-03 22:14:11','2023-01-03 22:14:11',NULL),(2547,7938,421,40721,3183,2,67,2,14786.83,NULL,'2023-01-03 22:14:11','2023-01-03 22:14:11',NULL),(2548,7938,421,40721,3183,2,511,2,12401.31,NULL,'2023-01-03 22:14:11','2023-01-03 22:14:11',NULL),(2549,7938,421,40721,3183,2,486,1,3064.46,NULL,'2023-01-03 22:14:11','2023-01-03 22:14:11',NULL),(2550,7938,422,40721,3185,16,156,1,49567.80,NULL,'2023-01-03 22:23:19','2023-01-03 22:23:19',NULL),(2551,7938,422,40721,3185,16,485,1,23406.14,NULL,'2023-01-03 22:23:19','2023-01-03 22:23:19',NULL),(2552,7938,422,40721,3185,16,485,2,32401.90,NULL,'2023-01-03 22:23:19','2023-01-03 22:23:19',NULL),(2553,7938,422,40721,3185,16,78,2,22135.82,NULL,'2023-01-03 22:23:19','2023-01-03 22:23:19',NULL),(2554,7938,422,40721,3185,16,486,2,18436.22,NULL,'2023-01-03 22:23:19','2023-01-03 22:23:19',NULL),(2555,7938,423,40721,3195,16,156,1,76586.49,NULL,'2023-01-03 22:26:35','2023-01-10 21:24:44','2023-01-10 21:24:44'),(2556,7938,423,40721,3195,16,485,1,30329.44,NULL,'2023-01-03 22:26:35','2023-01-10 21:24:44','2023-01-10 21:24:44'),(2557,7938,423,40721,3195,16,209,2,8478.39,NULL,'2023-01-03 22:26:35','2023-01-10 21:24:44','2023-01-10 21:24:44'),(2558,7938,423,40721,3195,16,485,2,29672.51,NULL,'2023-01-03 22:26:35','2023-01-10 21:24:44','2023-01-10 21:24:44'),(2559,7938,423,40721,3195,16,78,2,39401.36,NULL,'2023-01-03 22:26:35','2023-01-10 21:24:44','2023-01-10 21:24:44'),(2560,7938,423,40721,3195,16,486,2,29363.67,NULL,'2023-01-03 22:26:35','2023-01-10 21:24:44','2023-01-10 21:24:44'),(2561,7938,424,40721,3186,3,68,1,13965.90,NULL,'2023-01-03 22:29:28','2023-01-03 22:47:18','2023-01-03 22:47:18'),(2562,7938,424,40721,3186,3,62,1,324400.00,NULL,'2023-01-03 22:29:28','2023-01-03 22:47:18','2023-01-03 22:47:18'),(2563,7938,424,40721,3186,3,500,1,89955.84,NULL,'2023-01-03 22:29:28','2023-01-03 22:47:18','2023-01-03 22:47:18'),(2564,7938,424,40721,3186,3,64,1,6833.52,NULL,'2023-01-03 22:29:28','2023-01-03 22:47:18','2023-01-03 22:47:18'),(2565,7938,424,40721,3186,3,396,1,2826.00,NULL,'2023-01-03 22:29:28','2023-01-03 22:47:18','2023-01-03 22:47:18'),(2566,7938,424,40721,3186,3,502,1,376927.78,NULL,'2023-01-03 22:29:28','2023-01-03 22:47:18','2023-01-03 22:47:18');
INSERT INTO `balance_libro_details` VALUES (2567,7938,424,40721,3186,3,74,1,41127.73,NULL,'2023-01-03 22:29:28','2023-01-03 22:47:18','2023-01-03 22:47:18'),(2568,7938,424,40721,3186,3,78,1,22135.82,NULL,'2023-01-03 22:29:28','2023-01-03 22:47:18','2023-01-03 22:47:18'),(2569,7938,424,40721,3186,3,503,1,19946.76,NULL,'2023-01-03 22:29:28','2023-01-03 22:47:18','2023-01-03 22:47:18'),(2570,7938,424,40721,3186,3,135,1,42457.73,NULL,'2023-01-03 22:29:28','2023-01-03 22:47:18','2023-01-03 22:47:18'),(2571,7938,424,40721,3186,3,25,1,678.24,NULL,'2023-01-03 22:29:28','2023-01-03 22:47:18','2023-01-03 22:47:18'),(2572,7938,424,40721,3186,3,504,1,2887.58,NULL,'2023-01-03 22:29:28','2023-01-03 22:47:18','2023-01-03 22:47:18'),(2573,7938,424,40721,3186,3,486,1,1406.37,NULL,'2023-01-03 22:29:28','2023-01-03 22:47:18','2023-01-03 22:47:18'),(2574,7938,424,40721,3186,3,157,1,11794.58,NULL,'2023-01-03 22:29:28','2023-01-03 22:47:18','2023-01-03 22:47:18'),(2575,7938,424,40721,3186,3,425,2,1002343.85,NULL,'2023-01-03 22:29:28','2023-01-03 22:47:18','2023-01-03 22:47:18'),(2576,7938,424,40721,3186,3,513,1,45000.00,NULL,'2023-01-03 22:29:28','2023-01-03 22:47:18','2023-01-03 22:47:18'),(2577,7938,425,40721,3183,3,68,1,89646.50,NULL,'2023-01-03 22:30:50','2023-01-03 22:46:52','2023-01-03 22:46:52'),(2578,7938,425,40721,3183,3,62,1,218898.00,NULL,'2023-01-03 22:30:50','2023-01-03 22:46:52','2023-01-03 22:46:52'),(2579,7938,425,40721,3183,3,64,1,4531.70,NULL,'2023-01-03 22:30:50','2023-01-03 22:46:52','2023-01-03 22:46:52'),(2580,7938,425,40721,3183,3,396,1,2826.00,NULL,'2023-01-03 22:30:50','2023-01-03 22:46:52','2023-01-03 22:46:52'),(2581,7938,425,40721,3183,3,502,1,293948.56,NULL,'2023-01-03 22:30:50','2023-01-03 22:46:52','2023-01-03 22:46:52'),(2582,7938,425,40721,3183,3,74,1,25060.57,NULL,'2023-01-03 22:30:50','2023-01-03 22:46:52','2023-01-03 22:46:52'),(2583,7938,425,40721,3183,3,78,1,52.39,NULL,'2023-01-03 22:30:50','2023-01-03 22:46:52','2023-01-03 22:46:52'),(2584,7938,425,40721,3183,3,503,1,22826.54,NULL,'2023-01-03 22:30:50','2023-01-03 22:46:52','2023-01-03 22:46:52'),(2585,7938,425,40721,3183,3,135,1,17084.88,NULL,'2023-01-03 22:30:50','2023-01-03 22:46:52','2023-01-03 22:46:52'),(2586,7938,425,40721,3183,3,25,1,586.89,NULL,'2023-01-03 22:30:50','2023-01-03 22:46:52','2023-01-03 22:46:52'),(2587,7938,425,40721,3183,3,504,1,2546.66,NULL,'2023-01-03 22:30:50','2023-01-03 22:46:52','2023-01-03 22:46:52'),(2588,7938,425,40721,3183,3,486,1,1085.52,NULL,'2023-01-03 22:30:50','2023-01-03 22:46:52','2023-01-03 22:46:52'),(2589,7938,425,40721,3183,3,157,1,9983.80,NULL,'2023-01-03 22:30:50','2023-01-03 22:46:52','2023-01-03 22:46:52'),(2590,7938,425,40721,3183,3,425,2,776419.82,NULL,'2023-01-03 22:30:50','2023-01-03 22:46:52','2023-01-03 22:46:52'),(2591,7938,425,40721,3183,3,76,1,87341.81,NULL,'2023-01-03 22:30:50','2023-01-03 22:46:52','2023-01-03 22:46:52'),(2592,7938,426,40721,3183,3,68,1,89646.50,NULL,'2023-01-03 22:46:52','2023-01-10 21:16:42','2023-01-10 21:16:42'),(2593,7938,426,40721,3183,3,62,1,218898.00,NULL,'2023-01-03 22:46:52','2023-01-10 21:16:42','2023-01-10 21:16:42'),(2594,7938,426,40721,3183,3,64,1,4531.70,NULL,'2023-01-03 22:46:52','2023-01-10 21:16:42','2023-01-10 21:16:42'),(2595,7938,426,40721,3183,3,396,1,2826.00,NULL,'2023-01-03 22:46:52','2023-01-10 21:16:42','2023-01-10 21:16:42'),(2596,7938,426,40721,3183,3,502,1,293948.56,NULL,'2023-01-03 22:46:52','2023-01-10 21:16:42','2023-01-10 21:16:42'),(2597,7938,426,40721,3183,3,74,1,25060.57,NULL,'2023-01-03 22:46:52','2023-01-10 21:16:42','2023-01-10 21:16:42'),(2598,7938,426,40721,3183,3,78,1,52.39,NULL,'2023-01-03 22:46:52','2023-01-10 21:16:42','2023-01-10 21:16:42'),(2599,7938,426,40721,3183,3,503,1,22826.54,NULL,'2023-01-03 22:46:52','2023-01-10 21:16:42','2023-01-10 21:16:42'),(2600,7938,426,40721,3183,3,135,1,17084.88,NULL,'2023-01-03 22:46:52','2023-01-10 21:16:42','2023-01-10 21:16:42'),(2601,7938,426,40721,3183,3,25,1,586.89,NULL,'2023-01-03 22:46:52','2023-01-10 21:16:42','2023-01-10 21:16:42');
INSERT INTO `balance_libro_details` VALUES (2602,7938,426,40721,3183,3,504,1,2546.66,NULL,'2023-01-03 22:46:52','2023-01-10 21:16:42','2023-01-10 21:16:42'),(2603,7938,426,40721,3183,3,157,1,9983.80,NULL,'2023-01-03 22:46:52','2023-01-10 21:16:42','2023-01-10 21:16:42'),(2604,7938,426,40721,3183,3,425,2,776419.82,NULL,'2023-01-03 22:46:52','2023-01-10 21:16:42','2023-01-10 21:16:42'),(2605,7938,426,40721,3183,3,76,1,87341.81,NULL,'2023-01-03 22:46:52','2023-01-10 21:16:42','2023-01-10 21:16:42'),(2606,7938,426,40721,3183,3,209,1,1085.52,NULL,'2023-01-03 22:46:52','2023-01-10 21:16:42','2023-01-10 21:16:42'),(2607,7938,427,40721,3186,3,68,1,13965.90,NULL,'2023-01-03 22:47:18','2023-01-10 21:16:10','2023-01-10 21:16:10'),(2608,7938,427,40721,3186,3,62,1,324400.00,NULL,'2023-01-03 22:47:18','2023-01-10 21:16:10','2023-01-10 21:16:10'),(2609,7938,427,40721,3186,3,500,1,89955.84,NULL,'2023-01-03 22:47:18','2023-01-10 21:16:10','2023-01-10 21:16:10'),(2610,7938,427,40721,3186,3,64,1,6833.52,NULL,'2023-01-03 22:47:18','2023-01-10 21:16:10','2023-01-10 21:16:10'),(2611,7938,427,40721,3186,3,396,1,2826.00,NULL,'2023-01-03 22:47:18','2023-01-10 21:16:10','2023-01-10 21:16:10'),(2612,7938,427,40721,3186,3,502,1,376927.78,NULL,'2023-01-03 22:47:18','2023-01-10 21:16:10','2023-01-10 21:16:10'),(2613,7938,427,40721,3186,3,74,1,41127.73,NULL,'2023-01-03 22:47:18','2023-01-10 21:16:10','2023-01-10 21:16:10'),(2614,7938,427,40721,3186,3,78,1,22135.82,NULL,'2023-01-03 22:47:18','2023-01-10 21:16:10','2023-01-10 21:16:10'),(2615,7938,427,40721,3186,3,503,1,19946.76,NULL,'2023-01-03 22:47:18','2023-01-10 21:16:10','2023-01-10 21:16:10'),(2616,7938,427,40721,3186,3,135,1,42457.73,NULL,'2023-01-03 22:47:18','2023-01-10 21:16:10','2023-01-10 21:16:10'),(2617,7938,427,40721,3186,3,25,1,678.24,NULL,'2023-01-03 22:47:18','2023-01-10 21:16:10','2023-01-10 21:16:10'),(2618,7938,427,40721,3186,3,504,1,2887.58,NULL,'2023-01-03 22:47:18','2023-01-10 21:16:10','2023-01-10 21:16:10'),(2619,7938,427,40721,3186,3,157,1,11794.58,NULL,'2023-01-03 22:47:18','2023-01-10 21:16:10','2023-01-10 21:16:10'),(2620,7938,427,40721,3186,3,425,2,1002343.85,NULL,'2023-01-03 22:47:18','2023-01-10 21:16:10','2023-01-10 21:16:10'),(2621,7938,427,40721,3186,3,513,1,45000.00,NULL,'2023-01-03 22:47:18','2023-01-10 21:16:10','2023-01-10 21:16:10'),(2622,7938,427,40721,3186,3,209,1,1406.37,NULL,'2023-01-03 22:47:18','2023-01-10 21:16:10','2023-01-10 21:16:10'),(2623,7938,428,40721,3191,3,68,1,7338.66,NULL,'2023-01-03 22:47:48','2023-01-10 21:15:27','2023-01-10 21:15:27'),(2624,7938,428,40721,3191,3,62,1,268301.00,NULL,'2023-01-03 22:47:48','2023-01-10 21:15:27','2023-01-10 21:15:27'),(2625,7938,428,40721,3191,3,500,1,111607.52,NULL,'2023-01-03 22:47:48','2023-01-10 21:15:27','2023-01-10 21:15:27'),(2626,7938,428,40721,3191,3,64,1,7536.47,NULL,'2023-01-03 22:47:48','2023-01-10 21:15:27','2023-01-10 21:15:27'),(2627,7938,428,40721,3191,3,396,1,3000.00,NULL,'2023-01-03 22:47:48','2023-01-10 21:15:27','2023-01-10 21:15:27'),(2628,7938,428,40721,3191,3,502,1,438026.11,NULL,'2023-01-03 22:47:48','2023-01-10 21:15:27','2023-01-10 21:15:27'),(2629,7938,428,40721,3191,3,74,1,43527.39,NULL,'2023-01-03 22:47:48','2023-01-10 21:15:27','2023-01-10 21:15:27'),(2630,7938,428,40721,3191,3,78,1,28722.75,NULL,'2023-01-03 22:47:48','2023-01-10 21:15:27','2023-01-10 21:15:27'),(2631,7938,428,40721,3191,3,503,1,23115.62,NULL,'2023-01-03 22:47:48','2023-01-10 21:15:27','2023-01-10 21:15:27'),(2632,7938,428,40721,3191,3,135,1,7443.47,NULL,'2023-01-03 22:47:48','2023-01-10 21:15:27','2023-01-10 21:15:27'),(2633,7938,428,40721,3191,3,504,1,2372.86,NULL,'2023-01-03 22:47:48','2023-01-10 21:15:27','2023-01-10 21:15:27'),(2634,7938,428,40721,3191,3,157,1,11914.21,NULL,'2023-01-03 22:47:48','2023-01-10 21:15:27','2023-01-10 21:15:27'),(2635,7938,428,40721,3191,3,505,1,30000.00,NULL,'2023-01-03 22:47:48','2023-01-10 21:15:27','2023-01-10 21:15:27'),(2636,7938,428,40721,3191,3,425,2,992778.29,NULL,'2023-01-03 22:47:48','2023-01-10 21:15:27','2023-01-10 21:15:27');
INSERT INTO `balance_libro_details` VALUES (2637,7938,428,40721,3191,3,25,1,2498.67,NULL,'2023-01-03 22:47:48','2023-01-10 21:15:27','2023-01-10 21:15:27'),(2638,7938,428,40721,3191,3,209,1,7373.56,NULL,'2023-01-03 22:47:48','2023-01-10 21:15:27','2023-01-10 21:15:27'),(2639,7938,429,40721,3184,3,68,1,12748.33,NULL,'2023-01-03 22:48:18','2023-01-09 19:29:01','2023-01-09 19:29:01'),(2640,7938,429,40721,3184,3,62,1,210646.00,NULL,'2023-01-03 22:48:18','2023-01-09 19:29:01','2023-01-09 19:29:01'),(2641,7938,429,40721,3184,3,500,1,90350.12,NULL,'2023-01-03 22:48:18','2023-01-09 19:29:01','2023-01-09 19:29:01'),(2642,7938,429,40721,3184,3,64,1,7865.00,NULL,'2023-01-03 22:48:18','2023-01-09 19:29:01','2023-01-09 19:29:01'),(2643,7938,429,40721,3184,3,396,1,2826.00,NULL,'2023-01-03 22:48:18','2023-01-09 19:29:01','2023-01-09 19:29:01'),(2644,7938,429,40721,3184,3,502,1,336098.26,NULL,'2023-01-03 22:48:18','2023-01-09 19:29:01','2023-01-09 19:29:01'),(2645,7938,429,40721,3184,3,78,1,116.32,NULL,'2023-01-03 22:48:18','2023-01-09 19:29:01','2023-01-09 19:29:01'),(2646,7938,429,40721,3184,3,503,1,22494.74,NULL,'2023-01-03 22:48:18','2023-01-09 19:29:01','2023-01-09 19:29:01'),(2647,7938,429,40721,3184,3,135,1,76653.87,NULL,'2023-01-03 22:48:18','2023-01-09 19:29:01','2023-01-09 19:29:01'),(2648,7938,429,40721,3184,3,25,1,673.56,NULL,'2023-01-03 22:48:18','2023-01-09 19:29:01','2023-01-09 19:29:01'),(2649,7938,429,40721,3184,3,504,1,2284.85,NULL,'2023-01-03 22:48:18','2023-01-09 19:29:01','2023-01-09 19:29:01'),(2650,7938,429,40721,3184,3,157,1,9648.43,NULL,'2023-01-03 22:48:18','2023-01-09 19:29:01','2023-01-09 19:29:01'),(2651,7938,429,40721,3184,3,425,2,773313.69,NULL,'2023-01-03 22:48:18','2023-01-09 19:29:01','2023-01-09 19:29:01'),(2652,7938,429,40721,3184,3,209,1,908.21,NULL,'2023-01-03 22:48:18','2023-01-09 19:29:01','2023-01-09 19:29:01'),(2653,7938,430,40721,3196,3,68,1,203982.54,NULL,'2023-01-03 22:49:02','2023-01-08 02:05:09','2023-01-08 02:05:09'),(2654,7938,430,40721,3196,3,62,1,317543.08,NULL,'2023-01-03 22:49:02','2023-01-08 02:05:09','2023-01-08 02:05:09'),(2655,7938,430,40721,3196,3,500,1,138245.67,NULL,'2023-01-03 22:49:02','2023-01-08 02:05:09','2023-01-08 02:05:09'),(2656,7938,430,40721,3196,3,64,1,9368.47,NULL,'2023-01-03 22:49:02','2023-01-08 02:05:09','2023-01-08 02:05:09'),(2657,7938,430,40721,3196,3,396,1,3500.00,NULL,'2023-01-03 22:49:02','2023-01-08 02:05:09','2023-01-08 02:05:09'),(2658,7938,430,40721,3196,3,502,1,1466969.57,NULL,'2023-01-03 22:49:02','2023-01-08 02:05:09','2023-01-08 02:05:09'),(2659,7938,430,40721,3196,3,78,1,39401.36,NULL,'2023-01-03 22:49:02','2023-01-08 02:05:09','2023-01-08 02:05:09'),(2660,7938,430,40721,3196,3,503,1,33422.24,NULL,'2023-01-03 22:49:02','2023-01-08 02:05:09','2023-01-08 02:05:09'),(2661,7938,430,40721,3196,3,135,1,52655.75,NULL,'2023-01-03 22:49:02','2023-01-08 02:05:09','2023-01-08 02:05:09'),(2662,7938,430,40721,3196,3,25,1,90.00,NULL,'2023-01-03 22:49:02','2023-01-08 02:05:09','2023-01-08 02:05:09'),(2663,7938,430,40721,3196,3,504,1,1861.09,NULL,'2023-01-03 22:49:02','2023-01-08 02:05:09','2023-01-08 02:05:09'),(2664,7938,430,40721,3196,3,157,1,19683.92,NULL,'2023-01-03 22:49:02','2023-01-08 02:05:09','2023-01-08 02:05:09'),(2665,7938,430,40721,3196,3,425,2,2308690.97,NULL,'2023-01-03 22:49:02','2023-01-08 02:05:09','2023-01-08 02:05:09'),(2666,7938,430,40721,3196,3,209,1,21967.28,NULL,'2023-01-03 22:49:02','2023-01-08 02:05:09','2023-01-08 02:05:09'),(2667,7938,431,40721,3197,3,68,1,204684.60,NULL,'2023-01-03 22:49:42','2023-01-08 01:51:18','2023-01-08 01:51:18'),(2668,7938,431,40721,3197,3,62,1,373093.95,NULL,'2023-01-03 22:49:42','2023-01-08 01:51:18','2023-01-08 01:51:18'),(2669,7938,431,40721,3197,3,500,1,128154.37,NULL,'2023-01-03 22:49:42','2023-01-08 01:51:18','2023-01-08 01:51:18'),(2670,7938,431,40721,3197,3,64,1,11257.20,NULL,'2023-01-03 22:49:42','2023-01-08 01:51:18','2023-01-08 01:51:18'),(2671,7938,431,40721,3197,3,396,1,4750.00,NULL,'2023-01-03 22:49:42','2023-01-08 01:51:18','2023-01-08 01:51:18');
INSERT INTO `balance_libro_details` VALUES (2672,7938,431,40721,3197,3,502,1,2192666.37,NULL,'2023-01-03 22:49:42','2023-01-08 01:51:18','2023-01-08 01:51:18'),(2673,7938,431,40721,3197,3,74,1,104182.20,NULL,'2023-01-03 22:49:42','2023-01-08 01:51:18','2023-01-08 01:51:18'),(2674,7938,431,40721,3197,3,78,1,88179.24,NULL,'2023-01-03 22:49:42','2023-01-08 01:51:18','2023-01-08 01:51:18'),(2675,7938,431,40721,3197,3,503,1,29877.91,NULL,'2023-01-03 22:49:42','2023-01-08 01:51:18','2023-01-08 01:51:18'),(2676,7938,431,40721,3197,3,135,1,163903.02,NULL,'2023-01-03 22:49:42','2023-01-08 01:51:18','2023-01-08 01:51:18'),(2677,7938,431,40721,3197,3,25,1,135.00,NULL,'2023-01-03 22:49:42','2023-01-08 01:51:18','2023-01-08 01:51:18'),(2678,7938,431,40721,3197,3,504,1,2825.30,NULL,'2023-01-03 22:49:42','2023-01-08 01:51:18','2023-01-08 01:51:18'),(2679,7938,431,40721,3197,3,157,1,48953.12,NULL,'2023-01-03 22:49:42','2023-01-08 01:51:18','2023-01-08 01:51:18'),(2680,7938,431,40721,3197,3,425,2,3640145.14,NULL,'2023-01-03 22:49:42','2023-01-08 01:51:18','2023-01-08 01:51:18'),(2681,7938,431,40721,3197,3,492,1,256890.00,NULL,'2023-01-03 22:49:42','2023-01-08 01:51:18','2023-01-08 01:51:18'),(2682,7938,431,40721,3197,3,209,1,30592.86,NULL,'2023-01-03 22:49:42','2023-01-08 01:51:18','2023-01-08 01:51:18'),(2683,7938,432,40721,3195,3,68,1,91871.68,NULL,'2023-01-03 22:50:26','2023-01-10 21:14:35','2023-01-10 21:14:35'),(2684,7938,432,40721,3195,3,62,1,321251.00,NULL,'2023-01-03 22:50:26','2023-01-10 21:14:35','2023-01-10 21:14:35'),(2685,7938,432,40721,3195,3,500,1,160696.54,NULL,'2023-01-03 22:50:26','2023-01-10 21:14:35','2023-01-10 21:14:35'),(2686,7938,432,40721,3195,3,64,1,9517.00,NULL,'2023-01-03 22:50:26','2023-01-10 21:14:35','2023-01-10 21:14:35'),(2687,7938,432,40721,3195,3,396,1,3000.00,NULL,'2023-01-03 22:50:26','2023-01-10 21:14:35','2023-01-10 21:14:35'),(2688,7938,432,40721,3195,3,502,1,542949.36,NULL,'2023-01-03 22:50:26','2023-01-10 21:14:35','2023-01-10 21:14:35'),(2689,7938,432,40721,3195,3,78,1,33133.75,NULL,'2023-01-03 22:50:26','2023-01-10 21:14:35','2023-01-10 21:14:35'),(2690,7938,432,40721,3195,3,503,1,29678.17,NULL,'2023-01-03 22:50:26','2023-01-10 21:14:35','2023-01-10 21:14:35'),(2691,7938,432,40721,3195,3,135,1,63318.41,NULL,'2023-01-03 22:50:26','2023-01-10 21:14:35','2023-01-10 21:14:35'),(2692,7938,432,40721,3195,3,25,1,90.00,NULL,'2023-01-03 22:50:26','2023-01-10 21:14:35','2023-01-10 21:14:35'),(2693,7938,432,40721,3195,3,504,1,3800.07,NULL,'2023-01-03 22:50:26','2023-01-10 21:14:35','2023-01-10 21:14:35'),(2694,7938,432,40721,3195,3,157,1,16618.60,NULL,'2023-01-03 22:50:26','2023-01-10 21:14:35','2023-01-10 21:14:35'),(2695,7938,432,40721,3195,3,505,1,2309.19,NULL,'2023-01-03 22:50:26','2023-01-10 21:14:35','2023-01-10 21:14:35'),(2696,7938,432,40721,3195,3,425,2,1455445.84,NULL,'2023-01-03 22:50:26','2023-01-10 21:14:35','2023-01-10 21:14:35'),(2697,7938,432,40721,3195,3,492,1,167038.00,NULL,'2023-01-03 22:50:26','2023-01-10 21:14:35','2023-01-10 21:14:35'),(2698,7938,432,40721,3195,3,209,1,10174.07,NULL,'2023-01-03 22:50:26','2023-01-10 21:14:35','2023-01-10 21:14:35'),(2699,7938,433,40721,3194,3,68,1,84219.91,NULL,'2023-01-03 22:50:52','2023-01-10 21:13:33','2023-01-10 21:13:33'),(2700,7938,433,40721,3194,3,62,1,406166.00,NULL,'2023-01-03 22:50:52','2023-01-10 21:13:33','2023-01-10 21:13:33'),(2701,7938,433,40721,3194,3,500,1,139141.52,NULL,'2023-01-03 22:50:52','2023-01-10 21:13:33','2023-01-10 21:13:33'),(2702,7938,433,40721,3194,3,64,1,24797.39,NULL,'2023-01-03 22:50:52','2023-01-10 21:13:33','2023-01-10 21:13:33'),(2703,7938,433,40721,3194,3,396,1,3000.00,NULL,'2023-01-03 22:50:52','2023-01-10 21:13:33','2023-01-10 21:13:33'),(2704,7938,433,40721,3194,3,502,1,523829.98,NULL,'2023-01-03 22:50:52','2023-01-10 21:13:33','2023-01-10 21:13:33'),(2705,7938,433,40721,3194,3,78,1,37195.96,NULL,'2023-01-03 22:50:52','2023-01-10 21:13:33','2023-01-10 21:13:33');
INSERT INTO `balance_libro_details` VALUES (2706,7938,433,40721,3194,3,503,1,22804.79,NULL,'2023-01-03 22:50:52','2023-01-10 21:13:33','2023-01-10 21:13:33'),(2707,7938,433,40721,3194,3,135,1,51276.00,NULL,'2023-01-03 22:50:52','2023-01-10 21:13:33','2023-01-10 21:13:33'),(2708,7938,433,40721,3194,3,25,1,90.00,NULL,'2023-01-03 22:50:52','2023-01-10 21:13:33','2023-01-10 21:13:33'),(2709,7938,433,40721,3194,3,504,1,4255.83,NULL,'2023-01-03 22:50:52','2023-01-10 21:13:33','2023-01-10 21:13:33'),(2710,7938,433,40721,3194,3,157,1,14578.09,NULL,'2023-01-03 22:50:52','2023-01-10 21:13:33','2023-01-10 21:13:33'),(2711,7938,433,40721,3194,3,425,2,1320610.77,NULL,'2023-01-03 22:50:52','2023-01-10 21:13:33','2023-01-10 21:13:33'),(2712,7938,433,40721,3194,3,209,1,9255.30,NULL,'2023-01-03 22:50:52','2023-01-10 21:13:33','2023-01-10 21:13:33'),(2713,7938,434,40721,3193,3,68,1,76398.84,NULL,'2023-01-03 22:51:57','2023-01-10 21:12:30','2023-01-10 21:12:30'),(2714,7938,434,40721,3193,3,62,1,309933.00,NULL,'2023-01-03 22:51:57','2023-01-10 21:12:30','2023-01-10 21:12:30'),(2715,7938,434,40721,3193,3,500,1,114680.63,NULL,'2023-01-03 22:51:57','2023-01-10 21:12:30','2023-01-10 21:12:30'),(2716,7938,434,40721,3193,3,396,1,3000.00,NULL,'2023-01-03 22:51:57','2023-01-10 21:12:30','2023-01-10 21:12:30'),(2717,7938,434,40721,3193,3,502,1,528524.53,NULL,'2023-01-03 22:51:57','2023-01-10 21:12:30','2023-01-10 21:12:30'),(2718,7938,434,40721,3193,3,74,1,51473.76,NULL,'2023-01-03 22:51:57','2023-01-10 21:12:30','2023-01-10 21:12:30'),(2719,7938,434,40721,3193,3,78,1,34505.54,NULL,'2023-01-03 22:51:57','2023-01-10 21:12:30','2023-01-10 21:12:30'),(2720,7938,434,40721,3193,3,503,1,23981.40,NULL,'2023-01-03 22:51:57','2023-01-10 21:12:30','2023-01-10 21:12:30'),(2721,7938,434,40721,3193,3,135,1,62838.97,NULL,'2023-01-03 22:51:57','2023-01-10 21:12:30','2023-01-10 21:12:30'),(2722,7938,434,40721,3193,3,25,1,720.00,NULL,'2023-01-03 22:51:57','2023-01-10 21:12:30','2023-01-10 21:12:30'),(2723,7938,434,40721,3193,3,504,1,2927.83,NULL,'2023-01-03 22:51:57','2023-01-10 21:12:30','2023-01-10 21:12:30'),(2724,7938,434,40721,3193,3,157,1,17543.38,NULL,'2023-01-03 22:51:57','2023-01-10 21:12:30','2023-01-10 21:12:30'),(2725,7938,434,40721,3193,3,425,2,1236753.25,NULL,'2023-01-03 22:51:57','2023-01-10 21:12:30','2023-01-10 21:12:30'),(2726,7938,434,40721,3193,3,209,1,10225.37,NULL,'2023-01-03 22:51:57','2023-01-10 21:12:30','2023-01-10 21:12:30'),(2727,7938,435,40721,3192,3,68,1,16359.97,NULL,'2023-01-03 22:52:33','2023-01-10 21:11:14','2023-01-10 21:11:14'),(2728,7938,435,40721,3192,3,62,1,287074.00,NULL,'2023-01-03 22:52:33','2023-01-10 21:11:14','2023-01-10 21:11:14'),(2729,7938,435,40721,3192,3,500,1,114857.37,NULL,'2023-01-03 22:52:33','2023-01-10 21:11:14','2023-01-10 21:11:14'),(2730,7938,435,40721,3192,3,64,1,1222.89,NULL,'2023-01-03 22:52:33','2023-01-10 21:11:14','2023-01-10 21:11:14'),(2731,7938,435,40721,3192,3,396,1,3000.00,NULL,'2023-01-03 22:52:33','2023-01-10 21:11:14','2023-01-10 21:11:14'),(2732,7938,435,40721,3192,3,502,1,469345.46,NULL,'2023-01-03 22:52:33','2023-01-10 21:11:14','2023-01-10 21:11:14'),(2733,7938,435,40721,3192,3,74,1,50562.82,NULL,'2023-01-03 22:52:33','2023-01-10 21:11:14','2023-01-10 21:11:14'),(2734,7938,435,40721,3192,3,78,1,30070.06,NULL,'2023-01-03 22:52:33','2023-01-10 21:11:14','2023-01-10 21:11:14'),(2735,7938,435,40721,3192,3,503,1,22886.98,NULL,'2023-01-03 22:52:33','2023-01-10 21:11:14','2023-01-10 21:11:14'),(2736,7938,435,40721,3192,3,135,1,32269.24,NULL,'2023-01-03 22:52:33','2023-01-10 21:11:14','2023-01-10 21:11:14'),(2737,7938,435,40721,3192,3,25,1,720.00,NULL,'2023-01-03 22:52:33','2023-01-10 21:11:14','2023-01-10 21:11:14'),(2738,7938,435,40721,3192,3,504,1,3912.48,NULL,'2023-01-03 22:52:33','2023-01-10 21:11:14','2023-01-10 21:11:14'),(2739,7938,435,40721,3192,3,157,1,13497.22,NULL,'2023-01-03 22:52:33','2023-01-10 21:11:14','2023-01-10 21:11:14'),(2740,7938,435,40721,3192,3,425,2,1054613.70,NULL,'2023-01-03 22:52:33','2023-01-10 21:11:14','2023-01-10 21:11:14');
INSERT INTO `balance_libro_details` VALUES (2741,7938,435,40721,3192,3,209,1,8835.21,NULL,'2023-01-03 22:52:33','2023-01-10 21:11:14','2023-01-10 21:11:14'),(2742,7938,436,40721,3190,3,68,1,10763.04,NULL,'2023-01-03 22:53:06','2023-01-10 21:10:17','2023-01-10 21:10:17'),(2743,7938,436,40721,3190,3,62,1,247649.00,NULL,'2023-01-03 22:53:06','2023-01-10 21:10:17','2023-01-10 21:10:17'),(2744,7938,436,40721,3190,3,500,1,139496.40,NULL,'2023-01-03 22:53:06','2023-01-10 21:10:17','2023-01-10 21:10:17'),(2745,7938,436,40721,3190,3,64,1,11264.00,NULL,'2023-01-03 22:53:06','2023-01-10 21:10:17','2023-01-10 21:10:17'),(2746,7938,436,40721,3190,3,396,1,2826.00,NULL,'2023-01-03 22:53:06','2023-01-10 21:10:17','2023-01-10 21:10:17'),(2747,7938,436,40721,3190,3,502,1,369432.36,NULL,'2023-01-03 22:53:06','2023-01-10 21:10:17','2023-01-10 21:10:17'),(2748,7938,436,40721,3190,3,74,1,40727.36,NULL,'2023-01-03 22:53:06','2023-01-10 21:10:17','2023-01-10 21:10:17'),(2749,7938,436,40721,3190,3,78,1,30089.78,NULL,'2023-01-03 22:53:06','2023-01-10 21:10:17','2023-01-10 21:10:17'),(2750,7938,436,40721,3190,3,503,1,22052.89,NULL,'2023-01-03 22:53:06','2023-01-10 21:10:17','2023-01-10 21:10:17'),(2751,7938,436,40721,3190,3,135,1,35210.31,NULL,'2023-01-03 22:53:06','2023-01-10 21:10:17','2023-01-10 21:10:17'),(2752,7938,436,40721,3190,3,25,1,678.24,NULL,'2023-01-03 22:53:06','2023-01-10 21:10:17','2023-01-10 21:10:17'),(2753,7938,436,40721,3190,3,504,1,3371.60,NULL,'2023-01-03 22:53:06','2023-01-10 21:10:17','2023-01-10 21:10:17'),(2754,7938,436,40721,3190,3,157,1,10386.76,NULL,'2023-01-03 22:53:06','2023-01-10 21:10:17','2023-01-10 21:10:17'),(2755,7938,436,40721,3190,3,425,2,931409.43,NULL,'2023-01-03 22:53:06','2023-01-10 21:10:17','2023-01-10 21:10:17'),(2756,7938,436,40721,3190,3,209,1,7461.69,NULL,'2023-01-03 22:53:06','2023-01-10 21:10:17','2023-01-10 21:10:17'),(2757,7938,437,40721,3185,3,68,1,11013.64,NULL,'2023-01-03 22:53:38','2023-01-10 21:09:02','2023-01-10 21:09:02'),(2758,7938,437,40721,3185,3,62,1,226220.00,NULL,'2023-01-03 22:53:38','2023-01-10 21:09:02','2023-01-10 21:09:02'),(2759,7938,437,40721,3185,3,500,1,87450.80,NULL,'2023-01-03 22:53:38','2023-01-10 21:09:02','2023-01-10 21:09:02'),(2760,7938,437,40721,3185,3,64,1,7710.00,NULL,'2023-01-03 22:53:38','2023-01-10 21:09:02','2023-01-10 21:09:02'),(2761,7938,437,40721,3185,3,396,1,2826.00,NULL,'2023-01-03 22:53:38','2023-01-10 21:09:02','2023-01-10 21:09:02'),(2762,7938,437,40721,3185,3,502,1,374344.93,NULL,'2023-01-03 22:53:38','2023-01-10 21:09:02','2023-01-10 21:09:02'),(2763,7938,437,40721,3185,3,74,1,172.08,NULL,'2023-01-03 22:53:38','2023-01-10 21:09:02','2023-01-10 21:09:02'),(2764,7938,437,40721,3185,3,78,1,41.92,NULL,'2023-01-03 22:53:38','2023-01-10 21:09:02','2023-01-10 21:09:02'),(2765,7938,437,40721,3185,3,503,1,21001.80,NULL,'2023-01-03 22:53:38','2023-01-10 21:09:02','2023-01-10 21:09:02'),(2766,7938,437,40721,3185,3,135,1,61576.06,NULL,'2023-01-03 22:53:38','2023-01-10 21:09:02','2023-01-10 21:09:02'),(2767,7938,437,40721,3185,3,25,1,506.16,NULL,'2023-01-03 22:53:38','2023-01-10 21:09:02','2023-01-10 21:09:02'),(2768,7938,437,40721,3185,3,504,1,1944.93,NULL,'2023-01-03 22:53:38','2023-01-10 21:09:02','2023-01-10 21:09:02'),(2769,7938,437,40721,3185,3,157,1,11261.97,NULL,'2023-01-03 22:53:38','2023-01-10 21:09:02','2023-01-10 21:09:02'),(2770,7938,437,40721,3185,3,425,2,807073.25,NULL,'2023-01-03 22:53:38','2023-01-10 21:09:02','2023-01-10 21:09:02'),(2771,7938,437,40721,3185,3,209,1,1002.96,NULL,'2023-01-03 22:53:38','2023-01-10 21:09:02','2023-01-10 21:09:02'),(2772,7938,438,40721,3197,18,497,1,22088.90,NULL,'2023-01-03 22:55:24','2023-01-10 21:21:19','2023-01-10 21:21:19'),(2773,7938,438,40721,3197,18,209,2,22088.90,NULL,'2023-01-03 22:55:24','2023-01-10 21:21:19','2023-01-10 21:21:19'),(2774,7938,439,40721,3183,3,506,1,6688.32,NULL,'2023-01-03 22:59:36','2023-01-03 23:00:11','2023-01-03 23:00:11'),(2775,7938,439,40721,3183,3,67,2,1326.12,NULL,'2023-01-03 22:59:36','2023-01-03 23:00:11','2023-01-03 23:00:11');
INSERT INTO `balance_libro_details` VALUES (2776,7938,439,40721,3183,3,507,2,5362.20,NULL,'2023-01-03 22:59:36','2023-01-03 23:00:11','2023-01-03 23:00:11'),(2777,7938,440,40721,3183,3,506,1,6668.32,NULL,'2023-01-03 23:00:11','2023-01-03 23:00:38','2023-01-03 23:00:38'),(2778,7938,440,40721,3183,3,67,2,1306.12,NULL,'2023-01-03 23:00:11','2023-01-03 23:00:38','2023-01-03 23:00:38'),(2779,7938,440,40721,3183,3,507,2,5362.20,NULL,'2023-01-03 23:00:11','2023-01-03 23:00:38','2023-01-03 23:00:38'),(2780,7938,441,40721,3183,3,506,1,6708.32,NULL,'2023-01-03 23:00:38','2023-01-03 23:12:59','2023-01-03 23:12:59'),(2781,7938,441,40721,3183,3,67,2,1346.12,NULL,'2023-01-03 23:00:38','2023-01-03 23:12:59','2023-01-03 23:12:59'),(2782,7938,441,40721,3183,3,507,2,5362.20,NULL,'2023-01-03 23:00:38','2023-01-03 23:12:59','2023-01-03 23:12:59'),(2783,7938,442,40721,3183,3,506,1,6488.26,NULL,'2023-01-03 23:12:59','2023-01-03 23:12:59',NULL),(2784,7938,442,40721,3183,3,67,2,1346.12,NULL,'2023-01-03 23:12:59','2023-01-03 23:12:59',NULL),(2785,7938,442,40721,3183,3,507,2,5142.14,NULL,'2023-01-03 23:12:59','2023-01-03 23:12:59',NULL),(2786,7938,443,40721,3183,1,110,1,262745.99,NULL,'2023-01-08 01:15:31','2023-01-10 17:57:10','2023-01-10 17:57:10'),(2787,7938,443,40721,3183,1,514,1,40911.00,NULL,'2023-01-08 01:15:31','2023-01-10 17:57:10','2023-01-10 17:57:10'),(2788,7938,443,40721,3183,1,515,1,13400.04,NULL,'2023-01-08 01:15:31','2023-01-10 17:57:10','2023-01-10 17:57:10'),(2789,7938,443,40721,3183,1,516,1,3209.34,NULL,'2023-01-08 01:15:31','2023-01-10 17:57:10','2023-01-10 17:57:10'),(2790,7938,443,40721,3183,1,517,1,73.05,NULL,'2023-01-08 01:15:31','2023-01-10 17:57:10','2023-01-10 17:57:10'),(2791,7938,443,40721,3183,1,518,1,985.11,NULL,'2023-01-08 01:15:31','2023-01-10 17:57:10','2023-01-10 17:57:10'),(2792,7938,443,40721,3183,1,519,1,300.00,NULL,'2023-01-08 01:15:31','2023-01-10 17:57:10','2023-01-10 17:57:10'),(2793,7938,443,40721,3183,1,62,2,215265.12,NULL,'2023-01-08 01:15:31','2023-01-10 17:57:10','2023-01-10 17:57:10'),(2794,7938,443,40721,3183,1,500,2,90350.12,NULL,'2023-01-08 01:15:31','2023-01-10 17:57:10','2023-01-10 17:57:10'),(2795,7938,443,40721,3183,1,484,2,8147.64,NULL,'2023-01-08 01:15:31','2023-01-10 17:57:10','2023-01-10 17:57:10'),(2796,7938,443,40721,3183,1,64,2,7861.65,NULL,'2023-01-08 01:15:31','2023-01-10 17:57:10','2023-01-10 17:57:10'),(2797,7938,444,40721,3184,1,110,1,256998.20,NULL,'2023-01-08 01:20:20','2023-01-08 01:20:20',NULL),(2798,7938,444,40721,3184,1,514,1,39824.65,NULL,'2023-01-08 01:20:20','2023-01-08 01:20:20',NULL),(2799,7938,444,40721,3184,1,515,1,13106.91,NULL,'2023-01-08 01:20:20','2023-01-08 01:20:20',NULL),(2800,7938,444,40721,3184,1,516,1,3156.82,NULL,'2023-01-08 01:20:20','2023-01-08 01:20:20',NULL),(2801,7938,444,40721,3184,1,517,1,73.05,NULL,'2023-01-08 01:20:20','2023-01-08 01:20:20',NULL),(2802,7938,444,40721,3184,1,518,1,985.11,NULL,'2023-01-08 01:20:20','2023-01-08 01:20:20',NULL),(2803,7938,444,40721,3184,1,519,1,300.00,NULL,'2023-01-08 01:20:20','2023-01-08 01:20:20',NULL),(2804,7938,444,40721,3184,1,62,2,210646.03,NULL,'2023-01-08 01:20:20','2023-01-08 01:20:20',NULL),(2805,7938,444,40721,3184,1,500,2,87450.80,NULL,'2023-01-08 01:20:20','2023-01-08 01:20:20',NULL),(2806,7938,444,40721,3184,1,484,2,8637.85,NULL,'2023-01-08 01:20:20','2023-01-08 01:20:20',NULL),(2807,7938,444,40721,3184,1,64,2,7710.06,NULL,'2023-01-08 01:20:20','2023-01-08 01:20:20',NULL),(2808,7938,445,40721,3185,1,110,1,273645.98,NULL,'2023-01-08 01:22:38','2023-01-09 19:34:53','2023-01-09 19:34:53'),(2809,7938,445,40721,3185,1,514,1,40177.75,NULL,'2023-01-08 01:22:38','2023-01-09 19:34:53','2023-01-09 19:34:53'),(2810,7938,445,40721,3185,1,515,1,13955.95,NULL,'2023-01-08 01:22:38','2023-01-09 19:34:53','2023-01-09 19:34:53'),(2811,7938,445,40721,3185,1,516,1,3351.60,NULL,'2023-01-08 01:22:38','2023-01-09 19:34:53','2023-01-09 19:34:53'),(2812,7938,445,40721,3185,1,517,1,73.05,NULL,'2023-01-08 01:22:38','2023-01-09 19:34:53','2023-01-09 19:34:53');
INSERT INTO `balance_libro_details` VALUES (2813,7938,445,40721,3185,1,518,1,1061.52,NULL,'2023-01-08 01:22:38','2023-01-09 19:34:53','2023-01-09 19:34:53'),(2814,7938,445,40721,3185,1,519,1,300.00,NULL,'2023-01-08 01:22:38','2023-01-09 19:34:53','2023-01-09 19:34:53'),(2815,7938,445,40721,3185,1,62,2,226189.95,NULL,'2023-01-08 01:22:38','2023-01-09 19:34:53','2023-01-09 19:34:53'),(2816,7938,445,40721,3185,1,500,2,89955.84,NULL,'2023-01-08 01:22:38','2023-01-09 19:34:53','2023-01-09 19:34:53'),(2817,7938,445,40721,3185,1,484,2,8187.29,NULL,'2023-01-08 01:22:38','2023-01-09 19:34:53','2023-01-09 19:34:53'),(2818,7938,445,40721,3185,1,64,2,8232.77,NULL,'2023-01-08 01:22:38','2023-01-09 19:34:53','2023-01-09 19:34:53'),(2819,7938,446,40721,3186,1,110,1,514264.56,NULL,'2023-01-08 01:25:53','2023-01-09 19:36:52','2023-01-09 19:36:52'),(2820,7938,446,40721,3186,1,514,1,61337.42,NULL,'2023-01-08 01:25:53','2023-01-09 19:36:52','2023-01-09 19:36:52'),(2821,7938,446,40721,3186,1,515,1,20176.04,NULL,'2023-01-08 01:25:53','2023-01-09 19:36:52','2023-01-09 19:36:52'),(2822,7938,446,40721,3186,1,516,1,4778.56,NULL,'2023-01-08 01:25:53','2023-01-09 19:36:52','2023-01-09 19:36:52'),(2823,7938,446,40721,3186,1,517,1,73.05,NULL,'2023-01-08 01:25:53','2023-01-09 19:36:52','2023-01-09 19:36:52'),(2824,7938,446,40721,3186,1,518,1,1061.52,NULL,'2023-01-08 01:25:53','2023-01-09 19:36:52','2023-01-09 19:36:52'),(2825,7938,446,40721,3186,1,519,1,300.00,NULL,'2023-01-08 01:25:53','2023-01-09 19:36:52','2023-01-09 19:36:52'),(2826,7938,446,40721,3186,1,62,2,443042.30,NULL,'2023-01-08 01:25:53','2023-01-09 19:36:52','2023-01-09 19:36:52'),(2827,7938,446,40721,3186,1,500,2,139496.40,NULL,'2023-01-08 01:25:53','2023-01-09 19:36:52','2023-01-09 19:36:52'),(2828,7938,446,40721,3186,1,484,2,8186.87,NULL,'2023-01-08 01:25:53','2023-01-09 19:36:52','2023-01-09 19:36:52'),(2829,7938,446,40721,3186,1,64,2,11265.58,NULL,'2023-01-08 01:25:53','2023-01-09 19:36:52','2023-01-09 19:36:52'),(2830,7938,447,40721,3190,1,110,1,305363.64,NULL,'2023-01-08 01:27:58','2023-01-09 19:40:09','2023-01-09 19:40:09'),(2831,7938,447,40721,3190,1,514,1,51448.72,NULL,'2023-01-08 01:27:58','2023-01-09 19:40:09','2023-01-09 19:40:09'),(2832,7938,447,40721,3190,1,515,1,15573.55,NULL,'2023-01-08 01:27:58','2023-01-09 19:40:09','2023-01-09 19:40:09'),(2833,7938,447,40721,3190,1,516,1,3872.75,NULL,'2023-01-08 01:27:58','2023-01-09 19:40:09','2023-01-09 19:40:09'),(2834,7938,447,40721,3190,1,517,1,73.05,NULL,'2023-01-08 01:27:58','2023-01-09 19:40:09','2023-01-09 19:40:09'),(2835,7938,447,40721,3190,1,518,1,1129.47,NULL,'2023-01-08 01:27:58','2023-01-09 19:40:09','2023-01-09 19:40:09'),(2836,7938,447,40721,3190,1,519,1,300.00,NULL,'2023-01-08 01:27:58','2023-01-09 19:40:09','2023-01-09 19:40:09'),(2837,7938,447,40721,3190,1,62,2,247619.99,NULL,'2023-01-08 01:27:58','2023-01-09 19:40:09','2023-01-09 19:40:09'),(2838,7938,447,40721,3190,1,500,2,111607.52,NULL,'2023-01-08 01:27:58','2023-01-09 19:40:09','2023-01-09 19:40:09'),(2839,7938,447,40721,3190,1,484,2,9441.10,NULL,'2023-01-08 01:27:58','2023-01-09 19:40:09','2023-01-09 19:40:09'),(2840,7938,447,40721,3190,1,64,2,9092.57,NULL,'2023-01-08 01:27:58','2023-01-09 19:40:09','2023-01-09 19:40:09'),(2841,7938,448,40721,3191,1,110,1,327719.39,NULL,'2023-01-08 01:30:02','2023-01-09 19:42:11','2023-01-09 19:42:11'),(2842,7938,448,40721,3191,1,514,1,52259.67,NULL,'2023-01-08 01:30:02','2023-01-09 19:42:11','2023-01-09 19:42:11'),(2843,7938,448,40721,3191,1,515,1,16713.69,NULL,'2023-01-08 01:30:02','2023-01-09 19:42:11','2023-01-09 19:42:11'),(2844,7938,448,40721,3191,1,516,1,4134.32,NULL,'2023-01-08 01:30:02','2023-01-09 19:42:11','2023-01-09 19:42:11'),(2845,7938,448,40721,3191,1,517,1,73.05,NULL,'2023-01-08 01:30:02','2023-01-09 19:42:11','2023-01-09 19:42:11'),(2846,7938,448,40721,3191,1,518,1,1222.89,NULL,'2023-01-08 01:30:02','2023-01-09 19:42:11','2023-01-09 19:42:11'),(2847,7938,448,40721,3191,1,519,1,300.00,NULL,'2023-01-08 01:30:02','2023-01-09 19:42:11','2023-01-09 19:42:11');
INSERT INTO `balance_libro_details` VALUES (2848,7938,448,40721,3191,1,62,2,268264.86,NULL,'2023-01-08 01:30:02','2023-01-09 19:42:11','2023-01-09 19:42:11'),(2849,7938,448,40721,3191,1,500,2,114857.37,NULL,'2023-01-08 01:30:02','2023-01-09 19:42:11','2023-01-09 19:42:11'),(2850,7938,448,40721,3191,1,484,2,9548.85,NULL,'2023-01-08 01:30:02','2023-01-09 19:42:11','2023-01-09 19:42:11'),(2851,7938,448,40721,3191,1,64,2,9751.93,NULL,'2023-01-08 01:30:02','2023-01-09 19:42:11','2023-01-09 19:42:11'),(2852,7938,449,40721,3192,1,110,1,348041.42,NULL,'2023-01-08 01:32:29','2023-01-10 17:58:08','2023-01-10 17:58:08'),(2853,7938,449,40721,3192,1,514,1,52996.98,NULL,'2023-01-08 01:32:29','2023-01-10 17:58:08','2023-01-10 17:58:08'),(2854,7938,449,40721,3192,1,515,1,17750.11,NULL,'2023-01-08 01:32:29','2023-01-10 17:58:08','2023-01-10 17:58:08'),(2855,7938,449,40721,3192,1,516,1,4372.08,NULL,'2023-01-08 01:32:29','2023-01-10 17:58:08','2023-01-10 17:58:08'),(2856,7938,449,40721,3192,1,517,1,111.63,NULL,'2023-01-08 01:32:29','2023-01-10 17:58:08','2023-01-10 17:58:08'),(2857,7938,449,40721,3192,1,518,1,1307.82,NULL,'2023-01-08 01:32:29','2023-01-10 17:58:08','2023-01-10 17:58:08'),(2858,7938,449,40721,3192,1,519,1,300.00,NULL,'2023-01-08 01:32:29','2023-01-10 17:58:08','2023-01-10 17:58:08'),(2859,7938,449,40721,3192,1,62,2,293344.03,NULL,'2023-01-08 01:32:29','2023-01-10 17:58:08','2023-01-10 17:58:08'),(2860,7938,449,40721,3192,1,500,2,114680.63,NULL,'2023-01-08 01:32:29','2023-01-10 17:58:08','2023-01-10 17:58:08'),(2861,7938,449,40721,3192,1,484,2,11016.53,NULL,'2023-01-08 01:32:29','2023-01-10 17:58:08','2023-01-10 17:58:08'),(2862,7938,449,40721,3192,1,520,2,1800.00,NULL,'2023-01-08 01:32:29','2023-01-10 17:58:08','2023-01-10 17:58:08'),(2863,7938,449,40721,3192,1,64,2,4038.85,NULL,'2023-01-08 01:32:29','2023-01-10 17:58:08','2023-01-10 17:58:08'),(2864,7938,450,40721,3193,1,110,1,382363.12,NULL,'2023-01-08 01:35:27','2023-01-09 19:46:10','2023-01-09 19:46:10'),(2865,7938,450,40721,3193,1,514,1,65616.67,NULL,'2023-01-08 01:35:27','2023-01-09 19:46:10','2023-01-09 19:46:10'),(2866,7938,450,40721,3193,1,515,1,19500.52,NULL,'2023-01-08 01:35:27','2023-01-09 19:46:10','2023-01-09 19:46:10'),(2867,7938,450,40721,3193,1,516,1,4826.90,NULL,'2023-01-08 01:35:27','2023-01-09 19:46:10','2023-01-09 19:46:10'),(2868,7938,450,40721,3193,1,517,1,111.63,NULL,'2023-01-08 01:35:27','2023-01-09 19:46:10','2023-01-09 19:46:10'),(2869,7938,450,40721,3193,1,518,1,1386.30,NULL,'2023-01-08 01:35:27','2023-01-09 19:46:10','2023-01-09 19:46:10'),(2870,7938,450,40721,3193,1,519,1,600.00,NULL,'2023-01-08 01:35:27','2023-01-09 19:46:10','2023-01-09 19:46:10'),(2871,7938,450,40721,3193,1,62,2,309890.90,NULL,'2023-01-08 01:35:27','2023-01-09 19:46:10','2023-01-09 19:46:10'),(2872,7938,450,40721,3193,1,500,2,139141.52,NULL,'2023-01-08 01:35:27','2023-01-09 19:46:10','2023-01-09 19:46:10'),(2873,7938,450,40721,3193,1,484,2,11985.28,NULL,'2023-01-08 01:35:27','2023-01-09 19:46:10','2023-01-09 19:46:10'),(2874,7938,450,40721,3193,1,520,2,1800.00,NULL,'2023-01-08 01:35:27','2023-01-09 19:46:10','2023-01-09 19:46:10'),(2875,7938,450,40721,3193,1,64,2,11587.44,NULL,'2023-01-08 01:35:27','2023-01-09 19:46:10','2023-01-09 19:46:10'),(2876,7938,451,40721,3194,1,110,1,488747.92,NULL,'2023-01-08 01:37:45','2023-01-09 19:48:16','2023-01-09 19:48:16'),(2877,7938,451,40721,3194,1,514,1,74750.17,NULL,'2023-01-08 01:37:45','2023-01-09 19:48:16','2023-01-09 19:48:16'),(2878,7938,451,40721,3194,1,515,1,22738.99,NULL,'2023-01-08 01:37:45','2023-01-09 19:48:16','2023-01-09 19:48:16'),(2879,7938,451,40721,3194,1,516,1,5569.84,NULL,'2023-01-08 01:37:45','2023-01-09 19:48:16','2023-01-09 19:48:16'),(2880,7938,451,40721,3194,1,517,1,111.63,NULL,'2023-01-08 01:37:45','2023-01-09 19:48:16','2023-01-09 19:48:16'),(2881,7938,451,40721,3194,1,518,1,1464.78,NULL,'2023-01-08 01:37:45','2023-01-09 19:48:16','2023-01-09 19:48:16'),(2882,7938,451,40721,3194,1,519,1,600.00,NULL,'2023-01-08 01:37:45','2023-01-09 19:48:16','2023-01-09 19:48:16');
INSERT INTO `balance_libro_details` VALUES (2883,7938,451,40721,3194,1,62,2,406119.12,NULL,'2023-01-08 01:37:45','2023-01-09 19:48:16','2023-01-09 19:48:16'),(2884,7938,451,40721,3194,1,500,2,160696.54,NULL,'2023-01-08 01:37:45','2023-01-09 19:48:16','2023-01-09 19:48:16'),(2885,7938,451,40721,3194,1,484,2,12109.51,NULL,'2023-01-08 01:37:45','2023-01-09 19:48:16','2023-01-09 19:48:16'),(2886,7938,451,40721,3194,1,520,2,1800.00,NULL,'2023-01-08 01:37:45','2023-01-09 19:48:16','2023-01-09 19:48:16'),(2887,7938,451,40721,3194,1,64,2,13258.16,NULL,'2023-01-08 01:37:45','2023-01-09 19:48:16','2023-01-09 19:48:16'),(2888,7938,452,40721,3195,1,110,1,704274.29,NULL,'2023-01-08 01:40:03','2023-01-09 19:52:02','2023-01-09 19:52:02'),(2889,7938,452,40721,3195,1,514,1,66113.48,NULL,'2023-01-08 01:40:03','2023-01-09 19:52:02','2023-01-09 19:52:02'),(2890,7938,452,40721,3195,1,515,1,20068.27,NULL,'2023-01-08 01:40:03','2023-01-09 19:52:02','2023-01-09 19:52:02'),(2891,7938,452,40721,3195,1,516,1,4859.20,NULL,'2023-01-08 01:40:03','2023-01-09 19:52:02','2023-01-09 19:52:02'),(2892,7938,452,40721,3195,1,517,1,74.42,NULL,'2023-01-08 01:40:03','2023-01-09 19:52:02','2023-01-09 19:52:02'),(2893,7938,452,40721,3195,1,518,1,1028.84,NULL,'2023-01-08 01:40:03','2023-01-09 19:52:02','2023-01-09 19:52:02'),(2894,7938,452,40721,3195,1,62,2,631948.15,NULL,'2023-01-08 01:40:03','2023-01-09 19:52:02','2023-01-09 19:52:02'),(2895,7938,452,40721,3195,1,500,2,138245.67,NULL,'2023-01-08 01:40:03','2023-01-09 19:52:02','2023-01-09 19:52:02'),(2896,7938,452,40721,3195,1,484,2,13502.71,NULL,'2023-01-08 01:40:03','2023-01-09 19:52:02','2023-01-09 19:52:02'),(2897,7938,452,40721,3195,1,520,2,1800.00,NULL,'2023-01-08 01:40:03','2023-01-09 19:52:02','2023-01-09 19:52:02'),(2898,7938,452,40721,3195,1,64,2,10921.97,NULL,'2023-01-08 01:40:03','2023-01-09 19:52:02','2023-01-09 19:52:02'),(2899,7938,453,40721,3196,1,110,1,525781.75,NULL,'2023-01-08 01:42:17','2023-01-09 19:55:34','2023-01-09 19:55:34'),(2900,7938,453,40721,3196,1,514,1,60596.69,NULL,'2023-01-08 01:42:17','2023-01-09 19:55:34','2023-01-09 19:55:34'),(2901,7938,453,40721,3196,1,515,1,19693.69,NULL,'2023-01-08 01:42:17','2023-01-09 19:55:34','2023-01-09 19:55:34'),(2902,7938,453,40721,3196,1,516,1,4916.96,NULL,'2023-01-08 01:42:17','2023-01-09 19:55:34','2023-01-09 19:55:34'),(2903,7938,453,40721,3196,1,517,1,111.63,NULL,'2023-01-08 01:42:17','2023-01-09 19:55:34','2023-01-09 19:55:34'),(2904,7938,453,40721,3196,1,518,1,1543.26,NULL,'2023-01-08 01:42:17','2023-01-09 19:55:34','2023-01-09 19:55:34'),(2905,7938,453,40721,3196,1,519,1,600.00,NULL,'2023-01-08 01:42:17','2023-01-09 19:55:34','2023-01-09 19:55:34'),(2906,7938,453,40721,3196,1,62,2,457114.03,NULL,'2023-01-08 01:42:17','2023-01-09 19:55:34','2023-01-09 19:55:34'),(2907,7938,453,40721,3196,1,500,2,128154.37,NULL,'2023-01-08 01:42:17','2023-01-09 19:55:34','2023-01-09 19:55:34'),(2908,7938,453,40721,3196,1,484,2,14318.38,NULL,'2023-01-08 01:42:17','2023-01-09 19:55:34','2023-01-09 19:55:34'),(2909,7938,453,40721,3196,1,520,2,1800.00,NULL,'2023-01-08 01:42:17','2023-01-09 19:55:34','2023-01-09 19:55:34'),(2910,7938,453,40721,3196,1,64,2,11857.20,NULL,'2023-01-08 01:42:17','2023-01-09 19:55:34','2023-01-09 19:55:34'),(2911,7938,454,40721,3197,1,110,1,445815.05,NULL,'2023-01-08 01:44:38','2023-01-09 19:59:41','2023-01-09 19:59:41'),(2912,7938,454,40721,3197,1,514,1,62074.82,NULL,'2023-01-08 01:44:38','2023-01-09 19:59:41','2023-01-09 19:59:41'),(2913,7938,454,40721,3197,1,515,1,22736.57,NULL,'2023-01-08 01:44:38','2023-01-09 19:59:41','2023-01-09 19:59:41'),(2914,7938,454,40721,3197,1,516,1,5639.04,NULL,'2023-01-08 01:44:38','2023-01-09 19:59:41','2023-01-09 19:59:41'),(2915,7938,454,40721,3197,1,517,1,111.63,NULL,'2023-01-08 01:44:38','2023-01-09 19:59:41','2023-01-09 19:59:41'),(2916,7938,454,40721,3197,1,518,1,1811.37,NULL,'2023-01-08 01:44:38','2023-01-09 19:59:41','2023-01-09 19:59:41'),(2917,7938,454,40721,3197,1,519,1,600.00,NULL,'2023-01-08 01:44:38','2023-01-09 19:59:41','2023-01-09 19:59:41');
INSERT INTO `balance_libro_details` VALUES (2918,7938,454,40721,3197,1,62,2,373001.76,NULL,'2023-01-08 01:44:38','2023-01-09 19:59:41','2023-01-09 19:59:41'),(2919,7938,454,40721,3197,1,500,2,134573.36,NULL,'2023-01-08 01:44:38','2023-01-09 19:59:41','2023-01-09 19:59:41'),(2920,7938,454,40721,3197,1,484,2,15764.40,NULL,'2023-01-08 01:44:38','2023-01-09 19:59:41','2023-01-09 19:59:41'),(2921,7938,454,40721,3197,1,520,2,1800.00,NULL,'2023-01-08 01:44:38','2023-01-09 19:59:41','2023-01-09 19:59:41'),(2922,7938,454,40721,3197,1,64,2,13648.96,NULL,'2023-01-08 01:44:38','2023-01-09 19:59:41','2023-01-09 19:59:41'),(2923,7938,455,40721,3197,3,68,1,204684.60,NULL,'2023-01-08 01:51:18','2023-01-08 01:55:43','2023-01-08 01:55:43'),(2924,7938,455,40721,3197,3,62,1,373093.95,NULL,'2023-01-08 01:51:18','2023-01-08 01:55:43','2023-01-08 01:55:43'),(2925,7938,455,40721,3197,3,500,1,128154.37,NULL,'2023-01-08 01:51:18','2023-01-08 01:55:43','2023-01-08 01:55:43'),(2926,7938,455,40721,3197,3,64,1,11257.20,NULL,'2023-01-08 01:51:18','2023-01-08 01:55:43','2023-01-08 01:55:43'),(2927,7938,455,40721,3197,3,396,1,4750.00,NULL,'2023-01-08 01:51:18','2023-01-08 01:55:43','2023-01-08 01:55:43'),(2928,7938,455,40721,3197,3,502,1,2192666.37,NULL,'2023-01-08 01:51:18','2023-01-08 01:55:43','2023-01-08 01:55:43'),(2929,7938,455,40721,3197,3,74,1,104182.20,NULL,'2023-01-08 01:51:18','2023-01-08 01:55:43','2023-01-08 01:55:43'),(2930,7938,455,40721,3197,3,78,1,88179.24,NULL,'2023-01-08 01:51:18','2023-01-08 01:55:43','2023-01-08 01:55:43'),(2931,7938,455,40721,3197,3,503,1,29877.91,NULL,'2023-01-08 01:51:18','2023-01-08 01:55:43','2023-01-08 01:55:43'),(2932,7938,455,40721,3197,3,135,1,148984.46,NULL,'2023-01-08 01:51:18','2023-01-08 01:55:43','2023-01-08 01:55:43'),(2933,7938,455,40721,3197,3,25,1,135.00,NULL,'2023-01-08 01:51:18','2023-01-08 01:55:43','2023-01-08 01:55:43'),(2934,7938,455,40721,3197,3,504,1,2825.30,NULL,'2023-01-08 01:51:18','2023-01-08 01:55:43','2023-01-08 01:55:43'),(2935,7938,455,40721,3197,3,157,1,48953.12,NULL,'2023-01-08 01:51:18','2023-01-08 01:55:43','2023-01-08 01:55:43'),(2936,7938,455,40721,3197,3,425,2,3625226.58,NULL,'2023-01-08 01:51:18','2023-01-08 01:55:43','2023-01-08 01:55:43'),(2937,7938,455,40721,3197,3,492,1,256890.00,NULL,'2023-01-08 01:51:18','2023-01-08 01:55:43','2023-01-08 01:55:43'),(2938,7938,455,40721,3197,3,209,1,30592.86,NULL,'2023-01-08 01:51:18','2023-01-08 01:55:43','2023-01-08 01:55:43'),(2939,7938,456,40721,3197,3,68,1,204684.60,NULL,'2023-01-08 01:55:43','2023-01-08 01:59:39','2023-01-08 01:59:39'),(2940,7938,456,40721,3197,3,62,1,373093.95,NULL,'2023-01-08 01:55:43','2023-01-08 01:59:39','2023-01-08 01:59:39'),(2941,7938,456,40721,3197,3,500,1,128154.37,NULL,'2023-01-08 01:55:43','2023-01-08 01:59:39','2023-01-08 01:59:39'),(2942,7938,456,40721,3197,3,64,1,11257.20,NULL,'2023-01-08 01:55:43','2023-01-08 01:59:39','2023-01-08 01:59:39'),(2943,7938,456,40721,3197,3,396,1,4750.00,NULL,'2023-01-08 01:55:43','2023-01-08 01:59:39','2023-01-08 01:59:39'),(2944,7938,456,40721,3197,3,502,1,2192666.37,NULL,'2023-01-08 01:55:43','2023-01-08 01:59:39','2023-01-08 01:59:39'),(2945,7938,456,40721,3197,3,74,1,104182.20,NULL,'2023-01-08 01:55:43','2023-01-08 01:59:39','2023-01-08 01:59:39'),(2946,7938,456,40721,3197,3,78,1,88179.24,NULL,'2023-01-08 01:55:43','2023-01-08 01:59:39','2023-01-08 01:59:39'),(2947,7938,456,40721,3197,3,503,1,29877.91,NULL,'2023-01-08 01:55:43','2023-01-08 01:59:39','2023-01-08 01:59:39'),(2948,7938,456,40721,3197,3,135,1,119147.34,NULL,'2023-01-08 01:55:43','2023-01-08 01:59:39','2023-01-08 01:59:39'),(2949,7938,456,40721,3197,3,25,1,135.00,NULL,'2023-01-08 01:55:43','2023-01-08 01:59:39','2023-01-08 01:59:39'),(2950,7938,456,40721,3197,3,504,1,2825.30,NULL,'2023-01-08 01:55:43','2023-01-08 01:59:39','2023-01-08 01:59:39'),(2951,7938,456,40721,3197,3,157,1,48953.12,NULL,'2023-01-08 01:55:43','2023-01-08 01:59:39','2023-01-08 01:59:39');
INSERT INTO `balance_libro_details` VALUES (2952,7938,456,40721,3197,3,425,2,3595389.46,NULL,'2023-01-08 01:55:43','2023-01-08 01:59:39','2023-01-08 01:59:39'),(2953,7938,456,40721,3197,3,492,1,256890.00,NULL,'2023-01-08 01:55:43','2023-01-08 01:59:39','2023-01-08 01:59:39'),(2954,7938,456,40721,3197,3,209,1,30592.86,NULL,'2023-01-08 01:55:43','2023-01-08 01:59:39','2023-01-08 01:59:39'),(2955,7938,457,40721,3197,3,68,1,204684.60,NULL,'2023-01-08 01:59:39','2023-01-08 02:04:11','2023-01-08 02:04:11'),(2956,7938,457,40721,3197,3,62,1,373093.95,NULL,'2023-01-08 01:59:39','2023-01-08 02:04:11','2023-01-08 02:04:11'),(2957,7938,457,40721,3197,3,500,1,128154.37,NULL,'2023-01-08 01:59:39','2023-01-08 02:04:11','2023-01-08 02:04:11'),(2958,7938,457,40721,3197,3,64,1,11257.20,NULL,'2023-01-08 01:59:39','2023-01-08 02:04:11','2023-01-08 02:04:11'),(2959,7938,457,40721,3197,3,396,1,4750.00,NULL,'2023-01-08 01:59:39','2023-01-08 02:04:11','2023-01-08 02:04:11'),(2960,7938,457,40721,3197,3,502,1,2192666.37,NULL,'2023-01-08 01:59:39','2023-01-08 02:04:11','2023-01-08 02:04:11'),(2961,7938,457,40721,3197,3,74,1,104182.20,NULL,'2023-01-08 01:59:39','2023-01-08 02:04:11','2023-01-08 02:04:11'),(2962,7938,457,40721,3197,3,78,1,88179.24,NULL,'2023-01-08 01:59:39','2023-01-08 02:04:11','2023-01-08 02:04:11'),(2963,7938,457,40721,3197,3,503,1,29877.91,NULL,'2023-01-08 01:59:39','2023-01-08 02:04:11','2023-01-08 02:04:11'),(2964,7938,457,40721,3197,3,135,1,178821.58,NULL,'2023-01-08 01:59:39','2023-01-08 02:04:11','2023-01-08 02:04:11'),(2965,7938,457,40721,3197,3,25,1,135.00,NULL,'2023-01-08 01:59:39','2023-01-08 02:04:11','2023-01-08 02:04:11'),(2966,7938,457,40721,3197,3,504,1,2825.30,NULL,'2023-01-08 01:59:39','2023-01-08 02:04:11','2023-01-08 02:04:11'),(2967,7938,457,40721,3197,3,157,1,48953.12,NULL,'2023-01-08 01:59:39','2023-01-08 02:04:11','2023-01-08 02:04:11'),(2968,7938,457,40721,3197,3,425,2,3655063.70,NULL,'2023-01-08 01:59:39','2023-01-08 02:04:11','2023-01-08 02:04:11'),(2969,7938,457,40721,3197,3,492,1,256890.00,NULL,'2023-01-08 01:59:39','2023-01-08 02:04:11','2023-01-08 02:04:11'),(2970,7938,457,40721,3197,3,209,1,30592.86,NULL,'2023-01-08 01:59:39','2023-01-08 02:04:11','2023-01-08 02:04:11'),(2971,7938,458,40721,3197,3,68,1,204684.60,NULL,'2023-01-08 02:04:11','2023-01-09 20:01:00','2023-01-09 20:01:00'),(2972,7938,458,40721,3197,3,62,1,373093.95,NULL,'2023-01-08 02:04:11','2023-01-09 20:01:00','2023-01-09 20:01:00'),(2973,7938,458,40721,3197,3,500,1,128154.37,NULL,'2023-01-08 02:04:11','2023-01-09 20:01:00','2023-01-09 20:01:00'),(2974,7938,458,40721,3197,3,64,1,11257.20,NULL,'2023-01-08 02:04:11','2023-01-09 20:01:00','2023-01-09 20:01:00'),(2975,7938,458,40721,3197,3,396,1,4750.00,NULL,'2023-01-08 02:04:11','2023-01-09 20:01:00','2023-01-09 20:01:00'),(2976,7938,458,40721,3197,3,502,1,2192666.37,NULL,'2023-01-08 02:04:11','2023-01-09 20:01:00','2023-01-09 20:01:00'),(2977,7938,458,40721,3197,3,74,1,104182.20,NULL,'2023-01-08 02:04:11','2023-01-09 20:01:00','2023-01-09 20:01:00'),(2978,7938,458,40721,3197,3,78,1,88179.24,NULL,'2023-01-08 02:04:11','2023-01-09 20:01:00','2023-01-09 20:01:00'),(2979,7938,458,40721,3197,3,503,1,29877.91,NULL,'2023-01-08 02:04:11','2023-01-09 20:01:00','2023-01-09 20:01:00'),(2980,7938,458,40721,3197,3,25,1,135.00,NULL,'2023-01-08 02:04:12','2023-01-09 20:01:00','2023-01-09 20:01:00'),(2981,7938,458,40721,3197,3,504,1,2825.30,NULL,'2023-01-08 02:04:12','2023-01-09 20:01:00','2023-01-09 20:01:00'),(2982,7938,458,40721,3197,3,157,1,48953.12,NULL,'2023-01-08 02:04:12','2023-01-09 20:01:00','2023-01-09 20:01:00'),(2983,7938,458,40721,3197,3,425,2,3655063.70,NULL,'2023-01-08 02:04:12','2023-01-09 20:01:00','2023-01-09 20:01:00'),(2984,7938,458,40721,3197,3,492,1,256890.00,NULL,'2023-01-08 02:04:12','2023-01-09 20:01:00','2023-01-09 20:01:00'),(2985,7938,458,40721,3197,3,209,1,30592.86,NULL,'2023-01-08 02:04:12','2023-01-09 20:01:00','2023-01-09 20:01:00');
INSERT INTO `balance_libro_details` VALUES (2986,7938,458,40721,3197,3,62,1,178821.58,NULL,'2023-01-08 02:04:12','2023-01-09 20:01:00','2023-01-09 20:01:00'),(2987,7938,459,40721,3196,3,68,1,203982.54,NULL,'2023-01-08 02:05:09','2023-01-08 02:06:49','2023-01-08 02:06:49'),(2988,7938,459,40721,3196,3,62,1,317543.08,NULL,'2023-01-08 02:05:09','2023-01-08 02:06:49','2023-01-08 02:06:49'),(2989,7938,459,40721,3196,3,500,1,138245.67,NULL,'2023-01-08 02:05:09','2023-01-08 02:06:49','2023-01-08 02:06:49'),(2990,7938,459,40721,3196,3,64,1,9368.47,NULL,'2023-01-08 02:05:09','2023-01-08 02:06:49','2023-01-08 02:06:49'),(2991,7938,459,40721,3196,3,396,1,3500.00,NULL,'2023-01-08 02:05:09','2023-01-08 02:06:49','2023-01-08 02:06:49'),(2992,7938,459,40721,3196,3,502,1,1466969.57,NULL,'2023-01-08 02:05:09','2023-01-08 02:06:49','2023-01-08 02:06:49'),(2993,7938,459,40721,3196,3,78,1,39401.36,NULL,'2023-01-08 02:05:09','2023-01-08 02:06:49','2023-01-08 02:06:49'),(2994,7938,459,40721,3196,3,503,1,33422.24,NULL,'2023-01-08 02:05:09','2023-01-08 02:06:49','2023-01-08 02:06:49'),(2995,7938,459,40721,3196,3,135,1,33207.88,NULL,'2023-01-08 02:05:09','2023-01-08 02:06:49','2023-01-08 02:06:49'),(2996,7938,459,40721,3196,3,25,1,90.00,NULL,'2023-01-08 02:05:09','2023-01-08 02:06:49','2023-01-08 02:06:49'),(2997,7938,459,40721,3196,3,504,1,1861.09,NULL,'2023-01-08 02:05:09','2023-01-08 02:06:49','2023-01-08 02:06:49'),(2998,7938,459,40721,3196,3,157,1,19683.92,NULL,'2023-01-08 02:05:09','2023-01-08 02:06:49','2023-01-08 02:06:49'),(2999,7938,459,40721,3196,3,425,2,2308690.97,NULL,'2023-01-08 02:05:09','2023-01-08 02:06:49','2023-01-08 02:06:49'),(3000,7938,459,40721,3196,3,209,1,21967.28,NULL,'2023-01-08 02:05:09','2023-01-08 02:06:49','2023-01-08 02:06:49'),(3001,7938,459,40721,3196,3,62,1,19447.87,NULL,'2023-01-08 02:05:09','2023-01-08 02:06:49','2023-01-08 02:06:49'),(3002,7938,460,40721,3196,3,68,1,203982.54,NULL,'2023-01-08 02:06:49','2023-01-09 19:57:37','2023-01-09 19:57:37'),(3003,7938,460,40721,3196,3,62,1,317543.08,NULL,'2023-01-08 02:06:49','2023-01-09 19:57:37','2023-01-09 19:57:37'),(3004,7938,460,40721,3196,3,500,1,138245.67,NULL,'2023-01-08 02:06:49','2023-01-09 19:57:37','2023-01-09 19:57:37'),(3005,7938,460,40721,3196,3,64,1,9368.47,NULL,'2023-01-08 02:06:49','2023-01-09 19:57:37','2023-01-09 19:57:37'),(3006,7938,460,40721,3196,3,396,1,3500.00,NULL,'2023-01-08 02:06:49','2023-01-09 19:57:37','2023-01-09 19:57:37'),(3007,7938,460,40721,3196,3,502,1,1466969.57,NULL,'2023-01-08 02:06:49','2023-01-09 19:57:37','2023-01-09 19:57:37'),(3008,7938,460,40721,3196,3,78,1,39401.36,NULL,'2023-01-08 02:06:49','2023-01-09 19:57:37','2023-01-09 19:57:37'),(3009,7938,460,40721,3196,3,503,1,33422.24,NULL,'2023-01-08 02:06:49','2023-01-09 19:57:37','2023-01-09 19:57:37'),(3010,7938,460,40721,3196,3,135,1,25001.64,NULL,'2023-01-08 02:06:49','2023-01-09 19:57:37','2023-01-09 19:57:37'),(3011,7938,460,40721,3196,3,25,1,90.00,NULL,'2023-01-08 02:06:49','2023-01-09 19:57:37','2023-01-09 19:57:37'),(3012,7938,460,40721,3196,3,504,1,1861.09,NULL,'2023-01-08 02:06:49','2023-01-09 19:57:37','2023-01-09 19:57:37'),(3013,7938,460,40721,3196,3,157,1,19683.92,NULL,'2023-01-08 02:06:49','2023-01-09 19:57:37','2023-01-09 19:57:37'),(3014,7938,460,40721,3196,3,425,2,2308690.97,NULL,'2023-01-08 02:06:49','2023-01-09 19:57:37','2023-01-09 19:57:37'),(3015,7938,460,40721,3196,3,209,1,21967.28,NULL,'2023-01-08 02:06:49','2023-01-09 19:57:37','2023-01-09 19:57:37'),(3016,7938,460,40721,3196,3,62,1,19447.87,NULL,'2023-01-08 02:06:49','2023-01-09 19:57:37','2023-01-09 19:57:37'),(3017,7938,460,40721,3196,3,64,1,8206.24,NULL,'2023-01-08 02:06:49','2023-01-09 19:57:37','2023-01-09 19:57:37'),(3018,7938,461,40721,3184,3,68,1,12748.33,NULL,'2023-01-09 19:29:01','2023-01-10 21:04:37','2023-01-10 21:04:37'),(3019,7938,461,40721,3184,3,62,1,210646.03,NULL,'2023-01-09 19:29:01','2023-01-10 21:04:37','2023-01-10 21:04:37'),(3020,7938,461,40721,3184,3,500,1,90350.12,NULL,'2023-01-09 19:29:01','2023-01-10 21:04:37','2023-01-10 21:04:37');
INSERT INTO `balance_libro_details` VALUES (3021,7938,461,40721,3184,3,64,1,7865.00,NULL,'2023-01-09 19:29:01','2023-01-10 21:04:37','2023-01-10 21:04:37'),(3022,7938,461,40721,3184,3,396,1,2826.00,NULL,'2023-01-09 19:29:01','2023-01-10 21:04:37','2023-01-10 21:04:37'),(3023,7938,461,40721,3184,3,502,1,336098.26,NULL,'2023-01-09 19:29:01','2023-01-10 21:04:37','2023-01-10 21:04:37'),(3024,7938,461,40721,3184,3,78,1,116.32,NULL,'2023-01-09 19:29:01','2023-01-10 21:04:37','2023-01-10 21:04:37'),(3025,7938,461,40721,3184,3,503,1,22494.74,NULL,'2023-01-09 19:29:01','2023-01-10 21:04:37','2023-01-10 21:04:37'),(3026,7938,461,40721,3184,3,135,1,76653.84,NULL,'2023-01-09 19:29:01','2023-01-10 21:04:37','2023-01-10 21:04:37'),(3027,7938,461,40721,3184,3,25,1,673.56,NULL,'2023-01-09 19:29:01','2023-01-10 21:04:37','2023-01-10 21:04:37'),(3028,7938,461,40721,3184,3,504,1,2284.85,NULL,'2023-01-09 19:29:01','2023-01-10 21:04:37','2023-01-10 21:04:37'),(3029,7938,461,40721,3184,3,157,1,9648.43,NULL,'2023-01-09 19:29:01','2023-01-10 21:04:37','2023-01-10 21:04:37'),(3030,7938,461,40721,3184,3,425,2,773313.69,NULL,'2023-01-09 19:29:01','2023-01-10 21:04:37','2023-01-10 21:04:37'),(3031,7938,461,40721,3184,3,209,1,908.21,NULL,'2023-01-09 19:29:01','2023-01-10 21:04:37','2023-01-10 21:04:37'),(3032,7938,462,40721,3185,1,110,1,273676.03,NULL,'2023-01-09 19:34:53','2023-01-09 19:34:53',NULL),(3033,7938,462,40721,3185,1,514,1,40177.75,NULL,'2023-01-09 19:34:53','2023-01-09 19:34:53',NULL),(3034,7938,462,40721,3185,1,515,1,13955.95,NULL,'2023-01-09 19:34:53','2023-01-09 19:34:53',NULL),(3035,7938,462,40721,3185,1,516,1,3351.60,NULL,'2023-01-09 19:34:53','2023-01-09 19:34:53',NULL),(3036,7938,462,40721,3185,1,517,1,73.05,NULL,'2023-01-09 19:34:53','2023-01-09 19:34:53',NULL),(3037,7938,462,40721,3185,1,518,1,1061.52,NULL,'2023-01-09 19:34:53','2023-01-09 19:34:53',NULL),(3038,7938,462,40721,3185,1,519,1,300.00,NULL,'2023-01-09 19:34:53','2023-01-09 19:34:53',NULL),(3039,7938,462,40721,3185,1,62,2,226220.00,NULL,'2023-01-09 19:34:53','2023-01-09 19:34:53',NULL),(3040,7938,462,40721,3185,1,500,2,89955.84,NULL,'2023-01-09 19:34:53','2023-01-09 19:34:53',NULL),(3041,7938,462,40721,3185,1,484,2,8187.29,NULL,'2023-01-09 19:34:53','2023-01-09 19:34:53',NULL),(3042,7938,462,40721,3185,1,64,2,8232.77,NULL,'2023-01-09 19:34:53','2023-01-09 19:34:53',NULL),(3043,7938,463,40721,3186,1,110,1,395622.26,NULL,'2023-01-09 19:36:52','2023-01-09 19:36:52',NULL),(3044,7938,463,40721,3186,1,514,1,61337.42,NULL,'2023-01-09 19:36:52','2023-01-09 19:36:52',NULL),(3045,7938,463,40721,3186,1,515,1,20176.04,NULL,'2023-01-09 19:36:52','2023-01-09 19:36:52',NULL),(3046,7938,463,40721,3186,1,516,1,4778.56,NULL,'2023-01-09 19:36:52','2023-01-09 19:36:52',NULL),(3047,7938,463,40721,3186,1,517,1,73.05,NULL,'2023-01-09 19:36:52','2023-01-09 19:36:52',NULL),(3048,7938,463,40721,3186,1,518,1,1061.52,NULL,'2023-01-09 19:36:52','2023-01-09 19:36:52',NULL),(3049,7938,463,40721,3186,1,519,1,300.00,NULL,'2023-01-09 19:36:52','2023-01-09 19:36:52',NULL),(3050,7938,463,40721,3186,1,62,2,324400.00,NULL,'2023-01-09 19:36:52','2023-01-09 19:36:52',NULL),(3051,7938,463,40721,3186,1,500,2,139496.40,NULL,'2023-01-09 19:36:52','2023-01-09 19:36:52',NULL),(3052,7938,463,40721,3186,1,484,2,8186.87,NULL,'2023-01-09 19:36:52','2023-01-09 19:36:52',NULL),(3053,7938,463,40721,3186,1,64,2,11265.58,NULL,'2023-01-09 19:36:52','2023-01-09 19:36:52',NULL),(3054,7938,464,40721,3190,1,110,1,305392.65,NULL,'2023-01-09 19:40:09','2023-01-09 19:40:09',NULL),(3055,7938,464,40721,3190,1,514,1,51448.72,NULL,'2023-01-09 19:40:09','2023-01-09 19:40:09',NULL),(3056,7938,464,40721,3190,1,515,1,15573.55,NULL,'2023-01-09 19:40:09','2023-01-09 19:40:09',NULL),(3057,7938,464,40721,3190,1,516,1,3872.75,NULL,'2023-01-09 19:40:09','2023-01-09 19:40:09',NULL),(3058,7938,464,40721,3190,1,517,1,73.05,NULL,'2023-01-09 19:40:09','2023-01-09 19:40:09',NULL),(3059,7938,464,40721,3190,1,518,1,1129.47,NULL,'2023-01-09 19:40:09','2023-01-09 19:40:09',NULL);
INSERT INTO `balance_libro_details` VALUES (3060,7938,464,40721,3190,1,519,1,300.00,NULL,'2023-01-09 19:40:09','2023-01-09 19:40:09',NULL),(3061,7938,464,40721,3190,1,62,2,247649.00,NULL,'2023-01-09 19:40:09','2023-01-09 19:40:09',NULL),(3062,7938,464,40721,3190,1,500,2,111607.52,NULL,'2023-01-09 19:40:09','2023-01-09 19:40:09',NULL),(3063,7938,464,40721,3190,1,484,2,9441.10,NULL,'2023-01-09 19:40:09','2023-01-09 19:40:09',NULL),(3064,7938,464,40721,3190,1,64,2,9092.57,NULL,'2023-01-09 19:40:09','2023-01-09 19:40:09',NULL),(3065,7938,465,40721,3191,1,110,1,327755.53,NULL,'2023-01-09 19:42:11','2023-01-09 19:42:11',NULL),(3066,7938,465,40721,3191,1,514,1,52259.67,NULL,'2023-01-09 19:42:11','2023-01-09 19:42:11',NULL),(3067,7938,465,40721,3191,1,515,1,16713.69,NULL,'2023-01-09 19:42:11','2023-01-09 19:42:11',NULL),(3068,7938,465,40721,3191,1,516,1,4134.32,NULL,'2023-01-09 19:42:11','2023-01-09 19:42:11',NULL),(3069,7938,465,40721,3191,1,517,1,73.05,NULL,'2023-01-09 19:42:11','2023-01-09 19:42:11',NULL),(3070,7938,465,40721,3191,1,518,1,1222.89,NULL,'2023-01-09 19:42:11','2023-01-09 19:42:11',NULL),(3071,7938,465,40721,3191,1,519,1,300.00,NULL,'2023-01-09 19:42:11','2023-01-09 19:42:11',NULL),(3072,7938,465,40721,3191,1,62,2,268301.00,NULL,'2023-01-09 19:42:11','2023-01-09 19:42:11',NULL),(3073,7938,465,40721,3191,1,500,2,114857.37,NULL,'2023-01-09 19:42:11','2023-01-09 19:42:11',NULL),(3074,7938,465,40721,3191,1,484,2,9548.85,NULL,'2023-01-09 19:42:11','2023-01-09 19:42:11',NULL),(3075,7938,465,40721,3191,1,64,2,9751.93,NULL,'2023-01-09 19:42:11','2023-01-09 19:42:11',NULL),(3076,7938,466,40721,3193,1,110,1,382405.22,NULL,'2023-01-09 19:46:10','2023-01-09 19:46:10',NULL),(3077,7938,466,40721,3193,1,514,1,65616.67,NULL,'2023-01-09 19:46:10','2023-01-09 19:46:10',NULL),(3078,7938,466,40721,3193,1,515,1,19500.52,NULL,'2023-01-09 19:46:10','2023-01-09 19:46:10',NULL),(3079,7938,466,40721,3193,1,516,1,4826.90,NULL,'2023-01-09 19:46:10','2023-01-09 19:46:10',NULL),(3080,7938,466,40721,3193,1,517,1,111.63,NULL,'2023-01-09 19:46:10','2023-01-09 19:46:10',NULL),(3081,7938,466,40721,3193,1,518,1,1386.30,NULL,'2023-01-09 19:46:10','2023-01-09 19:46:10',NULL),(3082,7938,466,40721,3193,1,519,1,600.00,NULL,'2023-01-09 19:46:10','2023-01-09 19:46:10',NULL),(3083,7938,466,40721,3193,1,62,2,309933.00,NULL,'2023-01-09 19:46:10','2023-01-09 19:46:10',NULL),(3084,7938,466,40721,3193,1,500,2,139141.52,NULL,'2023-01-09 19:46:10','2023-01-09 19:46:10',NULL),(3085,7938,466,40721,3193,1,484,2,11985.28,NULL,'2023-01-09 19:46:10','2023-01-09 19:46:10',NULL),(3086,7938,466,40721,3193,1,520,2,1800.00,NULL,'2023-01-09 19:46:10','2023-01-09 19:46:10',NULL),(3087,7938,466,40721,3193,1,64,2,11587.44,NULL,'2023-01-09 19:46:10','2023-01-09 19:46:10',NULL),(3088,7938,467,40721,3194,1,110,1,488794.80,NULL,'2023-01-09 19:48:16','2023-01-09 19:48:16',NULL),(3089,7938,467,40721,3194,1,514,1,74750.17,NULL,'2023-01-09 19:48:16','2023-01-09 19:48:16',NULL),(3090,7938,467,40721,3194,1,515,1,22738.99,NULL,'2023-01-09 19:48:16','2023-01-09 19:48:16',NULL),(3091,7938,467,40721,3194,1,516,1,5569.84,NULL,'2023-01-09 19:48:16','2023-01-09 19:48:16',NULL),(3092,7938,467,40721,3194,1,517,1,111.63,NULL,'2023-01-09 19:48:16','2023-01-09 19:48:16',NULL),(3093,7938,467,40721,3194,1,518,1,1464.78,NULL,'2023-01-09 19:48:16','2023-01-09 19:48:16',NULL),(3094,7938,467,40721,3194,1,519,1,600.00,NULL,'2023-01-09 19:48:16','2023-01-09 19:48:16',NULL),(3095,7938,467,40721,3194,1,62,2,406166.00,NULL,'2023-01-09 19:48:16','2023-01-09 19:48:16',NULL),(3096,7938,467,40721,3194,1,500,2,160696.54,NULL,'2023-01-09 19:48:16','2023-01-09 19:48:16',NULL),(3097,7938,467,40721,3194,1,484,2,12109.51,NULL,'2023-01-09 19:48:16','2023-01-09 19:48:16',NULL),(3098,7938,467,40721,3194,1,520,2,1800.00,NULL,'2023-01-09 19:48:16','2023-01-09 19:48:16',NULL),(3099,7938,467,40721,3194,1,64,2,13258.16,NULL,'2023-01-09 19:48:16','2023-01-09 19:48:16',NULL),(3100,7938,468,40721,3195,1,110,1,393577.14,NULL,'2023-01-09 19:52:02','2023-01-09 19:52:02',NULL);
INSERT INTO `balance_libro_details` VALUES (3101,7938,468,40721,3195,1,514,1,66113.48,NULL,'2023-01-09 19:52:02','2023-01-09 19:52:02',NULL),(3102,7938,468,40721,3195,1,515,1,20068.27,NULL,'2023-01-09 19:52:02','2023-01-09 19:52:02',NULL),(3103,7938,468,40721,3195,1,516,1,4859.20,NULL,'2023-01-09 19:52:02','2023-01-09 19:52:02',NULL),(3104,7938,468,40721,3195,1,517,1,74.42,NULL,'2023-01-09 19:52:02','2023-01-09 19:52:02',NULL),(3105,7938,468,40721,3195,1,518,1,1028.84,NULL,'2023-01-09 19:52:02','2023-01-09 19:52:02',NULL),(3106,7938,468,40721,3195,1,62,2,321251.00,NULL,'2023-01-09 19:52:02','2023-01-09 19:52:02',NULL),(3107,7938,468,40721,3195,1,500,2,138245.67,NULL,'2023-01-09 19:52:02','2023-01-09 19:52:02',NULL),(3108,7938,468,40721,3195,1,484,2,13502.71,NULL,'2023-01-09 19:52:02','2023-01-09 19:52:02',NULL),(3109,7938,468,40721,3195,1,520,2,1800.00,NULL,'2023-01-09 19:52:02','2023-01-09 19:52:02',NULL),(3110,7938,468,40721,3195,1,64,2,10921.97,NULL,'2023-01-09 19:52:02','2023-01-09 19:52:02',NULL),(3111,7938,469,40721,3196,1,110,1,386210.80,NULL,'2023-01-09 19:55:34','2023-01-09 19:55:34',NULL),(3112,7938,469,40721,3196,1,514,1,60596.69,NULL,'2023-01-09 19:55:34','2023-01-09 19:55:34',NULL),(3113,7938,469,40721,3196,1,515,1,19693.69,NULL,'2023-01-09 19:55:34','2023-01-09 19:55:34',NULL),(3114,7938,469,40721,3196,1,516,1,4916.96,NULL,'2023-01-09 19:55:34','2023-01-09 19:55:34',NULL),(3115,7938,469,40721,3196,1,517,1,111.63,NULL,'2023-01-09 19:55:34','2023-01-09 19:55:34',NULL),(3116,7938,469,40721,3196,1,518,1,1543.26,NULL,'2023-01-09 19:55:34','2023-01-09 19:55:34',NULL),(3117,7938,469,40721,3196,1,519,1,600.00,NULL,'2023-01-09 19:55:34','2023-01-09 19:55:34',NULL),(3118,7938,469,40721,3196,1,62,2,317543.08,NULL,'2023-01-09 19:55:34','2023-01-09 19:55:34',NULL),(3119,7938,469,40721,3196,1,500,2,128154.37,NULL,'2023-01-09 19:55:34','2023-01-09 19:55:34',NULL),(3120,7938,469,40721,3196,1,484,2,14318.38,NULL,'2023-01-09 19:55:34','2023-01-09 19:55:34',NULL),(3121,7938,469,40721,3196,1,520,2,1800.00,NULL,'2023-01-09 19:55:34','2023-01-09 19:55:34',NULL),(3122,7938,469,40721,3196,1,64,2,11857.20,NULL,'2023-01-09 19:55:34','2023-01-09 19:55:34',NULL),(3123,7938,470,40721,3196,3,68,1,203982.54,NULL,'2023-01-09 19:57:37','2023-01-10 21:03:50','2023-01-10 21:03:50'),(3124,7938,470,40721,3196,3,62,1,317543.08,NULL,'2023-01-09 19:57:37','2023-01-10 21:03:50','2023-01-10 21:03:50'),(3125,7938,470,40721,3196,3,500,1,138245.67,NULL,'2023-01-09 19:57:37','2023-01-10 21:03:50','2023-01-10 21:03:50'),(3126,7938,470,40721,3196,3,64,1,9368.47,NULL,'2023-01-09 19:57:37','2023-01-10 21:03:50','2023-01-10 21:03:50'),(3127,7938,470,40721,3196,3,396,1,3500.00,NULL,'2023-01-09 19:57:37','2023-01-10 21:03:50','2023-01-10 21:03:50'),(3128,7938,470,40721,3196,3,502,1,1466969.57,NULL,'2023-01-09 19:57:37','2023-01-10 21:03:50','2023-01-10 21:03:50'),(3129,7938,470,40721,3196,3,78,1,39401.36,NULL,'2023-01-09 19:57:37','2023-01-10 21:03:50','2023-01-10 21:03:50'),(3130,7938,470,40721,3196,3,503,1,33422.24,NULL,'2023-01-09 19:57:37','2023-01-10 21:03:50','2023-01-10 21:03:50'),(3131,7938,470,40721,3196,3,135,1,44449.51,NULL,'2023-01-09 19:57:37','2023-01-10 21:03:50','2023-01-10 21:03:50'),(3132,7938,470,40721,3196,3,25,1,90.00,NULL,'2023-01-09 19:57:37','2023-01-10 21:03:50','2023-01-10 21:03:50'),(3133,7938,470,40721,3196,3,504,1,1861.09,NULL,'2023-01-09 19:57:37','2023-01-10 21:03:50','2023-01-10 21:03:50'),(3134,7938,470,40721,3196,3,157,1,19683.92,NULL,'2023-01-09 19:57:37','2023-01-10 21:03:50','2023-01-10 21:03:50'),(3135,7938,470,40721,3196,3,425,2,2308690.97,NULL,'2023-01-09 19:57:37','2023-01-10 21:03:50','2023-01-10 21:03:50'),(3136,7938,470,40721,3196,3,209,1,21967.28,NULL,'2023-01-09 19:57:37','2023-01-10 21:03:50','2023-01-10 21:03:50'),(3137,7938,470,40721,3196,3,64,1,8206.24,NULL,'2023-01-09 19:57:37','2023-01-10 21:03:50','2023-01-10 21:03:50'),(3138,7938,471,40721,3197,1,110,1,445907.24,NULL,'2023-01-09 19:59:41','2023-01-09 19:59:41',NULL);
INSERT INTO `balance_libro_details` VALUES (3139,7938,471,40721,3197,1,514,1,62074.82,NULL,'2023-01-09 19:59:41','2023-01-09 19:59:41',NULL),(3140,7938,471,40721,3197,1,515,1,22736.57,NULL,'2023-01-09 19:59:41','2023-01-09 19:59:41',NULL),(3141,7938,471,40721,3197,1,516,1,5639.04,NULL,'2023-01-09 19:59:41','2023-01-09 19:59:41',NULL),(3142,7938,471,40721,3197,1,517,1,111.63,NULL,'2023-01-09 19:59:41','2023-01-09 19:59:41',NULL),(3143,7938,471,40721,3197,1,518,1,1811.37,NULL,'2023-01-09 19:59:41','2023-01-09 19:59:41',NULL),(3144,7938,471,40721,3197,1,519,1,600.00,NULL,'2023-01-09 19:59:41','2023-01-09 19:59:41',NULL),(3145,7938,471,40721,3197,1,62,2,373093.95,NULL,'2023-01-09 19:59:41','2023-01-09 19:59:41',NULL),(3146,7938,471,40721,3197,1,500,2,134573.36,NULL,'2023-01-09 19:59:41','2023-01-09 19:59:41',NULL),(3147,7938,471,40721,3197,1,484,2,15764.40,NULL,'2023-01-09 19:59:41','2023-01-09 19:59:41',NULL),(3148,7938,471,40721,3197,1,520,2,1800.00,NULL,'2023-01-09 19:59:41','2023-01-09 19:59:41',NULL),(3149,7938,471,40721,3197,1,64,2,13648.96,NULL,'2023-01-09 19:59:41','2023-01-09 19:59:41',NULL),(3150,7938,472,40721,3197,3,68,1,204684.60,NULL,'2023-01-09 20:01:00','2023-01-10 21:02:10','2023-01-10 21:02:10'),(3151,7938,472,40721,3197,3,62,1,373093.95,NULL,'2023-01-09 20:01:00','2023-01-10 21:02:10','2023-01-10 21:02:10'),(3152,7938,472,40721,3197,3,500,1,128154.37,NULL,'2023-01-09 20:01:00','2023-01-10 21:02:10','2023-01-10 21:02:10'),(3153,7938,472,40721,3197,3,64,1,11257.20,NULL,'2023-01-09 20:01:00','2023-01-10 21:02:10','2023-01-10 21:02:10'),(3154,7938,472,40721,3197,3,396,1,4750.00,NULL,'2023-01-09 20:01:00','2023-01-10 21:02:10','2023-01-10 21:02:10'),(3155,7938,472,40721,3197,3,502,1,2192666.37,NULL,'2023-01-09 20:01:00','2023-01-10 21:02:10','2023-01-10 21:02:10'),(3156,7938,472,40721,3197,3,74,1,104182.20,NULL,'2023-01-09 20:01:00','2023-01-10 21:02:10','2023-01-10 21:02:10'),(3157,7938,472,40721,3197,3,78,1,88179.24,NULL,'2023-01-09 20:01:00','2023-01-10 21:02:10','2023-01-10 21:02:10'),(3158,7938,472,40721,3197,3,503,1,29877.91,NULL,'2023-01-09 20:01:00','2023-01-10 21:02:10','2023-01-10 21:02:10'),(3159,7938,472,40721,3197,3,25,1,135.00,NULL,'2023-01-09 20:01:00','2023-01-10 21:02:10','2023-01-10 21:02:10'),(3160,7938,472,40721,3197,3,504,1,2825.30,NULL,'2023-01-09 20:01:00','2023-01-10 21:02:10','2023-01-10 21:02:10'),(3161,7938,472,40721,3197,3,157,1,48953.12,NULL,'2023-01-09 20:01:00','2023-01-10 21:02:10','2023-01-10 21:02:10'),(3162,7938,472,40721,3197,3,425,2,3655063.70,NULL,'2023-01-09 20:01:00','2023-01-10 21:02:10','2023-01-10 21:02:10'),(3163,7938,472,40721,3197,3,492,1,256890.00,NULL,'2023-01-09 20:01:00','2023-01-10 21:02:10','2023-01-10 21:02:10'),(3164,7938,472,40721,3197,3,209,1,30592.86,NULL,'2023-01-09 20:01:00','2023-01-10 21:02:10','2023-01-10 21:02:10'),(3165,7938,472,40721,3197,3,135,1,178821.58,NULL,'2023-01-09 20:01:00','2023-01-10 21:02:10','2023-01-10 21:02:10'),(3166,7938,473,40721,3197,19,359,1,72231.16,NULL,'2023-01-10 17:53:06','2023-01-10 17:53:06',NULL),(3167,7938,473,40721,3197,19,384,2,72231.16,NULL,'2023-01-10 17:53:06','2023-01-10 17:53:06',NULL),(3168,7938,474,40721,3197,19,359,1,160000.00,NULL,'2023-01-10 17:53:56','2023-01-10 17:53:56',NULL),(3169,7938,474,40721,3197,19,482,2,160000.00,NULL,'2023-01-10 17:53:56','2023-01-10 17:53:56',NULL),(3170,7938,475,40721,3197,3,359,2,232000.00,NULL,'2023-01-10 17:54:57','2023-01-10 17:54:57',NULL),(3171,7938,475,40721,3197,3,135,1,232000.00,NULL,'2023-01-10 17:54:57','2023-01-10 17:54:57',NULL),(3172,7938,476,40721,3197,19,513,2,45000.00,NULL,'2023-01-10 17:56:05','2023-01-10 18:55:04','2023-01-10 18:55:04'),(3173,7938,476,40721,3197,19,110,1,45000.00,NULL,'2023-01-10 17:56:05','2023-01-10 18:55:04','2023-01-10 18:55:04'),(3174,7938,477,40721,3183,1,110,1,266378.87,NULL,'2023-01-10 17:57:10','2023-01-10 17:57:10',NULL),(3175,7938,477,40721,3183,1,514,1,40911.00,NULL,'2023-01-10 17:57:10','2023-01-10 17:57:10',NULL);
INSERT INTO `balance_libro_details` VALUES (3176,7938,477,40721,3183,1,515,1,13400.04,NULL,'2023-01-10 17:57:10','2023-01-10 17:57:10',NULL),(3177,7938,477,40721,3183,1,516,1,3209.34,NULL,'2023-01-10 17:57:10','2023-01-10 17:57:10',NULL),(3178,7938,477,40721,3183,1,517,1,73.05,NULL,'2023-01-10 17:57:10','2023-01-10 17:57:10',NULL),(3179,7938,477,40721,3183,1,518,1,985.11,NULL,'2023-01-10 17:57:10','2023-01-10 17:57:10',NULL),(3180,7938,477,40721,3183,1,519,1,300.00,NULL,'2023-01-10 17:57:10','2023-01-10 17:57:10',NULL),(3181,7938,477,40721,3183,1,62,2,218898.00,NULL,'2023-01-10 17:57:10','2023-01-10 17:57:10',NULL),(3182,7938,477,40721,3183,1,500,2,90350.12,NULL,'2023-01-10 17:57:10','2023-01-10 17:57:10',NULL),(3183,7938,477,40721,3183,1,484,2,8147.64,NULL,'2023-01-10 17:57:10','2023-01-10 17:57:10',NULL),(3184,7938,477,40721,3183,1,64,2,7861.65,NULL,'2023-01-10 17:57:10','2023-01-10 17:57:10',NULL),(3185,7938,478,40721,3192,1,110,1,341771.39,NULL,'2023-01-10 17:58:08','2023-01-10 17:58:08',NULL),(3186,7938,478,40721,3192,1,514,1,52996.98,NULL,'2023-01-10 17:58:08','2023-01-10 17:58:08',NULL),(3187,7938,478,40721,3192,1,515,1,17750.11,NULL,'2023-01-10 17:58:08','2023-01-10 17:58:08',NULL),(3188,7938,478,40721,3192,1,516,1,4372.08,NULL,'2023-01-10 17:58:08','2023-01-10 17:58:08',NULL),(3189,7938,478,40721,3192,1,517,1,111.63,NULL,'2023-01-10 17:58:08','2023-01-10 17:58:08',NULL),(3190,7938,478,40721,3192,1,518,1,1307.82,NULL,'2023-01-10 17:58:08','2023-01-10 17:58:08',NULL),(3191,7938,478,40721,3192,1,519,1,300.00,NULL,'2023-01-10 17:58:08','2023-01-10 17:58:08',NULL),(3192,7938,478,40721,3192,1,62,2,287074.00,NULL,'2023-01-10 17:58:08','2023-01-10 17:58:08',NULL),(3193,7938,478,40721,3192,1,500,2,114680.63,NULL,'2023-01-10 17:58:08','2023-01-10 17:58:08',NULL),(3194,7938,478,40721,3192,1,484,2,11016.53,NULL,'2023-01-10 17:58:08','2023-01-10 17:58:08',NULL),(3195,7938,478,40721,3192,1,520,2,1800.00,NULL,'2023-01-10 17:58:08','2023-01-10 17:58:08',NULL),(3196,7938,478,40721,3192,1,64,2,4038.85,NULL,'2023-01-10 17:58:08','2023-01-10 17:58:08',NULL),(3197,7938,479,40721,3197,23,508,2,808.08,NULL,'2023-01-10 18:16:33','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3198,7938,479,40721,3197,23,383,2,112651.69,NULL,'2023-01-10 18:16:33','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3199,7938,479,40721,3197,23,88,2,43440.35,NULL,'2023-01-10 18:16:33','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3200,7938,479,40721,3197,23,504,1,12695.89,NULL,'2023-01-10 18:16:33','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3201,7938,479,40721,3197,23,503,1,103141.88,NULL,'2023-01-10 18:16:33','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3202,7938,479,40721,3197,23,88,2,178282.01,NULL,'2023-01-10 18:16:34','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3203,7938,479,40721,3197,23,135,1,198384.48,NULL,'2023-01-10 18:16:34','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3204,7938,479,40721,3197,23,396,1,13206.41,NULL,'2023-01-10 18:16:34','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3205,7938,479,40721,3197,23,110,1,1466673.13,NULL,'2023-01-10 18:16:34','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3206,7938,479,40721,3197,23,518,1,5136.38,NULL,'2023-01-10 18:16:34','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3207,7938,479,40721,3197,23,516,1,18047.58,NULL,'2023-01-10 18:16:34','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3208,7938,479,40721,3197,23,510,2,469422.40,NULL,'2023-01-10 18:16:35','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3209,7938,479,40721,3197,23,514,1,230708.78,NULL,'2023-01-10 18:16:35','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3210,7938,479,40721,3197,23,519,1,1491.24,NULL,'2023-01-10 18:16:35','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3211,7938,479,40721,3197,23,517,1,368.66,NULL,'2023-01-10 18:16:35','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3212,7938,479,40721,3197,23,515,1,74313.78,NULL,'2023-01-10 18:16:35','2023-01-10 21:21:44','2023-01-10 21:21:44');
INSERT INTO `balance_libro_details` VALUES (3213,7938,479,40721,3197,23,502,1,1832661.96,NULL,'2023-01-10 18:16:36','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3214,7938,479,40721,3197,23,507,2,7161.36,NULL,'2023-01-10 18:16:36','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3215,7938,479,40721,3197,23,513,1,25392.98,NULL,'2023-01-10 18:16:36','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3216,7938,479,40721,3197,23,155,1,123525.45,NULL,'2023-01-10 18:16:36','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3217,7938,479,40721,3197,23,505,1,13495.90,NULL,'2023-01-10 18:16:36','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3218,7938,479,40721,3197,23,520,2,1884.56,NULL,'2023-01-10 18:16:36','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3219,7938,479,40721,3197,23,492,1,24876.58,NULL,'2023-01-10 18:16:37','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3220,7938,479,40721,3197,23,102,2,10430.43,NULL,'2023-01-10 18:16:37','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3221,7938,479,40721,3197,23,156,1,259829.63,NULL,'2023-01-10 18:16:37','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3222,7938,479,40721,3197,23,209,1,5795.06,NULL,'2023-01-10 18:16:37','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3223,7938,479,40721,3197,23,509,2,4308484.85,NULL,'2023-01-10 18:16:37','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3224,7938,479,40721,3197,23,476,1,722819.96,NULL,'2023-01-10 18:16:37','2023-01-10 21:21:44','2023-01-10 21:21:44'),(3225,7938,480,40721,3197,19,513,2,70392.98,NULL,'2023-01-10 18:55:04','2023-01-10 21:28:11','2023-01-10 21:28:11'),(3226,7938,480,40721,3197,19,110,1,70392.98,NULL,'2023-01-10 18:55:04','2023-01-10 21:28:11','2023-01-10 21:28:11'),(3227,7938,481,40721,3197,3,68,1,204684.60,NULL,'2023-01-10 21:02:10','2023-01-10 21:02:10',NULL),(3228,7938,481,40721,3197,3,62,1,373093.95,NULL,'2023-01-10 21:02:10','2023-01-10 21:02:10',NULL),(3229,7938,481,40721,3197,3,500,1,128154.37,NULL,'2023-01-10 21:02:10','2023-01-10 21:02:10',NULL),(3230,7938,481,40721,3197,3,64,1,11257.20,NULL,'2023-01-10 21:02:10','2023-01-10 21:02:10',NULL),(3231,7938,481,40721,3197,3,396,1,4750.00,NULL,'2023-01-10 21:02:10','2023-01-10 21:02:10',NULL),(3232,7938,481,40721,3197,3,502,1,2192666.37,NULL,'2023-01-10 21:02:10','2023-01-10 21:02:10',NULL),(3233,7938,481,40721,3197,3,74,1,104182.20,NULL,'2023-01-10 21:02:10','2023-01-10 21:02:10',NULL),(3234,7938,481,40721,3197,3,78,1,88179.24,NULL,'2023-01-10 21:02:10','2023-01-10 21:02:10',NULL),(3235,7938,481,40721,3197,3,503,1,29877.91,NULL,'2023-01-10 21:02:10','2023-01-10 21:02:10',NULL),(3236,7938,481,40721,3197,3,25,1,135.00,NULL,'2023-01-10 21:02:10','2023-01-10 21:02:10',NULL),(3237,7938,481,40721,3197,3,504,1,2825.30,NULL,'2023-01-10 21:02:10','2023-01-10 21:02:10',NULL),(3238,7938,481,40721,3197,3,157,1,48953.12,NULL,'2023-01-10 21:02:10','2023-01-10 21:02:10',NULL),(3239,7938,481,40721,3197,3,425,2,3655063.70,NULL,'2023-01-10 21:02:10','2023-01-10 21:02:10',NULL),(3240,7938,481,40721,3197,3,492,1,256890.00,NULL,'2023-01-10 21:02:10','2023-01-10 21:02:10',NULL),(3241,7938,481,40721,3197,3,209,1,25494.06,NULL,'2023-01-10 21:02:10','2023-01-10 21:02:10',NULL),(3242,7938,481,40721,3197,3,135,1,178821.58,NULL,'2023-01-10 21:02:10','2023-01-10 21:02:10',NULL),(3243,7938,481,40721,3197,3,497,1,5098.80,NULL,'2023-01-10 21:02:10','2023-01-10 21:02:10',NULL),(3244,7938,482,40721,3196,3,68,1,203982.54,NULL,'2023-01-10 21:03:50','2023-01-10 21:03:50',NULL),(3245,7938,482,40721,3196,3,62,1,317543.08,NULL,'2023-01-10 21:03:50','2023-01-10 21:03:50',NULL),(3246,7938,482,40721,3196,3,500,1,138245.67,NULL,'2023-01-10 21:03:50','2023-01-10 21:03:50',NULL),(3247,7938,482,40721,3196,3,64,1,9368.47,NULL,'2023-01-10 21:03:50','2023-01-10 21:03:50',NULL),(3248,7938,482,40721,3196,3,396,1,3500.00,NULL,'2023-01-10 21:03:50','2023-01-10 21:03:50',NULL),(3249,7938,482,40721,3196,3,502,1,1466969.57,NULL,'2023-01-10 21:03:50','2023-01-10 21:03:50',NULL),(3250,7938,482,40721,3196,3,78,1,39401.36,NULL,'2023-01-10 21:03:50','2023-01-10 21:03:50',NULL);
INSERT INTO `balance_libro_details` VALUES (3251,7938,482,40721,3196,3,503,1,33422.24,NULL,'2023-01-10 21:03:50','2023-01-10 21:03:50',NULL),(3252,7938,482,40721,3196,3,135,1,44449.51,NULL,'2023-01-10 21:03:50','2023-01-10 21:03:50',NULL),(3253,7938,482,40721,3196,3,25,1,90.00,NULL,'2023-01-10 21:03:50','2023-01-10 21:03:50',NULL),(3254,7938,482,40721,3196,3,504,1,1861.09,NULL,'2023-01-10 21:03:50','2023-01-10 21:03:50',NULL),(3255,7938,482,40721,3196,3,157,1,19683.92,NULL,'2023-01-10 21:03:50','2023-01-10 21:03:50',NULL),(3256,7938,482,40721,3196,3,425,2,2308690.97,NULL,'2023-01-10 21:03:50','2023-01-10 21:03:50',NULL),(3257,7938,482,40721,3196,3,209,1,18297.34,NULL,'2023-01-10 21:03:50','2023-01-10 21:03:50',NULL),(3258,7938,482,40721,3196,3,64,1,8206.24,NULL,'2023-01-10 21:03:50','2023-01-10 21:03:50',NULL),(3259,7938,482,40721,3196,3,497,1,3669.94,NULL,'2023-01-10 21:03:50','2023-01-10 21:03:50',NULL),(3260,7938,483,40721,3184,3,68,1,12748.33,NULL,'2023-01-10 21:04:37','2023-01-10 21:08:19','2023-01-10 21:08:19'),(3261,7938,483,40721,3184,3,62,1,210646.03,NULL,'2023-01-10 21:04:37','2023-01-10 21:08:19','2023-01-10 21:08:19'),(3262,7938,483,40721,3184,3,500,1,90350.12,NULL,'2023-01-10 21:04:37','2023-01-10 21:08:19','2023-01-10 21:08:19'),(3263,7938,483,40721,3184,3,64,1,7865.00,NULL,'2023-01-10 21:04:37','2023-01-10 21:08:19','2023-01-10 21:08:19'),(3264,7938,483,40721,3184,3,396,1,2826.00,NULL,'2023-01-10 21:04:37','2023-01-10 21:08:19','2023-01-10 21:08:19'),(3265,7938,483,40721,3184,3,502,1,336098.26,NULL,'2023-01-10 21:04:37','2023-01-10 21:08:19','2023-01-10 21:08:19'),(3266,7938,483,40721,3184,3,78,1,116.32,NULL,'2023-01-10 21:04:37','2023-01-10 21:08:19','2023-01-10 21:08:19'),(3267,7938,483,40721,3184,3,503,1,22494.74,NULL,'2023-01-10 21:04:37','2023-01-10 21:08:19','2023-01-10 21:08:19'),(3268,7938,483,40721,3184,3,135,1,76653.84,NULL,'2023-01-10 21:04:37','2023-01-10 21:08:19','2023-01-10 21:08:19'),(3269,7938,483,40721,3184,3,25,1,673.56,NULL,'2023-01-10 21:04:37','2023-01-10 21:08:19','2023-01-10 21:08:19'),(3270,7938,483,40721,3184,3,504,1,2284.85,NULL,'2023-01-10 21:04:37','2023-01-10 21:08:19','2023-01-10 21:08:19'),(3271,7938,483,40721,3184,3,157,1,9648.43,NULL,'2023-01-10 21:04:37','2023-01-10 21:08:19','2023-01-10 21:08:19'),(3272,7938,483,40721,3184,3,425,2,773313.69,NULL,'2023-01-10 21:04:37','2023-01-10 21:08:19','2023-01-10 21:08:19'),(3273,7938,483,40721,3184,3,497,1,908.21,NULL,'2023-01-10 21:04:37','2023-01-10 21:08:19','2023-01-10 21:08:19'),(3274,7938,484,40721,3184,3,68,1,12748.33,NULL,'2023-01-10 21:08:19','2023-01-10 21:08:19',NULL),(3275,7938,484,40721,3184,3,62,1,210646.03,NULL,'2023-01-10 21:08:19','2023-01-10 21:08:19',NULL),(3276,7938,484,40721,3184,3,500,1,90350.12,NULL,'2023-01-10 21:08:19','2023-01-10 21:08:19',NULL),(3277,7938,484,40721,3184,3,64,1,7865.00,NULL,'2023-01-10 21:08:19','2023-01-10 21:08:19',NULL),(3278,7938,484,40721,3184,3,396,1,2826.00,NULL,'2023-01-10 21:08:19','2023-01-10 21:08:19',NULL),(3279,7938,484,40721,3184,3,502,1,336098.26,NULL,'2023-01-10 21:08:19','2023-01-10 21:08:19',NULL),(3280,7938,484,40721,3184,3,78,1,116.32,NULL,'2023-01-10 21:08:19','2023-01-10 21:08:19',NULL),(3281,7938,484,40721,3184,3,503,1,22494.74,NULL,'2023-01-10 21:08:19','2023-01-10 21:08:19',NULL),(3282,7938,484,40721,3184,3,135,1,76532.77,NULL,'2023-01-10 21:08:19','2023-01-10 21:08:19',NULL),(3283,7938,484,40721,3184,3,25,1,673.56,NULL,'2023-01-10 21:08:19','2023-01-10 21:08:19',NULL),(3284,7938,484,40721,3184,3,504,1,2284.85,NULL,'2023-01-10 21:08:19','2023-01-10 21:08:19',NULL),(3285,7938,484,40721,3184,3,157,1,9648.43,NULL,'2023-01-10 21:08:19','2023-01-10 21:08:19',NULL),(3286,7938,484,40721,3184,3,425,2,773313.69,NULL,'2023-01-10 21:08:19','2023-01-10 21:08:19',NULL),(3287,7938,484,40721,3184,3,497,1,1029.28,NULL,'2023-01-10 21:08:19','2023-01-10 21:08:19',NULL),(3288,7938,485,40721,3185,3,68,1,11013.64,NULL,'2023-01-10 21:09:02','2023-01-10 21:09:02',NULL);
INSERT INTO `balance_libro_details` VALUES (3289,7938,485,40721,3185,3,62,1,226220.00,NULL,'2023-01-10 21:09:02','2023-01-10 21:09:02',NULL),(3290,7938,485,40721,3185,3,500,1,87450.80,NULL,'2023-01-10 21:09:02','2023-01-10 21:09:02',NULL),(3291,7938,485,40721,3185,3,64,1,7710.00,NULL,'2023-01-10 21:09:02','2023-01-10 21:09:02',NULL),(3292,7938,485,40721,3185,3,396,1,2826.00,NULL,'2023-01-10 21:09:02','2023-01-10 21:09:02',NULL),(3293,7938,485,40721,3185,3,502,1,374344.93,NULL,'2023-01-10 21:09:02','2023-01-10 21:09:02',NULL),(3294,7938,485,40721,3185,3,74,1,172.08,NULL,'2023-01-10 21:09:02','2023-01-10 21:09:02',NULL),(3295,7938,485,40721,3185,3,78,1,41.92,NULL,'2023-01-10 21:09:02','2023-01-10 21:09:02',NULL),(3296,7938,485,40721,3185,3,503,1,21001.80,NULL,'2023-01-10 21:09:02','2023-01-10 21:09:02',NULL),(3297,7938,485,40721,3185,3,135,1,61576.06,NULL,'2023-01-10 21:09:02','2023-01-10 21:09:02',NULL),(3298,7938,485,40721,3185,3,25,1,506.16,NULL,'2023-01-10 21:09:02','2023-01-10 21:09:02',NULL),(3299,7938,485,40721,3185,3,504,1,1944.93,NULL,'2023-01-10 21:09:02','2023-01-10 21:09:02',NULL),(3300,7938,485,40721,3185,3,157,1,11261.97,NULL,'2023-01-10 21:09:02','2023-01-10 21:09:02',NULL),(3301,7938,485,40721,3185,3,425,2,807073.25,NULL,'2023-01-10 21:09:02','2023-01-10 21:09:02',NULL),(3302,7938,485,40721,3185,3,497,1,1002.96,NULL,'2023-01-10 21:09:02','2023-01-10 21:09:02',NULL),(3303,7938,486,40721,3190,3,68,1,10763.04,NULL,'2023-01-10 21:10:17','2023-01-10 21:22:32','2023-01-10 21:22:32'),(3304,7938,486,40721,3190,3,62,1,247649.00,NULL,'2023-01-10 21:10:17','2023-01-10 21:22:32','2023-01-10 21:22:32'),(3305,7938,486,40721,3190,3,500,1,139496.40,NULL,'2023-01-10 21:10:17','2023-01-10 21:22:32','2023-01-10 21:22:32'),(3306,7938,486,40721,3190,3,64,1,11264.00,NULL,'2023-01-10 21:10:17','2023-01-10 21:22:32','2023-01-10 21:22:32'),(3307,7938,486,40721,3190,3,396,1,2826.00,NULL,'2023-01-10 21:10:17','2023-01-10 21:22:32','2023-01-10 21:22:32'),(3308,7938,486,40721,3190,3,502,1,369432.36,NULL,'2023-01-10 21:10:17','2023-01-10 21:22:32','2023-01-10 21:22:32'),(3309,7938,486,40721,3190,3,74,1,40727.36,NULL,'2023-01-10 21:10:17','2023-01-10 21:22:32','2023-01-10 21:22:32'),(3310,7938,486,40721,3190,3,78,1,30089.78,NULL,'2023-01-10 21:10:17','2023-01-10 21:22:32','2023-01-10 21:22:32'),(3311,7938,486,40721,3190,3,503,1,22052.89,NULL,'2023-01-10 21:10:17','2023-01-10 21:22:32','2023-01-10 21:22:32'),(3312,7938,486,40721,3190,3,135,1,35210.31,NULL,'2023-01-10 21:10:17','2023-01-10 21:22:32','2023-01-10 21:22:32'),(3313,7938,486,40721,3190,3,25,1,678.24,NULL,'2023-01-10 21:10:17','2023-01-10 21:22:32','2023-01-10 21:22:32'),(3314,7938,486,40721,3190,3,504,1,3371.60,NULL,'2023-01-10 21:10:17','2023-01-10 21:22:32','2023-01-10 21:22:32'),(3315,7938,486,40721,3190,3,157,1,10386.76,NULL,'2023-01-10 21:10:17','2023-01-10 21:22:32','2023-01-10 21:22:32'),(3316,7938,486,40721,3190,3,425,2,931409.43,NULL,'2023-01-10 21:10:17','2023-01-10 21:22:32','2023-01-10 21:22:32'),(3317,7938,486,40721,3190,3,209,1,6211.00,NULL,'2023-01-10 21:10:17','2023-01-10 21:22:32','2023-01-10 21:22:32'),(3318,7938,486,40721,3190,3,497,1,1250.69,NULL,'2023-01-10 21:10:17','2023-01-10 21:22:32','2023-01-10 21:22:32'),(3319,7938,487,40721,3192,3,68,1,16359.97,NULL,'2023-01-10 21:11:14','2023-01-10 21:11:14',NULL),(3320,7938,487,40721,3192,3,62,1,287074.00,NULL,'2023-01-10 21:11:14','2023-01-10 21:11:14',NULL),(3321,7938,487,40721,3192,3,500,1,114857.37,NULL,'2023-01-10 21:11:14','2023-01-10 21:11:14',NULL),(3322,7938,487,40721,3192,3,64,1,1222.89,NULL,'2023-01-10 21:11:14','2023-01-10 21:11:14',NULL),(3323,7938,487,40721,3192,3,396,1,3000.00,NULL,'2023-01-10 21:11:14','2023-01-10 21:11:14',NULL),(3324,7938,487,40721,3192,3,502,1,469345.46,NULL,'2023-01-10 21:11:14','2023-01-10 21:11:14',NULL),(3325,7938,487,40721,3192,3,74,1,50562.82,NULL,'2023-01-10 21:11:14','2023-01-10 21:11:14',NULL),(3326,7938,487,40721,3192,3,78,1,30070.06,NULL,'2023-01-10 21:11:14','2023-01-10 21:11:14',NULL);
INSERT INTO `balance_libro_details` VALUES (3327,7938,487,40721,3192,3,503,1,22886.98,NULL,'2023-01-10 21:11:14','2023-01-10 21:11:14',NULL),(3328,7938,487,40721,3192,3,135,1,32269.24,NULL,'2023-01-10 21:11:14','2023-01-10 21:11:14',NULL),(3329,7938,487,40721,3192,3,25,1,720.00,NULL,'2023-01-10 21:11:14','2023-01-10 21:11:14',NULL),(3330,7938,487,40721,3192,3,504,1,3912.48,NULL,'2023-01-10 21:11:14','2023-01-10 21:11:14',NULL),(3331,7938,487,40721,3192,3,157,1,13497.22,NULL,'2023-01-10 21:11:14','2023-01-10 21:11:14',NULL),(3332,7938,487,40721,3192,3,425,2,1054613.70,NULL,'2023-01-10 21:11:14','2023-01-10 21:11:14',NULL),(3333,7938,487,40721,3192,3,209,1,7355.18,NULL,'2023-01-10 21:11:14','2023-01-10 21:11:14',NULL),(3334,7938,487,40721,3192,3,497,1,1480.03,NULL,'2023-01-10 21:11:14','2023-01-10 21:11:14',NULL),(3335,7938,488,40721,3193,3,68,1,76398.84,NULL,'2023-01-10 21:12:30','2023-01-10 21:12:30',NULL),(3336,7938,488,40721,3193,3,62,1,309933.00,NULL,'2023-01-10 21:12:30','2023-01-10 21:12:30',NULL),(3337,7938,488,40721,3193,3,500,1,114680.63,NULL,'2023-01-10 21:12:30','2023-01-10 21:12:30',NULL),(3338,7938,488,40721,3193,3,396,1,3000.00,NULL,'2023-01-10 21:12:30','2023-01-10 21:12:30',NULL),(3339,7938,488,40721,3193,3,502,1,528524.53,NULL,'2023-01-10 21:12:30','2023-01-10 21:12:30',NULL),(3340,7938,488,40721,3193,3,74,1,51473.76,NULL,'2023-01-10 21:12:30','2023-01-10 21:12:30',NULL),(3341,7938,488,40721,3193,3,78,1,34505.54,NULL,'2023-01-10 21:12:30','2023-01-10 21:12:30',NULL),(3342,7938,488,40721,3193,3,503,1,23981.40,NULL,'2023-01-10 21:12:30','2023-01-10 21:12:30',NULL),(3343,7938,488,40721,3193,3,135,1,62838.97,NULL,'2023-01-10 21:12:30','2023-01-10 21:12:30',NULL),(3344,7938,488,40721,3193,3,25,1,720.00,NULL,'2023-01-10 21:12:30','2023-01-10 21:12:30',NULL),(3345,7938,488,40721,3193,3,504,1,2927.83,NULL,'2023-01-10 21:12:30','2023-01-10 21:12:30',NULL),(3346,7938,488,40721,3193,3,157,1,17543.38,NULL,'2023-01-10 21:12:30','2023-01-10 21:12:30',NULL),(3347,7938,488,40721,3193,3,425,2,1236753.25,NULL,'2023-01-10 21:12:30','2023-01-10 21:12:30',NULL),(3348,7938,488,40721,3193,3,209,1,8513.64,NULL,'2023-01-10 21:12:30','2023-01-10 21:12:30',NULL),(3349,7938,488,40721,3193,3,497,1,1711.73,NULL,'2023-01-10 21:12:30','2023-01-10 21:12:30',NULL),(3350,7938,489,40721,3194,3,68,1,84219.91,NULL,'2023-01-10 21:13:33','2023-01-10 21:13:33',NULL),(3351,7938,489,40721,3194,3,62,1,406166.00,NULL,'2023-01-10 21:13:33','2023-01-10 21:13:33',NULL),(3352,7938,489,40721,3194,3,500,1,139141.52,NULL,'2023-01-10 21:13:33','2023-01-10 21:13:33',NULL),(3353,7938,489,40721,3194,3,64,1,24797.39,NULL,'2023-01-10 21:13:33','2023-01-10 21:13:33',NULL),(3354,7938,489,40721,3194,3,396,1,3000.00,NULL,'2023-01-10 21:13:33','2023-01-10 21:13:33',NULL),(3355,7938,489,40721,3194,3,502,1,523829.98,NULL,'2023-01-10 21:13:33','2023-01-10 21:13:33',NULL),(3356,7938,489,40721,3194,3,78,1,37195.96,NULL,'2023-01-10 21:13:33','2023-01-10 21:13:33',NULL),(3357,7938,489,40721,3194,3,503,1,22804.79,NULL,'2023-01-10 21:13:33','2023-01-10 21:13:33',NULL),(3358,7938,489,40721,3194,3,135,1,51276.00,NULL,'2023-01-10 21:13:33','2023-01-10 21:13:33',NULL),(3359,7938,489,40721,3194,3,25,1,90.00,NULL,'2023-01-10 21:13:33','2023-01-10 21:13:33',NULL),(3360,7938,489,40721,3194,3,504,1,4255.83,NULL,'2023-01-10 21:13:33','2023-01-10 21:13:33',NULL),(3361,7938,489,40721,3194,3,157,1,14578.09,NULL,'2023-01-10 21:13:33','2023-01-10 21:13:33',NULL),(3362,7938,489,40721,3194,3,425,2,1320610.77,NULL,'2023-01-10 21:13:33','2023-01-10 21:13:33',NULL),(3363,7938,489,40721,3194,3,209,1,7712.75,NULL,'2023-01-10 21:13:33','2023-01-10 21:13:33',NULL),(3364,7938,489,40721,3194,3,497,1,1542.55,NULL,'2023-01-10 21:13:33','2023-01-10 21:13:33',NULL),(3365,7938,490,40721,3195,3,68,1,91871.68,NULL,'2023-01-10 21:14:35','2023-01-10 21:14:35',NULL),(3366,7938,490,40721,3195,3,62,1,321251.00,NULL,'2023-01-10 21:14:35','2023-01-10 21:14:35',NULL),(3367,7938,490,40721,3195,3,500,1,160696.54,NULL,'2023-01-10 21:14:35','2023-01-10 21:14:35',NULL);
INSERT INTO `balance_libro_details` VALUES (3368,7938,490,40721,3195,3,64,1,9517.00,NULL,'2023-01-10 21:14:35','2023-01-10 21:14:35',NULL),(3369,7938,490,40721,3195,3,396,1,3000.00,NULL,'2023-01-10 21:14:35','2023-01-10 21:14:35',NULL),(3370,7938,490,40721,3195,3,502,1,542949.36,NULL,'2023-01-10 21:14:35','2023-01-10 21:14:35',NULL),(3371,7938,490,40721,3195,3,78,1,33133.75,NULL,'2023-01-10 21:14:35','2023-01-10 21:14:35',NULL),(3372,7938,490,40721,3195,3,503,1,29678.17,NULL,'2023-01-10 21:14:35','2023-01-10 21:14:35',NULL),(3373,7938,490,40721,3195,3,135,1,63318.41,NULL,'2023-01-10 21:14:35','2023-01-10 21:14:35',NULL),(3374,7938,490,40721,3195,3,25,1,90.00,NULL,'2023-01-10 21:14:35','2023-01-10 21:14:35',NULL),(3375,7938,490,40721,3195,3,504,1,3800.07,NULL,'2023-01-10 21:14:35','2023-01-10 21:14:35',NULL),(3376,7938,490,40721,3195,3,157,1,16618.60,NULL,'2023-01-10 21:14:35','2023-01-10 21:14:35',NULL),(3377,7938,490,40721,3195,3,505,1,2309.19,NULL,'2023-01-10 21:14:35','2023-01-10 21:14:35',NULL),(3378,7938,490,40721,3195,3,425,2,1455445.84,NULL,'2023-01-10 21:14:35','2023-01-10 21:14:35',NULL),(3379,7938,490,40721,3195,3,492,1,167038.00,NULL,'2023-01-10 21:14:35','2023-01-10 21:14:35',NULL),(3380,7938,490,40721,3195,3,209,1,8478.29,NULL,'2023-01-10 21:14:35','2023-01-10 21:14:35',NULL),(3381,7938,490,40721,3195,3,497,1,1695.78,NULL,'2023-01-10 21:14:35','2023-01-10 21:14:35',NULL),(3382,7938,491,40721,3191,3,68,1,7338.66,NULL,'2023-01-10 21:15:27','2023-01-10 21:15:27',NULL),(3383,7938,491,40721,3191,3,62,1,268301.00,NULL,'2023-01-10 21:15:27','2023-01-10 21:15:27',NULL),(3384,7938,491,40721,3191,3,500,1,111607.52,NULL,'2023-01-10 21:15:27','2023-01-10 21:15:27',NULL),(3385,7938,491,40721,3191,3,64,1,7536.47,NULL,'2023-01-10 21:15:27','2023-01-10 21:15:27',NULL),(3386,7938,491,40721,3191,3,396,1,3000.00,NULL,'2023-01-10 21:15:27','2023-01-10 21:15:27',NULL),(3387,7938,491,40721,3191,3,502,1,438026.11,NULL,'2023-01-10 21:15:27','2023-01-10 21:15:27',NULL),(3388,7938,491,40721,3191,3,74,1,43527.39,NULL,'2023-01-10 21:15:27','2023-01-10 21:15:27',NULL),(3389,7938,491,40721,3191,3,78,1,28722.75,NULL,'2023-01-10 21:15:27','2023-01-10 21:15:27',NULL),(3390,7938,491,40721,3191,3,503,1,23115.62,NULL,'2023-01-10 21:15:27','2023-01-10 21:15:27',NULL),(3391,7938,491,40721,3191,3,135,1,7443.47,NULL,'2023-01-10 21:15:27','2023-01-10 21:15:27',NULL),(3392,7938,491,40721,3191,3,504,1,2372.86,NULL,'2023-01-10 21:15:27','2023-01-10 21:15:27',NULL),(3393,7938,491,40721,3191,3,157,1,11914.21,NULL,'2023-01-10 21:15:27','2023-01-10 21:15:27',NULL),(3394,7938,491,40721,3191,3,505,1,30000.00,NULL,'2023-01-10 21:15:27','2023-01-10 21:15:27',NULL),(3395,7938,491,40721,3191,3,425,2,992778.29,NULL,'2023-01-10 21:15:27','2023-01-10 21:15:27',NULL),(3396,7938,491,40721,3191,3,25,1,2498.67,NULL,'2023-01-10 21:15:27','2023-01-10 21:15:27',NULL),(3397,7938,491,40721,3191,3,209,1,6137.13,NULL,'2023-01-10 21:15:27','2023-01-10 21:15:27',NULL),(3398,7938,491,40721,3191,3,497,1,1236.43,NULL,'2023-01-10 21:15:27','2023-01-10 21:15:27',NULL),(3399,7938,492,40721,3186,3,68,1,13965.90,NULL,'2023-01-10 21:16:10','2023-01-10 22:04:12','2023-01-10 22:04:12'),(3400,7938,492,40721,3186,3,62,1,324400.00,NULL,'2023-01-10 21:16:10','2023-01-10 22:04:12','2023-01-10 22:04:12'),(3401,7938,492,40721,3186,3,500,1,89955.84,NULL,'2023-01-10 21:16:10','2023-01-10 22:04:12','2023-01-10 22:04:12'),(3402,7938,492,40721,3186,3,64,1,6833.52,NULL,'2023-01-10 21:16:10','2023-01-10 22:04:12','2023-01-10 22:04:12'),(3403,7938,492,40721,3186,3,396,1,2826.00,NULL,'2023-01-10 21:16:10','2023-01-10 22:04:12','2023-01-10 22:04:12'),(3404,7938,492,40721,3186,3,502,1,376927.78,NULL,'2023-01-10 21:16:10','2023-01-10 22:04:12','2023-01-10 22:04:12'),(3405,7938,492,40721,3186,3,74,1,41127.73,NULL,'2023-01-10 21:16:10','2023-01-10 22:04:12','2023-01-10 22:04:12'),(3406,7938,492,40721,3186,3,78,1,22135.82,NULL,'2023-01-10 21:16:10','2023-01-10 22:04:12','2023-01-10 22:04:12');
INSERT INTO `balance_libro_details` VALUES (3407,7938,492,40721,3186,3,503,1,19946.76,NULL,'2023-01-10 21:16:10','2023-01-10 22:04:12','2023-01-10 22:04:12'),(3408,7938,492,40721,3186,3,135,1,42457.73,NULL,'2023-01-10 21:16:10','2023-01-10 22:04:12','2023-01-10 22:04:12'),(3409,7938,492,40721,3186,3,25,1,678.24,NULL,'2023-01-10 21:16:10','2023-01-10 22:04:12','2023-01-10 22:04:12'),(3410,7938,492,40721,3186,3,504,1,2887.58,NULL,'2023-01-10 21:16:10','2023-01-10 22:04:12','2023-01-10 22:04:12'),(3411,7938,492,40721,3186,3,157,1,11794.58,NULL,'2023-01-10 21:16:10','2023-01-10 22:04:12','2023-01-10 22:04:12'),(3412,7938,492,40721,3186,3,425,2,1002343.85,NULL,'2023-01-10 21:16:10','2023-01-10 22:04:12','2023-01-10 22:04:12'),(3413,7938,492,40721,3186,3,513,1,45000.00,NULL,'2023-01-10 21:16:10','2023-01-10 22:04:12','2023-01-10 22:04:12'),(3414,7938,492,40721,3186,3,497,1,1406.37,NULL,'2023-01-10 21:16:10','2023-01-10 22:04:12','2023-01-10 22:04:12'),(3415,7938,493,40721,3183,3,68,1,89646.50,NULL,'2023-01-10 21:16:42','2023-01-10 21:16:42',NULL),(3416,7938,493,40721,3183,3,62,1,218898.00,NULL,'2023-01-10 21:16:42','2023-01-10 21:16:42',NULL),(3417,7938,493,40721,3183,3,64,1,4531.70,NULL,'2023-01-10 21:16:42','2023-01-10 21:16:42',NULL),(3418,7938,493,40721,3183,3,396,1,2826.00,NULL,'2023-01-10 21:16:42','2023-01-10 21:16:42',NULL),(3419,7938,493,40721,3183,3,502,1,293948.56,NULL,'2023-01-10 21:16:42','2023-01-10 21:16:42',NULL),(3420,7938,493,40721,3183,3,74,1,25060.57,NULL,'2023-01-10 21:16:42','2023-01-10 21:16:42',NULL),(3421,7938,493,40721,3183,3,78,1,52.39,NULL,'2023-01-10 21:16:42','2023-01-10 21:16:42',NULL),(3422,7938,493,40721,3183,3,503,1,22826.54,NULL,'2023-01-10 21:16:42','2023-01-10 21:16:42',NULL),(3423,7938,493,40721,3183,3,135,1,17084.88,NULL,'2023-01-10 21:16:42','2023-01-10 21:16:42',NULL),(3424,7938,493,40721,3183,3,25,1,586.89,NULL,'2023-01-10 21:16:42','2023-01-10 21:16:42',NULL),(3425,7938,493,40721,3183,3,504,1,2546.66,NULL,'2023-01-10 21:16:42','2023-01-10 21:16:42',NULL),(3426,7938,493,40721,3183,3,157,1,9983.80,NULL,'2023-01-10 21:16:42','2023-01-10 21:16:42',NULL),(3427,7938,493,40721,3183,3,425,2,776419.82,NULL,'2023-01-10 21:16:42','2023-01-10 21:16:42',NULL),(3428,7938,493,40721,3183,3,76,1,87341.81,NULL,'2023-01-10 21:16:42','2023-01-10 21:16:42',NULL),(3429,7938,493,40721,3183,3,497,1,1085.52,NULL,'2023-01-10 21:16:42','2023-01-10 21:16:42',NULL),(3430,7938,494,40721,3190,3,68,1,10763.04,NULL,'2023-01-10 21:22:32','2023-01-10 21:22:32',NULL),(3431,7938,494,40721,3190,3,62,1,247649.00,NULL,'2023-01-10 21:22:32','2023-01-10 21:22:32',NULL),(3432,7938,494,40721,3190,3,500,1,139496.40,NULL,'2023-01-10 21:22:32','2023-01-10 21:22:32',NULL),(3433,7938,494,40721,3190,3,64,1,11264.00,NULL,'2023-01-10 21:22:32','2023-01-10 21:22:32',NULL),(3434,7938,494,40721,3190,3,396,1,2826.00,NULL,'2023-01-10 21:22:32','2023-01-10 21:22:32',NULL),(3435,7938,494,40721,3190,3,502,1,369432.36,NULL,'2023-01-10 21:22:32','2023-01-10 21:22:32',NULL),(3436,7938,494,40721,3190,3,74,1,40727.36,NULL,'2023-01-10 21:22:32','2023-01-10 21:22:32',NULL),(3437,7938,494,40721,3190,3,78,1,30089.78,NULL,'2023-01-10 21:22:32','2023-01-10 21:22:32',NULL),(3438,7938,494,40721,3190,3,503,1,22052.89,NULL,'2023-01-10 21:22:32','2023-01-10 21:22:32',NULL),(3439,7938,494,40721,3190,3,135,1,35210.31,NULL,'2023-01-10 21:22:32','2023-01-10 21:22:32',NULL),(3440,7938,494,40721,3190,3,25,1,678.24,NULL,'2023-01-10 21:22:32','2023-01-10 21:22:32',NULL),(3441,7938,494,40721,3190,3,504,1,3371.60,NULL,'2023-01-10 21:22:32','2023-01-10 21:22:32',NULL),(3442,7938,494,40721,3190,3,157,1,10386.76,NULL,'2023-01-10 21:22:32','2023-01-10 21:22:32',NULL),(3443,7938,494,40721,3190,3,425,2,931409.43,NULL,'2023-01-10 21:22:32','2023-01-10 21:22:32',NULL),(3444,7938,494,40721,3190,3,209,1,6211.01,NULL,'2023-01-10 21:22:32','2023-01-10 21:22:32',NULL),(3445,7938,494,40721,3190,3,497,1,1250.68,NULL,'2023-01-10 21:22:32','2023-01-10 21:22:32',NULL);
INSERT INTO `balance_libro_details` VALUES (3446,7938,495,40721,3195,16,156,1,76586.49,NULL,'2023-01-10 21:24:44','2023-01-10 21:24:44',NULL),(3447,7938,495,40721,3195,16,485,1,30329.44,NULL,'2023-01-10 21:24:44','2023-01-10 21:24:44',NULL),(3448,7938,495,40721,3195,16,209,2,8478.29,NULL,'2023-01-10 21:24:44','2023-01-10 21:24:44',NULL),(3449,7938,495,40721,3195,16,485,2,29672.51,NULL,'2023-01-10 21:24:44','2023-01-10 21:24:44',NULL),(3450,7938,495,40721,3195,16,78,2,39401.36,NULL,'2023-01-10 21:24:44','2023-01-10 21:24:44',NULL),(3451,7938,495,40721,3195,16,486,2,29363.77,NULL,'2023-01-10 21:24:44','2023-01-10 21:24:44',NULL),(3452,7938,496,40721,3197,19,513,2,45000.00,NULL,'2023-01-10 21:28:11','2023-01-10 22:03:30','2023-01-10 22:03:30'),(3453,7938,496,40721,3197,19,110,1,45000.00,NULL,'2023-01-10 21:28:11','2023-01-10 22:03:30','2023-01-10 22:03:30'),(3454,7938,497,40721,3197,23,508,2,808.08,NULL,'2023-01-10 21:49:01','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3455,7938,497,40721,3197,23,383,2,112651.69,NULL,'2023-01-10 21:49:01','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3456,7938,497,40721,3197,23,88,2,43440.35,NULL,'2023-01-10 21:49:01','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3457,7938,497,40721,3197,23,88,2,178282.01,NULL,'2023-01-10 21:49:01','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3458,7938,497,40721,3197,23,519,1,1491.24,NULL,'2023-01-10 21:49:01','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3459,7938,497,40721,3197,23,517,1,368.66,NULL,'2023-01-10 21:49:02','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3460,7938,497,40721,3197,23,515,1,74313.78,NULL,'2023-01-10 21:49:02','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3461,7938,497,40721,3197,23,110,1,1466673.13,NULL,'2023-01-10 21:49:02','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3462,7938,497,40721,3197,23,510,2,469422.40,NULL,'2023-01-10 21:49:02','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3463,7938,497,40721,3197,23,518,1,5136.38,NULL,'2023-01-10 21:49:02','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3464,7938,497,40721,3197,23,516,1,18047.58,NULL,'2023-01-10 21:49:02','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3465,7938,497,40721,3197,23,514,1,230708.78,NULL,'2023-01-10 21:49:03','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3466,7938,497,40721,3197,23,502,1,1832661.96,NULL,'2023-01-10 21:49:03','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3467,7938,497,40721,3197,23,507,2,7161.36,NULL,'2023-01-10 21:49:03','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3468,7938,497,40721,3197,23,513,1,25392.98,NULL,'2023-01-10 21:49:03','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3469,7938,497,40721,3197,23,155,1,123525.45,NULL,'2023-01-10 21:49:03','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3470,7938,497,40721,3197,23,520,2,1884.56,NULL,'2023-01-10 21:49:04','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3471,7938,497,40721,3197,23,505,1,13495.90,NULL,'2023-01-10 21:49:04','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3472,7938,497,40721,3197,23,102,2,10430.43,NULL,'2023-01-10 21:49:04','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3473,7938,497,40721,3197,23,492,1,24876.58,NULL,'2023-01-10 21:49:04','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3474,7938,497,40721,3197,23,509,2,4308484.85,NULL,'2023-01-10 21:49:05','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3475,7938,497,40721,3197,23,503,1,103141.88,NULL,'2023-01-10 21:49:05','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3476,7938,497,40721,3197,23,135,1,198303.92,NULL,'2023-01-10 21:49:05','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3477,7938,497,40721,3197,23,156,1,259829.63,NULL,'2023-01-10 21:49:05','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3478,7938,497,40721,3197,23,504,1,12695.89,NULL,'2023-01-10 21:49:05','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3479,7938,497,40721,3197,23,396,1,13206.41,NULL,'2023-01-10 21:49:05','2023-01-10 22:03:14','2023-01-10 22:03:14'),(3480,7938,497,40721,3197,23,476,1,728695.58,NULL,'2023-01-10 21:49:05','2023-01-10 22:03:14','2023-01-10 22:03:14');
INSERT INTO `balance_libro_details` VALUES (3481,7938,498,40721,3186,3,68,1,13965.90,NULL,'2023-01-10 22:04:12','2023-01-10 22:04:12',NULL),(3482,7938,498,40721,3186,3,62,1,324400.00,NULL,'2023-01-10 22:04:12','2023-01-10 22:04:12',NULL),(3483,7938,498,40721,3186,3,500,1,89955.84,NULL,'2023-01-10 22:04:12','2023-01-10 22:04:12',NULL),(3484,7938,498,40721,3186,3,64,1,6833.52,NULL,'2023-01-10 22:04:12','2023-01-10 22:04:12',NULL),(3485,7938,498,40721,3186,3,396,1,2826.00,NULL,'2023-01-10 22:04:12','2023-01-10 22:04:12',NULL),(3486,7938,498,40721,3186,3,502,1,376927.78,NULL,'2023-01-10 22:04:12','2023-01-10 22:04:12',NULL),(3487,7938,498,40721,3186,3,74,1,41127.73,NULL,'2023-01-10 22:04:12','2023-01-10 22:04:12',NULL),(3488,7938,498,40721,3186,3,78,1,22135.82,NULL,'2023-01-10 22:04:12','2023-01-10 22:04:12',NULL),(3489,7938,498,40721,3186,3,503,1,19946.76,NULL,'2023-01-10 22:04:12','2023-01-10 22:04:12',NULL),(3490,7938,498,40721,3186,3,135,1,42457.73,NULL,'2023-01-10 22:04:12','2023-01-10 22:04:12',NULL),(3491,7938,498,40721,3186,3,25,1,678.24,NULL,'2023-01-10 22:04:12','2023-01-10 22:04:12',NULL),(3492,7938,498,40721,3186,3,504,1,2887.58,NULL,'2023-01-10 22:04:12','2023-01-10 22:04:12',NULL),(3493,7938,498,40721,3186,3,157,1,11794.58,NULL,'2023-01-10 22:04:12','2023-01-10 22:04:12',NULL),(3494,7938,498,40721,3186,3,425,2,1002343.85,NULL,'2023-01-10 22:04:12','2023-01-10 22:04:12',NULL),(3495,7938,498,40721,3186,3,497,1,1406.37,NULL,'2023-01-10 22:04:12','2023-01-10 22:04:12',NULL),(3496,7938,498,40721,3186,3,110,1,45000.00,NULL,'2023-01-10 22:04:12','2023-01-10 22:04:12',NULL),(3497,7938,499,40721,3197,23,508,2,808.08,NULL,'2023-01-10 22:05:32','2023-01-10 22:05:32',NULL),(3498,7938,499,40721,3197,23,383,2,112651.69,NULL,'2023-01-10 22:05:32','2023-01-10 22:05:32',NULL),(3499,7938,499,40721,3197,23,88,2,43440.35,NULL,'2023-01-10 22:05:32','2023-01-10 22:05:32',NULL),(3500,7938,499,40721,3197,23,88,2,178282.01,NULL,'2023-01-10 22:05:32','2023-01-10 22:05:32',NULL),(3501,7938,499,40721,3197,23,519,1,1491.24,NULL,'2023-01-10 22:05:32','2023-01-10 22:05:32',NULL),(3502,7938,499,40721,3197,23,517,1,368.66,NULL,'2023-01-10 22:05:32','2023-01-10 22:05:32',NULL),(3503,7938,499,40721,3197,23,515,1,74313.78,NULL,'2023-01-10 22:05:32','2023-01-10 22:05:32',NULL),(3504,7938,499,40721,3197,23,110,1,1492066.12,NULL,'2023-01-10 22:05:32','2023-01-10 22:05:32',NULL),(3505,7938,499,40721,3197,23,510,2,469422.40,NULL,'2023-01-10 22:05:33','2023-01-10 22:05:33',NULL),(3506,7938,499,40721,3197,23,518,1,5136.38,NULL,'2023-01-10 22:05:33','2023-01-10 22:05:33',NULL),(3507,7938,499,40721,3197,23,516,1,18047.58,NULL,'2023-01-10 22:05:33','2023-01-10 22:05:33',NULL),(3508,7938,499,40721,3197,23,514,1,230708.78,NULL,'2023-01-10 22:05:33','2023-01-10 22:05:33',NULL),(3509,7938,499,40721,3197,23,507,2,7161.36,NULL,'2023-01-10 22:05:33','2023-01-10 22:05:33',NULL),(3510,7938,499,40721,3197,23,502,1,1832661.96,NULL,'2023-01-10 22:05:33','2023-01-10 22:05:33',NULL),(3511,7938,499,40721,3197,23,155,1,123525.45,NULL,'2023-01-10 22:05:34','2023-01-10 22:05:34',NULL),(3512,7938,499,40721,3197,23,520,2,1884.56,NULL,'2023-01-10 22:05:34','2023-01-10 22:05:34',NULL),(3513,7938,499,40721,3197,23,505,1,13495.90,NULL,'2023-01-10 22:05:34','2023-01-10 22:05:34',NULL),(3514,7938,499,40721,3197,23,102,2,10430.43,NULL,'2023-01-10 22:05:34','2023-01-10 22:05:34',NULL),(3515,7938,499,40721,3197,23,509,2,4308484.85,NULL,'2023-01-10 22:05:35','2023-01-10 22:05:35',NULL),(3516,7938,499,40721,3197,23,503,1,103141.88,NULL,'2023-01-10 22:05:35','2023-01-10 22:05:35',NULL),(3517,7938,499,40721,3197,23,135,1,198303.92,NULL,'2023-01-10 22:05:35','2023-01-10 22:05:35',NULL),(3518,7938,499,40721,3197,23,156,1,259829.63,NULL,'2023-01-10 22:05:35','2023-01-10 22:05:35',NULL),(3519,7938,499,40721,3197,23,504,1,12695.89,NULL,'2023-01-10 22:05:35','2023-01-10 22:05:35',NULL),(3520,7938,499,40721,3197,23,396,1,13206.41,NULL,'2023-01-10 22:05:35','2023-01-10 22:05:35',NULL);
INSERT INTO `balance_libro_details` VALUES (3521,7938,499,40721,3197,23,492,1,24876.58,NULL,'2023-01-10 22:05:36','2023-01-10 22:05:36',NULL),(3522,7938,499,40721,3197,23,476,1,728695.57,NULL,'2023-01-10 22:05:36','2023-01-10 22:05:36',NULL);
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2022-10-11 09:37:10',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2022-10-11 09:37:10',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2022-10-11 09:37:10',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-10-11 09:37:10','2022-10-11 09:37:10',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-10-11 09:37:17','2022-10-11 09:37:17',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-10-11 09:37:17','2022-10-11 09:37:17',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-10-11 09:37:17','2022-10-11 09:37:17',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-10-11 09:37:17','2022-10-11 09:37:17',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-10-11 09:37:25','2022-10-11 09:37:25',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-10-11 09:37:25','2022-10-11 09:37:25',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-10-11 09:37:25','2022-10-11 09:37:25',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-10-11 09:37:25','2022-10-11 09:37:25',NULL),(15,2022,11282141.08,0.00,5641070.54,0.00,0.0050,0.00,'2023-05-30 15:04:55','2023-05-30 15:04:55',NULL),(16,2022,11282141.08,5641070.54,12222319.51,28205.35,0.0075,5641070.54,'2023-05-30 15:04:55','2023-05-30 15:04:55',NULL),(17,2022,11282141.08,12222319.51,33846423.25,77564.72,0.0100,12222319.51,'2023-05-30 15:04:55','2023-05-30 15:04:55',NULL),(18,2022,11282141.08,33846423.25,188035684.71,293802.76,0.0125,33846423.25,'2023-05-30 15:04:55','2023-05-30 15:04:55',NULL),(19,2022,11282141.08,188035684.71,564107054.14,2221171.53,0.0150,188035684.71,'2023-05-30 15:04:55','2023-05-30 15:04:55',NULL),(20,2022,11282141.08,564107054.14,999999999999.00,7682242.07,0.0175,564107054.14,'2023-05-30 15:04:55','2023-05-30 15:04:55',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1850.00,11100.00,370000.00,30,3300,NULL,'1',NULL,'2022-10-23 23:36:24',NULL),(2,'B',2750.00,16500.00,550000.00,45,5000,NULL,'1',NULL,'2022-10-23 23:36:24',NULL),(3,'C',3850.00,23100.00,770000.00,60,6700,NULL,'1',NULL,'2022-10-23 23:36:24',NULL),(4,'D',5300.00,31800.00,1060000.00,85,10000,NULL,'1',NULL,'2022-10-23 23:36:24',NULL),(5,'E',7000.00,42000.00,1400000.00,110,13000,NULL,'1',NULL,'2022-10-23 23:36:24',NULL),(6,'F',8750.00,52500.00,1750000.00,150,16500,NULL,'1',NULL,'2022-10-23 23:36:24',NULL),(7,'G',10500.00,63000.00,2100000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:36:24',NULL),(8,'H',13000.00,78000.00,2600000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:36:24',NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',1414762.00,117896.00,'No Excluida','0',30,3330,230178.48,496.85,496.85,2192.15,3061.75,5750.75,5750.75,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',2103025.00,175252.00,'No Excluida','0',45,5000,230178.48,957.27,957.27,2411.36,3061.75,6430.38,6430.38,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',2944235.00,245352.00,'No Excluida','0',60,6700,460356.93,1636.83,1512.56,2652.52,3061.75,7351.10,7226.83,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',3656604.00,304717.00,'No Excluida','0',85,10000,460356.93,2689.05,2484.46,2917.75,3638.26,9245.06,9040.47,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',4305799.00,358816.00,'No Excluida','0',110,13000,573619.32,5115.04,3967.80,3209.55,4452.02,12776.61,11629.37,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',5382248.00,448520.00,'No Excluida','0',150,16500,575446.12,7036.89,5180.81,3530.49,5145.02,15712.40,13856.32,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',6458698.00,538224.00,'No Excluida','0',200,20000,690535.39,8951.39,6459.54,3883.53,5512.52,18347.44,15855.59,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',7996484.00,666373.00,'No Excluida','0',200,20000,920713.84,20460.26,15856.76,4271.88,6615.02,31347.16,26743.66,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',8949911.00,745825.00,'Venta de Bs Muebles','0',200,20000,920713.84,NULL,25575.36,4699.08,8190.03,NULL,38464.47,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',10257028.00,854752.00,'Venta de Bs Muebles','0',200,20000,920713.84,NULL,30054.72,5169.03,9166.53,NULL,44390.28,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',11379612.00,948301.00,'Venta de Bs Muebles','0',200,20000,920713.84,NULL,34526.76,5685.87,10505.29,NULL,50717.92,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',1414762.00,117896.00,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL),(13,'A Exento',1414762.00,117896.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2192.15,3061.75,5253.90,5253.90,'',NULL,NULL,'0',NULL,NULL,NULL),(14,'B Exento',2103025.00,175252.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2411.36,3061.75,5473.11,5473.11,'',NULL,NULL,'0',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `chequeras_tipos`
--

DROP TABLE IF EXISTS `chequeras_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chequeras_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chequeras_tipos`
--

LOCK TABLES `chequeras_tipos` WRITE;
/*!40000 ALTER TABLE `chequeras_tipos` DISABLE KEYS */;
INSERT INTO `chequeras_tipos` VALUES (1,NULL,'Fisica',1,NULL,NULL,NULL),(2,NULL,'Electronica',1,NULL,NULL,NULL),(3,NULL,'Transferencias',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `chequeras_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cheques_transfer_emitidas`
--

DROP TABLE IF EXISTS `cheques_transfer_emitidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cheques_transfer_emitidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_cheq_id` int(10) unsigned NOT NULL,
  `fecha_emision` date NOT NULL,
  `fecha_cobro` date NOT NULL,
  `numero_cheque` int(11) NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cheques_transfer_emitidas_person_id_foreign` (`person_id`),
  KEY `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cte_tes_ban_che_id_foreign` (`cta_cte_tesoreria_banco_cheq_id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cte_tes_ban_che_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_cheq_id`) REFERENCES `cta_cte_tesoreria_banco_cheq` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cheques_transfer_emitidas`
--

LOCK TABLES `cheques_transfer_emitidas` WRITE;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,NULL,'Clave Fiscal',NULL,NULL,NULL),(2,NULL,'Clave Ciudad',NULL,NULL,NULL),(3,NULL,'Clave ARBA',NULL,NULL,NULL),(4,NULL,'Clave ANSES',NULL,NULL,NULL),(5,NULL,'Catedral',NULL,NULL,NULL),(6,NULL,'CEMIBA',NULL,NULL,NULL),(7,NULL,'COMPRA ARG',NULL,NULL,NULL),(8,NULL,'Consejo Ciencias Economicas',NULL,NULL,NULL),(9,NULL,'Correo',NULL,NULL,NULL),(10,NULL,'CUR',NULL,NULL,NULL),(11,NULL,'Firma Digital',NULL,NULL,NULL),(12,NULL,'Interbanking',NULL,NULL,NULL),(13,NULL,'Banco Citibank',NULL,NULL,NULL),(14,NULL,'Banco Ciudad',NULL,NULL,NULL),(15,NULL,'Banco Frances',NULL,NULL,NULL),(16,NULL,'Banco Galicia',NULL,NULL,NULL),(17,NULL,'Banco HSBC',NULL,NULL,NULL),(18,NULL,'Banco Itau',NULL,NULL,NULL),(19,NULL,'Banco Nacion',NULL,NULL,NULL),(20,NULL,'Banco Macro',NULL,NULL,NULL),(21,NULL,'Banco Patagonia',NULL,NULL,NULL),(22,NULL,'Banco Provincia',NULL,NULL,NULL),(23,NULL,'Banco Santander',NULL,NULL,NULL),(24,NULL,'Banco Supervielle',NULL,NULL,NULL),(25,NULL,'Seguridad e Higiene',NULL,NULL,NULL),(26,NULL,'Sindicato - ANSES',NULL,NULL,NULL),(27,NULL,'Sindicato - AOT',NULL,NULL,NULL),(28,NULL,'Sindicato - ATSA',NULL,NULL,NULL),(29,NULL,'Sindicato - Camioneros',NULL,NULL,NULL),(30,NULL,'Sindicato - Guinchero',NULL,NULL,NULL),(31,NULL,'Sindicato - IERIC',NULL,NULL,NULL),(32,NULL,'Sindicato - La Estrella',NULL,NULL,NULL),(33,NULL,'Sindicato - Nemesis',NULL,NULL,NULL),(34,NULL,'Sindicato - Pasta',NULL,NULL,NULL),(35,NULL,'Sindicato - SEC',NULL,NULL,NULL),(36,NULL,'Sindicato - SICOP',NULL,NULL,NULL),(37,NULL,'Sindicato - SOCAYA',NULL,NULL,NULL),(38,NULL,'Sindicato - UTHGRA',NULL,NULL,NULL),(39,NULL,'Sindicato - INACAP',NULL,NULL,NULL),(40,NULL,'Sindicato - Otro',NULL,NULL,NULL),(41,NULL,'Otra',NULL,NULL,NULL),(42,NULL,'Prisma - Firma Digital',NULL,NULL,NULL),(43,NULL,'Sindicato - FATSA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2022-10-11 09:37:17','2022-10-11 09:37:17',NULL),(2,NULL,'Articulo 6',6,0,'2022-10-11 09:37:17','2022-10-11 09:37:17',NULL),(3,NULL,'Articulo 7',7,0,'2022-10-11 09:37:17','2022-10-11 09:37:17',NULL),(4,NULL,'Articulo 8',8,0,'2022-10-11 09:37:17','2022-10-11 09:37:17',NULL),(5,NULL,'Articulo 9',9,0,'2022-10-11 09:37:17','2022-10-11 09:37:17',NULL),(6,NULL,'Articulo 10',10,0,'2022-10-11 09:37:17','2022-10-11 09:37:17',NULL),(7,NULL,'Articulo 11',11,0,'2022-10-11 09:37:17','2022-10-11 09:37:17',NULL),(8,NULL,'Articulo 12',12,0,'2022-10-11 09:37:17','2022-10-11 09:37:17',NULL),(9,NULL,'Articulo 13',13,0,'2022-10-11 09:37:17','2022-10-11 09:37:17',NULL),(10,NULL,'Articulo 14',14,1,'2022-10-11 09:37:17','2022-10-11 09:37:17',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores`
--

DROP TABLE IF EXISTS `cobradores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores`
--

LOCK TABLES `cobradores` WRITE;
/*!40000 ALTER TABLE `cobradores` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,NULL,NULL),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,NULL,NULL),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,NULL,NULL),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,NULL,NULL),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,NULL,NULL),(15,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,NULL,NULL),(16,NULL,NULL,'IVA No Alcanzado',0,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas`
--

DROP TABLE IF EXISTS `consultas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas`
--

LOCK TABLES `consultas` WRITE;
/*!40000 ALTER TABLE `consultas` DISABLE KEYS */;
INSERT INTO `consultas` VALUES (1,NULL,'Estado Liquidaciones',1,NULL,NULL,NULL),(2,NULL,'Consumo',1,NULL,NULL,NULL),(3,NULL,'Resultado Liquidacion Hijas',1,'2023-03-12 23:44:21','2023-03-12 23:44:21',NULL);
/*!40000 ALTER TABLE `consultas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas_aux`
--

DROP TABLE IF EXISTS `consultas_aux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas_aux` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consulta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consultas_aux_consulta_id_foreign` (`consulta_id`),
  KEY `consultas_aux_person_id_foreign` (`person_id`),
  CONSTRAINT `consultas_aux_consulta_id_foreign` FOREIGN KEY (`consulta_id`) REFERENCES `consultas` (`id`),
  CONSTRAINT `consultas_aux_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas_aux`
--

LOCK TABLES `consultas_aux` WRITE;
/*!40000 ALTER TABLE `consultas_aux` DISABLE KEYS */;
INSERT INTO `consultas_aux` VALUES (1,NULL,1,NULL,'[{\"id\":40720,\"user_id\":7938,\"field_name1\":\"CRV GROUP SA\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"30-71458947-0\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2022-10-11T15:01:44.000000Z\",\"updated_at\":\"2022-10-11T15:01:44.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":2,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":3,\"user_id\":7938,\"person_id\":40720,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2022-10-11T15:01:44.000000Z\",\"updated_at\":\"2022-10-11T15:31:54.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":8,\"iva_condition_id\":2,\"obligation_sell\":0,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":0,\"obligation_iibb\":4,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2021-09\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":null,\"person_id_administrador\":40720,\"person_id_titular\":40720,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2014-05-30T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":null,\"periods\":[{\"id\":1533,\"user_id\":null,\"code\":\"2022-09\",\"year\":2022,\"period_number\":9,\"date_from\":\"2022-09-01\",\"date_to\":\"2022-09-30\",\"created_at\":null,\"updated_at\":null,\"person_id\":40720,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]}]',1,'2022-10-11 12:33:23','2022-10-11 12:33:23',NULL);
/*!40000 ALTER TABLE `consultas_aux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costo_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_centro_costo_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costo_plan_cuenta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_centro_costo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` (`conta_centro_costo_id`),
  KEY `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` (`conta_plan_cuenta_id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` FOREIGN KEY (`conta_centro_costo_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` FOREIGN KEY (`conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costo_plan_cuenta`
--

LOCK TABLES `conta_centro_costo_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costos`
--

DROP TABLE IF EXISTS `conta_centro_costos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costos_person_id_foreign` (`person_id`),
  CONSTRAINT `conta_centro_costos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costos`
--

LOCK TABLES `conta_centro_costos` WRITE;
/*!40000 ALTER TABLE `conta_centro_costos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=522 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,1,1,0,0,0,0,NULL),(5,NULL,1110101,5,1,1110100,'Caja Oficina','Activo',NULL,0,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',NULL,1,2,0,0,1,1,NULL),(21,7938,1140135,5,1,1140100,'Retenciones Ingresos Brutos','Activo',NULL,1,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,1,1,0,0,0,1,NULL),(76,NULL,2110310,5,2,2110300,'Otros Pagos AFIP','Pasivo',NULL,1,1,0,0,0,1,NULL),(78,NULL,2110350,5,2,2110300,'Impuesto a los Ingresos Brutos Pasivo','Pasivo',NULL,1,1,0,0,0,1,NULL),(79,NULL,2110313,5,2,2110300,'Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(102,7938,4120101,5,1,4120100,'Intereses plazo fijo','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(110,7938,5110106,5,2,5110100,'Sueldos y jornales','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(120,NULL,5120107,5,1,5120100,'Celulares','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(135,7938,5120108,5,2,5120100,'Gastos generales','Result. Negativo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(141,7938,5130101,5,2,5130100,'Intereses Resarcitorios impuesto a las ganancias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(157,7938,1160107,5,1,1160100,'Impuesto al Debito y Credito Bancario','Activo',NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(160,NULL,5210102,5,1,5210100,'Inversiones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,1,2,1,0,0,1,NULL),(163,NULL,1110122,5,1,1110100,'Banco Patagonia Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(165,NULL,1110123,5,1,1110100,'Banco Ciudad Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(180,NULL,5120129,5,1,5120100,'Sueldo Agustina','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(191,NULL,5120140,5,1,5120100,'Cargas Sociales','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(193,NULL,5120142,5,1,5120100,'Telefono Fijo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(209,7938,1160108,5,1,1160100,'SIRCREB','Activo',NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(212,NULL,5120153,5,1,5120100,'Tarjeta Visa','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(214,NULL,5120155,5,1,5120100,'Tarjeta Mastercard','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Imp. Municipales','Result. Negativo',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (216,NULL,5120157,5,1,5120100,'Perc/Ret. Imp. Ganancias','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,1,2,1,0,0,1,NULL),(256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,1,2,1,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,1,2,1,0,0,1,NULL),(269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,1,2,0,0,0,1,NULL),(312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,1,2,0,0,0,1,NULL),(327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,1,2,0,0,0,1,NULL),(344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22'),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,1,1,0,0,0,0,NULL),(371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',NULL,1,1,0,0,0,1,NULL),(391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,1,1,0,0,0,1,NULL),(396,NULL,5120160,5,1,5120100,'Comisiones Y gastos Bancarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(414,NULL,1220109,5,1,1220100,'Amortizacion Acumulada Equipos','Activo',NULL,1,1,0,0,0,1,NULL),(415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',NULL,1,1,0,0,0,1,NULL),(435,NULL,2110345,5,2,2110300,'Intereses a devengar PFP','Pasivo',NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,1,1,0,0,0,0,NULL),(444,NULL,2110501,5,2,2110500,'Banco Santander Rio Cta Cte','Pasivo',NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,1,2,0,0,1,1,NULL),(451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,1,1,0,0,0,0,NULL),(480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(482,7938,1120202,5,1,1120200,'Prestamos a socios','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (483,7938,2110404,5,2,2110400,'Deposito en garantía directores','Pasivo',NULL,1,1,0,0,0,0,NULL),(484,7938,1140133,5,1,1140100,'Retenciones ANSES','Activo',NULL,1,1,0,0,0,0,NULL),(485,7938,1140333,5,1,1140300,'Saldo a favor IIBB','Activo',NULL,1,1,0,0,0,0,NULL),(486,7938,1140134,5,1,1140100,'Retenciones IIBB','Activo',NULL,1,1,0,0,0,0,NULL),(487,7938,4110101,5,1,4110100,'Comisión prevención salud','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(488,7938,1130107,5,1,1130100,'Comisiones a cobrar','Activo',NULL,1,1,0,0,0,0,NULL),(489,7938,4110101,5,1,4110100,'Comisiones prevencion salud','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(490,7938,4110101,5,1,4110100,'Honorarios extra','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(491,7938,5110106,5,2,5110100,'Honorarios gerenciamiento','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(492,7938,5110106,5,2,5110100,'Honorarios profesionales','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(493,7938,5120108,5,2,5120100,'Gastos de comercialización','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(494,7938,5120108,5,2,5120100,'Gastos de representación','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(495,7938,5120108,5,2,5120100,'Libreria y papelería','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(496,7938,5120108,5,2,5120100,'Gastos de Internet e Informatica','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(497,7938,1130108,5,1,1130100,'Percepción IIBB','Activo',NULL,1,1,0,0,0,0,NULL),(498,7938,5120108,5,2,5120100,'Gastos de administración','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(499,7938,2110206,5,2,2110200,'Premio empleaos a pagar','Pasivo',NULL,1,1,0,0,0,0,NULL),(500,7938,2110351,5,2,2110300,'F931 a pagar','Pasivo',NULL,1,1,0,0,0,0,NULL),(501,7938,2110121,5,2,2110100,'Comisiones banco a pagar','Pasivo',NULL,1,1,0,0,0,0,NULL),(502,7938,5110106,5,2,5110100,'Comisiones pagadas','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(503,7938,5120108,5,2,5120100,'Impuestos y servicios','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(504,7938,5120108,5,2,5120100,'Seguros y salud','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(505,7938,5120108,5,2,5120100,'Bienes acciones part soc','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(506,7938,1130109,5,1,1130100,'comisiones a cobrar prev retiro','Activo',NULL,1,1,0,0,0,0,NULL),(507,7938,4110101,5,1,4110100,'Comisiones prev retiro','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(508,7938,4110101,5,1,4110100,'Comision banco sol','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(509,7938,4110101,5,1,4110100,'Comisiones SANCOR','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(510,7938,4120101,5,1,4120100,'Comisiones prevencion ART','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(511,7938,1130110,5,1,1130100,'comisiones ART  a cobrar','Activo',NULL,1,1,0,0,0,0,NULL),(512,7938,4110101,5,1,4110100,'Comisiones SANCOR a cobrar','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(513,7938,5110106,5,2,5110100,'premio empleados','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(514,7938,5110106,5,2,5110100,'Contribuciones seguridad social','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(515,7938,5110106,5,2,5110100,'Contribuciones obra social','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(516,7938,5110106,5,2,5110100,'ART','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(517,7938,5110106,5,2,5110100,'Seguro de vida obligatorio','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(518,7938,5110106,5,2,5110100,'INACAP','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(519,7938,5110106,5,2,5110100,'OSECAC','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(520,7938,4120101,5,1,4120100,'Detraccion art 23','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(521,7938,5110106,5,2,5110100,'INACAP','Result. Negativo',NULL,1,1,0,0,0,0,NULL);
/*!40000 ALTER TABLE `conta_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_asientos`
--

DROP TABLE IF EXISTS `conta_tipo_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_asientos`
--

LOCK TABLES `conta_tipo_asientos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_asientos` DISABLE KEYS */;
INSERT INTO `conta_tipo_asientos` VALUES (1,'Sueldos',NULL,NULL,NULL,11),(2,'Ingresos',NULL,NULL,NULL,9),(3,'Egresos',NULL,NULL,NULL,10),(4,'Amortizaciones',NULL,NULL,NULL,4),(5,'Banco',NULL,NULL,NULL,15),(6,'Ganancias',NULL,NULL,NULL,12),(7,'Retenciones',NULL,NULL,NULL,13),(8,'SIRCREB',NULL,NULL,NULL,14),(9,'Compensaciones',NULL,NULL,NULL,16),(10,'Pagos AFIP',NULL,NULL,NULL,17),(11,'Ajustes',NULL,NULL,NULL,3),(12,'Saldos Iniciales',NULL,NULL,NULL,1),(13,'Cancelacion de Iniciales',NULL,NULL,NULL,2),(14,'Patrimonio Neto',NULL,NULL,NULL,8),(15,'Liquidaciones IVA',NULL,NULL,NULL,18),(16,'Liquidacion IIBB',NULL,NULL,NULL,19),(17,'Asientos de Cierre',NULL,NULL,NULL,5),(18,'Reclasificacion',NULL,NULL,NULL,6),(19,'Otros',NULL,NULL,NULL,7),(20,'Cobranzas','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(21,'Pagos','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(22,'Tesoreria','2019-10-19 02:10:24','2019-10-19 02:10:24',NULL,NULL),(23,'Ajuste por Inflacion','2020-03-01 06:39:20','2020-03-01 06:39:20',NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_cuentas`
--

DROP TABLE IF EXISTS `conta_tipo_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_cuentas`
--

LOCK TABLES `conta_tipo_cuentas` WRITE;
/*!40000 ALTER TABLE `conta_tipo_cuentas` DISABLE KEYS */;
INSERT INTO `conta_tipo_cuentas` VALUES (1,'Rubro',NULL,NULL,NULL),(2,'SubRubro',NULL,NULL,NULL),(3,'Grupo',NULL,NULL,NULL),(4,'SubGrupo',NULL,NULL,NULL),(5,'Cuenta',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_saldos`
--

DROP TABLE IF EXISTS `conta_tipo_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_saldos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `saldo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_saldos`
--

LOCK TABLES `conta_tipo_saldos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_saldos` DISABLE KEYS */;
INSERT INTO `conta_tipo_saldos` VALUES (1,'Deudor',NULL,NULL,NULL),(2,'Acreedor',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_cuits_afip`
--

DROP TABLE IF EXISTS `control_cuits_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_cuits_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `control_cuits_afip_person_id_foreign` (`person_id`),
  CONSTRAINT `control_cuits_afip_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_cuits_afip`
--

LOCK TABLES `control_cuits_afip` WRITE;
/*!40000 ALTER TABLE `control_cuits_afip` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_cuits_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_general`
--

DROP TABLE IF EXISTS `control_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_general` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `control_general_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_general`
--

LOCK TABLES `control_general` WRITE;
/*!40000 ALTER TABLE `control_general` DISABLE KEYS */;
INSERT INTO `control_general` VALUES (1,'Ingresos - Egresos - Resultado',1,'Proyeccion Ganancias','control_general/proyecGanancias',NULL,NULL),(2,'IVA',2,'IVA','control_general/iva',NULL,NULL),(3,'IIBB',3,'IIBB','control_general/iibb',NULL,NULL),(4,'Por Mes',4,'Vto. Impuestos','control_general/vto',NULL,NULL),(5,'Por Impuesto',4,'Vto. Impuestos','control_general/vtoPorImpuestos',NULL,NULL);
/*!40000 ALTER TABLE `control_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente`
--

DROP TABLE IF EXISTS `cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `compensado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_cliente_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_cliente_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente`
--

LOCK TABLES `cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_details`
--

DROP TABLE IF EXISTS `cta_cte_cliente_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_details_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_cliente_details_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_details_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_details_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_details_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_details`
--

LOCK TABLES `cta_cte_cliente_details` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_pivot_receipt`
--

DROP TABLE IF EXISTS `cta_cte_cliente_pivot_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_pivot_receipt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `receipt_id` int(11) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_pivot_receipt`
--

LOCK TABLES `cta_cte_cliente_pivot_receipt` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `cta_cte_tesoreria_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `cta_cte_tesoreria_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria`
--

LOCK TABLES `cta_cte_tesoreria` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_cheq`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_cheq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_cheq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `chequera_tipo_id` int(10) unsigned NOT NULL,
  `serie` text COLLATE utf8mb4_unicode_ci,
  `numero_cheque` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_cheq_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` (`cta_cte_tesoreria_banco_id`),
  KEY `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` (`chequera_tipo_id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` FOREIGN KEY (`chequera_tipo_id`) REFERENCES `chequeras_tipos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_cheq`
--

LOCK TABLES `cta_cte_tesoreria_banco_cheq` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_bancos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `ctacte_banco_id` int(10) unsigned NOT NULL,
  `zone_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id_diferido` int(10) unsigned DEFAULT NULL,
  `cuenta_contable_id_pend_acred` int(10) unsigned DEFAULT NULL,
  `numero_cuenta` text COLLATE utf8mb4_unicode_ci,
  `cbu` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_bancos_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` (`ctacte_banco_id`),
  KEY `cta_cte_tesoreria_bancos_zone_id_foreign` (`zone_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` (`cuenta_contable_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` (`cuenta_contable_id_diferido`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` (`cuenta_contable_id_pend_acred`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` FOREIGN KEY (`ctacte_banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` FOREIGN KEY (`cuenta_contable_id_diferido`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` FOREIGN KEY (`cuenta_contable_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` FOREIGN KEY (`cuenta_contable_id_pend_acred`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_bancos`
--

LOCK TABLES `cta_cte_tesoreria_bancos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuenta_tipos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuenta_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuenta_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuenta_tipos`
--

LOCK TABLES `cta_cte_tesoreria_cuenta_tipos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuenta_tipos` VALUES (1,NULL,'CAJA',1,NULL,NULL,NULL),(2,NULL,'BANCOS',1,NULL,NULL,NULL),(3,NULL,'CHEQUES',1,NULL,NULL,NULL),(4,NULL,'RETENCIONES',1,NULL,NULL,NULL),(5,NULL,'PERCEPCIONES',1,NULL,NULL,NULL),(6,NULL,'RESULTADO NEGATIVO',1,NULL,NULL,NULL),(7,NULL,'RESULTADO POSITIVO',1,NULL,NULL,NULL),(8,NULL,'MOVIMIENTO',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuentas`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_tipo_id` int(10) unsigned NOT NULL DEFAULT '8',
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_cuentas_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `cta_tes_tipo_id_foreign` (`cta_cte_tesoreria_cuenta_tipo_id`),
  KEY `cta_cte_tesoreria_cuentas_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_tes_tipo_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_tipo_id`) REFERENCES `cta_cte_tesoreria_cuenta_tipos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=757 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuentas`
--

LOCK TABLES `cta_cte_tesoreria_cuentas` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (13,NULL,1,13,NULL,8,'Clientes - Deudores',0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(20,NULL,1,20,NULL,8,'Anticipos Impuesto a las Ganancias',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(23,NULL,1,23,NULL,4,'Retenciones Impuesto a las Ganancias',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(25,NULL,1,25,NULL,4,'Retenciones de IVA',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(57,NULL,1,57,NULL,8,'Proveedores en Cta. Cte. locales',0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(60,NULL,1,60,NULL,3,'Cheques emitidos ',0,1,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(62,NULL,1,62,NULL,8,'Sueldos y Jornales a pagar',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(140,NULL,1,140,NULL,6,'Intereses y Gastos bancarios',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(162,NULL,1,162,NULL,4,'Retenciones SUSS',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(176,NULL,1,176,NULL,3,'Cheques en Cartera',1,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(201,NULL,1,201,NULL,6,'Monotributo',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(203,NULL,1,203,NULL,6,'Autonomos',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(219,NULL,1,219,NULL,8,'Pagos AFIP',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(251,NULL,1,251,NULL,4,'Retenciones de IIBB Buenos Aires',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(252,NULL,1,252,NULL,4,'Retenciones de IIBB Capital Federal',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(253,NULL,1,253,NULL,4,'Retenciones de IIBB Catamarca',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(254,NULL,1,254,NULL,4,'Retenciones de IIBB Chaco',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(255,NULL,1,255,NULL,4,'Retenciones de IIBB Chubut',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(256,NULL,1,256,NULL,4,'Retenciones de IIBB Córdoba',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(257,NULL,1,257,NULL,4,'Retenciones de IIBB Corrientes',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(258,NULL,1,258,NULL,4,'Retenciones de IIBB Entre Ríos',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(259,NULL,1,259,NULL,4,'Retenciones de IIBB Formosa',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(260,NULL,1,260,NULL,4,'Retenciones de IIBB Jujuy',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(261,NULL,1,261,NULL,4,'Retenciones de IIBB La Pampa',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(262,NULL,1,262,NULL,4,'Retenciones de IIBB La Rioja',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(263,NULL,1,263,NULL,4,'Retenciones de IIBB Mendoza',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(264,NULL,1,264,NULL,4,'Retenciones de IIBB Misiones',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(265,NULL,1,265,NULL,4,'Retenciones de IIBB Neuquén',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(266,NULL,1,266,NULL,4,'Retenciones de IIBB Pascua Lama',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(267,NULL,1,267,NULL,4,'Retenciones de IIBB Río Negro',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(268,NULL,1,268,NULL,4,'Retenciones de IIBB Salta',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(269,NULL,1,269,NULL,4,'Retenciones de IIBB San Juan',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(270,NULL,1,270,NULL,4,'Retenciones de IIBB San Luis',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(271,NULL,1,271,NULL,4,'Retenciones de IIBB Santa Cruz',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (272,NULL,1,272,NULL,4,'Retenciones de IIBB Santa Fe',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(273,NULL,1,273,NULL,4,'Retenciones de IIBB Santiago del Estero',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(274,NULL,1,274,NULL,4,'Retenciones de IIBB Tierra del Fuego',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(275,NULL,1,275,NULL,4,'Retenciones de IIBB Tucuman',0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(351,NULL,1,351,NULL,8,'BANCO SIRCREB',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(359,NULL,1,359,NULL,8,'Caja en Pesos',0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:15:14','2023-03-20 23:15:14'),(360,NULL,1,360,NULL,8,'Retenciones Bancarias de Ganancias a Favor',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(364,NULL,1,364,NULL,8,'Anticipo de Clientes',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(384,NULL,1,384,NULL,8,'Caja en Dolares',0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:15:14','2023-03-20 23:15:14'),(409,NULL,1,409,NULL,6,'IVA Crédito Fiscal No computable',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(418,NULL,1,418,NULL,8,'Deudas Bancarias',0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(433,NULL,1,433,NULL,8,'Préstamo',0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(441,NULL,1,441,NULL,8,'Leasing',0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(448,NULL,1,448,NULL,8,'Planes de Pagos AFIP',0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(450,NULL,1,450,NULL,3,'Cheques Rechazados',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(467,NULL,1,467,NULL,6,'Interés',0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:14:28',NULL),(468,NULL,1,14,NULL,8,'Deudores por ventas comunes',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(469,NULL,1,15,NULL,8,'Deudores por ventas morosos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(470,NULL,1,16,NULL,8,'Deudores en gestión judicial',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(471,NULL,1,17,NULL,8,'Previsión deudores incobrables',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(472,NULL,1,22,NULL,8,'Anticipo Impto.Ganancia Mínima Presunta',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(473,NULL,1,24,NULL,4,'Impuesto a las Ganancias (Saldo a favor)',0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:55:26',NULL),(474,NULL,1,27,NULL,8,'Anticipos de proveedores',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(475,NULL,1,28,NULL,8,'Depósito en garantía alquileres',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(476,NULL,1,29,NULL,8,'Derechos adquiridos a devengar',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(477,NULL,1,30,NULL,8,'Intereses a devengar',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(478,NULL,1,31,NULL,8,'Cuentas a rendir - Directores',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(479,NULL,1,32,NULL,8,'Alquileres no devengados',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(480,NULL,1,38,NULL,8,'Equipos de computación valores históricos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(481,NULL,1,39,NULL,8,'Equipos de computación ajuste',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(482,NULL,1,40,NULL,8,'Amortización Acumulada Equipos de comput.',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(483,NULL,1,42,NULL,8,'Instalaciones valores históricos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(484,NULL,1,43,NULL,8,'Instalaciones ajuste',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(485,NULL,1,44,NULL,8,'Amortización Acumulada Instalaciones',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (486,NULL,1,46,NULL,8,'Muebles y utiles valores históricos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(487,NULL,1,47,NULL,8,'Muebles y utiles ajuste',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(488,NULL,1,48,NULL,8,'Amortización Acumulada Muebles y Útiles',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(489,NULL,1,50,NULL,8,'Gastos de organización valores historicos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(490,NULL,1,51,NULL,8,'Gastos de organización ajuste',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(491,NULL,1,52,NULL,8,'Amortización acumulada gs. de organización',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(492,NULL,1,58,NULL,8,'Proveedores en cta. cte. exterior',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(493,NULL,1,59,NULL,8,'Derechos de exhibición a devengar',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(494,NULL,1,63,NULL,8,'Cargas sociales a pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(495,NULL,1,64,NULL,8,'Sindicatos a Pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(496,NULL,1,67,NULL,8,'IVA Debito Fiscal',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(497,NULL,1,68,NULL,8,'IVA Credito Fiscal',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(498,NULL,1,69,NULL,8,'Impuestos Internos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(499,NULL,1,70,NULL,8,'Impuestos al Combustible',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(500,NULL,1,71,NULL,8,'IVA Retenciones de terceros',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(501,NULL,1,72,NULL,5,'IVA Percepciones realiz.por terceros',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(502,NULL,1,73,NULL,8,'IVA Saldo a favor',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(503,NULL,1,74,NULL,8,'IVA a pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(504,NULL,1,75,NULL,5,'Percepciones Ingresos Brutos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(505,NULL,1,76,NULL,8,'Otros Pagos AFIP',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(506,NULL,1,78,NULL,8,'Impuesto a los Ingresos Brutos Pasivo',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(507,NULL,1,79,NULL,8,'Impuesto a las Ganancias',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(508,NULL,1,80,NULL,8,'Impuesto a la Ganancia Mínima Presunta',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(509,NULL,1,81,NULL,8,'AFIP - Retenciones Impuesto a las Ganancias',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(510,NULL,1,82,NULL,8,'AFIP - Plan de Facilidades Decreto 338/02',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(511,NULL,1,87,NULL,8,'Acciones en circulación',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(512,NULL,1,88,NULL,8,'Ajuste del Capital',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(513,NULL,1,89,NULL,8,'Aportes Irrevocables Futuras Suscripciones',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(514,NULL,1,91,NULL,8,'Resultado del ejercicio',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(515,NULL,1,92,NULL,8,'Resultado ejercicios anteriores',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(516,NULL,1,93,NULL,8,'A.R.E.A.',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(517,NULL,1,96,NULL,7,'VENTAS',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(518,NULL,1,97,NULL,7,'Honorarios',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(519,NULL,1,99,NULL,7,'Descuentos obtenidos',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (520,NULL,1,100,NULL,7,'Reintegros por exportaciones',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:28',NULL),(521,NULL,1,102,NULL,7,'Intereses Cobrados',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(522,NULL,1,103,NULL,7,'Diferencias de cambio',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(523,NULL,1,104,NULL,7,'Descuentos obtenidos',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(524,NULL,1,110,NULL,6,'Sueldos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(525,NULL,1,111,NULL,6,'Contribuciones',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(526,NULL,1,112,NULL,6,'Sindicato',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(527,NULL,1,114,NULL,8,'ACA',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(528,NULL,1,115,NULL,6,'Aereos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(529,NULL,1,116,NULL,6,'Alquiler',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(530,NULL,1,117,NULL,8,'AGUA AYSA',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(531,NULL,1,118,NULL,8,'TV Cablevision',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(532,NULL,1,119,NULL,1,'Caja Jubilacion Consejo',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(533,NULL,1,120,NULL,6,'Celulares',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(534,NULL,1,121,NULL,3,'Cheques',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(535,NULL,1,123,NULL,8,'Comida',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(536,NULL,1,126,NULL,6,'Fletes y acarreos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(537,NULL,1,127,NULL,8,'Luz Edesur',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(538,NULL,1,128,NULL,6,'Movilidad y Viáticos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(539,NULL,1,129,NULL,8,'Mantenimiento',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(540,NULL,1,130,NULL,8,'IVA No Computable',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(541,NULL,1,131,NULL,8,'Entretenimiento',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(542,NULL,1,132,NULL,6,'Amortización Bienes de Uso',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(543,NULL,1,135,NULL,6,'Gastos varios',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(544,NULL,1,136,NULL,6,'Ajuste por redondeo',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(545,NULL,1,137,NULL,6,'Deudores Incobrables',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(546,NULL,1,141,NULL,6,'Intereses Proveedores',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(547,NULL,1,143,NULL,6,'Diferencias de cambio',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(548,NULL,1,144,NULL,8,'Diferencia de Cambio Bces. en M.Extranjera',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(549,NULL,1,145,NULL,6,'Diferencia tipo cambio Vendedor/Comprador',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(550,NULL,1,146,NULL,8,'Diferencia por conversion en Bce. en Mon. Extranj.',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(551,NULL,1,147,NULL,8,'Diferencia de cambio CMV',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(552,NULL,1,148,NULL,8,'Diferencia de cambio PT',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(553,NULL,1,149,NULL,8,'Resultado por Exposición a la Inflación',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(554,NULL,1,150,NULL,8,'Diferencia de cambio PE',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(555,NULL,1,151,NULL,8,'Diferencia de cambio Ds.Vtas.',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (556,NULL,1,152,NULL,6,'Diferencia de cambio ME',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(557,NULL,1,153,NULL,6,'Descuentos otorgados',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(558,NULL,1,155,NULL,6,'Impuesto a las Ganancias',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(559,NULL,1,156,NULL,6,'Impuesto a los Ingresos Brutos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(560,NULL,1,157,NULL,8,'Impuesto al Debito y Credito Bancario',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(561,NULL,1,159,NULL,6,'Pérdida por venta bienes de uso',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(562,NULL,1,160,NULL,6,'Inversiones',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(563,NULL,1,161,NULL,6,'Amortizaciones extraordinarias',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(564,NULL,1,178,NULL,8,'Google',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(565,NULL,1,188,NULL,6,'Publicidad',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(566,NULL,1,191,NULL,6,'Cargas Sociales',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(567,NULL,1,192,NULL,6,'Honorarios',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(568,NULL,1,193,NULL,6,'Telefono Fijo',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(569,NULL,1,198,NULL,6,'Seguros',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(570,NULL,1,199,NULL,6,'Internet',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(571,NULL,1,204,NULL,6,'Multas Impositivas',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(572,NULL,1,208,NULL,6,'Impuesto a los Ingresos Brutos - BS AS',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(573,NULL,1,209,NULL,8,'SIRCREB',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(574,NULL,1,212,NULL,6,'Tarjeta Visa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(575,NULL,1,213,NULL,6,'Tarjeta American Express',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(576,NULL,1,214,NULL,6,'Tarjeta Mastercard',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(577,NULL,1,215,NULL,8,'Tarjeta Shopping',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(578,NULL,1,216,NULL,6,'Tarjeta Cencosud',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(579,NULL,1,217,NULL,6,'Compras',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(580,NULL,1,218,NULL,7,'Ventas No Gravadas',0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(581,NULL,1,220,NULL,5,'Perc IVA -RG3337',0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:55:26',NULL),(582,NULL,1,221,NULL,6,'Imps. Internos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(583,NULL,1,222,NULL,6,'Imp. Gasoil',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(584,NULL,1,223,NULL,6,'Imp. Hídricos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(585,NULL,1,224,NULL,6,'ITC',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(586,NULL,1,225,NULL,5,'Perc IIBB  Buenos Aires',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(587,NULL,1,226,NULL,5,'Perc IIBB  Capital Federal',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(588,NULL,1,227,NULL,5,'Perc IIBB  Catamarca',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(589,NULL,1,228,NULL,5,'Perc IIBB  Chaco',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(590,NULL,1,229,NULL,5,'Perc IIBB  Chubut',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(591,NULL,1,230,NULL,5,'Perc IIBB  Córdoba',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(592,NULL,1,231,NULL,5,'Perc IIBB  Corrientes',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (593,NULL,1,232,NULL,5,'Perc IIBB  Entre Ríos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(594,NULL,1,233,NULL,5,'Perc IIBB  Formosa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(595,NULL,1,234,NULL,5,'Perc IIBB  Jujuy',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(596,NULL,1,235,NULL,5,'Perc IIBB  La Pampa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(597,NULL,1,236,NULL,5,'Perc IIBB  La Rioja',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(598,NULL,1,237,NULL,5,'Perc IIBB  Mendoza',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(599,NULL,1,238,NULL,5,'Perc IIBB  Misiones',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(600,NULL,1,239,NULL,5,'Perc IIBB  Neuquén',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(601,NULL,1,240,NULL,5,'Perc IIBB  Pascua Lama',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(602,NULL,1,241,NULL,5,'Perc IIBB  Río Negro',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(603,NULL,1,242,NULL,5,'Perc IIBB  Salta',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(604,NULL,1,243,NULL,5,'Perc IIBB  San Juan',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(605,NULL,1,244,NULL,5,'Perc IIBB  San Luis',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(606,NULL,1,245,NULL,5,'Perc IIBB  Santa Cruz',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(607,NULL,1,246,NULL,5,'Perc IIBB  Santa Fe',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(608,NULL,1,247,NULL,5,'Perc IIBB  Santiago del Estero',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(609,NULL,1,248,NULL,5,'Perc IIBB  Tierra del Fuego',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(610,NULL,1,249,NULL,5,'Perc IIBB  Tucuman',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(611,NULL,1,250,NULL,6,'Compras No Gravadas',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(612,NULL,1,276,NULL,6,'SIRCREB Buenos Aires',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(613,NULL,1,277,NULL,6,'SIRCREB Capital Federal',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(614,NULL,1,278,NULL,6,'SIRCREB Catamarca',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(615,NULL,1,279,NULL,6,'SIRCREB Chaco',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(616,NULL,1,280,NULL,6,'SIRCREB Chubut',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(617,NULL,1,281,NULL,6,'SIRCREB Córdoba',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(618,NULL,1,282,NULL,6,'SIRCREB Corrientes',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(619,NULL,1,283,NULL,6,'SIRCREB Entre Ríos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(620,NULL,1,284,NULL,6,'SIRCREB Formosa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(621,NULL,1,285,NULL,6,'SIRCREB Jujuy',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(622,NULL,1,286,NULL,6,'SIRCREB La Pampa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(623,NULL,1,287,NULL,6,'SIRCREB La Rioja',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(624,NULL,1,288,NULL,6,'SIRCREB Mendoza',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(625,NULL,1,289,NULL,6,'SIRCREB Misiones',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(626,NULL,1,290,NULL,6,'SIRCREB Neuquén',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(627,NULL,1,291,NULL,6,'SIRCREB Pascua Lama',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(628,NULL,1,292,NULL,6,'SIRCREB Río Negro',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (629,NULL,1,293,NULL,6,'SIRCREB Salta',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(630,NULL,1,294,NULL,6,'SIRCREB San Juan',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(631,NULL,1,295,NULL,6,'SIRCREB San Luis',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(632,NULL,1,296,NULL,6,'SIRCREB Santa Cruz',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(633,NULL,1,297,NULL,6,'SIRCREB Santa Fe',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(634,NULL,1,298,NULL,6,'SIRCREB Santiago del Estero',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(635,NULL,1,299,NULL,6,'SIRCREB Tierra del Fuego',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(636,NULL,1,300,NULL,6,'SIRCREB Tucuman',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(637,NULL,1,301,NULL,8,'IIBB a Favor Buenos Aires',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(638,NULL,1,302,NULL,8,'IIBB a Favor Capital Federal',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(639,NULL,1,303,NULL,8,'IIBB a Favor Catamarca',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(640,NULL,1,304,NULL,8,'IIBB a Favor Chaco',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(641,NULL,1,305,NULL,8,'IIBB a Favor Chubut',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(642,NULL,1,306,NULL,8,'IIBB a Favor Córdoba',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(643,NULL,1,307,NULL,8,'IIBB a Favor Corrientes',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(644,NULL,1,308,NULL,8,'IIBB a Favor Entre Ríos',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(645,NULL,1,309,NULL,8,'IIBB a Favor Formosa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(646,NULL,1,310,NULL,8,'IIBB a Favor Jujuy',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(647,NULL,1,311,NULL,8,'IIBB a Favor La Pampa',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(648,NULL,1,312,NULL,8,'IIBB a Favor La Rioja',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(649,NULL,1,313,NULL,8,'IIBB a Favor Mendoza',0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:14:29',NULL),(650,NULL,1,314,NULL,8,'IIBB a Favor Misiones',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(651,NULL,1,315,NULL,8,'IIBB a Favor Neuquén',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(652,NULL,1,316,NULL,8,'IIBB a Favor Pascua Lama',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(653,NULL,1,317,NULL,8,'IIBB a Favor Río Negro',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(654,NULL,1,318,NULL,8,'IIBB a Favor Salta',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(655,NULL,1,319,NULL,8,'IIBB a Favor San Juan',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(656,NULL,1,320,NULL,8,'IIBB a Favor San Luis',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(657,NULL,1,321,NULL,8,'IIBB a Favor Santa Cruz',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(658,NULL,1,322,NULL,8,'IIBB a Favor Santa Fe',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(659,NULL,1,323,NULL,8,'IIBB a Favor Santiago del Estero',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(660,NULL,1,324,NULL,8,'IIBB a Favor Tierra del Fuego',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(661,NULL,1,325,NULL,8,'IIBB a Favor Tucuman',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(662,NULL,1,326,NULL,8,'IIBB a Pagar Buenos Aires',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(663,NULL,1,327,NULL,8,'IIBB a Pagar Capital Federal',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (664,NULL,1,328,NULL,8,'IIBB a Pagar Catamarca',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(665,NULL,1,329,NULL,8,'IIBB a Pagar Chaco',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(666,NULL,1,330,NULL,8,'IIBB a Pagar Chubut',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(667,NULL,1,331,NULL,8,'IIBB a Pagar Córdoba',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(668,NULL,1,332,NULL,8,'IIBB a Pagar Corrientes',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(669,NULL,1,333,NULL,8,'IIBB a Pagar Entre Ríos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(670,NULL,1,334,NULL,8,'IIBB a Pagar Formosa',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(671,NULL,1,335,NULL,8,'IIBB a Pagar Jujuy',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(672,NULL,1,336,NULL,8,'IIBB a Pagar La Pampa',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(673,NULL,1,337,NULL,8,'IIBB a Pagar La Rioja',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(674,NULL,1,338,NULL,8,'IIBB a Pagar Mendoza',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(675,NULL,1,339,NULL,8,'IIBB a Pagar Misiones',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(676,NULL,1,340,NULL,8,'IIBB a Pagar Neuquén',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(677,NULL,1,341,NULL,8,'IIBB a Pagar Pascua Lama',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(678,NULL,1,342,NULL,8,'IIBB a Pagar Río Negro',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(679,NULL,1,343,NULL,8,'IIBB a Pagar Salta',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(680,NULL,1,344,NULL,8,'IIBB a Pagar San Juan',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(681,NULL,1,345,NULL,8,'IIBB a Pagar San Luis',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(682,NULL,1,346,NULL,8,'IIBB a Pagar Santa Cruz',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(683,NULL,1,347,NULL,8,'IIBB a Pagar Santa Fe',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(684,NULL,1,348,NULL,8,'IIBB a Pagar Santiago del Estero',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(685,NULL,1,349,NULL,8,'IIBB a Pagar Tierra del Fuego',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(686,NULL,1,350,NULL,8,'IIBB a Pagar Tucuman',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(687,NULL,1,352,NULL,8,'Compensacion',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(688,NULL,1,353,NULL,8,'IVA Saldo Tecnico',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(689,NULL,1,354,NULL,8,'IVA Saldo Libre Disponibilidad',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(690,NULL,1,361,NULL,8,'Equipos de Computación',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(691,NULL,1,362,NULL,8,'Computadoras',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(692,NULL,1,363,NULL,8,'Muebles y Utiles',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(693,NULL,1,365,NULL,8,'Provision Honorarios',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(694,NULL,1,366,NULL,8,'Cta. Cte Directores',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(695,NULL,1,367,NULL,8,'Provisión Honorarios Directores',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(696,NULL,1,368,NULL,8,'Cuenta Particular Socio 1',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(697,NULL,1,369,NULL,8,'Capital',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(698,NULL,1,380,NULL,8,'Instalaciones',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(699,NULL,1,381,NULL,8,'Reserva Legal',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (700,NULL,1,382,NULL,8,'Reserva Legal',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(701,NULL,1,383,NULL,8,'Resultado no asignado',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(702,NULL,1,386,NULL,8,'PLAZO FIJO',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(703,NULL,1,388,NULL,8,'ACCIONES',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(704,NULL,1,389,NULL,8,'Inmuebles',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(705,NULL,1,390,NULL,8,'Vehiculos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(706,NULL,1,391,NULL,8,'Maquinarias',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(707,NULL,1,392,NULL,8,'MERCADERIAS',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(708,NULL,1,393,NULL,8,'OTROS',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(709,NULL,1,395,NULL,8,'Cuenta Particular Socio 2',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(710,NULL,1,396,NULL,6,'Comisiones Y gastos Bancarios',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(711,NULL,1,411,NULL,8,'Provisión Impuesto a las Ganancias',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(712,NULL,1,412,NULL,6,'Amortización Muebles y Útiles',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(713,NULL,1,413,NULL,6,'Amortización Equipos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(714,NULL,1,414,NULL,8,'Amortizacion Acumulada Equipos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(715,NULL,1,415,NULL,8,'Amortización Acumulada Maquinarias',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(716,NULL,1,416,NULL,8,'Materias Primas',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(717,NULL,1,419,NULL,8,'Rodados',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(718,NULL,1,420,NULL,8,'Amortización Acumulada Rodados',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(719,NULL,1,421,NULL,8,'Amortización Rodados',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(720,NULL,1,422,NULL,8,'Amortización Maquinarias',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(721,NULL,1,423,NULL,8,'Accesorios',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(722,NULL,1,424,NULL,8,'Amortización Acumulada Accesorios',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(723,NULL,1,426,NULL,8,'Reserva Facultativa',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(724,NULL,1,427,NULL,8,'Créditos por Impuestos Diferidos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(725,NULL,1,428,NULL,8,'Fondo de Comercio',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(726,NULL,1,429,NULL,8,'Amortizacion Acumulada Fondo de Comercio',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(727,NULL,1,430,NULL,8,'Intereses a devengar AGIP',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(728,NULL,1,431,NULL,8,'PFP IIBB',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(729,NULL,1,434,NULL,8,'Productos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(730,NULL,1,435,NULL,8,'Intereses a devengar PFP',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(731,NULL,1,437,NULL,8,'Imp. Ley 25413 Cred 0.6%',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(732,NULL,1,438,NULL,8,'Honorarios Directorio a Pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(733,NULL,1,439,NULL,8,'Reserva para Futuras Inversiones',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:29',NULL),(734,NULL,1,440,NULL,8,'TEAC - Trabajos Ejecutados a Certificar',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (735,NULL,1,444,NULL,8,'Banco Santander Rio Cta Cte',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(736,NULL,1,449,NULL,8,'Leasing',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(737,NULL,1,453,NULL,8,'Inversión Central Caribe',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(738,NULL,1,454,NULL,8,'Otras Inversiones',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(739,NULL,1,455,NULL,8,'Otros Créditos',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(740,NULL,1,456,NULL,8,'Provisión Honorarios Socio Gerente',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(741,NULL,1,459,NULL,8,'Moratoria SUSS a pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(742,NULL,1,460,NULL,8,'Impuestos Municipales a Pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(743,NULL,1,461,NULL,6,'Amortización Instalaciones',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(744,NULL,1,462,NULL,8,'Amortización Equipos de comput.',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(745,NULL,1,463,NULL,8,'Cuenta Particular Socio 3',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(746,NULL,1,464,NULL,8,'Cuenta Particular Socio 4',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(747,NULL,1,465,NULL,8,'Otras Reservas',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(748,NULL,1,466,NULL,8,'IGMP (Saldo a Favor)',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(749,NULL,1,468,NULL,8,'Productos en Proceso',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(750,NULL,1,469,NULL,8,'Depósitos en Garantía Socio Gerente',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(751,NULL,1,470,NULL,8,'Fondos Embargados',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(752,NULL,1,471,NULL,8,'Cuota Solid.',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(753,NULL,1,472,NULL,8,'Anticipo Honorarios Directores',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(754,NULL,1,473,NULL,8,'SICORE a Pagar',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(755,NULL,1,476,NULL,6,'RECPAM',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL),(756,NULL,1,478,NULL,6,'CO2 - Imp. Al Carbono',0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:14:30',NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_detail`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `is_conciliado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_detail_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_detail_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_detail`
--

LOCK TABLES `cta_cte_tesoreria_detail` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos`
--

DROP TABLE IF EXISTS `ctacte_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigoBCRA` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos`
--

LOCK TABLES `ctacte_bancos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos` DISABLE KEYS */;
INSERT INTO `ctacte_bancos` VALUES (1,NULL,'BANCO DE GALICIA Y BUENOS AIRES S.A.',7,NULL,NULL,NULL),(2,NULL,'BANCO DE LA NACION ARGENTINA',11,NULL,NULL,NULL),(3,NULL,'BANCO DE LA PROVINCIA DE BUENOS AIRES',14,NULL,NULL,NULL),(4,NULL,'INDUSTRIAL AND COMMERCIAL BANK OF CHINA',15,NULL,NULL,NULL),(5,NULL,'CITIBANK N.A.',16,NULL,NULL,NULL),(6,NULL,'BBVA BANCO FRANCES S.A.',17,NULL,NULL,NULL),(7,NULL,'THE BANK OF TOKYO-MITSUBISHI UFJ, LTD.',18,NULL,NULL,NULL),(8,NULL,'BANCO DE LA PROVINCIA DE CORDOBA S.A.',20,NULL,NULL,NULL),(9,NULL,'BANCO SUPERVIELLE S.A.',27,NULL,NULL,NULL),(10,NULL,'BANCO DE LA CIUDAD DE BUENOS AIRES',29,NULL,NULL,NULL),(11,NULL,'BANCO PATAGONIA S.A.',34,NULL,NULL,NULL),(12,NULL,'BANCO HIPOTECARIO S.A.',44,NULL,NULL,NULL),(13,NULL,'BANCO DE SAN JUAN S.A.',45,NULL,NULL,NULL),(14,NULL,'BANCO DEL TUCUMAN S.A.',60,NULL,NULL,NULL),(15,NULL,'BANCO MUNICIPAL DE ROSARIO',65,NULL,NULL,NULL),(16,NULL,'BANCO SANTANDER RIO S.A.',72,NULL,NULL,NULL),(17,NULL,'BANCO DEL CHUBUT S.A.',83,NULL,NULL,NULL),(18,NULL,'BANCO DE SANTA CRUZ S.A.',86,NULL,NULL,NULL),(19,NULL,'BANCO DE LA PAMPA SOCIEDAD DE ECONOMÍA M',93,NULL,NULL,NULL),(20,NULL,'BANCO DE CORRIENTES S.A.',94,NULL,NULL,NULL),(21,NULL,'BANCO PROVINCIA DEL NEUQUÉN SOCIEDAD ANÓ',97,NULL,NULL,NULL),(22,NULL,'BANCO INTERFINANZAS S.A.',147,NULL,NULL,NULL),(23,NULL,'HSBC BANK ARGENTINA S.A.',150,NULL,NULL,NULL),(24,NULL,'JPMORGAN CHASE BANK, NATIONAL ASSOCIATIO',165,NULL,NULL,NULL),(25,NULL,'BANCO CREDICOOP COOPERATIVO LIMITADO',191,NULL,NULL,NULL),(26,NULL,'BANCO DE VALORES S.A.',198,NULL,NULL,NULL),(27,NULL,'BANCO ROELA S.A.',247,NULL,NULL,NULL),(28,NULL,'BANCO MARIVA S.A.',254,NULL,NULL,NULL),(29,NULL,'BANCO ITAU ARGENTINA S.A.',259,NULL,NULL,NULL),(30,NULL,'BANK OF AMERICA, NATIONAL ASSOCIATION',262,NULL,NULL,NULL),(31,NULL,'BNP PARIBAS',266,NULL,NULL,NULL),(32,NULL,'BANCO PROVINCIA DE TIERRA DEL FUEGO',268,NULL,NULL,NULL),(33,NULL,'BANCO DE LA REPUBLICA ORIENTAL DEL URUGU',269,NULL,NULL,NULL),(34,NULL,'BANCO SAENZ S.A.',277,NULL,NULL,NULL),(35,NULL,'BANCO MERIDIAN S.A.',281,NULL,NULL,NULL),(36,NULL,'BANCO MACRO S.A.',285,NULL,NULL,NULL),(37,NULL,'BANCO COMAFI SOCIEDAD ANONIMA',299,NULL,NULL,NULL),(38,NULL,'BANCO DE INVERSION Y COMERCIO EXTERIOR S',300,NULL,NULL,NULL),(39,NULL,'BANCO PIANO S.A.',301,NULL,NULL,NULL),(40,NULL,'BANCO JULIO SOCIEDAD ANONIMA',305,NULL,NULL,NULL),(41,NULL,'BANCO RIOJA SOCIEDAD ANONIMA UNIPERSONAL',309,NULL,NULL,NULL),(42,NULL,'BANCO DEL SOL S.A.',310,NULL,NULL,NULL),(43,NULL,'NUEVO BANCO DEL CHACO S. A.',311,NULL,NULL,NULL),(44,NULL,'BANCO VOII S.A.',312,NULL,NULL,NULL),(45,NULL,'BANCO DE FORMOSA S.A.',315,NULL,NULL,NULL),(46,NULL,'BANCO CMF S.A.',319,NULL,NULL,NULL),(47,NULL,'BANCO DE SANTIAGO DEL ESTERO S.A.',321,NULL,NULL,NULL),(48,NULL,'BANCO INDUSTRIAL S.A.',322,NULL,NULL,NULL),(49,NULL,'NUEVO BANCO DE SANTA FE SOCIEDAD ANONIMA',330,NULL,NULL,NULL),(50,NULL,'BANCO CETELEM ARGENTINA S.A.',331,NULL,NULL,NULL),(51,NULL,'BANCO DE SERVICIOS FINANCIEROS S.A.',332,NULL,NULL,NULL),(52,NULL,'BANCO BRADESCO ARGENTINA S.A.U.',336,NULL,NULL,NULL),(53,NULL,'BANCO DE SERVICIOS Y TRANSACCIONES S.A.',338,NULL,NULL,NULL),(54,NULL,'RCI BANQUE S.A.',339,NULL,NULL,NULL),(55,NULL,'BACS BANCO DE CREDITO Y SECURITIZACION S',340,NULL,NULL,NULL),(56,NULL,'BANCO MASVENTAS S.A.',341,NULL,NULL,NULL),(57,NULL,'BANCO WANAP S.A.',384,NULL,NULL,NULL),(58,NULL,'NUEVO BANCO DE ENTRE RÍOS S.A.',386,NULL,NULL,NULL),(59,NULL,'BANCO COLUMBIA S.A.',389,NULL,NULL,NULL),(60,NULL,'BANCO BICA S.A.',426,NULL,NULL,NULL),(61,NULL,'BANCO COINAG S.A.',431,NULL,NULL,NULL),(62,NULL,'BANCO DE COMERCIO S.A.',432,NULL,NULL,NULL),(63,NULL,'FORD CREDIT COMPAÑIA FINANCIERA S.A.',44059,NULL,NULL,NULL),(64,NULL,'COMPAÑIA FINANCIERA ARGENTINA S.A.',44077,NULL,NULL,NULL),(65,NULL,'VOLKWAGEN FINANCIAL SERVICES CIA.FIN.S.A',44088,NULL,NULL,NULL),(66,NULL,'CORDIAL COMPAÑÍA FINANCIERA S.A.',44090,NULL,NULL,NULL),(67,NULL,'FCA COMPAÑIA FINANCIERA S.A.',44092,NULL,NULL,NULL);
INSERT INTO `ctacte_bancos` VALUES (68,NULL,'GPAT COMPAÑIA FINANCIERA S.A.',44093,NULL,NULL,NULL),(69,NULL,'MERCEDES-BENZ COMPAÑÍA FINANCIERA ARGENT',44094,NULL,NULL,NULL),(70,NULL,'ROMBO COMPAÑÍA FINANCIERA S.A.',44095,NULL,NULL,NULL),(71,NULL,'JOHN DEERE CREDIT COMPAÑÍA FINANCIERA S.',44096,NULL,NULL,NULL),(72,NULL,'PSA FINANCE ARGENTINA COMPAÑÍA FINANCIER',44098,NULL,NULL,NULL),(73,NULL,'TOYOTA COMPAÑÍA FINANCIERA DE ARGENTINA',44099,NULL,NULL,NULL),(74,NULL,'FINANDINO COMPAÑIA FINANCIERA S.A.',44100,NULL,NULL,NULL),(75,NULL,'MONTEMAR COMPAÑIA FINANCIERA S.A.',45056,NULL,NULL,NULL),(76,NULL,'MULTIFINANZAS COMPAÑIA FINANCIERA S.A.',45072,NULL,NULL,NULL),(77,NULL,'CAJA DE CREDITO \"CUENCA\" COOPERATIVA LIM',65203,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctacte_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos_datos`
--

DROP TABLE IF EXISTS `ctacte_bancos_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos_datos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `num_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cbu` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_bancos_datos_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  CONSTRAINT `ctacte_bancos_datos_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos_datos`
--

LOCK TABLES `ctacte_bancos_datos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_bancos_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_cheques`
--

DROP TABLE IF EXISTS `ctacte_cheques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_cheques` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `asiento_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) DEFAULT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_cobro` date DEFAULT NULL,
  `banco_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cuit` text COLLATE utf8mb4_unicode_ci,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abierto_cruzado` int(11) NOT NULL DEFAULT '1',
  `is_no_a_la_orden` tinyint(1) NOT NULL DEFAULT '0',
  `numero` int(10) unsigned DEFAULT NULL,
  `foto` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_cheques_asiento_id_foreign` (`asiento_id`),
  KEY `ctacte_cheques_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  KEY `ctacte_cheques_banco_id_foreign` (`banco_id`),
  KEY `ctacte_cheques_person_id_foreign` (`person_id`),
  KEY `ctacte_cheques_cta_cte_cliente_id2_foreign` (`cta_cte_cliente_id2`),
  KEY `ctacte_cheques_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesorer_id` (`cta_cte_tesoreria_id`),
  KEY `ctacte_cheques_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `ctacte_cheques_nf_cta_cte_id2_foreign` (`nf_cta_cte_id2`),
  KEY `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_tesorer_id` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `ctacte_cheques_banco_id_foreign` FOREIGN KEY (`banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id2_foreign` FOREIGN KEY (`cta_cte_cliente_id2`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctacte_cheques_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id2_foreign` FOREIGN KEY (`nf_cta_cte_id2`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_cheques`
--

LOCK TABLES `ctacte_cheques` WRITE;
/*!40000 ALTER TABLE `ctacte_cheques` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_cheques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_centrocosto`
--

DROP TABLE IF EXISTS `ctactegastos_centrocosto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_centrocosto` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_centrocosto`
--

LOCK TABLES `ctactegastos_centrocosto` WRITE;
/*!40000 ALTER TABLE `ctactegastos_centrocosto` DISABLE KEYS */;
INSERT INTO `ctactegastos_centrocosto` VALUES (1,NULL,'OFICINA',NULL,NULL,NULL),(2,NULL,'FIJO',NULL,NULL,NULL),(3,NULL,'VARIABLE',NULL,NULL,NULL),(4,NULL,'GISELA',NULL,NULL,NULL),(5,NULL,'LIA',NULL,NULL,NULL),(6,NULL,'PADRES',NULL,NULL,NULL),(7,NULL,'CASA',NULL,NULL,NULL),(8,NULL,'VANESA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_centrocosto` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_cuenta_tipo`
--

DROP TABLE IF EXISTS `ctactegastos_cuenta_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_cuenta_tipo` (
  `idCuentaTipo` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `idTipo` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`idCuentaTipo`),
  KEY `ctactegastos_cuenta_tipo_idtipo_foreign` (`idTipo`),
  KEY `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_idtipo_foreign` FOREIGN KEY (`idTipo`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_cuenta_tipo`
--

LOCK TABLES `ctactegastos_cuenta_tipo` WRITE;
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` DISABLE KEYS */;
INSERT INTO `ctactegastos_cuenta_tipo` VALUES (1,NULL,NULL,3,NULL,NULL,NULL),(2,NULL,NULL,6,NULL,NULL,NULL),(3,NULL,NULL,3,NULL,NULL,NULL),(4,NULL,NULL,4,NULL,NULL,NULL),(5,NULL,NULL,5,NULL,NULL,NULL),(6,NULL,NULL,3,NULL,NULL,NULL),(7,NULL,NULL,4,NULL,NULL,NULL),(8,NULL,NULL,3,NULL,NULL,NULL),(9,NULL,NULL,4,NULL,NULL,NULL),(10,NULL,NULL,7,NULL,NULL,NULL),(11,NULL,NULL,8,NULL,NULL,NULL),(12,NULL,NULL,3,NULL,NULL,NULL),(13,NULL,NULL,3,NULL,NULL,NULL),(14,NULL,NULL,4,NULL,NULL,NULL),(15,NULL,NULL,1,NULL,NULL,NULL),(16,NULL,NULL,2,NULL,NULL,NULL),(17,NULL,NULL,5,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_mensuales`
--

DROP TABLE IF EXISTS `ctactegastos_mensuales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_mensuales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `CuentaTipo_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `TipoDeGasto_id` int(10) unsigned NOT NULL,
  `CentroCosto_id` int(10) unsigned NOT NULL,
  `gasto_cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `monto` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctactegastos_mensuales_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `ctactegastos_mensuales_tipodegasto_id_foreign` (`TipoDeGasto_id`),
  KEY `ctactegastos_mensuales_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` (`gasto_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_mensuales_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`gasto_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_tipodegasto_id_foreign` FOREIGN KEY (`TipoDeGasto_id`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_mensuales`
--

LOCK TABLES `ctactegastos_mensuales` WRITE;
/*!40000 ALTER TABLE `ctactegastos_mensuales` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctactegastos_mensuales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_tiposdegastos`
--

DROP TABLE IF EXISTS `ctactegastos_tiposdegastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_tiposdegastos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_tiposdegastos`
--

LOCK TABLES `ctactegastos_tiposdegastos` WRITE;
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` DISABLE KEYS */;
INSERT INTO `ctactegastos_tiposdegastos` VALUES (1,NULL,'Oficina',NULL,NULL,NULL),(2,NULL,'Personales',NULL,NULL,NULL),(3,NULL,'Tarjeta VISA',NULL,NULL,NULL),(4,NULL,'Tarjeta Mastercard',NULL,NULL,NULL),(5,NULL,'Debito Automatico',NULL,NULL,NULL),(6,NULL,'American Express',NULL,NULL,NULL),(7,NULL,'Tarjeta Shopping',NULL,NULL,NULL),(8,NULL,'Tarjeta Cencosud',NULL,NULL,NULL),(9,NULL,'Tarjeta Coto',NULL,NULL,NULL),(10,NULL,'Tarjeta Nativa',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos`
--

DROP TABLE IF EXISTS `cursos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fecha` date DEFAULT NULL,
  `hora` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profesor` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cant_clases` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjuntos` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_zoom` longtext COLLATE utf8mb4_unicode_ci,
  `cod_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contraseña_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_youtube` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `materiales` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos`
--

LOCK TABLES `cursos` WRITE;
/*!40000 ALTER TABLE `cursos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos_detail`
--

DROP TABLE IF EXISTS `cursos_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `curso_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cursos_detail_curso_id_foreign` (`curso_id`),
  CONSTRAINT `cursos_detail_curso_id_foreign` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos_detail`
--

LOCK TABLES `cursos_detail` WRITE;
/*!40000 ALTER TABLE `cursos_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `data_types`
--

DROP TABLE IF EXISTS `data_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `data_types_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `data_types`
--

LOCK TABLES `data_types` WRITE;
/*!40000 ALTER TABLE `data_types` DISABLE KEYS */;
INSERT INTO `data_types` VALUES (1,'Comprobantes XLS',1,'Importación','XLS','data/imports/receipts/xls',NULL,NULL),(2,'CITI-Ventas',1,'Importación','TXT','data/imports/receipts/CitiVentas',NULL,NULL),(3,'CITI Compras',2,'Exportación','TXT','data/exports/receipts/citi',NULL,NULL),(4,'CITI Ventas',2,'Exportación','TXT','data/exports/receipts/CitiVentasExport',NULL,NULL),(5,'Convenio Multilateral',2,'Exportación','TXT','data/exports/receipts/convenio',NULL,NULL),(6,'Libro IVA Digital',2,'Exportación','TXT','data/exports/receipts/libro_iva_digital',NULL,'2019-11-20 21:43:44'),(7,'Mis Comprobantes',1,'Importacion','','data/imports/receipts/mis_comprobantes',NULL,NULL),(8,'Consulta AFIP',3,'AFIP','','data/afip/index','2019-12-06 14:49:55','2019-12-06 14:49:55');
/*!40000 ALTER TABLE `data_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_estados`
--

DROP TABLE IF EXISTS `dc_estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_estados` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_estados`
--

LOCK TABLES `dc_estados` WRITE;
/*!40000 ALTER TABLE `dc_estados` DISABLE KEYS */;
INSERT INTO `dc_estados` VALUES (1,NULL,'BORRADOR',1,NULL,'2023-08-06 23:59:35',NULL),(2,NULL,'TERMINADO',1,NULL,'2023-08-06 23:59:35',NULL),(3,NULL,'RECHAZADO',1,NULL,'2023-08-06 23:59:35','2023-08-06 23:59:35'),(4,NULL,'PAGADO',1,NULL,'2023-08-06 23:59:35','2023-08-06 23:59:35'),(5,NULL,'CONCILIADO',1,NULL,'2023-08-06 23:59:35','2023-08-06 23:59:35');
/*!40000 ALTER TABLE `dc_estados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas`
--

DROP TABLE IF EXISTS `dc_firmas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_firmante_dc` tinyint(1) NOT NULL DEFAULT '0',
  `show_create_dc` tinyint(1) NOT NULL DEFAULT '0',
  `faltan_firmas` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas`
--

LOCK TABLES `dc_firmas` WRITE;
/*!40000 ALTER TABLE `dc_firmas` DISABLE KEYS */;
INSERT INTO `dc_firmas` VALUES (1,NULL,'NO',1,1,0,1,NULL,'2023-08-06 23:59:35',NULL),(2,NULL,'RECHAZADO',1,1,0,1,NULL,'2023-08-06 23:59:35',NULL),(3,NULL,'ACEPTADO',1,0,0,1,NULL,'2023-08-06 23:59:35',NULL),(4,NULL,'FALTAN FIRMAS',0,0,1,1,'2023-08-06 23:59:35','2023-08-06 23:59:35',NULL);
/*!40000 ALTER TABLE `dc_firmas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas_ordenes`
--

DROP TABLE IF EXISTS `dc_firmas_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `user_id_que_firma` int(10) unsigned NOT NULL,
  `dc_firma_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_firmas_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_firmas_ordenes_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_firmas_ordenes_dc_firma_id_foreign` (`dc_firma_id`),
  CONSTRAINT `dc_firmas_ordenes_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_firmas_ordenes_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_firmas_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas_ordenes`
--

LOCK TABLES `dc_firmas_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_firmas_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_firmas_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas_reglas`
--

DROP TABLE IF EXISTS `dc_firmas_reglas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas_reglas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL,
  `grupos_users_ids` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_firmas_reglas_person_id_foreign` (`person_id`),
  KEY `dc_firmas_reglas_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_firmas_reglas_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_firmas_reglas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas_reglas`
--

LOCK TABLES `dc_firmas_reglas` WRITE;
/*!40000 ALTER TABLE `dc_firmas_reglas` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_firmas_reglas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_files`
--

DROP TABLE IF EXISTS `dc_orden_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `file` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_files_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_orden_files_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_files`
--

LOCK TABLES `dc_orden_files` WRITE;
/*!40000 ALTER TABLE `dc_orden_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes`
--

DROP TABLE IF EXISTS `dc_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_tipo_id` bigint(20) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `titulo` text COLLATE utf8mb4_unicode_ci,
  `numero` int(11) NOT NULL,
  `sector` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `solicitante` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha` date NOT NULL,
  `fecha_entrega` date DEFAULT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(16,2) NOT NULL DEFAULT '1.00',
  `neto` decimal(16,2) NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dc_estado_id` bigint(20) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_cc_id` bigint(20) unsigned DEFAULT NULL,
  `origendestinoable_type` text COLLATE utf8mb4_unicode_ci,
  `origendestinoable_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_origen_destino_id` bigint(20) unsigned DEFAULT NULL,
  `is_completado` tinyint(1) NOT NULL DEFAULT '0',
  `dc_firma_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_dc_orden_tipo_id_foreign` (`dc_orden_tipo_id`),
  KEY `dc_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_ordenes_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `dc_ordenes_dc_estado_id_foreign` (`dc_estado_id`),
  KEY `dc_ordenes_conta_cc_id_foreign` (`conta_cc_id`),
  KEY `dc_ordenes_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `dc_ordenes_dc_orden_origen_destino_id_foreign` (`dc_orden_origen_destino_id`),
  KEY `dc_ordenes_moneda_id_foreign` (`moneda_id`),
  KEY `dc_ordenes_dc_firma_id_foreign` (`dc_firma_id`),
  CONSTRAINT `dc_ordenes_conta_cc_id_foreign` FOREIGN KEY (`conta_cc_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `dc_ordenes_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `dc_ordenes_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_origen_destino_id_foreign` FOREIGN KEY (`dc_orden_origen_destino_id`) REFERENCES `dc_ordenes_origen_destino` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_tipo_id_foreign` FOREIGN KEY (`dc_orden_tipo_id`) REFERENCES `dc_ordenes_tipos` (`id`),
  CONSTRAINT `dc_ordenes_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `dc_ordenes_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `dc_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes`
--

LOCK TABLES `dc_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_compra_req`
--

DROP TABLE IF EXISTS `dc_ordenes_compra_req`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_compra_req` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_compra_req_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_compra_req_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_compra_req_dc_orden_req_id_foreign` (`dc_orden_req_id`),
  KEY `dc_ordenes_compra_req_dc_orden_req_detail_id_foreign` (`dc_orden_req_detail_id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_req_detail_id_foreign` FOREIGN KEY (`dc_orden_req_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_req_id_foreign` FOREIGN KEY (`dc_orden_req_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_compra_req`
--

LOCK TABLES `dc_ordenes_compra_req` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_compra_req` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_compra_req` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_details`
--

DROP TABLE IF EXISTS `dc_ordenes_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id_destino` bigint(20) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `neto` decimal(16,2) NOT NULL,
  `desc_porc` decimal(16,2) DEFAULT NULL,
  `descuento` decimal(16,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `subtotal` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_details_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_details_inv_producto_id_foreign` (`inv_producto_id`),
  KEY `dc_ordenes_details_system_tax_id_foreign` (`system_tax_id`),
  KEY `dc_ordenes_details_inv_producto_id_destino_foreign` (`inv_producto_id_destino`),
  CONSTRAINT `dc_ordenes_details_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_producto_id_destino_foreign` FOREIGN KEY (`inv_producto_id_destino`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `dc_ordenes_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_details`
--

LOCK TABLES `dc_ordenes_details` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_facturada`
--

DROP TABLE IF EXISTS `dc_ordenes_facturada`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_facturada` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_facturada_person_id_foreign` (`person_id`),
  KEY `dc_ordenes_facturada_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_facturada_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  CONSTRAINT `dc_ordenes_facturada_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_facturada_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `dc_ordenes_facturada_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_facturada`
--

LOCK TABLES `dc_ordenes_facturada` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_facturada` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_facturada` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_ingreso_compra`
--

DROP TABLE IF EXISTS `dc_ordenes_ingreso_compra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_ingreso_compra` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_compra_id_foreign` (`dc_orden_compra_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_compra_detail_id_foreign` (`dc_orden_compra_detail_id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_compra_detail_id_foreign` FOREIGN KEY (`dc_orden_compra_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_compra_id_foreign` FOREIGN KEY (`dc_orden_compra_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_ingreso_compra`
--

LOCK TABLES `dc_ordenes_ingreso_compra` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_ingreso_compra` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_ingreso_compra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_origen_destino`
--

DROP TABLE IF EXISTS `dc_ordenes_origen_destino`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_origen_destino` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `modelo` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_origen_destino`
--

LOCK TABLES `dc_ordenes_origen_destino` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_origen_destino` DISABLE KEYS */;
INSERT INTO `dc_ordenes_origen_destino` VALUES (1,NULL,'Orden de Trabajo','App\\Models\\Inventario\\InvOrdenTrabajo',1,NULL,NULL,NULL),(2,NULL,'Tipos de Gastos','App\\Models\\Inventario\\InvOrdenTrabajoGastosTipo',1,NULL,NULL,NULL),(3,NULL,'Deposito','App\\Models\\Inventario\\InvDeposito',0,NULL,'2023-07-03 22:10:16',NULL),(4,NULL,'Empleado','App\\Models\\SyJEmpleado',0,NULL,'2023-07-03 22:10:16',NULL);
/*!40000 ALTER TABLE `dc_ordenes_origen_destino` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_tipos`
--

DROP TABLE IF EXISTS `dc_ordenes_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `usabilidad` longtext COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_tipos`
--

LOCK TABLES `dc_ordenes_tipos` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_tipos` DISABLE KEYS */;
INSERT INTO `dc_ordenes_tipos` VALUES (1,NULL,'ORDEN DE COMPRAS',NULL,1,NULL,'2022-10-11 09:37:27',NULL),(2,NULL,'ORDEN DE VENTAS',NULL,1,NULL,'2022-10-11 09:37:27',NULL),(3,NULL,'PRESUPUESTO',NULL,1,NULL,NULL,NULL),(4,NULL,'REQUERIMIENTO',NULL,1,NULL,NULL,NULL),(5,NULL,'REMITO DE INGRESO',NULL,1,NULL,'2023-06-12 23:28:56',NULL),(6,NULL,'REMITO DE EGRESO',NULL,1,NULL,NULL,NULL),(7,NULL,'REMITO INTERNO',NULL,1,NULL,NULL,NULL),(8,NULL,'REMITO DE INGRESO','Es lo mismo que un remito de ingreso, \n        pero los productosa ingresar provienen de una Orden de Compra',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_ordenes_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `deudas_impositivas`
--

DROP TABLE IF EXISTS `deudas_impositivas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `deudas_impositivas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `vto_impuesto_id` int(10) unsigned NOT NULL,
  `periodo_deuda` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `deudas_impositivas_vto_impuesto_id_foreign` (`vto_impuesto_id`),
  KEY `deudas_impositivas_person_id_foreign` (`person_id`),
  CONSTRAINT `deudas_impositivas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `deudas_impositivas_vto_impuesto_id_foreign` FOREIGN KEY (`vto_impuesto_id`) REFERENCES `vto_impuestos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `deudas_impositivas`
--

LOCK TABLES `deudas_impositivas` WRITE;
/*!40000 ALTER TABLE `deudas_impositivas` DISABLE KEYS */;
/*!40000 ALTER TABLE `deudas_impositivas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ejer_anteriores`
--

DROP TABLE IF EXISTS `ejer_anteriores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ejer_anteriores` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `anio` int(11) NOT NULL,
  `ventas` decimal(16,2) DEFAULT NULL,
  `compras` decimal(16,2) DEFAULT NULL,
  `sueldos` decimal(16,2) DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `apagar` decimal(16,2) DEFAULT NULL,
  `afavor` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ejer_anteriores_person_id_foreign` (`person_id`),
  CONSTRAINT `ejer_anteriores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ejer_anteriores`
--

LOCK TABLES `ejer_anteriores` WRITE;
/*!40000 ALTER TABLE `ejer_anteriores` DISABLE KEYS */;
/*!40000 ALTER TABLE `ejer_anteriores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estado_civil`
--

DROP TABLE IF EXISTS `estado_civil`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estado_civil` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `estado_civil_descripcion_unique` (`descripcion`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estado_civil`
--

LOCK TABLES `estado_civil` WRITE;
/*!40000 ALTER TABLE `estado_civil` DISABLE KEYS */;
INSERT INTO `estado_civil` VALUES (1,NULL,'Separado Legal',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(2,NULL,'Separado de Hecho',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(3,NULL,'Divorciado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(4,NULL,'Convivencia',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(5,NULL,'Soltero',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(6,NULL,'Casado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(7,NULL,'Viudo',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `estado_civil` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva`
--

DROP TABLE IF EXISTS `fa_masiva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva`
--

LOCK TABLES `fa_masiva` WRITE;
/*!40000 ALTER TABLE `fa_masiva` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_detalle`
--

DROP TABLE IF EXISTS `fa_masiva_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_detalle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fa_masiva_id` int(11) NOT NULL,
  `cliente_id` int(11) NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL DEFAULT '22',
  `activity_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `concepto_id` int(10) unsigned NOT NULL DEFAULT '1',
  `taxable_iibb` int(10) unsigned NOT NULL DEFAULT '2',
  `renglon1` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe1` decimal(20,2) DEFAULT NULL,
  `renglon2` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe2` decimal(20,2) DEFAULT NULL,
  `renglon3` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe3` decimal(20,2) DEFAULT NULL,
  `punto_venta_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date DEFAULT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_detalle_concepto_id_foreign` (`concepto_id`),
  KEY `fa_masiva_detalle_system_tax_id_foreign` (`system_tax_id`),
  KEY `fa_masiva_detalle_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  KEY `fa_masiva_detalle_zone_id_foreign` (`zone_id`),
  KEY `fa_masiva_detalle_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fa_masiva_detalle_activity_id_foreign` (`activity_id`),
  CONSTRAINT `fa_masiva_detalle_activity_id_foreign` FOREIGN KEY (`activity_id`) REFERENCES `activities` (`id`),
  CONSTRAINT `fa_masiva_detalle_concepto_id_foreign` FOREIGN KEY (`concepto_id`) REFERENCES `fact_elec_conceptos_afip` (`id`),
  CONSTRAINT `fa_masiva_detalle_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `fac_elec_cond_frente_iva` (`id`),
  CONSTRAINT `fa_masiva_detalle_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`),
  CONSTRAINT `fa_masiva_detalle_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`),
  CONSTRAINT `fa_masiva_detalle_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_detalle`
--

LOCK TABLES `fa_masiva_detalle` WRITE;
/*!40000 ALTER TABLE `fa_masiva_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_stock`
--

DROP TABLE IF EXISTS `fa_masiva_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_stock_person_id_foreign` (`person_id`),
  KEY `fa_masiva_stock_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `fa_masiva_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fa_masiva_stock_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_stock`
--

LOCK TABLES `fa_masiva_stock` WRITE;
/*!40000 ALTER TABLE `fa_masiva_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_cond_frente_iva`
--

DROP TABLE IF EXISTS `fac_elec_cond_frente_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_cond_frente_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_cond_frente_iva_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_cond_frente_iva`
--

LOCK TABLES `fac_elec_cond_frente_iva` WRITE;
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` DISABLE KEYS */;
INSERT INTO `fac_elec_cond_frente_iva` VALUES (1,'IVA Responsable Inscripto','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'IVA Sujeto Exento','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Consumidor Final','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Responsable Monotributo','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Proveedor del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Cliente del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'IVA Liberado - Ley Nº 19.640','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'IVA Responsable Inscripto - Agente de Percepción','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Monotributista Social','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'IVA No Alcanzado','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_unidad_medidas`
--

DROP TABLE IF EXISTS `fac_elec_unidad_medidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_unidad_medidas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_unidad_medidas_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_unidad_medidas`
--

LOCK TABLES `fac_elec_unidad_medidas` WRITE;
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` DISABLE KEYS */;
INSERT INTO `fac_elec_unidad_medidas` VALUES (1,'Grs','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'Kg','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Mts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Mts2','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Mts3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Lts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'1000 Kwh','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'Unidades','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Pares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'Doc','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(11,'Quilates','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(12,'Millares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(13,'Milimetros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(14,'Mm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(15,'Km','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(16,'Hectolitros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(17,'Cm','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(18,'Cm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_conceptos_afip`
--

DROP TABLE IF EXISTS `fact_elec_conceptos_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_conceptos_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_comprobante_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_conceptos_afip`
--

LOCK TABLES `fact_elec_conceptos_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_conceptos_afip` VALUES (1,1,'Producto','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'Productos y Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_perc_ret`
--

DROP TABLE IF EXISTS `fact_elec_perc_ret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_perc_ret` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` int(10) unsigned NOT NULL,
  `other_tax_id` int(10) unsigned NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_perc_ret_other_tax_id_foreign` (`other_tax_id`),
  CONSTRAINT `fact_elec_perc_ret_other_tax_id_foreign` FOREIGN KEY (`other_tax_id`) REFERENCES `other_taxes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_perc_ret`
--

LOCK TABLES `fact_elec_perc_ret` WRITE;
/*!40000 ALTER TABLE `fact_elec_perc_ret` DISABLE KEYS */;
INSERT INTO `fact_elec_perc_ret` VALUES (1,NULL,'Per./Ret de Imp. a las Ganancias',1,1032,1,NULL,NULL,NULL),(2,NULL,'Per./Ret de IVA',1,1000,1,NULL,NULL,NULL),(3,NULL,'Per./Ret de IIBB',2,1006,1,NULL,NULL,NULL),(4,NULL,'Impuestos Internos',4,1001,1,NULL,NULL,NULL),(5,NULL,'Impuestos Municipales',3,1031,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `fact_elec_perc_ret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_perc_ret_details`
--

DROP TABLE IF EXISTS `fact_elec_perc_ret_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_perc_ret_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fact_elec_perc_ret_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `detalle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zone_id` int(10) unsigned DEFAULT NULL,
  `base_imponible` decimal(16,2) DEFAULT NULL,
  `alicuota` decimal(16,2) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_perc_ret_details_fact_elec_perc_ret_id_foreign` (`fact_elec_perc_ret_id`),
  KEY `fact_elec_perc_ret_details_person_id_foreign` (`person_id`),
  KEY `fact_elec_perc_ret_details_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `fact_elec_perc_ret_details_zone_id_foreign` (`zone_id`),
  CONSTRAINT `fact_elec_perc_ret_details_fact_elec_perc_ret_id_foreign` FOREIGN KEY (`fact_elec_perc_ret_id`) REFERENCES `fact_elec_perc_ret` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_perc_ret_details`
--

LOCK TABLES `fact_elec_perc_ret_details` WRITE;
/*!40000 ALTER TABLE `fact_elec_perc_ret_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_perc_ret_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_puntos_venta`
--

DROP TABLE IF EXISTS `fact_elec_puntos_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_puntos_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `direccion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `codigo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '0000',
  `codigo_postal` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_puntos_venta_person_id_foreign` (`person_id`),
  CONSTRAINT `fact_elec_puntos_venta_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_puntos_venta`
--

LOCK TABLES `fact_elec_puntos_venta` WRITE;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipt_details`
--

DROP TABLE IF EXISTS `fact_elec_receipt_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipt_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cantidad` decimal(20,2) NOT NULL,
  `unidad_medida` text COLLATE utf8mb4_unicode_ci,
  `precio_unitario` decimal(20,2) NOT NULL,
  `neto_gravado` decimal(20,2) NOT NULL,
  `bonificacion_porcentaje` decimal(20,2) DEFAULT NULL,
  `bonificacion_monto` decimal(20,2) DEFAULT NULL,
  `bonificacion_subtotal` decimal(20,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `iva_monto` decimal(20,2) DEFAULT NULL,
  `iva_subtotal` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `codigo` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipt_details_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `fact_elec_receipt_details_system_tax_id_foreign` (`system_tax_id`),
  CONSTRAINT `fact_elec_receipt_details_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `fact_elec_receipt_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipt_details`
--

LOCK TABLES `fact_elec_receipt_details` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipt_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipt_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipts`
--

DROP TABLE IF EXISTS `fact_elec_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date NOT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `concepto_id` int(10) unsigned NOT NULL,
  `punto_venta_id` int(10) unsigned NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL,
  `condiciones_venta` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comprobante_asoc` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `cae` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cae_vencimiento` date DEFAULT NULL,
  `nro_comprobante_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_proceso_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_receptor` int(10) unsigned NOT NULL,
  `condicion_venta_id` int(11) DEFAULT NULL,
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opcion_transferencia` longtext COLLATE utf8mb4_unicode_ci,
  `referencia` text COLLATE utf8mb4_unicode_ci,
  `alias_cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_otros_tributos` decimal(16,2) DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipts_user_id_foreign` (`user_id`),
  KEY `fact_elec_receipts_punto_venta_id_foreign` (`punto_venta_id`),
  KEY `fact_elec_receipts_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fact_elec_receipts_person_id_foreign` (`person_id`),
  KEY `fact_elec_receipts_person_id_receptor_foreign` (`person_id_receptor`),
  KEY `fact_elec_receipts_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  KEY `fact_elec_receipts_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `fact_elec_receipts_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `condicion_frente_al_iva` (`id`),
  CONSTRAINT `fact_elec_receipts_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_receptor_foreign` FOREIGN KEY (`person_id_receptor`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_punto_venta_id_foreign` FOREIGN KEY (`punto_venta_id`) REFERENCES `fact_elec_puntos_venta` (`id`),
  CONSTRAINT `fact_elec_receipts_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipts`
--

LOCK TABLES `fact_elec_receipts` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipts` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_tipos_docs_afip`
--

DROP TABLE IF EXISTS `fact_elec_tipos_docs_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_tipos_docs_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_tipo_doc_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_tipos_docs_afip`
--

LOCK TABLES `fact_elec_tipos_docs_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_tipos_docs_afip` VALUES (1,1,'CI Buenos Aires','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'CI Catamarca','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'CI Córdoba','2019-03-13 13:29:34','2019-03-13 13:29:34'),(4,4,'CI Corrientes','2019-03-13 13:29:34','2019-03-13 13:29:34'),(5,5,'CI Entre Ríos','2019-03-13 13:29:34','2019-03-13 13:29:34'),(6,6,'CI Jujuy','2019-03-13 13:29:34','2019-03-13 13:29:34'),(7,7,'CI Mendoza','2019-03-13 13:29:34','2019-03-13 13:29:34'),(8,8,'CI La Rioja','2019-03-13 13:29:34','2019-03-13 13:29:34'),(9,9,'CI Salta','2019-03-13 13:29:34','2019-03-13 13:29:34'),(10,10,'CI San Juan','2019-03-13 13:29:34','2019-03-13 13:29:34'),(11,11,'CI San Luis','2019-03-13 13:29:34','2019-03-13 13:29:34'),(12,12,'CI Santa Fe','2019-03-13 13:29:34','2019-03-13 13:29:34'),(13,13,'CI Santiago del Estero','2019-03-13 13:29:34','2019-03-13 13:29:34'),(14,14,'CI Tucumán','2019-03-13 13:29:34','2019-03-13 13:29:34'),(16,16,'CI Chaco','2019-03-13 13:29:34','2019-03-13 13:29:34'),(17,17,'CI Chubut','2019-03-13 13:29:34','2019-03-13 13:29:34'),(18,18,'CI Formosa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(19,19,'CI Misiones','2019-03-13 13:29:34','2019-03-13 13:29:34'),(20,20,'CI Neuquén','2019-03-13 13:29:34','2019-03-13 13:29:34'),(21,21,'CI La Pampa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(22,22,'CI Río Negro','2019-03-13 13:29:34','2019-03-13 13:29:34'),(23,23,'CI Santa Cruz','2019-03-13 13:29:34','2019-03-13 13:29:34'),(24,24,'CI Tierra del Fuego','2019-03-13 13:29:34','2019-03-13 13:29:34'),(80,80,'CUIT','2019-03-13 13:29:34','2019-03-13 13:29:34'),(86,86,'CUIL','2019-03-13 13:29:34','2019-03-13 13:29:34'),(87,87,'CDI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(89,89,'LE','2019-03-13 13:29:34','2019-03-13 13:29:34'),(90,90,'LC','2019-03-13 13:29:34','2019-03-13 13:29:34'),(91,91,'CI Extranjera','2019-03-13 13:29:34','2019-03-13 13:29:34'),(92,92,'en trámite','2019-03-13 13:29:34','2019-03-13 13:29:34'),(93,93,'Acta Nacimiento','2019-03-13 13:29:34','2019-03-13 13:29:34'),(94,94,'Pasaporte','2019-03-13 13:29:34','2019-03-13 13:29:34'),(95,95,'CI Bs. As. RNP','2019-03-13 13:29:34','2019-03-13 13:29:34'),(96,96,'DNI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(97,0,'CI Policía Federal','2019-03-13 13:29:34','2019-03-13 13:29:34'),(99,99,'Doc. (Otro)','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq`
--

DROP TABLE IF EXISTS `faq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `faq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pregunta` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `respuesta` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq`
--

LOCK TABLES `faq` WRITE;
/*!40000 ALTER TABLE `faq` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_upload_details`
--

DROP TABLE IF EXISTS `file_upload_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_upload_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `file_upload_id` int(10) unsigned NOT NULL,
  `detail` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_upload_details_file_upload_id_foreign` (`file_upload_id`),
  CONSTRAINT `file_upload_details_file_upload_id_foreign` FOREIGN KEY (`file_upload_id`) REFERENCES `file_uploads` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_upload_details`
--

LOCK TABLES `file_upload_details` WRITE;
/*!40000 ALTER TABLE `file_upload_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_upload_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_uploads`
--

DROP TABLE IF EXISTS `file_uploads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_uploads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `data_type_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_uploads_data_type_id_foreign` (`data_type_id`),
  KEY `file_uploads_user_id_foreign` (`user_id`),
  KEY `file_uploads_person_id_foreign` (`person_id`),
  KEY `file_uploads_period_id_foreign` (`period_id`),
  CONSTRAINT `file_uploads_data_type_id_foreign` FOREIGN KEY (`data_type_id`) REFERENCES `data_types` (`id`),
  CONSTRAINT `file_uploads_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `file_uploads_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `file_uploads_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `tusers` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_uploads`
--

LOCK TABLES `file_uploads` WRITE;
/*!40000 ALTER TABLE `file_uploads` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_uploads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_art_90`
--

DROP TABLE IF EXISTS `ganan_art_90`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_art_90` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,2) NOT NULL DEFAULT '0.00',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_art_90`
--

LOCK TABLES `ganan_art_90` WRITE;
/*!40000 ALTER TABLE `ganan_art_90` DISABLE KEYS */;
INSERT INTO `ganan_art_90` VALUES (1,2017,0.00,20000.00,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,2017,20000.00,40000.00,1000.00,0.09,20000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,2017,40000.00,60000.00,2800.00,0.12,40000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(4,2017,60000.00,80000.00,5200.00,0.15,60000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(5,2017,80000.00,120000.00,8200.00,0.19,80000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(6,2017,120000.00,160000.00,15800.00,0.23,120000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(7,2017,160000.00,240000.00,25000.00,0.27,160000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(8,2017,240000.00,320000.00,46600.00,0.31,240000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(9,2017,320000.00,999999999.99,71400.00,0.35,320000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(10,2018,0.00,25754.00,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(11,2018,25754.00,51508.00,1287.70,0.09,25754.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(12,2018,51508.00,77262.00,3605.56,0.12,51508.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(13,2018,77262.00,103016.00,6696.04,0.15,77262.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(14,2018,103016.00,154524.00,10559.14,0.19,103016.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(15,2018,154524.00,206032.00,20345.66,0.23,154524.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(16,2018,206032.00,309048.00,32192.50,0.27,206032.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(17,2018,309048.00,412064.00,60006.82,0.31,309048.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(18,2018,412064.00,999999999.99,91941.78,0.35,412064.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(19,2019,0.00,33039.81,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(20,2019,33039.81,66079.61,1651.99,0.09,33039.81,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(21,2019,66079.61,99119.42,4625.57,0.12,66079.61,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(22,2019,99119.42,132159.23,8590.35,0.15,99119.42,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(23,2019,132159.23,198238.84,13546.32,0.19,132159.23,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(24,2019,198238.84,264318.45,26101.45,0.23,198238.84,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(25,2019,264318.45,396477.68,41299.76,0.27,264318.45,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(26,2019,396477.68,528636.91,76982.75,0.31,396477.68,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(27,2019,528636.91,999999999.99,117952.11,0.35,528636.91,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(28,2016,0.00,10000.00,0.00,0.09,0.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(29,2016,10000.00,20000.00,900.00,0.14,10000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(30,2016,20000.00,30000.00,2300.00,0.19,20000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(31,2016,30000.00,60000.00,4200.00,0.23,30000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(32,2016,60000.00,90000.00,11100.00,0.27,60000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(33,2016,90000.00,120000.00,19200.00,0.31,90000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(34,2016,120000.00,999999999.00,28500.00,0.35,120000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(37,2020,0.00,47669.16,0.00,0.05,0.00,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(38,2020,47669.16,95338.32,2383.46,0.09,47669.16,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(39,2020,95338.32,143007.48,6673.68,0.12,95338.32,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(40,2020,143007.48,190676.65,12393.98,0.15,143007.48,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(41,2020,190676.65,286014.96,19544.36,0.19,190676.65,'2020-01-28 14:17:39','2022-10-11 09:37:13',NULL),(42,2020,286014.96,381353.28,37658.64,0.23,286014.96,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL);
INSERT INTO `ganan_art_90` VALUES (43,2020,381353.28,572029.92,59586.45,0.27,381353.28,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(44,2020,572029.92,762706.57,111069.14,0.31,572029.92,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(45,2020,762706.57,999999999.99,170178.90,0.35,762706.57,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(46,2021,0.00,64532.64,0.00,0.05,0.00,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(47,2021,64532.64,129065.29,3226.63,0.09,64532.64,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(48,2021,129065.29,193597.93,9034.57,0.12,129065.29,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(49,2021,193597.93,258130.58,16778.49,0.15,193597.93,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(50,2021,258130.58,387195.86,26458.39,0.19,258130.58,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(51,2021,387195.86,516261.14,50980.79,0.23,387195.86,'2022-10-11 09:37:14','2022-10-11 09:37:26',NULL),(52,2021,516261.14,774391.71,80665.80,0.27,516261.14,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(53,2021,774391.71,1032522.30,150361.06,0.31,774391.71,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(54,2021,1032522.30,999999999.99,230381.54,0.35,1032522.30,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(55,2022,0.00,97201.99,0.00,0.05,0.00,'2022-10-11 09:37:19','2022-10-11 09:37:20',NULL),(56,2022,97201.99,194404.01,4860.10,0.09,97201.99,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(57,2022,194404.01,291606.01,13608.29,0.12,194404.01,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(58,2022,291606.01,388808.02,25272.52,0.15,291606.01,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(59,2022,388808.02,583212.02,39852.82,0.19,388808.02,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(60,2022,583212.02,777616.02,76789.59,0.23,583212.02,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(61,2022,777616.02,1166424.03,121502.49,0.27,777616.02,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(62,2022,1166424.03,1555232.07,226480.67,0.31,1166424.03,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(63,2022,1555232.07,999999999.99,347011.15,0.35,1555232.07,'2022-10-11 09:37:19','2023-06-27 10:54:56',NULL),(64,2023,0.00,173834.61,0.00,0.05,0.00,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(65,2023,173834.61,347669.23,8691.73,0.09,173834.61,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(66,2023,347669.23,521503.84,24336.85,0.12,347669.23,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(67,2023,521503.84,695338.47,45197.00,0.15,521503.84,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(68,2023,695338.47,1043007.68,71272.19,0.19,695338.47,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(69,2023,1043007.68,1390676.90,137329.34,0.23,1043007.68,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(70,2023,1390676.90,2086015.35,217293.26,0.27,1390676.90,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(71,2023,2086015.35,2781353.85,405034.64,0.31,2086015.35,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(72,2023,2781353.85,999999999.99,620589.58,0.35,2781353.85,'2022-12-28 17:49:30','2023-06-27 10:54:56',NULL);
/*!40000 ALTER TABLE `ganan_art_90` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_categorias`
--

DROP TABLE IF EXISTS `ganan_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_categorias`
--

LOCK TABLES `ganan_categorias` WRITE;
/*!40000 ALTER TABLE `ganan_categorias` DISABLE KEYS */;
INSERT INTO `ganan_categorias` VALUES (1,'Primera',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(2,'Segunda',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(3,'Tercera',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(4,'Cuarta',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
/*!40000 ALTER TABLE `ganan_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_conceptos_anticipos`
--

DROP TABLE IF EXISTS `ganan_conceptos_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_conceptos_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ganan_conceptos_anticipos_nombre_unique` (`nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_conceptos_anticipos`
--

LOCK TABLES `ganan_conceptos_anticipos` WRITE;
/*!40000 ALTER TABLE `ganan_conceptos_anticipos` DISABLE KEYS */;
INSERT INTO `ganan_conceptos_anticipos` VALUES (1,NULL,'Anticipos',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,NULL,'Retenciones y Percepciones',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,NULL,'Saldo a Favor Anterior',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL);
/*!40000 ALTER TABLE `ganan_conceptos_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_anticipos`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_anticipos_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_anticipos`
--

LOCK TABLES `ganan_ddjj_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_deducciones`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_deducciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_deducciones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_deduccion_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_deducciones_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_deducciones_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_deducciones_ganan_deduccion_id_foreign` (`ganan_deduccion_id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_ganan_deduccion_id_foreign` FOREIGN KEY (`ganan_deduccion_id`) REFERENCES `ganan_deducciones` (`id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_deducciones`
--

LOCK TABLES `ganan_ddjj_detail_deducciones` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_deducciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_deducciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_ing_egr`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_ing_egr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_ing_egr` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `ganan_categoria_id` int(10) unsigned NOT NULL,
  `ganan_tipo_op_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_ing_egr_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_ing_egr_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_categoria_id_foreign` (`ganan_categoria_id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_tipo_op_id_foreign` (`ganan_tipo_op_id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_categoria_id_foreign` FOREIGN KEY (`ganan_categoria_id`) REFERENCES `ganan_categorias` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_tipo_op_id_foreign` FOREIGN KEY (`ganan_tipo_op_id`) REFERENCES `ganan_tipos_op` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_ing_egr`
--

LOCK TABLES `ganan_ddjj_detail_ing_egr` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_ing_egr` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_ing_egr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjjs`
--

DROP TABLE IF EXISTS `ganan_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ingresos_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `ingresos_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `egresos_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `egresos_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `deducciones_total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `ganan_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjjs`
--

LOCK TABLES `ganan_ddjjs` WRITE;
/*!40000 ALTER TABLE `ganan_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_deducciones`
--

DROP TABLE IF EXISTS `ganan_deducciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_deducciones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `generales` tinyint(1) NOT NULL DEFAULT '0',
  `particulares` tinyint(1) NOT NULL DEFAULT '0',
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=173 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_deducciones`
--

LOCK TABLES `ganan_deducciones` WRITE;
/*!40000 ALTER TABLE `ganan_deducciones` DISABLE KEYS */;
INSERT INTO `ganan_deducciones` VALUES (1,NULL,2017,1,0,'Primas de seguro para el caso de muerte',999.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,NULL,2017,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,NULL,2017,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(4,NULL,2017,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(5,NULL,2017,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(6,NULL,2017,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(7,NULL,2017,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(8,NULL,2017,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(9,NULL,2017,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(10,NULL,2017,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(11,NULL,2017,1,0,'Servicio Doméstico',51967.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(12,NULL,2017,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(13,NULL,2017,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(14,NULL,2017,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(15,NULL,2017,0,1,'Conyuge',48447.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(16,NULL,2017,0,1,'Hijo Incapacitado',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(17,NULL,2017,0,1,'Hijo Menor 18 años',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(18,NULL,2017,0,1,'Hijastro Incapacitado',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(19,NULL,2017,0,1,'Hijastro Menor 18 Años',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(20,NULL,2017,0,1,'Ganancia No Imponible',51967.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(21,NULL,2017,0,1,'Deduccion Especial',51967.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(22,NULL,2018,1,0,'Primas de seguro para el caso de muerte',12000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(23,NULL,2018,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(24,NULL,2018,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(25,NULL,2018,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(26,NULL,2018,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(27,NULL,2018,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(28,NULL,2018,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(29,NULL,2018,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(30,NULL,2018,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
INSERT INTO `ganan_deducciones` VALUES (31,NULL,2018,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(32,NULL,2018,1,0,'Servicio Doméstico',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(33,NULL,2018,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(34,NULL,2018,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(35,NULL,2018,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(36,NULL,2018,0,1,'Conyuge',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(37,NULL,2018,0,1,'Hijo Incapacitado',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(38,NULL,2018,0,1,'Hijo Menor 18 años',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(39,NULL,2018,0,1,'Hijastro Incapacitado',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(40,NULL,2018,0,1,'Hijastro Menor 18 Años',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(41,NULL,2018,0,1,'Ganancia No Imponible',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(42,NULL,2018,0,1,'Deduccion Especial',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(43,NULL,2019,1,0,'Primas de seguro para el caso de muerte',18000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(44,NULL,2019,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(45,NULL,2019,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(46,NULL,2019,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(47,NULL,2019,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(48,NULL,2019,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(49,NULL,2019,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(50,NULL,2019,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(51,NULL,2019,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(52,NULL,2019,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(53,NULL,2019,1,0,'Servicio Doméstico',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(54,NULL,2019,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(55,NULL,2019,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(56,NULL,2019,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(57,NULL,2019,0,1,'Conyuge',80033.97,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(58,NULL,2019,0,1,'Hijo Incapacitado',40361.43,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(59,NULL,2019,0,1,'Hijo Menor 18 años',206037.56,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(60,NULL,2019,0,1,'Hijastro Incapacitado',206037.56,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(61,NULL,2019,0,1,'Hijastro Menor 18 Años',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(62,NULL,2019,0,1,'Ganancia No Imponible',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(63,NULL,2019,0,1,'Deduccion Especial',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
INSERT INTO `ganan_deducciones` VALUES (64,NULL,2016,1,0,'Primas de seguro para el caso de muerte',999.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(65,NULL,2016,1,0,'Gastos de Sepelio',999.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(66,NULL,2016,1,0,'Aportes a Obras Sociales',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(67,NULL,2016,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(68,NULL,2016,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(69,NULL,2016,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(70,NULL,2016,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(71,NULL,2016,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(72,NULL,2016,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(73,NULL,2016,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(74,NULL,2016,1,0,'Servicio Doméstico',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(75,NULL,2016,1,0,'Donaciones',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(76,NULL,2016,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(77,NULL,2016,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y \n            Paramédica',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(78,NULL,2016,0,1,'Conyuge',39778.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(79,NULL,2016,0,1,'Hijo Incapacitado',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(80,NULL,2016,0,1,'Hijo Menor 18 años',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(81,NULL,2016,0,1,'Hijastro Incapacitado',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(82,NULL,2016,0,1,'Hijastro Menor 18 Años',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(83,NULL,2016,0,1,'Ganancia No Imponible',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(84,NULL,2016,0,1,'Deduccion Especial',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(85,NULL,2019,1,0,'Alquileres',103018.97,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(86,NULL,2020,1,0,'Alquileres',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(87,NULL,2020,1,0,'Primas de seguro para el caso de muerte',18000.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(88,NULL,2020,1,0,'Gastos de Sepelio',999.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(89,NULL,2020,1,0,'Aportes a Obras Sociales',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(90,NULL,2020,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(91,NULL,2020,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(92,NULL,2020,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(93,NULL,2020,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL);
INSERT INTO `ganan_deducciones` VALUES (94,NULL,2020,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(95,NULL,2020,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(96,NULL,2020,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(97,NULL,2020,1,0,'Servicio Doméstico',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(98,NULL,2020,1,0,'Donaciones',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(99,NULL,2020,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(100,NULL,2020,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(101,NULL,2020,0,1,'Conyuge',115471.38,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(102,NULL,2020,0,1,'Hijo Incapacitado',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(103,NULL,2020,0,1,'Hijo Menor 18 años',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(104,NULL,2020,0,1,'Hijastro Incapacitado',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(105,NULL,2020,0,1,'Hijastro Menor 18 Años',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(106,NULL,2020,0,1,'Ganancia No Imponible',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(107,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 1',103018.79,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(108,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 1 \"Nuevos Profesionales / Emprendedores',309652.93,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(109,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 2',594533.62,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(110,NULL,2021,1,0,'Primas de seguro para el caso de muerte',24000.00,1,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(111,NULL,2021,1,0,'Gastos de Sepelio',996.23,1,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(112,NULL,2021,1,0,'Aportes a Obras Sociales',0.00,1,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(113,NULL,2021,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(114,NULL,2021,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(115,NULL,2021,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(116,NULL,2021,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(117,NULL,2021,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(118,NULL,2021,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(119,NULL,2021,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(120,NULL,2021,1,0,'Servicio Doméstico',167678.40,1,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(121,NULL,2021,1,0,'Donaciones',0.00,1,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(122,NULL,2021,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(123,NULL,2021,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(124,NULL,2021,0,1,'Conyuge',156320.63,1,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(125,NULL,2021,0,1,'Hijo Menor 18 años',78833.08,1,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL);
INSERT INTO `ganan_deducciones` VALUES (126,NULL,2021,0,1,'Ganancia No Imponible',167678.40,1,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(127,NULL,2021,0,1,'Deduccion Especial',804856.34,1,'2022-10-11 09:37:14','2022-10-11 09:37:14',NULL),(128,NULL,2022,1,0,'Primas de seguro para el caso de muerte',24000.00,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(129,NULL,2022,1,0,'Gastos de Sepelio',996.23,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(130,NULL,2022,1,0,'Aportes a Obras Sociales',0.00,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(131,NULL,2022,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(132,NULL,2022,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(133,NULL,2022,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(134,NULL,2022,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(135,NULL,2022,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(136,NULL,2022,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(137,NULL,2022,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(138,NULL,2022,1,0,'Servicio Doméstico',252564.84,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(139,NULL,2022,1,0,'Donaciones',0.00,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(140,NULL,2022,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(141,NULL,2022,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(142,NULL,2022,1,0,'Alquileres',252564.84,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(143,NULL,2022,0,1,'Conyuge',235457.25,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(144,NULL,2022,0,1,'Hijo Menor 18 años',118741.97,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(145,NULL,2022,0,1,'Ganancia No Imponible',252564.84,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(146,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 2]',1212311.24,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(147,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1]',505129.68,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(148,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1 “nuevos profesionales/emprendedores”]',631412.10,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(149,NULL,2022,0,1,'Hijo Incapacitado',237483.94,1,'2022-10-11 09:37:19','2022-10-11 09:37:19',NULL),(150,NULL,2021,1,0,'Alquileres',167678.40,1,NULL,NULL,NULL),(151,NULL,2023,1,0,'Primas de seguro para el caso de muerte',24000.00,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(152,NULL,2023,1,0,'Aportes a Obras Sociales',0.00,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(153,NULL,2023,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(154,NULL,2023,1,0,'Gastos de Sepelio',996.23,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(155,NULL,2023,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL);
INSERT INTO `ganan_deducciones` VALUES (156,NULL,2023,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(157,NULL,2023,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(158,NULL,2023,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(159,NULL,2023,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(160,NULL,2023,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(161,NULL,2023,1,0,'Servicio Doméstico',451686.96,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(162,NULL,2023,1,0,'Donaciones',0.00,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(163,NULL,2023,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(164,NULL,2023,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(165,NULL,2023,1,0,'Alquileres',451686.96,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(166,NULL,2023,0,1,'Ganancia No Imponible',451686.96,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(167,NULL,2023,0,1,'Conyuge',421091.75,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(168,NULL,2023,0,1,'Hijo Menor 18 años',212358.14,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(169,NULL,2023,0,1,'Hijo Incapacitado',424716.28,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(170,NULL,2023,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1]',1580904.36,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(171,NULL,2023,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1 “nuevos profesionales/emprendedores”]',1806747.84,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL),(172,NULL,2023,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 2]',2168097.42,1,'2022-12-28 17:49:30','2022-12-28 17:49:30',NULL);
/*!40000 ALTER TABLE `ganan_deducciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_tipos_op`
--

DROP TABLE IF EXISTS `ganan_tipos_op`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_tipos_op` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_tipos_op`
--

LOCK TABLES `ganan_tipos_op` WRITE;
/*!40000 ALTER TABLE `ganan_tipos_op` DISABLE KEYS */;
INSERT INTO `ganan_tipos_op` VALUES (1,NULL,'Gravado',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(2,NULL,'Exento',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
/*!40000 ALTER TABLE `ganan_tipos_op` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iibb_perceptions`
--

DROP TABLE IF EXISTS `iibb_perceptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iibb_perceptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iibb_perceptions`
--

LOCK TABLES `iibb_perceptions` WRITE;
/*!40000 ALTER TABLE `iibb_perceptions` DISABLE KEYS */;
INSERT INTO `iibb_perceptions` VALUES (1,NULL,NULL,NULL,'IIBB CABA','IIBBCABA'),(2,NULL,NULL,NULL,'IIBB Bs. As.','IIBBBSAS'),(3,NULL,NULL,NULL,'Percepcion IIBB Tucuman','IIBBTucuman'),(4,NULL,NULL,NULL,'Perc IIBB Misiones','IIBBMisiones'),(5,NULL,NULL,NULL,'Perc IIBB Cordoba','IIBBCba'),(6,NULL,NULL,NULL,'Pec IIBB La Pampa','IIBB La Pampa'),(7,NULL,NULL,NULL,'Perc IIBB Rio Negro','IIBB Rio Negro'),(8,NULL,NULL,NULL,'Perc IIBB Corrientes','IIIBB Corrientes'),(9,NULL,NULL,NULL,'Perc IIBB Santiago del Estero','IIBBSantiago');
/*!40000 ALTER TABLE `iibb_perceptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_combos`
--

DROP TABLE IF EXISTS `inv_combos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_combos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `inv_product_combo_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `cantidades` int(11) NOT NULL,
  `codigo_interno` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_combos_inv_product_combo_id_foreign` (`inv_product_combo_id`),
  KEY `inv_combos_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_combos_inv_product_combo_id_foreign` FOREIGN KEY (`inv_product_combo_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_combos_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_combos`
--

LOCK TABLES `inv_combos` WRITE;
/*!40000 ALTER TABLE `inv_combos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_combos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_control_stock`
--

DROP TABLE IF EXISTS `inv_control_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_control_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_control_stock_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_control_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_control_stock`
--

LOCK TABLES `inv_control_stock` WRITE;
/*!40000 ALTER TABLE `inv_control_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_control_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_control_stock_detail`
--

DROP TABLE IF EXISTS `inv_control_stock_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_control_stock_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_control_stock_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `stock_actual` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_real` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_diferencia` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_diferencia` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_control_stock_detail_person_id_foreign` (`person_id`),
  KEY `inv_control_stock_detail_inv_control_stock_id_foreign` (`inv_control_stock_id`),
  KEY `inv_control_stock_detail_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_control_stock_detail_inv_control_stock_id_foreign` FOREIGN KEY (`inv_control_stock_id`) REFERENCES `inv_control_stock` (`id`),
  CONSTRAINT `inv_control_stock_detail_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_control_stock_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_control_stock_detail`
--

LOCK TABLES `inv_control_stock_detail` WRITE;
/*!40000 ALTER TABLE `inv_control_stock_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_control_stock_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_depositos`
--

DROP TABLE IF EXISTS `inv_depositos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_depositos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_depositos_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_depositos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_depositos`
--

LOCK TABLES `inv_depositos` WRITE;
/*!40000 ALTER TABLE `inv_depositos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_depositos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_descarga_details`
--

DROP TABLE IF EXISTS `inv_descarga_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_descarga_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_descarga_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `cantidades` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_descarga_details_person_id_foreign` (`person_id`),
  KEY `inv_descarga_details_inv_producto_id_foreign` (`inv_producto_id`),
  KEY `inv_descarga_details_inv_descarga_id_foreign` (`inv_descarga_id`),
  CONSTRAINT `inv_descarga_details_inv_descarga_id_foreign` FOREIGN KEY (`inv_descarga_id`) REFERENCES `inv_descargas` (`id`),
  CONSTRAINT `inv_descarga_details_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_descarga_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_descarga_details`
--

LOCK TABLES `inv_descarga_details` WRITE;
/*!40000 ALTER TABLE `inv_descarga_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_descarga_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_descargas`
--

DROP TABLE IF EXISTS `inv_descargas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_descargas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_gastos_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_empleado_id` int(10) unsigned DEFAULT NULL,
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `fecha` datetime NOT NULL DEFAULT '2023-03-15 23:49:01',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_descargas_person_id_foreign` (`person_id`),
  KEY `inv_descargas_inv_orden_trabajo_gastos_tipo_id_foreign` (`inv_orden_trabajo_gastos_tipo_id`),
  KEY `inv_descargas_syj_empleado_id_foreign` (`syj_empleado_id`),
  CONSTRAINT `inv_descargas_inv_orden_trabajo_gastos_tipo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_gastos_tipo_id`) REFERENCES `inv_orden_trabajo_gastos_tipos` (`id`),
  CONSTRAINT `inv_descargas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_descargas_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_descargas`
--

LOCK TABLES `inv_descargas` WRITE;
/*!40000 ALTER TABLE `inv_descargas` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_descargas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_indicadores`
--

DROP TABLE IF EXISTS `inv_indicadores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_indicadores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metodo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `orden` int(10) unsigned NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_indicadores`
--

LOCK TABLES `inv_indicadores` WRITE;
/*!40000 ALTER TABLE `inv_indicadores` DISABLE KEYS */;
INSERT INTO `inv_indicadores` VALUES (1,NULL,'Datos Grales','datos_grales','card_info',5,1,NULL,'2022-10-11 09:37:25',NULL),(2,NULL,'Impuestos Asociados','impuestos_asociados','card_info',6,1,NULL,'2022-10-11 09:37:25',NULL),(3,NULL,'Informacion de Liquidacion','informacion_de_liquidacion','card_info',7,1,NULL,'2022-10-11 09:37:25',NULL),(4,NULL,'Cantidad Ventas del Mes','cantidad_ventas_del_mes','card',1,1,NULL,'2022-10-11 09:37:25',NULL),(5,NULL,'Total Facturado En El Mes','total_facturado_en_el_mes','card',2,1,NULL,'2022-10-11 09:37:25',NULL),(6,NULL,'Total Facturado En El Dia','total_facturado_en_el_dia','card',3,1,NULL,'2022-10-11 09:37:25',NULL),(7,NULL,'Total Facturado En El Año','total_facturado_en_el_anio','card',4,1,NULL,'2022-10-11 09:37:25',NULL),(8,NULL,'Facturacion Mensual','facturacion_mensual','grafico',8,1,NULL,'2022-10-11 09:37:25',NULL),(9,NULL,'Proyeccion de Ganancias','proyeccion_de_ganancias','tabla',9,1,NULL,'2022-10-11 09:37:25',NULL),(10,NULL,'Posicion IVA','posicion_de_iva','tabla',10,1,NULL,'2022-10-11 09:37:25',NULL);
/*!40000 ALTER TABLE `inv_indicadores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_indicadores_persons`
--

DROP TABLE IF EXISTS `inv_indicadores_persons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_indicadores_persons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_indicador_id` bigint(20) unsigned NOT NULL,
  `objetivo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_indicadores_persons_person_id_foreign` (`person_id`),
  KEY `inv_indicadores_persons_inv_indicador_id_foreign` (`inv_indicador_id`),
  CONSTRAINT `inv_indicadores_persons_inv_indicador_id_foreign` FOREIGN KEY (`inv_indicador_id`) REFERENCES `inv_indicadores` (`id`),
  CONSTRAINT `inv_indicadores_persons_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_indicadores_persons`
--

LOCK TABLES `inv_indicadores_persons` WRITE;
/*!40000 ALTER TABLE `inv_indicadores_persons` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_indicadores_persons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ing_egr_stock`
--

DROP TABLE IF EXISTS `inv_ing_egr_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ing_egr_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ing_egr_stock_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_ing_egr_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ing_egr_stock`
--

LOCK TABLES `inv_ing_egr_stock` WRITE;
/*!40000 ALTER TABLE `inv_ing_egr_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ing_egr_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ing_egr_stock_detail`
--

DROP TABLE IF EXISTS `inv_ing_egr_stock_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ing_egr_stock_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_ing_egr_stock_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `sumar1_restar0` tinyint(1) NOT NULL DEFAULT '1',
  `cantidades` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ing_egr_stock_detail_person_id_foreign` (`person_id`),
  KEY `inv_ing_egr_stock_detail_inv_ing_egr_stock_id_foreign` (`inv_ing_egr_stock_id`),
  KEY `inv_ing_egr_stock_detail_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_ing_egr_stock_detail_inv_ing_egr_stock_id_foreign` FOREIGN KEY (`inv_ing_egr_stock_id`) REFERENCES `inv_ing_egr_stock` (`id`),
  CONSTRAINT `inv_ing_egr_stock_detail_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_ing_egr_stock_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ing_egr_stock_detail`
--

LOCK TABLES `inv_ing_egr_stock_detail` WRITE;
/*!40000 ALTER TABLE `inv_ing_egr_stock_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ing_egr_stock_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_lista_de_precios`
--

DROP TABLE IF EXISTS `inv_lista_de_precios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_lista_de_precios` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `porcentaje_descuento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_lista_de_precios_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_lista_de_precios_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_lista_de_precios`
--

LOCK TABLES `inv_lista_de_precios` WRITE;
/*!40000 ALTER TABLE `inv_lista_de_precios` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_lista_de_precios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_config_cc`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_config_cc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_config_cc` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `horas_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `horas_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `gastos_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `gastos_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `productos_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `productos_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `asiento_horas_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_horas_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_gastos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_gastos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_productos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_productos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_config_cc_person_id_foreign` (`person_id`),
  KEY `hcc_id_foreign` (`horas_conta_plan_cuenta_id`),
  KEY `gcc_id_foreign` (`gastos_conta_plan_cuenta_id`),
  KEY `pcc_id_foreign` (`productos_conta_plan_cuenta_id`),
  KEY `h_contra_cc_id_foreign` (`horas_contra_conta_plan_cuenta_id`),
  KEY `g_contra_cc_id_foreign` (`gastos_contra_conta_plan_cuenta_id`),
  KEY `p_contra_cc_id_foreign` (`productos_contra_conta_plan_cuenta_id`),
  KEY `ahcc_id_foreign` (`asiento_horas_cpc_id`),
  KEY `agcc_id_foreign` (`asiento_gastos_cpc_id`),
  KEY `apcc_id_foreign` (`asiento_productos_cpc_id`),
  KEY `ah_contra_cc_id_foreign` (`asiento_contra_horas_cpc_id`),
  KEY `ag_contra_cc_id_foreign` (`asiento_contra_gastos_cpc_id`),
  KEY `ap_contra_cc_id_foreign` (`asiento_contra_productos_cpc_id`),
  CONSTRAINT `ag_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_gastos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `agcc_id_foreign` FOREIGN KEY (`asiento_gastos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ah_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_horas_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ahcc_id_foreign` FOREIGN KEY (`asiento_horas_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ap_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_productos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `apcc_id_foreign` FOREIGN KEY (`asiento_productos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `g_contra_cc_id_foreign` FOREIGN KEY (`gastos_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `gcc_id_foreign` FOREIGN KEY (`gastos_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `h_contra_cc_id_foreign` FOREIGN KEY (`horas_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `hcc_id_foreign` FOREIGN KEY (`horas_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `inv_orden_trabajo_config_cc_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `p_contra_cc_id_foreign` FOREIGN KEY (`productos_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `pcc_id_foreign` FOREIGN KEY (`productos_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_config_cc`
--

LOCK TABLES `inv_orden_trabajo_config_cc` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_config_cc` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_config_cc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_facturada`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_facturada`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_facturada` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_facturada_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_facturada_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_facturada_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  CONSTRAINT `inv_orden_trabajo_facturada_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `inv_orden_trabajo_facturada_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_facturada_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_facturada`
--

LOCK TABLES `inv_orden_trabajo_facturada` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_facturada` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_facturada` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_gastos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_gastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_gastos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_orden_trabajo_gastos_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-10-11 09:37:22',
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_gastos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_gastos_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `inv_orden_trabajo_gastos_receipt_id_foreign` (`receipt_id`),
  KEY `i_o_t_g_t_id_foreign` (`inv_orden_trabajo_gastos_tipo_id`),
  KEY `inv_orden_trabajo_gastos_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `i_o_t_g_t_id_foreign` FOREIGN KEY (`inv_orden_trabajo_gastos_tipo_id`) REFERENCES `inv_orden_trabajo_gastos_tipos` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_gastos`
--

LOCK TABLES `inv_orden_trabajo_gastos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_gastos_tipos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_gastos_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_gastos_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_gastos_tipos_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_orden_trabajo_gastos_tipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_gastos_tipos`
--

LOCK TABLES `inv_orden_trabajo_gastos_tipos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos_tipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_orden_trabajo_horas_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-10-11 09:37:22',
  `syj_empleado_id` int(10) unsigned DEFAULT NULL,
  `cantidad` decimal(16,2) NOT NULL DEFAULT '0.00',
  `is_especial` tinyint(1) NOT NULL DEFAULT '0',
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_horas_inv_orden_trabajo_horas_tipo_id_foreign` (`inv_orden_trabajo_horas_tipo_id`),
  KEY `inv_orden_trabajo_horas_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_horas_syj_empleado_id_foreign` (`syj_empleado_id`),
  CONSTRAINT `inv_orden_trabajo_horas_inv_orden_trabajo_horas_tipo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_horas_tipo_id`) REFERENCES `inv_orden_trabajo_horas_tipos` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas`
--

LOCK TABLES `inv_orden_trabajo_horas` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas_tipos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `valor` decimal(16,2) NOT NULL DEFAULT '1.00',
  `is_acumulador` tinyint(1) NOT NULL DEFAULT '1',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_tipos_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_orden_trabajo_horas_tipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas_tipos`
--

LOCK TABLES `inv_orden_trabajo_horas_tipos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_tipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_productos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_productos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-10-11 09:37:22',
  `cantidades` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_productos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_productos_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_productos_inv_producto_id_foreign` (`inv_producto_id`),
  KEY `inv_orden_trabajo_productos_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `inv_orden_trabajo_productos_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `inv_orden_trabajo_productos_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_productos_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_orden_trabajo_productos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_productos`
--

LOCK TABLES `inv_orden_trabajo_productos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_productos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajos`
--

DROP TABLE IF EXISTS `inv_orden_trabajos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-10-11 09:37:22',
  `fecha_cierre` datetime DEFAULT NULL,
  `numero` int(10) unsigned NOT NULL,
  `responsable` text COLLATE utf8mb4_unicode_ci,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `titulo` text COLLATE utf8mb4_unicode_ci,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `cerrada` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajos_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `inv_orden_trabajos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajos_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajos`
--

LOCK TABLES `inv_orden_trabajos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_product_receipt`
--

DROP TABLE IF EXISTS `inv_product_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_product_receipt` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `type_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `receiptable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `receiptable_id` int(10) unsigned NOT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_sin_iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `descuento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `descuento_por1_imp0` tinyint(1) NOT NULL DEFAULT '1',
  `descuento_porcentaje` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_con_descuento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_final` decimal(16,2) NOT NULL DEFAULT '0.00',
  `iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_product_receipt_type_id_foreign` (`type_id`),
  KEY `inv_product_receipt_person_id_foreign` (`person_id`),
  KEY `inv_product_receipt_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_product_receipt_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_product_receipt_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_product_receipt_type_id_foreign` FOREIGN KEY (`type_id`) REFERENCES `types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_product_receipt`
--

LOCK TABLES `inv_product_receipt` WRITE;
/*!40000 ALTER TABLE `inv_product_receipt` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_product_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_producto_fotos`
--

DROP TABLE IF EXISTS `inv_producto_fotos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_producto_fotos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `inv_producto_id` bigint(20) unsigned NOT NULL,
  `foto` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_producto_fotos_inv_producto_id_foreign` (`inv_producto_id`),
  CONSTRAINT `inv_producto_fotos_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_producto_fotos`
--

LOCK TABLES `inv_producto_fotos` WRITE;
/*!40000 ALTER TABLE `inv_producto_fotos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_producto_fotos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_producto_prioridad`
--

DROP TABLE IF EXISTS `inv_producto_prioridad`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_producto_prioridad` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_producto_prioridad`
--

LOCK TABLES `inv_producto_prioridad` WRITE;
/*!40000 ALTER TABLE `inv_producto_prioridad` DISABLE KEYS */;
INSERT INTO `inv_producto_prioridad` VALUES (1,'Alta',1,NULL,NULL,NULL),(2,'Media',1,NULL,NULL,NULL),(3,'Baja',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `inv_producto_prioridad` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_productos`
--

DROP TABLE IF EXISTS `inv_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_productos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `inv_producto_tipo_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `inv_deposito_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `person_id` int(10) unsigned NOT NULL,
  `person_prov_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigo_externo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigo_interno` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fac_ele_unidad_medida_id` int(10) unsigned NOT NULL DEFAULT '8',
  `inv_rubro_sub_id` bigint(20) unsigned NOT NULL,
  `inv_ubicacion_id` bigint(20) unsigned DEFAULT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `margen` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_sin_iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `system_tax_id` int(10) unsigned DEFAULT NULL,
  `iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_final` decimal(16,2) NOT NULL DEFAULT '0.00',
  `inv_lista_de_precio_id` bigint(20) unsigned DEFAULT NULL,
  `inv_prioridad_id` bigint(20) unsigned NOT NULL DEFAULT '3',
  `foto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stock` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_minimo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `texto_corto` text COLLATE utf8mb4_unicode_ci,
  `texto_largo` text COLLATE utf8mb4_unicode_ci,
  `show_in_catalogo` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_productos_person_id_foreign` (`person_id`),
  KEY `inv_productos_person_prov_id_foreign` (`person_prov_id`),
  KEY `inv_productos_fac_ele_unidad_medida_id_foreign` (`fac_ele_unidad_medida_id`),
  KEY `inv_productos_inv_rubro_sub_id_foreign` (`inv_rubro_sub_id`),
  KEY `inv_productos_inv_ubicacion_id_foreign` (`inv_ubicacion_id`),
  KEY `inv_productos_system_tax_id_foreign` (`system_tax_id`),
  KEY `inv_productos_inv_lista_de_precio_id_foreign` (`inv_lista_de_precio_id`),
  KEY `inv_productos_inv_producto_tipo_id_foreign` (`inv_producto_tipo_id`),
  KEY `inv_productos_moneda_id_foreign` (`moneda_id`),
  KEY `inv_productos_inv_deposito_id_foreign` (`inv_deposito_id`),
  KEY `inv_productos_inv_prioridad_id_foreign` (`inv_prioridad_id`),
  CONSTRAINT `inv_productos_fac_ele_unidad_medida_id_foreign` FOREIGN KEY (`fac_ele_unidad_medida_id`) REFERENCES `fac_elec_unidad_medidas` (`id`),
  CONSTRAINT `inv_productos_inv_deposito_id_foreign` FOREIGN KEY (`inv_deposito_id`) REFERENCES `inv_depositos` (`id`),
  CONSTRAINT `inv_productos_inv_lista_de_precio_id_foreign` FOREIGN KEY (`inv_lista_de_precio_id`) REFERENCES `inv_lista_de_precios` (`id`),
  CONSTRAINT `inv_productos_inv_prioridad_id_foreign` FOREIGN KEY (`inv_prioridad_id`) REFERENCES `inv_producto_prioridad` (`id`),
  CONSTRAINT `inv_productos_inv_producto_tipo_id_foreign` FOREIGN KEY (`inv_producto_tipo_id`) REFERENCES `inv_productos_tipos` (`id`),
  CONSTRAINT `inv_productos_inv_rubro_sub_id_foreign` FOREIGN KEY (`inv_rubro_sub_id`) REFERENCES `inv_rubros_sub` (`id`),
  CONSTRAINT `inv_productos_inv_ubicacion_id_foreign` FOREIGN KEY (`inv_ubicacion_id`) REFERENCES `inv_ubicaciones` (`id`),
  CONSTRAINT `inv_productos_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `inv_productos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_productos_person_prov_id_foreign` FOREIGN KEY (`person_prov_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_productos_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_productos`
--

LOCK TABLES `inv_productos` WRITE;
/*!40000 ALTER TABLE `inv_productos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_productos_tipos`
--

DROP TABLE IF EXISTS `inv_productos_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_productos_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_productos_tipos`
--

LOCK TABLES `inv_productos_tipos` WRITE;
/*!40000 ALTER TABLE `inv_productos_tipos` DISABLE KEYS */;
INSERT INTO `inv_productos_tipos` VALUES (1,NULL,'Unitario',1,NULL,NULL,NULL),(2,NULL,'Combo',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `inv_productos_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_rubros`
--

DROP TABLE IF EXISTS `inv_rubros`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_rubros` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_rubros_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_rubros_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_rubros`
--

LOCK TABLES `inv_rubros` WRITE;
/*!40000 ALTER TABLE `inv_rubros` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_rubros` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_rubros_sub`
--

DROP TABLE IF EXISTS `inv_rubros_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_rubros_sub` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_rubro_id` bigint(20) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_rubros_sub_person_id_foreign` (`person_id`),
  KEY `inv_rubros_sub_inv_rubro_id_foreign` (`inv_rubro_id`),
  CONSTRAINT `inv_rubros_sub_inv_rubro_id_foreign` FOREIGN KEY (`inv_rubro_id`) REFERENCES `inv_rubros` (`id`),
  CONSTRAINT `inv_rubros_sub_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_rubros_sub`
--

LOCK TABLES `inv_rubros_sub` WRITE;
/*!40000 ALTER TABLE `inv_rubros_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_rubros_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_stock_movimientos`
--

DROP TABLE IF EXISTS `inv_stock_movimientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_stock_movimientos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `movimiento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock` decimal(16,2) NOT NULL DEFAULT '0.00',
  `costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_sin_iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_final` decimal(16,2) NOT NULL DEFAULT '0.00',
  `transactionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transactionable_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_morph` (`transactionable_type`,`transactionable_id`),
  KEY `inv_stock_movimientos_person_id_foreign` (`person_id`),
  KEY `inv_stock_movimientos_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_stock_movimientos_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_stock_movimientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_stock_movimientos`
--

LOCK TABLES `inv_stock_movimientos` WRITE;
/*!40000 ALTER TABLE `inv_stock_movimientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_stock_movimientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ubicaciones`
--

DROP TABLE IF EXISTS `inv_ubicaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ubicaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_deposito_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ubicaciones_person_id_foreign` (`person_id`),
  KEY `inv_ubicaciones_inv_deposito_id_foreign` (`inv_deposito_id`),
  CONSTRAINT `inv_ubicaciones_inv_deposito_id_foreign` FOREIGN KEY (`inv_deposito_id`) REFERENCES `inv_depositos` (`id`),
  CONSTRAINT `inv_ubicaciones_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ubicaciones`
--

LOCK TABLES `inv_ubicaciones` WRITE;
/*!40000 ALTER TABLE `inv_ubicaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ubicaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iva_agrupacion`
--

DROP TABLE IF EXISTS `iva_agrupacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iva_agrupacion` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL,
  `ordr` int(11) NOT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iva_agrupacion`
--

LOCK TABLES `iva_agrupacion` WRITE;
/*!40000 ALTER TABLE `iva_agrupacion` DISABLE KEYS */;
INSERT INTO `iva_agrupacion` VALUES (1,1,1,0.00,'Operaciones con Responsables Inscriptos',1,NULL,NULL,NULL),(2,1,2,0.00,'Operaciones con Consumidores finales, Exentos y No alcanzados',1,NULL,NULL,NULL),(3,1,3,0.00,'Operaciones no gravadas y exentas',1,NULL,NULL,NULL),(4,1,4,0.00,'Credito fiscal a restituir',1,NULL,NULL,NULL),(5,2,5,0.00,'Debito fiscal a restituir',1,NULL,NULL,NULL),(6,2,6,0.00,'Total Credito Fiscal',1,NULL,NULL,NULL),(7,2,7,0.00,'Total Operaciones que no Generan Credito Fiscal',1,NULL,NULL,NULL),(8,1,8,0.00,'Operaciones con Monotributistas - Regimen Simmplificado',1,'2022-10-11 09:37:21','2022-10-11 09:37:21',NULL);
/*!40000 ALTER TABLE `iva_agrupacion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iva_conditions`
--

DROP TABLE IF EXISTS `iva_conditions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iva_conditions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `iva_conditions_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iva_conditions`
--

LOCK TABLES `iva_conditions` WRITE;
/*!40000 ALTER TABLE `iva_conditions` DISABLE KEYS */;
INSERT INTO `iva_conditions` VALUES (1,'Monotributo',NULL,NULL),(2,'Responsable Inscripto',NULL,NULL),(3,'Otro',NULL,NULL);
/*!40000 ALTER TABLE `iva_conditions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iva_creditos_tipos`
--

DROP TABLE IF EXISTS `iva_creditos_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iva_creditos_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iva_creditos_tipos`
--

LOCK TABLES `iva_creditos_tipos` WRITE;
/*!40000 ALTER TABLE `iva_creditos_tipos` DISABLE KEYS */;
INSERT INTO `iva_creditos_tipos` VALUES (1,0,'Compras de bienes (excepto bienes de uso)',0.00,1,NULL,NULL,NULL),(2,0,'Locaciones',0.00,1,NULL,NULL,NULL),(3,0,'Prestaciones de servicios',0.00,1,NULL,NULL,NULL),(4,0,'Inversiones de Bienes de Uso',0.00,1,NULL,NULL,NULL),(5,0,'Compras de bienes usados a consumidores finales',0.00,1,NULL,NULL,NULL),(6,0,'Tur IVA',0.00,1,NULL,NULL,NULL),(7,0,'Contribuciones de la Seguridad Social',0.00,1,NULL,NULL,NULL),(8,0,'Contribuciones de la Seguridad Social - Artículo 91 Ley 27.467',0.00,1,NULL,NULL,NULL),(9,0,'Otros Conceptos',0.00,1,NULL,NULL,NULL),(10,0,'Compras de Bienes en el Exterior',0.00,1,NULL,NULL,NULL),(11,0,'Compras de Servicios en el exterior - Impuesto ingresado a través de entidades Financieras',0.00,1,NULL,NULL,NULL),(12,0,'Compras de Servicios en el exterior - Impuesto ingresado por el responsable',0.00,1,NULL,NULL,NULL),(13,0,'Locaciones o prestaciones gravadas en el país realizadas por sujetos del exterior - Impuesto ingresado a través de entidades Financieras',0.00,1,NULL,NULL,NULL),(14,0,'Régimen especial de compensación para la estabilización de precios - Emergencia alimentaria - Ley 27.519',0.00,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `iva_creditos_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  `base_de_dato` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `liquidators`
--

DROP TABLE IF EXISTS `liquidators`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `liquidators` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `liquidators_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `liquidators`
--

LOCK TABLES `liquidators` WRITE;
/*!40000 ALTER TABLE `liquidators` DISABLE KEYS */;
INSERT INTO `liquidators` VALUES (1,NULL,'Florencia',NULL,NULL,NULL),(2,NULL,'Jose Luis',NULL,NULL,NULL),(3,NULL,'Elizabet',NULL,NULL,NULL),(4,NULL,'Graciela',NULL,NULL,NULL),(5,NULL,'Agustina',NULL,NULL,NULL),(6,NULL,'Betty',NULL,NULL,NULL),(7,NULL,'Hernan',NULL,NULL,NULL);
/*!40000 ALTER TABLE `liquidators` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `localidad`
--

DROP TABLE IF EXISTS `localidad`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `localidad` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `zone_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `localidad_descripcion_unique` (`descripcion`),
  KEY `localidad_zone_id_foreign` (`zone_id`),
  CONSTRAINT `localidad_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `localidad`
--

LOCK TABLES `localidad` WRITE;
/*!40000 ALTER TABLE `localidad` DISABLE KEYS */;
INSERT INTO `localidad` VALUES (1,NULL,22,'Capital Federal',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(2,NULL,23,'Vicente Lopez',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(3,NULL,23,'San Isidro',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(4,NULL,23,'Lomas del Mirador',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(5,NULL,23,'Avellaneda',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(6,NULL,23,'Saenz Peña',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(7,NULL,23,'Caseros',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(8,NULL,23,'Moron',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `localidad` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `log_debug`
--

DROP TABLE IF EXISTS `log_debug`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_debug` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `function_name` varchar(255) DEFAULT NULL,
  `message` varchar(255) DEFAULT NULL,
  `date` datetime DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15142 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `log_debug`
--

LOCK TABLES `log_debug` WRITE;
/*!40000 ALTER TABLE `log_debug` DISABLE KEYS */;
INSERT INTO `log_debug` VALUES (1,NULL,'assingMorePeriods','ejecutando funcion','2018-06-06 12:58:53',NULL),(2,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2, periodo->2018-5','2018-06-06 12:58:53',NULL),(3,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(4,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(5,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(6,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(7,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(8,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(9,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(10,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(11,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(12,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(13,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(14,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(15,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(16,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->3, periodo->2018-5','2018-06-06 12:58:53',NULL),(17,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(18,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(19,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(20,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(21,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(22,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(23,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(24,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(25,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(26,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(27,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(28,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(29,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(30,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->5, periodo->2018-5','2018-06-06 12:58:53',NULL),(31,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(32,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(33,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(34,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (35,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(36,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(37,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(38,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(39,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(40,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(41,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(42,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(43,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(44,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->96, periodo->2018-5','2018-06-06 12:58:53',NULL),(45,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(46,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(47,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(48,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(49,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(50,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(51,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(52,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(53,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(54,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(55,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(56,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(57,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(58,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->338, periodo->2018-5','2018-06-06 12:58:53',NULL),(59,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(60,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(61,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(62,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(63,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(64,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(65,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(66,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(67,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (68,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(69,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(70,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(71,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(72,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->435, periodo->2018-5','2018-06-06 12:58:53',NULL),(73,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(74,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(75,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(76,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(77,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(78,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(79,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(80,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(81,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(82,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(83,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(84,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(85,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(86,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->436, periodo->2018-5','2018-06-06 12:58:53',NULL),(87,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(88,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(89,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(90,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(91,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(92,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(93,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(94,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(95,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(96,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(97,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(98,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(99,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(100,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->448, periodo->2018-5','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (101,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(102,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(103,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(104,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(105,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(106,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(107,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(108,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(109,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(110,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(111,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(112,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(113,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(114,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->639, periodo->2018-5','2018-06-06 12:58:53',NULL),(115,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(116,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(117,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(118,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(119,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(120,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(121,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(122,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(123,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(124,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(125,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(126,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(127,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(128,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->640, periodo->2018-5','2018-06-06 12:58:53',NULL),(129,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(130,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(131,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(132,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(133,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (134,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(135,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(136,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(137,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(138,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(139,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(140,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:5