-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-39009656-4
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-08-31 11:10:00','Actividad Generica 1','000001',NULL),(2,NULL,'2022-08-31 11:10:00','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'desireerod26@yahoo.com.ar','2645429562',NULL,1,40719,'2023-01-19');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13781 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7749,40720,1525,3,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',0.31,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:22','2022-09-27 09:35:22'),(2,7749,40720,1525,3,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',381001.38,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:22','2022-09-27 09:35:22'),(3,7749,40720,1525,3,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',3826.01,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:22','2022-09-27 09:35:22'),(4,7749,40720,1525,3,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',3602.46,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:22','2022-09-27 09:35:22'),(5,7749,40720,1525,3,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',151048.96,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:22','2022-09-27 09:35:22'),(6,7749,40720,1525,3,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',6000.00,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:22','2022-09-27 09:35:22'),(7,7749,40720,1525,3,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',25.48,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:22','2022-09-27 09:35:22'),(8,7749,40720,1525,3,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',88776.36,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:22','2022-09-27 09:35:22'),(9,7749,40720,1525,3,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',112500.00,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:22','2022-09-27 09:35:22'),(10,7749,40720,1525,3,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',18086.28,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:23','2022-09-27 09:35:23'),(11,7749,40720,1525,3,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',79963.58,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:23','2022-09-27 09:35:23'),(12,7749,40720,1525,3,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',93933.17,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:23','2022-09-27 09:35:23'),(13,7749,40720,1525,3,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',151048.96,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:23','2022-09-27 09:35:23'),(14,7749,40720,1525,3,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',151048.96,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:23','2022-09-27 09:35:23'),(15,7749,40720,1525,3,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',74673.51,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:23','2022-09-27 09:35:23'),(16,7749,40720,1525,3,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',10078.46,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:23','2022-09-27 09:35:23'),(17,7749,40720,1525,3,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',21941.60,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:23','2022-09-27 09:35:23'),(18,7749,40720,1525,3,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',76288.50,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:23','2022-09-27 09:35:23'),(19,7749,40720,1525,3,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',49560.07,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:23','2022-09-27 09:35:23'),(20,7749,40720,1525,3,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',49560.07,NULL,NULL,1,'2022-09-02 10:17:43','2022-09-27 09:35:23','2022-09-27 09:35:23');
INSERT INTO `balance_libro` VALUES (21,7749,40720,1525,3,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',66489.28,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(22,7749,40720,1525,3,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',85532.47,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(23,7749,40720,1525,3,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',167031.40,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(24,7749,40720,1525,3,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',144082.14,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(25,7749,40720,1525,3,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',15327.07,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(26,7749,40720,1525,3,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',9480.59,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(27,7749,40720,1525,3,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',29499.49,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(28,7749,40720,1525,3,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',41397.41,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(29,7749,40720,1525,3,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',11400.26,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(30,7749,40720,1525,3,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',0.90,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(31,7749,40720,1525,3,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',4900.50,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(32,7749,40720,1525,3,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',122347.67,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(33,7749,40720,1525,3,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',6140.50,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(34,7749,40720,1525,3,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',12900.72,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(35,7749,40720,1525,3,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',74024.51,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(36,7749,40720,1525,3,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',250344.00,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(37,7749,40720,1525,3,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',287444.96,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(38,7749,40720,1525,3,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',62200.68,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(39,7749,40720,1525,3,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',190135.03,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23');
INSERT INTO `balance_libro` VALUES (40,7749,40720,1525,3,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',38108.74,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(41,7749,40720,1525,3,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',40995.25,NULL,NULL,1,'2022-09-02 10:17:44','2022-09-27 09:35:23','2022-09-27 09:35:23'),(42,7749,40720,1525,3,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',28884.13,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(43,7749,40720,1525,3,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',72940.69,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(44,7749,40720,1525,3,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',22668.62,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(45,7749,40720,1525,3,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',18257.66,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(46,7749,40720,1525,3,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',42034.81,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(47,7749,40720,1525,3,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',173786.49,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(48,7749,40720,1525,3,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',6061.81,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(49,7749,40720,1525,3,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',5478.42,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(50,7749,40720,1525,3,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',99614.41,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(51,7749,40720,1525,3,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',42700.00,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(52,7749,40720,1525,3,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',11343.96,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(53,7749,40720,1525,3,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',28039.40,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(54,7749,40720,1525,3,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',0.85,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(55,7749,40720,1525,3,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',23562.23,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(56,7749,40720,1525,3,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',19684.60,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(57,7749,40720,1525,3,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',22300.76,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(58,7749,40720,1525,3,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',66132.19,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(59,7749,40720,1525,3,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',114424.55,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23');
INSERT INTO `balance_libro` VALUES (60,7749,40720,1525,3,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',36241.56,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(61,7749,40720,1525,3,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',108000.09,NULL,NULL,1,'2022-09-02 10:17:45','2022-09-27 09:35:23','2022-09-27 09:35:23'),(62,7749,40720,1525,3,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',49660.57,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:23','2022-09-27 09:35:23'),(63,7749,40720,1525,3,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',23908.37,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:23','2022-09-27 09:35:23'),(64,7749,40720,1525,3,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',142756.72,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:23','2022-09-27 09:35:23'),(65,7749,40720,1525,3,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',81801.02,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:23','2022-09-27 09:35:23'),(66,7749,40720,1525,3,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',73376.29,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:23','2022-09-27 09:35:23'),(67,7749,40720,1525,3,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',27214.64,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:23','2022-09-27 09:35:23'),(68,7749,40720,1525,3,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',26321.31,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:23','2022-09-27 09:35:23'),(69,7749,40720,1525,3,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',86386.20,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:23','2022-09-27 09:35:23'),(70,7749,40720,1525,3,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',73376.29,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:23','2022-09-27 09:35:23'),(71,7749,40720,1525,3,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',1416.98,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:23','2022-09-27 09:35:23'),(72,7749,40720,1525,3,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',19967.77,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:23','2022-09-27 09:35:23'),(73,7749,40720,1525,3,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',1428.41,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:24','2022-09-27 09:35:24'),(74,7749,40720,1525,3,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',3558.36,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:24','2022-09-27 09:35:24'),(75,7749,40720,1525,3,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',17280.52,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:24','2022-09-27 09:35:24'),(76,7749,40720,1525,3,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',360000.00,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:24','2022-09-27 09:35:24'),(77,7749,40720,1525,3,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',323237.77,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:24','2022-09-27 09:35:24'),(78,7749,40720,1525,3,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',836559.06,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:24','2022-09-27 09:35:24');
INSERT INTO `balance_libro` VALUES (79,7749,40720,1525,3,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',19342.00,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:24','2022-09-27 09:35:24'),(80,7749,40720,1525,3,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',55625.39,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:24','2022-09-27 09:35:24'),(81,7749,40720,1525,3,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',4083.20,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:24','2022-09-27 09:35:24'),(82,7749,40720,1525,3,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',4456.19,NULL,NULL,1,'2022-09-02 10:17:46','2022-09-27 09:35:24','2022-09-27 09:35:24'),(83,7749,40720,1525,2,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',6300.00,NULL,NULL,1,'2022-09-19 10:15:06','2022-09-20 11:07:59','2022-09-20 11:07:59'),(84,7749,40720,1525,2,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',84000.00,NULL,NULL,1,'2022-09-19 10:15:06','2022-09-20 11:07:59','2022-09-20 11:07:59'),(85,7749,40720,1525,2,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',60000.00,NULL,NULL,1,'2022-09-19 10:15:06','2022-09-20 11:08:00','2022-09-20 11:08:00'),(86,7749,40720,1525,2,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',28499.96,NULL,NULL,1,'2022-09-19 10:15:06','2022-09-20 11:08:00','2022-09-20 11:08:00'),(87,7749,40720,1525,2,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2800.00,NULL,NULL,1,'2022-09-19 10:15:06','2022-09-20 11:08:00','2022-09-20 11:08:00'),(88,7749,40720,1525,2,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',16900.00,NULL,NULL,1,'2022-09-19 10:15:06','2022-09-20 11:08:00','2022-09-20 11:08:00'),(89,7749,40720,1525,2,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',26899.96,NULL,NULL,1,'2022-09-19 10:15:06','2022-09-20 11:08:00','2022-09-20 11:08:00'),(90,7749,40720,1525,2,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',22300.00,NULL,NULL,1,'2022-09-19 10:15:06','2022-09-20 11:08:00','2022-09-20 11:08:00'),(91,7749,40720,1525,2,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',25800.00,NULL,NULL,1,'2022-09-19 10:15:06','2022-09-20 11:08:00','2022-09-20 11:08:00'),(92,7749,40720,1525,2,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',3000.00,NULL,NULL,1,'2022-09-19 10:15:06','2022-09-20 11:08:00','2022-09-20 11:08:00'),(93,7749,40720,1525,2,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',11999.98,NULL,NULL,1,'2022-09-19 10:15:06','2022-09-20 11:08:00','2022-09-20 11:08:00'),(94,7749,40720,1525,2,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',13000.00,NULL,NULL,1,'2022-09-19 10:15:06','2022-09-20 11:08:00','2022-09-20 11:08:00'),(95,7749,40720,1525,2,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',800.00,NULL,NULL,1,'2022-09-19 10:15:06','2022-09-20 11:08:00','2022-09-20 11:08:00'),(96,7749,40720,1525,2,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',23000.00,NULL,NULL,1,'2022-09-19 10:15:07','2022-09-20 11:08:00','2022-09-20 11:08:00'),(97,7749,40720,1525,2,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',3100.00,NULL,NULL,1,'2022-09-19 10:15:07','2022-09-20 11:08:00','2022-09-20 11:08:00'),(98,7749,40720,1525,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',30580.00,NULL,NULL,1,'2022-09-19 10:15:07','2022-09-20 11:08:00','2022-09-20 11:08:00');
INSERT INTO `balance_libro` VALUES (99,7749,40720,1525,2,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',4800.00,NULL,NULL,1,'2022-09-19 10:15:07','2022-09-20 11:08:00','2022-09-20 11:08:00'),(100,7749,40720,1525,2,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',6000.00,NULL,NULL,1,'2022-09-19 10:15:07','2022-09-20 11:08:00','2022-09-20 11:08:00'),(101,7749,40720,1525,2,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',6075.00,NULL,NULL,1,'2022-09-19 10:15:07','2022-09-20 11:08:00','2022-09-20 11:08:00'),(102,7749,40720,1525,2,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',2150.00,NULL,NULL,1,'2022-09-19 10:15:07','2022-09-20 11:08:00','2022-09-20 11:08:00'),(103,7749,40720,1525,2,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',4700.00,NULL,NULL,1,'2022-09-19 10:15:07','2022-09-20 11:08:00','2022-09-20 11:08:00'),(104,7749,40720,1525,2,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',600.00,NULL,NULL,1,'2022-09-19 10:15:07','2022-09-20 11:08:00','2022-09-20 11:08:00'),(105,7749,40720,1525,2,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',1720.00,NULL,NULL,1,'2022-09-19 10:15:07','2022-09-20 11:08:00','2022-09-20 11:08:00'),(106,7749,40720,1525,2,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',650.00,NULL,NULL,1,'2022-09-19 10:15:07','2022-09-20 11:08:00','2022-09-20 11:08:00'),(107,7749,40720,1525,2,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',2800.00,NULL,NULL,1,'2022-09-19 10:15:07','2022-09-20 11:08:00','2022-09-20 11:08:00'),(108,7749,40720,1525,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',1000.00,NULL,NULL,1,'2022-09-19 10:15:07','2022-09-20 11:08:00','2022-09-20 11:08:00'),(109,7749,40720,1525,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',1200.00,NULL,NULL,1,'2022-09-19 10:15:07','2022-09-20 11:08:00','2022-09-20 11:08:00'),(110,7749,40720,1525,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',3999.99,NULL,NULL,1,'2022-09-19 10:15:07','2022-09-20 11:08:00','2022-09-20 11:08:00'),(111,7749,40720,1525,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',200.00,NULL,NULL,1,'2022-09-19 10:15:08','2022-09-20 11:08:00','2022-09-20 11:08:00'),(112,7749,40720,1525,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',600.00,NULL,NULL,1,'2022-09-19 10:15:08','2022-09-20 11:08:00','2022-09-20 11:08:00'),(113,7749,40720,1525,2,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',4200.00,NULL,NULL,1,'2022-09-19 10:15:08','2022-09-20 11:08:00','2022-09-20 11:08:00'),(114,7749,40720,1525,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',5400.00,NULL,NULL,1,'2022-09-19 10:15:08','2022-09-20 11:08:00','2022-09-20 11:08:00'),(115,7749,40720,1525,2,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',3700.00,NULL,NULL,1,'2022-09-19 10:15:08','2022-09-20 11:08:00','2022-09-20 11:08:00'),(116,7749,40720,1525,2,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',7659.97,NULL,NULL,1,'2022-09-19 10:15:08','2022-09-20 11:08:00','2022-09-20 11:08:00'),(117,7749,40720,1525,2,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',9340.00,NULL,NULL,1,'2022-09-19 10:15:08','2022-09-20 11:08:00','2022-09-20 11:08:00');
INSERT INTO `balance_libro` VALUES (118,7749,40720,1525,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',1280.00,NULL,NULL,1,'2022-09-19 10:15:08','2022-09-20 11:08:00','2022-09-20 11:08:00'),(119,7749,40720,1525,2,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',7239.95,NULL,NULL,1,'2022-09-19 10:15:08','2022-09-20 11:08:00','2022-09-20 11:08:00'),(120,7749,40720,1525,2,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',1350.00,NULL,NULL,1,'2022-09-19 10:15:08','2022-09-20 11:08:00','2022-09-20 11:08:00'),(121,7749,40720,1525,2,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',8449.97,NULL,NULL,1,'2022-09-19 10:15:08','2022-09-20 11:08:00','2022-09-20 11:08:00'),(122,7749,40720,1525,2,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',8300.00,NULL,NULL,1,'2022-09-19 10:15:08','2022-09-20 11:08:00','2022-09-20 11:08:00'),(123,7749,40720,1525,2,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',1200.00,NULL,NULL,1,'2022-09-19 10:15:08','2022-09-20 11:08:00','2022-09-20 11:08:00'),(124,7749,40720,1525,2,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',12800.00,NULL,NULL,1,'2022-09-19 10:15:08','2022-09-20 11:08:00','2022-09-20 11:08:00'),(125,7749,40720,1525,2,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',11000.00,NULL,NULL,1,'2022-09-19 10:15:08','2022-09-20 11:08:00','2022-09-20 11:08:00'),(126,7749,40720,1525,2,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',400.00,NULL,NULL,1,'2022-09-19 10:15:08','2022-09-20 11:08:00','2022-09-20 11:08:00'),(127,7749,40720,1525,2,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',13730.00,NULL,NULL,1,'2022-09-19 10:15:08','2022-09-20 11:08:00','2022-09-20 11:08:00'),(128,7749,40720,1525,2,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',74300.30,NULL,NULL,1,'2022-09-19 10:15:09','2022-09-20 11:08:00','2022-09-20 11:08:00'),(129,7749,40720,1525,2,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',296999.34,NULL,NULL,1,'2022-09-19 10:15:09','2022-09-20 11:08:00','2022-09-20 11:08:00'),(130,7749,40720,1525,2,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',9350.00,NULL,NULL,1,'2022-09-19 10:15:09','2022-09-20 11:08:00','2022-09-20 11:08:00'),(131,7749,40720,1525,2,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',186599.90,NULL,NULL,1,'2022-09-19 10:15:09','2022-09-20 11:08:00','2022-09-20 11:08:00'),(132,7749,40720,1525,2,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',163999.78,NULL,NULL,1,'2022-09-19 10:15:09','2022-09-20 11:08:00','2022-09-20 11:08:00'),(133,7749,40720,1525,2,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',160600.00,NULL,NULL,1,'2022-09-19 10:15:09','2022-09-20 11:08:00','2022-09-20 11:08:00'),(134,7749,40720,1525,2,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',45750.00,NULL,NULL,1,'2022-09-19 10:15:09','2022-09-20 11:08:00','2022-09-20 11:08:00'),(135,7749,40720,1525,2,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',50100.00,NULL,NULL,1,'2022-09-19 10:15:09','2022-09-20 11:08:00','2022-09-20 11:08:00'),(136,7749,40720,1525,2,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',110499.99,NULL,NULL,1,'2022-09-19 10:15:09','2022-09-20 11:08:00','2022-09-20 11:08:00');
INSERT INTO `balance_libro` VALUES (137,7749,40720,1525,2,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',14300.00,NULL,NULL,1,'2022-09-19 10:15:09','2022-09-20 11:08:00','2022-09-20 11:08:00'),(138,7749,40720,1525,2,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',59199.93,NULL,NULL,1,'2022-09-19 10:15:09','2022-09-20 11:08:00','2022-09-20 11:08:00'),(139,7749,40720,1525,2,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',144319.99,NULL,NULL,1,'2022-09-19 10:15:09','2022-09-20 11:08:00','2022-09-20 11:08:00'),(140,7749,40720,1525,2,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',183400.00,NULL,NULL,1,'2022-09-19 10:15:09','2022-09-20 11:08:00','2022-09-20 11:08:00'),(141,7749,40720,1525,2,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',112140.00,NULL,NULL,1,'2022-09-19 10:15:09','2022-09-20 11:08:00','2022-09-20 11:08:00'),(142,7749,40720,1525,2,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',155500.00,NULL,NULL,1,'2022-09-19 10:15:09','2022-09-20 11:08:00','2022-09-20 11:08:00'),(143,7749,40720,1525,2,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',6800.00,NULL,NULL,1,'2022-09-19 10:15:09','2022-09-20 11:08:00','2022-09-20 11:08:00'),(144,7749,40720,1525,2,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',8650.00,NULL,NULL,1,'2022-09-19 10:15:09','2022-09-20 11:08:00','2022-09-20 11:08:00'),(145,7749,40720,1525,2,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',10329.99,NULL,NULL,1,'2022-09-19 10:15:10','2022-09-20 11:08:00','2022-09-20 11:08:00'),(146,7749,40720,1525,2,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',20239.99,NULL,NULL,1,'2022-09-19 10:15:10','2022-09-20 11:08:00','2022-09-20 11:08:00'),(147,7749,40720,1525,2,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',1950.00,NULL,NULL,1,'2022-09-19 10:15:10','2022-09-20 11:08:01','2022-09-20 11:08:01'),(148,7749,40720,1525,2,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',8950.00,NULL,NULL,1,'2022-09-19 10:15:10','2022-09-20 11:08:01','2022-09-20 11:08:01'),(149,7749,40720,1525,2,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',17639.99,NULL,NULL,1,'2022-09-19 10:15:10','2022-09-20 11:08:01','2022-09-20 11:08:01'),(150,7749,40720,1525,2,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',7000.00,NULL,NULL,1,'2022-09-19 10:15:10','2022-09-20 11:08:01','2022-09-20 11:08:01'),(151,7749,40720,1525,2,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',53899.99,NULL,NULL,1,'2022-09-19 10:15:10','2022-09-20 11:08:01','2022-09-20 11:08:01'),(152,7749,40720,1525,2,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',4680.00,NULL,NULL,1,'2022-09-19 10:15:10','2022-09-20 11:08:01','2022-09-20 11:08:01'),(153,7749,40720,1525,2,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',148600.34,NULL,NULL,1,'2022-09-19 10:15:10','2022-09-20 11:08:01','2022-09-20 11:08:01'),(154,7749,40720,1525,2,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',42000.00,NULL,NULL,1,'2022-09-19 10:15:10','2022-09-20 11:08:01','2022-09-20 11:08:01'),(155,7749,40720,1525,2,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',53999.99,NULL,NULL,1,'2022-09-19 10:15:10','2022-09-20 11:08:01','2022-09-20 11:08:01');
INSERT INTO `balance_libro` VALUES (156,7749,40720,1525,2,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',29799.88,NULL,NULL,1,'2022-09-19 10:15:10','2022-09-20 11:08:01','2022-09-20 11:08:01'),(157,7749,40720,1525,2,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',82000.01,NULL,NULL,1,'2022-09-19 10:15:10','2022-09-20 11:08:01','2022-09-20 11:08:01'),(158,7749,40720,1525,2,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',36049.96,NULL,NULL,1,'2022-09-19 10:15:10','2022-09-20 11:08:01','2022-09-20 11:08:01'),(159,7749,40720,1525,2,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',15600.00,NULL,NULL,1,'2022-09-19 10:15:10','2022-09-20 11:08:01','2022-09-20 11:08:01'),(160,7749,40720,1525,2,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',17000.00,NULL,NULL,1,'2022-09-19 10:15:10','2022-09-20 11:08:01','2022-09-20 11:08:01'),(161,7749,40720,1525,2,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',45500.00,NULL,NULL,1,'2022-09-19 10:15:10','2022-09-20 11:08:01','2022-09-20 11:08:01'),(162,7749,40720,1525,2,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',9850.00,NULL,NULL,1,'2022-09-19 10:15:11','2022-09-20 11:08:01','2022-09-20 11:08:01'),(163,7749,40720,1525,2,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',349.99,NULL,NULL,1,'2022-09-19 10:15:11','2022-09-20 11:08:01','2022-09-20 11:08:01'),(164,7749,40720,1525,2,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',10950.00,NULL,NULL,1,'2022-09-19 10:15:11','2022-09-20 11:08:01','2022-09-20 11:08:01'),(165,7749,40720,1525,2,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',200.00,NULL,NULL,1,'2022-09-19 10:15:11','2022-09-20 11:08:01','2022-09-20 11:08:01'),(166,7749,40720,1525,2,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',795.00,NULL,NULL,1,'2022-09-19 10:15:11','2022-09-20 11:08:01','2022-09-20 11:08:01'),(167,7749,40720,1525,2,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',43800.00,NULL,NULL,1,'2022-09-19 10:15:11','2022-09-20 11:08:01','2022-09-20 11:08:01'),(168,7749,40720,1525,2,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',250.00,NULL,NULL,1,'2022-09-19 10:15:11','2022-09-20 11:08:01','2022-09-20 11:08:01'),(169,7749,40720,1525,2,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',9750.01,NULL,NULL,1,'2022-09-19 10:15:11','2022-09-20 11:08:01','2022-09-20 11:08:01'),(170,7749,40720,1525,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',3080.00,NULL,NULL,1,'2022-09-19 10:15:11','2022-09-20 11:08:01','2022-09-20 11:08:01'),(171,7749,40720,1525,2,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',7340.00,NULL,NULL,1,'2022-09-19 10:15:11','2022-09-20 11:08:01','2022-09-20 11:08:01'),(172,7749,40720,1525,2,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',4460.00,NULL,NULL,1,'2022-09-19 10:15:11','2022-09-20 11:08:01','2022-09-20 11:08:01'),(173,7749,40720,1525,2,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',7950.00,NULL,NULL,1,'2022-09-19 10:15:11','2022-09-20 11:08:01','2022-09-20 11:08:01'),(174,7749,40720,1525,2,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',18752.79,NULL,NULL,1,'2022-09-19 10:15:11','2022-09-20 11:08:01','2022-09-20 11:08:01');
INSERT INTO `balance_libro` VALUES (175,7749,40720,1525,2,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',7200.00,NULL,NULL,1,'2022-09-19 10:15:11','2022-09-20 11:08:01','2022-09-20 11:08:01'),(176,7749,40720,1525,2,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',53999.88,NULL,NULL,1,'2022-09-19 10:15:11','2022-09-20 11:08:01','2022-09-20 11:08:01'),(177,7749,40720,1525,2,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',54000.02,NULL,NULL,1,'2022-09-19 10:15:11','2022-09-20 11:08:01','2022-09-20 11:08:01'),(178,7749,40720,1525,2,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',36049.96,NULL,NULL,1,'2022-09-19 10:15:11','2022-09-20 11:08:01','2022-09-20 11:08:01'),(179,7749,40720,1525,2,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',114149.97,NULL,NULL,1,'2022-09-19 10:15:11','2022-09-20 11:08:01','2022-09-20 11:08:01'),(180,7749,40720,1525,2,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',15600.00,NULL,NULL,1,'2022-09-19 10:15:12','2022-09-20 11:08:01','2022-09-20 11:08:01'),(181,7749,40720,1525,2,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',17000.00,NULL,NULL,1,'2022-09-19 10:15:12','2022-09-20 11:08:01','2022-09-20 11:08:01'),(182,7749,40720,1525,2,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',45500.00,NULL,NULL,1,'2022-09-19 10:15:12','2022-09-20 11:08:01','2022-09-20 11:08:01'),(183,7749,40720,1525,2,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',27770.00,NULL,NULL,1,'2022-09-19 10:15:12','2022-09-20 11:08:01','2022-09-20 11:08:01'),(184,7749,40720,1525,2,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',220500.01,NULL,NULL,1,'2022-09-19 10:15:12','2022-09-20 11:08:01','2022-09-20 11:08:01'),(185,7749,40720,1525,2,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',7600.00,NULL,NULL,1,'2022-09-19 10:15:12','2022-09-20 11:08:01','2022-09-20 11:08:01'),(186,7749,40720,1525,2,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',6000.00,NULL,NULL,1,'2022-09-19 10:15:12','2022-09-20 11:08:01','2022-09-20 11:08:01'),(187,7749,40720,1525,2,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',2000.00,NULL,NULL,1,'2022-09-19 10:15:12','2022-09-20 11:08:01','2022-09-20 11:08:01'),(188,7749,40720,1525,2,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',34890.00,NULL,NULL,1,'2022-09-19 10:15:12','2022-09-20 11:08:01','2022-09-20 11:08:01'),(189,7749,40720,1525,2,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',31999.72,NULL,NULL,1,'2022-09-19 10:15:12','2022-09-20 11:08:01','2022-09-20 11:08:01'),(190,7749,40720,1525,2,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',5200.00,NULL,NULL,1,'2022-09-19 10:15:13','2022-09-20 11:08:01','2022-09-20 11:08:01'),(191,7749,40720,1525,2,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',2200.00,NULL,NULL,1,'2022-09-19 10:15:13','2022-09-20 11:08:01','2022-09-20 11:08:01'),(192,7749,40720,1525,2,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',6800.00,NULL,NULL,1,'2022-09-19 10:15:13','2022-09-20 11:08:01','2022-09-20 11:08:01'),(193,7749,40720,1525,2,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',7000.00,NULL,NULL,1,'2022-09-19 10:15:13','2022-09-20 11:08:01','2022-09-20 11:08:01');
INSERT INTO `balance_libro` VALUES (194,7749,40720,1525,2,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',7600.00,NULL,NULL,1,'2022-09-19 10:15:13','2022-09-20 11:08:01','2022-09-20 11:08:01'),(195,7749,40720,1525,2,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',49329.97,NULL,NULL,1,'2022-09-19 10:15:13','2022-09-20 11:08:01','2022-09-20 11:08:01'),(196,7749,40720,1525,2,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',5000.00,NULL,NULL,1,'2022-09-19 10:15:13','2022-09-20 11:08:01','2022-09-20 11:08:01'),(197,7749,40720,1525,2,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',860.02,NULL,NULL,1,'2022-09-19 10:16:37','2022-09-20 11:08:02','2022-09-20 11:08:02'),(198,7749,40720,1525,2,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',4779.96,NULL,NULL,1,'2022-09-19 10:16:37','2022-09-20 11:08:02','2022-09-20 11:08:02'),(199,7749,40720,1525,2,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',4310.02,NULL,NULL,1,'2022-09-19 10:16:37','2022-09-20 11:08:02','2022-09-20 11:08:02'),(200,7749,40720,1525,2,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',3250.00,NULL,NULL,1,'2022-09-19 10:16:37','2022-09-20 11:08:02','2022-09-20 11:08:02'),(201,7749,40720,1525,2,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',15340.03,NULL,NULL,1,'2022-09-19 10:16:37','2022-09-20 11:08:02','2022-09-20 11:08:02'),(202,7749,40720,1525,2,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',95109.98,NULL,NULL,1,'2022-09-19 10:16:37','2022-09-20 11:08:02','2022-09-20 11:08:02'),(203,7749,40720,1525,2,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-14','2022-08-14',4750.00,NULL,NULL,1,'2022-09-19 10:16:37','2022-09-20 11:08:02','2022-09-20 11:08:02'),(204,7749,40720,1525,2,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',3949.96,NULL,NULL,1,'2022-09-19 10:17:00','2022-09-20 11:08:02','2022-09-20 11:08:02'),(205,7749,40720,1525,2,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',3199.99,NULL,NULL,1,'2022-09-19 10:17:00','2022-09-20 11:08:02','2022-09-20 11:08:02'),(206,7749,40720,1525,2,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',10200.01,NULL,NULL,1,'2022-09-19 10:17:00','2022-09-20 11:08:02','2022-09-20 11:08:02'),(207,7749,40720,1525,2,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',7450.03,NULL,NULL,1,'2022-09-19 10:17:00','2022-09-20 11:08:02','2022-09-20 11:08:02'),(208,7749,40720,1525,2,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',7699.98,NULL,NULL,1,'2022-09-19 10:17:00','2022-09-20 11:08:02','2022-09-20 11:08:02'),(209,7749,40720,1525,2,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',9600.02,NULL,NULL,1,'2022-09-19 10:17:00','2022-09-20 11:08:02','2022-09-20 11:08:02'),(210,7749,40720,1525,2,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',52500.00,NULL,NULL,1,'2022-09-19 10:17:38','2022-09-19 10:27:13','2022-09-19 10:27:13'),(211,7749,40720,1525,2,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',3999.97,NULL,NULL,1,'2022-09-19 10:17:38','2022-09-19 10:27:42','2022-09-19 10:27:42'),(212,7749,40720,1525,2,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',11669.99,NULL,NULL,1,'2022-09-19 10:17:38','2022-09-19 10:27:23','2022-09-19 10:27:23');
INSERT INTO `balance_libro` VALUES (213,7749,40720,1525,2,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',8720.01,NULL,NULL,1,'2022-09-19 10:17:38','2022-09-19 10:27:55','2022-09-19 10:27:55'),(214,7749,40720,1525,2,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',2115.02,NULL,NULL,1,'2022-09-19 10:17:38','2022-09-19 10:26:59','2022-09-19 10:26:59'),(215,7749,40720,1525,2,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',9830.04,NULL,NULL,1,'2022-09-19 10:17:38','2022-09-19 10:26:45','2022-09-19 10:26:45'),(216,7749,40720,1525,2,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',9120.00,NULL,NULL,1,'2022-09-19 10:17:38','2022-09-19 10:26:32','2022-09-19 10:26:32'),(217,7749,40720,1525,2,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7710.00,NULL,NULL,1,'2022-09-19 10:17:38','2022-09-19 10:26:13','2022-09-19 10:26:13'),(218,7749,40720,1525,2,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',6400.04,NULL,NULL,1,'2022-09-19 10:17:39','2022-09-19 10:25:37','2022-09-19 10:25:37'),(219,7749,40720,1525,2,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',24659.97,NULL,NULL,1,'2022-09-19 10:17:39','2022-09-19 10:25:17','2022-09-19 10:25:17'),(220,7749,40720,1525,2,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',4080.00,NULL,NULL,1,'2022-09-19 10:17:53','2022-09-20 11:08:02','2022-09-20 11:08:02'),(221,7749,40720,1525,2,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',62760.22,NULL,NULL,1,'2022-09-19 10:17:53','2022-09-20 11:08:02','2022-09-20 11:08:02'),(222,7749,40720,1525,2,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',18510.00,NULL,NULL,1,'2022-09-19 10:17:53','2022-09-20 11:08:02','2022-09-20 11:08:02'),(223,7749,40720,1525,2,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',4899.98,NULL,NULL,1,'2022-09-19 10:17:53','2022-09-20 11:08:02','2022-09-20 11:08:02'),(224,7749,40720,1525,2,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',10009.98,NULL,NULL,1,'2022-09-19 10:17:53','2022-09-20 11:08:02','2022-09-20 11:08:02'),(225,7749,40720,1525,2,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',6499.95,NULL,NULL,1,'2022-09-19 10:17:53','2022-09-20 11:08:02','2022-09-20 11:08:02'),(226,7749,40720,1525,2,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',77363.83,NULL,NULL,1,'2022-09-19 10:18:08','2022-09-20 11:08:02','2022-09-20 11:08:02'),(227,7749,40720,1525,2,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',87574.84,NULL,NULL,1,'2022-09-19 10:18:08','2022-09-20 11:08:02','2022-09-20 11:08:02'),(228,7749,40720,1525,2,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',5540.01,NULL,NULL,1,'2022-09-19 10:18:08','2022-09-20 11:08:02','2022-09-20 11:08:02'),(229,7749,40720,1525,2,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',6900.00,NULL,NULL,1,'2022-09-19 10:18:08','2022-09-20 11:08:02','2022-09-20 11:08:02'),(230,7749,40720,1525,2,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',20390.06,NULL,NULL,1,'2022-09-19 10:18:08','2022-09-20 11:08:02','2022-09-20 11:08:02'),(231,7749,40720,1525,2,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',8050.01,NULL,NULL,1,'2022-09-19 10:18:08','2022-09-20 11:08:02','2022-09-20 11:08:02');
INSERT INTO `balance_libro` VALUES (232,7749,40720,1525,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-28','2022-08-28',14110.04,NULL,NULL,1,'2022-09-19 10:18:08','2022-09-20 11:08:02','2022-09-20 11:08:02'),(233,7749,40720,1525,2,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',14469.93,NULL,NULL,1,'2022-09-19 10:18:08','2022-09-20 11:08:02','2022-09-20 11:08:02'),(234,7749,40720,1525,2,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',3300.02,NULL,NULL,1,'2022-09-19 10:18:08','2022-09-20 11:08:02','2022-09-20 11:08:02'),(235,7749,40720,1525,2,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',4019.97,NULL,NULL,1,'2022-09-19 10:18:08','2022-09-20 11:08:02','2022-09-20 11:08:02'),(236,7749,40720,1525,2,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2100.00,NULL,NULL,1,'2022-09-19 10:35:33','2022-09-20 11:08:02','2022-09-20 11:08:02'),(237,7749,40720,1525,2,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',1000.00,NULL,NULL,1,'2022-09-19 10:35:33','2022-09-20 11:08:02','2022-09-20 11:08:02'),(238,7749,40720,1525,2,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',850.00,NULL,NULL,1,'2022-09-19 10:35:33','2022-09-20 11:08:02','2022-09-20 11:08:02'),(239,7749,40720,1525,2,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',3200.00,NULL,NULL,1,'2022-09-19 10:35:33','2022-09-20 11:08:02','2022-09-20 11:08:02'),(240,7749,40720,1525,2,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',2700.06,NULL,NULL,1,'2022-09-19 10:35:33','2022-09-20 11:08:02','2022-09-20 11:08:02'),(241,7749,40720,1525,2,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',7500.00,NULL,NULL,1,'2022-09-19 10:35:33','2022-09-20 11:08:02','2022-09-20 11:08:02'),(242,7749,40720,1525,2,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',2700.06,NULL,NULL,1,'2022-09-19 10:35:33','2022-09-20 11:08:02','2022-09-20 11:08:02'),(243,7749,40720,1525,2,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',4000.00,NULL,NULL,1,'2022-09-19 10:35:33','2022-09-20 11:08:02','2022-09-20 11:08:02'),(244,7749,40720,1525,2,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',750.06,NULL,NULL,1,'2022-09-19 10:35:33','2022-09-20 11:08:02','2022-09-20 11:08:02'),(245,7749,40720,1525,2,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',5800.00,NULL,NULL,1,'2022-09-19 10:35:33','2022-09-20 11:08:02','2022-09-20 11:08:02'),(246,7749,40720,1525,2,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',1900.00,NULL,NULL,1,'2022-09-19 10:35:33','2022-09-20 11:08:02','2022-09-20 11:08:02'),(247,7749,40720,1525,2,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',9600.04,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(248,7749,40720,1525,2,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',1450.00,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(249,7749,40720,1525,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',3330.00,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(250,7749,40720,1525,2,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',1300.00,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02');
INSERT INTO `balance_libro` VALUES (251,7749,40720,1525,2,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',3010.04,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(252,7749,40720,1525,2,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',3250.00,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(253,7749,40720,1525,2,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',2100.00,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(254,7749,40720,1525,2,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',950.04,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(255,7749,40720,1525,2,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',880.04,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(256,7749,40720,1525,2,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',11410.02,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(257,7749,40720,1525,2,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-14','2022-08-14',4750.00,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(258,7749,40720,1525,2,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',4080.00,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(259,7749,40720,1525,2,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',6910.04,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(260,7749,40720,1525,2,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',11600.00,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(261,7749,40720,1525,2,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',1300.00,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(262,7749,40720,1525,2,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',3600.00,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(263,7749,40720,1525,2,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',960.00,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(264,7749,40720,1525,2,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',9050.00,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(265,7749,40720,1525,2,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',1000.00,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(266,7749,40720,1525,2,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',3000.00,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(267,7749,40720,1525,2,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',2500.00,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(268,7749,40720,1525,2,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',1700.00,NULL,NULL,1,'2022-09-19 10:35:34','2022-09-20 11:08:02','2022-09-20 11:08:02'),(269,7749,40720,1525,2,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',3840.04,NULL,NULL,1,'2022-09-19 10:35:35','2022-09-20 11:08:02','2022-09-20 11:08:02');
INSERT INTO `balance_libro` VALUES (270,7749,40720,1525,2,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',6900.00,NULL,NULL,1,'2022-09-19 10:35:35','2022-09-20 11:08:02','2022-09-20 11:08:02'),(271,7749,40720,1525,2,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',3500.02,NULL,NULL,1,'2022-09-19 10:35:35','2022-09-20 11:08:03','2022-09-20 11:08:03'),(272,7749,40720,1525,2,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',6890.06,NULL,NULL,1,'2022-09-19 10:35:35','2022-09-20 11:08:03','2022-09-20 11:08:03'),(273,7749,40720,1525,2,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',10000.04,NULL,NULL,1,'2022-09-19 10:35:35','2022-09-20 11:08:03','2022-09-20 11:08:03'),(274,7749,40720,1525,2,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',3050.02,NULL,NULL,1,'2022-09-19 10:35:35','2022-09-20 11:08:03','2022-09-20 11:08:03'),(275,7749,40720,1525,2,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',3900.00,NULL,NULL,1,'2022-09-19 10:35:35','2022-09-20 11:08:03','2022-09-20 11:08:03'),(276,7749,40720,1525,2,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',1100.02,NULL,NULL,1,'2022-09-19 10:35:35','2022-09-20 11:08:03','2022-09-20 11:08:03'),(277,7749,40720,1525,2,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',820.00,NULL,NULL,1,'2022-09-19 10:35:35','2022-09-20 11:08:03','2022-09-20 11:08:03'),(278,7749,40720,1525,2,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',9090.00,NULL,NULL,1,'2022-09-19 10:35:35','2022-09-20 11:08:03','2022-09-20 11:08:03'),(279,7749,40720,1525,2,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',4560.00,NULL,NULL,1,'2022-09-19 10:35:35','2022-09-20 11:08:03','2022-09-20 11:08:03'),(280,7749,40720,1525,2,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',3590.02,NULL,NULL,1,'2022-09-19 10:35:35','2022-09-20 11:08:03','2022-09-20 11:08:03'),(281,7749,40720,1526,2,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',317354.40,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(282,7749,40720,1526,2,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',447000.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(283,7749,40720,1526,2,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',317354.40,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(284,7749,40720,1526,2,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',20700.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(285,7749,40720,1526,2,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',63900.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(286,7749,40720,1526,2,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',5000.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(287,7749,40720,1526,2,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',17280.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(288,7749,40720,1526,2,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',500.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(289,7749,40720,1526,2,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1600.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL);
INSERT INTO `balance_libro` VALUES (290,7749,40720,1526,2,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1000.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(291,7749,40720,1526,2,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',10700.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(292,7749,40720,1526,2,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',3650.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(293,7749,40720,1526,2,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1500.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(294,7749,40720,1526,2,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',400.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(295,7749,40720,1526,2,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',8750.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(296,7749,40720,1526,2,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',9500.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(297,7749,40720,1526,2,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',4750.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(298,7749,40720,1526,2,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',16850.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(299,7749,40720,1526,2,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',11200.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(300,7749,40720,1526,2,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',450.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(301,7749,40720,1526,2,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',5000.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(302,7749,40720,1526,2,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',2800.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(303,7749,40720,1526,2,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',4250.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(304,7749,40720,1526,2,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',200.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(305,7749,40720,1526,2,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',900.00,NULL,NULL,1,'2022-09-27 09:36:11','2022-09-27 09:36:11',NULL),(306,7749,40720,1526,2,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',9850.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(307,7749,40720,1526,2,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',300.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(308,7749,40720,1526,2,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',3100.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(309,7749,40720,1526,2,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',2700.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(310,7749,40720,1526,2,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1600.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL);
INSERT INTO `balance_libro` VALUES (311,7749,40720,1526,2,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',2600.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(312,7749,40720,1526,2,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',17640.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(313,7749,40720,1526,2,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',5250.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(314,7749,40720,1526,2,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1800.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(315,7749,40720,1526,2,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',4700.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(316,7749,40720,1526,2,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',45000.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(317,7749,40720,1526,2,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',16650.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(318,7749,40720,1526,2,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',14820.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(319,7749,40720,1526,2,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',13890.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(320,7749,40720,1526,2,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',3400.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(321,7749,40720,1526,2,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',33099.99,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(322,7749,40720,1526,2,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',23298.11,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(323,7749,40720,1526,2,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',700.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(324,7749,40720,1526,2,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',500.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(325,7749,40720,1526,2,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',4450.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(326,7749,40720,1526,2,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',4700.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(327,7749,40720,1526,2,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',8450.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(328,7749,40720,1526,2,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',7800.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(329,7749,40720,1526,2,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',2600.00,NULL,NULL,1,'2022-09-27 09:36:12','2022-09-27 09:36:12',NULL),(330,7749,40720,1526,2,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',6200.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(331,7749,40720,1526,2,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',29660.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL);
INSERT INTO `balance_libro` VALUES (332,7749,40720,1526,2,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',130029.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(333,7749,40720,1526,2,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',9000.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(334,7749,40720,1526,2,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',97409.99,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(335,7749,40720,1526,2,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',245300.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(336,7749,40720,1526,2,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',272000.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(337,7749,40720,1526,2,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',278000.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(338,7749,40720,1526,2,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',109300.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(339,7749,40720,1526,2,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',8420.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(340,7749,40720,1526,2,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',9700.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(341,7749,40720,1526,2,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',1380.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(342,7749,40720,1526,2,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',5200.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(343,7749,40720,1526,2,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',3700.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(344,7749,40720,1526,2,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',4760.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(345,7749,40720,1526,2,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',6450.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(346,7749,40720,1526,2,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',3040.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(347,7749,40720,1526,2,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',25000.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(348,7749,40720,1526,2,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',227749.99,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(349,7749,40720,1526,2,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',278000.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(350,7749,40720,1526,2,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',41200.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(351,7749,40720,1526,2,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',3000.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(352,7749,40720,1526,2,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',60000.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL);
INSERT INTO `balance_libro` VALUES (353,7749,40720,1526,2,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',60000.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(354,7749,40720,1526,2,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',35000.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(355,7749,40720,1526,2,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',17400.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(356,7749,40720,1526,2,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',8280.00,NULL,NULL,1,'2022-09-27 09:36:13','2022-09-27 09:36:13',NULL),(357,7749,40720,1526,2,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',42200.00,NULL,NULL,1,'2022-09-27 09:36:14','2022-09-27 09:36:14',NULL),(358,7749,40720,1526,2,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',70999.92,NULL,NULL,1,'2022-09-27 09:36:14','2022-09-27 09:36:14',NULL),(359,7749,40720,1526,2,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',16200.00,NULL,NULL,1,'2022-09-27 09:36:14','2022-09-27 09:36:14',NULL),(360,7749,40720,1526,2,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',44999.97,NULL,NULL,1,'2022-09-27 09:36:14','2022-09-27 09:36:14',NULL),(361,7749,40720,1526,2,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',4500.00,NULL,NULL,1,'2022-09-27 09:36:14','2022-09-27 09:36:14',NULL),(362,7749,40720,1526,2,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',4080.00,NULL,NULL,1,'2022-09-27 09:36:14','2022-09-27 09:36:14',NULL),(363,7749,40720,1526,2,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',123178.00,NULL,NULL,1,'2022-09-27 09:36:14','2022-09-27 09:36:14',NULL),(364,7749,40720,1526,2,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',23824.90,NULL,NULL,1,'2022-09-27 09:36:14','2022-09-27 09:36:14',NULL),(365,7749,40720,1526,2,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',16200.00,NULL,NULL,1,'2022-09-27 09:36:14','2022-09-27 09:36:14',NULL),(366,7749,40720,1526,2,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',16200.00,NULL,NULL,1,'2022-09-27 09:36:14','2022-09-27 09:36:14',NULL),(367,7749,40720,1526,2,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',7500.00,NULL,NULL,1,'2022-09-27 09:36:14','2022-09-27 09:36:14',NULL),(368,7749,40720,1526,2,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',46599.99,NULL,NULL,1,'2022-09-27 09:36:14','2022-09-27 09:36:14',NULL),(369,7749,40720,1526,2,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',95039.78,NULL,NULL,1,'2022-09-27 09:36:14','2022-09-27 09:36:14',NULL),(370,7749,40720,1526,2,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',75359.97,NULL,NULL,1,'2022-09-27 09:36:14','2022-09-27 09:36:14',NULL),(371,7749,40720,1526,2,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',7500.00,NULL,NULL,1,'2022-09-27 09:36:14','2022-09-27 09:36:14',NULL),(372,7749,40720,1526,2,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',14400.00,NULL,NULL,1,'2022-09-27 09:36:14','2022-09-27 09:36:14',NULL),(373,7749,40720,1526,2,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',5900.00,NULL,NULL,1,'2022-09-27 09:36:14','2022-09-27 09:36:14',NULL);
INSERT INTO `balance_libro` VALUES (374,7749,40720,1526,2,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',19999.97,NULL,NULL,1,'2022-09-27 09:36:14','2022-09-27 09:36:14',NULL),(375,7749,40720,1526,2,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',52750.00,NULL,NULL,1,'2022-09-27 09:36:15','2022-09-27 09:36:15',NULL),(376,7749,40720,1526,2,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',169800.00,NULL,NULL,1,'2022-09-27 09:36:15','2022-09-27 09:36:15',NULL),(377,7749,40720,1526,2,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',155400.00,NULL,NULL,1,'2022-09-27 09:36:15','2022-09-27 09:36:15',NULL),(378,7749,40720,1526,2,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',293200.00,NULL,NULL,1,'2022-09-27 09:36:15','2022-09-27 09:36:15',NULL),(379,7749,40720,1526,2,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',136000.00,NULL,NULL,1,'2022-09-27 09:36:15','2022-09-27 09:36:15',NULL),(380,7749,40720,1526,2,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',110000.00,NULL,NULL,1,'2022-09-27 09:36:16','2022-09-27 09:36:16',NULL),(381,7749,40720,1526,2,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',100000.00,NULL,NULL,1,'2022-09-27 09:36:16','2022-09-27 09:36:16',NULL),(382,7749,40720,1526,2,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',100000.00,NULL,NULL,1,'2022-09-27 09:36:16','2022-09-27 09:36:16',NULL),(383,7749,40720,1526,2,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',367455.00,NULL,NULL,1,'2022-09-27 09:36:16','2022-09-27 09:36:16',NULL),(384,7749,40720,1526,2,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',599.99,NULL,NULL,1,'2022-09-27 09:37:24','2022-09-27 09:37:24',NULL),(385,7749,40720,1526,2,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',10000.02,NULL,NULL,1,'2022-09-27 09:37:24','2022-10-11 11:41:58','2022-10-11 11:41:58'),(386,7749,40720,1526,2,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',7270.03,NULL,NULL,1,'2022-09-27 09:37:24','2022-10-11 11:42:42','2022-10-11 11:42:42'),(387,7749,40720,1526,2,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',10540.02,NULL,NULL,1,'2022-09-27 09:37:24','2022-09-27 09:37:24',NULL),(388,7749,40720,1526,2,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',16970.02,NULL,NULL,1,'2022-09-27 09:37:24','2022-10-11 11:43:44','2022-10-11 11:43:44'),(389,7749,40720,1526,2,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',3949.96,NULL,NULL,1,'2022-09-27 09:37:24','2022-10-11 11:44:16','2022-10-11 11:44:16'),(390,7749,40720,1526,2,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',49770.07,NULL,NULL,1,'2022-09-27 09:37:24','2022-09-27 09:37:24',NULL),(391,7749,40720,1526,2,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',58360.09,NULL,NULL,1,'2022-09-27 09:38:17','2022-09-27 09:38:17',NULL),(392,7749,40720,1526,2,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',14889.97,NULL,NULL,1,'2022-09-27 09:38:17','2022-10-11 11:44:54','2022-10-11 11:44:54'),(393,7749,40720,1526,2,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',25649.98,NULL,NULL,1,'2022-09-27 09:38:17','2022-10-11 11:45:12','2022-10-11 11:45:12');
INSERT INTO `balance_libro` VALUES (394,7749,40720,1526,2,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-11','2022-09-11',2099.98,NULL,NULL,1,'2022-09-27 09:38:17','2022-10-11 11:45:31','2022-10-11 11:45:31'),(395,7749,40720,1526,2,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',5600.00,NULL,NULL,1,'2022-09-27 09:38:17','2022-10-11 11:45:52','2022-10-11 11:45:52'),(396,7749,40720,1526,2,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',4229.99,NULL,NULL,1,'2022-09-27 09:38:17','2022-09-27 09:38:17',NULL),(397,7749,40720,1526,2,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',39579.96,NULL,NULL,1,'2022-09-27 09:38:17','2022-10-11 11:46:48','2022-10-11 11:46:48'),(398,7749,40720,1526,2,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',12149.96,NULL,NULL,1,'2022-09-27 09:38:30','2022-10-11 11:47:08','2022-10-11 11:47:08'),(399,7749,40720,1526,2,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',5900.02,NULL,NULL,1,'2022-09-27 09:38:31','2022-09-27 09:38:31',NULL),(400,7749,40720,1526,2,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',7479.99,NULL,NULL,1,'2022-09-27 09:38:31','2022-09-27 09:38:31',NULL),(401,7749,40720,1526,2,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',8860.08,NULL,NULL,1,'2022-09-27 09:38:31','2022-09-27 09:38:31',NULL),(402,7749,40720,1526,2,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',11050.01,NULL,NULL,1,'2022-09-27 09:38:31','2022-10-11 11:48:00','2022-10-11 11:48:00'),(403,7749,40720,1526,2,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',14700.00,NULL,NULL,1,'2022-09-27 09:38:31','2022-10-11 11:48:19','2022-10-11 11:48:19'),(404,7749,40720,1526,2,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',19930.03,NULL,NULL,1,'2022-09-27 09:38:31','2022-10-11 11:48:41','2022-10-11 11:48:41'),(405,7749,40720,1526,2,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',10000.02,NULL,NULL,1,'2022-09-27 09:38:56','2022-09-27 09:38:56',NULL),(406,7749,40720,1526,2,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',4370.00,NULL,NULL,1,'2022-09-27 09:38:56','2022-09-27 09:38:56',NULL),(407,7749,40720,1526,2,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',2900.02,NULL,NULL,1,'2022-09-27 09:38:56','2022-09-27 09:38:56',NULL),(408,7749,40720,1526,2,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',10600.00,NULL,NULL,1,'2022-09-27 09:38:56','2022-09-27 09:38:56',NULL),(409,7749,40720,1526,2,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',3880.01,NULL,NULL,1,'2022-09-27 09:38:56','2022-09-27 09:38:56',NULL),(410,7749,40720,1526,2,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',1190.01,NULL,NULL,1,'2022-09-27 09:38:56','2022-09-27 09:38:56',NULL),(411,7749,40720,1526,2,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',1300.00,NULL,NULL,1,'2022-09-27 09:38:56','2022-09-27 09:38:56',NULL),(412,7749,40720,1526,2,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',2099.98,NULL,NULL,1,'2022-09-27 09:38:56','2022-09-27 09:38:56',NULL),(413,7749,40720,1526,2,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',1049.99,NULL,NULL,1,'2022-09-27 09:38:56','2022-09-27 09:38:56',NULL);
INSERT INTO `balance_libro` VALUES (414,7749,40720,1526,2,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',799.98,NULL,NULL,1,'2022-09-27 09:38:56','2022-09-27 09:38:56',NULL),(415,7749,40720,1526,2,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',990.01,NULL,NULL,1,'2022-09-27 09:39:05','2022-09-27 09:39:05',NULL),(416,7749,40720,1526,2,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',2400.01,NULL,NULL,1,'2022-09-27 09:39:06','2022-09-27 09:39:06',NULL),(417,7749,40720,1526,2,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',9399.97,NULL,NULL,1,'2022-09-27 09:39:06','2022-09-27 09:39:06',NULL),(418,7749,40720,1526,2,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',2099.98,NULL,NULL,1,'2022-09-27 09:39:06','2022-09-27 09:39:06',NULL),(419,7749,40720,1526,2,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',24999.98,NULL,NULL,1,'2022-09-27 09:39:06','2022-09-27 09:39:06',NULL),(420,7749,40720,1526,2,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',650.00,NULL,NULL,1,'2022-09-27 09:39:06','2022-09-27 09:39:06',NULL),(421,7749,40720,1526,2,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-11','2022-09-11',2099.98,NULL,NULL,1,'2022-09-27 09:39:06','2022-09-27 09:39:06',NULL),(422,7749,40720,1526,2,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',5600.00,NULL,NULL,1,'2022-09-27 09:39:06','2022-09-27 09:39:06',NULL),(423,7749,40720,1526,2,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',1449.98,NULL,NULL,1,'2022-09-27 09:39:06','2022-09-27 09:39:06',NULL),(424,7749,40720,1526,2,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',4600.02,NULL,NULL,1,'2022-09-27 09:39:06','2022-09-27 09:39:06',NULL),(425,7749,40720,1526,2,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',1519.99,NULL,NULL,1,'2022-09-27 09:39:06','2022-09-27 09:39:06',NULL),(426,7749,40720,1526,2,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',2999.99,NULL,NULL,1,'2022-09-27 09:39:06','2022-09-27 09:39:06',NULL),(427,7749,40720,1526,2,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',14199.98,NULL,NULL,1,'2022-09-27 09:39:06','2022-09-27 09:39:06',NULL),(428,7749,40720,1526,2,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',999.98,NULL,NULL,1,'2022-09-27 09:39:06','2022-09-27 09:39:06',NULL),(429,7749,40720,1526,2,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',4879.99,NULL,NULL,1,'2022-09-27 09:39:06','2022-09-27 09:39:06',NULL),(430,7749,40720,1526,2,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',28499.99,NULL,NULL,1,'2022-09-27 09:39:06','2022-09-27 09:39:06',NULL),(431,7749,40720,1526,2,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',3399.98,NULL,NULL,1,'2022-09-27 09:39:06','2022-09-27 09:39:06',NULL),(432,7749,40720,1526,2,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',1800.02,NULL,NULL,1,'2022-09-27 09:39:06','2022-09-27 09:39:06',NULL),(433,7749,40720,1526,2,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',2999.99,NULL,NULL,1,'2022-09-27 09:39:22','2022-09-27 09:39:22',NULL),(434,7749,40720,1526,2,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',2949.98,NULL,NULL,1,'2022-09-27 09:39:22','2022-09-27 09:39:22',NULL);
INSERT INTO `balance_libro` VALUES (435,7749,40720,1526,2,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',6199.98,NULL,NULL,1,'2022-09-27 09:39:22','2022-09-27 09:39:22',NULL),(436,7749,40720,1526,2,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',2700.03,NULL,NULL,1,'2022-09-27 09:39:22','2022-09-27 09:39:22',NULL),(437,7749,40720,1526,2,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',4400.02,NULL,NULL,1,'2022-09-27 09:39:22','2022-09-27 09:39:22',NULL),(438,7749,40720,1526,2,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',5600.00,NULL,NULL,1,'2022-09-27 09:39:22','2022-09-27 09:39:22',NULL),(439,7749,40720,1526,2,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',399.99,NULL,NULL,1,'2022-09-27 09:39:22','2022-09-27 09:39:22',NULL),(440,7749,40720,1526,2,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',5050.02,NULL,NULL,1,'2022-09-27 09:39:22','2022-09-27 09:39:22',NULL),(441,7749,40720,1526,2,441,'App\\Models\\Receipt',441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',12249.98,NULL,NULL,1,'2022-09-27 09:39:22','2022-09-27 09:39:22',NULL),(442,7749,40720,1526,2,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',850.00,NULL,NULL,1,'2022-09-27 09:39:22','2022-09-27 09:39:22',NULL),(443,7749,40720,1526,2,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',1600.02,NULL,NULL,1,'2022-09-27 09:39:22','2022-09-27 09:39:22',NULL),(444,7749,40720,1526,2,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',11880.01,NULL,NULL,1,'2022-09-27 09:39:22','2022-09-27 09:39:22',NULL),(445,7749,40720,1526,2,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',2850.01,NULL,NULL,1,'2022-09-27 09:39:22','2022-09-27 09:39:22',NULL),(446,7749,40720,1526,2,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',2999.99,NULL,NULL,1,'2022-09-27 09:39:22','2022-09-27 09:39:22',NULL),(447,7749,40720,1526,2,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',1899.99,NULL,NULL,1,'2022-09-27 09:39:22','2022-09-27 09:39:22',NULL),(448,7749,40720,1526,2,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',300.02,NULL,NULL,1,'2022-09-27 09:39:22','2022-09-27 09:39:22',NULL),(449,7749,40720,1526,2,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',57020.00,NULL,NULL,1,'2022-09-27 11:49:18','2022-09-27 11:49:18',NULL),(450,7749,40720,1526,2,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',129030.00,NULL,NULL,1,'2022-09-27 11:50:16','2022-09-27 11:50:16',NULL),(451,7749,40720,1526,2,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',71440.00,NULL,NULL,1,'2022-09-27 11:50:55','2022-09-27 11:50:55',NULL),(452,7749,40720,1526,2,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',111885.00,NULL,NULL,1,'2022-09-27 11:51:24','2022-09-27 11:51:24',NULL),(453,7749,40720,1526,3,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',82514.90,NULL,NULL,1,'2022-09-27 12:09:07','2022-09-27 12:09:07',NULL),(454,7749,40720,1526,3,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',73895.39,NULL,NULL,1,'2022-09-27 12:09:07','2022-09-27 12:09:07',NULL),(455,7749,40720,1526,3,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',1972.91,NULL,NULL,1,'2022-09-27 12:09:07','2022-09-27 12:09:07',NULL);
INSERT INTO `balance_libro` VALUES (456,7749,40720,1526,3,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',4456.19,NULL,NULL,1,'2022-09-27 12:09:07','2022-09-27 12:09:07',NULL),(457,7749,40720,1526,3,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',45817.34,NULL,NULL,1,'2022-09-27 12:09:07','2022-09-27 12:09:07',NULL),(458,7749,40720,1526,3,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',203564.62,NULL,NULL,1,'2022-09-27 12:09:07','2022-09-27 12:09:07',NULL),(459,7749,40720,1526,3,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',154078.06,NULL,NULL,1,'2022-09-27 12:09:07','2022-10-11 12:28:32','2022-10-11 12:28:32'),(460,7749,40720,1526,3,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',114287.70,NULL,NULL,1,'2022-09-27 12:09:07','2022-10-11 12:29:09','2022-10-11 12:29:09'),(461,7749,40720,1526,3,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',7814.38,NULL,NULL,1,'2022-09-27 12:09:07','2022-10-11 12:30:25','2022-10-11 12:30:25'),(462,7749,40720,1526,3,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',18445.28,NULL,NULL,1,'2022-09-27 12:09:07','2022-10-13 10:36:15','2022-10-13 10:36:15'),(463,7749,40720,1526,3,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',194328.87,NULL,NULL,1,'2022-09-27 12:09:07','2022-10-18 09:42:13','2022-10-18 09:42:13'),(464,7749,40720,1526,3,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',75591.48,NULL,NULL,1,'2022-09-27 12:09:07','2022-10-18 09:44:20','2022-10-18 09:44:20'),(465,7749,40720,1526,3,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',6197.84,NULL,NULL,1,'2022-09-27 12:09:07','2022-09-27 12:09:07',NULL),(466,7749,40720,1526,3,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',25864.10,NULL,NULL,1,'2022-09-27 12:09:07','2022-09-27 12:09:07',NULL),(467,7749,40720,1526,3,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',6850.04,NULL,NULL,1,'2022-09-27 12:09:07','2022-09-27 12:09:07',NULL),(468,7749,40720,1526,3,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',51589.54,NULL,NULL,1,'2022-09-27 12:09:07','2022-10-17 11:28:31','2022-10-17 11:28:31'),(469,7749,40720,1526,3,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',3537.75,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL),(470,7749,40720,1526,3,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',37837.64,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL),(471,7749,40720,1526,3,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',34915.68,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL),(472,7749,40720,1526,3,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',127701.83,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL),(473,7749,40720,1526,3,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',38513.88,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL),(474,7749,40720,1526,3,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',130209.71,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL),(475,7749,40720,1526,3,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',38999.91,NULL,NULL,1,'2022-09-27 12:09:08','2022-10-11 12:36:35','2022-10-11 12:36:35');
INSERT INTO `balance_libro` VALUES (476,7749,40720,1526,3,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',30995.08,NULL,NULL,1,'2022-09-27 12:09:08','2022-10-11 12:37:19','2022-10-11 12:37:19'),(477,7749,40720,1526,3,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',134500.00,NULL,NULL,1,'2022-09-27 12:09:08','2022-10-11 12:37:44','2022-10-11 12:37:44'),(478,7749,40720,1526,3,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',145199.11,NULL,NULL,1,'2022-09-27 12:09:08','2022-10-11 12:38:27','2022-10-11 12:38:27'),(479,7749,40720,1526,3,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',22588.10,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL),(480,7749,40720,1526,3,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',41751.79,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL),(481,7749,40720,1526,3,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',130659.19,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL),(482,7749,40720,1526,3,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',330080.70,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL),(483,7749,40720,1526,3,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',34228.60,NULL,NULL,1,'2022-09-27 12:09:08','2022-10-13 11:19:31','2022-10-13 11:19:31'),(484,7749,40720,1526,3,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',52266.54,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL),(485,7749,40720,1526,3,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',33523.98,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL),(486,7749,40720,1526,3,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',14000.00,NULL,NULL,1,'2022-09-27 12:09:08','2022-10-11 12:41:14','2022-10-11 12:41:14'),(487,7749,40720,1526,3,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',5592.06,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL),(488,7749,40720,1526,3,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',72651.22,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL),(489,7749,40720,1526,3,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',231500.00,NULL,NULL,1,'2022-09-27 12:09:08','2022-10-11 12:42:50','2022-10-11 12:42:50'),(490,7749,40720,1526,3,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',872.76,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL),(491,7749,40720,1526,3,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',2054.76,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL),(492,7749,40720,1526,3,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',24136.03,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL),(493,7749,40720,1526,3,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',5511.43,NULL,NULL,1,'2022-09-27 12:09:08','2022-10-13 11:19:48','2022-10-13 11:19:48'),(494,7749,40720,1526,3,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',6478.36,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL),(495,7749,40720,1526,3,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',65978.95,NULL,NULL,1,'2022-09-27 12:09:08','2022-09-27 12:09:08',NULL);
INSERT INTO `balance_libro` VALUES (496,7749,40720,1526,3,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',14133.56,NULL,NULL,1,'2022-09-27 12:09:08','2022-10-13 11:20:01','2022-10-13 11:20:01'),(497,7749,40720,1526,3,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',22660.03,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(498,7749,40720,1526,3,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',42636.55,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(499,7749,40720,1526,3,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',34441.15,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(500,7749,40720,1526,3,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',73115.65,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(501,7749,40720,1526,3,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',48014.23,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(502,7749,40720,1526,3,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',4041.40,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(503,7749,40720,1526,3,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',16620.71,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(504,7749,40720,1526,3,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',236000.00,NULL,NULL,1,'2022-09-27 12:09:09','2022-10-11 12:48:16','2022-10-11 12:48:16'),(505,7749,40720,1526,3,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',30722.90,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(506,7749,40720,1526,3,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',370967.85,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(507,7749,40720,1526,3,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',109199.50,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(508,7749,40720,1526,3,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',45083.25,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(509,7749,40720,1526,3,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',34800.00,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(510,7749,40720,1526,3,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',166104.96,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(511,7749,40720,1526,3,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',20373.53,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(512,7749,40720,1526,3,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',9924.64,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(513,7749,40720,1526,3,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',228595.53,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(514,7749,40720,1526,3,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',174715.90,NULL,NULL,1,'2022-09-27 12:09:09','2022-10-13 10:36:51','2022-10-13 10:36:51'),(515,7749,40720,1526,3,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',97900.01,NULL,NULL,1,'2022-09-27 12:09:09','2022-10-14 10:16:56','2022-10-14 10:16:56');
INSERT INTO `balance_libro` VALUES (516,7749,40720,1526,3,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',217126.30,NULL,NULL,1,'2022-09-27 12:09:09','2022-10-13 10:48:18','2022-10-13 10:48:18'),(517,7749,40720,1526,3,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',180990.14,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(518,7749,40720,1526,3,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',79531.24,NULL,NULL,1,'2022-09-27 12:09:09','2022-10-13 10:37:12','2022-10-13 10:37:12'),(519,7749,40720,1526,3,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',1518.50,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(520,7749,40720,1526,3,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',12980.58,NULL,NULL,1,'2022-09-27 12:09:09','2022-09-27 12:09:09',NULL),(521,7749,40720,1526,3,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',13760.06,NULL,NULL,1,'2022-09-27 12:09:09','2022-10-13 11:21:51','2022-10-13 11:21:51'),(522,7749,40720,1526,3,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',17713.58,NULL,NULL,1,'2022-09-27 12:09:10','2022-10-13 11:22:03','2022-10-13 11:22:03'),(523,7749,40720,1526,3,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',12017.15,NULL,NULL,1,'2022-09-27 12:09:10','2022-10-13 11:22:15','2022-10-13 11:22:15'),(524,7749,40720,1526,3,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',6126.59,NULL,NULL,1,'2022-09-27 12:09:10','2022-10-13 11:22:24','2022-10-13 11:22:24'),(525,7749,40720,1526,3,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',3649.99,NULL,NULL,1,'2022-09-27 12:09:10','2022-10-13 11:22:35','2022-10-13 11:22:35'),(526,7749,40720,1526,3,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',3946.12,NULL,NULL,1,'2022-09-27 12:09:10','2022-10-13 11:22:46','2022-10-13 11:22:46'),(527,7749,40720,1526,3,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',9589.17,NULL,NULL,1,'2022-09-27 12:09:10','2022-10-13 11:22:57','2022-10-13 11:22:57'),(528,7749,40720,1526,3,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',3233.61,NULL,NULL,1,'2022-09-27 12:09:10','2022-10-13 11:23:09','2022-10-13 11:23:09'),(529,7749,40720,1526,3,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',896.95,NULL,NULL,1,'2022-09-27 12:09:10','2022-10-13 11:23:22','2022-10-13 11:23:22'),(530,7749,40720,1526,3,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',16591.56,NULL,NULL,1,'2022-09-27 12:09:10','2022-10-13 11:23:32','2022-10-13 11:23:32'),(531,7749,40720,1526,3,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',10639.56,NULL,NULL,1,'2022-09-27 12:09:10','2022-10-13 11:23:42','2022-10-13 11:23:42'),(532,7749,40720,1526,3,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',3194.29,NULL,NULL,1,'2022-09-27 12:09:10','2022-09-27 12:09:10',NULL),(533,7749,40720,1526,3,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',2420.00,NULL,NULL,1,'2022-09-27 12:09:10','2022-09-27 12:09:10',NULL),(534,7749,40720,1526,2,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',42209.99,NULL,NULL,1,'2022-10-05 10:47:15','2022-10-11 11:57:54','2022-10-11 11:57:54'),(535,7749,40720,1526,2,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',1670.03,NULL,NULL,1,'2022-10-05 10:47:15','2022-10-11 11:49:03','2022-10-11 11:49:03');
INSERT INTO `balance_libro` VALUES (536,7749,40720,1526,2,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',102109.88,NULL,NULL,1,'2022-10-05 10:47:15','2022-10-05 10:47:15',NULL),(537,7749,40720,1526,2,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',6800.03,NULL,NULL,1,'2022-10-05 10:47:15','2022-10-05 10:47:15',NULL),(538,7749,40720,1526,2,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',13899.96,NULL,NULL,1,'2022-10-05 10:47:15','2022-10-11 11:58:35','2022-10-11 11:58:35'),(539,7749,40720,1526,2,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',29840.10,NULL,NULL,1,'2022-10-05 10:47:15','2022-10-05 10:47:15',NULL),(540,7749,40720,1526,2,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',7600.01,NULL,NULL,1,'2022-10-05 10:47:15','2022-10-11 11:49:32','2022-10-11 11:49:32'),(541,7749,40720,1526,2,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',6300.01,NULL,NULL,1,'2022-10-05 10:47:15','2022-10-05 10:47:15',NULL),(542,7749,40720,1526,2,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',5700.02,NULL,NULL,1,'2022-10-05 10:47:32','2022-10-05 10:47:32',NULL),(543,7749,40720,1526,2,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',5299.97,NULL,NULL,1,'2022-10-05 10:47:32','2022-10-05 10:47:32',NULL),(544,7749,40720,1526,2,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',19999.97,NULL,NULL,1,'2022-10-05 10:47:32','2022-10-05 10:47:32',NULL),(545,7749,40720,1526,2,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',8950.02,NULL,NULL,1,'2022-10-05 10:47:33','2022-10-05 10:47:33',NULL),(546,7749,40720,1526,2,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',1860.00,NULL,NULL,1,'2022-10-05 10:47:33','2022-10-05 10:47:33',NULL),(547,7749,40720,1526,2,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',399.99,NULL,NULL,1,'2022-10-05 10:47:33','2022-10-05 10:47:33',NULL),(548,7749,40720,1526,2,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',720.01,NULL,NULL,1,'2022-10-05 10:47:33','2022-10-05 10:47:33',NULL),(549,7749,40720,1526,2,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',950.02,NULL,NULL,1,'2022-10-05 10:47:33','2022-10-05 10:47:33',NULL),(550,7749,40720,1526,2,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',830.00,NULL,NULL,1,'2022-10-05 10:47:33','2022-10-05 10:47:33',NULL),(551,7749,40720,1526,2,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',4069.98,NULL,NULL,1,'2022-10-05 10:47:33','2022-10-05 10:47:33',NULL),(552,7749,40720,1526,2,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',8999.98,NULL,NULL,1,'2022-10-05 10:47:33','2022-10-05 10:47:33',NULL),(553,7749,40720,1526,2,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1100.01,NULL,NULL,1,'2022-10-05 10:47:33','2022-10-05 10:47:33',NULL),(554,7749,40720,1526,2,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',6500.00,NULL,NULL,1,'2022-10-05 10:47:33','2022-10-05 10:47:33',NULL),(555,7749,40720,1526,2,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',360.00,NULL,NULL,1,'2022-10-05 10:47:33','2022-10-05 10:47:33',NULL),(556,7749,40720,1526,2,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2499.98,NULL,NULL,1,'2022-10-05 10:47:33','2022-10-05 10:47:33',NULL);
INSERT INTO `balance_libro` VALUES (557,7749,40720,1526,2,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',96769.00,NULL,NULL,1,'2022-10-11 11:05:41','2022-10-11 11:05:41',NULL),(558,7749,40720,1526,2,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',159970.00,NULL,NULL,1,'2022-10-11 11:15:11','2022-10-11 11:15:11',NULL),(559,7749,40720,1526,2,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',87419.50,NULL,NULL,1,'2022-10-11 11:41:58','2022-10-11 11:41:58',NULL),(560,7749,40720,1526,2,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',80490.00,NULL,NULL,1,'2022-10-11 11:42:42','2022-10-11 11:42:42',NULL),(561,7749,40720,1526,2,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',61040.00,NULL,NULL,1,'2022-10-11 11:43:44','2022-10-11 11:43:44',NULL),(562,7749,40720,1526,2,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',81930.00,NULL,NULL,1,'2022-10-11 11:44:16','2022-10-11 11:44:16',NULL),(563,7749,40720,1526,2,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',71630.00,NULL,NULL,1,'2022-10-11 11:44:54','2022-10-11 11:44:54',NULL),(564,7749,40720,1526,2,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',85615.00,NULL,NULL,1,'2022-10-11 11:45:12','2022-10-11 11:45:12',NULL),(565,7749,40720,1526,2,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-11','2022-09-11',34733.00,NULL,NULL,1,'2022-10-11 11:45:31','2022-10-11 11:45:31',NULL),(566,7749,40720,1526,2,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',78974.00,NULL,NULL,1,'2022-10-11 11:45:52','2022-10-11 11:45:52',NULL),(567,7749,40720,1526,2,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',76735.01,NULL,NULL,1,'2022-10-11 11:46:48','2022-10-11 11:46:48',NULL),(568,7749,40720,1526,2,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',77430.01,NULL,NULL,1,'2022-10-11 11:47:08','2022-10-11 11:47:08',NULL),(569,7749,40720,1526,2,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',56000.00,NULL,NULL,1,'2022-10-11 11:48:00','2022-10-11 11:48:00',NULL),(570,7749,40720,1526,2,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',85350.00,NULL,NULL,1,'2022-10-11 11:48:19','2022-10-11 11:48:19',NULL),(571,7749,40720,1526,2,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',72210.00,NULL,NULL,1,'2022-10-11 11:48:41','2022-10-11 11:48:41',NULL),(572,7749,40720,1526,2,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',90980.00,NULL,NULL,1,'2022-10-11 11:49:03','2022-10-11 11:49:03',NULL),(573,7749,40720,1526,2,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',112605.00,NULL,NULL,1,'2022-10-11 11:49:32','2022-10-11 11:49:32',NULL),(574,7749,40720,1526,2,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',77250.01,NULL,NULL,1,'2022-10-11 11:57:54','2022-10-11 11:57:54',NULL),(575,7749,40720,1526,2,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',97033.02,NULL,NULL,1,'2022-10-11 11:58:35','2022-10-11 11:58:35',NULL),(576,7749,40720,1526,3,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',67250.00,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-11 12:57:21','2022-10-11 12:57:21'),(577,7749,40720,1526,3,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',242321.11,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-11 12:04:04',NULL);
INSERT INTO `balance_libro` VALUES (578,7749,40720,1526,3,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',4139.74,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-11 12:04:04',NULL),(579,7749,40720,1526,3,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',15361.13,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-11 12:04:04',NULL),(580,7749,40720,1526,3,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',85088.35,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-11 12:04:04',NULL),(581,7749,40720,1526,3,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',70564.97,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-11 12:04:04',NULL),(582,7749,40720,1526,3,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',526000.00,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-11 13:00:09','2022-10-11 13:00:09'),(583,7749,40720,1526,3,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',0.13,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-11 12:04:04',NULL),(584,7749,40720,1526,3,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',64902.89,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-11 12:04:04',NULL),(585,7749,40720,1526,3,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',98006.25,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-11 12:04:04',NULL),(586,7749,40720,1526,3,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',178618.16,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-11 12:04:04',NULL),(587,7749,40720,1526,3,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',7117.54,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-11 12:04:04',NULL),(588,7749,40720,1526,3,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',27871.34,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-17 11:29:02','2022-10-17 11:29:02'),(589,7749,40720,1526,3,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',13127.83,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-11 12:04:04',NULL),(590,7749,40720,1526,3,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',15780.04,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-17 11:56:32','2022-10-17 11:56:32'),(591,7749,40720,1526,3,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',32819.30,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-11 12:04:04',NULL),(592,7749,40720,1526,3,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',9707.56,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-13 11:20:17','2022-10-13 11:20:17'),(593,7749,40720,1526,3,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',13972.35,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-11 12:04:04',NULL),(594,7749,40720,1526,3,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',8514.67,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-11 12:04:04',NULL),(595,7749,40720,1526,3,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',27418.42,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-11 12:04:04',NULL),(596,7749,40720,1526,3,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',7898.93,NULL,NULL,1,'2022-10-11 12:04:04','2022-10-11 12:04:04',NULL),(597,7749,40720,1526,3,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',9145.88,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-11 12:04:05',NULL),(598,7749,40720,1526,3,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',58302.96,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-11 12:04:05',NULL);
INSERT INTO `balance_libro` VALUES (599,7749,40720,1526,3,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',18516.34,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-11 12:04:05',NULL),(600,7749,40720,1526,3,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',49404.42,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-11 12:04:05',NULL),(601,7749,40720,1526,3,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',20421.76,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-11 12:04:05',NULL),(602,7749,40720,1526,3,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',37073.38,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-11 12:04:05',NULL),(603,7749,40720,1526,3,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',16674.41,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-11 12:04:05',NULL),(604,7749,40720,1526,3,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',75.11,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-13 11:21:21','2022-10-13 11:21:21'),(605,7749,40720,1526,3,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',62480.93,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-11 12:04:05',NULL),(606,7749,40720,1526,3,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',108065.78,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-11 12:04:05',NULL),(607,7749,40720,1526,3,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',62230.00,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-11 12:04:05',NULL),(608,7749,40720,1526,3,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',10890.00,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-11 12:04:05',NULL),(609,7749,40720,1526,3,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',244000.00,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-13 11:24:26','2022-10-13 11:24:26'),(610,7749,40720,1526,3,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2370.96,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-11 12:04:05',NULL),(611,7749,40720,1526,3,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',85964.90,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-11 12:04:05',NULL),(612,7749,40720,1526,3,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',4203.48,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-13 10:37:41','2022-10-13 10:37:41'),(613,7749,40720,1526,3,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',12234.77,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-13 10:38:01','2022-10-13 10:38:01'),(614,7749,40720,1526,3,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',14527.00,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-11 13:04:26','2022-10-11 13:04:26'),(615,7749,40720,1526,3,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',87519.89,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-11 13:04:45','2022-10-11 13:04:45'),(616,7749,40720,1526,3,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',132475.04,NULL,NULL,1,'2022-10-11 12:04:05','2022-10-18 09:43:16','2022-10-18 09:43:16'),(617,7749,40720,1526,3,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',17236.11,NULL,NULL,1,'2022-10-11 12:04:06','2022-10-11 12:04:06',NULL),(618,7749,40720,1526,3,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',4083.20,NULL,NULL,1,'2022-10-11 12:04:06','2022-10-13 11:06:28','2022-10-13 11:06:28');
INSERT INTO `balance_libro` VALUES (619,7749,40720,1526,3,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',0.00,NULL,NULL,1,'2022-10-11 12:04:06','2022-10-11 12:04:06',NULL),(620,7749,40720,1526,3,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',219166.94,NULL,NULL,1,'2022-10-11 12:04:06','2022-10-11 12:04:06',NULL),(621,7749,40720,1526,3,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',53509.32,NULL,NULL,1,'2022-10-11 12:25:28','2022-10-11 12:25:28',NULL),(622,7749,40720,1526,3,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',154078.06,NULL,NULL,1,'2022-10-11 12:28:32','2022-10-11 12:28:32',NULL),(623,7749,40720,1526,3,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',114287.70,NULL,NULL,1,'2022-10-11 12:29:09','2022-10-11 12:29:09',NULL),(624,7749,40720,1526,3,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',7814.38,NULL,NULL,1,'2022-10-11 12:30:25','2022-10-11 12:30:25',NULL),(625,7749,40720,1526,3,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',135243.64,NULL,NULL,1,'2022-10-11 12:33:42','2022-10-11 12:33:42',NULL),(626,7749,40720,1526,3,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',38999.91,NULL,NULL,1,'2022-10-11 12:36:35','2022-10-11 12:36:35',NULL),(627,7749,40720,1526,3,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',30995.08,NULL,NULL,1,'2022-10-11 12:37:19','2022-10-11 12:37:19',NULL),(628,7749,40720,1526,3,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',134500.00,NULL,NULL,1,'2022-10-11 12:37:44','2022-10-11 12:37:44',NULL),(629,7749,40720,1526,3,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',145199.11,NULL,NULL,1,'2022-10-11 12:38:27','2022-10-11 12:38:27',NULL),(630,7749,40720,1526,3,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',19853.40,NULL,NULL,1,'2022-10-11 12:39:41','2022-10-11 12:39:41',NULL),(631,7749,40720,1526,3,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',14000.00,NULL,NULL,1,'2022-10-11 12:41:14','2022-10-11 12:41:14',NULL),(632,7749,40720,1526,3,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',231500.00,NULL,NULL,1,'2022-10-11 12:42:50','2022-10-11 12:42:50',NULL),(633,7749,40720,1526,3,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',6602.09,NULL,NULL,1,'2022-10-11 12:46:12','2022-10-11 12:46:12',NULL),(634,7749,40720,1526,3,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',7001.20,NULL,NULL,1,'2022-10-11 12:46:42','2022-10-11 12:46:42',NULL),(635,7749,40720,1526,3,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',236000.00,NULL,NULL,1,'2022-10-11 12:48:16','2022-10-11 12:48:16',NULL),(636,7749,40720,1526,3,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',23573.21,NULL,NULL,1,'2022-10-11 12:55:28','2022-10-11 12:55:28',NULL),(637,7749,40720,1526,3,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',90290.61,NULL,NULL,1,'2022-10-11 12:56:19','2022-10-11 12:56:19',NULL),(638,7749,40720,1526,3,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',76915.27,NULL,NULL,1,'2022-10-11 12:56:39','2022-10-11 12:56:39',NULL),(639,7749,40720,1526,3,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',67250.00,NULL,NULL,1,'2022-10-11 12:57:21','2022-10-11 12:57:21',NULL);
INSERT INTO `balance_libro` VALUES (640,7749,40720,1526,3,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',526000.00,NULL,NULL,1,'2022-10-11 13:00:09','2022-10-11 13:00:09',NULL),(641,7749,40720,1526,3,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',14527.00,NULL,NULL,1,'2022-10-11 13:04:26','2022-10-11 13:04:26',NULL),(642,7749,40720,1526,3,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',87519.89,NULL,NULL,1,'2022-10-11 13:04:45','2022-10-11 13:04:45',NULL),(643,7749,40720,1526,3,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',205592.61,NULL,NULL,1,'2022-10-11 13:05:54','2022-10-11 13:05:54',NULL),(644,7749,40720,1526,3,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',18445.28,NULL,NULL,1,'2022-10-13 10:36:15','2022-10-13 10:36:15',NULL),(645,7749,40720,1526,3,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',174715.90,NULL,NULL,1,'2022-10-13 10:36:51','2022-10-13 10:36:51',NULL),(646,7749,40720,1526,3,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',79531.24,NULL,NULL,1,'2022-10-13 10:37:12','2022-10-13 10:37:12',NULL),(647,7749,40720,1526,3,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',4203.48,NULL,NULL,1,'2022-10-13 10:37:41','2022-10-13 10:37:41',NULL),(648,7749,40720,1526,3,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',12234.77,NULL,NULL,1,'2022-10-13 10:38:01','2022-10-13 10:38:01',NULL),(649,7749,40720,1526,3,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',217126.35,NULL,NULL,1,'2022-10-13 10:48:18','2022-10-13 10:48:18',NULL),(650,7749,40720,1526,3,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',4083.20,NULL,NULL,1,'2022-10-13 11:06:28','2022-10-13 11:06:28',NULL),(651,7749,40720,1526,3,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',243999.99,NULL,NULL,1,'2022-10-13 11:24:26','2022-10-13 11:24:26',NULL),(652,7749,40720,1526,7,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',195.81,NULL,NULL,1,'2022-10-14 09:46:39','2022-10-14 09:46:39',NULL),(653,7749,40720,1526,7,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',339.82,NULL,NULL,1,'2022-10-14 09:48:12','2022-10-14 09:48:12',NULL),(654,7749,40720,1526,7,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',0.00,NULL,NULL,1,'2022-10-14 10:03:53','2022-10-14 10:03:53',NULL),(655,7749,40720,1526,7,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',286.93,NULL,NULL,1,'2022-10-14 10:04:29','2022-10-14 10:04:29',NULL),(656,7749,40720,1526,7,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',2695.56,NULL,NULL,1,'2022-10-14 10:04:29','2022-10-14 10:04:29',NULL),(657,7749,40720,1526,7,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',212.92,NULL,NULL,1,'2022-10-14 10:04:29','2022-10-14 10:04:29',NULL),(658,7749,40720,1526,7,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',196.78,NULL,NULL,1,'2022-10-14 10:08:17','2022-10-14 10:08:38','2022-10-14 10:08:38'),(659,7749,40720,1526,7,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',590.35,NULL,NULL,1,'2022-10-14 10:08:38','2022-10-14 10:08:38',NULL),(660,7749,40720,1526,3,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',97900.01,NULL,NULL,1,'2022-10-17 10:36:12','2022-10-17 10:36:12',NULL);
INSERT INTO `balance_libro` VALUES (661,7749,40720,1526,3,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',51589.55,NULL,NULL,1,'2022-10-17 11:28:31','2022-10-17 11:28:31',NULL),(662,7749,40720,1526,3,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',27871.35,NULL,NULL,1,'2022-10-17 11:29:02','2022-10-17 11:29:02',NULL),(663,7749,40720,1526,3,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',194328.88,NULL,NULL,1,'2022-10-18 09:42:13','2022-10-18 09:42:13',NULL),(664,7749,40720,1526,3,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',132475.05,NULL,NULL,1,'2022-10-18 09:43:16','2022-10-18 09:43:16',NULL),(665,7749,40720,1526,3,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',75591.52,NULL,NULL,1,'2022-10-18 09:44:20','2022-10-18 09:44:20',NULL),(666,7749,40720,1527,3,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',116634.95,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-20 10:58:29',NULL),(667,7749,40720,1527,3,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',24216.08,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-20 10:58:29',NULL),(668,7749,40720,1527,3,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',125615.91,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-20 10:58:29',NULL),(669,7749,40720,1527,3,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',866748.87,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-20 10:58:29',NULL),(670,7749,40720,1527,3,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',8520.00,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-20 10:58:29',NULL),(671,7749,40720,1527,3,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',7990.01,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-20 10:58:29',NULL),(672,7749,40720,1527,3,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',51702.43,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-20 10:58:29',NULL),(673,7749,40720,1527,3,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',7139.00,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-20 10:58:29',NULL),(674,7749,40720,1527,3,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',67900.00,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-24 12:45:00','2022-10-24 12:45:00'),(675,7749,40720,1527,3,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',225521.01,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-20 10:58:29',NULL),(676,7749,40720,1527,3,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',158494.91,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-20 10:58:29',NULL),(677,7749,40720,1527,3,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',12000.01,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-20 10:58:29',NULL),(678,7749,40720,1527,3,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',137684.30,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-20 10:58:29',NULL),(679,7749,40720,1527,3,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',108200.00,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-24 12:47:25','2022-10-24 12:47:25'),(680,7749,40720,1527,3,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',125203.87,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-24 12:48:10','2022-10-24 12:48:10'),(681,7749,40720,1527,3,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3593.70,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-20 10:58:29',NULL);
INSERT INTO `balance_libro` VALUES (682,7749,40720,1527,3,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',0.10,NULL,NULL,1,'2022-10-20 10:58:29','2022-11-16 10:37:37','2022-11-16 10:37:37'),(683,7749,40720,1527,3,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',88389.56,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-20 10:58:29',NULL),(684,7749,40720,1527,3,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',236423.06,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-20 10:58:29',NULL),(685,7749,40720,1527,3,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',75540.83,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-20 10:58:29',NULL),(686,7749,40720,1527,3,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',7485.33,NULL,NULL,1,'2022-10-20 10:58:29','2022-10-20 10:58:29',NULL),(687,7749,40720,1527,3,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',46255.00,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(688,7749,40720,1527,3,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',26171.91,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(689,7749,40720,1527,3,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3405.34,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(690,7749,40720,1527,3,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',108524.45,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(691,7749,40720,1527,3,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',20984.75,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(692,7749,40720,1527,3,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3075.69,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(693,7749,40720,1527,3,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',8663.20,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(694,7749,40720,1527,3,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',43845.16,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(695,7749,40720,1527,3,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',64296.22,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(696,7749,40720,1527,3,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',59514.15,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(697,7749,40720,1527,3,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',9949.61,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(698,7749,40720,1527,3,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',40521.59,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(699,7749,40720,1527,3,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',65347.84,NULL,NULL,1,'2022-10-20 10:58:30','2022-11-14 12:08:39','2022-11-14 12:08:39'),(700,7749,40720,1527,3,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',214156.81,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(701,7749,40720,1527,3,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',5009.90,NULL,NULL,1,'2022-10-20 10:58:30','2022-11-14 12:07:26','2022-11-14 12:07:26'),(702,7749,40720,1527,3,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',21271.15,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL);
INSERT INTO `balance_libro` VALUES (703,7749,40720,1527,3,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',89.32,NULL,NULL,1,'2022-10-20 10:58:30','2022-11-14 12:07:51','2022-11-14 12:07:51'),(704,7749,40720,1527,3,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',65347.84,NULL,NULL,1,'2022-10-20 10:58:30','2022-11-14 12:08:29','2022-11-14 12:08:29'),(705,7749,40720,1527,3,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',181882.00,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-24 12:52:55','2022-10-24 12:52:55'),(706,7749,40720,1527,3,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',205.48,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(707,7749,40720,1527,3,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1129.40,NULL,NULL,1,'2022-10-20 10:58:30','2022-11-14 12:07:18','2022-11-14 12:07:18'),(708,7749,40720,1527,3,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',51693.92,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(709,7749,40720,1527,3,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',51338.57,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(710,7749,40720,1527,3,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',82951.82,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(711,7749,40720,1527,3,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',49000.00,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(712,7749,40720,1527,3,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',8109.07,NULL,NULL,1,'2022-10-20 10:58:30','2022-10-20 10:58:30',NULL),(713,7749,40720,1527,3,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',5324.34,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-20 10:58:31',NULL),(714,7749,40720,1527,3,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',23063.82,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-20 10:58:31',NULL),(715,7749,40720,1527,3,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',71405.63,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-20 10:58:31',NULL),(716,7749,40720,1527,3,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140111.42,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-24 12:56:25','2022-10-24 12:56:25'),(717,7749,40720,1527,3,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',79660.06,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-20 10:58:31',NULL),(718,7749,40720,1527,3,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',45215.08,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-20 10:58:31',NULL),(719,7749,40720,1527,3,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',6925.17,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-20 10:58:31',NULL),(720,7749,40720,1527,3,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',88014.75,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-20 10:58:31',NULL),(721,7749,40720,1527,3,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',67134.43,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-20 10:58:31',NULL),(722,7749,40720,1527,3,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',21307.19,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-20 10:58:31',NULL),(723,7749,40720,1527,3,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',134255.45,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-20 10:58:31',NULL);
INSERT INTO `balance_libro` VALUES (724,7749,40720,1527,3,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',120724.14,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-20 10:58:31',NULL),(725,7749,40720,1527,3,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',30844.93,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-20 10:58:31',NULL),(726,7749,40720,1527,3,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',312604.17,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-26 11:29:35','2022-10-26 11:29:35'),(727,7749,40720,1527,3,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',81169.29,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-26 11:29:58','2022-10-26 11:29:58'),(728,7749,40720,1527,3,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',207116.34,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-20 10:58:31',NULL),(729,7749,40720,1527,3,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',122545.69,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-20 10:58:31',NULL),(730,7749,40720,1527,3,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',41052.63,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-20 10:58:31',NULL),(731,7749,40720,1527,3,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',128759.91,NULL,NULL,1,'2022-10-20 10:58:31','2022-10-20 10:58:31',NULL),(732,7749,40720,1527,3,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',63923.17,NULL,NULL,1,'2022-10-20 10:58:32','2022-10-20 10:58:32',NULL),(733,7749,40720,1527,3,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',202060.32,NULL,NULL,1,'2022-10-20 10:58:32','2022-10-20 10:58:32',NULL),(734,7749,40720,1527,3,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',30121.92,NULL,NULL,1,'2022-10-20 10:58:32','2022-10-20 10:58:32',NULL),(735,7749,40720,1527,3,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',3411.11,NULL,NULL,1,'2022-10-20 10:58:32','2022-10-20 10:58:32',NULL),(736,7749,40720,1527,3,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',378820.54,NULL,NULL,1,'2022-10-20 10:58:32','2022-10-26 11:28:56','2022-10-26 11:28:56'),(737,7749,40720,1527,3,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2925.39,NULL,NULL,1,'2022-10-20 10:58:32','2022-10-20 10:58:32',NULL),(738,7749,40720,1527,3,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',13453.72,NULL,NULL,1,'2022-10-20 10:58:32','2022-10-20 10:58:32',NULL),(739,7749,40720,1527,3,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',51104.14,NULL,NULL,1,'2022-10-20 10:58:32','2022-10-20 10:58:32',NULL),(740,7749,40720,1527,2,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',17550.07,NULL,NULL,1,'2022-10-20 11:22:19','2022-10-21 09:25:40','2022-10-21 09:25:40'),(741,7749,40720,1527,2,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',27045.00,NULL,NULL,1,'2022-10-20 11:22:19','2022-10-21 09:25:55','2022-10-21 09:25:55'),(742,7749,40720,1527,2,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',10800.00,NULL,NULL,1,'2022-10-20 11:22:19','2022-10-21 09:26:15','2022-10-21 09:26:15'),(743,7749,40720,1527,2,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',4800.01,NULL,NULL,1,'2022-10-20 11:22:19','2022-10-21 09:26:39','2022-10-21 09:26:39');
INSERT INTO `balance_libro` VALUES (744,7749,40720,1527,2,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',2999.99,NULL,NULL,1,'2022-10-20 11:22:19','2022-10-21 10:24:38','2022-10-21 10:24:38'),(745,7749,40720,1527,2,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',21500.03,NULL,NULL,1,'2022-10-20 11:22:19','2022-10-21 10:24:57','2022-10-21 10:24:57'),(746,7749,40720,1527,2,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',8160.01,NULL,NULL,1,'2022-10-20 11:22:19','2022-10-21 10:25:15','2022-10-21 10:25:15'),(747,7749,40720,1527,2,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',10999.99,NULL,NULL,1,'2022-10-20 11:22:35','2022-10-21 10:25:29','2022-10-21 10:25:29'),(748,7749,40720,1527,2,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-09','2022-10-09',7340.03,NULL,NULL,1,'2022-10-20 11:22:35','2022-10-20 11:22:35',NULL),(749,7749,40720,1527,2,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',1400.03,NULL,NULL,1,'2022-10-20 11:22:35','2022-10-21 10:25:50','2022-10-21 10:25:50'),(750,7749,40720,1527,2,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',3399.98,NULL,NULL,1,'2022-10-20 11:22:35','2022-10-21 10:26:07','2022-10-21 10:26:07'),(751,7749,40720,1527,2,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',9080.01,NULL,NULL,1,'2022-10-20 11:22:35','2022-10-21 10:26:25','2022-10-21 10:26:25'),(752,7749,40720,1527,2,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',13280.04,NULL,NULL,1,'2022-10-20 11:22:35','2022-10-21 10:26:39','2022-10-21 10:26:39'),(753,7749,40720,1527,2,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',6109.92,NULL,NULL,1,'2022-10-20 11:22:35','2022-10-21 10:26:57','2022-10-21 10:26:57'),(754,7749,40720,1527,2,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',58100.00,NULL,NULL,1,'2022-10-21 09:12:15','2022-10-21 09:12:15',NULL),(755,7749,40720,1527,2,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',55640.00,NULL,NULL,1,'2022-10-21 09:12:16','2022-10-21 09:12:16',NULL),(756,7749,40720,1527,2,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',3999.99,NULL,NULL,1,'2022-10-21 09:12:16','2022-10-21 09:12:16',NULL),(757,7749,40720,1527,2,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2300.00,NULL,NULL,1,'2022-10-21 09:12:16','2022-10-21 09:12:16',NULL),(758,7749,40720,1527,2,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1250.00,NULL,NULL,1,'2022-10-21 09:12:16','2022-10-21 09:12:16',NULL),(759,7749,40720,1527,2,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',600.00,NULL,NULL,1,'2022-10-21 09:12:16','2022-10-21 09:12:16',NULL),(760,7749,40720,1527,2,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2500.00,NULL,NULL,1,'2022-10-21 09:12:16','2022-10-21 09:12:16',NULL),(761,7749,40720,1527,2,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1580.00,NULL,NULL,1,'2022-10-21 09:12:16','2022-10-21 09:12:16',NULL),(762,7749,40720,1527,2,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',8499.99,NULL,NULL,1,'2022-10-21 09:12:16','2022-10-21 09:12:16',NULL),(763,7749,40720,1527,2,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',600.00,NULL,NULL,1,'2022-10-21 09:12:16','2022-10-21 09:12:16',NULL);
INSERT INTO `balance_libro` VALUES (764,7749,40720,1527,2,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',560.00,NULL,NULL,1,'2022-10-21 09:12:16','2022-10-21 09:12:16',NULL),(765,7749,40720,1527,2,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',3200.00,NULL,NULL,1,'2022-10-21 09:12:16','2022-10-21 09:12:16',NULL),(766,7749,40720,1527,2,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2850.00,NULL,NULL,1,'2022-10-21 09:12:16','2022-10-21 09:12:16',NULL),(767,7749,40720,1527,2,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2500.00,NULL,NULL,1,'2022-10-21 09:12:16','2022-10-21 09:12:16',NULL),(768,7749,40720,1527,2,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',11700.00,NULL,NULL,1,'2022-10-21 09:12:16','2022-10-21 09:12:16',NULL),(769,7749,40720,1527,2,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',29499.99,NULL,NULL,1,'2022-10-21 09:12:16','2022-10-21 09:12:16',NULL),(770,7749,40720,1527,2,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',5200.00,NULL,NULL,1,'2022-10-21 09:12:17','2022-10-21 09:12:17',NULL),(771,7749,40720,1527,2,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',9100.00,NULL,NULL,1,'2022-10-21 09:12:17','2022-10-21 09:12:17',NULL),(772,7749,40720,1527,2,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',45000.00,NULL,NULL,1,'2022-10-21 09:12:17','2022-10-21 09:12:17',NULL),(773,7749,40720,1527,2,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',217399.99,NULL,NULL,1,'2022-10-21 09:12:17','2022-10-21 09:12:17',NULL),(774,7749,40720,1527,2,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',268499.97,NULL,NULL,1,'2022-10-21 09:12:17','2022-10-21 09:12:17',NULL),(775,7749,40720,1527,2,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',236099.96,NULL,NULL,1,'2022-10-21 09:12:17','2022-10-21 09:12:17',NULL),(776,7749,40720,1527,2,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',108800.00,NULL,NULL,1,'2022-10-21 09:12:17','2022-10-21 09:12:17',NULL),(777,7749,40720,1527,2,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2450.00,NULL,NULL,1,'2022-10-21 09:12:17','2022-10-21 09:12:17',NULL),(778,7749,40720,1527,2,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',137400.00,NULL,NULL,1,'2022-10-21 09:12:17','2022-10-21 09:12:17',NULL),(779,7749,40720,1527,2,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',190499.99,NULL,NULL,1,'2022-10-21 09:12:17','2022-10-21 09:12:17',NULL),(780,7749,40720,1527,2,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',228000.00,NULL,NULL,1,'2022-10-21 09:12:18','2022-10-21 09:12:18',NULL),(781,7749,40720,1527,2,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',24330.00,NULL,NULL,1,'2022-10-21 09:12:18','2022-10-21 09:12:18',NULL),(782,7749,40720,1527,2,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',20100.00,NULL,NULL,1,'2022-10-21 09:12:18','2022-10-21 09:12:18',NULL),(783,7749,40720,1527,2,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',12500.00,NULL,NULL,1,'2022-10-21 09:12:18','2022-10-21 09:12:18',NULL),(784,7749,40720,1527,2,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',5500.00,NULL,NULL,1,'2022-10-21 09:12:18','2022-10-21 09:12:18',NULL);
INSERT INTO `balance_libro` VALUES (785,7749,40720,1527,2,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',140999.99,NULL,NULL,1,'2022-10-21 09:12:18','2022-10-21 09:12:18',NULL),(786,7749,40720,1527,2,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',52300.00,NULL,NULL,1,'2022-10-21 09:12:18','2022-10-21 09:12:18',NULL),(787,7749,40720,1527,2,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',75100.00,NULL,NULL,1,'2022-10-21 09:12:18','2022-10-21 09:12:18',NULL),(788,7749,40720,1527,2,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',73200.00,NULL,NULL,1,'2022-10-21 09:12:18','2022-10-21 09:12:18',NULL),(789,7749,40720,1527,2,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',42099.99,NULL,NULL,1,'2022-10-21 09:12:18','2022-10-21 09:12:18',NULL),(790,7749,40720,1527,2,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',22299.98,NULL,NULL,1,'2022-10-21 09:12:18','2022-10-21 09:12:18',NULL),(791,7749,40720,1527,2,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',46999.99,NULL,NULL,1,'2022-10-21 09:12:18','2022-10-21 09:12:18',NULL),(792,7749,40720,1527,2,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',68000.00,NULL,NULL,1,'2022-10-21 09:12:18','2022-10-21 09:12:18',NULL),(793,7749,40720,1527,2,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',131200.00,NULL,NULL,1,'2022-10-21 09:12:18','2022-10-21 09:12:18',NULL),(794,7749,40720,1527,2,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',102600.00,NULL,NULL,1,'2022-10-21 09:12:18','2022-10-21 09:12:18',NULL),(795,7749,40720,1527,2,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',146000.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(796,7749,40720,1527,2,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1200.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(797,7749,40720,1527,2,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',135600.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(798,7749,40720,1527,2,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',26000.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(799,7749,40720,1527,2,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',120000.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(800,7749,40720,1527,2,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',78000.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(801,7749,40720,1527,2,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',120000.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(802,7749,40720,1527,2,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',94120.03,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(803,7749,40720,1527,2,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',50820.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(804,7749,40720,1527,2,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',42500.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(805,7749,40720,1527,2,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',140400.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL);
INSERT INTO `balance_libro` VALUES (806,7749,40720,1527,2,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',49750.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(807,7749,40720,1527,2,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',36000.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(808,7749,40720,1527,2,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',88649.99,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(809,7749,40720,1527,2,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',13500.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(810,7749,40720,1527,2,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',120000.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(811,7749,40720,1527,2,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',45000.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(812,7749,40720,1527,2,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',34849.98,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(813,7749,40720,1527,2,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',10600.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(814,7749,40720,1527,2,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',27250.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(815,7749,40720,1527,2,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',19280.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(816,7749,40720,1527,2,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',7000.00,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(817,7749,40720,1527,2,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1399.99,NULL,NULL,1,'2022-10-21 09:12:19','2022-10-21 09:12:19',NULL),(818,7749,40720,1527,2,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',14520.00,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(819,7749,40720,1527,2,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',650.00,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(820,7749,40720,1527,2,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',25900.00,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(821,7749,40720,1527,2,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',139319.99,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(822,7749,40720,1527,2,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',134400.00,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(823,7749,40720,1527,2,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',33600.00,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(824,7749,40720,1527,2,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',34500.00,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(825,7749,40720,1527,2,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',269999.99,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(826,7749,40720,1527,2,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',195000.03,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL);
INSERT INTO `balance_libro` VALUES (827,7749,40720,1527,2,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',35999.99,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(828,7749,40720,1527,2,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',62000.00,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(829,7749,40720,1527,2,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',134799.99,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(830,7749,40720,1527,2,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',33700.00,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(831,7749,40720,1527,2,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',24399.99,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(832,7749,40720,1527,2,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',8589.98,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(833,7749,40720,1527,2,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',74300.00,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(834,7749,40720,1527,2,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',4450.00,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(835,7749,40720,1527,2,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1000.00,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(836,7749,40720,1527,2,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1450.00,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(837,7749,40720,1527,2,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',58360.00,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(838,7749,40720,1527,2,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',10325.00,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(839,7749,40720,1527,2,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',850.00,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(840,7749,40720,1527,2,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',5299.99,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(841,7749,40720,1527,2,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',36079.99,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(842,7749,40720,1527,2,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',2400.00,NULL,NULL,1,'2022-10-21 09:12:20','2022-10-21 09:12:20',NULL),(843,7749,40720,1527,2,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',62400.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(844,7749,40720,1527,2,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',33635.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(845,7749,40720,1527,2,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',5599.99,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(846,7749,40720,1527,2,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2200.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(847,7749,40720,1527,2,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',89400.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL);
INSERT INTO `balance_libro` VALUES (848,7749,40720,1527,2,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',81000.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(849,7749,40720,1527,2,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',49475.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(850,7749,40720,1527,2,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',7230.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(851,7749,40720,1527,2,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',11450.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(852,7749,40720,1527,2,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',4549.95,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(853,7749,40720,1527,2,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',7000.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(854,7749,40720,1527,2,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',20099.52,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(855,7749,40720,1527,2,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',23750.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(856,7749,40720,1527,2,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',18580.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(857,7749,40720,1527,2,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',204006.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(858,7749,40720,1527,2,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',298991.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(859,7749,40720,1527,2,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',198609.40,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(860,7749,40720,1527,2,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',6000.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(861,7749,40720,1527,2,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',14260.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(862,7749,40720,1527,2,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1520.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(863,7749,40720,1527,2,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',532.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(864,7749,40720,1527,2,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',10940.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(865,7749,40720,1527,2,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',151100.00,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(866,7749,40720,1527,2,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',10494.58,NULL,NULL,1,'2022-10-21 09:12:21','2022-10-21 09:12:21',NULL),(867,7749,40720,1527,2,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',33294.67,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL),(868,7749,40720,1527,2,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',10969.99,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL);
INSERT INTO `balance_libro` VALUES (869,7749,40720,1527,2,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',60000.00,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL),(870,7749,40720,1527,2,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',43789.25,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL),(871,7749,40720,1527,2,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',200.00,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL),(872,7749,40720,1527,2,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1900.00,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL),(873,7749,40720,1527,2,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',23000.00,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL),(874,7749,40720,1527,2,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',39800.00,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL),(875,7749,40720,1527,2,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2000.00,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL),(876,7749,40720,1527,2,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',9350.00,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL),(877,7749,40720,1527,2,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',57735.02,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL),(878,7749,40720,1527,2,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',134400.00,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL),(879,7749,40720,1527,2,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',134400.00,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL),(880,7749,40720,1527,2,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',102000.00,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL),(881,7749,40720,1527,2,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',138000.00,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL),(882,7749,40720,1527,2,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',96000.00,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL),(883,7749,40720,1527,2,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',56000.00,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL),(884,7749,40720,1527,2,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1509799.99,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL),(885,7749,40720,1527,2,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',235055.00,NULL,NULL,1,'2022-10-21 09:12:22','2022-10-21 09:12:22',NULL),(886,7749,40720,1527,2,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',206385.01,NULL,NULL,1,'2022-10-21 09:25:40','2022-10-21 09:25:40',NULL),(887,7749,40720,1527,2,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',27045.00,NULL,NULL,1,'2022-10-21 09:25:55','2022-10-21 09:25:55',NULL),(888,7749,40720,1527,2,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',101919.99,NULL,NULL,1,'2022-10-21 09:26:15','2022-10-21 09:26:15',NULL),(889,7749,40720,1527,2,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',95205.99,NULL,NULL,1,'2022-10-21 09:26:39','2022-10-21 09:26:39',NULL);
INSERT INTO `balance_libro` VALUES (890,7749,40720,1527,2,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',97540.00,NULL,NULL,1,'2022-10-21 10:24:38','2022-10-21 10:24:38',NULL),(891,7749,40720,1527,2,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',65380.00,NULL,NULL,1,'2022-10-21 10:24:57','2022-10-21 10:24:57',NULL),(892,7749,40720,1527,2,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',58515.00,NULL,NULL,1,'2022-10-21 10:25:15','2022-10-21 10:25:15',NULL),(893,7749,40720,1527,2,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',94690.00,NULL,NULL,1,'2022-10-21 10:25:29','2022-10-21 10:25:29',NULL),(894,7749,40720,1527,2,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',29640.00,NULL,NULL,1,'2022-10-21 10:25:50','2022-10-21 10:25:50',NULL),(895,7749,40720,1527,2,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',90460.00,NULL,NULL,1,'2022-10-21 10:26:07','2022-10-21 10:26:07',NULL),(896,7749,40720,1527,2,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',110446.00,NULL,NULL,1,'2022-10-21 10:26:25','2022-10-21 10:26:25',NULL),(897,7749,40720,1527,2,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',59619.00,NULL,NULL,1,'2022-10-21 10:26:39','2022-10-21 10:26:39',NULL),(898,7749,40720,1527,2,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',71213.75,NULL,NULL,1,'2022-10-21 10:26:57','2022-10-21 10:26:57',NULL),(899,7749,40720,1527,2,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1800.00,NULL,NULL,1,'2022-10-21 10:36:02','2022-10-21 10:36:02',NULL),(900,7749,40720,1527,2,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',8949.99,NULL,NULL,1,'2022-10-21 10:38:33','2022-10-21 10:38:33',NULL),(901,7749,40720,1527,2,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',6799.99,NULL,NULL,1,'2022-10-21 10:39:20','2022-10-21 10:39:20',NULL),(902,7749,40720,1527,2,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',600.00,NULL,NULL,1,'2022-10-21 10:39:46','2022-10-21 10:39:46',NULL),(903,7749,40720,1527,2,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1300.00,NULL,NULL,1,'2022-10-21 10:40:12','2022-10-21 10:40:12',NULL),(904,7749,40720,1527,2,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',5900.00,NULL,NULL,1,'2022-10-21 10:40:36','2022-10-21 10:40:36',NULL),(905,7749,40720,1527,2,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',3000.00,NULL,NULL,1,'2022-10-21 10:40:57','2022-10-21 10:40:57',NULL),(906,7749,40720,1527,2,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',4800.00,NULL,NULL,1,'2022-10-21 10:42:06','2022-10-21 10:42:06',NULL),(907,7749,40720,1527,2,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',600.00,NULL,NULL,1,'2022-10-21 10:42:25','2022-10-21 10:42:25',NULL),(908,7749,40720,1527,2,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',2400.00,NULL,NULL,1,'2022-10-21 10:43:05','2022-10-21 10:43:05',NULL),(909,7749,40720,1527,2,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3000.00,NULL,NULL,1,'2022-10-21 10:43:28','2022-10-21 10:43:28',NULL),(910,7749,40720,1527,2,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',5499.99,NULL,NULL,1,'2022-10-21 10:43:55','2022-10-21 10:43:55',NULL);
INSERT INTO `balance_libro` VALUES (911,7749,40720,1527,2,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',900.00,NULL,NULL,1,'2022-10-21 10:44:09','2022-10-21 10:44:09',NULL),(912,7749,40720,1527,2,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',7500.00,NULL,NULL,1,'2022-10-21 10:44:34','2022-10-21 10:44:34',NULL),(913,7749,40720,1527,2,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',4600.00,NULL,NULL,1,'2022-10-21 10:44:59','2022-10-21 10:44:59',NULL),(914,7749,40720,1527,2,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2630.00,NULL,NULL,1,'2022-10-21 10:45:39','2022-10-21 10:45:39',NULL),(915,7749,40720,1527,2,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',5530.00,NULL,NULL,1,'2022-10-21 10:46:04','2022-10-21 10:46:04',NULL),(916,7749,40720,1527,2,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',11000.00,NULL,NULL,1,'2022-10-21 10:49:25','2022-10-21 10:49:25',NULL),(917,7749,40720,1527,2,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',1399.99,NULL,NULL,1,'2022-10-21 10:50:20','2022-10-21 10:50:20',NULL),(918,7749,40720,1527,2,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',800.00,NULL,NULL,1,'2022-10-21 10:50:55','2022-10-21 10:50:55',NULL),(919,7749,40720,1527,2,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1350.00,NULL,NULL,1,'2022-10-21 10:51:33','2022-10-21 10:51:33',NULL),(920,7749,40720,1527,2,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1250.00,NULL,NULL,1,'2022-10-21 10:51:55','2022-10-21 10:51:55',NULL),(921,7749,40720,1527,2,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',800.00,NULL,NULL,1,'2022-10-21 10:52:42','2022-10-21 10:52:42',NULL),(922,7749,40720,1527,2,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',5650.00,NULL,NULL,1,'2022-10-21 10:53:41','2022-10-21 10:53:41',NULL),(923,7749,40720,1527,2,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2630.00,NULL,NULL,1,'2022-10-21 10:53:59','2022-10-21 10:53:59',NULL),(924,7749,40720,1527,2,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1250.00,NULL,NULL,1,'2022-10-21 10:54:43','2022-10-21 10:54:43',NULL),(925,7749,40720,1527,2,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',3500.00,NULL,NULL,1,'2022-10-21 10:55:28','2022-10-21 10:55:28',NULL),(926,7749,40720,1527,2,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',4199.99,NULL,NULL,1,'2022-10-21 10:55:45','2022-10-21 10:55:45',NULL),(927,7749,40720,1527,2,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',4330.00,NULL,NULL,1,'2022-10-21 10:56:22','2022-10-21 10:56:22',NULL),(928,7749,40720,1527,2,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',2010.00,NULL,NULL,1,'2022-10-21 10:57:06','2022-10-21 10:57:06',NULL),(929,7749,40720,1527,2,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',2500.01,NULL,NULL,1,'2022-10-21 10:57:25','2022-10-21 10:57:25',NULL),(930,7749,40720,1527,2,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',800.00,NULL,NULL,1,'2022-10-21 10:57:42','2022-10-21 10:57:42',NULL),(931,7749,40720,1527,2,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',800.00,NULL,NULL,1,'2022-10-21 10:58:13','2022-10-21 10:58:13',NULL);
INSERT INTO `balance_libro` VALUES (932,7749,40720,1527,2,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',5500.01,NULL,NULL,1,'2022-10-24 12:26:55','2022-10-24 12:26:55',NULL),(933,7749,40720,1527,2,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',9330.02,NULL,NULL,1,'2022-10-24 12:26:55','2022-10-24 12:26:55',NULL),(934,7749,40720,1527,3,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',6866.11,NULL,NULL,1,'2022-10-24 12:27:29','2022-11-15 10:41:09','2022-11-15 10:41:09'),(935,7749,40720,1527,3,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',77834.59,NULL,NULL,1,'2022-10-24 12:27:29','2022-10-24 12:27:29',NULL),(936,7749,40720,1527,3,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',11588.88,NULL,NULL,1,'2022-10-24 12:27:29','2022-10-24 12:27:29',NULL),(937,7749,40720,1527,3,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2847.08,NULL,NULL,1,'2022-10-24 12:27:29','2022-10-24 12:27:29',NULL),(938,7749,40720,1527,3,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',180418.87,NULL,NULL,1,'2022-10-24 12:27:29','2022-10-24 12:27:29',NULL),(939,7749,40720,1527,3,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',16957.12,NULL,NULL,1,'2022-10-24 12:27:29','2022-10-24 12:27:29',NULL),(940,7749,40720,1527,3,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',83520.20,NULL,NULL,1,'2022-10-24 12:27:29','2022-10-24 12:27:29',NULL),(941,7749,40720,1527,3,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',113272.22,NULL,NULL,1,'2022-10-24 12:27:30','2022-10-24 12:27:30',NULL),(942,7749,40720,1527,3,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',45778.25,NULL,NULL,1,'2022-10-24 12:27:30','2022-10-24 12:27:30',NULL),(943,7749,40720,1527,3,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',16342.90,NULL,NULL,1,'2022-10-24 12:27:30','2022-11-14 11:53:23','2022-11-14 11:53:23'),(944,7749,40720,1527,3,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',67900.00,NULL,NULL,1,'2022-10-24 12:45:00','2022-10-24 12:45:00',NULL),(945,7749,40720,1527,3,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',56225.47,NULL,NULL,1,'2022-10-24 12:46:09','2022-10-24 12:46:09',NULL),(946,7749,40720,1527,3,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',36166.32,NULL,NULL,1,'2022-10-24 12:46:25','2022-10-24 12:46:25',NULL),(947,7749,40720,1527,3,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',108200.00,NULL,NULL,1,'2022-10-24 12:47:25','2022-10-24 12:47:25',NULL),(948,7749,40720,1527,3,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',125203.86,NULL,NULL,1,'2022-10-24 12:48:10','2022-10-24 12:48:10',NULL),(949,7749,40720,1527,3,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',102980.04,NULL,NULL,1,'2022-10-24 12:49:58','2022-10-24 12:49:58',NULL),(950,7749,40720,1527,3,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',42703.46,NULL,NULL,1,'2022-10-24 12:50:25','2022-10-24 12:50:25',NULL),(951,7749,40720,1527,3,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',34810.31,NULL,NULL,1,'2022-10-24 12:52:04','2022-10-24 12:52:04',NULL),(952,7749,40720,1527,3,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',181882.00,NULL,NULL,1,'2022-10-24 12:52:55','2022-10-24 12:52:55',NULL);
INSERT INTO `balance_libro` VALUES (953,7749,40720,1527,3,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',216244.98,NULL,NULL,1,'2022-10-24 12:54:06','2022-10-24 12:54:06',NULL),(954,7749,40720,1527,3,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',24058.07,NULL,NULL,1,'2022-10-24 12:54:23','2022-10-24 12:54:23',NULL),(955,7749,40720,1527,3,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',140111.44,NULL,NULL,1,'2022-10-24 12:56:25','2022-10-24 12:56:25',NULL),(956,7749,40720,1527,3,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',27201.12,NULL,NULL,1,'2022-10-24 12:59:26','2022-10-24 12:59:26',NULL),(957,7749,40720,1527,2,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',13560.01,NULL,NULL,1,'2022-10-26 09:58:51','2022-10-26 10:02:57','2022-10-26 10:02:57'),(958,7749,40720,1527,2,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',5400.00,NULL,NULL,1,'2022-10-26 09:58:51','2022-10-26 10:03:14','2022-10-26 10:03:14'),(959,7749,40720,1527,2,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2150.00,NULL,NULL,1,'2022-10-26 09:58:51','2022-10-26 10:03:33','2022-10-26 10:03:33'),(960,7749,40720,1527,2,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',11854.95,NULL,NULL,1,'2022-10-26 09:58:51','2022-10-26 10:04:04','2022-10-26 10:04:04'),(961,7749,40720,1527,2,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',8349.98,NULL,NULL,1,'2022-10-26 09:58:51','2022-10-26 10:04:24','2022-10-26 10:04:24'),(962,7749,40720,1527,2,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',12499.99,NULL,NULL,1,'2022-10-26 09:58:51','2022-10-26 10:04:44','2022-10-26 10:04:44'),(963,7749,40720,1527,2,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',7760.02,NULL,NULL,1,'2022-10-26 09:59:04','2022-10-26 09:59:04',NULL),(964,7749,40720,1527,2,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',5799.99,NULL,NULL,1,'2022-10-26 09:59:05','2022-10-26 09:59:05',NULL),(965,7749,40720,1527,2,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',3100.02,NULL,NULL,1,'2022-10-26 09:59:05','2022-10-26 09:59:05',NULL),(966,7749,40720,1527,2,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2299.98,NULL,NULL,1,'2022-10-26 09:59:05','2022-10-26 09:59:05',NULL),(967,7749,40720,1527,2,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2150.00,NULL,NULL,1,'2022-10-26 09:59:05','2022-10-26 09:59:05',NULL),(968,7749,40720,1527,2,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',5999.99,NULL,NULL,1,'2022-10-26 09:59:05','2022-10-26 09:59:05',NULL),(969,7749,40720,1527,2,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2839.99,NULL,NULL,1,'2022-10-26 09:59:05','2022-10-26 09:59:05',NULL),(970,7749,40720,1527,2,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1199.97,NULL,NULL,1,'2022-10-26 09:59:05','2022-10-26 09:59:05',NULL),(971,7749,40720,1527,2,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1815.00,NULL,NULL,1,'2022-10-26 09:59:05','2022-10-26 09:59:05',NULL),(972,7749,40720,1527,2,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',8349.98,NULL,NULL,1,'2022-10-26 09:59:05','2022-10-26 09:59:05',NULL);
INSERT INTO `balance_libro` VALUES (973,7749,40720,1527,2,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',12499.99,NULL,NULL,1,'2022-10-26 09:59:05','2022-10-26 09:59:05',NULL),(974,7749,40720,1527,2,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',112710.00,NULL,NULL,1,'2022-10-26 10:02:57','2022-10-26 10:02:57',NULL),(975,7749,40720,1527,2,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',62660.00,NULL,NULL,1,'2022-10-26 10:03:14','2022-10-26 10:03:14',NULL),(976,7749,40720,1527,2,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',102990.00,NULL,NULL,1,'2022-10-26 10:03:33','2022-10-26 10:03:33',NULL),(977,7749,40720,1527,2,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',78580.00,NULL,NULL,1,'2022-10-26 10:04:04','2022-10-26 10:04:04',NULL),(978,7749,40720,1527,2,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',101020.00,NULL,NULL,1,'2022-10-26 10:04:24','2022-10-26 10:04:24',NULL),(979,7749,40720,1527,2,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',91660.00,NULL,NULL,1,'2022-10-26 10:04:44','2022-10-26 10:04:44',NULL),(980,7749,40720,1527,2,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',7760.00,NULL,NULL,1,'2022-10-26 10:06:38','2022-10-26 10:28:34','2022-10-26 10:28:34'),(981,7749,40720,1527,2,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',5800.00,NULL,NULL,1,'2022-10-26 10:07:04','2022-10-26 10:28:24','2022-10-26 10:28:24'),(982,7749,40720,1527,2,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',3100.00,NULL,NULL,1,'2022-10-26 10:07:29','2022-10-26 10:28:14','2022-10-26 10:28:14'),(983,7749,40720,1527,2,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2300.00,NULL,NULL,1,'2022-10-26 10:07:49','2022-10-26 10:28:04','2022-10-26 10:28:04'),(984,7749,40720,1527,2,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2150.00,NULL,NULL,1,'2022-10-26 10:08:12','2022-10-26 10:27:55','2022-10-26 10:27:55'),(985,7749,40720,1527,2,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',6000.00,NULL,NULL,1,'2022-10-26 10:08:44','2022-10-26 10:27:44','2022-10-26 10:27:44'),(986,7749,40720,1527,2,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2840.00,NULL,NULL,1,'2022-10-26 10:09:06','2022-10-26 10:27:35','2022-10-26 10:27:35'),(987,7749,40720,1527,2,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1200.01,NULL,NULL,1,'2022-10-26 10:09:28','2022-10-26 10:27:29','2022-10-26 10:27:29'),(988,7749,40720,1527,2,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1815.00,NULL,NULL,1,'2022-10-26 10:09:52','2022-10-26 10:27:21','2022-10-26 10:27:21'),(989,7749,40720,1527,2,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',8350.00,NULL,NULL,1,'2022-10-26 10:10:20','2022-10-26 10:27:11','2022-10-26 10:27:11'),(990,7749,40720,1527,2,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',12500.00,NULL,NULL,1,'2022-10-26 10:10:43','2022-10-26 10:27:03','2022-10-26 10:27:03'),(991,7749,40720,1527,2,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',112855.01,NULL,NULL,1,'2022-10-26 10:35:00','2022-10-26 10:35:00',NULL),(992,7749,40720,1527,2,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',4960.00,NULL,NULL,1,'2022-10-26 10:35:24','2022-10-26 10:35:24',NULL);
INSERT INTO `balance_libro` VALUES (993,7749,40720,1527,2,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',79390.00,NULL,NULL,1,'2022-10-26 10:35:50','2022-10-26 10:35:50',NULL),(994,7749,40720,1527,2,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',94460.01,NULL,NULL,1,'2022-10-26 10:36:25','2022-10-26 10:36:25',NULL),(995,7749,40720,1527,3,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',36639.74,NULL,NULL,1,'2022-10-26 10:39:57','2022-10-26 10:39:57',NULL),(996,7749,40720,1527,3,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',31248.45,NULL,NULL,1,'2022-10-26 10:39:57','2022-10-26 10:39:57',NULL),(997,7749,40720,1527,3,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',17221.76,NULL,NULL,1,'2022-10-26 10:39:57','2022-10-26 10:39:57',NULL),(998,7749,40720,1527,3,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',16062.46,NULL,NULL,1,'2022-10-26 10:39:57','2022-10-26 10:39:57',NULL),(999,7749,40720,1527,3,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',4801.42,NULL,NULL,1,'2022-10-26 10:39:57','2022-10-26 10:39:57',NULL),(1000,7749,40720,1527,3,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',178955.23,NULL,NULL,1,'2022-10-26 10:39:57','2022-10-26 10:39:57',NULL),(1001,7749,40720,1527,3,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',51356.78,NULL,NULL,1,'2022-10-26 10:39:57','2022-10-26 10:39:57',NULL),(1002,7749,40720,1527,3,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1828.39,NULL,NULL,1,'2022-10-26 11:27:43','2022-10-26 11:27:43',NULL),(1003,7749,40720,1527,3,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',378820.54,NULL,NULL,1,'2022-10-26 11:28:56','2022-10-26 11:28:56',NULL),(1004,7749,40720,1527,3,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',312604.16,NULL,NULL,1,'2022-10-26 11:29:35','2022-10-26 11:29:35',NULL),(1005,7749,40720,1527,3,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',81169.29,NULL,NULL,1,'2022-10-26 11:29:58','2022-10-26 11:29:58',NULL),(1006,7749,40720,1527,3,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',78768.00,NULL,NULL,1,'2022-11-01 08:55:45','2022-11-14 12:20:28','2022-11-14 12:20:28'),(1007,7749,40720,1527,3,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',3556.55,NULL,NULL,1,'2022-11-01 08:55:45','2022-11-01 08:55:45',NULL),(1008,7749,40720,1527,3,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',5515.80,NULL,NULL,1,'2022-11-01 08:55:45','2022-11-01 08:55:45',NULL),(1009,7749,40720,1527,3,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',7604.09,NULL,NULL,1,'2022-11-01 08:55:45','2022-11-01 08:55:45',NULL),(1010,7749,40720,1527,3,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2801.76,NULL,NULL,1,'2022-11-01 08:55:45','2022-11-01 08:55:45',NULL),(1011,7749,40720,1527,3,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2485.97,NULL,NULL,1,'2022-11-01 08:55:46','2022-11-01 08:55:46',NULL),(1012,7749,40720,1527,3,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2865.85,NULL,NULL,1,'2022-11-01 08:55:46','2022-11-01 08:55:46',NULL),(1013,7749,40720,1527,3,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',56571.13,NULL,NULL,1,'2022-11-01 08:55:46','2022-11-01 08:55:46',NULL);
INSERT INTO `balance_libro` VALUES (1014,7749,40720,1527,3,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',114544.41,NULL,NULL,1,'2022-11-01 08:55:46','2022-11-01 08:55:46',NULL),(1015,7749,40720,1527,3,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',10293.68,NULL,NULL,1,'2022-11-01 08:55:46','2022-11-01 08:55:46',NULL),(1016,7749,40720,1527,3,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6818.91,NULL,NULL,1,'2022-11-01 08:55:46','2022-11-01 08:55:46',NULL),(1017,7749,40720,1527,3,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',9620.14,NULL,NULL,1,'2022-11-01 08:55:46','2022-11-01 08:55:46',NULL),(1018,7749,40720,1527,3,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',19252.02,NULL,NULL,1,'2022-11-01 08:55:46','2022-11-01 08:55:46',NULL),(1019,7749,40720,1527,3,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',72165.97,NULL,NULL,1,'2022-11-01 08:55:46','2022-11-14 11:57:48','2022-11-14 11:57:48'),(1020,7749,40720,1527,3,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',186027.21,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1021,7749,40720,1527,3,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',17840.78,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1022,7749,40720,1527,3,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',12236.35,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1023,7749,40720,1527,3,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',38152.79,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1024,7749,40720,1527,3,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',15341.87,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1025,7749,40720,1527,3,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',14064.01,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1026,7749,40720,1527,3,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',26904.84,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1027,7749,40720,1527,3,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',20750.88,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1028,7749,40720,1527,3,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',24335.39,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1029,7749,40720,1527,3,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',34047.50,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1030,7749,40720,1527,3,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',34704.86,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-14 12:01:48','2022-11-14 12:01:48'),(1031,7749,40720,1527,3,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',7003.42,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1032,7749,40720,1527,3,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',20699.73,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1033,7749,40720,1527,3,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',11861.15,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1034,7749,40720,1527,3,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',15669.54,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL);
INSERT INTO `balance_libro` VALUES (1035,7749,40720,1527,3,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',9059.73,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1036,7749,40720,1527,3,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',8453.93,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1037,7749,40720,1527,3,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',6368.08,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1038,7749,40720,1527,3,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',34281.36,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1039,7749,40720,1527,3,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',12525.99,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1040,7749,40720,1527,3,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',15660.00,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1041,7749,40720,1527,3,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',273090.69,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1042,7749,40720,1527,3,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',6357.55,NULL,NULL,1,'2022-11-01 08:55:47','2022-11-01 08:55:47',NULL),(1043,7749,40720,1527,3,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',375574.35,NULL,NULL,1,'2022-11-01 08:55:48','2022-11-14 12:01:15','2022-11-14 12:01:15'),(1044,7749,40720,1527,3,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',834803.20,NULL,NULL,1,'2022-11-01 08:55:48','2022-11-01 08:55:48',NULL),(1045,7749,40720,1527,3,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',834803.20,NULL,NULL,1,'2022-11-01 08:55:48','2022-11-01 08:55:48',NULL),(1046,7749,40720,1527,3,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',342865.60,NULL,NULL,1,'2022-11-01 08:55:48','2022-11-01 08:55:48',NULL),(1047,7749,40720,1527,3,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',366217.31,NULL,NULL,1,'2022-11-01 08:55:48','2022-11-01 08:55:48',NULL),(1048,7749,40720,1527,3,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',178493.54,NULL,NULL,1,'2022-11-01 08:55:48','2022-11-01 08:55:48',NULL),(1049,7749,40720,1527,3,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',40653.58,NULL,NULL,1,'2022-11-01 08:55:48','2022-11-01 08:55:48',NULL),(1050,7749,40720,1527,3,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',425469.87,NULL,NULL,1,'2022-11-01 08:55:48','2022-11-01 08:55:48',NULL),(1051,7749,40720,1527,3,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',20561.42,NULL,NULL,1,'2022-11-01 08:55:48','2022-11-01 08:55:48',NULL),(1052,7749,40720,1527,3,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',69149.86,NULL,NULL,1,'2022-11-01 08:55:48','2022-11-01 08:55:48',NULL),(1053,7749,40720,1527,3,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',0.79,NULL,NULL,1,'2022-11-01 08:55:48','2022-11-15 10:27:59','2022-11-15 10:27:59'),(1054,7749,40720,1527,3,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',670199.64,NULL,NULL,1,'2022-11-01 08:55:48','2022-11-01 08:55:48',NULL),(1055,7749,40720,1527,3,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4612.74,NULL,NULL,1,'2022-11-01 08:55:48','2022-11-15 10:32:53','2022-11-15 10:32:53');
INSERT INTO `balance_libro` VALUES (1056,7749,40720,1527,3,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',0.00,NULL,NULL,1,'2022-11-01 08:55:48','2022-11-15 10:25:39','2022-11-15 10:25:39'),(1057,7749,40720,1527,2,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1699.99,NULL,NULL,1,'2022-11-01 09:09:42','2022-11-01 09:09:42',NULL),(1058,7749,40720,1527,2,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1699.99,NULL,NULL,1,'2022-11-01 09:09:42','2022-11-01 09:09:42',NULL),(1059,7749,40720,1527,2,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2650.02,NULL,NULL,1,'2022-11-01 09:09:43','2022-11-01 09:09:43',NULL),(1060,7749,40720,1527,2,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2949.98,NULL,NULL,1,'2022-11-01 09:09:43','2022-11-01 09:09:43',NULL),(1061,7749,40720,1527,2,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',500.02,NULL,NULL,1,'2022-11-01 09:09:43','2022-11-01 09:09:43',NULL),(1062,7749,40720,1527,2,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1500.00,NULL,NULL,1,'2022-11-01 09:09:43','2022-11-01 09:09:43',NULL),(1063,7749,40720,1527,2,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',10000.02,NULL,NULL,1,'2022-11-01 09:09:43','2022-11-01 09:09:43',NULL),(1064,7749,40720,1527,2,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',16999.98,NULL,NULL,1,'2022-11-01 09:09:43','2022-11-01 09:09:43',NULL),(1065,7749,40720,1527,2,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',9899.99,NULL,NULL,1,'2022-11-01 09:09:43','2022-11-01 09:09:43',NULL),(1066,7749,40720,1527,2,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2400.01,NULL,NULL,1,'2022-11-01 09:09:43','2022-11-01 09:09:43',NULL),(1067,7749,40720,1527,2,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3900.00,NULL,NULL,1,'2022-11-01 09:09:43','2022-11-01 09:09:43',NULL),(1068,7749,40720,1527,2,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',90640.00,NULL,NULL,1,'2022-11-01 09:13:01','2022-11-01 09:13:01',NULL),(1069,7749,40720,1527,2,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',87300.00,NULL,NULL,1,'2022-11-01 09:13:27','2022-11-01 09:13:27',NULL),(1070,7749,40720,1527,2,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',73220.00,NULL,NULL,1,'2022-11-01 09:13:54','2022-11-01 09:13:54',NULL),(1071,7749,40720,1527,2,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',96445.00,NULL,NULL,1,'2022-11-01 09:14:17','2022-11-01 09:14:17',NULL),(1072,7749,40720,1527,2,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',80780.00,NULL,NULL,1,'2022-11-01 09:14:39','2022-11-01 09:14:39',NULL),(1073,7749,40720,1527,2,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',28900.00,NULL,NULL,1,'2022-11-01 09:20:30','2022-11-01 09:20:30',NULL),(1074,7749,40720,1527,2,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',571200.01,NULL,NULL,1,'2022-11-01 09:32:20','2022-11-01 09:32:20',NULL),(1075,7749,40720,1528,2,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1000.00,NULL,NULL,1,'2022-11-09 09:43:50','2022-11-09 09:43:50',NULL),(1076,7749,40720,1528,2,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',16400.00,NULL,NULL,1,'2022-11-09 09:43:50','2022-11-09 09:43:50',NULL);
INSERT INTO `balance_libro` VALUES (1077,7749,40720,1528,2,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',3000.00,NULL,NULL,1,'2022-11-09 09:43:50','2022-11-09 09:43:50',NULL),(1078,7749,40720,1528,2,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',6800.00,NULL,NULL,1,'2022-11-09 09:43:50','2022-11-09 09:43:50',NULL),(1079,7749,40720,1528,2,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',42400.00,NULL,NULL,1,'2022-11-09 09:43:50','2022-11-09 09:43:50',NULL),(1080,7749,40720,1528,2,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1300.00,NULL,NULL,1,'2022-11-09 09:43:50','2022-11-09 09:43:50',NULL),(1081,7749,40720,1528,2,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4640.00,NULL,NULL,1,'2022-11-09 09:43:50','2022-11-09 09:43:50',NULL),(1082,7749,40720,1528,2,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4050.00,NULL,NULL,1,'2022-11-09 09:43:50','2022-11-09 09:43:50',NULL),(1083,7749,40720,1528,2,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',700.00,NULL,NULL,1,'2022-11-09 09:43:50','2022-11-09 09:43:50',NULL),(1084,7749,40720,1528,2,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',32000.00,NULL,NULL,1,'2022-11-09 09:43:50','2022-11-09 09:43:50',NULL),(1085,7749,40720,1528,2,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',35920.00,NULL,NULL,1,'2022-11-09 09:43:50','2022-11-09 09:43:50',NULL),(1086,7749,40720,1528,2,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2150.00,NULL,NULL,1,'2022-11-09 09:43:50','2022-11-09 09:43:50',NULL),(1087,7749,40720,1528,2,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',7100.00,NULL,NULL,1,'2022-11-09 09:43:50','2022-11-09 09:43:50',NULL),(1088,7749,40720,1528,2,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',10000.00,NULL,NULL,1,'2022-11-09 09:43:50','2022-11-09 09:43:50',NULL),(1089,7749,40720,1528,2,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1300.00,NULL,NULL,1,'2022-11-09 09:43:51','2022-11-09 09:43:51',NULL),(1090,7749,40720,1528,2,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',9100.00,NULL,NULL,1,'2022-11-09 09:43:51','2022-11-09 09:43:51',NULL),(1091,7749,40720,1528,2,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2650.00,NULL,NULL,1,'2022-11-09 09:43:51','2022-11-09 09:43:51',NULL),(1092,7749,40720,1528,2,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',12300.00,NULL,NULL,1,'2022-11-09 09:43:51','2022-11-09 09:43:51',NULL),(1093,7749,40720,1528,2,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',7500.00,NULL,NULL,1,'2022-11-09 09:43:51','2022-11-09 09:43:51',NULL),(1094,7749,40720,1528,2,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',50000.00,NULL,NULL,1,'2022-11-09 09:43:51','2022-11-09 09:43:51',NULL),(1095,7749,40720,1528,2,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',6250.00,NULL,NULL,1,'2022-11-09 09:43:51','2022-11-09 09:43:51',NULL),(1096,7749,40720,1528,2,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',32500.00,NULL,NULL,1,'2022-11-09 09:43:51','2022-11-09 09:43:51',NULL),(1097,7749,40720,1528,2,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4950.00,NULL,NULL,1,'2022-11-09 09:43:51','2022-11-09 09:43:51',NULL);
INSERT INTO `balance_libro` VALUES (1098,7749,40720,1528,2,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',22000.00,NULL,NULL,1,'2022-11-09 09:43:51','2022-11-09 09:43:51',NULL),(1099,7749,40720,1528,2,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1300.00,NULL,NULL,1,'2022-11-09 09:43:51','2022-11-09 09:43:51',NULL),(1100,7749,40720,1528,2,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2600.00,NULL,NULL,1,'2022-11-09 09:43:51','2022-11-09 09:43:51',NULL),(1101,7749,40720,1528,2,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',45000.00,NULL,NULL,1,'2022-11-09 09:43:51','2022-11-09 09:43:51',NULL),(1102,7749,40720,1528,2,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',6280.00,NULL,NULL,1,'2022-11-09 09:43:51','2022-11-09 09:43:51',NULL),(1103,7749,40720,1528,2,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',64158.97,NULL,NULL,1,'2022-11-09 09:43:51','2022-11-09 09:43:51',NULL),(1104,7749,40720,1528,2,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',13299.99,NULL,NULL,1,'2022-11-09 09:43:51','2022-11-09 09:43:51',NULL),(1105,7749,40720,1528,2,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2300.00,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1106,7749,40720,1528,2,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',5499.99,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1107,7749,40720,1528,2,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',13839.99,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1108,7749,40720,1528,2,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',44897.66,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1109,7749,40720,1528,2,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2000.00,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1110,7749,40720,1528,2,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4800.00,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1111,7749,40720,1528,2,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4800.00,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1112,7749,40720,1528,2,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',52149.99,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1113,7749,40720,1528,2,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',63600.00,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1114,7749,40720,1528,2,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',4900.00,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1115,7749,40720,1528,2,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',41100.00,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1116,7749,40720,1528,2,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',10800.00,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1117,7749,40720,1528,2,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',42050.00,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1118,7749,40720,1528,2,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',5430.00,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL);
INSERT INTO `balance_libro` VALUES (1119,7749,40720,1528,2,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',47650.00,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1120,7749,40720,1528,2,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',24250.00,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1121,7749,40720,1528,2,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',143499.91,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1122,7749,40720,1528,2,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',14000.00,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1123,7749,40720,1528,2,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',134999.68,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1124,7749,40720,1528,2,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',89999.99,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1125,7749,40720,1528,2,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',47349.99,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1126,7749,40720,1528,2,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',49250.00,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1127,7749,40720,1528,2,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',138999.80,NULL,NULL,1,'2022-11-09 09:43:52','2022-11-09 09:43:52',NULL),(1128,7749,40720,1528,2,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',6000.00,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1129,7749,40720,1528,2,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',24000.00,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1130,7749,40720,1528,2,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',225386.70,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1131,7749,40720,1528,2,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',24800.00,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1132,7749,40720,1528,2,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',12300.00,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1133,7749,40720,1528,2,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',137779.99,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1134,7749,40720,1528,2,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',148599.99,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1135,7749,40720,1528,2,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',95600.00,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1136,7749,40720,1528,2,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',143400.00,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1137,7749,40720,1528,2,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',122400.00,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1138,7749,40720,1528,2,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',122400.00,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1139,7749,40720,1528,2,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',120000.00,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL);
INSERT INTO `balance_libro` VALUES (1140,7749,40720,1528,2,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',60000.00,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1141,7749,40720,1528,2,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',215250.00,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1142,7749,40720,1528,2,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',150000.00,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1143,7749,40720,1528,2,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',120000.00,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1144,7749,40720,1528,2,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',297499.99,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1145,7749,40720,1528,2,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',88800.00,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1146,7749,40720,1528,2,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',139000.00,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1147,7749,40720,1528,2,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',114400.00,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1148,7749,40720,1528,2,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',130000.00,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1149,7749,40720,1528,2,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',32500.00,NULL,NULL,1,'2022-11-09 09:43:53','2022-11-09 09:43:53',NULL),(1150,7749,40720,1528,2,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',60000.00,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1151,7749,40720,1528,2,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',122350.00,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1152,7749,40720,1528,2,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',1790.00,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1153,7749,40720,1528,2,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',36800.02,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1154,7749,40720,1528,2,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',63500.02,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1155,7749,40720,1528,2,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',40200.00,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1156,7749,40720,1528,2,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',17500.00,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1157,7749,40720,1528,2,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',103000.00,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1158,7749,40720,1528,2,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',95399.99,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1159,7749,40720,1528,2,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',5000.00,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1160,7749,40720,1528,2,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',116797.49,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL);
INSERT INTO `balance_libro` VALUES (1161,7749,40720,1528,2,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',3800.00,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1162,7749,40720,1528,2,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',18000.01,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1163,7749,40720,1528,2,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',440.00,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1164,7749,40720,1528,2,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',7559.99,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1165,7749,40720,1528,2,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',7385.00,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1166,7749,40720,1528,2,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',1280.00,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1167,7749,40720,1528,2,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',9349.98,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1168,7749,40720,1528,2,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',17299.99,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1169,7749,40720,1528,2,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',7500.00,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1170,7749,40720,1528,2,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',7800.00,NULL,NULL,1,'2022-11-09 09:43:54','2022-11-09 09:43:54',NULL),(1171,7749,40720,1528,2,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',2400.00,NULL,NULL,1,'2022-11-09 09:43:55','2022-11-09 09:43:55',NULL),(1172,7749,40720,1528,2,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',5250.00,NULL,NULL,1,'2022-11-09 09:43:55','2022-11-09 09:43:55',NULL),(1173,7749,40720,1528,2,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',1019.99,NULL,NULL,1,'2022-11-09 09:43:55','2022-11-09 09:43:55',NULL),(1174,7749,40720,1528,2,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',8150.00,NULL,NULL,1,'2022-11-09 09:43:55','2022-11-09 09:43:55',NULL),(1175,7749,40720,1528,2,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',35299.92,NULL,NULL,1,'2022-11-09 09:43:55','2022-11-09 09:43:55',NULL),(1176,7749,40720,1528,2,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',8999.97,NULL,NULL,1,'2022-11-09 09:43:55','2022-11-09 09:43:55',NULL),(1177,7749,40720,1528,2,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',4124.99,NULL,NULL,1,'2022-11-09 09:43:55','2022-11-09 09:43:55',NULL),(1178,7749,40720,1528,2,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',10200.00,NULL,NULL,1,'2022-11-09 09:43:55','2022-11-09 09:43:55',NULL),(1179,7749,40720,1528,2,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',8600.00,NULL,NULL,1,'2022-11-09 09:43:55','2022-11-09 09:43:55',NULL),(1180,7749,40720,1528,2,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',84700.00,NULL,NULL,1,'2022-11-09 09:43:55','2022-11-09 09:43:55',NULL),(1181,7749,40720,1528,2,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',9700.00,NULL,NULL,1,'2022-11-09 09:43:55','2022-11-09 09:43:55',NULL);
INSERT INTO `balance_libro` VALUES (1182,7749,40720,1528,3,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',79544.95,NULL,NULL,1,'2022-11-09 09:44:10','2022-11-09 09:44:10',NULL),(1183,7749,40720,1528,3,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',49324.78,NULL,NULL,1,'2022-11-09 09:44:10','2022-11-09 09:44:10',NULL),(1184,7749,40720,1528,3,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',49270.24,NULL,NULL,1,'2022-11-09 09:44:10','2022-11-09 09:44:10',NULL),(1185,7749,40720,1528,3,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',11519.82,NULL,NULL,1,'2022-11-09 09:44:10','2022-11-09 09:44:10',NULL),(1186,7749,40720,1528,3,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',7800.00,NULL,NULL,1,'2022-11-09 09:44:10','2022-11-09 09:44:10',NULL),(1187,7749,40720,1528,3,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',94682.00,NULL,NULL,1,'2022-11-09 09:44:10','2022-11-09 09:44:10',NULL),(1188,7749,40720,1528,3,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',119815.71,NULL,NULL,1,'2022-11-09 09:44:10','2022-11-09 09:44:10',NULL),(1189,7749,40720,1528,3,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',43784.29,NULL,NULL,1,'2022-11-09 09:44:10','2022-11-09 09:44:10',NULL),(1190,7749,40720,1528,3,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',83344.80,NULL,NULL,1,'2022-11-09 09:44:10','2022-11-09 09:44:10',NULL),(1191,7749,40720,1528,3,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',84533.21,NULL,NULL,1,'2022-11-09 09:44:10','2022-12-20 09:30:50','2022-12-20 09:30:50'),(1192,7749,40720,1528,3,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',341601.91,NULL,NULL,1,'2022-11-09 09:44:10','2022-11-09 09:44:10',NULL),(1193,7749,40720,1528,3,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',213110.89,NULL,NULL,1,'2022-11-09 09:44:10','2022-12-16 10:13:02','2022-12-16 10:13:02'),(1194,7749,40720,1528,3,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',168450.01,NULL,NULL,1,'2022-11-09 09:44:10','2022-11-09 09:44:10',NULL),(1195,7749,40720,1528,3,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',192477.81,NULL,NULL,1,'2022-11-09 09:44:10','2022-12-16 12:04:57','2022-12-16 12:04:57'),(1196,7749,40720,1528,3,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',67104.51,NULL,NULL,1,'2022-11-09 09:44:10','2022-11-09 09:44:10',NULL),(1197,7749,40720,1528,3,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',125622.96,NULL,NULL,1,'2022-11-09 09:44:10','2022-11-09 09:44:10',NULL),(1198,7749,40720,1528,3,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',25887.72,NULL,NULL,1,'2022-11-09 09:44:10','2022-11-09 09:44:10',NULL),(1199,7749,40720,1528,3,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',218364.81,NULL,NULL,1,'2022-11-09 09:44:10','2022-11-09 09:44:10',NULL),(1200,7749,40720,1527,3,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',5999.97,NULL,NULL,1,'2022-11-14 11:47:39','2022-11-14 11:47:39',NULL),(1201,7749,40720,1527,3,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',16342.90,NULL,NULL,1,'2022-11-14 11:53:23','2022-11-14 11:53:23',NULL);
INSERT INTO `balance_libro` VALUES (1202,7749,40720,1527,3,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',18501.29,NULL,NULL,1,'2022-11-14 11:55:48','2022-11-14 11:55:48',NULL),(1203,7749,40720,1527,3,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',7000.08,NULL,NULL,1,'2022-11-14 11:56:53','2022-11-14 11:56:53',NULL),(1204,7749,40720,1527,3,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',72165.97,NULL,NULL,1,'2022-11-14 11:57:48','2022-11-14 11:57:48',NULL),(1205,7749,40720,1527,3,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1519.52,NULL,NULL,1,'2022-11-14 11:59:30','2022-11-14 11:59:30',NULL),(1206,7749,40720,1527,3,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',96302.01,NULL,NULL,1,'2022-11-14 11:59:55','2022-11-14 11:59:55',NULL),(1207,7749,40720,1527,3,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',375574.35,NULL,NULL,1,'2022-11-14 12:01:15','2022-11-14 12:01:15',NULL),(1208,7749,40720,1527,3,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',34704.86,NULL,NULL,1,'2022-11-14 12:01:48','2022-11-14 12:01:48',NULL),(1209,7749,40720,1527,3,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4612.74,NULL,NULL,1,'2022-11-15 10:32:53','2022-11-15 10:32:53',NULL),(1210,7749,40720,1527,7,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',3036.63,NULL,NULL,1,'2022-11-16 10:48:32','2022-11-16 10:48:32',NULL),(1211,7749,40720,1527,7,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',438.71,NULL,NULL,1,'2022-11-16 10:48:32','2022-11-16 10:48:32',NULL),(1212,7749,40720,1528,2,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',77999.99,NULL,NULL,1,'2022-11-18 10:28:21','2022-11-18 10:28:21',NULL),(1213,7749,40720,1528,2,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',192099.98,NULL,NULL,1,'2022-11-18 10:28:21','2022-11-18 10:28:21',NULL),(1214,7749,40720,1528,2,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',20000.09,NULL,NULL,1,'2022-11-18 10:28:21','2022-11-18 10:28:21',NULL),(1215,7749,40720,1528,2,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',5600.00,NULL,NULL,1,'2022-11-18 10:28:21','2022-11-18 10:28:21',NULL),(1216,7749,40720,1528,2,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',21800.00,NULL,NULL,1,'2022-11-18 10:28:21','2022-11-18 10:28:21',NULL),(1217,7749,40720,1528,2,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',456.11,NULL,NULL,1,'2022-11-18 10:28:21','2022-11-18 10:28:21',NULL),(1218,7749,40720,1528,2,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',5300.00,NULL,NULL,1,'2022-11-18 10:28:21','2022-11-18 10:28:21',NULL),(1219,7749,40720,1528,2,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',20999.99,NULL,NULL,1,'2022-11-18 10:28:21','2022-11-18 10:28:21',NULL),(1220,7749,40720,1528,2,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',3800.00,NULL,NULL,1,'2022-11-18 10:28:21','2022-11-18 10:28:21',NULL),(1221,7749,40720,1528,2,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',1700.00,NULL,NULL,1,'2022-11-18 10:28:21','2022-11-18 10:28:21',NULL),(1222,7749,40720,1528,2,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',10000.00,NULL,NULL,1,'2022-11-18 10:28:22','2022-11-18 10:28:22',NULL);
INSERT INTO `balance_libro` VALUES (1223,7749,40720,1528,2,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',24000.00,NULL,NULL,1,'2022-11-18 10:28:22','2022-11-18 10:28:22',NULL),(1224,7749,40720,1528,2,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',23000.04,NULL,NULL,1,'2022-11-18 10:28:22','2022-11-18 10:28:22',NULL),(1225,7749,40720,1528,2,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',22500.00,NULL,NULL,1,'2022-11-18 10:28:22','2022-11-18 10:28:22',NULL),(1226,7749,40720,1528,2,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',11999.99,NULL,NULL,1,'2022-11-18 10:28:22','2022-11-18 10:28:22',NULL),(1227,7749,40720,1528,2,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',11999.96,NULL,NULL,1,'2022-11-18 10:28:22','2022-11-18 10:28:22',NULL),(1228,7749,40720,1528,2,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',65995.07,NULL,NULL,1,'2022-11-18 10:28:22','2022-11-18 10:28:22',NULL),(1229,7749,40720,1528,2,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',54999.99,NULL,NULL,1,'2022-11-18 10:28:22','2022-11-18 10:28:22',NULL),(1230,7749,40720,1528,2,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',69600.00,NULL,NULL,1,'2022-11-18 10:28:22','2022-11-18 10:28:22',NULL),(1231,7749,40720,1528,2,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2800.00,NULL,NULL,1,'2022-11-23 09:36:05','2022-11-23 09:36:05',NULL),(1232,7749,40720,1528,2,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',40299.97,NULL,NULL,1,'2022-11-23 09:36:05','2022-12-15 12:29:16','2022-12-15 12:29:16'),(1233,7749,40720,1528,2,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',5860.03,NULL,NULL,1,'2022-11-23 09:36:05','2022-12-15 12:29:38','2022-12-15 12:29:38'),(1234,7749,40720,1528,2,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',1199.97,NULL,NULL,1,'2022-11-23 09:36:06','2022-12-15 12:30:05','2022-12-15 12:30:05'),(1235,7749,40720,1528,2,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',5290.00,NULL,NULL,1,'2022-11-23 09:36:06','2022-12-15 12:30:23','2022-12-15 12:30:23'),(1236,7749,40720,1528,2,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',0.06,NULL,NULL,1,'2022-11-23 09:36:06','2022-11-23 09:36:06',NULL),(1237,7749,40720,1528,2,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',15899.98,NULL,NULL,1,'2022-11-23 09:36:06','2022-11-25 11:22:42','2022-11-25 11:22:42'),(1238,7749,40720,1528,2,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',10499.98,NULL,NULL,1,'2022-11-23 09:36:23','2022-11-23 09:36:23',NULL),(1239,7749,40720,1528,2,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2830.02,NULL,NULL,1,'2022-11-23 09:36:23','2022-11-23 09:36:23',NULL),(1240,7749,40720,1528,2,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',19750.02,NULL,NULL,1,'2022-11-23 09:36:23','2022-11-23 09:36:23',NULL),(1241,7749,40720,1528,2,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',3799.98,NULL,NULL,1,'2022-11-23 09:36:23','2022-11-23 09:36:23',NULL),(1242,7749,40720,1528,2,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',4499.99,NULL,NULL,1,'2022-11-23 09:36:23','2022-11-23 09:36:23',NULL);
INSERT INTO `balance_libro` VALUES (1243,7749,40720,1528,2,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',32000.01,NULL,NULL,1,'2022-11-23 09:36:23','2022-11-23 09:36:23',NULL),(1244,7749,40720,1528,2,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',2000.01,NULL,NULL,1,'2022-11-23 09:36:23','2022-11-23 09:36:23',NULL),(1245,7749,40720,1528,2,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',3860.02,NULL,NULL,1,'2022-11-23 09:36:23','2022-11-23 09:36:23',NULL),(1246,7749,40720,1528,2,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',1199.97,NULL,NULL,1,'2022-11-23 09:36:23','2022-11-23 09:36:23',NULL),(1247,7749,40720,1528,2,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',2200.01,NULL,NULL,1,'2022-11-23 09:36:23','2022-11-23 09:36:23',NULL),(1248,7749,40720,1528,2,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',3089.99,NULL,NULL,1,'2022-11-23 09:36:23','2022-11-23 09:36:23',NULL),(1249,7749,40720,1528,2,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',12499.99,NULL,NULL,1,'2022-11-23 09:36:23','2022-11-23 09:36:23',NULL),(1250,7749,40720,1528,2,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',3399.98,NULL,NULL,1,'2022-11-23 09:36:23','2022-11-23 09:36:23',NULL),(1251,7749,40720,1528,3,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',258.49,NULL,NULL,1,'2022-11-23 09:38:18','2022-12-19 11:29:37','2022-12-19 11:29:37'),(1252,7749,40720,1528,3,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',112484.93,NULL,NULL,1,'2022-11-23 09:38:18','2022-11-23 09:38:18',NULL),(1253,7749,40720,1528,3,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',152513.01,NULL,NULL,1,'2022-11-23 09:38:18','2022-11-23 09:38:18',NULL),(1254,7749,40720,1528,3,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',449329.68,NULL,NULL,1,'2022-11-23 09:38:18','2022-11-23 09:38:18',NULL),(1255,7749,40720,1528,3,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',40754.57,NULL,NULL,1,'2022-11-23 09:38:18','2022-11-23 09:38:18',NULL),(1256,7749,40720,1528,3,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',65062.22,NULL,NULL,1,'2022-11-23 09:38:18','2022-12-16 10:15:41','2022-12-16 10:15:41'),(1257,7749,40720,1528,3,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',5520.89,NULL,NULL,1,'2022-11-23 09:38:18','2022-12-16 10:16:07','2022-12-16 10:16:07'),(1258,7749,40720,1528,3,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',21712.11,NULL,NULL,1,'2022-11-23 09:38:18','2022-12-16 12:13:54','2022-12-16 12:13:54'),(1259,7749,40720,1528,3,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',10630.09,NULL,NULL,1,'2022-11-23 09:38:19','2022-11-23 09:38:19',NULL),(1260,7749,40720,1528,3,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',22990.00,NULL,NULL,1,'2022-11-23 09:38:19','2022-12-16 12:32:39','2022-12-16 12:32:39'),(1261,7749,40720,1528,3,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',227459.91,NULL,NULL,1,'2022-11-23 09:38:19','2022-11-23 09:38:19',NULL),(1262,7749,40720,1528,3,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',1411000.00,NULL,NULL,1,'2022-11-23 09:38:19','2022-12-16 10:18:03','2022-12-16 10:18:03');
INSERT INTO `balance_libro` VALUES (1263,7749,40720,1528,3,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',87783.58,NULL,NULL,1,'2022-11-23 09:38:19','2022-11-23 09:38:19',NULL),(1264,7749,40720,1528,3,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',67960.24,NULL,NULL,1,'2022-11-23 09:38:19','2022-11-23 09:38:19',NULL),(1265,7749,40720,1528,3,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',67139.96,NULL,NULL,1,'2022-11-23 09:38:19','2022-11-23 09:38:19',NULL),(1266,7749,40720,1528,3,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',25424.57,NULL,NULL,1,'2022-11-23 09:38:19','2022-12-16 10:19:19','2022-12-16 10:19:19'),(1267,7749,40720,1528,3,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',97648.51,NULL,NULL,1,'2022-11-23 09:38:19','2022-11-23 09:38:19',NULL),(1268,7749,40720,1528,3,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',5239.28,NULL,NULL,1,'2022-11-23 09:38:19','2022-11-23 09:38:19',NULL),(1269,7749,40720,1528,3,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',6970.42,NULL,NULL,1,'2022-11-23 09:38:19','2022-12-19 11:29:20','2022-12-19 11:29:20'),(1270,7749,40720,1528,3,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',22600.00,NULL,NULL,1,'2022-11-23 09:38:19','2022-11-23 09:38:19',NULL),(1271,7749,40720,1528,3,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',42077.60,NULL,NULL,1,'2022-11-23 09:38:19','2022-11-23 09:38:19',NULL),(1272,7749,40720,1528,3,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',26741.00,NULL,NULL,1,'2022-11-23 09:38:19','2022-11-23 09:38:19',NULL),(1273,7749,40720,1528,3,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',36235.07,NULL,NULL,1,'2022-11-23 09:38:19','2022-11-23 09:38:19',NULL),(1274,7749,40720,1528,3,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',271104.94,NULL,NULL,1,'2022-11-23 09:38:19','2022-11-23 09:38:19',NULL),(1275,7749,40720,1528,3,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',488167.85,NULL,NULL,1,'2022-11-23 09:38:19','2022-12-16 10:23:46','2022-12-16 10:23:46'),(1276,7749,40720,1528,3,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',52867.25,NULL,NULL,1,'2022-11-23 09:38:19','2022-11-23 09:38:19',NULL),(1277,7749,40720,1528,3,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',194003.56,NULL,NULL,1,'2022-11-23 09:38:19','2022-11-23 09:38:19',NULL),(1278,7749,40720,1528,3,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',18466.16,NULL,NULL,1,'2022-11-23 09:38:20','2022-11-23 09:38:20',NULL),(1279,7749,40720,1528,3,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',10204.69,NULL,NULL,1,'2022-11-23 09:38:20','2022-12-16 11:59:24','2022-12-16 11:59:24'),(1280,7749,40720,1528,3,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',32688.56,NULL,NULL,1,'2022-11-23 09:38:20','2022-11-23 09:38:20',NULL),(1281,7749,40720,1528,2,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',2750.00,NULL,NULL,1,'2022-11-23 09:38:47','2022-11-23 09:38:47',NULL),(1282,7749,40720,1528,2,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',4500.00,NULL,NULL,1,'2022-11-23 09:38:47','2022-11-23 09:38:47',NULL);
INSERT INTO `balance_libro` VALUES (1283,7749,40720,1528,2,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',113374.98,NULL,NULL,1,'2022-11-25 11:06:33','2022-11-25 11:06:33',NULL),(1284,7749,40720,1528,2,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',10400.07,NULL,NULL,1,'2022-11-25 11:06:33','2022-11-25 11:13:56','2022-11-25 11:13:56'),(1285,7749,40720,1528,2,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',2900.02,NULL,NULL,1,'2022-11-25 11:06:33','2022-11-25 11:15:38','2022-11-25 11:15:38'),(1286,7749,40720,1528,2,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',33999.96,NULL,NULL,1,'2022-11-25 11:06:33','2022-11-25 11:17:11','2022-11-25 11:17:11'),(1287,7749,40720,1528,2,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',78470.06,NULL,NULL,1,'2022-11-25 11:06:33','2022-11-25 11:06:33',NULL),(1288,7749,40720,1528,2,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',15959.96,NULL,NULL,1,'2022-11-25 11:06:33','2022-11-25 11:19:10','2022-11-25 11:19:10'),(1289,7749,40720,1528,2,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',71549.95,NULL,NULL,1,'2022-11-25 11:06:44','2022-11-25 11:06:44',NULL),(1290,7749,40720,1528,2,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',210833.86,NULL,NULL,1,'2022-11-25 11:06:44','2022-11-25 11:06:44',NULL),(1291,7749,40720,1528,2,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',22399.98,NULL,NULL,1,'2022-11-25 11:06:44','2022-11-25 11:11:42','2022-11-25 11:11:42'),(1292,7749,40720,1528,2,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',6799.97,NULL,NULL,1,'2022-11-25 11:06:44','2022-11-25 11:12:31','2022-11-25 11:12:31'),(1293,7749,40720,1528,2,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',2380.01,NULL,NULL,1,'2022-11-25 11:06:44','2022-11-25 11:12:52','2022-11-25 11:12:52'),(1294,7749,40720,1528,2,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',13479.98,NULL,NULL,1,'2022-11-25 11:06:44','2022-11-25 11:06:44',NULL),(1295,7749,40720,1528,2,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',66989.98,NULL,NULL,1,'2022-11-25 11:06:44','2022-11-25 11:13:30','2022-11-25 11:13:30'),(1296,7749,40720,1528,2,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',3100.02,NULL,NULL,1,'2022-11-25 11:07:03','2022-11-25 11:07:03',NULL),(1297,7749,40720,1528,2,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',5700.02,NULL,NULL,1,'2022-11-25 11:07:03','2022-11-25 11:07:03',NULL),(1298,7749,40720,1528,2,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',1600.02,NULL,NULL,1,'2022-11-25 11:07:03','2022-11-25 11:07:03',NULL),(1299,7749,40720,1528,2,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',1400.03,NULL,NULL,1,'2022-11-25 11:07:03','2022-11-25 11:07:03',NULL),(1300,7749,40720,1528,2,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',5099.98,NULL,NULL,1,'2022-11-25 11:07:03','2022-11-25 11:07:03',NULL),(1301,7749,40720,1528,2,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',16999.98,NULL,NULL,1,'2022-11-25 11:07:03','2022-11-25 11:07:03',NULL),(1302,7749,40720,1528,2,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',16999.98,NULL,NULL,1,'2022-11-25 11:07:03','2022-11-25 11:07:03',NULL);
INSERT INTO `balance_libro` VALUES (1303,7749,40720,1528,2,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',7000.02,NULL,NULL,1,'2022-11-25 11:07:03','2022-11-25 11:07:03',NULL),(1304,7749,40720,1528,2,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',3199.99,NULL,NULL,1,'2022-11-25 11:07:03','2022-11-25 11:07:03',NULL),(1305,7749,40720,1528,2,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2999.99,NULL,NULL,1,'2022-11-25 11:07:03','2022-11-25 11:07:03',NULL),(1306,7749,40720,1528,2,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2499.98,NULL,NULL,1,'2022-11-25 11:07:03','2022-11-25 11:07:03',NULL),(1307,7749,40720,1528,2,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',259.98,NULL,NULL,1,'2022-11-25 11:07:03','2022-11-25 11:07:03',NULL),(1308,7749,40720,1528,2,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',2400.01,NULL,NULL,1,'2022-11-25 11:07:13','2022-11-25 11:07:13',NULL),(1309,7749,40720,1528,2,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',8000.00,NULL,NULL,1,'2022-11-25 11:07:13','2022-11-25 11:07:13',NULL),(1310,7749,40720,1528,2,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',8000.00,NULL,NULL,1,'2022-11-25 11:07:13','2022-11-25 11:07:13',NULL),(1311,7749,40720,1528,2,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',3999.97,NULL,NULL,1,'2022-11-25 11:07:14','2022-11-25 11:07:14',NULL),(1312,7749,40720,1528,2,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2999.99,NULL,NULL,1,'2022-11-25 11:07:14','2022-11-25 11:07:14',NULL),(1313,7749,40720,1528,2,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',700.01,NULL,NULL,1,'2022-11-25 11:07:14','2022-11-25 11:07:14',NULL),(1314,7749,40720,1528,2,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',999.98,NULL,NULL,1,'2022-11-25 11:07:14','2022-11-25 11:07:14',NULL),(1315,7749,40720,1528,2,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2099.98,NULL,NULL,1,'2022-11-25 11:07:14','2022-11-25 11:07:14',NULL),(1316,7749,40720,1528,2,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',2380.01,NULL,NULL,1,'2022-11-25 11:07:14','2022-11-25 11:07:14',NULL),(1317,7749,40720,1528,2,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',66989.98,NULL,NULL,1,'2022-11-25 11:07:14','2022-11-25 11:07:14',NULL),(1318,7749,40720,1528,2,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',78000.02,NULL,NULL,1,'2022-11-25 11:11:42','2022-11-25 11:11:42',NULL),(1319,7749,40720,1528,2,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',62459.99,NULL,NULL,1,'2022-11-25 11:12:31','2022-11-25 11:12:31',NULL),(1320,7749,40720,1528,2,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',51620.00,NULL,NULL,1,'2022-11-25 11:12:52','2022-11-25 11:12:52',NULL),(1321,7749,40720,1528,2,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',101010.00,NULL,NULL,1,'2022-11-25 11:13:30','2022-11-25 11:13:30',NULL),(1322,7749,40720,1528,2,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',65610.00,NULL,NULL,1,'2022-11-25 11:13:56','2022-11-25 11:13:56',NULL),(1323,7749,40720,1528,2,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',2899.99,NULL,NULL,1,'2022-11-25 11:15:38','2022-11-25 11:15:38',NULL);
INSERT INTO `balance_libro` VALUES (1324,7749,40720,1528,2,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',71420.00,NULL,NULL,1,'2022-11-25 11:16:50','2022-11-25 11:16:50',NULL),(1325,7749,40720,1528,2,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',102105.00,NULL,NULL,1,'2022-11-25 11:17:11','2022-11-25 11:17:11',NULL),(1326,7749,40720,1528,2,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',49610.00,NULL,NULL,1,'2022-11-25 11:19:10','2022-11-25 11:19:10',NULL),(1327,7749,40720,1528,2,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',51476.11,NULL,NULL,1,'2022-11-25 11:22:19','2022-11-25 11:22:19',NULL),(1328,7749,40720,1528,2,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',29270.00,NULL,NULL,1,'2022-11-25 11:22:42','2022-11-25 11:22:42',NULL),(1329,7749,40720,1528,2,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',35130.00,NULL,NULL,1,'2022-11-25 11:23:40','2022-11-25 11:23:40',NULL),(1330,7749,40720,1528,3,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',61051.76,NULL,NULL,1,'2022-11-25 11:37:27','2022-11-25 11:37:27',NULL),(1331,7749,40720,1528,3,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',13339.08,NULL,NULL,1,'2022-11-25 11:37:27','2022-11-25 11:37:27',NULL),(1332,7749,40720,1528,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',267594.00,NULL,NULL,1,'2022-11-25 11:37:27','2022-11-25 11:37:27',NULL),(1333,7749,40720,1528,3,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',28133.43,NULL,NULL,1,'2022-11-25 11:37:27','2022-11-25 11:37:27',NULL),(1334,7749,40720,1528,3,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',56900.04,NULL,NULL,1,'2022-11-25 11:37:28','2022-11-25 11:37:28',NULL),(1335,7749,40720,1528,3,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',19124.03,NULL,NULL,1,'2022-11-25 11:37:28','2022-11-25 11:37:28',NULL),(1336,7749,40720,1528,3,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',13227.41,NULL,NULL,1,'2022-11-25 11:37:28','2022-11-25 11:37:28',NULL),(1337,7749,40720,1528,3,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',22142.08,NULL,NULL,1,'2022-11-25 11:37:28','2022-11-25 11:37:28',NULL),(1338,7749,40720,1528,3,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',49998.74,NULL,NULL,1,'2022-11-25 11:37:28','2022-11-25 11:37:28',NULL),(1339,7749,40720,1528,3,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',61894.49,NULL,NULL,1,'2022-11-25 11:37:28','2022-11-25 11:37:28',NULL),(1340,7749,40720,1528,3,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',37992.23,NULL,NULL,1,'2022-11-25 11:37:28','2022-11-25 11:37:28',NULL),(1341,7749,40720,1528,3,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',99168.24,NULL,NULL,1,'2022-11-25 11:37:28','2022-11-25 11:37:28',NULL),(1342,7749,40720,1528,3,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',125299.10,NULL,NULL,1,'2022-11-25 11:37:28','2022-12-19 11:24:35','2022-12-19 11:24:35'),(1343,7749,40720,1528,3,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',134283.81,NULL,NULL,1,'2022-11-25 11:37:28','2022-12-19 11:24:56','2022-12-19 11:24:56');
INSERT INTO `balance_libro` VALUES (1344,7749,40720,1528,3,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',134283.81,NULL,NULL,1,'2022-11-25 11:37:28','2022-12-19 11:24:46','2022-12-19 11:24:46'),(1345,7749,40720,1528,3,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',46600.02,NULL,NULL,1,'2022-11-25 11:37:28','2022-11-25 11:37:28',NULL),(1346,7749,40720,1528,3,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',65027.29,NULL,NULL,1,'2022-11-25 11:37:28','2022-11-25 11:37:28',NULL),(1347,7749,40720,1528,3,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',22990.00,NULL,NULL,1,'2022-11-25 11:37:28','2022-12-16 12:32:52','2022-12-16 12:32:52'),(1348,7749,40720,1528,3,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',8242.30,NULL,NULL,1,'2022-11-25 11:37:28','2022-11-25 11:37:28',NULL),(1349,7749,40720,1528,3,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',16608.95,NULL,NULL,1,'2022-11-25 11:37:28','2022-12-20 10:01:48','2022-12-20 10:01:48'),(1350,7749,40720,1528,3,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',11550.71,NULL,NULL,1,'2022-11-25 11:37:28','2022-12-20 10:01:59','2022-12-20 10:01:59'),(1351,7749,40720,1528,3,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',8202.82,NULL,NULL,1,'2022-11-25 11:37:28','2022-12-20 10:02:09','2022-12-20 10:02:09'),(1352,7749,40720,1528,3,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',9990.00,NULL,NULL,1,'2022-11-25 11:37:28','2022-11-25 11:37:28',NULL),(1353,7749,40720,1528,3,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',22565.82,NULL,NULL,1,'2022-11-25 11:37:28','2022-11-25 11:37:28',NULL),(1354,7749,40720,1528,3,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',171493.28,NULL,NULL,1,'2022-11-25 11:37:28','2022-11-25 11:37:28',NULL),(1355,7749,40720,1528,3,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',12654.23,NULL,NULL,1,'2022-11-25 11:43:18','2022-11-25 11:43:18',NULL),(1356,7749,40720,1528,3,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',25555.73,NULL,NULL,1,'2022-11-25 11:45:06','2022-11-25 11:45:06',NULL),(1357,7749,40720,1528,3,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',43704.60,NULL,NULL,1,'2022-11-25 11:45:36','2022-11-25 11:45:36',NULL),(1358,7749,40720,1528,3,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',17100.29,NULL,NULL,1,'2022-11-25 11:45:52','2022-11-25 11:45:52',NULL),(1359,7749,40720,1528,3,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',39951.55,NULL,NULL,1,'2022-11-25 11:46:10','2022-11-25 11:46:10',NULL),(1360,7749,40720,1528,3,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',42739.11,NULL,NULL,1,'2022-11-25 11:46:24','2022-11-25 11:46:24',NULL),(1361,7749,40720,1528,3,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',763908.39,NULL,NULL,1,'2022-11-25 11:49:38','2022-11-25 11:49:38',NULL),(1362,7749,40720,1528,3,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',113070.83,NULL,NULL,1,'2022-11-25 11:50:57','2022-11-25 11:50:57',NULL),(1363,7749,40720,1528,3,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',26328.43,NULL,NULL,1,'2022-11-25 11:51:14','2022-12-16 10:07:55','2022-12-16 10:07:55');
INSERT INTO `balance_libro` VALUES (1364,7749,40720,1528,3,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',11067.75,NULL,NULL,1,'2022-11-25 11:51:54','2022-11-25 11:51:54',NULL),(1365,7749,40720,1528,3,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',109800.00,NULL,NULL,1,'2022-11-28 08:59:13','2022-12-16 10:49:31','2022-12-16 10:49:31'),(1366,7749,40720,1528,3,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',6152.01,NULL,NULL,1,'2022-11-28 08:59:13','2022-11-28 08:59:13',NULL),(1367,7749,40720,1528,3,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',11116.03,NULL,NULL,1,'2022-11-28 08:59:13','2022-12-20 09:31:39','2022-12-20 09:31:39'),(1368,7749,40720,1528,3,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',7867.38,NULL,NULL,1,'2022-11-28 08:59:13','2022-12-16 12:28:38','2022-12-16 12:28:38'),(1369,7749,40720,1528,3,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',15736.05,NULL,NULL,1,'2022-11-28 08:59:13','2022-12-20 10:02:19','2022-12-20 10:02:19'),(1370,7749,40720,1528,3,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',9322.95,NULL,NULL,1,'2022-11-28 08:59:13','2022-12-20 10:02:33','2022-12-20 10:02:33'),(1371,7749,40720,1528,3,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',10953.42,NULL,NULL,1,'2022-11-28 08:59:13','2022-12-20 10:02:43','2022-12-20 10:02:43'),(1372,7749,40720,1528,3,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',12816.49,NULL,NULL,1,'2022-11-28 08:59:13','2022-12-20 10:02:52','2022-12-20 10:02:52'),(1373,7749,40720,1528,3,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',8629.55,NULL,NULL,1,'2022-11-28 08:59:13','2022-12-20 10:03:02','2022-12-20 10:03:02'),(1374,7749,40720,1528,3,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',12762.13,NULL,NULL,1,'2022-11-28 08:59:13','2022-12-20 10:03:15','2022-12-20 10:03:15'),(1375,7749,40720,1528,3,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',6556.19,NULL,NULL,1,'2022-11-28 08:59:13','2022-12-20 10:03:25','2022-12-20 10:03:25'),(1376,7749,40720,1528,3,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',12547.17,NULL,NULL,1,'2022-11-28 08:59:13','2022-11-28 08:59:13',NULL),(1377,7749,40720,1528,3,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',2299.00,NULL,NULL,1,'2022-11-28 08:59:13','2022-11-28 08:59:13',NULL),(1378,7749,40720,1528,2,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',4807.00,NULL,NULL,1,'2022-11-28 09:45:28','2022-11-28 09:45:28',NULL),(1379,7749,40720,1528,2,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',6409.00,NULL,NULL,1,'2022-11-28 09:45:28','2022-11-28 09:45:28',NULL),(1380,7749,40720,1528,3,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',55569.65,NULL,NULL,1,'2022-11-28 09:47:58','2022-11-28 09:47:58',NULL),(1381,7749,40720,1528,3,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',20635.56,NULL,NULL,1,'2022-11-28 09:48:40','2022-11-28 09:48:40',NULL),(1382,7749,40720,1528,3,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',6111.27,NULL,NULL,1,'2022-11-28 09:49:08','2022-11-28 09:49:08',NULL),(1383,7749,40720,1528,3,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',575500.00,NULL,NULL,1,'2022-11-29 10:09:53','2022-12-16 10:51:22','2022-12-16 10:51:22');
INSERT INTO `balance_libro` VALUES (1384,7749,40720,1528,3,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',538849.79,NULL,NULL,1,'2022-11-29 10:09:53','2022-11-29 10:09:53',NULL),(1385,7749,40720,1528,3,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',150577.27,NULL,NULL,1,'2022-11-29 10:09:53','2022-11-29 10:09:53',NULL),(1386,7749,40720,1528,3,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',77515.17,NULL,NULL,1,'2022-11-30 10:17:45','2022-11-30 10:17:45',NULL),(1387,7749,40720,1528,3,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',29631.86,NULL,NULL,1,'2022-11-30 10:17:45','2022-11-30 10:17:45',NULL),(1388,7749,40720,1528,3,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',37929.07,NULL,NULL,1,'2022-11-30 10:17:45','2022-11-30 10:17:45',NULL),(1389,7749,40720,1528,3,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4663.62,NULL,NULL,1,'2022-11-30 10:17:45','2022-11-30 10:17:45',NULL),(1390,7749,40720,1528,3,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',57064.69,NULL,NULL,1,'2022-11-30 10:17:45','2022-11-30 10:17:45',NULL),(1391,7749,40720,1528,3,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',0.00,NULL,NULL,1,'2022-11-30 10:17:45','2022-11-30 10:17:45',NULL),(1392,7749,40720,1528,3,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',126454.29,NULL,NULL,1,'2022-11-30 10:28:30','2022-11-30 10:28:30',NULL),(1393,7749,40720,1528,3,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',158786.63,NULL,NULL,1,'2022-11-30 10:28:54','2022-11-30 10:28:54',NULL),(1394,7749,40720,1528,2,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',7099.99,NULL,NULL,1,'2022-12-15 11:53:28','2022-12-15 12:03:07','2022-12-15 12:03:07'),(1395,7749,40720,1528,2,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',799.98,NULL,NULL,1,'2022-12-15 11:53:28','2022-12-15 12:02:59','2022-12-15 12:02:59'),(1396,7749,40720,1528,2,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',2250.02,NULL,NULL,1,'2022-12-15 11:53:28','2022-12-15 12:02:51','2022-12-15 12:02:51'),(1397,7749,40720,1528,2,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2600.00,NULL,NULL,1,'2022-12-15 11:53:28','2022-12-15 12:02:43','2022-12-15 12:02:43'),(1398,7749,40720,1528,2,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',12600.02,NULL,NULL,1,'2022-12-15 11:53:28','2022-12-15 12:02:34','2022-12-15 12:02:34'),(1399,7749,40720,1528,2,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',3500.01,NULL,NULL,1,'2022-12-15 11:53:28','2022-12-15 12:02:25','2022-12-15 12:02:25'),(1400,7749,40720,1528,2,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1800.02,NULL,NULL,1,'2022-12-15 11:53:28','2022-12-15 12:02:14','2022-12-15 12:02:14'),(1401,7749,40720,1528,2,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2299.98,NULL,NULL,1,'2022-12-15 11:53:28','2022-12-15 12:02:04','2022-12-15 12:02:04'),(1402,7749,40720,1528,2,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2000.01,NULL,NULL,1,'2022-12-15 11:53:28','2022-12-15 12:01:56','2022-12-15 12:01:56'),(1403,7749,40720,1528,2,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',15800.01,NULL,NULL,1,'2022-12-15 11:53:28','2022-12-15 12:01:48','2022-12-15 12:01:48');
INSERT INTO `balance_libro` VALUES (1404,7749,40720,1528,2,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',549.97,NULL,NULL,1,'2022-12-15 11:53:28','2022-12-15 12:01:36','2022-12-15 12:01:36'),(1405,7749,40720,1528,2,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1600.02,NULL,NULL,1,'2022-12-15 11:53:28','2022-12-15 12:01:23','2022-12-15 12:01:23'),(1406,7749,40720,1528,2,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1300.00,NULL,NULL,1,'2022-12-15 11:53:28','2022-12-15 12:01:13','2022-12-15 12:01:13'),(1407,7749,40720,1528,2,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',6500.00,NULL,NULL,1,'2022-12-15 11:54:22','2022-12-15 11:54:22',NULL),(1408,7749,40720,1528,2,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',5000.00,NULL,NULL,1,'2022-12-15 11:54:22','2022-12-15 11:54:22',NULL),(1409,7749,40720,1528,2,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',565300.00,NULL,NULL,1,'2022-12-15 11:54:22','2022-12-15 11:54:22',NULL),(1410,7749,40720,1528,2,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',347659.00,NULL,NULL,1,'2022-12-15 11:54:22','2022-12-15 11:54:22',NULL),(1411,7749,40720,1528,2,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',482932.00,NULL,NULL,1,'2022-12-15 11:54:22','2022-12-15 11:54:22',NULL),(1412,7749,40720,1528,2,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',250400.03,NULL,NULL,1,'2022-12-15 11:54:22','2022-12-15 11:54:22',NULL),(1413,7749,40720,1528,2,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',1500.00,NULL,NULL,1,'2022-12-15 12:07:06','2022-12-15 12:07:06',NULL),(1414,7749,40720,1528,2,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',1870.03,NULL,NULL,1,'2022-12-15 12:07:06','2022-12-15 12:07:06',NULL),(1415,7749,40720,1528,2,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',3599.98,NULL,NULL,1,'2022-12-15 12:07:06','2022-12-15 12:07:06',NULL),(1416,7749,40720,1528,2,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',1500.00,NULL,NULL,1,'2022-12-15 12:07:06','2022-12-15 12:07:06',NULL),(1417,7749,40720,1528,2,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',3999.97,NULL,NULL,1,'2022-12-15 12:07:06','2022-12-15 12:07:06',NULL),(1418,7749,40720,1528,2,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',2900.02,NULL,NULL,1,'2022-12-15 12:07:06','2022-12-15 12:07:06',NULL),(1419,7749,40720,1528,2,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',6199.98,NULL,NULL,1,'2022-12-15 12:07:06','2022-12-15 12:07:06',NULL),(1420,7749,40720,1528,2,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',3250.00,NULL,NULL,1,'2022-12-15 12:07:06','2022-12-15 12:07:06',NULL),(1421,7749,40720,1528,2,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1600.02,NULL,NULL,1,'2022-12-15 12:07:06','2022-12-15 12:07:06',NULL),(1422,7749,40720,1528,2,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4600.02,NULL,NULL,1,'2022-12-15 12:07:06','2022-12-15 12:07:06',NULL),(1423,7749,40720,1528,2,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',549.97,NULL,NULL,1,'2022-12-15 12:07:06','2022-12-15 12:07:06',NULL);
INSERT INTO `balance_libro` VALUES (1424,7749,40720,1528,2,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',970.02,NULL,NULL,1,'2022-12-15 12:07:06','2022-12-15 12:07:06',NULL),(1425,7749,40720,1528,2,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',2600.00,NULL,NULL,1,'2022-12-15 12:07:06','2022-12-15 12:07:06',NULL),(1426,7749,40720,1528,2,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3700.01,NULL,NULL,1,'2022-12-15 12:07:06','2022-12-15 12:07:06',NULL),(1427,7749,40720,1528,2,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',7600.01,NULL,NULL,1,'2022-12-15 12:07:06','2022-12-15 12:07:06',NULL),(1428,7749,40720,1528,2,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.01,NULL,NULL,1,'2022-12-15 12:07:07','2022-12-15 12:07:07',NULL),(1429,7749,40720,1528,2,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',93310.00,NULL,NULL,1,'2022-12-15 12:29:16','2022-12-15 12:29:16',NULL),(1430,7749,40720,1528,2,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',73079.99,NULL,NULL,1,'2022-12-15 12:29:38','2022-12-15 12:29:38',NULL),(1431,7749,40720,1528,2,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',71430.00,NULL,NULL,1,'2022-12-15 12:30:05','2022-12-15 12:30:05',NULL),(1432,7749,40720,1528,2,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',84930.00,NULL,NULL,1,'2022-12-15 12:30:23','2022-12-15 12:30:23',NULL),(1433,7749,40720,1528,2,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',66680.00,NULL,NULL,1,'2022-12-15 12:31:58','2022-12-15 12:31:58',NULL),(1434,7749,40720,1528,2,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',54560.00,NULL,NULL,1,'2022-12-15 12:32:18','2022-12-15 12:32:18',NULL),(1435,7749,40720,1528,2,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',74010.00,NULL,NULL,1,'2022-12-15 12:32:38','2022-12-15 12:32:38',NULL),(1436,7749,40720,1528,2,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',63920.00,NULL,NULL,1,'2022-12-15 12:33:00','2022-12-15 12:33:00',NULL),(1437,7749,40720,1528,2,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',137620.00,NULL,NULL,1,'2022-12-15 12:33:26','2022-12-15 12:33:26',NULL),(1438,7749,40720,1528,2,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',46545.00,NULL,NULL,1,'2022-12-15 12:33:51','2022-12-15 12:33:51',NULL),(1439,7749,40720,1528,2,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',62870.00,NULL,NULL,1,'2022-12-15 12:34:14','2022-12-15 12:34:14',NULL),(1440,7749,40720,1528,2,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',5800.00,NULL,NULL,1,'2022-12-15 12:37:32','2022-12-15 12:37:32',NULL),(1441,7749,40720,1528,3,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',152521.20,NULL,NULL,1,'2022-12-16 09:34:17','2022-12-16 09:34:17',NULL),(1442,7749,40720,1528,3,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',778.68,NULL,NULL,1,'2022-12-16 09:34:17','2022-12-16 09:34:17',NULL),(1443,7749,40720,1528,3,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',139722.87,NULL,NULL,1,'2022-12-16 09:34:17','2022-12-16 10:53:11','2022-12-16 10:53:11');
INSERT INTO `balance_libro` VALUES (1444,7749,40720,1528,3,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',173439.56,NULL,NULL,1,'2022-12-16 09:34:17','2022-12-20 11:21:12','2022-12-20 11:21:12'),(1445,7749,40720,1528,3,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',311098.70,NULL,NULL,1,'2022-12-16 09:34:17','2022-12-16 10:54:32','2022-12-16 10:54:32'),(1446,7749,40720,1528,3,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',347099.22,NULL,NULL,1,'2022-12-16 09:34:17','2022-12-16 09:34:17',NULL),(1447,7749,40720,1528,3,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',7200.78,NULL,NULL,1,'2022-12-16 09:34:17','2022-12-20 10:03:44','2022-12-20 10:03:44'),(1448,7749,40720,1528,3,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',6706.97,NULL,NULL,1,'2022-12-16 09:34:17','2022-12-20 10:03:55','2022-12-20 10:03:55'),(1449,7749,40720,1528,3,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',7571.84,NULL,NULL,1,'2022-12-16 09:34:17','2022-12-20 10:04:08','2022-12-20 10:04:08'),(1450,7749,40720,1528,3,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',8870.92,NULL,NULL,1,'2022-12-16 09:34:17','2022-12-20 10:04:34','2022-12-20 10:04:34'),(1451,7749,40720,1528,3,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',8775.26,NULL,NULL,1,'2022-12-16 09:34:17','2022-12-20 10:04:43','2022-12-20 10:04:43'),(1452,7749,40720,1528,3,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',12159.12,NULL,NULL,1,'2022-12-16 09:34:17','2022-12-20 10:04:54','2022-12-20 10:04:54'),(1453,7749,40720,1528,3,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',7163.64,NULL,NULL,1,'2022-12-16 09:34:17','2022-12-20 10:05:09','2022-12-20 10:05:09'),(1454,7749,40720,1528,3,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',8042.85,NULL,NULL,1,'2022-12-16 09:34:17','2022-12-20 10:05:19','2022-12-20 10:05:19'),(1455,7749,40720,1528,3,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',11250.21,NULL,NULL,1,'2022-12-16 09:34:17','2022-12-20 10:05:27','2022-12-20 10:05:27'),(1456,7749,40720,1528,3,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',13969.09,NULL,NULL,1,'2022-12-16 09:34:18','2022-12-20 10:05:37','2022-12-20 10:05:37'),(1457,7749,40720,1528,3,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5375.64,NULL,NULL,1,'2022-12-16 09:34:18','2022-12-20 10:05:47','2022-12-20 10:05:47'),(1458,7749,40720,1528,3,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',16448.74,NULL,NULL,1,'2022-12-16 09:34:18','2022-12-20 10:06:03','2022-12-20 10:06:03'),(1459,7749,40720,1528,3,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',16837.69,NULL,NULL,1,'2022-12-16 09:34:18','2022-12-20 10:06:17','2022-12-20 10:06:17'),(1460,7749,40720,1528,3,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',26328.43,NULL,NULL,1,'2022-12-16 10:07:55','2022-12-16 10:07:55',NULL),(1461,7749,40720,1528,3,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',213110.89,NULL,NULL,1,'2022-12-16 10:13:02','2022-12-16 10:13:02',NULL),(1462,7749,40720,1528,3,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',65062.22,NULL,NULL,1,'2022-12-16 10:15:41','2022-12-16 10:15:41',NULL);
INSERT INTO `balance_libro` VALUES (1463,7749,40720,1528,3,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',5520.89,NULL,NULL,1,'2022-12-16 10:16:07','2022-12-16 10:16:07',NULL),(1464,7749,40720,1528,3,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',1411000.00,NULL,NULL,1,'2022-12-16 10:18:03','2022-12-16 10:18:03',NULL),(1465,7749,40720,1528,3,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',25424.57,NULL,NULL,1,'2022-12-16 10:19:19','2022-12-16 10:19:19',NULL),(1466,7749,40720,1528,3,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',488167.85,NULL,NULL,1,'2022-12-16 10:23:46','2022-12-16 10:23:46',NULL),(1467,7749,40720,1528,3,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',6866.11,NULL,NULL,1,'2022-12-16 10:25:43','2022-12-16 10:25:43',NULL),(1468,7749,40720,1528,3,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',109800.00,NULL,NULL,1,'2022-12-16 10:49:31','2022-12-16 10:49:31',NULL),(1469,7749,40720,1528,3,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',575500.00,NULL,NULL,1,'2022-12-16 10:51:22','2022-12-16 10:51:22',NULL),(1470,7749,40720,1528,3,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',139722.87,NULL,NULL,1,'2022-12-16 10:53:11','2022-12-16 10:53:11',NULL),(1471,7749,40720,1528,3,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',311098.70,NULL,NULL,1,'2022-12-16 10:54:32','2022-12-16 10:54:32',NULL),(1472,7749,40720,1528,3,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',10204.69,NULL,NULL,1,'2022-12-16 11:59:24','2022-12-16 11:59:24',NULL),(1473,7749,40720,1528,3,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',192477.81,NULL,NULL,1,'2022-12-16 12:04:57','2022-12-16 12:04:57',NULL),(1474,7749,40720,1528,3,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',21712.12,NULL,NULL,1,'2022-12-16 12:13:54','2022-12-16 12:13:54',NULL),(1475,7749,40720,1528,7,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',1625.64,NULL,NULL,1,'2022-12-19 12:20:50','2022-12-19 12:20:50',NULL),(1476,7749,40720,1528,7,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',46.39,NULL,NULL,1,'2022-12-19 12:20:50','2022-12-19 12:20:50',NULL),(1477,7749,40720,1529,2,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',10150.00,NULL,NULL,1,'2022-12-21 10:46:37','2022-12-22 12:21:43','2022-12-22 12:21:43'),(1478,7749,40720,1529,2,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',15200.02,NULL,NULL,1,'2022-12-21 10:46:37','2022-12-22 12:26:24','2022-12-22 12:26:24'),(1479,7749,40720,1529,2,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',5300.03,NULL,NULL,1,'2022-12-21 10:46:37','2022-12-22 12:26:44','2022-12-22 12:26:44'),(1480,7749,40720,1529,2,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',26389.98,NULL,NULL,1,'2022-12-21 10:46:37','2022-12-22 12:27:12','2022-12-22 12:27:12'),(1481,7749,40720,1529,2,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2299.98,NULL,NULL,1,'2022-12-21 10:46:37','2022-12-22 12:27:43','2022-12-22 12:27:43'),(1482,7749,40720,1529,2,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',17800.02,NULL,NULL,1,'2022-12-21 10:46:37','2022-12-22 12:28:01','2022-12-22 12:28:01');
INSERT INTO `balance_libro` VALUES (1483,7749,40720,1529,2,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',3450.00,NULL,NULL,1,'2022-12-21 10:46:37','2022-12-22 12:28:27','2022-12-22 12:28:27'),(1484,7749,40720,1529,2,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',799.98,NULL,NULL,1,'2022-12-21 10:46:47','2022-12-22 12:29:02','2022-12-22 12:29:02'),(1485,7749,40720,1529,2,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',57210.07,NULL,NULL,1,'2022-12-21 10:46:47','2022-12-22 12:29:25','2022-12-22 12:29:25'),(1486,7749,40720,1529,2,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2700.03,NULL,NULL,1,'2022-12-21 10:46:47','2022-12-22 12:29:48','2022-12-22 12:29:48'),(1487,7749,40720,1529,2,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',4299.99,NULL,NULL,1,'2022-12-21 10:46:47','2022-12-21 10:46:47',NULL),(1488,7749,40720,1529,2,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',9560.04,NULL,NULL,1,'2022-12-21 10:46:47','2022-12-22 12:30:18','2022-12-22 12:30:18'),(1489,7749,40720,1529,2,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',7260.00,NULL,NULL,1,'2022-12-21 10:46:47','2022-12-22 12:30:36','2022-12-22 12:30:36'),(1490,7749,40720,1529,2,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',81880.07,NULL,NULL,1,'2022-12-21 10:46:47','2022-12-22 12:30:56','2022-12-22 12:30:56'),(1491,7749,40720,1529,2,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',7099.99,NULL,NULL,1,'2022-12-21 10:47:15','2022-12-21 10:47:15',NULL),(1492,7749,40720,1529,2,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',799.98,NULL,NULL,1,'2022-12-21 10:47:15','2022-12-21 10:47:15',NULL),(1493,7749,40720,1529,2,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',2250.02,NULL,NULL,1,'2022-12-21 10:47:15','2022-12-21 10:47:15',NULL),(1494,7749,40720,1529,2,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2600.00,NULL,NULL,1,'2022-12-21 10:47:16','2022-12-21 10:47:16',NULL),(1495,7749,40720,1529,2,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',12600.02,NULL,NULL,1,'2022-12-21 10:47:16','2022-12-21 10:47:16',NULL),(1496,7749,40720,1529,2,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',3500.01,NULL,NULL,1,'2022-12-21 10:47:16','2022-12-21 10:47:16',NULL),(1497,7749,40720,1529,2,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1800.02,NULL,NULL,1,'2022-12-21 10:47:16','2022-12-21 10:47:16',NULL),(1498,7749,40720,1529,2,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2299.98,NULL,NULL,1,'2022-12-21 10:47:16','2022-12-21 10:47:16',NULL),(1499,7749,40720,1529,2,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2000.01,NULL,NULL,1,'2022-12-21 10:47:16','2022-12-21 10:47:16',NULL),(1500,7749,40720,1529,2,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',15800.01,NULL,NULL,1,'2022-12-21 10:47:16','2022-12-21 10:47:16',NULL),(1501,7749,40720,1529,2,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',549.97,NULL,NULL,1,'2022-12-21 10:47:16','2022-12-21 10:47:16',NULL),(1502,7749,40720,1529,2,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1600.02,NULL,NULL,1,'2022-12-21 10:47:16','2022-12-21 10:47:16',NULL);
INSERT INTO `balance_libro` VALUES (1503,7749,40720,1529,2,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1300.00,NULL,NULL,1,'2022-12-21 10:47:16','2022-12-21 10:47:16',NULL),(1504,7749,40720,1529,2,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',799.98,NULL,NULL,1,'2022-12-21 10:47:54','2022-12-21 10:47:54',NULL),(1505,7749,40720,1529,2,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2700.03,NULL,NULL,1,'2022-12-21 10:47:54','2022-12-21 10:47:54',NULL),(1506,7749,40720,1529,2,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',4760.02,NULL,NULL,1,'2022-12-21 10:47:54','2022-12-21 10:47:54',NULL),(1507,7749,40720,1529,2,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',4800.01,NULL,NULL,1,'2022-12-21 10:47:54','2022-12-21 10:47:54',NULL),(1508,7749,40720,1529,2,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',360.00,NULL,NULL,1,'2022-12-21 10:47:55','2022-12-21 10:47:55',NULL),(1509,7749,40720,1529,2,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',5000.01,NULL,NULL,1,'2022-12-21 10:47:55','2022-12-21 10:47:55',NULL),(1510,7749,40720,1529,2,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1899.99,NULL,NULL,1,'2022-12-21 10:47:55','2022-12-21 10:47:55',NULL),(1511,7749,40720,1529,2,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',9000.00,NULL,NULL,1,'2022-12-21 10:49:38','2022-12-21 10:49:38',NULL),(1512,7749,40720,1529,2,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1600.00,NULL,NULL,1,'2022-12-21 10:49:38','2022-12-21 10:49:38',NULL),(1513,7749,40720,1529,2,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1200.00,NULL,NULL,1,'2022-12-21 10:49:38','2022-12-21 10:49:38',NULL),(1514,7749,40720,1529,2,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',60.00,NULL,NULL,1,'2022-12-21 10:49:38','2022-12-21 10:49:38',NULL),(1515,7749,40720,1529,2,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',3750.00,NULL,NULL,1,'2022-12-21 10:49:38','2022-12-21 10:49:38',NULL),(1516,7749,40720,1529,2,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2499.99,NULL,NULL,1,'2022-12-21 10:49:38','2022-12-21 10:49:38',NULL),(1517,7749,40720,1529,2,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',19900.00,NULL,NULL,1,'2022-12-21 10:49:38','2022-12-21 10:49:38',NULL),(1518,7749,40720,1529,2,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2100.00,NULL,NULL,1,'2022-12-21 10:49:38','2022-12-21 10:49:38',NULL),(1519,7749,40720,1529,2,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1700.00,NULL,NULL,1,'2022-12-21 10:49:38','2022-12-21 10:49:38',NULL),(1520,7749,40720,1529,2,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',82600.00,NULL,NULL,1,'2022-12-21 10:49:38','2022-12-21 10:49:38',NULL),(1521,7749,40720,1529,2,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',10600.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1522,7749,40720,1529,2,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',7350.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1523,7749,40720,1529,2,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',6000.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL);
INSERT INTO `balance_libro` VALUES (1524,7749,40720,1529,2,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',13000.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1525,7749,40720,1529,2,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',4200.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1526,7749,40720,1529,2,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',3750.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1527,7749,40720,1529,2,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',4129.98,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1528,7749,40720,1529,2,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1980.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1529,7749,40720,1529,2,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',2800.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1530,7749,40720,1529,2,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',5700.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1531,7749,40720,1529,2,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',60.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1532,7749,40720,1529,2,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',4000.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1533,7749,40720,1529,2,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',50160.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1534,7749,40720,1529,2,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',16000.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1535,7749,40720,1529,2,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',4000.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1536,7749,40720,1529,2,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',10199.99,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1537,7749,40720,1529,2,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',4750.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1538,7749,40720,1529,2,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',6000.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1539,7749,40720,1529,2,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',36000.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1540,7749,40720,1529,2,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',15350.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1541,7749,40720,1529,2,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',4500.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1542,7749,40720,1529,2,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',4000.01,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1543,7749,40720,1529,2,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',135000.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1544,7749,40720,1529,2,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',147000.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL);
INSERT INTO `balance_libro` VALUES (1545,7749,40720,1529,2,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',102499.99,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1546,7749,40720,1529,2,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',149000.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1547,7749,40720,1529,2,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',149999.96,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1548,7749,40720,1529,2,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',129500.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1549,7749,40720,1529,2,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',94800.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1550,7749,40720,1529,2,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',60000.00,NULL,NULL,1,'2022-12-21 10:49:39','2022-12-21 10:49:39',NULL),(1551,7749,40720,1529,2,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',73000.00,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1552,7749,40720,1529,2,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',148800.00,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1553,7749,40720,1529,2,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',148800.00,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1554,7749,40720,1529,2,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',15200.00,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1555,7749,40720,1529,2,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',159999.99,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1556,7749,40720,1529,2,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',137500.00,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1557,7749,40720,1529,2,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',137500.00,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1558,7749,40720,1529,2,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',140400.00,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1559,7749,40720,1529,2,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',58000.00,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1560,7749,40720,1529,2,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',98780.00,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1561,7749,40720,1529,2,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',29499.98,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1562,7749,40720,1529,2,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',13200.00,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1563,7749,40720,1529,2,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',26399.99,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1564,7749,40720,1529,2,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',17700.00,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1565,7749,40720,1529,2,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',38400.00,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL);
INSERT INTO `balance_libro` VALUES (1566,7749,40720,1529,2,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',136000.00,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1567,7749,40720,1529,2,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',136000.00,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1568,7749,40720,1529,2,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',136000.00,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1569,7749,40720,1529,2,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',96000.00,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1570,7749,40720,1529,2,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',136000.00,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1571,7749,40720,1529,2,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',129499.99,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1572,7749,40720,1529,2,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',136000.00,NULL,NULL,1,'2022-12-21 10:49:40','2022-12-21 10:49:40',NULL),(1573,7749,40720,1529,2,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',136000.00,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1574,7749,40720,1529,2,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',136000.00,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1575,7749,40720,1529,2,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',120000.00,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1576,7749,40720,1529,2,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',68000.00,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1577,7749,40720,1529,2,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',126999.99,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1578,7749,40720,1529,2,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',126200.00,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1579,7749,40720,1529,2,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',43699.99,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1580,7749,40720,1529,2,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',113899.97,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1581,7749,40720,1529,2,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',113400.00,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1582,7749,40720,1529,2,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',139500.00,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1583,7749,40720,1529,2,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',20000.00,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1584,7749,40720,1529,2,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',30599.99,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1585,7749,40720,1529,2,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',68000.00,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1586,7749,40720,1529,2,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',20100.00,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL);
INSERT INTO `balance_libro` VALUES (1587,7749,40720,1529,2,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',272500.00,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1588,7749,40720,1529,2,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',97500.00,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1589,7749,40720,1529,2,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',106600.00,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1590,7749,40720,1529,2,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',136499.99,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1591,7749,40720,1529,2,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',135499.99,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1592,7749,40720,1529,2,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',27600.00,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1593,7749,40720,1529,2,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',12000.00,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1594,7749,40720,1529,2,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',6020.00,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1595,7749,40720,1529,2,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',4390.00,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1596,7749,40720,1529,2,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',17500.00,NULL,NULL,1,'2022-12-21 10:49:41','2022-12-21 10:49:41',NULL),(1597,7749,40720,1529,2,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2026.44,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1598,7749,40720,1529,2,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',3100.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1599,7749,40720,1529,2,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',7200.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1600,7749,40720,1529,2,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',130479.90,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1601,7749,40720,1529,2,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',3600.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1602,7749,40720,1529,2,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',45000.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1603,7749,40720,1529,2,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',143999.99,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1604,7749,40720,1529,2,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1350.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1605,7749,40720,1529,2,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',3500.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1606,7749,40720,1529,2,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',5271.78,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1607,7749,40720,1529,2,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',3700.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL);
INSERT INTO `balance_libro` VALUES (1608,7749,40720,1529,2,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',3700.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1609,7749,40720,1529,2,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',5930.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1610,7749,40720,1529,2,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',98500.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1611,7749,40720,1529,2,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',98500.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1612,7749,40720,1529,2,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',98500.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1613,7749,40720,1529,2,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',98500.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1614,7749,40720,1529,2,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',98500.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1615,7749,40720,1529,2,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',98500.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1616,7749,40720,1529,2,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',98500.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1617,7749,40720,1529,2,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',98500.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1618,7749,40720,1529,2,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',98500.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1619,7749,40720,1529,2,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',98500.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1620,7749,40720,1529,2,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',98500.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1621,7749,40720,1529,2,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',98500.00,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1622,7749,40720,1529,2,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1199.99,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1623,7749,40720,1529,2,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',73000.01,NULL,NULL,1,'2022-12-21 10:49:42','2022-12-21 10:49:42',NULL),(1624,7749,40720,1529,2,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',6900.00,NULL,NULL,1,'2022-12-21 10:49:43','2022-12-21 10:49:43',NULL),(1625,7749,40720,1529,2,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',140400.00,NULL,NULL,1,'2022-12-21 10:49:43','2022-12-21 10:49:43',NULL),(1626,7749,40720,1529,2,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2100.00,NULL,NULL,1,'2022-12-21 10:49:43','2022-12-21 10:49:43',NULL),(1627,7749,40720,1529,2,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',7830.00,NULL,NULL,1,'2022-12-21 10:49:43','2022-12-21 10:49:43',NULL),(1628,7749,40720,1529,2,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2300.00,NULL,NULL,1,'2022-12-21 10:49:43','2022-12-21 10:49:43',NULL);
INSERT INTO `balance_libro` VALUES (1629,7749,40720,1529,2,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',19949.67,NULL,NULL,1,'2022-12-21 10:49:43','2022-12-21 10:49:43',NULL),(1630,7749,40720,1529,2,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',120749.99,NULL,NULL,1,'2022-12-21 10:49:43','2022-12-21 10:49:43',NULL),(1631,7749,40720,1529,2,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',83999.99,NULL,NULL,1,'2022-12-21 10:49:43','2022-12-21 10:49:43',NULL),(1632,7749,40720,1529,2,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',3050.00,NULL,NULL,1,'2022-12-21 10:49:43','2022-12-21 10:49:43',NULL),(1633,7749,40720,1529,2,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',5550.00,NULL,NULL,1,'2022-12-21 10:49:43','2022-12-21 10:49:43',NULL),(1634,7749,40720,1529,2,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',141060.00,NULL,NULL,1,'2022-12-21 10:49:43','2022-12-21 10:49:43',NULL),(1635,7749,40720,1529,2,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',6900.00,NULL,NULL,1,'2022-12-21 10:49:44','2022-12-21 10:49:44',NULL),(1636,7749,40720,1529,2,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1920.00,NULL,NULL,1,'2022-12-21 10:49:44','2022-12-21 10:49:44',NULL),(1637,7749,40720,1529,2,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',52599.96,NULL,NULL,1,'2022-12-21 10:49:44','2022-12-21 10:49:44',NULL),(1638,7749,40720,1529,2,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',21200.00,NULL,NULL,1,'2022-12-21 10:49:44','2022-12-21 10:49:44',NULL),(1639,7749,40720,1529,2,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1199.99,NULL,NULL,1,'2022-12-21 10:49:44','2022-12-21 10:49:44',NULL),(1640,7749,40720,1529,2,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',7500.00,NULL,NULL,1,'2022-12-21 10:49:44','2022-12-21 10:49:44',NULL),(1641,7749,40720,1529,2,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',22150.00,NULL,NULL,1,'2022-12-21 10:49:44','2022-12-21 10:49:44',NULL),(1642,7749,40720,1529,2,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',12950.00,NULL,NULL,1,'2022-12-21 10:49:44','2022-12-21 10:49:44',NULL),(1643,7749,40720,1529,2,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',5800.00,NULL,NULL,1,'2022-12-21 10:49:44','2022-12-21 10:49:44',NULL),(1644,7749,40720,1529,2,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',3599.99,NULL,NULL,1,'2022-12-21 10:49:44','2022-12-21 10:49:44',NULL),(1645,7749,40720,1529,2,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',12499.99,NULL,NULL,1,'2022-12-21 10:49:44','2022-12-21 10:49:44',NULL),(1646,7749,40720,1529,2,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',149699.96,NULL,NULL,1,'2022-12-21 10:49:44','2022-12-21 10:49:44',NULL),(1647,7749,40720,1529,2,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',33000.00,NULL,NULL,1,'2022-12-21 10:49:44','2022-12-21 10:49:44',NULL),(1648,7749,40720,1529,2,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',21699.95,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1649,7749,40720,1529,2,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',7800.00,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL);
INSERT INTO `balance_libro` VALUES (1650,7749,40720,1529,2,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',12430.00,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1651,7749,40720,1529,2,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',29999.99,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1652,7749,40720,1529,2,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',135250.00,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1653,7749,40720,1529,2,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',149625.33,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1654,7749,40720,1529,2,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',9400.01,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1655,7749,40720,1529,2,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',133949.99,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1656,7749,40720,1529,2,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',7449.99,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1657,7749,40720,1529,2,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',120000.00,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1658,7749,40720,1529,2,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',100539.99,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1659,7749,40720,1529,2,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',11350.00,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1660,7749,40720,1529,2,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',96000.00,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1661,7749,40720,1529,2,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',78400.00,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1662,7749,40720,1529,2,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',128000.00,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1663,7749,40720,1529,2,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',52599.95,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1664,7749,40720,1529,2,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',140000.00,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1665,7749,40720,1529,2,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',140000.00,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1666,7749,40720,1529,2,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',78299.99,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1667,7749,40720,1529,2,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',98800.00,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1668,7749,40720,1529,2,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',125500.00,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1669,7749,40720,1529,2,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',116000.00,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL),(1670,7749,40720,1529,2,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',116000.00,NULL,NULL,1,'2022-12-21 10:49:45','2022-12-21 10:49:45',NULL);
INSERT INTO `balance_libro` VALUES (1671,7749,40720,1529,2,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2100.00,NULL,NULL,1,'2022-12-21 10:49:46','2022-12-21 10:49:46',NULL),(1672,7749,40720,1529,2,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',116000.00,NULL,NULL,1,'2022-12-21 10:49:46','2022-12-21 10:49:46',NULL),(1673,7749,40720,1529,2,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',26399.99,NULL,NULL,1,'2022-12-21 10:49:46','2022-12-21 10:49:46',NULL),(1674,7749,40720,1529,2,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',116000.00,NULL,NULL,1,'2022-12-21 10:49:46','2022-12-21 10:49:46',NULL),(1675,7749,40720,1529,2,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',44750.00,NULL,NULL,1,'2022-12-21 10:49:46','2022-12-21 10:49:46',NULL),(1676,7749,40720,1529,2,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',66499.48,NULL,NULL,1,'2022-12-21 10:49:46','2022-12-21 10:49:46',NULL),(1677,7749,40720,1529,2,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',3700.00,NULL,NULL,1,'2022-12-21 10:49:46','2022-12-21 10:49:46',NULL),(1678,7749,40720,1529,2,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',4560.00,NULL,NULL,1,'2022-12-21 10:49:46','2022-12-21 10:49:46',NULL),(1679,7749,40720,1529,2,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',6900.00,NULL,NULL,1,'2022-12-21 10:49:46','2022-12-21 10:49:46',NULL),(1680,7749,40720,1529,2,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',8200.00,NULL,NULL,1,'2022-12-21 10:49:46','2022-12-21 10:49:46',NULL),(1681,7749,40720,1529,2,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',8800.04,NULL,NULL,1,'2022-12-22 10:55:01','2022-12-22 12:31:21','2022-12-22 12:31:21'),(1682,7749,40720,1529,2,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',20350.01,NULL,NULL,1,'2022-12-22 10:55:01','2022-12-22 12:31:39','2022-12-22 12:31:39'),(1683,7749,40720,1529,2,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',79400.03,NULL,NULL,1,'2022-12-22 10:55:01','2022-12-22 12:31:57','2022-12-22 12:31:57'),(1684,7749,40720,1529,2,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',13450.07,NULL,NULL,1,'2022-12-22 10:55:01','2022-12-22 12:32:20','2022-12-22 12:32:20'),(1685,7749,40720,1529,2,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1400.03,NULL,NULL,1,'2022-12-22 10:55:01','2022-12-22 12:32:50','2022-12-22 12:32:50'),(1686,7749,40720,1529,2,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',5400.00,NULL,NULL,1,'2022-12-22 10:55:01','2022-12-22 12:33:07','2022-12-22 12:33:07'),(1687,7749,40720,1529,2,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',135039.98,NULL,NULL,1,'2022-12-22 10:55:01','2022-12-22 10:55:01',NULL),(1688,7749,40720,1529,2,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2800.00,NULL,NULL,1,'2022-12-22 10:55:19','2022-12-22 10:55:19',NULL),(1689,7749,40720,1529,2,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2200.01,NULL,NULL,1,'2022-12-22 10:55:19','2022-12-22 10:55:19',NULL),(1690,7749,40720,1529,2,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1100.01,NULL,NULL,1,'2022-12-22 10:55:19','2022-12-22 10:55:19',NULL);
INSERT INTO `balance_libro` VALUES (1691,7749,40720,1529,2,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1300.00,NULL,NULL,1,'2022-12-22 10:55:19','2022-12-22 10:55:19',NULL),(1692,7749,40720,1529,2,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1400.03,NULL,NULL,1,'2022-12-22 10:55:19','2022-12-22 10:55:19',NULL),(1693,7749,40720,1529,2,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',20350.01,NULL,NULL,1,'2022-12-22 10:55:19','2022-12-22 10:55:19',NULL),(1694,7749,40720,1529,2,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',3500.01,NULL,NULL,1,'2022-12-22 10:55:19','2022-12-22 10:55:19',NULL),(1695,7749,40720,1529,2,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',1400.03,NULL,NULL,1,'2022-12-22 10:55:19','2022-12-22 10:55:19',NULL),(1696,7749,40720,1529,2,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',70000.00,NULL,NULL,1,'2022-12-22 10:55:19','2022-12-22 10:55:19',NULL),(1697,7749,40720,1529,2,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',4499.99,NULL,NULL,1,'2022-12-22 10:55:19','2022-12-22 10:55:19',NULL),(1698,7749,40720,1529,2,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1400.03,NULL,NULL,1,'2022-12-22 10:55:19','2022-12-22 10:55:19',NULL),(1699,7749,40720,1529,2,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',3500.01,NULL,NULL,1,'2022-12-22 10:55:19','2022-12-22 10:55:19',NULL),(1700,7749,40720,1529,2,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',1899.99,NULL,NULL,1,'2022-12-22 10:55:19','2022-12-22 10:55:19',NULL),(1701,7749,40720,1529,3,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',11700.43,NULL,NULL,1,'2022-12-22 12:15:16','2022-12-22 12:15:16',NULL),(1702,7749,40720,1529,3,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1.18,NULL,NULL,1,'2022-12-22 12:15:16','2022-12-22 12:15:16',NULL),(1703,7749,40720,1529,3,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',24738.63,NULL,NULL,1,'2022-12-22 12:15:16','2022-12-22 12:15:16',NULL),(1704,7749,40720,1529,3,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',138839.69,NULL,NULL,1,'2022-12-22 12:15:16','2022-12-22 12:15:16',NULL),(1705,7749,40720,1529,3,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',245666.20,NULL,NULL,1,'2022-12-22 12:15:16','2022-12-22 12:15:16',NULL),(1706,7749,40720,1529,3,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',32243.78,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1707,7749,40720,1529,3,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',49222.64,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1708,7749,40720,1529,3,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',185800.06,NULL,NULL,1,'2022-12-22 12:15:17','2023-01-05 11:01:13','2023-01-05 11:01:13'),(1709,7749,40720,1529,3,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',17080.00,NULL,NULL,1,'2022-12-22 12:15:17','2023-01-17 11:36:41','2023-01-17 11:36:41'),(1710,7749,40720,1529,3,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',179014.08,NULL,NULL,1,'2022-12-22 12:15:17','2023-01-05 11:13:01','2023-01-05 11:13:01');
INSERT INTO `balance_libro` VALUES (1711,7749,40720,1529,3,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',47099.38,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1712,7749,40720,1529,3,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',41971.13,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1713,7749,40720,1529,3,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',16.94,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1714,7749,40720,1529,3,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',106272.82,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1715,7749,40720,1529,3,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',49531.04,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1716,7749,40720,1529,3,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',127631.57,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1717,7749,40720,1529,3,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',32310.00,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1718,7749,40720,1529,3,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',58103.37,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1719,7749,40720,1529,3,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',18648.87,NULL,NULL,1,'2022-12-22 12:15:17','2023-01-17 11:36:57','2023-01-17 11:36:57'),(1720,7749,40720,1529,3,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',40770.01,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1721,7749,40720,1529,3,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',685055.57,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1722,7749,40720,1529,3,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',16705.83,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1723,7749,40720,1529,3,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',143000.00,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1724,7749,40720,1529,3,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',131886.13,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1725,7749,40720,1529,3,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',75804.69,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1726,7749,40720,1529,3,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',97959.66,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1727,7749,40720,1529,3,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',45853.75,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1728,7749,40720,1529,3,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',43488.55,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL),(1729,7749,40720,1529,3,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',27039.21,NULL,NULL,1,'2022-12-22 12:15:17','2023-01-17 11:37:10','2023-01-17 11:37:10'),(1730,7749,40720,1529,3,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',4300.27,NULL,NULL,1,'2022-12-22 12:15:17','2022-12-22 12:15:17',NULL);
INSERT INTO `balance_libro` VALUES (1731,7749,40720,1529,3,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',2427.88,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1732,7749,40720,1529,3,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',2460.63,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1733,7749,40720,1529,3,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',4770.74,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1734,7749,40720,1529,3,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',4245.94,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1735,7749,40720,1529,3,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',4986.05,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1736,7749,40720,1529,3,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',2397.98,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1737,7749,40720,1529,3,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',34607.21,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1738,7749,40720,1529,3,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',104170.64,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1739,7749,40720,1529,3,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',28675.14,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1740,7749,40720,1529,3,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',158158.52,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1741,7749,40720,1529,3,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',309763.59,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1742,7749,40720,1529,3,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',97651.99,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1743,7749,40720,1529,3,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',32550.67,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1744,7749,40720,1529,3,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',38396.36,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1745,7749,40720,1529,3,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',15977.37,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1746,7749,40720,1529,3,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',10634.59,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1747,7749,40720,1529,3,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',9832.00,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1748,7749,40720,1529,3,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',45328.34,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1749,7749,40720,1529,3,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',131555.14,NULL,NULL,1,'2022-12-22 12:15:18','2023-01-05 11:12:25','2023-01-05 11:12:25'),(1750,7749,40720,1529,3,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',7063.32,NULL,NULL,1,'2022-12-22 12:15:18','2023-01-05 11:08:09','2023-01-05 11:08:09');
INSERT INTO `balance_libro` VALUES (1751,7749,40720,1529,3,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',219670.44,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1752,7749,40720,1529,3,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',22065.45,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1753,7749,40720,1529,3,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',179319.65,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1754,7749,40720,1529,3,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',44026.81,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1755,7749,40720,1529,3,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',17149.33,NULL,NULL,1,'2022-12-22 12:15:18','2022-12-22 12:15:18',NULL),(1756,7749,40720,1529,3,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',125299.10,NULL,NULL,1,'2022-12-22 12:15:18','2023-01-05 11:24:59','2023-01-05 11:24:59'),(1757,7749,40720,1529,3,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',11341.95,NULL,NULL,1,'2022-12-22 12:15:19','2022-12-22 12:15:19',NULL),(1758,7749,40720,1529,3,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',5150.39,NULL,NULL,1,'2022-12-22 12:15:19','2022-12-22 12:15:19',NULL),(1759,7749,40720,1529,3,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',2556.92,NULL,NULL,1,'2022-12-22 12:15:19','2022-12-22 12:15:19',NULL),(1760,7749,40720,1529,3,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',642.50,NULL,NULL,1,'2022-12-22 12:15:19','2022-12-22 12:15:19',NULL),(1761,7749,40720,1529,3,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',396.98,NULL,NULL,1,'2022-12-22 12:15:19','2022-12-22 12:15:19',NULL),(1762,7749,40720,1529,3,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',7410.32,NULL,NULL,1,'2022-12-22 12:15:19','2023-01-17 10:55:55','2023-01-17 10:55:55'),(1763,7749,40720,1529,3,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',60594.00,NULL,NULL,1,'2022-12-22 12:15:19','2023-01-16 11:50:14','2023-01-16 11:50:14'),(1764,7749,40720,1529,3,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',63944.51,NULL,NULL,1,'2022-12-22 12:15:19','2022-12-22 12:15:19',NULL),(1765,7749,40720,1529,3,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',29800.00,NULL,NULL,1,'2022-12-22 12:15:19','2023-01-05 11:00:18','2023-01-05 11:00:18'),(1766,7749,40720,1529,3,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',11868.10,NULL,NULL,1,'2022-12-22 12:15:19','2022-12-22 12:15:19',NULL),(1767,7749,40720,1529,3,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',15087.25,NULL,NULL,1,'2022-12-22 12:15:19','2022-12-22 12:15:19',NULL),(1768,7749,40720,1529,2,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',106249.97,NULL,NULL,1,'2022-12-22 12:21:43','2022-12-22 12:25:59','2022-12-22 12:25:59'),(1769,7749,40720,1529,2,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',118350.00,NULL,NULL,1,'2022-12-22 12:25:59','2022-12-22 12:25:59',NULL),(1770,7749,40720,1529,2,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',95650.00,NULL,NULL,1,'2022-12-22 12:26:24','2022-12-22 12:26:24',NULL);
INSERT INTO `balance_libro` VALUES (1771,7749,40720,1529,2,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',37049.99,NULL,NULL,1,'2022-12-22 12:26:44','2022-12-22 12:26:44',NULL),(1772,7749,40720,1529,2,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',26390.00,NULL,NULL,1,'2022-12-22 12:27:12','2022-12-22 12:27:12',NULL),(1773,7749,40720,1529,2,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',83790.00,NULL,NULL,1,'2022-12-22 12:27:43','2022-12-22 12:27:43',NULL),(1774,7749,40720,1529,2,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',105230.00,NULL,NULL,1,'2022-12-22 12:28:01','2022-12-22 12:28:01',NULL),(1775,7749,40720,1529,2,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',122340.00,NULL,NULL,1,'2022-12-22 12:28:27','2022-12-22 12:28:27',NULL),(1776,7749,40720,1529,2,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',67389.99,NULL,NULL,1,'2022-12-22 12:29:02','2022-12-22 12:29:02',NULL),(1777,7749,40720,1529,2,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',57210.00,NULL,NULL,1,'2022-12-22 12:29:25','2022-12-22 12:29:25',NULL),(1778,7749,40720,1529,2,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',89610.00,NULL,NULL,1,'2022-12-22 12:29:48','2022-12-22 12:29:48',NULL),(1779,7749,40720,1529,2,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',73600.00,NULL,NULL,1,'2022-12-22 12:30:18','2022-12-22 12:30:18',NULL),(1780,7749,40720,1529,2,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',26245.00,NULL,NULL,1,'2022-12-22 12:30:36','2022-12-22 12:30:36',NULL),(1781,7749,40720,1529,2,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',81880.00,NULL,NULL,1,'2022-12-22 12:30:56','2022-12-22 12:30:56',NULL),(1782,7749,40720,1529,2,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',112105.00,NULL,NULL,1,'2022-12-22 12:31:21','2022-12-22 12:31:21',NULL),(1783,7749,40720,1529,2,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',109970.00,NULL,NULL,1,'2022-12-22 12:31:39','2022-12-22 12:31:39',NULL),(1784,7749,40720,1529,2,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',84190.00,NULL,NULL,1,'2022-12-22 12:31:57','2022-12-22 12:31:57',NULL),(1785,7749,40720,1529,2,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',13450.00,NULL,NULL,1,'2022-12-22 12:32:20','2022-12-22 12:32:20',NULL),(1786,7749,40720,1529,2,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',98350.00,NULL,NULL,1,'2022-12-22 12:32:50','2022-12-22 12:32:50',NULL),(1787,7749,40720,1529,2,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',106260.00,NULL,NULL,1,'2022-12-22 12:33:07','2022-12-22 12:33:07',NULL),(1788,7749,40720,1529,3,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',52788.07,NULL,NULL,1,'2022-12-26 09:13:16','2023-01-05 11:09:39','2023-01-05 11:09:39'),(1789,7749,40720,1529,3,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',61445.79,NULL,NULL,1,'2022-12-26 09:13:17','2023-01-17 11:37:24','2023-01-17 11:37:24'),(1790,7749,40720,1529,3,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',3655.00,NULL,NULL,1,'2022-12-26 09:13:17','2022-12-26 09:13:17',NULL);
INSERT INTO `balance_libro` VALUES (1791,7749,40720,1529,3,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',7528.86,NULL,NULL,1,'2022-12-26 09:13:17','2023-01-16 12:50:39','2023-01-16 12:50:39'),(1792,7749,40720,1529,3,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',25470.00,NULL,NULL,1,'2022-12-26 09:13:17','2022-12-26 09:13:17',NULL),(1793,7749,40720,1529,2,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',15774.90,NULL,NULL,1,'2022-12-26 09:18:24','2022-12-26 09:23:43','2022-12-26 09:23:43'),(1794,7749,40720,1529,2,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',42570.85,NULL,NULL,1,'2022-12-26 09:19:12','2022-12-26 09:23:34','2022-12-26 09:23:34'),(1795,7749,40720,1529,2,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',48013.60,NULL,NULL,1,'2022-12-26 09:19:51','2022-12-26 09:23:27','2022-12-26 09:23:27'),(1796,7749,40720,1529,2,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',68115.80,NULL,NULL,1,'2022-12-26 09:20:29','2022-12-26 09:23:21','2022-12-26 09:23:21'),(1797,7749,40720,1529,2,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',16371.48,NULL,NULL,1,'2022-12-26 09:20:49','2022-12-26 09:23:14','2022-12-26 09:23:14'),(1798,7749,40720,1529,2,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',24198.52,NULL,NULL,1,'2022-12-26 09:21:20','2022-12-26 09:23:08','2022-12-26 09:23:08'),(1799,7749,40720,1529,2,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',66883.03,NULL,NULL,1,'2022-12-26 09:21:41','2022-12-26 09:22:36','2022-12-26 09:22:36'),(1800,7749,40720,1529,2,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',38757.41,NULL,NULL,1,'2022-12-26 09:22:16','2022-12-26 09:22:56','2022-12-26 09:22:56'),(1801,7749,40720,1529,3,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',15774.90,NULL,NULL,1,'2022-12-26 09:25:03','2022-12-26 09:25:03',NULL),(1802,7749,40720,1529,3,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',66883.03,NULL,NULL,1,'2022-12-26 09:25:24','2022-12-26 09:25:24',NULL),(1803,7749,40720,1529,3,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',38757.41,NULL,NULL,1,'2022-12-26 09:25:42','2022-12-26 09:25:42',NULL),(1804,7749,40720,1529,3,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',16371.48,NULL,NULL,1,'2022-12-26 09:26:05','2022-12-26 09:26:05',NULL),(1805,7749,40720,1529,3,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',24198.52,NULL,NULL,1,'2022-12-26 09:26:24','2022-12-26 09:26:24',NULL),(1806,7749,40720,1529,3,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',68115.80,NULL,NULL,1,'2022-12-26 09:26:48','2022-12-26 09:26:48',NULL),(1807,7749,40720,1529,3,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',48013.60,NULL,NULL,1,'2022-12-26 09:27:09','2022-12-26 09:28:30','2022-12-26 09:28:30'),(1808,7749,40720,1529,3,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',42570.85,NULL,NULL,1,'2022-12-26 09:28:14','2022-12-26 09:28:14',NULL),(1809,7749,40720,1529,3,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',48013.60,NULL,NULL,1,'2022-12-26 09:28:30','2022-12-26 09:28:30',NULL),(1810,7749,40720,1529,3,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',34464.77,NULL,NULL,1,'2022-12-26 09:31:58','2022-12-26 09:31:58',NULL);
INSERT INTO `balance_libro` VALUES (1811,7749,40720,1529,3,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',22541.30,NULL,NULL,1,'2022-12-26 09:32:22','2022-12-26 09:32:22',NULL),(1812,7749,40720,1529,3,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',54826.41,NULL,NULL,1,'2022-12-26 09:32:59','2023-01-05 11:10:52','2023-01-05 11:10:52'),(1813,7749,40720,1529,3,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',7999.94,NULL,NULL,1,'2022-12-26 11:27:08','2022-12-26 11:27:08',NULL),(1814,7749,40720,1529,3,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',10000.06,NULL,NULL,1,'2022-12-26 11:27:41','2022-12-26 11:27:41',NULL),(1815,7749,40720,1529,3,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',10599.89,NULL,NULL,1,'2022-12-26 11:55:57','2022-12-26 11:55:57',NULL),(1816,7749,40720,1529,3,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1242882.28,NULL,NULL,1,'2022-12-28 09:47:47','2022-12-28 09:47:47',NULL),(1817,7749,40720,1529,3,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1652230.80,NULL,NULL,1,'2022-12-28 09:47:47','2023-01-16 12:44:59','2023-01-16 12:44:59'),(1818,7749,40720,1529,3,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1652230.80,NULL,NULL,1,'2022-12-28 09:47:47','2023-01-16 12:44:49','2023-01-16 12:44:49'),(1819,7749,40720,1529,3,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',813120.00,NULL,NULL,1,'2022-12-28 09:47:47','2022-12-28 09:47:47',NULL),(1820,7749,40720,1529,3,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',969835.47,NULL,NULL,1,'2022-12-28 09:47:47','2022-12-28 09:47:47',NULL),(1821,7749,40720,1529,3,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',156781.80,NULL,NULL,1,'2022-12-28 09:47:47','2022-12-28 09:47:47',NULL),(1822,7749,40720,1529,3,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1311467.50,NULL,NULL,1,'2022-12-28 09:47:47','2022-12-28 09:47:47',NULL),(1823,7749,40720,1529,3,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',181990.34,NULL,NULL,1,'2022-12-28 09:47:47','2022-12-28 09:47:47',NULL),(1824,7749,40720,1529,3,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',33536.47,NULL,NULL,1,'2022-12-28 09:47:48','2023-01-05 10:57:40','2023-01-05 10:57:40'),(1825,7749,40720,1529,3,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',73391.78,NULL,NULL,1,'2022-12-28 09:47:48','2022-12-28 09:47:48',NULL),(1826,7749,40720,1529,3,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',30722.89,NULL,NULL,1,'2022-12-28 09:47:48','2022-12-28 09:47:48',NULL),(1827,7749,40720,1529,3,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',53732.25,NULL,NULL,1,'2022-12-28 09:47:48','2022-12-28 09:47:48',NULL),(1828,7749,40720,1529,2,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',67000.00,NULL,NULL,1,'2022-12-28 09:52:28','2022-12-28 09:52:28',NULL),(1829,7749,40720,1529,2,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',167000.00,NULL,NULL,1,'2022-12-28 09:52:28','2022-12-28 09:52:28',NULL),(1830,7749,40720,1529,2,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',67000.00,NULL,NULL,1,'2022-12-28 09:52:28','2022-12-28 09:52:28',NULL);
INSERT INTO `balance_libro` VALUES (1831,7749,40720,1529,2,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',357000.00,NULL,NULL,1,'2022-12-28 09:52:28','2022-12-28 09:52:28',NULL),(1832,7749,40720,1529,2,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',213260.00,NULL,NULL,1,'2022-12-28 09:52:28','2022-12-28 09:52:28',NULL),(1833,7749,40720,1529,2,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',265540.00,NULL,NULL,1,'2022-12-28 09:52:28','2022-12-28 09:52:28',NULL),(1834,7749,40720,1529,3,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',967196.97,NULL,NULL,1,'2022-12-29 09:10:48','2022-12-29 09:10:48',NULL),(1835,7749,40720,1529,3,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',57066.27,NULL,NULL,1,'2022-12-29 09:10:48','2022-12-29 09:10:48',NULL),(1836,7749,40720,1529,3,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',148021.07,NULL,NULL,1,'2022-12-29 09:10:49','2023-01-17 11:38:07','2023-01-17 11:38:07'),(1837,7749,40720,1529,3,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',1456407.51,NULL,NULL,1,'2022-12-29 09:10:49','2022-12-29 09:10:49',NULL),(1838,7749,40720,1529,3,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',137816.30,NULL,NULL,1,'2022-12-29 09:10:49','2022-12-29 09:10:49',NULL),(1839,7749,40720,1529,3,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',57998.65,NULL,NULL,1,'2022-12-30 08:53:40','2022-12-30 08:53:40',NULL),(1840,7749,40720,1529,3,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',44915.72,NULL,NULL,1,'2022-12-30 08:53:41','2022-12-30 08:53:41',NULL),(1841,7749,40720,1529,3,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',5567.47,NULL,NULL,1,'2022-12-30 08:53:41','2022-12-30 08:53:41',NULL),(1842,7749,40720,1529,3,1717,'App\\Models\\Receipt',1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',155368.19,NULL,NULL,1,'2022-12-30 08:53:41','2022-12-30 08:53:41',NULL),(1843,7749,40720,1529,3,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',13580.25,NULL,NULL,1,'2022-12-30 09:46:06','2022-12-30 09:46:06',NULL),(1844,7749,40720,1529,2,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1062380.00,NULL,NULL,1,'2022-12-30 09:48:08','2023-01-05 09:33:27','2023-01-05 09:33:27'),(1845,7749,40720,1529,3,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',11999.93,NULL,NULL,1,'2023-01-03 10:30:09','2023-01-03 10:30:09',NULL),(1846,7749,40720,1529,3,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',6700.00,NULL,NULL,1,'2023-01-03 10:31:57','2023-01-03 10:31:57',NULL),(1847,7749,40720,1529,3,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',428100.01,NULL,NULL,1,'2023-01-03 10:33:09','2023-01-03 10:33:09',NULL),(1848,7749,40720,1529,2,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',56799.94,NULL,NULL,1,'2023-01-05 09:32:29','2023-01-05 09:50:14','2023-01-05 09:50:14'),(1849,7749,40720,1529,2,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',134940.06,NULL,NULL,1,'2023-01-05 09:32:29','2023-01-05 09:51:38','2023-01-05 09:51:38'),(1850,7749,40720,1529,2,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',4100.00,NULL,NULL,1,'2023-01-05 09:32:29','2023-01-05 09:51:55','2023-01-05 09:51:55');
INSERT INTO `balance_libro` VALUES (1851,7749,40720,1529,2,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',11390.02,NULL,NULL,1,'2023-01-05 09:32:29','2023-01-05 09:52:16','2023-01-05 09:52:16'),(1852,7749,40720,1529,2,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',7400.01,NULL,NULL,1,'2023-01-05 09:32:29','2023-01-05 09:52:31','2023-01-05 09:52:31'),(1853,7749,40720,1529,2,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',101710.06,NULL,NULL,1,'2023-01-05 09:32:29','2023-01-05 09:32:29',NULL),(1854,7749,40720,1529,2,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',4960.02,NULL,NULL,1,'2023-01-05 09:32:29','2023-01-05 09:53:12','2023-01-05 09:53:12'),(1855,7749,40720,1529,2,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',24429.96,NULL,NULL,1,'2023-01-05 09:32:29','2023-01-05 09:53:27','2023-01-05 09:53:27'),(1856,7749,40720,1529,2,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4100.00,NULL,NULL,1,'2023-01-05 09:32:29','2023-01-05 09:53:42','2023-01-05 09:53:42'),(1857,7749,40720,1529,2,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',23499.99,NULL,NULL,1,'2023-01-05 09:32:45','2023-01-05 09:32:45',NULL),(1858,7749,40720,1529,2,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',23499.99,NULL,NULL,1,'2023-01-05 09:32:45','2023-01-05 09:32:45',NULL),(1859,7749,40720,1529,2,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',999.98,NULL,NULL,1,'2023-01-05 09:32:45','2023-01-05 09:32:45',NULL),(1860,7749,40720,1529,2,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',5799.99,NULL,NULL,1,'2023-01-05 09:32:45','2023-01-05 09:32:45',NULL),(1861,7749,40720,1529,2,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',2999.99,NULL,NULL,1,'2023-01-05 09:32:45','2023-01-05 09:32:45',NULL),(1862,7749,40720,1529,2,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',4100.00,NULL,NULL,1,'2023-01-05 09:32:45','2023-01-05 09:32:45',NULL),(1863,7749,40720,1529,2,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',6190.01,NULL,NULL,1,'2023-01-05 09:32:45','2023-01-05 09:32:45',NULL),(1864,7749,40720,1529,2,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',799.98,NULL,NULL,1,'2023-01-05 09:32:45','2023-01-05 09:32:45',NULL),(1865,7749,40720,1529,2,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',4400.02,NULL,NULL,1,'2023-01-05 09:32:45','2023-01-05 09:32:45',NULL),(1866,7749,40720,1529,2,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',7400.01,NULL,NULL,1,'2023-01-05 09:32:45','2023-01-05 09:32:45',NULL),(1867,7749,40720,1529,2,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1800.02,NULL,NULL,1,'2023-01-05 09:32:45','2023-01-05 09:32:45',NULL),(1868,7749,40720,1529,2,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3160.00,NULL,NULL,1,'2023-01-05 09:32:45','2023-01-05 09:32:45',NULL),(1869,7749,40720,1529,2,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2999.99,NULL,NULL,1,'2023-01-05 09:32:45','2023-01-05 09:32:45',NULL),(1870,7749,40720,1529,2,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',16999.98,NULL,NULL,1,'2023-01-05 09:32:45','2023-01-05 09:32:45',NULL);
INSERT INTO `balance_libro` VALUES (1871,7749,40720,1529,2,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',680.02,NULL,NULL,1,'2023-01-05 09:32:46','2023-01-05 09:32:46',NULL),(1872,7749,40720,1529,2,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',599.99,NULL,NULL,1,'2023-01-05 09:32:46','2023-01-05 09:32:46',NULL),(1873,7749,40720,1529,2,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3149.98,NULL,NULL,1,'2023-01-05 09:32:46','2023-01-05 09:32:46',NULL),(1874,7749,40720,1529,2,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4100.00,NULL,NULL,1,'2023-01-05 09:32:46','2023-01-05 09:32:46',NULL),(1875,7749,40720,1529,2,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',179434.00,NULL,NULL,1,'2023-01-05 09:50:14','2023-01-05 09:50:14',NULL),(1876,7749,40720,1529,2,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',134940.06,NULL,NULL,1,'2023-01-05 09:51:38','2023-01-05 09:51:38',NULL),(1877,7749,40720,1529,2,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',22650.00,NULL,NULL,1,'2023-01-05 09:51:55','2023-01-05 09:51:55',NULL),(1878,7749,40720,1529,2,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',130385.00,NULL,NULL,1,'2023-01-05 09:52:16','2023-01-05 09:52:16',NULL),(1879,7749,40720,1529,2,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',147680.00,NULL,NULL,1,'2023-01-05 09:52:31','2023-01-05 09:52:31',NULL),(1880,7749,40720,1529,2,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',143490.00,NULL,NULL,1,'2023-01-05 09:53:12','2023-01-05 09:53:12',NULL),(1881,7749,40720,1529,2,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',89870.00,NULL,NULL,1,'2023-01-05 09:53:27','2023-01-05 09:53:27',NULL),(1882,7749,40720,1529,2,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',49790.00,NULL,NULL,1,'2023-01-05 09:53:42','2023-01-05 09:53:42',NULL),(1883,7749,40720,1529,3,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',173439.55,NULL,NULL,1,'2023-01-05 10:36:37','2023-01-05 10:36:37',NULL),(1884,7749,40720,1529,3,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',28164.96,NULL,NULL,1,'2023-01-05 10:55:44','2023-01-05 10:55:44',NULL),(1885,7749,40720,1529,3,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',191991.55,NULL,NULL,1,'2023-01-05 10:55:44','2023-01-05 11:26:33','2023-01-05 11:26:33'),(1886,7749,40720,1529,3,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',0.70,NULL,NULL,1,'2023-01-05 10:55:44','2023-01-05 10:55:44',NULL),(1887,7749,40720,1529,3,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',38801.17,NULL,NULL,1,'2023-01-05 10:55:44','2023-01-05 10:55:44',NULL),(1888,7749,40720,1529,3,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',183700.03,NULL,NULL,1,'2023-01-05 10:55:45','2023-01-05 10:55:45',NULL),(1889,7749,40720,1529,3,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2650.00,NULL,NULL,1,'2023-01-05 10:55:45','2023-01-05 10:57:18','2023-01-05 10:57:18'),(1890,7749,40720,1529,3,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',5545.50,NULL,NULL,1,'2023-01-05 10:55:45','2023-01-05 11:32:42','2023-01-05 11:32:42');
INSERT INTO `balance_libro` VALUES (1891,7749,40720,1529,3,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1319690.38,NULL,NULL,1,'2023-01-05 10:55:45','2023-01-17 10:56:08','2023-01-17 10:56:08'),(1892,7749,40720,1529,3,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',35259.40,NULL,NULL,1,'2023-01-05 10:55:45','2023-01-17 10:55:44','2023-01-17 10:55:44'),(1893,7749,40720,1529,3,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2650.00,NULL,NULL,1,'2023-01-05 10:57:18','2023-01-05 10:57:18',NULL),(1894,7749,40720,1529,3,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',33536.48,NULL,NULL,1,'2023-01-05 10:57:40','2023-01-05 10:57:40',NULL),(1895,7749,40720,1529,3,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',138316.89,NULL,NULL,1,'2023-01-05 10:58:56','2023-01-05 10:58:56',NULL),(1896,7749,40720,1529,3,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',26003.23,NULL,NULL,1,'2023-01-05 10:59:32','2023-01-05 10:59:32',NULL),(1897,7749,40720,1529,3,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',13959.61,NULL,NULL,1,'2023-01-05 10:59:55','2023-01-05 10:59:55',NULL),(1898,7749,40720,1529,3,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',29800.00,NULL,NULL,1,'2023-01-05 11:00:18','2023-01-05 11:00:18',NULL),(1899,7749,40720,1529,3,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',185800.06,NULL,NULL,1,'2023-01-05 11:01:13','2023-01-05 11:01:13',NULL),(1900,7749,40720,1529,3,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',11526.63,NULL,NULL,1,'2023-01-05 11:02:41','2023-01-05 11:02:41',NULL),(1901,7749,40720,1529,3,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',4710.37,NULL,NULL,1,'2023-01-05 11:03:14','2023-01-05 11:03:14',NULL),(1902,7749,40720,1529,3,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',24085.96,NULL,NULL,1,'2023-01-05 11:05:13','2023-01-05 11:05:13',NULL),(1903,7749,40720,1529,3,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',17316.30,NULL,NULL,1,'2023-01-05 11:05:28','2023-01-05 11:05:28',NULL),(1904,7749,40720,1529,3,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',14878.15,NULL,NULL,1,'2023-01-05 11:07:48','2023-01-05 11:07:48',NULL),(1905,7749,40720,1529,3,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',7063.32,NULL,NULL,1,'2023-01-05 11:08:09','2023-01-05 11:08:09',NULL),(1906,7749,40720,1529,3,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',52788.06,NULL,NULL,1,'2023-01-05 11:09:39','2023-01-05 11:09:39',NULL),(1907,7749,40720,1529,3,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',54826.41,NULL,NULL,1,'2023-01-05 11:10:52','2023-01-05 11:10:52',NULL),(1908,7749,40720,1529,3,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',131555.14,NULL,NULL,1,'2023-01-05 11:12:25','2023-01-05 11:12:25',NULL),(1909,7749,40720,1529,3,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',179014.08,NULL,NULL,1,'2023-01-05 11:13:01','2023-01-05 11:13:01',NULL),(1910,7749,40720,1529,3,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',191991.55,NULL,NULL,1,'2023-01-05 11:26:33','2023-01-05 11:26:33',NULL);
INSERT INTO `balance_libro` VALUES (1911,7749,40720,1529,3,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',5545.50,NULL,NULL,1,'2023-01-05 11:32:42','2023-01-05 11:32:42',NULL),(1912,7749,40720,1529,7,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1061.27,NULL,NULL,1,'2023-01-16 13:09:00','2023-01-16 13:09:00',NULL),(1913,7749,40720,1529,7,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',2524.62,NULL,NULL,1,'2023-01-16 13:09:00','2023-01-16 13:09:00',NULL),(1914,7749,40720,1529,7,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',668.56,NULL,NULL,1,'2023-01-16 13:09:00','2023-01-16 13:09:00',NULL),(1915,7749,40720,1529,3,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',17080.00,NULL,NULL,1,'2023-01-17 11:36:41','2023-01-17 11:36:41',NULL),(1916,7749,40720,1529,3,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',18648.86,NULL,NULL,1,'2023-01-17 11:36:57','2023-01-17 11:36:57',NULL),(1917,7749,40720,1529,3,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',27039.20,NULL,NULL,1,'2023-01-17 11:37:10','2023-01-17 11:37:10',NULL),(1918,7749,40720,1529,3,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',61445.78,NULL,NULL,1,'2023-01-17 11:37:24','2023-01-17 11:37:24',NULL),(1919,7749,40720,1529,3,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',148021.08,NULL,NULL,1,'2023-01-17 11:38:07','2023-01-17 11:38:07',NULL),(1920,7749,40720,1529,15,991,'App\\Models\\PeriodLiquidation',NULL,991,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2544633.35,NULL,NULL,1,'2023-01-18 11:17:44','2023-02-28 09:31:10','2023-02-28 09:31:10'),(1921,7749,40720,1533,3,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',173539.99,NULL,NULL,1,'2023-01-18 12:24:47','2023-01-18 12:24:47',NULL),(1922,7749,40720,1533,3,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',8700.02,NULL,NULL,1,'2023-01-18 12:29:02','2023-01-18 12:29:02',NULL),(1923,7749,40720,1533,2,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',27250.00,NULL,NULL,1,'2023-01-19 10:04:23','2023-01-19 10:04:23',NULL),(1924,7749,40720,1533,2,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',80750.00,NULL,NULL,1,'2023-01-19 10:04:23','2023-01-19 10:04:23',NULL),(1925,7749,40720,1533,2,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3699.99,NULL,NULL,1,'2023-01-19 10:04:23','2023-01-19 10:04:23',NULL),(1926,7749,40720,1533,2,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',855.00,NULL,NULL,1,'2023-01-19 10:04:23','2023-01-19 10:04:23',NULL),(1927,7749,40720,1533,2,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2450.00,NULL,NULL,1,'2023-01-19 10:04:23','2023-01-19 10:04:23',NULL),(1928,7749,40720,1533,2,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',900.00,NULL,NULL,1,'2023-01-19 10:04:23','2023-01-19 10:04:23',NULL),(1929,7749,40720,1533,2,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',27200.00,NULL,NULL,1,'2023-01-19 10:04:23','2023-01-19 10:04:23',NULL),(1930,7749,40720,1533,2,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',85000.00,NULL,NULL,1,'2023-01-19 10:04:23','2023-01-19 10:04:23',NULL),(1931,7749,40720,1533,2,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',23800.00,NULL,NULL,1,'2023-01-19 10:04:23','2023-01-19 10:04:23',NULL);
INSERT INTO `balance_libro` VALUES (1932,7749,40720,1533,2,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',14250.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1933,7749,40720,1533,2,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',58800.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1934,7749,40720,1533,2,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',20000.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1935,7749,40720,1533,2,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3430.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1936,7749,40720,1533,2,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',6000.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1937,7749,40720,1533,2,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',13800.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1938,7749,40720,1533,2,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',6639.99,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1939,7749,40720,1533,2,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',8800.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1940,7749,40720,1533,2,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',33710.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1941,7749,40720,1533,2,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3180.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1942,7749,40720,1533,2,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',15350.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1943,7749,40720,1533,2,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3365.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1944,7749,40720,1533,2,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3200.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1945,7749,40720,1533,2,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',700.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1946,7749,40720,1533,2,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1840.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1947,7749,40720,1533,2,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1100.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1948,7749,40720,1533,2,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3800.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1949,7749,40720,1533,2,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2400.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1950,7749,40720,1533,2,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5700.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1951,7749,40720,1533,2,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',7000.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1952,7749,40720,1533,2,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',102000.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL);
INSERT INTO `balance_libro` VALUES (1953,7749,40720,1533,2,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4100.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1954,7749,40720,1533,2,1804,'App\\Models\\Receipt',1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3000.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1955,7749,40720,1533,2,1805,'App\\Models\\Receipt',1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5280.00,NULL,NULL,1,'2023-01-19 10:04:24','2023-01-19 10:04:24',NULL),(1956,7749,40720,1533,2,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',12564.96,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1957,7749,40720,1533,2,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4140.00,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1958,7749,40720,1533,2,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',8090.00,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1959,7749,40720,1533,2,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',16920.00,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1960,7749,40720,1533,2,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',15700.00,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1961,7749,40720,1533,2,1811,'App\\Models\\Receipt',1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3400.00,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1962,7749,40720,1533,2,1812,'App\\Models\\Receipt',1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',13800.00,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1963,7749,40720,1533,2,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5000.00,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1964,7749,40720,1533,2,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',9570.00,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1965,7749,40720,1533,2,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4200.00,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1966,7749,40720,1533,2,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5100.00,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1967,7749,40720,1533,2,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7150.00,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1968,7749,40720,1533,2,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3665.00,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1969,7749,40720,1533,2,1819,'App\\Models\\Receipt',1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',69900.00,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1970,7749,40720,1533,2,1820,'App\\Models\\Receipt',1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',40100.00,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1971,7749,40720,1533,2,1821,'App\\Models\\Receipt',1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',54199.99,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1972,7749,40720,1533,2,1822,'App\\Models\\Receipt',1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',82100.00,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1973,7749,40720,1533,2,1823,'App\\Models\\Receipt',1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5000.00,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL);
INSERT INTO `balance_libro` VALUES (1974,7749,40720,1533,2,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',25000.00,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1975,7749,40720,1533,2,1825,'App\\Models\\Receipt',1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5280.00,NULL,NULL,1,'2023-01-19 10:04:25','2023-01-19 10:04:25',NULL),(1976,7749,40720,1533,2,1826,'App\\Models\\Receipt',1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',145699.98,NULL,NULL,1,'2023-01-19 10:04:26','2023-01-19 10:04:26',NULL),(1977,7749,40720,1533,2,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',44800.00,NULL,NULL,1,'2023-01-19 10:04:26','2023-01-19 10:04:26',NULL),(1978,7749,40720,1533,2,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',123099.99,NULL,NULL,1,'2023-01-19 10:04:26','2023-01-19 10:04:26',NULL),(1979,7749,40720,1533,2,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',21699.99,NULL,NULL,1,'2023-01-19 10:04:26','2023-01-19 10:04:26',NULL),(1980,7749,40720,1533,2,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',145450.00,NULL,NULL,1,'2023-01-19 10:04:26','2023-01-19 10:04:26',NULL),(1981,7749,40720,1533,2,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',150000.00,NULL,NULL,1,'2023-01-19 10:04:26','2023-01-19 10:04:26',NULL),(1982,7749,40720,1533,2,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',30000.00,NULL,NULL,1,'2023-01-19 10:04:26','2023-01-19 10:04:26',NULL),(1983,7749,40720,1533,2,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',148000.00,NULL,NULL,1,'2023-01-19 10:04:26','2023-01-19 10:04:26',NULL),(1984,7749,40720,1533,2,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',10400.00,NULL,NULL,1,'2023-01-19 10:04:26','2023-01-19 10:04:26',NULL),(1985,7749,40720,1533,2,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',18800.00,NULL,NULL,1,'2023-01-19 10:04:26','2023-01-19 10:04:26',NULL),(1986,7749,40720,1533,2,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',137940.00,NULL,NULL,1,'2023-01-19 10:04:26','2023-01-19 10:04:26',NULL),(1987,7749,40720,1533,2,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',15400.00,NULL,NULL,1,'2023-01-19 10:04:26','2023-01-19 10:04:26',NULL),(1988,7749,40720,1533,2,1838,'App\\Models\\Receipt',1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',180895.00,NULL,NULL,1,'2023-01-19 10:04:26','2023-01-19 10:04:26',NULL),(1989,7749,40720,1533,2,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1350.00,NULL,NULL,1,'2023-01-19 10:04:26','2023-01-19 10:04:26',NULL),(1990,7749,40720,1533,2,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',25550.00,NULL,NULL,1,'2023-01-19 10:04:26','2023-01-19 10:04:26',NULL),(1991,7749,40720,1533,2,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',36799.99,NULL,NULL,1,'2023-01-19 10:04:26','2023-01-19 10:04:26',NULL),(1992,7749,40720,1533,2,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',8300.00,NULL,NULL,1,'2023-01-19 10:04:26','2023-01-19 10:04:26',NULL),(1993,7749,40720,1533,2,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',51999.99,NULL,NULL,1,'2023-01-19 10:04:26','2023-01-19 10:04:26',NULL),(1994,7749,40720,1533,2,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2800.00,NULL,NULL,1,'2023-01-19 10:04:27','2023-01-19 10:04:27',NULL);
INSERT INTO `balance_libro` VALUES (1995,7749,40720,1533,2,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',7000.00,NULL,NULL,1,'2023-01-19 10:04:27','2023-01-19 10:04:27',NULL),(1996,7749,40720,1533,2,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3200.00,NULL,NULL,1,'2023-01-19 10:04:27','2023-01-19 10:04:27',NULL),(1997,7749,40720,1533,2,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3000.00,NULL,NULL,1,'2023-01-19 10:04:27','2023-01-19 10:04:27',NULL),(1998,7749,40720,1533,2,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',9000.00,NULL,NULL,1,'2023-01-19 10:04:27','2023-01-19 10:04:27',NULL),(1999,7749,40720,1533,2,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',420.00,NULL,NULL,1,'2023-01-19 10:04:27','2023-01-19 10:04:27',NULL),(2000,7749,40720,1533,2,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2699.99,NULL,NULL,1,'2023-01-19 10:04:27','2023-01-19 10:04:27',NULL),(2001,7749,40720,1533,2,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',120900.00,NULL,NULL,1,'2023-01-19 10:04:27','2023-01-19 10:04:27',NULL),(2002,7749,40720,1533,2,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',179500.01,NULL,NULL,1,'2023-01-19 10:04:27','2023-01-19 10:04:27',NULL),(2003,7749,40720,1533,2,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',40500.01,NULL,NULL,1,'2023-01-19 10:04:27','2023-01-19 10:04:27',NULL),(2004,7749,40720,1533,2,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',138900.00,NULL,NULL,1,'2023-01-19 10:04:27','2023-01-19 10:04:27',NULL),(2005,7749,40720,1533,2,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',160799.99,NULL,NULL,1,'2023-01-19 10:04:27','2023-01-19 10:04:27',NULL),(2006,7749,40720,1533,2,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',114000.00,NULL,NULL,1,'2023-01-19 10:04:27','2023-01-19 10:04:27',NULL),(2007,7749,40720,1533,2,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',131999.99,NULL,NULL,1,'2023-01-19 10:04:27','2023-01-19 10:04:27',NULL),(2008,7749,40720,1533,2,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',178999.99,NULL,NULL,1,'2023-01-19 10:04:27','2023-01-19 10:04:27',NULL),(2009,7749,40720,1533,2,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',67000.00,NULL,NULL,1,'2023-01-19 10:04:27','2023-01-19 10:04:27',NULL),(2010,7749,40720,1533,2,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',137600.00,NULL,NULL,1,'2023-01-19 10:04:27','2023-01-19 10:04:27',NULL),(2011,7749,40720,1533,2,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',143000.00,NULL,NULL,1,'2023-01-19 10:04:28','2023-01-19 10:04:28',NULL),(2012,7749,40720,1533,2,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',179459.99,NULL,NULL,1,'2023-01-19 10:04:28','2023-01-19 10:04:28',NULL),(2013,7749,40720,1533,2,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',27000.00,NULL,NULL,1,'2023-01-19 10:04:28','2023-01-19 10:04:28',NULL),(2014,7749,40720,1533,2,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3149.99,NULL,NULL,1,'2023-01-19 10:04:28','2023-01-19 10:04:28',NULL),(2015,7749,40720,1533,2,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',13580.00,NULL,NULL,1,'2023-01-19 10:04:28','2023-01-19 10:04:28',NULL);
INSERT INTO `balance_libro` VALUES (2016,7749,40720,1533,2,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',62850.00,NULL,NULL,1,'2023-01-19 10:04:28','2023-01-19 10:04:28',NULL),(2017,7749,40720,1533,3,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',11249.99,NULL,NULL,1,'2023-01-19 10:04:38','2023-01-19 10:04:38',NULL),(2018,7749,40720,1533,3,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',46617.00,NULL,NULL,1,'2023-01-19 10:04:38','2023-01-19 10:04:38',NULL),(2019,7749,40720,1533,3,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',13577.50,NULL,NULL,1,'2023-01-19 10:04:38','2023-01-19 10:04:38',NULL),(2020,7749,40720,1533,3,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',25935.73,NULL,NULL,1,'2023-01-19 10:04:38','2023-01-19 10:04:38',NULL),(2021,7749,40720,1533,3,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',7007.06,NULL,NULL,1,'2023-01-19 10:04:38','2023-01-19 10:04:38',NULL),(2022,7749,40720,1533,3,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',137362.35,NULL,NULL,1,'2023-01-19 10:04:39','2023-01-19 10:04:39',NULL),(2023,7749,40720,1533,3,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',139552.48,NULL,NULL,1,'2023-01-19 10:04:39','2023-01-19 10:04:39',NULL),(2024,7749,40720,1533,3,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',21118.58,NULL,NULL,1,'2023-01-19 10:04:39','2023-01-19 10:04:39',NULL),(2025,7749,40720,1533,3,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7830.87,NULL,NULL,1,'2023-01-19 10:04:39','2023-01-19 10:04:39',NULL),(2026,7749,40720,1533,3,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',52843.68,NULL,NULL,1,'2023-01-19 10:04:39','2023-01-19 10:04:39',NULL),(2027,7749,40720,1533,3,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',20175.54,NULL,NULL,1,'2023-01-19 10:04:39','2023-02-06 12:20:52','2023-02-06 12:20:52'),(2028,7749,40720,1533,3,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',28820.00,NULL,NULL,1,'2023-01-19 10:04:39','2023-01-19 10:04:39',NULL),(2029,7749,40720,1533,3,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',25706.35,NULL,NULL,1,'2023-01-19 10:04:39','2023-02-06 12:22:13','2023-02-06 12:22:13'),(2030,7749,40720,1533,3,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',25706.35,NULL,NULL,1,'2023-01-19 10:04:39','2023-02-06 12:22:27','2023-02-06 12:22:27'),(2031,7749,40720,1533,3,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',24038.73,NULL,NULL,1,'2023-01-19 10:04:39','2023-01-19 10:04:39',NULL),(2032,7749,40720,1533,3,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',178506.40,NULL,NULL,1,'2023-01-19 10:04:39','2023-01-19 10:04:39',NULL),(2033,7749,40720,1533,3,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',350646.63,NULL,NULL,1,'2023-01-19 10:04:39','2023-02-06 12:24:06','2023-02-06 12:24:06'),(2034,7749,40720,1533,3,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',209683.26,NULL,NULL,1,'2023-01-19 10:04:39','2023-01-19 10:04:39',NULL),(2035,7749,40720,1533,3,1885,'App\\Models\\Receipt',1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7291.95,NULL,NULL,1,'2023-01-19 10:04:39','2023-01-19 10:04:39',NULL);
INSERT INTO `balance_libro` VALUES (2036,7749,40720,1533,3,1886,'App\\Models\\Receipt',1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',20029.26,NULL,NULL,1,'2023-01-19 10:04:39','2023-01-19 10:04:39',NULL),(2037,7749,40720,1533,3,1887,'App\\Models\\Receipt',1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',8608.44,NULL,NULL,1,'2023-01-19 10:04:40','2023-01-19 10:04:40',NULL),(2038,7749,40720,1533,3,1888,'App\\Models\\Receipt',1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',22216.04,NULL,NULL,1,'2023-01-19 10:04:40','2023-01-19 10:04:40',NULL),(2039,7749,40720,1533,3,1889,'App\\Models\\Receipt',1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',6694.28,NULL,NULL,1,'2023-01-19 10:04:40','2023-01-19 10:04:40',NULL),(2040,7749,40720,1533,3,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',27822.99,NULL,NULL,1,'2023-01-19 10:04:40','2023-02-06 12:26:26','2023-02-06 12:26:26'),(2041,7749,40720,1533,3,1891,'App\\Models\\Receipt',1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',21704.04,NULL,NULL,1,'2023-01-19 10:04:40','2023-01-19 10:04:40',NULL),(2042,7749,40720,1533,3,1892,'App\\Models\\Receipt',1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',45147.65,NULL,NULL,1,'2023-01-19 10:04:40','2023-01-19 10:04:40',NULL),(2043,7749,40720,1533,3,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',77259.00,NULL,NULL,1,'2023-01-19 10:04:40','2023-01-19 10:04:40',NULL),(2044,7749,40720,1533,3,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',94494.92,NULL,NULL,1,'2023-01-19 10:04:40','2023-01-19 10:04:40',NULL),(2045,7749,40720,1533,3,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',13740.18,NULL,NULL,1,'2023-01-19 10:04:40','2023-01-19 10:04:40',NULL),(2046,7749,40720,1533,3,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',134545.70,NULL,NULL,1,'2023-01-19 10:04:40','2023-01-19 10:04:40',NULL),(2047,7749,40720,1533,3,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',16845.00,NULL,NULL,1,'2023-01-19 10:04:40','2023-01-19 10:04:40',NULL),(2048,7749,40720,1533,3,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',167614.06,NULL,NULL,1,'2023-01-19 10:04:40','2023-01-19 10:04:40',NULL),(2049,7749,40720,1533,3,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2597.75,NULL,NULL,1,'2023-01-19 10:04:40','2023-01-19 10:04:40',NULL),(2050,7749,40720,1533,3,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',38485.37,NULL,NULL,1,'2023-01-19 10:04:40','2023-02-09 09:53:40','2023-02-09 09:53:40'),(2051,7749,40720,1533,3,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',181011.49,NULL,NULL,1,'2023-01-19 10:04:40','2023-01-19 10:04:40',NULL),(2052,7749,40720,1533,3,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',124601.07,NULL,NULL,1,'2023-01-19 10:04:40','2023-01-19 10:04:40',NULL),(2053,7749,40720,1533,3,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2935.00,NULL,NULL,1,'2023-01-19 10:04:41','2023-01-19 10:04:41',NULL),(2054,7749,40720,1533,3,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',75742.13,NULL,NULL,1,'2023-01-19 10:04:41','2023-01-19 10:04:41',NULL),(2055,7749,40720,1533,3,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',127887.98,NULL,NULL,1,'2023-01-19 10:04:41','2023-01-19 10:04:41',NULL);
INSERT INTO `balance_libro` VALUES (2056,7749,40720,1533,3,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',121297.28,NULL,NULL,1,'2023-01-19 10:04:41','2023-01-19 10:04:41',NULL),(2057,7749,40720,1533,3,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',358.90,NULL,NULL,1,'2023-01-19 10:04:41','2023-01-19 10:04:41',NULL),(2058,7749,40720,1533,3,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',14849.00,NULL,NULL,1,'2023-01-19 11:48:51','2023-01-19 11:48:51',NULL),(2059,7749,40720,1533,3,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',90937.96,NULL,NULL,1,'2023-01-19 11:49:13','2023-01-19 11:49:13',NULL),(2060,7749,40720,1533,3,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',15345.05,NULL,NULL,1,'2023-01-19 11:49:32','2023-01-19 11:49:32',NULL),(2061,7749,40720,1533,3,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',45721.36,NULL,NULL,1,'2023-01-19 11:49:51','2023-01-19 11:49:51',NULL),(2062,7749,40720,1533,3,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',6500.13,NULL,NULL,1,'2023-01-19 11:50:29','2023-01-19 11:50:29',NULL),(2063,7749,40720,1533,2,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',16455.02,NULL,NULL,1,'2023-01-19 12:34:47','2023-01-19 13:03:58','2023-01-19 13:03:58'),(2064,7749,40720,1533,2,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',9319.94,NULL,NULL,1,'2023-01-19 12:34:47','2023-01-19 13:04:18','2023-01-19 13:04:18'),(2065,7749,40720,1533,2,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',22500.01,NULL,NULL,1,'2023-01-19 12:34:47','2023-01-19 13:04:38','2023-01-19 13:04:38'),(2066,7749,40720,1533,2,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4149.95,NULL,NULL,1,'2023-01-19 12:34:47','2023-01-19 13:04:52','2023-01-19 13:04:52'),(2067,7749,40720,1533,2,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',120469.85,NULL,NULL,1,'2023-01-19 12:34:47','2023-01-19 13:05:38','2023-01-19 13:05:38'),(2068,7749,40720,1533,2,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',5200.00,NULL,NULL,1,'2023-01-19 12:34:47','2023-01-19 12:34:47',NULL),(2069,7749,40720,1533,2,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',15170.06,NULL,NULL,1,'2023-01-19 12:34:55','2023-01-24 09:31:52','2023-01-24 09:31:52'),(2070,7749,40720,1533,2,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',6250.00,NULL,NULL,1,'2023-01-19 12:34:55','2023-01-24 09:32:11','2023-01-24 09:32:11'),(2071,7749,40720,1533,2,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',8899.95,NULL,NULL,1,'2023-01-19 12:34:55','2023-01-24 09:32:27','2023-01-24 09:32:27'),(2072,7749,40720,1533,2,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',8340.01,NULL,NULL,1,'2023-01-19 12:34:55','2023-01-24 09:32:44','2023-01-24 09:32:44'),(2073,7749,40720,1533,2,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',4400.02,NULL,NULL,1,'2023-01-19 12:34:55','2023-01-24 09:32:58','2023-01-24 09:32:58'),(2074,7749,40720,1533,2,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',4350.01,NULL,NULL,1,'2023-01-19 12:34:55','2023-01-24 09:33:14','2023-01-24 09:33:14'),(2075,7749,40720,1533,2,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',14475.00,NULL,NULL,1,'2023-01-19 12:35:08','2023-01-19 12:35:08',NULL);
INSERT INTO `balance_libro` VALUES (2076,7749,40720,1533,2,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',900.01,NULL,NULL,1,'2023-01-19 12:35:08','2023-01-19 12:35:08',NULL),(2077,7749,40720,1533,2,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1080.01,NULL,NULL,1,'2023-01-19 12:35:08','2023-01-19 12:35:08',NULL),(2078,7749,40720,1533,2,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2099.98,NULL,NULL,1,'2023-01-19 12:35:08','2023-01-19 12:35:08',NULL),(2079,7749,40720,1533,2,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1199.97,NULL,NULL,1,'2023-01-19 12:35:09','2023-01-19 12:35:09',NULL),(2080,7749,40720,1533,2,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',6019.98,NULL,NULL,1,'2023-01-19 12:35:09','2023-01-19 12:35:09',NULL),(2081,7749,40720,1533,2,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2400.01,NULL,NULL,1,'2023-01-19 12:35:09','2023-01-19 12:35:09',NULL),(2082,7749,40720,1533,2,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',17300.00,NULL,NULL,1,'2023-01-19 12:35:09','2023-01-19 12:35:09',NULL),(2083,7749,40720,1533,2,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2800.00,NULL,NULL,1,'2023-01-19 12:35:09','2023-01-19 12:35:09',NULL),(2084,7749,40720,1533,2,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',799.98,NULL,NULL,1,'2023-01-19 12:35:09','2023-01-19 12:35:09',NULL),(2085,7749,40720,1533,2,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',850.00,NULL,NULL,1,'2023-01-19 12:35:09','2023-01-19 12:35:09',NULL),(2086,7749,40720,1533,2,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2499.98,NULL,NULL,1,'2023-01-19 12:35:09','2023-01-19 12:35:09',NULL),(2087,7749,40720,1533,2,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1500.00,NULL,NULL,1,'2023-01-19 12:35:09','2023-01-19 12:35:09',NULL),(2088,7749,40720,1533,2,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',7600.01,NULL,NULL,1,'2023-01-19 12:35:09','2023-01-19 12:35:09',NULL),(2089,7749,40720,1533,2,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',12280.00,NULL,NULL,1,'2023-01-19 12:35:09','2023-01-19 12:35:09',NULL),(2090,7749,40720,1533,2,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2900.02,NULL,NULL,1,'2023-01-19 12:35:09','2023-01-19 12:35:09',NULL),(2091,7749,40720,1533,2,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3280.02,NULL,NULL,1,'2023-01-19 12:35:15','2023-01-19 12:35:15',NULL),(2092,7749,40720,1533,2,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4290.03,NULL,NULL,1,'2023-01-19 12:35:15','2023-01-19 12:35:15',NULL),(2093,7749,40720,1533,2,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3900.00,NULL,NULL,1,'2023-01-19 12:35:15','2023-01-19 12:35:15',NULL),(2094,7749,40720,1533,2,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3700.01,NULL,NULL,1,'2023-01-19 12:35:15','2023-01-19 12:35:15',NULL),(2095,7749,40720,1533,2,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1249.99,NULL,NULL,1,'2023-01-19 12:35:15','2023-01-19 12:35:15',NULL),(2096,7749,40720,1533,2,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',5000.01,NULL,NULL,1,'2023-01-19 12:35:15','2023-01-19 12:35:15',NULL);
INSERT INTO `balance_libro` VALUES (2097,7749,40720,1533,2,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3999.97,NULL,NULL,1,'2023-01-19 12:35:15','2023-01-19 12:35:15',NULL),(2098,7749,40720,1533,2,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2400.01,NULL,NULL,1,'2023-01-19 12:35:15','2023-01-19 12:35:15',NULL),(2099,7749,40720,1533,2,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2499.98,NULL,NULL,1,'2023-01-19 12:35:15','2023-01-19 12:35:15',NULL),(2100,7749,40720,1533,2,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1370.01,NULL,NULL,1,'2023-01-19 12:35:15','2023-01-19 12:35:15',NULL),(2101,7749,40720,1533,2,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2000.01,NULL,NULL,1,'2023-01-19 12:35:15','2023-01-19 12:35:15',NULL),(2102,7749,40720,1533,2,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3999.97,NULL,NULL,1,'2023-01-19 12:35:15','2023-01-19 12:35:15',NULL),(2103,7749,40720,1533,2,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',970.02,NULL,NULL,1,'2023-01-19 12:35:15','2023-01-19 12:35:15',NULL),(2104,7749,40720,1533,2,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',500.02,NULL,NULL,1,'2023-01-19 12:35:15','2023-01-19 12:35:15',NULL),(2105,7749,40720,1533,2,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3900.00,NULL,NULL,1,'2023-01-19 12:35:15','2023-01-19 12:35:15',NULL),(2106,7749,40720,1533,2,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3399.98,NULL,NULL,1,'2023-01-19 12:35:15','2023-01-19 12:35:15',NULL),(2107,7749,40720,1533,2,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',950.02,NULL,NULL,1,'2023-01-19 12:35:15','2023-01-19 12:35:15',NULL),(2108,7749,40720,1533,2,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',124360.00,NULL,NULL,1,'2023-01-19 13:03:58','2023-01-19 13:03:58',NULL),(2109,7749,40720,1533,2,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',83910.00,NULL,NULL,1,'2023-01-19 13:04:18','2023-01-19 13:04:18',NULL),(2110,7749,40720,1533,2,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',83275.00,NULL,NULL,1,'2023-01-19 13:04:38','2023-01-19 13:04:38',NULL),(2111,7749,40720,1533,2,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',55070.00,NULL,NULL,1,'2023-01-19 13:04:52','2023-01-19 13:04:52',NULL),(2112,7749,40720,1533,2,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',120470.00,NULL,NULL,1,'2023-01-19 13:05:38','2023-01-19 13:05:38',NULL),(2113,7749,40720,1533,3,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',7773.12,NULL,NULL,1,'2023-01-24 09:03:19','2023-02-09 09:56:40','2023-02-09 09:56:40'),(2114,7749,40720,1533,3,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',19200.00,NULL,NULL,1,'2023-01-24 09:03:19','2023-01-24 09:03:19',NULL),(2115,7749,40720,1533,3,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',125692.07,NULL,NULL,1,'2023-01-24 09:03:19','2023-02-06 12:36:03','2023-02-06 12:36:03'),(2116,7749,40720,1533,3,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',39494.40,NULL,NULL,1,'2023-01-24 09:03:19','2023-01-24 09:03:19',NULL);
INSERT INTO `balance_libro` VALUES (2117,7749,40720,1533,3,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',39848.49,NULL,NULL,1,'2023-01-24 09:03:19','2023-02-06 12:36:44','2023-02-06 12:36:44'),(2118,7749,40720,1533,3,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',72989.11,NULL,NULL,1,'2023-01-24 09:03:19','2023-01-24 09:03:19',NULL),(2119,7749,40720,1533,3,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',40643.16,NULL,NULL,1,'2023-01-24 09:03:19','2023-01-24 09:03:19',NULL),(2120,7749,40720,1533,3,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',89082.26,NULL,NULL,1,'2023-01-24 09:03:19','2023-01-24 09:03:19',NULL),(2121,7749,40720,1533,3,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',57007.94,NULL,NULL,1,'2023-01-24 09:03:19','2023-01-24 09:03:19',NULL),(2122,7749,40720,1533,3,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',19082.00,NULL,NULL,1,'2023-01-24 09:03:19','2023-01-24 09:03:19',NULL),(2123,7749,40720,1533,3,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3945.49,NULL,NULL,1,'2023-01-24 09:03:20','2023-01-24 09:03:20',NULL),(2124,7749,40720,1533,3,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',38485.37,NULL,NULL,1,'2023-01-24 09:03:20','2023-02-09 09:53:48','2023-02-09 09:53:48'),(2125,7749,40720,1533,3,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',442257.68,NULL,NULL,1,'2023-01-24 09:03:20','2023-02-03 09:56:31','2023-02-03 09:56:31'),(2126,7749,40720,1533,3,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',100318.08,NULL,NULL,1,'2023-01-24 09:03:20','2023-01-24 09:03:20',NULL),(2127,7749,40720,1533,3,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',58778.23,NULL,NULL,1,'2023-01-24 09:03:20','2023-01-24 09:03:20',NULL),(2128,7749,40720,1533,2,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',16640.04,NULL,NULL,1,'2023-01-24 09:25:49','2023-01-24 09:33:32','2023-01-24 09:33:32'),(2129,7749,40720,1533,2,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',21350.05,NULL,NULL,1,'2023-01-24 09:25:49','2023-01-24 09:33:47','2023-01-24 09:33:47'),(2130,7749,40720,1533,2,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',17880.05,NULL,NULL,1,'2023-01-24 09:25:49','2023-01-24 09:34:04','2023-01-24 09:34:04'),(2131,7749,40720,1533,2,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',13450.01,NULL,NULL,1,'2023-01-24 09:25:49','2023-01-24 09:34:20','2023-01-24 09:34:20'),(2132,7749,40720,1533,2,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2630.02,NULL,NULL,1,'2023-01-24 09:25:49','2023-01-24 09:34:36','2023-01-24 09:34:36'),(2133,7749,40720,1533,2,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',6820.02,NULL,NULL,1,'2023-01-24 09:25:49','2023-01-24 09:34:53','2023-01-24 09:34:53'),(2134,7749,40720,1533,2,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3640.03,NULL,NULL,1,'2023-01-24 09:26:06','2023-01-24 09:26:06',NULL),(2135,7749,40720,1533,2,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',7000.02,NULL,NULL,1,'2023-01-24 09:26:06','2023-01-24 09:26:06',NULL),(2136,7749,40720,1533,2,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',5999.99,NULL,NULL,1,'2023-01-24 09:26:06','2023-01-24 09:26:06',NULL);
INSERT INTO `balance_libro` VALUES (2137,7749,40720,1533,2,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1800.02,NULL,NULL,1,'2023-01-24 09:26:06','2023-01-24 09:26:06',NULL),(2138,7749,40720,1533,2,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',10000.02,NULL,NULL,1,'2023-01-24 09:26:06','2023-01-24 09:26:06',NULL),(2139,7749,40720,1533,2,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1800.02,NULL,NULL,1,'2023-01-24 09:26:06','2023-01-24 09:26:06',NULL),(2140,7749,40720,1533,2,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',7749.99,NULL,NULL,1,'2023-01-24 09:26:06','2023-01-24 09:26:06',NULL),(2141,7749,40720,1533,2,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1600.02,NULL,NULL,1,'2023-01-24 09:26:06','2023-01-24 09:26:06',NULL),(2142,7749,40720,1533,2,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1400.03,NULL,NULL,1,'2023-01-24 09:26:06','2023-01-24 09:26:06',NULL),(2143,7749,40720,1533,2,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',14880.00,NULL,NULL,1,'2023-01-24 09:26:06','2023-01-24 09:26:06',NULL),(2144,7749,40720,1533,2,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3799.98,NULL,NULL,1,'2023-01-24 09:26:06','2023-01-24 09:26:06',NULL),(2145,7749,40720,1533,2,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',6950.01,NULL,NULL,1,'2023-01-24 09:26:06','2023-01-24 09:26:06',NULL),(2146,7749,40720,1533,2,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2700.03,NULL,NULL,1,'2023-01-24 09:26:06','2023-01-24 09:26:06',NULL),(2147,7749,40720,1533,2,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1780.03,NULL,NULL,1,'2023-01-24 09:26:06','2023-01-24 09:26:06',NULL),(2148,7749,40720,1533,2,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',850.00,NULL,NULL,1,'2023-01-24 09:26:06','2023-01-24 09:26:06',NULL),(2149,7749,40720,1533,2,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',6820.02,NULL,NULL,1,'2023-01-24 09:26:06','2023-01-24 09:26:06',NULL),(2150,7749,40720,1533,2,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',101060.00,NULL,NULL,1,'2023-01-24 09:31:52','2023-01-24 09:31:52',NULL),(2151,7749,40720,1533,2,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',113970.00,NULL,NULL,1,'2023-01-24 09:32:11','2023-01-24 09:32:11',NULL),(2152,7749,40720,1533,2,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',108970.00,NULL,NULL,1,'2023-01-24 09:32:27','2023-01-24 09:32:27',NULL),(2153,7749,40720,1533,2,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',101130.00,NULL,NULL,1,'2023-01-24 09:32:44','2023-01-24 09:32:44',NULL),(2154,7749,40720,1533,2,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',88960.00,NULL,NULL,1,'2023-01-24 09:32:58','2023-01-24 09:32:58',NULL),(2155,7749,40720,1533,2,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',62225.00,NULL,NULL,1,'2023-01-24 09:33:14','2023-01-24 09:33:14',NULL),(2156,7749,40720,1533,2,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',127965.00,NULL,NULL,1,'2023-01-24 09:33:32','2023-01-24 09:33:32',NULL),(2157,7749,40720,1533,2,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',119750.00,NULL,NULL,1,'2023-01-24 09:33:47','2023-01-24 09:33:47',NULL);
INSERT INTO `balance_libro` VALUES (2158,7749,40720,1533,2,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',117930.00,NULL,NULL,1,'2023-01-24 09:34:04','2023-01-24 09:34:04',NULL),(2159,7749,40720,1533,2,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',83969.99,NULL,NULL,1,'2023-01-24 09:34:20','2023-01-24 09:34:20',NULL),(2160,7749,40720,1533,2,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',95850.00,NULL,NULL,1,'2023-01-24 09:34:36','2023-01-24 09:34:36',NULL),(2161,7749,40720,1533,2,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',113720.00,NULL,NULL,1,'2023-01-24 09:34:53','2023-01-24 09:34:53',NULL),(2162,7749,40720,1533,2,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',133090.01,NULL,NULL,1,'2023-01-24 09:35:44','2023-01-24 09:35:44',NULL),(2163,7749,40720,1533,2,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',20630.00,NULL,NULL,1,'2023-01-24 10:23:46','2023-01-24 10:23:46',NULL),(2164,7749,40720,1533,2,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',118000.00,NULL,NULL,1,'2023-01-24 10:23:46','2023-01-24 10:23:46',NULL),(2165,7749,40720,1533,2,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',118000.00,NULL,NULL,1,'2023-01-24 10:23:46','2023-01-24 10:23:46',NULL),(2166,7749,40720,1533,2,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',236000.00,NULL,NULL,1,'2023-01-24 10:23:46','2023-01-24 10:23:46',NULL),(2167,7749,40720,1533,2,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',236000.00,NULL,NULL,1,'2023-01-24 10:23:46','2023-01-24 10:23:46',NULL),(2168,7749,40720,1533,3,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',10800.01,NULL,NULL,1,'2023-01-24 11:24:03','2023-01-24 11:24:03',NULL),(2169,7749,40720,1533,2,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',60780.01,NULL,NULL,1,'2023-01-26 09:33:15','2023-01-26 09:33:15',NULL),(2170,7749,40720,1533,3,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1597998.60,NULL,NULL,1,'2023-01-26 09:33:25','2023-01-26 09:33:25',NULL),(2171,7749,40720,1533,3,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',61445.79,NULL,NULL,1,'2023-01-26 09:33:25','2023-01-26 09:33:25',NULL),(2172,7749,40720,1533,3,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',44550.00,NULL,NULL,1,'2023-01-26 09:33:25','2023-01-26 09:33:25',NULL),(2173,7749,40720,1533,3,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',72768.01,NULL,NULL,1,'2023-01-26 09:33:25','2023-02-06 12:40:50','2023-02-06 12:40:50'),(2174,7749,40720,1533,3,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',82260.64,NULL,NULL,1,'2023-01-26 09:33:25','2023-01-26 09:33:25',NULL),(2175,7749,40720,1533,3,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',11234.55,NULL,NULL,1,'2023-01-26 09:33:25','2023-01-26 09:33:25',NULL),(2176,7749,40720,1533,3,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',13155.51,NULL,NULL,1,'2023-01-26 09:33:25','2023-02-09 09:33:35','2023-02-09 09:33:35'),(2177,7749,40720,1533,3,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',52007.32,NULL,NULL,1,'2023-01-26 09:33:25','2023-01-26 09:33:25',NULL);
INSERT INTO `balance_libro` VALUES (2178,7749,40720,1533,3,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1319690.38,NULL,NULL,1,'2023-01-26 09:37:31','2023-01-26 09:37:31',NULL),(2179,7749,40720,1533,3,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',28912.16,NULL,NULL,1,'2023-01-27 10:21:34','2023-01-27 10:21:34',NULL),(2180,7749,40720,1533,3,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',40055.44,NULL,NULL,1,'2023-01-27 10:21:34','2023-02-06 12:42:28','2023-02-06 12:42:28'),(2181,7749,40720,1533,3,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',12763.14,NULL,NULL,1,'2023-01-27 10:21:34','2023-01-27 10:21:34',NULL),(2182,7749,40720,1533,3,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',332456.74,NULL,NULL,1,'2023-01-27 10:21:34','2023-02-06 12:43:49','2023-02-06 12:43:49'),(2183,7749,40720,1533,3,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',26466.60,NULL,NULL,1,'2023-01-27 10:21:34','2023-01-27 10:21:34',NULL),(2184,7749,40720,1533,3,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',32048.22,NULL,NULL,1,'2023-01-30 09:15:39','2023-01-30 09:15:39',NULL),(2185,7749,40720,1533,3,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',17944.85,NULL,NULL,1,'2023-01-30 09:15:39','2023-01-30 09:15:39',NULL),(2186,7749,40720,1533,3,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',58612.05,NULL,NULL,1,'2023-01-30 09:15:39','2023-01-30 09:15:39',NULL),(2187,7749,40720,1533,3,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',36377.88,NULL,NULL,1,'2023-01-30 09:15:39','2023-01-30 09:15:39',NULL),(2188,7749,40720,1533,3,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',227967.70,NULL,NULL,1,'2023-01-30 09:15:39','2023-01-30 09:15:39',NULL),(2189,7749,40720,1533,3,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',35538.01,NULL,NULL,1,'2023-01-30 09:15:39','2023-01-30 09:15:39',NULL),(2190,7749,40720,1533,3,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',16276.97,NULL,NULL,1,'2023-01-30 09:15:39','2023-01-30 09:15:39',NULL),(2191,7749,40720,1533,3,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',39421.55,NULL,NULL,1,'2023-01-30 09:15:39','2023-01-30 09:15:39',NULL),(2192,7749,40720,1533,3,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',79748.12,NULL,NULL,1,'2023-01-30 09:15:39','2023-01-30 09:15:39',NULL),(2193,7749,40720,1533,3,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',9390.58,NULL,NULL,1,'2023-01-30 09:15:39','2023-01-30 09:15:39',NULL),(2194,7749,40720,1533,3,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',7310.15,NULL,NULL,1,'2023-01-30 09:15:40','2023-01-30 09:15:40',NULL),(2195,7749,40720,1533,3,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',34968.25,NULL,NULL,1,'2023-01-30 09:15:40','2023-01-30 09:15:40',NULL),(2196,7749,40720,1533,3,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',47080.63,NULL,NULL,1,'2023-01-30 09:15:40','2023-01-30 09:15:40',NULL),(2197,7749,40720,1533,3,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',69770.26,NULL,NULL,1,'2023-01-30 09:15:40','2023-01-30 09:15:40',NULL);
INSERT INTO `balance_libro` VALUES (2198,7749,40720,1533,3,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',38442.78,NULL,NULL,1,'2023-01-30 09:15:40','2023-01-30 09:15:40',NULL),(2199,7749,40720,1533,3,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',237204.28,NULL,NULL,1,'2023-01-30 09:15:40','2023-01-30 09:15:40',NULL),(2200,7749,40720,1533,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',13552.00,NULL,NULL,1,'2023-01-30 09:15:40','2023-01-30 09:15:40',NULL),(2201,7749,40720,1533,3,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',19049.68,NULL,NULL,1,'2023-01-30 09:15:40','2023-01-30 09:15:40',NULL),(2202,7749,40720,1533,3,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',9719.28,NULL,NULL,1,'2023-01-30 09:15:40','2023-01-30 09:15:40',NULL),(2203,7749,40720,1533,2,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',950000.00,NULL,NULL,1,'2023-01-30 09:41:17','2023-02-01 10:28:40','2023-02-01 10:28:40'),(2204,7749,40720,1533,3,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',48727.58,NULL,NULL,1,'2023-01-31 09:16:26','2023-01-31 09:16:26',NULL),(2205,7749,40720,1533,3,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',346560.75,NULL,NULL,1,'2023-01-31 09:16:26','2023-01-31 09:16:26',NULL),(2206,7749,40720,1533,3,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',792000.66,NULL,NULL,1,'2023-01-31 09:16:26','2023-01-31 09:16:26',NULL),(2207,7749,40720,1533,3,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',246900.00,NULL,NULL,1,'2023-01-31 09:16:26','2023-02-03 10:03:32','2023-02-03 10:03:32'),(2208,7749,40720,1533,3,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.00,NULL,NULL,1,'2023-01-31 09:16:27','2023-01-31 09:16:27',NULL),(2209,7749,40720,1533,2,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',132530.00,NULL,NULL,1,'2023-01-31 10:49:08','2023-01-31 10:49:08',NULL),(2210,7749,40720,1533,2,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2550.00,NULL,NULL,1,'2023-01-31 10:49:08','2023-01-31 10:49:08',NULL),(2211,7749,40720,1533,2,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',60000.00,NULL,NULL,1,'2023-01-31 10:49:08','2023-01-31 10:49:08',NULL),(2212,7749,40720,1533,3,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',69706.25,NULL,NULL,1,'2023-01-31 10:50:15','2023-01-31 10:50:15',NULL),(2213,7749,40720,1533,3,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',14201.18,NULL,NULL,1,'2023-01-31 10:51:11','2023-01-31 10:51:11',NULL),(2214,7749,40720,1533,3,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',44783.45,NULL,NULL,1,'2023-01-31 10:51:58','2023-01-31 10:51:58',NULL),(2215,7749,40720,1533,2,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',3340.00,NULL,NULL,1,'2023-02-01 08:53:26','2023-02-01 10:30:04','2023-02-01 10:30:04'),(2216,7749,40720,1533,2,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1150.02,NULL,NULL,1,'2023-02-01 08:53:26','2023-02-01 10:30:20','2023-02-01 10:30:20'),(2217,7749,40720,1533,2,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',8999.98,NULL,NULL,1,'2023-02-01 08:53:26','2023-02-01 10:32:33','2023-02-01 10:32:33');
INSERT INTO `balance_libro` VALUES (2218,7749,40720,1533,2,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',29729.99,NULL,NULL,1,'2023-02-01 08:53:26','2023-02-01 10:33:54','2023-02-01 10:33:54'),(2219,7749,40720,1533,2,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',13250.02,NULL,NULL,1,'2023-02-01 08:53:26','2023-02-01 10:34:09','2023-02-01 10:34:09'),(2220,7749,40720,1533,2,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',114069.93,NULL,NULL,1,'2023-02-01 08:53:26','2023-02-01 08:53:26',NULL),(2221,7749,40720,1533,2,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1199.97,NULL,NULL,1,'2023-02-01 08:53:26','2023-02-01 10:34:34','2023-02-01 10:34:34'),(2222,7749,40720,1533,2,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',13399.94,NULL,NULL,1,'2023-02-01 08:53:26','2023-02-01 10:35:00','2023-02-01 10:35:00'),(2223,7749,40720,1533,2,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',590.02,NULL,NULL,1,'2023-02-01 08:53:47','2023-02-01 08:53:47',NULL),(2224,7749,40720,1533,2,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2600.00,NULL,NULL,1,'2023-02-01 08:53:47','2023-02-01 08:53:47',NULL),(2225,7749,40720,1533,2,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',149.98,NULL,NULL,1,'2023-02-01 08:53:47','2023-02-01 08:53:47',NULL),(2226,7749,40720,1533,2,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1150.02,NULL,NULL,1,'2023-02-01 08:53:47','2023-02-01 08:53:47',NULL),(2227,7749,40720,1533,2,2060,'App\\Models\\Receipt',2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2400.01,NULL,NULL,1,'2023-02-01 08:53:47','2023-02-01 08:53:47',NULL),(2228,7749,40720,1533,2,2061,'App\\Models\\Receipt',2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',6599.97,NULL,NULL,1,'2023-02-01 08:53:47','2023-02-01 08:53:47',NULL),(2229,7749,40720,1533,2,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',16709.98,NULL,NULL,1,'2023-02-01 08:53:47','2023-02-01 08:53:47',NULL),(2230,7749,40720,1533,2,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4499.99,NULL,NULL,1,'2023-02-01 08:53:47','2023-02-01 08:53:47',NULL),(2231,7749,40720,1533,2,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',8520.01,NULL,NULL,1,'2023-02-01 08:53:47','2023-02-01 08:53:47',NULL),(2232,7749,40720,1533,2,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3250.00,NULL,NULL,1,'2023-02-01 08:53:47','2023-02-01 08:53:47',NULL),(2233,7749,40720,1533,2,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',10000.02,NULL,NULL,1,'2023-02-01 08:53:47','2023-02-01 08:53:47',NULL),(2234,7749,40720,1533,2,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1199.97,NULL,NULL,1,'2023-02-01 08:53:47','2023-02-01 08:53:47',NULL),(2235,7749,40720,1533,2,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',999.98,NULL,NULL,1,'2023-02-01 08:53:47','2023-02-01 08:53:47',NULL),(2236,7749,40720,1533,2,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2400.01,NULL,NULL,1,'2023-02-01 08:53:47','2023-02-01 08:53:47',NULL),(2237,7749,40720,1533,2,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',999.98,NULL,NULL,1,'2023-02-01 08:53:47','2023-02-01 08:53:47',NULL);
INSERT INTO `balance_libro` VALUES (2238,7749,40720,1533,2,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4699.99,NULL,NULL,1,'2023-02-01 08:53:47','2023-02-01 08:53:47',NULL),(2239,7749,40720,1533,2,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4299.99,NULL,NULL,1,'2023-02-01 08:53:47','2023-02-01 08:53:47',NULL),(2240,7749,40720,1533,2,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',112265.00,NULL,NULL,1,'2023-02-01 10:30:04','2023-02-01 10:30:04',NULL),(2241,7749,40720,1533,2,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',130550.00,NULL,NULL,1,'2023-02-01 10:30:20','2023-02-01 10:30:20',NULL),(2242,7749,40720,1533,2,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',170290.00,NULL,NULL,1,'2023-02-01 10:32:33','2023-02-01 10:32:33',NULL),(2243,7749,40720,1533,2,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',98545.00,NULL,NULL,1,'2023-02-01 10:33:54','2023-02-01 10:33:54',NULL),(2244,7749,40720,1533,2,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',74890.00,NULL,NULL,1,'2023-02-01 10:34:09','2023-02-01 10:34:09',NULL),(2245,7749,40720,1533,2,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',81670.00,NULL,NULL,1,'2023-02-01 10:34:34','2023-02-01 10:34:34',NULL),(2246,7749,40720,1533,2,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',64800.00,NULL,NULL,1,'2023-02-01 10:35:00','2023-02-01 10:35:00',NULL),(2247,7749,40720,1533,3,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',95404.74,NULL,NULL,1,'2023-02-01 10:40:09','2023-02-01 10:40:09',NULL),(2248,7749,40720,1533,3,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7006.59,NULL,NULL,1,'2023-02-01 10:40:09','2023-02-01 10:40:09',NULL),(2249,7749,40720,1533,3,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',71484.28,NULL,NULL,1,'2023-02-01 10:40:09','2023-02-01 10:40:09',NULL),(2250,7749,40720,1533,3,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',33342.06,NULL,NULL,1,'2023-02-01 10:40:09','2023-02-01 10:40:09',NULL),(2251,7749,40720,1533,3,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',72076.28,NULL,NULL,1,'2023-02-01 10:40:09','2023-02-01 10:40:09',NULL),(2252,7749,40720,1533,3,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',18509.53,NULL,NULL,1,'2023-02-01 10:40:09','2023-02-01 10:40:09',NULL),(2253,7749,40720,1533,3,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',22258.90,NULL,NULL,1,'2023-02-01 10:40:09','2023-02-01 10:40:09',NULL),(2254,7749,40720,1533,3,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',45181.45,NULL,NULL,1,'2023-02-01 10:40:09','2023-02-01 10:40:09',NULL),(2255,7749,40720,1533,3,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',390022.65,NULL,NULL,1,'2023-02-01 10:40:09','2023-02-01 10:40:09',NULL),(2256,7749,40720,1533,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',14612.37,NULL,NULL,1,'2023-02-01 10:40:09','2023-02-01 10:40:09',NULL),(2257,7749,40720,1533,3,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',33735.21,NULL,NULL,1,'2023-02-01 10:40:09','2023-02-01 10:40:09',NULL),(2258,7749,40720,1533,3,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',390022.65,NULL,NULL,1,'2023-02-01 10:40:09','2023-02-01 10:40:09',NULL);
INSERT INTO `balance_libro` VALUES (2259,7749,40720,1533,3,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',390022.65,NULL,NULL,1,'2023-02-01 10:40:09','2023-02-01 10:40:09',NULL),(2260,7749,40720,1533,3,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',33735.21,NULL,NULL,1,'2023-02-01 10:40:09','2023-02-01 10:40:09',NULL),(2261,7749,40720,1533,3,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',363678.36,NULL,NULL,1,'2023-02-01 10:40:09','2023-02-01 10:40:09',NULL),(2262,7749,40720,1533,3,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',390022.65,NULL,NULL,1,'2023-02-01 10:40:09','2023-02-01 10:40:09',NULL),(2263,7749,40720,1533,3,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9700.00,NULL,NULL,1,'2023-02-01 10:40:09','2023-02-01 10:40:09',NULL),(2264,7749,40720,1533,3,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',442257.68,NULL,NULL,1,'2023-02-03 09:56:31','2023-02-03 09:56:31',NULL),(2265,7749,40720,1533,3,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',246900.00,NULL,NULL,1,'2023-02-03 10:03:32','2023-02-03 10:03:32',NULL),(2266,7749,40720,1533,3,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',20175.54,NULL,NULL,1,'2023-02-06 12:20:52','2023-02-06 12:20:52',NULL),(2267,7749,40720,1533,3,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',350646.64,NULL,NULL,1,'2023-02-06 12:24:06','2023-02-06 12:24:06',NULL),(2268,7749,40720,1533,3,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',27822.99,NULL,NULL,1,'2023-02-06 12:26:26','2023-02-06 12:26:26',NULL),(2269,7749,40720,1533,3,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',20753.54,NULL,NULL,1,'2023-02-06 12:28:36','2023-02-06 12:28:36',NULL),(2270,7749,40720,1533,3,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',38803.04,NULL,NULL,1,'2023-02-06 12:31:04','2023-02-06 12:31:04',NULL),(2271,7749,40720,1533,3,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',14106.00,NULL,NULL,1,'2023-02-06 12:34:25','2023-02-06 12:34:25',NULL),(2272,7749,40720,1533,3,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',27986.71,NULL,NULL,1,'2023-02-06 12:35:10','2023-02-06 12:35:10',NULL),(2273,7749,40720,1533,3,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',155212.18,NULL,NULL,1,'2023-02-06 12:35:30','2023-02-06 12:35:30',NULL),(2274,7749,40720,1533,3,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',125692.07,NULL,NULL,1,'2023-02-06 12:36:03','2023-02-06 12:36:03',NULL),(2275,7749,40720,1533,3,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',39848.49,NULL,NULL,1,'2023-02-06 12:36:44','2023-02-06 12:36:44',NULL),(2276,7749,40720,1533,3,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',40055.44,NULL,NULL,1,'2023-02-06 12:42:28','2023-02-06 12:42:28',NULL),(2277,7749,40720,1533,3,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',332456.75,NULL,NULL,1,'2023-02-06 12:43:49','2023-02-06 12:43:49',NULL),(2278,7749,40720,1533,3,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',39804.29,NULL,NULL,1,'2023-02-06 12:50:07','2023-02-06 12:50:07',NULL),(2279,7749,40720,1533,3,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',13155.51,NULL,NULL,1,'2023-02-09 09:33:35','2023-02-09 09:33:35',NULL);
INSERT INTO `balance_libro` VALUES (2280,7749,40720,1534,2,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',31999.90,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2281,7749,40720,1534,2,2097,'App\\Models\\Receipt',2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',38999.99,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2282,7749,40720,1534,2,2098,'App\\Models\\Receipt',2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',12300.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2283,7749,40720,1534,2,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',53600.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2284,7749,40720,1534,2,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',28000.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2285,7749,40720,1534,2,2101,'App\\Models\\Receipt',2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',4000.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2286,7749,40720,1534,2,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',8899.99,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2287,7749,40720,1534,2,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1150.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2288,7749,40720,1534,2,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1720.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2289,7749,40720,1534,2,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',410.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2290,7749,40720,1534,2,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1500.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2291,7749,40720,1534,2,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',12800.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2292,7749,40720,1534,2,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',22800.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2293,7749,40720,1534,2,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',800.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2294,7749,40720,1534,2,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',7900.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2295,7749,40720,1534,2,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1100.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2296,7749,40720,1534,2,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',37700.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2297,7749,40720,1534,2,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',5300.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2298,7749,40720,1534,2,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',2700.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2299,7749,40720,1534,2,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',19250.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2300,7749,40720,1534,2,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',4400.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL);
INSERT INTO `balance_libro` VALUES (2301,7749,40720,1534,2,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',136000.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2302,7749,40720,1534,2,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',66199.85,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2303,7749,40720,1534,2,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',136000.00,NULL,NULL,1,'2023-02-28 09:32:35','2023-02-28 09:32:35',NULL),(2304,7749,40720,1534,2,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',106000.00,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2305,7749,40720,1534,2,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',27999.99,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2306,7749,40720,1534,2,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',125400.00,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2307,7749,40720,1534,2,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',37800.00,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2308,7749,40720,1534,2,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',85999.99,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2309,7749,40720,1534,2,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',5650.00,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2310,7749,40720,1534,2,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',9650.00,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2311,7749,40720,1534,2,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',17350.00,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2312,7749,40720,1534,2,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3999.99,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2313,7749,40720,1534,2,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',15000.00,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2314,7749,40720,1534,2,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',39900.00,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2315,7749,40720,1534,2,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',5950.00,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2316,7749,40720,1534,2,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',113300.00,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2317,7749,40720,1534,2,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',19299.98,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2318,7749,40720,1534,2,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',3000.00,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2319,7749,40720,1534,2,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',104750.00,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2320,7749,40720,1534,2,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',7620.00,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2321,7749,40720,1534,2,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',14300.00,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL);
INSERT INTO `balance_libro` VALUES (2322,7749,40720,1534,2,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',92900.00,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2323,7749,40720,1534,2,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',7530.00,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2324,7749,40720,1534,2,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',5400.00,NULL,NULL,1,'2023-02-28 09:32:36','2023-02-28 09:32:36',NULL),(2325,7749,40720,1534,2,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1660.00,NULL,NULL,1,'2023-02-28 09:32:37','2023-02-28 09:32:37',NULL),(2326,7749,40720,1534,2,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',132399.99,NULL,NULL,1,'2023-02-28 09:32:37','2023-02-28 09:32:37',NULL),(2327,7749,40720,1534,2,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',66199.85,NULL,NULL,1,'2023-02-28 09:32:37','2023-02-28 09:32:37',NULL),(2328,7749,40720,1534,2,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',35000.00,NULL,NULL,1,'2023-02-28 09:32:37','2023-02-28 09:32:37',NULL),(2329,7749,40720,1534,2,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',4300.00,NULL,NULL,1,'2023-02-28 09:32:37','2023-02-28 09:32:37',NULL),(2330,7749,40720,1534,2,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',39700.00,NULL,NULL,1,'2023-02-28 09:32:37','2023-02-28 09:32:37',NULL),(2331,7749,40720,1534,3,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',151275.59,NULL,NULL,1,'2023-02-28 09:32:46','2023-02-28 09:32:46',NULL),(2332,7749,40720,1534,3,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',150250.46,NULL,NULL,1,'2023-02-28 09:32:46','2023-02-28 09:32:46',NULL),(2333,7749,40720,1534,3,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',63223.75,NULL,NULL,1,'2023-02-28 09:32:46','2023-02-28 09:32:46',NULL),(2334,7749,40720,1534,3,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',155121.48,NULL,NULL,1,'2023-02-28 09:32:46','2023-03-17 11:08:03','2023-03-17 11:08:03'),(2335,7749,40720,1534,3,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',11563.22,NULL,NULL,1,'2023-02-28 09:32:46','2023-02-28 09:32:46',NULL),(2336,7749,40720,1534,3,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',24395.85,NULL,NULL,1,'2023-02-28 09:32:46','2023-02-28 09:32:46',NULL),(2337,7749,40720,1534,3,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',98042.61,NULL,NULL,1,'2023-02-28 09:32:46','2023-02-28 09:32:46',NULL),(2338,7749,40720,1534,3,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',330139.14,NULL,NULL,1,'2023-02-28 09:32:46','2023-02-28 09:34:09','2023-02-28 09:34:09'),(2339,7749,40720,1534,3,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',10927.07,NULL,NULL,1,'2023-02-28 09:32:46','2023-02-28 09:34:29','2023-02-28 09:34:29'),(2340,7749,40720,1534,3,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',21301.07,NULL,NULL,1,'2023-02-28 09:32:46','2023-02-28 09:32:46',NULL),(2341,7749,40720,1534,3,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',64781.84,NULL,NULL,1,'2023-02-28 09:32:46','2023-02-28 09:34:42','2023-02-28 09:34:42');
INSERT INTO `balance_libro` VALUES (2342,7749,40720,1534,3,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',156737.10,NULL,NULL,1,'2023-02-28 09:32:46','2023-03-17 11:10:40','2023-03-17 11:10:40'),(2343,7749,40720,1534,3,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',549612.56,NULL,NULL,1,'2023-02-28 09:32:46','2023-02-28 09:32:46',NULL),(2344,7749,40720,1534,3,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',19201.18,NULL,NULL,1,'2023-02-28 09:32:46','2023-02-28 09:34:57','2023-02-28 09:34:57'),(2345,7749,40720,1534,3,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',7400.07,NULL,NULL,1,'2023-02-28 09:32:46','2023-02-28 09:32:46',NULL),(2346,7749,40720,1534,3,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',8941.91,NULL,NULL,1,'2023-02-28 09:32:46','2023-03-17 12:07:50','2023-03-17 12:07:50'),(2347,7749,40720,1534,3,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',8941.91,NULL,NULL,1,'2023-02-28 09:32:46','2023-02-28 09:32:46',NULL),(2348,7749,40720,1534,3,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',25110.67,NULL,NULL,1,'2023-02-28 09:32:46','2023-02-28 09:32:46',NULL),(2349,7749,40720,1534,3,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',12284.34,NULL,NULL,1,'2023-02-28 09:32:46','2023-03-17 11:59:50','2023-03-17 11:59:50'),(2350,7749,40720,1534,3,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',8076.02,NULL,NULL,1,'2023-02-28 09:32:46','2023-03-17 12:06:50','2023-03-17 12:06:50'),(2351,7749,40720,1534,3,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',347274.04,NULL,NULL,1,'2023-02-28 09:32:46','2023-03-17 11:20:57','2023-03-17 11:20:57'),(2352,7749,40720,1534,3,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',10200.00,NULL,NULL,1,'2023-02-28 09:32:46','2023-02-28 09:32:46',NULL),(2353,7749,40720,1534,3,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',0.39,NULL,NULL,1,'2023-02-28 09:32:46','2023-02-28 09:32:46',NULL),(2354,7749,40720,1534,3,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',157366.61,NULL,NULL,1,'2023-02-28 09:32:46','2023-02-28 09:32:46',NULL),(2355,7749,40720,1534,3,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',28368.21,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:32:47',NULL),(2356,7749,40720,1534,3,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',102620.75,NULL,NULL,1,'2023-02-28 09:32:47','2023-03-17 11:23:17','2023-03-17 11:23:17'),(2357,7749,40720,1534,3,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1545681.90,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:32:47',NULL),(2358,7749,40720,1534,3,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',344786.32,NULL,NULL,1,'2023-02-28 09:32:47','2023-03-17 11:24:35','2023-03-17 11:24:35'),(2359,7749,40720,1534,3,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',8703.89,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:32:47',NULL),(2360,7749,40720,1534,3,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',6767.15,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:35:34','2023-02-28 09:35:34'),(2361,7749,40720,1534,3,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',155498.46,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:35:52','2023-02-28 09:35:52');
INSERT INTO `balance_libro` VALUES (2362,7749,40720,1534,3,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',30354.02,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:32:47',NULL),(2363,7749,40720,1534,3,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',24107.16,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:32:47',NULL),(2364,7749,40720,1534,3,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',89562.99,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:32:47',NULL),(2365,7749,40720,1534,3,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',377502.09,NULL,NULL,1,'2023-02-28 09:32:47','2023-03-17 11:27:57','2023-03-17 11:27:57'),(2366,7749,40720,1534,3,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',84948.12,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:32:47',NULL),(2367,7749,40720,1534,3,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',17820.00,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:32:47',NULL),(2368,7749,40720,1534,3,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',166233.69,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:32:47',NULL),(2369,7749,40720,1534,3,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',182078.96,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:32:47',NULL),(2370,7749,40720,1534,3,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',11799.99,NULL,NULL,1,'2023-02-28 09:32:47','2023-03-17 11:58:27','2023-03-17 11:58:27'),(2371,7749,40720,1534,3,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',24107.16,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:32:47',NULL),(2372,7749,40720,1534,3,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',217445.20,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:32:47',NULL),(2373,7749,40720,1534,3,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',228000.49,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:32:47',NULL),(2374,7749,40720,1534,3,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',63182.75,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:32:47',NULL),(2375,7749,40720,1534,3,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',18823.34,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:36:10','2023-02-28 09:36:10'),(2376,7749,40720,1534,3,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',59001.93,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:32:47',NULL),(2377,7749,40720,1534,3,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',236395.01,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:32:47',NULL),(2378,7749,40720,1534,3,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',394899.54,NULL,NULL,1,'2023-02-28 09:32:47','2023-02-28 09:32:47',NULL),(2379,7749,40720,1534,3,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',94112.58,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2380,7749,40720,1534,3,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',4313.09,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2381,7749,40720,1534,3,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',54028.78,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL);
INSERT INTO `balance_libro` VALUES (2382,7749,40720,1534,3,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',242429.55,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2383,7749,40720,1534,3,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',37082.03,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:37:13','2023-02-28 09:37:13'),(2384,7749,40720,1534,3,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',107226.81,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2385,7749,40720,1534,3,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',23185.26,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2386,7749,40720,1534,3,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',69280.00,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2387,7749,40720,1534,3,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',34042.36,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2388,7749,40720,1534,3,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',8152.17,NULL,NULL,1,'2023-02-28 09:32:48','2023-03-17 11:40:37','2023-03-17 11:40:37'),(2389,7749,40720,1534,3,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',78400.00,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2390,7749,40720,1534,3,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',16678.82,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2391,7749,40720,1534,3,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',39296.82,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:37:25','2023-02-28 09:37:25'),(2392,7749,40720,1534,3,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',11312.81,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2393,7749,40720,1534,3,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',996.10,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2394,7749,40720,1534,3,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',50401.98,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2395,7749,40720,1534,3,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',5894.16,NULL,NULL,1,'2023-02-28 09:32:48','2023-03-17 11:58:10','2023-03-17 11:58:10'),(2396,7749,40720,1534,3,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',99299.22,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2397,7749,40720,1534,3,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',32500.01,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2398,7749,40720,1534,3,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',42509.76,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2399,7749,40720,1534,3,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',84137.34,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2400,7749,40720,1534,3,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',14347.21,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2401,7749,40720,1534,3,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',32515.45,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL);
INSERT INTO `balance_libro` VALUES (2402,7749,40720,1534,3,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',48021.22,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2403,7749,40720,1534,3,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',280800.97,NULL,NULL,1,'2023-02-28 09:32:48','2023-02-28 09:32:48',NULL),(2404,7749,40720,1534,3,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',18651.21,NULL,NULL,1,'2023-02-28 09:32:49','2023-02-28 09:32:49',NULL),(2405,7749,40720,1534,3,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',50672.28,NULL,NULL,1,'2023-02-28 09:32:49','2023-02-28 09:32:49',NULL),(2406,7749,40720,1534,3,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',21410.48,NULL,NULL,1,'2023-02-28 09:32:49','2023-02-28 09:32:49',NULL),(2407,7749,40720,1534,3,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',10116.69,NULL,NULL,1,'2023-02-28 09:32:49','2023-02-28 09:32:49',NULL),(2408,7749,40720,1534,3,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',26388.60,NULL,NULL,1,'2023-02-28 09:32:49','2023-02-28 09:32:49',NULL),(2409,7749,40720,1534,3,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',11563.48,NULL,NULL,1,'2023-02-28 09:32:49','2023-02-28 09:32:49',NULL),(2410,7749,40720,1534,3,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',56553.27,NULL,NULL,1,'2023-02-28 09:32:49','2023-02-28 09:32:49',NULL),(2411,7749,40720,1534,3,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',52733.37,NULL,NULL,1,'2023-02-28 09:32:49','2023-02-28 09:32:49',NULL),(2412,7749,40720,1534,3,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',33055.31,NULL,NULL,1,'2023-02-28 09:32:49','2023-02-28 09:32:49',NULL),(2413,7749,40720,1534,3,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',142754.57,NULL,NULL,1,'2023-02-28 09:32:49','2023-02-28 09:32:49',NULL),(2414,7749,40720,1534,3,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',330139.13,NULL,NULL,1,'2023-02-28 09:34:09','2023-02-28 09:34:09',NULL),(2415,7749,40720,1534,3,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',10927.07,NULL,NULL,1,'2023-02-28 09:34:29','2023-02-28 09:34:29',NULL),(2416,7749,40720,1534,3,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',64781.84,NULL,NULL,1,'2023-02-28 09:34:42','2023-02-28 09:34:42',NULL),(2417,7749,40720,1534,3,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',19201.18,NULL,NULL,1,'2023-02-28 09:34:57','2023-02-28 09:34:57',NULL),(2418,7749,40720,1534,3,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',6767.15,NULL,NULL,1,'2023-02-28 09:35:34','2023-02-28 09:35:34',NULL),(2419,7749,40720,1534,3,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',155498.46,NULL,NULL,1,'2023-02-28 09:35:52','2023-02-28 09:35:52',NULL),(2420,7749,40720,1534,3,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',18823.33,NULL,NULL,1,'2023-02-28 09:36:10','2023-02-28 09:36:10',NULL),(2421,7749,40720,1534,3,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',37082.03,NULL,NULL,1,'2023-02-28 09:37:13','2023-02-28 09:37:13',NULL),(2422,7749,40720,1534,3,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',39296.83,NULL,NULL,1,'2023-02-28 09:37:25','2023-02-28 09:37:25',NULL);
INSERT INTO `balance_libro` VALUES (2423,7749,40720,1534,2,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',10990.03,NULL,NULL,1,'2023-02-28 09:38:32','2023-02-28 10:52:27','2023-02-28 10:52:27'),(2424,7749,40720,1534,2,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',14080.08,NULL,NULL,1,'2023-02-28 09:38:32','2023-02-28 10:52:58','2023-02-28 10:52:58'),(2425,7749,40720,1534,2,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',8099.97,NULL,NULL,1,'2023-02-28 09:38:32','2023-02-28 10:53:25','2023-02-28 10:53:25'),(2426,7749,40720,1534,2,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',7049.98,NULL,NULL,1,'2023-02-28 09:38:32','2023-02-28 10:53:51','2023-02-28 10:53:51'),(2427,7749,40720,1534,2,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1849.97,NULL,NULL,1,'2023-02-28 09:38:32','2023-02-28 09:38:32',NULL),(2428,7749,40720,1534,2,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',11389.96,NULL,NULL,1,'2023-02-28 09:38:32','2023-02-28 10:56:06','2023-02-28 10:56:06'),(2429,7749,40720,1534,2,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',23170.06,NULL,NULL,1,'2023-02-28 09:38:44','2023-02-28 10:56:25','2023-02-28 10:56:25'),(2430,7749,40720,1534,2,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',26749.99,NULL,NULL,1,'2023-02-28 09:38:44','2023-02-28 10:56:48','2023-02-28 10:56:48'),(2431,7749,40720,1534,2,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',5200.00,NULL,NULL,1,'2023-02-28 09:38:44','2023-02-28 10:57:37','2023-02-28 10:57:37'),(2432,7749,40720,1534,2,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',69039.89,NULL,NULL,1,'2023-02-28 09:38:44','2023-02-28 10:57:59','2023-02-28 10:57:59'),(2433,7749,40720,1534,2,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',20519.99,NULL,NULL,1,'2023-02-28 09:38:44','2023-02-28 10:58:17','2023-02-28 10:58:17'),(2434,7749,40720,1534,2,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1699.99,NULL,NULL,1,'2023-02-28 09:38:44','2023-02-28 10:58:43','2023-02-28 10:58:43'),(2435,7749,40720,1534,2,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',16410.02,NULL,NULL,1,'2023-02-28 09:38:44','2023-02-28 10:59:05','2023-02-28 10:59:05'),(2436,7749,40720,1534,2,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',14250.00,NULL,NULL,1,'2023-02-28 09:38:44','2023-02-28 10:59:23','2023-02-28 10:59:23'),(2437,7749,40720,1534,2,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',5249.96,NULL,NULL,1,'2023-02-28 09:38:44','2023-02-28 10:59:41','2023-02-28 10:59:41'),(2438,7749,40720,1534,2,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',6700.00,NULL,NULL,1,'2023-02-28 09:38:44','2023-02-28 11:00:00','2023-02-28 11:00:00'),(2439,7749,40720,1534,2,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',28409.82,NULL,NULL,1,'2023-02-28 09:38:45','2023-02-28 09:38:45',NULL),(2440,7749,40720,1534,2,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',118400.11,NULL,NULL,1,'2023-02-28 09:38:45','2023-02-28 09:38:45',NULL),(2441,7749,40720,1534,2,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1100.01,NULL,NULL,1,'2023-02-28 09:39:01','2023-02-28 09:39:01',NULL);
INSERT INTO `balance_libro` VALUES (2442,7749,40720,1534,2,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1640.01,NULL,NULL,1,'2023-02-28 09:39:01','2023-02-28 09:39:01',NULL),(2443,7749,40720,1534,2,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',4249.98,NULL,NULL,1,'2023-02-28 09:39:01','2023-02-28 09:39:01',NULL),(2444,7749,40720,1534,2,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1400.03,NULL,NULL,1,'2023-02-28 09:39:01','2023-02-28 09:39:01',NULL),(2445,7749,40720,1534,2,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2600.00,NULL,NULL,1,'2023-02-28 09:39:01','2023-02-28 09:39:01',NULL),(2446,7749,40720,1534,2,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',3930.02,NULL,NULL,1,'2023-02-28 09:39:01','2023-02-28 09:39:01',NULL),(2447,7749,40720,1534,2,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2650.02,NULL,NULL,1,'2023-02-28 09:39:01','2023-02-28 09:39:01',NULL),(2448,7749,40720,1534,2,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',4800.01,NULL,NULL,1,'2023-02-28 09:39:02','2023-02-28 09:39:02',NULL),(2449,7749,40720,1534,2,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2700.03,NULL,NULL,1,'2023-02-28 09:39:02','2023-02-28 09:39:02',NULL),(2450,7749,40720,1534,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',5600.00,NULL,NULL,1,'2023-02-28 09:39:02','2023-02-28 09:39:02',NULL),(2451,7749,40720,1534,2,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',2499.98,NULL,NULL,1,'2023-02-28 09:39:02','2023-02-28 09:39:02',NULL),(2452,7749,40720,1534,2,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',7049.98,NULL,NULL,1,'2023-02-28 09:39:02','2023-02-28 09:39:02',NULL),(2453,7749,40720,1534,2,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1440.02,NULL,NULL,1,'2023-02-28 09:39:02','2023-02-28 09:39:02',NULL),(2454,7749,40720,1534,2,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1620.02,NULL,NULL,1,'2023-02-28 09:39:02','2023-02-28 09:39:02',NULL),(2455,7749,40720,1534,2,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',9300.00,NULL,NULL,1,'2023-02-28 09:39:02','2023-02-28 09:39:02',NULL),(2456,7749,40720,1534,2,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',9300.00,NULL,NULL,1,'2023-02-28 09:39:02','2023-02-28 09:39:02',NULL),(2457,7749,40720,1534,2,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',9750.01,NULL,NULL,1,'2023-02-28 09:39:02','2023-02-28 09:39:02',NULL),(2458,7749,40720,1534,2,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',2800.00,NULL,NULL,1,'2023-02-28 09:39:02','2023-02-28 09:39:02',NULL),(2459,7749,40720,1534,2,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',5279.98,NULL,NULL,1,'2023-02-28 09:39:02','2023-02-28 09:39:02',NULL),(2460,7749,40720,1534,2,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',3309.98,NULL,NULL,1,'2023-02-28 09:39:02','2023-02-28 09:39:02',NULL),(2461,7749,40720,1534,2,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',9699.99,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL),(2462,7749,40720,1534,2,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',5500.03,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL);
INSERT INTO `balance_libro` VALUES (2463,7749,40720,1534,2,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',3500.01,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL),(2464,7749,40720,1534,2,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',900.01,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL),(2465,7749,40720,1534,2,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',2250.02,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL),(2466,7749,40720,1534,2,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1319.99,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL),(2467,7749,40720,1534,2,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',5000.01,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL),(2468,7749,40720,1534,2,2275,'App\\Models\\Receipt',2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',12300.00,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL),(2469,7749,40720,1534,2,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',9449.98,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL),(2470,7749,40720,1534,2,2277,'App\\Models\\Receipt',2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',5200.00,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL),(2471,7749,40720,1534,2,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',6199.98,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL),(2472,7749,40720,1534,2,2279,'App\\Models\\Receipt',2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',28244.97,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL),(2473,7749,40720,1534,2,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',28244.97,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL),(2474,7749,40720,1534,2,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1649.98,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL),(2475,7749,40720,1534,2,2282,'App\\Models\\Receipt',2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',4699.99,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL),(2476,7749,40720,1534,2,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',19000.00,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL),(2477,7749,40720,1534,2,2284,'App\\Models\\Receipt',2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1519.99,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL),(2478,7749,40720,1534,2,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1699.99,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL),(2479,7749,40720,1534,2,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',3660.02,NULL,NULL,1,'2023-02-28 09:39:10','2023-02-28 09:39:10',NULL),(2480,7749,40720,1534,2,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',2200.01,NULL,NULL,1,'2023-02-28 09:39:11','2023-02-28 09:39:11',NULL),(2481,7749,40720,1534,2,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',10549.99,NULL,NULL,1,'2023-02-28 09:39:11','2023-02-28 09:39:11',NULL),(2482,7749,40720,1534,2,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',7150.01,NULL,NULL,1,'2023-02-28 09:39:11','2023-02-28 09:39:11',NULL),(2483,7749,40720,1534,2,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',2200.01,NULL,NULL,1,'2023-02-28 09:39:11','2023-02-28 09:39:11',NULL);
INSERT INTO `balance_libro` VALUES (2484,7749,40720,1534,2,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1899.99,NULL,NULL,1,'2023-02-28 09:39:11','2023-02-28 09:39:11',NULL),(2485,7749,40720,1534,2,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',2999.99,NULL,NULL,1,'2023-02-28 09:39:11','2023-02-28 09:39:11',NULL),(2486,7749,40720,1534,2,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',149.98,NULL,NULL,1,'2023-02-28 09:39:11','2023-02-28 09:39:11',NULL),(2487,7749,40720,1534,2,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',5099.98,NULL,NULL,1,'2023-02-28 09:39:11','2023-02-28 09:39:11',NULL),(2488,7749,40720,1534,2,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',5200.00,NULL,NULL,1,'2023-02-28 09:39:11','2023-02-28 09:39:11',NULL),(2489,7749,40720,1534,2,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1500.00,NULL,NULL,1,'2023-02-28 09:39:11','2023-02-28 09:39:11',NULL),(2490,7749,40720,1534,2,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',106480.00,NULL,NULL,1,'2023-02-28 10:52:27','2023-02-28 10:52:27',NULL),(2491,7749,40720,1534,2,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',108885.00,NULL,NULL,1,'2023-02-28 10:52:58','2023-02-28 10:52:58',NULL),(2492,7749,40720,1534,2,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',81199.98,NULL,NULL,1,'2023-02-28 10:53:25','2023-02-28 10:53:25',NULL),(2493,7749,40720,1534,2,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',120149.99,NULL,NULL,1,'2023-02-28 10:53:51','2023-02-28 10:53:51',NULL),(2494,7749,40720,1534,2,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',88060.99,NULL,NULL,1,'2023-02-28 10:55:39','2023-02-28 10:55:39',NULL),(2495,7749,40720,1534,2,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',92220.04,NULL,NULL,1,'2023-02-28 10:56:06','2023-02-28 10:56:06',NULL),(2496,7749,40720,1534,2,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',76740.01,NULL,NULL,1,'2023-02-28 10:56:25','2023-02-28 10:56:25',NULL),(2497,7749,40720,1534,2,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',107765.02,NULL,NULL,1,'2023-02-28 10:56:48','2023-02-28 10:56:48',NULL),(2498,7749,40720,1534,2,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',111409.56,NULL,NULL,1,'2023-02-28 10:57:37','2023-02-28 10:57:37',NULL),(2499,7749,40720,1534,2,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',121729.94,NULL,NULL,1,'2023-02-28 10:57:59','2023-02-28 10:57:59',NULL),(2500,7749,40720,1534,2,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',123675.00,NULL,NULL,1,'2023-02-28 10:58:17','2023-02-28 10:58:17',NULL),(2501,7749,40720,1534,2,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',144000.02,NULL,NULL,1,'2023-02-28 10:58:43','2023-02-28 10:58:43',NULL),(2502,7749,40720,1534,2,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',126440.00,NULL,NULL,1,'2023-02-28 10:59:05','2023-02-28 10:59:05',NULL),(2503,7749,40720,1534,2,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',123349.94,NULL,NULL,1,'2023-02-28 10:59:23','2023-02-28 10:59:23',NULL),(2504,7749,40720,1534,2,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',68979.99,NULL,NULL,1,'2023-02-28 10:59:41','2023-02-28 10:59:41',NULL);
INSERT INTO `balance_libro` VALUES (2505,7749,40720,1534,2,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',200719.97,NULL,NULL,1,'2023-02-28 11:00:00','2023-02-28 11:00:00',NULL),(2506,7749,40720,1534,2,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',934120.00,NULL,NULL,1,'2023-02-28 11:03:51','2023-03-01 11:06:09','2023-03-01 11:06:09'),(2507,7749,40720,1534,3,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',12500.12,NULL,NULL,1,'2023-02-28 11:26:31','2023-02-28 11:26:31',NULL),(2508,7749,40720,1534,3,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',9999.95,NULL,NULL,1,'2023-02-28 11:27:03','2023-02-28 11:27:03',NULL),(2509,7749,40720,1534,3,2301,'App\\Models\\Receipt',2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',36033.21,NULL,NULL,1,'2023-02-28 11:28:52','2023-02-28 11:28:52',NULL),(2510,7749,40720,1534,3,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',62213.70,NULL,NULL,1,'2023-02-28 11:29:11','2023-02-28 11:29:11',NULL),(2511,7749,40720,1534,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',232865.09,NULL,NULL,1,'2023-02-28 11:29:37','2023-02-28 11:29:37',NULL),(2512,7749,40720,1534,3,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',150767.79,NULL,NULL,1,'2023-02-28 11:29:56','2023-02-28 11:29:56',NULL),(2513,7749,40720,1534,3,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',72747.67,NULL,NULL,1,'2023-02-28 11:30:18','2023-02-28 11:30:18',NULL),(2514,7749,40719,19,2,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',140000.00,NULL,NULL,1,'2023-02-28 12:22:49','2023-02-28 12:22:49',NULL),(2515,7749,40720,1534,2,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',19939.94,NULL,NULL,1,'2023-03-01 11:03:40','2023-03-01 11:07:11','2023-03-01 11:07:11'),(2516,7749,40720,1534,2,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1280.01,NULL,NULL,1,'2023-03-01 11:03:40','2023-03-01 11:03:40',NULL),(2517,7749,40720,1534,2,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1849.97,NULL,NULL,1,'2023-03-01 11:03:40','2023-03-01 11:08:58','2023-03-01 11:08:58'),(2518,7749,40720,1534,2,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',11250.00,NULL,NULL,1,'2023-03-01 11:03:41','2023-03-01 11:09:19','2023-03-01 11:09:19'),(2519,7749,40720,1534,2,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',21790.03,NULL,NULL,1,'2023-03-01 11:03:41','2023-03-01 11:10:14','2023-03-01 11:10:14'),(2520,7749,40720,1534,2,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4930.00,NULL,NULL,1,'2023-03-01 11:03:41','2023-03-01 11:11:34','2023-03-01 11:11:34'),(2521,7749,40720,1534,2,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',6739.99,NULL,NULL,1,'2023-03-01 11:03:56','2023-03-01 11:03:56',NULL),(2522,7749,40720,1534,2,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',6199.98,NULL,NULL,1,'2023-03-01 11:03:56','2023-03-01 11:03:56',NULL),(2523,7749,40720,1534,2,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',3999.97,NULL,NULL,1,'2023-03-01 11:03:56','2023-03-01 11:03:56',NULL),(2524,7749,40720,1534,2,2316,'App\\Models\\Receipt',2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',2999.99,NULL,NULL,1,'2023-03-01 11:03:56','2023-03-01 11:03:56',NULL);
INSERT INTO `balance_libro` VALUES (2525,7749,40720,1534,2,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',3500.01,NULL,NULL,1,'2023-03-01 11:03:56','2023-03-01 11:03:56',NULL),(2526,7749,40720,1534,2,2318,'App\\Models\\Receipt',2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',9449.98,NULL,NULL,1,'2023-03-01 11:03:56','2023-03-01 11:03:56',NULL),(2527,7749,40720,1534,2,2319,'App\\Models\\Receipt',2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1849.97,NULL,NULL,1,'2023-03-01 11:03:56','2023-03-01 11:03:56',NULL),(2528,7749,40720,1534,2,2320,'App\\Models\\Receipt',2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',3250.00,NULL,NULL,1,'2023-03-01 11:03:56','2023-03-01 11:03:56',NULL),(2529,7749,40720,1534,2,2321,'App\\Models\\Receipt',2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',8000.00,NULL,NULL,1,'2023-03-01 11:03:56','2023-03-01 11:03:56',NULL),(2530,7749,40720,1534,2,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',5340.02,NULL,NULL,1,'2023-03-01 11:03:56','2023-03-01 11:03:56',NULL),(2531,7749,40720,1534,2,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',16450.01,NULL,NULL,1,'2023-03-01 11:03:56','2023-03-01 11:03:56',NULL),(2532,7749,40720,1534,2,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1730.01,NULL,NULL,1,'2023-03-01 11:03:56','2023-03-01 11:03:56',NULL),(2533,7749,40720,1534,2,2325,'App\\Models\\Receipt',2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3199.99,NULL,NULL,1,'2023-03-01 11:03:56','2023-03-01 11:03:56',NULL),(2534,7749,40720,1534,2,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',134309.99,NULL,NULL,1,'2023-03-01 11:07:11','2023-03-01 11:07:11',NULL),(2535,7749,40720,1534,2,2326,'App\\Models\\Receipt',2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',143139.97,NULL,NULL,1,'2023-03-01 11:08:27','2023-03-01 11:08:27',NULL),(2536,7749,40720,1534,2,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',189420.01,NULL,NULL,1,'2023-03-01 11:08:58','2023-03-01 11:08:58',NULL),(2537,7749,40720,1534,2,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',87009.96,NULL,NULL,1,'2023-03-01 11:09:19','2023-03-01 11:09:19',NULL),(2538,7749,40720,1534,2,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',133690.01,NULL,NULL,1,'2023-03-01 11:10:14','2023-03-01 11:10:14',NULL),(2539,7749,40720,1534,2,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',128090.03,NULL,NULL,1,'2023-03-01 11:11:34','2023-03-01 11:11:34',NULL),(2540,7749,40720,1535,2,2327,'App\\Models\\Receipt',2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',120780.00,NULL,NULL,1,'2023-03-03 10:11:34','2023-03-03 10:11:34',NULL),(2541,7749,40720,1535,2,2328,'App\\Models\\Receipt',2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',8710.00,NULL,NULL,1,'2023-03-03 10:11:34','2023-03-03 10:11:34',NULL),(2542,7749,40720,1535,2,2329,'App\\Models\\Receipt',2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',124000.00,NULL,NULL,1,'2023-03-03 10:11:34','2023-03-03 10:11:34',NULL),(2543,7749,40720,1535,2,2330,'App\\Models\\Receipt',2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',1800.00,NULL,NULL,1,'2023-03-03 10:11:34','2023-03-03 10:11:34',NULL),(2544,7749,40720,1535,2,2331,'App\\Models\\Receipt',2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',63699.99,NULL,NULL,1,'2023-03-03 10:11:34','2023-03-03 10:11:34',NULL),(2545,7749,40720,1535,2,2332,'App\\Models\\Receipt',2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',41949.99,NULL,NULL,1,'2023-03-03 10:11:34','2023-03-03 10:11:34',NULL);
INSERT INTO `balance_libro` VALUES (2546,7749,40720,1535,2,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',65349.26,NULL,NULL,1,'2023-03-03 10:11:34','2023-03-03 10:11:34',NULL),(2547,7749,40720,1535,2,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',128859.98,NULL,NULL,1,'2023-03-03 10:11:34','2023-03-03 10:11:34',NULL),(2548,7749,40720,1535,2,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',15500.00,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL),(2549,7749,40720,1535,2,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',620.00,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL),(2550,7749,40720,1535,2,2337,'App\\Models\\Receipt',2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',9300.00,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL),(2551,7749,40720,1535,2,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',103699.99,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL),(2552,7749,40720,1535,2,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',149600.00,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL),(2553,7749,40720,1535,2,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',76499.88,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL),(2554,7749,40720,1535,2,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',149600.00,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL),(2555,7749,40720,1535,2,2342,'App\\Models\\Receipt',2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',34399.86,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL),(2556,7749,40720,1535,2,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',33660.00,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL),(2557,7749,40720,1535,2,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',79739.86,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL),(2558,7749,40720,1535,2,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',107999.95,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL),(2559,7749,40720,1535,2,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',128599.99,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL),(2560,7749,40720,1535,2,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',117999.97,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL),(2561,7749,40720,1535,2,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',85500.00,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL),(2562,7749,40720,1535,2,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',102999.94,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL),(2563,7749,40720,1535,2,2350,'App\\Models\\Receipt',2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',132799.97,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL),(2564,7749,40720,1535,2,2351,'App\\Models\\Receipt',2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',7950.00,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL),(2565,7749,40720,1535,2,2352,'App\\Models\\Receipt',2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',27300.00,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL),(2566,7749,40720,1535,2,2353,'App\\Models\\Receipt',2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',115249.96,NULL,NULL,1,'2023-03-03 10:11:35','2023-03-03 10:11:35',NULL);
INSERT INTO `balance_libro` VALUES (2567,7749,40720,1535,2,2354,'App\\Models\\Receipt',2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2100.00,NULL,NULL,1,'2023-03-03 10:11:36','2023-03-03 10:11:36',NULL),(2568,7749,40720,1535,2,2355,'App\\Models\\Receipt',2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',41000.00,NULL,NULL,1,'2023-03-03 10:11:36','2023-03-03 10:11:36',NULL),(2569,7749,40720,1535,2,2356,'App\\Models\\Receipt',2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',8500.00,NULL,NULL,1,'2023-03-03 10:11:36','2023-03-03 10:11:36',NULL),(2570,7749,40720,1535,2,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',4500.00,NULL,NULL,1,'2023-03-03 10:11:36','2023-03-03 10:11:36',NULL),(2571,7749,40720,1535,2,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',76800.00,NULL,NULL,1,'2023-03-03 10:11:36','2023-03-03 10:11:36',NULL),(2572,7749,40720,1535,2,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3000.00,NULL,NULL,1,'2023-03-03 10:11:36','2023-03-03 10:11:36',NULL),(2573,7749,40720,1535,2,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',8760.00,NULL,NULL,1,'2023-03-03 10:11:36','2023-03-03 10:11:36',NULL),(2574,7749,40720,1535,2,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',7200.00,NULL,NULL,1,'2023-03-03 10:11:36','2023-03-03 10:11:36',NULL),(2575,7749,40720,1535,2,2362,'App\\Models\\Receipt',2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',130500.00,NULL,NULL,1,'2023-03-03 10:11:36','2023-03-03 10:11:36',NULL),(2576,7749,40720,1535,2,2363,'App\\Models\\Receipt',2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',16000.00,NULL,NULL,1,'2023-03-03 10:11:36','2023-03-03 10:11:36',NULL),(2577,7749,40720,1535,2,2364,'App\\Models\\Receipt',2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',26000.00,NULL,NULL,1,'2023-03-03 10:11:36','2023-03-03 10:11:36',NULL),(2578,7749,40720,1535,2,2365,'App\\Models\\Receipt',2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',11000.00,NULL,NULL,1,'2023-03-03 10:11:36','2023-03-03 10:11:36',NULL),(2579,7749,40720,1535,2,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',138450.00,NULL,NULL,1,'2023-03-03 10:11:36','2023-03-03 10:11:36',NULL),(2580,7749,40720,1535,2,2367,'App\\Models\\Receipt',2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',64000.00,NULL,NULL,1,'2023-03-03 10:11:37','2023-03-03 10:11:37',NULL),(2581,7749,40720,1535,2,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',24000.00,NULL,NULL,1,'2023-03-03 10:11:37','2023-03-03 10:11:37',NULL),(2582,7749,40720,1535,2,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',6300.00,NULL,NULL,1,'2023-03-03 10:11:37','2023-03-03 10:11:37',NULL),(2583,7749,40720,1535,2,2370,'App\\Models\\Receipt',2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',156949.97,NULL,NULL,1,'2023-03-03 10:11:37','2023-03-03 10:11:37',NULL),(2584,7749,40720,1535,2,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',15850.00,NULL,NULL,1,'2023-03-03 10:11:37','2023-03-03 10:11:37',NULL),(2585,7749,40720,1535,2,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',76899.99,NULL,NULL,1,'2023-03-03 10:11:37','2023-03-03 10:11:37',NULL),(2586,7749,40720,1535,2,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',25200.00,NULL,NULL,1,'2023-03-03 10:11:37','2023-03-03 10:11:37',NULL),(2587,7749,40720,1535,2,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3200.00,NULL,NULL,1,'2023-03-03 10:11:37','2023-03-03 10:11:37',NULL);
INSERT INTO `balance_libro` VALUES (2588,7749,40720,1535,2,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',295000.00,NULL,NULL,1,'2023-03-03 10:11:37','2023-03-03 10:11:37',NULL),(2589,7749,40720,1535,2,2376,'App\\Models\\Receipt',2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',111715.00,NULL,NULL,1,'2023-03-03 10:11:37','2023-03-03 10:11:37',NULL),(2590,7749,40720,1535,2,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',35000.00,NULL,NULL,1,'2023-03-03 10:11:37','2023-03-03 10:11:37',NULL),(2591,7749,40720,1535,2,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',122799.97,NULL,NULL,1,'2023-03-03 10:11:37','2023-03-03 10:11:37',NULL),(2592,7749,40720,1535,2,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',172649.97,NULL,NULL,1,'2023-03-03 10:11:37','2023-03-03 10:11:37',NULL),(2593,7749,40720,1535,2,2380,'App\\Models\\Receipt',2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',27200.00,NULL,NULL,1,'2023-03-03 10:11:37','2023-03-03 10:11:37',NULL),(2594,7749,40720,1535,2,2381,'App\\Models\\Receipt',2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',8200.00,NULL,NULL,1,'2023-03-03 10:11:37','2023-03-03 10:11:37',NULL),(2595,7749,40720,1535,2,2382,'App\\Models\\Receipt',2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',8200.00,NULL,NULL,1,'2023-03-03 10:11:37','2023-03-03 10:11:37',NULL),(2596,7749,40720,1535,2,2383,'App\\Models\\Receipt',2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',8200.00,NULL,NULL,1,'2023-03-03 10:11:37','2023-03-03 10:11:37',NULL),(2597,7749,40720,1535,2,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',8200.00,NULL,NULL,1,'2023-03-03 10:11:38','2023-03-03 10:11:38',NULL),(2598,7749,40720,1535,2,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',43199.99,NULL,NULL,1,'2023-03-03 10:11:38','2023-03-03 10:11:38',NULL),(2599,7749,40720,1535,2,2386,'App\\Models\\Receipt',2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',40089.80,NULL,NULL,1,'2023-03-03 10:11:38','2023-03-03 10:11:38',NULL),(2600,7749,40720,1535,2,2387,'App\\Models\\Receipt',2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',67300.00,NULL,NULL,1,'2023-03-03 10:11:38','2023-03-03 10:11:38',NULL),(2601,7749,40720,1535,2,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',24999.99,NULL,NULL,1,'2023-03-03 10:11:38','2023-03-03 10:11:38',NULL),(2602,7749,40720,1535,2,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',67409.99,NULL,NULL,1,'2023-03-03 10:11:38','2023-03-03 10:11:38',NULL),(2603,7749,40720,1535,2,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',9900.00,NULL,NULL,1,'2023-03-03 10:11:38','2023-03-03 10:11:38',NULL),(2604,7749,40720,1535,2,2391,'App\\Models\\Receipt',2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',750.00,NULL,NULL,1,'2023-03-03 10:11:38','2023-03-03 10:11:38',NULL),(2605,7749,40720,1535,2,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',91843.49,NULL,NULL,1,'2023-03-03 10:11:38','2023-03-03 10:11:38',NULL),(2606,7749,40720,1535,2,2393,'App\\Models\\Receipt',2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',12800.00,NULL,NULL,1,'2023-03-03 10:11:38','2023-03-03 10:11:38',NULL),(2607,7749,40720,1535,2,2394,'App\\Models\\Receipt',2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',73369.99,NULL,NULL,1,'2023-03-03 10:11:38','2023-03-03 10:11:38',NULL),(2608,7749,40720,1535,2,2395,'App\\Models\\Receipt',2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',5700.00,NULL,NULL,1,'2023-03-03 10:11:38','2023-03-03 10:11:38',NULL);
INSERT INTO `balance_libro` VALUES (2609,7749,40720,1535,2,2396,'App\\Models\\Receipt',2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',20500.00,NULL,NULL,1,'2023-03-03 10:11:38','2023-03-03 10:11:38',NULL),(2610,7749,40720,1535,2,2397,'App\\Models\\Receipt',2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',56500.00,NULL,NULL,1,'2023-03-03 10:11:38','2023-03-03 10:11:38',NULL),(2611,7749,40720,1535,2,2398,'App\\Models\\Receipt',2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',65650.00,NULL,NULL,1,'2023-03-03 10:11:38','2023-03-03 10:11:38',NULL),(2612,7749,40720,1535,2,2399,'App\\Models\\Receipt',2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',38290.00,NULL,NULL,1,'2023-03-03 10:11:38','2023-03-03 10:11:38',NULL),(2613,7749,40720,1535,2,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',35999.99,NULL,NULL,1,'2023-03-03 10:11:39','2023-03-03 10:11:39',NULL),(2614,7749,40720,1535,2,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',19600.00,NULL,NULL,1,'2023-03-03 10:11:39','2023-03-03 10:11:39',NULL),(2615,7749,40720,1535,2,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2800.00,NULL,NULL,1,'2023-03-03 10:11:39','2023-03-03 10:11:39',NULL),(2616,7749,40720,1535,2,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',1500.00,NULL,NULL,1,'2023-03-03 10:11:39','2023-03-03 10:11:39',NULL),(2617,7749,40720,1535,2,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',9600.00,NULL,NULL,1,'2023-03-03 10:11:39','2023-03-03 10:11:39',NULL),(2618,7749,40720,1535,2,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',5109.99,NULL,NULL,1,'2023-03-03 10:11:39','2023-03-03 10:11:39',NULL),(2619,7749,40720,1535,2,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',24600.00,NULL,NULL,1,'2023-03-03 10:11:39','2023-03-03 10:11:39',NULL),(2620,7749,40720,1534,3,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',155121.48,NULL,NULL,1,'2023-03-17 11:08:03','2023-03-17 11:08:03',NULL),(2621,7749,40720,1534,3,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',156737.10,NULL,NULL,1,'2023-03-17 11:10:40','2023-03-17 11:10:40',NULL),(2622,7749,40720,1534,3,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',22829.45,NULL,NULL,1,'2023-03-17 11:17:30','2023-03-17 11:17:45','2023-03-17 11:17:45'),(2623,7749,40720,1534,3,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',22829.45,NULL,NULL,1,'2023-03-17 11:17:45','2023-03-17 11:17:45',NULL),(2624,7749,40720,1534,3,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',347274.04,NULL,NULL,1,'2023-03-17 11:20:57','2023-03-17 11:20:57',NULL),(2625,7749,40720,1534,3,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',102620.76,NULL,NULL,1,'2023-03-17 11:23:17','2023-03-17 11:23:17',NULL),(2626,7749,40720,1534,3,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',344786.32,NULL,NULL,1,'2023-03-17 11:24:35','2023-03-17 11:24:35',NULL),(2627,7749,40720,1534,3,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',377502.09,NULL,NULL,1,'2023-03-17 11:27:57','2023-03-17 11:27:57',NULL),(2628,7749,40720,1534,3,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',4900.03,NULL,NULL,1,'2023-03-17 11:42:05','2023-03-17 11:42:05',NULL);
INSERT INTO `balance_libro` VALUES (2629,7749,40720,1534,3,2409,'App\\Models\\Receipt',2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',31410.00,NULL,NULL,1,'2023-03-17 11:46:11','2023-03-17 11:57:23','2023-03-17 11:57:23'),(2630,7749,40720,1534,3,2410,'App\\Models\\Receipt',2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',140000.00,NULL,NULL,1,'2023-03-17 11:46:11','2023-03-17 11:46:11',NULL),(2631,7749,40720,1534,3,2411,'App\\Models\\Receipt',2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',16573.84,NULL,NULL,1,'2023-03-17 11:46:11','2023-03-17 11:47:46','2023-03-17 11:47:46'),(2632,7749,40720,1534,3,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',455761.71,NULL,NULL,1,'2023-03-17 11:46:11','2023-03-17 11:46:11',NULL),(2633,7749,40720,1534,3,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5545.50,NULL,NULL,1,'2023-03-17 11:46:11','2023-03-17 11:55:52','2023-03-17 11:55:52'),(2634,7749,40720,1534,3,2414,'App\\Models\\Receipt',2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',22932.98,NULL,NULL,1,'2023-03-17 11:46:11','2023-03-17 11:46:11',NULL),(2635,7749,40720,1534,3,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',15104.74,NULL,NULL,1,'2023-03-17 11:46:11','2023-03-17 11:46:11',NULL),(2636,7749,40720,1534,3,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',8250.51,NULL,NULL,1,'2023-03-17 11:46:11','2023-03-17 11:46:11',NULL),(2637,7749,40720,1534,3,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',8498.76,NULL,NULL,1,'2023-03-17 11:46:11','2023-03-17 11:46:11',NULL),(2638,7749,40720,1534,3,2418,'App\\Models\\Receipt',2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',14159.54,NULL,NULL,1,'2023-03-17 11:46:11','2023-03-17 11:46:11',NULL),(2639,7749,40720,1534,3,2419,'App\\Models\\Receipt',2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',63266.06,NULL,NULL,1,'2023-03-17 11:46:11','2023-03-17 11:46:11',NULL),(2640,7749,40720,1534,3,2411,'App\\Models\\Receipt',2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',16573.84,NULL,NULL,1,'2023-03-17 11:47:46','2023-03-17 11:47:46',NULL),(2641,7749,40720,1534,3,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5545.50,NULL,NULL,1,'2023-03-17 11:55:52','2023-03-17 11:55:52',NULL),(2642,7749,40720,1534,3,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',9045.44,NULL,NULL,1,'2023-03-17 12:10:13','2023-03-17 12:10:46','2023-03-17 12:10:46'),(2643,7749,40720,1534,3,2421,'App\\Models\\Receipt',2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',16161.91,NULL,NULL,1,'2023-03-17 12:10:36','2023-03-17 12:10:36',NULL),(2644,7749,40720,1534,3,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',9045.44,NULL,NULL,1,'2023-03-17 12:10:46','2023-03-17 12:10:46',NULL),(2645,7749,40720,1535,3,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',12705686.00,NULL,NULL,1,'2023-03-17 12:32:27','2023-03-29 10:14:59','2023-03-29 10:14:59'),(2646,7749,40720,1535,3,2423,'App\\Models\\Receipt',2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',8699.00,NULL,NULL,1,'2023-03-17 12:32:27','2023-03-17 12:32:27',NULL),(2647,7749,40720,1535,3,2424,'App\\Models\\Receipt',2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',112952.38,NULL,NULL,1,'2023-03-17 12:32:28','2023-04-17 11:06:51','2023-04-17 11:06:51'),(2648,7749,40720,1535,3,2425,'App\\Models\\Receipt',2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',365876.56,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL);
INSERT INTO `balance_libro` VALUES (2649,7749,40720,1535,3,2426,'App\\Models\\Receipt',2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',5850.08,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL),(2650,7749,40720,1535,3,2427,'App\\Models\\Receipt',2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',276132.37,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL),(2651,7749,40720,1535,3,2428,'App\\Models\\Receipt',2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',50583.70,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL),(2652,7749,40720,1535,3,2429,'App\\Models\\Receipt',2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',7799.95,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL),(2653,7749,40720,1535,3,2430,'App\\Models\\Receipt',2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',52468.95,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL),(2654,7749,40720,1535,3,2431,'App\\Models\\Receipt',2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',296849.42,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL),(2655,7749,40720,1535,3,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',42677.89,NULL,NULL,1,'2023-03-17 12:32:28','2023-04-17 11:16:01','2023-04-17 11:16:01'),(2656,7749,40720,1535,3,2433,'App\\Models\\Receipt',2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',5258.66,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL),(2657,7749,40720,1535,3,2434,'App\\Models\\Receipt',2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',279419.25,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL),(2658,7749,40720,1535,3,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',304239.79,NULL,NULL,1,'2023-03-17 12:32:28','2023-04-17 11:17:13','2023-04-17 11:17:13'),(2659,7749,40720,1535,3,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',311708.69,NULL,NULL,1,'2023-03-17 12:32:28','2023-04-17 11:17:46','2023-04-17 11:17:46'),(2660,7749,40720,1535,3,2437,'App\\Models\\Receipt',2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',14272.78,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL),(2661,7749,40720,1535,3,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',63157.89,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL),(2662,7749,40720,1535,3,2439,'App\\Models\\Receipt',2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',46856.20,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL),(2663,7749,40720,1535,3,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',142682.78,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL),(2664,7749,40720,1535,3,2441,'App\\Models\\Receipt',2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',15847.13,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL),(2665,7749,40720,1535,3,2442,'App\\Models\\Receipt',2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',9787.68,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL),(2666,7749,40720,1535,3,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',13238.51,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL),(2667,7749,40720,1535,3,2444,'App\\Models\\Receipt',2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',9787.06,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL),(2668,7749,40720,1535,3,2445,'App\\Models\\Receipt',2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',34392.11,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL);
INSERT INTO `balance_libro` VALUES (2669,7749,40720,1535,3,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',253230.22,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL),(2670,7749,40720,1535,3,2447,'App\\Models\\Receipt',2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',125167.81,NULL,NULL,1,'2023-03-17 12:32:28','2023-03-17 12:32:28',NULL),(2671,7749,40720,1535,3,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',9156.11,NULL,NULL,1,'2023-03-17 12:32:29','2023-03-17 12:32:29',NULL),(2672,7749,40720,1535,3,2449,'App\\Models\\Receipt',2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',16075.50,NULL,NULL,1,'2023-03-17 12:32:29','2023-03-17 12:32:29',NULL),(2673,7749,40720,1535,3,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',216851.83,NULL,NULL,1,'2023-03-17 12:32:29','2023-04-17 11:20:54','2023-04-17 11:20:54'),(2674,7749,40720,1535,3,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',10939.39,NULL,NULL,1,'2023-03-17 12:32:29','2023-03-17 12:32:29',NULL),(2675,7749,40720,1535,3,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',75000.00,NULL,NULL,1,'2023-03-17 12:32:29','2023-03-17 12:32:29',NULL),(2676,7749,40720,1535,3,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',76400.00,NULL,NULL,1,'2023-03-17 12:32:29','2023-03-17 12:32:29',NULL),(2677,7749,40720,1535,3,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',362550.27,NULL,NULL,1,'2023-03-17 12:32:29','2023-04-17 11:27:30','2023-04-17 11:27:30'),(2678,7749,40720,1535,3,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',286.84,NULL,NULL,1,'2023-03-17 12:32:29','2023-03-17 12:32:29',NULL),(2679,7749,40720,1535,3,2456,'App\\Models\\Receipt',2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',206626.80,NULL,NULL,1,'2023-03-17 12:32:29','2023-03-17 12:32:29',NULL),(2680,7749,40720,1535,3,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4953.10,NULL,NULL,1,'2023-03-17 12:32:29','2023-04-18 11:41:11','2023-04-18 11:41:11'),(2681,7749,40720,1535,3,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',7298.90,NULL,NULL,1,'2023-03-17 12:32:29','2023-04-18 11:41:24','2023-04-18 11:41:24'),(2682,7749,40720,1535,3,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',3949.44,NULL,NULL,1,'2023-03-17 12:32:29','2023-04-18 11:41:51','2023-04-18 11:41:51'),(2683,7749,40720,1535,3,2460,'App\\Models\\Receipt',2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',17931.96,NULL,NULL,1,'2023-03-17 12:32:29','2023-04-18 11:41:40','2023-04-18 11:41:40'),(2684,7749,40720,1535,3,2461,'App\\Models\\Receipt',2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',7852.55,NULL,NULL,1,'2023-03-17 12:32:29','2023-03-17 12:32:29',NULL),(2685,7749,40720,1535,3,2462,'App\\Models\\Receipt',2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',237505.46,NULL,NULL,1,'2023-03-17 12:32:29','2023-03-17 12:32:29',NULL),(2686,7749,40720,1535,3,2463,'App\\Models\\Receipt',2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',162004.70,NULL,NULL,1,'2023-03-17 12:32:29','2023-03-17 12:32:29',NULL),(2687,7749,40720,1535,3,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',53588.79,NULL,NULL,1,'2023-03-17 12:32:29','2023-04-17 11:50:57','2023-04-17 11:50:57'),(2688,7749,40720,1535,3,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',15301.52,NULL,NULL,1,'2023-03-17 12:32:29','2023-03-17 12:32:29',NULL);
INSERT INTO `balance_libro` VALUES (2689,7749,40720,1535,3,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',15673.10,NULL,NULL,1,'2023-03-17 12:32:30','2023-04-18 11:44:10','2023-04-18 11:44:10'),(2690,7749,40720,1535,3,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',22772.98,NULL,NULL,1,'2023-03-17 12:32:30','2023-03-17 12:32:30',NULL),(2691,7749,40720,1535,2,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',6900.00,NULL,NULL,1,'2023-03-17 12:33:36','2023-03-17 12:36:26','2023-03-17 12:36:26'),(2692,7749,40720,1535,2,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',320.02,NULL,NULL,1,'2023-03-17 12:33:36','2023-03-17 12:33:36',NULL),(2693,7749,40720,1535,2,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',13080.04,NULL,NULL,1,'2023-03-17 12:33:36','2023-03-17 12:38:10','2023-03-17 12:38:10'),(2694,7749,40720,1535,2,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',8529.98,NULL,NULL,1,'2023-03-17 12:33:36','2023-03-17 12:38:31','2023-03-17 12:38:31'),(2695,7749,40720,1535,2,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',6300.01,NULL,NULL,1,'2023-03-17 12:33:36','2023-03-17 12:38:45','2023-03-17 12:38:45'),(2696,7749,40720,1535,2,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',10899.97,NULL,NULL,1,'2023-03-17 12:33:36','2023-03-17 12:39:49','2023-03-17 12:39:49'),(2697,7749,40720,1535,2,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',1800.02,NULL,NULL,1,'2023-03-17 12:33:56','2023-03-17 12:33:56',NULL),(2698,7749,40720,1535,2,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',5099.98,NULL,NULL,1,'2023-03-17 12:33:56','2023-03-17 12:33:56',NULL),(2699,7749,40720,1535,2,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3149.98,NULL,NULL,1,'2023-03-17 12:33:56','2023-03-17 12:33:56',NULL),(2700,7749,40720,1535,2,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2200.01,NULL,NULL,1,'2023-03-17 12:33:56','2023-03-17 12:33:56',NULL),(2701,7749,40720,1535,2,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',1469.98,NULL,NULL,1,'2023-03-17 12:33:57','2023-03-17 12:33:57',NULL),(2702,7749,40720,1535,2,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2250.02,NULL,NULL,1,'2023-03-17 12:33:57','2023-03-17 12:33:57',NULL),(2703,7749,40720,1535,2,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',999.98,NULL,NULL,1,'2023-03-17 12:33:57','2023-03-17 12:33:57',NULL),(2704,7749,40720,1535,2,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',280.03,NULL,NULL,1,'2023-03-17 12:33:57','2023-03-17 12:33:57',NULL),(2705,7749,40720,1535,2,2482,'App\\Models\\Receipt',2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1400.03,NULL,NULL,1,'2023-03-17 12:33:57','2023-03-17 12:33:57',NULL),(2706,7749,40720,1535,2,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',10400.01,NULL,NULL,1,'2023-03-17 12:33:57','2023-03-17 12:33:57',NULL),(2707,7749,40720,1535,2,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1480.00,NULL,NULL,1,'2023-03-17 12:33:57','2023-03-17 12:33:57',NULL),(2708,7749,40720,1535,2,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',5299.97,NULL,NULL,1,'2023-03-17 12:33:57','2023-03-17 12:33:57',NULL);
INSERT INTO `balance_libro` VALUES (2709,7749,40720,1535,2,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1750.01,NULL,NULL,1,'2023-03-17 12:33:57','2023-03-17 12:33:57',NULL),(2710,7749,40720,1535,2,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',6300.01,NULL,NULL,1,'2023-03-17 12:33:57','2023-03-17 12:33:57',NULL),(2711,7749,40720,1535,2,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',4400.02,NULL,NULL,1,'2023-03-17 12:33:57','2023-03-17 12:33:57',NULL),(2712,7749,40720,1535,2,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',3999.97,NULL,NULL,1,'2023-03-17 12:33:57','2023-03-17 12:33:57',NULL),(2713,7749,40720,1535,2,2490,'App\\Models\\Receipt',2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',2499.98,NULL,NULL,1,'2023-03-17 12:33:58','2023-03-17 12:33:58',NULL),(2714,7749,40720,1535,2,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',272510.00,NULL,NULL,1,'2023-03-17 12:36:26','2023-03-17 12:36:26',NULL),(2715,7749,40720,1535,2,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',70430.00,NULL,NULL,1,'2023-03-17 12:37:45','2023-03-17 12:37:45',NULL),(2716,7749,40720,1535,2,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',78430.00,NULL,NULL,1,'2023-03-17 12:38:10','2023-03-17 12:38:10',NULL),(2717,7749,40720,1535,2,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',163290.00,NULL,NULL,1,'2023-03-17 12:38:31','2023-03-17 12:38:31',NULL),(2718,7749,40720,1535,2,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',99420.00,NULL,NULL,1,'2023-03-17 12:38:45','2023-03-17 12:38:45',NULL),(2719,7749,40720,1535,2,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',178550.02,NULL,NULL,1,'2023-03-17 12:39:49','2023-03-17 12:39:49',NULL),(2720,7749,40720,1535,2,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',4820.01,NULL,NULL,1,'2023-03-20 12:22:27','2023-03-20 12:29:03','2023-03-20 12:29:03'),(2721,7749,40720,1535,2,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3300.02,NULL,NULL,1,'2023-03-20 12:22:27','2023-03-20 12:29:26','2023-03-20 12:29:26'),(2722,7749,40720,1535,2,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',8349.98,NULL,NULL,1,'2023-03-20 12:22:27','2023-03-20 12:29:47','2023-03-20 12:29:47'),(2723,7749,40720,1535,2,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',16359.95,NULL,NULL,1,'2023-03-20 12:22:27','2023-03-20 12:30:08','2023-03-20 12:30:08'),(2724,7749,40720,1535,2,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',25700.00,NULL,NULL,1,'2023-03-20 12:22:27','2023-03-20 12:31:12','2023-03-20 12:31:12'),(2725,7749,40720,1535,2,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4750.00,NULL,NULL,1,'2023-03-20 12:22:27','2023-03-20 12:31:30','2023-03-20 12:31:30'),(2726,7749,40720,1535,2,2498,'App\\Models\\Receipt',2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',3820.03,NULL,NULL,1,'2023-03-20 12:22:44','2023-03-20 12:22:44',NULL),(2727,7749,40720,1535,2,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',999.98,NULL,NULL,1,'2023-03-20 12:22:44','2023-03-20 12:22:44',NULL),(2728,7749,40720,1535,2,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3300.02,NULL,NULL,1,'2023-03-20 12:22:44','2023-03-20 12:22:44',NULL);
INSERT INTO `balance_libro` VALUES (2729,7749,40720,1535,2,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',7150.01,NULL,NULL,1,'2023-03-20 12:22:44','2023-03-20 12:22:44',NULL),(2730,7749,40720,1535,2,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1199.97,NULL,NULL,1,'2023-03-20 12:22:44','2023-03-20 12:22:44',NULL),(2731,7749,40720,1535,2,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',8459.97,NULL,NULL,1,'2023-03-20 12:22:44','2023-03-20 12:22:44',NULL),(2732,7749,40720,1535,2,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',7899.97,NULL,NULL,1,'2023-03-20 12:22:44','2023-03-20 12:22:44',NULL),(2733,7749,40720,1535,2,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',2999.99,NULL,NULL,1,'2023-03-20 12:22:44','2023-03-20 12:22:44',NULL),(2734,7749,40720,1535,2,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',7000.02,NULL,NULL,1,'2023-03-20 12:22:44','2023-03-20 12:22:44',NULL),(2735,7749,40720,1535,2,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',4299.99,NULL,NULL,1,'2023-03-20 12:22:44','2023-03-20 12:22:44',NULL),(2736,7749,40720,1535,2,2508,'App\\Models\\Receipt',2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',11399.99,NULL,NULL,1,'2023-03-20 12:22:44','2023-03-20 12:22:44',NULL),(2737,7749,40720,1535,2,2509,'App\\Models\\Receipt',2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',2999.99,NULL,NULL,1,'2023-03-20 12:22:44','2023-03-20 12:22:44',NULL),(2738,7749,40720,1535,2,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1750.01,NULL,NULL,1,'2023-03-20 12:22:44','2023-03-20 12:22:44',NULL),(2739,7749,40720,1535,2,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',65200.00,NULL,NULL,1,'2023-03-20 12:23:44','2023-03-20 12:23:44',NULL),(2740,7749,40720,1535,2,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',44199.99,NULL,NULL,1,'2023-03-20 12:23:45','2023-03-20 12:23:45',NULL),(2741,7749,40720,1535,2,2513,'App\\Models\\Receipt',2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',78239.97,NULL,NULL,1,'2023-03-20 12:23:45','2023-03-20 12:23:45',NULL),(2742,7749,40720,1535,2,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',58750.00,NULL,NULL,1,'2023-03-20 12:23:45','2023-03-20 12:23:45',NULL),(2743,7749,40720,1535,2,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',11000.11,NULL,NULL,1,'2023-03-20 12:23:45','2023-03-20 12:23:45',NULL),(2744,7749,40720,1535,2,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',8228.00,NULL,NULL,1,'2023-03-20 12:23:45','2023-03-20 12:23:45',NULL),(2745,7749,40720,1535,2,2517,'App\\Models\\Receipt',2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',8228.00,NULL,NULL,1,'2023-03-20 12:23:45','2023-03-20 12:23:45',NULL),(2746,7749,40720,1535,2,2518,'App\\Models\\Receipt',2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',96239.26,NULL,NULL,1,'2023-03-20 12:23:45','2023-03-20 12:23:45',NULL),(2747,7749,40720,1535,2,2519,'App\\Models\\Receipt',2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',46399.99,NULL,NULL,1,'2023-03-20 12:23:45','2023-03-20 12:23:45',NULL),(2748,7749,40720,1535,2,2520,'App\\Models\\Receipt',2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',15000.00,NULL,NULL,1,'2023-03-20 12:23:45','2023-03-20 12:23:45',NULL),(2749,7749,40720,1535,2,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',3000.00,NULL,NULL,1,'2023-03-20 12:23:45','2023-03-20 12:23:45',NULL);
INSERT INTO `balance_libro` VALUES (2750,7749,40720,1535,2,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',3000.00,NULL,NULL,1,'2023-03-20 12:23:46','2023-03-20 12:23:46',NULL),(2751,7749,40720,1535,2,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',2530.00,NULL,NULL,1,'2023-03-20 12:23:46','2023-03-20 12:23:46',NULL),(2752,7749,40720,1535,2,2524,'App\\Models\\Receipt',2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',8228.00,NULL,NULL,1,'2023-03-20 12:23:46','2023-03-20 12:23:46',NULL),(2753,7749,40720,1535,2,2525,'App\\Models\\Receipt',2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',3000.00,NULL,NULL,1,'2023-03-20 12:23:46','2023-03-20 12:23:46',NULL),(2754,7749,40720,1535,2,2526,'App\\Models\\Receipt',2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',10799.98,NULL,NULL,1,'2023-03-20 12:23:46','2023-03-20 12:23:46',NULL),(2755,7749,40720,1535,2,2527,'App\\Models\\Receipt',2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',17000.02,NULL,NULL,1,'2023-03-20 12:23:46','2023-03-20 12:23:46',NULL),(2756,7749,40720,1535,2,2528,'App\\Models\\Receipt',2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',80000.00,NULL,NULL,1,'2023-03-20 12:23:46','2023-03-20 12:23:46',NULL),(2757,7749,40720,1535,2,2529,'App\\Models\\Receipt',2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',4800.02,NULL,NULL,1,'2023-03-20 12:23:46','2023-03-20 12:23:46',NULL),(2758,7749,40720,1535,2,2530,'App\\Models\\Receipt',2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',2750.00,NULL,NULL,1,'2023-03-20 12:23:46','2023-03-20 12:23:46',NULL),(2759,7749,40720,1535,2,2531,'App\\Models\\Receipt',2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',10400.00,NULL,NULL,1,'2023-03-20 12:23:46','2023-03-20 12:23:46',NULL),(2760,7749,40720,1535,2,2532,'App\\Models\\Receipt',2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',7249.72,NULL,NULL,1,'2023-03-20 12:23:47','2023-03-20 12:23:47',NULL),(2761,7749,40720,1535,2,2533,'App\\Models\\Receipt',2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',24000.00,NULL,NULL,1,'2023-03-20 12:23:47','2023-03-20 12:23:47',NULL),(2762,7749,40720,1535,3,2534,'App\\Models\\Receipt',2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',91321.10,NULL,NULL,1,'2023-03-20 12:23:59','2023-03-20 12:23:59',NULL),(2763,7749,40720,1535,3,2535,'App\\Models\\Receipt',2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',40690.59,NULL,NULL,1,'2023-03-20 12:23:59','2023-03-20 12:23:59',NULL),(2764,7749,40720,1535,3,2536,'App\\Models\\Receipt',2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',13939.49,NULL,NULL,1,'2023-03-20 12:23:59','2023-04-18 11:47:50','2023-04-18 11:47:50'),(2765,7749,40720,1535,3,2537,'App\\Models\\Receipt',2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',26958.61,NULL,NULL,1,'2023-03-20 12:23:59','2023-03-20 12:23:59',NULL),(2766,7749,40720,1535,3,2538,'App\\Models\\Receipt',2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',285500.74,NULL,NULL,1,'2023-03-20 12:23:59','2023-04-17 11:53:22','2023-04-17 11:53:22'),(2767,7749,40720,1535,3,2539,'App\\Models\\Receipt',2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',4280.38,NULL,NULL,1,'2023-03-20 12:23:59','2023-03-20 12:23:59',NULL),(2768,7749,40720,1535,2,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',80100.00,NULL,NULL,1,'2023-03-20 12:29:03','2023-03-20 12:29:03',NULL),(2769,7749,40720,1535,2,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',141530.00,NULL,NULL,1,'2023-03-20 12:29:26','2023-03-20 12:29:26',NULL);
INSERT INTO `balance_libro` VALUES (2770,7749,40720,1535,2,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',105640.01,NULL,NULL,1,'2023-03-20 12:29:47','2023-03-20 12:29:47',NULL),(2771,7749,40720,1535,2,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',100890.01,NULL,NULL,1,'2023-03-20 12:30:08','2023-03-20 12:30:08',NULL),(2772,7749,40720,1535,2,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',125550.00,NULL,NULL,1,'2023-03-20 12:31:12','2023-03-20 12:31:12',NULL),(2773,7749,40720,1535,2,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',121710.00,NULL,NULL,1,'2023-03-20 12:31:30','2023-03-20 12:31:30',NULL),(2774,7749,40720,1535,2,2540,'App\\Models\\Receipt',2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',25749.99,NULL,NULL,1,'2023-03-22 10:15:24','2023-03-22 10:15:24',NULL),(2775,7749,40720,1535,2,2541,'App\\Models\\Receipt',2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',20000.00,NULL,NULL,1,'2023-03-22 10:15:24','2023-03-22 10:15:24',NULL),(2776,7749,40720,1535,2,2542,'App\\Models\\Receipt',2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',58600.00,NULL,NULL,1,'2023-03-22 10:15:24','2023-03-22 10:15:24',NULL),(2777,7749,40720,1535,2,2543,'App\\Models\\Receipt',2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',21300.00,NULL,NULL,1,'2023-03-22 10:15:24','2023-03-22 10:15:24',NULL),(2778,7749,40720,1535,2,2544,'App\\Models\\Receipt',2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',75000.01,NULL,NULL,1,'2023-03-22 10:24:12','2023-03-22 10:27:32','2023-03-22 10:27:32'),(2779,7749,40720,1535,2,2545,'App\\Models\\Receipt',2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',4220.02,NULL,NULL,1,'2023-03-22 10:24:12','2023-03-22 10:27:51','2023-03-22 10:27:51'),(2780,7749,40720,1535,2,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',24299.97,NULL,NULL,1,'2023-03-22 10:24:12','2023-03-22 10:28:11','2023-03-22 10:28:11'),(2781,7749,40720,1535,2,2547,'App\\Models\\Receipt',2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',7729.94,NULL,NULL,1,'2023-03-22 10:24:12','2023-03-22 10:28:28','2023-03-22 10:28:28'),(2782,7749,40720,1535,2,2548,'App\\Models\\Receipt',2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',55339.98,NULL,NULL,1,'2023-03-22 10:24:12','2023-03-22 10:28:46','2023-03-22 10:28:46'),(2783,7749,40720,1535,2,2549,'App\\Models\\Receipt',2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',76519.94,NULL,NULL,1,'2023-03-22 10:24:12','2023-03-22 10:24:12',NULL),(2784,7749,40720,1535,2,2550,'App\\Models\\Receipt',2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',3900.00,NULL,NULL,1,'2023-03-22 10:24:30','2023-03-22 10:24:30',NULL),(2785,7749,40720,1535,2,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',1800.02,NULL,NULL,1,'2023-03-22 10:24:30','2023-03-22 10:24:30',NULL),(2786,7749,40720,1535,2,2552,'App\\Models\\Receipt',2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',16999.98,NULL,NULL,1,'2023-03-22 10:24:30','2023-03-22 10:24:30',NULL),(2787,7749,40720,1535,2,2553,'App\\Models\\Receipt',2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',6300.01,NULL,NULL,1,'2023-03-22 10:24:30','2023-03-22 10:24:30',NULL),(2788,7749,40720,1535,2,2554,'App\\Models\\Receipt',2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',45999.99,NULL,NULL,1,'2023-03-22 10:24:30','2023-03-22 10:24:30',NULL),(2789,7749,40720,1535,2,2555,'App\\Models\\Receipt',2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',2349.99,NULL,NULL,1,'2023-03-22 10:24:30','2023-03-22 10:24:30',NULL);
INSERT INTO `balance_libro` VALUES (2790,7749,40720,1535,2,2556,'App\\Models\\Receipt',2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',320.02,NULL,NULL,1,'2023-03-22 10:24:30','2023-03-22 10:24:30',NULL),(2791,7749,40720,1535,2,2557,'App\\Models\\Receipt',2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1550.01,NULL,NULL,1,'2023-03-22 10:24:30','2023-03-22 10:24:30',NULL),(2792,7749,40720,1535,2,2558,'App\\Models\\Receipt',2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',17579.97,NULL,NULL,1,'2023-03-22 10:24:30','2023-03-22 10:24:30',NULL),(2793,7749,40720,1535,2,2559,'App\\Models\\Receipt',2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',720.01,NULL,NULL,1,'2023-03-22 10:24:31','2023-03-22 10:24:31',NULL),(2794,7749,40720,1535,2,2560,'App\\Models\\Receipt',2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',5999.99,NULL,NULL,1,'2023-03-22 10:24:31','2023-03-22 10:24:31',NULL),(2795,7749,40720,1535,2,2561,'App\\Models\\Receipt',2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',2999.99,NULL,NULL,1,'2023-03-22 10:24:31','2023-03-22 10:24:31',NULL),(2796,7749,40720,1535,2,2562,'App\\Models\\Receipt',2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1199.97,NULL,NULL,1,'2023-03-22 10:24:31','2023-03-22 10:24:31',NULL),(2797,7749,40720,1535,2,2563,'App\\Models\\Receipt',2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1939.98,NULL,NULL,1,'2023-03-22 10:24:31','2023-03-22 10:24:31',NULL),(2798,7749,40720,1535,2,2564,'App\\Models\\Receipt',2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1590.00,NULL,NULL,1,'2023-03-22 10:24:31','2023-03-22 10:24:31',NULL),(2799,7749,40720,1535,2,2565,'App\\Models\\Receipt',2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',13999.99,NULL,NULL,1,'2023-03-22 10:24:31','2023-03-22 10:24:31',NULL),(2800,7749,40720,1535,2,2566,'App\\Models\\Receipt',2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',7200.02,NULL,NULL,1,'2023-03-22 10:24:31','2023-03-22 10:24:31',NULL),(2801,7749,40720,1535,2,2567,'App\\Models\\Receipt',2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',5639.98,NULL,NULL,1,'2023-03-22 10:24:31','2023-03-22 10:24:31',NULL),(2802,7749,40720,1535,2,2568,'App\\Models\\Receipt',2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',18000.02,NULL,NULL,1,'2023-03-22 10:24:31','2023-03-22 10:24:31',NULL),(2803,7749,40720,1535,2,2569,'App\\Models\\Receipt',2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',10499.98,NULL,NULL,1,'2023-03-22 10:24:31','2023-03-22 10:24:31',NULL),(2804,7749,40720,1535,2,2544,'App\\Models\\Receipt',2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',74480.00,NULL,NULL,1,'2023-03-22 10:27:32','2023-03-22 10:27:32',NULL),(2805,7749,40720,1535,2,2545,'App\\Models\\Receipt',2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',103970.00,NULL,NULL,1,'2023-03-22 10:27:51','2023-03-22 10:27:51',NULL),(2806,7749,40720,1535,2,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',93108.00,NULL,NULL,1,'2023-03-22 10:28:11','2023-03-22 10:28:11',NULL),(2807,7749,40720,1535,2,2547,'App\\Models\\Receipt',2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',67769.99,NULL,NULL,1,'2023-03-22 10:28:28','2023-03-22 10:28:28',NULL),(2808,7749,40720,1535,2,2548,'App\\Models\\Receipt',2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',63780.00,NULL,NULL,1,'2023-03-22 10:28:46','2023-03-22 10:28:46',NULL),(2809,7749,40720,1535,3,2570,'App\\Models\\Receipt',2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',406063.15,NULL,NULL,1,'2023-03-22 10:30:48','2023-03-22 10:30:48',NULL),(2810,7749,40720,1535,3,2571,'App\\Models\\Receipt',2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',4500.00,NULL,NULL,1,'2023-03-22 10:30:49','2023-03-22 10:30:49',NULL);
INSERT INTO `balance_libro` VALUES (2811,7749,40720,1535,3,2572,'App\\Models\\Receipt',2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',66223.07,NULL,NULL,1,'2023-03-22 10:30:49','2023-03-22 10:30:49',NULL),(2812,7749,40720,1535,2,2573,'App\\Models\\Receipt',2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',992997.00,NULL,NULL,1,'2023-03-22 10:39:28','2023-03-22 10:39:28',NULL),(2813,7749,40720,1535,3,2574,'App\\Models\\Receipt',2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',24479.62,NULL,NULL,1,'2023-03-27 11:21:30','2023-03-27 11:21:30',NULL),(2814,7749,40720,1535,3,2575,'App\\Models\\Receipt',2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',9745.52,NULL,NULL,1,'2023-03-27 11:21:30','2023-03-27 11:21:30',NULL),(2815,7749,40720,1535,3,2576,'App\\Models\\Receipt',2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',6300.00,NULL,NULL,1,'2023-03-27 11:21:30','2023-03-27 11:21:30',NULL),(2816,7749,40720,1535,3,2577,'App\\Models\\Receipt',2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',164999.99,NULL,NULL,1,'2023-03-27 11:21:30','2023-03-27 11:21:30',NULL),(2817,7749,40720,1535,2,2578,'App\\Models\\Receipt',2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',89993.75,NULL,NULL,1,'2023-03-27 11:43:21','2023-03-27 11:43:21',NULL),(2818,7749,40720,1535,2,2579,'App\\Models\\Receipt',2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',28190.00,NULL,NULL,1,'2023-03-27 11:43:21','2023-03-27 11:43:21',NULL),(2819,7749,40720,1535,2,2580,'App\\Models\\Receipt',2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',1052150.66,NULL,NULL,1,'2023-03-27 11:43:21','2023-03-27 11:43:21',NULL),(2820,7749,40720,1535,2,2581,'App\\Models\\Receipt',2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',1104852.34,NULL,NULL,1,'2023-03-29 10:10:08','2023-03-29 10:10:08',NULL),(2821,7749,40720,1535,3,2582,'App\\Models\\Receipt',2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',8313.31,NULL,NULL,1,'2023-03-29 10:10:18','2023-04-17 11:55:49','2023-04-17 11:55:49'),(2822,7749,40720,1535,3,2583,'App\\Models\\Receipt',2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',3097.60,NULL,NULL,1,'2023-03-29 10:10:18','2023-03-29 10:10:18',NULL),(2823,7749,40720,1535,3,2584,'App\\Models\\Receipt',2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',22850.73,NULL,NULL,1,'2023-03-29 10:10:18','2023-03-29 10:10:18',NULL),(2824,7749,40720,1535,3,2585,'App\\Models\\Receipt',2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',18537.65,NULL,NULL,1,'2023-03-29 10:10:18','2023-03-29 10:10:18',NULL),(2825,7749,40720,1535,3,2586,'App\\Models\\Receipt',2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',81322.83,NULL,NULL,1,'2023-03-29 10:10:18','2023-03-29 10:10:18',NULL),(2826,7749,40720,1535,3,2587,'App\\Models\\Receipt',2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',21477.86,NULL,NULL,1,'2023-03-29 10:10:18','2023-03-29 10:10:18',NULL),(2827,7749,40720,1535,3,2588,'App\\Models\\Receipt',2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',67799.46,NULL,NULL,1,'2023-03-29 10:10:18','2023-03-29 10:10:18',NULL),(2828,7749,40720,1535,3,2589,'App\\Models\\Receipt',2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',67799.46,NULL,NULL,1,'2023-03-29 10:10:18','2023-03-29 10:10:18',NULL),(2829,7749,40720,1535,3,2590,'App\\Models\\Receipt',2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',35082.79,NULL,NULL,1,'2023-03-29 10:10:18','2023-03-29 10:10:18',NULL),(2830,7749,40720,1535,3,2591,'App\\Models\\Receipt',2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',10790.31,NULL,NULL,1,'2023-03-29 10:10:18','2023-03-29 10:10:18',NULL),(2831,7749,40720,1535,3,2592,'App\\Models\\Receipt',2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',45216.74,NULL,NULL,1,'2023-03-29 10:10:18','2023-03-29 10:10:18',NULL);
INSERT INTO `balance_libro` VALUES (2832,7749,40720,1535,3,2593,'App\\Models\\Receipt',2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',35082.79,NULL,NULL,1,'2023-03-29 10:10:18','2023-03-29 10:10:18',NULL),(2833,7749,40720,1535,3,2594,'App\\Models\\Receipt',2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',140000.00,NULL,NULL,1,'2023-03-29 10:10:19','2023-03-29 10:10:19',NULL),(2834,7749,40720,1535,3,2595,'App\\Models\\Receipt',2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',272944.42,NULL,NULL,1,'2023-04-04 09:49:08','2023-04-17 12:05:34','2023-04-17 12:05:34'),(2835,7749,40720,1535,3,2596,'App\\Models\\Receipt',2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',108700.82,NULL,NULL,1,'2023-04-04 09:49:08','2023-04-04 09:49:08',NULL),(2836,7749,40720,1535,3,2597,'App\\Models\\Receipt',2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',30533.82,NULL,NULL,1,'2023-04-04 09:49:08','2023-04-04 09:49:08',NULL),(2837,7749,40720,1535,3,2598,'App\\Models\\Receipt',2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',53928.99,NULL,NULL,1,'2023-04-04 09:49:08','2023-04-04 09:49:08',NULL),(2838,7749,40720,1535,3,2599,'App\\Models\\Receipt',2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',19258.05,NULL,NULL,1,'2023-04-04 09:49:08','2023-04-18 11:54:26','2023-04-18 11:54:26'),(2839,7749,40720,1535,3,2600,'App\\Models\\Receipt',2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',140079.93,NULL,NULL,1,'2023-04-04 09:49:08','2023-04-04 09:49:08',NULL),(2840,7749,40720,1535,3,2601,'App\\Models\\Receipt',2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',0.00,NULL,NULL,1,'2023-04-04 09:49:08','2023-04-04 09:49:08',NULL),(2841,7749,40720,1535,3,2602,'App\\Models\\Receipt',2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',38701.85,NULL,NULL,1,'2023-04-04 09:49:08','2023-04-04 09:49:08',NULL),(2842,7749,40720,1535,3,2603,'App\\Models\\Receipt',2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',45677.50,NULL,NULL,1,'2023-04-04 09:49:08','2023-04-04 09:49:08',NULL),(2843,7749,40720,1535,2,2604,'App\\Models\\Receipt',2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',38790.00,NULL,NULL,1,'2023-04-04 09:49:21','2023-04-04 09:49:21',NULL),(2844,7749,40720,1535,2,2605,'App\\Models\\Receipt',2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',90665.00,NULL,NULL,1,'2023-04-04 10:02:58','2023-04-04 10:02:58',NULL),(2845,7749,40720,1535,2,2606,'App\\Models\\Receipt',2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',76154.00,NULL,NULL,1,'2023-04-04 10:03:36','2023-04-04 10:03:36',NULL),(2846,7749,40720,1535,2,2607,'App\\Models\\Receipt',2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',77980.00,NULL,NULL,1,'2023-04-04 10:03:54','2023-04-04 10:03:54',NULL),(2847,7749,40720,1535,2,2608,'App\\Models\\Receipt',2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',123140.06,NULL,NULL,1,'2023-04-04 10:08:39','2023-04-04 10:08:39',NULL),(2848,7749,40720,1535,2,2609,'App\\Models\\Receipt',2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',92664.99,NULL,NULL,1,'2023-04-04 10:09:35','2023-04-04 10:09:35',NULL),(2849,7749,40720,1535,2,2610,'App\\Models\\Receipt',2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',64730.00,NULL,NULL,1,'2023-04-04 10:10:59','2023-04-04 10:10:59',NULL),(2850,7749,40720,1535,2,2611,'App\\Models\\Receipt',2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',99290.00,NULL,NULL,1,'2023-04-04 10:11:31','2023-04-04 10:11:31',NULL),(2851,7749,40720,1535,2,2612,'App\\Models\\Receipt',2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',117700.00,NULL,NULL,1,'2023-04-04 10:11:54','2023-04-04 10:11:54',NULL);
INSERT INTO `balance_libro` VALUES (2852,7749,40720,1535,2,2613,'App\\Models\\Receipt',2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',136620.00,NULL,NULL,1,'2023-04-04 10:12:19','2023-04-04 10:12:19',NULL),(2853,7749,40720,1535,2,2614,'App\\Models\\Receipt',2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',2730.00,NULL,NULL,1,'2023-04-04 10:16:44','2023-04-04 10:16:44',NULL),(2854,7749,40720,1535,2,2615,'App\\Models\\Receipt',2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',2699.99,NULL,NULL,1,'2023-04-04 10:18:34','2023-04-04 10:18:34',NULL),(2855,7749,40720,1535,2,2616,'App\\Models\\Receipt',2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',2000.00,NULL,NULL,1,'2023-04-04 10:18:57','2023-04-04 10:18:57',NULL),(2856,7749,40720,1535,2,2617,'App\\Models\\Receipt',2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',2519.99,NULL,NULL,1,'2023-04-04 10:19:44','2023-04-04 10:19:44',NULL),(2857,7749,40720,1535,2,2618,'App\\Models\\Receipt',2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',4600.00,NULL,NULL,1,'2023-04-04 10:20:07','2023-04-04 10:20:07',NULL),(2858,7749,40720,1535,2,2619,'App\\Models\\Receipt',2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',2800.00,NULL,NULL,1,'2023-04-04 10:21:56','2023-04-04 10:21:56',NULL),(2859,7749,40720,1535,2,2620,'App\\Models\\Receipt',2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',1600.00,NULL,NULL,1,'2023-04-04 10:22:21','2023-04-04 10:22:21',NULL),(2860,7749,40720,1535,2,2621,'App\\Models\\Receipt',2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',445700.00,NULL,NULL,1,'2023-04-04 10:22:59','2023-04-04 10:22:59',NULL),(2861,7749,40720,1535,2,2622,'App\\Models\\Receipt',2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',5150.00,NULL,NULL,1,'2023-04-04 10:24:43','2023-04-04 10:24:43',NULL),(2862,7749,40720,1535,2,2623,'App\\Models\\Receipt',2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',7800.00,NULL,NULL,1,'2023-04-04 10:25:27','2023-04-04 10:25:27',NULL),(2863,7749,40720,1535,2,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',10000.00,NULL,NULL,1,'2023-04-04 10:25:47','2023-04-04 10:25:47',NULL),(2864,7749,40720,1535,2,2625,'App\\Models\\Receipt',2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',2000.00,NULL,NULL,1,'2023-04-04 10:26:11','2023-04-04 10:26:11',NULL),(2865,7749,40720,1535,2,2626,'App\\Models\\Receipt',2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',9300.00,NULL,NULL,1,'2023-04-04 10:26:53','2023-04-04 10:26:53',NULL),(2866,7749,40720,1535,2,2627,'App\\Models\\Receipt',2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',3800.00,NULL,NULL,1,'2023-04-04 10:27:17','2023-04-04 10:27:17',NULL),(2867,7749,40720,1535,2,2628,'App\\Models\\Receipt',2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',8000.00,NULL,NULL,1,'2023-04-04 10:27:45','2023-04-04 10:27:45',NULL),(2868,7749,40720,1535,2,2629,'App\\Models\\Receipt',2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',10320.01,NULL,NULL,1,'2023-04-04 10:28:05','2023-04-04 10:28:05',NULL),(2869,7749,40720,1535,2,2630,'App\\Models\\Receipt',2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',9720.00,NULL,NULL,1,'2023-04-04 10:29:24','2023-04-04 10:29:24',NULL),(2870,7749,40720,1535,2,2631,'App\\Models\\Receipt',2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',900.00,NULL,NULL,1,'2023-04-04 10:29:42','2023-04-04 10:29:42',NULL),(2871,7749,40720,1535,2,2632,'App\\Models\\Receipt',2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',2000.00,NULL,NULL,1,'2023-04-04 10:31:44','2023-04-04 10:31:44',NULL),(2872,7749,40720,1535,2,2633,'App\\Models\\Receipt',2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',2500.01,NULL,NULL,1,'2023-04-04 10:32:09','2023-04-04 10:32:09',NULL);
INSERT INTO `balance_libro` VALUES (2873,7749,40720,1535,2,2634,'App\\Models\\Receipt',2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',25660.00,NULL,NULL,1,'2023-04-04 10:32:33','2023-04-04 10:32:33',NULL),(2874,7749,40720,1535,2,2635,'App\\Models\\Receipt',2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',7500.00,NULL,NULL,1,'2023-04-04 10:34:02','2023-04-04 10:34:02',NULL),(2875,7749,40720,1535,2,2636,'App\\Models\\Receipt',2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',3900.00,NULL,NULL,1,'2023-04-04 10:34:26','2023-04-04 10:34:26',NULL),(2876,7749,40720,1535,2,2637,'App\\Models\\Receipt',2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',6560.00,NULL,NULL,1,'2023-04-04 10:34:50','2023-04-04 10:34:50',NULL),(2877,7749,40720,1535,2,2638,'App\\Models\\Receipt',2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',7980.00,NULL,NULL,1,'2023-04-04 10:35:45','2023-04-04 10:35:45',NULL),(2878,7749,40720,1535,2,2639,'App\\Models\\Receipt',2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',3040.00,NULL,NULL,1,'2023-04-04 10:36:48','2023-04-04 10:36:48',NULL),(2879,7749,40720,1535,2,2640,'App\\Models\\Receipt',2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',3650.00,NULL,NULL,1,'2023-04-04 10:37:17','2023-04-04 10:37:17',NULL),(2880,7749,40720,1535,2,2641,'App\\Models\\Receipt',2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1399.99,NULL,NULL,1,'2023-04-04 10:37:49','2023-04-04 10:37:49',NULL),(2881,7749,40720,1535,2,2642,'App\\Models\\Receipt',2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',4000.01,NULL,NULL,1,'2023-04-04 10:40:58','2023-04-04 10:40:58',NULL),(2882,7749,40720,1535,2,2643,'App\\Models\\Receipt',2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',445700.00,NULL,NULL,1,'2023-04-04 10:42:57','2023-04-04 10:42:57',NULL),(2883,7749,40720,1536,2,2644,'App\\Models\\Receipt',2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',3450.00,NULL,NULL,1,'2023-04-13 10:04:52','2023-04-13 11:57:45','2023-04-13 11:57:45'),(2884,7749,40720,1536,2,2645,'App\\Models\\Receipt',2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',4220.02,NULL,NULL,1,'2023-04-13 10:04:52','2023-04-13 11:58:05','2023-04-13 11:58:05'),(2885,7749,40720,1536,2,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',12449.98,NULL,NULL,1,'2023-04-13 10:04:52','2023-04-13 11:59:02','2023-04-13 11:59:02'),(2886,7749,40720,1536,2,2647,'App\\Models\\Receipt',2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',19750.02,NULL,NULL,1,'2023-04-13 10:04:52','2023-04-13 11:59:28','2023-04-13 11:59:28'),(2887,7749,40720,1536,2,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',12600.02,NULL,NULL,1,'2023-04-13 10:04:52','2023-04-13 11:59:50','2023-04-13 11:59:50'),(2888,7749,40720,1536,2,2649,'App\\Models\\Receipt',2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',1900.05,NULL,NULL,1,'2023-04-13 10:04:52','2023-04-13 12:00:10','2023-04-13 12:00:10'),(2889,7749,40720,1536,2,2650,'App\\Models\\Receipt',2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',3450.00,NULL,NULL,1,'2023-04-13 10:05:10','2023-04-13 10:05:10',NULL),(2890,7749,40720,1536,2,2651,'App\\Models\\Receipt',2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',4220.02,NULL,NULL,1,'2023-04-13 10:05:10','2023-04-13 10:05:10',NULL),(2891,7749,40720,1536,2,2652,'App\\Models\\Receipt',2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',599.99,NULL,NULL,1,'2023-04-13 10:05:10','2023-04-13 10:05:10',NULL),(2892,7749,40720,1536,2,2653,'App\\Models\\Receipt',2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',4200.03,NULL,NULL,1,'2023-04-13 10:05:10','2023-04-13 10:05:10',NULL);
INSERT INTO `balance_libro` VALUES (2893,7749,40720,1536,2,2654,'App\\Models\\Receipt',2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',4899.98,NULL,NULL,1,'2023-04-13 10:05:10','2023-04-13 10:05:10',NULL),(2894,7749,40720,1536,2,2655,'App\\Models\\Receipt',2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',2749.98,NULL,NULL,1,'2023-04-13 10:05:10','2023-04-13 10:05:10',NULL),(2895,7749,40720,1536,2,2656,'App\\Models\\Receipt',2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',9150.02,NULL,NULL,1,'2023-04-13 10:05:10','2023-04-13 10:05:10',NULL),(2896,7749,40720,1536,2,2657,'App\\Models\\Receipt',2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',5000.01,NULL,NULL,1,'2023-04-13 10:05:10','2023-04-13 10:05:10',NULL),(2897,7749,40720,1536,2,2658,'App\\Models\\Receipt',2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',3999.97,NULL,NULL,1,'2023-04-13 10:05:10','2023-04-13 10:05:10',NULL),(2898,7749,40720,1536,2,2659,'App\\Models\\Receipt',2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1600.02,NULL,NULL,1,'2023-04-13 10:05:10','2023-04-13 10:05:10',NULL),(2899,7749,40720,1536,2,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',6500.00,NULL,NULL,1,'2023-04-13 10:05:10','2023-04-13 10:05:10',NULL),(2900,7749,40720,1536,2,2661,'App\\Models\\Receipt',2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',6100.01,NULL,NULL,1,'2023-04-13 10:05:10','2023-04-13 10:05:10',NULL),(2901,7749,40720,1536,2,2662,'App\\Models\\Receipt',2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',1400.03,NULL,NULL,1,'2023-04-13 10:05:10','2023-04-13 10:05:10',NULL),(2902,7749,40720,1536,2,2663,'App\\Models\\Receipt',2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',500.02,NULL,NULL,1,'2023-04-13 10:05:10','2023-04-13 10:05:10',NULL),(2903,7749,40720,1536,2,2664,'App\\Models\\Receipt',2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',26000.00,NULL,NULL,1,'2023-04-13 10:21:50','2023-04-13 10:21:50',NULL),(2904,7749,40720,1536,2,2665,'App\\Models\\Receipt',2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1630.00,NULL,NULL,1,'2023-04-13 10:21:50','2023-04-13 10:21:50',NULL),(2905,7749,40720,1536,2,2666,'App\\Models\\Receipt',2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',2800.04,NULL,NULL,1,'2023-04-13 10:21:50','2023-04-13 10:21:50',NULL),(2906,7749,40720,1536,2,2667,'App\\Models\\Receipt',2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1300.00,NULL,NULL,1,'2023-04-13 10:21:50','2023-04-13 10:21:50',NULL),(2907,7749,40720,1536,2,2668,'App\\Models\\Receipt',2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',4500.00,NULL,NULL,1,'2023-04-13 10:21:50','2023-04-13 10:21:50',NULL),(2908,7749,40720,1536,2,2669,'App\\Models\\Receipt',2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',43549.93,NULL,NULL,1,'2023-04-13 10:21:50','2023-04-13 10:21:50',NULL),(2909,7749,40720,1536,2,2670,'App\\Models\\Receipt',2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',4100.00,NULL,NULL,1,'2023-04-13 10:21:50','2023-04-13 10:21:50',NULL),(2910,7749,40720,1536,2,2671,'App\\Models\\Receipt',2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',6500.00,NULL,NULL,1,'2023-04-13 10:21:51','2023-04-13 10:21:51',NULL),(2911,7749,40720,1536,2,2672,'App\\Models\\Receipt',2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',352949.99,NULL,NULL,1,'2023-04-13 10:21:51','2023-04-13 10:21:51',NULL),(2912,7749,40720,1536,2,2673,'App\\Models\\Receipt',2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',21599.95,NULL,NULL,1,'2023-04-13 10:21:51','2023-04-13 10:21:51',NULL),(2913,7749,40720,1536,2,2674,'App\\Models\\Receipt',2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',20700.00,NULL,NULL,1,'2023-04-13 10:21:51','2023-04-13 10:21:51',NULL);
INSERT INTO `balance_libro` VALUES (2914,7749,40720,1536,2,2675,'App\\Models\\Receipt',2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1600.00,NULL,NULL,1,'2023-04-13 10:21:51','2023-04-13 10:21:51',NULL),(2915,7749,40720,1536,2,2676,'App\\Models\\Receipt',2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',15000.00,NULL,NULL,1,'2023-04-13 10:21:51','2023-04-13 10:21:51',NULL),(2916,7749,40720,1536,2,2677,'App\\Models\\Receipt',2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',25100.00,NULL,NULL,1,'2023-04-13 10:21:51','2023-04-13 10:21:51',NULL),(2917,7749,40720,1536,2,2678,'App\\Models\\Receipt',2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',3900.00,NULL,NULL,1,'2023-04-13 10:21:51','2023-04-13 10:21:51',NULL),(2918,7749,40720,1536,2,2679,'App\\Models\\Receipt',2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',2700.00,NULL,NULL,1,'2023-04-13 10:21:51','2023-04-13 10:21:51',NULL),(2919,7749,40720,1536,2,2680,'App\\Models\\Receipt',2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',10100.00,NULL,NULL,1,'2023-04-13 10:21:51','2023-04-13 10:21:51',NULL),(2920,7749,40720,1536,2,2681,'App\\Models\\Receipt',2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',2300.00,NULL,NULL,1,'2023-04-13 10:21:51','2023-04-13 10:21:51',NULL),(2921,7749,40720,1536,2,2682,'App\\Models\\Receipt',2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',4450.00,NULL,NULL,1,'2023-04-13 10:21:51','2023-04-13 10:21:51',NULL),(2922,7749,40720,1536,2,2683,'App\\Models\\Receipt',2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',10000.00,NULL,NULL,1,'2023-04-13 10:21:52','2023-04-13 10:21:52',NULL),(2923,7749,40720,1536,2,2684,'App\\Models\\Receipt',2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',5400.00,NULL,NULL,1,'2023-04-13 10:21:52','2023-04-13 10:21:52',NULL),(2924,7749,40720,1536,2,2685,'App\\Models\\Receipt',2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',11000.00,NULL,NULL,1,'2023-04-13 10:21:52','2023-04-13 10:21:52',NULL),(2925,7749,40720,1536,2,2686,'App\\Models\\Receipt',2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',2100.00,NULL,NULL,1,'2023-04-13 10:21:52','2023-04-13 10:21:52',NULL),(2926,7749,40720,1536,2,2687,'App\\Models\\Receipt',2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',11200.00,NULL,NULL,1,'2023-04-13 10:21:52','2023-04-13 10:21:52',NULL),(2927,7749,40720,1536,2,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1200.00,NULL,NULL,1,'2023-04-13 10:21:52','2023-04-13 10:21:52',NULL),(2928,7749,40720,1536,2,2689,'App\\Models\\Receipt',2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',3640.00,NULL,NULL,1,'2023-04-13 10:21:52','2023-04-13 10:21:52',NULL),(2929,7749,40720,1536,2,2690,'App\\Models\\Receipt',2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',8880.00,NULL,NULL,1,'2023-04-13 10:21:52','2023-04-13 10:21:52',NULL),(2930,7749,40720,1536,2,2691,'App\\Models\\Receipt',2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',650.00,NULL,NULL,1,'2023-04-13 10:21:52','2023-04-13 10:21:52',NULL),(2931,7749,40720,1536,2,2692,'App\\Models\\Receipt',2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',4350.00,NULL,NULL,1,'2023-04-13 10:21:52','2023-04-13 10:21:52',NULL),(2932,7749,40720,1536,2,2693,'App\\Models\\Receipt',2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',4700.00,NULL,NULL,1,'2023-04-13 10:21:52','2023-04-13 10:21:52',NULL),(2933,7749,40720,1536,2,2694,'App\\Models\\Receipt',2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',14430.00,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL),(2934,7749,40720,1536,2,2695,'App\\Models\\Receipt',2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',5150.00,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL);
INSERT INTO `balance_libro` VALUES (2935,7749,40720,1536,2,2696,'App\\Models\\Receipt',2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',7250.00,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL),(2936,7749,40720,1536,2,2697,'App\\Models\\Receipt',2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',900.00,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL),(2937,7749,40720,1536,2,2698,'App\\Models\\Receipt',2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',17000.00,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL),(2938,7749,40720,1536,2,2699,'App\\Models\\Receipt',2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',2320.00,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL),(2939,7749,40720,1536,2,2700,'App\\Models\\Receipt',2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',8800.00,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL),(2940,7749,40720,1536,2,2701,'App\\Models\\Receipt',2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',10000.00,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL),(2941,7749,40720,1536,2,2702,'App\\Models\\Receipt',2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',18000.00,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL),(2942,7749,40720,1536,2,2703,'App\\Models\\Receipt',2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',5500.00,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL),(2943,7749,40720,1536,2,2704,'App\\Models\\Receipt',2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',600.00,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL),(2944,7749,40720,1536,2,2705,'App\\Models\\Receipt',2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',10600.00,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL),(2945,7749,40720,1536,2,2706,'App\\Models\\Receipt',2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',4500.00,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL),(2946,7749,40720,1536,2,2707,'App\\Models\\Receipt',2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',750.00,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL),(2947,7749,40720,1536,2,2708,'App\\Models\\Receipt',2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1900.00,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL),(2948,7749,40720,1536,2,2709,'App\\Models\\Receipt',2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1600.00,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL),(2949,7749,40720,1536,2,2710,'App\\Models\\Receipt',2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',3200.00,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL),(2950,7749,40720,1536,2,2711,'App\\Models\\Receipt',2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',3910.00,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL),(2951,7749,40720,1536,2,2712,'App\\Models\\Receipt',2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',9259.99,NULL,NULL,1,'2023-04-13 10:21:53','2023-04-13 10:21:53',NULL),(2952,7749,40720,1536,2,2713,'App\\Models\\Receipt',2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',5600.00,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2953,7749,40720,1536,2,2714,'App\\Models\\Receipt',2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',7400.00,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2954,7749,40720,1536,2,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',5600.00,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2955,7749,40720,1536,2,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',10960.00,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL);
INSERT INTO `balance_libro` VALUES (2956,7749,40720,1536,2,2717,'App\\Models\\Receipt',2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',101249.99,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2957,7749,40720,1536,2,2718,'App\\Models\\Receipt',2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',147500.00,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2958,7749,40720,1536,2,2719,'App\\Models\\Receipt',2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',131849.99,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2959,7749,40720,1536,2,2720,'App\\Models\\Receipt',2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',148800.00,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2960,7749,40720,1536,2,2721,'App\\Models\\Receipt',2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',164200.01,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2961,7749,40720,1536,2,2722,'App\\Models\\Receipt',2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',178280.00,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2962,7749,40720,1536,2,2723,'App\\Models\\Receipt',2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',4200.00,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2963,7749,40720,1536,2,2724,'App\\Models\\Receipt',2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',237999.99,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2964,7749,40720,1536,2,2725,'App\\Models\\Receipt',2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',20400.00,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2965,7749,40720,1536,2,2726,'App\\Models\\Receipt',2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',139571.00,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2966,7749,40720,1536,2,2727,'App\\Models\\Receipt',2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',66800.00,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2967,7749,40720,1536,2,2728,'App\\Models\\Receipt',2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',129299.77,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2968,7749,40720,1536,2,2729,'App\\Models\\Receipt',2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',67250.00,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2969,7749,40720,1536,2,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',18750.00,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2970,7749,40720,1536,2,2731,'App\\Models\\Receipt',2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',93500.00,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2971,7749,40720,1536,2,2732,'App\\Models\\Receipt',2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',5600.00,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2972,7749,40720,1536,2,2733,'App\\Models\\Receipt',2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',7000.04,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2973,7749,40720,1536,2,2734,'App\\Models\\Receipt',2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',35000.46,NULL,NULL,1,'2023-04-13 10:21:54','2023-04-13 10:21:54',NULL),(2974,7749,40720,1536,3,2735,'App\\Models\\Receipt',2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',8699.00,NULL,NULL,1,'2023-04-13 10:22:13','2023-04-13 10:22:13',NULL),(2975,7749,40720,1536,3,2736,'App\\Models\\Receipt',2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',9892.29,NULL,NULL,1,'2023-04-13 10:22:13','2023-04-13 10:22:13',NULL),(2976,7749,40720,1536,3,2737,'App\\Models\\Receipt',2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',55091.02,NULL,NULL,1,'2023-04-13 10:22:13','2023-04-13 10:22:13',NULL);
INSERT INTO `balance_libro` VALUES (2977,7749,40720,1536,3,2738,'App\\Models\\Receipt',2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',32619.91,NULL,NULL,1,'2023-04-13 10:22:13','2023-04-13 10:22:13',NULL),(2978,7749,40720,1536,3,2739,'App\\Models\\Receipt',2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',38372.34,NULL,NULL,1,'2023-04-13 10:22:13','2023-04-13 10:22:13',NULL),(2979,7749,40720,1536,3,2740,'App\\Models\\Receipt',2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',30722.89,NULL,NULL,1,'2023-04-13 10:22:13','2023-04-13 10:22:13',NULL),(2980,7749,40720,1536,3,2741,'App\\Models\\Receipt',2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',19749.84,NULL,NULL,1,'2023-04-13 10:22:13','2023-04-13 10:22:13',NULL),(2981,7749,40720,1536,3,2742,'App\\Models\\Receipt',2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',8217.69,NULL,NULL,1,'2023-04-13 10:22:13','2023-04-13 10:22:13',NULL),(2982,7749,40720,1536,3,2743,'App\\Models\\Receipt',2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',32824.65,NULL,NULL,1,'2023-04-13 10:22:13','2023-04-13 10:22:13',NULL),(2983,7749,40720,1536,3,2744,'App\\Models\\Receipt',2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',12875.20,NULL,NULL,1,'2023-04-13 10:22:13','2023-04-13 10:22:13',NULL),(2984,7749,40720,1536,3,2745,'App\\Models\\Receipt',2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',190000.58,NULL,NULL,1,'2023-04-13 10:22:13','2023-05-18 10:57:20','2023-05-18 10:57:20'),(2985,7749,40720,1536,3,2746,'App\\Models\\Receipt',2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',412178.51,NULL,NULL,1,'2023-04-13 10:22:13','2023-04-13 10:22:13',NULL),(2986,7749,40720,1536,3,2747,'App\\Models\\Receipt',2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',285010.22,NULL,NULL,1,'2023-04-13 10:22:13','2023-05-17 11:43:04','2023-05-17 11:43:04'),(2987,7749,40720,1536,3,2748,'App\\Models\\Receipt',2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',254216.70,NULL,NULL,1,'2023-04-13 10:22:13','2023-04-13 10:22:13',NULL),(2988,7749,40720,1536,3,2749,'App\\Models\\Receipt',2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',35340.00,NULL,NULL,1,'2023-04-13 10:22:14','2023-05-18 09:19:49','2023-05-18 09:19:49'),(2989,7749,40720,1536,3,2750,'App\\Models\\Receipt',2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3925.00,NULL,NULL,1,'2023-04-13 10:22:14','2023-05-18 09:19:37','2023-05-18 09:19:37'),(2990,7749,40720,1536,3,2751,'App\\Models\\Receipt',2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',10819.16,NULL,NULL,1,'2023-04-13 10:22:14','2023-04-13 10:22:14',NULL),(2991,7749,40720,1536,3,2752,'App\\Models\\Receipt',2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',86515.00,NULL,NULL,1,'2023-04-13 10:22:14','2023-04-13 10:22:14',NULL),(2992,7749,40720,1536,2,2644,'App\\Models\\Receipt',2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',134190.00,NULL,NULL,1,'2023-04-13 11:57:45','2023-04-13 11:57:45',NULL),(2993,7749,40720,1536,2,2645,'App\\Models\\Receipt',2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',13210.01,NULL,NULL,1,'2023-04-13 11:58:05','2023-04-13 11:58:05',NULL),(2994,7749,40720,1536,2,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',129420.07,NULL,NULL,1,'2023-04-13 11:59:02','2023-04-13 11:59:02',NULL),(2995,7749,40720,1536,2,2647,'App\\Models\\Receipt',2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',99780.00,NULL,NULL,1,'2023-04-13 11:59:28','2023-04-13 11:59:28',NULL),(2996,7749,40720,1536,2,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',81460.00,NULL,NULL,1,'2023-04-13 11:59:50','2023-04-13 11:59:50',NULL);
INSERT INTO `balance_libro` VALUES (2997,7749,40720,1536,2,2649,'App\\Models\\Receipt',2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',154799.99,NULL,NULL,1,'2023-04-13 12:00:10','2023-04-13 12:00:10',NULL),(2998,7749,40720,1535,3,2424,'App\\Models\\Receipt',2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',112952.38,NULL,NULL,1,'2023-04-17 11:06:51','2023-04-17 11:06:51',NULL),(2999,7749,40720,1535,3,2753,'App\\Models\\Receipt',2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',32503.13,NULL,NULL,1,'2023-04-17 11:11:35','2023-04-17 11:11:35',NULL),(3000,7749,40720,1535,3,2754,'App\\Models\\Receipt',2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',50701.87,NULL,NULL,1,'2023-04-17 11:13:21','2023-04-17 11:13:21',NULL),(3001,7749,40720,1535,3,2755,'App\\Models\\Receipt',2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',7003.29,NULL,NULL,1,'2023-04-17 11:15:06','2023-04-17 11:15:06',NULL),(3002,7749,40720,1535,3,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',42677.89,NULL,NULL,1,'2023-04-17 11:16:01','2023-04-17 11:16:01',NULL),(3003,7749,40720,1535,3,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',304239.79,NULL,NULL,1,'2023-04-17 11:17:13','2023-04-17 11:17:13',NULL),(3004,7749,40720,1535,3,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',311708.69,NULL,NULL,1,'2023-04-17 11:17:46','2023-04-17 11:17:46',NULL),(3005,7749,40720,1535,3,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',10000.01,NULL,NULL,1,'2023-04-17 11:19:52','2023-04-17 11:19:52',NULL),(3006,7749,40720,1535,3,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',216851.83,NULL,NULL,1,'2023-04-17 11:20:54','2023-04-17 11:20:54',NULL),(3007,7749,40720,1535,3,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',19316.57,NULL,NULL,1,'2023-04-17 11:21:55','2023-04-17 11:21:55',NULL),(3008,7749,40720,1535,3,2758,'App\\Models\\Receipt',2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',15000.02,NULL,NULL,1,'2023-04-17 11:22:39','2023-04-17 11:22:39',NULL),(3009,7749,40720,1535,3,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',67572.85,NULL,NULL,1,'2023-04-17 11:23:12','2023-04-17 11:23:12',NULL),(3010,7749,40720,1535,3,2760,'App\\Models\\Receipt',2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',32116.10,NULL,NULL,1,'2023-04-17 11:25:37','2023-04-17 11:25:37',NULL),(3011,7749,40720,1535,3,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',362550.25,NULL,NULL,1,'2023-04-17 11:27:30','2023-04-17 11:27:30',NULL),(3012,7749,40720,1535,3,2761,'App\\Models\\Receipt',2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',48665.99,NULL,NULL,1,'2023-04-17 11:29:32','2023-04-17 11:29:32',NULL),(3013,7749,40720,1535,3,2762,'App\\Models\\Receipt',2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',9300.03,NULL,NULL,1,'2023-04-17 11:30:12','2023-04-17 11:30:12',NULL),(3014,7749,40720,1535,3,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',171962.37,NULL,NULL,1,'2023-04-17 11:32:28','2023-04-17 11:32:28',NULL),(3015,7749,40720,1535,3,2764,'App\\Models\\Receipt',2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',9799.99,NULL,NULL,1,'2023-04-17 11:49:00','2023-04-17 11:49:00',NULL),(3016,7749,40720,1535,3,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',53588.79,NULL,NULL,1,'2023-04-17 11:50:57','2023-04-17 11:50:57',NULL),(3017,7749,40720,1535,3,2765,'App\\Models\\Receipt',2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',5700.04,NULL,NULL,1,'2023-04-17 11:52:52','2023-04-17 11:52:52',NULL);
INSERT INTO `balance_libro` VALUES (3018,7749,40720,1535,3,2538,'App\\Models\\Receipt',2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',285500.74,NULL,NULL,1,'2023-04-17 11:53:22','2023-04-17 11:53:22',NULL),(3019,7749,40720,1535,3,2766,'App\\Models\\Receipt',2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',38746.44,NULL,NULL,1,'2023-04-17 11:54:21','2023-04-17 11:54:21',NULL),(3020,7749,40720,1535,3,2767,'App\\Models\\Receipt',2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',10102.74,NULL,NULL,1,'2023-04-17 11:55:03','2023-04-17 11:55:03',NULL),(3021,7749,40720,1535,3,2768,'App\\Models\\Receipt',2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',5500.06,NULL,NULL,1,'2023-04-17 11:57:01','2023-04-17 11:57:01',NULL),(3022,7749,40720,1535,3,2769,'App\\Models\\Receipt',2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',28600.20,NULL,NULL,1,'2023-04-17 12:02:59','2023-04-17 12:18:20','2023-04-17 12:18:20'),(3023,7749,40720,1535,3,2770,'App\\Models\\Receipt',2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',16999.80,NULL,NULL,1,'2023-04-17 12:03:45','2023-04-17 12:03:45',NULL),(3024,7749,40720,1535,3,2771,'App\\Models\\Receipt',2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',31110.00,NULL,NULL,1,'2023-04-17 12:04:27','2023-04-17 12:04:27',NULL),(3025,7749,40720,1535,3,2595,'App\\Models\\Receipt',2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',272944.37,NULL,NULL,1,'2023-04-17 12:05:34','2023-04-17 12:05:34',NULL),(3026,7749,40720,1535,3,2772,'App\\Models\\Receipt',2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',8000.03,NULL,NULL,1,'2023-04-17 12:09:30','2023-04-17 12:09:30',NULL),(3027,7749,40720,1535,3,2773,'App\\Models\\Receipt',2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',61471.23,NULL,NULL,1,'2023-04-17 12:10:08','2023-04-17 12:10:08',NULL),(3028,7749,40720,1535,3,2769,'App\\Models\\Receipt',2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',28600.20,NULL,NULL,1,'2023-04-17 12:18:20','2023-04-17 12:18:20',NULL),(3029,7749,40720,1535,3,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',15673.10,NULL,NULL,1,'2023-04-18 11:44:10','2023-04-18 11:44:10',NULL),(3030,7749,40720,1535,3,2599,'App\\Models\\Receipt',2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',19258.05,NULL,NULL,1,'2023-04-18 11:54:26','2023-04-18 11:54:26',NULL),(3031,7749,40720,1536,2,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',21589.97,NULL,NULL,1,'2023-04-20 10:16:45','2023-04-20 10:21:20','2023-04-20 10:21:20'),(3032,7749,40720,1536,2,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',2000.01,NULL,NULL,1,'2023-04-20 10:16:45','2023-04-20 10:21:01','2023-04-20 10:21:01'),(3033,7749,40720,1536,2,2776,'App\\Models\\Receipt',2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',700.01,NULL,NULL,1,'2023-04-20 10:16:45','2023-04-20 10:16:45',NULL),(3034,7749,40720,1536,2,2777,'App\\Models\\Receipt',2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',63989.87,NULL,NULL,1,'2023-04-20 10:16:45','2023-04-20 10:16:45',NULL),(3035,7749,40720,1536,2,2778,'App\\Models\\Receipt',2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',47200.03,NULL,NULL,1,'2023-04-20 10:16:45','2023-04-20 10:17:45','2023-04-20 10:17:45'),(3036,7749,40720,1536,2,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',11200.05,NULL,NULL,1,'2023-04-20 10:16:45','2023-04-20 10:18:05','2023-04-20 10:18:05'),(3037,7749,40720,1536,2,2780,'App\\Models\\Receipt',2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',22349.97,NULL,NULL,1,'2023-04-20 10:16:45','2023-04-20 10:18:23','2023-04-20 10:18:23');
INSERT INTO `balance_libro` VALUES (3038,7749,40720,1536,2,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1789.99,NULL,NULL,1,'2023-04-20 10:17:03','2023-04-20 10:17:03',NULL),(3039,7749,40720,1536,2,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',19799.98,NULL,NULL,1,'2023-04-20 10:17:03','2023-04-20 10:17:03',NULL),(3040,7749,40720,1536,2,2783,'App\\Models\\Receipt',2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',2000.01,NULL,NULL,1,'2023-04-20 10:17:03','2023-04-20 10:17:03',NULL),(3041,7749,40720,1536,2,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',37700.03,NULL,NULL,1,'2023-04-20 10:17:03','2023-04-20 10:17:03',NULL),(3042,7749,40720,1536,2,2785,'App\\Models\\Receipt',2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',9500.00,NULL,NULL,1,'2023-04-20 10:17:03','2023-04-20 10:17:03',NULL),(3043,7749,40720,1536,2,2786,'App\\Models\\Receipt',2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',6800.03,NULL,NULL,1,'2023-04-20 10:17:03','2023-04-20 10:17:03',NULL),(3044,7749,40720,1536,2,2787,'App\\Models\\Receipt',2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',599.99,NULL,NULL,1,'2023-04-20 10:17:03','2023-04-20 10:17:03',NULL),(3045,7749,40720,1536,2,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',1649.98,NULL,NULL,1,'2023-04-20 10:17:03','2023-04-20 10:17:03',NULL),(3046,7749,40720,1536,2,2789,'App\\Models\\Receipt',2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',750.03,NULL,NULL,1,'2023-04-20 10:17:03','2023-04-20 10:17:03',NULL),(3047,7749,40720,1536,2,2790,'App\\Models\\Receipt',2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',1400.03,NULL,NULL,1,'2023-04-20 10:17:03','2023-04-20 10:17:03',NULL),(3048,7749,40720,1536,2,2791,'App\\Models\\Receipt',2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',2349.99,NULL,NULL,1,'2023-04-20 10:17:03','2023-04-20 10:17:03',NULL),(3049,7749,40720,1536,2,2792,'App\\Models\\Receipt',2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',19999.97,NULL,NULL,1,'2023-04-20 10:17:04','2023-04-20 10:17:04',NULL),(3050,7749,40720,1536,2,2778,'App\\Models\\Receipt',2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',53760.00,NULL,NULL,1,'2023-04-20 10:17:45','2023-04-20 10:17:45',NULL),(3051,7749,40720,1536,2,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',106830.00,NULL,NULL,1,'2023-04-20 10:18:05','2023-04-20 10:18:05',NULL),(3052,7749,40720,1536,2,2780,'App\\Models\\Receipt',2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',131700.01,NULL,NULL,1,'2023-04-20 10:18:23','2023-04-20 10:18:23',NULL),(3053,7749,40720,1536,2,2793,'App\\Models\\Receipt',2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',109060.00,NULL,NULL,1,'2023-04-20 10:20:33','2023-04-20 10:20:33',NULL),(3054,7749,40720,1536,2,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',4815.00,NULL,NULL,1,'2023-04-20 10:21:01','2023-04-20 10:21:01',NULL),(3055,7749,40720,1536,2,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',141185.00,NULL,NULL,1,'2023-04-20 10:21:20','2023-04-20 10:21:20',NULL),(3056,7749,40720,1536,2,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',6599.97,NULL,NULL,1,'2023-04-24 09:28:28','2023-04-24 09:32:31','2023-04-24 09:32:31'),(3057,7749,40720,1536,2,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',3979.98,NULL,NULL,1,'2023-04-24 09:28:28','2023-04-24 09:28:28',NULL),(3058,7749,40720,1536,2,2796,'App\\Models\\Receipt',2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',12399.96,NULL,NULL,1,'2023-04-24 09:28:28','2023-04-24 09:34:09','2023-04-24 09:34:09');
INSERT INTO `balance_libro` VALUES (3059,7749,40720,1536,2,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',54199.99,NULL,NULL,1,'2023-04-24 09:28:28','2023-04-24 09:34:25','2023-04-24 09:34:25'),(3060,7749,40720,1536,2,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',999.98,NULL,NULL,1,'2023-04-24 09:28:28','2023-04-24 09:28:28',NULL),(3061,7749,40720,1536,2,2799,'App\\Models\\Receipt',2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',2940.01,NULL,NULL,1,'2023-04-24 09:28:28','2023-04-24 09:28:28',NULL),(3062,7749,40720,1536,2,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',3599.98,NULL,NULL,1,'2023-04-24 09:28:42','2023-04-24 09:28:42',NULL),(3063,7749,40720,1536,2,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',2999.99,NULL,NULL,1,'2023-04-24 09:28:42','2023-04-24 09:28:42',NULL),(3064,7749,40720,1536,2,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',11599.98,NULL,NULL,1,'2023-04-24 09:28:42','2023-04-24 09:28:42',NULL),(3065,7749,40720,1536,2,2803,'App\\Models\\Receipt',2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',599.99,NULL,NULL,1,'2023-04-24 09:28:42','2023-04-24 09:28:42',NULL),(3066,7749,40720,1536,2,2804,'App\\Models\\Receipt',2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',3399.98,NULL,NULL,1,'2023-04-24 09:28:42','2023-04-24 09:28:42',NULL),(3067,7749,40720,1536,2,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',2999.99,NULL,NULL,1,'2023-04-24 09:28:42','2023-04-24 09:28:42',NULL),(3068,7749,40720,1536,2,2806,'App\\Models\\Receipt',2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',5999.99,NULL,NULL,1,'2023-04-24 09:28:42','2023-04-24 09:28:42',NULL),(3069,7749,40720,1536,2,2807,'App\\Models\\Receipt',2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',8500.02,NULL,NULL,1,'2023-04-24 09:28:42','2023-04-24 09:28:42',NULL),(3070,7749,40720,1536,2,2808,'App\\Models\\Receipt',2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',38399.98,NULL,NULL,1,'2023-04-24 09:28:42','2023-04-24 09:28:42',NULL),(3071,7749,40720,1536,2,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',3599.98,NULL,NULL,1,'2023-04-24 09:28:43','2023-04-24 09:28:43',NULL),(3072,7749,40720,1536,2,2810,'App\\Models\\Receipt',2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',3700.01,NULL,NULL,1,'2023-04-24 09:28:43','2023-04-24 09:28:43',NULL),(3073,7749,40720,1536,2,2811,'App\\Models\\Receipt',2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',5299.97,NULL,NULL,1,'2023-04-24 09:28:43','2023-04-24 09:28:43',NULL),(3074,7749,40720,1536,2,2812,'App\\Models\\Receipt',2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',15879.98,NULL,NULL,1,'2023-04-24 09:28:43','2023-04-24 09:28:43',NULL),(3075,7749,40720,1536,2,2813,'App\\Models\\Receipt',2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',6199.98,NULL,NULL,1,'2023-04-24 09:28:43','2023-04-24 09:28:43',NULL),(3076,7749,40720,1536,2,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',113490.00,NULL,NULL,1,'2023-04-24 09:32:31','2023-04-24 09:32:31',NULL),(3077,7749,40720,1536,2,2814,'App\\Models\\Receipt',2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',79170.00,NULL,NULL,1,'2023-04-24 09:33:29','2023-04-24 09:33:29',NULL),(3078,7749,40720,1536,2,2796,'App\\Models\\Receipt',2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',78990.00,NULL,NULL,1,'2023-04-24 09:34:09','2023-04-24 09:34:09',NULL),(3079,7749,40720,1536,2,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',66340.00,NULL,NULL,1,'2023-04-24 09:34:25','2023-04-24 09:34:25',NULL);
INSERT INTO `balance_libro` VALUES (3080,7749,40720,1536,2,2815,'App\\Models\\Receipt',2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',65529.99,NULL,NULL,1,'2023-04-24 09:35:34','2023-04-24 09:35:34',NULL),(3081,7749,40720,1536,2,2816,'App\\Models\\Receipt',2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',125750.00,NULL,NULL,1,'2023-04-24 09:36:58','2023-04-24 09:36:58',NULL),(3082,7749,40720,1536,3,2817,'App\\Models\\Receipt',2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',93745.95,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3083,7749,40720,1536,3,2818,'App\\Models\\Receipt',2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',109922.51,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3084,7749,40720,1536,3,2819,'App\\Models\\Receipt',2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',4397.79,NULL,NULL,1,'2023-04-24 09:39:58','2023-05-17 11:44:39','2023-05-17 11:44:39'),(3085,7749,40720,1536,3,2820,'App\\Models\\Receipt',2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',109015.63,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3086,7749,40720,1536,3,2821,'App\\Models\\Receipt',2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',16778.39,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3087,7749,40720,1536,3,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',247863.01,NULL,NULL,1,'2023-04-24 09:39:58','2023-05-17 11:50:49','2023-05-17 11:50:49'),(3088,7749,40720,1536,3,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',36095.00,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3089,7749,40720,1536,3,2824,'App\\Models\\Receipt',2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',84305.70,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3090,7749,40720,1536,3,2825,'App\\Models\\Receipt',2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',75408.80,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3091,7749,40720,1536,3,2826,'App\\Models\\Receipt',2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',7638.86,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3092,7749,40720,1536,3,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',154759.04,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3093,7749,40720,1536,3,2828,'App\\Models\\Receipt',2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',105144.67,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3094,7749,40720,1536,3,2829,'App\\Models\\Receipt',2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',32162.24,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3095,7749,40720,1536,3,2830,'App\\Models\\Receipt',2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',124744.59,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3096,7749,40720,1536,3,2831,'App\\Models\\Receipt',2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',132871.24,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3097,7749,40720,1536,3,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',342440.02,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3098,7749,40720,1536,3,2833,'App\\Models\\Receipt',2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',15114.58,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3099,7749,40720,1536,3,2834,'App\\Models\\Receipt',2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',101014.25,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL);
INSERT INTO `balance_libro` VALUES (3100,7749,40720,1536,3,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',23404.24,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3101,7749,40720,1536,3,2836,'App\\Models\\Receipt',2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',30722.89,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3102,7749,40720,1536,3,2837,'App\\Models\\Receipt',2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',11223.64,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3103,7749,40720,1536,3,2838,'App\\Models\\Receipt',2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',70935.20,NULL,NULL,1,'2023-04-24 09:39:58','2023-04-24 09:39:58',NULL),(3104,7749,40720,1536,3,2839,'App\\Models\\Receipt',2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',66862.51,NULL,NULL,1,'2023-04-24 09:39:59','2023-04-24 09:39:59',NULL),(3105,7749,40720,1536,2,2840,'App\\Models\\Receipt',2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',104200.00,NULL,NULL,1,'2023-04-24 09:41:31','2023-04-24 09:41:31',NULL),(3106,7749,40720,1536,2,2841,'App\\Models\\Receipt',2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',28700.00,NULL,NULL,1,'2023-04-24 09:41:32','2023-04-24 09:41:32',NULL),(3107,7749,40720,1536,2,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',77175.25,NULL,NULL,1,'2023-04-24 09:41:32','2023-04-24 09:41:32',NULL),(3108,7749,40720,1536,2,2843,'App\\Models\\Receipt',2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',14800.00,NULL,NULL,1,'2023-04-24 09:41:32','2023-04-24 09:41:32',NULL),(3109,7749,40720,1536,2,2844,'App\\Models\\Receipt',2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',97510.00,NULL,NULL,1,'2023-04-24 09:41:32','2023-04-24 09:41:32',NULL),(3110,7749,40720,1536,2,2845,'App\\Models\\Receipt',2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',150000.00,NULL,NULL,1,'2023-04-24 09:41:32','2023-04-24 09:41:32',NULL),(3111,7749,40720,1536,2,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',7950.00,NULL,NULL,1,'2023-04-24 09:41:33','2023-04-24 09:41:33',NULL),(3112,7749,40720,1536,3,2847,'App\\Models\\Receipt',2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',140000.00,NULL,NULL,1,'2023-04-26 10:08:17','2023-04-26 10:08:17',NULL),(3113,7749,40720,1536,3,2848,'App\\Models\\Receipt',2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',231996.63,NULL,NULL,1,'2023-04-26 10:08:17','2023-04-26 10:08:17',NULL),(3114,7749,40720,1536,3,2849,'App\\Models\\Receipt',2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',9072.00,NULL,NULL,1,'2023-04-26 10:08:17','2023-04-26 10:08:17',NULL),(3115,7749,40720,1536,3,2850,'App\\Models\\Receipt',2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',11600.00,NULL,NULL,1,'2023-04-28 09:43:58','2023-04-28 09:43:58',NULL),(3116,7749,40720,1536,3,2851,'App\\Models\\Receipt',2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',74227.79,NULL,NULL,1,'2023-04-28 09:43:58','2023-04-28 09:43:58',NULL),(3117,7749,40720,1536,3,2852,'App\\Models\\Receipt',2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',29649.42,NULL,NULL,1,'2023-04-28 09:43:58','2023-04-28 09:43:58',NULL),(3118,7749,40720,1536,3,2853,'App\\Models\\Receipt',2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',133246.25,NULL,NULL,1,'2023-04-28 09:43:59','2023-04-28 09:43:59',NULL),(3119,7749,40720,1536,2,2854,'App\\Models\\Receipt',2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',431800.00,NULL,NULL,1,'2023-04-28 09:44:29','2023-04-28 09:44:29',NULL),(3120,7749,40720,1536,2,2855,'App\\Models\\Receipt',2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',434000.00,NULL,NULL,1,'2023-04-28 09:44:29','2023-04-28 09:44:29',NULL);
INSERT INTO `balance_libro` VALUES (3121,7749,40720,1536,2,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',347500.00,NULL,NULL,1,'2023-04-28 09:44:30','2023-04-28 09:44:30',NULL),(3122,7749,40720,1536,2,2857,'App\\Models\\Receipt',2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',28000.00,NULL,NULL,1,'2023-04-28 09:44:30','2023-04-28 09:44:30',NULL),(3123,7749,40720,1536,3,2858,'App\\Models\\Receipt',2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',56510.35,NULL,NULL,1,'2023-04-28 11:15:20','2023-04-28 11:15:20',NULL),(3124,7749,40720,1536,3,2859,'App\\Models\\Receipt',2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',38147.15,NULL,NULL,1,'2023-04-28 11:15:41','2023-04-28 11:15:41',NULL),(3125,7749,40720,1536,3,2860,'App\\Models\\Receipt',2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',71151.71,NULL,NULL,1,'2023-04-28 11:16:06','2023-04-28 11:16:06',NULL),(3126,7749,40720,1536,2,2861,'App\\Models\\Receipt',2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',67599.99,NULL,NULL,1,'2023-05-02 09:10:47','2023-05-04 10:36:50','2023-05-04 10:36:50'),(3127,7749,40720,1536,2,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',2999.99,NULL,NULL,1,'2023-05-02 09:10:47','2023-05-04 10:37:21','2023-05-04 10:37:21'),(3128,7749,40720,1536,2,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',19070.00,NULL,NULL,1,'2023-05-02 09:10:47','2023-05-04 10:37:38','2023-05-04 10:37:38'),(3129,7749,40720,1536,2,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',868.09,NULL,NULL,1,'2023-05-02 09:10:47','2023-05-02 09:10:47',NULL),(3130,7749,40720,1536,2,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',13189.98,NULL,NULL,1,'2023-05-02 09:10:47','2023-05-04 10:39:23','2023-05-04 10:39:23'),(3131,7749,40720,1536,2,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',6800.03,NULL,NULL,1,'2023-05-02 09:10:47','2023-05-04 10:39:46','2023-05-04 10:39:46'),(3132,7749,40720,1536,2,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',26000.02,NULL,NULL,1,'2023-05-02 09:10:47','2023-05-04 10:40:51','2023-05-04 10:40:51'),(3133,7749,40720,1536,2,2868,'App\\Models\\Receipt',2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',15849.96,NULL,NULL,1,'2023-05-02 09:10:47','2023-05-02 09:10:47',NULL),(3134,7749,40720,1536,2,2869,'App\\Models\\Receipt',2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',60399.97,NULL,NULL,1,'2023-05-02 09:11:02','2023-05-02 09:11:02',NULL),(3135,7749,40720,1536,2,2870,'App\\Models\\Receipt',2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',7200.02,NULL,NULL,1,'2023-05-02 09:11:02','2023-05-02 09:11:02',NULL),(3136,7749,40720,1536,2,2871,'App\\Models\\Receipt',2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',2999.99,NULL,NULL,1,'2023-05-02 09:11:02','2023-05-02 09:11:02',NULL),(3137,7749,40720,1536,2,2872,'App\\Models\\Receipt',2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',2650.02,NULL,NULL,1,'2023-05-02 09:11:02','2023-05-02 09:11:02',NULL),(3138,7749,40720,1536,2,2873,'App\\Models\\Receipt',2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',13299.97,NULL,NULL,1,'2023-05-02 09:11:02','2023-05-02 09:11:02',NULL),(3139,7749,40720,1536,2,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',3120.01,NULL,NULL,1,'2023-05-02 09:11:02','2023-05-02 09:11:02',NULL),(3140,7749,40720,1536,2,2875,'App\\Models\\Receipt',2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',2839.99,NULL,NULL,1,'2023-05-02 09:11:02','2023-05-02 09:11:02',NULL);
INSERT INTO `balance_libro` VALUES (3141,7749,40720,1536,2,2876,'App\\Models\\Receipt',2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',5079.98,NULL,NULL,1,'2023-05-02 09:11:02','2023-05-02 09:11:02',NULL),(3142,7749,40720,1536,2,2877,'App\\Models\\Receipt',2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',1249.99,NULL,NULL,1,'2023-05-02 09:11:02','2023-05-02 09:11:02',NULL),(3143,7749,40720,1536,2,2878,'App\\Models\\Receipt',2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',3999.97,NULL,NULL,1,'2023-05-02 09:11:02','2023-05-02 09:11:02',NULL),(3144,7749,40720,1536,2,2879,'App\\Models\\Receipt',2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',6900.00,NULL,NULL,1,'2023-05-02 09:11:02','2023-05-02 09:11:02',NULL),(3145,7749,40720,1536,2,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',7699.98,NULL,NULL,1,'2023-05-02 09:11:02','2023-05-02 09:11:02',NULL),(3146,7749,40720,1536,2,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',2859.98,NULL,NULL,1,'2023-05-02 09:11:02','2023-05-02 09:11:02',NULL),(3147,7749,40720,1536,2,2882,'App\\Models\\Receipt',2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1300.00,NULL,NULL,1,'2023-05-02 09:11:02','2023-05-02 09:11:02',NULL),(3148,7749,40720,1536,2,2883,'App\\Models\\Receipt',2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',1330.02,NULL,NULL,1,'2023-05-02 09:11:02','2023-05-02 09:11:02',NULL),(3149,7749,40720,1536,2,2884,'App\\Models\\Receipt',2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',3500.01,NULL,NULL,1,'2023-05-02 09:11:02','2023-05-02 09:11:02',NULL),(3150,7749,40720,1536,2,2885,'App\\Models\\Receipt',2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',3300.02,NULL,NULL,1,'2023-05-02 09:11:02','2023-05-02 09:11:02',NULL),(3151,7749,40720,1536,2,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',10999.99,NULL,NULL,1,'2023-05-02 09:11:03','2023-05-02 09:11:03',NULL),(3152,7749,40720,1536,2,2887,'App\\Models\\Receipt',2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',15000.02,NULL,NULL,1,'2023-05-02 09:11:03','2023-05-02 09:11:03',NULL),(3153,7749,40720,1536,2,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',1700.00,NULL,NULL,1,'2023-05-02 09:11:21','2023-05-02 09:11:21',NULL),(3154,7749,40720,1536,2,2889,'App\\Models\\Receipt',2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',47000.01,NULL,NULL,1,'2023-05-02 09:11:21','2023-05-02 09:11:21',NULL),(3155,7749,40720,1536,2,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',11000.00,NULL,NULL,1,'2023-05-02 09:11:21','2023-05-02 09:11:21',NULL),(3156,7749,40720,1536,2,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',94400.00,NULL,NULL,1,'2023-05-02 09:11:21','2023-05-02 09:11:21',NULL),(3157,7749,40720,1536,2,2892,'App\\Models\\Receipt',2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',9600.01,NULL,NULL,1,'2023-05-02 09:11:21','2023-05-02 09:11:21',NULL),(3158,7749,40720,1536,2,2893,'App\\Models\\Receipt',2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',48600.00,NULL,NULL,1,'2023-05-02 09:11:22','2023-05-02 09:11:22',NULL),(3159,7749,40720,1536,2,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',3800.00,NULL,NULL,1,'2023-05-02 09:11:22','2023-05-02 09:11:22',NULL),(3160,7749,40720,1536,3,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',72272.70,NULL,NULL,1,'2023-05-02 09:15:06','2023-05-02 09:15:06',NULL),(3161,7749,40720,1536,3,2896,'App\\Models\\Receipt',2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',73987.59,NULL,NULL,1,'2023-05-02 09:15:06','2023-05-02 09:15:06',NULL);
INSERT INTO `balance_libro` VALUES (3162,7749,40720,1536,3,2897,'App\\Models\\Receipt',2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',618386.82,NULL,NULL,1,'2023-05-02 09:15:06','2023-05-02 09:15:06',NULL),(3163,7749,40720,1536,3,2898,'App\\Models\\Receipt',2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',448991.74,NULL,NULL,1,'2023-05-02 09:15:06','2023-05-02 09:15:06',NULL),(3164,7749,40720,1536,3,2899,'App\\Models\\Receipt',2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',331379.16,NULL,NULL,1,'2023-05-02 09:15:07','2023-05-02 09:15:07',NULL),(3165,7749,40720,1536,3,2900,'App\\Models\\Receipt',2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',52405.15,NULL,NULL,1,'2023-05-02 09:15:07','2023-05-02 09:15:07',NULL),(3166,7749,40720,1536,3,2901,'App\\Models\\Receipt',2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',118490.15,NULL,NULL,1,'2023-05-02 09:15:07','2023-05-02 09:15:07',NULL),(3167,7749,40720,1536,3,2902,'App\\Models\\Receipt',2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',7407.42,NULL,NULL,1,'2023-05-02 09:15:07','2023-05-02 09:15:07',NULL),(3168,7749,40720,1536,3,2903,'App\\Models\\Receipt',2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',31998.84,NULL,NULL,1,'2023-05-02 09:15:07','2023-05-02 09:15:07',NULL),(3169,7749,40720,1536,3,2904,'App\\Models\\Receipt',2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',22889.50,NULL,NULL,1,'2023-05-02 09:15:07','2023-05-02 09:15:07',NULL),(3170,7749,40720,1536,3,2905,'App\\Models\\Receipt',2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',0.00,NULL,NULL,1,'2023-05-02 09:15:07','2023-05-02 09:15:07',NULL),(3171,7749,40720,1536,2,2861,'App\\Models\\Receipt',2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',125289.99,NULL,NULL,1,'2023-05-04 10:36:50','2023-05-04 10:36:50',NULL),(3172,7749,40720,1536,2,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',136390.00,NULL,NULL,1,'2023-05-04 10:37:21','2023-05-04 10:37:21',NULL),(3173,7749,40720,1536,2,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',124560.00,NULL,NULL,1,'2023-05-04 10:37:38','2023-05-04 10:37:38',NULL),(3174,7749,40720,1536,2,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',117660.00,NULL,NULL,1,'2023-05-04 10:38:53','2023-05-04 10:38:53',NULL),(3175,7749,40720,1536,2,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',113330.00,NULL,NULL,1,'2023-05-04 10:39:23','2023-05-04 10:39:23',NULL),(3176,7749,40720,1536,2,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',105090.00,NULL,NULL,1,'2023-05-04 10:39:46','2023-05-04 10:39:46',NULL),(3177,7749,40720,1536,2,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',204590.10,NULL,NULL,1,'2023-05-04 10:40:51','2023-05-04 10:40:51',NULL),(3178,7749,40720,1537,2,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',2259.99,NULL,NULL,1,'2023-05-15 11:08:43','2023-05-22 11:59:32','2023-05-22 11:59:32'),(3179,7749,40720,1537,2,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',7249.97,NULL,NULL,1,'2023-05-15 11:08:43','2023-06-16 10:39:37','2023-06-16 10:39:37'),(3180,7749,40720,1537,2,2909,'App\\Models\\Receipt',2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',100.03,NULL,NULL,1,'2023-05-15 11:08:43','2023-06-16 10:41:47','2023-06-16 10:41:47'),(3181,7749,40720,1537,2,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',5000.01,NULL,NULL,1,'2023-05-15 11:08:43','2023-06-16 10:42:14','2023-06-16 10:42:14');
INSERT INTO `balance_libro` VALUES (3182,7749,40720,1537,2,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',13889.99,NULL,NULL,1,'2023-05-15 11:08:43','2023-05-22 12:03:46','2023-05-22 12:03:46'),(3183,7749,40720,1537,2,2912,'App\\Models\\Receipt',2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',161909.98,NULL,NULL,1,'2023-05-15 11:08:43','2023-05-15 11:08:43',NULL),(3184,7749,40720,1537,2,2913,'App\\Models\\Receipt',2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',799.98,NULL,NULL,1,'2023-05-15 11:08:57','2023-05-15 11:08:57',NULL),(3185,7749,40720,1537,2,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',1460.01,NULL,NULL,1,'2023-05-15 11:08:57','2023-05-15 11:08:57',NULL),(3186,7749,40720,1537,2,2915,'App\\Models\\Receipt',2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',799.98,NULL,NULL,1,'2023-05-15 11:08:57','2023-05-15 11:08:57',NULL),(3187,7749,40720,1537,2,2916,'App\\Models\\Receipt',2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',5999.99,NULL,NULL,1,'2023-05-15 11:08:57','2023-05-15 11:08:57',NULL),(3188,7749,40720,1537,2,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',2099.98,NULL,NULL,1,'2023-05-15 11:08:57','2023-05-15 11:08:57',NULL),(3189,7749,40720,1537,2,2918,'App\\Models\\Receipt',2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',9669.97,NULL,NULL,1,'2023-05-15 11:08:57','2023-05-15 11:08:57',NULL),(3190,7749,40720,1537,2,2919,'App\\Models\\Receipt',2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',1350.01,NULL,NULL,1,'2023-05-15 11:08:57','2023-05-15 11:08:57',NULL),(3191,7749,40720,1537,2,2920,'App\\Models\\Receipt',2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',2499.98,NULL,NULL,1,'2023-05-15 11:08:57','2023-05-15 11:08:57',NULL),(3192,7749,40720,1537,2,2921,'App\\Models\\Receipt',2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',300.02,NULL,NULL,1,'2023-05-15 11:08:57','2023-05-15 11:08:57',NULL),(3193,7749,40720,1537,2,2922,'App\\Models\\Receipt',2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',4200.03,NULL,NULL,1,'2023-05-15 11:08:57','2023-05-15 11:08:57',NULL),(3194,7749,40720,1537,2,2923,'App\\Models\\Receipt',2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',4899.98,NULL,NULL,1,'2023-05-15 11:08:57','2023-05-15 11:08:57',NULL),(3195,7749,40720,1537,2,2924,'App\\Models\\Receipt',2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',7000.02,NULL,NULL,1,'2023-05-15 11:08:57','2023-05-15 11:08:57',NULL),(3196,7749,40720,1537,2,2925,'App\\Models\\Receipt',2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1800.02,NULL,NULL,1,'2023-05-15 11:08:57','2023-05-15 11:08:57',NULL),(3197,7749,40720,1537,2,2926,'App\\Models\\Receipt',2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',4420.01,NULL,NULL,1,'2023-05-15 11:08:57','2023-05-15 11:08:57',NULL),(3198,7749,40720,1537,2,2927,'App\\Models\\Receipt',2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1519.99,NULL,NULL,1,'2023-05-15 11:08:57','2023-05-15 11:08:57',NULL),(3199,7749,40720,1537,2,2928,'App\\Models\\Receipt',2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1199.97,NULL,NULL,1,'2023-05-15 11:08:57','2023-05-15 11:08:57',NULL),(3200,7749,40720,1537,2,2929,'App\\Models\\Receipt',2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1899.99,NULL,NULL,1,'2023-05-15 11:08:57','2023-05-15 11:08:57',NULL),(3201,7749,40720,1537,2,2930,'App\\Models\\Receipt',2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',3050.01,NULL,NULL,1,'2023-05-15 11:08:57','2023-05-15 11:08:57',NULL),(3202,7749,40720,1536,3,2747,'App\\Models\\Receipt',2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',285010.22,NULL,NULL,1,'2023-05-17 11:43:04','2023-05-17 11:43:04',NULL);
INSERT INTO `balance_libro` VALUES (3203,7749,40720,1536,3,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',247863.01,NULL,NULL,1,'2023-05-17 11:50:49','2023-05-17 11:50:49',NULL),(3204,7749,40720,1536,3,2931,'App\\Models\\Receipt',2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',9301.79,NULL,NULL,1,'2023-05-18 09:33:09','2023-05-18 09:33:09',NULL),(3205,7749,40720,1536,3,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',11101.24,NULL,NULL,1,'2023-05-18 09:33:52','2023-05-18 09:33:52',NULL),(3206,7749,40720,1536,3,2933,'App\\Models\\Receipt',2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',11000.16,NULL,NULL,1,'2023-05-18 09:34:41','2023-05-18 09:34:41',NULL),(3207,7749,40720,1536,3,2934,'App\\Models\\Receipt',2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',16000.00,NULL,NULL,1,'2023-05-18 09:35:34','2023-05-18 09:35:34',NULL),(3208,7749,40720,1536,3,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',8202.13,NULL,NULL,1,'2023-05-18 09:36:16','2023-05-18 09:36:16',NULL),(3209,7749,40720,1536,3,2936,'App\\Models\\Receipt',2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',11001.40,NULL,NULL,1,'2023-05-18 09:37:06','2023-05-18 09:37:06',NULL),(3210,7749,40720,1536,3,2937,'App\\Models\\Receipt',2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',6999.98,NULL,NULL,1,'2023-05-18 09:37:58','2023-05-18 09:37:58',NULL),(3211,7749,40720,1536,3,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',7003.32,NULL,NULL,1,'2023-05-18 09:38:32','2023-05-18 09:38:32',NULL),(3212,7749,40720,1536,3,2939,'App\\Models\\Receipt',2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',4000.12,NULL,NULL,1,'2023-05-18 09:39:04','2023-05-18 09:39:04',NULL),(3213,7749,40720,1536,3,2745,'App\\Models\\Receipt',2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',190000.58,NULL,NULL,1,'2023-05-18 10:57:20','2023-05-18 10:57:20',NULL),(3214,7749,40720,1537,3,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',10249.00,NULL,NULL,1,'2023-05-19 12:40:59','2023-06-21 11:40:43','2023-06-21 11:40:43'),(3215,7749,40720,1537,3,2941,'App\\Models\\Receipt',2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',261755.15,NULL,NULL,1,'2023-05-19 12:40:59','2023-05-19 12:40:59',NULL),(3216,7749,40720,1537,3,2942,'App\\Models\\Receipt',2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',253563.98,NULL,NULL,1,'2023-05-19 12:40:59','2023-06-15 12:12:10','2023-06-15 12:12:10'),(3217,7749,40720,1537,3,2943,'App\\Models\\Receipt',2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',12544.84,NULL,NULL,1,'2023-05-19 12:40:59','2023-05-19 12:40:59',NULL),(3218,7749,40720,1537,3,2944,'App\\Models\\Receipt',2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',5040.18,NULL,NULL,1,'2023-05-19 12:40:59','2023-06-16 10:14:33','2023-06-16 10:14:33'),(3219,7749,40720,1537,3,2945,'App\\Models\\Receipt',2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',93549.96,NULL,NULL,1,'2023-05-19 12:40:59','2023-05-19 12:40:59',NULL),(3220,7749,40720,1537,3,2946,'App\\Models\\Receipt',2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',38152.75,NULL,NULL,1,'2023-05-19 12:40:59','2023-05-19 12:40:59',NULL),(3221,7749,40720,1537,3,2947,'App\\Models\\Receipt',2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',132655.24,NULL,NULL,1,'2023-05-19 12:40:59','2023-06-15 12:13:40','2023-06-15 12:13:40'),(3222,7749,40720,1537,3,2948,'App\\Models\\Receipt',2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',1823.22,NULL,NULL,1,'2023-05-19 12:40:59','2023-05-19 12:40:59',NULL);
INSERT INTO `balance_libro` VALUES (3223,7749,40720,1537,3,2949,'App\\Models\\Receipt',2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',82676.64,NULL,NULL,1,'2023-05-19 12:40:59','2023-05-19 12:40:59',NULL),(3224,7749,40720,1537,3,2950,'App\\Models\\Receipt',2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',11599.85,NULL,NULL,1,'2023-05-19 12:40:59','2023-05-19 12:40:59',NULL),(3225,7749,40720,1537,3,2951,'App\\Models\\Receipt',2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',11599.85,NULL,NULL,1,'2023-05-19 12:40:59','2023-05-19 12:40:59',NULL),(3226,7749,40720,1537,3,2952,'App\\Models\\Receipt',2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',181879.25,NULL,NULL,1,'2023-05-19 12:41:00','2023-05-19 12:41:00',NULL),(3227,7749,40720,1537,3,2953,'App\\Models\\Receipt',2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',92783.77,NULL,NULL,1,'2023-05-19 12:41:00','2023-06-15 12:18:59','2023-06-15 12:18:59'),(3228,7749,40720,1537,3,2954,'App\\Models\\Receipt',2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',76093.42,NULL,NULL,1,'2023-05-19 12:41:00','2023-06-15 12:19:15','2023-06-15 12:19:15'),(3229,7749,40720,1537,3,2955,'App\\Models\\Receipt',2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',189750.00,NULL,NULL,1,'2023-05-19 12:41:00','2023-05-19 12:41:00',NULL),(3230,7749,40720,1537,3,2956,'App\\Models\\Receipt',2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',106395.75,NULL,NULL,1,'2023-05-19 12:41:00','2023-05-19 12:41:00',NULL),(3231,7749,40720,1537,3,2957,'App\\Models\\Receipt',2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',47825.30,NULL,NULL,1,'2023-05-19 12:41:00','2023-05-19 12:41:00',NULL),(3232,7749,40720,1537,3,2958,'App\\Models\\Receipt',2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',36874.00,NULL,NULL,1,'2023-05-19 12:41:00','2023-06-16 10:28:12','2023-06-16 10:28:12'),(3233,7749,40720,1537,3,2959,'App\\Models\\Receipt',2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',33290.94,NULL,NULL,1,'2023-05-19 12:41:00','2023-05-19 12:41:00',NULL),(3234,7749,40720,1537,3,2960,'App\\Models\\Receipt',2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',327888.40,NULL,NULL,1,'2023-05-19 12:41:00','2023-05-19 12:41:00',NULL),(3235,7749,40720,1537,3,2961,'App\\Models\\Receipt',2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',23113.54,NULL,NULL,1,'2023-05-19 12:41:00','2023-06-15 12:25:04','2023-06-15 12:25:04'),(3236,7749,40720,1537,3,2962,'App\\Models\\Receipt',2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',16300.01,NULL,NULL,1,'2023-05-19 12:41:00','2023-05-19 12:41:00',NULL),(3237,7749,40720,1537,3,2963,'App\\Models\\Receipt',2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',31349.33,NULL,NULL,1,'2023-05-19 12:41:00','2023-05-19 12:41:00',NULL),(3238,7749,40720,1537,3,2964,'App\\Models\\Receipt',2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',29286.22,NULL,NULL,1,'2023-05-19 12:41:00','2023-05-19 12:41:00',NULL),(3239,7749,40720,1537,3,2965,'App\\Models\\Receipt',2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',226987.01,NULL,NULL,1,'2023-05-19 12:41:00','2023-05-19 12:41:00',NULL),(3240,7749,40720,1537,3,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',106490.77,NULL,NULL,1,'2023-05-19 12:41:00','2023-05-19 12:41:00',NULL),(3241,7749,40720,1537,3,2967,'App\\Models\\Receipt',2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',91800.00,NULL,NULL,1,'2023-05-19 12:41:00','2023-06-15 12:35:05','2023-06-15 12:35:05'),(3242,7749,40720,1537,3,2968,'App\\Models\\Receipt',2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',95119.41,NULL,NULL,1,'2023-05-19 12:41:00','2023-05-19 12:41:00',NULL);
INSERT INTO `balance_libro` VALUES (3243,7749,40720,1537,3,2969,'App\\Models\\Receipt',2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',381495.93,NULL,NULL,1,'2023-05-19 12:41:00','2023-06-15 12:30:32','2023-06-15 12:30:32'),(3244,7749,40720,1537,3,2970,'App\\Models\\Receipt',2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',40604.01,NULL,NULL,1,'2023-05-19 12:41:00','2023-05-19 12:41:00',NULL),(3245,7749,40720,1537,3,2971,'App\\Models\\Receipt',2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',5299.99,NULL,NULL,1,'2023-05-19 12:41:00','2023-05-19 12:41:00',NULL),(3246,7749,40720,1537,3,2972,'App\\Models\\Receipt',2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',264769.31,NULL,NULL,1,'2023-05-19 12:41:00','2023-05-19 12:41:00',NULL),(3247,7749,40720,1537,3,2973,'App\\Models\\Receipt',2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',142589.39,NULL,NULL,1,'2023-05-19 12:41:00','2023-06-15 12:32:49','2023-06-15 12:32:49'),(3248,7749,40720,1537,3,2974,'App\\Models\\Receipt',2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',87339.75,NULL,NULL,1,'2023-05-19 12:41:00','2023-06-15 12:33:22','2023-06-15 12:33:22'),(3249,7749,40720,1537,3,2975,'App\\Models\\Receipt',2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',9626.03,NULL,NULL,1,'2023-05-19 12:41:00','2023-06-15 12:33:44','2023-06-15 12:33:44'),(3250,7749,40720,1537,3,2976,'App\\Models\\Receipt',2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',146524.93,NULL,NULL,1,'2023-05-19 12:41:00','2023-05-19 12:41:00',NULL),(3251,7749,40720,1537,3,2977,'App\\Models\\Receipt',2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',68624.07,NULL,NULL,1,'2023-05-19 12:41:01','2023-05-19 12:41:01',NULL),(3252,7749,40720,1537,3,2978,'App\\Models\\Receipt',2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',343484.55,NULL,NULL,1,'2023-05-19 12:41:01','2023-06-15 12:34:49','2023-06-15 12:34:49'),(3253,7749,40720,1537,3,2979,'App\\Models\\Receipt',2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',150456.74,NULL,NULL,1,'2023-05-19 12:41:01','2023-05-19 12:41:01',NULL),(3254,7749,40720,1537,3,2980,'App\\Models\\Receipt',2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',140324.69,NULL,NULL,1,'2023-05-19 12:41:01','2023-06-15 12:36:17','2023-06-15 12:36:17'),(3255,7749,40720,1537,3,2981,'App\\Models\\Receipt',2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',178807.99,NULL,NULL,1,'2023-05-19 12:41:01','2023-06-15 12:37:17','2023-06-15 12:37:17'),(3256,7749,40720,1537,3,2982,'App\\Models\\Receipt',2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',115275.31,NULL,NULL,1,'2023-05-19 12:41:01','2023-05-19 12:41:01',NULL),(3257,7749,40720,1537,3,2983,'App\\Models\\Receipt',2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',336938.87,NULL,NULL,1,'2023-05-19 12:41:01','2023-05-19 12:41:01',NULL),(3258,7749,40720,1537,3,2984,'App\\Models\\Receipt',2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',583140.79,NULL,NULL,1,'2023-05-19 12:41:01','2023-06-15 12:38:21','2023-06-15 12:38:21'),(3259,7749,40720,1537,3,2985,'App\\Models\\Receipt',2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',30221.57,NULL,NULL,1,'2023-05-19 12:41:01','2023-05-19 12:41:01',NULL),(3260,7749,40720,1537,3,2986,'App\\Models\\Receipt',2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',1303507.34,NULL,NULL,1,'2023-05-19 12:41:01','2023-05-19 12:41:01',NULL),(3261,7749,40720,1537,3,2987,'App\\Models\\Receipt',2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',902062.76,NULL,NULL,1,'2023-05-19 12:41:01','2023-05-19 12:41:01',NULL),(3262,7749,40720,1537,3,2988,'App\\Models\\Receipt',2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',163680.68,NULL,NULL,1,'2023-05-19 12:41:01','2023-05-19 12:41:01',NULL);
INSERT INTO `balance_libro` VALUES (3263,7749,40720,1537,2,2989,'App\\Models\\Receipt',2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',64850.00,NULL,NULL,1,'2023-05-22 09:59:53','2023-05-22 09:59:53',NULL),(3264,7749,40720,1537,2,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',53659.99,NULL,NULL,1,'2023-05-22 09:59:53','2023-05-22 09:59:53',NULL),(3265,7749,40720,1537,2,2991,'App\\Models\\Receipt',2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',17530.00,NULL,NULL,1,'2023-05-22 09:59:53','2023-05-22 09:59:53',NULL),(3266,7749,40720,1537,2,2992,'App\\Models\\Receipt',2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',43739.99,NULL,NULL,1,'2023-05-22 09:59:53','2023-05-22 09:59:53',NULL),(3267,7749,40720,1537,2,2993,'App\\Models\\Receipt',2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',7100.60,NULL,NULL,1,'2023-05-22 09:59:53','2023-05-22 09:59:53',NULL),(3268,7749,40720,1537,2,2994,'App\\Models\\Receipt',2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',5600.00,NULL,NULL,1,'2023-05-22 09:59:54','2023-05-22 09:59:54',NULL),(3269,7749,40720,1537,2,2995,'App\\Models\\Receipt',2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',20950.00,NULL,NULL,1,'2023-05-22 09:59:54','2023-05-22 09:59:54',NULL),(3270,7749,40720,1537,2,2996,'App\\Models\\Receipt',2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',22699.99,NULL,NULL,1,'2023-05-22 09:59:54','2023-05-22 09:59:54',NULL),(3271,7749,40720,1537,2,2997,'App\\Models\\Receipt',2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',5050.00,NULL,NULL,1,'2023-05-22 09:59:54','2023-05-22 09:59:54',NULL),(3272,7749,40720,1537,2,2998,'App\\Models\\Receipt',2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',12440.00,NULL,NULL,1,'2023-05-22 09:59:54','2023-05-22 09:59:54',NULL),(3273,7749,40720,1537,2,2999,'App\\Models\\Receipt',2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',3900.00,NULL,NULL,1,'2023-05-22 09:59:54','2023-05-22 09:59:54',NULL),(3274,7749,40720,1537,2,3000,'App\\Models\\Receipt',3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',9900.00,NULL,NULL,1,'2023-05-22 09:59:54','2023-05-22 09:59:54',NULL),(3275,7749,40720,1537,2,3001,'App\\Models\\Receipt',3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',12150.00,NULL,NULL,1,'2023-05-22 09:59:54','2023-05-22 09:59:54',NULL),(3276,7749,40720,1537,2,3002,'App\\Models\\Receipt',3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',37620.00,NULL,NULL,1,'2023-05-22 09:59:54','2023-05-22 09:59:54',NULL),(3277,7749,40720,1537,2,3003,'App\\Models\\Receipt',3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',38980.00,NULL,NULL,1,'2023-05-22 09:59:54','2023-05-22 09:59:54',NULL),(3278,7749,40720,1537,2,3004,'App\\Models\\Receipt',3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',5200.00,NULL,NULL,1,'2023-05-22 09:59:54','2023-05-22 09:59:54',NULL),(3279,7749,40720,1537,2,3005,'App\\Models\\Receipt',3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',59600.00,NULL,NULL,1,'2023-05-22 09:59:54','2023-05-22 09:59:54',NULL),(3280,7749,40720,1537,2,3006,'App\\Models\\Receipt',3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',117059.99,NULL,NULL,1,'2023-05-22 09:59:54','2023-05-22 09:59:54',NULL),(3281,7749,40720,1537,2,3007,'App\\Models\\Receipt',3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',106000.00,NULL,NULL,1,'2023-05-22 09:59:54','2023-05-22 09:59:54',NULL),(3282,7749,40720,1537,2,3008,'App\\Models\\Receipt',3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',16600.00,NULL,NULL,1,'2023-05-22 09:59:54','2023-05-22 09:59:54',NULL),(3283,7749,40720,1537,2,3009,'App\\Models\\Receipt',3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',22600.00,NULL,NULL,1,'2023-05-22 09:59:54','2023-05-22 09:59:54',NULL);
INSERT INTO `balance_libro` VALUES (3284,7749,40720,1537,2,3010,'App\\Models\\Receipt',3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',25910.00,NULL,NULL,1,'2023-05-22 09:59:54','2023-05-22 09:59:54',NULL),(3285,7749,40720,1537,2,3011,'App\\Models\\Receipt',3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',35999.99,NULL,NULL,1,'2023-05-22 09:59:55','2023-05-22 09:59:55',NULL),(3286,7749,40720,1537,2,3012,'App\\Models\\Receipt',3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',95590.00,NULL,NULL,1,'2023-05-22 09:59:55','2023-05-22 09:59:55',NULL),(3287,7749,40720,1537,2,3013,'App\\Models\\Receipt',3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',14700.00,NULL,NULL,1,'2023-05-22 09:59:55','2023-05-22 09:59:55',NULL),(3288,7749,40720,1537,2,3014,'App\\Models\\Receipt',3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',100870.00,NULL,NULL,1,'2023-05-22 09:59:55','2023-05-22 09:59:55',NULL),(3289,7749,40720,1537,2,3015,'App\\Models\\Receipt',3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',5100.00,NULL,NULL,1,'2023-05-22 09:59:55','2023-05-22 09:59:55',NULL),(3290,7749,40720,1537,2,3016,'App\\Models\\Receipt',3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',1400.00,NULL,NULL,1,'2023-05-22 09:59:55','2023-05-22 09:59:55',NULL),(3291,7749,40720,1537,2,3017,'App\\Models\\Receipt',3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',85000.00,NULL,NULL,1,'2023-05-22 09:59:55','2023-05-22 09:59:55',NULL),(3292,7749,40720,1537,2,3018,'App\\Models\\Receipt',3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',24000.00,NULL,NULL,1,'2023-05-22 09:59:55','2023-05-22 09:59:55',NULL),(3293,7749,40720,1537,2,3019,'App\\Models\\Receipt',3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',21100.00,NULL,NULL,1,'2023-05-22 09:59:55','2023-05-22 09:59:55',NULL),(3294,7749,40720,1537,2,3020,'App\\Models\\Receipt',3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',46650.02,NULL,NULL,1,'2023-05-22 09:59:55','2023-05-22 09:59:55',NULL),(3295,7749,40720,1537,2,3021,'App\\Models\\Receipt',3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',5100.00,NULL,NULL,1,'2023-05-22 09:59:55','2023-05-22 09:59:55',NULL),(3296,7749,40720,1537,3,3022,'App\\Models\\Receipt',3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',65476.51,NULL,NULL,1,'2023-05-22 10:00:07','2023-05-22 10:00:07',NULL),(3297,7749,40720,1537,3,3023,'App\\Models\\Receipt',3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',12385.27,NULL,NULL,1,'2023-05-22 10:00:07','2023-05-22 10:00:07',NULL),(3298,7749,40720,1537,2,3024,'App\\Models\\Receipt',3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',3499.95,NULL,NULL,1,'2023-05-22 10:39:39','2023-05-22 12:04:17','2023-05-22 12:04:17'),(3299,7749,40720,1537,2,3025,'App\\Models\\Receipt',3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',6199.98,NULL,NULL,1,'2023-05-22 10:39:39','2023-05-22 12:04:50','2023-05-22 12:04:50'),(3300,7749,40720,1537,2,3026,'App\\Models\\Receipt',3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',7049.98,NULL,NULL,1,'2023-05-22 10:39:39','2023-05-22 12:06:34','2023-05-22 12:06:34'),(3301,7749,40720,1537,2,3027,'App\\Models\\Receipt',3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',5050.02,NULL,NULL,1,'2023-05-22 10:39:39','2023-05-22 12:06:55','2023-05-22 12:06:55'),(3302,7749,40720,1537,2,3028,'App\\Models\\Receipt',3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',14599.98,NULL,NULL,1,'2023-05-22 10:39:39','2023-05-22 12:07:17','2023-05-22 12:07:17'),(3303,7749,40720,1537,2,3029,'App\\Models\\Receipt',3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',3999.97,NULL,NULL,1,'2023-05-22 10:39:39','2023-05-22 12:07:57','2023-05-22 12:07:57');
INSERT INTO `balance_libro` VALUES (3304,7749,40720,1537,2,3030,'App\\Models\\Receipt',3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-21','2023-05-21',15169.94,NULL,NULL,1,'2023-05-22 10:39:40','2023-05-22 10:39:40',NULL),(3305,7749,40720,1537,2,3031,'App\\Models\\Receipt',3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',1199.97,NULL,NULL,1,'2023-05-22 10:40:07','2023-05-22 10:40:07',NULL),(3306,7749,40720,1537,2,3032,'App\\Models\\Receipt',3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',2299.98,NULL,NULL,1,'2023-05-22 10:40:07','2023-05-22 10:40:07',NULL),(3307,7749,40720,1537,2,3033,'App\\Models\\Receipt',3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',1500.00,NULL,NULL,1,'2023-05-22 10:40:07','2023-05-22 10:40:07',NULL),(3308,7749,40720,1537,2,3034,'App\\Models\\Receipt',3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',4699.99,NULL,NULL,1,'2023-05-22 10:40:07','2023-05-22 10:40:07',NULL),(3309,7749,40720,1537,2,3035,'App\\Models\\Receipt',3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',3750.02,NULL,NULL,1,'2023-05-22 10:40:07','2023-05-22 10:40:07',NULL),(3310,7749,40720,1537,2,3036,'App\\Models\\Receipt',3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',2499.98,NULL,NULL,1,'2023-05-22 10:40:07','2023-05-22 10:40:07',NULL),(3311,7749,40720,1537,2,3037,'App\\Models\\Receipt',3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',799.98,NULL,NULL,1,'2023-05-22 10:40:07','2023-05-22 10:40:07',NULL),(3312,7749,40720,1537,2,3038,'App\\Models\\Receipt',3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',1100.01,NULL,NULL,1,'2023-05-22 10:40:07','2023-05-22 10:40:07',NULL),(3313,7749,40720,1537,2,3039,'App\\Models\\Receipt',3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',1449.98,NULL,NULL,1,'2023-05-22 10:40:07','2023-05-22 10:40:07',NULL),(3314,7749,40720,1537,2,3040,'App\\Models\\Receipt',3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',500.02,NULL,NULL,1,'2023-05-22 10:40:07','2023-05-22 10:40:07',NULL),(3315,7749,40720,1537,2,3041,'App\\Models\\Receipt',3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',2000.01,NULL,NULL,1,'2023-05-22 10:40:07','2023-05-22 10:40:07',NULL),(3316,7749,40720,1537,2,3042,'App\\Models\\Receipt',3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',7499.98,NULL,NULL,1,'2023-05-22 10:40:07','2023-05-22 10:40:07',NULL),(3317,7749,40720,1537,2,3043,'App\\Models\\Receipt',3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',7099.99,NULL,NULL,1,'2023-05-22 10:40:08','2023-05-22 10:40:08',NULL),(3318,7749,40720,1537,2,3044,'App\\Models\\Receipt',3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',3999.97,NULL,NULL,1,'2023-05-22 10:40:08','2023-05-22 10:40:08',NULL),(3319,7749,40720,1537,2,3045,'App\\Models\\Receipt',3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',29349.99,NULL,NULL,1,'2023-05-22 11:54:10','2023-05-22 11:55:14','2023-05-22 11:55:14'),(3320,7749,40720,1537,2,3046,'App\\Models\\Receipt',3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',20000.03,NULL,NULL,1,'2023-05-22 11:54:10','2023-05-22 11:55:39','2023-05-22 11:55:39'),(3321,7749,40720,1537,2,3047,'App\\Models\\Receipt',3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',21349.99,NULL,NULL,1,'2023-05-22 11:54:11','2023-05-22 11:57:35','2023-05-22 11:57:35'),(3322,7749,40720,1537,2,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',28079.95,NULL,NULL,1,'2023-05-22 11:54:11','2023-05-22 11:58:48','2023-05-22 11:58:48'),(3323,7749,40720,1537,2,3049,'App\\Models\\Receipt',3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',21499.97,NULL,NULL,1,'2023-05-22 11:54:11','2023-05-22 11:59:09','2023-05-22 11:59:09');
INSERT INTO `balance_libro` VALUES (3324,7749,40720,1537,2,3050,'App\\Models\\Receipt',3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',1350.01,NULL,NULL,1,'2023-05-22 11:54:29','2023-05-22 11:54:29',NULL),(3325,7749,40720,1537,2,3051,'App\\Models\\Receipt',3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',27999.98,NULL,NULL,1,'2023-05-22 11:54:29','2023-05-22 11:54:29',NULL),(3326,7749,40720,1537,2,3052,'App\\Models\\Receipt',3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',4499.99,NULL,NULL,1,'2023-05-22 11:54:29','2023-05-22 11:54:29',NULL),(3327,7749,40720,1537,2,3053,'App\\Models\\Receipt',3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',7200.02,NULL,NULL,1,'2023-05-22 11:54:29','2023-05-22 11:54:29',NULL),(3328,7749,40720,1537,2,3054,'App\\Models\\Receipt',3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',700.01,NULL,NULL,1,'2023-05-22 11:54:29','2023-05-22 11:54:29',NULL),(3329,7749,40720,1537,2,3055,'App\\Models\\Receipt',3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',7600.01,NULL,NULL,1,'2023-05-22 11:54:29','2023-05-22 11:54:29',NULL),(3330,7749,40720,1537,2,3056,'App\\Models\\Receipt',3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',8149.98,NULL,NULL,1,'2023-05-22 11:54:29','2023-05-22 11:54:29',NULL),(3331,7749,40720,1537,2,3057,'App\\Models\\Receipt',3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',13200.01,NULL,NULL,1,'2023-05-22 11:54:29','2023-05-22 11:54:29',NULL),(3332,7749,40720,1537,2,3058,'App\\Models\\Receipt',3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',5099.98,NULL,NULL,1,'2023-05-22 11:54:29','2023-05-22 11:54:29',NULL),(3333,7749,40720,1537,2,3059,'App\\Models\\Receipt',3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',17379.98,NULL,NULL,1,'2023-05-22 11:54:29','2023-05-22 11:54:29',NULL),(3334,7749,40720,1537,2,3060,'App\\Models\\Receipt',3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',5600.00,NULL,NULL,1,'2023-05-22 11:54:29','2023-05-22 11:54:29',NULL),(3335,7749,40720,1537,2,3061,'App\\Models\\Receipt',3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',21499.97,NULL,NULL,1,'2023-05-22 11:54:29','2023-05-22 11:54:29',NULL),(3336,7749,40720,1537,2,3045,'App\\Models\\Receipt',3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',135640.00,NULL,NULL,1,'2023-05-22 11:55:14','2023-05-22 11:55:14',NULL),(3337,7749,40720,1537,2,3046,'App\\Models\\Receipt',3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',108280.00,NULL,NULL,1,'2023-05-22 11:55:39','2023-05-22 11:55:39',NULL),(3338,7749,40720,1537,2,3047,'App\\Models\\Receipt',3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',123270.00,NULL,NULL,1,'2023-05-22 11:57:35','2023-05-22 11:57:35',NULL),(3339,7749,40720,1537,2,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',215494.98,NULL,NULL,1,'2023-05-22 11:58:48','2023-05-22 11:58:48',NULL),(3340,7749,40720,1537,2,3049,'App\\Models\\Receipt',3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',162360.00,NULL,NULL,1,'2023-05-22 11:59:09','2023-05-22 11:59:09',NULL),(3341,7749,40720,1537,2,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',107920.00,NULL,NULL,1,'2023-05-22 11:59:32','2023-05-22 11:59:32',NULL),(3342,7749,40720,1537,2,3062,'App\\Models\\Receipt',3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',217429.99,NULL,NULL,1,'2023-05-22 12:00:42','2023-05-22 12:00:42',NULL),(3343,7749,40720,1537,2,3063,'App\\Models\\Receipt',3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',156547.93,NULL,NULL,1,'2023-05-22 12:02:27','2023-05-22 12:02:27',NULL),(3344,7749,40720,1537,2,3064,'App\\Models\\Receipt',3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',147530.00,NULL,NULL,1,'2023-05-22 12:03:27','2023-05-22 12:03:27',NULL);
INSERT INTO `balance_libro` VALUES (3345,7749,40720,1537,2,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',124079.99,NULL,NULL,1,'2023-05-22 12:03:46','2023-05-22 12:03:46',NULL),(3346,7749,40720,1537,2,3024,'App\\Models\\Receipt',3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',76870.01,NULL,NULL,1,'2023-05-22 12:04:17','2023-05-22 12:04:17',NULL),(3347,7749,40720,1537,2,3025,'App\\Models\\Receipt',3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',99699.99,NULL,NULL,1,'2023-05-22 12:04:50','2023-05-22 12:04:50',NULL),(3348,7749,40720,1537,2,3026,'App\\Models\\Receipt',3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',113040.00,NULL,NULL,1,'2023-05-22 12:06:34','2023-05-22 12:06:34',NULL),(3349,7749,40720,1537,2,3027,'App\\Models\\Receipt',3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',119870.01,NULL,NULL,1,'2023-05-22 12:06:55','2023-05-22 12:06:55',NULL),(3350,7749,40720,1537,2,3028,'App\\Models\\Receipt',3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',136269.99,NULL,NULL,1,'2023-05-22 12:07:17','2023-05-22 12:07:17',NULL),(3351,7749,40720,1537,2,3029,'App\\Models\\Receipt',3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',143840.00,NULL,NULL,1,'2023-05-22 12:07:57','2023-05-22 12:07:57',NULL),(3352,7749,40719,20,2,3065,'App\\Models\\Receipt',3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',140000.00,NULL,NULL,1,'2023-05-23 10:24:00','2023-05-23 10:24:00',NULL),(3353,7749,40719,21,2,3066,'App\\Models\\Receipt',3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',140000.00,NULL,NULL,1,'2023-05-23 10:24:20','2023-05-23 10:24:20',NULL),(3354,7749,40719,22,2,3067,'App\\Models\\Receipt',3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',160000.00,NULL,NULL,1,'2023-05-23 10:24:44','2023-05-23 10:24:44',NULL),(3355,7749,40719,22,2,3068,'App\\Models\\Receipt',3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',200000.00,NULL,NULL,1,'2023-05-23 10:27:47','2023-05-23 10:27:47',NULL),(3356,7749,40720,1537,2,3069,'App\\Models\\Receipt',3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',138000.00,NULL,NULL,1,'2023-05-29 10:41:53','2023-05-29 10:41:53',NULL),(3357,7749,40720,1537,3,3070,'App\\Models\\Receipt',3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',4728.12,NULL,NULL,1,'2023-05-29 10:42:27','2023-06-15 12:40:11','2023-06-15 12:40:11'),(3358,7749,40720,1537,3,3071,'App\\Models\\Receipt',3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',160000.00,NULL,NULL,1,'2023-05-29 10:42:27','2023-05-29 10:42:27',NULL),(3359,7749,40720,1537,3,3072,'App\\Models\\Receipt',3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',200000.00,NULL,NULL,1,'2023-05-29 10:42:27','2023-05-29 10:42:27',NULL),(3360,7749,40720,1537,3,3073,'App\\Models\\Receipt',3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',36158.62,NULL,NULL,1,'2023-05-29 10:42:27','2023-05-29 10:42:27',NULL),(3361,7749,40720,1537,3,3074,'App\\Models\\Receipt',3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',166195.44,NULL,NULL,1,'2023-05-29 10:42:27','2023-05-29 10:42:27',NULL),(3362,7749,40720,1537,3,3075,'App\\Models\\Receipt',3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',240853.36,NULL,NULL,1,'2023-05-29 10:42:27','2023-05-29 10:42:27',NULL),(3363,7749,40720,1537,3,3076,'App\\Models\\Receipt',3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',46405.68,NULL,NULL,1,'2023-05-29 10:42:27','2023-05-29 10:42:27',NULL),(3364,7749,40720,1537,3,3077,'App\\Models\\Receipt',3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',35135.06,NULL,NULL,1,'2023-05-29 10:42:27','2023-05-29 10:42:27',NULL);
INSERT INTO `balance_libro` VALUES (3365,7749,40720,1537,3,3078,'App\\Models\\Receipt',3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',210675.84,NULL,NULL,1,'2023-05-29 10:42:27','2023-06-16 11:17:48','2023-06-16 11:17:48'),(3366,7749,40720,1537,3,3079,'App\\Models\\Receipt',3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',411180.90,NULL,NULL,1,'2023-05-29 10:42:27','2023-06-16 11:17:36','2023-06-16 11:17:36'),(3367,7749,40720,1537,3,3080,'App\\Models\\Receipt',3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',146446.80,NULL,NULL,1,'2023-05-29 10:42:27','2023-06-16 11:17:19','2023-06-16 11:17:19'),(3368,7749,40720,1537,3,3081,'App\\Models\\Receipt',3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',14654.46,NULL,NULL,1,'2023-05-29 10:42:27','2023-06-16 11:17:08','2023-06-16 11:17:08'),(3369,7749,40720,1537,3,3082,'App\\Models\\Receipt',3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',47976.06,NULL,NULL,1,'2023-05-29 10:42:27','2023-05-29 10:42:27',NULL),(3370,7749,40720,1537,3,3083,'App\\Models\\Receipt',3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',84395.78,NULL,NULL,1,'2023-05-29 10:42:27','2023-05-29 10:42:27',NULL),(3371,7749,40720,1537,3,3084,'App\\Models\\Receipt',3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',122025.49,NULL,NULL,1,'2023-05-29 10:42:28','2023-05-29 10:42:28',NULL),(3372,7749,40720,1537,3,3085,'App\\Models\\Receipt',3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',32942.10,NULL,NULL,1,'2023-05-29 10:42:28','2023-05-29 10:42:28',NULL),(3373,7749,40720,1537,3,3086,'App\\Models\\Receipt',3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',64213.24,NULL,NULL,1,'2023-05-29 10:42:28','2023-05-29 10:42:28',NULL),(3374,7749,40720,1537,3,3087,'App\\Models\\Receipt',3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',10891.60,NULL,NULL,1,'2023-05-29 10:42:28','2023-05-29 10:42:28',NULL),(3375,7749,40720,1537,3,3088,'App\\Models\\Receipt',3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',79348.49,NULL,NULL,1,'2023-05-29 10:42:28','2023-05-29 10:42:28',NULL),(3376,7749,40720,1537,3,3089,'App\\Models\\Receipt',3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',13969.64,NULL,NULL,1,'2023-05-29 10:42:28','2023-05-29 10:42:28',NULL),(3377,7749,40720,1537,3,3090,'App\\Models\\Receipt',3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',36628.71,NULL,NULL,1,'2023-05-29 10:42:28','2023-05-29 10:42:28',NULL),(3378,7749,40720,1537,3,3091,'App\\Models\\Receipt',3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',104222.77,NULL,NULL,1,'2023-05-29 10:42:28','2023-05-29 10:42:28',NULL),(3379,7749,40720,1537,3,3092,'App\\Models\\Receipt',3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',75481.60,NULL,NULL,1,'2023-05-29 10:42:28','2023-05-29 10:42:28',NULL),(3380,7749,40720,1537,3,3093,'App\\Models\\Receipt',3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',30475.25,NULL,NULL,1,'2023-05-29 10:42:28','2023-05-29 10:42:28',NULL),(3381,7749,40720,1537,3,3094,'App\\Models\\Receipt',3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',47342.86,NULL,NULL,1,'2023-05-29 10:42:28','2023-05-29 10:42:28',NULL),(3382,7749,40720,1537,3,3095,'App\\Models\\Receipt',3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',35273.60,NULL,NULL,1,'2023-05-29 10:42:28','2023-05-29 10:42:28',NULL),(3383,7749,40720,1537,3,3096,'App\\Models\\Receipt',3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',13261.19,NULL,NULL,1,'2023-05-29 10:42:28','2023-05-29 10:42:28',NULL),(3384,7749,40720,1537,3,3097,'App\\Models\\Receipt',3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',31668.04,NULL,NULL,1,'2023-05-29 10:42:28','2023-05-29 10:42:28',NULL);
INSERT INTO `balance_libro` VALUES (3385,7749,40720,1537,3,3098,'App\\Models\\Receipt',3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',28905.28,NULL,NULL,1,'2023-05-29 10:42:28','2023-06-15 12:51:53','2023-06-15 12:51:53'),(3386,7749,40720,1537,2,3099,'App\\Models\\Receipt',3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',13650.00,NULL,NULL,1,'2023-05-31 10:42:07','2023-05-31 10:42:07',NULL),(3387,7749,40720,1537,2,3100,'App\\Models\\Receipt',3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',58000.00,NULL,NULL,1,'2023-05-31 10:42:07','2023-05-31 10:42:07',NULL),(3388,7749,40720,1537,2,3101,'App\\Models\\Receipt',3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',58000.00,NULL,NULL,1,'2023-05-31 10:42:07','2023-05-31 10:42:07',NULL),(3389,7749,40720,1537,2,3102,'App\\Models\\Receipt',3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',58000.00,NULL,NULL,1,'2023-05-31 10:42:07','2023-05-31 10:42:07',NULL),(3390,7749,40720,1537,3,3103,'App\\Models\\Receipt',3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',16214.94,NULL,NULL,1,'2023-05-31 10:42:23','2023-05-31 10:42:23',NULL),(3391,7749,40720,1537,3,3104,'App\\Models\\Receipt',3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',149909.03,NULL,NULL,1,'2023-05-31 10:42:23','2023-05-31 10:42:23',NULL),(3392,7749,40720,1537,3,3105,'App\\Models\\Receipt',3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',446249.62,NULL,NULL,1,'2023-05-31 10:42:23','2023-05-31 10:42:23',NULL),(3393,7749,40720,1537,3,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',67314.10,NULL,NULL,1,'2023-05-31 10:42:23','2023-06-15 12:52:44','2023-06-15 12:52:44'),(3394,7749,40720,1537,3,3107,'App\\Models\\Receipt',3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',272474.67,NULL,NULL,1,'2023-05-31 10:42:23','2023-05-31 10:42:23',NULL),(3395,7749,40720,1537,3,3108,'App\\Models\\Receipt',3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',110673.80,NULL,NULL,1,'2023-05-31 10:42:23','2023-05-31 10:42:23',NULL),(3396,7749,40720,1537,3,3109,'App\\Models\\Receipt',3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',10182.39,NULL,NULL,1,'2023-05-31 10:42:23','2023-05-31 10:42:23',NULL),(3397,7749,40720,1537,3,3110,'App\\Models\\Receipt',3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',40716.14,NULL,NULL,1,'2023-05-31 10:42:23','2023-05-31 10:42:23',NULL),(3398,7749,40720,1537,3,3111,'App\\Models\\Receipt',3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',36718.38,NULL,NULL,1,'2023-05-31 10:42:23','2023-05-31 10:42:23',NULL),(3399,7749,40720,1537,3,3112,'App\\Models\\Receipt',3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',72737.27,NULL,NULL,1,'2023-05-31 10:42:23','2023-05-31 10:42:23',NULL),(3400,7749,40720,1537,3,3113,'App\\Models\\Receipt',3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',0.00,NULL,NULL,1,'2023-05-31 10:42:23','2023-05-31 10:42:23',NULL),(3401,7749,40720,1537,3,3114,'App\\Models\\Receipt',3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',133975.89,NULL,NULL,1,'2023-05-31 10:42:23','2023-05-31 10:42:23',NULL),(3402,7749,40720,1537,2,3115,'App\\Models\\Receipt',3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1523000.01,NULL,NULL,1,'2023-06-02 10:32:36','2023-06-02 10:32:36',NULL),(3403,7749,40720,1537,2,3116,'App\\Models\\Receipt',3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',152180.00,NULL,NULL,1,'2023-06-02 10:32:36','2023-06-02 10:32:36',NULL),(3404,7749,40720,1537,3,3117,'App\\Models\\Receipt',3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',271189.00,NULL,NULL,1,'2023-06-02 10:32:49','2023-06-16 10:55:36','2023-06-16 10:55:36');
INSERT INTO `balance_libro` VALUES (3405,7749,40720,1537,3,3118,'App\\Models\\Receipt',3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',21028.02,NULL,NULL,1,'2023-06-02 10:32:49','2023-06-02 10:32:49',NULL),(3406,7749,40720,1537,3,3119,'App\\Models\\Receipt',3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',120388.80,NULL,NULL,1,'2023-06-02 10:32:49','2023-06-15 12:56:06','2023-06-15 12:56:06'),(3407,7749,40720,1537,3,3120,'App\\Models\\Receipt',3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',18149.34,NULL,NULL,1,'2023-06-02 10:32:49','2023-06-02 10:32:49',NULL),(3408,7749,40720,1537,3,3121,'App\\Models\\Receipt',3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',19266.33,NULL,NULL,1,'2023-06-02 10:32:49','2023-06-02 10:32:49',NULL),(3409,7749,40720,1537,3,3122,'App\\Models\\Receipt',3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',11791.81,NULL,NULL,1,'2023-06-02 10:32:49','2023-06-02 10:32:49',NULL),(3410,7749,40720,1537,3,3123,'App\\Models\\Receipt',3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',72917.12,NULL,NULL,1,'2023-06-02 10:32:49','2023-06-02 10:32:49',NULL),(3411,7749,40720,1537,2,3124,'App\\Models\\Receipt',3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',16040.05,NULL,NULL,1,'2023-06-13 17:47:58','2023-06-13 17:48:53','2023-06-13 17:48:53'),(3412,7749,40720,1537,2,3125,'App\\Models\\Receipt',3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',9890.02,NULL,NULL,1,'2023-06-13 17:47:58','2023-06-13 17:49:11','2023-06-13 17:49:11'),(3413,7749,40720,1537,2,3126,'App\\Models\\Receipt',3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',2649.96,NULL,NULL,1,'2023-06-13 17:47:58','2023-06-13 17:49:29','2023-06-13 17:49:29'),(3414,7749,40720,1537,2,3127,'App\\Models\\Receipt',3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',69380.02,NULL,NULL,1,'2023-06-13 17:47:58','2023-06-13 17:47:58',NULL),(3415,7749,40720,1537,2,3128,'App\\Models\\Receipt',3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',11199.99,NULL,NULL,1,'2023-06-13 17:47:58','2023-06-13 17:50:25','2023-06-13 17:50:25'),(3416,7749,40720,1537,2,3129,'App\\Models\\Receipt',3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',13999.99,NULL,NULL,1,'2023-06-13 17:47:58','2023-06-13 17:50:55','2023-06-13 17:50:55'),(3417,7749,40720,1537,2,3130,'App\\Models\\Receipt',3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',4299.99,NULL,NULL,1,'2023-06-13 17:47:58','2023-06-13 17:51:13','2023-06-13 17:51:13'),(3418,7749,40720,1537,2,3131,'App\\Models\\Receipt',3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',12600.02,NULL,NULL,1,'2023-06-13 17:47:58','2023-06-13 17:51:33','2023-06-13 17:51:33'),(3419,7749,40720,1537,2,3132,'App\\Models\\Receipt',3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',12250.04,NULL,NULL,1,'2023-06-13 17:47:58','2023-06-13 17:51:55','2023-06-13 17:51:55'),(3420,7749,40720,1537,2,3133,'App\\Models\\Receipt',3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',6890.03,NULL,NULL,1,'2023-06-13 17:48:15','2023-06-13 17:48:15',NULL),(3421,7749,40720,1537,2,3134,'App\\Models\\Receipt',3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',3750.02,NULL,NULL,1,'2023-06-13 17:48:15','2023-06-13 17:48:15',NULL),(3422,7749,40720,1537,2,3135,'App\\Models\\Receipt',3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',1899.99,NULL,NULL,1,'2023-06-13 17:48:15','2023-06-13 17:48:15',NULL),(3423,7749,40720,1537,2,3136,'App\\Models\\Receipt',3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',3500.01,NULL,NULL,1,'2023-06-13 17:48:15','2023-06-13 17:48:15',NULL),(3424,7749,40720,1537,2,3137,'App\\Models\\Receipt',3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',3700.01,NULL,NULL,1,'2023-06-13 17:48:15','2023-06-13 17:48:15',NULL);
INSERT INTO `balance_libro` VALUES (3425,7749,40720,1537,2,3138,'App\\Models\\Receipt',3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',4119.99,NULL,NULL,1,'2023-06-13 17:48:15','2023-06-13 17:48:15',NULL),(3426,7749,40720,1537,2,3139,'App\\Models\\Receipt',3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',2070.02,NULL,NULL,1,'2023-06-13 17:48:15','2023-06-13 17:48:15',NULL),(3427,7749,40720,1537,2,3140,'App\\Models\\Receipt',3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',1649.98,NULL,NULL,1,'2023-06-13 17:48:15','2023-06-13 17:48:15',NULL),(3428,7749,40720,1537,2,3141,'App\\Models\\Receipt',3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',999.98,NULL,NULL,1,'2023-06-13 17:48:15','2023-06-13 17:48:15',NULL),(3429,7749,40720,1537,2,3142,'App\\Models\\Receipt',3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',9500.00,NULL,NULL,1,'2023-06-13 17:48:15','2023-06-13 17:48:15',NULL),(3430,7749,40720,1537,2,3143,'App\\Models\\Receipt',3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',1699.99,NULL,NULL,1,'2023-06-13 17:48:15','2023-06-13 17:48:15',NULL),(3431,7749,40720,1537,2,3144,'App\\Models\\Receipt',3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',13999.99,NULL,NULL,1,'2023-06-13 17:48:15','2023-06-13 17:48:15',NULL),(3432,7749,40720,1537,2,3145,'App\\Models\\Receipt',3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',500.02,NULL,NULL,1,'2023-06-13 17:48:15','2023-06-13 17:48:15',NULL),(3433,7749,40720,1537,2,3146,'App\\Models\\Receipt',3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',2299.98,NULL,NULL,1,'2023-06-13 17:48:16','2023-06-13 17:48:16',NULL),(3434,7749,40720,1537,2,3147,'App\\Models\\Receipt',3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',1500.00,NULL,NULL,1,'2023-06-13 17:48:16','2023-06-13 17:48:16',NULL),(3435,7749,40720,1537,2,3148,'App\\Models\\Receipt',3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',5000.01,NULL,NULL,1,'2023-06-13 17:48:16','2023-06-13 17:48:16',NULL),(3436,7749,40720,1537,2,3149,'App\\Models\\Receipt',3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',6199.98,NULL,NULL,1,'2023-06-13 17:48:16','2023-06-13 17:48:16',NULL),(3437,7749,40720,1537,2,3150,'App\\Models\\Receipt',3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1400.03,NULL,NULL,1,'2023-06-13 17:48:16','2023-06-13 17:48:16',NULL),(3438,7749,40720,1537,2,3151,'App\\Models\\Receipt',3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',8050.01,NULL,NULL,1,'2023-06-13 17:48:16','2023-06-13 17:48:16',NULL),(3439,7749,40720,1537,2,3152,'App\\Models\\Receipt',3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',4200.03,NULL,NULL,1,'2023-06-13 17:48:16','2023-06-13 17:48:16',NULL),(3440,7749,40720,1537,2,3124,'App\\Models\\Receipt',3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',117890.00,NULL,NULL,1,'2023-06-13 17:48:53','2023-06-13 17:48:53',NULL),(3441,7749,40720,1537,2,3125,'App\\Models\\Receipt',3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',137817.50,NULL,NULL,1,'2023-06-13 17:49:11','2023-06-13 17:49:11',NULL),(3442,7749,40720,1537,2,3126,'App\\Models\\Receipt',3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',117005.00,NULL,NULL,1,'2023-06-13 17:49:29','2023-06-13 17:49:29',NULL),(3443,7749,40720,1537,2,3128,'App\\Models\\Receipt',3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',178049.89,NULL,NULL,1,'2023-06-13 17:50:25','2023-06-13 17:50:25',NULL),(3444,7749,40720,1537,2,3129,'App\\Models\\Receipt',3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',120773.00,NULL,NULL,1,'2023-06-13 17:50:55','2023-06-13 17:50:55',NULL),(3445,7749,40720,1537,2,3130,'App\\Models\\Receipt',3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',129580.00,NULL,NULL,1,'2023-06-13 17:51:13','2023-06-13 17:51:13',NULL);
INSERT INTO `balance_libro` VALUES (3446,7749,40720,1537,2,3131,'App\\Models\\Receipt',3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',127239.99,NULL,NULL,1,'2023-06-13 17:51:33','2023-06-13 17:51:33',NULL),(3447,7749,40720,1537,2,3132,'App\\Models\\Receipt',3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',120430.01,NULL,NULL,1,'2023-06-13 17:51:55','2023-06-13 17:51:55',NULL),(3448,7749,40720,1537,3,2942,'App\\Models\\Receipt',2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',253563.98,NULL,NULL,1,'2023-06-15 12:12:10','2023-06-15 12:12:10',NULL),(3449,7749,40720,1537,3,2947,'App\\Models\\Receipt',2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',132655.24,NULL,NULL,1,'2023-06-15 12:13:40','2023-06-15 12:13:40',NULL),(3450,7749,40720,1537,3,3153,'App\\Models\\Receipt',3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',26511.60,NULL,NULL,1,'2023-06-15 12:15:05','2023-06-15 12:15:05',NULL),(3451,7749,40720,1537,3,3154,'App\\Models\\Receipt',3154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',12062.77,NULL,NULL,1,'2023-06-15 12:18:30','2023-06-15 12:18:30',NULL),(3452,7749,40720,1537,3,2953,'App\\Models\\Receipt',2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',92783.77,NULL,NULL,1,'2023-06-15 12:18:59','2023-06-15 12:18:59',NULL),(3453,7749,40720,1537,3,2954,'App\\Models\\Receipt',2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',76093.42,NULL,NULL,1,'2023-06-15 12:19:15','2023-06-15 12:19:15',NULL),(3454,7749,40720,1537,3,3155,'App\\Models\\Receipt',3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',13300.07,NULL,NULL,1,'2023-06-15 12:21:08','2023-06-15 12:21:08',NULL),(3455,7749,40720,1537,3,3156,'App\\Models\\Receipt',3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',27669.42,NULL,NULL,1,'2023-06-15 12:22:50','2023-06-15 12:22:50',NULL),(3456,7749,40720,1537,3,3157,'App\\Models\\Receipt',3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',7274.51,NULL,NULL,1,'2023-06-15 12:23:22','2023-06-15 12:23:22',NULL),(3457,7749,40720,1537,3,3158,'App\\Models\\Receipt',3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',79783.64,NULL,NULL,1,'2023-06-15 12:23:45','2023-06-15 12:23:45',NULL),(3458,7749,40720,1537,3,2961,'App\\Models\\Receipt',2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',23113.54,NULL,NULL,1,'2023-06-15 12:25:04','2023-06-15 12:25:04',NULL),(3459,7749,40720,1537,3,3159,'App\\Models\\Receipt',3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',7114.58,NULL,NULL,1,'2023-06-15 12:26:46','2023-06-15 12:26:46',NULL),(3460,7749,40720,1537,3,3160,'App\\Models\\Receipt',3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',6000.00,NULL,NULL,1,'2023-06-15 12:28:07','2023-06-15 12:28:07',NULL),(3461,7749,40720,1537,3,2969,'App\\Models\\Receipt',2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',381495.93,NULL,NULL,1,'2023-06-15 12:30:32','2023-06-15 12:30:32',NULL),(3462,7749,40720,1537,3,3161,'App\\Models\\Receipt',3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',6000.81,NULL,NULL,1,'2023-06-15 12:31:44','2023-06-15 12:31:44',NULL),(3463,7749,40720,1537,3,2973,'App\\Models\\Receipt',2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',142589.39,NULL,NULL,1,'2023-06-15 12:32:49','2023-06-15 12:32:49',NULL),(3464,7749,40720,1537,3,2974,'App\\Models\\Receipt',2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',87339.75,NULL,NULL,1,'2023-06-15 12:33:22','2023-06-15 12:33:22',NULL),(3465,7749,40720,1537,3,2975,'App\\Models\\Receipt',2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',9626.03,NULL,NULL,1,'2023-06-15 12:33:44','2023-06-15 12:33:44',NULL),(3466,7749,40720,1537,3,2978,'App\\Models\\Receipt',2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',343484.55,NULL,NULL,1,'2023-06-15 12:34:49','2023-06-15 12:34:49',NULL);
INSERT INTO `balance_libro` VALUES (3467,7749,40720,1537,3,2967,'App\\Models\\Receipt',2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',91800.00,NULL,NULL,1,'2023-06-15 12:35:05','2023-06-15 12:35:05',NULL),(3468,7749,40720,1537,3,2980,'App\\Models\\Receipt',2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',140324.69,NULL,NULL,1,'2023-06-15 12:36:17','2023-06-15 12:36:17',NULL),(3469,7749,40720,1537,3,2981,'App\\Models\\Receipt',2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',178807.99,NULL,NULL,1,'2023-06-15 12:37:17','2023-06-15 12:37:17',NULL),(3470,7749,40720,1537,3,2984,'App\\Models\\Receipt',2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',583140.75,NULL,NULL,1,'2023-06-15 12:38:21','2023-06-15 12:38:21',NULL),(3471,7749,40720,1537,3,3162,'App\\Models\\Receipt',3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',5008.82,NULL,NULL,1,'2023-06-15 12:42:22','2023-06-15 12:42:22',NULL),(3472,7749,40720,1537,3,3163,'App\\Models\\Receipt',3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',7411.24,NULL,NULL,1,'2023-06-15 12:43:29','2023-06-15 12:43:29',NULL),(3473,7749,40720,1537,3,3164,'App\\Models\\Receipt',3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-25','2023-05-25',270477.92,NULL,NULL,1,'2023-06-15 12:46:18','2023-06-15 12:46:18',NULL),(3474,7749,40720,1537,3,3165,'App\\Models\\Receipt',3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',31047.27,NULL,NULL,1,'2023-06-15 12:48:31','2023-06-15 12:48:31',NULL),(3475,7749,40720,1537,3,3166,'App\\Models\\Receipt',3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',79270.56,NULL,NULL,1,'2023-06-15 12:49:01','2023-06-15 12:49:01',NULL),(3476,7749,40720,1537,3,3167,'App\\Models\\Receipt',3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-28','2023-05-28',23054.40,NULL,NULL,1,'2023-06-15 12:49:28','2023-06-15 12:49:28',NULL),(3477,7749,40720,1537,3,3168,'App\\Models\\Receipt',3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-28','2023-05-28',7999.99,NULL,NULL,1,'2023-06-15 12:50:45','2023-06-15 12:50:45',NULL),(3478,7749,40720,1537,3,3169,'App\\Models\\Receipt',3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',10000.90,NULL,NULL,1,'2023-06-15 12:51:21','2023-06-15 12:51:21',NULL),(3479,7749,40720,1537,3,3098,'App\\Models\\Receipt',3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',28905.28,NULL,NULL,1,'2023-06-15 12:51:53','2023-06-15 12:51:53',NULL),(3480,7749,40720,1537,3,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',67314.09,NULL,NULL,1,'2023-06-15 12:52:44','2023-06-15 12:52:44',NULL),(3481,7749,40720,1537,3,3119,'App\\Models\\Receipt',3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',120388.80,NULL,NULL,1,'2023-06-15 12:56:06','2023-06-15 12:56:06',NULL),(3482,7749,40720,1537,3,3170,'App\\Models\\Receipt',3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',153276.35,NULL,NULL,1,'2023-06-15 12:57:10','2023-06-15 12:57:10',NULL),(3483,7749,40720,1537,2,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',2150.00,NULL,NULL,1,'2023-06-16 10:39:37','2023-06-16 10:39:37',NULL),(3484,7749,40720,1537,2,3171,'App\\Models\\Receipt',3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',5100.00,NULL,NULL,1,'2023-06-16 10:40:34','2023-06-16 10:40:34',NULL),(3485,7749,40720,1537,2,2909,'App\\Models\\Receipt',2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',99.99,NULL,NULL,1,'2023-06-16 10:41:47','2023-06-16 10:41:47',NULL),(3486,7749,40720,1537,2,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',5000.01,NULL,NULL,1,'2023-06-16 10:42:14','2023-06-16 10:42:14',NULL),(3487,7749,40720,1537,3,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',10249.00,NULL,NULL,1,'2023-06-21 11:40:43','2023-06-21 11:40:43',NULL);
INSERT INTO `balance_libro` VALUES (3488,7749,40720,1538,3,3172,'App\\Models\\Receipt',3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',10199.01,NULL,NULL,1,'2023-06-21 12:12:04','2023-06-21 12:12:04',NULL),(3489,7749,40720,1538,3,3173,'App\\Models\\Receipt',3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',13324.25,NULL,NULL,1,'2023-06-21 12:12:04','2023-06-21 12:12:04',NULL),(3490,7749,40720,1538,3,3174,'App\\Models\\Receipt',3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',193183.86,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3491,7749,40720,1538,3,3175,'App\\Models\\Receipt',3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',35420.38,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3492,7749,40720,1538,3,3176,'App\\Models\\Receipt',3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',40963.85,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3493,7749,40720,1538,3,3177,'App\\Models\\Receipt',3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',415436.05,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3494,7749,40720,1538,3,3178,'App\\Models\\Receipt',3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',18069.12,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3495,7749,40720,1538,3,3179,'App\\Models\\Receipt',3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',22543.90,NULL,NULL,1,'2023-06-21 12:12:05','2023-07-11 11:35:26','2023-07-11 11:35:26'),(3496,7749,40720,1538,3,3180,'App\\Models\\Receipt',3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',2878.71,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3497,7749,40720,1538,3,3181,'App\\Models\\Receipt',3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',3011.31,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3498,7749,40720,1538,3,3182,'App\\Models\\Receipt',3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',142490.43,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3499,7749,40720,1538,3,3183,'App\\Models\\Receipt',3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',51770.18,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3500,7749,40720,1538,3,3184,'App\\Models\\Receipt',3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',7502.00,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3501,7749,40720,1538,3,3185,'App\\Models\\Receipt',3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',212102.26,NULL,NULL,1,'2023-06-21 12:12:05','2023-07-13 12:55:48','2023-07-13 12:55:48'),(3502,7749,40720,1538,3,3186,'App\\Models\\Receipt',3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',169524.39,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3503,7749,40720,1538,3,3187,'App\\Models\\Receipt',3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',163130.23,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3504,7749,40720,1538,3,3188,'App\\Models\\Receipt',3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',231998.00,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-28 11:12:08','2023-06-28 11:12:08'),(3505,7749,40720,1538,3,3189,'App\\Models\\Receipt',3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',206094.10,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3506,7749,40720,1538,3,3190,'App\\Models\\Receipt',3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',404359.28,NULL,NULL,1,'2023-06-21 12:12:05','2023-07-13 12:10:06','2023-07-13 12:10:06'),(3507,7749,40720,1538,3,3191,'App\\Models\\Receipt',3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',65819.67,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL);
INSERT INTO `balance_libro` VALUES (3508,7749,40720,1538,3,3192,'App\\Models\\Receipt',3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',414295.55,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3509,7749,40720,1538,3,3193,'App\\Models\\Receipt',3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',93383.81,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3510,7749,40720,1538,3,3194,'App\\Models\\Receipt',3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',41295.76,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3511,7749,40720,1538,3,3195,'App\\Models\\Receipt',3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',11766.34,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3512,7749,40720,1538,3,3196,'App\\Models\\Receipt',3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',14904.74,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3513,7749,40720,1538,3,3197,'App\\Models\\Receipt',3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',8952.13,NULL,NULL,1,'2023-06-21 12:12:05','2023-06-21 12:12:05',NULL),(3514,7749,40720,1538,3,3198,'App\\Models\\Receipt',3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',296188.14,NULL,NULL,1,'2023-06-21 12:12:06','2023-06-21 12:12:06',NULL),(3515,7749,40720,1538,3,3199,'App\\Models\\Receipt',3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',243502.04,NULL,NULL,1,'2023-06-21 12:12:06','2023-07-11 11:43:42','2023-07-11 11:43:42'),(3516,7749,40720,1538,3,3200,'App\\Models\\Receipt',3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',7609.34,NULL,NULL,1,'2023-06-21 12:12:06','2023-07-13 12:09:10','2023-07-13 12:09:10'),(3517,7749,40720,1538,3,3201,'App\\Models\\Receipt',3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',115909.15,NULL,NULL,1,'2023-06-21 12:12:06','2023-06-21 12:12:06',NULL),(3518,7749,40720,1538,3,3202,'App\\Models\\Receipt',3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',111905.43,NULL,NULL,1,'2023-06-21 12:12:06','2023-06-21 12:12:06',NULL),(3519,7749,40720,1538,3,3203,'App\\Models\\Receipt',3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',107170.62,NULL,NULL,1,'2023-06-21 12:12:06','2023-06-21 12:12:06',NULL),(3520,7749,40720,1538,3,3204,'App\\Models\\Receipt',3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',647480.75,NULL,NULL,1,'2023-06-21 12:12:06','2023-06-21 12:12:06',NULL),(3521,7749,40720,1538,3,3205,'App\\Models\\Receipt',3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',42872.55,NULL,NULL,1,'2023-06-21 12:12:06','2023-06-21 12:12:06',NULL),(3522,7749,40720,1538,3,3206,'App\\Models\\Receipt',3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',83254.51,NULL,NULL,1,'2023-06-21 12:12:06','2023-06-21 12:12:06',NULL),(3523,7749,40720,1538,3,3207,'App\\Models\\Receipt',3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',29554.69,NULL,NULL,1,'2023-06-21 12:12:06','2023-06-21 12:12:06',NULL),(3524,7749,40720,1538,3,3208,'App\\Models\\Receipt',3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',49681.76,NULL,NULL,1,'2023-06-21 12:12:06','2023-06-21 12:12:06',NULL),(3525,7749,40720,1538,3,3209,'App\\Models\\Receipt',3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',59056.58,NULL,NULL,1,'2023-06-21 12:12:06','2023-06-21 12:12:06',NULL),(3526,7749,40720,1538,3,3210,'App\\Models\\Receipt',3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',0.77,NULL,NULL,1,'2023-06-21 12:12:06','2023-06-21 12:12:06',NULL),(3527,7749,40720,1538,3,3211,'App\\Models\\Receipt',3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',99932.33,NULL,NULL,1,'2023-06-21 12:12:06','2023-06-21 12:12:06',NULL);
INSERT INTO `balance_libro` VALUES (3528,7749,40720,1538,3,3212,'App\\Models\\Receipt',3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',102409.64,NULL,NULL,1,'2023-06-21 12:12:06','2023-06-21 12:12:06',NULL),(3529,7749,40720,1538,3,3213,'App\\Models\\Receipt',3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',0.00,NULL,NULL,1,'2023-06-21 12:12:06','2023-06-21 12:12:06',NULL),(3530,7749,40720,1538,3,3214,'App\\Models\\Receipt',3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',113782.99,NULL,NULL,1,'2023-06-21 12:12:06','2023-07-11 11:49:20','2023-07-11 11:49:20'),(3531,7749,40720,1538,3,3215,'App\\Models\\Receipt',3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',38897.35,NULL,NULL,1,'2023-06-21 12:12:06','2023-06-21 12:12:06',NULL),(3532,7749,40720,1538,3,3216,'App\\Models\\Receipt',3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',26669.90,NULL,NULL,1,'2023-06-21 12:12:06','2023-06-21 12:12:06',NULL),(3533,7749,40720,1538,3,3217,'App\\Models\\Receipt',3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',13016.47,NULL,NULL,1,'2023-06-21 12:12:07','2023-06-21 12:12:07',NULL),(3534,7749,40720,1538,3,3218,'App\\Models\\Receipt',3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',625354.58,NULL,NULL,1,'2023-06-21 12:12:07','2023-06-21 12:12:07',NULL),(3535,7749,40720,1538,3,3219,'App\\Models\\Receipt',3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',28508.19,NULL,NULL,1,'2023-06-21 12:12:07','2023-06-21 12:12:07',NULL),(3536,7749,40720,1538,3,3220,'App\\Models\\Receipt',3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',164217.77,NULL,NULL,1,'2023-06-21 12:12:07','2023-07-11 11:51:03','2023-07-11 11:51:03'),(3537,7749,40720,1538,3,3221,'App\\Models\\Receipt',3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',109014.96,NULL,NULL,1,'2023-06-21 12:12:07','2023-06-21 12:12:07',NULL),(3538,7749,40720,1538,3,3222,'App\\Models\\Receipt',3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',21262.02,NULL,NULL,1,'2023-06-21 12:12:07','2023-06-21 12:12:07',NULL),(3539,7749,40720,1538,3,3223,'App\\Models\\Receipt',3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',88257.22,NULL,NULL,1,'2023-06-21 12:12:07','2023-06-21 12:12:07',NULL),(3540,7749,40720,1538,3,3224,'App\\Models\\Receipt',3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',11000.00,NULL,NULL,1,'2023-06-21 12:12:07','2023-06-21 12:12:07',NULL),(3541,7749,40720,1538,3,3225,'App\\Models\\Receipt',3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',414586.50,NULL,NULL,1,'2023-06-21 12:12:07','2023-07-11 11:53:04','2023-07-11 11:53:04'),(3542,7749,40720,1538,2,3226,'App\\Models\\Receipt',3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',11000.00,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3543,7749,40720,1538,2,3227,'App\\Models\\Receipt',3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',30370.00,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3544,7749,40720,1538,2,3228,'App\\Models\\Receipt',3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',113442.00,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3545,7749,40720,1538,2,3229,'App\\Models\\Receipt',3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',64030.00,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3546,7749,40720,1538,2,3230,'App\\Models\\Receipt',3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',13200.00,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3547,7749,40720,1538,2,3231,'App\\Models\\Receipt',3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',44800.01,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL);
INSERT INTO `balance_libro` VALUES (3548,7749,40720,1538,2,3232,'App\\Models\\Receipt',3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',18999.96,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3549,7749,40720,1538,2,3233,'App\\Models\\Receipt',3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',18600.00,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3550,7749,40720,1538,2,3234,'App\\Models\\Receipt',3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',8200.00,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3551,7749,40720,1538,2,3235,'App\\Models\\Receipt',3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',7490.00,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3552,7749,40720,1538,2,3236,'App\\Models\\Receipt',3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',3800.00,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3553,7749,40720,1538,2,3237,'App\\Models\\Receipt',3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',108919.99,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3554,7749,40720,1538,2,3238,'App\\Models\\Receipt',3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',15200.07,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3555,7749,40720,1538,2,3239,'App\\Models\\Receipt',3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',17499.99,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3556,7749,40720,1538,2,3240,'App\\Models\\Receipt',3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',9800.00,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3557,7749,40720,1538,2,3241,'App\\Models\\Receipt',3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',86550.79,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3558,7749,40720,1538,2,3242,'App\\Models\\Receipt',3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',7000.00,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3559,7749,40720,1538,2,3243,'App\\Models\\Receipt',3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',5660.00,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3560,7749,40720,1538,2,3244,'App\\Models\\Receipt',3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',15850.00,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3561,7749,40720,1538,2,3245,'App\\Models\\Receipt',3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',5700.00,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3562,7749,40720,1538,2,3246,'App\\Models\\Receipt',3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',20500.00,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3563,7749,40720,1538,2,3247,'App\\Models\\Receipt',3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',17530.00,NULL,NULL,1,'2023-06-21 12:12:28','2023-06-21 12:12:28',NULL),(3564,7749,40720,1538,2,3248,'App\\Models\\Receipt',3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',6780.00,NULL,NULL,1,'2023-06-21 12:12:29','2023-06-21 12:12:29',NULL),(3565,7749,40720,1538,2,3249,'App\\Models\\Receipt',3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',3370.00,NULL,NULL,1,'2023-06-21 12:12:29','2023-06-21 12:12:29',NULL),(3566,7749,40720,1538,2,3250,'App\\Models\\Receipt',3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',5500.00,NULL,NULL,1,'2023-06-21 12:12:29','2023-06-21 12:12:29',NULL),(3567,7749,40720,1538,2,3251,'App\\Models\\Receipt',3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',7700.00,NULL,NULL,1,'2023-06-21 12:12:29','2023-06-21 12:12:29',NULL),(3568,7749,40720,1538,2,3252,'App\\Models\\Receipt',3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',6250.00,NULL,NULL,1,'2023-06-21 12:12:29','2023-06-21 12:12:29',NULL);
INSERT INTO `balance_libro` VALUES (3569,7749,40720,1538,2,3253,'App\\Models\\Receipt',3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',27600.00,NULL,NULL,1,'2023-06-21 12:12:29','2023-06-21 12:12:29',NULL),(3570,7749,40720,1538,2,3254,'App\\Models\\Receipt',3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',4560.00,NULL,NULL,1,'2023-06-21 12:12:29','2023-06-21 12:12:29',NULL),(3571,7749,40720,1538,2,3255,'App\\Models\\Receipt',3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',225000.00,NULL,NULL,1,'2023-06-21 12:12:29','2023-06-21 12:12:29',NULL),(3572,7749,40720,1538,2,3256,'App\\Models\\Receipt',3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',8700.00,NULL,NULL,1,'2023-06-21 12:12:29','2023-06-21 12:12:29',NULL),(3573,7749,40720,1538,2,3257,'App\\Models\\Receipt',3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',185450.00,NULL,NULL,1,'2023-06-21 12:12:29','2023-06-21 12:12:29',NULL),(3574,7749,40720,1538,2,3258,'App\\Models\\Receipt',3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',163450.00,NULL,NULL,1,'2023-06-21 12:12:29','2023-06-21 12:12:29',NULL),(3575,7749,40720,1538,2,3259,'App\\Models\\Receipt',3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',22000.00,NULL,NULL,1,'2023-06-21 12:12:29','2023-06-21 12:12:29',NULL),(3576,7749,40720,1538,2,3260,'App\\Models\\Receipt',3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',17370.00,NULL,NULL,1,'2023-06-21 12:12:29','2023-06-21 12:12:29',NULL),(3577,7749,40720,1538,2,3261,'App\\Models\\Receipt',3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',21570.00,NULL,NULL,1,'2023-06-21 12:12:29','2023-06-21 12:12:29',NULL),(3578,7749,40720,1538,2,3262,'App\\Models\\Receipt',3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',39290.00,NULL,NULL,1,'2023-06-21 12:12:29','2023-06-21 12:12:29',NULL),(3579,7749,40720,1538,2,3263,'App\\Models\\Receipt',3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',185450.01,NULL,NULL,1,'2023-06-21 12:12:29','2023-06-21 12:12:29',NULL),(3580,7749,40720,1538,2,3264,'App\\Models\\Receipt',3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',10300.00,NULL,NULL,1,'2023-06-21 12:12:29','2023-06-21 12:12:29',NULL),(3581,7749,40720,1538,2,3265,'App\\Models\\Receipt',3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',25600.00,NULL,NULL,1,'2023-06-21 12:12:29','2023-06-21 12:12:29',NULL),(3582,7749,40720,1538,2,3266,'App\\Models\\Receipt',3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',17204.84,NULL,NULL,1,'2023-06-21 12:12:30','2023-06-21 12:12:30',NULL),(3583,7749,40720,1538,2,3267,'App\\Models\\Receipt',3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',52799.95,NULL,NULL,1,'2023-06-21 12:12:30','2023-06-21 12:12:30',NULL),(3584,7749,40720,1538,2,3268,'App\\Models\\Receipt',3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',95389.99,NULL,NULL,1,'2023-06-21 12:12:30','2023-06-21 12:12:30',NULL),(3585,7749,40720,1538,2,3269,'App\\Models\\Receipt',3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',36319.99,NULL,NULL,1,'2023-06-21 12:12:30','2023-06-21 12:12:30',NULL),(3586,7749,40720,1538,2,3270,'App\\Models\\Receipt',3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',16000.07,NULL,NULL,1,'2023-06-21 12:12:30','2023-06-21 12:12:30',NULL),(3587,7749,40720,1538,2,3271,'App\\Models\\Receipt',3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',210000.00,NULL,NULL,1,'2023-06-21 12:12:30','2023-06-21 12:12:30',NULL),(3588,7749,40720,1538,2,3272,'App\\Models\\Receipt',3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',94600.00,NULL,NULL,1,'2023-06-21 12:12:30','2023-06-21 12:12:30',NULL),(3589,7749,40720,1538,2,3273,'App\\Models\\Receipt',3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',11999.97,NULL,NULL,1,'2023-06-21 12:12:58','2023-06-23 12:55:27','2023-06-23 12:55:27');
INSERT INTO `balance_libro` VALUES (3590,7749,40720,1538,2,3274,'App\\Models\\Receipt',3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',16900.01,NULL,NULL,1,'2023-06-21 12:12:58','2023-06-23 12:55:50','2023-06-23 12:55:50'),(3591,7749,40720,1538,2,3275,'App\\Models\\Receipt',3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',18099.99,NULL,NULL,1,'2023-06-21 12:12:58','2023-06-23 12:56:17','2023-06-23 12:56:17'),(3592,7749,40720,1538,2,3276,'App\\Models\\Receipt',3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-04','2023-06-04',21610.08,NULL,NULL,1,'2023-06-21 12:12:58','2023-06-21 12:12:58',NULL),(3593,7749,40720,1538,2,3277,'App\\Models\\Receipt',3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',790.01,NULL,NULL,1,'2023-06-21 12:12:58','2023-06-23 12:56:49','2023-06-23 12:56:49'),(3594,7749,40720,1538,2,3278,'App\\Models\\Receipt',3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',8599.99,NULL,NULL,1,'2023-06-21 12:12:58','2023-06-23 12:57:08','2023-06-23 12:57:08'),(3595,7749,40720,1538,2,3279,'App\\Models\\Receipt',3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',3250.00,NULL,NULL,1,'2023-06-21 12:12:58','2023-06-23 12:57:31','2023-06-23 12:57:31'),(3596,7749,40720,1538,2,3280,'App\\Models\\Receipt',3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',799.98,NULL,NULL,1,'2023-06-21 12:13:15','2023-06-21 12:13:15',NULL),(3597,7749,40720,1538,2,3281,'App\\Models\\Receipt',3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',799.98,NULL,NULL,1,'2023-06-21 12:13:15','2023-06-21 12:13:15',NULL),(3598,7749,40720,1538,2,3282,'App\\Models\\Receipt',3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',10400.01,NULL,NULL,1,'2023-06-21 12:13:15','2023-06-21 12:13:15',NULL),(3599,7749,40720,1538,2,3283,'App\\Models\\Receipt',3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',11100.02,NULL,NULL,1,'2023-06-21 12:13:15','2023-06-21 12:13:15',NULL),(3600,7749,40720,1538,2,3284,'App\\Models\\Receipt',3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',2600.00,NULL,NULL,1,'2023-06-21 12:13:15','2023-06-21 12:13:15',NULL),(3601,7749,40720,1538,2,3285,'App\\Models\\Receipt',3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',3199.99,NULL,NULL,1,'2023-06-21 12:13:15','2023-06-21 12:13:15',NULL),(3602,7749,40720,1538,2,3286,'App\\Models\\Receipt',3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',6399.98,NULL,NULL,1,'2023-06-21 12:13:15','2023-06-21 12:13:15',NULL),(3603,7749,40720,1538,2,3287,'App\\Models\\Receipt',3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',4200.03,NULL,NULL,1,'2023-06-21 12:13:15','2023-06-21 12:13:15',NULL),(3604,7749,40720,1538,2,3288,'App\\Models\\Receipt',3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',7499.98,NULL,NULL,1,'2023-06-21 12:13:15','2023-06-21 12:13:15',NULL),(3605,7749,40720,1538,2,3289,'App\\Models\\Receipt',3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',790.01,NULL,NULL,1,'2023-06-21 12:13:15','2023-06-21 12:13:15',NULL),(3606,7749,40720,1538,2,3290,'App\\Models\\Receipt',3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',3599.98,NULL,NULL,1,'2023-06-21 12:13:15','2023-06-21 12:13:15',NULL),(3607,7749,40720,1538,2,3291,'App\\Models\\Receipt',3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',5000.01,NULL,NULL,1,'2023-06-21 12:13:15','2023-06-21 12:13:15',NULL),(3608,7749,40720,1538,2,3292,'App\\Models\\Receipt',3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',2250.02,NULL,NULL,1,'2023-06-21 12:13:15','2023-06-21 12:13:15',NULL),(3609,7749,40720,1538,2,3293,'App\\Models\\Receipt',3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',999.98,NULL,NULL,1,'2023-06-21 12:13:16','2023-06-21 12:13:16',NULL);
INSERT INTO `balance_libro` VALUES (3610,7749,40720,1538,2,3294,'App\\Models\\Receipt',3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',100000.00,NULL,NULL,1,'2023-06-23 10:51:52','2023-06-23 10:51:52',NULL),(3611,7749,40720,1538,2,3295,'App\\Models\\Receipt',3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',100000.00,NULL,NULL,1,'2023-06-23 10:51:52','2023-06-23 10:51:52',NULL),(3612,7749,40720,1538,2,3296,'App\\Models\\Receipt',3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',3059.99,NULL,NULL,1,'2023-06-23 10:51:52','2023-06-23 10:51:52',NULL),(3613,7749,40720,1538,2,3297,'App\\Models\\Receipt',3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',3025.00,NULL,NULL,1,'2023-06-23 10:51:52','2023-06-23 10:51:52',NULL),(3614,7749,40720,1538,3,3298,'App\\Models\\Receipt',3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',11624.50,NULL,NULL,1,'2023-06-23 10:52:03','2023-07-11 11:57:11','2023-07-11 11:57:11'),(3615,7749,40720,1538,3,3299,'App\\Models\\Receipt',3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',77736.67,NULL,NULL,1,'2023-06-23 10:52:03','2023-06-23 10:52:03',NULL),(3616,7749,40720,1538,2,3300,'App\\Models\\Receipt',3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',5799.99,NULL,NULL,1,'2023-06-23 10:52:24','2023-06-23 12:57:50','2023-06-23 12:57:50'),(3617,7749,40720,1538,2,3301,'App\\Models\\Receipt',3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',123819.99,NULL,NULL,1,'2023-06-23 10:52:24','2023-06-23 10:52:24',NULL),(3618,7749,40720,1538,2,3302,'App\\Models\\Receipt',3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',7699.98,NULL,NULL,1,'2023-06-23 10:52:24','2023-06-23 12:58:23','2023-06-23 12:58:23'),(3619,7749,40720,1538,2,3303,'App\\Models\\Receipt',3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',9100.01,NULL,NULL,1,'2023-06-23 10:52:24','2023-06-23 12:58:42','2023-06-23 12:58:42'),(3620,7749,40720,1538,2,3304,'App\\Models\\Receipt',3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',87709.96,NULL,NULL,1,'2023-06-23 10:52:24','2023-06-23 12:59:02','2023-06-23 12:59:02'),(3621,7749,40720,1538,2,3305,'App\\Models\\Receipt',3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',7420.01,NULL,NULL,1,'2023-06-23 10:52:24','2023-06-23 12:59:20','2023-06-23 12:59:20'),(3622,7749,40720,1538,2,3306,'App\\Models\\Receipt',3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',13100.04,NULL,NULL,1,'2023-06-23 10:52:36','2023-06-23 12:59:42','2023-06-23 12:59:42'),(3623,7749,40720,1538,2,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',3710.03,NULL,NULL,1,'2023-06-23 10:52:36','2023-06-23 13:00:03','2023-06-23 13:00:03'),(3624,7749,40720,1538,2,3308,'App\\Models\\Receipt',3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',18450.02,NULL,NULL,1,'2023-06-23 10:52:36','2023-06-23 13:00:23','2023-06-23 13:00:23'),(3625,7749,40720,1538,2,3309,'App\\Models\\Receipt',3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',1049.99,NULL,NULL,1,'2023-06-23 10:52:36','2023-06-23 13:00:42','2023-06-23 13:00:42'),(3626,7749,40720,1538,2,3310,'App\\Models\\Receipt',3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-20','2023-06-20',65710.03,NULL,NULL,1,'2023-06-23 10:52:36','2023-06-23 10:52:36',NULL),(3627,7749,40720,1538,2,3311,'App\\Models\\Receipt',3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',11099.96,NULL,NULL,1,'2023-06-23 10:52:36','2023-06-23 13:01:06','2023-06-23 13:01:06'),(3628,7749,40720,1538,2,3312,'App\\Models\\Receipt',3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',5799.99,NULL,NULL,1,'2023-06-23 10:53:09','2023-06-23 10:53:09',NULL),(3629,7749,40720,1538,2,3313,'App\\Models\\Receipt',3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',7699.98,NULL,NULL,1,'2023-06-23 10:53:09','2023-06-23 10:53:09',NULL);
INSERT INTO `balance_libro` VALUES (3630,7749,40720,1538,2,3314,'App\\Models\\Receipt',3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',3100.02,NULL,NULL,1,'2023-06-23 10:53:09','2023-06-23 10:53:09',NULL),(3631,7749,40720,1538,2,3315,'App\\Models\\Receipt',3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',799.98,NULL,NULL,1,'2023-06-23 10:53:09','2023-06-23 10:53:09',NULL),(3632,7749,40720,1538,2,3316,'App\\Models\\Receipt',3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',2499.98,NULL,NULL,1,'2023-06-23 10:53:09','2023-06-23 10:53:09',NULL),(3633,7749,40720,1538,2,3317,'App\\Models\\Receipt',3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',2700.03,NULL,NULL,1,'2023-06-23 10:53:09','2023-06-23 10:53:09',NULL),(3634,7749,40720,1538,2,3318,'App\\Models\\Receipt',3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',37499.97,NULL,NULL,1,'2023-06-23 10:53:10','2023-06-23 10:53:10',NULL),(3635,7749,40720,1538,2,3319,'App\\Models\\Receipt',3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',37499.97,NULL,NULL,1,'2023-06-23 10:53:10','2023-06-23 10:53:10',NULL),(3636,7749,40720,1538,2,3320,'App\\Models\\Receipt',3320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',1759.97,NULL,NULL,1,'2023-06-23 10:53:10','2023-06-23 10:53:10',NULL),(3637,7749,40720,1538,2,3321,'App\\Models\\Receipt',3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',4750.00,NULL,NULL,1,'2023-06-23 10:53:10','2023-06-23 10:53:10',NULL),(3638,7749,40720,1538,2,3322,'App\\Models\\Receipt',3322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',3500.01,NULL,NULL,1,'2023-06-23 10:53:10','2023-06-23 10:53:10',NULL),(3639,7749,40720,1538,2,3323,'App\\Models\\Receipt',3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',2700.03,NULL,NULL,1,'2023-06-23 10:53:10','2023-06-23 10:53:10',NULL),(3640,7749,40720,1538,2,3324,'App\\Models\\Receipt',3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',2200.01,NULL,NULL,1,'2023-06-23 10:53:10','2023-06-23 10:53:10',NULL),(3641,7749,40720,1538,2,3325,'App\\Models\\Receipt',3325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',999.98,NULL,NULL,1,'2023-06-23 10:53:10','2023-06-23 10:53:10',NULL),(3642,7749,40720,1538,2,3326,'App\\Models\\Receipt',3326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',4220.02,NULL,NULL,1,'2023-06-23 10:53:10','2023-06-23 10:53:10',NULL),(3643,7749,40720,1538,2,3327,'App\\Models\\Receipt',3327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',2900.02,NULL,NULL,1,'2023-06-23 10:53:19','2023-06-23 10:53:19',NULL),(3644,7749,40720,1538,2,3328,'App\\Models\\Receipt',3328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',4499.99,NULL,NULL,1,'2023-06-23 10:53:19','2023-06-23 10:53:19',NULL),(3645,7749,40720,1538,2,3329,'App\\Models\\Receipt',3329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',5700.02,NULL,NULL,1,'2023-06-23 10:53:19','2023-06-23 10:53:19',NULL),(3646,7749,40720,1538,2,3330,'App\\Models\\Receipt',3330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',1600.02,NULL,NULL,1,'2023-06-23 10:53:19','2023-06-23 10:53:19',NULL),(3647,7749,40720,1538,2,3331,'App\\Models\\Receipt',3331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',2110.01,NULL,NULL,1,'2023-06-23 10:53:19','2023-06-23 10:53:19',NULL),(3648,7749,40720,1538,2,3332,'App\\Models\\Receipt',3332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',6500.00,NULL,NULL,1,'2023-06-23 10:53:19','2023-06-23 10:53:19',NULL),(3649,7749,40720,1538,2,3333,'App\\Models\\Receipt',3333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',11950.02,NULL,NULL,1,'2023-06-23 10:53:19','2023-06-23 10:53:19',NULL),(3650,7749,40720,1538,2,3334,'App\\Models\\Receipt',3334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',1049.99,NULL,NULL,1,'2023-06-23 10:53:19','2023-06-23 10:53:19',NULL);
INSERT INTO `balance_libro` VALUES (3651,7749,40720,1538,2,3335,'App\\Models\\Receipt',3335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',3399.98,NULL,NULL,1,'2023-06-23 10:53:19','2023-06-23 10:53:19',NULL),(3652,7749,40720,1538,2,3336,'App\\Models\\Receipt',3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',1300.00,NULL,NULL,1,'2023-06-23 10:53:19','2023-06-23 10:53:19',NULL),(3653,7749,40720,1538,2,3337,'App\\Models\\Receipt',3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',6399.98,NULL,NULL,1,'2023-06-23 10:53:19','2023-06-23 10:53:19',NULL),(3654,7749,40720,1538,2,3273,'App\\Models\\Receipt',3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',133240.00,NULL,NULL,1,'2023-06-23 12:55:27','2023-06-23 12:55:27',NULL),(3655,7749,40720,1538,2,3274,'App\\Models\\Receipt',3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',173590.00,NULL,NULL,1,'2023-06-23 12:55:50','2023-06-23 12:55:50',NULL),(3656,7749,40720,1538,2,3275,'App\\Models\\Receipt',3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',269459.99,NULL,NULL,1,'2023-06-23 12:56:17','2023-06-23 12:56:17',NULL),(3657,7749,40720,1538,2,3277,'App\\Models\\Receipt',3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',93690.00,NULL,NULL,1,'2023-06-23 12:56:49','2023-06-23 12:56:49',NULL),(3658,7749,40720,1538,2,3278,'App\\Models\\Receipt',3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',158855.00,NULL,NULL,1,'2023-06-23 12:57:08','2023-06-23 12:57:08',NULL),(3659,7749,40720,1538,2,3279,'App\\Models\\Receipt',3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',231100.01,NULL,NULL,1,'2023-06-23 12:57:31','2023-06-23 12:57:31',NULL),(3660,7749,40720,1538,2,3300,'App\\Models\\Receipt',3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',160416.50,NULL,NULL,1,'2023-06-23 12:57:50','2023-06-23 12:57:50',NULL),(3661,7749,40720,1538,2,3302,'App\\Models\\Receipt',3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',162680.00,NULL,NULL,1,'2023-06-23 12:58:23','2023-06-23 12:58:23',NULL),(3662,7749,40720,1538,2,3303,'App\\Models\\Receipt',3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',173950.00,NULL,NULL,1,'2023-06-23 12:58:42','2023-06-23 12:58:42',NULL),(3663,7749,40720,1538,2,3304,'App\\Models\\Receipt',3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',199630.00,NULL,NULL,1,'2023-06-23 12:59:02','2023-06-23 12:59:02',NULL),(3664,7749,40720,1538,2,3305,'App\\Models\\Receipt',3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',198220.00,NULL,NULL,1,'2023-06-23 12:59:20','2023-06-23 12:59:20',NULL),(3665,7749,40720,1538,2,3306,'App\\Models\\Receipt',3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',146880.00,NULL,NULL,1,'2023-06-23 12:59:42','2023-06-23 12:59:42',NULL),(3666,7749,40720,1538,2,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',132250.00,NULL,NULL,1,'2023-06-23 13:00:03','2023-06-23 13:00:03',NULL),(3667,7749,40720,1538,2,3308,'App\\Models\\Receipt',3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',171040.00,NULL,NULL,1,'2023-06-23 13:00:23','2023-06-23 13:00:23',NULL),(3668,7749,40720,1538,2,3309,'App\\Models\\Receipt',3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-19','2023-06-19',83589.99,NULL,NULL,1,'2023-06-23 13:00:42','2023-06-23 13:00:42',NULL),(3669,7749,40720,1538,2,3311,'App\\Models\\Receipt',3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',141140.00,NULL,NULL,1,'2023-06-23 13:01:06','2023-06-23 13:01:06',NULL),(3670,7749,40720,1538,2,3338,'App\\Models\\Receipt',3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',65800.00,NULL,NULL,1,'2023-06-26 10:17:06','2023-06-26 10:17:06',NULL),(3671,7749,40720,1538,2,3339,'App\\Models\\Receipt',3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',131499.97,NULL,NULL,1,'2023-06-26 10:17:06','2023-06-26 10:17:06',NULL);
INSERT INTO `balance_libro` VALUES (3672,7749,40720,1538,3,3340,'App\\Models\\Receipt',3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',6320.99,NULL,NULL,1,'2023-06-26 10:17:20','2023-06-26 10:17:20',NULL),(3673,7749,40720,1538,2,3341,'App\\Models\\Receipt',3341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',1205506.79,NULL,NULL,1,'2023-06-28 09:28:29','2023-06-28 09:28:29',NULL),(3674,7749,40720,1538,3,3342,'App\\Models\\Receipt',3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',0.00,NULL,NULL,1,'2023-06-28 09:28:38','2023-06-28 09:28:38',NULL),(3675,7749,40720,1538,3,3343,'App\\Models\\Receipt',3343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',0.00,NULL,NULL,1,'2023-06-28 09:28:38','2023-06-28 09:28:38',NULL),(3676,7749,40720,1538,3,3344,'App\\Models\\Receipt',3344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',0.00,NULL,NULL,1,'2023-06-28 09:28:38','2023-06-28 09:28:38',NULL),(3677,7749,40720,1538,3,3345,'App\\Models\\Receipt',3345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',17181.08,NULL,NULL,1,'2023-06-28 09:28:38','2023-06-28 09:28:38',NULL),(3678,7749,40720,1538,3,3346,'App\\Models\\Receipt',3346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',89666.09,NULL,NULL,1,'2023-06-28 09:28:38','2023-06-28 09:28:38',NULL),(3679,7749,40720,1538,3,3347,'App\\Models\\Receipt',3347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',10934.28,NULL,NULL,1,'2023-06-28 09:28:38','2023-06-28 09:28:38',NULL),(3680,7749,40720,1538,3,3348,'App\\Models\\Receipt',3348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',48049.98,NULL,NULL,1,'2023-06-28 09:28:38','2023-06-28 09:28:38',NULL),(3681,7749,40720,1538,3,3349,'App\\Models\\Receipt',3349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',65103.80,NULL,NULL,1,'2023-06-28 09:28:38','2023-06-28 09:28:38',NULL),(3682,7749,40720,1538,3,3350,'App\\Models\\Receipt',3350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',61964.86,NULL,NULL,1,'2023-06-28 09:28:38','2023-06-28 09:28:38',NULL),(3683,7749,40720,1538,3,3351,'App\\Models\\Receipt',3351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',173389.38,NULL,NULL,1,'2023-06-28 09:28:38','2023-06-28 09:28:38',NULL),(3684,7749,40720,1538,3,3352,'App\\Models\\Receipt',3352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',62335.74,NULL,NULL,1,'2023-06-28 09:28:38','2023-06-28 09:28:38',NULL),(3685,7749,40720,1538,3,3353,'App\\Models\\Receipt',3353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',28168.49,NULL,NULL,1,'2023-06-28 09:34:43','2023-06-28 09:34:43',NULL),(3686,7749,40720,1538,3,3354,'App\\Models\\Receipt',3354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',15563.70,NULL,NULL,1,'2023-06-28 09:35:55','2023-06-28 09:35:55',NULL),(3687,7749,40720,1538,3,3355,'App\\Models\\Receipt',3355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',206716.99,NULL,NULL,1,'2023-06-28 09:36:28','2023-06-28 09:36:28',NULL),(3688,7749,40720,1538,3,3356,'App\\Models\\Receipt',3356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',27560.25,NULL,NULL,1,'2023-06-28 09:36:45','2023-06-28 09:36:45',NULL),(3689,7749,40720,1538,3,3357,'App\\Models\\Receipt',3357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',29206.61,NULL,NULL,1,'2023-06-28 09:37:51','2023-06-28 09:37:51',NULL),(3690,7749,40720,1538,3,3358,'App\\Models\\Receipt',3358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',14654.46,NULL,NULL,1,'2023-06-28 09:38:21','2023-06-28 09:38:21',NULL),(3691,7749,40720,1538,2,3359,'App\\Models\\Receipt',3359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',1806106.50,NULL,NULL,1,'2023-06-28 11:03:24','2023-06-28 11:03:24',NULL),(3692,7749,40720,1538,2,3360,'App\\Models\\Receipt',3360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',55720.00,NULL,NULL,1,'2023-06-28 11:03:24','2023-06-28 11:03:24',NULL);
INSERT INTO `balance_libro` VALUES (3693,7749,40720,1538,2,3361,'App\\Models\\Receipt',3361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',5200.00,NULL,NULL,1,'2023-06-28 11:03:24','2023-06-28 11:03:24',NULL),(3694,7749,40720,1533,7,3362,'App\\Models\\Receipt',3362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',407.94,NULL,NULL,1,'2023-06-28 11:15:36','2023-06-28 11:15:36',NULL),(3695,7749,40720,1533,7,3363,'App\\Models\\Receipt',3363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',399.30,NULL,NULL,1,'2023-06-28 11:15:36','2023-06-28 11:15:36',NULL),(3696,7749,40720,1533,7,3364,'App\\Models\\Receipt',3364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',205.45,NULL,NULL,1,'2023-06-28 11:15:36','2023-06-28 11:15:36',NULL),(3697,7749,40720,1533,7,3365,'App\\Models\\Receipt',3365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',73701.89,NULL,NULL,1,'2023-06-28 11:15:36','2023-06-28 11:15:36',NULL),(3698,7749,40720,1533,7,3366,'App\\Models\\Receipt',3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',3148.76,NULL,NULL,1,'2023-06-28 11:15:36','2023-06-28 11:15:36',NULL),(3699,7749,40720,1533,7,3367,'App\\Models\\Receipt',3367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',73412.72,NULL,NULL,1,'2023-06-28 11:15:37','2023-06-28 11:15:37',NULL),(3700,7749,40720,1533,7,3368,'App\\Models\\Receipt',3368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',78.46,NULL,NULL,1,'2023-06-28 11:15:37','2023-06-28 11:15:37',NULL),(3701,7749,40720,1533,7,3369,'App\\Models\\Receipt',3369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',100.65,NULL,NULL,1,'2023-06-28 11:15:37','2023-06-28 11:15:37',NULL),(3702,7749,40720,1533,7,3370,'App\\Models\\Receipt',3370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',54.68,NULL,NULL,1,'2023-06-28 11:15:37','2023-06-28 11:15:37',NULL),(3703,7749,40720,1534,7,3371,'App\\Models\\Receipt',3371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4504.13,NULL,NULL,1,'2023-06-28 11:15:47','2023-06-28 11:15:47',NULL),(3704,7749,40720,1534,7,3372,'App\\Models\\Receipt',3372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',181.89,NULL,NULL,1,'2023-06-28 11:15:47','2023-06-28 11:15:47',NULL),(3705,7749,40720,1534,7,3373,'App\\Models\\Receipt',3373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',271.90,NULL,NULL,1,'2023-06-28 11:15:47','2023-06-28 11:15:47',NULL),(3706,7749,40720,1534,7,3374,'App\\Models\\Receipt',3374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1137.28,NULL,NULL,1,'2023-06-28 11:15:47','2023-06-28 11:15:47',NULL),(3707,7749,40720,1534,7,3375,'App\\Models\\Receipt',3375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',6054.05,NULL,NULL,1,'2023-06-28 11:15:48','2023-06-28 11:15:48',NULL),(3708,7749,40720,1534,7,3376,'App\\Models\\Receipt',3376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',5357.69,NULL,NULL,1,'2023-06-28 11:15:48','2023-06-28 11:15:48',NULL),(3709,7749,40720,1535,7,3377,'App\\Models\\Receipt',3377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1344.47,NULL,NULL,1,'2023-06-28 11:15:56','2023-06-28 11:15:56',NULL),(3710,7749,40720,1535,7,3378,'App\\Models\\Receipt',3378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',240.20,NULL,NULL,1,'2023-06-28 11:15:56','2023-06-28 11:15:56',NULL),(3711,7749,40720,1535,7,3379,'App\\Models\\Receipt',3379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',23709.91,NULL,NULL,1,'2023-06-28 11:15:56','2023-06-28 11:15:56',NULL),(3712,7749,40720,1535,7,3380,'App\\Models\\Receipt',3380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',200.00,NULL,NULL,1,'2023-06-28 11:15:56','2023-06-28 11:15:56',NULL),(3713,7749,40720,1535,7,3381,'App\\Models\\Receipt',3381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',30201.16,NULL,NULL,1,'2023-06-28 11:15:56','2023-06-28 11:15:56',NULL);
INSERT INTO `balance_libro` VALUES (3714,7749,40720,1536,7,3382,'App\\Models\\Receipt',3382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',152.11,NULL,NULL,1,'2023-06-28 11:16:05','2023-06-28 11:16:05',NULL),(3715,7749,40720,1536,7,3383,'App\\Models\\Receipt',3383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',173.72,NULL,NULL,1,'2023-06-28 11:16:05','2023-06-28 11:16:05',NULL),(3716,7749,40720,1536,7,3384,'App\\Models\\Receipt',3384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',57.09,NULL,NULL,1,'2023-06-28 11:16:05','2023-06-28 11:16:05',NULL),(3717,7749,40720,1536,7,3385,'App\\Models\\Receipt',3385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',17398.99,NULL,NULL,1,'2023-06-28 11:16:05','2023-06-28 11:16:05',NULL),(3718,7749,40720,1536,7,3386,'App\\Models\\Receipt',3386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',2130.04,NULL,NULL,1,'2023-06-28 11:16:05','2023-06-28 11:16:05',NULL),(3719,7749,40720,1536,7,3387,'App\\Models\\Receipt',3387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',413.18,NULL,NULL,1,'2023-06-28 11:16:05','2023-06-28 11:16:05',NULL),(3720,7749,40720,1536,7,3388,'App\\Models\\Receipt',3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',18837.18,NULL,NULL,1,'2023-06-28 11:16:05','2023-06-28 11:16:05',NULL),(3721,7749,40720,1536,7,3389,'App\\Models\\Receipt',3389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',859.37,NULL,NULL,1,'2023-06-28 11:16:05','2023-06-28 11:16:05',NULL),(3722,7749,40720,1537,7,3390,'App\\Models\\Receipt',3390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',201.35,NULL,NULL,1,'2023-06-28 11:16:14','2023-06-28 11:16:14',NULL),(3723,7749,40720,1537,7,3391,'App\\Models\\Receipt',3391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',14310.74,NULL,NULL,1,'2023-06-28 11:16:14','2023-06-28 11:16:14',NULL),(3724,7749,40720,1537,7,3392,'App\\Models\\Receipt',3392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',5743.80,NULL,NULL,1,'2023-06-28 11:16:14','2023-06-28 11:16:14',NULL),(3725,7749,40720,1537,7,3393,'App\\Models\\Receipt',3393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',32.71,NULL,NULL,1,'2023-06-28 11:16:14','2023-06-28 11:16:14',NULL),(3726,7749,40720,1537,7,3394,'App\\Models\\Receipt',3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',748.43,NULL,NULL,1,'2023-06-28 11:16:14','2023-06-28 11:16:14',NULL),(3727,7749,40720,1537,7,3395,'App\\Models\\Receipt',3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',23782.99,NULL,NULL,1,'2023-06-28 11:16:14','2023-06-28 11:16:14',NULL),(3728,7749,40720,1537,7,3396,'App\\Models\\Receipt',3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',14.21,NULL,NULL,1,'2023-06-28 11:16:14','2023-06-28 11:16:14',NULL),(3729,7749,40720,1537,7,3397,'App\\Models\\Receipt',3397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',18.06,NULL,NULL,1,'2023-06-28 11:16:14','2023-06-28 11:16:14',NULL),(3730,7749,40720,1538,3,3398,'App\\Models\\Receipt',3398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',411180.95,NULL,NULL,1,'2023-06-29 12:39:44','2023-06-29 12:39:44',NULL),(3731,7749,40720,1538,3,3399,'App\\Models\\Receipt',3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',146446.80,NULL,NULL,1,'2023-06-29 12:40:04','2023-06-29 12:40:04',NULL),(3732,7749,40720,1538,3,3400,'App\\Models\\Receipt',3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',210675.83,NULL,NULL,1,'2023-06-29 12:40:49','2023-06-29 12:40:49',NULL),(3733,7749,40720,1538,3,3401,'App\\Models\\Receipt',3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',9203.72,NULL,NULL,1,'2023-06-29 12:41:18','2023-06-29 12:41:18',NULL),(3734,7749,40720,1538,3,3402,'App\\Models\\Receipt',3402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',13699.98,NULL,NULL,1,'2023-06-29 12:42:28','2023-06-29 12:42:28',NULL);
INSERT INTO `balance_libro` VALUES (3735,7749,40720,1538,3,3403,'App\\Models\\Receipt',3403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',9500.01,NULL,NULL,1,'2023-06-29 12:43:00','2023-06-29 12:43:00',NULL),(3736,7749,40720,1538,3,3404,'App\\Models\\Receipt',3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',19299.99,NULL,NULL,1,'2023-06-29 12:43:48','2023-06-29 12:43:48',NULL),(3737,7749,40720,1539,2,3405,'App\\Models\\Receipt',3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',104000.00,NULL,NULL,1,'2023-07-05 10:50:36','2023-07-05 10:50:36',NULL),(3738,7749,40720,1539,2,3406,'App\\Models\\Receipt',3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',26270.00,NULL,NULL,1,'2023-07-05 10:50:36','2023-07-05 10:50:36',NULL),(3739,7749,40720,1539,2,3407,'App\\Models\\Receipt',3407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',53040.00,NULL,NULL,1,'2023-07-05 10:50:36','2023-07-05 10:50:36',NULL),(3740,7749,40720,1539,2,3408,'App\\Models\\Receipt',3408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',23999.99,NULL,NULL,1,'2023-07-05 10:50:36','2023-07-05 10:50:36',NULL),(3741,7749,40720,1539,2,3409,'App\\Models\\Receipt',3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',22460.00,NULL,NULL,1,'2023-07-05 10:50:36','2023-07-05 10:50:36',NULL),(3742,7749,40720,1539,2,3410,'App\\Models\\Receipt',3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',38100.00,NULL,NULL,1,'2023-07-05 10:50:37','2023-07-05 10:50:37',NULL),(3743,7749,40720,1539,2,3411,'App\\Models\\Receipt',3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',19449.99,NULL,NULL,1,'2023-07-05 10:50:37','2023-07-05 10:50:37',NULL),(3744,7749,40720,1539,2,3412,'App\\Models\\Receipt',3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',2610.00,NULL,NULL,1,'2023-07-05 10:50:37','2023-07-05 10:50:37',NULL),(3745,7749,40720,1539,2,3413,'App\\Models\\Receipt',3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',10699.99,NULL,NULL,1,'2023-07-05 10:50:37','2023-07-05 10:50:37',NULL),(3746,7749,40720,1539,2,3414,'App\\Models\\Receipt',3414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',1600.00,NULL,NULL,1,'2023-07-05 10:50:37','2023-07-05 10:50:37',NULL),(3747,7749,40720,1539,2,3415,'App\\Models\\Receipt',3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',21750.00,NULL,NULL,1,'2023-07-05 10:50:37','2023-07-05 10:50:37',NULL),(3748,7749,40720,1539,2,3416,'App\\Models\\Receipt',3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',700.00,NULL,NULL,1,'2023-07-05 10:50:37','2023-07-05 10:50:37',NULL),(3749,7749,40720,1539,2,3417,'App\\Models\\Receipt',3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',14000.00,NULL,NULL,1,'2023-07-05 10:50:37','2023-07-05 10:50:37',NULL),(3750,7749,40720,1539,2,3418,'App\\Models\\Receipt',3418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',58200.00,NULL,NULL,1,'2023-07-05 10:50:37','2023-07-05 10:50:37',NULL),(3751,7749,40720,1539,2,3419,'App\\Models\\Receipt',3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',2030.00,NULL,NULL,1,'2023-07-05 10:50:37','2023-07-05 10:50:37',NULL),(3752,7749,40720,1539,2,3420,'App\\Models\\Receipt',3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',6500.00,NULL,NULL,1,'2023-07-05 10:50:37','2023-07-05 10:50:37',NULL),(3753,7749,40720,1539,2,3421,'App\\Models\\Receipt',3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',10700.00,NULL,NULL,1,'2023-07-05 10:50:38','2023-07-05 10:50:38',NULL),(3754,7749,40720,1539,2,3422,'App\\Models\\Receipt',3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',20700.00,NULL,NULL,1,'2023-07-05 10:50:38','2023-07-05 10:50:38',NULL),(3755,7749,40720,1539,2,3423,'App\\Models\\Receipt',3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',41550.00,NULL,NULL,1,'2023-07-05 10:50:38','2023-07-05 10:50:38',NULL);
INSERT INTO `balance_libro` VALUES (3756,7749,40720,1539,2,3424,'App\\Models\\Receipt',3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',8049.99,NULL,NULL,1,'2023-07-05 10:50:38','2023-07-05 10:50:38',NULL),(3757,7749,40720,1539,2,3425,'App\\Models\\Receipt',3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',18719.98,NULL,NULL,1,'2023-07-05 10:50:38','2023-07-05 10:50:38',NULL),(3758,7749,40720,1539,2,3426,'App\\Models\\Receipt',3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',700.00,NULL,NULL,1,'2023-07-05 10:50:38','2023-07-05 10:50:38',NULL),(3759,7749,40720,1539,2,3427,'App\\Models\\Receipt',3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',91240.00,NULL,NULL,1,'2023-07-05 10:50:38','2023-07-05 10:50:38',NULL),(3760,7749,40720,1539,2,3428,'App\\Models\\Receipt',3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',153934.98,NULL,NULL,1,'2023-07-05 10:50:38','2023-07-05 10:50:38',NULL),(3761,7749,40720,1539,2,3429,'App\\Models\\Receipt',3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',42510.00,NULL,NULL,1,'2023-07-05 10:50:38','2023-07-05 10:50:38',NULL),(3762,7749,40720,1539,2,3430,'App\\Models\\Receipt',3430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',73300.00,NULL,NULL,1,'2023-07-05 10:50:38','2023-07-05 10:50:38',NULL),(3763,7749,40720,1539,2,3431,'App\\Models\\Receipt',3431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',36000.00,NULL,NULL,1,'2023-07-05 10:50:38','2023-07-05 10:50:38',NULL),(3764,7749,40720,1539,3,3432,'App\\Models\\Receipt',3432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',11099.00,NULL,NULL,1,'2023-07-05 10:51:14','2023-07-05 10:51:14',NULL),(3765,7749,40720,1539,3,3433,'App\\Models\\Receipt',3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',204957.42,NULL,NULL,1,'2023-07-05 10:51:14','2023-08-15 12:55:34','2023-08-15 12:55:34'),(3766,7749,40720,1539,3,3434,'App\\Models\\Receipt',3434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',80174.18,NULL,NULL,1,'2023-07-05 10:51:14','2023-07-05 10:51:14',NULL),(3767,7749,40720,1539,3,3435,'App\\Models\\Receipt',3435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',7599.96,NULL,NULL,1,'2023-07-05 10:51:14','2023-07-05 10:51:14',NULL),(3768,7749,40720,1539,3,3436,'App\\Models\\Receipt',3436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',1381.74,NULL,NULL,1,'2023-07-05 10:51:14','2023-07-05 10:51:14',NULL),(3769,7749,40720,1539,3,3437,'App\\Models\\Receipt',3437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',3184.63,NULL,NULL,1,'2023-07-05 10:51:14','2023-07-05 10:51:14',NULL),(3770,7749,40720,1539,3,3438,'App\\Models\\Receipt',3438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',895.83,NULL,NULL,1,'2023-07-05 10:51:14','2023-07-05 10:51:14',NULL),(3771,7749,40720,1539,3,3439,'App\\Models\\Receipt',3439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',1560.55,NULL,NULL,1,'2023-07-05 10:51:14','2023-07-05 10:51:14',NULL),(3772,7749,40720,1539,3,3440,'App\\Models\\Receipt',3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',510.10,NULL,NULL,1,'2023-07-05 10:51:14','2023-07-05 10:51:14',NULL),(3773,7749,40720,1539,3,3441,'App\\Models\\Receipt',3441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',1071.48,NULL,NULL,1,'2023-07-05 10:51:14','2023-07-05 10:51:14',NULL),(3774,7749,40720,1539,3,3442,'App\\Models\\Receipt',3442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',1619.66,NULL,NULL,1,'2023-07-05 10:51:14','2023-07-05 10:51:14',NULL),(3775,7749,40720,1539,3,3443,'App\\Models\\Receipt',3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',1275.24,NULL,NULL,1,'2023-07-05 10:51:14','2023-07-05 10:51:14',NULL),(3776,7749,40720,1539,3,3444,'App\\Models\\Receipt',3444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',1016.37,NULL,NULL,1,'2023-07-05 10:51:14','2023-07-05 10:51:14',NULL);
INSERT INTO `balance_libro` VALUES (3777,7749,40720,1538,3,3445,'App\\Models\\Receipt',3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',50680.06,NULL,NULL,1,'2023-07-05 10:51:29','2023-07-05 10:51:29',NULL),(3778,7749,40720,1538,3,3446,'App\\Models\\Receipt',3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',36968.27,NULL,NULL,1,'2023-07-05 10:51:29','2023-07-05 10:51:29',NULL),(3779,7749,40720,1538,3,3447,'App\\Models\\Receipt',3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',33748.55,NULL,NULL,1,'2023-07-05 10:51:29','2023-07-05 10:51:29',NULL),(3780,7749,40720,1538,3,3448,'App\\Models\\Receipt',3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',8101.25,NULL,NULL,1,'2023-07-05 10:51:29','2023-07-05 10:51:29',NULL),(3781,7749,40720,1538,3,3449,'App\\Models\\Receipt',3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',23538.14,NULL,NULL,1,'2023-07-05 10:51:29','2023-07-05 10:51:29',NULL),(3782,7749,40720,1538,3,3450,'App\\Models\\Receipt',3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',94206.18,NULL,NULL,1,'2023-07-05 10:51:29','2023-07-05 10:51:29',NULL),(3783,7749,40720,1538,3,3451,'App\\Models\\Receipt',3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',204705.38,NULL,NULL,1,'2023-07-05 10:51:30','2023-07-05 10:51:30',NULL),(3784,7749,40720,1538,3,3452,'App\\Models\\Receipt',3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',157106.10,NULL,NULL,1,'2023-07-05 10:51:30','2023-07-05 10:51:30',NULL),(3785,7749,40720,1538,3,3453,'App\\Models\\Receipt',3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',128590.19,NULL,NULL,1,'2023-07-05 10:51:30','2023-07-05 10:51:30',NULL),(3786,7749,40720,1538,3,3454,'App\\Models\\Receipt',3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',9714.73,NULL,NULL,1,'2023-07-05 10:51:30','2023-07-05 10:51:30',NULL),(3787,7749,40720,1538,3,3455,'App\\Models\\Receipt',3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',162331.65,NULL,NULL,1,'2023-07-05 10:51:30','2023-07-05 10:51:30',NULL),(3788,7749,40720,1538,3,3456,'App\\Models\\Receipt',3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',13540.65,NULL,NULL,1,'2023-07-05 10:51:30','2023-07-05 10:51:30',NULL),(3789,7749,40720,1538,3,3457,'App\\Models\\Receipt',3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',42947.29,NULL,NULL,1,'2023-07-05 10:51:30','2023-07-05 10:51:30',NULL),(3790,7749,40720,1538,3,3458,'App\\Models\\Receipt',3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',12237.39,NULL,NULL,1,'2023-07-05 10:51:30','2023-07-05 10:51:30',NULL),(3791,7749,40720,1538,3,3459,'App\\Models\\Receipt',3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',169692.75,NULL,NULL,1,'2023-07-05 10:51:30','2023-07-05 10:51:30',NULL),(3792,7749,40720,1538,3,3460,'App\\Models\\Receipt',3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',156438.77,NULL,NULL,1,'2023-07-05 10:51:30','2023-07-05 10:51:30',NULL),(3793,7749,40720,1538,3,3461,'App\\Models\\Receipt',3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',29612.93,NULL,NULL,1,'2023-07-05 10:51:30','2023-07-13 12:47:17','2023-07-13 12:47:17'),(3794,7749,40720,1538,3,3462,'App\\Models\\Receipt',3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',118817.38,NULL,NULL,1,'2023-07-05 10:51:30','2023-07-05 10:51:30',NULL),(3795,7749,40720,1538,3,3463,'App\\Models\\Receipt',3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',11624.62,NULL,NULL,1,'2023-07-05 10:51:30','2023-07-11 12:04:08','2023-07-11 12:04:08'),(3796,7749,40720,1538,3,3464,'App\\Models\\Receipt',3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',12038.88,NULL,NULL,1,'2023-07-05 10:51:31','2023-07-11 12:01:52','2023-07-11 12:01:52');
INSERT INTO `balance_libro` VALUES (3797,7749,40720,1538,3,3465,'App\\Models\\Receipt',3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',12467.15,NULL,NULL,1,'2023-07-05 10:51:31','2023-07-05 10:51:31',NULL),(3798,7749,40720,1538,3,3466,'App\\Models\\Receipt',3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',7608.16,NULL,NULL,1,'2023-07-05 10:51:31','2023-07-13 12:22:21','2023-07-13 12:22:21'),(3799,7749,40720,1538,3,3467,'App\\Models\\Receipt',3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4273.16,NULL,NULL,1,'2023-07-05 10:51:31','2023-07-05 10:51:31',NULL),(3800,7749,40720,1538,3,3468,'App\\Models\\Receipt',3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',6811.45,NULL,NULL,1,'2023-07-05 10:51:31','2023-07-05 10:51:31',NULL),(3801,7749,40720,1538,3,3469,'App\\Models\\Receipt',3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5020.63,NULL,NULL,1,'2023-07-05 10:51:31','2023-07-05 10:51:31',NULL),(3802,7749,40720,1538,3,3470,'App\\Models\\Receipt',3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',6864.72,NULL,NULL,1,'2023-07-05 10:51:31','2023-07-05 10:51:31',NULL),(3803,7749,40720,1538,3,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',9271.96,NULL,NULL,1,'2023-07-05 10:51:31','2023-07-05 10:51:31',NULL),(3804,7749,40720,1538,3,3472,'App\\Models\\Receipt',3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4776.61,NULL,NULL,1,'2023-07-05 10:51:31','2023-07-05 10:51:31',NULL),(3805,7749,40720,1538,3,3473,'App\\Models\\Receipt',3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',18087.96,NULL,NULL,1,'2023-07-05 10:51:31','2023-07-05 10:51:31',NULL),(3806,7749,40720,1538,3,3474,'App\\Models\\Receipt',3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',11505.53,NULL,NULL,1,'2023-07-05 10:51:31','2023-07-05 10:51:31',NULL),(3807,7749,40720,1538,3,3475,'App\\Models\\Receipt',3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4663.52,NULL,NULL,1,'2023-07-05 10:51:31','2023-07-05 10:51:31',NULL),(3808,7749,40720,1538,3,3476,'App\\Models\\Receipt',3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5987.89,NULL,NULL,1,'2023-07-05 10:51:31','2023-07-05 10:51:31',NULL),(3809,7749,40720,1538,3,3477,'App\\Models\\Receipt',3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1298.06,NULL,NULL,1,'2023-07-05 10:51:32','2023-07-05 10:51:32',NULL),(3810,7749,40720,1538,3,3478,'App\\Models\\Receipt',3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',22440.06,NULL,NULL,1,'2023-07-05 10:51:32','2023-07-05 10:51:32',NULL),(3811,7749,40720,1538,3,3479,'App\\Models\\Receipt',3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',49653.80,NULL,NULL,1,'2023-07-05 10:51:32','2023-07-05 10:51:32',NULL),(3812,7749,40720,1538,3,3480,'App\\Models\\Receipt',3480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',10944.83,NULL,NULL,1,'2023-07-05 10:51:32','2023-07-05 10:51:32',NULL),(3813,7749,40720,1538,3,3481,'App\\Models\\Receipt',3481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',12224.32,NULL,NULL,1,'2023-07-05 10:51:32','2023-07-05 10:51:32',NULL),(3814,7749,40720,1538,3,3482,'App\\Models\\Receipt',3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',15245.95,NULL,NULL,1,'2023-07-05 10:51:32','2023-07-05 10:51:32',NULL),(3815,7749,40720,1538,3,3483,'App\\Models\\Receipt',3483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',15112.30,NULL,NULL,1,'2023-07-05 10:51:32','2023-07-05 10:51:32',NULL),(3816,7749,40720,1538,3,3484,'App\\Models\\Receipt',3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',17693.70,NULL,NULL,1,'2023-07-05 10:51:32','2023-07-05 10:51:32',NULL),(3817,7749,40720,1538,3,3485,'App\\Models\\Receipt',3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',2161.19,NULL,NULL,1,'2023-07-05 10:51:32','2023-07-05 10:51:32',NULL);
INSERT INTO `balance_libro` VALUES (3818,7749,40720,1538,3,3486,'App\\Models\\Receipt',3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1706.12,NULL,NULL,1,'2023-07-05 10:51:32','2023-07-05 10:51:32',NULL),(3819,7749,40720,1538,3,3487,'App\\Models\\Receipt',3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4418.91,NULL,NULL,1,'2023-07-05 10:51:32','2023-07-05 10:51:32',NULL),(3820,7749,40720,1538,3,3488,'App\\Models\\Receipt',3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',5311.16,NULL,NULL,1,'2023-07-05 10:51:32','2023-07-05 10:51:32',NULL),(3821,7749,40720,1538,3,3489,'App\\Models\\Receipt',3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',7598.74,NULL,NULL,1,'2023-07-05 10:51:32','2023-07-05 10:51:32',NULL),(3822,7749,40720,1538,3,3490,'App\\Models\\Receipt',3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',2025.60,NULL,NULL,1,'2023-07-05 10:51:33','2023-07-05 10:51:33',NULL),(3823,7749,40720,1538,2,3491,'App\\Models\\Receipt',3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',6000.03,NULL,NULL,1,'2023-07-10 10:02:56','2023-07-10 10:02:56',NULL),(3824,7749,40720,1538,2,3492,'App\\Models\\Receipt',3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',842689.63,NULL,NULL,1,'2023-07-10 10:02:56','2023-07-10 10:02:56',NULL),(3825,7749,40720,1538,2,3493,'App\\Models\\Receipt',3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',842689.63,NULL,NULL,1,'2023-07-10 10:02:56','2023-07-10 10:02:56',NULL),(3826,7749,40720,1538,2,3494,'App\\Models\\Receipt',3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',54799.98,NULL,NULL,1,'2023-07-10 10:03:19','2023-07-10 10:11:26','2023-07-10 10:11:26'),(3827,7749,40720,1538,2,3495,'App\\Models\\Receipt',3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',15299.93,NULL,NULL,1,'2023-07-10 10:03:19','2023-07-10 10:11:47','2023-07-10 10:11:47'),(3828,7749,40720,1538,2,3496,'App\\Models\\Receipt',3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',17609.99,NULL,NULL,1,'2023-07-10 10:03:19','2023-07-10 10:12:09','2023-07-10 10:12:09'),(3829,7749,40720,1538,2,3497,'App\\Models\\Receipt',3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',46750.02,NULL,NULL,1,'2023-07-10 10:03:19','2023-07-10 10:12:29','2023-07-10 10:12:29'),(3830,7749,40720,1538,2,3498,'App\\Models\\Receipt',3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',13500.03,NULL,NULL,1,'2023-07-10 10:03:19','2023-07-10 10:12:49','2023-07-10 10:12:49'),(3831,7749,40720,1538,2,3499,'App\\Models\\Receipt',3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',18369.93,NULL,NULL,1,'2023-07-10 10:03:19','2023-07-10 10:13:09','2023-07-10 10:13:09'),(3832,7749,40720,1538,2,3500,'App\\Models\\Receipt',3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',24959.94,NULL,NULL,1,'2023-07-10 10:03:19','2023-07-10 10:13:28','2023-07-10 10:13:28'),(3833,7749,40720,1538,2,3501,'App\\Models\\Receipt',3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',9699.99,NULL,NULL,1,'2023-07-10 10:03:37','2023-07-10 10:03:37',NULL),(3834,7749,40720,1538,2,3502,'App\\Models\\Receipt',3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',45099.98,NULL,NULL,1,'2023-07-10 10:03:37','2023-07-10 10:03:37',NULL),(3835,7749,40720,1538,2,3503,'App\\Models\\Receipt',3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',999.98,NULL,NULL,1,'2023-07-10 10:03:37','2023-07-10 10:03:37',NULL),(3836,7749,40720,1538,2,3504,'App\\Models\\Receipt',3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',2299.98,NULL,NULL,1,'2023-07-10 10:03:37','2023-07-10 10:03:37',NULL),(3837,7749,40720,1538,2,3505,'App\\Models\\Receipt',3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',5999.99,NULL,NULL,1,'2023-07-10 10:03:37','2023-07-10 10:03:37',NULL);
INSERT INTO `balance_libro` VALUES (3838,7749,40720,1538,2,3506,'App\\Models\\Receipt',3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',5999.99,NULL,NULL,1,'2023-07-10 10:03:37','2023-07-10 10:03:37',NULL),(3839,7749,40720,1538,2,3507,'App\\Models\\Receipt',3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',4159.98,NULL,NULL,1,'2023-07-10 10:03:37','2023-07-10 10:03:37',NULL),(3840,7749,40720,1538,2,3508,'App\\Models\\Receipt',3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',13450.01,NULL,NULL,1,'2023-07-10 10:03:37','2023-07-10 10:03:37',NULL),(3841,7749,40720,1538,2,3509,'App\\Models\\Receipt',3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',4200.03,NULL,NULL,1,'2023-07-10 10:03:37','2023-07-10 10:03:37',NULL),(3842,7749,40720,1538,2,3510,'App\\Models\\Receipt',3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',16999.98,NULL,NULL,1,'2023-07-10 10:03:37','2023-07-10 10:03:37',NULL),(3843,7749,40720,1538,2,3511,'App\\Models\\Receipt',3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',24700.02,NULL,NULL,1,'2023-07-10 10:03:37','2023-07-10 10:03:37',NULL),(3844,7749,40720,1538,2,3512,'App\\Models\\Receipt',3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',850.00,NULL,NULL,1,'2023-07-10 10:03:38','2023-07-10 10:03:38',NULL),(3845,7749,40720,1538,2,3513,'App\\Models\\Receipt',3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',2900.02,NULL,NULL,1,'2023-07-10 10:03:38','2023-07-10 10:03:38',NULL),(3846,7749,40720,1538,2,3514,'App\\Models\\Receipt',3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',8500.02,NULL,NULL,1,'2023-07-10 10:03:38','2023-07-10 10:03:38',NULL),(3847,7749,40720,1538,2,3515,'App\\Models\\Receipt',3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',2099.98,NULL,NULL,1,'2023-07-10 10:03:38','2023-07-10 10:03:38',NULL),(3848,7749,40720,1538,2,3516,'App\\Models\\Receipt',3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',1500.00,NULL,NULL,1,'2023-07-10 10:03:38','2023-07-10 10:03:38',NULL),(3849,7749,40720,1538,2,3517,'App\\Models\\Receipt',3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',3059.97,NULL,NULL,1,'2023-07-10 10:03:38','2023-07-10 10:03:38',NULL),(3850,7749,40720,1538,2,3518,'App\\Models\\Receipt',3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',5369.98,NULL,NULL,1,'2023-07-10 10:03:38','2023-07-10 10:03:38',NULL),(3851,7749,40720,1538,2,3519,'App\\Models\\Receipt',3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',3120.01,NULL,NULL,1,'2023-07-10 10:03:38','2023-07-10 10:03:38',NULL),(3852,7749,40720,1538,2,3520,'App\\Models\\Receipt',3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',2119.98,NULL,NULL,1,'2023-07-10 10:03:38','2023-07-10 10:03:38',NULL),(3853,7749,40720,1538,2,3521,'App\\Models\\Receipt',3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',3199.99,NULL,NULL,1,'2023-07-10 10:03:38','2023-07-10 10:03:38',NULL),(3854,7749,40720,1538,2,3522,'App\\Models\\Receipt',3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',3599.98,NULL,NULL,1,'2023-07-10 10:03:38','2023-07-10 10:03:38',NULL),(3855,7749,40720,1538,2,3523,'App\\Models\\Receipt',3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',20559.97,NULL,NULL,1,'2023-07-10 10:03:38','2023-07-10 10:03:38',NULL),(3856,7749,40720,1538,2,3524,'App\\Models\\Receipt',3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',799.98,NULL,NULL,1,'2023-07-10 10:03:38','2023-07-10 10:03:38',NULL),(3857,7749,40720,1538,2,3494,'App\\Models\\Receipt',3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',178570.00,NULL,NULL,1,'2023-07-10 10:11:26','2023-07-10 10:11:26',NULL),(3858,7749,40720,1538,2,3495,'App\\Models\\Receipt',3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',132830.00,NULL,NULL,1,'2023-07-10 10:11:47','2023-07-10 10:11:47',NULL);
INSERT INTO `balance_libro` VALUES (3859,7749,40720,1538,2,3496,'App\\Models\\Receipt',3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',151349.99,NULL,NULL,1,'2023-07-10 10:12:09','2023-07-10 10:12:09',NULL),(3860,7749,40720,1538,2,3497,'App\\Models\\Receipt',3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',142260.01,NULL,NULL,1,'2023-07-10 10:12:29','2023-07-10 10:12:29',NULL),(3861,7749,40720,1538,2,3498,'App\\Models\\Receipt',3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',154799.99,NULL,NULL,1,'2023-07-10 10:12:49','2023-07-10 10:12:49',NULL),(3862,7749,40720,1538,2,3499,'App\\Models\\Receipt',3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',203830.01,NULL,NULL,1,'2023-07-10 10:13:09','2023-07-10 10:13:09',NULL),(3863,7749,40720,1538,2,3500,'App\\Models\\Receipt',3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',135370.00,NULL,NULL,1,'2023-07-10 10:13:28','2023-07-10 10:13:28',NULL),(3864,7749,40720,1538,3,3179,'App\\Models\\Receipt',3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',22543.90,NULL,NULL,1,'2023-07-11 11:35:26','2023-07-11 11:35:26',NULL),(3865,7749,40720,1538,3,3199,'App\\Models\\Receipt',3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',243502.03,NULL,NULL,1,'2023-07-11 11:43:42','2023-07-11 11:43:42',NULL),(3866,7749,40720,1538,3,3525,'App\\Models\\Receipt',3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',4000.11,NULL,NULL,1,'2023-07-11 11:45:39','2023-07-11 11:45:39',NULL),(3867,7749,40720,1538,3,3214,'App\\Models\\Receipt',3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',113782.99,NULL,NULL,1,'2023-07-11 11:49:20','2023-07-11 11:49:20',NULL),(3868,7749,40720,1538,3,3220,'App\\Models\\Receipt',3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',164217.77,NULL,NULL,1,'2023-07-11 11:51:03','2023-07-11 11:51:03',NULL),(3869,7749,40720,1538,3,3225,'App\\Models\\Receipt',3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',414586.50,NULL,NULL,1,'2023-07-11 11:53:04','2023-07-11 11:53:04',NULL),(3870,7749,40720,1538,3,3298,'App\\Models\\Receipt',3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',11624.50,NULL,NULL,1,'2023-07-11 11:57:11','2023-07-11 11:57:11',NULL),(3871,7749,40720,1538,3,3526,'App\\Models\\Receipt',3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',21800.00,NULL,NULL,1,'2023-07-11 12:00:29','2023-07-11 12:00:29',NULL),(3872,7749,40720,1538,3,3464,'App\\Models\\Receipt',3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',12038.88,NULL,NULL,1,'2023-07-11 12:01:52','2023-07-11 12:01:52',NULL),(3873,7749,40720,1538,3,3200,'App\\Models\\Receipt',3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',7609.34,NULL,NULL,1,'2023-07-13 12:09:10','2023-07-13 12:09:10',NULL),(3874,7749,40720,1538,3,3190,'App\\Models\\Receipt',3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',404359.28,NULL,NULL,1,'2023-07-13 12:10:06','2023-07-13 12:10:06',NULL),(3875,7749,40720,1538,3,3466,'App\\Models\\Receipt',3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',7608.15,NULL,NULL,1,'2023-07-13 12:22:21','2023-07-13 12:22:21',NULL),(3876,7749,40720,1538,3,3461,'App\\Models\\Receipt',3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',29612.94,NULL,NULL,1,'2023-07-13 12:47:17','2023-07-13 12:47:17',NULL),(3877,7749,40720,1538,3,3185,'App\\Models\\Receipt',3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',212102.28,NULL,NULL,1,'2023-07-13 12:55:48','2023-07-13 12:55:48',NULL),(3878,7749,40720,1539,2,3527,'App\\Models\\Receipt',3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',9249.99,NULL,NULL,1,'2023-07-17 11:24:01','2023-07-17 11:24:01',NULL),(3879,7749,40720,1539,2,3528,'App\\Models\\Receipt',3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',1500.00,NULL,NULL,1,'2023-07-17 11:24:02','2023-07-17 11:24:02',NULL);
INSERT INTO `balance_libro` VALUES (3880,7749,40720,1539,2,3529,'App\\Models\\Receipt',3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',19050.01,NULL,NULL,1,'2023-07-17 11:24:02','2023-07-17 11:24:02',NULL),(3881,7749,40720,1539,2,3530,'App\\Models\\Receipt',3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',399.99,NULL,NULL,1,'2023-07-17 11:24:02','2023-07-17 11:24:02',NULL),(3882,7749,40720,1539,2,3531,'App\\Models\\Receipt',3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',520.01,NULL,NULL,1,'2023-07-17 11:24:02','2023-07-17 11:24:02',NULL),(3883,7749,40720,1539,2,3532,'App\\Models\\Receipt',3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',6919.99,NULL,NULL,1,'2023-07-17 11:24:02','2023-07-17 11:24:02',NULL),(3884,7749,40720,1539,2,3533,'App\\Models\\Receipt',3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',999.98,NULL,NULL,1,'2023-07-17 11:24:02','2023-07-17 11:24:02',NULL),(3885,7749,40720,1539,2,3534,'App\\Models\\Receipt',3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',7899.97,NULL,NULL,1,'2023-07-17 11:24:02','2023-07-17 11:24:02',NULL),(3886,7749,40720,1539,2,3535,'App\\Models\\Receipt',3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',999.98,NULL,NULL,1,'2023-07-17 11:24:02','2023-07-17 11:24:02',NULL),(3887,7749,40720,1539,2,3536,'App\\Models\\Receipt',3536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',1500.00,NULL,NULL,1,'2023-07-17 11:24:02','2023-07-17 11:24:02',NULL),(3888,7749,40720,1539,2,3537,'App\\Models\\Receipt',3537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',4800.01,NULL,NULL,1,'2023-07-17 11:24:03','2023-07-17 11:24:03',NULL),(3889,7749,40720,1539,2,3538,'App\\Models\\Receipt',3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',4649.97,NULL,NULL,1,'2023-07-17 11:24:03','2023-07-17 11:24:03',NULL),(3890,7749,40720,1539,2,3539,'App\\Models\\Receipt',3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',12200.03,NULL,NULL,1,'2023-07-17 11:24:03','2023-07-17 11:24:03',NULL),(3891,7749,40720,1539,2,3540,'App\\Models\\Receipt',3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',1400.03,NULL,NULL,1,'2023-07-17 11:24:03','2023-07-17 11:24:03',NULL),(3892,7749,40720,1539,2,3541,'App\\Models\\Receipt',3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',480.02,NULL,NULL,1,'2023-07-17 11:24:03','2023-07-17 11:24:03',NULL),(3893,7749,40720,1539,2,3542,'App\\Models\\Receipt',3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',1150.02,NULL,NULL,1,'2023-07-17 11:24:03','2023-07-17 11:24:03',NULL),(3894,7749,40720,1539,3,3543,'App\\Models\\Receipt',3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',77097.07,NULL,NULL,1,'2023-07-17 12:41:15','2023-07-17 12:41:15',NULL),(3895,7749,40720,1539,3,3544,'App\\Models\\Receipt',3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',104777.86,NULL,NULL,1,'2023-07-17 12:41:35','2023-07-17 12:41:35',NULL),(3896,7749,40720,1539,3,3545,'App\\Models\\Receipt',3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',151443.96,NULL,NULL,1,'2023-07-17 12:41:51','2023-07-17 12:41:51',NULL),(3897,7749,40720,1539,3,3546,'App\\Models\\Receipt',3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',9999.98,NULL,NULL,1,'2023-07-17 12:42:36','2023-07-17 12:42:36',NULL),(3898,7749,40720,1539,3,3547,'App\\Models\\Receipt',3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',70123.54,NULL,NULL,1,'2023-07-17 12:43:04','2023-07-17 12:43:04',NULL),(3899,7749,40720,1539,3,3548,'App\\Models\\Receipt',3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',17683.19,NULL,NULL,1,'2023-07-17 12:43:21','2023-07-17 12:43:21',NULL),(3900,7749,40720,1539,3,3549,'App\\Models\\Receipt',3549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',43431.98,NULL,NULL,1,'2023-07-17 12:43:36','2023-07-17 12:43:36',NULL);
INSERT INTO `balance_libro` VALUES (3901,7749,40720,1539,2,3550,'App\\Models\\Receipt',3550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',142905.01,NULL,NULL,1,'2023-07-17 12:49:42','2023-07-17 12:49:42',NULL),(3902,7749,40720,1539,2,3551,'App\\Models\\Receipt',3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-02','2023-07-02',164120.00,NULL,NULL,1,'2023-07-17 12:50:21','2023-07-31 12:50:57','2023-07-31 12:50:57'),(3903,7749,40720,1539,2,3552,'App\\Models\\Receipt',3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',160300.00,NULL,NULL,1,'2023-07-17 12:51:00','2023-07-17 12:51:00',NULL),(3904,7749,40720,1539,2,3553,'App\\Models\\Receipt',3553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',157770.00,NULL,NULL,1,'2023-07-17 12:51:30','2023-07-17 12:51:30',NULL),(3905,7749,40720,1539,2,3554,'App\\Models\\Receipt',3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',268075.00,NULL,NULL,1,'2023-07-17 12:52:05','2023-07-17 12:52:05',NULL),(3906,7749,40720,1539,2,3555,'App\\Models\\Receipt',3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',245855.05,NULL,NULL,1,'2023-07-17 12:53:29','2023-07-17 12:53:29',NULL),(3907,7749,40720,1539,2,3556,'App\\Models\\Receipt',3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',218110.00,NULL,NULL,1,'2023-07-17 12:55:28','2023-07-17 12:55:28',NULL),(3908,7749,40720,1539,2,3557,'App\\Models\\Receipt',3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',157370.00,NULL,NULL,1,'2023-07-17 12:56:04','2023-07-17 12:56:04',NULL),(3909,7749,40720,1539,2,3558,'App\\Models\\Receipt',3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',149190.00,NULL,NULL,1,'2023-07-17 12:56:29','2023-07-17 12:56:29',NULL),(3910,7749,40720,1539,2,3559,'App\\Models\\Receipt',3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',167580.23,NULL,NULL,1,'2023-07-17 12:57:47','2023-07-17 12:57:47',NULL),(3911,7749,40720,1539,2,3560,'App\\Models\\Receipt',3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',181720.00,NULL,NULL,1,'2023-07-17 12:58:09','2023-07-17 12:58:09',NULL),(3912,7749,40720,1539,2,3561,'App\\Models\\Receipt',3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',0.10,NULL,NULL,1,'2023-07-17 13:01:53','2023-07-17 13:01:53',NULL),(3913,7749,40720,1539,2,3562,'App\\Models\\Receipt',3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',79.99,NULL,NULL,1,'2023-07-17 13:02:31','2023-07-17 13:04:08','2023-07-17 13:04:08'),(3914,7749,40720,1539,2,3563,'App\\Models\\Receipt',3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',80000.00,NULL,NULL,1,'2023-07-17 13:03:31','2023-07-17 13:05:07','2023-07-17 13:05:07'),(3915,7749,40720,1539,2,3562,'App\\Models\\Receipt',3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',79.99,NULL,NULL,1,'2023-07-17 13:04:08','2023-07-17 13:04:08',NULL),(3916,7749,40720,1539,2,3563,'App\\Models\\Receipt',3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',96599.99,NULL,NULL,1,'2023-07-17 13:05:07','2023-07-17 13:05:07',NULL),(3917,7749,40720,1539,2,3564,'App\\Models\\Receipt',3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',105599.99,NULL,NULL,1,'2023-07-17 13:06:15','2023-07-17 13:06:15',NULL),(3918,7749,40720,1539,2,3565,'App\\Models\\Receipt',3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',107597.50,NULL,NULL,1,'2023-07-17 13:06:16','2023-07-17 13:06:16',NULL),(3919,7749,40720,1539,2,3566,'App\\Models\\Receipt',3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',102170.00,NULL,NULL,1,'2023-07-17 13:06:16','2023-08-10 11:29:48','2023-08-10 11:29:48'),(3920,7749,40720,1539,2,3567,'App\\Models\\Receipt',3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',15000.37,NULL,NULL,1,'2023-07-17 13:06:16','2023-07-17 13:06:16',NULL);
INSERT INTO `balance_libro` VALUES (3921,7749,40720,1539,2,3568,'App\\Models\\Receipt',3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',4999.96,NULL,NULL,1,'2023-07-17 13:06:16','2023-07-17 13:06:16',NULL),(3922,7749,40720,1539,2,3569,'App\\Models\\Receipt',3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',19650.29,NULL,NULL,1,'2023-07-17 13:06:16','2023-07-17 13:06:16',NULL),(3923,7749,40720,1539,2,3570,'App\\Models\\Receipt',3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',72000.00,NULL,NULL,1,'2023-07-17 13:06:16','2023-07-17 13:06:16',NULL),(3924,7749,40720,1539,2,3571,'App\\Models\\Receipt',3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',66514.99,NULL,NULL,1,'2023-07-17 13:06:16','2023-07-17 13:06:16',NULL),(3925,7749,40720,1539,2,3572,'App\\Models\\Receipt',3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',101999.37,NULL,NULL,1,'2023-07-17 13:06:16','2023-07-17 13:06:16',NULL),(3926,7749,40720,1539,2,3573,'App\\Models\\Receipt',3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',25399.97,NULL,NULL,1,'2023-07-17 13:06:16','2023-07-17 13:06:16',NULL),(3927,7749,40720,1539,2,3574,'App\\Models\\Receipt',3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',4149.99,NULL,NULL,1,'2023-07-17 13:06:16','2023-07-17 13:06:16',NULL),(3928,7749,40720,1539,2,3575,'App\\Models\\Receipt',3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',32399.92,NULL,NULL,1,'2023-07-17 13:06:16','2023-07-17 13:06:16',NULL),(3929,7749,40720,1539,2,3576,'App\\Models\\Receipt',3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',155929.98,NULL,NULL,1,'2023-07-17 13:06:16','2023-07-17 13:06:16',NULL),(3930,7749,40720,1539,3,3577,'App\\Models\\Receipt',3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',15068.19,NULL,NULL,1,'2023-07-17 13:06:33','2023-08-14 11:48:14','2023-08-14 11:48:14'),(3931,7749,40720,1539,3,3578,'App\\Models\\Receipt',3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',133857.96,NULL,NULL,1,'2023-07-17 13:06:33','2023-07-17 13:06:33',NULL),(3932,7749,40720,1539,3,3579,'App\\Models\\Receipt',3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',28095.89,NULL,NULL,1,'2023-07-17 13:06:33','2023-07-17 13:06:33',NULL),(3933,7749,40720,1539,3,3580,'App\\Models\\Receipt',3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',195042.14,NULL,NULL,1,'2023-07-17 13:06:33','2023-07-17 13:06:33',NULL),(3934,7749,40720,1539,3,3581,'App\\Models\\Receipt',3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',209101.16,NULL,NULL,1,'2023-07-17 13:06:33','2023-08-14 10:46:58','2023-08-14 10:46:58'),(3935,7749,40720,1539,3,3582,'App\\Models\\Receipt',3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',213352.80,NULL,NULL,1,'2023-07-17 13:06:33','2023-08-14 10:49:35','2023-08-14 10:49:35'),(3936,7749,40720,1539,3,3583,'App\\Models\\Receipt',3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',220572.79,NULL,NULL,1,'2023-07-17 13:06:33','2023-07-17 13:06:33',NULL),(3937,7749,40720,1539,3,3584,'App\\Models\\Receipt',3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',243637.20,NULL,NULL,1,'2023-07-17 13:06:33','2023-07-17 13:06:33',NULL),(3938,7749,40720,1539,3,3585,'App\\Models\\Receipt',3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',232423.75,NULL,NULL,1,'2023-07-17 13:06:33','2023-07-17 13:06:33',NULL),(3939,7749,40720,1539,3,3586,'App\\Models\\Receipt',3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',459655.28,NULL,NULL,1,'2023-07-17 13:06:33','2023-08-14 10:50:34','2023-08-14 10:50:34'),(3940,7749,40720,1539,3,3587,'App\\Models\\Receipt',3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',46168.29,NULL,NULL,1,'2023-07-17 13:06:33','2023-08-15 12:31:16','2023-08-15 12:31:16');
INSERT INTO `balance_libro` VALUES (3941,7749,40720,1539,3,3588,'App\\Models\\Receipt',3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',36548.73,NULL,NULL,1,'2023-07-17 13:06:33','2023-07-17 13:06:33',NULL),(3942,7749,40720,1539,3,3589,'App\\Models\\Receipt',3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',13517.53,NULL,NULL,1,'2023-07-17 13:06:34','2023-07-17 13:06:34',NULL),(3943,7749,40720,1539,3,3590,'App\\Models\\Receipt',3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',401160.50,NULL,NULL,1,'2023-07-17 13:06:34','2023-07-17 13:06:34',NULL),(3944,7749,40720,1539,3,3591,'App\\Models\\Receipt',3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',6223.10,NULL,NULL,1,'2023-07-17 13:06:34','2023-07-17 13:06:34',NULL),(3945,7749,40720,1539,3,3592,'App\\Models\\Receipt',3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',1948.80,NULL,NULL,1,'2023-07-17 13:06:34','2023-07-17 13:06:34',NULL),(3946,7749,40720,1539,3,3593,'App\\Models\\Receipt',3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',110354.65,NULL,NULL,1,'2023-07-17 13:06:34','2023-08-14 10:52:11','2023-08-14 10:52:11'),(3947,7749,40720,1539,3,3594,'App\\Models\\Receipt',3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',240073.33,NULL,NULL,1,'2023-07-17 13:06:34','2023-07-17 13:06:34',NULL),(3948,7749,40720,1539,3,3595,'App\\Models\\Receipt',3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',286344.14,NULL,NULL,1,'2023-07-17 13:06:34','2023-08-14 10:53:09','2023-08-14 10:53:09'),(3949,7749,40720,1539,3,3596,'App\\Models\\Receipt',3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',250096.23,NULL,NULL,1,'2023-07-17 13:06:34','2023-07-17 13:06:34',NULL),(3950,7749,40720,1539,3,3597,'App\\Models\\Receipt',3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',187007.96,NULL,NULL,1,'2023-07-17 13:06:34','2023-07-17 13:06:34',NULL),(3951,7749,40720,1539,3,3598,'App\\Models\\Receipt',3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',27696.13,NULL,NULL,1,'2023-07-17 13:06:34','2023-07-17 13:06:34',NULL),(3952,7749,40720,1539,3,3599,'App\\Models\\Receipt',3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',42372.72,NULL,NULL,1,'2023-07-17 13:06:34','2023-07-17 13:06:34',NULL),(3953,7749,40720,1539,3,3600,'App\\Models\\Receipt',3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',76815.89,NULL,NULL,1,'2023-07-17 13:06:34','2023-07-17 13:06:34',NULL),(3954,7749,40720,1539,3,3601,'App\\Models\\Receipt',3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',11530.59,NULL,NULL,1,'2023-07-17 13:06:34','2023-07-17 13:06:34',NULL),(3955,7749,40720,1539,3,3602,'App\\Models\\Receipt',3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',141085.78,NULL,NULL,1,'2023-07-17 13:06:35','2023-07-17 13:06:35',NULL),(3956,7749,40720,1539,3,3603,'App\\Models\\Receipt',3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',25396.82,NULL,NULL,1,'2023-07-17 13:06:35','2023-07-17 13:06:35',NULL),(3957,7749,40720,1539,3,3604,'App\\Models\\Receipt',3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',119308.98,NULL,NULL,1,'2023-07-17 13:06:35','2023-07-17 13:06:35',NULL),(3958,7749,40720,1539,3,3605,'App\\Models\\Receipt',3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',144522.00,NULL,NULL,1,'2023-07-17 13:06:35','2023-07-17 13:06:35',NULL),(3959,7749,40720,1539,3,3606,'App\\Models\\Receipt',3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',59096.92,NULL,NULL,1,'2023-07-17 13:06:35','2023-07-17 13:06:35',NULL),(3960,7749,40720,1539,3,3607,'App\\Models\\Receipt',3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',43611.28,NULL,NULL,1,'2023-07-17 13:06:35','2023-07-17 13:06:35',NULL);
INSERT INTO `balance_libro` VALUES (3961,7749,40720,1539,3,3608,'App\\Models\\Receipt',3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',102982.18,NULL,NULL,1,'2023-07-17 13:06:35','2023-07-17 13:06:35',NULL),(3962,7749,40720,1539,3,3609,'App\\Models\\Receipt',3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',135259.83,NULL,NULL,1,'2023-07-31 12:24:29','2023-07-31 12:24:29',NULL),(3963,7749,40720,1539,3,3610,'App\\Models\\Receipt',3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',12578.36,NULL,NULL,1,'2023-07-31 12:24:29','2023-07-31 12:24:29',NULL),(3964,7749,40720,1539,3,3611,'App\\Models\\Receipt',3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',1961.07,NULL,NULL,1,'2023-07-31 12:24:29','2023-08-14 11:56:20','2023-08-14 11:56:20'),(3965,7749,40720,1539,3,3612,'App\\Models\\Receipt',3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',166479.70,NULL,NULL,1,'2023-07-31 12:24:29','2023-07-31 12:24:29',NULL),(3966,7749,40720,1539,3,3613,'App\\Models\\Receipt',3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',176172.13,NULL,NULL,1,'2023-07-31 12:24:30','2023-07-31 12:24:30',NULL),(3967,7749,40720,1539,3,3614,'App\\Models\\Receipt',3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',4311.85,NULL,NULL,1,'2023-07-31 12:24:30','2023-07-31 12:24:30',NULL),(3968,7749,40720,1539,3,3615,'App\\Models\\Receipt',3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',325797.58,NULL,NULL,1,'2023-07-31 12:24:30','2023-08-15 12:16:31','2023-08-15 12:16:31'),(3969,7749,40720,1539,3,3616,'App\\Models\\Receipt',3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',131986.84,NULL,NULL,1,'2023-07-31 12:24:30','2023-08-14 11:03:05','2023-08-14 11:03:05'),(3970,7749,40720,1539,3,3617,'App\\Models\\Receipt',3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',208061.21,NULL,NULL,1,'2023-07-31 12:24:31','2023-08-14 11:03:40','2023-08-14 11:03:40'),(3971,7749,40720,1539,3,3618,'App\\Models\\Receipt',3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',206307.52,NULL,NULL,1,'2023-07-31 12:24:31','2023-07-31 12:24:31',NULL),(3972,7749,40720,1539,3,3619,'App\\Models\\Receipt',3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',46813.11,NULL,NULL,1,'2023-07-31 12:24:31','2023-07-31 12:24:31',NULL),(3973,7749,40720,1539,3,3620,'App\\Models\\Receipt',3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',218249.00,NULL,NULL,1,'2023-07-31 12:24:31','2023-07-31 12:24:31',NULL),(3974,7749,40720,1539,3,3621,'App\\Models\\Receipt',3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',268167.39,NULL,NULL,1,'2023-07-31 12:24:32','2023-07-31 12:24:32',NULL),(3975,7749,40720,1539,3,3622,'App\\Models\\Receipt',3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',106567.87,NULL,NULL,1,'2023-07-31 12:24:32','2023-07-31 12:24:32',NULL),(3976,7749,40720,1539,3,3623,'App\\Models\\Receipt',3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',0.65,NULL,NULL,1,'2023-07-31 12:24:32','2023-07-31 12:24:32',NULL),(3977,7749,40720,1539,3,3624,'App\\Models\\Receipt',3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',222666.11,NULL,NULL,1,'2023-07-31 12:24:32','2023-07-31 12:24:32',NULL),(3978,7749,40720,1539,3,3625,'App\\Models\\Receipt',3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',268167.39,NULL,NULL,1,'2023-07-31 12:24:32','2023-07-31 12:24:32',NULL),(3979,7749,40720,1539,3,3626,'App\\Models\\Receipt',3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',325726.35,NULL,NULL,1,'2023-07-31 12:24:32','2023-07-31 12:24:32',NULL),(3980,7749,40720,1539,3,3627,'App\\Models\\Receipt',3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',40017.01,NULL,NULL,1,'2023-07-31 12:24:32','2023-07-31 12:24:32',NULL);
INSERT INTO `balance_libro` VALUES (3981,7749,40720,1539,3,3628,'App\\Models\\Receipt',3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',19450.89,NULL,NULL,1,'2023-07-31 12:24:33','2023-07-31 12:24:33',NULL),(3982,7749,40720,1539,3,3629,'App\\Models\\Receipt',3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',17557.55,NULL,NULL,1,'2023-07-31 12:24:33','2023-07-31 12:24:33',NULL),(3983,7749,40720,1539,3,3630,'App\\Models\\Receipt',3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',103519.02,NULL,NULL,1,'2023-07-31 12:24:33','2023-07-31 12:24:33',NULL),(3984,7749,40720,1539,3,3631,'App\\Models\\Receipt',3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',84735.26,NULL,NULL,1,'2023-07-31 12:24:33','2023-07-31 12:24:33',NULL),(3985,7749,40720,1539,3,3632,'App\\Models\\Receipt',3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',45626.00,NULL,NULL,1,'2023-07-31 12:24:33','2023-08-14 12:11:42','2023-08-14 12:11:42'),(3986,7749,40720,1539,3,3633,'App\\Models\\Receipt',3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',5505.50,NULL,NULL,1,'2023-07-31 12:24:33','2023-08-14 11:20:11','2023-08-14 11:20:11'),(3987,7749,40720,1539,3,3634,'App\\Models\\Receipt',3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',195095.71,NULL,NULL,1,'2023-07-31 12:24:34','2023-07-31 12:24:34',NULL),(3988,7749,40720,1539,3,3635,'App\\Models\\Receipt',3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',72591.16,NULL,NULL,1,'2023-07-31 12:24:34','2023-07-31 12:24:34',NULL),(3989,7749,40720,1539,3,3636,'App\\Models\\Receipt',3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',55890.40,NULL,NULL,1,'2023-07-31 12:24:34','2023-08-14 11:23:53','2023-08-14 11:23:53'),(3990,7749,40720,1539,3,3637,'App\\Models\\Receipt',3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',7291.71,NULL,NULL,1,'2023-07-31 12:24:34','2023-07-31 12:24:34',NULL),(3991,7749,40720,1539,3,3638,'App\\Models\\Receipt',3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',83128.72,NULL,NULL,1,'2023-07-31 12:24:34','2023-07-31 12:24:34',NULL),(3992,7749,40720,1539,3,3639,'App\\Models\\Receipt',3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',35738.25,NULL,NULL,1,'2023-07-31 12:24:34','2023-07-31 12:24:34',NULL),(3993,7749,40720,1539,3,3640,'App\\Models\\Receipt',3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',40963.86,NULL,NULL,1,'2023-07-31 12:24:34','2023-07-31 12:24:34',NULL),(3994,7749,40720,1539,3,3641,'App\\Models\\Receipt',3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',248531.35,NULL,NULL,1,'2023-07-31 12:24:35','2023-08-14 11:31:09','2023-08-14 11:31:09'),(3995,7749,40720,1539,3,3642,'App\\Models\\Receipt',3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',15710.08,NULL,NULL,1,'2023-07-31 12:24:35','2023-08-14 11:33:33','2023-08-14 11:33:33'),(3996,7749,40720,1539,3,3643,'App\\Models\\Receipt',3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',191820.22,NULL,NULL,1,'2023-07-31 12:24:35','2023-07-31 12:24:35',NULL),(3997,7749,40720,1539,3,3644,'App\\Models\\Receipt',3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',49723.67,NULL,NULL,1,'2023-07-31 12:24:35','2023-07-31 12:24:35',NULL),(3998,7749,40720,1539,3,3645,'App\\Models\\Receipt',3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',66421.64,NULL,NULL,1,'2023-07-31 12:24:35','2023-07-31 12:24:35',NULL),(3999,7749,40720,1539,3,3646,'App\\Models\\Receipt',3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',33356.37,NULL,NULL,1,'2023-07-31 12:24:35','2023-07-31 12:24:35',NULL),(4000,7749,40720,1539,3,3647,'App\\Models\\Receipt',3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',2447.70,NULL,NULL,1,'2023-07-31 12:24:35','2023-07-31 12:24:35',NULL);
INSERT INTO `balance_libro` VALUES (4001,7749,40720,1539,3,3648,'App\\Models\\Receipt',3648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',146872.33,NULL,NULL,1,'2023-07-31 12:24:36','2023-07-31 12:24:36',NULL),(4002,7749,40720,1539,3,3649,'App\\Models\\Receipt',3649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',92326.11,NULL,NULL,1,'2023-07-31 12:24:36','2023-07-31 12:24:36',NULL),(4003,7749,40720,1539,3,3650,'App\\Models\\Receipt',3650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',113593.74,NULL,NULL,1,'2023-07-31 12:24:36','2023-07-31 12:24:36',NULL),(4004,7749,40720,1539,3,3651,'App\\Models\\Receipt',3651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',22333.12,NULL,NULL,1,'2023-07-31 12:24:36','2023-07-31 12:24:36',NULL),(4005,7749,40720,1539,3,3652,'App\\Models\\Receipt',3652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',40963.86,NULL,NULL,1,'2023-07-31 12:24:36','2023-07-31 12:24:36',NULL),(4006,7749,40720,1539,3,3653,'App\\Models\\Receipt',3653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',0.00,NULL,NULL,1,'2023-07-31 12:24:36','2023-07-31 12:24:36',NULL),(4007,7749,40720,1539,3,3654,'App\\Models\\Receipt',3654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',170940.34,NULL,NULL,1,'2023-07-31 12:24:36','2023-07-31 12:24:36',NULL),(4008,7749,40720,1539,2,3655,'App\\Models\\Receipt',3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',40400.06,NULL,NULL,1,'2023-07-31 12:25:20','2023-07-31 12:33:35','2023-07-31 12:33:35'),(4009,7749,40720,1539,2,3656,'App\\Models\\Receipt',3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',6199.98,NULL,NULL,1,'2023-07-31 12:25:20','2023-07-31 12:34:14','2023-07-31 12:34:14'),(4010,7749,40720,1539,2,3657,'App\\Models\\Receipt',3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',4100.00,NULL,NULL,1,'2023-07-31 12:25:20','2023-07-31 12:34:42','2023-07-31 12:34:42'),(4011,7749,40720,1539,2,3658,'App\\Models\\Receipt',3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',2000.01,NULL,NULL,1,'2023-07-31 12:25:20','2023-07-31 12:35:15','2023-07-31 12:35:15'),(4012,7749,40720,1539,2,3659,'App\\Models\\Receipt',3659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',6313.95,NULL,NULL,1,'2023-07-31 12:25:20','2023-07-31 12:25:20',NULL),(4013,7749,40720,1539,2,3660,'App\\Models\\Receipt',3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',3424.99,NULL,NULL,1,'2023-07-31 12:25:21','2023-07-31 12:37:14','2023-07-31 12:37:14'),(4014,7749,40720,1539,2,3661,'App\\Models\\Receipt',3661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',21870.00,NULL,NULL,1,'2023-07-31 12:25:49','2023-07-31 12:25:49',NULL),(4015,7749,40720,1539,2,3662,'App\\Models\\Receipt',3662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',11999.97,NULL,NULL,1,'2023-07-31 12:25:49','2023-07-31 12:25:49',NULL),(4016,7749,40720,1539,2,3663,'App\\Models\\Receipt',3663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',799.98,NULL,NULL,1,'2023-07-31 12:25:49','2023-07-31 12:25:49',NULL),(4017,7749,40720,1539,2,3664,'App\\Models\\Receipt',3664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',1699.99,NULL,NULL,1,'2023-07-31 12:25:49','2023-07-31 12:25:49',NULL),(4018,7749,40720,1539,2,3665,'App\\Models\\Receipt',3665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',6800.03,NULL,NULL,1,'2023-07-31 12:25:49','2023-07-31 12:25:49',NULL),(4019,7749,40720,1539,2,3666,'App\\Models\\Receipt',3666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',920.00,NULL,NULL,1,'2023-07-31 12:25:49','2023-07-31 12:25:49',NULL),(4020,7749,40720,1539,2,3667,'App\\Models\\Receipt',3667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',3100.02,NULL,NULL,1,'2023-07-31 12:25:49','2023-07-31 12:25:49',NULL);
INSERT INTO `balance_libro` VALUES (4021,7749,40720,1539,2,3668,'App\\Models\\Receipt',3668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',5299.97,NULL,NULL,1,'2023-07-31 12:25:49','2023-07-31 12:25:49',NULL),(4022,7749,40720,1539,2,3669,'App\\Models\\Receipt',3669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',5000.01,NULL,NULL,1,'2023-07-31 12:25:49','2023-07-31 12:25:49',NULL),(4023,7749,40720,1539,2,3670,'App\\Models\\Receipt',3670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',3550.02,NULL,NULL,1,'2023-07-31 12:25:49','2023-07-31 12:25:49',NULL),(4024,7749,40720,1539,2,3671,'App\\Models\\Receipt',3671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',9500.00,NULL,NULL,1,'2023-07-31 12:25:49','2023-07-31 12:25:49',NULL),(4025,7749,40720,1539,2,3672,'App\\Models\\Receipt',3672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',4200.03,NULL,NULL,1,'2023-07-31 12:25:49','2023-07-31 12:25:49',NULL),(4026,7749,40720,1539,2,3673,'App\\Models\\Receipt',3673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',2999.99,NULL,NULL,1,'2023-07-31 12:25:49','2023-07-31 12:25:49',NULL),(4027,7749,40720,1539,2,3674,'App\\Models\\Receipt',3674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',4499.99,NULL,NULL,1,'2023-07-31 12:25:50','2023-07-31 12:25:50',NULL),(4028,7749,40720,1539,2,3675,'App\\Models\\Receipt',3675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',2299.98,NULL,NULL,1,'2023-07-31 12:25:50','2023-07-31 12:25:50',NULL),(4029,7749,40720,1539,2,3676,'App\\Models\\Receipt',3676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',999.98,NULL,NULL,1,'2023-07-31 12:25:50','2023-07-31 12:25:50',NULL),(4030,7749,40720,1539,2,3677,'App\\Models\\Receipt',3677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',2999.99,NULL,NULL,1,'2023-07-31 12:25:50','2023-07-31 12:25:50',NULL),(4031,7749,40720,1539,2,3678,'App\\Models\\Receipt',3678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',1500.00,NULL,NULL,1,'2023-07-31 12:25:50','2023-07-31 12:25:50',NULL),(4032,7749,40720,1539,2,3679,'App\\Models\\Receipt',3679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',999.98,NULL,NULL,1,'2023-07-31 12:25:50','2023-07-31 12:25:50',NULL),(4033,7749,40720,1539,2,3680,'App\\Models\\Receipt',3680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',5900.02,NULL,NULL,1,'2023-07-31 12:25:50','2023-07-31 12:25:50',NULL),(4034,7749,40720,1539,2,3681,'App\\Models\\Receipt',3681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',700.01,NULL,NULL,1,'2023-07-31 12:25:50','2023-07-31 12:25:50',NULL),(4035,7749,40720,1539,2,3682,'App\\Models\\Receipt',3682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',8250.01,NULL,NULL,1,'2023-07-31 12:25:50','2023-07-31 12:25:50',NULL),(4036,7749,40720,1539,2,3683,'App\\Models\\Receipt',3683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',3999.97,NULL,NULL,1,'2023-07-31 12:25:50','2023-07-31 12:25:50',NULL),(4037,7749,40720,1539,2,3684,'App\\Models\\Receipt',3684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',21099.98,NULL,NULL,1,'2023-07-31 12:25:50','2023-07-31 12:25:50',NULL),(4038,7749,40720,1539,2,3685,'App\\Models\\Receipt',3685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',1440.02,NULL,NULL,1,'2023-07-31 12:25:50','2023-07-31 12:25:50',NULL),(4039,7749,40720,1539,2,3686,'App\\Models\\Receipt',3686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',1800.02,NULL,NULL,1,'2023-07-31 12:25:50','2023-07-31 12:25:50',NULL),(4040,7749,40720,1539,2,3687,'App\\Models\\Receipt',3687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',26000.02,NULL,NULL,1,'2023-07-31 12:26:04','2023-07-31 12:26:04',NULL),(4041,7749,40720,1539,2,3688,'App\\Models\\Receipt',3688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',9600.02,NULL,NULL,1,'2023-07-31 12:26:05','2023-07-31 12:26:05',NULL);
INSERT INTO `balance_libro` VALUES (4042,7749,40720,1539,2,3689,'App\\Models\\Receipt',3689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',4800.01,NULL,NULL,1,'2023-07-31 12:26:05','2023-07-31 12:26:05',NULL),(4043,7749,40720,1539,2,3690,'App\\Models\\Receipt',3690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',700.01,NULL,NULL,1,'2023-07-31 12:26:05','2023-07-31 12:26:05',NULL),(4044,7749,40720,1539,2,3691,'App\\Models\\Receipt',3691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',2499.98,NULL,NULL,1,'2023-07-31 12:26:05','2023-07-31 12:26:05',NULL),(4045,7749,40720,1539,2,3692,'App\\Models\\Receipt',3692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',2999.99,NULL,NULL,1,'2023-07-31 12:26:05','2023-07-31 12:26:05',NULL),(4046,7749,40720,1539,2,3693,'App\\Models\\Receipt',3693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',4100.00,NULL,NULL,1,'2023-07-31 12:26:05','2023-07-31 12:26:05',NULL),(4047,7749,40720,1539,2,3694,'App\\Models\\Receipt',3694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',2000.01,NULL,NULL,1,'2023-07-31 12:26:06','2023-07-31 12:26:06',NULL),(4048,7749,40720,1539,2,3695,'App\\Models\\Receipt',3695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',2760.01,NULL,NULL,1,'2023-07-31 12:26:06','2023-07-31 12:26:06',NULL),(4049,7749,40720,1539,2,3696,'App\\Models\\Receipt',3696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',1125.01,NULL,NULL,1,'2023-07-31 12:26:06','2023-07-31 12:26:06',NULL),(4050,7749,40720,1539,2,3697,'App\\Models\\Receipt',3697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',1100.01,NULL,NULL,1,'2023-07-31 12:26:06','2023-07-31 12:26:06',NULL),(4051,7749,40720,1539,2,3698,'App\\Models\\Receipt',3698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',1199.97,NULL,NULL,1,'2023-07-31 12:26:06','2023-07-31 12:26:06',NULL),(4052,7749,40720,1539,2,3699,'App\\Models\\Receipt',3699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',16449.98,NULL,NULL,1,'2023-07-31 12:29:51','2023-07-31 12:29:51',NULL),(4053,7749,40720,1539,2,3700,'App\\Models\\Receipt',3700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',21956.00,NULL,NULL,1,'2023-07-31 12:29:52','2023-07-31 12:29:52',NULL),(4054,7749,40720,1539,2,3701,'App\\Models\\Receipt',3701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',242860.00,NULL,NULL,1,'2023-07-31 12:32:45','2023-07-31 12:32:45',NULL),(4055,7749,40720,1539,2,3655,'App\\Models\\Receipt',3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',126100.00,NULL,NULL,1,'2023-07-31 12:33:35','2023-07-31 12:33:35',NULL),(4056,7749,40720,1539,2,3656,'App\\Models\\Receipt',3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',187115.01,NULL,NULL,1,'2023-07-31 12:34:14','2023-07-31 12:34:14',NULL),(4057,7749,40720,1539,2,3657,'App\\Models\\Receipt',3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',117810.00,NULL,NULL,1,'2023-07-31 12:34:42','2023-07-31 12:34:42',NULL),(4058,7749,40720,1539,2,3658,'App\\Models\\Receipt',3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',164960.00,NULL,NULL,1,'2023-07-31 12:35:15','2023-07-31 12:35:15',NULL),(4059,7749,40720,1539,2,3702,'App\\Models\\Receipt',3702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',128200.00,NULL,NULL,1,'2023-07-31 12:36:54','2023-07-31 12:36:54',NULL),(4060,7749,40720,1539,2,3660,'App\\Models\\Receipt',3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',188805.00,NULL,NULL,1,'2023-07-31 12:37:14','2023-07-31 12:37:14',NULL),(4061,7749,40720,1539,2,3703,'App\\Models\\Receipt',3703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',109730.00,NULL,NULL,1,'2023-07-31 12:38:20','2023-07-31 12:38:20',NULL),(4062,7749,40720,1539,2,3704,'App\\Models\\Receipt',3704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',155270.00,NULL,NULL,1,'2023-07-31 12:38:59','2023-07-31 12:38:59',NULL);
INSERT INTO `balance_libro` VALUES (4063,7749,40720,1539,2,3705,'App\\Models\\Receipt',3705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',259100.00,NULL,NULL,1,'2023-07-31 12:39:25','2023-07-31 12:39:25',NULL),(4064,7749,40720,1539,2,3706,'App\\Models\\Receipt',3706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',211560.01,NULL,NULL,1,'2023-07-31 12:39:53','2023-07-31 12:39:53',NULL),(4065,7749,40720,1539,2,3707,'App\\Models\\Receipt',3707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',276683.00,NULL,NULL,1,'2023-07-31 12:40:27','2023-07-31 12:40:27',NULL),(4066,7749,40720,1539,2,3708,'App\\Models\\Receipt',3708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',139249.99,NULL,NULL,1,'2023-07-31 12:40:59','2023-07-31 12:42:50','2023-07-31 12:42:50'),(4067,7749,40720,1539,2,3709,'App\\Models\\Receipt',3709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',123720.00,NULL,NULL,1,'2023-07-31 12:42:22','2023-07-31 12:42:22',NULL),(4068,7749,40720,1539,2,3708,'App\\Models\\Receipt',3708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',139249.99,NULL,NULL,1,'2023-07-31 12:42:50','2023-07-31 12:42:50',NULL),(4069,7749,40720,1539,2,3551,'App\\Models\\Receipt',3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',164120.00,NULL,NULL,1,'2023-07-31 12:50:57','2023-07-31 12:50:57',NULL),(4070,7749,40720,1539,2,3710,'App\\Models\\Receipt',3710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',29292.49,NULL,NULL,1,'2023-08-01 09:20:42','2023-08-01 09:20:42',NULL),(4071,7749,40720,1539,2,3711,'App\\Models\\Receipt',3711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',29292.49,NULL,NULL,1,'2023-08-01 09:20:42','2023-08-01 09:20:42',NULL),(4072,7749,40720,1539,2,3712,'App\\Models\\Receipt',3712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',18499.98,NULL,NULL,1,'2023-08-01 09:20:42','2023-08-01 09:20:42',NULL),(4073,7749,40720,1539,2,3713,'App\\Models\\Receipt',3713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',12800.01,NULL,NULL,1,'2023-08-01 09:20:42','2023-08-01 09:20:42',NULL),(4074,7749,40720,1539,2,3714,'App\\Models\\Receipt',3714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',799.98,NULL,NULL,1,'2023-08-01 09:20:42','2023-08-01 09:20:42',NULL),(4075,7749,40720,1539,2,3715,'App\\Models\\Receipt',3715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',10020.01,NULL,NULL,1,'2023-08-01 09:20:42','2023-08-01 09:20:42',NULL),(4076,7749,40720,1539,2,3716,'App\\Models\\Receipt',3716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',300.02,NULL,NULL,1,'2023-08-01 09:20:43','2023-08-01 09:20:43',NULL),(4077,7749,40720,1539,2,3717,'App\\Models\\Receipt',3717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',4800.01,NULL,NULL,1,'2023-08-01 09:20:43','2023-08-01 09:20:43',NULL),(4078,7749,40720,1539,2,3718,'App\\Models\\Receipt',3718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',2949.98,NULL,NULL,1,'2023-08-01 09:20:43','2023-08-01 09:20:43',NULL),(4079,7749,40720,1539,2,3719,'App\\Models\\Receipt',3719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',799.98,NULL,NULL,1,'2023-08-01 09:20:43','2023-08-01 09:20:43',NULL),(4080,7749,40720,1539,2,3720,'App\\Models\\Receipt',3720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',399.99,NULL,NULL,1,'2023-08-01 09:20:43','2023-08-01 09:20:43',NULL),(4081,7749,40720,1539,2,3721,'App\\Models\\Receipt',3721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',900.01,NULL,NULL,1,'2023-08-01 09:20:43','2023-08-01 09:20:43',NULL),(4082,7749,40720,1539,2,3722,'App\\Models\\Receipt',3722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',11500.01,NULL,NULL,1,'2023-08-01 09:20:43','2023-08-01 09:20:43',NULL),(4083,7749,40720,1539,2,3723,'App\\Models\\Receipt',3723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',6900.00,NULL,NULL,1,'2023-08-01 09:20:43','2023-08-01 09:20:43',NULL);
INSERT INTO `balance_libro` VALUES (4084,7749,40720,1539,2,3724,'App\\Models\\Receipt',3724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',2600.00,NULL,NULL,1,'2023-08-01 09:20:43','2023-08-01 09:20:43',NULL),(4085,7749,40720,1539,2,3725,'App\\Models\\Receipt',3725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',58000.02,NULL,NULL,1,'2023-08-01 09:20:43','2023-08-01 09:20:43',NULL),(4086,7749,40720,1539,2,3726,'App\\Models\\Receipt',3726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',1199.97,NULL,NULL,1,'2023-08-01 09:20:43','2023-08-01 09:20:43',NULL),(4087,7749,40720,1539,2,3727,'App\\Models\\Receipt',3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',1199.97,NULL,NULL,1,'2023-08-01 09:20:44','2023-08-01 09:20:44',NULL),(4088,7749,40720,1539,2,3728,'App\\Models\\Receipt',3728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',9600.02,NULL,NULL,1,'2023-08-01 09:20:44','2023-08-01 09:20:44',NULL),(4089,7749,40720,1539,2,3729,'App\\Models\\Receipt',3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',700.01,NULL,NULL,1,'2023-08-01 09:20:44','2023-08-01 09:20:44',NULL),(4090,7749,40720,1539,2,3730,'App\\Models\\Receipt',3730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',7200.00,NULL,NULL,1,'2023-08-01 09:46:29','2023-08-01 09:46:29',NULL),(4091,7749,40720,1539,2,3731,'App\\Models\\Receipt',3731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',37500.00,NULL,NULL,1,'2023-08-01 09:47:45','2023-08-01 09:47:45',NULL),(4092,7749,40720,1539,2,3732,'App\\Models\\Receipt',3732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',81299.53,NULL,NULL,1,'2023-08-01 09:47:45','2023-08-01 09:47:45',NULL),(4093,7749,40720,1539,2,3733,'App\\Models\\Receipt',3733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',107789.99,NULL,NULL,1,'2023-08-01 09:49:25','2023-08-01 09:49:25',NULL),(4094,7749,40720,1539,2,3734,'App\\Models\\Receipt',3734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',5499.99,NULL,NULL,1,'2023-08-01 09:55:49','2023-08-01 09:55:49',NULL),(4095,7749,40720,1539,2,3735,'App\\Models\\Receipt',3735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',3100.00,NULL,NULL,1,'2023-08-01 09:56:04','2023-08-01 09:56:04',NULL),(4096,7749,40720,1539,2,3736,'App\\Models\\Receipt',3736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',51829.98,NULL,NULL,1,'2023-08-01 10:26:10','2023-08-01 10:26:10',NULL),(4097,7749,40720,1538,7,3737,'App\\Models\\Receipt',3737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',214.24,NULL,NULL,1,'2023-08-01 10:39:57','2023-08-01 10:39:57',NULL),(4098,7749,40720,1538,7,3738,'App\\Models\\Receipt',3738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',143.34,NULL,NULL,1,'2023-08-01 10:39:57','2023-08-01 10:39:57',NULL),(4099,7749,40720,1538,7,3739,'App\\Models\\Receipt',3739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',1492.02,NULL,NULL,1,'2023-08-01 10:39:57','2023-08-01 10:39:57',NULL),(4100,7749,40720,1538,7,3740,'App\\Models\\Receipt',3740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',1908.60,NULL,NULL,1,'2023-08-01 10:39:57','2023-08-01 10:39:57',NULL),(4101,7749,40720,1539,3,3741,'App\\Models\\Receipt',3741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',162169.55,NULL,NULL,1,'2023-08-01 11:43:18','2023-08-01 11:43:18',NULL),(4102,7749,40720,1539,3,3742,'App\\Models\\Receipt',3742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',50228.36,NULL,NULL,1,'2023-08-01 11:43:40','2023-08-01 11:43:40',NULL),(4103,7749,40720,1539,3,3743,'App\\Models\\Receipt',3743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',399044.10,NULL,NULL,1,'2023-08-01 11:44:15','2023-08-01 11:44:15',NULL),(4104,7749,40720,1539,3,3744,'App\\Models\\Receipt',3744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',403592.69,NULL,NULL,1,'2023-08-01 11:44:43','2023-08-01 11:44:43',NULL);
INSERT INTO `balance_libro` VALUES (4105,7749,40720,1539,3,3745,'App\\Models\\Receipt',3745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',4275.20,NULL,NULL,1,'2023-08-01 11:45:10','2023-08-01 11:45:10',NULL),(4106,7749,40720,1539,3,3746,'App\\Models\\Receipt',3746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',27970.47,NULL,NULL,1,'2023-08-01 11:45:34','2023-08-01 11:45:34',NULL),(4107,7749,40720,1539,3,3747,'App\\Models\\Receipt',3747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',19232.50,NULL,NULL,1,'2023-08-01 11:45:56','2023-08-01 11:45:56',NULL),(4108,7749,40720,1539,2,3748,'App\\Models\\Receipt',3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1379000.00,NULL,NULL,1,'2023-08-01 12:01:40','2023-08-01 12:01:40',NULL),(4109,7749,40720,1539,2,3749,'App\\Models\\Receipt',3749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1148500.00,NULL,NULL,1,'2023-08-01 12:01:40','2023-08-01 12:01:40',NULL),(4110,7749,40720,1540,2,3750,'App\\Models\\Receipt',3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',24360.00,NULL,NULL,1,'2023-08-08 10:31:38','2023-08-08 10:31:38',NULL),(4111,7749,40720,1540,2,3751,'App\\Models\\Receipt',3751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',37159.98,NULL,NULL,1,'2023-08-08 10:31:38','2023-08-08 10:31:38',NULL),(4112,7749,40720,1540,2,3752,'App\\Models\\Receipt',3752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',70100.00,NULL,NULL,1,'2023-08-08 10:31:38','2023-08-08 10:31:38',NULL),(4113,7749,40720,1540,2,3753,'App\\Models\\Receipt',3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',88499.37,NULL,NULL,1,'2023-08-08 10:31:39','2023-08-08 10:31:39',NULL),(4114,7749,40720,1540,2,3754,'App\\Models\\Receipt',3754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',8400.00,NULL,NULL,1,'2023-08-08 10:31:39','2023-08-08 10:31:39',NULL),(4115,7749,40720,1540,2,3755,'App\\Models\\Receipt',3755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',9000.00,NULL,NULL,1,'2023-08-08 10:31:39','2023-08-08 10:31:39',NULL),(4116,7749,40720,1540,2,3756,'App\\Models\\Receipt',3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',41364.99,NULL,NULL,1,'2023-08-08 10:31:39','2023-08-08 10:31:39',NULL),(4117,7749,40720,1540,2,3757,'App\\Models\\Receipt',3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',53600.00,NULL,NULL,1,'2023-08-08 10:31:39','2023-08-08 10:31:39',NULL),(4118,7749,40720,1540,2,3758,'App\\Models\\Receipt',3758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',33899.99,NULL,NULL,1,'2023-08-08 10:31:39','2023-08-08 10:31:39',NULL),(4119,7749,40720,1540,2,3759,'App\\Models\\Receipt',3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',46999.94,NULL,NULL,1,'2023-08-08 10:31:39','2023-08-08 10:31:39',NULL),(4120,7749,40720,1540,2,3760,'App\\Models\\Receipt',3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',14400.00,NULL,NULL,1,'2023-08-08 10:31:39','2023-08-08 10:31:39',NULL),(4121,7749,40720,1540,2,3761,'App\\Models\\Receipt',3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',131000.00,NULL,NULL,1,'2023-08-08 10:31:39','2023-08-08 10:31:39',NULL),(4122,7749,40720,1540,2,3762,'App\\Models\\Receipt',3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',9000.00,NULL,NULL,1,'2023-08-08 10:31:39','2023-08-08 10:31:39',NULL),(4123,7749,40720,1540,2,3763,'App\\Models\\Receipt',3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',15000.01,NULL,NULL,1,'2023-08-08 10:31:39','2023-08-08 10:31:39',NULL),(4124,7749,40720,1540,2,3764,'App\\Models\\Receipt',3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',243199.74,NULL,NULL,1,'2023-08-08 10:31:39','2023-08-08 10:31:39',NULL),(4125,7749,40720,1540,2,3765,'App\\Models\\Receipt',3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',33200.00,NULL,NULL,1,'2023-08-08 10:31:40','2023-08-08 10:31:40',NULL);
INSERT INTO `balance_libro` VALUES (4126,7749,40720,1540,2,3766,'App\\Models\\Receipt',3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',41900.00,NULL,NULL,1,'2023-08-08 10:31:40','2023-08-08 10:31:40',NULL),(4127,7749,40720,1540,2,3767,'App\\Models\\Receipt',3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',266109.99,NULL,NULL,1,'2023-08-08 10:31:40','2023-08-08 10:31:40',NULL),(4128,7749,40720,1540,2,3768,'App\\Models\\Receipt',3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',1300.00,NULL,NULL,1,'2023-08-08 10:31:40','2023-08-08 10:31:40',NULL),(4129,7749,40720,1540,2,3769,'App\\Models\\Receipt',3769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',6160.00,NULL,NULL,1,'2023-08-08 10:31:40','2023-08-08 10:31:40',NULL),(4130,7749,40720,1540,2,3770,'App\\Models\\Receipt',3770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',10680.00,NULL,NULL,1,'2023-08-08 10:31:40','2023-08-08 10:31:40',NULL),(4131,7749,40720,1540,2,3771,'App\\Models\\Receipt',3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',7440.00,NULL,NULL,1,'2023-08-08 10:31:40','2023-08-08 10:31:40',NULL),(4132,7749,40720,1540,2,3772,'App\\Models\\Receipt',3772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',914417.99,NULL,NULL,1,'2023-08-08 10:31:40','2023-08-08 10:31:40',NULL),(4133,7749,40720,1540,2,3773,'App\\Models\\Receipt',3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',396400.00,NULL,NULL,1,'2023-08-08 10:31:40','2023-08-08 10:31:40',NULL),(4134,7749,40720,1540,3,3774,'App\\Models\\Receipt',3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',349480.52,NULL,NULL,1,'2023-08-08 10:31:55','2023-09-19 10:02:52','2023-09-19 10:02:52'),(4135,7749,40720,1540,3,3775,'App\\Models\\Receipt',3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',14748.00,NULL,NULL,1,'2023-08-08 10:31:55','2023-08-08 10:31:55',NULL),(4136,7749,40720,1540,3,3776,'App\\Models\\Receipt',3776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',398198.26,NULL,NULL,1,'2023-08-08 10:31:55','2023-08-08 10:31:55',NULL),(4137,7749,40720,1540,3,3777,'App\\Models\\Receipt',3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',43230.75,NULL,NULL,1,'2023-08-08 10:31:55','2023-08-08 10:31:55',NULL),(4138,7749,40720,1540,3,3778,'App\\Models\\Receipt',3778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',43230.75,NULL,NULL,1,'2023-08-08 10:31:55','2023-08-08 10:31:55',NULL),(4139,7749,40720,1540,3,3779,'App\\Models\\Receipt',3779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',17698.15,NULL,NULL,1,'2023-08-08 10:31:55','2023-09-19 10:04:47','2023-09-19 10:04:47'),(4140,7749,40720,1540,3,3780,'App\\Models\\Receipt',3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',53094.45,NULL,NULL,1,'2023-08-08 10:31:55','2023-09-19 10:05:56','2023-09-19 10:05:56'),(4141,7749,40720,1540,3,3781,'App\\Models\\Receipt',3781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',356547.80,NULL,NULL,1,'2023-08-08 10:31:55','2023-08-08 10:31:55',NULL),(4142,7749,40720,1540,3,3782,'App\\Models\\Receipt',3782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',549318.06,NULL,NULL,1,'2023-08-08 10:31:56','2023-08-08 10:31:56',NULL),(4143,7749,40720,1540,3,3783,'App\\Models\\Receipt',3783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',64186.95,NULL,NULL,1,'2023-08-08 10:31:56','2023-09-19 10:07:36','2023-09-19 10:07:36'),(4144,7749,40720,1540,3,3784,'App\\Models\\Receipt',3784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',237139.57,NULL,NULL,1,'2023-08-08 10:31:56','2023-08-08 10:31:56',NULL),(4145,7749,40720,1540,3,3785,'App\\Models\\Receipt',3785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',5656.19,NULL,NULL,1,'2023-08-08 10:31:56','2023-08-30 10:20:31','2023-08-30 10:20:31');
INSERT INTO `balance_libro` VALUES (4146,7749,40720,1540,3,3786,'App\\Models\\Receipt',3786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',26987.81,NULL,NULL,1,'2023-08-08 10:31:56','2023-08-08 10:31:56',NULL),(4147,7749,40720,1540,3,3787,'App\\Models\\Receipt',3787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',18999.24,NULL,NULL,1,'2023-08-08 10:31:56','2023-08-08 10:31:56',NULL),(4148,7749,40720,1540,3,3788,'App\\Models\\Receipt',3788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',7699.99,NULL,NULL,1,'2023-08-08 10:31:56','2023-08-08 10:31:56',NULL),(4149,7749,40720,1540,3,3789,'App\\Models\\Receipt',3789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',106583.43,NULL,NULL,1,'2023-08-08 10:31:56','2023-08-08 10:31:56',NULL),(4150,7749,40720,1540,3,3790,'App\\Models\\Receipt',3790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',167323.76,NULL,NULL,1,'2023-08-08 10:31:56','2023-08-08 10:31:56',NULL),(4151,7749,40720,1540,3,3791,'App\\Models\\Receipt',3791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',47256.40,NULL,NULL,1,'2023-08-08 10:31:56','2023-09-19 10:12:32','2023-09-19 10:12:32'),(4152,7749,40720,1540,3,3792,'App\\Models\\Receipt',3792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',46900.24,NULL,NULL,1,'2023-08-08 10:31:56','2023-08-08 10:31:56',NULL),(4153,7749,40720,1540,3,3793,'App\\Models\\Receipt',3793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',175819.44,NULL,NULL,1,'2023-08-08 10:31:56','2023-08-08 10:31:56',NULL),(4154,7749,40720,1540,3,3794,'App\\Models\\Receipt',3794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',130524.34,NULL,NULL,1,'2023-08-08 10:31:56','2023-08-08 10:31:56',NULL),(4155,7749,40720,1540,3,3795,'App\\Models\\Receipt',3795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',117875.26,NULL,NULL,1,'2023-08-08 10:31:57','2023-08-08 10:31:57',NULL),(4156,7749,40720,1540,3,3796,'App\\Models\\Receipt',3796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',25870.89,NULL,NULL,1,'2023-08-08 10:31:57','2023-09-19 10:13:56','2023-09-19 10:13:56'),(4157,7749,40720,1540,3,3797,'App\\Models\\Receipt',3797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',798612.67,NULL,NULL,1,'2023-08-08 10:31:57','2023-09-19 10:17:09','2023-09-19 10:17:09'),(4158,7749,40720,1540,2,3798,'App\\Models\\Receipt',3798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',10199.95,NULL,NULL,1,'2023-08-08 10:32:17','2023-08-23 11:17:56','2023-08-23 11:17:56'),(4159,7749,40720,1540,2,3799,'App\\Models\\Receipt',3799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',5799.99,NULL,NULL,1,'2023-08-08 10:32:17','2023-08-08 10:32:17',NULL),(4160,7749,40720,1540,2,3800,'App\\Models\\Receipt',3800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',10599.95,NULL,NULL,1,'2023-08-08 10:32:17','2023-08-23 11:20:20','2023-08-23 11:20:20'),(4161,7749,40720,1540,2,3801,'App\\Models\\Receipt',3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',32099.97,NULL,NULL,1,'2023-08-08 10:32:17','2023-08-23 11:20:40','2023-08-23 11:20:40'),(4162,7749,40720,1540,2,3802,'App\\Models\\Receipt',3802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',5600.00,NULL,NULL,1,'2023-08-08 10:32:18','2023-08-23 11:49:19','2023-08-23 11:49:19'),(4163,7749,40720,1540,2,3803,'App\\Models\\Receipt',3803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',58720.03,NULL,NULL,1,'2023-08-08 10:32:18','2023-08-23 11:49:37','2023-08-23 11:49:37'),(4164,7749,40720,1540,2,3804,'App\\Models\\Receipt',3804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',4899.98,NULL,NULL,1,'2023-08-08 10:32:35','2023-08-08 10:32:35',NULL),(4165,7749,40720,1540,2,3805,'App\\Models\\Receipt',3805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',1199.97,NULL,NULL,1,'2023-08-08 10:32:35','2023-08-08 10:32:35',NULL);
INSERT INTO `balance_libro` VALUES (4166,7749,40720,1540,2,3806,'App\\Models\\Receipt',3806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',1699.99,NULL,NULL,1,'2023-08-08 10:32:35','2023-08-08 10:32:35',NULL),(4167,7749,40720,1540,2,3807,'App\\Models\\Receipt',3807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',1400.03,NULL,NULL,1,'2023-08-08 10:32:35','2023-08-08 10:32:35',NULL),(4168,7749,40720,1540,2,3808,'App\\Models\\Receipt',3808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',999.98,NULL,NULL,1,'2023-08-08 10:32:35','2023-08-08 10:32:35',NULL),(4169,7749,40720,1540,2,3809,'App\\Models\\Receipt',3809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',1800.02,NULL,NULL,1,'2023-08-08 10:32:35','2023-08-08 10:32:35',NULL),(4170,7749,40720,1540,2,3810,'App\\Models\\Receipt',3810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',1600.02,NULL,NULL,1,'2023-08-08 10:32:35','2023-08-08 10:32:35',NULL),(4171,7749,40720,1540,2,3811,'App\\Models\\Receipt',3811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',1699.99,NULL,NULL,1,'2023-08-08 10:32:35','2023-08-08 10:32:35',NULL),(4172,7749,40720,1540,2,3812,'App\\Models\\Receipt',3812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',2400.01,NULL,NULL,1,'2023-08-08 10:32:36','2023-08-08 10:32:36',NULL),(4173,7749,40720,1540,2,3813,'App\\Models\\Receipt',3813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',1649.98,NULL,NULL,1,'2023-08-08 10:32:36','2023-08-08 10:32:36',NULL),(4174,7749,40720,1540,2,3814,'App\\Models\\Receipt',3814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',2160.02,NULL,NULL,1,'2023-08-08 10:32:36','2023-08-08 10:32:36',NULL),(4175,7749,40720,1540,2,3815,'App\\Models\\Receipt',3815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',799.98,NULL,NULL,1,'2023-08-08 10:32:36','2023-08-08 10:32:36',NULL),(4176,7749,40720,1540,2,3816,'App\\Models\\Receipt',3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',2499.98,NULL,NULL,1,'2023-08-08 10:32:36','2023-08-08 10:32:36',NULL),(4177,7749,40720,1540,2,3817,'App\\Models\\Receipt',3817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',4800.01,NULL,NULL,1,'2023-08-08 10:32:36','2023-08-08 10:32:36',NULL),(4178,7749,40720,1540,2,3818,'App\\Models\\Receipt',3818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',2499.98,NULL,NULL,1,'2023-08-08 10:32:36','2023-08-08 10:32:36',NULL),(4179,7749,40720,1540,2,3819,'App\\Models\\Receipt',3819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',16000.00,NULL,NULL,1,'2023-08-08 10:32:36','2023-08-08 10:32:36',NULL),(4180,7749,40720,1540,2,3820,'App\\Models\\Receipt',3820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',4299.99,NULL,NULL,1,'2023-08-08 10:32:36','2023-08-08 10:32:36',NULL),(4181,7749,40720,1540,2,3821,'App\\Models\\Receipt',3821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',1199.97,NULL,NULL,1,'2023-08-08 10:32:36','2023-08-08 10:32:36',NULL),(4182,7749,40720,1540,2,3822,'App\\Models\\Receipt',3822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',7600.01,NULL,NULL,1,'2023-08-08 10:32:36','2023-08-08 10:32:36',NULL),(4183,7749,40720,1540,2,3823,'App\\Models\\Receipt',3823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',2999.99,NULL,NULL,1,'2023-08-08 10:32:36','2023-08-08 10:32:36',NULL),(4184,7749,40720,1540,2,3824,'App\\Models\\Receipt',3824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',2099.98,NULL,NULL,1,'2023-08-08 10:32:36','2023-08-08 10:32:36',NULL),(4185,7749,40720,1540,2,3825,'App\\Models\\Receipt',3825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',3500.01,NULL,NULL,1,'2023-08-08 10:32:36','2023-08-08 10:32:36',NULL),(4186,7749,40720,1540,2,3826,'App\\Models\\Receipt',3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',5000.01,NULL,NULL,1,'2023-08-08 10:32:37','2023-08-08 10:32:37',NULL);
INSERT INTO `balance_libro` VALUES (4187,7749,40720,1540,2,3827,'App\\Models\\Receipt',3827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',1150.02,NULL,NULL,1,'2023-08-08 10:32:37','2023-08-08 10:32:37',NULL),(4188,7749,40720,1540,2,3828,'App\\Models\\Receipt',3828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',5149.99,NULL,NULL,1,'2023-08-08 10:32:37','2023-08-08 10:32:37',NULL),(4189,7749,40720,1540,2,3829,'App\\Models\\Receipt',3829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',1449.98,NULL,NULL,1,'2023-08-08 10:32:37','2023-08-08 10:32:37',NULL),(4190,7749,40720,1540,2,3830,'App\\Models\\Receipt',3830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',11700.01,NULL,NULL,1,'2023-08-08 10:32:37','2023-08-08 10:32:37',NULL),(4191,7749,40720,1540,2,3831,'App\\Models\\Receipt',3831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',17770.00,NULL,NULL,1,'2023-08-08 10:32:37','2023-08-08 10:32:37',NULL),(4192,7749,40720,1540,2,3832,'App\\Models\\Receipt',3832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',16500.02,NULL,NULL,1,'2023-08-08 10:32:37','2023-08-08 10:32:37',NULL),(4193,7749,40720,1539,2,3566,'App\\Models\\Receipt',3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',102170.01,NULL,NULL,1,'2023-08-10 11:29:48','2023-08-10 11:29:48',NULL),(4194,7749,40720,1539,3,3833,'App\\Models\\Receipt',3833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',24600.14,NULL,NULL,1,'2023-08-14 10:12:27','2023-08-14 10:12:27',NULL),(4195,7749,40720,1539,3,3581,'App\\Models\\Receipt',3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',209101.17,NULL,NULL,1,'2023-08-14 10:46:58','2023-08-14 10:46:58',NULL),(4196,7749,40720,1539,3,3834,'App\\Models\\Receipt',3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',5002.80,NULL,NULL,1,'2023-08-14 10:48:09','2023-08-14 10:48:09',NULL),(4197,7749,40720,1539,3,3582,'App\\Models\\Receipt',3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',213352.80,NULL,NULL,1,'2023-08-14 10:49:35','2023-08-14 10:49:35',NULL),(4198,7749,40720,1539,3,3586,'App\\Models\\Receipt',3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',459655.28,NULL,NULL,1,'2023-08-14 10:50:34','2023-08-14 10:50:34',NULL),(4199,7749,40720,1539,3,3593,'App\\Models\\Receipt',3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',110354.65,NULL,NULL,1,'2023-08-14 10:52:11','2023-08-14 10:52:11',NULL),(4200,7749,40720,1539,3,3595,'App\\Models\\Receipt',3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',286344.14,NULL,NULL,1,'2023-08-14 10:53:09','2023-08-14 10:53:09',NULL),(4201,7749,40720,1539,3,3616,'App\\Models\\Receipt',3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',131986.84,NULL,NULL,1,'2023-08-14 11:03:05','2023-08-14 11:03:05',NULL),(4202,7749,40720,1539,3,3617,'App\\Models\\Receipt',3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',208061.21,NULL,NULL,1,'2023-08-14 11:03:40','2023-08-14 11:03:40',NULL),(4203,7749,40720,1539,3,3835,'App\\Models\\Receipt',3835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',10000.00,NULL,NULL,1,'2023-08-14 11:04:55','2023-08-14 11:04:55',NULL),(4204,7749,40720,1539,3,3636,'App\\Models\\Receipt',3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',55890.40,NULL,NULL,1,'2023-08-14 11:23:53','2023-08-14 11:23:53',NULL),(4205,7749,40720,1539,3,3836,'App\\Models\\Receipt',3836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',24600.38,NULL,NULL,1,'2023-08-14 11:29:44','2023-08-14 11:29:44',NULL),(4206,7749,40720,1539,3,3641,'App\\Models\\Receipt',3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',248531.35,NULL,NULL,1,'2023-08-14 11:31:09','2023-08-14 11:31:09',NULL),(4207,7749,40720,1539,3,3642,'App\\Models\\Receipt',3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',15710.08,NULL,NULL,1,'2023-08-14 11:33:33','2023-08-14 11:33:33',NULL);
INSERT INTO `balance_libro` VALUES (4208,7749,40720,1539,3,3837,'App\\Models\\Receipt',3837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',385141.32,NULL,NULL,1,'2023-08-14 11:38:14','2023-08-14 11:38:14',NULL),(4209,7749,40720,1539,3,3838,'App\\Models\\Receipt',3838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',107871.67,NULL,NULL,1,'2023-08-14 11:38:14','2023-08-14 11:38:14',NULL),(4210,7749,40720,1539,3,3839,'App\\Models\\Receipt',3839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',9631.14,NULL,NULL,1,'2023-08-14 11:38:14','2023-08-14 11:38:14',NULL),(4211,7749,40720,1539,3,3840,'App\\Models\\Receipt',3840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',4836.67,NULL,NULL,1,'2023-08-14 11:38:14','2023-08-14 11:38:14',NULL),(4212,7749,40720,1539,3,3841,'App\\Models\\Receipt',3841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',10000.00,NULL,NULL,1,'2023-08-14 11:44:31','2023-08-14 11:44:31',NULL),(4213,7749,40720,1539,3,3842,'App\\Models\\Receipt',3842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',62167.25,NULL,NULL,1,'2023-08-14 11:50:00','2023-08-14 11:50:00',NULL),(4214,7749,40720,1539,3,3615,'App\\Models\\Receipt',3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',325797.58,NULL,NULL,1,'2023-08-15 12:16:31','2023-08-15 12:16:31',NULL),(4215,7749,40720,1539,3,3587,'App\\Models\\Receipt',3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',46168.30,NULL,NULL,1,'2023-08-15 12:31:16','2023-08-15 12:31:16',NULL),(4216,7749,40720,1539,3,3433,'App\\Models\\Receipt',3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',204957.42,NULL,NULL,1,'2023-08-15 12:55:34','2023-08-15 13:06:24','2023-08-15 13:06:24'),(4217,7749,40720,1539,3,3433,'App\\Models\\Receipt',3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',204957.42,NULL,NULL,1,'2023-08-15 13:06:24','2023-08-15 13:06:24',NULL),(4218,7749,40720,1540,2,3843,'App\\Models\\Receipt',3843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',225000.00,NULL,NULL,1,'2023-08-23 11:01:36','2023-08-23 11:01:36',NULL),(4219,7749,40720,1540,2,3844,'App\\Models\\Receipt',3844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',303570.00,NULL,NULL,1,'2023-08-23 11:01:36','2023-08-23 11:01:36',NULL),(4220,7749,40720,1540,2,3845,'App\\Models\\Receipt',3845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',23000.00,NULL,NULL,1,'2023-08-23 11:01:36','2023-08-23 11:01:36',NULL),(4221,7749,40720,1540,2,3846,'App\\Models\\Receipt',3846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',94830.00,NULL,NULL,1,'2023-08-23 11:01:36','2023-08-23 11:01:36',NULL),(4222,7749,40720,1540,2,3847,'App\\Models\\Receipt',3847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',99600.00,NULL,NULL,1,'2023-08-23 11:01:36','2023-08-23 11:01:36',NULL),(4223,7749,40720,1540,2,3848,'App\\Models\\Receipt',3848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',87499.94,NULL,NULL,1,'2023-08-23 11:01:36','2023-08-23 11:01:36',NULL),(4224,7749,40720,1540,2,3849,'App\\Models\\Receipt',3849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',64000.00,NULL,NULL,1,'2023-08-23 11:01:37','2023-08-23 11:01:37',NULL),(4225,7749,40720,1540,2,3850,'App\\Models\\Receipt',3850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',134963.40,NULL,NULL,1,'2023-08-23 11:01:37','2023-08-23 11:01:37',NULL),(4226,7749,40720,1540,2,3851,'App\\Models\\Receipt',3851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',196200.00,NULL,NULL,1,'2023-08-23 11:01:37','2023-08-23 11:01:37',NULL),(4227,7749,40720,1540,2,3852,'App\\Models\\Receipt',3852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',19700.00,NULL,NULL,1,'2023-08-23 11:01:37','2023-08-23 11:01:37',NULL),(4228,7749,40720,1540,2,3853,'App\\Models\\Receipt',3853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',21000.00,NULL,NULL,1,'2023-08-23 11:01:37','2023-08-23 11:01:37',NULL);
INSERT INTO `balance_libro` VALUES (4229,7749,40720,1540,2,3854,'App\\Models\\Receipt',3854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',7500.00,NULL,NULL,1,'2023-08-23 11:01:37','2023-08-23 11:01:37',NULL),(4230,7749,40720,1540,2,3855,'App\\Models\\Receipt',3855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',49700.00,NULL,NULL,1,'2023-08-23 11:01:37','2023-08-23 11:01:37',NULL),(4231,7749,40720,1540,2,3856,'App\\Models\\Receipt',3856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',18000.00,NULL,NULL,1,'2023-08-23 11:01:37','2023-08-23 11:01:37',NULL),(4232,7749,40720,1540,2,3857,'App\\Models\\Receipt',3857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',77499.99,NULL,NULL,1,'2023-08-23 11:01:37','2023-08-23 11:01:37',NULL),(4233,7749,40720,1540,2,3858,'App\\Models\\Receipt',3858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',89599.90,NULL,NULL,1,'2023-08-23 11:01:37','2023-08-23 11:01:37',NULL),(4234,7749,40720,1540,2,3859,'App\\Models\\Receipt',3859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',25199.99,NULL,NULL,1,'2023-08-23 11:01:37','2023-08-23 11:01:37',NULL),(4235,7749,40720,1540,3,3860,'App\\Models\\Receipt',3860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',26060.16,NULL,NULL,1,'2023-08-23 11:01:52','2023-08-23 11:01:52',NULL),(4236,7749,40720,1540,3,3861,'App\\Models\\Receipt',3861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',37978.89,NULL,NULL,1,'2023-08-23 11:01:52','2023-08-23 11:01:52',NULL),(4237,7749,40720,1540,3,3862,'App\\Models\\Receipt',3862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',158209.39,NULL,NULL,1,'2023-08-23 11:01:52','2023-08-23 11:01:52',NULL),(4238,7749,40720,1540,3,3863,'App\\Models\\Receipt',3863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',10444.79,NULL,NULL,1,'2023-08-23 11:01:52','2023-08-23 11:01:52',NULL),(4239,7749,40720,1540,3,3864,'App\\Models\\Receipt',3864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',20534.28,NULL,NULL,1,'2023-08-23 11:01:53','2023-08-23 11:01:53',NULL),(4240,7749,40720,1540,3,3865,'App\\Models\\Receipt',3865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',13476.68,NULL,NULL,1,'2023-08-23 11:01:53','2023-08-23 11:01:53',NULL),(4241,7749,40720,1540,3,3866,'App\\Models\\Receipt',3866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',462956.56,NULL,NULL,1,'2023-08-23 11:01:53','2023-09-19 10:43:06','2023-09-19 10:43:06'),(4242,7749,40720,1540,3,3867,'App\\Models\\Receipt',3867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',113699.39,NULL,NULL,1,'2023-08-23 11:01:53','2023-08-23 11:01:53',NULL),(4243,7749,40720,1540,3,3868,'App\\Models\\Receipt',3868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',60180.77,NULL,NULL,1,'2023-08-23 11:01:53','2023-08-23 11:01:53',NULL),(4244,7749,40720,1540,3,3869,'App\\Models\\Receipt',3869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',0.24,NULL,NULL,1,'2023-08-23 11:01:53','2023-08-23 11:01:53',NULL),(4245,7749,40720,1540,3,3870,'App\\Models\\Receipt',3870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',210175.46,NULL,NULL,1,'2023-08-23 11:01:53','2023-08-23 11:01:53',NULL),(4246,7749,40720,1540,3,3871,'App\\Models\\Receipt',3871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',17562.55,NULL,NULL,1,'2023-08-23 11:01:53','2023-08-23 11:01:53',NULL),(4247,7749,40720,1540,3,3872,'App\\Models\\Receipt',3872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',38650.40,NULL,NULL,1,'2023-08-23 11:01:53','2023-08-23 11:01:53',NULL),(4248,7749,40720,1540,3,3873,'App\\Models\\Receipt',3873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',13973.42,NULL,NULL,1,'2023-08-23 11:01:53','2023-08-23 11:01:53',NULL),(4249,7749,40720,1540,3,3874,'App\\Models\\Receipt',3874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',47261.23,NULL,NULL,1,'2023-08-23 11:01:53','2023-08-23 11:01:53',NULL);
INSERT INTO `balance_libro` VALUES (4250,7749,40720,1540,3,3875,'App\\Models\\Receipt',3875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',18687.36,NULL,NULL,1,'2023-08-23 11:01:53','2023-08-23 11:01:53',NULL),(4251,7749,40720,1540,3,3876,'App\\Models\\Receipt',3876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',12346.23,NULL,NULL,1,'2023-08-23 11:01:53','2023-08-23 11:01:53',NULL),(4252,7749,40720,1540,3,3877,'App\\Models\\Receipt',3877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',21199.85,NULL,NULL,1,'2023-08-23 11:01:53','2023-08-23 11:01:53',NULL),(4253,7749,40720,1540,3,3878,'App\\Models\\Receipt',3878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',170127.51,NULL,NULL,1,'2023-08-23 11:01:53','2023-09-19 10:47:10','2023-09-19 10:47:10'),(4254,7749,40720,1540,3,3879,'App\\Models\\Receipt',3879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',6056.05,NULL,NULL,1,'2023-08-23 11:01:53','2023-09-19 10:47:30','2023-09-19 10:47:30'),(4255,7749,40720,1540,3,3880,'App\\Models\\Receipt',3880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',4197.07,NULL,NULL,1,'2023-08-23 11:01:54','2023-08-23 11:01:54',NULL),(4256,7749,40720,1540,3,3881,'App\\Models\\Receipt',3881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',7989.15,NULL,NULL,1,'2023-08-23 11:01:54','2023-08-23 11:01:54',NULL),(4257,7749,40720,1540,3,3882,'App\\Models\\Receipt',3882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',74575.48,NULL,NULL,1,'2023-08-23 11:01:54','2023-08-23 11:01:54',NULL),(4258,7749,40720,1540,2,3883,'App\\Models\\Receipt',3883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',111532.38,NULL,NULL,1,'2023-08-23 11:02:14','2023-08-23 11:02:14',NULL),(4259,7749,40720,1540,2,3884,'App\\Models\\Receipt',3884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',18899.97,NULL,NULL,1,'2023-08-23 11:02:14','2023-08-23 11:53:39','2023-08-23 11:53:39'),(4260,7749,40720,1540,2,3885,'App\\Models\\Receipt',3885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',9950.00,NULL,NULL,1,'2023-08-23 11:02:14','2023-08-23 11:02:14',NULL),(4261,7749,40720,1540,2,3886,'App\\Models\\Receipt',3886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',11460.03,NULL,NULL,1,'2023-08-23 11:02:15','2023-08-23 11:55:00','2023-08-23 11:55:00'),(4262,7749,40720,1540,2,3887,'App\\Models\\Receipt',3887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',4299.99,NULL,NULL,1,'2023-08-23 11:02:15','2023-08-23 11:55:19','2023-08-23 11:55:19'),(4263,7749,40720,1540,2,3888,'App\\Models\\Receipt',3888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-21','2023-08-21',39429.98,NULL,NULL,1,'2023-08-23 11:02:15','2023-08-23 11:02:15',NULL),(4264,7749,40720,1540,2,3889,'App\\Models\\Receipt',3889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',2999.99,NULL,NULL,1,'2023-08-23 11:02:29','2023-08-23 11:02:29',NULL),(4265,7749,40720,1540,2,3890,'App\\Models\\Receipt',3890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',7899.97,NULL,NULL,1,'2023-08-23 11:02:29','2023-08-23 11:02:29',NULL),(4266,7749,40720,1540,2,3891,'App\\Models\\Receipt',3891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',2800.00,NULL,NULL,1,'2023-08-23 11:02:29','2023-08-23 11:02:29',NULL),(4267,7749,40720,1540,2,3892,'App\\Models\\Receipt',3892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',1350.01,NULL,NULL,1,'2023-08-23 11:02:29','2023-08-23 11:02:29',NULL),(4268,7749,40720,1540,2,3893,'App\\Models\\Receipt',3893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',2000.01,NULL,NULL,1,'2023-08-23 11:02:29','2023-08-23 11:02:29',NULL),(4269,7749,40720,1540,2,3894,'App\\Models\\Receipt',3894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',349.98,NULL,NULL,1,'2023-08-23 11:02:30','2023-08-23 11:02:30',NULL);
INSERT INTO `balance_libro` VALUES (4270,7749,40720,1540,2,3895,'App\\Models\\Receipt',3895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',900.01,NULL,NULL,1,'2023-08-23 11:02:30','2023-08-23 11:02:30',NULL),(4271,7749,40720,1540,2,3896,'App\\Models\\Receipt',3896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',599.99,NULL,NULL,1,'2023-08-23 11:02:30','2023-08-23 11:02:30',NULL),(4272,7749,40720,1540,2,3897,'App\\Models\\Receipt',3897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',2800.00,NULL,NULL,1,'2023-08-23 11:02:30','2023-08-23 11:02:30',NULL),(4273,7749,40720,1540,2,3898,'App\\Models\\Receipt',3898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',13999.99,NULL,NULL,1,'2023-08-23 11:02:30','2023-08-23 11:02:30',NULL),(4274,7749,40720,1540,2,3899,'App\\Models\\Receipt',3899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',3999.97,NULL,NULL,1,'2023-08-23 11:02:30','2023-08-23 11:02:30',NULL),(4275,7749,40720,1540,2,3900,'App\\Models\\Receipt',3900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',2499.98,NULL,NULL,1,'2023-08-23 11:02:30','2023-08-23 11:02:30',NULL),(4276,7749,40720,1540,2,3901,'App\\Models\\Receipt',3901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',999.98,NULL,NULL,1,'2023-08-23 11:02:30','2023-08-23 11:02:30',NULL),(4277,7749,40720,1540,2,3902,'App\\Models\\Receipt',3902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',2400.01,NULL,NULL,1,'2023-08-23 11:02:30','2023-08-23 11:02:30',NULL),(4278,7749,40720,1540,2,3903,'App\\Models\\Receipt',3903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',3900.00,NULL,NULL,1,'2023-08-23 11:02:30','2023-08-23 11:02:30',NULL),(4279,7749,40720,1540,2,3904,'App\\Models\\Receipt',3904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',1800.02,NULL,NULL,1,'2023-08-23 11:02:30','2023-08-23 11:02:30',NULL),(4280,7749,40720,1540,2,3905,'App\\Models\\Receipt',3905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',3399.98,NULL,NULL,1,'2023-08-23 11:02:30','2023-08-23 11:02:30',NULL),(4281,7749,40720,1540,2,3906,'App\\Models\\Receipt',3906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',1500.00,NULL,NULL,1,'2023-08-23 11:02:30','2023-08-23 11:02:30',NULL),(4282,7749,40720,1540,2,3907,'App\\Models\\Receipt',3907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',4760.02,NULL,NULL,1,'2023-08-23 11:02:30','2023-08-23 11:02:30',NULL),(4283,7749,40720,1540,2,3908,'App\\Models\\Receipt',3908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',4299.99,NULL,NULL,1,'2023-08-23 11:02:30','2023-08-23 11:02:30',NULL),(4284,7749,40720,1540,2,3798,'App\\Models\\Receipt',3798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',990630.00,NULL,NULL,1,'2023-08-23 11:17:56','2023-08-23 11:17:56',NULL),(4285,7749,40720,1540,2,3909,'App\\Models\\Receipt',3909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',169885.00,NULL,NULL,1,'2023-08-23 11:19:13','2023-08-23 11:19:13',NULL),(4286,7749,40720,1540,2,3800,'App\\Models\\Receipt',3800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',191440.00,NULL,NULL,1,'2023-08-23 11:20:20','2023-08-23 11:20:20',NULL),(4287,7749,40720,1540,2,3801,'App\\Models\\Receipt',3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',194100.00,NULL,NULL,1,'2023-08-23 11:20:40','2023-08-23 11:20:40',NULL),(4288,7749,40720,1540,2,3802,'App\\Models\\Receipt',3802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-05','2023-08-05',213245.00,NULL,NULL,1,'2023-08-23 11:49:19','2023-08-23 11:49:19',NULL),(4289,7749,40720,1540,2,3803,'App\\Models\\Receipt',3803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',198110.00,NULL,NULL,1,'2023-08-23 11:49:37','2023-08-23 11:49:37',NULL),(4290,7749,40720,1540,2,3910,'App\\Models\\Receipt',3910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',14199.98,NULL,NULL,1,'2023-08-23 11:50:34','2023-08-23 11:51:19','2023-08-23 11:51:19');
INSERT INTO `balance_libro` VALUES (4291,7749,40720,1540,2,3911,'App\\Models\\Receipt',3911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',4980.01,NULL,NULL,1,'2023-08-23 11:50:34','2023-08-23 11:51:42','2023-08-23 11:51:42'),(4292,7749,40720,1540,2,3912,'App\\Models\\Receipt',3912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',49799.91,NULL,NULL,1,'2023-08-23 11:50:35','2023-08-23 11:52:04','2023-08-23 11:52:04'),(4293,7749,40720,1540,2,3913,'App\\Models\\Receipt',3913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',7679.99,NULL,NULL,1,'2023-08-23 11:50:35','2023-08-23 11:52:26','2023-08-23 11:52:26'),(4294,7749,40720,1540,2,3914,'App\\Models\\Receipt',3914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',4820.01,NULL,NULL,1,'2023-08-23 11:50:35','2023-08-23 11:52:52','2023-08-23 11:52:52'),(4295,7749,40720,1540,2,3915,'App\\Models\\Receipt',3915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',20760.03,NULL,NULL,1,'2023-08-23 11:50:35','2023-08-23 11:53:11','2023-08-23 11:53:11'),(4296,7749,40720,1540,2,3916,'App\\Models\\Receipt',3916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',4299.99,NULL,NULL,1,'2023-08-23 11:50:50','2023-08-23 11:50:50',NULL),(4297,7749,40720,1540,2,3917,'App\\Models\\Receipt',3917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',2000.01,NULL,NULL,1,'2023-08-23 11:50:50','2023-08-23 11:50:50',NULL),(4298,7749,40720,1540,2,3918,'App\\Models\\Receipt',3918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',5999.99,NULL,NULL,1,'2023-08-23 11:50:50','2023-08-23 11:50:50',NULL),(4299,7749,40720,1540,2,3919,'App\\Models\\Receipt',3919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',1899.99,NULL,NULL,1,'2023-08-23 11:50:50','2023-08-23 11:50:50',NULL),(4300,7749,40720,1540,2,3920,'App\\Models\\Receipt',3920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',4980.01,NULL,NULL,1,'2023-08-23 11:50:50','2023-08-23 11:50:50',NULL),(4301,7749,40720,1540,2,3921,'App\\Models\\Receipt',3921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',4899.98,NULL,NULL,1,'2023-08-23 11:50:50','2023-08-23 11:50:50',NULL),(4302,7749,40720,1540,2,3922,'App\\Models\\Receipt',3922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',13299.97,NULL,NULL,1,'2023-08-23 11:50:51','2023-08-23 11:50:51',NULL),(4303,7749,40720,1540,2,3923,'App\\Models\\Receipt',3923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',7899.97,NULL,NULL,1,'2023-08-23 11:50:51','2023-08-23 11:50:51',NULL),(4304,7749,40720,1540,2,3924,'App\\Models\\Receipt',3924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',17199.98,NULL,NULL,1,'2023-08-23 11:50:51','2023-08-23 11:50:51',NULL),(4305,7749,40720,1540,2,3925,'App\\Models\\Receipt',3925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',6500.00,NULL,NULL,1,'2023-08-23 11:50:51','2023-08-23 11:50:51',NULL),(4306,7749,40720,1540,2,3926,'App\\Models\\Receipt',3926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',3999.97,NULL,NULL,1,'2023-08-23 11:50:51','2023-08-23 11:50:51',NULL),(4307,7749,40720,1540,2,3927,'App\\Models\\Receipt',3927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',1400.03,NULL,NULL,1,'2023-08-23 11:50:51','2023-08-23 11:50:51',NULL),(4308,7749,40720,1540,2,3928,'App\\Models\\Receipt',3928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',2279.99,NULL,NULL,1,'2023-08-23 11:50:51','2023-08-23 11:50:51',NULL),(4309,7749,40720,1540,2,3929,'App\\Models\\Receipt',3929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',4820.01,NULL,NULL,1,'2023-08-23 11:50:51','2023-08-23 11:50:51',NULL),(4310,7749,40720,1540,2,3930,'App\\Models\\Receipt',3930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',2050.03,NULL,NULL,1,'2023-08-23 11:50:51','2023-08-23 11:50:51',NULL);
INSERT INTO `balance_libro` VALUES (4311,7749,40720,1540,2,3931,'App\\Models\\Receipt',3931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',1759.97,NULL,NULL,1,'2023-08-23 11:50:51','2023-08-23 11:50:51',NULL),(4312,7749,40720,1540,2,3932,'App\\Models\\Receipt',3932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',12750.00,NULL,NULL,1,'2023-08-23 11:50:51','2023-08-23 11:50:51',NULL),(4313,7749,40720,1540,2,3933,'App\\Models\\Receipt',3933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',4200.03,NULL,NULL,1,'2023-08-23 11:50:51','2023-08-23 11:50:51',NULL),(4314,7749,40720,1540,2,3910,'App\\Models\\Receipt',3910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',172780.00,NULL,NULL,1,'2023-08-23 11:51:19','2023-08-23 11:51:19',NULL),(4315,7749,40720,1540,2,3911,'App\\Models\\Receipt',3911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',155930.00,NULL,NULL,1,'2023-08-23 11:51:42','2023-08-23 11:51:42',NULL),(4316,7749,40720,1540,2,3912,'App\\Models\\Receipt',3912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',175140.00,NULL,NULL,1,'2023-08-23 11:52:04','2023-08-23 11:52:04',NULL),(4317,7749,40720,1540,2,3913,'App\\Models\\Receipt',3913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',197395.00,NULL,NULL,1,'2023-08-23 11:52:26','2023-08-23 11:52:26',NULL),(4318,7749,40720,1540,2,3914,'App\\Models\\Receipt',3914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',271760.00,NULL,NULL,1,'2023-08-23 11:52:52','2023-08-23 11:52:52',NULL),(4319,7749,40720,1540,2,3915,'App\\Models\\Receipt',3915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',177290.00,NULL,NULL,1,'2023-08-23 11:53:11','2023-08-23 11:53:11',NULL),(4320,7749,40720,1540,2,3884,'App\\Models\\Receipt',3884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',151310.00,NULL,NULL,1,'2023-08-23 11:53:39','2023-08-23 11:53:39',NULL),(4321,7749,40720,1540,2,3934,'App\\Models\\Receipt',3934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',99160.00,NULL,NULL,1,'2023-08-23 11:54:36','2023-08-23 11:54:36',NULL),(4322,7749,40720,1540,2,3886,'App\\Models\\Receipt',3886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',197770.00,NULL,NULL,1,'2023-08-23 11:55:00','2023-08-23 11:55:00',NULL),(4323,7749,40720,1540,2,3887,'App\\Models\\Receipt',3887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',231640.00,NULL,NULL,1,'2023-08-23 11:55:19','2023-08-23 11:55:19',NULL),(4324,7749,40720,1540,2,3935,'App\\Models\\Receipt',3935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',110250.00,NULL,NULL,1,'2023-08-28 11:54:41','2023-08-28 11:54:41',NULL),(4325,7749,40720,1540,2,3936,'App\\Models\\Receipt',3936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',52930.00,NULL,NULL,1,'2023-08-28 11:54:41','2023-08-28 11:54:41',NULL),(4326,7749,40720,1540,2,3937,'App\\Models\\Receipt',3937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',25000.00,NULL,NULL,1,'2023-08-28 11:54:41','2023-08-28 11:54:41',NULL),(4327,7749,40720,1540,2,3938,'App\\Models\\Receipt',3938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',333499.96,NULL,NULL,1,'2023-08-28 11:54:41','2023-08-28 11:54:41',NULL),(4328,7749,40720,1540,2,3939,'App\\Models\\Receipt',3939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',116999.99,NULL,NULL,1,'2023-08-28 11:54:41','2023-08-28 11:54:41',NULL),(4329,7749,40720,1540,2,3940,'App\\Models\\Receipt',3940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',94199.99,NULL,NULL,1,'2023-08-28 11:54:42','2023-08-28 11:54:42',NULL),(4330,7749,40720,1540,2,3941,'App\\Models\\Receipt',3941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',22900.00,NULL,NULL,1,'2023-08-28 11:54:42','2023-08-28 11:54:42',NULL),(4331,7749,40720,1540,2,3942,'App\\Models\\Receipt',3942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',71100.00,NULL,NULL,1,'2023-08-28 11:54:42','2023-08-28 11:54:42',NULL);
INSERT INTO `balance_libro` VALUES (4332,7749,40720,1540,2,3943,'App\\Models\\Receipt',3943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',38400.03,NULL,NULL,1,'2023-08-28 11:54:42','2023-08-28 11:54:42',NULL),(4333,7749,40720,1540,2,3944,'App\\Models\\Receipt',3944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',23399.90,NULL,NULL,1,'2023-08-28 11:54:42','2023-08-28 11:54:42',NULL),(4334,7749,40720,1540,2,3945,'App\\Models\\Receipt',3945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',31340.00,NULL,NULL,1,'2023-08-28 11:54:42','2023-08-28 11:54:42',NULL),(4335,7749,40720,1540,2,3946,'App\\Models\\Receipt',3946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',210999.80,NULL,NULL,1,'2023-08-28 11:54:42','2023-08-28 11:54:42',NULL),(4336,7749,40720,1540,2,3947,'App\\Models\\Receipt',3947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',19200.00,NULL,NULL,1,'2023-08-28 11:54:42','2023-08-28 11:54:42',NULL),(4337,7749,40720,1540,2,3948,'App\\Models\\Receipt',3948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',23800.00,NULL,NULL,1,'2023-08-28 11:54:42','2023-08-28 11:54:42',NULL),(4338,7749,40720,1540,3,3949,'App\\Models\\Receipt',3949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',15000.00,NULL,NULL,1,'2023-08-28 11:54:57','2023-08-30 10:20:42','2023-08-30 10:20:42'),(4339,7749,40720,1540,3,3950,'App\\Models\\Receipt',3950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',8995.06,NULL,NULL,1,'2023-08-28 11:54:58','2023-08-28 11:54:58',NULL),(4340,7749,40720,1540,3,3951,'App\\Models\\Receipt',3951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',10912.45,NULL,NULL,1,'2023-08-28 11:54:58','2023-09-19 11:44:29','2023-09-19 11:44:29'),(4341,7749,40720,1540,3,3952,'App\\Models\\Receipt',3952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',38968.63,NULL,NULL,1,'2023-08-28 11:54:58','2023-08-28 11:54:58',NULL),(4342,7749,40720,1540,3,3953,'App\\Models\\Receipt',3953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',59647.52,NULL,NULL,1,'2023-08-28 11:54:58','2023-08-28 11:54:58',NULL),(4343,7749,40720,1540,3,3954,'App\\Models\\Receipt',3954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',10621.84,NULL,NULL,1,'2023-08-28 11:54:58','2023-08-28 11:54:58',NULL),(4344,7749,40720,1540,3,3955,'App\\Models\\Receipt',3955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',187521.77,NULL,NULL,1,'2023-08-28 11:54:58','2023-09-19 10:50:06','2023-09-19 10:50:06'),(4345,7749,40720,1540,3,3956,'App\\Models\\Receipt',3956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',313090.46,NULL,NULL,1,'2023-08-28 11:54:58','2023-08-28 11:54:58',NULL),(4346,7749,40720,1540,3,3957,'App\\Models\\Receipt',3957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',1206231.58,NULL,NULL,1,'2023-08-28 11:54:58','2023-08-28 11:54:58',NULL),(4347,7749,40720,1540,3,3958,'App\\Models\\Receipt',3958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',36807.09,NULL,NULL,1,'2023-08-28 11:54:58','2023-08-28 11:54:58',NULL),(4348,7749,40720,1540,3,3959,'App\\Models\\Receipt',3959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-26','2023-08-26',93681.88,NULL,NULL,1,'2023-08-28 11:54:58','2023-08-28 11:54:58',NULL),(4349,7749,40720,1540,3,3960,'App\\Models\\Receipt',3960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',152336.69,NULL,NULL,1,'2023-08-28 11:54:58','2023-08-28 11:54:58',NULL),(4350,7749,40720,1540,3,3961,'App\\Models\\Receipt',3961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',222233.56,NULL,NULL,1,'2023-08-28 12:01:32','2023-08-28 12:01:32',NULL),(4351,7749,40720,1540,3,3962,'App\\Models\\Receipt',3962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',136565.68,NULL,NULL,1,'2023-08-28 12:02:05','2023-08-28 12:02:05',NULL);
INSERT INTO `balance_libro` VALUES (4352,7749,40720,1540,3,3963,'App\\Models\\Receipt',3963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',17492.89,NULL,NULL,1,'2023-08-28 12:02:25','2023-08-28 12:02:25',NULL),(4353,7749,40720,1540,3,3964,'App\\Models\\Receipt',3964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',106192.35,NULL,NULL,1,'2023-08-28 12:02:45','2023-08-28 12:02:45',NULL),(4354,7749,40720,1540,3,3965,'App\\Models\\Receipt',3965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',65777.64,NULL,NULL,1,'2023-08-28 12:06:23','2023-08-28 12:06:23',NULL),(4355,7749,40720,1540,3,3966,'App\\Models\\Receipt',3966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',84840.83,NULL,NULL,1,'2023-08-28 12:06:44','2023-08-28 12:06:44',NULL),(4356,7749,40720,1540,3,3967,'App\\Models\\Receipt',3967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',40000.92,NULL,NULL,1,'2023-08-28 12:07:00','2023-08-28 12:07:00',NULL),(4357,7749,40720,1540,3,3968,'App\\Models\\Receipt',3968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',44891.76,NULL,NULL,1,'2023-08-28 12:07:19','2023-08-28 12:07:19',NULL),(4358,7749,40720,1540,3,3969,'App\\Models\\Receipt',3969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',66001.99,NULL,NULL,1,'2023-08-28 12:08:49','2023-08-28 12:08:49',NULL),(4359,7749,40720,1540,3,3970,'App\\Models\\Receipt',3970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',20000.23,NULL,NULL,1,'2023-08-28 12:10:05','2023-08-28 12:10:05',NULL),(4360,7749,40720,1540,3,3971,'App\\Models\\Receipt',3971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',10000.00,NULL,NULL,1,'2023-08-28 12:10:44','2023-08-28 12:10:44',NULL),(4361,7749,40720,1540,3,3972,'App\\Models\\Receipt',3972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',17800.01,NULL,NULL,1,'2023-08-28 12:11:15','2023-08-28 12:11:15',NULL),(4362,7749,40720,1540,3,3973,'App\\Models\\Receipt',3973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',20000.21,NULL,NULL,1,'2023-08-28 12:11:51','2023-08-28 12:11:51',NULL),(4363,7749,40720,1540,3,3974,'App\\Models\\Receipt',3974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',10000.12,NULL,NULL,1,'2023-08-28 12:12:26','2023-08-28 12:12:26',NULL),(4364,7749,40720,1540,3,3975,'App\\Models\\Receipt',3975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',53624.99,NULL,NULL,1,'2023-08-30 10:09:03','2023-08-30 10:09:03',NULL),(4365,7749,40720,1540,3,3976,'App\\Models\\Receipt',3976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',67756.98,NULL,NULL,1,'2023-08-30 10:09:03','2023-08-30 10:09:03',NULL),(4366,7749,40720,1540,3,3977,'App\\Models\\Receipt',3977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-28','2023-08-28',428.78,NULL,NULL,1,'2023-08-30 10:09:03','2023-08-30 10:09:03',NULL),(4367,7749,40720,1540,3,3978,'App\\Models\\Receipt',3978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',4.17,NULL,NULL,1,'2023-08-30 10:09:03','2023-08-30 10:09:03',NULL),(4368,7749,40720,1540,3,3979,'App\\Models\\Receipt',3979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',543436.05,NULL,NULL,1,'2023-08-30 10:09:03','2023-08-30 10:09:03',NULL),(4369,7749,40720,1540,3,3980,'App\\Models\\Receipt',3980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',66800.35,NULL,NULL,1,'2023-08-30 10:09:03','2023-08-30 10:09:03',NULL),(4370,7749,40720,1540,3,3981,'App\\Models\\Receipt',3981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',18412.49,NULL,NULL,1,'2023-08-30 10:09:04','2023-08-30 10:09:04',NULL),(4371,7749,40720,1540,3,3982,'App\\Models\\Receipt',3982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',15676.66,NULL,NULL,1,'2023-08-30 10:09:04','2023-08-30 10:09:04',NULL),(4372,7749,40720,1540,3,3983,'App\\Models\\Receipt',3983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',79773.51,NULL,NULL,1,'2023-08-30 10:09:04','2023-08-30 10:09:04',NULL);
INSERT INTO `balance_libro` VALUES (4373,7749,40720,1540,3,3984,'App\\Models\\Receipt',3984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',7796.43,NULL,NULL,1,'2023-08-30 10:09:04','2023-08-30 10:09:04',NULL),(4374,7749,40720,1540,3,3985,'App\\Models\\Receipt',3985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',14587.90,NULL,NULL,1,'2023-08-30 10:09:04','2023-08-30 10:09:04',NULL),(4375,7749,40720,1540,3,3986,'App\\Models\\Receipt',3986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',15950.46,NULL,NULL,1,'2023-08-30 10:09:04','2023-08-30 10:09:04',NULL),(4376,7749,40720,1540,3,3987,'App\\Models\\Receipt',3987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',27813.94,NULL,NULL,1,'2023-08-30 10:09:04','2023-08-30 10:09:04',NULL),(4377,7749,40720,1540,3,3988,'App\\Models\\Receipt',3988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',13387.29,NULL,NULL,1,'2023-08-30 10:09:04','2023-08-30 10:09:04',NULL),(4378,7749,40720,1540,3,3989,'App\\Models\\Receipt',3989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',21296.49,NULL,NULL,1,'2023-08-30 10:09:04','2023-08-30 10:09:04',NULL),(4379,7749,40720,1540,3,3990,'App\\Models\\Receipt',3990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',7209.93,NULL,NULL,1,'2023-08-30 10:09:04','2023-08-30 10:09:04',NULL),(4380,7749,40720,1540,3,3991,'App\\Models\\Receipt',3991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',288339.15,NULL,NULL,1,'2023-08-30 10:09:04','2023-08-30 10:09:04',NULL),(4381,7749,40720,1540,3,3992,'App\\Models\\Receipt',3992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',163376.44,NULL,NULL,1,'2023-08-30 10:09:04','2023-08-30 10:09:04',NULL),(4382,7749,40720,1540,3,3993,'App\\Models\\Receipt',3993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',16103.45,NULL,NULL,1,'2023-08-30 10:09:05','2023-08-30 10:09:05',NULL),(4383,7749,40720,1540,3,3994,'App\\Models\\Receipt',3994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',261465.27,NULL,NULL,1,'2023-08-30 10:09:05','2023-08-30 10:09:05',NULL),(4384,7749,40720,1540,3,3995,'App\\Models\\Receipt',3995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',214471.50,NULL,NULL,1,'2023-08-30 10:09:05','2023-08-30 10:09:05',NULL),(4385,7749,40720,1540,3,3996,'App\\Models\\Receipt',3996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',71312.45,NULL,NULL,1,'2023-08-30 10:09:05','2023-08-30 10:09:05',NULL),(4386,7749,40720,1540,2,3997,'App\\Models\\Receipt',3997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',172800.00,NULL,NULL,1,'2023-08-30 10:09:37','2023-08-30 10:09:37',NULL),(4387,7749,40720,1540,2,3998,'App\\Models\\Receipt',3998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',32100.00,NULL,NULL,1,'2023-08-30 10:09:38','2023-08-30 10:09:38',NULL),(4388,7749,40720,1540,2,3999,'App\\Models\\Receipt',3999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',77200.00,NULL,NULL,1,'2023-08-30 10:09:38','2023-08-30 10:09:38',NULL),(4389,7749,40720,1540,2,4000,'App\\Models\\Receipt',4000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',300000.01,NULL,NULL,1,'2023-08-30 11:48:59','2023-08-30 11:48:59',NULL),(4390,7749,40720,1540,2,4001,'App\\Models\\Receipt',4001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',702100.03,NULL,NULL,1,'2023-08-31 10:01:16','2023-08-31 10:01:16',NULL),(4391,7749,40720,1540,3,4002,'App\\Models\\Receipt',4002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',50088.27,NULL,NULL,1,'2023-08-31 10:01:28','2023-08-31 10:01:28',NULL),(4392,7749,40720,1540,3,4003,'App\\Models\\Receipt',4003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',1671.93,NULL,NULL,1,'2023-08-31 10:01:28','2023-08-31 10:01:28',NULL),(4393,7749,40720,1540,3,4004,'App\\Models\\Receipt',4004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',354.92,NULL,NULL,1,'2023-08-31 10:01:28','2023-08-31 10:01:28',NULL);
INSERT INTO `balance_libro` VALUES (4394,7749,40720,1540,3,4005,'App\\Models\\Receipt',4005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',20955.69,NULL,NULL,1,'2023-08-31 10:01:28','2023-08-31 10:01:28',NULL),(4395,7749,40720,1540,3,4006,'App\\Models\\Receipt',4006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-30','2023-08-30',17299.80,NULL,NULL,1,'2023-08-31 10:01:28','2023-08-31 10:01:28',NULL),(4396,7749,40720,1540,3,4007,'App\\Models\\Receipt',4007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',755494.14,NULL,NULL,1,'2023-08-31 10:01:28','2023-08-31 10:01:28',NULL),(4397,7749,40720,1540,3,4008,'App\\Models\\Receipt',4008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',0.00,NULL,NULL,1,'2023-08-31 10:01:28','2023-08-31 10:01:28',NULL),(4398,7749,40720,1540,3,4009,'App\\Models\\Receipt',4009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',150906.12,NULL,NULL,1,'2023-08-31 10:01:28','2023-08-31 10:01:28',NULL),(4399,7749,40720,1540,2,4010,'App\\Models\\Receipt',4010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',682720.02,NULL,NULL,1,'2023-08-31 10:40:30','2023-08-31 10:40:30',NULL),(4400,7749,40720,1540,2,4011,'App\\Models\\Receipt',4011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',682720.00,NULL,NULL,1,'2023-08-31 11:53:45','2023-08-31 11:53:45',NULL),(4401,7749,40720,1540,2,4012,'App\\Models\\Receipt',4012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',682720.02,NULL,NULL,1,'2023-08-31 11:53:45','2023-08-31 11:53:45',NULL),(4402,7749,40720,1541,2,4013,'App\\Models\\Receipt',4013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',81649.99,NULL,NULL,1,'2023-09-04 09:54:05','2023-09-04 09:54:05',NULL),(4403,7749,40720,1541,2,4014,'App\\Models\\Receipt',4014,NULL,NULL,NULL,NULL,NULL,NU